/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints.definitions;

import com.jme3.math.Transform;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.constraints.definitions.ConstraintDefinition;
import com.jme3.scene.plugins.blender.file.Structure;

class ConstraintDefinitionRotLimit
extends ConstraintDefinition {
    private static final int LIMIT_XROT = 1;
    private static final int LIMIT_YROT = 2;
    private static final int LIMIT_ZROT = 4;
    private transient float[][] limits = new float[3][2];
    private transient float[] angles = new float[3];

    public ConstraintDefinitionRotLimit(Structure constraintData, Long ownerOMA, BlenderContext blenderContext) {
        super(constraintData, ownerOMA, blenderContext);
        if (blenderContext.getBlenderKey().isFixUpAxis()) {
            this.limits[0][0] = ((Number)constraintData.getFieldValue("xmin")).floatValue();
            this.limits[0][1] = ((Number)constraintData.getFieldValue("xmax")).floatValue();
            this.limits[2][0] = ((Number)constraintData.getFieldValue("ymin")).floatValue();
            this.limits[2][1] = ((Number)constraintData.getFieldValue("ymax")).floatValue();
            this.limits[1][0] = ((Number)constraintData.getFieldValue("zmin")).floatValue();
            this.limits[1][1] = ((Number)constraintData.getFieldValue("zmax")).floatValue();
            int limitY = this.flag & 2;
            int limitZ = this.flag & 4;
            this.flag &= 1;
            this.flag |= limitY << 1;
            this.flag |= limitZ >> 1;
        } else {
            this.limits[0][0] = ((Number)constraintData.getFieldValue("xmin")).floatValue();
            this.limits[0][1] = ((Number)constraintData.getFieldValue("xmax")).floatValue();
            this.limits[1][0] = ((Number)constraintData.getFieldValue("ymin")).floatValue();
            this.limits[1][1] = ((Number)constraintData.getFieldValue("ymax")).floatValue();
            this.limits[2][0] = ((Number)constraintData.getFieldValue("zmin")).floatValue();
            this.limits[2][1] = ((Number)constraintData.getFieldValue("zmax")).floatValue();
        }
        if (blenderContext.getBlenderVersion() <= 249) {
            for (int i = 0; i < 3; ++i) {
                float[] fArray = this.limits[i];
                fArray[0] = fArray[0] * ((float)Math.PI / 180);
                float[] fArray2 = this.limits[i];
                fArray2[1] = fArray2[1] * ((float)Math.PI / 180);
            }
        }
    }

    public void bake(Transform ownerTransform, Transform targetTransform, float influence) {
        float difference;
        ownerTransform.getRotation().toAngles(this.angles);
        if ((this.flag & 1) != 0) {
            difference = 0.0f;
            if (this.angles[0] < this.limits[0][0]) {
                difference = (this.angles[0] - this.limits[0][0]) * influence;
            } else if (this.angles[0] > this.limits[0][1]) {
                difference = (this.angles[0] - this.limits[0][1]) * influence;
            }
            this.angles[0] = this.angles[0] - difference;
        }
        if ((this.flag & 2) != 0) {
            difference = 0.0f;
            if (this.angles[1] < this.limits[1][0]) {
                difference = (this.angles[1] - this.limits[1][0]) * influence;
            } else if (this.angles[1] > this.limits[1][1]) {
                difference = (this.angles[1] - this.limits[1][1]) * influence;
            }
            this.angles[1] = this.angles[1] - difference;
        }
        if ((this.flag & 4) != 0) {
            difference = 0.0f;
            if (this.angles[2] < this.limits[2][0]) {
                difference = (this.angles[2] - this.limits[2][0]) * influence;
            } else if (this.angles[2] > this.limits[2][1]) {
                difference = (this.angles[2] - this.limits[2][1]) * influence;
            }
            this.angles[2] = this.angles[2] - difference;
        }
        ownerTransform.getRotation().fromAngles(this.angles);
    }

    public String getConstraintTypeName() {
        return "Limit rotation";
    }
}

