/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.math.Transform;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.BoneContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import java.util.logging.Level;
import java.util.logging.Logger;

class BoneConstraint
extends Constraint {
    private static final Logger LOGGER = Logger.getLogger(BoneConstraint.class.getName());
    protected boolean isNodeTarget;

    public BoneConstraint(Structure constraintStructure, Long ownerOMA, Ipo influenceIpo, BlenderContext blenderContext) throws BlenderFileException {
        super(constraintStructure, ownerOMA, influenceIpo, blenderContext);
    }

    public boolean validate() {
        if (this.targetOMA != null) {
            Spatial nodeTarget = (Spatial)this.blenderContext.getLoadedFeature(this.targetOMA, BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
            if (nodeTarget == null) {
                LOGGER.log(Level.WARNING, "Cannot find target for constraint: {0}.", this.name);
                return false;
            }
            if (this.blenderContext.getMarkerValue("armature-node", nodeTarget) != null) {
                if (this.subtargetName.trim().isEmpty()) {
                    LOGGER.log(Level.WARNING, "No bone target specified for constraint: {0}.", this.name);
                    return false;
                }
                BoneContext boneContext = this.blenderContext.getBoneContext(this.ownerOMA);
                if (this.targetOMA.longValue() != boneContext.getArmatureObjectOMA().longValue()) {
                    LOGGER.log(Level.WARNING, "Bone constraint {0} must target bone in the its own skeleton! Targeting bone in another skeleton is not supported!", this.name);
                    return false;
                }
            } else {
                this.isNodeTarget = true;
            }
        }
        return true;
    }

    public void apply(int frame) {
        BoneContext boneContext = this.blenderContext.getBoneContext(this.ownerOMA);
        Transform ownerTransform = this.constraintHelper.getTransform(boneContext.getArmatureObjectOMA(), boneContext.getBone().getName(), this.ownerSpace);
        if (this.targetOMA != null) {
            if (this.isNodeTarget) {
                Transform targetTransform = this.targetOMA != null ? this.constraintHelper.getTransform(this.targetOMA, this.subtargetName, this.targetSpace) : null;
                this.constraintDefinition.bake(ownerTransform, targetTransform, this.ipo.calculateValue(frame));
            } else {
                Transform targetTransform = this.constraintHelper.getTransform(this.targetOMA, this.subtargetName, this.targetSpace);
                this.constraintDefinition.bake(ownerTransform, targetTransform, this.ipo.calculateValue(frame));
            }
        } else {
            this.constraintDefinition.bake(ownerTransform, null, this.ipo.calculateValue(frame));
        }
        this.constraintHelper.applyTransform(boneContext.getArmatureObjectOMA(), boneContext.getBone().getName(), this.ownerSpace, ownerTransform);
    }
}

