/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.cameras;

import com.jme3.math.FastMath;
import com.jme3.renderer.Camera;
import com.jme3.scene.CameraNode;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CameraHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(CameraHelper.class.getName());
    protected static final int DEFAULT_CAM_WIDTH = 640;
    protected static final int DEFAULT_CAM_HEIGHT = 480;

    public CameraHelper(String blenderVersion, BlenderContext blenderContext) {
        super(blenderVersion, blenderContext);
    }

    public CameraNode toCamera(Structure structure, BlenderContext blenderContext) throws BlenderFileException {
        if (this.blenderVersion >= 250) {
            return this.toCamera250(structure, blenderContext.getSceneStructure());
        }
        return this.toCamera249(structure);
    }

    private CameraNode toCamera250(Structure structure, Structure sceneStructure) throws BlenderFileException {
        float fovY;
        int width = 640;
        int height = 480;
        if (sceneStructure != null) {
            Structure renderData = (Structure)sceneStructure.getFieldValue("r");
            width = ((Number)renderData.getFieldValue("xsch")).shortValue();
            height = ((Number)renderData.getFieldValue("ysch")).shortValue();
        }
        Camera camera = new Camera(width, height);
        int type = ((Number)structure.getFieldValue("type")).intValue();
        if (type != 0 && type != 1) {
            LOGGER.log(Level.WARNING, "Unknown camera type: {0}. Perspective camera is being used!", type);
            type = 0;
        }
        camera.setParallelProjection(type == 1);
        float aspect = (float)width / (float)height;
        float clipsta = ((Number)structure.getFieldValue("clipsta")).floatValue();
        float clipend = ((Number)structure.getFieldValue("clipend")).floatValue();
        if (type == 0) {
            float sensor = 32.0f;
            boolean sensorVertical = false;
            Number sensorFit = (Number)structure.getFieldValue("sensor_fit");
            if (sensorFit != null) {
                sensorVertical = sensorFit.byteValue() == 2;
                String sensorName = "sensor_x";
                if (sensorVertical) {
                    sensorName = "sensor_y";
                }
                sensor = ((Number)structure.getFieldValue(sensorName)).floatValue();
            }
            float focalLength = ((Number)structure.getFieldValue("lens")).floatValue();
            float fov = 2.0f * FastMath.atan(sensor / 2.0f / focalLength);
            fovY = sensorVertical ? fov * 57.295776f : 2.0f * FastMath.atan(FastMath.tan(fov / 2.0f) / aspect) * 57.295776f;
        } else {
            fovY = ((Number)structure.getFieldValue("ortho_scale")).floatValue();
        }
        camera.setFrustumPerspective(fovY, aspect, clipsta, clipend);
        return new CameraNode(null, camera);
    }

    private CameraNode toCamera249(Structure structure) throws BlenderFileException {
        Camera camera = new Camera(640, 480);
        int type = ((Number)structure.getFieldValue("type")).intValue();
        if (type != 0 && type != 1) {
            LOGGER.log(Level.WARNING, "Unknown camera type: {0}. Perspective camera is being used!", type);
            type = 0;
        }
        camera.setParallelProjection(type == 1);
        float aspect = 0.0f;
        float clipsta = ((Number)structure.getFieldValue("clipsta")).floatValue();
        float clipend = ((Number)structure.getFieldValue("clipend")).floatValue();
        aspect = type == 0 ? ((Number)structure.getFieldValue("lens")).floatValue() : ((Number)structure.getFieldValue("ortho_scale")).floatValue();
        camera.setFrustumPerspective(aspect, camera.getWidth() / camera.getHeight(), clipsta, clipend);
        return new CameraNode(null, camera);
    }

    public boolean shouldBeLoaded(Structure structure, BlenderContext blenderContext) {
        return (blenderContext.getBlenderKey().getFeaturesToLoad() & 0x20) != 0;
    }
}

