/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.asset.AssetManager;
import com.jme3.asset.BlenderKey;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Node;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.animations.AnimationData;
import com.jme3.scene.plugins.blender.animations.BoneContext;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.file.BlenderInputStream;
import com.jme3.scene.plugins.blender.file.DnaBlockData;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.meshes.MeshContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlenderContext {
    private static final Logger LOGGER = Logger.getLogger(BlenderContext.class.getName());
    private int blenderVersion;
    private BlenderKey blenderKey;
    private DnaBlockData dnaBlockData;
    private Structure sceneStructure;
    private BlenderInputStream inputStream;
    private AssetManager assetManager;
    private Map<Long, FileBlockHeader> fileBlockHeadersByOma = new HashMap<Long, FileBlockHeader>();
    private Map<Integer, List<FileBlockHeader>> fileBlockHeadersByCode = new HashMap<Integer, List<FileBlockHeader>>();
    private Map<Long, Object[]> loadedFeatures = new HashMap<Long, Object[]>();
    private Map<String, Object[]> loadedFeaturesByName = new HashMap<String, Object[]>();
    private Stack<Structure> parentStack = new Stack();
    protected Map<Long, List<Constraint>> constraints = new HashMap<Long, List<Constraint>>();
    private Map<Long, AnimationData> animData = new HashMap<Long, AnimationData>();
    private Map<Long, Skeleton> skeletons = new HashMap<Long, Skeleton>();
    private Map<Skeleton, Node> nodesWithSkeletons = new HashMap<Skeleton, Node>();
    protected Map<Long, MeshContext> meshContexts = new HashMap<Long, MeshContext>();
    protected Map<Long, BoneContext> boneContexts = new HashMap<Long, BoneContext>();
    private Map<String, AbstractBlenderHelper> helpers = new HashMap<String, AbstractBlenderHelper>();
    private Map<String, Map<Object, Object>> markers = new HashMap<String, Map<Object, Object>>();

    public void setBlenderVersion(String blenderVersion) {
        this.blenderVersion = Integer.parseInt(blenderVersion);
    }

    public int getBlenderVersion() {
        return this.blenderVersion;
    }

    public void setBlenderKey(BlenderKey blenderKey) {
        this.blenderKey = blenderKey;
    }

    public BlenderKey getBlenderKey() {
        return this.blenderKey;
    }

    public void setBlockData(DnaBlockData dnaBlockData) {
        this.dnaBlockData = dnaBlockData;
    }

    public DnaBlockData getDnaBlockData() {
        return this.dnaBlockData;
    }

    public void setSceneStructure(Structure sceneStructure) {
        this.sceneStructure = sceneStructure;
    }

    public Structure getSceneStructure() {
        return this.sceneStructure;
    }

    public AssetManager getAssetManager() {
        return this.assetManager;
    }

    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    public BlenderInputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(BlenderInputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void addFileBlockHeader(Long oldMemoryAddress, FileBlockHeader fileBlockHeader) {
        this.fileBlockHeadersByOma.put(oldMemoryAddress, fileBlockHeader);
        List<FileBlockHeader> headers = this.fileBlockHeadersByCode.get(fileBlockHeader.getCode());
        if (headers == null) {
            headers = new ArrayList<FileBlockHeader>();
            this.fileBlockHeadersByCode.put(fileBlockHeader.getCode(), headers);
        }
        headers.add(fileBlockHeader);
    }

    public FileBlockHeader getFileBlock(Long oldMemoryAddress) {
        return this.fileBlockHeadersByOma.get(oldMemoryAddress);
    }

    public List<FileBlockHeader> getFileBlocks(Integer code) {
        return this.fileBlockHeadersByCode.get(code);
    }

    public <T> void putHelper(Class<T> clazz, AbstractBlenderHelper helper) {
        this.helpers.put(clazz.getSimpleName(), helper);
    }

    public <T> T getHelper(Class<?> clazz) {
        return (T)this.helpers.get(clazz.getSimpleName());
    }

    public void addLoadedFeatures(Long oldMemoryAddress, String featureName, Structure structure, Object feature) {
        if (oldMemoryAddress == null || structure == null || feature == null) {
            throw new IllegalArgumentException("One of the given arguments is null!");
        }
        Object[] storedData = new Object[]{structure, feature};
        this.loadedFeatures.put(oldMemoryAddress, storedData);
        if (featureName != null) {
            this.loadedFeaturesByName.put(featureName, storedData);
        }
    }

    public Object getLoadedFeature(Long oldMemoryAddress, LoadedFeatureDataType loadedFeatureDataType) {
        Object[] result = this.loadedFeatures.get(oldMemoryAddress);
        if (result != null) {
            return result[loadedFeatureDataType.getIndex()];
        }
        return null;
    }

    public void pushParent(Structure parent) {
        this.parentStack.push(parent);
    }

    public Structure popParent() {
        try {
            return this.parentStack.pop();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public Structure peekParent() {
        try {
            return this.parentStack.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public void addConstraints(Long ownerOMA, List<Constraint> constraints) {
        List<Constraint> objectConstraints = this.constraints.get(ownerOMA);
        if (objectConstraints == null) {
            objectConstraints = new ArrayList<Constraint>();
            this.constraints.put(ownerOMA, objectConstraints);
        }
        objectConstraints.addAll(constraints);
    }

    public List<Constraint> getAllConstraints() {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        for (Map.Entry<Long, List<Constraint>> entry : this.constraints.entrySet()) {
            result.addAll((Collection<Constraint>)entry.getValue());
        }
        return result;
    }

    public void setAnimData(Long ownerOMA, AnimationData animData) {
        this.animData.put(ownerOMA, animData);
    }

    public AnimationData getAnimData(Long ownerOMA) {
        return this.animData.get(ownerOMA);
    }

    public void setSkeleton(Long skeletonOMA, Skeleton skeleton) {
        this.skeletons.put(skeletonOMA, skeleton);
    }

    public void setNodeForSkeleton(Skeleton skeleton, Node node) {
        this.nodesWithSkeletons.put(skeleton, node);
    }

    public Node getControlledNode(Skeleton skeleton) {
        return this.nodesWithSkeletons.get(skeleton);
    }

    public Skeleton getSkeleton(Long skeletonOMA) {
        return this.skeletons.get(skeletonOMA);
    }

    public void setMeshContext(Long meshOMA, MeshContext meshContext) {
        this.meshContexts.put(meshOMA, meshContext);
    }

    public MeshContext getMeshContext(Long meshOMA) {
        return this.meshContexts.get(meshOMA);
    }

    public void setBoneContext(Long boneOMA, BoneContext boneContext) {
        this.boneContexts.put(boneOMA, boneContext);
    }

    public BoneContext getBoneContext(Long boneOMA) {
        return this.boneContexts.get(boneOMA);
    }

    public BoneContext getBoneByName(String name) {
        for (Map.Entry<Long, BoneContext> entry : this.boneContexts.entrySet()) {
            Bone bone = entry.getValue().getBone();
            if (bone == null || !name.equals(bone.getName())) continue;
            return entry.getValue();
        }
        return null;
    }

    public BoneContext getBoneContext(Bone bone) {
        for (Map.Entry<Long, BoneContext> entry : this.boneContexts.entrySet()) {
            if (!entry.getValue().getBone().equals(bone)) continue;
            return entry.getValue();
        }
        throw new IllegalStateException("Cannot find context for bone: " + bone);
    }

    public synchronized Material getDefaultMaterial() {
        if (this.blenderKey.getDefaultMaterial() == null) {
            Material defaultMaterial = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
            defaultMaterial.setColor("Color", ColorRGBA.DarkGray);
            this.blenderKey.setDefaultMaterial(defaultMaterial);
        }
        return this.blenderKey.getDefaultMaterial();
    }

    public void addMarker(String marker, Object feature, Object markerValue) {
        if (markerValue == null) {
            throw new IllegalArgumentException("The marker's value cannot be null.");
        }
        Map<Object, Object> markersMap = this.markers.get(marker);
        if (markersMap == null) {
            markersMap = new HashMap<Object, Object>();
            this.markers.put(marker, markersMap);
        }
        markersMap.put(feature, markerValue);
    }

    public Object getMarkerValue(String marker, Object feature) {
        Map<Object, Object> markersMap = this.markers.get(marker);
        return markersMap == null ? null : markersMap.get(feature);
    }

    public void dispose() {
        LOGGER.fine("Disposing blender context resources.");
        this.inputStream.forceClose();
        this.loadedFeatures.clear();
        this.loadedFeaturesByName.clear();
        this.parentStack.clear();
        this.constraints.clear();
        this.animData.clear();
        this.skeletons.clear();
        this.meshContexts.clear();
        this.boneContexts.clear();
        this.helpers.clear();
        this.fileBlockHeadersByOma.clear();
        this.fileBlockHeadersByCode.clear();
        this.markers.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LoadedFeatureDataType {
        LOADED_STRUCTURE(0),
        LOADED_FEATURE(1);

        private int index;

        private LoadedFeatureDataType(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

