/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer;

import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.Matrix3f;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Camera;
import com.jme3.renderer.Caps;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.GeometryList;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.shader.Uniform;
import com.jme3.shader.VarType;
import com.jme3.system.NullRenderer;
import com.jme3.system.Timer;
import com.jme3.util.BufferUtils;
import com.jme3.util.IntMap;
import com.jme3.util.TempVars;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderManager {
    private static final Logger logger = Logger.getLogger(RenderManager.class.getName());
    private Renderer renderer;
    private Timer timer;
    private ArrayList<ViewPort> preViewPorts = new ArrayList();
    private ArrayList<ViewPort> viewPorts = new ArrayList();
    private ArrayList<ViewPort> postViewPorts = new ArrayList();
    private Camera prevCam = null;
    private Material forcedMaterial = null;
    private String forcedTechnique = null;
    private RenderState forcedRenderState = null;
    private boolean shader;
    private int viewX;
    private int viewY;
    private int viewWidth;
    private int viewHeight;
    private float near;
    private float far;
    private Matrix4f orthoMatrix = new Matrix4f();
    private Matrix4f viewMatrix = new Matrix4f();
    private FloatBuffer viewMatrixBuf = BufferUtils.createFloatBuffer(16);
    private Matrix4f projMatrix = new Matrix4f();
    private FloatBuffer projMatrixBuf = BufferUtils.createFloatBuffer(16);
    private Matrix4f viewProjMatrix = new Matrix4f();
    private FloatBuffer viewProjMatrixBuf = BufferUtils.createFloatBuffer(16);
    private Matrix4f worldMatrix = new Matrix4f();
    private FloatBuffer worldMatrixBuf = BufferUtils.createFloatBuffer(16);
    private FloatBuffer worldViewMatrixBuf = BufferUtils.createFloatBuffer(16);
    private boolean worldViewMatrixBufDirty = true;
    private FloatBuffer worldViewProjectionMatrixBuf = BufferUtils.createFloatBuffer(16);
    private boolean worldViewProjectionMatrixBufDirty = true;
    private FloatBuffer normalMatrixBuf = BufferUtils.createFloatBuffer(9);
    private boolean normalMatrixBufDirty = true;
    private Vector3f camUp = new Vector3f();
    private Vector3f camLeft = new Vector3f();
    private Vector3f camDir = new Vector3f();
    private Vector3f camLoc = new Vector3f();
    private String tmpTech;
    private boolean handleTranlucentBucket = true;

    public RenderManager(Renderer renderer) {
        this.renderer = renderer;
    }

    public ViewPort getPreView(String viewName) {
        for (int i = 0; i < this.preViewPorts.size(); ++i) {
            if (!this.preViewPorts.get(i).getName().equals(viewName)) continue;
            return this.preViewPorts.get(i);
        }
        return null;
    }

    public boolean removePreView(ViewPort view) {
        return this.preViewPorts.remove(view);
    }

    public ViewPort getMainView(String viewName) {
        for (int i = 0; i < this.viewPorts.size(); ++i) {
            if (!this.viewPorts.get(i).getName().equals(viewName)) continue;
            return this.viewPorts.get(i);
        }
        return null;
    }

    public boolean removeMainView(String viewName) {
        for (int i = 0; i < this.viewPorts.size(); ++i) {
            if (!this.viewPorts.get(i).getName().equals(viewName)) continue;
            this.viewPorts.remove(i);
            return true;
        }
        return false;
    }

    public boolean removeMainView(ViewPort view) {
        return this.viewPorts.remove(view);
    }

    public ViewPort getPostView(String viewName) {
        for (int i = 0; i < this.postViewPorts.size(); ++i) {
            if (!this.postViewPorts.get(i).getName().equals(viewName)) continue;
            return this.postViewPorts.get(i);
        }
        return null;
    }

    public boolean removePostView(String viewName) {
        for (int i = 0; i < this.postViewPorts.size(); ++i) {
            if (!this.postViewPorts.get(i).getName().equals(viewName)) continue;
            this.postViewPorts.remove(i);
            return true;
        }
        return false;
    }

    public boolean removePostView(ViewPort view) {
        return this.postViewPorts.remove(view);
    }

    public List<ViewPort> getPreViews() {
        return Collections.unmodifiableList(this.preViewPorts);
    }

    public List<ViewPort> getMainViews() {
        return Collections.unmodifiableList(this.viewPorts);
    }

    public List<ViewPort> getPostViews() {
        return Collections.unmodifiableList(this.postViewPorts);
    }

    public ViewPort createPreView(String viewName, Camera cam) {
        ViewPort vp = new ViewPort(viewName, cam);
        this.preViewPorts.add(vp);
        return vp;
    }

    public ViewPort createMainView(String viewName, Camera cam) {
        ViewPort vp = new ViewPort(viewName, cam);
        this.viewPorts.add(vp);
        return vp;
    }

    public ViewPort createPostView(String viewName, Camera cam) {
        ViewPort vp = new ViewPort(viewName, cam);
        this.postViewPorts.add(vp);
        return vp;
    }

    private void notifyReshape(ViewPort vp, int w, int h) {
        List<SceneProcessor> processors = vp.getProcessors();
        for (SceneProcessor proc : processors) {
            if (!proc.isInitialized()) {
                proc.initialize(this, vp);
                continue;
            }
            proc.reshape(vp, w, h);
        }
    }

    public void notifyReshape(int w, int h) {
        Camera cam;
        for (ViewPort vp : this.preViewPorts) {
            if (vp.getOutputFrameBuffer() == null) {
                cam = vp.getCamera();
                cam.resize(w, h, true);
            }
            this.notifyReshape(vp, w, h);
        }
        for (ViewPort vp : this.viewPorts) {
            if (vp.getOutputFrameBuffer() == null) {
                cam = vp.getCamera();
                cam.resize(w, h, true);
            }
            this.notifyReshape(vp, w, h);
        }
        for (ViewPort vp : this.postViewPorts) {
            if (vp.getOutputFrameBuffer() == null) {
                cam = vp.getCamera();
                cam.resize(w, h, true);
            }
            this.notifyReshape(vp, w, h);
        }
    }

    public void updateUniformBindings(List<Uniform> params) {
        TempVars vars = TempVars.get();
        Matrix4f tempMat4 = vars.tempMat4;
        Matrix3f tempMat3 = vars.tempMat3;
        Vector2f tempVec2 = vars.vect2d;
        Quaternion tempVec4 = vars.quat1;
        block27: for (int i = 0; i < params.size(); ++i) {
            Uniform u = params.get(i);
            switch (u.getBinding()) {
                case WorldMatrix: {
                    u.setValue(VarType.Matrix4, this.worldMatrixBuf);
                    continue block27;
                }
                case ViewMatrix: {
                    u.setValue(VarType.Matrix4, this.viewMatrix);
                    continue block27;
                }
                case ProjectionMatrix: {
                    u.setValue(VarType.Matrix4, this.projMatrixBuf);
                    continue block27;
                }
                case ViewProjectionMatrix: {
                    u.setValue(VarType.Matrix4, this.viewProjMatrixBuf);
                    continue block27;
                }
                case WorldViewMatrix: {
                    u.setValue(VarType.Matrix4, this.getWorldViewMatrixBuf());
                    continue block27;
                }
                case NormalMatrix: {
                    tempMat4.set(this.viewMatrix);
                    tempMat4.multLocal(this.worldMatrix);
                    tempMat4.toRotationMatrix(tempMat3);
                    tempMat3.invertLocal();
                    tempMat3.transposeLocal();
                    u.setValue(VarType.Matrix3, tempMat3);
                    continue block27;
                }
                case WorldViewProjectionMatrix: {
                    u.setValue(VarType.Matrix4, this.getWorldViewProjectionMatrixBuf());
                    continue block27;
                }
                case WorldMatrixInverse: {
                    tempMat4.multLocal(this.worldMatrix);
                    tempMat4.invertLocal();
                    u.setValue(VarType.Matrix4, tempMat4);
                    continue block27;
                }
                case ViewMatrixInverse: {
                    tempMat4.set(this.viewMatrix);
                    tempMat4.invertLocal();
                    u.setValue(VarType.Matrix4, tempMat4);
                    continue block27;
                }
                case ProjectionMatrixInverse: {
                    tempMat4.set(this.projMatrix);
                    tempMat4.invertLocal();
                    u.setValue(VarType.Matrix4, tempMat4);
                    continue block27;
                }
                case ViewProjectionMatrixInverse: {
                    tempMat4.set(this.viewProjMatrix);
                    tempMat4.invertLocal();
                    u.setValue(VarType.Matrix4, tempMat4);
                    continue block27;
                }
                case WorldViewMatrixInverse: {
                    tempMat4.set(this.viewMatrix);
                    tempMat4.multLocal(this.worldMatrix);
                    tempMat4.invertLocal();
                    u.setValue(VarType.Matrix4, tempMat4);
                    continue block27;
                }
                case NormalMatrixInverse: {
                    tempMat4.set(this.viewMatrix);
                    tempMat4.multLocal(this.worldMatrix);
                    tempMat4.toRotationMatrix(tempMat3);
                    tempMat3.invertLocal();
                    tempMat3.transposeLocal();
                    tempMat3.invertLocal();
                    u.setValue(VarType.Matrix3, tempMat3);
                    continue block27;
                }
                case WorldViewProjectionMatrixInverse: {
                    tempMat4.set(this.viewProjMatrix);
                    tempMat4.multLocal(this.worldMatrix);
                    tempMat4.invertLocal();
                    u.setValue(VarType.Matrix4, tempMat4);
                    continue block27;
                }
                case ViewPort: {
                    tempVec4.set(this.viewX, this.viewY, this.viewWidth, this.viewHeight);
                    u.setValue(VarType.Vector4, tempVec4);
                    continue block27;
                }
                case Resolution: {
                    tempVec2.set(this.viewWidth, this.viewHeight);
                    u.setValue(VarType.Vector2, tempVec2);
                    continue block27;
                }
                case Aspect: {
                    float aspect = (float)this.viewWidth / (float)this.viewHeight;
                    u.setValue(VarType.Float, Float.valueOf(aspect));
                    continue block27;
                }
                case FrustumNearFar: {
                    tempVec2.set(this.near, this.far);
                    u.setValue(VarType.Vector2, tempVec2);
                    continue block27;
                }
                case CameraPosition: {
                    u.setValue(VarType.Vector3, this.camLoc);
                    continue block27;
                }
                case CameraDirection: {
                    u.setValue(VarType.Vector3, this.camDir);
                    continue block27;
                }
                case CameraLeft: {
                    u.setValue(VarType.Vector3, this.camLeft);
                    continue block27;
                }
                case CameraUp: {
                    u.setValue(VarType.Vector3, this.camUp);
                    continue block27;
                }
                case Time: {
                    u.setValue(VarType.Float, Float.valueOf(this.timer.getTimeInSeconds()));
                    continue block27;
                }
                case Tpf: {
                    u.setValue(VarType.Float, Float.valueOf(this.timer.getTimePerFrame()));
                    continue block27;
                }
                case FrameRate: {
                    u.setValue(VarType.Float, Float.valueOf(this.timer.getFrameRate()));
                }
            }
        }
        vars.release();
    }

    public void setForcedMaterial(Material mat) {
        this.forcedMaterial = mat;
    }

    public RenderState getForcedRenderState() {
        return this.forcedRenderState;
    }

    public void setForcedRenderState(RenderState forcedRenderState) {
        this.forcedRenderState = forcedRenderState;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public String getForcedTechnique() {
        return this.forcedTechnique;
    }

    public void setForcedTechnique(String forcedTechnique) {
        this.forcedTechnique = forcedTechnique;
    }

    public void setAlphaToCoverage(boolean value) {
        this.renderer.setAlphaToCoverage(value);
    }

    public boolean isHandleTranslucentBucket() {
        return this.handleTranlucentBucket;
    }

    public void setHandleTranslucentBucket(boolean handleTranslucentBucket) {
        this.handleTranlucentBucket = handleTranslucentBucket;
    }

    public void setWorldMatrix(Matrix4f mat) {
        if (this.shader) {
            this.worldMatrix.set(mat);
            this.worldMatrix.fillFloatBuffer(this.worldMatrixBuf, true);
            this.worldMatrixBuf.position(0);
            this.worldViewProjectionMatrixBufDirty = true;
            this.normalMatrixBufDirty = true;
        } else {
            this.renderer.setWorldMatrix(mat);
        }
    }

    public void renderGeometry(Geometry g) {
        if (g.isIgnoreTransform()) {
            this.setWorldMatrix(Matrix4f.IDENTITY);
        } else {
            this.setWorldMatrix(g.getWorldMatrix());
        }
        if (this.forcedTechnique != null) {
            if (g.getMaterial().getMaterialDef().getTechniqueDef(this.forcedTechnique) != null) {
                this.tmpTech = g.getMaterial().getActiveTechnique() != null ? g.getMaterial().getActiveTechnique().getDef().getName() : "Default";
                g.getMaterial().selectTechnique(this.forcedTechnique, this);
                g.getMaterial().render(g, this);
                g.getMaterial().selectTechnique(this.tmpTech, this);
            } else if (this.forcedMaterial != null) {
                this.forcedMaterial.render(g, this);
            }
        } else if (this.forcedMaterial != null) {
            this.forcedMaterial.render(g, this);
        } else {
            g.getMaterial().render(g, this);
        }
    }

    public void renderGeometryList(GeometryList gl) {
        for (int i = 0; i < gl.size(); ++i) {
            this.renderGeometry(gl.get(i));
        }
    }

    private void renderShadow(Spatial s, RenderQueue rq) {
        if (s instanceof Node) {
            Node n = (Node)s;
            List<Spatial> children = n.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                this.renderShadow(children.get(i), rq);
            }
        } else if (s instanceof Geometry) {
            Geometry gm = (Geometry)s;
            RenderQueue.ShadowMode shadowMode = s.getShadowMode();
            if (shadowMode != RenderQueue.ShadowMode.Off && shadowMode != RenderQueue.ShadowMode.Receive) {
                rq.addToShadowQueue(gm, RenderQueue.ShadowMode.Cast);
            }
        }
    }

    public void preloadScene(Spatial scene) {
        block5: {
            block4: {
                if (!(scene instanceof Node)) break block4;
                Node n = (Node)scene;
                List<Spatial> children = n.getChildren();
                for (int i = 0; i < children.size(); ++i) {
                    this.preloadScene(children.get(i));
                }
                break block5;
            }
            if (!(scene instanceof Geometry)) break block5;
            Geometry gm = (Geometry)scene;
            if (gm.getMaterial() == null) {
                throw new IllegalStateException("No material is set for Geometry: " + gm.getName());
            }
            gm.getMaterial().preload(this);
            Mesh mesh = gm.getMesh();
            if (mesh != null) {
                for (IntMap.Entry<VertexBuffer> entry : mesh.getBuffers()) {
                    VertexBuffer buf = entry.getValue();
                    if (buf.getData() == null) continue;
                    this.renderer.updateBufferData(buf);
                }
            }
        }
    }

    public void renderScene(Spatial scene, ViewPort vp) {
        if (scene.getParent() == null) {
            vp.getCamera().setPlaneState(0);
        }
        if (!scene.checkCulling(vp.getCamera())) {
            if ((scene.getShadowMode() != RenderQueue.ShadowMode.Off || scene instanceof Node) && scene.getCullHint() != Spatial.CullHint.Always) {
                this.renderShadow(scene, vp.getQueue());
            }
            return;
        }
        scene.runControlRender(this, vp);
        if (scene instanceof Node) {
            Node n = (Node)scene;
            List<Spatial> children = n.getChildren();
            int camState = vp.getCamera().getPlaneState();
            for (int i = 0; i < children.size(); ++i) {
                vp.getCamera().setPlaneState(camState);
                this.renderScene(children.get(i), vp);
            }
        } else if (scene instanceof Geometry) {
            Geometry gm = (Geometry)scene;
            if (gm.getMaterial() == null) {
                throw new IllegalStateException("No material is set for Geometry: " + gm.getName());
            }
            vp.getQueue().addToQueue(gm, scene.getQueueBucket());
            RenderQueue.ShadowMode shadowMode = scene.getShadowMode();
            if (shadowMode != RenderQueue.ShadowMode.Off) {
                vp.getQueue().addToShadowQueue(gm, shadowMode);
            }
        }
    }

    public Camera getCurrentCamera() {
        return this.prevCam;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public void flushQueue(ViewPort vp) {
        this.renderViewPortQueues(vp, true);
    }

    public void clearQueue(ViewPort vp) {
        vp.getQueue().clear();
    }

    public void renderViewPortQueues(ViewPort vp, boolean flush) {
        RenderQueue rq = vp.getQueue();
        Camera cam = vp.getCamera();
        boolean depthRangeChanged = false;
        rq.renderQueue(RenderQueue.Bucket.Opaque, this, cam, flush);
        if (!rq.isQueueEmpty(RenderQueue.Bucket.Sky)) {
            this.renderer.setDepthRange(1.0f, 1.0f);
            rq.renderQueue(RenderQueue.Bucket.Sky, this, cam, flush);
            depthRangeChanged = true;
        }
        if (!rq.isQueueEmpty(RenderQueue.Bucket.Transparent)) {
            if (depthRangeChanged) {
                this.renderer.setDepthRange(0.0f, 1.0f);
                depthRangeChanged = false;
            }
            rq.renderQueue(RenderQueue.Bucket.Transparent, this, cam, flush);
        }
        if (!rq.isQueueEmpty(RenderQueue.Bucket.Gui)) {
            this.renderer.setDepthRange(0.0f, 0.0f);
            this.setCamera(cam, true);
            rq.renderQueue(RenderQueue.Bucket.Gui, this, cam, flush);
            this.setCamera(cam, false);
            depthRangeChanged = true;
        }
        if (depthRangeChanged) {
            this.renderer.setDepthRange(0.0f, 1.0f);
        }
    }

    public void renderTranslucentQueue(ViewPort vp) {
        RenderQueue rq = vp.getQueue();
        if (!rq.isQueueEmpty(RenderQueue.Bucket.Translucent) && this.handleTranlucentBucket) {
            rq.renderQueue(RenderQueue.Bucket.Translucent, this, vp.getCamera(), true);
        }
    }

    private void setViewPort(Camera cam) {
        if (cam != this.prevCam || cam.isViewportChanged()) {
            this.viewX = (int)(cam.getViewPortLeft() * (float)cam.getWidth());
            this.viewY = (int)(cam.getViewPortBottom() * (float)cam.getHeight());
            this.viewWidth = (int)((cam.getViewPortRight() - cam.getViewPortLeft()) * (float)cam.getWidth());
            this.viewHeight = (int)((cam.getViewPortTop() - cam.getViewPortBottom()) * (float)cam.getHeight());
            this.renderer.setViewPort(this.viewX, this.viewY, this.viewWidth, this.viewHeight);
            this.renderer.setClipRect(this.viewX, this.viewY, this.viewWidth, this.viewHeight);
            cam.clearViewportChanged();
            this.prevCam = cam;
            this.orthoMatrix.loadIdentity();
            this.orthoMatrix.setTranslation(-1.0f, -1.0f, 0.0f);
            this.orthoMatrix.setScale(2.0f / (float)cam.getWidth(), 2.0f / (float)cam.getHeight(), 0.0f);
        }
    }

    private void setViewProjection(Camera cam, boolean ortho) {
        if (this.shader) {
            if (ortho) {
                this.viewMatrix.set(Matrix4f.IDENTITY);
                this.projMatrix.set(this.orthoMatrix);
                this.viewProjMatrix.set(this.orthoMatrix);
            } else {
                this.viewMatrix.set(cam.getViewMatrix());
                this.projMatrix.set(cam.getProjectionMatrix());
                this.viewProjMatrix.set(cam.getViewProjectionMatrix());
            }
            this.projMatrix.fillFloatBuffer(this.projMatrixBuf, true);
            this.projMatrixBuf.position(0);
            this.viewProjMatrix.fillFloatBuffer(this.viewProjMatrixBuf, true);
            this.viewProjMatrixBuf.position(0);
            this.worldViewMatrixBufDirty = true;
            this.worldViewProjectionMatrixBufDirty = true;
            this.normalMatrixBufDirty = true;
            this.camLoc.set(cam.getLocation());
            cam.getLeft(this.camLeft);
            cam.getUp(this.camUp);
            cam.getDirection(this.camDir);
            this.near = cam.getFrustumNear();
            this.far = cam.getFrustumFar();
        } else if (ortho) {
            this.renderer.setViewProjectionMatrices(Matrix4f.IDENTITY, this.orthoMatrix);
        } else {
            this.renderer.setViewProjectionMatrices(cam.getViewMatrix(), cam.getProjectionMatrix());
        }
    }

    private FloatBuffer getWorldViewMatrixBuf() {
        if (this.worldViewMatrixBufDirty) {
            TempVars tmp = TempVars.get();
            tmp.tempMat4.set(this.viewMatrix);
            tmp.tempMat4.multLocal(this.worldMatrix);
            tmp.tempMat4.fillFloatBuffer(this.worldViewMatrixBuf, true);
            this.worldViewMatrixBuf.position(0);
            tmp.release();
            this.worldViewMatrixBufDirty = false;
        }
        return this.worldViewMatrixBuf;
    }

    private FloatBuffer getWorldViewProjectionMatrixBuf() {
        if (this.worldViewProjectionMatrixBufDirty) {
            TempVars tmp = TempVars.get();
            tmp.tempMat4.set(this.viewProjMatrix);
            tmp.tempMat4.multLocal(this.worldMatrix);
            tmp.tempMat4.fillFloatBuffer(this.worldViewProjectionMatrixBuf, true);
            this.worldViewProjectionMatrixBuf.position(0);
            tmp.release();
            this.worldViewProjectionMatrixBufDirty = false;
        }
        return this.worldViewProjectionMatrixBuf;
    }

    private FloatBuffer getNormalMatrixBuf() {
        if (this.normalMatrixBufDirty) {
            TempVars tmp = TempVars.get();
            tmp.tempMat4.set(this.viewMatrix);
            tmp.tempMat4.multLocal(this.worldMatrix);
            tmp.tempMat4.toRotationMatrix(tmp.tempMat3);
            tmp.tempMat3.invertLocal();
            tmp.tempMat3.transposeLocal();
            tmp.tempMat3.fillFloatBuffer(this.normalMatrixBuf, true);
            this.normalMatrixBuf.position(0);
            tmp.release();
            this.normalMatrixBufDirty = false;
        }
        return this.worldViewProjectionMatrixBuf;
    }

    public void setCamera(Camera cam, boolean ortho) {
        this.setViewPort(cam);
        this.setViewProjection(cam, ortho);
    }

    public void renderViewPortRaw(ViewPort vp) {
        this.setCamera(vp.getCamera(), false);
        List<Spatial> scenes = vp.getScenes();
        for (int i = scenes.size() - 1; i >= 0; --i) {
            this.renderScene(scenes.get(i), vp);
        }
        this.flushQueue(vp);
    }

    public void renderViewPort(ViewPort vp, float tpf) {
        SceneProcessor proc;
        int procSize;
        int i;
        if (!vp.isEnabled()) {
            return;
        }
        List<SceneProcessor> processors = vp.getProcessors();
        if (processors.isEmpty()) {
            processors = null;
        }
        if (processors != null) {
            int procSize2 = processors.size();
            for (i = 0; i < procSize2; ++i) {
                SceneProcessor proc2 = processors.get(i);
                if (!proc2.isInitialized()) {
                    proc2.initialize(this, vp);
                }
                proc2.preFrame(tpf);
            }
        }
        this.renderer.setFrameBuffer(vp.getOutputFrameBuffer());
        this.setCamera(vp.getCamera(), false);
        if (vp.isClearDepth() || vp.isClearColor() || vp.isClearStencil()) {
            if (vp.isClearColor()) {
                this.renderer.setBackgroundColor(vp.getBackgroundColor());
            }
            this.renderer.clearBuffers(vp.isClearColor(), vp.isClearDepth(), vp.isClearStencil());
        }
        List<Spatial> scenes = vp.getScenes();
        for (i = scenes.size() - 1; i >= 0; --i) {
            this.renderScene(scenes.get(i), vp);
        }
        if (processors != null) {
            procSize = processors.size();
            for (int i2 = 0; i2 < procSize; ++i2) {
                proc = processors.get(i2);
                proc.postQueue(vp.getQueue());
            }
        }
        this.flushQueue(vp);
        if (processors != null) {
            procSize = processors.size();
            for (int i3 = 0; i3 < procSize; ++i3) {
                proc = processors.get(i3);
                proc.postFrame(vp.getOutputFrameBuffer());
            }
        }
        this.renderTranslucentQueue(vp);
        this.clearQueue(vp);
    }

    public void render(float tpf, boolean mainFrameBufferActive) {
        ViewPort vp;
        int i;
        if (this.renderer instanceof NullRenderer) {
            return;
        }
        this.shader = this.renderer.getCaps().contains((Object)Caps.GLSL100);
        for (i = 0; i < this.preViewPorts.size(); ++i) {
            vp = this.preViewPorts.get(i);
            if (vp.getOutputFrameBuffer() == null && !mainFrameBufferActive) continue;
            this.renderViewPort(vp, tpf);
        }
        for (i = 0; i < this.viewPorts.size(); ++i) {
            vp = this.viewPorts.get(i);
            if (vp.getOutputFrameBuffer() == null && !mainFrameBufferActive) continue;
            this.renderViewPort(vp, tpf);
        }
        for (i = 0; i < this.postViewPorts.size(); ++i) {
            vp = this.postViewPorts.get(i);
            if (vp.getOutputFrameBuffer() == null && !mainFrameBufferActive) continue;
            this.renderViewPort(vp, tpf);
        }
    }
}

