/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.niftygui;

import com.jme3.font.BitmapText;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix4f;
import com.jme3.niftygui.NiftyJmeDisplay;
import com.jme3.niftygui.RenderFontJme;
import com.jme3.niftygui.RenderImageJme;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.scene.Geometry;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture2D;
import com.jme3.util.BufferUtils;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.render.BlendMode;
import de.lessvoid.nifty.spi.render.MouseCursor;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.spi.render.RenderImage;
import de.lessvoid.nifty.tools.Color;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.HashMap;

public class RenderDeviceJme
implements RenderDevice {
    private NiftyJmeDisplay display;
    private RenderManager rm;
    private Renderer r;
    private HashMap<String, BitmapText> textCacheLastFrame = new HashMap();
    private HashMap<String, BitmapText> textCacheCurrentFrame = new HashMap();
    private final Quad quad = new Quad(1.0f, -1.0f, true);
    private final Geometry quadGeom = new Geometry("nifty-quad", this.quad);
    private final Material niftyMat;
    private boolean clipWasSet = false;
    private BlendMode blendMode = null;
    private VertexBuffer quadDefaultTC = this.quad.getBuffer(VertexBuffer.Type.TexCoord);
    private VertexBuffer quadModTC = this.quadDefaultTC.clone();
    private VertexBuffer quadColor;
    private Matrix4f tempMat = new Matrix4f();
    private ColorRGBA tempColor = new ColorRGBA();

    public RenderDeviceJme(NiftyJmeDisplay display) {
        this.display = display;
        this.quadColor = new VertexBuffer(VertexBuffer.Type.Color);
        this.quadColor.setNormalized(true);
        ByteBuffer bb = BufferUtils.createByteBuffer(16);
        this.quadColor.setupData(VertexBuffer.Usage.Stream, 4, VertexBuffer.Format.UnsignedByte, bb);
        this.quad.setBuffer(this.quadColor);
        this.quadModTC.setUsage(VertexBuffer.Usage.Stream);
        this.niftyMat = new Material(display.getAssetManager(), "Common/MatDefs/Nifty/Nifty.j3md");
        this.niftyMat.getAdditionalRenderState().setDepthTest(false);
    }

    public void setRenderManager(RenderManager rm) {
        this.rm = rm;
        this.r = rm.getRenderer();
    }

    public MouseCursor createMouseCursor(String str, int x, int y) {
        return new MouseCursor(){

            public void dispose() {
            }
        };
    }

    public void enableMouseCursor(MouseCursor cursor) {
    }

    public void disableMouseCursor() {
    }

    public RenderImage createImage(String filename, boolean linear) {
        return new RenderImageJme(filename, linear, this.display);
    }

    public RenderFont createFont(String filename) {
        return new RenderFontJme(filename, this.display);
    }

    public void beginFrame() {
    }

    public void endFrame() {
        HashMap<String, BitmapText> temp = this.textCacheLastFrame;
        this.textCacheLastFrame = this.textCacheCurrentFrame;
        this.textCacheCurrentFrame = temp;
        this.textCacheCurrentFrame.clear();
    }

    public int getWidth() {
        return this.display.getWidth();
    }

    public int getHeight() {
        return this.display.getHeight();
    }

    public void clear() {
    }

    public void setBlendMode(BlendMode blendMode) {
        if (this.blendMode != blendMode) {
            this.blendMode = blendMode;
        }
    }

    private RenderState.BlendMode convertBlend() {
        if (this.blendMode == null) {
            return RenderState.BlendMode.Off;
        }
        if (this.blendMode == BlendMode.BLEND) {
            return RenderState.BlendMode.Alpha;
        }
        if (this.blendMode == BlendMode.MULIPLY) {
            return RenderState.BlendMode.Modulate;
        }
        throw new UnsupportedOperationException();
    }

    private int convertColor(Color color) {
        int color2 = 0;
        color2 |= (int)(255.0 * (double)color.getAlpha()) << 24;
        color2 |= (int)(255.0 * (double)color.getBlue()) << 16;
        color2 |= (int)(255.0 * (double)color.getGreen()) << 8;
        return color2 |= (int)(255.0 * (double)color.getRed());
    }

    private ColorRGBA convertColor(Color inColor, ColorRGBA outColor) {
        return outColor.set(inColor.getRed(), inColor.getGreen(), inColor.getBlue(), inColor.getAlpha());
    }

    private void setColor(Color color) {
        ByteBuffer buf = (ByteBuffer)this.quadColor.getData();
        buf.rewind();
        int color2 = this.convertColor(color);
        buf.putInt(color2);
        buf.putInt(color2);
        buf.putInt(color2);
        buf.putInt(color2);
        buf.flip();
        this.quadColor.updateData(buf);
    }

    public void renderFont(RenderFont font, String str, int x, int y, Color color, float size) {
        if (str.length() == 0) {
            return;
        }
        if (font instanceof TextRenderer.RenderFontNull) {
            return;
        }
        RenderFontJme jmeFont = (RenderFontJme)font;
        String key = font + str + color.getColorString();
        BitmapText text = this.textCacheLastFrame.get(key);
        if (text == null) {
            text = jmeFont.createText();
            text.setText(str);
            text.updateLogicalState(0.0f);
        }
        this.textCacheCurrentFrame.put(key, text);
        this.niftyMat.setColor("Color", this.convertColor(color, this.tempColor));
        this.niftyMat.setBoolean("UseTex", true);
        this.niftyMat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        text.setMaterial(this.niftyMat);
        float width = text.getLineWidth();
        float height = text.getLineHeight();
        float x0 = (float)x + 0.5f * width * (1.0f - size);
        float y0 = (float)y + 0.5f * height * (1.0f - size);
        this.tempMat.loadIdentity();
        this.tempMat.setTranslation(x0, (float)this.getHeight() - y0, 0.0f);
        this.tempMat.setScale(size, size, 0.0f);
        this.rm.setWorldMatrix(this.tempMat);
        text.render(this.rm);
    }

    public void renderImage(RenderImage image, int x, int y, int w, int h, int srcX, int srcY, int srcW, int srcH, Color color, float scale, int centerX, int centerY) {
        RenderImageJme jmeImage = (RenderImageJme)image;
        Texture2D texture = jmeImage.getTexture();
        this.niftyMat.getAdditionalRenderState().setBlendMode(this.convertBlend());
        this.niftyMat.setColor("Color", ColorRGBA.White);
        this.niftyMat.setTexture("Texture", texture);
        this.niftyMat.setBoolean("UseTex", true);
        this.setColor(color);
        float imageWidth = jmeImage.getWidth();
        float imageHeight = jmeImage.getHeight();
        FloatBuffer texCoords = (FloatBuffer)this.quadModTC.getData();
        float startX = (float)srcX / imageWidth;
        float startY = (float)srcY / imageHeight;
        float endX = startX + (float)srcW / imageWidth;
        float endY = startY + (float)srcH / imageHeight;
        startY = 1.0f - startY;
        endY = 1.0f - endY;
        texCoords.rewind();
        texCoords.put(startX).put(startY);
        texCoords.put(endX).put(startY);
        texCoords.put(endX).put(endY);
        texCoords.put(startX).put(endY);
        texCoords.flip();
        this.quadModTC.updateData(texCoords);
        this.quad.clearBuffer(VertexBuffer.Type.TexCoord);
        this.quad.setBuffer(this.quadModTC);
        float x0 = (float)centerX + (float)(x - centerX) * scale;
        float y0 = (float)centerY + (float)(y - centerY) * scale;
        this.tempMat.loadIdentity();
        this.tempMat.setTranslation(x0, (float)this.getHeight() - y0, 0.0f);
        this.tempMat.setScale((float)w * scale, (float)h * scale, 0.0f);
        this.rm.setWorldMatrix(this.tempMat);
        this.niftyMat.render(this.quadGeom, this.rm);
    }

    public void renderImage(RenderImage image, int x, int y, int width, int height, Color color, float imageScale) {
        RenderImageJme jmeImage = (RenderImageJme)image;
        this.niftyMat.getAdditionalRenderState().setBlendMode(this.convertBlend());
        this.niftyMat.setColor("Color", ColorRGBA.White);
        this.niftyMat.setTexture("Texture", jmeImage.getTexture());
        this.niftyMat.setBoolean("UseTex", true);
        this.setColor(color);
        this.quad.clearBuffer(VertexBuffer.Type.TexCoord);
        this.quad.setBuffer(this.quadDefaultTC);
        float x0 = (float)x + 0.5f * (float)width * (1.0f - imageScale);
        float y0 = (float)y + 0.5f * (float)height * (1.0f - imageScale);
        this.tempMat.loadIdentity();
        this.tempMat.setTranslation(x0, (float)this.getHeight() - y0, 0.0f);
        this.tempMat.setScale((float)width * imageScale, (float)height * imageScale, 0.0f);
        this.rm.setWorldMatrix(this.tempMat);
        this.niftyMat.render(this.quadGeom, this.rm);
    }

    public void renderQuad(int x, int y, int width, int height, Color color) {
        this.niftyMat.getAdditionalRenderState().setBlendMode(this.convertBlend());
        this.niftyMat.setColor("Color", ColorRGBA.White);
        this.niftyMat.clearParam("Texture");
        this.niftyMat.setBoolean("UseTex", false);
        this.setColor(color);
        this.tempMat.loadIdentity();
        this.tempMat.setTranslation(x, this.getHeight() - y, 0.0f);
        this.tempMat.setScale(width, height, 0.0f);
        this.rm.setWorldMatrix(this.tempMat);
        this.niftyMat.render(this.quadGeom, this.rm);
    }

    public void renderQuad(int x, int y, int width, int height, Color topLeft, Color topRight, Color bottomRight, Color bottomLeft) {
        ByteBuffer buf = (ByteBuffer)this.quadColor.getData();
        buf.rewind();
        buf.putInt(this.convertColor(topRight));
        buf.putInt(this.convertColor(topLeft));
        buf.putInt(this.convertColor(bottomLeft));
        buf.putInt(this.convertColor(bottomRight));
        buf.flip();
        this.quadColor.updateData(buf);
        this.niftyMat.getAdditionalRenderState().setBlendMode(this.convertBlend());
        this.niftyMat.setColor("Color", ColorRGBA.White);
        this.niftyMat.clearParam("Texture");
        this.niftyMat.setBoolean("UseTex", false);
        this.tempMat.loadIdentity();
        this.tempMat.setTranslation(x, this.getHeight() - y, 0.0f);
        this.tempMat.setScale(width, height, 0.0f);
        this.rm.setWorldMatrix(this.tempMat);
        this.niftyMat.render(this.quadGeom, this.rm);
    }

    public void enableClip(int x0, int y0, int x1, int y1) {
        this.clipWasSet = true;
        this.r.setClipRect(x0, this.getHeight() - y1, x1 - x0, y1 - y0);
    }

    public void disableClip() {
        if (this.clipWasSet) {
            this.r.clearClipRect();
            this.clipWasSet = false;
        }
    }
}

