/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.MatParam;
import com.jme3.material.Material;
import com.jme3.material.TechniqueDef;
import com.jme3.shader.DefineList;
import com.jme3.shader.Shader;
import com.jme3.shader.ShaderKey;
import com.jme3.shader.Uniform;
import com.jme3.shader.UniformBinding;
import com.jme3.shader.VarType;
import com.jme3.util.ListMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Technique
implements Savable {
    private static final Logger logger = Logger.getLogger(Technique.class.getName());
    private TechniqueDef def;
    private Material owner;
    private ArrayList<Uniform> worldBindUniforms;
    private DefineList defines;
    private Shader shader;
    private boolean needReload = true;
    ListMap<String, MatParam> paramValues;
    Uniform[] uniformArray;
    String[] defineNameArray;

    public Technique(Material owner, TechniqueDef def) {
        this.owner = owner;
        this.def = def;
        if (def.isUsingShaders()) {
            this.worldBindUniforms = new ArrayList();
            this.defines = new DefineList();
            for (MatParam param : owner.getParams()) {
                String defineName = def.getShaderParamDefine(param.getName());
                if (defineName == null) continue;
                this.defines.set(defineName, param.getVarType(), param.getValue());
            }
        }
    }

    public Technique() {
    }

    public TechniqueDef getDef() {
        return this.def;
    }

    public Shader getShader() {
        return this.shader;
    }

    public List<Uniform> getWorldBindUniforms() {
        return this.worldBindUniforms;
    }

    void notifySetParam(String paramName, VarType type, Object value) {
        String defineName = this.def.getShaderParamDefine(paramName);
        if (defineName != null) {
            this.defines.set(defineName, type, value);
            this.needReload = true;
        }
    }

    void notifySetParam(int paramIndex, VarType type, Object value) {
        if (this.defineNameArray == null) {
            return;
        }
        String defineName = this.defineNameArray[paramIndex];
        if (defineName != null) {
            this.defines.set(defineName, type, value);
            this.needReload = true;
        }
    }

    void notifyClearParam(String paramName) {
        String defineName = this.def.getShaderParamDefine(paramName);
        if (defineName != null) {
            this.defines.remove(defineName);
            this.needReload = true;
        }
        if (this.shader != null) {
            if (!paramName.startsWith("m_")) {
                paramName = "m_" + paramName;
            }
            this.shader.removeUniform(paramName);
            for (int i = this.uniformArray.length - 1; i >= 0; --i) {
                if (!paramName.equals(this.uniformArray[i].getName())) continue;
                this.uniformArray[i] = null;
            }
        }
    }

    void notifyClearParam(int paramIndex) {
        if (this.shader == null) {
            return;
        }
        String defineName = this.defineNameArray[paramIndex];
        if (defineName != null) {
            this.defines.remove(defineName);
            this.needReload = true;
        }
        if (this.shader != null) {
            String paramName = this.uniformArray[paramIndex].getName();
            this.shader.removeUniform(paramName);
            this.uniformArray[paramIndex] = null;
        }
    }

    void updateUniformParam(String paramName, VarType type, Object value, boolean ifNotOwner) {
        Uniform u = this.shader.getUniform(paramName);
        switch (type) {
            case Texture2D: 
            case Texture3D: 
            case TextureArray: 
            case TextureCubeMap: 
            case Int: {
                u.setValue(VarType.Int, value);
                break;
            }
            default: {
                u.setValue(type, value);
            }
        }
    }

    void updateUniformParam(int paramIndex, VarType type, Object value, boolean ifNotOwner) {
        Uniform u = this.uniformArray[paramIndex];
        if (u == null) {
            this.uniformArray[paramIndex] = u = this.shader.getUniform(this.paramValues.getValue(paramIndex).getPrefixedName());
        }
        switch (type) {
            case Texture2D: 
            case Texture3D: 
            case TextureArray: 
            case TextureCubeMap: 
            case Int: {
                u.setValue(VarType.Int, value);
                break;
            }
            default: {
                u.setValue(type, value);
            }
        }
    }

    void updateUniformParam(String paramName, VarType type, Object value) {
        this.updateUniformParam(paramName, type, value, false);
    }

    void updateUniformParam(int paramIndex, VarType type, Object value) {
        this.updateUniformParam(paramIndex, type, value, false);
    }

    public boolean isNeedReload() {
        return this.needReload;
    }

    public void setNeedReload(boolean needReload) {
        this.needReload = needReload;
    }

    public void makeCurrent(AssetManager assetManager, ListMap<String, MatParam> paramValues) {
        int i;
        this.paramValues = paramValues;
        this.defineNameArray = new String[paramValues.size()];
        for (i = paramValues.size() - 1; i >= 0; --i) {
            this.defineNameArray[i] = this.def.getShaderParamDefine(paramValues.getValue(i).getName());
        }
        if (this.def.isUsingShaders() && this.needReload) {
            this.loadShader(assetManager);
            if (this.shader != null) {
                this.uniformArray = new Uniform[paramValues.size()];
                this.defineNameArray = new String[paramValues.size()];
                for (i = paramValues.size() - 1; i >= 0; --i) {
                    this.defineNameArray[i] = this.def.getShaderParamDefine(paramValues.getValue(i).getName());
                }
            }
        }
    }

    private void loadShader(AssetManager manager) {
        DefineList allDefines = new DefineList();
        allDefines.addFrom(this.def.getShaderPresetDefines());
        allDefines.addFrom(this.defines);
        ShaderKey key = new ShaderKey(this.def.getVertexShaderName(), this.def.getFragmentShaderName(), allDefines, this.def.getShaderLanguage());
        this.shader = manager.loadShader(key);
        if (this.shader == null) {
            logger.warning("Failed to reload shader!");
            return;
        }
        this.worldBindUniforms.clear();
        for (UniformBinding binding : this.def.getWorldBindings()) {
            Uniform uniform = this.shader.getUniform("g_" + binding.name());
            uniform.setBinding(binding);
            if (uniform == null) continue;
            this.worldBindUniforms.add(uniform);
        }
        this.needReload = false;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.def, "def", null);
        oc.writeSavableArrayList(this.worldBindUniforms, "worldBindUniforms", null);
        oc.write(this.defines, "defines", null);
        oc.write(this.shader, "shader", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.def = (TechniqueDef)ic.readSavable("def", null);
        this.worldBindUniforms = ic.readSavableArrayList("worldBindUniforms", null);
        this.defines = (DefineList)ic.readSavable("defines", null);
        this.shader = (Shader)ic.readSavable("shader", null);
    }
}

