/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.ogg;

import de.jarnbjo.ogg.EndOfOggStreamException;
import de.jarnbjo.ogg.OggFormatException;
import de.jarnbjo.util.io.ByteArrayBitInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class OggPage {
    private int version;
    private boolean continued;
    private boolean bos;
    private boolean eos;
    private long absoluteGranulePosition;
    private int streamSerialNumber;
    private int pageSequenceNumber;
    private int pageCheckSum;
    private int[] segmentOffsets;
    private int[] segmentLengths;
    private int totalLength;
    private byte[] header;
    private byte[] segmentTable;
    private byte[] data;

    protected OggPage() {
    }

    private OggPage(int version, boolean continued, boolean bos, boolean eos, long absoluteGranulePosition, int streamSerialNumber, int pageSequenceNumber, int pageCheckSum, int[] segmentOffsets, int[] segmentLengths, int totalLength, byte[] header, byte[] segmentTable, byte[] data) {
        this.version = version;
        this.continued = continued;
        this.bos = bos;
        this.eos = eos;
        this.absoluteGranulePosition = absoluteGranulePosition;
        this.streamSerialNumber = streamSerialNumber;
        this.pageSequenceNumber = pageSequenceNumber;
        this.pageCheckSum = pageCheckSum;
        this.segmentOffsets = segmentOffsets;
        this.segmentLengths = segmentLengths;
        this.totalLength = totalLength;
        this.header = header;
        this.segmentTable = segmentTable;
        this.data = data;
    }

    public static OggPage create(RandomAccessFile source) throws IOException, EndOfOggStreamException, OggFormatException {
        return OggPage.create(source, false);
    }

    public static OggPage create(RandomAccessFile source, boolean skipData) throws IOException, EndOfOggStreamException, OggFormatException {
        return OggPage.create((Object)source, skipData);
    }

    public static OggPage create(InputStream source) throws IOException, EndOfOggStreamException, OggFormatException {
        return OggPage.create(source, false);
    }

    public static OggPage create(InputStream source, boolean skipData) throws IOException, EndOfOggStreamException, OggFormatException {
        return OggPage.create((Object)source, skipData);
    }

    public static OggPage create(byte[] source) throws IOException, EndOfOggStreamException, OggFormatException {
        return OggPage.create(source, false);
    }

    public static OggPage create(byte[] source, boolean skipData) throws IOException, EndOfOggStreamException, OggFormatException {
        return OggPage.create((Object)source, skipData);
    }

    private static OggPage create(Object source, boolean skipData) throws IOException, EndOfOggStreamException, OggFormatException {
        try {
            int sourceOffset = 27;
            byte[] header = new byte[27];
            if (source instanceof RandomAccessFile) {
                RandomAccessFile raf = (RandomAccessFile)source;
                if (raf.getFilePointer() == raf.length()) {
                    return null;
                }
                raf.readFully(header);
            } else if (source instanceof InputStream) {
                OggPage.readFully((InputStream)source, header);
            } else if (source instanceof byte[]) {
                System.arraycopy((byte[])source, 0, header, 0, 27);
            }
            ByteArrayBitInputStream bdSource = new ByteArrayBitInputStream(header);
            int capture = bdSource.getInt(32);
            if (capture != 1399285583) {
                String cs = Integer.toHexString(capture);
                while (cs.length() < 8) {
                    cs = "0" + cs;
                }
                cs = cs.substring(6, 8) + cs.substring(4, 6) + cs.substring(2, 4) + cs.substring(0, 2);
                char c1 = (char)Integer.valueOf(cs.substring(0, 2), 16).intValue();
                char c2 = (char)Integer.valueOf(cs.substring(2, 4), 16).intValue();
                char c3 = (char)Integer.valueOf(cs.substring(4, 6), 16).intValue();
                char c4 = (char)Integer.valueOf(cs.substring(6, 8), 16).intValue();
                System.out.println("Ogg packet header is 0x" + cs + " (" + c1 + c2 + c3 + c4 + "), should be 0x4f676753 (OggS)");
            }
            int version = bdSource.getInt(8);
            byte tmp = (byte)bdSource.getInt(8);
            boolean bf1 = (tmp & 1) != 0;
            boolean bos = (tmp & 2) != 0;
            boolean eos = (tmp & 4) != 0;
            long absoluteGranulePosition = bdSource.getLong(64);
            int streamSerialNumber = bdSource.getInt(32);
            int pageSequenceNumber = bdSource.getInt(32);
            int pageCheckSum = bdSource.getInt(32);
            int pageSegments = bdSource.getInt(8);
            int[] segmentOffsets = new int[pageSegments];
            int[] segmentLengths = new int[pageSegments];
            int totalLength = 0;
            byte[] segmentTable = new byte[pageSegments];
            byte[] tmpBuf = new byte[1];
            for (int i = 0; i < pageSegments; ++i) {
                int l = 0;
                if (source instanceof RandomAccessFile) {
                    l = ((RandomAccessFile)source).readByte() & 0xFF;
                } else if (source instanceof InputStream) {
                    l = ((InputStream)source).read();
                } else if (source instanceof byte[]) {
                    l = ((byte[])source)[sourceOffset++];
                    l &= 0xFF;
                }
                segmentTable[i] = (byte)l;
                segmentLengths[i] = l;
                segmentOffsets[i] = totalLength;
                totalLength += l;
            }
            byte[] data = null;
            if (!skipData) {
                data = new byte[totalLength];
                if (source instanceof RandomAccessFile) {
                    ((RandomAccessFile)source).readFully(data);
                } else if (source instanceof InputStream) {
                    OggPage.readFully((InputStream)source, data);
                } else if (source instanceof byte[]) {
                    System.arraycopy(source, sourceOffset, data, 0, totalLength);
                }
            }
            return new OggPage(version, bf1, bos, eos, absoluteGranulePosition, streamSerialNumber, pageSequenceNumber, pageCheckSum, segmentOffsets, segmentLengths, totalLength, header, segmentTable, data);
        }
        catch (EOFException e) {
            throw new EndOfOggStreamException();
        }
    }

    private static void readFully(InputStream source, byte[] buffer) throws IOException {
        int read;
        for (int total = 0; total < buffer.length; total += read) {
            read = source.read(buffer, total, buffer.length - total);
            if (read != -1) continue;
            throw new EndOfOggStreamException();
        }
    }

    public long getAbsoluteGranulePosition() {
        return this.absoluteGranulePosition;
    }

    public int getStreamSerialNumber() {
        return this.streamSerialNumber;
    }

    public int getPageSequenceNumber() {
        return this.pageSequenceNumber;
    }

    public int getPageCheckSum() {
        return this.pageCheckSum;
    }

    public int getTotalLength() {
        if (this.data != null) {
            return 27 + this.segmentTable.length + this.data.length;
        }
        return this.totalLength;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public byte[] getSegmentTable() {
        return this.segmentTable;
    }

    public int[] getSegmentOffsets() {
        return this.segmentOffsets;
    }

    public int[] getSegmentLengths() {
        return this.segmentLengths;
    }

    public boolean isContinued() {
        return this.continued;
    }

    public boolean isFresh() {
        return !this.continued;
    }

    public boolean isBos() {
        return this.bos;
    }

    public boolean isEos() {
        return this.eos;
    }
}

