name 'pleiades-jt'
description 'Pleiades JobTracker node'

run_list(
  'role[grid-realm]',
  'role[ganglia-gmond]',
  'role[pleiades-node]'
)

mcast_addr = '239.2.11.9'
port = '8649'

#env_run_lists "prod" => ["recipe[apache2]"], "staging" => ["recipe[apache2::staging]"], "_default" => []

default_attributes(
)

override_attributes(
  'ganglia' => {
    # gmond
    'cluster' => {
      'name' => 'JobTracker',
      'owner' => 'grid.example.com'
    },
    'static' => {
      ## static multi-cast
      'udp_send_channels' => [
        {
          'mcast_join' => mcast_addr,
          'host' => '',
          'port' => port,
          'ttl' => '1'
        }
      ],
      'udp_recv_channels' => [
        {
          'mcast_join' => mcast_addr,
          'port' => port,
          'bind' => mcast_addr
        }
      ]
=begin
      ## static uni-cast
      'udp_send_channels' => [
        {
          'mcast_join' => '',
          'host' => "jt00.#{this.domain}",
          'port' => port,
          'ttl' => ''
        },
        {
          'mcast_join' => '',
          'host' => "jt01.#{this.domain}",
          'port' => port,
          'ttl' => ''
        }
      ],
      'udp_recv_channels' => [
        {
          'mcast_join' => '',
          'port' => port,
          'bind' => ''
        }
      ]
=end
    }
  }
)
