#
# Cookbook Name:: grid
# Attributes:: default
#
# Copyright 2013-2017, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

default['grid']['etc_root'] = '/grid/etc'
default['grid']['app_root'] = '/grid/usr'
default['grid']['vol_root'] = '/grid/vol'
default['grid']['max_vol_nums'] = '1'

default['grid']['cacert']['path'] = '/etc/ssl/certs/grid_internal_cacert.pem'
default['grid']['cacert']['source'] = 'etc/ssl/certs/grid_internal_cacert.pem'

default['grid']['gridctl']['env'] = {
  'DOMAIN' => '',  # default: '' ( for localhost; pseudo distributed env.)
  #'DOMAIN' => 'grid.example.com',
  'HADOOP_ARTIFACT_TYPE' => '',  # 'package'|'tarball'
  'HADOOP_DISTRIBUTION' => '',  # 'apache'|'cdh(3|4)'|'hdp'

  # Hadoop (HDFS, MapReduce)
  'HADOOP_HOME' => '',
  #'HADOOP_HOME' => '/grid/usr/hadoop',
  'HADOOP_PREFIX' => '',
  #'HADOOP_PREFIX' => '$HADOOP_HOME',
  'HADOOP_CONF_DIR' => '',
  'HDFS_USER' => 'hdfs',
  'MAPRED_USER' => 'mapred',
  'DN_INIT_USER' => 'root',
  'NAMENODE' => 'localhost',
  'SECONDARYNAMENODE' => 'localhost',
  'DATANODES' => 'localhost',
  'BALANCER' => 'localhost',
  'JOBTRACKER' => 'localhost',
  'TASKTRACKERS' => '$DATANODES',
  'HISTORYSERVER' => 'localhost',
  #'NAMENODE => 'nn00',
  #'SECONDARYNAMENODE' => 'nn02',
  #'DATANODES' => 'dn00000 dn00001',
  #'JOBTRACKER' => 'jt00',

  # YARN
  'YARN_USER' => 'yarn',
  'RESOURCEMANAGER' => 'localhost',
  'NODEMANAGERS' => '$DATANODES',
  #'RESOURCEMANAGER' => 'rm00',

  # HBase
  'HBASE_HOME' => '',
  #'HBASE_HOME' => '/grid/usr/hbase',
  'HBASE_USER' => 'hbase',
  'HMASTERS' => 'localhost',
  'HREGIONSERVERS' => 'localhost',
  #'HMASTERS' => 'hm00 hm01',
  #'HREGIONSERVERS' => 'dn00000 dn00001',

  # ZooKeeper
  'ZOOKEEPER_PREFIX' => '',
  #'ZOOKEEPER_PREFIX' => '/grid/usr/zookeeper',
  'ZOOCFGDIR' => '${ZOOKEEPER_PREFIX}/conf',
  'ZOOKEEPER_USER' => 'zookeeper',
  'ZOOKEEPER_PEERS' => 'localhost',
  #'ZOOKEEPER_PEERS' => 'zk00 zk01 zk02',
}
