name 'nameservice-slave'
description 'The NameService (Kerberos and LDAP) slave role'

run_list(
  'recipe[node_commons]',
  'recipe[krb5:client]',
  'recipe[krb5:kdc]'
)

#env_run_lists "prod" => ["recipe[apache2]"], "staging" => ["recipe[apache2::staging]"], "_default" => []

default_attributes(
  'krb5' => {
    'libdefaults' => {
      'default_realm' => 'GRID.EXAMPLE.COM'
    },
    'realms' => {
      'default_realm' => {
        'kdcs' => [
          'ns01.grid.example.com',
          'ns02.grid.example.com'
        ],
        'admin_server' => 'krb-admin.grid.example.com'
      }
    },
    'domain_realms' => [
      '.grid.example.com = GRID.EXAMPLE.COM'
    ]
  }
)

#override_attributes "apache2" => { "max_children" => "50" }
