#
# Copyright 2017, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

name 'gitlab-runner'
description 'GitLab-runner'

ca_name = 'grid_ca'  # Internal CA

run_list(
  #'recipe[ssl_cert::ca_certs]',
  'role[docker]',
  'recipe[gitlab-grid::runner-docker-compose]',
)

#env_run_lists()

#default_attributes()

override_attributes(
  'ssl_cert' => {
    'ca_names' => [
      ca_name,
    ],
  },
  'gitlab-grid' => {
    #'with_ssl_cert_cookbook' => true,
    'ssl_cert' => {
      'ca_name' => ca_name,
    },
    'runner-docker-compose' => {
      #'import_ca' => true,
      'config' => {
        'services' => {
          'runner' => {
            'volumes' => [
              # for Docker executor
              '/var/run/docker.sock:/var/run/docker.sock',
            ],
          },
        },
      },
    },
  },
)
