#
# Cookbook Name:: ups_utils
# Recipe:: nut
#
# Copyright 2018, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

mode = node['ups_utils']['nut']['nut.conf']['MODE']
is_server = (mode == 'standalone' || mode == 'netserver')

package 'nut' do
  action :install
end

service 'nut-server' do
  action [:enable] if is_server
  supports status: true, restart: true, reload: false
end

service 'nut-client' do
  action [:nothing]
  supports status: true, restart: true, reload: false
end

template '/lib/udev/rules.d/53-nut-usbups-local.rules' do
  source 'lib/udev/rules.d/53-nut-usbups-local.rules'
  owner 'root'
  group 'root'
  mode '0644'
  not_if { node['ups_utils']['nut']['udev_usbups_rules'].empty? }
end

secrets = {}
node['ups_utils']['nut']['secrets'].each {|key, vault_item|
  secrets[key] = get_vault_item_value(vault_item)
}

[
  'nut.conf',
  'ups.conf',
  'upsd.conf',
  'upsd.users',
  'upsmon.conf',
].each {|tpl|
  template "/etc/nut/#{tpl}" do
    source  "etc/nut/#{tpl}"
    owner 'root'
    group 'nut'
    mode '0640'
    if tpl == 'upsd.users' || tpl == 'upsmon.conf'
      sensitive true
      variables(
        secrets: secrets
      )
    end
    notifies :restart, 'service[nut-server]' if is_server
    notifies :restart, 'service[nut-client]'
  end
}
