#
# Cookbook Name:: docker-grid
# Library:: Helper
#
# Copyright 2018, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

module DockerGrid
  # Helper methods
  module Helper
    def gem_ver(version)
      # `.gsub(/^\d:/, '')` deletes an epoch prefix (e.g. '5:')
      Gem::Version.create(version.gsub(/^\d:/, '').tr('~', '-'))
    end

    def docker_full_ver(node, version)
      platform = node['platform']

      case platform
      when 'centos', 'redhat'
        suffix = ''
        suffix = ".#{platform}" if gem_ver(version) < gem_ver('18.06.0.ce-3')
        "#{version}.el#{node['platform_version'].to_i}#{suffix}"
      when 'debian', 'ubuntu'
        # e.g.
        #   5:18.09.0~3-0~ubuntu-xenial  # epoch ('5:') and codename suffix added
        #   18.06.1~ce~3-0~ubuntu ...
        #   17.06.0~ce-0~ubuntu          # codename suffix deleted
        #   17.03.2~ce-0~ubuntu-xenial ...
        #   1.12.3-0ubuntu4~16.10.2, 1.12.3-0ubuntu4~16.04.2
        target_ver = gem_ver(version)
        if target_ver < gem_ver('1.12.4-0')
          "#{version}~#{node['lsb']['codename']}"
        elsif target_ver < gem_ver('17.06') || target_ver > gem_ver('18.06.99')
          "#{version}~#{platform}-#{node['lsb']['codename']}"
        else  # 17.06 =< ver =< 18.06
          "#{version}~#{platform}"
        end
      end
    end
  end
end
