#
# Cookbook Name:: apt_utils
# Recipe:: apt-cacher-ng
#
# Copyright 2013-2018, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

::Chef::Recipe.send(:include, PlatformUtils::PackageUtils)

conf = node['apt_utils']['apt-cacher-ng']

if node['platform_family'] == 'debian'
  pkg = 'apt-cacher-ng'
  user_name = pkg
  resources(package: pkg) rescue package pkg do
    action :install
  end

  service_name = pkg
  resources(service: service_name) rescue service service_name do
    action [:enable, :start]
    supports status: true, restart: true, reload: false
  end

  directory conf['CacheDir'] do
    owner user_name
    group user_name
    mode '2755'
    recursive true
  end

  directory conf['LogDir'] do
    owner user_name
    group user_name
    mode '2755'
    recursive true
  end

  template '/etc/apt-cacher-ng/acng.conf' do
    source 'etc/apt-cacher-ng/acng.conf'
    owner 'root'
    group 'root'
    mode '0644'
    notifies :restart, "service[#{service_name}]"
  end
end

# autopilot
srv = 'apt-cacher-ng'
template "/etc/cron.d/#{srv}-local" do
  source  "etc/cron.d/#{srv}-local"
  owner 'root'
  group 'root'
  mode '0644'
  action :delete unless conf['autopilot']['enabled']
end

template '/usr/local/bin/restart_acng-local' do
  source  'usr/local/bin/restart_acng-local'
  owner 'root'
  group 'root'
  mode '0755'
  action :delete unless conf['autopilot']['enabled']
end
