#
# Cookbook Name:: platform_utils
# Recipe:: pip
#
# Copyright 2018, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

case node['platform_family']
when 'debian'
  pkgs = [
    'python-setuptools',
    'python-pip',
  ]
  pkgs.each {|pkg|
    resources(package: pkg) rescue package pkg do
      action :install
    end
  }
when 'rhel'
  pkg = 'python-setuptools'
  resources(package: pkg) rescue package pkg do
    action :install
  end

  execute 'install_pip' do
    user 'root'
    command 'easy_install pip'
    action :run
    not_if 'which pip'
  end
end
