#
# Cookbook Name:: dcos-grid
# Recipe:: node-commons
#
# Copyright 2016, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

genconf_dir = node['dcos-grid']['bootstrap']['genconf_dir']

directory genconf_dir do
  owner 'root'
  group 'root'
  mode '0755'
  recursive true
  action :create
end

template "#{File.dirname(genconf_dir)}/uninstall.sh" do
  source  'opt/dcos-grid/uninstall.sh'
  owner 'root'
  group 'root'
  mode '0755'
end

case node['platform_family']
when 'rhel'
  service 'firewalld' do
    action [:stop, :disable]
  end

  [
    'tar',
    'xz',
    'unzip',
    'curl',
    'ipset',
  ].each {|pkg|
    package pkg do
      action :install
    end
  }

  bash 'disable_selinux' do
    code <<-EOH
      setenforce Permissive
    EOH
    not_if 'getenforce | grep -i \'\(disabled\|permissive\)\''
  end
  template '/etc/selinux/config' do
    source  'etc/selinux/config'
    owner 'root'
    group 'root'
    mode '0644'
  end

  group 'nogroup' do
    action :create
  end

  bash 'load_overlayfs_kernel_module' do
    code <<-EOH
      modprobe overlay
    EOH
    not_if 'lsmod | grep overlay'
  end
  template '/etc/modules-load.d/overlay.conf' do
    source  'etc/modules-load.d/overlay.conf'
    owner 'root'
    group 'root'
    mode '0644'
  end

  template '/etc/yum.repos.d/docker.repo' do
    source  'etc/yum.repos.d/docker.repo'
    owner 'root'
    group 'root'
    mode '0644'
  end

  directory '/etc/systemd/system/docker.service.d' do
    owner 'root'
    group 'root'
    mode '0755'
    action :create
  end

  template '/etc/systemd/system/docker.service.d/override.conf' do
    source  'etc/systemd/system/docker.service.d/override.conf'
    owner 'root'
    group 'root'
    mode '0644'
  end

  [
    'docker-engine-selinux',
    'docker-engine',
  ].each {|pkg|
    package pkg do
      action :install
      version node['dcos-grid']['docker-engine']['version']
      options '--enablerepo=dockerrepo'
    end
  }

  service 'docker' do
    action [:start, :enable]
  end
end
