dcos-grid Cookbook
==================

This cookbook sets up your customized DC/OS cluster on bare metal, virtual machines and every cloud. This install method is based on [_Advanced DC/OS Installation Guide_](https://dcos.io/docs/1.8/administration/installing/custom/advanced/).

Requirements
------------

#### packages
- none.

Attributes
----------

|Key|Type|Description, example|Default|
|:--|:--|:--|:--|
|`['dcos-grid']['dcos_release_url']`|String|DC/OS download URL.|`'https://downloads.dcos.io/dcos/EarlyAccess/dcos_generate_config.sh'`|
|`['dcos-grid']['docker-engine']['version']`|String|Docker 1.9.x - 1.11.x is recommended for stability reasons.|`'1.11.2-1.el7.centos'`|
|`['dcos-grid']['bootstrap']['ip']`|String|Bootstrap node IP address.|`'127.0.0.1'`|
|`['dcos-grid']['bootstrap']['port']`|String|Bootstrap node port number.|`'8080'`|
|`['dcos-grid']['bootstrap']['genconf_dir']`|String|genconf directory path.|`'/opt/dcos-grid/genconf'`|
|`['dcos-grid']['bootstrap']['config']`|Hash|Install configurations.|see [_Install Configuration Parameters_](https://dcos.io/docs/1.8/administration/installing/custom/configuration-parameters/)|
|`['dcos-grid']['bootstrap']['config']['bootstrap_url']`|String||`"http://#{node['dcos-grid']['bootstrap']['ip']}:#{node['dcos-grid']['bootstrap']['port']}"`|
|`['dcos-grid']['bootstrap']['config']['cluster_name']`|String||`'dcos0'`|
|`['dcos-grid']['bootstrap']['config']['exhibitor_storage_backend']`|String||`'static'`|
|`['dcos-grid']['bootstrap']['config']['ip_detect_filename']`|String||`'/genconf/ip-detect'`|
|`['dcos-grid']['bootstrap']['config']['master_list']`|Array|e.g. `['192.168.1.101','192.168.1.102','192.168.1.103']`|`nil`|
|`['dcos-grid']['bootstrap']['config']['resolvers']`|Array|e.g. `['8.8.8.8','8.8.4.4']` (Google DNS)|`nil`|
|`['dcos-grid']['bootstrap']['bootstrap']['ip-detect']['interface']`|String|Network interface on each node for ip-detect.|`'eth0'`|
|`['dcos-grid']['node']['auto_setup']`|Boolean|execute the node setup script automatically or not.|`false`|
|`['dcos-grid']['cloud-config']['target_platform']`|String|CoreOS only now.|`'coreos'`|
|`['dcos-grid']['cloud-config']['target_dir']`|String||`'/home/core'`|
|`['dcos-grid']['cloud-config']['target_owner']`|String||`'core:core'`|
|`['dcos-grid']['cloud-config']['hostname']`|String||`'<fqdn>'`|
|`['dcos-grid']['cloud-config']['ssh_authorized_keys']`|Array||`['<your_ssh_pub_key>',]`|

Usage
-----
### Recipes

#### dcos-grid::default

This recipe does nothing.

#### dcos-grid::agent

This recipe sets up a private agent node. Note: If `node['dcos-grid']['node']['auto_setup']` is `false`, you must execute the following manually.

```
$ cd /opt/dcos-grid
$ ./node_setup.sh slave
```

#### dcos-grid::bootstrap

This recipe sets up a bootstrap node. Note: Please execute the following manually.

```
$ cd /opt/dcos-grid
$ ./bootstrap_setup.sh
```

#### dcos-grid::cloud-config (for CoreOS only)

This recipe generates a `/opt/dcos-grid/cloud-config.yaml` template file on local machine by the following `chef-solo` command.

```
$ sudo chef-solo -c solo.rb -j nodes/local-dcos0-cloud-config.json
```

`nodes/local-dcos0-cloud-config.json`

```json
{
  "run_list": [
    "role[dcos0-cloud-config]"
  ]
}
```

`roles/dcos0-cloud-config.rb`

```ruby
name 'dcos0-cloud-config'
description 'dcos0 cloud-config.yaml file.'

run_list(
  'role[dcos0]',  # includes common attributes.
  'recipe[dcos-grid::cloud-config]',
)
```

Then edit this yaml template (hostname, ssh_authorized_keys, IP address and so on) and install CoreOS by the `cloud-config.yaml`.

```
$ coreos-cloudinit -from-file ~/cloud-config.yaml -validate
...
$ sudo coreos-install -d /dev/sda -C stable -c ~/cloud-config.yaml
```

#### dcos-grid::master

This recipe sets up a master node. Note: If `node['dcos-grid']['node']['auto_setup']` is `false`, you must execute the following manually.

```
$ cd /opt/dcos-grid
$ ./node_setup.sh master
```

#### dcos-grid::node

This recipe sets up a base node (particular role is not assigned yet). Note: Please execute the following manually.

```
$ cd /opt/dcos-grid
$ ./node_setup.sh {master|slave|slave_public}
```

#### dcos-grid::node-commons

This recipe sets up common environment for DC/OS node.

#### dcos-grid::public-agent

This recipe sets up a public node. Note: If `node['dcos-grid']['node']['auto_setup']` is `false`, you must execute the following manually.

```
$ cd /opt/dcos-grid
$ ./node_setup.sh slave_public
```

### Role Examples

- `roles/dcos0.rb`: Common attributes.

```ruby
name 'dcos0'
description 'dcos0 cluster'

run_list(
)

override_attributes(
  'dcos-grid' => {
    'dcos_release_url' => 'https://downloads.dcos.io/dcos/EarlyAccess/dcos_generate_config.sh',
    'docker-engine' => {
      'version' => '1.11.2-1.el7.centos',
    },
    'bootstrap' => {
      'ip' => '192.168.56.100',
      'port' => '8080',
      'config' => {
        'cluster_name' => 'dcos0',
        'master_list' => [
          '192.168.56.101',
          '192.168.56.102',
          '192.168.56.103',
        ],
        'resolvers' => [
          '8.8.8.8',
          '8.8.4.4',
        ],
      },
      'ip-detect' => {
        'interface' => 'enp0s8',
      },
    },
    'node' => {
      'auto_setup' => false,
    },
  },
)
```

- `roles/dcos0-boot.rb`

```ruby
name 'dcos0-boot'
description 'dcos0 cluster bootstrap node'

run_list(
  'role[dcos0]',
  'recipe[dcos-grid::bootstrap]',
)
```

- `roles/dcos-master.rb`

```ruby
name 'dcos0-master'
description 'dcos0 cluster master node'

run_list(
  'role[dcos0]',
  'recipe[dcos-grid::master]',
)

override_attributes(
  'dcos-grid' => {
    'node' => {
      'auto_setup' => false,
    },
  },
)
```

- `roles/dcos0-agent.rb`

```ruby
name 'dcos0-agent'
description 'dcos0 cluster private agent node'

run_list(
  'role[dcos0]',
  'recipe[dcos-grid::agent]',
)

override_attributes(
  'dcos-grid' => {
    'node' => {
      'auto_setup' => true,
    },
  },
)
```

### Uninstall DC/OS

Please log in each node and execute the following.

```
$ cd /opt/dcos-grid
$ ./uninstall.sh
```

License and Authors
-------------------
- Author:: whitestar at osdn.jp

```text
Copyright 2016, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
