#
# Cookbook Name:: bind-grid
# Recipe:: bind
#
# Copyright 2017, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

package 'bind9' do
  action :install
end

service 'bind9' do
  action [:enable, :start]
  supports status: true, restart: true, reload: true
end

conf_files = [
  'named.conf.local',
  'named.conf.options',
]

conf_files.each {|conf_file|
  template "/etc/bind/#{conf_file}" do
    source  "etc/bind/#{conf_file}"
    owner 'root'
    group 'bind'
    mode '0644'
    notifies :reload, 'service[bind9]'
  end
}

zone_dir = node['bind-grid']['options']['directory']
directory zone_dir do
  owner 'root'
  group 'bind'
  mode '0775'
  recursive true
end

if node['bind-grid']['role'] == 'master'
  node['bind-grid']['zone']['files'].each {|db_file|
    template "#{zone_dir}/#{db_file}" do
      source "var/cache/bind/#{db_file}"
      owner 'root'
      group 'root'
      mode '0644'
      notifies :reload, 'service[bind9]'
    end
  }
end
