#
# Cookbook Name:: hadoop
# Attributes:: default
#
# Copyright 2013, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# default: for pseudo-distributed
default['hadoop']['install_flavor'] = 'apache'  # 'apache'|'cdh'|'hdp'
case node['hadoop']['install_flavor']
when 'cdh'
  default['hadoop']['cdh']['alternatives']['hadoop-conf'] = {
    'path' => (node['cdh']['version'] >= '4.0.0') \
      ? '/etc/hadoop/conf.localhost' \
      : '/etc/hadoop-0.20/conf.localhost',
    'priority' => '50'
  }
  default['hadoop']['cdh']['resource_negotiator_framework'] = 'YARN'  # 'MRv1'|'YARN'
when 'hdp'
  default['hadoop']['hdp']['alternatives']['hadoop-conf'] = {
    'path' => '/etc/hadoop/conf.localhost',
    'priority' => '50'
  }
end
# 1.0.0 <= version < 2.3.0
default['hadoop']['version'] = '1.2.1'
default['hadoop']['archive_url'] = 'http://archive.apache.org/dist/hadoop/core'
default['hadoop']['with_hadoop_lzo'] = false
default['hadoop']['with_security'] = false
# for package installation.
default['hadoop']['packages']['action'] = :install  # or :upgrade,...
default['hadoop']['services']['action'] = [:disable, :stop]

## hadoop-env.sh
default['hadoop']['HADOOP_PREFIX'] = "#{node['grid']['app_root']}/hadoop"
default['hadoop']['HADOOP_PID_DIR'] = "#{node['grid']['vol_root']}/0/var/run/${USER}"
default['hadoop']['HADOOP_LOG_DIR'] = "#{node['grid']['vol_root']}/0/var/log/${USER}"
default['hadoop']['HADOOP_CLASSPATH'] = ''
default['hadoop']['HADOOP_USER_CLASSPATH_FIRST'] = false
case node['hadoop']['install_flavor']
when 'apache'
  default['hadoop']['HADOOP_CONF_DIR'] = (node['hadoop']['version'] >= '2.0.0') \
    ? "#{node['hadoop']['HADOOP_PREFIX']}/etc/hadoop" \
    : "#{node['hadoop']['HADOOP_PREFIX']}/conf"
when 'cdh'
  default['hadoop']['HADOOP_CONF_DIR'] = '/etc/hadoop/conf'
when 'hdp'
  default['hadoop']['HADOOP_CONF_DIR'] = '/etc/hadoop/conf'
end
### with_security
default['hadoop']['HADOOP_SECURE_DN_USER'] = 'hdfs'
default['hadoop']['HADOOP_SECURE_DN_PID_DIR'] = "#{node['grid']['vol_root']}/0/var/run/${HADOOP_SECURE_DN_USER}"
default['hadoop']['HADOOP_SECURE_DN_LOG_DIR'] = "#{node['grid']['vol_root']}/0/var/log/${HADOOP_SECURE_DN_USER}"
case node['hadoop']['install_flavor']
when 'cdh'
  if node['cdh']['version'] >= '4.0.0' then
    default['hadoop']['HADOOP_PID_DIR'] = '/var/run/hadoop-hdfs'
    default['hadoop']['HADOOP_SECURE_DN_PID_DIR'] = '/var/run/hadoop-hdfs'
    default['hadoop']['HADOOP_SECURE_DN_LOG_DIR'] = "#{node['grid']['vol_root']}/0/var/log/hdfs"
    # NG: $HADOOP_SECURE_DN_USER is N/A!
    # "#{node['grid']['vol_root']}/0/var/log/${HADOOP_SECURE_DN_USER}"
  else
    # NG: ${USER} is N/A!
    default['hadoop']['HADOOP_PID_DIR'] = '/var/run/hadoop-0.20'
    default['hadoop']['HADOOP_LOG_DIR'] = "#{node['grid']['vol_root']}/0/var/log"
    default['hadoop']['HADOOP_SECURE_DN_PID_DIR'] = '/var/run/hadoop-0.20'
  end
when 'hdp'
  if node['hdp']['version'] >= '2.0.0' then
    default['hadoop']['HADOOP_PID_DIR'] = '/var/run/hadoop-hdfs'
    default['hadoop']['HADOOP_SECURE_DN_PID_DIR'] = '/var/run/hadoop-hdfs'
  else
    default['hadoop']['HADOOP_PID_DIR'] = '/var/run/hadoop'
    default['hadoop']['HADOOP_SECURE_DN_PID_DIR'] = '/var/run/hadoop'
  end
end

## hadoop-policy.xml
default['hadoop']['security.refresh.policy.protocol.acl'] = 'hdfs,mapred hadoop'
default['hadoop']['security.admin.operations.protocol.acl'] = 'hdfs,mapred hadoop'

## core-site.xml
default['hadoop']['this.cluster.name'] = 'localhost' 
default['hadoop']['this.domain'] = 'localhost'
default['hadoop']['this.realm'] = 'LOCALDOMAIN'
default['hadoop']['this.keytab.dir'] = "#{node['grid']['etc_root']}/keytabs/#{node['hadoop']['this.cluster.name']}"
default['hadoop']['this.namenode.fqdn'] = 'localhost'
default['hadoop']['fs.default.name'] = 'hdfs://${this.namenode.fqdn}:9000'
default['hadoop']['hadoop.tmp.dir'] = '/tmp/hadoop-${user.name}'
default['hadoop']['fs.checkpoint.dir'] = "#{node['grid']['vol_root']}/0/var/lib/${user.name}/checkpoint"
### with_security
default['hadoop']['hadoop.security.authentication'] = 'kerberos'
default['hadoop']['hadoop.security.authorization'] = 'true'
if node['hadoop']['version'] >= '2.0.0' \
  || (node['hadoop']['install_flavor'] == 'cdh' && node['cdh']['version'] >= '4.0.0') \
  || (node['hadoop']['install_flavor'] == 'hdp' && node['hdp']['version'] >= '2.0.0.0') then
  default['hadoop']['hadoop.security.auth_to_local'] = '
            RULE:[2:$1@$0](.*@${this.realm})s/@.*//
            RULE:[1:$1@$0](.*@${this.realm})s/@.*//
            RULE:[2:$1@$0](hdfs@.*${this.realm})s/.*/hdfs/
            RULE:[2:$1@$0](yarn@.*${this.realm})s/.*/yarn/
            RULE:[2:$1@$0](mapred@.*${this.realm})s/.*/mapred/
            DEFAULT'
else
  default['hadoop']['hadoop.security.auth_to_local'] = '
            RULE:[2:$1@$0](.*@${this.realm})s/@.*//
            RULE:[1:$1@$0](.*@${this.realm})s/@.*//
            RULE:[2:$1@$0](hdfs@.*${this.realm})s/.*/hdfs/
            RULE:[2:$1@$0](mapred@.*${this.realm})s/.*/mapred/
            DEFAULT'
end
default['hadoop']['hadoop.security.group.mapping'] = 'org.apache.hadoop.security.JniBasedUnixGroupsMapping'
default['hadoop']['hadoop.security.groups.cache.secs'] = '14400'
default['hadoop']['hadoop.kerberos.kinit.command'] = '/usr/bin/kinit'
default['hadoop']['hadoop.http.filter.initializers'] = 'org.apache.hadoop.security.AuthenticationFilterInitializer'
default['hadoop']['hadoop.http.authentication.signature.secret.file'] = "#{node['grid']['etc_root']}/hadoop-http-auth-signature-secret"
default['hadoop']['hadoop.http.authentication.cookie.domain'] = '${this.domain}'
default['hadoop']['hadoop.http.authentication.type'] = 'kerberos'
default['hadoop']['hadoop.http.authentication.kerberos.principal'] = 'HTTP/localhost@${this.realm}'
default['hadoop']['hadoop.http.authentication.kerberos.keytab'] = '${this.keytab.dir}/HTTP.keytab'
default['hadoop']['hadoop.proxyuser'] = {
  'oozie' => {
    'hosts' => 'localhost',
    'groups' => 'hadoopers'
  },
  'httpfs' => {
    'hosts' => 'localhost',
    'groups' => 'hadoopers'
  }
}

## hdfs-site.xml
default['hadoop']['this.secondary.namenode.fqdn'] = 'localhost'
default['hadoop']['dfs.name.dir'] = "#{node['grid']['vol_root']}/0/var/lib/${user.name}/name"
default['hadoop']['dfs.replication'] = '1'
default['hadoop']['dfs.hosts'] = "#{node['hadoop']['HADOOP_CONF_DIR']}/hosts.include"
default['hadoop']['dfs.hosts.exclude'] = "#{node['hadoop']['HADOOP_CONF_DIR']}/hosts.exclude"
### with_security
default['hadoop']['dfs.cluster.administrators'] = ' hdfs'
default['hadoop']['dfs.http.port'] = '50070'
default['hadoop']['dfs.http.address'] = '${this.namenode.fqdn}:${dfs.http.port}'
#### version >= 1.1.x
default['hadoop']['hadoop.security.use-weak-http-crypto'] = 'false'
default['hadoop']['dfs.https.port'] = '50470'
default['hadoop']['dfs.https.address'] = '${this.namenode.fqdn}:${dfs.https.port}'
default['hadoop']['dfs.namenode.kerberos.principal'] = 'hdfs/_HOST@${this.realm}'
default['hadoop']['dfs.namenode.kerberos.https.principal'] = 'host/${this.namenode.fqdn}@${this.realm}'
default['hadoop']['dfs.namenode.keytab.file'] = '${this.keytab.dir}/nn.keytab'
default['hadoop']['dfs.secondary.http.port'] = '50090'
default['hadoop']['dfs.secondary.http.address'] = '${this.secondary.namenode.fqdn}:${dfs.secondary.http.port}'
default['hadoop']['dfs.secondary.https.port'] = '50495'
default['hadoop']['dfs.secondary.https.address'] = '${this.secondary.namenode.fqdn}:${dfs.secondary.https.port}'
default['hadoop']['dfs.secondary.namenode.kerberos.principal'] = 'hdfs/${this.secondary.namenode.fqdn}@${this.realm}'
default['hadoop']['dfs.secondary.namenode.kerberos.https.principal'] = 'host/${this.secondary.namenode.fqdn}@${this.realm}'
default['hadoop']['dfs.secondary.namenode.keytab.file'] = '${this.keytab.dir}/cn.keytab'
default['hadoop']['dfs.block.access.token.enable'] = 'true'
default['hadoop']['dfs.datanode.kerberos.principal'] = 'hdfs/localhost@${this.realm}'
default['hadoop']['dfs.datanode.keytab.file'] = '${this.keytab.dir}/dn.keytab'
default['hadoop']['dfs.datanode.address'] = '0.0.0.0:1004'
default['hadoop']['dfs.datanode.http.address'] = '0.0.0.0:1006'
default['hadoop']['dfs.namenode.http-address'] = '${this.namenode.fqdn}:50070'
default['hadoop']['dfs.namenode.secondary.http-address'] = '${this.secondary.namenode.fqdn}:50090'
default['hadoop']['dfs.web.authentication.kerberos.principal'] = 'HTTP/_HOST@${this.realm}'
default['hadoop']['dfs.web.authentication.kerberos.keytab'] = '${this.keytab.dir}/HTTP.keytab'
### available in the ver. 1.1 and later
default['hadoop']['dfs.namenode.kerberos.internal.spnego.principal'] = '${dfs.web.authentication.kerberos.principal}'
default['hadoop']['dfs.secondary.namenode.kerberos.internal.spnego.principal'] = 'HTTP/${this.secondary.namenode.fqdn}@${this.realm}'
# bug? _HOST is NOT replaced with dfs.namenode.secondary.http-address's host name!
#default['hadoop']['dfs.secondary.namenode.kerberos.internal.spnego.principal'] = '${dfs.web.authentication.kerberos.principal}'

## mapred-site.xml
default['hadoop']['this.jobtracker.fqdn'] = 'localhost'
default['hadoop']['this.jobhistory.fqdn'] = 'localhost'
default['hadoop']['mapred.job.tracker'] = '${this.jobtracker.fqdn}:9001'
default['hadoop']['mapred.system.dir'] \
  = (node['hadoop']['install_flavor'] == 'cdh') \
    ? "#{node['grid']['vol_root']}/0/var/lib/mapred/system" \
    : "#{node['grid']['vol_root']}/0/var/lib/${user.name}/system"
default['hadoop']['mapreduce.jobtracker.staging.root.dir'] = '/user'
default['hadoop']['mapred.job.tracker.persist.jobstatus.active'] = 'true'
default['hadoop']['mapred.job.tracker.persist.jobstatus.hours'] = '3'
default['hadoop']['mapred.job.tracker.persist.jobstatus.dir'] = "#{node['grid']['vol_root']}/0/var/lib/mapred/jobstatus"
default['hadoop']['hadoop.job.history.location'] = "file://#{node['grid']['vol_root']}/0/var/lib/mapred/history"
default['hadoop']['mapred.job.tracker.history.completed.location'] = "hdfs://#{node['grid']['vol_root']}/0/var/lib/mapred/history/done"
default['hadoop']['mapred.hosts'] = "#{node['hadoop']['HADOOP_CONF_DIR']}/hosts.include"
default['hadoop']['mapred.hosts.exclude'] = "#{node['hadoop']['HADOOP_CONF_DIR']}/hosts.exclude"
default['hadoop']['mapred.jobtracker.taskScheduler'] = 'org.apache.hadoop.mapred.JobQueueTaskScheduler'
### with_security
default['hadoop']['mapred.acls.enabled'] = 'true'
default['hadoop']['mapreduce.cluster.administrators'] = ' mapred'
default['hadoop']['mapreduce.jobtracker.kerberos.principal'] = 'mapred/_HOST@${this.realm}'
default['hadoop']['mapreduce.jobtracker.keytab.file'] = '${this.keytab.dir}/jt.keytab'
default['hadoop']['mapreduce.tasktracker.kerberos.principal'] = 'mapred/localhost@${this.realm}'
default['hadoop']['mapreduce.tasktracker.keytab.file'] = '${this.keytab.dir}/tt.keytab'
default['hadoop']['mapred.task.tracker.task-controller'] = 'org.apache.hadoop.mapred.LinuxTaskController'
default['hadoop']['mapreduce.tasktracker.group'] = 'mapred'
default['hadoop']['mapreduce.history.server.embedded'] = 'true'
default['hadoop']['mapreduce.history.server.http.address'] = '${this.jobhistory.fqdn}:19888'
default['hadoop']['mapreduce.jobhistory.kerberos.principal'] = 'mapred/${this.jobhistory.fqdn}@${this.realm}'
default['hadoop']['mapreduce.jobhistory.keytab.file'] = '${this.keytab.dir}/jh.keytab'

## mapred-queue-acls.xml
default['hadoop']['mapred.queue.default.acl-submit-job'] = '*'
default['hadoop']['mapred.queue.default.acl-administer-jobs'] = ' hadoop,gridops'

## taskcontroller.cfg
### e.g. CentOS: 500
default['hadoop']['taskcontroller']['min.user.id'] = '1000'

## hadoop-metrics2.properties
default['hadoop']['metrics2']['*.sink.ganglia.class'] = 'org.apache.hadoop.metrics2.sink.ganglia.GangliaSink31'
default['hadoop']['metrics2']['*.sink.ganglia.period'] = '10'
default['hadoop']['metrics2']['*.sink.ganglia.supportsparse'] = 'false'
default['hadoop']['metrics2']['*.sink.ganglia.slope'] = 'jvm.metrics.gcCount=zero,jvm.metrics.memHeapUsedM=both'
default['hadoop']['metrics2']['*.sink.ganglia.dmax'] = 'jvm.metrics.threadsBlocked=70,jvm.metrics.memHeapUsedM=40'
# e.g. default['hadoop']['metrics2']['.sink.ganglia.servers'] = 'addredd1:port1,address2:port2,...'
# '': off
default['hadoop']['metrics2']['namenode.sink.ganglia.servers'] = ''
default['hadoop']['metrics2']['datanode.sink.ganglia.servers'] = ''
default['hadoop']['metrics2']['jobtracker.sink.ganglia.servers'] = ''
default['hadoop']['metrics2']['tasktracker.sink.ganglia.servers'] = ''
default['hadoop']['metrics2']['maptask.sink.ganglia.servers'] = ''
default['hadoop']['metrics2']['reducetask.sink.ganglia.servers'] = ''
## for 1.0.x KSSL on the JDK 6 only
default['hadoop']['krb5_strong_crypto'] = {
  'default_tgs_enctypes' \
    => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5',
  'default_tkt_enctypes' \
    => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5',
  'permitted_enctypes' \
    => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5'
}
default['hadoop']['krb5_weak_crypto'] = {
  'default_tgs_enctypes' \
    => 'des-cbc-crc des-cbc-md5',
  'default_tkt_enctypes' \
    => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5 des-cbc-crc des-cbc-md5',
  'permitted_enctypes' \
    => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5 des-cbc-crc des-cbc-md5'
}

# 2.x specific
## hadoop-env.sh
default['hadoop']['JSVC_HOME'] = '/usr/bin'

## hadoop-policy.xml
default['hadoop']['security.refresh.usertogroups.mappings.protocol.acl'] = 'hdfs hadoop'
default['hadoop']['security.ha.service.protocol.acl'] = 'hdfs hadoop'
default['hadoop']['security.zkfc.protocol.acl'] = 'hdfs hadoop'
default['hadoop']['security.qjournal.service.protocol.acl'] = 'hdfs'
default['hadoop']['security.resourcetracker.protocol.acl'] = 'yarn'
default['hadoop']['security.resourcemanager-administration.protocol.acl'] = 'yarn hadoop'

## yarn-env.sh
default['hadoop']['HADOOP_COMMON_HOME'] = '${HADOOP_PREFIX}'
default['hadoop']['HADOOP_HDFS_HOME'] = '${HADOOP_PREFIX}'
default['hadoop']['YARN_HOME'] = '${HADOOP_PREFIX}'
default['hadoop']['YARN_PID_DIR'] = "#{node['grid']['vol_root']}/0/var/run/${USER}"
default['hadoop']['YARN_LOG_DIR'] = "#{node['grid']['vol_root']}/0/var/log/${USER}"
default['hadoop']['HADOOP_MAPRED_HOME'] = '${HADOOP_PREFIX}'
case node['hadoop']['install_flavor']
when 'cdh'
  default['hadoop']['YARN_PID_DIR'] = '/var/run/hadoop-yarn'
  default['hadoop']['HADOOP_MAPRED_HOME'] = '/usr/lib/hadoop-mapreduce'
  default['hadoop']['MAPRED_LOG_DIR'] = "#{node['grid']['vol_root']}/0/var/log/mapred"
when 'hdp'
  default['hadoop']['YARN_PID_DIR'] = '/var/run/hadoop-yarn'
end

## mapred-env.sh (available in the ver. 2.0.2-alpha and later.)
default['hadoop']['HADOOP_MAPRED_PID_DIR'] = "#{node['grid']['vol_root']}/0/var/run/${USER}"
default['hadoop']['HADOOP_MAPRED_LOG_DIR'] = "#{node['grid']['vol_root']}/0/var/log/${USER}"
case node['hadoop']['install_flavor']
when 'cdh', 'hdp'
  default['hadoop']['HADOOP_MAPRED_PID_DIR'] = '/var/run/hadoop-mapreduce'
end

## core-site.xml
default['hadoop']['fs.defaultFS'] = 'hdfs://${this.namenode.fqdn}:9000'
### ver. 0.23.7, 2.1.0-beta or later.
default['hadoop']['io.compression.codec.bzip2.library'] = 'system-native'

## hdfs-site.xml
default['hadoop']['dfs.namenode.name.dir'] = "file://#{node['grid']['vol_root']}/0/var/lib/${user.name}/name"
default['hadoop']['dfs.namenode.checkpoint.dir'] = "file://#{node['grid']['vol_root']}/0/var/lib/${user.name}/checkpoint"
default['hadoop']['dfs.namenode.https-address'] = '${this.namenode.fqdn}:50470'
default['hadoop']['dfs.namenode.secondary.https-address'] = '${this.secondary.namenode.fqdn}:50495'

## yarn-site.xml
default['hadoop']['this.resourcemanager.fqdn'] = 'localhost'
default['hadoop']['yarn.log-aggregation-enable'] = 'true'
default['hadoop']['yarn.resourcemanager.scheduler.class'] = 'org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler'
default['hadoop']['yarn.nodemanager.resource.memory-mb'] = '8192'
# cpu-cores is available in the ver. 2.0.3-alpha and later.
default['hadoop']['yarn.nodemanager.resource.cpu-cores'] = '8'
default['hadoop']['yarn.nodemanager.remote-app-log-dir'] = "#{node['grid']['vol_root']}/0/var/log/${user.name}/nm"
case node['hadoop']['install_flavor']
when 'apache'
  default['hadoop']['yarn.nodemanager.aux-services'] = \
    (node['hadoop']['version'] >= '2.2.0') \
    ? 'mapreduce_shuffle' \
    : 'mapreduce.shuffle'
when 'hdp'
  default['hadoop']['yarn.nodemanager.aux-services'] = \
    (node['hdp']['version'] >= '2.0.6.0') \
    ? 'mapreduce_shuffle' \
    : 'mapreduce.shuffle'
when 'cdh'
  default['hadoop']['yarn.nodemanager.aux-services'] = \
    (node['cdh']['version'] >= '5.0.0') \
    ? 'mapreduce_shuffle' \
    : 'mapreduce.shuffle'
end
case node['hadoop']['install_flavor']
when 'apache'
  default['hadoop']['yarn.application.classpath'] = '
           $HADOOP_CONF_DIR,
           $HADOOP_COMMON_HOME/share/hadoop/common/*,
           $HADOOP_COMMON_HOME/share/hadoop/common/lib/*,
           $HADOOP_HDFS_HOME/share/hadoop/hdfs/*,
           $HADOOP_HDFS_HOME/share/hadoop/hdfs/lib/*,
           $HADOOP_YARN_HOME/share/hadoop/yarn/*,
           $HADOOP_YARN_HOME/share/hadoop/yarn/lib/*'
when 'cdh'
  yarn_classpath = '$HADOOP_YARN_HOME/*,$HADOOP_YARN_HOME/lib/*'
  if node['cdh']['version'] < '5.0.0' then
    yarn_classpath = '$YARN_HOME/*,$YARN_HOME/lib/*'
  end
  default['hadoop']['yarn.application.classpath'] = "
           $HADOOP_CONF_DIR,
           $HADOOP_COMMON_HOME/*,$HADOOP_COMMON_HOME/lib/*,
           $HADOOP_HDFS_HOME/*,$HADOOP_HDFS_HOME/lib/*,
           $HADOOP_MAPRED_HOME/*,$HADOOP_MAPRED_HOME/lib/*,
           #{yarn_classpath}"
when 'hdp'
  default['hadoop']['yarn.application.classpath'] = '
           $HADOOP_CONF_DIR,
           $HADOOP_COMMON_HOME/*,$HADOOP_COMMON_HOME/lib/*,
           $HADOOP_HDFS_HOME/*,$HADOOP_HDFS_HOME/lib/*,
           $HADOOP_MAPRED_HOME/*,$HADOOP_MAPRED_HOME/lib/*,
           $HADOOP_YARN_HOME/*,$HADOOP_YARN_HOME/lib/*'
end
default['hadoop']['yarn.resourcemanager.nodes.include-path'] = "#{node['hadoop']['HADOOP_CONF_DIR']}/hosts.include"
default['hadoop']['yarn.resourcemanager.nodes.exclude-path'] = "#{node['hadoop']['HADOOP_CONF_DIR']}/hosts.exclude"
# with security
default['hadoop']['yarn.acl.enable'] = 'true'
default['hadoop']['yarn.admin.acl'] = ' yarn,gridops'
default['hadoop']['yarn.resourcemanager.principal'] = 'yarn/${this.resourcemanager.fqdn}@${this.realm}'
default['hadoop']['yarn.resourcemanager.keytab'] = '${this.keytab.dir}/rm.keytab'
default['hadoop']['yarn.nodemanager.principal'] = 'yarn/localhost@${this.realm}'
default['hadoop']['yarn.nodemanager.keytab'] = '${this.keytab.dir}/nm.keytab'
default['hadoop']['yarn.nodemanager.admin-env'] = 'MALLOC_ARENA_MAX=$MALLOC_ARENA_MAX,LD_LIBRARY_PATH=${HADOOP_COMMON_HOME}/lib/native'
default['hadoop']['yarn.nodemanager.container-executor.class'] = 'org.apache.hadoop.yarn.server.nodemanager.LinuxContainerExecutor'
default['hadoop']['yarn.nodemanager.linux-container-executor.group'] = 'yarn'
default['hadoop']['yarn.nodemanager.linux-container-executor.resources-handler.class'] = 'org.apache.hadoop.yarn.server.nodemanager.util.DefaultLCEResourcesHandler'
# CgroupsLCEResourcesHandler is available in the ver. 2.0.3-alpha and later.
#default['hadoop']['yarn.nodemanager.linux-container-executor.resources-handler.class'] = 'org.apache.hadoop.yarn.server.nodemanager.util.CgroupsLCEResourcesHandler'
default['hadoop']['yarn.nodemanager.linux-container-executor.cgroups.hierarchy'] = '/hadoop-yarn'
default['hadoop']['yarn.nodemanager.linux-container-executor.cgroups.mount'] = 'false'
default['hadoop']['yarn.nodemanager.linux-container-executor.cgroups.mount-path'] = ''
# in the ver. 2.1.1 and later.
default['hadoop']['yarn.resourcemanager.webapp.spnego-principal'] = 'HTTP/${this.resourcemanager.fqdn}@${this.realm}'
default['hadoop']['yarn.resourcemanager.webapp.spnego-keytab-file'] = '${this.keytab.dir}/HTTP.keytab'
default['hadoop']['yarn.nodemanager.webapp.spnego-principal'] = 'HTTP/localhost@${this.realm}'
default['hadoop']['yarn.nodemanager.webapp.spnego-keytab-file'] = '${this.keytab.dir}/HTTP.keytab'

## mapred-site.xml
default['hadoop']['mapreduce.framework.name'] = 'yarn'
default['hadoop']['yarn.app.mapreduce.am.staging-dir'] = '/user'
default['hadoop']['mapreduce.jobhistory.intermediate-done-dir'] = "#{node['grid']['vol_root']}/0/var/lib/mapred/history/done_intermediate"
default['hadoop']['mapreduce.jobhistory.done-dir'] = "#{node['grid']['vol_root']}/0/var/lib/mapred/history/done"
default['hadoop']['mapreduce.jobhistory.principal'] = 'mapred/${this.jobhistory.fqdn}@${this.realm}'
default['hadoop']['mapreduce.jobhistory.keytab'] = '${this.keytab.dir}/jh.keytab'
# in the ver. 2.1.1 and later.
default['hadoop']['mapreduce.jobhistory.webapp.spnego-principal'] = 'HTTP/${this.jobhistory.fqdn}@${this.realm}'
default['hadoop']['mapreduce.jobhistory.webapp.spnego-keytab-file'] = '${this.keytab.dir}/HTTP.keytab'

## capacity-scheduler.xml
default['hadoop']['yarn.scheduler.capacity.root.acl_submit_applications'] = ' '  # nobody
default['hadoop']['yarn.scheduler.capacity.root.acl_ahdminister_queue'] = ' hadoop,gridops'
default['hadoop']['yarn.scheduler.capacity.root.queues'] = 'default'
default['hadoop']['yarn.scheduler.capacity.root.default.acl_submit_applications'] = '*'
default['hadoop']['yarn.scheduler.capacity.root.default.acl_administer_queue'] = ' hadoop,gridops'

## container-executor.cfg
### e.g. CentOS: 500
default['hadoop']['container-executor']['min.user.id'] = '1000'
default['hadoop']['container-executor']['allowed.system.users'] = ''  # ver. 2.2.0
## hadoop-metrics2.properties
default['hadoop']['metrics2']['resourcemanager.sink.ganglia.servers'] = ''
default['hadoop']['metrics2']['nodemanager.sink.ganglia.servers'] = ''

## extra settings
default['hadoop']['extra_configs'] = {
  # e.g. 'core-site.xml' => {'k1' => 'v1', 'k2' => 'v2'},
  'hadoop-env.sh' => {},
  'yarn-env.sh' => {},  # ver. 2.0
  'mapred-env.sh' => {},  # ver. 2.0
  'core-site.xml' => {},
  'hdfs-site.xml' => {
    # with HBase
    #'dfs.support.append' => 'true',
    #'truenode.max.xcievers' => '4096'
  },
  'yarn-site.xml' => {},  # ver. 2.0
  'mapred-site.xml' => {
    #'mapred.tasktracker.map.tasks.maximum' => '4',     # default: 2
    #'mapred.tasktracker.reduce.tasks.maximum' => '2',  # default: 2
    #'mapred.child.java.opts' => '-Xmx1000m',           # default: -Xmx200m
    #'mapred.reduce.slowstart.completed.maps' => '0.80',  # default: 0.05
    #'tasktracker.http.threads' => '80',                  # default: 40
    #'mapred.reduce.parallel.copies' => SQRT(nodes)       # default: 5
  },
  'capacity-scheduler.xml' => {},
}
#default['hadoop'][''] = 

=begin
# e.g. for full-distributed 
default['grid']['max_vol_nums'] = '4'
## hadoop-env.sh
default['hadoop']['HADOOP_CLASSPATH'] = '/usr/share/java/commons-daemon.jar'
default['hadoop']['HADOOP_USER_CLASSPATH_FIRST'] = true
## core-site.xml
default['hadoop']['this.cluster.name'] = 'pleiades' 
default['hadoop']['this.domain'] = 'grid.example.com'
default['hadoop']['this.realm'] = 'GRID.EXAMPLE.COM'
default['hadoop']['this.keytab.dir'] = '/grid/etc/keytabs/${this.cluster.name}'
default['hadoop']['this.namenode.fqdn'] = '${this.cluster.name}-nn.${this.domain}'
default['hadoop']['fs.checkpoint.dir'] = "#{node['grid']['vol_root']}/0/var/lib/${user.name}/checkpoint,/export/home/${user.name}/var/lib/checkpoint"
default['hadoop']['hadoop.http.authentication.kerberos.principal'] = 'HTTP/${this.fqdn}@${this.realm}'
## hdfs-site.xml
default['hadoop']['this.secondary.namenode.fqdn'] = '${this.cluster.name}-cn.${this.domain}'
default['hadoop']['dfs.name.dir'] = "#{node['grid']['vol_root']}/0/var/lib/${user.name}/name,/export/home/${user.name}/var/lib/name"
default['hadoop']['dfs.datanode.kerberos.principal'] = 'hdfs/_HOST@${this.realm}'
default['hadoop']['dfs.replication'] = '3'
## mapred-site.xml
default['hadoop']['this.jobtracker.fqdn'] = '${this.cluster.name}-jt.${this.domain}'
default['hadoop']['this.jobhistory.fqdn'] = '${this.cluster.name}-jt.${this.domain}'
#default['hadoop']['this.jobhistory.fqdn'] = '${this.cluster.name}-jh.${this.domain}'
default['hadoop']['mapreduce.tasktracker.kerberos.principal'] = 'mapred/_HOST@${this.realm}'
#default['hadoop'][''] =
=end
