#
# Cookbook Name:: drillbook
# Recipe:: guard
#
# Copyright 2016, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# multiple only_if
log 'only_if true,  only_if true ' do
  only_if { true }
  only_if { true }
end

log 'only_if true,  only_if false' do
  only_if { true }
  only_if { false }
end

log 'only_if false, only_if true ' do
  only_if { false }
  only_if { true }
end

log 'only_if false, only_if false' do
  only_if { false }
  only_if { false }
end

# multiple not_if
log 'not_if  true,  not_if  true ' do
  not_if { true }
  not_if { true }
end

log 'not_if  true,  not_if  false' do
  not_if { true }
  not_if { false }
end

log 'not_if  false, not_if  true ' do
  not_if { false }
  not_if { true }
end

log 'not_if  false, not_if  false' do
  not_if { false }
  not_if { false }
end

# only_if, not_if
log 'only_if true,  not_if  true ' do
  only_if { true }
  not_if  { true }
end

log 'only_if true,  not_if  false' do
  only_if { true }
  not_if  { false }
end

log 'only_if false, not_if  true ' do
  only_if { false }
  not_if  { true }
end

log 'only_if false, not_if  false' do
  only_if { false }
  not_if  { false }
end

# not_if, only_if
log 'not_if  true,  only_if true ' do
  not_if  { true }
  only_if { true }
end

log 'not_if  true,  only_if false' do
  not_if  { true }
  only_if { false }
end

log 'not_if  false, only_if true ' do
  not_if  { false }
  only_if { true }
end

log 'not_if  false, only_if false' do
  not_if  { false }
  only_if { false }
end

# etc
log 'not_if  true,  not_if true,  only_if false' do
  not_if  { true }
  not_if  { true }
  only_if { false }
end

log 'not_if  true,  not_if true,  not_if true, only_if false' do
  not_if  { true }
  not_if  { true }
  not_if  { true }
  only_if { false }
end

