export JAVA_HOME=<%= node['java']['java_home'] %>

export HADOOP_HOME_WARN_SUPPRESS=true
export HADOOP_HOME=<%= node['pig']['HADOOP_HOME'] %>
export HADOOP_CONF_DIR=<%= node['pig']['HADOOP_CONF_DIR'] %>
# for Hadoop deb and rpm package.
#export HADOOP_HOME=${HADOOP_HOME:-'/usr/share/hadoop'}
#export HADOOP_CONF_DIR=${HADOOP_CONF_DIR:-'/etc/hadoop'}

# for HCatalog
PIG_USE_HCATALOG=${PIG_USE_HCATALOG:-'false'}
# $includeHCatalog is set in the ${PIG_HOME}/bin/pig scripts.
if [ x"$includeHCatalog" = x'true' -o x"$PIG_USE_HCATALOG" = x'true' ]; then
	export HCAT_HOME=${HCAT_HOME:-'/grid/usr/hcatalog'}
	export HIVE_HOME=${HIVE_HOME:-'/grid/usr/hive'}
	HIVE_OPTS=${HIVE_OPTS:-'-Dhive.metastore.uris=thrift://localhost:9933'}
fi

## pig-0.10.1 or later with -useHCatalog option
if [ x"$includeHCatalog" = x'true' ]; then
	HIVE_LIBS='slf4j-log4j12'

	LIB_DIR=${HIVE_HOME}/lib
	for LIB in $HIVE_LIBS; do
		LIB=`ls ${LIB_DIR} | grep -P ${LIB}'-\d.*\.jar'`
		if [ $? -eq 0 ]; then
			if [ x"$PIG_CLASSPATH" = x'' ]; then
				PIG_CLASSPATH=${LIB_DIR}/${LIB}
			else
				PIG_CLASSPATH=${PIG_CLASSPATH}:${LIB_DIR}/${LIB}
			fi
		fi
	done
	export PIG_CLASSPATH

	if [ x"$PIG_OPTS" = x'' ]; then
		export PIG_OPTS=$HIVE_OPTS
	else
		export PIG_OPTS="${PIG_OPTS} ${HIVE_OPTS}"
	fi
fi

## pig-0.10.0 or before with PIG_USE_HCATALOG=true
if [ x"$PIG_USE_HCATALOG" = x'true' ]; then
	HCAT_LIBS='hcatalog'
	HIVE_LIBS='hive-metastore libthrift libthrift hive-exec libfb303 jdo2-api slf4j-api slf4j-log4j12'

	if [ x"$PIG_CLASSPATH" = x'' ]; then
		PIG_CLASSPATH=${HIVE_HOME}/conf:${HADOOP_HOME}/conf
	else
		PIG_CLASSPATH=${PIG_CLASSPATH}:${HIVE_HOME}/conf:${HADOOP_HOME}/conf
	fi

	LIB_DIR=${HCAT_HOME}/share/hcatalog
	for LIB in $HCAT_LIBS; do
		LIB=`ls ${LIB_DIR} | grep -P ${LIB}'-\d.*\.jar'`
		if [ $? -eq 0 ]; then
			PIG_CLASSPATH=${PIG_CLASSPATH}:${LIB_DIR}/${LIB}
			if [ x"$pigAdditionalJars" = x'' ]; then
				pigAdditionalJars=${LIB_DIR}/${LIB}
			else
				pigAdditionalJars=${pigAdditionalJars}:${LIB_DIR}/${LIB}
			fi
		fi
	done

	LIB_DIR=${HIVE_HOME}/lib
	for LIB in $HIVE_LIBS; do
		LIB=`ls ${LIB_DIR} | grep -P ${LIB}'-\d.*\.jar'`
		if [ $? -eq 0 ]; then
			PIG_CLASSPATH=${PIG_CLASSPATH}:${LIB_DIR}/${LIB}
			if [ x"$pigAdditionalJars" = x'' ]; then
				pigAdditionalJars=${LIB_DIR}/${LIB}
			else
				pigAdditionalJars=${pigAdditionalJars}:${LIB_DIR}/${LIB}
			fi
		fi
	done

	export PIG_CLASSPATH

	HIVE_OPTS="${HIVE_OPTS} -Dpig.additional.jars=${pigAdditionalJars}"
	if [ x"$PIG_OPTS" = x'' ]; then
		export PIG_OPTS=$HIVE_OPTS
	else
		export PIG_OPTS="${PIG_OPTS} ${HIVE_OPTS}"
	fi
fi

<%
this_file = 'pig-env.sh'
if defined? node['pig']['extra_configs'][this_file] \
  && node['pig']['extra_configs'][this_file] != nil then
  node['pig']['extra_configs'][this_file].each do |key, value|
%>
export <%= key %>=<%= value %>
<%
  end
end
%>

