#
# Cookbook Name:: berkshelf-api-server-ya
# Recipe Spec:: spec_helper
#
# Copyright 2015, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# Added by ChefSpec
require 'chefspec'

# Uncomment to use ChefSpec's Berkshelf extension
require 'chefspec/berkshelf'

RSpec.configure do |config|
  config.before(:suite) do
    ChefSpec::Coverage.start! do
      filters.clear

      # custom filters
      add_filter do |resource|
        resource.name !~ %r{^(
            /etc/sv/berks-api/run
           |/etc/nginx/sites-available/berks-api
          )$}x
      end
    end
  end

  # Specify the path for Chef Solo to find cookbooks
  #config.cookbook_path = '/var/cookbooks'

  # Specify the path for Chef Solo to find roles
  # config.role_path = '/var/roles'

  # Specify the Chef log_level (default: :warn)
  # config.log_level = :debug

  # Specify the path to a local JSON file with Ohai data
  # config.path = 'ohai.json'

  # Specify the operating platform to mock Ohai data from
  # config.platform = 'ubuntu'

  # Specify the operating version to mock Ohai data from
  # config.version = '12.04'
end

