#
# Cookbook Name:: supermarket-omnibus-ya
# Recipe:: default
#
# Copyright 2016-2017, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# https://supermarket.chef.io/cookbooks/supermarket-omnibus-cookbook

::Chef::Recipe.send(:include, SSLCert::Helper)

force_override_config = node.force_override['supermarket_omnibus']['config']

if node['supermarket_omnibus']['with_ssl_cert_cookbook']
  cn = node['supermarket_omnibus']['ssl_cert']['common_name']
  force_override_config['ssl']['certificate'] = server_cert_path(cn)
  force_override_config['ssl']['certificate_key'] = server_key_path(cn)
end

chef_oauth2_app_id_vault_item = node['supermarket_omnibus']['chef_oauth2_app_id_vault_item']
unless chef_oauth2_app_id_vault_item.empty?
  chef_oauth2_app_id = get_vault_item_value(chef_oauth2_app_id_vault_item)
  node.force_override['supermarket_omnibus']['chef_oauth2_app_id'] = chef_oauth2_app_id
end

chef_oauth2_secret_vault_item = node['supermarket_omnibus']['chef_oauth2_secret_vault_item']
unless chef_oauth2_secret_vault_item.empty?
  chef_oauth2_secret = get_vault_item_value(chef_oauth2_secret_vault_item)
  node.force_override['supermarket_omnibus']['chef_oauth2_secret'] = chef_oauth2_secret
end

include_recipe 'supermarket-omnibus-cookbook'
