/*
	JǗNX

		Tab(4) Font(10) VC2003.NET

													Make:  2007/8/27
											 Last Update:  2007/8/27
												  Author:  
*/

#include "dxSysAfx.h"
#include "dxSysCamera.h"

CameraCtrl* g_dxCameraCtrl;

Camera::Camera()
{
	m_stDebug = new DrawParts;
	ZeroMemory( &m_stCameraVex, sizeof(VERTEX)*16 );
	m_stDebug->SetVertexList( m_stCameraVex[0], 16 );
	
//	m_fDistance=1.0f;	//
//	m_CameraPos;	//J̈ʒu
//	m_CameraAt;		//J̒_(^[Qbg)
//	m_CameraRot;	//J̉]

//	m_ViewMat;		//r[|[gE}gbNX
}

Camera::~Camera()
{
	SAFE_DELETE( m_stDebug );
}

void	Camera::SetCameraPos(D3DXVECTOR3 &vec)
{
	memcpy( &this->m_CameraPos , vec, sizeof(D3DXVECTOR3) );
}

void	Camera::SetCameraPos(float x, float y, float z)
{
	this->m_CameraPos.x = x;
	this->m_CameraPos.y = y;
	this->m_CameraPos.z = z;
}

void	Camera::SetCameraTarget(D3DXVECTOR3 &vec)
{
	memcpy( &this->m_CameraAt , vec, sizeof(D3DXVECTOR3) );
}

void	Camera::SetCameraTarget(float x, float y, float z)
{
	this->m_CameraAt.x = x;
	this->m_CameraAt.y = y;
	this->m_CameraAt.z = z;
}

void	Camera::Refresh()
{
	//ɃvC[𒆐SƂJ[Ns

	//D3DXMATRIX c_mat;
	//D3DXMATRIX tmp;							//s
	D3DXVECTOR3 vec3Up(0.0f,1.0f,0.0f);		//J̎͂wxʂɑ΂ĕsłƂ܂́B
	//D3DXVECTOR3	vec3ScreenPos;
	//D3DXMatrixIdentity(&c_mat);
 	//D3DXMatrixRotationZ(&tmp, this->m_CameraRot.y);
	//c_mat*=tmp;
	//D3DXMatrixRotationY(&tmp, this->m_CameraRot.x);
	//c_mat*=tmp;
	//D3DXVec3TransformCoord(&vec3ScreenPos,&m_CameraPos,&c_mat);
	// vec3From = m_fDistance * vec3ScreenPos + m_CameraAt;
	D3DXMatrixLookAtLH(&m_ViewMat,&m_CameraPos,&m_CameraAt,&vec3Up); //r[s쐬
	MCR_DEVICE->SetTransform(D3DTS_VIEW,&m_ViewMat);				 //r[sSet
}

/////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////


CameraCtrl::CameraCtrl()
{
	m_NowCamera = 0;
	for(int i=0; i<16; i++) m_pcCarera[i]=NULL;
	m_pcCarera[m_NowCamera] = new Camera;

	//vWFNVn
	m_fAngle = 30 * 3.141592f  / 180.0f;;	//p
	m_fAspect = 1.0f;						//AXyNg	ʂ1.0f
	m_fNear = 0.01f;						//ŋߓ_
	m_fFar = 250.0f;						//ŉ_
	D3DXMatrixPerspectiveFovLH(&m_PrjMat,m_fAngle,m_fAspect,m_fNear,m_fFar);	//vWFNVs̍쐬
	MCR_DEVICE->SetTransform(D3DTS_PROJECTION,&m_PrjMat);						//vWFNVsSet

	m_pcCarera[m_NowCamera]->SetCameraPos(0.0f,0.0f,2.0f);
	m_pcCarera[m_NowCamera]->SetCameraTarget(0.0f,0.0f,1.0f);
	m_pcCarera[m_NowCamera]->Refresh();
}

CameraCtrl::~CameraCtrl()
{
	for(int i=0; i<16; i++)
	{
		SAFE_DELETE( m_pcCarera[i] );
	}
}

void	CameraCtrl::SetNowCameraPos(D3DXVECTOR3 &vec)
{
	if( !this->m_pcCarera[this->m_NowCamera] ) return;
	this->m_pcCarera[this->m_NowCamera]->SetCameraPos(vec);
}

void	CameraCtrl::SetNowCameraPos(float x, float y, float z)
{
	if( !this->m_pcCarera[this->m_NowCamera] ) return;
	this->m_pcCarera[this->m_NowCamera]->SetCameraPos(x,y,z);
}

void	CameraCtrl::SetNowCameraTarget(D3DXVECTOR3 &vec)
{
	if( !this->m_pcCarera[this->m_NowCamera] ) return;
	this->m_pcCarera[this->m_NowCamera]->SetCameraTarget(vec);
}

void	CameraCtrl::SetNowCameraTarget(float x, float y, float z)
{
	if( !this->m_pcCarera[this->m_NowCamera] ) return;
	this->m_pcCarera[this->m_NowCamera]->SetCameraTarget(x,y,z);
}

void	CameraCtrl::SetCameraPos(int id, D3DXVECTOR3 &vec)
{
	if( this->m_pcCarera[id] )
	{
		this->m_pcCarera[id]->SetCameraPos(vec);
	}
}

void	CameraCtrl::SetCameraPos(int id, float x, float y, float z)
{
	if( this->m_pcCarera[id] )
	{
		this->m_pcCarera[id]->SetCameraPos(x,y,z);
	}
}


void	CameraCtrl::RefreshNowCamera()
{
	if( !this->m_pcCarera[this->m_NowCamera] ) return;
	this->m_pcCarera[this->m_NowCamera]->Refresh();
}

void	CameraCtrl::RefreshProjection()
{
	D3DXMatrixPerspectiveFovLH(&m_PrjMat,m_fAngle,m_fAspect,m_fNear,m_fFar);	//vWFNVs̍쐬
	MCR_DEVICE->SetTransform(D3DTS_PROJECTION,&m_PrjMat);						//vWFNVsSet
}