﻿## Active Perl 5.8.8

use utf8;
use warnings;
use strict;
use Encode;
binmode STDOUT, ':encoding(cp932)'; $|=1;

my $DEBUG = 0;

&start('./');
exit 0;

sub start {
	my ($subDir) = @_;

	opendir DIR,$subDir  or die $!;
	my @files = readdir DIR;
	closedir DIR;

	foreach my $fileName (@files) {
		next if $fileName =~ m/^\./;
		next if $fileName =~ m/ /;
		next unless $fileName =~ m!\.htm$!;

		my $filePath = $subDir.$fileName;
		open FILE, '<:utf8', $filePath  or die "'$filePath' $!";
		read FILE, my $htm, -s FILE;
		my $mtime = (stat FILE)[9];
		close FILE;

		my $original = $htm;
		$_           = $htm;
#----------------------------------------------------------------------------
s/\bAncient Adena\b/古代のアデナ/gi;

s/\bNecropolis of Sacrifice\b/生贄のネクロポリス/gi;
s/\bPilgrims Necropolis\b/巡礼者のネクロポリス/gi;
s/\bThe Pilgrim's Necropolis\b/巡礼者のネクロポリス/gi;
s/\bWorshipers Necropolis\b/参拝者のネクロポリス/gi;
s/\bNecropolis of Worship\b/参拝者のネクロポリス/gi;
s/\bPatriots Necropolis\b/烈士のネクロポリス/gi;
s/\bThe Patriot's Necropolis\b/烈士のネクロポリス/gi;
s/\bAscetics Necropolis\b/苦行者のネクロポリス/gi;
s/\bNecropolis of Devotion\b/苦行者のネクロポリス/gi;
s/\bNecropolis of Martyrdom\b/殉教者のネクロポリス/gi;
s/\bMartyrs Necropolis\b/殉教者のネクロポリス/gi;
s/\bThe Saint's Necropolis\b/聖者のネクロポリス/gi;
s/\bSaints Necropolis\b/聖者のネクロポリス/gi;
s/\bThe Disciple's Necropolis\b/使徒のネクロポリス/gi;
s/\bDisciple's Necropolis\b/使徒のネクロポリス/gi;
s/\bDisciples Necropolis\b/使徒のネクロポリス/gi;

s/\bHeretics Catacomb\b/異端者のカタコム/gi;
s/\bThe Catacomb of the Heretic\b/異端者のカタコム/gi;
s/\bCatacomb of the Apostate\b/異教徒のカタコム/gi;
s/\bCatacomb of the Branded\b/烙印のカタコム/gi;
s/\bHeretics Catacomb\b/異端者のカタコム/gi;
s/\bCatacomb of the Witch\b/魔導のカタコム/gi;
s/\bCatacomb of Dark Omens\b/凶星のカタコム/gi;
s/\bCatacomb of the Forbidden Path\b/密界のカタコム/gi;
#----------------------------------------------------------------------------
		$htm = $_;

		if ($htm ne $original) {
			print $filePath,"\n";
			my $output = $filePath;
			   $output = $filePath.'.text' if $DEBUG;
			open FILE, '>:utf8', $output  or die "'$output' $!";
			$htm = "\x{feff}".$htm unless $htm =~ m/^\x{feff}/;  #BOM
			print FILE $htm;
			close FILE;
			utime $mtime,$mtime,$output;
		}
	}
}
