﻿## Active Perl 5.8.8

use utf8;
use warnings;
use strict;
use Encode;
binmode STDOUT, ':encoding(cp932)'; $|=1;

my $DEBUG = 0;

opendir DIR,'.'  or die $!;
my @files = readdir DIR;
closedir DIR;

foreach my $fileName (@files) {
	next if $fileName =~ m!^\.!;
	next unless $fileName =~ m!\.htm$!;

	open FILE, '<:utf8', $fileName  or die "'$fileName' $!";
	read FILE, my $htm, -s FILE;
	my $mtime = (stat FILE)[9];
	close FILE;

	my $original = $htm;
	$_           = $htm;
#----------------------------------------------------------------------------
s!(?<=[>;])Village Square(?=["<])!村の広場!gi;
s!(?<=[>;])East Gate Entrance(?=["<])!東門入口!gi;
s!(?<=[>;])West Gate Entrance(?=["<])!西門入口!gi;
s!(?<=[>;])South Gate Entrance(?=["<])!南門入口!gi;
s!(?<=[>;])North Gate Entrance(?=["<])!北門入口!gi;

s/ ?- ?(\d+) ?Adena/ - $1 Adena/gi;
s/ - 0 Adena//gi;
s/(\d+) Adena/$1 アデナ/gi;
#----------------------------------------------------------------------------
	$htm = $_;

	if ($htm ne $original) {
		print $fileName,"\n";
		my $output = $fileName;
		   $output = "$fileName.text" if $DEBUG;
		open FILE, '>:utf8', $output  or die "'$output' $!";
		$htm = "\x{feff}".$htm unless $htm =~ m/^\x{feff}/;  #BOM
		print FILE $htm;
		close FILE;
		utime $mtime,$mtime,$output;
	}
}
