use utf8;
use warnings;
use strict;
use Encode;

binmode STDOUT,':encoding(cp932)';$|=1;
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $JP_Path = 'door.csv.#JP-1057';
my $inpPath = 'door.csv';
my $outPath = 'door.csv.#DP-merge';

my %theHash;

print "open '$JP_Path'\n";
open FILE,'<', $JP_Path or die "'$JP_Path' $!";
while (not eof FILE) {
#	#name;static_object_id;posx;posy;posz;pos_minx;pos_miny;pos_minz;pos_maxx;pos_maxy;pos_maxz;hp;physical_defence;magic_defence;unlockable;level
#	aden_clanhall_001;24180022;145358;25385;-2090;0;0;0;0;0;0;158250;644;518;False;99
	my $record = <FILE>; chomp $record;
	my @rs = split /;/, $record;

	next if $#rs != 15;
	next if $rs[0] =~ m/^\s*#/;

	my $name = $rs[0];
	my $static_object_id = $rs[1];
	my $level = $rs[15];

	next if $level eq '99';

	$theHash{$name} = [$static_object_id,$level];
}
close FILE;

print "open '$inpPath'\n";
open FILE,'<', $inpPath or die "'$inpPath' $!";
print "open '$outPath'\n";
open OUTP,'>', $outPath or die "'$outPath' $!";
while (not eof FILE) {
	my $record = <FILE>; chomp $record;
	my @rs = split /;/, $record;

	if ($#rs == 14  && $rs[0] !~ m/^\s*#/) {
		my $name = $rs[0];
		my $static_object_id;
		my $level = '';
		if (exists($theHash{$name})) {
			($static_object_id,$level) = @{$theHash{$name}};
print "*\$name=[$name],\$static_object_id=[$static_object_id],\$level=[$level]\n";
			if ($static_object_id eq $rs[1]) {
				$record .= ";$level";
				print $record,"\n";
			}
		}
	}
	print OUTP $record,"\n";
}
close OUTP;
close FILE;
exit 0;
