﻿## Active Perl 5.8.8
# 注意>DBD-mysql を 4.005 以上にアップデートしてください。
# 注意>やりかた: ppm install http://theoryx5.uwinnipeg.ca/ppms/DBD-mysql.ppd

# *.htm 中のＮＰＣ名を一括して日本語化する.

#2008/12/08 DBD-mysql 4.005 以上
#2008/01/10 Kamael 対応

use utf8;
use strict;
use warnings;
use Encode;
use DBI;

binmode STDOUT,':encoding(cp932)'; $|=1;
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $vars_txt = 'tools/vars.txt';
open FILE,'<',$vars_txt  or do {warn "'$vars_txt' $!";exit 0};
read FILE,my $vars,-s FILE;
close FILE;
my $gsuser = ($vars =~ m/^@*set gsuser=(.+)$/m)[0];
my $gspass = ($vars =~ m/^@*set gspass=(.+)$/m)[0];
my $gsdb   = ($vars =~ m/^@*set gsdb=(.+)$/m)[0];
my $gshost = ($vars =~ m/^@*set gshost=(.+)$/m)[0];

my $DEBUG = 0; # 1 or 0

my $LogFile = UTF8(__FILE__);
   $LogFile =~ s!\.[^.\/\\]*$!.log!;
open LOG, '>:utf8', FS($LogFile)  or die "'$LogFile' $!";

my $db = DBI->connect("DBI:mysql:$gsdb:$gshost", $gsuser, $gspass, {mysql_enable_utf8=>1}) or do{warn DBI::errstr;exit 0};
   $db->do('SET NAMES UTF8');

&start('build/dist/gameserver/data/html/');
&start('build/dist/gameserver/data/scripts/');

close LOG;
exit 0;

sub start {
	my ($subDir) = @_;

	print ' [',$subDir,"]\n" if $DEBUG;
	opendir DIR, FS($subDir) or die "'$subDir' $!";
	my @files = readdir DIR; foreach (@files) { $_ = UTF8($_) }
	closedir DIR;

	foreach my $fileName (@files) {
		next if $fileName =~ m/^\./;
		next if $fileName =~ m/ /;
		my $filePath = $subDir.$fileName;

		if (-d FS($filePath)) {
			$filePath =~ s!^\.\/!!;
			&start($filePath.'/');
			next;

		} elsif ($fileName =~ /^([0-9]{5})\.htm$/
		      || $fileName =~ /^([0-9]{5})-.+\.htm$/) {
			my $id = $1;	# Ex. '30001-1.htm' => $id='30001'

			my $outPath = $filePath;
			   $outPath .= '.text' if $DEBUG;

			print "  $filePath\n" if $DEBUG;
			open FILE, '<:utf8', FS($filePath) or die;
			my $mtime = (stat FILE)[9];
			read FILE,my $text,-s FILE;
			close FILE;

			if ($text =~ m/(<body>)([^<>\r\n]+?)(:<br>)/) {
				# <body>Title and Name:<br>
				# |-$1-||-----$2-----||-$3-|
				my $text0   = $`.$1;
				my $name_en = $2;
				my $text2   = $3.$';
				next if $name_en eq '%npcname%';

				my $name_jp = &getName($id);
				next unless $name_jp;
				next if $name_jp eq $name_en;

				my $tmp1 = $name_jp; $tmp1 =~ s/\s//g;
				my $tmp2 = $name_en; $tmp2 =~ s/\s//g;
				next if $tmp1 eq $tmp2;

				$text = $text0.$name_jp.$text2;

				open FILE, '>:utf8', FS($outPath) or die;
				print FILE "\x{feff}" unless $text =~ m/\x{feff}/; #BOM
				print FILE $text;
				close FILE;
				utime $mtime, $mtime, FS($outPath);

				print '●',$outPath,"(1)\n";
				print     "\t[",$name_en,"]\n";
				print     "\t[",$name_jp,"]\n";
				print LOG  $outPath,"(1)\n";
				print LOG "\t[",$name_en,"]\n";
				print LOG "\t[",$name_jp,"]\n";
			}

		}
	}
}

sub getName {
	my ($id) = @_;

	my $sql = "SELECT name,title FROM npcname_ja WHERE id=?";
	my $sth = $db->prepare($sql);
	$sth->execute($id) or die DBI::errstr;
	$sth->bind_columns(undef, \(my($N_name,$N_title))) or die DBI::errstr;
	my $rc = $sth->fetch();

	return '' unless $N_name;
	if ($N_title) {
		# タイトルと名前をくっつける #
		if ($N_title =~ m/[\x{30A1}-\x{30ff}]$/
		 && $N_name =~ m/^[\x{30A1}-\x{30ff}]/) {
			#カタカナ+カタカナ連続するときは、空白入れる
		 	return $N_title.' '.$N_name;
		} elsif ($N_title =~ m/ /
		      || $N_name  =~ m/ /) {
			#タイトルか名前に空白ありのときは、空白入れる
		 	return $N_title.' '.$N_name;
		} else {
		 	return $N_title.$N_name;
		}
	}
	return $N_name;
}
