use warnings;
use strict;

&start('../datapack_development/build.xml');
&start('../L2_GameServer/build.xml');
#&start('../L2J_JP/build.xml');

exit;

sub start($)
{
	my ($buildxml) = @_;
##	print '-'x72,"\n";
	print $buildxml,"\n";
##	print '-'x72,"\n";

	my $modify = 0;

	open IN, '<', $buildxml  or die;
	my @xml = <IN>;
	close IN;

	foreach my $line (@xml) {
		if ($line =~ m|<copy [^>]*>$|
		 && $line !~ m| preservelastmodified="true">$|) {
			print '- ',$line;
			$line =~ s|>$| preservelastmodified="true">|;
			print '+ ',$line;
			$modify = 1;
		}
	}

	my $xml = join '', @xml;

if (0) {{
	if ($xml =~ s|<(zip [^>]*/)>|<!--$1-->|sg) {
		print "* zip...\n";
		$modify = 1;
	}
}}

#|	if ($xml =~ s|<delete dir="\$\{build.classes\}"/>|<delete dir="\${build}"/>|g) {
#|		print "* clean...\n";
#|		$modify = 1;
#|	}

##	if ($xml =~ s|(^[ \t]*<exclude name="\.project"/>$)|$1<!-- -->
	if ($xml =~ s|(^[ \t]*<fileset dir="\$\{basedir\}/data">$)|$1<!-- -->
<exclude name="**/.*"/>
<exclude name="**/.*/"/>
<exclude name="**/*.BAK"/>
<exclude name="**/*.bak"/>
<exclude name="**/#*"/>
<exclude name="**/*.#*"/>|mg) {
		print "* exclude '.*'\n";
		$modify = 1;
	}
	if ($xml =~ s|^([ \t]*<fileset dir="\$\{basedir\}/sql">$)|$1<!-- -->
<include name="lang/ja/*.*"/>|mg) {
		print "* include lang/ja/*.*\n";
		$modify = 1;
	}

	if ($xml =~ s|<exclude name="build.xml"/>|<exclude name="build*.*"/>
<exclude name="ant_*.*"/>|g) {
		print "* exclude build*.*\n";
		$modify = 1;
	}

	# OK - "../MyProject/yavac/yavac.exe"
	# OK - "../yavac.exe"
	# NG - "./yavac.exe"
	if ($xml =~ s|^([\t ]*?)(<javac [^>]+")>$|$1$2
$1	fork="yes" executable="../MyProject/yavac/yavac.exe"><!-- -->|m) {
		print "* <javac fork=yes executable=yavac>\n";
		$modify = 1;
	}

	if ($xml =~ s|(<target name="dist"\s*depends="export)"|$1,language"|s) {
		print "* TextBuilder-PATCH\n";
		$modify = 1;
	}

	if ($modify) {
		open OUT, '>', $buildxml  or die;
#		open OUT, '>', $buildxml.'-TEST.txt'  or die;
		print OUT $xml;
		close OUT;
	}
}
