/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package net.sf.l2j.gameserver.network.clientpackets;

import java.util.logging.Logger;

import net.sf.l2j.Config;
import net.sf.l2j.gameserver.GameTimeController;
import net.sf.l2j.gameserver.ThreadPoolManager;
import net.sf.l2j.gameserver.handler.IItemHandler;
import net.sf.l2j.gameserver.handler.ItemHandler;
import net.sf.l2j.gameserver.instancemanager.CastleManager;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Clan;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.actor.instance.L2PcInstance;
import net.sf.l2j.gameserver.model.base.Race;
import net.sf.l2j.gameserver.model.itemcontainer.Inventory;
import net.sf.l2j.gameserver.network.SystemMessageId;
import net.sf.l2j.gameserver.network.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.network.serverpackets.ItemList;
import net.sf.l2j.gameserver.network.serverpackets.ShowCalculator;
import net.sf.l2j.gameserver.network.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.templates.item.L2Armor;
import net.sf.l2j.gameserver.templates.item.L2ArmorType;
import net.sf.l2j.gameserver.templates.item.L2Item;
import net.sf.l2j.gameserver.templates.item.L2Weapon;
import net.sf.l2j.gameserver.templates.item.L2WeaponType;
import net.sf.l2j.gameserver.util.FloodProtector;

/**
 * This class ...
 *
 * @version $Revision: 1.18.2.7.2.9 $ $Date: 2005/03/27 15:29:30 $
 */
public final class UseItem extends L2GameClientPacket
{
	private static Logger _log = Logger.getLogger(UseItem.class.getName());
	private static final String _C__14_USEITEM = "[C] 14 UseItem";

	private int _objectId;

	/** Weapon Equip Task */
	public class WeaponEquipTask implements Runnable
	{
		L2ItemInstance item;
		L2PcInstance activeChar;
		public WeaponEquipTask(L2ItemInstance it, L2PcInstance character){
			item = it;
			activeChar = character;
		}
		public void run()
		{
			//If character is still engaged in strike we should not change weapon
			if (activeChar.isAttackingNow())
				return;
            // Equip or unEquip
			activeChar.useEquippableItem(item, false);
		}
	}	
	
	@Override
	protected void readImpl()
	{
		_objectId = readD();
	}

	@Override
	protected void runImpl()
	{

		L2PcInstance activeChar = getClient().getActiveChar();

		if (activeChar == null)
            return;

		// Flood protect UseItem
		if (!FloodProtector.getInstance().tryPerformAction(activeChar.getObjectId(), FloodProtector.PROTECTED_USEITEM))
			return;

		if (activeChar.getPrivateStoreType() != 0)
		{
			activeChar.sendPacket(new SystemMessage(SystemMessageId.CANNOT_TRADE_DISCARD_DROP_ITEM_WHILE_IN_SHOPMODE));
			activeChar.sendPacket(ActionFailed.STATIC_PACKET);
			return;
		}
		
		if (activeChar.getActiveTradeList() != null)
			activeChar.cancelActiveTrade();

		// NOTE: disabled due to deadlocks
		// synchronized (activeChar.getInventory())
		// 	{
			L2ItemInstance item = activeChar.getInventory().getItemByObjectId(_objectId);

			if (item == null)
                return;

			if (item.isWear())
			{
				// No unequipping wear-items
				return;
			}
            if (item.getItem().getType2() == L2Item.TYPE2_QUEST)
            {
                SystemMessage sm = new SystemMessage(SystemMessageId.CANNOT_USE_QUEST_ITEMS);
                activeChar.sendPacket(sm);
                sm = null;
                return;
            }
			int itemId = item.getItemId();
			/*
			 * Alt game - Karma punishment // SOE
			 * 736  	Scroll of Escape
			 * 1538  	Blessed Scroll of Escape
			 * 1829  	Scroll of Escape: Clan Hall
			 * 1830  	Scroll of Escape: Castle
			 * 3958  	L2Day - Blessed Scroll of Escape
			 * 5858  	Blessed Scroll of Escape: Clan Hall
			 * 5859  	Blessed Scroll of Escape: Castle
			 * 6663  	Scroll of Escape: Orc Village
			 * 6664  	Scroll of Escape: Silenos Village
			 * 7117  	Scroll of Escape to Talking Island
			 * 7118  	Scroll of Escape to Elven Village
			 * 7119  	Scroll of Escape to Dark Elf Village
			 * 7120  	Scroll of Escape to Orc Village
			 * 7121  	Scroll of Escape to Dwarven Village
			 * 7122  	Scroll of Escape to Gludin Village
			 * 7123  	Scroll of Escape to the Town of Gludio
			 * 7124  	Scroll of Escape to the Town of Dion
			 * 7125  	Scroll of Escape to Floran
			 * 7126  	Scroll of Escape to Giran Castle Town
			 * 7127  	Scroll of Escape to Hardin's Private Academy
			 * 7128  	Scroll of Escape to Heine
			 * 7129  	Scroll of Escape to the Town of Oren
			 * 7130  	Scroll of Escape to Ivory Tower
			 * 7131  	Scroll of Escape to Hunters Village
			 * 7132  	Scroll of Escape to Aden Castle Town
			 * 7133  	Scroll of Escape to the Town of Goddard
			 * 7134  	Scroll of Escape to the Rune Township
			 * 7135  	Scroll of Escape to the Town of Schuttgart.
			 * 7554  	Scroll of Escape to Talking Island
			 * 7555  	Scroll of Escape to Elven Village
			 * 7556  	Scroll of Escape to Dark Elf Village
			 * 7557  	Scroll of Escape to Orc Village
			 * 7558  	Scroll of Escape to Dwarven Village
			 * 7559  	Scroll of Escape to Giran Castle Town
			 * 7618  	Scroll of Escape - Ketra Orc Village
			 * 7619  	Scroll of Escape - Varka Silenos Village
			 * 10129    Scroll of Escape : Fortress
			 * 10130    Blessed Scroll of Escape : Fortress
			 */
			if (!Config.ALT_GAME_KARMA_PLAYER_CAN_TELEPORT && activeChar.getKarma() > 0
				&& (itemId == 736 || itemId == 1538 || itemId == 1829 || itemId == 1830
				|| itemId == 3958 || itemId == 5858 || itemId == 5859 || itemId == 6663
				|| itemId == 6664 || (itemId >= 7117 && itemId <= 7135)
				|| (itemId >= 7554 && itemId <= 7559) || itemId == 7618 || itemId == 7619
				|| itemId == 10129 || itemId == 10130))
				return;


           L2Clan cl = activeChar.getClan();
            //A shield that can only be used by the members of a clan that owns a castle.
           if ((cl == null||cl.getHasCastle() == 0) && itemId == 7015 && Config.CASTLE_SHIELD)
           {
               SystemMessage sm = new SystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
               activeChar.sendPacket(sm);
               sm = null;
               return;
           }

           //A shield that can only be used by the members of a clan that owns a clan hall.
           if ((cl == null|| cl.getHasHideout() == 0) && itemId == 6902 && Config.CLANHALL_SHIELD)
           {
               SystemMessage sm = new SystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
               activeChar.sendPacket(sm);
               sm = null;
               return;
           }
           
           //Apella armor used by clan members may be worn by a Baron or a higher level Aristocrat.
           if ((itemId >=7860 && itemId <=7879) && Config.APELLA_ARMORS && (cl == null||activeChar.getPledgeClass() < 5))
           {
               SystemMessage sm = new SystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
               activeChar.sendPacket(sm);
               sm = null;
               return;
           }

           //Clan Oath armor used by all clan members
           if ((itemId >=7850 && itemId <=7859) && Config.OATH_ARMORS && (cl == null))
           {
               SystemMessage sm = new SystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
               activeChar.sendPacket(sm);
               sm = null;
               return;
           }

           //The Lord's Crown used by castle lords only
           if (itemId ==6841 && Config.CASTLE_CROWN && (cl == null||(cl.getHasCastle() == 0||!activeChar.isClanLeader())))
           {
               SystemMessage sm = new SystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
               activeChar.sendPacket(sm);
               sm = null;
               return;
           }

           //Castle circlets used by the members of a clan that owns a castle, academy members are excluded.
           if (Config.CASTLE_CIRCLETS &&((itemId >= 6834 && itemId <= 6840)||itemId == 8182||itemId == 8183))
           {
               if (cl ==null)
               {
                   SystemMessage sm = new SystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
                   activeChar.sendPacket(sm);
                   sm = null;
                   return;
               }
               else
               {
                   int circletId = CastleManager.getInstance().getCircletByCastleId(cl.getHasCastle());
                   if (activeChar.getPledgeType() == -1||circletId != itemId)
                   {
                       SystemMessage sm = new SystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
                       activeChar.sendPacket(sm);
                       sm = null;
                       return;
                   }
               }
           }

			// Items that cannot be used
			if (itemId == 57)
                return;
            
            if (activeChar.isFishing() && (itemId < 6535 || itemId > 6540))
            {
                // You cannot do anything else while fishing
                SystemMessage sm = new SystemMessage(SystemMessageId.CANNOT_DO_WHILE_FISHING_3);
                getClient().getActiveChar().sendPacket(sm);
                sm = null;
                return;
            }

			// Char cannot use item when dead
			if (activeChar.isDead())
			{
				SystemMessage sm = new SystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
				sm.addItemName(item);
				getClient().getActiveChar().sendPacket(sm);
				sm = null;
				return;
			}

			// Char cannot use pet items
			if ((item.getItem() instanceof L2Armor && item.getItem().getItemType() == L2ArmorType.PET)
					 || (item.getItem() instanceof L2Weapon && item.getItem().getItemType() == L2WeaponType.PET) )
			{
				SystemMessage sm = new SystemMessage(SystemMessageId.CANNOT_EQUIP_PET_ITEM); // You cannot equip a pet item.
				sm.addItemName(item);
				getClient().getActiveChar().sendPacket(sm);
				sm = null;
				return;
			}

			if (Config.DEBUG)
                _log.finest(activeChar.getObjectId() + ": use item " + _objectId);

			if (item.isEquipable())
			{
//				// [L2J_JP ADD START]
//				if (activeChar.isCastingNow())
//				{
//					ThreadPoolManager.getInstance().scheduleAi(new WaitActionEndTask(), activeChar.getCastEndTimeLeftMili());
////					ThreadPoolManager.getInstance().scheduleAi(new WaitActionEndTask(), (activeChar.getCastEndTime() - GameTimeController.getGameTicks()) * GameTimeController.MILLIS_IN_TICK);
//					activeChar.sendPacket(ActionFailed.STATIC_PACKET);
//					return;
//				}
//				
//				if (activeChar.isAttackingNow())
//				{
//					ThreadPoolManager.getInstance().scheduleAi(new WaitActionEndTask(), (activeChar.getAttackEndTime() - GameTimeController.getGameTicks()) * GameTimeController.MILLIS_IN_TICK);
//					activeChar.sendPacket(ActionFailed.STATIC_PACKET);
//					return;
//				}
//				// [L2J_JP ADD END]
//        		
				// No unequipping/equipping while the player is in special conditions
				if (activeChar.isStunned() || activeChar.isSleeping() || activeChar.isParalyzed()
						|| activeChar.isAlikeDead())
				{
					activeChar.sendMessage("Your status does not allow you to do that.");
					return;
				}

                switch (item.getItem().getBodyPart())
                {
                    case L2Item.SLOT_LR_HAND:
                    case L2Item.SLOT_L_HAND:
                    case L2Item.SLOT_R_HAND:
                    {
                        // Prevent player to remove the weapon on special conditions
                    	if (activeChar.isCastingNow() || activeChar.isCastingSimultaneouslyNow())
                    	{
                    		activeChar.sendPacket(new SystemMessage(SystemMessageId.CANNOT_USE_ITEM_WHILE_USING_MAGIC));
                    		return;
                    	}
                    	
                        if (activeChar.isMounted())
                        	return;
                        
                       
                        if (activeChar.isDisarmed())
                        {
                            activeChar.sendPacket(new SystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION));
                            return;
                        }
                        
                        // Don't allow weapon/shield equipment if a cursed weapon is equiped
                        if (activeChar.isCursedWeaponEquipped())
                        {
                            return;
                        }
                        
                        // Don't allow weapon/shield hero equipment during Olympiads
                        if (activeChar.isInOlympiadMode() && (item.isHeroItem() || item.isOlyRestrictedItem()))
                        {
                            activeChar.sendPacket(new SystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION));
                            return;
                        }
                        
                        // Don't allow other Race to Wear Kamael exclusive Weapons.
                        if (!item.isEquipped() && item.getItem() instanceof L2Weapon && !activeChar.isGM())
                        {
                            L2Weapon wpn = (L2Weapon)item.getItem();
                            
                            switch (activeChar.getRace())
                            {
                                case Kamael:
                                {
                                    switch (wpn.getItemType())
                                    {
                                        case NONE:
                                            activeChar.sendPacket(new SystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION));
                                            return;
                                    }
                                    break;
                                }
                                case Human:
                                case Dwarf:
                                case Elf:
                                case DarkElf:
                                case Orc:
                                {
                                    switch (wpn.getItemType())
                                    {
                                        case RAPIER:
                                        case CROSSBOW:
                                        case ANCIENT_SWORD:
                                            activeChar.sendPacket(new SystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION));
                                            return;
                                    }
                                    break;
                                }
                            }
                        }
                        break;
                    }
                    case L2Item.SLOT_CHEST:
                    case L2Item.SLOT_BACK:
                    case L2Item.SLOT_GLOVES:
                    case L2Item.SLOT_FEET:
                    case L2Item.SLOT_HEAD:
                    case L2Item.SLOT_FULL_ARMOR:
                    case L2Item.SLOT_LEGS:
                    {
                        if (activeChar.getRace() == Race.Kamael &&
                                (item.getItem().getItemType() == L2ArmorType.HEAVY
                                        ||item.getItem().getItemType() == L2ArmorType.MAGIC))
                        {
                            activeChar.sendPacket(new SystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION));
                            return;
                        }
                        break;
                    }
                    //Race circlets can be used only if your race is matching.
                    case L2Item.SLOT_HAIRALL:
                    {
                    	if (itemId >= 9391 && itemId <= 9396)
                    	{
                    		switch (activeChar.getRace())
                    		{
                    			case Kamael:
                    			{
                    				if (itemId != 9396)
                    				{
                    					activeChar.sendPacket(new SystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION));
                    					return;
                    				}
                    				break;
                    			}
                    			case Human:
                    			{
                    				if (itemId != 9391)
                    				{
                    					activeChar.sendPacket(new SystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION));
                    					return;
                    				}
                    				break;
                    			}
                    			case Dwarf:
                    			{
                    				if (itemId != 9395)
                    				{
                    					activeChar.sendPacket(new SystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION));
                    					return;
                    				}
                    				break;
                    			}
                    			case Elf:
                    			{
                    				if (itemId != 9392)
                    				{
                    					activeChar.sendPacket(new SystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION));
                    					return;
                    				}
                    				break;
                    			}
                    			case DarkElf:
                    			{
                    				if (itemId != 9393)
                    				{
                    					activeChar.sendPacket(new SystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION));
                    					return;
                    				}
                    				break;
                    			}
                    			case Orc:
                    			{
                    				if (itemId != 9394)
                    				{
                    					activeChar.sendPacket(new SystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION));
                    					return;
                    				}
                    				break;
                    			}
                    		}
                    	}
                        break;
                    }
                    case L2Item.SLOT_L_BRACELET:
                    {
                    	SystemMessage sm = new SystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
                    	if ((itemId >= 9605 && itemId <= 9615) || itemId == 10018)
                    	{
                    		if (activeChar.getClan()!= null)
                    		{
                    			switch (itemId)
                    			{
                    				case 9605:
                    					if (activeChar.getClan().getHasHideout() != 62)
                    					{
                                            activeChar.sendPacket(sm);
                                            return;
                    					}
                    					break;
                    				case 9606:
                    					if (activeChar.getClan().getHasHideout() != 63)
                    					{
                                            activeChar.sendPacket(sm);
                                            return;
                    					}
                    					break;
                    				case 9607:
                    					if (activeChar.getClan().getHasCastle() != 1)
                    					{
                                            activeChar.sendPacket(sm);
                                            return;
                    					}
                    					break;
                    				case 9608:
                    					if (activeChar.getClan().getHasCastle() != 2)
                    					{
                                            activeChar.sendPacket(sm);
                                            return;
                    					}
                    					break;
                    				case 9609:
                    					if (activeChar.getClan().getHasCastle() != 3)
                    					{
                                            activeChar.sendPacket(sm);
                                            return;
                    					}
                    					break;
                    				case 9610:
                    					if (activeChar.getClan().getHasCastle() != 4)
                    					{
                                            activeChar.sendPacket(sm);
                                            return;
                    					}
                    					break;
                    				case 9611:
                    					if (activeChar.getClan().getHasCastle() != 5)
                    					{
                                            activeChar.sendPacket(sm);
                                            return;
                    					}
                    					break;
                    				case 9612:
                    					if (activeChar.getClan().getHasCastle() != 6)
                    					{
                                            activeChar.sendPacket(sm);
                                            return;
                    					}
                    					break;
                    				case 9613:
                    					if (activeChar.getClan().getHasCastle() != 7)
                    					{
                                            activeChar.sendPacket(sm);
                                            return;
                    					}
                    					break;
                    				case 9614:
                    					if (activeChar.getClan().getHasCastle() != 8)
                    					{
                                            activeChar.sendPacket(sm);
                                            return;
                    					}
                    					break;
                    				case 9615:
                    					if (activeChar.getClan().getHasCastle() != 9)
                    					{
                                            activeChar.sendPacket(sm);
                                            return;
                    					}
                    					break;
                    				case 10018:
                    					if (activeChar.getClan().getHasFort() == 0)
                    					{
                                            activeChar.sendPacket(sm);
                                            return;
                    					}
                    					break;
                    			}
                    		}
                    		else
                    		{
                                activeChar.sendPacket(sm);
                                return;
                    		}
                    	}
                    	break;
                    }
                    case L2Item.SLOT_DECO:
                    {
                        if (!item.isEquipped() && activeChar.getInventory().getMaxTalismanCount() == 0)
                        {
                            activeChar.sendPacket(new SystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION));
                            return;
                        }
                    }
                }
                
                if (activeChar.isCursedWeaponEquipped() && itemId == 6408) // Don't allow to put formal wear
                {
                    return;
                }
                if (activeChar.isAttackingNow()){
                	ThreadPoolManager.getInstance().scheduleGeneral( new WeaponEquipTask(item,activeChar), (activeChar.getAttackEndTime()-GameTimeController.getGameTicks())*GameTimeController.MILLIS_IN_TICK);
                	return;
                }

                // Equip or unEquip
                activeChar.useEquippableItem(item, true);

//
// L2J_JP r1057 -->> L2J r2420 }[W̍ssB
//    v̂vȂ̂Aǂɑ}΂̂sBƂ肠֒uĂB
//     activeChar.useEquippableItem(...) 𒲂ׂĂ݂ƂB
//
//            //sm = null;
//
//            //activeChar.refreshExpertisePenalty();
//
//				/* [L2J_JP EDIT]
//				if (item.getItem().getType2() == L2Item.TYPE2_WEAPON)
//					activeChar.CheckIfWeaponIsAllowed();*/
//
//				InventoryUpdate iu = new InventoryUpdate();
//				iu.addItems(Arrays.asList(items));
//				activeChar.sendPacket(iu);
//				// [L2J_JP DEL - Shibainu]
//				//activeChar.abortAttack();
//				activeChar.broadcastUserInfo();
//
			}
			else
			{
                L2Weapon weaponItem = activeChar.getActiveWeaponItem();
                int itemid = item.getItemId();
				//_log.finest("item not equipable id:"+ item.getItemId());
                if (itemid == 4393)
                {
                        activeChar.sendPacket(new ShowCalculator(4393));
                }
                else if ((weaponItem != null && weaponItem.getItemType() == L2WeaponType.ROD)
                    && ((itemid >= 6519 && itemid <= 6527) || (itemid >= 7610 && itemid <= 7613) || (itemid >= 7807 && itemid <= 7809) || (itemid >= 8484 && itemid <= 8486) || (itemid >= 8505 && itemid <= 8513)))
                {
                    activeChar.getInventory().setPaperdollItem(Inventory.PAPERDOLL_LHAND, item);
                    activeChar.broadcastUserInfo();
                    // Send a Server->Client packet ItemList to this L2PcINstance to update left hand equipement
                    ItemList il = new ItemList(activeChar, false);
                    sendPacket(il);
                    return;
                }
				else
				{
					IItemHandler handler = ItemHandler.getInstance().getItemHandler(item.getItemId());

					if (handler == null)
					{
						if (Config.DEBUG)
							_log.warning("No item handler registered for item ID " + item.getItemId() + ".");
					}
					else
                        handler.useItem(activeChar, item);
				}
			}
//		}
	}

	@Override
	public String getType()
	{
		return _C__14_USEITEM;
	}

//	// [L2J_JP ADD START]
//	// Task of wait to end action
//	public class WaitActionEndTask implements Runnable
//    {
//        public void run()
//        {
//            try
//            {
//                runImpl();
//            }
//            catch (Throwable t)
//            {
//                System.err.println("Error in WaitActionEndTask.");
//                t.printStackTrace();
//            }
//        }
//    }
//	// [L2J_JP ADD END]
}
