/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.Set;
import javolution.context.ObjectFactory;
import javolution.lang.Reusable;
import javolution.util.FastCollection;
import javolution.util.FastComparator;
import javolution.util.FastMap;

public class FastSet<E>
extends FastCollection<E>
implements Set<E>,
Reusable {
    private static final ObjectFactory FACTORY = new ObjectFactory(){

        public Object create() {
            return new FastSet();
        }

        public void cleanup(Object object) {
            ((FastSet)object).reset();
        }
    };
    private transient FastMap _map;
    private static final long serialVersionUID = 1L;

    public FastSet() {
        this(new FastMap());
    }

    public FastSet(String string) {
        this(new FastMap(string));
    }

    public FastSet(int n) {
        this(new FastMap(n));
    }

    public FastSet(Set<? extends E> set) {
        this(new FastMap(set.size()));
        this.addAll(set);
    }

    private FastSet(FastMap fastMap) {
        this._map = fastMap;
    }

    public static <E> FastSet<E> newInstance() {
        return (FastSet)FACTORY.object();
    }

    public static void recycle(FastSet fastSet) {
        FACTORY.recycle(fastSet);
    }

    @Override
    public final int size() {
        return this._map.size();
    }

    @Override
    public final boolean add(E e) {
        return this._map.put(e, e) == null;
    }

    @Override
    public Iterator<E> iterator() {
        return this._map.keySet().iterator();
    }

    @Override
    public Set<E> unmodifiable() {
        return (Set)super.unmodifiable();
    }

    @Override
    public final void clear() {
        this._map.clear();
    }

    @Override
    public final boolean contains(Object object) {
        return this._map.containsKey(object);
    }

    @Override
    public final boolean remove(Object object) {
        return this._map.remove(object) != null;
    }

    public FastSet<E> setValueComparator(FastComparator<? super E> fastComparator) {
        this._map.setKeyComparator(fastComparator);
        return this;
    }

    @Override
    public FastComparator<? super E> getValueComparator() {
        return this._map.getKeyComparator();
    }

    @Override
    public void reset() {
        this._map.reset();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        FastComparator fastComparator = (FastComparator)objectInputStream.readObject();
        int n = objectInputStream.readInt();
        this._map = new FastMap(n);
        this.setValueComparator(fastComparator);
        int n2 = n;
        while (n2-- != 0) {
            Object object = objectInputStream.readObject();
            this._map.put(object, object);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.getValueComparator());
        objectOutputStream.writeInt(this.size());
        FastCollection.Record record = this._map.head();
        FastMap.Entry entry = this._map.tail();
        while ((record = ((FastMap.Entry)record).getNext()) != entry) {
            objectOutputStream.writeObject(((FastMap.Entry)record).getKey());
        }
    }

    @Override
    public final FastCollection.Record head() {
        return this._map.head();
    }

    @Override
    public final FastCollection.Record tail() {
        return this._map.tail();
    }

    @Override
    public final E valueOf(FastCollection.Record record) {
        return (E)((FastMap.Entry)record).getKey();
    }

    @Override
    public final void delete(FastCollection.Record record) {
        this._map.remove(((FastMap.Entry)record).getKey());
    }
}

