/*
 * Decompiled with CFR 0.152.
 */
package javolution.lang;

import java.io.File;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javolution.lang.Reflection;
import javolution.util.StandardLog;

public class ClassInitializer {
    private ClassInitializer() {
    }

    public static void initializeAll() {
        ClassInitializer.initializeRuntime();
        ClassInitializer.initializeClassPath();
    }

    public static void initializeRuntime() {
        String string = System.getProperty("sun.boot.class.path");
        String string2 = System.getProperty("path.separator");
        if (string == null || string2 == null) {
            StandardLog.warning("Cannot initialize boot path through system properties");
            return;
        }
        ClassInitializer.initialize(string, string2);
        String string3 = System.getProperty("java.home");
        String string4 = System.getProperty("file.separator");
        if (string3 == null || string4 == null) {
            StandardLog.warning("Cannot initialize extension library through system properties");
            return;
        }
        File file = new File(string3 + string4 + "lib" + string4 + "ext");
        if (!file.getClass().getName().equals("java.io.File")) {
            StandardLog.warning("Extension classes initialization not supported for J2ME build");
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                String string5 = fileArray[i].getPath();
                if (!string5.endsWith(".jar") && !string5.endsWith(".zip")) continue;
                ClassInitializer.initializeJar(string5);
            }
        } else {
            StandardLog.warning(file + " is not a directory");
        }
    }

    public static void initializeClassPath() {
        String string = System.getProperty("java.class.path");
        String string2 = System.getProperty("path.separator");
        if (string == null || string2 == null) {
            StandardLog.warning("Cannot initialize classpath through system properties");
            return;
        }
        ClassInitializer.initialize(string, string2);
    }

    private static void initialize(String string, String string2) {
        StandardLog.fine("Initialize classpath: " + string);
        while (string.length() > 0) {
            String string3;
            int n = string.indexOf(string2);
            if (n < 0) {
                string3 = string;
                string = "";
            } else {
                string3 = string.substring(0, n);
                string = string.substring(n + string2.length());
            }
            if (string3.endsWith(".jar") || string3.endsWith(".zip")) {
                ClassInitializer.initializeJar(string3);
                continue;
            }
            ClassInitializer.initializeDir(string3);
        }
    }

    public static void initialize(Class clazz) {
        try {
            Reflection.getClass(clazz.getName());
        }
        catch (Throwable throwable) {
            StandardLog.error(throwable);
        }
    }

    public static void initialize(String string) {
        try {
            Reflection.getClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            StandardLog.warning("Class + " + string + " not found");
        }
        catch (Throwable throwable) {
            StandardLog.error(throwable);
        }
    }

    public static void initializeJar(String string) {
        try {
            StandardLog.fine("Initialize Jar file: " + string);
            ZipFile zipFile = new ZipFile(string);
            if (!zipFile.getClass().getName().equals("java.util.zip.ZipFile")) {
                StandardLog.warning("Initialization of classes in jar file not supported for J2ME build");
                return;
            }
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string2 = zipEntry.getName();
                if (!string2.endsWith(".class")) continue;
                String string3 = string2.substring(0, string2.length() - 6);
                string3 = string3.replace('/', '.');
                StandardLog.finer("Initialize " + string3);
                ClassInitializer.initialize(string3);
            }
        }
        catch (Exception exception) {
            StandardLog.error(exception);
        }
    }

    public static void initializeDir(String string) {
        StandardLog.fine("Initialize Directory: " + string);
        File file = new File(string);
        if (!file.getClass().getName().equals("java.io.File")) {
            StandardLog.warning("Initialization of classes in directory not supported for J2ME build");
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                ClassInitializer.initialize("", fileArray[i]);
            }
        } else {
            StandardLog.warning(string + " is not a directory");
        }
    }

    private static void initialize(String string, File file) {
        String string2 = file.getName();
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            String string3 = string.length() == 0 ? string2 : string + "." + string2;
            for (int i = 0; i < fileArray.length; ++i) {
                ClassInitializer.initialize(string3, fileArray[i]);
            }
        } else if (string2.endsWith(".class")) {
            String string4 = string + "." + string2.substring(0, string2.length() - 6);
            StandardLog.finer("Initialize " + string4);
            ClassInitializer.initialize(string4);
        }
    }
}

