/*
 * Decompiled with CFR 0.152.
 */
package javolution;

import javolution.context.ArrayFactory;
import javolution.context.ConcurrentContext;
import javolution.context.LocalContext;
import javolution.context.ObjectFactory;
import javolution.context.StackContext;
import javolution.lang.MathLib;
import javolution.testing.TestCase;
import javolution.testing.TestContext;
import javolution.testing.TestSuite;
import javolution.text.TextBuilder;
import javolution.util.FastTable;
import javolution.util.Index;

public final class ContextTestSuite
extends TestSuite {
    @Override
    public void run() {
        TestContext.info("-------------------------------------------------");
        TestContext.info("-- Test Suite for package javolution.context.* --");
        TestContext.info("-------------------------------------------------");
        int n = ConcurrentContext.getConcurrency();
        TestContext.test(new Concurrency(10000, 0));
        TestContext.test(new Concurrency(10000, n));
        TestContext.info("");
        TestContext.test(new SmallObjectAllocation(1000, false));
        TestContext.test(new SmallObjectAllocation(1000, true));
        TestContext.info("");
        TestContext.test(new ArrayAllocation(4096, false));
        TestContext.test(new ArrayAllocation(4096, true));
        TestContext.info("");
    }

    public static class ArrayAllocation
    extends TestCase {
        int _size;
        boolean _recycle;
        char[] _array;

        public ArrayAllocation(int n, boolean bl) {
            this._size = n;
            this._recycle = bl;
        }

        @Override
        public CharSequence getDescription() {
            if (this._recycle) {
                return TextBuilder.newInstance().append("Recycled - ArrayFactory.CHARS_FACTORY.array(").append(this._size).append(")");
            }
            return TextBuilder.newInstance().append("HeapContext (default)            - new char[").append(this._size).append("]");
        }

        @Override
        public void execute() {
            if (this._recycle) {
                this._array = ArrayFactory.CHARS_FACTORY.array(this._size);
                ArrayFactory.CHARS_FACTORY.recycle(this._array);
            } else {
                this._array = new char[this._size];
            }
        }

        @Override
        public void validate() {
            TestContext.assertTrue(this._array.length >= this._size);
        }
    }

    public static class SmallObjectAllocation
    extends TestCase {
        int _size;
        boolean _useStack;
        XYZ c0;
        XYZ c1;

        public SmallObjectAllocation(int n, boolean bl) {
            this._size = n;
            this._useStack = bl;
        }

        @Override
        public CharSequence getDescription() {
            return TextBuilder.newInstance().append(!this._useStack ? "HeapContext (default) - Create " : "StackContext            Create ").append(this._size).append(" small objects");
        }

        @Override
        public void prepare() {
            this.c0 = new XYZ(0.0, 0.0, 0.0);
            this.c1 = new XYZ(-1.0, 1.0, 0.0);
            StackContext.enter();
        }

        @Override
        public void execute() {
            if (this._useStack) {
                for (int i = 0; i < this._size; ++i) {
                    XYZ xYZ = this.c1.plusStack(this.c0);
                    this.c0 = this.c1;
                    this.c1 = xYZ;
                }
            } else {
                for (int i = 0; i < this._size; ++i) {
                    XYZ xYZ = this.c1.plusHeap(this.c0);
                    this.c0 = this.c1;
                    this.c1 = xYZ;
                }
            }
        }

        @Override
        public int count() {
            return this._size;
        }

        @Override
        public void cleanup() {
            StackContext.exit();
        }

        @Override
        public void validate() {
            TestContext.assertTrue(this.c0.x == -this.c0.y);
        }

        private static final class XYZ {
            static ObjectFactory FACTORY = new ObjectFactory(){

                protected Object create() {
                    return new XYZ();
                }
            };
            double x;
            double y;
            double z;

            private XYZ() {
            }

            public XYZ(double d, double d2, double d3) {
                this.x = d;
                this.y = d2;
                this.z = d3;
            }

            public static XYZ valueOf(double d, double d2, double d3) {
                XYZ xYZ = (XYZ)FACTORY.object();
                xYZ.x = d;
                xYZ.y = d2;
                xYZ.z = d3;
                return xYZ;
            }

            public XYZ plusStack(XYZ xYZ) {
                return XYZ.valueOf(this.x + xYZ.x, this.y + xYZ.y, this.z + xYZ.z);
            }

            public XYZ plusHeap(XYZ xYZ) {
                return new XYZ(this.x + xYZ.x, this.y + xYZ.y, this.z + xYZ.z);
            }
        }
    }

    public static class Concurrency
    extends TestCase {
        final int _size;
        final int _concurrency;
        FastTable _table;

        public Concurrency(int n, int n2) {
            this._size = n;
            this._concurrency = n2;
        }

        @Override
        public CharSequence getDescription() {
            return TextBuilder.newInstance().append("ConcurrentContext - Quick Sort (size: ").append(this._size).append(", concurrency: ").append(this._concurrency).append(")");
        }

        @Override
        public void prepare() {
            this._table = new FastTable(this._size);
            for (int i = 0; i < this._size; ++i) {
                this._table.add(Index.valueOf(MathLib.random(0, this._size)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            LocalContext.enter();
            try {
                ConcurrentContext.setConcurrency(this._concurrency);
                this.quickSort(this._table);
            }
            finally {
                LocalContext.exit();
            }
        }

        @Override
        public void validate() {
            int n;
            int n2;
            TestContext.assertEquals("Size", new Integer(this._size), new Integer(this._table.size()));
            for (int i = 0; i < this._size - 1 && TestContext.assertTrue("Natural Order", (n2 = ((Index)this._table.get(i)).intValue()) <= (n = ((Index)this._table.get(i + 1)).intValue())); ++i) {
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void quickSort(final FastTable fastTable) {
            final int n = fastTable.size();
            if (n < 100) {
                fastTable.sort();
            } else {
                final FastTable fastTable2 = FastTable.newInstance();
                final FastTable fastTable3 = FastTable.newInstance();
                ConcurrentContext.enter();
                try {
                    ConcurrentContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            fastTable2.addAll(fastTable.subList(0, n / 2));
                            Concurrency.this.quickSort(fastTable2);
                        }
                    });
                    ConcurrentContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            fastTable3.addAll(fastTable.subList(n / 2, n));
                            Concurrency.this.quickSort(fastTable3);
                        }
                    });
                }
                finally {
                    ConcurrentContext.exit();
                }
                int n2 = 0;
                int n3 = 0;
                for (int i = 0; i < n; ++i) {
                    if (n2 >= fastTable2.size()) {
                        fastTable.set(i, fastTable3.get(n3++));
                        continue;
                    }
                    if (n3 >= fastTable3.size()) {
                        fastTable.set(i, fastTable2.get(n2++));
                        continue;
                    }
                    Index index = (Index)fastTable2.get(n2);
                    Index index2 = (Index)fastTable3.get(n3);
                    if (index.intValue() < index2.intValue()) {
                        fastTable.set(i, index);
                        ++n2;
                        continue;
                    }
                    fastTable.set(i, index2);
                    ++n3;
                }
                FastTable.recycle(fastTable2);
                FastTable.recycle(fastTable3);
            }
        }
    }
}

