﻿<?php
/**
 * Search module file
 * New search module search for account or character have been put in a different classes
 * @author Lauri Lüüs <mad@webpoint.ee>
 * @version $Id: Search.php 15 2005-05-29 17:32:41Z madest $
 * @package AccountManager
 * @filesource
 */

/**
 * Search module 
 *
 * @author Lauri Lüüs <mad@webpoint.ee>
 * @version $Id: Search.php 15 2005-05-29 17:32:41Z madest $
 * @package AccountManager
 */
class Search extends Module 
{
	/**
	 * Search type (account/character)
	 */
	var $type;
	
	
	/**
	 * Ordering string for sql if have been set
	 */
	var $ordering;
	
	/**
	 * Search string needle
	 */
	var $search_s;
	
	
	
	/**
	 * Array of column titles
	 */
	var $cols;
	
	
	/**
	 * Search module main
	 */
	function Search()
	{		
		$this->Module();
		if(isset($this->active_user) && $this->active_user->is_admin() == true )
		{			
			
			if($this->template = temp_load($this->config->manager['template_path'].'search.htm'))
			{					
				// Delete if have to 
				if(isset($_POST['Delete']))
				{
					$this->delFromlist();
				}
				
				// Set query key string		
				if(isset($_POST['search_s']))
				{
					$this->search_s = $_POST['search_s'];
	
				} else {
					if(isset($_POST['p_search']))
					{
						$this->search_s = $_POST['p_search'];
					} else {
						$this->search_s = "";
					}					
				}
				
				
				// Select type
				if( isset($_POST['s_type']))
				{				
					switch ($_POST['s_type']) {
						case 'account':						
							$this->search_account();
							break;
						case 'character':
							$this->search_character();
							break;				
						default:
							$this->search_account();
							break;
					}
				} elseif (isset($_POST['p_type'])) {
					switch ($_POST['p_type']) {
						case 'account':						
							$this->search_account();
							break;
						case 'character':
							$this->search_character();
							break;				
						default:
							$this->search_account();
							break;
					}
	
				} else {
					$this->search_account();
				}
				$this->output = $this->template;
				$this->parseMessages();
			} else {
				$this->output = "Class:検索テンプレートがありません！";
			}			
		} else {
			$this->output = "<font color=red>これは管理者用ツールです！ログインしてください。</font>";
		}
	}
	
	/**
	 * Makes SQL query for accounts from specified search key and order
	 */
	function accountSQL()
	{
		$this->cols['1_link'] = "loginasc";
		$this->cols['2_link'] = "activeasc";
		$this->cols['4_link'] = "";
		$this->cols['4_link'] = "charasc";
		$this->cols['5_link'] = "accessasc";
		if(isset($_POST['ord']))
		{
			switch ($_POST['ord']) {
				case "loginasc":
					$q = mysql_query("SELECT * FROM accounts WHERE login LIKE '%{$this->search_s}%' ORDER BY login ASC");
					$this->cols['1_link'] = "logindesc";
					break;
				
				case "logindesc":
					$q = mysql_query("SELECT * FROM accounts WHERE login LIKE '%{$this->search_s}%' ORDER BY login DESC");					
					break;
				
				case "activeasc":
					$q = mysql_query("SELECT * FROM accounts WHERE login LIKE '%{$this->search_s}%' ORDER BY lastactive ASC");
					$this->cols['2_link'] = "activedesc";
					break;
					
				case "activedesc":
					$q = mysql_query("SELECT * FROM accounts WHERE login LIKE '%{$this->search_s}%' ORDER BY lastactive DESC");
					break;
					
				case "charasc":
					$this->cols['4_link'] = "chardesc";
					$q = mysql_query("SELECT *, COUNT(charId) AS charcount FROM accounts LEFT JOIN characters ON accounts.login = characters.account_name WHERE login LIKE '%{$this->search_s}%' GROUP BY accounts.login ORDER BY charcount ASC");
					break;
					
				case "chardesc":
					$q = mysql_query("SELECT *, COUNT(charId) AS charcount FROM accounts LEFT JOIN characters ON accounts.login = characters.account_name WHERE login LIKE '%{$this->search_s}%' GROUP BY accounts.login ORDER BY charcount DESC");
					break;
				
				case "accessasc":
					$this->cols['5_link'] = "accessdesc";
					$q = mysql_query("SELECT * FROM accounts WHERE login LIKE '%{$this->search_s}%' ORDER BY accessLevel ASC");
					break;
					
				case "accessdesc":
					$q = mysql_query("SELECT * FROM accounts WHERE login LIKE '%{$this->search_s}%' ORDER BY accessLevel DESC");
					break;					
								
				default:
					$q = mysql_query("SELECT * FROM accounts WHERE login LIKE '%{$this->search_s}%'");
					break;
			}
		} else {
			$q = mysql_query("SELECT * FROM accounts WHERE login LIKE '%{$this->search_s}%'");
		}		
		return $q;
	}
	
	/**
	 * Search for account
	 */
	function search_account ()
	{
		$q = $this->accountSQL();
			
		$this->cols['1'] = "アカウント";
		$this->cols['2'] = "最終接続";
		$this->cols['3'] = "";
		$this->cols['4'] = "キャラクター";
		$this->cols['5'] = "アクセスレベル";
		$this->cols['6'] = "選択";
		
		// Column names
		$this->template = temp_subs($this->template, "col", $this->cols);
		
		//$cols['2ord'] = $this->ordlinks['active_ord'];
		//$cols['3ord'] = $this->ordlinks['level_ord'];

		// Hidden values
		$search['search'] = $this->search_s;
		$search['type'] = 'account';
		$this->template = temp_subs($this->template, "search", $search);

		
		// Start List Output	
		$blockList = temp_lock($this->template, "results");
		# Display Accounts
		
		$counter = 0;
		while($r = mysql_fetch_array($q))
		{				
			$account = new Account($r['login']);
			$account->get();
			
			$result['1'] = $account->login;
			$result['2'] = $account->lastactive;
			$result['3'] = "";
			$result['4'] = $account->char_count;
			$result['5'] = $account->access_level;
			$result['6'] = $account->login;
			
			/*
			$result['1'] = $r['login'];
			$result['2'] = $r['lastactive'];
			$result['3'] = "";
			$result['4'] = $chars['charCount'];
			$result['5'] = $r['access_level'];
			*/
			
			$result['link'] = "act=account&id=".$r['login'];
						
			$blockList['add'] = temp_subs($blockList['tpl'], "result", $result);
			$blockList  = temp_done($blockList);
			
			$counter++;
		}
		$this->template = temp_unlock($blockList, "results");	
	}
	
	
		function characterSQL()
	{
		$this->cols['1_link'] = "charasc";
		$this->cols['2_link'] = "classasc";
		$this->cols['3_link'] = "levelasc";
		$this->cols['4_link'] = "acnasc";
		$this->cols['5_link'] = "acsasc";
		if(isset($_POST['ord']))
		{
			switch ($_POST['ord']) {
				case "charasc":
					$q = mysql_query("SELECT * FROM characters WHERE char_name LIKE '%{$this->search_s}%' ORDER BY char_name ASC");
					$this->cols['1_link'] = "chardesc";
					break;
				
				case "chardesc":
					$q = mysql_query("SELECT * FROM characters WHERE char_name LIKE '%{$this->search_s}%' ORDER BY char_name DESC");
					break;
					
				case "classasc":
					$q = mysql_query("SELECT * FROM characters LEFT JOIN char_templates ON characters.classid = char_templates.ClassId WHERE char_name LIKE '%{$this->search_s}%' ORDER BY char_name ASC");
					$this->cols['2_link'] = "classdesc";
					break;
					
				case "classdesc":
					$q = mysql_query("SELECT * FROM characters LEFT JOIN char_templates ON characters.classid = char_templates.ClassId WHERE char_name LIKE '%{$this->search_s}%' ORDER BY char_name DESC");					
					break;
					
				case "levelasc":
					$q = mysql_query("SELECT * FROM characters WHERE char_name LIKE '%{$this->search_s}%' ORDER BY level ASC");
					$this->cols['3_link'] = "leveldesc";
					break;
					
				case "leveldesc":
					$q = mysql_query("SELECT * FROM characters WHERE char_name LIKE '%{$this->search_s}%' ORDER BY level DESC");
					break;
					
				case "acnasc":
					$q = mysql_query("SELECT * FROM characters WHERE char_name LIKE '%{$this->search_s}%' ORDER BY account_name ASC");
					$this->cols['4_link'] = "acndesc";
					break;
					
				case "acndesc":
					$q = mysql_query("SELECT * FROM characters WHERE char_name LIKE '%{$this->search_s}%' ORDER BY account_name DESC");
					break;
					
				case "acsasc":
					$q = mysql_query("SELECT * FROM characters WHERE char_name LIKE '%{$this->search_s}%' ORDER BY accesslevel ASC");
					$this->cols['5_link'] = "acsdesc";
					break;
					
				case "acsdesc":
					$q = mysql_query("SELECT * FROM characters WHERE char_name LIKE '%{$this->search_s}%' ORDER BY accesslevel DESC");
					break;
					
					
				default:
					$q = mysql_query("SELECT * FROM characters WHERE char_name LIKE '%{$this->search_s}%'");
					break;
			}
		} else {
			$q = mysql_query("SELECT * FROM characters WHERE char_name LIKE '%{$this->search_s}%'");
		}		
		return $q;
	}
	
	/**
	 * Search for character
	 */
	function search_character()
	{
		$q = $this->characterSQL();
			
		$this->cols['1'] = "Character name";
		$this->cols['2'] = "Class";
		$this->cols['3'] = "Level";
		$this->cols['4'] = "Account name";
		$this->cols['5'] = "Accesslevel";
		$this->cols['6'] = "Select";
		
		// Hidden values
		$search['search'] = $this->search_s;
		$search['type'] = 'character';
		$this->template = temp_subs($this->template, "search", $search);
			
		$this->template = temp_subs($this->template, "col", $this->cols);
					
		$blockList = temp_lock($this->template, "results");
		# Display Characters
		while($r = mysql_fetch_array($q))
		{
			$className = @mysql_fetch_array(mysql_query("SELECT ClassName FROM char_templates WHERE classid={$r['classid']}"));
			$result['1'] = $r['char_name'];
			$result['2'] = $className['ClassName'];
			$result['3'] = $r['level'];
			$result['4'] = $r['account_name'];
			$result['5'] = $r['accesslevel'];
			$result['6'] = $r['charId'];
			$result['link'] = "act=character&id=".$r['charId'];
			
			$blockList['add'] = temp_subs($blockList['tpl'], "result", $result);
			$blockList  = temp_done($blockList);
		}
		$this->template = temp_unlock($blockList, "results");
	}
	
	
	/**
     * Deleting selected values
     * depends from hidden value in form p_type wich has to be set
     */	
	function delFromlist()
	{
		if(isset($_POST['list']))
		{
			if(is_array($_POST['list']))
			{
				switch ($_POST['p_type']) {
					case "account":
						for ($i = 0; $i < sizeof($_POST['list']); $i++)
						{
							$account = new Account($_POST['list'][$i]);
							$account->get();
							if($account->login !== $_SESSION['acObj']->login)
							{
								$this->write_log($_SESSION['acObj']->login." : Deleted account  '".$account->login."'");
								$this->addMessage("<font color=red>削除されたアカウント : '".$account->login."'</font>");
								$account->delete();
							} else {
								$this->addMessage("<font color=red>アカウント : '".$account->login."' は省略されました。</font>");
							}
							//echo "Account:".$_POST['list'][$i]."<br>";
						}
						break;
							
					case "character":
						for ($i = 0; $i < sizeof($_POST['list']); $i++)
						{
							$char = new Character($_POST['list'][$i]);
							$char->get();										
							$this->write_log($_SESSION['acObj']->login." : Deleted character  '".$char->char_name."'");
							$this->addMessage("<font color=red>削除されたキャラクター : ".$char->char_name."</font>");
							$char->delete();
							//echo "Character:".$_POST['list'][$i]."<br>";
						}
						break;
					default:
						break;
				}// Switch end
			} // If is_array() end
		} else {
			$this->addMessage("<font color=red>選択されていません！ </font>");
		}
	}
}
?>