/*
 * Copyright (C) 2004-2013 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package handlers.bypasshandlers;

import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.handler.IBypassHandler;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;

public class SupportMagic implements IBypassHandler
{
	private static final boolean USE_GETEFFECTS = false;
	
	private static final String[] COMMANDS =
	{
		"supportmagicservitor",
		"supportmagic"
	};
	
	// Buffs
	private static final int HASTE_1 = SkillTable.getSkillHashCode(4327, 1);
	private static final int HASTE_2 = SkillTable.getSkillHashCode(5632, 1);
	private static final int CUBIC = SkillTable.getSkillHashCode(4338, 1);
	private static final int[] FIGHTER_BUFFS =
	{
		SkillTable.getSkillHashCode(4322, 1), // Wind Walk
		SkillTable.getSkillHashCode(4323, 1), // Shield
		SkillTable.getSkillHashCode(5637, 1), // Magic Barrier
		SkillTable.getSkillHashCode(4324, 1), // Bless the Body
		SkillTable.getSkillHashCode(4325, 1), // Vampiric Rage
		SkillTable.getSkillHashCode(4326, 1), // Regeneration
	};
	private static final int[] MAGE_BUFFS =
	{
		SkillTable.getSkillHashCode(4322, 1), // Wind Walk
		SkillTable.getSkillHashCode(4323, 1), // Shield
		SkillTable.getSkillHashCode(5637, 1), // Magic Barrier
		SkillTable.getSkillHashCode(4328, 1), // Bless the Soul
		SkillTable.getSkillHashCode(4329, 1), // Acumen
		SkillTable.getSkillHashCode(4330, 1), // Concentration
		SkillTable.getSkillHashCode(4331, 1), // Empower
	};
	private static final int[] SUMMON_BUFFS =
	{
		SkillTable.getSkillHashCode(4322, 1), // Wind Walk
		SkillTable.getSkillHashCode(4323, 1), // Shield
		SkillTable.getSkillHashCode(5637, 1), // Magic Barrier
		SkillTable.getSkillHashCode(4324, 1), // Bless the Body
		SkillTable.getSkillHashCode(4325, 1), // Vampiric Rage
		SkillTable.getSkillHashCode(4326, 1), // Regeneration
		SkillTable.getSkillHashCode(4328, 1), // Bless the Soul
		SkillTable.getSkillHashCode(4329, 1), // Acumen
		SkillTable.getSkillHashCode(4330, 1), // Concentration
		SkillTable.getSkillHashCode(4331, 1), // Empower
	};
	
	// Levels
	private static final int LOWEST_LEVEL = 6;
	private static final int HIGHEST_LEVEL = 75;
	private static final int CUBIC_LOWEST = 16;
	private static final int CUBIC_HIGHEST = 34;
	private static final int HASTE_LEVEL_2 = 40;
	
	@Override
	public boolean useBypass(String command, L2PcInstance activeChar, L2Character target)
	{
		if (!target.isNpc() || activeChar.isCursedWeaponEquipped())
		{
			return false;
		}
		
		if (command.equalsIgnoreCase(COMMANDS[0]))
		{
			makeSupportMagic(activeChar, (L2Npc) target, true);
		}
		else if (command.equalsIgnoreCase(COMMANDS[1]))
		{
			makeSupportMagic(activeChar, (L2Npc) target, false);
		}
		return true;
	}
	
	private static void makeSupportMagic(L2PcInstance player, L2Npc npc, boolean isSummon)
	{
		final int level = player.getLevel();
		if (isSummon && (!player.hasSummon() || !player.getSummon().isServitor()))
		{
			npc.showChatWindow(player, "data/html/default/SupportMagicNoSummon.htm");
			return;
		}
		else if (level > HIGHEST_LEVEL)
		{
			npc.showChatWindow(player, "data/html/default/SupportMagicHighLevel.htm");
			return;
		}
		else if (level < LOWEST_LEVEL)
		{
			npc.showChatWindow(player, "data/html/default/SupportMagicLowLevel.htm");
			return;
		}
		else if (player.getClassId().level() == 3)
		{
			player.sendMessage("Only adventurers who have not completed their 3rd class transfer may receive these buffs."); // Custom message
			return;
		}
		
		if (isSummon)
		{
			npc.setTarget(player.getSummon());
			for (int skill : SUMMON_BUFFS)
			{
				handleCast(npc, player, skill);
			}
			
			if (level >= HASTE_LEVEL_2)
			{
				handleCast(npc, player, HASTE_2);
			}
			else
			{
				handleCast(npc, player, HASTE_1);
			}
		}
		else
		{
			npc.setTarget(player);
			if (player.isMageClass() && (player.getClassId() != ClassId.overlord) && (player.getClassId() != ClassId.warcryer))
			{
				for (int skill : MAGE_BUFFS)
				{
					handleCast(npc, player, skill);
				}
			}
			else
			{
				for (int skill : FIGHTER_BUFFS)
				{
					handleCast(npc, player, skill);
				}
				
				if (level >= HASTE_LEVEL_2)
				{
					handleCast(npc, player, HASTE_2);
				}
				else
				{
					handleCast(npc, player, HASTE_1);
				}
			}
			
			if ((level >= CUBIC_LOWEST) && (level <= CUBIC_HIGHEST))
			{
				player.doSimultaneousCast(SkillTable.getSkill(CUBIC));
			}
		}
	}
	
	private static void handleCast(L2Npc npc, L2Character target, int skillHashCode)
	{
if (USE_GETEFFECTS) {{
		L2Skill skill = SkillTable.getSkill(skillHashCode);
		skill.getEffects(npc, target);
		npc.broadcastPacket(new MagicSkillUse(npc, target, skill.getId(), skill.getLevel(), 0, 0));
}} else {{
		npc.doCast(SkillTable.getSkill(skillHashCode));
}}
	}
	
	@Override
	public String[] getBypassList()
	{
		return COMMANDS;
	}
}