/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package custom.FortuneTelling;

import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;

/**
 * @authors Kerberos (python), Nyaran (java)
 */
public class FortuneTelling extends Quest
{
	private static final String qn = "FortuneTelling";

	private static final int ADENA = 57;
	private static final int COST = 1000;

	private static final int NPC = 32616;

	public FortuneTelling(int questId, String name, String descr)
	{
		super(questId, name, descr);
		addStartNpc(NPC);
		addTalkId(NPC);
	}

	@Override
	public String onTalk(L2Npc npc, L2PcInstance player)
	{
		QuestState st = player.getQuestState(qn);
		NpcHtmlMessage html = new NpcHtmlMessage(1);
		String PARENT_DIR = "data/scripts/custom/FortuneTelling/";
		
		if (st == null)
			return null;
	
		if (st.getQuestItemsCount(ADENA) < COST)
			html.setFile(player.getHtmlPrefix(), PARENT_DIR + "lowadena.htm");
		else
		{
			st.takeItems(ADENA, COST);
			html.setFile(player.getHtmlPrefix(), PARENT_DIR + "fortune.htm");
			html.replace("%fortune%", getRandom(1800309, 1800694));	//<fstring>npcstring</fstring>
		}
		st.exitQuest(true);
		player.sendPacket(html);
		return null;
	}

	public static void main(String args[])
	{
		new FortuneTelling(-1, qn, "custom");
	}
}
