/*
 * Copyright (C) 2004-2013 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package handlers.admincommandhandlers;

import com.l2jserver.gameserver.datatables.TransformData;
import com.l2jserver.gameserver.handler.IAdminCommandHandler;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;

/**
 * @author
 * modify JOJO
 */
public class AdminRide implements IAdminCommandHandler
{
	private static final String[] ADMIN_COMMANDS =
	{
		"admin_ride_horse",
		"admin_ride_bike",
		"admin_ride_lion",
		"admin_ride_beatle",
		"admin_ride_platform",
		"admin_ride_wyvern",
		"admin_ride_strider",
		"admin_ride_gstrider",
		"admin_ride_gwolf",
		"admin_ride_wolf",
		"admin_ride_wwolf",
		"admin_unride_wyvern",
		"admin_unride_strider",
		"admin_unride_wolf",
		"admin_unride",
	};
	
	public static final int PURPLE_MANED_HORSE_TRANSFORMATION_ID = 106;
	public static final int JET_BIKE_TRANSFORMATION_ID = 20001;
	public static final int TAWNY_MANED_LION_TRANSFORMATION_ID = 109;
	public static final int STEAM_BEATLE_TRANSFORMATION_ID = 110;
	public static final int SHINY_PLATFORM_TRANSFORMATION_ID = 20004;
	
	@Override
	public boolean useAdminCommand(String command, L2PcInstance activeChar)
	{
		final L2PcInstance player;
		final L2Object o = activeChar.getTarget();
		if (o instanceof L2PcInstance)
		{
			player = (L2PcInstance)o;
		}
		else if (o == null)
		{
			player = activeChar;
		}
		else
		{
			activeChar.sendPacket(SystemMessageId.INCORRECT_TARGET);
			return false;
		}
		
		if (command.startsWith("admin_ride"))
		{
			int id = 0;
			if (player.isMounted() || player.hasSummon())
			{
				activeChar.sendMessage("Target already have a summon.");
				return false;
			}
			else if (player.isTransformed() || player.isInStance())
			{
				activeChar.sendPacket(SystemMessageId.YOU_ALREADY_POLYMORPHED_AND_CANNOT_POLYMORPH_AGAIN);
				return false;
			}
			else if (command.startsWith("admin_ride_horse")    && (id = PURPLE_MANED_HORSE_TRANSFORMATION_ID) != 0
				  || command.startsWith("admin_ride_bike")     && (id = JET_BIKE_TRANSFORMATION_ID) != 0
				  || command.startsWith("admin_ride_lion")     && (id = TAWNY_MANED_LION_TRANSFORMATION_ID) != 0
				  || command.startsWith("admin_ride_beatle")   && (id = STEAM_BEATLE_TRANSFORMATION_ID) != 0
				  || command.startsWith("admin_ride_platform") && (id = SHINY_PLATFORM_TRANSFORMATION_ID) != 0
			     )
			{
				TransformData.getInstance().transformPlayer(id, player);
				return true;
			}
			else if (command.startsWith("admin_ride_wyvern")   && (id = 12621) != 0	// Wyvern
			      || command.startsWith("admin_ride_strider")  && (id = 12526) != 0	// Wind Strider
			      || command.startsWith("admin_ride_gstrider") && (id = 16068) != 0	// Guardian's Strider
			      || command.startsWith("admin_ride_gwolf")    && (id = 16037) != 0	// Great Snow Wolf
			      || command.startsWith("admin_ride_wolf")     && (id = 16041) != 0	// Fenrir Wolf
			      || command.startsWith("admin_ride_wwolf")    && (id = 16042) != 0	// White Fenrir Wolf
			     )
			{
				player.mount(id, 0, false);
				return true;
			}
			else
			{
				activeChar.sendMessage("Command '" + command + "' not recognized");
				return false;
			}
		}
		else if (command.startsWith("admin_unride"))
		{
			switch (player.getTransformationId())
			{
				case PURPLE_MANED_HORSE_TRANSFORMATION_ID:
				case JET_BIKE_TRANSFORMATION_ID:
				case TAWNY_MANED_LION_TRANSFORMATION_ID:
				case STEAM_BEATLE_TRANSFORMATION_ID:
				case SHINY_PLATFORM_TRANSFORMATION_ID:
					player.untransform();
					break;
				default:
					player.dismount();
					break;
			}
		}
		return true;
	}
	
	@Override
	public String[] getAdminCommandList()
	{
		return ADMIN_COMMANDS;
	}
	
}
