/*
 * Copyright (C) 2005-2008 L2J_JP / 2008-2013 L2J-SFJP
 * 
 * This file is part of L2J Server.
 * 
 * L2J Server is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J Server is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
//@formatter:off
package ai.fantasy_isle;

import static com.l2jserver.gameserver.util.GameTimeFunction.gameTimeHourToRealMilli;
import static com.l2jserver.gameserver.util.GameTimeFunction.timeLeftMilli;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.concurrent.ScheduledFuture;

import ai.npc.AbstractNpcAI;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.NextAction;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.network.serverpackets.PlaySound;

/**
 * Fantasy Isle Parade
 * @author JOJO
 */
public class Parade extends AbstractNpcAI
{
	private static final boolean DEBUG = true;
	private static final boolean MUSIC = true;
	protected final int[] ACTORS = {
		// 3c
		32381,/*q|n*/              32379,/*q*/            32381,/*q|n*/
		32382,/*q*/              32383,/*q*/            32384,/*qM*/
		32381,/*q|n*/              32385,/*qʏ*/            32381,/*q|n*/
		32384,/*qM*/            32383,/*q*/            32382,/*q*/
		32386,/*cd*/                32387,/*cd*/                32388,/*cd*/
		32389,/*cd*/                32390,/*cd*/                32391,/*hjK[h*/
		32392,/*hjEl*/            32393,/*h*/                32394,/*h*/
		32395,/*hfj*/            32396,/*GtjK[h*/        32397,/*Gtj}X^[*/
		32398,/*GtF*/          32399,/*GthX*/        32400,/*Gt*/
		32401,/*I[NjK[h*/        32402,/*I[NjnQn}[*/  32403,/*I[Nj*/
		32404,/*I[Nfj*/          32405,/*q[}j}X^[*/  32406,/*q[}}X^[*/
		32407,/*q[}t@C^[*/32408,/*q[}fj*/      32409,/*L*/
		32411,/*N[K*/                32412,/*NbJv*/            32413,/*CGeB()*/
		32414,/*CGeB()*/      32415,/*CGeB()*/      32416,/*jR[*/
		32417,/*jR[*/      32418,/*jR[*/          32419,/*jR[*/
		32420,/*jR[*/      32421,/*Lj*/                  32422,/*Lj*/
		32423,/*L*/           32429,/*uJ EH[bN pXgD*/ 32430,/*hfj*/
		32447,/*f[T*/            32448,/**/                    32449,/**/
		32450,/**/                    32451,/*KKւя()*/  32452,/*菗()*/
		32453,/*()*/              32454,/*()*/              32455,/**/
		32456,/*()*/              0,                              0,
		0,                              32415,/*CGeB()*/      0,
	};
	
	//[gP (270x ks)
	private final Location[] START1 = {new Location(-54780, -56810, -2015, 49152), new Location(-54860, -56810, -2015, 49152), new Location(-54940, -56810, -2015, 49152)};
	private final Location[] GOAL1  = {new Location(-54780, -57965, -2015, 49152), new Location(-54860, -57965, -2015, 49152), new Location(-54940, -57965, -2015, 49152)};
	//[gQ (180x s)
//	private final Location[] START2 = {new Location(-55740, -58900, -2015, 32768), new Location(-55740, -58820, -2015, 32768), new Location(-55740, -58740, -2015, 32768)};//TODO
	private final Location[] START2 = {new Location(-55715, -58900, -2015, 32768), new Location(-55715, -58820, -2015, 32768), new Location(-55715, -58740, -2015, 32768)};
	private final Location[] GOAL2  = {new Location(-60850, -58900, -2015, 32768), new Location(-60850, -58820, -2015, 32768), new Location(-60850, -58740, -2015, 32768)};
	//[gR (90x s)
	private final Location[] START3 = {new Location(-61790, -57965, -2015, 16384), new Location(-61710, -57965, -2015, 16384), new Location(-61630, -57965, -2015, 16384)};
	private final Location[] GOAL3  = {new Location(-61790, -53890, -2116, 16384), new Location(-61710, -53890, -2116, 16384), new Location(-61630, -53890, -2116, 16384)};
	//[gS (0x s)
	private final Location[] START4 = {new Location(-60840, -52990, -2108, 0), new Location(-60840, -53070, -2108, 0), new Location(-60840, -53150, -2108, 0)};
	private final Location[] GOAL4  = {new Location(-58620, -52990, -2015, 0), new Location(-58620, -53070, -2015, 0), new Location(-58620, -53150, -2015, 0)};
	//[gT (315x ks)
	private final Location[] START5 = {new Location(-57233, -53554, -2015, 57344), new Location(-57290, -53610, -2015, 57344), new Location(-57346, -53667, -2015, 57344)};
	private final Location[] GOAL5  = {new Location(-55338, -55435, -2015, 57344), new Location(-55395, -55491, -2015, 57344), new Location(-55451, -55547, -2015, 57344)};
	
	protected final Location[][] START = { START1, START2, START3, START4, START5 };
	protected final Location[][] GOAL  = { GOAL1,  GOAL2,  GOAL3,  GOAL4,  GOAL5 };
	
	protected final ArrayList<CtrlEvent> ARRIVED_EVENTS;
	
	protected ScheduledFuture<?> spawnTask;
	
	protected int npcIndex;
	
	private Parade(int id, String name, String descr)
	{
		super(id, name, descr);
		
		ARRIVED_EVENTS = new ArrayList<>(1);
		ARRIVED_EVENTS.add(CtrlEvent.EVT_ARRIVED);
		
		final long diff = timeLeftMilli(8, 0, 0, 6), cycle = gameTimeHourToRealMilli(6); // lԂ800JnA6ԂƌJԂ
		if (DEBUG)
		{
			SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm");
			_log.info("Fantasy Isle: Parade script starting at " + format.format(System.currentTimeMillis() + diff) + " and is scheduled each next " + (cycle / 3600000) + " hours.");
		}
		ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new Start(), diff, cycle);
	}
	
	protected class Start implements Runnable
	{
		@Override
		public void run()
		{
			if (DEBUG)
				System.out.println("Fantasy Isle: Parade start.");
			npcIndex = 0;
			spawnTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new Spawn(), 0, 5000);
		}
	}
	
	protected class Spawn implements Runnable
	{
		@Override
		public void run()
		{
			for (int i = 0; i < 3; ++i) {
				if (npcIndex >= ACTORS.length) { spawnTask.cancel(false); return; }
				int npcId = ACTORS[npcIndex++];
				if (npcId == 0) continue;
				for (int route = START.length; --route >= 0;) {
					Location start = START[route][i];
					Location goal = GOAL[route][i];
					final L2Npc actor = addSpawn(npcId, start.getX(), start.getY(), start.getZ(), start.getHeading(), false, 0);
					actor.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, goal);
					actor.getAI().setNextAction(new NextAction(ARRIVED_EVENTS, null){
						@Override public void doWork()
						{
							actor.deleteMe();
						}
					});
					if (MUSIC)
						if (npcIndex == 1) actor.broadcastPacket(new PlaySound("TP05_F"));
				}
			}
		}
	}
	
	public static void main(String[] args)
	{
		new Parade(-1, "Parade", "fantasy_isle");
	}
}

/**
  F
    Q[Ԃł"24"́AłSԁB܂U{B
    T[oN "6"ɐݒ肳B
    Xe[W͂܂"2030"́AT[oNĂ"1430"Ȃ̂ŁA
    ɊZ(UŊ)QԂQTB

    p[h̓Q[Ԃ
      2:00A8:00A14:00A20:00 ̂PSAUԂƂɂȂB
    Xe[W
      20:30 ̂P̂݁B
*/
