/*
 * Copyright (C) 2004-2013 L2J Server
 * 
 * This file is part of L2J Server.
 * 
 * L2J Server is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J Server is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.l2jserver.gameserver.model.actor.tasks.attackable;

import com.l2jserver.gameserver.enums.QuestEventType;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;

/**
 * @author xban1x
 */
public final class OnKillNotifyTask implements Runnable
{
	private final L2Attackable _attackable;
	private final Quest _quest;
	private final L2PcInstance _killer;
	private final boolean _isSummon;
	
	public OnKillNotifyTask(L2Attackable attackable, Quest quest, L2PcInstance killer, boolean isSummon)
	{
		_attackable = attackable;
		_quest = quest;
		_killer = killer;
		_isSummon = isSummon;
	}
	
	@Override
	public void run()
	{
if (com.l2jserver.Config.FIX_OnKillNotifyTask_THREAD) {{
		for (Quest quest : _attackable.getTemplate().getEventQuests(QuestEventType.ON_KILL))
		{
			quest.notifyKill(_attackable, _killer, _isSummon);
		}
}} else {{
		if ((_quest != null) && (_attackable != null) && (_killer != null))
		{
			_quest.notifyKill(_attackable, _killer, _isSummon);
		}
}}
	}
}
