﻿## Active Perl 5.8.8

use utf8;
use warnings;
use strict;
use Encode;
binmode STDOUT, ':encoding(cp932)'; $|=1;

my $DEBUG = 0;

opendir DIR,'.'  or die $!;
my @files = readdir DIR;
closedir DIR;

foreach my $fileName (@files) {
	next if $fileName =~ m!^\.!;
	next unless $fileName =~ m!\.html?$!;

	open FILE, '<:utf8', $fileName  or die "'$fileName' $!";
	read FILE, my $htm, -s FILE;
	my $mtime = (stat FILE)[9];
	close FILE;

	my $original = $htm;
	$_           = $htm;
#----------------------------------------------------------------------------

s/(?<=<button action="bypass -h Quest WyvernManager Help" value=").+?(?=")/ワイバーン説明/g;		# -01,-02,-dusk
s/(?<=<button action="bypass -h Quest WyvernManager RideWyvern" value=").+?(?=")/ワイバーン搭乗/g;	# -01
s/(?<=<button action="bypass -h Quest WyvernManager Return" value=").+?(?=")/初期画面/g;			# -03,-03b,-07

s/(?<=value="ワイバーン説明" width=)\d\d(?= )/100/g;	# width=80 --> 100
s/(?<=value="ワイバーン搭乗" width=)\d\d(?= )/100/g;	# width=80 --> 100
s/^(<button.*>)<br>$/$1<br1>/gm;

#----------------------------------------------------------------------------
	$htm = $_;

	if ($htm ne $original) {
		print $fileName,"\n";
		my $output = $fileName;
		   $output = "$fileName.text" if $DEBUG;
		open FILE, '>:utf8', $output  or die "'$output' $!";
		$htm = "\x{feff}".$htm unless $htm =~ m/^\x{feff}/;  #BOM
		print FILE $htm;
		close FILE;
		utime $mtime,$mtime,$output;
	}
}
