﻿## Active Perl 5.8.8

# L2J_DataPack language tool for Japanese.
# part 2 - *.htm、*.py 中のテレポート先地名を強引に日本語化する.

use utf8;
use warnings;
use strict;
use Encode;

binmode STDOUT,':encoding(cp932)'; $|=1;
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $DEBUG = 0; # 1 or 0
my $LOG = 0; # 1 or 0
my @CC;

my $LogFile = UTF8(__FILE__);
   $LogFile =~ s!\.[^.\/\\]*$!.log!;
if ($LOG) {{open LOG, '>:utf8', FS($LogFile) or die "'$LogFile' $!";}}

my $ERROR_HEADER;

$SIG{__WARN__} = sub {
	print STDERR $ERROR_HEADER,' ' if $ERROR_HEADER;
	foreach my $m (@_) {
		my $a = $m;
		$a =~ s!build[/\\]dist[/\\]game[/\\](data[/\\])!$1!;
		$a =~ s!build[/\\]dist[/\\]!!;
		if ($a =~ m/^Malformed UTF-8 character \(/) {
			print STDERR $a;
			exit 1;
		}
		print STDERR $a;
		if ($LOG) {{print LOG    $a;}}
	}
};

$SIG{__DIE__} = sub {
	print STDERR $ERROR_HEADER,' ' if $ERROR_HEADER;
	foreach my $m (@_) {
		my $a = $m;
		$a =~ s!build[/\\]dist[/\\]game[/\\](data[/\\])!$1!;
		$a =~ s!build[/\\]dist[/\\]!!;
		print STDERR $a;
	}
	exit 1;
};

&start('build/dist/game/data/html/teleporter/');
&start('build/dist/game/data/scripts/ai/npc/CastleChamberlain/');
&start('build/dist/game/data/html/clanHallManager/');
&start('build/dist/game/data/html/fortress/');
&start('build/dist/game/data/scripts/ai/npc/KetraOrcSupport/');
&start('build/dist/game/data/scripts/ai/npc/VarkaSilenosSupport/');

if ($LOG) {{
print LOG "\n";
for (my $i=0; $i <= $#CC; ++$i) {
	if ($CC[$i]) {print LOG __FILE__,"($i)\t",$CC[$i],"\n"}
}

close LOG;
}}
exit 0;

sub start {
	my ($subDir) = @_;

	print ' [',$subDir,"]\n";
	opendir DIR, FS($subDir) or die "'$subDir' $!";
	my @files = readdir DIR; $_ = UTF8($_) foreach (@files);
	closedir DIR;

	foreach my $fileName (@files) {
		next if $fileName =~ m/^\./;
		next if $fileName =~ m/ /;
		my $filePath = $subDir.$fileName;
		my $outPath = $filePath;
		   $outPath .= '.text' if $DEBUG;

		if (-d FS($filePath)) {
			$filePath =~ s!^\.\/!!;
			&start($filePath.'/');
			next;
		}

		my ($ext, $encode);
		if    ($fileName =~ /\.html?$/) {$ext = 'htm'; $encode = ':utf8'}
		elsif ($fileName =~ /\.py$/ )   {$ext = 'py' ; $encode = ':encoding(cp932)'}
		else {next}

		print "  $filePath\n" if $DEBUG;
		open FILE, '<'.$encode, FS($filePath) or die "'$filePath' $!";
		read FILE,my $text,-s FILE;
		my $mtime = (stat FILE)[9];
		close FILE;

		my $original = $text;
		$_           = $text;
		$ERROR_HEADER = "'$filePath'";
#------------------------------------------------------------------------------
# 置換の順番に注意！
#  同じ地域・似た名前の地域を書くときは、長い名前を先に書くこと。
#  たとえば 
#    ○ s/Ketra Orc Village/ケトラー オーク ヴィレッジ/  #長い
#    ○ s/Orc Village/オーク村/                          #短い
#  反対にすると長い名前の方がマッチしなくなる。
#    × s/Orc Village/オーク村/                          #短いのを先に置換してしまうと、
#    × s/Ketra Orc Village/ケトラー オーク ヴィレッジ/  #長いのがマッチしなくなる。
#  極端に短い名前は最後の方で置換すること。
#       s/Coliseum/コロシアム/ とか
#       s/Heine/水上都市ハイネス/ とか

s/\bCenter of the Elven Ruins\b/エルフの遺跡の中心/gi;
s/\bElven Ruins\b/エルフの遺跡/gi;
s/\bSinging Waterfall\b/歌う滝/gi;
s/\bTalking Island, Northern Territory\b/話せる島の西部(北側)/gi;#freya r2
s/\b話せる島, Northern Territory\b/話せる島の西部(北側)/gi;#freya r2
s/\bObelisk of Victory\b/戦勝記念塔/gi;

s/\bExecution Grounds\b/処刑場/gi;
s/\bThe Center of the Cruma Marshlands\b/クルマ湿地 中央/gi;
s/\bCruma Marshlands\b/クルマ湿地/gi;
s/\bCruma Tower - First Floor/クルマの塔 1階/;
s/\bCruma Tower - Second Floor/クルマの塔 2階/;
s/\bCruma Tower, 1st Floor/クルマの塔 1階/;
s/\bCruma Tower, 2nd Floor/クルマの塔 2階/;
s/\bCruma Tower Entrance\b/クルマの塔の入り口/gi;
s/\bCruma Tower\b/クルマの塔/gi;
s/\bFortress of Resistance\b/パルチザンのアジト/gi;
s/\bPlains of Dion\b/ディオン牧草地/gi;
s/\bEntrance to Floran Village\b/フローラン村 入口/gi;	#freya r2
s/\bFloran Agricultural Area\b/フローラン開拓地/gi;
s/\bBee Hive\b/ビーハイヴ/gi;

s/\bTanor Canyon\b/タノール峡谷/gi;
s/\bGorgon Flower Garden\b/ゴルコンの花園/gi;
s/\bBreka's Stronghold\b/ブレカの巣窟/gi;
s/\bGiran Harbor\b/ギラン港/gi;
s/\bHardin's Private Academy\b/ハーディンの私塾/gi;
s/\bHardins Private Academy\b/ハーディンの私塾/gi;
s/\bPrivate Hardins Academy\b/ハーディンの私塾/gi;
s/\bHardins Academy\b/ハーディンの私塾/gi;
s/\bThe Center of Dragon Valley\b/ドラゴンバレー 中央/gi;
s/\bDragon Valley, Traders Post\b/ドラゴンバレー 中央/gi;
s/\bDragon Valley\b/ドラゴンバレー/gi;
s/\bAntharas' Lair - 1st Level\b/ドラゴンバレーのダンジョン 1階/gi;
s/\bAntharas' Lair - 2nd Level\b/ドラゴンバレーのダンジョン 2階/gi;
s/\bAntharas' Lair -  Magic Force Field Bridge\b/ドラゴンバレーのダンジョン 結界の橋/gi;
s/\bAntharas' Lair - Magic Force Field Bridge\b/ドラゴンバレーのダンジョン 結界の橋/gi;
s/\bThe Heart of Antharas' Lair\b/ドラゴンバレーのダンジョン 心臓部/gi;
s/\bAntharas Lair 1\b/ドラゴンバレーのダンジョン 1階/gi;
s/\bAntharas Lair 2\b/ドラゴンバレーのダンジョン 2階/gi;
s/\bAntharas Lair, Magic Force Field Bridge\b/ドラゴンバレーのダンジョン 結界の橋/gi;
s/\bAntharas Lair, Heart of Warding\b/ドラゴンバレーのダンジョン 心臓部/gi;
s/\bThe Heart of Antharas's Lair\b/ドラゴンバレーのダンジョン 心臓部/gi;	#r9024
s/\bAntharas's Lair\b/ドラゴンバレーのダンジョン/gi;	#r9024
s/\bAntharas' Lair\b/ドラゴンバレーのダンジョン/gi;
s/\bAntharas Lair\b/ドラゴンバレーのダンジョン/gi;
s/\bDevil's Isle\b/悪魔の島/gi;
s/\bPirate's Tunnel\b/海賊のトンネル/gi;
s/\bPirate Tunnel\b/海賊のトンネル/gi;

s/\bCenter of the School of Dark Arts\b/黒魔法研究所 中央/gi;
s/\bSchool Of Dark Arts\b/黒魔法研究所/gi;
s/\bThe Center of the Dark Forest\b/ダークエルフの森の中心/gi;
s/\bThe Center of Dark Forest\b/ダークエルフの森の森の中心/gi;
s/\bDark Forest\b/ダークエルフの森/gi;
s/\bSwampland\b/沼地帯/gi;
s/\bSpider Nest\b/クモの巣/gi;

s/\bThe Center of the Neutral Zone\b/中立地帯 中央/gi;
s/\bThe Center of the Neutral Zona\b/中立地帯 中央/gi;	#誤字
s/\bThe Center of Neutral Zone\b/中立地帯 中央/gi;
s/\bNeutral Zone\b/中立地帯/gi;
s/\bElven Forest\b/エルフの森/gi;
s/\bElven Fortress\b/エルフの地下要塞/gi;

s/\bForest of Evil\b/魔導の森/gi;
s/\bTimak Outpost\b/ティマック アウトポスト/gi;
s/\bAltar of Rites\b/成人式の祭壇/gi;
s/\bSkyshadow Meadow\b/スカイシャドウ メドウ/gi;
s/\bPlains of the Lizardmen\b/リザード プレイン/gi;
s/\bOutlaw Forest\b/無法者の森/gi;
s/\bSea of Spores\b/胞子の海/gi;

s/\bEnchanted Valley, Southern Region\b/フェアリーの谷(南側)/gi;
s/\bEnchanted Valley, Northern Region\b/フェアリーの谷(北側)/gi;
s/\bEnchanted Valley, Northen Region\b/フェアリーの谷(北側)/gi;	#freya r2
s/\bThe Center of the Enchanted Valley\b/フェアリーの谷 中央/gi;
s/\bEnchanted Valley\b/フェアリーの谷/gi;
s/\bThe Center of the Forest of Mirrors\b/鏡の森の中心/gi;
s/\bForest of Mirrors\b/鏡の森/gi;

s/\bSel Mahum Training Grounds \(West Gate\)/スクール オブ コンピタンス(西口)/gi;	#freya r2
s/\bSel Mahum Training Grounds \(South Gate\)/スクール オブ コンピタンス(南口)/gi;	#freya r2
s/\bSel Mahum Training Grounds \(Center\)/スクール オブ コンピタンス(中央)/gi;	#freya r2

s/\bEvil Hunting Grounds\b/魔物の略奪地/gi;
s/\bRuins of Agony\b/悲嘆の廃墟/gi;
s/\bRuins Agony\b/悲嘆の廃墟/gi;
s/\bRuins of Despair\b/絶望の廃墟/gi;
s/\bRuins Dispair\b/絶望の廃墟/gi;
s/\bWindmill Hill\b/風車の丘/gi;
s/\bFellmere Harvesting Grounds\b/フェルメル採集場/gi;
s/\bOrc Barracks\b/トゥレックオークの野営地/gi;
s/\bWindy Hill\b/風の丘/gi;
s/\bAbandoned Camp\b/棄てられた露営地/gi;

s/\bWindawood Manor\b/ウィンダウッドの荘園/gi;
s/\bLangk Lizardman Dwelling\b/ランクリザードマン生息地/gi;
s/\bCenter of the Forgotten Temple\b/忘れられた神殿(中央)/gi;
s/\bForgotten Temple\b/忘れられた神殿/gi;
s/\bWastelands, Western Region\b/荒地(西側)/gi;
s/\bWastelands\b/荒地/gi;
s/\bWasteland\b/荒地/gi;
s/\bThe Ant Nest\b/アリの巣/gi;
s/\bAnt Nest\b/アリの巣/gi;
s/\bRed Rock Ridge\b/赤い岩の尾根/gi;

s/\bThe Center of the Mithril Mines\b/ミスリル鉱山の中心/gi;
s/\bThe Center of Mithril Mines\b/ミスリル鉱山の中心/gi;
s/\bMithril Mines Western Entrance\b/ミスリル鉱山の西側入口/gi;	#r7443
s/\bMithril Mines Eastern Entrance\b/ミスリル鉱山の東側入口/gi;	#r7443
s/\bMithril Mines\b/ミスリル鉱山/gi;
s/\bThe Center of the Abandoned Coal Mines\b/棄てられた炭鉱の中心/gi;
s/\bThe Center of Abandoned Coal Mines\b/棄てられた炭鉱の中心/gi;
s/\bAbandoned Coal Mines\b/棄てられた炭鉱/gi;
s/\bEastern Mining Zone \(Northeastern Shore\)/鉱山地帯東部(北東海岸)/gi;
s/\bWestern Mining Zone \(Central Shore\)/鉱山地帯西部(中部海岸)/gi;

s/\bImmortal Plateau, Southern Region\b/不滅の高原南部/gi;
s/\bImmortal Plateau, Northern Region\b/不滅の高原北部/gi;
s/\bThe Immortal Plateau\b/不滅の高原/gi;
s/\bImmortal Plateau\b/不滅の高原/gi;
s/\bEntrance to the Cave of Trials\b/試練の洞窟/gi;
s/\bCave of Trials\b/試練の洞窟/gi;
s/\bFrozen Waterfall\b/凍りついた滝/gi;

s/\bForsaken Plains\b/忘却の平原/gi;
s/\bSeal of Shilen\b/シーレンの封印/gi;
s/\bBlazing Swamp\b/火炎の沼/gi;
s/\bFields of Massacre\b/虐殺の大地/gi;
s/\bAncient Battleground\b/過去の戦場/gi;
s/\bSilent Valley\b/サイレント バレー/gi;

s/\bThe Giant's Cave Upper Layer\b/巨人たちの洞窟 上層/gi;	#freya r2
s/\bThe Giant's Cave Lower Layer\b/巨人たちの洞窟 下層/gi;	#freya r2
s/\bThe Giants Cave Upper Layer\b/巨人たちの洞窟 上層/gi;	#r8071
s/\bThe Giants Cave Lower Layer\b/巨人たちの洞窟 下層/gi;	#r8071
s/\bEntrance to The Giant's Cave\b/巨人たちの洞窟入口/gi;
s/\bGiant's Cave\b/巨人たちの洞窟/gi;
s/\bGiants Cave\b/巨人たちの洞窟/gi;
s/\bPlains of Glory\b/栄光の平原/gi;
s/\bWar-Torn Plains\b/激戦の平原/gi;
s/\bTower of Insolence, 3rd Floor\b/傲慢の塔 3階/gi;
s/\bTower of Insolence, 5th Floor\b/傲慢の塔 5階/gi;
s/\bTower of Insolence, 7th Floor\b/傲慢の塔 7階/gi;
s/\bTower of Insolence, 10th Floor\b/傲慢の塔 10階/gi;
s/\bTower of Insolence, 13th Floor\b/傲慢の塔 13階/gi;
s/\bTower of Insolence\b/傲慢の塔/gi;
s/\bHunters Valley\b/猟師の渓谷/gi;
s/\bAngh?el Waterfall\b/アンヘル滝/gi;
s/\bNear the frontier post\b/傲慢の搭付近/gi;	#freya r2

s/\bField of Silence Center\b/静寂の草原 中央/gi;	#freya r2
s/\bField of Silence \(Western Section\)/静寂の草原(西側)/gi;
s/\bField of Silence\b/静寂の草原/gi;
s/\bField of Whispers Center\b/囁きの草原 中央/gi;	#freya r2
s/\bField of Whispers \(Eastern Section\)/囁きの草原(東側)/gi;
s/\bField of Whispers\b/囁きの草原/gi;
s/\bThe Center of Alligator Island\b/クロコダイル アイランドの中心/gi;
s/\bAlligator Island\b/クロコダイル アイランド/gi;
s/\bInside the Garden of Eva\b/エヴァの水中庭園 内部/gi;
s/\bGarden of Eva - 2nd level\b/エヴァの水中庭園 2階/gi;
s/\bGarden of Eva - 3rd level\b/エヴァの水中庭園 3階/gi;
s/\bGarden of Eva - 4th level\b/エヴァの水中庭園 4階/gi;
s/\bGarden of Eva - 5th level\b/エヴァの水中庭園 5階/gi;
s/\bGarden of Eva\b/エヴァの水中庭園/gi;

s/\bVarka Silenos Village\b/バルカ シレノス ヴィレッジ/gi;
s/\bVarka Silenos Outpost\b/バルカシレノス駐屯地/g;
s/\bVarka Silenos Stronghold\b/バルカシレノス駐屯地/gi;
s/\bKetra Orc Village\b/ケトラー オーク ヴィレッジ/gi;
s/\bKetra Orc Outpost\b/ケトラー オーク アウトポスト/gi;

s/\bDevil's Pass\b/死霊の関門/gi;
s/\bGarden of Wild Beasts\b/野獣の庭園/gi;	#freya r2
s/\bThe Center of the Hot Springs\b/温泉地帯 中央/gi;	#freya r2
s/\bHot Springs\b/温泉地帯/gi;
s/\bThe Center of the Wall of Argos\b/アルゴスの壁の中心/gi;	#freya r2
s/\bWall of Argos\b/アルゴスの壁/gi;
s/\bShrine of Loyalty\b/諸侯の参拝地/gi;	#freya r2
s/\bFour Sepulchers\b/四大霊廟/gi;
s/\bImperial Tomb\b/帝国の墓地/gi;

s/\bEntrance to the Forge of the Gods\b/神々の火鉢入口/gi;
s/\bForge of the Gods Entrance\b/神々の火鉢入口/gi;
s/\bForge of the Gods - Top Level\b/神々の火鉢：上層/gi;	#freya r2
s/\bForge of the Gods, Top Level\b/神々の火鉢：上層/gi;	#freya r2
s/\bForge of the Gods - Lower Level\b/神々の火鉢：下層/gi;	#freya r2
s/\bForge of the Gods, lower level\b/神々の火鉢：下層/gi;

s/\bMonastery of Silence\b/沈黙の修道院/gi;

s/\bThe Center of the Forest of the Dead\b/亡者の森の中心/gi;
s/\bForest of the Dead\b/亡者の森/gi;
s/\bThe Center of the Valley of Saints\b/聖者の渓谷の中心/gi;
s/\bValley of Saints\b/聖者の渓谷/gi;
s/\bCursed Village\b/呪われた村/gi;
s/\bStakato Nest\b/スタッカートの巣/gi;
s/\bShyeed's Cavern\b/シャイドの棲み処/gi;	#r7561

s/\bWild Beast Pastures\b/猛獣の放牧地/gi;
s/\bSwamp of Screams\b/悲鳴の沼/gi;
s/\bRune Township Guild\b/ルウン城の村のギルド/gi;
s/\bRune Township Temple\b/ルウン城の村の神殿/g;
s/\bDen of Evil\b/悪霊の棲処/gi;
s/\bPlunderous Plains\b/略奪の荒野/gi;
s/\bFrozen Labyrinth\b/冬の迷宮/gi;
s/\bFrost Lake\b/フロスト湖/gi;
s/\bGrave Robber Hideout\b/盗掘屋の棲家/gi;	#freya r2
s/\bCrypts of Disgrace\b/恥辱の埋葬地/gi;
s/\bSky Wagon Relic\b/空中列車の遺跡/gi;
s/\bPavel Ruins\b/パヴェルの遺跡/gi;
s/\bIce Merchant Cabin\b/氷屋の小屋/gi;	#freya r2
s/\bIceman's Hut\b/氷屋の小屋/gi;	#r9024

s/\bIsle of Souls Harbor\b/魂の島の港/gi;
s/\bStronghold III\b/第3拠点/gi;
s/\bStronghold II\b/第2拠点/gi;
s/\bStronghold I\b/第1拠点/gi;

s/\bIsle of Prayer\b/神託の島/gi;
s/\bPrimeval Isle Wharf\b/太古の島乗船場/gi;
s/\bPrimeval Isle\b/太古の島/gi;

s/\bSeed of Infinity Dock\b/不滅の種 乗船場/gi;	#freya r2
s/\bSeed of Destruction Dock\b/破滅の種 乗船場/gi;	#freya r2
s/\bSeed of Annihilation Dock\b/消滅の種 乗船場/gi;	#freya r2

#----------------------------------------------------------------------------
s/\bTalking Island Village\b/話せる島の村/gi;
s/\bTalking Island\b/話せる島/gi;
s/\bDark Elven Village\b/ダークエルフ村/gi;
s/\bDark Elf Village\b/ダークエルフ村/gi;
s/\bElven Village\b/エルフ村/gi;
s/\bDwarven Village\b/ドワーフ村/gi;
s/\bOrc Village\b/オーク村/gi;
s/\bKamael Village\b/カマエル村/gi;

s/\bThe Village of Gludin\b/グルーディン村/gi;
s/\bGludin Village\b/グルーディン村/gi;
s/\bGludin Arena\b/グルーディン村決闘場/gi;
s/\bTown of Gludio\b/グルーディオ城の村/gi;
s/\bGludio Castle Town\b/グルーディオ城の村/gi;
s/\bDion Castle Town\b/ディオン城の村/gi;
s/\bTown of Dion\b/ディオン城の村/gi;
s/\bFloran Village\b/フローラン村/gi;
s/\bGiran Castle Town\b/ギラン城の村/gi;
s/\bTown of Giran\b/ギラン城の村/gi;
s/\bGiran Arena\b/ギラン決闘場/gi;
s/\bHunter's Village\b/猟師の村/gi;
s/\bHunters Village\b/猟師の村/gi;
s/\bHunter Village\b/猟師の村/gi;
s/\bAden Castle Town\b/アデン城の村/gi;
s/\bTown of Aden\b/アデン城の村/gi;
s/\bColiseum\b/コロシアム/gi;
s/\bOren Castle Town\b/オーレン城の村/gi;
s/\bTown of Oren\b/オーレン城の村/gi;
s/\bRune Castle Town\b/ルウン城の村/gi;
s/\bRune Township\b/ルウン城の村/gi;
s/\bGoddard Castle Town\b/ゴダード城の村/gi;
s/\bTown of Goddard\b/ゴダード城の村/gi;
s/\bHeine\b/水上都市ハイネス/gi;
s/\bTown of Schuttgart\b/シュチュッツガルト城の村/gi;
s/\bIvory Tower\b/象牙の塔/gi;
s/\bFantasy Island\b/幻想の島/gi;

## 象牙の塔
s/\(Lobby\)/(ロビー)/gi;
s/\(Shopping\)/(商店街)/gi;
s/\(1st Floor\)/(1階)/gi;
s/\(2nd Floor\)/(2階)/gi;
s/\(3rd Floor\)/(3階)/gi;
s/\(4th Floor\)/(4階)/gi;

#----------------------------------------------------------------------------
##未チェック##
s/\bDeath Path\b/死の回廊/gi;
s/\bDVC Entrance\b/ドラゴンバレー入り口/gi;
s/\bForbidden Gateway\b/国立墓地とシーレンの封印の間/gi;
##未チェック##
#----------------------------------------------------------------------------
# s/\bThe (?=[\x{1000}-\x{FFFF}])//gi;	# /The ○○村/○○村/
#------------------------------------------------------------------------------
		$ERROR_HEADER = undef;
		$text = $_;
		next if $text eq $original;

		open FILE, '>'.$encode, FS($outPath) or die "'$outPath' $!";
		print FILE $text;
		close FILE;
		utime $mtime, $mtime, FS($outPath);

		if ($LOG) {{
		my $i = &minidiff($text, $original);
		print  '+',$outPath,"($i)\n";
		print LOG  $outPath,"($i)\n";
		}}
	}
}

sub minidiff {
	my ($textA, $textB) = @_;

	$textA =~ s/^\x{FEFF}//;
	$textB =~ s/^\x{FEFF}//;
	my @A = split /\n/,$textA;
	my @B = split /\n/,$textB;
	my $min = $#A <= $#B ? $#A : $#B;
	for (my $i=0; $i <=$min; ++$i) {
		return $i+1 if $A[$i] ne $B[$i];
	}
	return 0;
}
