/*
 * Copyright (C) 2004-2013 L2J Server
 * 
 * This file is part of L2J Server.
 * 
 * L2J Server is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J Server is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.olympiad.Olympiad;

/**
 * Olympiad Npc's Instance
 * @author godson
 */
public class L2OlympiadManagerInstance extends L2Npc
{
	public L2OlympiadManagerInstance(int objectId, L2NpcTemplate template)
	{
		super(objectId, template);
		setInstanceType(InstanceType.L2OlympiadManagerInstance);
	}
	
	public void showChatWindow(L2PcInstance player, int val, String suffix)
	{
		String filename;
		if (val == 0)
		{
			filename = Olympiad.OLYMPIAD_HTML_PATH + "noble_main.htm";
		}
		else
		{
			StringBuilder s = new StringBuilder(128)
				.append(Olympiad.OLYMPIAD_HTML_PATH)
				.append("noble_desc")
				.append(val);
			if (suffix != null) s.append(suffix);
			s.append(".htm");
			filename = s.toString();
		}
		showChatWindow(player, filename);
		
	//	String filename = Olympiad.OLYMPIAD_HTML_PATH;
	//	
	//	filename += "noble_desc" + val;
	//	filename += (suffix != null) ? suffix + ".htm" : ".htm";
	//	
	//	if (filename.equals(Olympiad.OLYMPIAD_HTML_PATH + "noble_desc0.htm"))
	//	{
	//		filename = Olympiad.OLYMPIAD_HTML_PATH + "noble_main.htm";
	//	}
	//	
	//	showChatWindow(player, filename);
	}
}
