## Active Perl 5.8.8
use utf8;
use warnings;
use strict;
binmode STDOUT,'encoding(cp932)';

open CSV, '<:utf8', 'temp/sysstring-j.txt'  or die $!;
my $mtime = (stat CSV)[9];

open TXT, '>:utf8', 'sysstring.txt'  or die $!;
print TXT "id\tname
";

<CSV>; # skip header
while (not eof CSV) {
	my $buf = <CSV>;
	chomp $buf;
	my @field = split /\t/, $buf;
	foreach (@field) {s/^[ua],//; s/\\0//; s/\\\\n/\\n/g}
	my ($id,$name) = ($field[0],$field[1]);
	print "$id\r";

	print TXT "$id\t$name\n";
}
close TXT;
utime $mtime,$mtime,'sysstring.txt';

close CSV;
print "\n";
