﻿<?php
/**
 * Account(user) profile module file
 * New account profile module all in one now (ability to display account info from search if premission)
 * @author Lauri Lüüs <mad@webpoint.ee>
 * @version $Id: AccountProfile.php 17 2005-05-29 18:20:31Z madest $
 * @package AccountManager
 * @filesource
 */
 
/**
 * Password changing panel
 */
require('classes/modules/AccountPassword.php');

/**
 * Access changing panel
 */
require('classes/modules/AccountEdit.php');
 

/**
 * Account profile class
 * User can login and see he's characters and stats and change password
 * @author Lauri Lüüs <mad@webpoint.ee>
 * @version $Id: AccountProfile.php 17 2005-05-29 18:20:31Z madest $
 * @package AccountManager
 */
class AccountProfile extends Module 
{
	/**
	 * Account what data will be shown
	 */
	var $account;
	
	/**
	 * Account info constructor
	 */
	function AccountProfile()
	{
		$this->Module();
		// Default content will be owerrided when user is logged
		$loginPanel = new Loginpanel();
		$this->setActiveuser();
		$this->output = $loginPanel->output;
		
		// If user is logging out
		if(isset($_GET['do']))
		{
			if($_GET['do']=="quit") 
			{
				$loginPanel->logOut();			
			}
		}	
					
		
		if($this->is_logged()==true)
		{
			if($this->template = temp_load($this->config->manager['template_path'].'account_profile.htm'))
			{
				// Get account
				if (isset($_GET['id'])) 
				{
					if($this->active_user->is_admin() == true)
					{
						$this->account = new Account($_GET['id']);
					} else {
						$this->account = $this->active_user;
					}
				} else {
					$this->account = new Account($this->active_user->login);
				}	

				// If that account exists
				if($this->account->get()== true)
				{
					$this->actions();
					$this->template = $this->template."<br>\n".$this->panel_actions();
					$this->panel();
					$this->output = $this->template;
					$this->output .= "<font color=red>";
					$this->parseMessages();
					$this->output .= "</font>";
					
				} else {
					$this->output = "<font color=red>アカウントはありません。</font>";
				}
			} else {
				$this->output = "Class: アカウント情報のテンプレートがありません。";
			}						
		}
	}
	
	/**
	 * Actions you can do from Account panel
	 */
	function panel_actions()
	{
		$content = "";
		if(isset($_GET['do']))
		{			
			switch ($_GET['do']) {				
				
				case "pwd":	//Account change password
					if($this->config->user['set_pass']==true || $this->active_user->is_Admin() ==true)
					{
						$passwordForm = new AccountPassword($this->account->login);
						$content = $passwordForm->output;
					} else {						
						$content = "<font color=red>パスワードを変更できません。</font>";	
					}
					break;
					
				case "access":	// Account change access
					if($this->active_user->is_admin() == true)
					{
						$accessForm = new AccountEdit($this->account->login, $this->account->password);
						$content = $accessForm->output;
					} else {
						$content = "<font color=red>管理者権限ではありません。</font>";
					}
					break;
				default:
					break;
			}
		}
		// Returns content from Set_access and Set_password modules if set.
		return $content;
	}
	
	/**
	 * Account panel content creation
	 */
	function panel()
	{
		$this->account->get(); // Refresh account data
		$profile['login'] = $this->account->login;
		$profile['lastactive'] = $this->account->lastactive;
		$profile['access_level'] = $this->account->access_level;
		
		if($this->account->is_admin() == true)
		{
			$profile['ManagerAdmin'] = "有効";
		} else {
			$profile['ManagerAdmin'] = "無効";
		}
				
		//Block Start
		$charBlock = temp_lock($this->template, "characters");
		$q = mysql_query("SELECT * FROM characters WHERE account_name = '{$this->account->login}'");
		while ($r = mysql_fetch_array($q))
		{
			$className = @mysql_fetch_array(mysql_query("SELECT ClassName FROM char_templates WHERE ClassId={$r['classid']}"));
			$r['class'] = $className['ClassName'];
			$charBlock['add'] = temp_subs($charBlock['tpl'], "char", $r);
			$charBlock = temp_done($charBlock);
		}
		$this->template = temp_unlock($charBlock, "characters");
		// Block end
		
		$this->template = temp_subs($this->template, "account", $profile);	
	}
	
	/**
	 * Actions done before displaying enything
	 */
	function actions()
	{
		if(isset($_GET['del']))
		{
			if(is_numeric($_GET['del']))
			{
				if($this->account->is_yourchar($_GET['del']))
				{				
					$charId = $_GET['del'];
					$char = new Character($charId);
					
					if($this->config->user['can_delete'] == true)
					{											
						$this->addMessage("Character {$char->char_name} deleted");
						$char->delete();			
											
					} elseif ($this->active_user->is_admin() == true && $this->active_user->can_delete() == true) {
						$this->addMessage("Admin: Character {$char->char_name} deleted");
						$char->delete();
						
					} else {
						$this->addMessage("あなたは削除するための権限がありません。");
					}
				} else {
					$this->addMessage("あなたのキャラクターではありません。またはキャラクターが存在しません。");
				}
			} else {
				$this->addMessage("あなたのキャラクターではありません。またはキャラクターが存在しません。");
			}
		}
	}
}
?>