/*
 * Copyright (C) 2004-2013 L2J Server
 * 
 * This file is part of L2J Server.
 * 
 * L2J Server is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J Server is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.l2jserver.gameserver.network;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.clientstrings.Builder;
import com.l2jserver.gameserver.network.serverpackets.ExShowScreenMessage;

import gnu.trove.map.hash.TIntObjectHashMap;

/**
 * NpcStringId implementation, based on SystemMessageId class
 * @author mrTJO
 */
public final class NpcStringId
{
	private static final Logger _log = Logger.getLogger(NpcStringId.class.getName());
	private static final NSLocalisation[] EMPTY_NSL_ARRAY = new NSLocalisation[0];
	public static final NpcStringId[] EMPTY_ARRAY = new NpcStringId[0];
	
	/**
	 * ID: 1<br>
	 * Message: ߂܂āB$s1łBNbNbAO$s2HqbqbqbB<br>
	 * Message: &#20320;&#22909;&#65281;&#25105;&#26159;&#12300;&#36;&#115;&#49;&#12301;&#12290;&#21621;&#21621;&#65292;&#20320;&#26159;&#12300;&#36;&#115;&#50;&#12301;&#21543;&#65311;&#22075;&#22075;&#22075;&#12290;<br>
	 * Message: Hello! I am $s1. You are $s2, right? Hehehe
	 */
	public static final NpcStringId HELLO_I_AM_S1_YOU_ARE_S2_RIGHT_HEHEHE;
	
	/**
	 * ID: 2<br>
	 * Message: $s1--$s2--$s3--$s4//$s5 qbqbqbB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#45;&#45;&#12300;&#36;&#115;&#50;&#12301;&#45;&#45;&#12300;&#36;&#115;&#51;&#12301;&#45;&#45;&#12300;&#36;&#115;&#52;&#12301;&#47;&#47;&#12300;&#36;&#115;&#53;&#12301;&#22075;&#22075;&#22075;&#12290;<br>
	 * Message: $s1--$s2--$s3--$s4//$s5 Hehehe
	 */
	public static final NpcStringId S1_S2_S3_S4_S5_HEHEHE;
	
	/**
	 * ID: 5<br>
	 * Message: $s1/$s2 $s3 Ɏ̎gpƂB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#47;&#12300;&#36;&#115;&#50;&#12301;&#12300;&#36;&#115;&#51;&#12301;&#40670;&#65292;&#23559;&#26371;&#21295;&#20986;&#19979;&#27425;&#30340;&#20351;&#29992;&#36027;&#12290;<br>
	 * Message: Withdraw the fee for the next time at $s1/$s2 $s3
	 */
	public static final NpcStringId WITHDRAW_THE_FEE_FOR_THE_NEXT_TIME_AT_S1_S2_S4;
	
	/**
	 * ID: 8<br>
	 * Message: iK<br>
	 * Message: &#38542;&#27573;<br>
	 * Message: Stage
	 */
	public static final NpcStringId STAGE;
	
	/**
	 * ID: 9<br>
	 * Message: $s1iK<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#38542;&#27573;<br>
	 * Message: Stage $s1
	 */
	public static final NpcStringId STAGE_S1;
	
	/**
	 * ID: 10<br>
	 * Message: $s1%%<br>
	 * Message: &#12300;&#36;&#115;&#49;&#37;&#37;&#12301;<br>
	 * Message: $s1%%
	 */
	public static final NpcStringId S1;
	
	/**
	 * ID: 2004<br>
	 * Message: AɉłB<br>
	 * Message: &#24744;&#29694;&#22312;&#23565;&#25105;&#20570;&#20102;&#20160;&#40637;&#21602;&#65311;<br>
	 * Message: What did you just do to me?
	 */
	public static final NpcStringId WHAT_DID_YOU_JUST_DO_TO_ME;
	
	/**
	 * ID: 2005<br>
	 * Message: Ȃ悤ƁH`<br>
	 * Message: &#24819;&#35201;&#39348;&#26381;&#25105;&#21834;&#65311;&#21029;&#36889;&#27171;&#22043;&#126;<br>
	 * Message: Are you trying to tame me? Don't do that!
	 */
	public static final NpcStringId ARE_YOU_TRYING_TO_TAME_ME_DONT_DO_THAT;
	
	/**
	 * ID: 2006<br>
	 * Message: Ȃ̂ȂĂłBȂȂȂ邩H<br>
	 * Message: &#21029;&#20877;&#32102;&#25105;&#37027;&#31278;&#26481;&#35199;&#65292;&#35498;&#19981;&#23450;&#26371;&#23475;&#20320;&#38519;&#20837;&#21361;&#38570;&#30340;&#12290;<br>
	 * Message: Don't give such a thing. You can endanger yourself!
	 */
	public static final NpcStringId DONT_GIVE_SUCH_A_THING_YOU_CAN_ENDANGER_YOURSELF;
	
	/**
	 * ID: 2007<br>
	 * Message: ybybDDDȂ񂾂H<br>
	 * Message: &#21624;&#21624;&#46;&#46;&#20160;&#40637;&#26481;&#35199;&#36889;&#40637;&#38627;&#21507;&#21834;&#65311;<br>
	 * Message: Yuck! What is this? It tastes terrible!
	 */
	public static final NpcStringId YUCK_WHAT_IS_THIS_IT_TASTES_TERRIBLE;
	
	/**
	 * ID: 2008<br>
	 * Message: 󂢂`Ƃ傤B<br>
	 * Message: &#32922;&#23376;&#39187;&#20102;&#65292;&#20877;&#32102;&#25105;&#19968;&#40670;&#21543;&#12290;<br>
	 * Message: I'm hungry. Give me a little more, please.
	 */
	public static final NpcStringId IM_HUNGRY_GIVE_ME_A_LITTLE_MORE_PLEASE;
	
	/**
	 * ID: 2009<br>
	 * Message: HHוH<br>
	 * Message: &#36889;&#26159;&#20160;&#40637;&#65311;&#21487;&#20197;&#21507;&#21966;&#65311;<br>
	 * Message: What is this? Is this edible?
	 */
	public static final NpcStringId WHAT_IS_THIS_IS_THIS_EDIBLE;
	
	/**
	 * ID: 2010<br>
	 * Message: قƂĂB<br>
	 * Message: &#21029;&#31649;&#25105;&#12290;<br>
	 * Message: Don't worry about me.
	 */
	public static final NpcStringId DONT_WORRY_ABOUT_ME;
	
	/**
	 * ID: 2011<br>
	 * Message: ́A肪ƂB<br>
	 * Message: &#35613;&#35613;&#20320;&#32102;&#25105;&#22909;&#21507;&#30340;&#39135;&#29289;&#12290;<br>
	 * Message: Thank you. That was delicious!
	 */
	public static final NpcStringId THANK_YOU_THAT_WAS_DELICIOUS;
	
	/**
	 * ID: 2012<br>
	 * Message: iXȂDɂȂĂB<br>
	 * Message: &#22909;&#20687;&#36234;&#20358;&#36234;&#21916;&#27489;&#20320;&#20102;&#32822;&#65311;<br>
	 * Message: I think I am starting to like you!
	 */
	public static final NpcStringId I_THINK_I_AM_STARTING_TO_LIKE_YOU;
	
	/**
	 * ID: 2013<br>
	 * Message: L[L[B<br>
	 * Message: &#21564;&#126;&#126;&#21564;&#126;&#126;<br>
	 * Message: Eeeeek! Eeeeek!
	 */
	public static final NpcStringId EEEEEK_EEEEEK;
	
	/**
	 * ID: 2014<br>
	 * Message: Ȃ̂͂߂ȁB̋C͂ȂB<br>
	 * Message: &#21029;&#24819;&#39348;&#26381;&#25105;&#65292;&#25105;&#21487;&#19981;&#24819;&#34987;&#39348;&#26381;&#21602;&#12290;<br>
	 * Message: Don't keep trying to tame me. I don't want to be tamed.
	 */
	public static final NpcStringId DONT_KEEP_TRYING_TO_TAME_ME_I_DONT_WANT_TO_BE_TAMED;
	
	/**
	 * ID: 2015<br>
	 * Message: ̃GT낤Bʂɂ񂽂̎ł񂾂B<br>
	 * Message: &#23565;&#25105;&#20358;&#35498;&#21482;&#19981;&#36942;&#26159;&#39135;&#29289;&#32780;&#24050;&#65292;&#35498;&#19981;&#23450;&#20063;&#26371;&#32879;&#24819;&#21040;&#20320;&#30340;&#25163;&#21543;&#12290;<br>
	 * Message: It is just food to me. Although it may also be your hand.
	 */
	public static final NpcStringId IT_IS_JUST_FOOD_TO_ME_ALTHOUGH_IT_MAY_ALSO_BE_YOUR_HAND;
	
	/**
	 * ID: 2016<br>
	 * Message: ȐHׂ瑾ႤBKcKcB<br>
	 * Message: &#36889;&#27171;&#21507;&#19979;&#21435;&#26371;&#30332;&#32982;&#21543;&#65311;&#22909;&#21507;&#22909;&#21507;&#46;&#46;&#46;<br>
	 * Message: If I keep eating like this, won't I become fat? *chomp chomp*
	 */
	public static final NpcStringId IF_I_KEEP_EATING_LIKE_THIS_WONT_I_BECOME_FAT_CHOMP_CHOMP;
	
	/**
	 * ID: 2017<br>
	 * Message: ŐHו΂̂ȁH<br>
	 * Message: &#24590;&#40637;&#19968;&#30452;&#32102;&#25105;&#26481;&#35199;&#21507;&#21602;&#65311;<br>
	 * Message: Why do you keep feeding me?
	 */
	public static final NpcStringId WHY_DO_YOU_KEEP_FEEDING_ME;
	
	/**
	 * ID: 2018<br>
	 * Message: MȁB؂邩ȂB<br>
	 * Message: &#21029;&#30456;&#20449;&#25105;&#65292;&#25105;&#24597;&#25105;&#26371;&#32972;&#21467;&#20320;&#12290;<br>
	 * Message: Don't trust me. I'm afraid I may betray you later.
	 */
	public static final NpcStringId DONT_TRUST_ME_IM_AFRAID_I_MAY_BETRAY_YOU_LATER;
	
	/**
	 * ID: 2019<br>
	 * Message: ODDD<br>
	 * Message: &#21564;&#46;&#46;&#46;<br>
	 * Message: Grrrrr....
	 */
	public static final NpcStringId GRRRRR;
	
	/**
	 * ID: 2020<br>
	 * Message: O珵ƂI<br>
	 * Message: &#36889;&#37117;&#26159;&#20320;&#23475;&#30340;&#46;&#46;&#46;&#65281;<br>
	 * Message: You brought this upon yourself...!
	 */
	public static final NpcStringId YOU_BROUGHT_THIS_UPON_YOURSELF;
	
	/**
	 * ID: 2021<br>
	 * Message: I̒ɂ悩ʊI<br>
	 * Message: &#25105;&#30340;&#24863;&#35258;&#26377;&#40670;&#22855;&#24618;&#46;&#46;&#46;&#65281;&#25105;&#24515;&#20013;&#30340;&#24801;&#24847;&#46;&#46;&#46;&#65281;<br>
	 * Message: I feel strange...! I keep having these evil thoughts...!
	 */
	public static final NpcStringId I_FEEL_STRANGE_I_KEEP_HAVING_THESE_EVIL_THOUGHTS;
	
	/**
	 * ID: 2022<br>
	 * Message: ǁDDDȂ񂾂ȁB<br>
	 * Message: &#32080;&#26524;&#46;&#46;&#32;&#31455;&#28982;&#35722;&#25104;&#36889;&#27171;&#20102;&#12290;<br>
	 * Message: Alas... so this is how it all ends...
	 */
	public static final NpcStringId ALAS_SO_THIS_IS_HOW_IT_ALL_ENDS;
	
	/**
	 * ID: 2023<br>
	 * Message: ꂵDDDꂵ悤DDD<br>
	 * Message: &#22909;&#30171;&#33510;&#46;&#46;&#46;&#22909;&#30171;&#33510;&#21834;&#46;&#46;&#46;&#65281;<br>
	 * Message: I don't feel so good... Oh, my mind is very troubled...!
	 */
	public static final NpcStringId I_DONT_FEEL_SO_GOOD_OH_MY_MIND_IS_VERY_TROUBLED;
	
	/**
	 * ID: 2024<br>
	 * Message: $s1AȂĂȂ񂾂낤H<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#25152;&#35586;&#34987;&#39348;&#26381;&#26159;&#25351;&#20160;&#40637;&#21602;&#65311;<br>
	 * Message: $s1, so what do you think it is like to be tamed?
	 */
	public static final NpcStringId S1_SO_WHAT_DO_YOU_THINK_IT_IS_LIKE_TO_BE_TAMED;
	
	/**
	 * ID: 2025<br>
	 * Message: $s1AXpCX邽тɁA񂽂̎肪ȂȂB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#20598;&#29246;&#30475;&#21040;&#39321;&#26009;&#26178;&#65292;&#26371;&#24819;&#36215;&#20320;&#37027;&#36958;&#32102;&#25105;&#39321;&#26009;&#30340;&#25163;&#12290;<br>
	 * Message: $s1, whenever I see spice, I think I will miss your hand that used to feed it to me.
	 */
	public static final NpcStringId S1_WHENEVER_I_SEE_SPICE_I_THINK_I_WILL_MISS_YOUR_HAND_THAT_USED_TO_FEED_IT_TO_ME;
	
	/**
	 * ID: 2026<br>
	 * Message: $s1Aɂ͍sȂŁB܂ōs͂ȂB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#21029;&#22238;&#26449;&#33674;&#21543;&#65292;&#25105;&#27794;&#21147;&#27683;&#36319;&#19978;&#24744;&#12290;<br>
	 * Message: $s1, don't go to the village. I don't have the strength to follow you.
	 */
	public static final NpcStringId S1_DONT_GO_TO_THE_VILLAGE_I_DONT_HAVE_THE_STRENGTH_TO_FOLLOW_YOU;
	
	/**
	 * ID: 2027<br>
	 * Message: MĂĂ肪ƂA$s1BȂ̖ɗĂƂ񂾂DDD<br>
	 * Message: &#35613;&#35613;&#24744;&#30456;&#20449;&#25105;&#65292;&#12300;&#36;&#115;&#49;&#12301;&#65292;&#30495;&#24076;&#26395;&#25105;&#20063;&#33021;&#24171;&#24471;&#19978;&#24537;&#46;&#46;&#46;<br>
	 * Message: Thank you for trusting me, $s1. I hope I will be helpful to you.
	 */
	public static final NpcStringId THANK_YOU_FOR_TRUSTING_ME_S1_I_HOPE_I_WILL_BE_HELPFUL_TO_YOU;
	
	/**
	 * ID: 2028<br>
	 * Message: $s1AȂ̖ɗĂ邩ȁH<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#24744;&#35258;&#24471;&#25105;&#33021;&#24171;&#24471;&#19978;&#24537;&#21966;&#65311;<br>
	 * Message: $s1, will I be able to help you?
	 */
	public static final NpcStringId S1_WILL_I_BE_ABLE_TO_HELP_YOU;
	
	/**
	 * ID: 2029<br>
	 * Message: ΂I悢I<br>
	 * Message: &#21152;&#27833;&#65281;&#21568;&#21628;&#65281;<br>
	 * Message: I guess it's just my animal magnetism.
	 */
	public static final NpcStringId I_GUESS_ITS_JUST_MY_ANIMAL_MAGNETISM;
	
	/**
	 * ID: 2030<br>
	 * Message: HVł߂ˁBB<br>
	 * Message: &#23565;&#19981;&#36215;&#65292;&#25105;&#26159;&#20491;&#36010;&#21507;&#39740;&#65292;&#22909;&#21507;&#22909;&#21507;&#46;&#46;&#46;<br>
	 * Message: Too much spicy food makes me sweat like a beast.
	 */
	public static final NpcStringId TOO_MUCH_SPICY_FOOD_MAKES_ME_SWEAT_LIKE_A_BEAST;
	
	/**
	 * ID: 2031<br>
	 * Message: ȂƑ킹̂yɂȂĂB<br>
	 * Message: &#33287;&#24744;&#21512;&#20316;&#36234;&#20358;&#36234;&#26377;&#40664;&#22865;&#20102;&#12290;<br>
	 * Message: Animals need love too.
	 */
	public static final NpcStringId ANIMALS_NEED_LOVE_TOO;
	
	/**
	 * ID: 2032<br>
	 * Message: `Ă낤I<br>
	 * Message: &#25105;&#20358;&#24171;&#24744;&#65281;<br>
	 * Message: What'd I miss? What'd I miss?
	 */
	public static final NpcStringId WHATD_I_MISS_WHATD_I_MISS;
	
	/**
	 * ID: 2033<br>
	 * Message: VCȁBsNjbNłsB<br>
	 * Message: &#22825;&#27683;&#30495;&#22909;&#65292;&#21435;&#37066;&#36938;&#24590;&#40636;&#27171;&#65311;<br>
	 * Message: I just know before this is over, I'm gonna need a lot of serious therapy.
	 */
	public static final NpcStringId I_JUST_KNOW_BEFORE_THIS_IS_OVER_IM_GONNA_NEED_A_LOT_OF_SERIOUS_THERAPY;
	
	/**
	 * ID: 2034<br>
	 * Message: ƂĂȂCɓ킯ȂDDD́ÁDDD<br>
	 * Message: &#25105;&#20006;&#19981;&#26159;&#29305;&#21029;&#23565;&#24744;&#28415;&#24847;&#65281;&#21482;&#26159;&#22240;&#28858;&#46;&#46;&#46;&#46;<br>
	 * Message: I sense great wisdom in you... I'm an animal, and I got instincts.
	 */
	public static final NpcStringId I_SENSE_GREAT_WISDOM_IN_YOU_IM_AN_ANIMAL_AND_I_GOT_INSTINCTS;
	
	/**
	 * ID: 2035<br>
	 * Message: 痣ȁB݂͂ĂȂȂ邼B<br>
	 * Message: &#21482;&#35201;&#21029;&#38626;&#38283;&#36889;&#35041;&#65292;&#37027;&#40637;&#25105;&#23601;&#33021;&#24171;&#24744;&#20102;<br>
	 * Message: Remember, I'm here to help.
	 */
	public static final NpcStringId REMEMBER_IM_HERE_TO_HELP;
	
	/**
	 * ID: 2036<br>
	 * Message: ɗĂ̂ȂAB<br>
	 * Message: &#25105;&#26377;&#24171;&#19978;&#24537;&#21966;&#65311;<br>
	 * Message: Are we there yet?
	 */
	public static final NpcStringId ARE_WE_THERE_YET;
	
	/**
	 * ID: 2037<br>
	 * Message: Hׂ邱ƈȊOɂł񂾂Ă΁I<br>
	 * Message: &#25105;&#19981;&#21482;&#26159;&#20491;&#39151;&#26742;&#21862;&#65281;<br>
	 * Message: That really made me feel good to see that.
	 */
	public static final NpcStringId THAT_REALLY_MADE_ME_FEEL_GOOD_TO_SEE_THAT;
	
	/**
	 * ID: 2038<br>
	 * Message: AAA[I<br>
	 * Message: &#22079;&#21568;&#65292;&#21917;&#21568;&#65292;&#21834;&#21568;&#65292;&#21756;&#21568;&#65281;<br>
	 * Message: Oh, no, no, no, Nooooo!
	 */
	public static final NpcStringId OH_NO_NO_NO_NOOOOO;
	
	/**
	 * ID: 2150<br>
	 * Message: ̖Ŵ͒NB<br>
	 * Message: &#26159;&#35504;&#21483;&#37266;&#25105;&#12290;<br>
	 * Message: Who awoke me?
	 */
	public static final NpcStringId WHO_AWOKE_ME;
	
	/**
	 * ID: 2151<br>
	 * Message: $s1lAll̖ɂAē܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#20381;&#29031;&#20027;&#20154;&#30340;&#21629;&#20196;&#65292;&#25105;&#23559;&#24341;&#23566;&#24744;&#12290;<br>
	 * Message: My master has instructed me to be your guide, $s1.
	 */
	public static final NpcStringId MY_MASTER_HAS_INSTRUCTED_ME_TO_BE_YOUR_GUIDE_S1;
	
	/**
	 * ID: 2152<br>
	 * Message: $s1lA̖{I𒲂ׂĂB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#35531;&#35519;&#26597;&#19968;&#19979;&#36889;&#20491;&#26360;&#27331;&#12290;<br>
	 * Message: Please check this bookcase, $s1.
	 */
	public static final NpcStringId PLEASE_CHECK_THIS_BOOKCASE_S1;
	
	/**
	 * ID: 2250<br>
	 * Message: $s1Ƃ҂AĂ񂾂̂͂ODDD<br>
	 * Message: &#21517;&#21483;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#20154;&#21834;&#65292;&#21628;&#21914;&#25105;&#30340;&#20154;&#23601;&#26159;&#20320;&#21966;&#46;&#46;&#46;&#65311;<br>
	 * Message: Did you call me, $s1?
	 */
	public static final NpcStringId DID_YOU_CALL_ME_S1;
	
	/**
	 * ID: 2251<br>
	 * Message: ӎh炮DDD߂ȂĂ͂ȂȂ̂DDD<br>
	 * Message: &#31934;&#31070;&#28040;&#25955;&#46;&#46;&#32;&#29694;&#22312;&#26159;&#19981;&#26159;&#22238;&#21435;&#30340;&#26178;&#21051;&#46;&#46;&#46;<br>
	 * Message: I'm confused! Maybe it's time to go back.
	 */
	public static final NpcStringId IM_CONFUSED_MAYBE_ITS_TIME_TO_GO_BACK;
	
	/**
	 * ID: 2450<br>
	 * Message: A̐ẂI<br>
	 * Message: &#37027;&#20491;&#65292;&#37027;&#20491;&#32854;&#27161;&#26159;&#46;&#46;&#46;&#46;&#65281;<br>
	 * Message: That sign!
	 */
	public static final NpcStringId THAT_SIGN;
	
	/**
	 * ID: 2550<br>
	 * Message: ̔͂llB $s1 GĂ͂ȂʂI<br>
	 * Message: &#37027;&#20491;&#31665;&#23376;&#26159;&#20027;&#20154;&#35242;&#33258;&#23553;&#38281;&#30340;&#65292;&#12300;&#36;&#115;&#49;&#12301;&#65292;&#20320;&#19981;&#21487;&#20197;&#21435;&#30896;&#37027;&#20491;&#31665;&#23376;&#65281;<br>
	 * Message: That box was sealed by my master, $s1! Don't touch it!
	 */
	public static final NpcStringId THAT_BOX_WAS_SEALED_BY_MY_MASTER_S1_DONT_TOUCH_IT;
	
	/**
	 * ID: 2551<br>
	 * Message: s̐̂ł鎄|Ƃ́BO͂܂A̎̉󂯂ҁIH<br>
	 * Message: &#20320;&#31455;&#33021;&#27578;&#27515;&#25105;&#36889;&#19981;&#27515;&#20043;&#36544;&#65292;&#38627;&#36947;&#20320;&#26159;&#21463;&#38936;&#20027;&#24199;&#35703;&#30340;&#46;&#46;&#46;&#65311;&#65281;<br>
	 * Message: You've ended my immortal life! You're protected by the feudal lord, aren't you?
	 */
	public static final NpcStringId YOUVE_ENDED_MY_IMMORTAL_LIFE_YOURE_PROTECTED_BY_THE_FEUDAL_LORD_ARENT_YOU;
	
	/**
	 * ID: 4151<br>
	 * Message: zBCB\nS҈ēl̂ƂɍsĂB<br>
	 * Message: &#36865;&#36008;&#20219;&#21209;&#32080;&#26463;&#12290;&#92;&#110;&#35531;&#21435;&#25214;&#21021;&#23416;&#32773;&#22190;&#23566;&#12290;<br>
	 * Message: Delivery duty complete. \\n Go find the Newbie Guide.
	 */
	public static final NpcStringId DELIVERY_DUTY_COMPLETE_N_GO_FIND_THE_NEWBIE_GUIDE;
	
	/**
	 * ID: 4152<br>
	 * Message: Sҗp\E VbglB\nS҈ēl̂ƂɍsĂB<br>
	 * Message: &#24050;&#29554;&#24471;&#21021;&#23416;&#32773;&#29992;&#38728;&#39746;&#24392;&#12290;&#92;&#110;&#35531;&#21435;&#25214;&#21021;&#23416;&#32773;&#22190;&#23566;&#12290;<br>
	 * Message: Acquisition of Soulshot for beginners complete. \\n Go find the Newbie Guide.
	 */
	public static final NpcStringId ACQUISITION_OF_SOULSHOT_FOR_BEGINNERS_COMPLETE_N_GO_FIND_THE_NEWBIE_GUIDE;
	
	/**
	 * ID: 4153<br>
	 * Message: SҗplB\nS҈ēl̂ƂɍsĂB<br>
	 * Message: &#24050;&#29554;&#24471;&#21021;&#23416;&#32773;&#29992;&#27494;&#22120;&#20132;&#25563;&#21048;&#12290;&#92;&#110;&#35531;&#25214;&#21021;&#23416;&#32773;&#22190;&#23566;&#23565;&#35527;&#12290;<br>
	 * Message: Acquisition of Weapon Exchange coupon for beginners complete. \\n Go speak with the Newbie Guide.
	 */
	public static final NpcStringId ACQUISITION_OF_WEAPON_EXCHANGE_COUPON_FOR_BEGINNERS_COMPLETE_N_GO_SPEAK_WITH_THE_NEWBIE_GUIDE;
	
	/**
	 * ID: 4154<br>
	 * Message: SҗplB\nS҈ēl̂ƂɍsĂB<br>
	 * Message: &#24050;&#29554;&#24471;&#31278;&#26063;&#27494;&#22120;&#12290;&#92;&#110;&#35531;&#21435;&#25214;&#21021;&#23416;&#32773;&#22190;&#23566;&#12290;<br>
	 * Message: Acquisition of race-specific weapon complete. \\n Go find the Newbie Guide.
	 */
	public static final NpcStringId ACQUISITION_OF_RACE_SPECIFIC_WEAPON_COMPLETE_N_GO_FIND_THE_NEWBIE_GUIDE;
	
	/**
	 * ID: 4155<br>
	 * Message: Ō̔CB\nS҈ēl̂ƂɍsĂB<br>
	 * Message: &#26368;&#24460;&#20219;&#21209;&#24050;&#23436;&#25104;&#12290;&#92;&#110;&#35531;&#21435;&#25214;&#21021;&#23416;&#32773;&#22190;&#23566;&#12290;<br>
	 * Message: Last duty complete. \\n Go find the Newbie Guide.
	 */
	public static final NpcStringId LAST_DUTY_COMPLETE_N_GO_FIND_THE_NEWBIE_GUIDE;
	
	/**
	 * ID: 6051<br>
	 * Message: $s1IO𐶂Ă͂ȂBނ̂ȂA̍DSނ񂾂ȁB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#21435;&#27515;&#21543;&#65292;&#35201;&#24618;&#23601;&#24618;&#20320;&#30340;&#22909;&#22855;&#24515;&#12290;<br>
	 * Message: $s1! I must kill you. Blame your own curiosity.
	 */
	public static final NpcStringId S1_I_MUST_KILL_YOU_BLAME_YOUR_OWN_CURIOSITY;
	
	/**
	 * ID: 6052<br>
	 * Message: ^̂B܂邺B<br>
	 * Message: &#20320;&#36939;&#27683;&#30495;&#22909;&#65292;&#19979;&#27425;&#25105;&#26371;&#20877;&#20358;&#25214;&#20320;&#30340;&#12290;<br>
	 * Message: You have good luck. I shall return.
	 */
	public static final NpcStringId YOU_HAVE_GOOD_LUCK_I_SHALL_RETURN;
	
	/**
	 * ID: 6053<br>
	 * Message: ȂɋƂ͂ȁBsB<br>
	 * Message: &#27794;&#24819;&#21040;&#26371;&#36889;&#40636;&#24375;&#65292;&#25105;&#22833;&#31639;&#20102;&#12290;<br>
	 * Message: You are strong. This was a mistake.
	 */
	public static final NpcStringId YOU_ARE_STRONG_THIS_WAS_A_MISTAKE;
	
	/**
	 * ID: 6054<br>
	 * Message: ǂ̔n̍킩ȂAȂŌo񂾁BI<br>
	 * Message: &#20320;&#26159;&#35504;&#65292;&#28858;&#20160;&#40636;&#25554;&#25163;&#36889;&#22580;&#25171;&#39717;&#65292;&#30495;&#21487;&#24801;&#12290;<br>
	 * Message: Who are you to join in the battle? How upsetting.
	 */
	public static final NpcStringId WHO_ARE_YOU_TO_JOIN_IN_THE_BATTLE_HOW_UPSETTING;
	
	/**
	 * ID: 6451<br>
	 * Message: $s1Aɗ̂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#26159;&#20358;&#24171;&#21161;&#25105;&#30340;&#21966;&#65311;<br>
	 * Message: $s1, did you come to help me?
	 */
	public static final NpcStringId S1_DID_YOU_COME_TO_HELP_ME;
	
	/**
	 * ID: 6551<br>
	 * Message: `bI͈ႤI<br>
	 * Message: &#21756;&#65281;&#36889;&#35041;&#24050;&#32147;&#19981;&#34892;&#20102;&#65281;<br>
	 * Message: Drats! How could I be so wrong??
	 */
	public static final NpcStringId DRATS_HOW_COULD_I_BE_SO_WRONG;
	
	/**
	 * ID: 6552<br>
	 * Message: $s1I̔痣Ỉݕ͉I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#38626;&#38283;&#37027;&#20491;&#31665;&#23376;&#65281;&#37027;&#20491;&#36008;&#29289;&#27512;&#25105;&#25152;&#26377;&#65281;<br>
	 * Message: $s1! Step back from the confounded box! I will take it myself!
	 */
	public static final NpcStringId S1_STEP_BACK_FROM_THE_CONFOUNDED_BOX_I_WILL_TAKE_IT_MYSELF;
	
	/**
	 * ID: 6553<br>
	 * Message: $s1I܂Ŗ߂Ă邼BƂȂ҂ĂI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#25105;&#26202;&#40670;&#20877;&#22238;&#20358;&#65292;&#20054;&#20054;&#31561;&#33879;&#21543;&#65281;<br>
	 * Message: $s1! I will be back soon. Stay there and don't you dare wander off!
	 */
	public static final NpcStringId S1_I_WILL_BE_BACK_SOON_STAY_THERE_AND_DONT_YOU_DARE_WANDER_OFF;
	
	/**
	 * ID: 6554<br>
	 * Message: IȂɂƂ́DDD<br>
	 * Message: &#21917;&#65281;&#31455;&#28982;&#26371;&#34987;&#36889;&#31278;&#20642;&#20249;&#25171;&#25943;&#46;&#46;&#46;<br>
	 * Message: Grr. I've been hit...
	 */
	public static final NpcStringId GRR_IVE_BEEN_HIT;
	
	/**
	 * ID: 6555<br>
	 * Message: IO͉҂IȂ̎ז̂I<br>
	 * Message: &#21917;&#65281;&#20320;&#26159;&#20160;&#40636;&#20154;&#65292;&#31455;&#25954;&#22952;&#31001;&#25105;&#65281;<br>
	 * Message: Grr! Who are you and why have you stopped me?
	 */
	public static final NpcStringId GRR_WHO_ARE_YOU_AND_WHY_HAVE_YOU_STOPPED_ME;
	
	/**
	 * ID: 6556<br>
	 * Message: ƁAԂxĂ܂ȁI<br>
	 * Message: &#31967;&#20102;&#65292;&#26178;&#38291;&#34987;&#24310;&#36978;&#20102;&#65281;<br>
	 * Message: I am late!
	 */
	public static final NpcStringId I_AM_LATE;
	
	/**
	 * ID: 6557<br>
	 * Message: 낵ނI<br>
	 * Message: &#25308;&#35351;&#20102;&#65281;<br>
	 * Message: Good luck!
	 */
	public static final NpcStringId GOOD_LUCK;
	
	/**
	 * ID: 6750<br>
	 * Message: $s1IOɂ͋ւꂽmII<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#36889;&#26159;&#19981;&#23660;&#26044;&#20320;&#20497;&#30340;&#30693;&#35672;&#65292;&#36864;&#19979;&#65281;<br>
	 * Message: $s1! You seek the forbidden knowledge and I cannot let you have it!
	 */
	public static final NpcStringId S1_YOU_SEEK_THE_FORBIDDEN_KNOWLEDGE_AND_I_CANNOT_LET_YOU_HAVE_IT;
	
	/**
	 * ID: 6751<br>
	 * Message: OɋꂽԂ͂܂łDDD<br>
	 * Message: &#38627;&#36947;&#46;&#46;&#46;&#20801;&#35377;&#26044;&#25105;&#30340;&#26178;&#38291;&#65292;&#23601;&#21040;&#27492;&#28858;&#27490;&#20102;&#21966;&#65311;&#46;&#46;&#46;<br>
	 * Message: Is this all I am allowed to have?...
	 */
	public static final NpcStringId IS_THIS_ALL_I_AM_ALLOWED_TO_HAVE;
	
	/**
	 * ID: 6752<br>
	 * Message: A|΁AO͔jł邾낤DDD<br>
	 * Message: &#29694;&#22312;&#38614;&#28982;&#25802;&#25943;&#20102;&#25105;&#65292;&#20294;&#32317;&#26377;&#19968;&#22825;&#20320;&#20497;&#26371;&#36973;&#27584;&#28357;&#30340;&#46;&#46;&#46;<br>
	 * Message: You defeated me, but our doom approaches...
	 */
	public static final NpcStringId YOU_DEFEATED_ME_BUT_OUR_DOOM_APPROACHES;
	
	/**
	 * ID: 6753<br>
	 * Message: $s1I̕ɂȂĂƂĂ񂾁IOA҂I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#20320;&#26159;&#20160;&#40636;&#26481;&#35199;&#65292;&#31455;&#25954;&#27450;&#36000;&#25105;&#30340;&#38568;&#24478;&#65311;<br>
	 * Message: $s1! Who are you? Why are you bothering my minions?
	 */
	public static final NpcStringId S1_WHO_ARE_YOU_WHY_ARE_YOU_BOTHERING_MY_MINIONS;
	
	/**
	 * ID: 6754<br>
	 * Message: AI<br>
	 * Message: &#22909;&#24375;&#21834;&#65281;&#65281;<br>
	 * Message: Beefcake!!
	 */
	public static final NpcStringId BEEFCAKE;
	
	/**
	 * ID: 6755<br>
	 * Message: IĂ߂҂IHזĂ肩B<br>
	 * Message: &#21917;&#65281;&#20320;&#26159;&#20160;&#40636;&#26481;&#35199;&#65292;&#25954;&#25554;&#25163;&#31649;&#38290;&#20107;&#65311;<br>
	 * Message: Grr! Why are you sticking your nose in our business?
	 */
	public static final NpcStringId GRR_WHY_ARE_YOU_STICKING_YOUR_NOSE_IN_OUR_BUSINESS;
	
	/**
	 * ID: 6756<br>
	 * Message: ͂̂炢ɂƂĂ邪A͂Ⴈ˂I<br>
	 * Message: &#29694;&#22312;&#25105;&#26371;&#36864;&#19979;&#65292;&#20294;&#20197;&#24460;&#25105;&#20497;&#26371;&#20877;&#30456;&#35211;&#30340;&#65281;<br>
	 * Message: Farewell and watch your back!
	 */
	public static final NpcStringId FAREWELL_AND_WATCH_YOUR_BACK;
	
	/**
	 * ID: 6757<br>
	 * Message: J}GI悩I͌ɂāAƎ݂ĂȂDDD<br>
	 * Message: &#38343;&#22825;&#20351;&#65281;&#24456;&#39640;&#33288;&#35211;&#21040;&#20320;&#65292;&#31245;&#24460;&#20877;&#25171;&#25307;&#21628;&#65292;&#20808;&#24171;&#24171;&#25105;&#21543;&#46;&#46;&#46;<br>
	 * Message: Kamael! Good to see you. I have something to ask you...
	 */
	public static final NpcStringId KAMAEL_GOOD_TO_SEE_YOU_I_HAVE_SOMETHING_TO_ASK_YOU;
	
	/**
	 * ID: 6758<br>
	 * Message: $s1IARCcÛI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#36245;&#24555;&#25915;&#25802;&#36889;&#20642;&#20249;&#65281;<br>
	 * Message: $s1! Go get him!!
	 */
	public static final NpcStringId S1_GO_GET_HIM;
	
	/**
	 * ID: 6759<br>
	 * Message: $s1IĂAāI񂾁I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#22312;&#24185;&#20160;&#40636;&#65311;&#25171;&#21568;&#65281;&#36245;&#24555;&#25171;&#21568;&#65281;<br>
	 * Message: $s1! What are you doing? Attack him!
	 */
	public static final NpcStringId S1_WHAT_ARE_YOU_DOING_ATTACK_HIM;
	
	/**
	 * ID: 6760<br>
	 * Message: $s1IÕ|eV͂̒xł͂Ȃ͂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#20320;&#30340;&#28507;&#21147;&#19981;&#25033;&#35442;&#21482;&#26377;&#36889;&#27171;&#21568;&#65311;<br>
	 * Message: $s1! Is ? your full potential?
	 */
	public static final NpcStringId S1_IS_YOUR_FULL_POTENTIAL;
	
	/**
	 * ID: 6761<br>
	 * Message: 肪ƂI͍Gǂčs˂΂ȂȂB<br>
	 * Message: &#35613;&#35613;&#65281;&#25105;&#29694;&#22312;&#35201;&#21435;&#36861;&#25802;&#25973;&#20154;&#20102;&#12290;<br>
	 * Message: Thanks! I must go and hunt down those that oppose me.
	 */
	public static final NpcStringId THANKS_I_MUST_GO_AND_HUNT_DOWN_THOSE_THAT_OPPOSE_ME;
	
	/**
	 * ID: 6762<br>
	 * Message: DDD͂ɂǂȂ΂ȂȂDDD<br>
	 * Message: &#36889;&#20642;&#20249;&#30495;&#26377;&#38860;&#24615;&#46;&#46;&#46;&#32;&#25105;&#29694;&#22312;&#35201;&#21435;&#36861;&#25802;&#37027;&#20642;&#20249;&#20102;&#46;&#46;&#46;<br>
	 * Message: You are so stubborn... I must follow him now...
	 */
	public static final NpcStringId YOU_ARE_SO_STUBBORN_I_MUST_FOLLOW_HIM_NOW;
	
	/**
	 * ID: 6763<br>
	 * Message: OȂ^ubg琳𓾂邱Ƃł͂DDD<br>
	 * Message: &#22914;&#26524;&#26159;&#20320;&#30340;&#35441;&#65292;&#25033;&#35442;&#21487;&#20197;&#38936;&#24735;&#21040;&#30707;&#26495;&#19978;&#27491;&#30906;&#30340;&#24847;&#32681;&#46;&#46;&#46;<br>
	 * Message: Seek enlightenment from the Tablet.
	 */
	public static final NpcStringId SEEK_ENLIGHTENMENT_FROM_THE_TABLET;
	
	/**
	 * ID: 6764<br>
	 * Message: ɂ҂IłтI<br>
	 * Message: &#39791;&#33725;&#25345;&#20992;&#20043;&#20154;&#65292;&#28357;&#20129;&#21543;&#65281;<br>
	 * Message: Arrogant beings! You are all doomed!
	 */
	public static final NpcStringId ARROGANT_BEINGS_YOU_ARE_ALL_DOOMED;
	
	/**
	 * ID: 6765<br>
	 * Message: ̎Ŏɗ^ꂽԂ͏IB^悩ȁDDD<br>
	 * Message: &#29694;&#26178;&#27573;&#32102;&#20104;&#25105;&#30340;&#26178;&#38291;&#24050;&#21040;&#65292;&#36208;&#36939;&#20102;&#12290;<br>
	 * Message: My time in your world has come to an end. Consider yourselves lucky...
	 */
	public static final NpcStringId MY_TIME_IN_YOUR_WORLD_HAS_COME_TO_AN_END_CONSIDER_YOURSELVES_LUCKY;
	
	/**
	 * ID: 6766<br>
	 * Message: $s1I_ɑʎ҂ÂI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#19981;&#20449;&#22857;&#31070;&#30340;&#20154;&#65292;&#33213;&#25954;&#65281;&#65281;<br>
	 * Message: $s1! How dare you!!!
	 */
	public static final NpcStringId S1_HOW_DARE_YOU;
	
	/**
	 * ID: 6767<br>
	 * Message: $s1II_ɑʎ҂͊댯DDD<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#21834;&#126;&#65281;&#20320;&#20497;&#37117;&#19981;&#20449;&#22857;&#31070;&#65292;&#21361;&#38570;&#20998;&#23376;&#46;&#46;&#46;<br>
	 * Message: $s1! Ahhaa! Your god forsakes you!
	 */
	public static final NpcStringId S1_AHHAA_YOUR_GOD_FORSAKES_YOU;
	
	/**
	 * ID: 6851<br>
	 * Message: $s1I܂łB낻뎀ł˂΂ȁB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#23601;&#21040;&#27492;&#28858;&#27490;&#21543;&#65292;&#20320;&#30340;&#27515;&#26399;&#21040;&#20102;&#12290;<br>
	 * Message: $s1! Your time is up. Prepare to die a horrible death.
	 */
	public static final NpcStringId S1_YOUR_TIME_IS_UP_PREPARE_TO_DIE_A_HORRIBLE_DEATH;
	
	/**
	 * ID: 6852<br>
	 * Message: ȂƉ^̂߁I͐ċA˂B<br>
	 * Message: &#21756;&#65292;&#36939;&#27683;&#30495;&#22909;&#21834;&#65292;&#19979;&#27425;&#21487;&#23601;&#19981;&#26371;&#27963;&#33879;&#22238;&#21435;&#20102;&#12290;<br>
	 * Message: Consider yourself lucky. The next time we meet, you will die - PERMANENTLY!
	 */
	public static final NpcStringId CONSIDER_YOURSELF_LUCKY_THE_NEXT_TIME_WE_MEET_YOU_WILL_DIE_PERMANENTLY;
	
	/**
	 * ID: 6853<br>
	 * Message: oĂI͂Ⴈ˂I<br>
	 * Message: &#36208;&#33879;&#30631;&#65281;&#25105;&#20497;&#26371;&#20877;&#30456;&#35211;&#30340;&#12290;<br>
	 * Message: Fare thee well! We shall meet again.
	 */
	public static final NpcStringId FARE_THEE_WELL_WE_SHALL_MEET_AGAIN;
	
	/**
	 * ID: 6854<br>
	 * Message: $s1I̕ɂȂĂƂĂ񂾁IOA҂I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#20320;&#26159;&#20160;&#40636;&#26481;&#35199;&#65292;&#31455;&#25954;&#27450;&#36000;&#25105;&#30340;&#38568;&#24478;&#65311;<br>
	 * Message: $s1! Who are you? And better yet, why are you bothering my minions?
	 */
	public static final NpcStringId S1_WHO_ARE_YOU_AND_BETTER_YET_WHY_ARE_YOU_BOTHERING_MY_MINIONS;
	
	/**
	 * ID: 6855<br>
	 * Message: AI<br>
	 * Message: &#22909;&#24375;&#21834;&#65281;&#65281;<br>
	 * Message: Strength beyond strength!!
	 */
	public static final NpcStringId STRENGTH_BEYOND_STRENGTH;
	
	/**
	 * ID: 6856<br>
	 * Message: IĂ߂҂IHזĂ肩B<br>
	 * Message: &#21917;&#65281;&#20320;&#26159;&#20160;&#40636;&#26481;&#35199;&#65292;&#25954;&#25554;&#25163;&#31649;&#38290;&#20107;&#65311;<br>
	 * Message: Grr! Why are you sticking your nose where it doesn't belong?
	 */
	public static final NpcStringId GRR_WHY_ARE_YOU_STICKING_YOUR_NOSE_WHERE_IT_DOESNT_BELONG;
	
	/**
	 * ID: 6857<br>
	 * Message: ͂̂炢ɂƂĂ邪A͂Ⴈ˂I<br>
	 * Message: &#29694;&#22312;&#25105;&#26283;&#26178;&#38626;&#38283;&#65292;&#20294;&#20197;&#24460;&#25105;&#20497;&#26371;&#20877;&#30456;&#35211;&#30340;&#65281;<br>
	 * Message: You've won for now, but we will meet again!
	 */
	public static final NpcStringId YOUVE_WON_FOR_NOW_BUT_WE_WILL_MEET_AGAIN;
	
	/**
	 * ID: 6858<br>
	 * Message: Oɂ悭ǂĂ񂾁BɂB<br>
	 * Message: &#20320;&#36889;&#27171;&#36861;&#25802;&#25105;&#65292;&#19981;&#23244;&#32047;&#21966;&#65311;<br>
	 * Message: Are they tired of following me?
	 */
	public static final NpcStringId ARE_THEY_TIRED_OF_FOLLOWING_ME;
	
	/**
	 * ID: 6859<br>
	 * Message: $s1Iɗ݂͂ĂȂB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#35201;&#19981;&#35201;&#24171;&#25105;&#19968;&#19979;&#65311;<br>
	 * Message: $s1! Can you help me?
	 */
	public static final NpcStringId S1_CAN_YOU_HELP_ME;
	
	/**
	 * ID: 6860<br>
	 * Message: $s1IO̗͂͂Ȃ񂩁B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#20320;&#30340;&#33021;&#21147;&#21482;&#19981;&#36942;&#26159;&#36889;&#27171;&#21966;&#65311;<br>
	 * Message: Is that all you got, little $s1?
	 */
	public static final NpcStringId IS_THAT_ALL_YOU_GOT_LITTLE_S1;
	
	/**
	 * ID: 6861<br>
	 * Message: $s1I΂ČĂ̂IH<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#30332;&#24996;&#22294;&#24375;&#65292;&#19981;&#33021;&#35731;&#37027;&#20642;&#20249;&#36867;&#36305;&#65281;<br>
	 * Message: $s1! Wake up fool! Don't let him get away!
	 */
	public static final NpcStringId S1_WAKE_UP_FOOL_DONT_LET_HIM_GET_AWAY;
	
	/**
	 * ID: 6862<br>
	 * Message: ͂₨O̎ז͂Ȃ낤Bł́A΁I<br>
	 * Message: &#19981;&#26371;&#20877;&#26377;&#20154;&#22952;&#31001;&#20320;&#12290;&#37027;&#40636;&#65292;&#21578;&#36781;&#20102;&#65281;<br>
	 * Message: The path is clear, but be careful!
	 */
	public static final NpcStringId THE_PATH_IS_CLEAR_BUT_BE_CAREFUL;
	
	/**
	 * ID: 6863<br>
	 * Message: UvLGǂȂ΁B܂I<br>
	 * Message: &#35201;&#21435;&#36861;&#26597;&#26222;&#22522;&#29246;&#20102;&#65292;&#24460;&#26371;&#26377;&#26399;&#65281;<br>
	 * Message: I must follow someone now. See you around!
	 */
	public static final NpcStringId I_MUST_FOLLOW_SOMEONE_NOW_SEE_YOU_AROUND;
	
	/**
	 * ID: 6864<br>
	 * Message: ܂̂y݂ɂĂB<br>
	 * Message: &#26399;&#24453;&#19979;&#27425;&#20877;&#35211;&#12290;<br>
	 * Message: May we meet again.
	 */
	public static final NpcStringId MAY_WE_MEET_AGAIN;
	
	/**
	 * ID: 6865<br>
	 * Message: _ɐn҂ɂ͓VI<br>
	 * Message: &#23559;&#21133;&#25351;&#21521;&#31070;&#30340;&#20154;&#23559;&#36973;&#21463;&#22825;&#35700;&#65281;<br>
	 * Message: Curses on those who blaspheme the Gods!
	 */
	public static final NpcStringId CURSES_ON_THOSE_WHO_BLASPHEME_THE_GODS;
	
	/**
	 * ID: 6866<br>
	 * Message: ACnU[hlĂтI͕KVĂ낤I<br>
	 * Message: &#27575;&#28023;&#34217;&#22312;&#21628;&#21914;&#25105;&#65281;&#19979;&#27425;&#19968;&#23450;&#35731;&#20320;&#21463;&#21040;&#22825;&#35700;&#65281;<br>
	 * Message: Einhasad is calling me! You are lucky and I shall continue my punishment later!
	 */
	public static final NpcStringId EINHASAD_IS_CALLING_ME_YOU_ARE_LUCKY_AND_I_SHALL_CONTINUE_MY_PUNISHMENT_LATER;
	
	/**
	 * ID: 6867<br>
	 * Message: $s1I_̖ɂĂOقĂ낤B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#20197;&#31070;&#20043;&#21517;&#65292;&#36899;&#20320;&#20063;&#19968;&#21516;&#34389;&#27770;&#12290;<br>
	 * Message: By the power vested in me by the gods, you $s1, shall die!
	 */
	public static final NpcStringId BY_THE_POWER_VESTED_IN_ME_BY_THE_GODS_YOU_S1_SHALL_DIE;
	
	/**
	 * ID: 6868<br>
	 * Message: $s1IOYȂI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#19981;&#26371;&#24536;&#35352;&#20320;&#30340;&#65281;<br>
	 * Message: $s1! I will not forget you!
	 */
	public static final NpcStringId S1_I_WILL_NOT_FORGET_YOU;
	
	/**
	 * ID: 6950<br>
	 * Message: $s1IxXl̕Sł鉴̎זƂ́DDDˁI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#31455;&#25954;&#22952;&#31001;&#25105;&#36889;&#24052;&#21015;&#26031;&#30340;&#24515;&#33145;&#46;&#46;&#46;&#21435;&#27515;&#21543;&#46;&#46;<br>
	 * Message: $s1! How dare you interfere! You shall pay for this!
	 */
	public static final NpcStringId S1_HOW_DARE_YOU_INTERFERE_YOU_SHALL_PAY_FOR_THIS;
	
	/**
	 * ID: 6951<br>
	 * Message: AxXlĂłB^悩ȁDDD<br>
	 * Message: &#21710;&#21568;&#65281;&#24052;&#21015;&#26031;&#22312;&#21628;&#21914;&#25105;&#65292;&#31639;&#20320;&#36208;&#36939;&#46;&#46;&#46;<br>
	 * Message: Beleth is calling me. You are lucky but still a fool...
	 */
	public static final NpcStringId BELETH_IS_CALLING_ME_YOU_ARE_LUCKY_BUT_STILL_A_FOOL;
	
	/**
	 * ID: 6952<br>
	 * Message: oĂI͂߂ȂȁB<br>
	 * Message: &#36208;&#33879;&#30631;&#65292;&#25105;&#19981;&#26371;&#25918;&#26820;&#30340;&#12290;<br>
	 * Message: I shall take my leave, but will never surrender!
	 */
	public static final NpcStringId I_SHALL_TAKE_MY_LEAVE_BUT_WILL_NEVER_SURRENDER;
	
	/**
	 * ID: 6954<br>
	 * Message: AI<br>
	 * Message: &#22909;&#24375;&#21834;&#65281;&#65281;<br>
	 * Message: Cower before my awesome and mighty power!!
	 */
	public static final NpcStringId COWER_BEFORE_MY_AWESOME_AND_MIGHTY_POWER;
	
	/**
	 * ID: 6955<br>
	 * Message: IĂ߂҂IHזĂ肩B<br>
	 * Message: &#21917;&#65281;&#20320;&#26159;&#20160;&#40636;&#26481;&#35199;&#65292;&#25954;&#25554;&#25163;&#31649;&#38290;&#20107;&#65311;<br>
	 * Message: Grr! Can't you find something better to do with your time?
	 */
	public static final NpcStringId GRR_CANT_YOU_FIND_SOMETHING_BETTER_TO_DO_WITH_YOUR_TIME;
	
	/**
	 * ID: 6956<br>
	 * Message: ͂̂炢ɂƂĂ邪A͂Ⴈ˂I<br>
	 * Message: &#29694;&#22312;&#25105;&#26283;&#26178;&#38626;&#38283;&#65292;&#20294;&#20197;&#24460;&#25105;&#20497;&#26371;&#20877;&#30456;&#35211;&#30340;&#65281;<br>
	 * Message: I shall take my leave, but your head will be mine some day.. Oh yes..yes it will!
	 */
	public static final NpcStringId I_SHALL_TAKE_MY_LEAVE_BUT_YOUR_HEAD_WILL_BE_MINE_SOME_DAY_OH_YESYES_IT_WILL;
	
	/**
	 * ID: 6957<br>
	 * Message: A̎qDDD<br>
	 * Message: &#21834;&#21834;&#65292;&#32;&#25105;&#30340;&#24460;&#32380;&#32773;&#21834;&#46;&#46;&#46;<br>
	 * Message: My children are stronger!
	 */
	public static final NpcStringId MY_CHILDREN_ARE_STRONGER;
	
	/**
	 * ID: 6958<br>
	 * Message: $s1Iꏏɖڂ̑O̓GFEɂ悤ł͂ȂB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#40778;&#24515;&#21332;&#21147;&#28040;&#28357;&#30524;&#21069;&#30340;&#25973;&#20154;&#21543;&#12290;<br>
	 * Message: $s1! Let's kill them all.
	 */
	public static final NpcStringId S1_LETS_KILL_THEM_ALL;
	
	/**
	 * ID: 6959<br>
	 * Message: $s1I΂AqDDD<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#30332;&#24996;&#22294;&#24375;&#21834;&#65292;&#25105;&#30340;&#24460;&#32380;&#32773;&#46;&#46;&#46;<br>
	 * Message: $s1! Come my children...
	 */
	public static final NpcStringId S1_COME_MY_CHILDREN;
	
	/**
	 * ID: 6960<br>
	 * Message: $s1IO̐ݔ\͂ڊo߂̂DDDĜhB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#21914;&#37266;&#20320;&#25152;&#26377;&#30340;&#28507;&#21147;&#46;&#46;&#46;&#21029;&#35731;&#25973;&#20154;&#36867;&#36305;&#12290;<br>
	 * Message: $s1! Muster your strength... Pick them off like chickens.
	 */
	public static final NpcStringId S1_MUSTER_YOUR_STRENGTH_PICK_THEM_OFF_LIKE_CHICKENS;
	
	/**
	 * ID: 6961<br>
	 * Message: 肪ƂAqDDD܂邾낤B<br>
	 * Message: &#35613;&#35613;&#20320;&#65292;&#25105;&#30340;&#24460;&#32380;&#32773;&#46;&#46;&#46;&#32317;&#26377;&#19968;&#22825;&#25105;&#20497;&#26371;&#20877;&#30456;&#35211;&#30340;&#12290;<br>
	 * Message: Thank you my children... Someday, we will meet again.
	 */
	public static final NpcStringId THANK_YOU_MY_CHILDREN_SOMEDAY_WE_WILL_MEET_AGAIN;
	
	/**
	 * ID: 6962<br>
	 * Message: qDDD͓Gǂ˂΂ȂȂB<br>
	 * Message: &#25105;&#30340;&#24460;&#32380;&#32773;&#21834;&#46;&#46;&#46;&#30475;&#20358;&#25105;&#24471;&#21435;&#36861;&#25802;&#25973;&#20154;&#20102;&#12290;<br>
	 * Message: My children... Seek my enemies.
	 */
	public static final NpcStringId MY_CHILDREN_SEEK_MY_ENEMIES;
	
	/**
	 * ID: 6963<br>
	 * Message: qDDDO̖ɏjDDD<br>
	 * Message: &#25105;&#30340;&#24460;&#32380;&#32773;&#21834;&#46;&#46;&#46;&#31069;&#31119;&#20320;&#25152;&#35201;&#36208;&#30340;&#36335;&#46;&#46;&#46;<br>
	 * Message: My children... I grant you my blessings...
	 */
	public static final NpcStringId MY_CHILDREN_I_GRANT_YOU_MY_BLESSINGS;
	
	/**
	 * ID: 6964<br>
	 * Message: ݂Ă͂ȂȂ҂I<br>
	 * Message: &#19981;&#35442;&#23384;&#22312;&#30340;&#20642;&#20249;&#20497;&#21834;&#65281;<br>
	 * Message: You worthless beings!
	 */
	public static final NpcStringId YOU_WORTHLESS_BEINGS;
	
	/**
	 * ID: 6965<br>
	 * Message: nŋꂽԂIȁB^悩ȁDDD<br>
	 * Message: &#22312;&#19990;&#38291;&#25152;&#20801;&#35377;&#30340;&#26178;&#38291;&#24050;&#21040;&#65292;&#36939;&#27683;&#30495;&#22909;&#46;&#46;&#46;<br>
	 * Message: My time on the material plane has ended. You are lucky...
	 */
	public static final NpcStringId MY_TIME_ON_THE_MATERIAL_PLANE_HAS_ENDED_YOU_ARE_LUCKY;
	
	/**
	 * ID: 6966<br>
	 * Message: $s1I݂Ă͂ȂȂ҂A邪I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#19981;&#35442;&#23384;&#22312;&#30340;&#20642;&#20249;&#65292;&#28040;&#22833;&#21543;&#65281;<br>
	 * Message: $s1! Worthless beings! Begone!
	 */
	public static final NpcStringId S1_WORTHLESS_BEINGS_BEGONE;
	
	/**
	 * ID: 6967<br>
	 * Message: $s1I͂肨O͊댯DDD<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#20320;&#20497;&#26524;&#28982;&#24456;&#21361;&#38570;&#46;&#46;&#46;<br>
	 * Message: $s1! You are the meaning of the word 'danger'...
	 */
	public static final NpcStringId S1_YOU_ARE_THE_MEANING_OF_THE_WORD_DANGER;
	
	/**
	 * ID: 7050<br>
	 * Message: 悭܂ŗȁA$s1I̋ؖ邽߂AˁI<br>
	 * Message: &#32066;&#26044;&#20358;&#21040;&#20102;&#36889;&#35041;&#21834;&#65292;&#12300;&#36;&#115;&#49;&#12301;&#65281;&#28858;&#20102;&#35657;&#26126;&#25105;&#30340;&#21147;&#37327;&#65292;&#21435;&#27515;&#21543;&#65281;<br>
	 * Message: You made it here, $s1. I'll show my strength. Die!
	 */
	public static final NpcStringId YOU_MADE_IT_HERE_S1_ILL_SHOW_MY_STRENGTH_DIE;
	
	/**
	 * ID: 7051<br>
	 * Message: nnnnIMl͎|ȂI͂܂łɂĂB<br>
	 * Message: &#21888;&#21621;&#21621;&#21621;&#65281;&#20320;&#26159;&#28961;&#27861;&#25171;&#25943;&#25105;&#30340;&#65281;&#36889;&#27171;&#30340;&#21147;&#37327;&#30495;&#33021;&#21213;&#36942;&#25105;&#21966;&#65311;<br>
	 * Message: Ha! You failed! Are you ready to quit?
	 */
	public static final NpcStringId HA_YOU_FAILED_ARE_YOU_READY_TO_QUIT;
	
	/**
	 * ID: 7052<br>
	 * Message: NbDDDȂI͍ŋ̂͂DDD͏̂߂ɂׂĂĂ̂ɁI<br>
	 * Message: &#21888;&#22079;&#46;&#46;&#46;&#22240;&#28858;&#65281;&#25105;&#26159;&#26368;&#24375;&#30340;&#46;&#46;&#46;&#28858;&#20102;&#21213;&#21033;&#65292;&#25105;&#33021;&#29351;&#29298;&#19968;&#20999;&#46;&#46;&#46;&#65281;<br>
	 * Message: I'm the strongest! I lost everything to win!
	 */
	public static final NpcStringId IM_THE_STRONGEST_I_LOST_EVERYTHING_TO_WIN;
	
	/**
	 * ID: 7053<br>
	 * Message: $s1Iނ炪nV̕ƒmĂ̂Ƃ̂悤ȁH<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#26082;&#28982;&#20320;&#26371;&#36914;&#34892;&#36889;&#20214;&#20107;&#65292;&#37027;&#40636;&#20320;&#26089;&#23601;&#30693;&#36947;&#20182;&#20497;&#26159;&#39764;&#29579;&#32;&#21704;&#37324;&#22799;&#30340;&#37096;&#19979;&#65311;<br>
	 * Message: $s1! Are you doing this because they're Halisha's minions?
	 */
	public static final NpcStringId S1_ARE_YOU_DOING_THIS_BECAUSE_THEYRE_HALISHAS_MINIONS;
	
	/**
	 * ID: 7054<br>
	 * Message: A̍͐N̎AnVl̂TցDDD<br>
	 * Message: &#29694;&#22312;&#65292;&#25105;&#30340;&#38728;&#39746;&#24478;&#21315;&#24180;&#30340;&#26463;&#32283;&#20013;&#24471;&#21040;&#37323;&#25918;&#65292;&#30041;&#22312;&#21704;&#37324;&#22799;&#30340;&#36523;&#37002;&#46;&#46;&#46;<br>
	 * Message: My spirit is released from this shell. I'm getting close to Halisha...
	 */
	public static final NpcStringId MY_SPIRIT_IS_RELEASED_FROM_THIS_SHELL_IM_GETTING_CLOSE_TO_HALISHA;
	
	/**
	 * ID: 7055<br>
	 * Message: ̕AȂl̑Ɏ˂ނ̂H<br>
	 * Message: &#20320;&#28858;&#20309;&#35201;&#20171;&#20837;&#20182;&#20154;&#30340;&#27770;&#39717;&#65311;<br>
	 * Message: Mind your own business!
	 */
	public static final NpcStringId MIND_YOUR_OWN_BUSINESS;
	
	/**
	 * ID: 7056<br>
	 * Message: ȏ̐킢͖ʂDDDł܂I<br>
	 * Message: &#32380;&#32396;&#27770;&#39717;&#21482;&#26159;&#28010;&#36027;&#26178;&#38291;&#46;&#46;&#46;&#23601;&#27492;&#21578;&#36781;&#65281;<br>
	 * Message: This fight is a waste of time. Goodbye!
	 */
	public static final NpcStringId THIS_FIGHT_IS_A_WASTE_OF_TIME_GOODBYE;
	
	/**
	 * ID: 7057<br>
	 * Message: _d낤ƂȀɂ͏ɑzPĂ͕̂ςʎI<br>
	 * Message: &#19981;&#31649;&#28879;&#38642;&#22810;&#40636;&#21402;&#37325;&#65292;&#32972;&#24460;&#30340;&#22826;&#38525;&#20381;&#28982;&#32380;&#32396;&#32187;&#25918;&#20809;&#26126;&#65281;<br>
	 * Message: Every cloud has a silver lining, don't you think?
	 */
	public static final NpcStringId EVERY_CLOUD_HAS_A_SILVER_LINING_DONT_YOU_THINK;
	
	/**
	 * ID: 7058<br>
	 * Message: ̈̌tɎXȁI$s1I<br>
	 * Message: &#21029;&#32893;&#20449;&#24801;&#39764;&#30340;&#35441;&#65281;&#12300;&#36;&#115;&#49;&#12301;&#65281;<br>
	 * Message: $s1! Don't listen to this demon.
	 */
	public static final NpcStringId S1_DONT_LISTEN_TO_THIS_DEMON;
	
	/**
	 * ID: 7059<br>
	 * Message: $s1I͐S̓GǏfēGaI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#29494;&#35947;&#19981;&#27770;&#26159;&#24515;&#20043;&#22823;&#24524;&#65281;&#25582;&#21205;&#20320;&#30340;&#21133;&#65292;&#25915;&#25802;&#25973;&#20154;&#21543;&#65281;<br>
	 * Message: $s1! Hesitation betrays your heart. Fight!
	 */
	public static final NpcStringId S1_HESITATION_BETRAYS_YOUR_HEART_FIGHT;
	
	/**
	 * ID: 7060<br>
	 * Message: $s1I`ANƂƂ{ɉl̂ȂƂƎvĂ̂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#20320;&#35258;&#24471;&#32173;&#35703;&#27491;&#32681;&#21644;&#25793;&#35703;&#26576;&#20491;&#20154;&#65292;&#30495;&#30340;&#26159;&#20214;&#27627;&#28961;&#24847;&#32681;&#30340;&#20107;&#21966;&#65311;<br>
	 * Message: $s1! Isn't protecting somebody worthy? Isn't that justice?
	 */
	public static final NpcStringId S1_ISNT_PROTECTING_SOMEBODY_WORTHY_ISNT_THAT_JUSTICE;
	
	/**
	 * ID: 7061<br>
	 * Message: A}ȗpvoBꂶB<br>
	 * Message: &#21710;&#21568;&#65292;&#31361;&#28982;&#24819;&#36215;&#32202;&#24613;&#20219;&#21209;&#12290;&#23601;&#21040;&#27492;&#28858;&#27490;&#12290;<br>
	 * Message: I have urgent business! I gotta go.
	 */
	public static final NpcStringId I_HAVE_URGENT_BUSINESS_I_GOTTA_GO;
	
	/**
	 * ID: 7062<br>
	 * Message: ܂łȂ̂DDD̓w͂́DDD<br>
	 * Message: &#20320;&#30340;&#24847;&#24605;&#26159;&#23601;&#21040;&#27492;&#28858;&#27490;&#46;&#46;&#46;&#65281;&#25105;&#30340;&#21162;&#21147;&#46;&#46;&#46;&#65281;<br>
	 * Message: Are my efforts in vain? Is this the end?
	 */
	public static final NpcStringId ARE_MY_EFFORTS_IN_VAIN_IS_THIS_THE_END;
	
	/**
	 * ID: 7063<br>
	 * Message: ΂AFB܂邱ƂB<br>
	 * Message: &#20877;&#35211;&#65292;&#26379;&#21451;&#12290;&#32317;&#26377;&#19968;&#22825;&#26371;&#20877;&#35211;&#38754;&#30340;&#12290;<br>
	 * Message: Goodbye, friend. I hope to see you again.
	 */
	public static final NpcStringId GOODBYE_FRIEND_I_HOPE_TO_SEE_YOU_AGAIN;
	
	/**
	 * ID: 7064<br>
	 * Message: ORm͏ɋȁI<br>
	 * Message: &#20320;&#20497;&#36889;&#20123;&#39438;&#22763;&#24590;&#40636;&#32769;&#26159;&#36889;&#40636;&#31528;&#65281;&#32;<br>
	 * Message: Knights are always foolish!
	 */
	public static final NpcStringId KNIGHTS_ARE_ALWAYS_FOOLISH;
	
	/**
	 * ID: 7065<br>
	 * Message: NNNbDDD̂炢ŌĂ낤<br>
	 * Message: &#21888;&#21888;&#46;&#46;&#46;&#20687;&#20320;&#20497;&#36889;&#27171;&#30340;&#19977;&#33139;&#35987;&#65292;&#23601;&#39250;&#20102;&#20320;&#20497;&#21543;<br>
	 * Message: I'll show mercy on you for now.
	 */
	public static final NpcStringId ILL_SHOW_MERCY_ON_YOU_FOR_NOW;
	
	/**
	 * ID: 7066<br>
	 * Message: $s1IƌĂȂȂ́IŜĂĂ܂̂BO̐`͂̋UPI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#20320;&#35498;&#36942;&#19968;&#23450;&#35201;&#36774;&#21040;&#21371;&#26410;&#33021;&#36774;&#21040;&#30340;&#20107;&#24773;&#65281;&#38627;&#36947;&#20320;&#24050;&#32147;&#24536;&#20102;&#21966;&#65311;&#37027;&#40636;&#20320;&#30340;&#27491;&#32681;&#21482;&#19981;&#36942;&#26159;&#20605;&#35037;&#30340;&#32631;&#20102;&#65281;<br>
	 * Message: $s1! Your justice is just hypocrisy if you give up on what you've promised to protect.
	 */
	public static final NpcStringId S1_YOUR_JUSTICE_IS_JUST_HYPOCRISY_IF_YOU_GIVE_UP_ON_WHAT_YOUVE_PROMISED_TO_PROTECT;
	
	/**
	 * ID: 7067<br>
	 * Message: $s1AƎvȂIỎe̒ɂł́AɂOĂ񂾂ȁDDDUP҂߁I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#46;&#46;&#46;&#21029;&#22916;&#24819;&#20320;&#24050;&#21462;&#21213;&#46;&#46;&#46;&#65281;&#20320;&#37027;&#38512;&#24433;&#20013;&#40657;&#26263;&#30340;&#19968;&#38754;&#65292;&#23559;&#26371;&#26178;&#26178;&#21051;&#21051;&#31418;&#35222;&#33879;&#20320;&#46;&#46;&#46;&#20605;&#21531;&#23376;&#65281;<br>
	 * Message: $s1...Don't think you've won! Your dark shadow will always follow you...hypocrite!
	 */
	public static final NpcStringId S1DONT_THINK_YOUVE_WON_YOUR_DARK_SHADOW_WILL_ALWAYS_FOLLOW_YOUHYPOCRITE;
	
	/**
	 * ID: 7150<br>
	 * Message: ev iCgƂ͐ÉB$s1ANAq[}Ɖ߂ĂꂳYꂽ̂B<br>
	 * Message: &#32854;&#27583;&#39438;&#22763;&#26159;&#25421;&#34907;&#19990;&#30028;&#27193;&#30340;&#20154;&#65281;&#12300;&#36;&#115;&#49;&#12301;&#65292;&#20320;&#36319;&#20154;&#39006;&#29983;&#27963;&#20102;&#37027;&#40636;&#20037;&#65292;&#38627;&#36947;&#36899;&#36889;&#19968;&#40670;&#37117;&#24536;&#20102;&#21966;&#65311;<br>
	 * Message: A temple knight guards the Mother Tree! $s1! Has Human contact made you forget that?
	 */
	public static final NpcStringId A_TEMPLE_KNIGHT_GUARDS_THE_MOTHER_TREE_S1_HAS_HUMAN_CONTACT_MADE_YOU_FORGET_THAT;
	
	/**
	 * ID: 7151<br>
	 * Message: ͂̕ӂɂĂBYȁIOĂ҂́AGtłڂwƂȂ邱ƂI<br>
	 * Message: &#36889;&#27425;&#23601;&#25764;&#36864;&#21543;&#12290;&#20294;&#26159;&#20320;&#35201;&#35352;&#20303;&#65281;&#20320;&#29694;&#22312;&#25152;&#20445;&#35703;&#30340;&#31934;&#38728;&#65292;&#32317;&#26377;&#19968;&#22825;&#25105;&#26371;&#25226;&#20182;&#20497;&#37117;&#28040;&#28357;&#30340;&#65281;<br>
	 * Message: I must stop. Remember, the ones you're protecting will someday defeat the Elves.
	 */
	public static final NpcStringId I_MUST_STOP_REMEMBER_THE_ONES_YOURE_PROTECTING_WILL_SOMEDAY_DEFEAT_THE_ELVES;
	
	/**
	 * ID: 7152<br>
	 * Message: NbDDDŋMl镨͂Ȃ񂾁HǕQ̎U΂߂邾ȂI<br>
	 * Message: &#21888;&#22079;&#46;&#46;&#46;&#20320;&#37027;&#40636;&#20570;&#21040;&#24213;&#33021;&#29554;&#24471;&#20160;&#40636;&#27171;&#30340;&#22909;&#34389;&#65292;&#21482;&#26371;&#27193;&#31435;&#26356;&#22810;&#30340;&#25973;&#20154;&#32780;&#24050;&#65281;<br>
	 * Message: What! That will just strengthen the enemy!
	 */
	public static final NpcStringId WHAT_THAT_WILL_JUST_STRENGTHEN_THE_ENEMY;
	
	/**
	 * ID: 7153<br>
	 * Message: RƂQqn̒𗐂ҁDDD$s1ɎI<br>
	 * Message: &#25854;&#20098;&#21443;&#25308;&#22320;&#31209;&#24207;&#30340;&#20154;&#65292;&#33268;&#12300;&#36;&#115;&#49;&#12301;&#26044;&#27515;&#22320;&#65281;<br>
	 * Message: You dare to disturb the order of the shrine! Die, $s1!
	 */
	public static final NpcStringId YOU_DARE_TO_DISTURB_THE_ORDER_OF_THE_SHRINE_DIE_S1;
	
	/**
	 * ID: 7154<br>
	 * Message: A̍͐N̎AnVl̂TցDDD<br>
	 * Message: &#29694;&#22312;&#65292;&#25105;&#30340;&#38728;&#39746;&#24478;&#21315;&#24180;&#30340;&#26463;&#32283;&#20013;&#24471;&#21040;&#37323;&#25918;&#65292;&#30041;&#22312;&#21704;&#37324;&#22799;&#30340;&#36523;&#37002;&#46;&#46;&#46;<br>
	 * Message: My spirit is releasing from this shell. I'm getting close to Halisha...
	 */
	public static final NpcStringId MY_SPIRIT_IS_RELEASING_FROM_THIS_SHELL_IM_GETTING_CLOSE_TO_HALISHA;
	
	/**
	 * ID: 7156<br>
	 * Message: ȏ̐킢͖ʂDDDł܂I<br>
	 * Message: &#32380;&#32396;&#27770;&#39717;&#21482;&#26159;&#28010;&#36027;&#26178;&#38291;&#46;&#46;&#46;&#23601;&#27492;&#21578;&#36781;&#65281;<br>
	 * Message: This is a waste of time. Goodbye!
	 */
	public static final NpcStringId THIS_IS_A_WASTE_OF_TIME_GOODBYE;
	
	/**
	 * ID: 7157<br>
	 * Message: ͌ZpiPCAƂ͈ႤBނIߋ̖SI<br>
	 * Message: &#25105;&#36319;&#21733;&#21733;&#28504;&#37027;&#35199;&#20126;&#21487;&#19981;&#19968;&#27171;&#12290;&#25764;&#36864;&#21543;&#65292;&#21476;&#20195;&#30340;&#36938;&#39746;&#65281;<br>
	 * Message: I'm not like my brother Panacea. Ghost of the past, begone!
	 */
	public static final NpcStringId IM_NOT_LIKE_MY_BROTHER_PANACEA_GHOST_OF_THE_PAST_BEGONE;
	
	/**
	 * ID: 7158<br>
	 * Message: $s1I̓Gt̎ザȂ񂾁IɎ݂ĂI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#29694;&#22312;&#19981;&#26159;&#31934;&#38728;&#30340;&#26178;&#20195;&#65281;&#24171;&#21161;&#25105;&#65281;<br>
	 * Message: The Elves no longer rule! Help me, $s1!
	 */
	public static final NpcStringId THE_ELVES_NO_LONGER_RULE_HELP_ME_S1;
	
	/**
	 * ID: 7159<br>
	 * Message: U̎ɂ߂ȁA$s1I͒琶܂ꂽȂ񂾁I<br>
	 * Message: &#21029;&#25918;&#39686;&#25915;&#25802;&#65281;&#12300;&#36;&#115;&#49;&#12301;&#65281;&#25171;&#20498;&#36889;&#20491;&#21315;&#24180;&#24801;&#39764;&#65281;<br>
	 * Message: Don't give up, $s1! He' a demon from the past!
	 */
	public static final NpcStringId DONT_GIVE_UP_S1_HE_A_DEMON_FROM_THE_PAST;
	
	/**
	 * ID: 7160<br>
	 * Message: ւāI$s1̂悤ɂ̒ԂƉ߂Ă҂͒mĂIFŐEƂւI<br>
	 * Message: &#32173;&#25345;&#23562;&#22196;&#65281;&#20687;&#12300;&#36;&#115;&#49;&#12301;&#19968;&#27171;&#65292;&#33287;&#30526;&#22810;&#30340;&#20154;&#19968;&#36215;&#22894;&#39717;&#36942;&#30340;&#20154;&#23601;&#26371;&#30693;&#36947;&#65281;&#22823;&#23478;&#37117;&#35201;&#32173;&#32363;&#20849;&#21516;&#32173;&#35703;&#19990;&#30028;&#30340;&#23562;&#22196;&#65281;<br>
	 * Message: Be proud, $s1. We protect this world together.
	 */
	public static final NpcStringId BE_PROUD_S1_WE_PROTECT_THIS_WORLD_TOGETHER;
	
	/**
	 * ID: 7161<br>
	 * Message: āAsȂẮB̎d҂ĂB<br>
	 * Message: &#25105;&#35442;&#36208;&#20102;&#12290;&#36996;&#26377;&#19979;&#19968;&#20491;&#20219;&#21209;&#31561;&#33879;&#25105;&#21602;&#12290;<br>
	 * Message: I have to go. I've got some business to take care of.
	 */
	public static final NpcStringId I_HAVE_TO_GO_IVE_GOT_SOME_BUSINESS_TO_TAKE_CARE_OF;
	
	/**
	 * ID: 7162<br>
	 * Message: DDD𓦂ςȂƂɂȂI<br>
	 * Message: &#21888;&#21888;&#46;&#46;&#46;&#27794;&#36910;&#20303;&#37027;&#20642;&#20249;&#30340;&#35441;&#65292;&#23559;&#26371;&#30332;&#29983;&#22823;&#20107;&#46;&#46;&#46;&#65281;<br>
	 * Message: Ugh! Don't let him get away!
	 */
	public static final NpcStringId UGH_DONT_LET_HIM_GET_AWAY;
	
	/**
	 * ID: 7163<br>
	 * Message: YȁBEƌ^̌ւB<br>
	 * Message: &#35352;&#20303;&#12290;&#32173;&#32363;&#23432;&#35703;&#19990;&#30028;&#30340;&#23562;&#22196;&#12290;<br>
	 * Message: Don't forget your pride. You're protecting the world!
	 */
	public static final NpcStringId DONT_FORGET_YOUR_PRIDE_YOURE_PROTECTING_THE_WORLD;
	
	/**
	 * ID: 7164<br>
	 * Message: B<br>
	 * Message: &#21888;&#21621;&#21621;&#21621;<br>
	 * Message: Ha, ha, ha!...
	 */
	public static final NpcStringId HA_HA_HA;
	
	/**
	 * ID: 7165<br>
	 * Message: PPPPPPPB<br>
	 * Message: &#21703;&#21704;&#21704;&#21704;&#21704;<br>
	 * Message: Kuh, huh...
	 */
	public static final NpcStringId KUH_HUH;
	
	/**
	 * ID: 7166<br>
	 * Message: DDDODDD$s1DDDODDD<br>
	 * Message: &#21734;&#46;&#46;&#46;&#21888;&#21862;&#46;&#46;&#46;&#12300;&#36;&#115;&#49;&#12301;&#21888;&#21862;&#21862;&#46;&#46;&#46;<br>
	 * Message: Aah! Kuh...$s1!...Kuh, huh...
	 */
	public static final NpcStringId AAH_KUHS1KUH_HUH;
	
	/**
	 * ID: 7167<br>
	 * Message: $s1IDDDDDDDDD<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#46;&#46;&#46;&#65281;&#46;&#46;&#46;&#35352;&#46;&#46;&#46;&#25014;&#46;&#46;&#46;&#21888;&#21734;&#21734;&#46;&#46;&#46;<br>
	 * Message: $s1!...Re... mem... Ugh...Uh...
	 */
	public static final NpcStringId S1RE_MEM_UGHUH;
	
	/**
	 * ID: 7250<br>
	 * Message: $s1AXẢ̂ɁB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#20320;&#26368;&#22909;&#35201;&#20670;&#32893;&#21908;&#65292;&#25105;&#26159;&#25351;&#20670;&#32893;&#25105;&#30340;&#27468;&#46;&#46;&#46;<br>
	 * Message: $s1, You'd better listen.
	 */
	public static final NpcStringId S1_YOUD_BETTER_LISTEN;
	
	/**
	 * ID: 7251<br>
	 * Message: ӂA鎞ԂȁB͂ȂB<br>
	 * Message: &#21834;&#65292;&#38281;&#24149;&#30340;&#26178;&#38291;&#21040;&#20102;&#12290;&#19981;&#25910;&#20998;&#25991;&#12290;<br>
	 * Message: Huh? It's curtain time! I won't get any money.
	 */
	public static final NpcStringId HUH_ITS_CURTAIN_TIME_I_WONT_GET_ANY_MONEY;
	
	/**
	 * ID: 7252<br>
	 * Message: DDD̕䂪DDD<br>
	 * Message: &#21888;&#21888;&#46;&#46;&#46;&#25105;&#30340;&#33310;&#21488;&#46;&#46;&#46;&#65281;<br>
	 * Message: Ugh...It can't be...!
	 */
	public static final NpcStringId UGHIT_CANT_BE;
	
	/**
	 * ID: 7257<br>
	 * Message: BȂIVgiVXI<br>
	 * Message: &#25214;&#21040;&#20102;&#65292;&#21029;&#20877;&#37679;&#36942;&#20102;&#65281;&#24801;&#39764;&#32013;&#29246;&#24076;&#26031;&#65281;<br>
	 * Message: You won't get away this time, Narcissus!
	 */
	public static final NpcStringId YOU_WONT_GET_AWAY_THIS_TIME_NARCISSUS;
	
	/**
	 * ID: 7258<br>
	 * Message: UDDD܂ȂH$s1I݂ĂI<br>
	 * Message: &#25915;&#46;&#46;&#46;&#19981;&#36914;&#21435;&#65311;&#12300;&#36;&#115;&#49;&#12301;&#65281;&#24171;&#21161;&#25105;&#65281;<br>
	 * Message: $s1! Help me!
	 */
	public static final NpcStringId S1_HELP_ME;
	
	/**
	 * ID: 7259<br>
	 * Message: A$s1ꏏɁI҂vȂ̂́ÂĂI<br>
	 * Message: &#19968;&#36215;&#20358;&#21543;&#65292;&#12300;&#36;&#115;&#49;&#12301;&#65281;&#32893;&#30526;&#19981;&#24819;&#32893;&#30340;&#27468;&#65292;&#23601;&#31639;&#21809;&#20102;&#20063;&#21482;&#19981;&#36942;&#26159;&#28010;&#36027;&#26178;&#38291;&#32631;&#20102;&#65281;<br>
	 * Message: You must be aware of your audience when singing, %s! => Join us $s1! A song that nobody listens to is empty.
	 */
	public static final NpcStringId YOU_MUST_BE_AWARE_OF_YOUR_AUDIENCE_WHEN_SINGING_S_JOIN_US_S1_A_SONG_THAT_NOBODY_LISTENS_TO_IS_EMPTY;
	
	/**
	 * ID: 7260<br>
	 * Message: CoāA$s1IƏŏɂł܂I<br>
	 * Message: &#21152;&#27833;&#65281;&#12300;&#36;&#115;&#49;&#12301;&#65292;&#20877;&#22533;&#25345;&#19968;&#19979;&#30340;&#35441;&#65292;&#23601;&#21487;&#20197;&#29554;&#21213;&#20102;&#65281;<br>
	 * Message: You must work harder to be victorious, $s1.
	 */
	public static final NpcStringId YOU_MUST_WORK_HARDER_TO_BE_VICTORIOUS_S1;
	
	/**
	 * ID: 7261<br>
	 * Message: ̉̂͏I܂Bʂ̎ԂłˁB<br>
	 * Message: &#25105;&#30340;&#27468;&#32080;&#26463;&#20102;&#12290;&#25105;&#35442;&#36208;&#20102;<br>
	 * Message: My song is over, I must go. Goodbye!
	 */
	public static final NpcStringId MY_SONG_IS_OVER_I_MUST_GO_GOODBYE;
	
	/**
	 * ID: 7262<br>
	 * Message: Ƃ́I<br>
	 * Message: &#37679;&#36942;&#46;&#46;&#46;&#65281;<br>
	 * Message: How could I miss!
	 */
	public static final NpcStringId HOW_COULD_I_MISS;
	
	/**
	 * ID: 7263<br>
	 * Message: ̂Ƃ͒aBꏏɂ邱ƁBYȂŁDDD<br>
	 * Message: &#22914;&#27492;&#35433;&#27468;&#30340;&#21644;&#32882;&#12290;&#26159;&#19968;&#21516;&#21512;&#21809;&#30340;&#12290;&#21029;&#24536;&#20102;&#46;&#46;&#46;<br>
	 * Message: Don't forget. Song comes with harmony.
	 */
	public static final NpcStringId DONT_FORGET_SONG_COMES_WITH_HARMONY;
	
	/**
	 * ID: 7264<br>
	 * Message: ̂BׂĂ̎҂Ȃ̉̐ɎXł傤B<br>
	 * Message: &#21809;&#39318;&#27468;&#21543;&#12290;&#27599;&#19968;&#20491;&#20154;&#37117;&#31561;&#33879;&#20670;&#32893;&#20320;&#30340;&#27468;&#32882;&#12290;<br>
	 * Message: Sing. Everyone will listen.
	 */
	public static final NpcStringId SING_EVERYONE_WILL_LISTEN;
	
	/**
	 * ID: 7265<br>
	 * Message: N͎̏j󂯂鎑iȂȁB<br>
	 * Message: &#20320;&#20497;&#27794;&#26377;&#36039;&#26684;&#24471;&#21040;&#25105;&#30340;&#31069;&#31119;&#12290;<br>
	 * Message: You don't deserve my blessing.
	 */
	public static final NpcStringId YOU_DONT_DESERVE_MY_BLESSING;
	
	/**
	 * ID: 7266<br>
	 * Message: $s1HN܂ł̏jނ̂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65311;&#36899;&#20320;&#20063;&#25298;&#32085;&#25509;&#21463;&#25105;&#30340;&#31069;&#31119;&#21966;&#65311;<br>
	 * Message: Do you reject my blessing, $s1?
	 */
	public static final NpcStringId DO_YOU_REJECT_MY_BLESSING_S1;
	
	/**
	 * ID: 7267<br>
	 * Message: DDD$s1BȂAȂDDDFN̂邾낤ɁDDD<br>
	 * Message: &#21834;&#21834;&#46;&#46;&#12300;&#36;&#115;&#49;&#12301;&#24590;&#40636;&#26371;&#65292;&#24590;&#40636;&#26371;&#36889;&#27171;&#46;&#46;&#46;&#25152;&#26377;&#30340;&#20154;&#24456;&#24555;&#23601;&#26371;&#35738;&#32654;&#20320;&#20102;&#46;&#46;&#46;<br>
	 * Message: But why, $s1. Everyone would praise you!
	 */
	public static final NpcStringId BUT_WHY_S1_EVERYONE_WOULD_PRAISE_YOU;
	
	/**
	 * ID: 7350<br>
	 * Message: $s1Iꂵ̍UɒʗpƎv̂B͕sgIGI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#37027;&#27171;&#30340;&#25915;&#25802;&#33021;&#20663;&#23475;&#24471;&#20102;&#25105;&#21966;&#65311;&#25105;&#25793;&#26377;&#19981;&#26429;&#20043;&#36544;&#65281;&#25105;&#26159;&#28961;&#25973;&#30340;&#65281;<br>
	 * Message: $s1! Attack me? I'm immortal! I'm unrivaled!
	 */
	public static final NpcStringId S1_ATTACK_ME_IM_IMMORTAL_IM_UNRIVALED;
	
	/**
	 * ID: 7351<br>
	 * Message: NNNDDD͕sgBȂǂ񕜂DDDɉMl̖B<br>
	 * Message: &#21704;&#21704;&#21704;&#12290;&#25105;&#30340;&#36523;&#39636;&#26159;&#19981;&#26429;&#30340;&#65292;&#20663;&#30165;&#39340;&#19978;&#23601;&#26371;&#24489;&#21407;&#30340;&#65294;&#65294;&#19979;&#27425;&#20877;&#35211;&#38754;&#30340;&#37027;&#22825;&#65292;&#23601;&#26159;&#20320;&#30340;&#24524;&#26085;&#12290;<br>
	 * Message: Ha! I'm immortal. This scar will soon heal. You'll die next time.
	 */
	public static final NpcStringId HA_IM_IMMORTAL_THIS_SCAR_WILL_SOON_HEAL_YOULL_DIE_NEXT_TIME;
	
	/**
	 * ID: 7352<br>
	 * Message: ƁH̃\[h}X^[ ACIIHeXA񑩂ȂAɉi̖ƁI<br>
	 * Message: &#20320;&#35498;&#25105;&#36664;&#20102;&#65311;&#65281;&#25105;&#65292;&#21133;&#32854;&#33406;&#20234;&#24681;&#36664;&#32102;&#21029;&#20154;&#65311;&#65281;&#19981;&#65292;&#26757;&#29305;&#39791;&#26031;&#65292;&#20320;&#35498;&#36942;&#26371;&#36060;&#32102;&#25105;&#27704;&#24646;&#30340;&#29983;&#21629;&#65281;&#65281;&#65281;<br>
	 * Message: Metellus! You promised me an immortal life! How could I, Swordmaster Iron, lose?
	 */
	public static final NpcStringId METELLUS_YOU_PROMISED_ME_AN_IMMORTAL_LIFE_HOW_COULD_I_SWORDMASTER_IRON_LOSE;
	
	/**
	 * ID: 7357<br>
	 * Message: قAVgHbオ肻ȁH<br>
	 * Message: &#21834;&#21704;&#65292;&#22702;&#33853;&#22825;&#20351;&#65311;&#32;&#20540;&#24471;&#19968;&#35430;&#21966;&#65311;<br>
	 * Message: Fallen Angel? It's worth trying.
	 */
	public static final NpcStringId FALLEN_ANGEL_ITS_WORTH_TRYING;
	
	/**
	 * ID: 7358<br>
	 * Message: A$s1IĂ΂肢Ȃňꏏɂ낤I育̂鑊肾H<br>
	 * Message: &#21890;&#65292;&#12300;&#36;&#115;&#49;&#12301;&#65281;&#19981;&#35201;&#34966;&#25163;&#26049;&#35264;&#65292;&#19968;&#36215;&#19978;&#21543;&#65281;&#36889;&#26159;&#20491;&#20540;&#24471;&#19968;&#25136;&#30340;&#23565;&#35937;&#21908;&#65311;&#65281;<br>
	 * Message: Hey $s1! Why don't you join? It's your best shot!
	 */
	public static final NpcStringId HEY_S1_WHY_DONT_YOU_JOIN_ITS_YOUR_BEST_SHOT;
	
	/**
	 * ID: 7359<br>
	 * Message: $s1A񂽁Ai̖ɋ邩B͂Ȃ̂ɂዻȂˁI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#20320;&#23565;&#19981;&#26429;&#20043;&#36544;&#24863;&#33288;&#36259;&#21966;&#65311;&#37027;&#40636;&#28961;&#36259;&#30340;&#26481;&#35199;&#65292;&#36865;&#32102;&#25105;&#25105;&#36996;&#19981;&#24819;&#35201;&#21602;&#65311;<br>
	 * Message: Are you interested in immortal life, $s1? It's too boring for me.
	 */
	public static final NpcStringId ARE_YOU_INTERESTED_IN_IMMORTAL_LIFE_S1_ITS_TOO_BORING_FOR_ME;
	
	/**
	 * ID: 7360<br>
	 * Message: $s1AIO̘rĂI̒Ŗʂ͂I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#38750;&#24120;&#22909;&#65281;&#35731;&#25105;&#30475;&#30475;&#20320;&#30340;&#23526;&#21147;&#21543;&#65281;&#22312;&#30495;&#27491;&#30340;&#36870;&#22659;&#20013;&#29730;&#30952;&#20986;&#20358;&#30340;&#23526;&#21147;&#65281;<br>
	 * Message: Excellent, $s1! Show me what you learned when your life was on the line!
	 */
	public static final NpcStringId EXCELLENT_S1_SHOW_ME_WHAT_YOU_LEARNED_WHEN_YOUR_LIFE_WAS_ON_THE_LINE;
	
	/**
	 * ID: 7361<br>
	 * Message: ꂶAɎ炷B\ꂽAƋx܂ȂƂˁB<br>
	 * Message: &#37027;&#40636;&#25105;&#20808;&#36208;&#20102;&#12290;&#32147;&#36942;&#20102;&#19968;&#30058;&#28608;&#28872;&#30340;&#25171;&#39717;&#65292;&#25033;&#35442;&#20241;&#24687;&#19968;&#19979;&#12290;<br>
	 * Message: I have to go take a break.
	 */
	public static final NpcStringId I_HAVE_TO_GO_TAKE_A_BREAK;
	
	/**
	 * ID: 7362<br>
	 * Message: ÂIۂ̂|Ȃ̂B[[[I <br>
	 * Message: &#24590;&#40636;&#65292;&#37679;&#36942;&#46;&#46;&#46;&#65311;&#32;&#37027;&#20123;&#20642;&#20249;&#36899;&#19968;&#20491;&#20063;&#27794;&#25235;&#21040;&#65311;&#21703;&#21704;&#21704;&#21704;&#21704;&#65281;<br>
	 * Message: You missed?! What a fool you are!
	 */
	public static final NpcStringId YOU_MISSED_WHAT_A_FOOL_YOU_ARE;
	
	/**
	 * ID: 7363<br>
	 * Message: X̂Ȃ퓬A댯̂ȂCsAt̂ȂBɉ̈Ӗ񂾁H<br>
	 * Message: &#27627;&#28961;&#25361;&#25136;&#24615;&#30340;&#25136;&#39717;&#65292;&#27627;&#28961;&#21361;&#38570;&#24615;&#30340;&#37723;&#37706;&#12290;&#27627;&#28961;&#25387;&#25240;&#30340;&#25104;&#38263;&#12290;&#19981;&#35201;&#26377;&#36889;&#31278;&#27794;&#22823;&#33126;&#30340;&#24819;&#27861;&#12290;&#35352;&#20303;&#12290;<br>
	 * Message: Fighting without risk, training without danger and growing without hardship will only lead to an inflated ego. Don't forget.
	 */
	public static final NpcStringId FIGHTING_WITHOUT_RISK_TRAINING_WITHOUT_DANGER_AND_GROWING_WITHOUT_HARDSHIP_WILL_ONLY_LEAD_TO_AN_INFLATED_EGO_DONT_FORGET;
	
	/**
	 * ID: 7364<br>
	 * Message: ̓eXBO]ނȂi̖^悤B<br>
	 * Message: &#25105;&#26159;&#26757;&#29305;&#39791;&#26031;&#12290;&#21482;&#35201;&#20320;&#39000;&#24847;&#65292;&#23601;&#36060;&#32102;&#20320;&#27704;&#24646;&#30340;&#29983;&#21629;&#12290;<br>
	 * Message: Do you want an immortal life?
	 */
	public static final NpcStringId DO_YOU_WANT_AN_IMMORTAL_LIFE;
	
	/**
	 * ID: 7365<br>
	 * Message: x悭lĂ݂񂾂ȁBi̖Ask̂ȂDDD<br>
	 * Message: &#20877;&#20180;&#32048;&#22320;&#24819;&#24819;&#30475;&#21543;&#12290;&#27704;&#24646;&#30340;&#29983;&#21629;&#65292;&#27794;&#26377;&#32114;&#27627;&#22833;&#25943;&#30340;&#21213;&#21033;&#46;&#46;&#46;<br>
	 * Message: Think it over. An immortal life and assured victory...
	 */
	public static final NpcStringId THINK_IT_OVER_AN_IMMORTAL_LIFE_AND_ASSURED_VICTORY;
	
	/**
	 * ID: 7366<br>
	 * Message: $s1I̋Z͔ɗDĂB̏j󂯂āA̘rwĂ݂ȂB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#46;&#46;&#65281;&#37027;&#20491;&#25216;&#34899;&#38750;&#24120;&#21331;&#36234;&#12290;&#35201;&#19981;&#35201;&#25509;&#21463;&#25105;&#30340;&#31069;&#31119;&#65292;&#32380;&#32396;&#30952;&#32244;&#37027;&#20491;&#23526;&#21147;&#21602;&#65311;<br>
	 * Message: That's good, $s1! Do you want my blessing to improve your skills?
	 */
	public static final NpcStringId THATS_GOOD_S1_DO_YOU_WANT_MY_BLESSING_TO_IMPROVE_YOUR_SKILLS;
	
	/**
	 * ID: 7367<br>
	 * Message: $s1IȂA񑩂ꂽނ̂I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#46;&#46;&#46;&#65281;&#28858;&#20160;&#40636;&#26371;&#25298;&#32085;&#24050;&#23450;&#30340;&#21213;&#21033;&#46;&#46;&#46;&#65311;&#65281;<br>
	 * Message: $s1! Why do you reject guaranteed victory?
	 */
	public static final NpcStringId S1_WHY_DO_YOU_REJECT_GUARANTEED_VICTORY;
	
	/**
	 * ID: 7450<br>
	 * Message: $s1A_̌䖼ɂĂO𔱂I狭ƂAS𑊎ɂ邱Ƃ͂ł܂I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#46;&#46;&#22857;&#31070;&#30340;&#21629;&#20196;&#65292;&#34389;&#32624;&#20320;&#65281;&#20320;&#20877;&#24590;&#40636;&#24375;&#24717;&#65292;&#20063;&#25973;&#19981;&#36942;&#25105;&#20497;&#36889;&#40636;&#22810;&#20154;&#65281;<br>
	 * Message: In the name of gods, I punish you, $s1! You can't rival us all, no matter how strong you think you are!
	 */
	public static final NpcStringId IN_THE_NAME_OF_GODS_I_PUNISH_YOU_S1_YOU_CANT_RIVAL_US_ALL_NO_MATTER_HOW_STRONG_YOU_THINK_YOU_ARE;
	
	/**
	 * ID: 7451<br>
	 * Message: ͌Ă邪A̗͂ڊo߂ʂ悤ɂĂI<br>
	 * Message: &#36889;&#27425;&#38614;&#28982;&#25764;&#36864;&#65292;&#20294;&#26159;&#21029;&#21914;&#37266;&#20102;&#40845;&#20043;&#21147;&#65281;<br>
	 * Message: I have to stop for now, but I'll defeat the power of the dragon yet!
	 */
	public static final NpcStringId I_HAVE_TO_STOP_FOR_NOW_BUT_ILL_DEFEAT_THE_POWER_OF_THE_DRAGON_YET;
	
	/**
	 * ID: 7452<br>
	 * Message: DDDO͒mȂ̂Aڊo߂Ă͂ȂȂ́DDD́I<br>
	 * Message: &#21888;&#22079;&#46;&#46;&#46;&#20320;&#19981;&#26313;&#24471;&#65292;&#37027;&#26159;&#46;&#46;&#46;&#19981;&#33021;&#21914;&#37266;&#30340;&#46;&#46;&#46;&#65281;<br>
	 * Message: It is...The power that shouldn't live!
	 */
	public static final NpcStringId IT_ISTHE_POWER_THAT_SHOULDNT_LIVE;
	
	/**
	 * ID: 7457<br>
	 * Message: ͂ƂAVgɂȂĐlԂ̏oɁA``̂ǂƎv񂾂H<br>
	 * Message: &#19981;&#31649;&#24590;&#40636;&#27171;&#65292;&#25104;&#28858;&#22825;&#20351;&#32780;&#24178;&#28041;&#20154;&#39006;&#30340;&#20107;&#65292;&#19981;&#35258;&#24471;&#19981;&#22826;&#27491;&#22823;&#20809;&#26126;&#21966;&#65311;<br>
	 * Message: Isn't it unwise for an angel to interfere in Human affairs?
	 */
	public static final NpcStringId ISNT_IT_UNWISE_FOR_AN_ANGEL_TO_INTERFERE_IN_HUMAN_AFFAIRS;
	
	/**
	 * ID: 7458<br>
	 * Message: ƌłˁDDD$s1A]T`Ă炦܂H<br>
	 * Message: &#30495;&#26377;&#40670;&#46;&#46;&#36027;&#21147;&#46;&#46;&#65281;&#12300;&#36;&#115;&#49;&#12301;&#65292;&#26377;&#40670;&#39192;&#21147;&#30340;&#35441;&#65292;&#33021;&#24171;&#24537;&#19968;&#19979;&#21966;&#65311;<br>
	 * Message: This is tough! $s1, would you help me?
	 */
	public static final NpcStringId THIS_IS_TOUGH_S1_WOULD_YOU_HELP_ME;
	
	/**
	 * ID: 7459<br>
	 * Message: $s1I͗̌󂯌p҂ׂ͂ČxĂ܂IȂOł͂܂I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#46;&#46;&#65281;&#36889;&#20642;&#20249;&#22312;&#38450;&#20633;&#25152;&#26377;&#32380;&#25215;&#40845;&#20043;&#34880;&#33032;&#30340;&#20154;&#65292;&#23565;&#24744;&#20063;&#19981;&#20363;&#22806;&#65281;<br>
	 * Message: $s1! He's keeping an eye on all those in succession to the blood of dragons, including you!
	 */
	public static final NpcStringId S1_HES_KEEPING_AN_EYE_ON_ALL_THOSE_IN_SUCCESSION_TO_THE_BLOOD_OF_DRAGONS_INCLUDING_YOU;
	
	/**
	 * ID: 7460<br>
	 * Message: G̔ŵłA$s1I|ꂽA͂Ȃ̔ԂłI<br>
	 * Message: &#25915;&#25802;&#25973;&#20154;&#30340;&#24460;&#26041;&#65292;&#12300;&#36;&#115;&#49;&#12301;&#65281;&#25105;&#20498;&#19979;&#21435;&#30340;&#35441;&#65292;&#25509;&#19979;&#20358;&#23601;&#38752;&#24744;&#20102;&#65281;<br>
	 * Message: Attack the rear, $s1! If I'm killed, you're next!
	 */
	public static final NpcStringId ATTACK_THE_REAR_S1_IF_IM_KILLED_YOURE_NEXT;
	
	/**
	 * ID: 7461<br>
	 * Message: l̊Ⴊ߂܂ˁAƂɂAȂƂɂDDD͂܂ˁA悤ȂB<br>
	 * Message: &#27880;&#35222;&#33879;&#25105;&#20497;&#30340;&#20154;&#26377;&#24456;&#22810;&#12290;&#30475;&#24471;&#21040;&#30340;&#22320;&#26041;&#20063;&#26377;&#65292;&#30475;&#19981;&#21040;&#30340;&#22320;&#26041;&#20063;&#26377;&#46;&#46;&#46;&#25105;&#20497;&#19981;&#21487;&#33021;&#24453;&#24456;&#20037;&#30340;&#12290;&#20445;&#37325;&#12290;<br>
	 * Message: I can't stay any longer. There are too many eyes on us. Farewell!
	 */
	public static final NpcStringId I_CANT_STAY_ANY_LONGER_THERE_ARE_TOO_MANY_EYES_ON_US_FAREWELL;
	
	/**
	 * ID: 7462<br>
	 * Message: HłˁAłDDD<br>
	 * Message: &#46;&#46;&#46;&#36867;&#36305;&#20102;&#65311;&#20320;&#36996;&#27963;&#33879;&#12290;&#20294;&#26159;&#46;&#46;&#46;<br>
	 * Message: Get away? You're still alive. But...
	 */
	public static final NpcStringId GET_AWAY_YOURE_STILL_ALIVE_BUT;
	
	/**
	 * ID: 7463<br>
	 * Message: 邱Ƃ̂łȂ킢ȂAł͂ŐȂĂ͂Ȃ܂BꂪȂ킿Aa𐶂ޗB̓łB<br>
	 * Message: &#22914;&#26524;&#26159;&#36991;&#28961;&#21487;&#36991;&#30340;&#25136;&#39717;&#65292;&#37027;&#40636;&#23601;&#35201;&#29992;&#26368;&#24375;&#30340;&#21147;&#37327;&#20358;&#22739;&#21046;&#12290;&#37027;&#26159;&#32173;&#25345;&#21644;&#24179;&#30340;&#21807;&#19968;&#36947;&#36335;&#12290;<br>
	 * Message: If we can't avoid this fight, we'll need great strength. It's the only way to peace.
	 */
	public static final NpcStringId IF_WE_CANT_AVOID_THIS_FIGHT_WELL_NEED_GREAT_STRENGTH_ITS_THE_ONLY_WAY_TO_PEACE;
	
	/**
	 * ID: 7464<br>
	 * Message: EH[[hǍ󂯌pҁI̋ZpĂ͂ȂȂI<br>
	 * Message: &#20653;&#20853;&#65292;&#32380;&#25215;&#40845;&#20043;&#34880;&#33032;&#30340;&#20154;&#46;&#46;&#46;&#65281;&#19981;&#33021;&#35731;&#40845;&#30340;&#25216;&#34899;&#20659;&#25215;&#19979;&#21435;&#65281;<br>
	 * Message: Warlord, you'll never learn the techniques of the dragon!
	 */
	public static final NpcStringId WARLORD_YOULL_NEVER_LEARN_THE_TECHNIQUES_OF_THE_DRAGON;
	
	/**
	 * ID: 7465<br>
	 * Message: NbDDDȂז̂DDDO̕ꂾI<br>
	 * Message: &#21834;&#65294;&#65294;&#21704;&#65294;&#28858;&#20160;&#40636;&#22952;&#31001;&#25105;&#65292;&#26159;&#20320;&#27597;&#35242;&#20570;&#30340;&#20107;&#32822;&#46;&#46;&#46;&#65281;<br>
	 * Message: Hey, why bother with this. Isn't it your mother's business?
	 */
	public static final NpcStringId HEY_WHY_BOTHER_WITH_THIS_ISNT_IT_YOUR_MOTHERS_BUSINESS;
	
	/**
	 * ID: 7466<br>
	 * Message: $s1IMlNɔ|̂IV[̎q̋Z󂯌p炾ȁI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#46;&#46;&#65281;&#20320;&#20063;&#24819;&#21453;&#25239;&#27597;&#35242;&#25152;&#20570;&#30340;&#20107;&#21966;&#46;&#46;&#65311;&#65281;&#26524;&#28982;&#26159;&#32380;&#25215;&#24109;&#29747;&#23376;&#23403;&#20497;&#25216;&#34899;&#30340;&#24290;&#29289;&#65281;<br>
	 * Message: $s1! Are you against your mother's wishes? You're not worthy of the secrets of Shilen's children!
	 */
	public static final NpcStringId S1_ARE_YOU_AGAINST_YOUR_MOTHERS_WISHES_YOURE_NOT_WORTHY_OF_THE_SECRETS_OF_SHILENS_CHILDREN;
	
	/**
	 * ID: 7467<br>
	 * Message: $s1A̋Z͑f炵Buɂčł̕sK𐶂ގҁAꂪOɂȂ邾낤I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#20320;&#37027;&#27494;&#25216;&#38750;&#24120;&#22909;&#12290;&#20294;&#26159;&#33021;&#22312;&#30636;&#38291;&#24341;&#36215;&#26368;&#22810;&#19981;&#24184;&#30340;&#20154;&#65292;&#24517;&#23450;&#26159;&#20320;&#65281;<br>
	 * Message: Excellent technique, $s1. Unfortunately, you're the one destined for tragedy!
	 */
	public static final NpcStringId EXCELLENT_TECHNIQUE_S1_UNFORTUNATELY_YOURE_THE_ONE_DESTINED_FOR_TRAGEDY;
	
	/**
	 * ID: 7550<br>
	 * Message: $s1I܂ł悭ǂĂI̓I[ŇE𒴂Ilƌт_̗͂邪I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#31455;&#28982;&#26371;&#36861;&#21040;&#36889;&#35041;&#20358;&#65281;&#28982;&#32780;&#65292;&#25105;&#24050;&#36229;&#36234;&#21322;&#29560;&#20154;&#30340;&#26997;&#38480;&#65281;&#35731;&#20320;&#30631;&#30631;&#21644;&#24040;&#20154;&#32080;&#21512;&#30340;&#21147;&#37327;&#65281;<br>
	 * Message: $s1! You may follow me, but an Orc is no match for my giant's strength!
	 */
	public static final NpcStringId S1_YOU_MAY_FOLLOW_ME_BUT_AN_ORC_IS_NO_MATCH_FOR_MY_GIANTS_STRENGTH;
	
	/**
	 * ID: 7551<br>
	 * Message: DDD̂DDD܂łDDD<br>
	 * Message: &#21888;&#46;&#46;&#46;&#36523;&#39636;&#46;&#46;&#46;&#65281;&#20320;&#30340;&#24847;&#24605;&#26159;&#21040;&#27492;&#28858;&#27490;&#46;&#46;&#46;&#65281;&#32;<br>
	 * Message: Kuh...My body fails..This is the end!
	 */
	public static final NpcStringId KUHMY_BODY_FAILSTHIS_IS_THE_END;
	
	/**
	 * ID: 7552<br>
	 * Message: ͕ʁIl̗͂ɓꂽ̎́II<br>
	 * Message: &#25105;&#19981;&#21487;&#33021;&#36664;&#32102;&#20320;&#30340;&#46;&#46;&#46;&#65281;&#24471;&#21040;&#24040;&#20154;&#21147;&#37327;&#30340;&#25105;&#46;&#46;&#46;&#65281;&#21703;&#21704;&#21704;&#21704;&#21704;&#65281;<br>
	 * Message: How could I lose with the powers of a giant? Aargh!!!
	 */
	public static final NpcStringId HOW_COULD_I_LOSE_WITH_THE_POWERS_OF_A_GIANT_AARGH;
	
	/**
	 * ID: 7557<br>
	 * Message: ꂪGȂ̂B<br>
	 * Message: &#46;&#46;&#46;&#37027;&#20491;&#20642;&#20249;&#23601;&#26159;&#25973;&#20154;&#21966;&#12290;<br>
	 * Message: That's the enemy.
	 */
	public static final NpcStringId THATS_THE_ENEMY;
	
	/**
	 * ID: 7558<br>
	 * Message: ӂI$s1AĂ邾Ȃ̂B<br>
	 * Message: &#46;&#46;&#46;&#21756;&#65281;&#12300;&#36;&#115;&#49;&#12301;&#65292;&#20320;&#24819;&#22352;&#35222;&#19981;&#31649;&#21966;&#65311;<br>
	 * Message: Hmm.. $s1! Will you just stand there doing nothing?
	 */
	public static final NpcStringId HMM_S1_WILL_YOU_JUST_STAND_THERE_DOING_NOTHING;
	
	/**
	 * ID: 7559<br>
	 * Message: $s1A͗^̂ȂB킢ɐg𓊂҂𓾂鎑i񂾁B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#46;&#46;&#46;&#21213;&#21033;&#19981;&#26159;&#24977;&#31354;&#24471;&#20358;&#30340;&#12290;&#21807;&#26377;&#21443;&#33287;&#25136;&#39717;&#30340;&#20154;&#65292;&#25165;&#26377;&#36039;&#26684;&#20139;&#21463;&#21213;&#21033;&#30340;&#28363;&#21619;&#12290;<br>
	 * Message: $s1. Nothing risked, nothing gained. Only those who fight enjoy the spoils of victory.
	 */
	public static final NpcStringId S1_NOTHING_RISKED_NOTHING_GAINED_ONLY_THOSE_WHO_FIGHT_ENJOY_THE_SPOILS_OF_VICTORY;
	
	/**
	 * ID: 7560<br>
	 * Message: ͏肶ȂB$s1AOvȂB<br>
	 * Message: &#19981;&#26159;&#40657;&#33394;&#30340;&#35037;&#39166;&#21697;&#65292;&#12300;&#36;&#115;&#49;&#12301;&#12290;&#20320;&#19981;&#20063;&#36889;&#40636;&#35469;&#28858;&#21966;&#65311;<br>
	 * Message: A sword isn't jewelry, $s1. Don't you agree?
	 */
	public static final NpcStringId A_SWORD_ISNT_JEWELRY_S1_DONT_YOU_AGREE;
	
	/**
	 * ID: 7561<br>
	 * Message: ӂށA킢͂Ȃ̂B闝R͂ȂȁB<br>
	 * Message: &#21999;&#12290;&#27794;&#26377;&#25136;&#39717;&#20102;&#12290;&#25105;&#22312;&#36889;&#35041;&#30340;&#29702;&#30001;&#20063;&#65294;&#65294;<br>
	 * Message: With no fight, I have no reason to stay.
	 */
	public static final NpcStringId WITH_NO_FIGHT_I_HAVE_NO_REASON_TO_STAY;
	
	/**
	 * ID: 7562<br>
	 * Message: DDD<br>
	 * Message: &#37679;&#36942;&#46;&#46;&#46;<br>
	 * Message: Miss...
	 */
	public static final NpcStringId MISS;
	
	/**
	 * ID: 7563<br>
	 * Message: 炪f킢ɂ̂ݐg𓊂BȂƌ邱ƂɂȂ邼B<br>
	 * Message: &#28858;&#29983;&#27515;&#30340;&#27770;&#39717;&#29351;&#29298;&#21543;&#12290;&#19981;&#36889;&#40636;&#20570;&#30340;&#35441;&#65292;&#35498;&#19981;&#23450;&#26371;&#24460;&#24724;&#12290;<br>
	 * Message: Pick your battles wisely, or you'll regret it.
	 */
	public static final NpcStringId PICK_YOUR_BATTLES_WISELY_OR_YOULL_REGRET_IT;
	
	/**
	 * ID: 7564<br>
	 * Message:    I  J    l         B<br>
	 * Message: &#31528;&#65294;&#34507;&#46;&#46;&#46;&#65294;&#26397;&#65294;&#33879;&#65294;&#24040;&#65294;&#20154;&#65294;&#30340;&#65294;&#21147;&#65294;&#37327;&#65294;&#34909;&#65294;&#36942;&#65294;&#21435;<br>
	 * Message: What a fool to challenge the giant of the Oroka tribe!
	 */
	public static final NpcStringId WHAT_A_FOOL_TO_CHALLENGE_THE_GIANT_OF_THE_OROKA_TRIBE;
	
	/**
	 * ID: 7565<br>
	 * Message: G l  M [ s  B  U   B<br>
	 * Message: &#21147;&#65294;&#37327;&#65294;&#19981;&#65294;&#36275;&#65294;&#23601;&#65294;&#24460;&#65294;&#36864;<br>
	 * Message: Running low on steam. I must withdraw.
	 */
	public static final NpcStringId RUNNING_LOW_ON_STEAM_I_MUST_WITHDRAW;
	
	/**
	 * ID: 7566<br>
	 * Message: $s1 K [ f B A   n [ N  |   ҁB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#25802;&#65294;&#20498;&#65294;&#23432;&#65294;&#35703;&#65294;&#32773;&#65294;&#31302;&#65294;&#21704;&#65294;&#20811;&#65294;&#30340;&#65294;&#20154;&#12290;<br>
	 * Message: $s1. You're the one who defeated Guardian Muhark!
	 */
	public static final NpcStringId S1_YOURE_THE_ONE_WHO_DEFEATED_GUARDIAN_MUHARK;
	
	/**
	 * ID: 7567<br>
	 * Message: $s1I|         DDD<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#46;&#46;&#46;&#65281;&#35201;&#65294;&#25171;&#65294;&#20498;&#65294;&#25171;&#65294;&#20498;&#46;&#46;&#46;<br>
	 * Message: $s1....! I must succeed...
	 */
	public static final NpcStringId S1_I_MUST_SUCCEED;
	
	/**
	 * ID: 7650<br>
	 * Message: $s1ÃEYɒǂ͔͂F߂Ă낤BɂĂA{ɃAYA̗͂ɓB𑊎ɐ킨Ƃ̂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#46;&#46;&#46;&#23565;&#26044;&#36861;&#25802;&#25105;&#38463;&#39791;&#26031;&#36889;&#19968;&#40670;&#65292;&#25105;&#20498;&#26159;&#21487;&#20197;&#32102;&#20104;&#32943;&#23450;&#12290;&#20294;&#26159;&#65292;&#20320;&#30906;&#23450;&#35201;&#21644;&#29554;&#24471;&#20126;&#20625;&#25289;&#20043;&#21147;&#30340;&#25105;&#25136;&#39717;&#21966;&#65311;<br>
	 * Message: $s1... Would you fight Uruz, who has reached the power of Azira?
	 */
	public static final NpcStringId S1_WOULD_YOU_FIGHT_URUZ_WHO_HAS_REACHED_THE_POWER_OF_AZIRA;
	
	/**
	 * ID: 7651<br>
	 * Message: ӂDDD܂AYA̗͂SɃRg[͓̂ȁB<br>
	 * Message: &#21628;&#65294;&#65294;&#36996;&#19981;&#33021;&#23436;&#20840;&#25484;&#25511;&#20126;&#20625;&#25289;&#30340;&#21147;&#37327;&#12290;&#39318;&#20808;&#46;&#46;&#46;<br>
	 * Message: I can't handle the power of Azira yet. First...
	 */
	public static final NpcStringId I_CANT_HANDLE_THE_POWER_OF_AZIRA_YET_FIRST;
	
	/**
	 * ID: 7652<br>
	 * Message: ȁIAYA̗͂󂯌pẢeɒBȂāDDD<br>
	 * Message: &#19981;&#21487;&#33021;&#65281;&#24471;&#21040;&#20126;&#20625;&#25289;&#20043;&#21147;&#30340;&#25105;&#65292;&#36948;&#21040;&#28779;&#20043;&#24433;&#30340;&#25105;&#31455;&#28982;&#26371;&#36889;&#27171;&#20498;&#19979;&#46;&#46;&#46;&#65281;<br>
	 * Message: This can't be happening! I have the power of Azira! How could I fall so easily?
	 */
	public static final NpcStringId THIS_CANT_BE_HAPPENING_I_HAVE_THE_POWER_OF_AZIRA_HOW_COULD_I_FALL_SO_EASILY;
	
	/**
	 * ID: 7657<br>
	 * Message: AYAI׈ȉ萶܂ꂽҁǍŒ߂Ă낤I<br>
	 * Message: &#20126;&#20625;&#25289;&#65281;&#25105;&#35201;&#29992;&#25105;&#30340;&#25163;&#22475;&#33900;&#24478;&#37034;&#24801;&#20043;&#28779;&#35477;&#29983;&#30340;&#20154;&#65281;<br>
	 * Message: Azira, born from the Evil Flame, I'll kill you with my bare hands!
	 */
	public static final NpcStringId AZIRA_BORN_FROM_THE_EVIL_FLAME_ILL_KILL_YOU_WITH_MY_BARE_HANDS;
	
	/**
	 * ID: 7658<br>
	 * Message: I$s1IOJo^ toC̖mĂȂA̎Ɉꔭ܂ĂI<br>
	 * Message: &#21890;&#65281;&#12300;&#36;&#115;&#49;&#12301;&#65281;&#22914;&#26524;&#20320;&#26377;&#32893;&#36942;&#21345;&#24052;&#22612;&#37324;&#32;&#34382;&#30333;&#20043;&#21517;&#30340;&#35441;&#65292;&#23601;&#21521;&#36889;&#20491;&#27515;&#38728;&#25582;&#25331;&#21543;&#65281;<br>
	 * Message: $s1! In the name of Khavatari Hubai, strike this evil with your fists!
	 */
	public static final NpcStringId S1_IN_THE_NAME_OF_KHAVATARI_HUBAI_STRIKE_THIS_EVIL_WITH_YOUR_FISTS;
	
	/**
	 * ID: 7659<br>
	 * Message: $s1I݌ISɍ߂āAāI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#33145;&#32972;&#22846;&#25915;&#65281;&#25226;&#24515;&#24605;&#25918;&#22312;&#25331;&#38957;&#19978;&#65292;&#25582;&#25331;&#21543;&#65281;<br>
	 * Message: $s1! Attack from both sides! Hit hard!
	 */
	public static final NpcStringId S1_ATTACK_FROM_BOTH_SIDES_HIT_HARD;
	
	/**
	 * ID: 7660<br>
	 * Message: $s1IO̐SȂAԈႢȂ̉gɂʗp邾낤I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#21547;&#26377;&#20320;&#30495;&#24515;&#30340;&#25331;&#38957;&#65292;&#19968;&#23450;&#33021;&#25802;&#25943;&#28779;&#28976;&#30340;&#21270;&#36523;&#65281;<br>
	 * Message: $s1! Strike with all your heart. It must work.
	 */
	public static final NpcStringId S1_STRIKE_WITH_ALL_YOUR_HEART_IT_MUST_WORK;
	
	/**
	 * ID: 7661<br>
	 * Message: IHsȂ΁Bł܂B<br>
	 * Message: &#21999;&#65311;&#65281;&#37027;&#40636;&#65292;&#35442;&#36208;&#20102;&#65281;&#19979;&#27425;&#20877;&#35211;&#21543;&#12290;<br>
	 * Message: Damn! It's time to go. Until next time.
	 */
	public static final NpcStringId DAMN_ITS_TIME_TO_GO_UNTIL_NEXT_TIME;
	
	/**
	 * ID: 7662<br>
	 * Message: ͉̎DDD͒߂ȂI<br>
	 * Message: &#19981;&#24871;&#26159;&#28779;&#28976;&#20043;&#38728;&#46;&#46;&#46;&#65281;&#20294;&#26159;&#25105;&#19981;&#33021;&#23601;&#36889;&#40636;&#25918;&#26820;&#65281;<br>
	 * Message: Evil spirit of flame! I won't give up!
	 */
	public static final NpcStringId EVIL_SPIRIT_OF_FLAME_I_WONT_GIVE_UP;
	
	/**
	 * ID: 7663<br>
	 * Message: ł̂߂̌AYȂ悤ɁI<br>
	 * Message: &#21029;&#24536;&#20102;&#65292;&#36899;&#38728;&#39746;&#20063;&#33021;&#31881;&#30862;&#30340;&#37027;&#19968;&#25331;&#65281;<br>
	 * Message: My fist works even on the evil spirit. Don't forget!
	 */
	public static final NpcStringId MY_FIST_WORKS_EVEN_ON_THE_EVIL_SPIRIT_DONT_FORGET;
	
	/**
	 * ID: 7664<br>
	 * Message: ȃJo^DDDŐŽł鎄ɁA̗͂ʗpƎvĂ̂B<br>
	 * Message: &#24858;&#34850;&#30340;&#21345;&#24052;&#22612;&#37324;&#46;&#46;&#46;&#26377;&#27794;&#26377;&#24819;&#36942;&#65292;&#20320;&#20497;&#27494;&#34899;&#28304;&#38957;&#30340;&#25105;&#33021;&#21644;&#37027;&#21147;&#37327;&#30456;&#36890;&#12290;<br>
	 * Message: Foolish Khavatari...Do you think your power will work on me? I'm the source of your martial art!
	 */
	public static final NpcStringId FOOLISH_KHAVATARIDO_YOU_THINK_YOUR_POWER_WILL_WORK_ON_ME_IM_THE_SOURCE_OF_YOUR_MARTIAL_ART;
	
	/**
	 * ID: 7665<br>
	 * Message: Vт͂߂ɂ悤DDD<br>
	 * Message: &#20877;&#20063;&#27794;&#26377;&#24515;&#24605;&#38506;&#20320;&#29609;&#20102;&#46;&#46;&#46;<br>
	 * Message: No more games...
	 */
	public static final NpcStringId NO_MORE_GAMES;
	
	/**
	 * ID: 7666<br>
	 * Message: $s1AJo^̓ގ҂Bǂȑ݂mĐĂ̂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#46;&#46;&#46;&#26159;&#36367;&#19978;&#21345;&#24052;&#22612;&#37324;&#20043;&#36335;&#30340;&#20154;&#21966;&#65311;&#33213;&#25954;&#36319;&#25105;&#25171;&#39717;&#65292;&#20320;&#30693;&#36947;&#25105;&#26159;&#35504;&#21966;&#46;&#46;&#46;&#65311;<br>
	 * Message: $s1...Are you next after Khavatari? Do you know who I am?
	 */
	public static final NpcStringId S1ARE_YOU_NEXT_AFTER_KHAVATARI_DO_YOU_KNOW_WHO_I_AM;
	
	/**
	 * ID: 7667<br>
	 * Message: $s1AJVDDD܂܂̍UȁB̓̂ł͑ςȂقǁDDD<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#46;&#46;&#46;&#21345;&#20462;&#46;&#46;&#19981;&#23481;&#24573;&#35222;&#30340;&#25915;&#25802;&#12290;&#20197;&#25105;&#29694;&#22312;&#30340;&#32905;&#39636;&#65292;&#20877;&#20063;&#19981;&#33021;&#22533;&#25345;&#19979;&#21435;&#20102;&#46;&#46;&#46;&#36889;&#27425;&#30340;&#29694;&#36523;&#26178;&#38291;&#24456;&#30701;&#46;&#46;&#46;<br>
	 * Message: $s1...Kashu. Not a bad attack. I can't hold on much longer.
	 */
	public static final NpcStringId S1KASHU_NOT_A_BAD_ATTACK_I_CANT_HOLD_ON_MUCH_LONGER;
	
	/**
	 * ID: 7750<br>
	 * Message: $s1AAJA̍DGɂ͂ȂȂIFEIɂȂ̂͂̎I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#21644;&#20126;&#32943;&#37117;&#19981;&#26159;&#25105;&#30340;&#23565;&#25163;&#65281;&#20840;&#37117;&#21435;&#27515;&#21543;&#65281;&#25104;&#28858;&#29579;&#30340;&#20154;&#23601;&#26159;&#25105;&#65281;<br>
	 * Message: $s1, Akkan, you can't be my rival! I'll kill everything! I'll be the king!
	 */
	public static final NpcStringId S1_AKKAN_YOU_CANT_BE_MY_RIVAL_ILL_KILL_EVERYTHING_ILL_BE_THE_KING;
	
	/**
	 * ID: 7751<br>
	 * Message: nnnnI͌Ă낤IMl̎͂͂[킩I<br>
	 * Message: &#21888;&#21621;&#21621;&#21621;&#65281;&#36889;&#27425;&#23601;&#39250;&#20102;&#20320;&#20497;&#21543;&#65281;&#22240;&#28858;&#24050;&#32147;&#30693;&#36947;&#20320;&#30340;&#23526;&#21147;&#20102;&#65281;<br>
	 * Message: Ha! I'll show mercy on you this time. I know well of your technique!
	 */
	public static final NpcStringId HA_ILL_SHOW_MERCY_ON_YOU_THIS_TIME_I_KNOW_WELL_OF_YOUR_TECHNIQUE;
	
	/**
	 * ID: 7752<br>
	 * Message: xz҂̌󂯌pIHȖlɕȂāIH<br>
	 * Message: &#25105;&#27880;&#20837;&#20102;&#32113;&#27835;&#32773;&#30340;&#34880;&#65311;&#65281;&#19981;&#21487;&#33021;&#25943;&#30340;&#36889;&#40636;&#24920;&#46;&#46;&#46;&#65311;&#65281;<br>
	 * Message: I have in me the blood of a king! How could I lose?!
	 */
	public static final NpcStringId I_HAVE_IN_ME_THE_BLOOD_OF_A_KING_HOW_COULD_I_LOSE;
	
	/**
	 * ID: 7757<br>
	 * Message: \NDDDȂ̂IH<br>
	 * Message: &#26292;&#21531;&#46;&#46;&#46;&#65281;<br>
	 * Message: Are you....tyrant!
	 */
	public static final NpcStringId ARE_YOUTYRANT;
	
	/**
	 * ID: 7758<br>
	 * Message: ܂Ȃ񂩉ȂI̖\NI$s1A͂킹悤I<br>
	 * Message: &#20320;&#26681;&#26412;&#19981;&#31639;&#26159;&#20491;&#21531;&#29579;&#65281;&#20320;&#21482;&#26159;&#20491;&#26292;&#21531;&#65281;&#12300;&#36;&#115;&#49;&#12301;&#65292;&#35731;&#25105;&#20497;&#22296;&#32080;&#36215;&#20358;&#21543;&#65281;<br>
	 * Message: You're not a king! You're just a tyrant! $s1, we must fight together!
	 */
	public static final NpcStringId YOURE_NOT_A_KING_YOURE_JUST_A_TYRANT_S1_WE_MUST_FIGHT_TOGETHER;
	
	/**
	 * ID: 7759<br>
	 * Message: Ȃ񂾂獑łт񂾂낤I$s1AȖ\ĂȂȂIH<br>
	 * Message: &#23601;&#26159;&#29992;&#37027;&#31278;&#21147;&#37327;&#25903;&#37197;&#22283;&#23478;&#65292;&#22283;&#23478;&#25165;&#26371;&#28357;&#20129;&#30340;&#65281;&#12300;&#36;&#115;&#49;&#12301;&#65292;&#23565;&#26044;&#36889;&#27171;&#30340;&#26292;&#25919;&#19981;&#33021;&#22352;&#35222;&#19981;&#31649;&#21543;&#65311;&#65281;<br>
	 * Message: Such rule is ruining the country! $s1, I can't bear this tyranny any longer!
	 */
	public static final NpcStringId SUCH_RULE_IS_RUINING_THE_COUNTRY_S1_I_CANT_BEAR_THIS_TYRANNY_ANY_LONGER;
	
	/**
	 * ID: 7760<br>
	 * Message: $s1A΂񂾁I\ɍR̂͏Ɏw҂̖ڂȂ񂾂I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#21152;&#27833;&#65281;&#28961;&#35542;&#22914;&#20309;&#65292;&#25269;&#25239;&#26292;&#25919;&#19968;&#30452;&#37117;&#26159;&#38936;&#34966;&#30340;&#36012;&#20219;&#65281;<br>
	 * Message: $s1, leaders must always resist tyranny!
	 */
	public static final NpcStringId S1_LEADERS_MUST_ALWAYS_RESIST_TYRANNY;
	
	/**
	 * ID: 7761<br>
	 * Message: [A߂ȁBƗɂ߂ē{ꂻȁH<br>
	 * Message: &#22038;&#22038;&#65292;&#24453;&#22826;&#20037;&#20102;&#12290;&#38626;&#38283;&#22283;&#23478;&#22826;&#20037;&#20102;&#65292;&#26371;&#25384;&#32629;&#30340;&#65311;<br>
	 * Message: I stayed too long. I'll be punished for being away so long.
	 */
	public static final NpcStringId I_STAYED_TOO_LONG_ILL_BE_PUNISHED_FOR_BEING_AWAY_SO_LONG;
	
	/**
	 * ID: 7762<br>
	 * Message: ̂DDDN\bAlNȂ͑Ƃ߂܂ĂȂƁI<br>
	 * Message: &#36867;&#36305;&#20102;&#21966;&#46;&#46;&#46;&#31967;&#31957;&#12290;&#25033;&#35442;&#36245;&#24555;&#25235;&#20303;&#37027;&#20123;&#40657;&#26263;&#30340;&#20129;&#38728;&#65281;&#33;<br>
	 * Message: He got away, Dammit! We must catch this dark soul!
	 */
	public static final NpcStringId HE_GOT_AWAY_DAMMIT_WE_MUST_CATCH_THIS_DARK_SOUL;
	
	/**
	 * ID: 7763<br>
	 * Message: ɂĂAĉHɂȂɂ͂ǂ΂񂾁HOꏏɍlĂȂB<br>
	 * Message: &#28982;&#32780;&#65292;&#29579;&#21040;&#24213;&#26159;&#20160;&#40636;&#27171;&#30340;&#23384;&#22312;&#65311;&#35201;&#25104;&#28858;&#19968;&#20491;&#22909;&#22283;&#29579;&#25033;&#35442;&#35201;&#26377;&#20309;&#20316;&#28858;&#65311;&#20320;&#20063;&#21644;&#25105;&#19968;&#36215;&#24605;&#32771;&#30475;&#30475;&#21543;&#65311;<br>
	 * Message: What is a king? What must one do to be a good king? Think it over.
	 */
	public static final NpcStringId WHAT_IS_A_KING_WHAT_MUST_ONE_DO_TO_BE_A_GOOD_KING_THINK_IT_OVER;
	
	/**
	 * ID: 7764<br>
	 * Message: ̑OɂЂ܂IȖI<br>
	 * Message: &#22312;&#25105;&#38754;&#21069;&#36330;&#19979;&#21543;&#65281;&#36889;&#20123;&#24858;&#34850;&#30340;&#30334;&#22995;&#65281;<br>
	 * Message: Kneel down before me! Foolish people!
	 */
	public static final NpcStringId KNEEL_DOWN_BEFORE_ME_FOOLISH_PEOPLE;
	
	/**
	 * ID: 7765<br>
	 * Message: ނ鎞IĉI<br>
	 * Message: &#36225;&#29579;&#19981;&#22312;&#30340;&#26178;&#20505;&#65281;&#20302;&#33879;&#38957;&#36814;&#25509;&#29579;&#21543;&#65281;<br>
	 * Message: It's time for the king to leave! Bow your head and say goodbye!
	 */
	public static final NpcStringId ITS_TIME_FOR_THE_KING_TO_LEAVE_BOW_YOUR_HEAD_AND_SAY_GOODBYE;
	
	/**
	 * ID: 7766<br>
	 * Message: $s1I̎ɋt炤̂I͎xzҁIxzƂ͗́I͂xzɌq̂I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#22909;&#22823;&#30340;&#33213;&#23376;&#65292;&#31455;&#25954;&#21453;&#25239;&#25105;&#65281;&#21531;&#29579;&#23601;&#26159;&#32113;&#27835;&#65281;&#32113;&#27835;&#23601;&#26159;&#21147;&#37327;&#65281;&#21807;&#26377;&#24375;&#27402;&#25165;&#33021;&#25345;&#32396;&#32113;&#27835;&#65281;<br>
	 * Message: $s1! You dare to fight me? A king's power must be great to rule!
	 */
	public static final NpcStringId S1_YOU_DARE_TO_FIGHT_ME_A_KINGS_POWER_MUST_BE_GREAT_TO_RULE;
	
	/**
	 * ID: 7767<br>
	 * Message: MlƂaƂ́I$s1A؂ȁI<br>
	 * Message: &#21312;&#21312;&#19968;&#20491;&#20320;&#31455;&#25954;&#25915;&#25802;&#21531;&#29579;&#46;&#46;&#65281;&#12300;&#36;&#115;&#49;&#12301;&#65292;&#31713;&#20301;&#32773;&#46;&#46;&#46;&#65281;<br>
	 * Message: You would fight the king, $s1? Traitor!
	 */
	public static final NpcStringId YOU_WOULD_FIGHT_THE_KING_S1_TRAITOR;
	
	/**
	 * ID: 7850<br>
	 * Message: fWJ TqI$s1ATq̌ _n̈З͂I<br>
	 * Message: &#37941;&#36040;&#21345;&#21202;&#32;&#25746;&#29246;&#24076;&#65281;&#12300;&#36;&#115;&#49;&#12301;&#65292;&#30631;&#30631;&#25746;&#29246;&#24076;&#30340;&#21897;&#33292;&#32;&#40664;&#36948;&#21704;&#30340;&#23041;&#21147;&#65281;<br>
	 * Message: Tejakar Sharuhi! $s1, I'll show you the power of Sharuhi Mouth Mudaha!
	 */
	public static final NpcStringId TEJAKAR_SHARUHI_S1_ILL_SHOW_YOU_THE_POWER_OF_SHARUHI_MOUTH_MUDAHA;
	
	/**
	 * ID: 7851<br>
	 * Message: ႠIÂɂĂĂ΁IO̎u͎DDDAЂƂ܂͌ނI<br>
	 * Message: &#21683;&#21834;&#21834;&#21704;&#65281;&#38728;&#39746;&#65292;&#23433;&#38748;&#40670;&#21543;&#65281;&#20320;&#30340;&#24847;&#24605;&#26159;&#25105;&#26159;&#46;&#46;&#46;&#65281;&#20808;&#24460;&#36864;&#20877;&#35498;&#65294;&#65294;&#65281;<br>
	 * Message: Aaargh! My soul won't keep quiet. Now I must take my leave.
	 */
	public static final NpcStringId AAARGH_MY_SOUL_WONT_KEEP_QUIET_NOW_I_MUST_TAKE_MY_LEAVE;
	
	/**
	 * ID: 7852<br>
	 * Message: ߂ATqBÔ͎̂Î̂Ȃ񂾂I<br>
	 * Message: &#19981;&#34892;&#65292;&#25746;&#29246;&#24076;&#20320;&#26159;&#25105;&#30340;&#65281;&#38728;&#39746;&#21834;&#65292;&#20320;&#26159;&#25105;&#30340;&#21834;&#21834;&#21834;&#65281;<br>
	 * Message: No, Sharuhi. You're soul is mine!
	 */
	public static final NpcStringId NO_SHARUHI_YOURE_SOUL_IS_MINE;
	
	/**
	 * ID: 7857<br>
	 * Message: fWJ IJIfWJ hD_[}I<br>
	 * Message: &#37941;&#36040;&#21345;&#21202;&#20800;&#32645;&#21345;&#65281;&#27888;&#21152;&#21345;&#21202;&#37117;&#36948;&#29802;&#25289;&#65281;<br>
	 * Message: Tejakar Oroca! Tejakar Duda-Mara!
	 */
	public static final NpcStringId TEJAKAR_OROCA_TEJAKAR_DUDA_MARA;
	
	/**
	 * ID: 7858<br>
	 * Message: $s1Ai~Ɛ키ȂAƈꏏɂ̗썰߂悤I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#22914;&#26524;&#20320;&#24050;&#28310;&#20633;&#22909;&#23565;&#25239;&#37027;&#27704;&#36960;&#30340;&#23506;&#20908;&#65292;&#37027;&#23601;&#21644;&#25105;&#19968;&#36215;&#21046;&#26381;&#37027;&#20491;&#38728;&#39746;&#21543;&#65281;<br>
	 * Message: $s1, we must fight this soul together to prevent an everlasting winter!
	 */
	public static final NpcStringId S1_WE_MUST_FIGHT_THIS_SOUL_TOGETHER_TO_PREVENT_AN_EVERLASTING_WINTER;
	
	/**
	 * ID: 7859<br>
	 * Message: $s1I̗썰͂ȂɔҁIȂ̍U߂邾낤I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#37027;&#20491;&#38728;&#39746;&#23565;&#20320;&#26377;&#25152;&#21453;&#25033;&#65281;&#20320;&#30340;&#25915;&#25802;&#21487;&#20197;&#21046;&#26381;&#20182;&#65281;<br>
	 * Message: $s1! The soul responds to you. May your attack quiet him!
	 */
	public static final NpcStringId S1_THE_SOUL_RESPONDS_TO_YOU_MAY_YOUR_ATTACK_QUIET_HIM;
	
	/**
	 * ID: 7860<br>
	 * Message: $s1ITq߂񂾁I͂łɎ̌Ƃ͕ʁI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#37806;&#26381;&#25746;&#29246;&#24076;&#21543;&#65281;&#20182;&#24050;&#32147;&#19981;&#32893;&#25105;&#30340;&#25351;&#25582;&#20102;&#65281;<br>
	 * Message: $s1! Calm Sharuhi! He doesn't listen to me anymore.
	 */
	public static final NpcStringId S1_CALM_SHARUHI_HE_DOESNT_LISTEN_TO_ME_ANYMORE;
	
	/**
	 * ID: 7861<br>
	 * Message: IɔM̉̂񂱂ƂI<br>
	 * Message: &#24050;&#32147;&#21040;&#20102;&#35442;&#38626;&#38283;&#30340;&#26178;&#21051;&#65281;&#22312;&#20320;&#30340;&#38754;&#21069;&#26377;&#29105;&#28872;&#25793;&#35703;&#20320;&#30340;&#20154;&#65281;<br>
	 * Message: It's time to go! May the eternal flame bless you!
	 */
	public static final NpcStringId ITS_TIME_TO_GO_MAY_THE_ETERNAL_FLAME_BLESS_YOU;
	
	/**
	 * ID: 7862<br>
	 * Message: ނ͋DDDcODDDcODDD<br>
	 * Message: &#20182;&#38626;&#38283;&#30340;&#35441;&#46;&#46;&#46;&#19981;&#34892;&#46;&#46;&#46;&#19981;&#34892;&#46;&#46;&#46;<br>
	 * Message: He left...That's too bad..Too bad...
	 */
	public static final NpcStringId HE_LEFTTHATS_TOO_BADTOO_BAD;
	
	/**
	 * ID: 7863<br>
	 * Message: ނÂ߂̐SAYꂸɂȁDDD<br>
	 * Message: &#21029;&#24536;&#20102;&#29694;&#22312;&#24819;&#35201;&#24179;&#24489;&#20182;&#30340;&#24515;&#24773;&#46;&#46;&#46;<br>
	 * Message: Don't forget your strong will now!
	 */
	public static final NpcStringId DONT_FORGET_YOUR_STRONG_WILL_NOW;
	
	/**
	 * ID: 7864<br>
	 * Message: VAAAbI2xƒN̎xz󂯂ʁI<br>
	 * Message: &#21703;&#21704;&#21704;&#21704;&#65281;&#25105;&#20877;&#20063;&#19981;&#35201;&#21463;&#20219;&#20309;&#20154;&#30340;&#25903;&#37197;&#65281;&#32;<br>
	 * Message: Ha! Nobody will rule over me anymore!
	 */
	public static final NpcStringId HA_NOBODY_WILL_RULE_OVER_ME_ANYMORE;
	
	/**
	 * ID: 7865<br>
	 * Message: RARA䂤I<br>
	 * Message: &#33258;&#30001;&#65292;&#33258;&#30001;&#65292;&#33258;&#30001;&#30001;&#30001;&#46;&#46;&#46;&#65281;<br>
	 * Message: Freedom... freedom... freedom!
	 */
	public static final NpcStringId FREEDOM_FREEDOM_FREEDOM;
	
	/**
	 * ID: 7866<br>
	 * Message: $s1AĂꂽOAǂ͎߂悤ƂĂ̂ȁIVAAAAbI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#20320;&#26366;&#32147;&#35299;&#25918;&#36942;&#25105;&#65292;&#20294;&#26368;&#32066;&#36996;&#26159;&#24819;&#35201;&#36910;&#25429;&#25105;&#21543;&#65281;&#21703;&#21704;&#21704;&#21704;&#21704;&#65281;<br>
	 * Message: $s1, You released me, but you also want to catch me. Ha!
	 */
	public static final NpcStringId S1_YOU_RELEASED_ME_BUT_YOU_ALSO_WANT_TO_CATCH_ME_HA;
	
	/**
	 * ID: 7867<br>
	 * Message: $s1AÔ͎ƂvĂĂ̂ȁDDD悩낤DDDOɎ̗݂͂DDD<br>
	 * Message: &#46;&#46;&#46;&#12300;&#36;&#115;&#49;&#12301;&#46;&#46;&#46;&#21407;&#20358;&#20320;&#26159;&#36889;&#40636;&#30475;&#24453;&#25105;&#30340;&#46;&#46;&#46;&#22909;&#21543;&#46;&#46;&#46;&#23601;&#25226;&#25105;&#30340;&#21147;&#37327;&#20511;&#32102;&#20320;&#29992;&#29992;&#46;&#46;&#46;<br>
	 * Message: ...$s1...Me?....All right...I'll help you.
	 */
	public static final NpcStringId S1MEALL_RIGHTILL_HELP_YOU;
	
	/**
	 * ID: 7950<br>
	 * Message: ނI͐_ւꏊI<br>
	 * Message: &#36864;&#19979;&#65281;&#36889;&#35041;&#31105;&#27490;&#22823;&#33251;&#36914;&#20837;&#12290;<br>
	 * Message: Get out of here! This place is forbidden by god.
	 */
	public static final NpcStringId GET_OUT_OF_HERE_THIS_PLACE_IS_FORBIDDEN_BY_GOD;
	
	/**
	 * ID: 7951<br>
	 * Message: ACnU[hlĂтB<br>
	 * Message: &#27575;&#28023;&#34217;&#21914;&#25105;&#20358;&#30340;&#12290;<br>
	 * Message: Einhasad is calling me.
	 */
	public static final NpcStringId EINHASAD_IS_CALLING_ME;
	
	/**
	 * ID: 7952<br>
	 * Message: EƂ́DDD_̎􂢂|Ȃ̂B<br>
	 * Message: &#20320;&#27578;&#20102;&#25105;&#65292;&#38627;&#36947;&#20320;&#19981;&#30031;&#25084;&#31070;&#30340;&#35419;&#21650;&#65281;<br>
	 * Message: You killed me! Aren't you afraid of god's curse?
	 */
	public static final NpcStringId YOU_KILLED_ME_ARENT_YOU_AFRAID_OF_GODS_CURSE;
	
	/**
	 * ID: 7953<br>
	 * Message: ̕DDD$s1Aɂ̂I<br>
	 * Message: &#33213;&#25954;&#27450;&#36000;&#25105;&#30340;&#37096;&#19979;&#65292;&#12300;&#36;&#115;&#49;&#12301;&#20320;&#19981;&#24819;&#27963;&#20102;&#21966;&#65311;&#32;<br>
	 * Message: You bother my minions, $s1. Do you want to die?
	 */
	public static final NpcStringId YOU_BOTHER_MY_MINIONS_S1_DO_YOU_WANT_TO_DIE;
	
	/**
	 * ID: 7954<br>
	 * Message: Ȃ͂DDDDDDƂ́B<br>
	 * Message: &#20160;&#40636;&#65292;&#25105;&#46;&#46;&#46;&#25915;&#25802;&#20182;&#20497;<br>
	 * Message: What the hell... I lost.
	 */
	public static final NpcStringId WHAT_THE_HELL_I_LOST;
	
	/**
	 * ID: 7955<br>
	 * Message: NMĺIזȁI<br>
	 * Message: &#20320;&#26159;&#20160;&#40636;&#26481;&#35199;&#65292;&#25954;&#25554;&#25163;&#31649;&#38290;&#20107;&#65281;<br>
	 * Message: Who are you? Why are you interfering in our business?
	 */
	public static final NpcStringId WHO_ARE_YOU_WHY_ARE_YOU_INTERFERING_IN_OUR_BUSINESS;
	
	/**
	 * ID: 7956<br>
	 * Message: DDD͗e͂ʂI<br>
	 * Message: &#24456;&#21426;&#23475;&#46;&#46;&#46;&#20294;&#26159;&#19979;&#27425;&#32085;&#23565;&#19981;&#26371;&#25918;&#36942;&#20320;&#30340;&#65281;<br>
	 * Message: You're strong. I'll get you next time!
	 */
	public static final NpcStringId YOURE_STRONG_ILL_GET_YOU_NEXT_TIME;
	
	/**
	 * ID: 7957<br>
	 * Message: ܂ȁDDDx͓|ĂI<br>
	 * Message: &#21448;&#35211;&#38754;&#20102;&#65281;&#36889;&#27425;&#32085;&#23565;&#35201;&#25235;&#21040;&#65281;<br>
	 * Message: We meet again. I'll have you this time!
	 */
	public static final NpcStringId WE_MEET_AGAIN_ILL_HAVE_YOU_THIS_TIME;
	
	/**
	 * ID: 7958<br>
	 * Message: ͂苭DDDA$s1A`ĂB<br>
	 * Message: &#26524;&#30495;&#24456;&#21426;&#23475;&#65292;&#12300;&#36;&#115;&#49;&#12301;&#24171;&#24171;&#25105;&#21543;&#12290;<br>
	 * Message: A worthy opponent. $s1. Help me!
	 */
	public static final NpcStringId A_WORTHY_OPPONENT_S1_HELP_ME;
	
	/**
	 * ID: 7959<br>
	 * Message: $s1IOɋ}B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#36225;&#37027;&#20491;&#20642;&#20249;&#36867;&#36305;&#20043;&#21069;&#36245;&#24555;&#34892;&#21205;&#21543;&#12290;<br>
	 * Message: $s1! Hurry before he gets away!
	 */
	public static final NpcStringId S1_HURRY_BEFORE_HE_GETS_AWAY;
	
	/**
	 * ID: 7960<br>
	 * Message: EI<br>
	 * Message: &#21435;&#27515;&#21543;&#65281;<br>
	 * Message: I'll kill you!
	 */
	public static final NpcStringId ILL_KILL_YOU;
	
	/**
	 * ID: 7961<br>
	 * Message: 荇킹肤B<br>
	 * Message: &#25214;&#19968;&#22825;&#36611;&#37327;&#36611;&#37327;&#19968;&#19979;&#12290;<br>
	 * Message: Why don't you fight me someday?
	 */
	public static final NpcStringId WHY_DONT_YOU_FIGHT_ME_SOMEDAY;
	
	/**
	 * ID: 7962<br>
	 * Message: ܂̂II<br>
	 * Message: &#31967;&#31957;&#65292;&#36889;&#27425;&#21448;&#37679;&#36942;&#20102;&#65281;<br>
	 * Message: I missed again. Dammit!
	 */
	public static final NpcStringId I_MISSED_AGAIN_DAMMIT;
	
	/**
	 * ID: 7963<br>
	 * Message: ܂邾낤B<br>
	 * Message: &#32317;&#26377;&#19968;&#22825;&#26371;&#20877;&#36935;&#21040;&#30340;&#12290;<br>
	 * Message: I'm sure we'll meet again someday.
	 */
	public static final NpcStringId IM_SURE_WELL_MEET_AGAIN_SOMEDAY;
	
	/**
	 * ID: 7964<br>
	 * Message: _ɋt炤҂ɓVI<br>
	 * Message: &#32972;&#21467;&#31070;&#30340;&#20154;&#32317;&#26377;&#19968;&#22825;&#26371;&#36973;&#22825;&#36963;&#30340;&#65281;<br>
	 * Message: Curse those who defy the gods!
	 */
	public static final NpcStringId CURSE_THOSE_WHO_DEFY_THE_GODS;
	
	/**
	 * ID: 7966<br>
	 * Message: _̎g҂ł邱̎ɂĂƂ́I<br>
	 * Message: &#31455;&#25954;&#24825;&#28779;&#31070;&#30340;&#20351;&#32773;&#25105;&#65311;<br>
	 * Message: You would fight me, a messenger of the gods?
	 */
	public static final NpcStringId YOU_WOULD_FIGHT_ME_A_MESSENGER_OF_THE_GODS;
	
	/**
	 * ID: 7967<br>
	 * Message: $s1IYȂI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#25105;&#26371;&#35352;&#20303;&#20320;&#30340;&#12290;<br>
	 * Message: $s1! I won't forget you.
	 */
	public static final NpcStringId S1_I_WONT_FORGET_YOU;
	
	/**
	 * ID: 8050<br>
	 * Message: $s1A_ȒnƂ́I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#31455;&#25954;&#20405;&#29359;&#31070;&#32854;&#30340;&#38936;&#22495;&#12290;<br>
	 * Message: $s1! How could you desecrate a holy place?
	 */
	public static final NpcStringId S1_HOW_COULD_YOU_DESECRATE_A_HOLY_PLACE;
	
	/**
	 * ID: 8051<br>
	 * Message: 傫ȔOɋ邪B<br>
	 * Message: &#21463;&#21040;&#37325;&#32624;&#20197;&#21069;&#36245;&#24555;&#28414;&#38283;&#21543;&#12290;<br>
	 * Message: Leave before you are severely punished!
	 */
	public static final NpcStringId LEAVE_BEFORE_YOU_ARE_SEVERELY_PUNISHED;
	
	/**
	 * ID: 8052<br>
	 * Message: ACnU[hlÂĂȂłI<br>
	 * Message: &#27575;&#28023;&#34217;&#21029;&#36986;&#26820;&#25105;&#65281;<br>
	 * Message: Einhasad, don't give up on me!
	 */
	public static final NpcStringId EINHASAD_DONT_GIVE_UP_ON_ME;
	
	/**
	 * ID: 8053<br>
	 * Message: TĂ̂́A$s1AOB<br>
	 * Message: &#22312;&#25214;&#25105;&#30340;&#20154;&#65292;&#26159;&#12300;&#36;&#115;&#49;&#12301;&#20320;&#21966;&#65311;<br>
	 * Message: $s1, so you're the one who's looking for me?
	 */
	public static final NpcStringId S1_SO_YOURE_THE_ONE_WHOS_LOOKING_FOR_ME;
	
	/**
	 * ID: 8054<br>
	 * Message: E̐ȂǂɂƂ́DDD<br>
	 * Message: &#25105;&#31455;&#28982;&#26371;&#27515;&#22312;&#20961;&#30028;&#29983;&#29289;&#30340;&#25163;&#35041;&#46;&#46;&#46;<br>
	 * Message: A mere mortal has defeated me!
	 */
	public static final NpcStringId A_MERE_MORTAL_HAS_DEFEATED_ME;
	
	/**
	 * ID: 8055<br>
	 * Message: NbA킢̎זƂ͔ڋȁB<br>
	 * Message: &#20160;&#40636;&#65281;&#30495;&#21329;&#37145;&#65292;&#31455;&#28982;&#20171;&#20837;&#21029;&#20154;&#30340;&#25136;&#39717;&#12290;<br>
	 * Message: How cowardly to intrude in other people's business.
	 */
	public static final NpcStringId HOW_COWARDLY_TO_INTRUDE_IN_OTHER_PEOPLES_BUSINESS;
	
	/**
	 * ID: 8056<br>
	 * Message: ԂB<br>
	 * Message: &#26178;&#38291;&#21040;&#20102;&#12290;<br>
	 * Message: Time is up.
	 */
	public static final NpcStringId TIME_IS_UP;
	
	/**
	 * ID: 8057<br>
	 * Message: ̌󂯂Ă݂I<br>
	 * Message: &#20320;&#36889;&#21487;&#24801;&#30340;&#20642;&#20249;&#65292;&#25509;&#25307;&#21543;&#65281;<br>
	 * Message: I'll kill you with my sword!
	 */
	public static final NpcStringId ILL_KILL_YOU_WITH_MY_SWORD;
	
	/**
	 * ID: 8058<br>
	 * Message: ĂI<br>
	 * Message: &#24171;&#24171;&#24537;&#21543;&#65281;<br>
	 * Message: Help me!
	 */
	public static final NpcStringId HELP_ME;
	
	/**
	 * ID: 8059<br>
	 * Message: ȁI<br>
	 * Message: &#32085;&#23565;&#19981;&#33021;&#25918;&#36942;&#65281;<br>
	 * Message: Don't miss!
	 */
	public static final NpcStringId DONT_MISS;
	
	/**
	 * ID: 8060<br>
	 * Message: Ɖ߂I<br>
	 * Message: &#20877;&#29992;&#21147;&#25512;&#25512;&#30475;&#65281;<br>
	 * Message: Keep pushing!
	 */
	public static final NpcStringId KEEP_PUSHING;
	
	/**
	 * ID: 8061<br>
	 * Message: A߂܂ČN݂̍𐰂炵Ă낤B<br>
	 * Message: &#29694;&#22312;&#36889;&#32676;&#26379;&#21451;&#25235;&#20303;&#36889;&#20491;&#20642;&#20249;&#20102;&#65292;&#23559;&#35299;&#38283;&#20320;&#20497;&#30340;&#24616;&#32080;&#65281;<br>
	 * Message: I'll get him. You'll have your revenge.
	 */
	public static final NpcStringId ILL_GET_HIM_YOULL_HAVE_YOUR_REVENGE;
	
	/**
	 * ID: 8062<br>
	 * Message: ܂𓦂̂BKOЕtĂB<br>
	 * Message: &#20160;&#40636;&#65292;&#21448;&#35731;&#37027;&#20642;&#20249;&#36305;&#20102;&#12290;&#19968;&#23450;&#35201;&#36910;&#21040;&#20182;&#12290;<br>
	 * Message: I missed him again. I'll kill you.
	 */
	public static final NpcStringId I_MISSED_HIM_AGAIN_ILL_KILL_YOU;
	
	/**
	 * ID: 8063<br>
	 * Message: ͂ǂB<br>
	 * Message: &#25105;&#35201;&#21435;&#36861;&#25802;&#37027;&#20491;&#20642;&#20249;&#20102;&#12290;<br>
	 * Message: I must follow him.
	 */
	public static final NpcStringId I_MUST_FOLLOW_HIM;
	
	/**
	 * ID: 8150<br>
	 * Message: $s1A_̓{Ȃ狎邪I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#30031;&#25084;&#31070;&#20043;&#24594;&#30340;&#35441;&#65292;&#23601;&#36864;&#19979;&#21435;&#21543;&#65281;<br>
	 * Message: $s1, you should leave if you fear god's wrath!
	 */
	public static final NpcStringId S1_YOU_SHOULD_LEAVE_IF_YOU_FEAR_GODS_WRATH;
	
	/**
	 * ID: 8151<br>
	 * Message: Ȏɉ̗pH<br>
	 * Message: &#36889;&#20491;&#26178;&#20505;&#65292;&#30332;&#29983;&#20102;&#20160;&#40636;&#20107;&#65311;<br>
	 * Message: What's going on?
	 */
	public static final NpcStringId WHATS_GOING_ON;
	
	/**
	 * ID: 8152<br>
	 * Message: ܂ƂɂȂ邾낤I<br>
	 * Message: &#26371;&#20877;&#30456;&#36935;&#30340;&#65281;<br>
	 * Message: I'll see you again!
	 */
	public static final NpcStringId ILL_SEE_YOU_AGAIN;
	
	/**
	 * ID: 8153<br>
	 * Message: O͉҂HȂ̕ɂ߂̂H<br>
	 * Message: &#20320;&#20197;&#28858;&#20320;&#26159;&#35504;&#65292;&#31455;&#25954;&#27450;&#36000;&#25105;&#30340;&#38568;&#24478;&#65311;<br>
	 * Message: Who are you? Why are you bothering my minions?
	 */
	public static final NpcStringId WHO_ARE_YOU_WHY_ARE_YOU_BOTHERING_MY_MINIONS;
	
	/**
	 * ID: 8154<br>
	 * Message: ߂I<br>
	 * Message: &#19981;&#34892;&#65281;&#65281;&#65281;<br>
	 * Message: No way!!!
	 */
	public static final NpcStringId NO_WAY;
	
	/**
	 * ID: 8155<br>
	 * Message: NMĺIזȁI<br>
	 * Message: &#20320;&#26159;&#20160;&#40636;&#26481;&#35199;&#65292;&#25954;&#25554;&#25163;&#31649;&#38290;&#20107;&#65311;<br>
	 * Message: Why are you sticking your nose in our business?
	 */
	public static final NpcStringId WHY_ARE_YOU_STICKING_YOUR_NOSE_IN_OUR_BUSINESS;
	
	/**
	 * ID: 8156<br>
	 * Message: Ml͉҂HE̐܂ŋƂ́DDD<br>
	 * Message: &#20320;&#26159;&#35504;&#65311;&#19979;&#30028;&#30340;&#29983;&#29289;&#31455;&#28982;&#26371;&#36889;&#40636;&#24375;&#46;&#46;&#46;<br>
	 * Message: Who are you? How can a creature from the netherworld be so powerful?
	 */
	public static final NpcStringId WHO_ARE_YOU_HOW_CAN_A_CREATURE_FROM_THE_NETHERWORLD_BE_SO_POWERFUL;
	
	/**
	 * ID: 8157<br>
	 * Message: ōŌォDDD<br>
	 * Message: &#36889;&#26159;&#26368;&#24460;&#19968;&#27425;&#21966;&#65311;<br>
	 * Message: Is this the end?
	 */
	public static final NpcStringId IS_THIS_THE_END;
	
	/**
	 * ID: 8158<br>
	 * Message: O̘rĂ݂B|񂾁I<br>
	 * Message: &#23637;&#29694;&#19968;&#19979;&#23526;&#21147;&#21966;&#65311;&#25171;&#20498;&#36889;&#20491;&#20642;&#20249;&#21543;&#65281;<br>
	 * Message: Show me what you're made of. Kill him!
	 */
	public static final NpcStringId SHOW_ME_WHAT_YOURE_MADE_OF_KILL_HIM;
	
	/**
	 * ID: 8159<br>
	 * Message: ̒x̘rł|ƎvĂ̂B<br>
	 * Message: &#20197;&#20320;&#36889;&#27171;&#30340;&#19977;&#33139;&#35987;&#21151;&#22827;&#65292;&#33021;&#25235;&#20303;&#36889;&#20491;&#20642;&#20249;&#21966;&#65311;<br>
	 * Message: You think you can get him with that?
	 */
	public static final NpcStringId YOU_THINK_YOU_CAN_GET_HIM_WITH_THAT;
	
	/**
	 * ID: 8160<br>
	 * Message: A΂I悤ƂĂ邶ȂB<br>
	 * Message: &#20351;&#21185;&#40670;&#65281;&#37027;&#20491;&#20642;&#20249;&#35201;&#36867;&#36305;&#20102;&#12290;<br>
	 * Message: Pull yourself together! He's trying to get away.
	 */
	public static final NpcStringId PULL_YOURSELF_TOGETHER_HES_TRYING_TO_GET_AWAY;
	
	/**
	 * ID: 8161<br>
	 * Message: ubN Lbgɓ`B؂͕ԂƁB<br>
	 * Message: &#35531;&#21578;&#35380;&#24067;&#25289;&#20811;&#20977;&#29305;&#65292;&#21483;&#20182;&#34880;&#20661;&#34880;&#36996;&#12290;<br>
	 * Message: Tell the Black Cat that I got his paid back.
	 */
	public static final NpcStringId TELL_THE_BLACK_CAT_THAT_I_GOT_HIS_PAID_BACK;
	
	/**
	 * ID: 8162<br>
	 * Message: ubN LbĝAނ낤ȁB<br>
	 * Message: &#24067;&#25289;&#20811;&#20977;&#29305;&#26371;&#24616;&#24680;&#25105;&#30340;&#12290;<br>
	 * Message: Black Cat, he'll blame me.
	 */
	public static final NpcStringId BLACK_CAT_HELL_BLAME_ME;
	
	/**
	 * ID: 8163<br>
	 * Message: ɂĎB<br>
	 * Message: &#21040;&#27492;&#28858;&#27490;&#12290;<br>
	 * Message: I gotta' go now.
	 */
	public static final NpcStringId I_GOTTA_GO_NOW;
	
	/**
	 * ID: 8166<br>
	 * Message: _̌䖼ɂĂOnB<br>
	 * Message: &#22857;&#31070;&#30340;&#24847;&#26088;&#20358;&#25074;&#32624;&#20320;&#12290;<br>
	 * Message: I'll kill you in the name of god.
	 */
	public static final NpcStringId ILL_KILL_YOU_IN_THE_NAME_OF_GOD;
	
	/**
	 * ID: 8167<br>
	 * Message: $s1I܂I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#24460;&#26371;&#26377;&#26399;&#65281;<br>
	 * Message: $s1! See you later.
	 */
	public static final NpcStringId S1_SEE_YOU_LATER;
	
	/**
	 * ID: 8251<br>
	 * Message: 傫ȔOɋ邪B<br>
	 * Message: &#21463;&#21040;&#37325;&#32624;&#20197;&#21069;&#36245;&#24555;&#28414;&#38283;&#21543;&#12290;<br>
	 * Message: Get out before you're punished!
	 */
	public static final NpcStringId GET_OUT_BEFORE_YOURE_PUNISHED;
	
	/**
	 * ID: 8252<br>
	 * Message: ACnU[hlÂĂȂłI<br>
	 * Message: &#27575;&#28023;&#34217;&#21029;&#36986;&#26820;&#25105;&#65281;<br>
	 * Message: Einhasad, please don't give up on me!
	 */
	public static final NpcStringId EINHASAD_PLEASE_DONT_GIVE_UP_ON_ME;
	
	/**
	 * ID: 8253<br>
	 * Message: TĂ̂́A$s1AOB<br>
	 * Message: &#22312;&#25214;&#25105;&#30340;&#20154;&#65292;&#26159;&#12300;&#36;&#115;&#49;&#12301;&#20320;&#21966;&#65311;<br>
	 * Message: $s1, are you looking for me?
	 */
	public static final NpcStringId S1_ARE_YOU_LOOKING_FOR_ME;
	
	/**
	 * ID: 8254<br>
	 * Message: E̐ȂǂɂƂ́DDD<br>
	 * Message: &#25105;&#31455;&#28982;&#26371;&#27515;&#22312;&#20961;&#30028;&#29983;&#29289;&#30340;&#25163;&#35041;&#46;&#46;&#46;<br>
	 * Message: A mere mortal is killing me!
	 */
	public static final NpcStringId A_MERE_MORTAL_IS_KILLING_ME;
	
	/**
	 * ID: 8256<br>
	 * Message: E̐AŎ̈̑傳킩B<br>
	 * Message: &#20961;&#30028;&#30340;&#29983;&#29289;&#20497;&#65292;&#29694;&#22312;&#20320;&#20497;&#38936;&#24735;&#21040;&#25105;&#30340;&#20553;&#22823;&#20102;&#21543;&#65311;<br>
	 * Message: Mortal, don't you recognize my greatness?
	 */
	public static final NpcStringId MORTAL_DONT_YOU_RECOGNIZE_MY_GREATNESS;
	
	/**
	 * ID: 8257<br>
	 * Message: xMlK|ĂB<br>
	 * Message: &#36889;&#27425;&#25105;&#19968;&#23450;&#35201;&#25235;&#21040;&#20320;&#36889;&#20491;&#20642;&#20249;&#12290;<br>
	 * Message: I'll get you this time.
	 */
	public static final NpcStringId ILL_GET_YOU_THIS_TIME;
	
	/**
	 * ID: 8258<br>
	 * Message: ̂̐킢ŕÏuBA$s1Iꏏɓ|B<br>
	 * Message: &#36942;&#21435;&#25171;&#39717;&#26178;&#30041;&#19979;&#30340;&#20663;&#30165;&#65292;&#35731;&#25105;&#32831;&#32831;&#26044;&#25079;&#12290;&#21890;&#65292;&#12300;&#36;&#115;&#49;&#12301;&#65281;&#19968;&#36215;&#38500;&#25481;&#36889;&#20491;&#20642;&#20249;&#21543;&#12290;<br>
	 * Message: I'll never forget the taste of his steel, $s1! Let's fight him together!
	 */
	public static final NpcStringId ILL_NEVER_FORGET_THE_TASTE_OF_HIS_STEEL_S1_LETS_FIGHT_HIM_TOGETHER;
	
	/**
	 * ID: 8259<br>
	 * Message: $s1I΂Î܂܂Ⴀ𓦂Ă܂I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#20877;&#22810;&#20351;&#40670;&#21185;&#12290;&#20877;&#36889;&#27171;&#30340;&#35441;&#65292;&#37027;&#20491;&#20642;&#20249;&#23601;&#35201;&#36867;&#36208;&#20102;&#65281;<br>
	 * Message: $s1! Pull yourself together. We'll miss him!
	 */
	public static final NpcStringId S1_PULL_YOURSELF_TOGETHER_WELL_MISS_HIM;
	
	/**
	 * ID: 8260<br>
	 * Message: $s1IɓꂻB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#36889;&#20491;&#20642;&#20249;&#35201;&#36867;&#36305;&#20102;&#12290;<br>
	 * Message: $s1! He's trying to get away.
	 */
	public static final NpcStringId S1_HES_TRYING_TO_GET_AWAY;
	
	/**
	 * ID: 8261<br>
	 * Message: ܂BKDDD<br>
	 * Message: &#21448;&#25918;&#36942;&#20182;&#30340;&#35441;&#65292;&#19979;&#27425;&#19968;&#23450;&#46;&#46;&#46;<br>
	 * Message: I missed again! Next time...
	 */
	public static final NpcStringId I_MISSED_AGAIN_NEXT_TIME;
	
	/**
	 * ID: 8262<br>
	 * Message: DDD܂sB<br>
	 * Message: &#24590;&#40636;&#46;&#46;&#46;&#36889;&#27425;&#21448;&#22833;&#25943;&#20102;&#21966;&#65311;&#32;<br>
	 * Message: Dammit! Failed again!
	 */
	public static final NpcStringId DAMMIT_FAILED_AGAIN;
	
	/**
	 * ID: 8353<br>
	 * Message: TĂ̂́A$s1AOB<br>
	 * Message: &#22312;&#25214;&#25105;&#30340;&#20154;&#65292;&#26159;&#12300;&#36;&#115;&#49;&#12301;&#20320;&#21966;&#65311;<br>
	 * Message: You are the one who's looking for me, $s1?
	 */
	public static final NpcStringId YOU_ARE_THE_ONE_WHOS_LOOKING_FOR_ME_S1;
	
	/**
	 * ID: 8354<br>
	 * Message: E̐ȂǂɂƂ́DDD<br>
	 * Message: &#25105;&#31455;&#28982;&#26371;&#27515;&#22312;&#20961;&#30028;&#29983;&#29289;&#30340;&#25163;&#35041;&#46;&#46;&#46;<br>
	 * Message: A mere mortal has killed me!
	 */
	public static final NpcStringId A_MERE_MORTAL_HAS_KILLED_ME;
	
	/**
	 * ID: 8355<br>
	 * Message: NbDDDMl͉҂HȂ킢̎ז񂾁I<br>
	 * Message: &#21487;&#24801;&#65292;&#20320;&#26159;&#20160;&#40636;&#26481;&#35199;&#65292;&#25954;&#25554;&#25163;&#31649;&#38290;&#20107;&#65281;<br>
	 * Message: Who are you? This is none of your business!
	 */
	public static final NpcStringId WHO_ARE_YOU_THIS_IS_NONE_OF_YOUR_BUSINESS;
	
	/**
	 * ID: 8359<br>
	 * Message: $s1IƓ񒣂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#20877;&#22810;&#20351;&#40670;&#21185;&#12290;<br>
	 * Message: $s1! Pull yourself together.
	 */
	public static final NpcStringId S1_PULL_YOURSELF_TOGETHER;
	
	/**
	 * ID: 8360<br>
	 * Message: $s1IɓꂻB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#36889;&#20491;&#20642;&#20249;&#35201;&#36867;&#36305;&#20102;&#12290;<br>
	 * Message: $s1! He'll get away!
	 */
	public static final NpcStringId S1_HELL_GET_AWAY;
	
	/**
	 * ID: 8452<br>
	 * Message: ACnU[hlÂĂȂłI<br>
	 * Message: &#27575;&#28023;&#34217;&#21029;&#36986;&#26820;&#25105;&#65281;<br>
	 * Message: Einhasad, please don't forsake me!
	 */
	public static final NpcStringId EINHASAD_PLEASE_DONT_FORSAKE_ME;
	
	/**
	 * ID: 8453<br>
	 * Message: TĂ̂́A$s1AOB<br>
	 * Message: &#22312;&#25214;&#25105;&#30340;&#20154;&#65292;&#26159;&#12300;&#36;&#115;&#49;&#12301;&#20320;&#21966;&#65311;<br>
	 * Message: Looking for me, $s1?
	 */
	public static final NpcStringId LOOKING_FOR_ME_S1;
	
	/**
	 * ID: 8550<br>
	 * Message: $s1IrVbv_̌SɔwƂ́BB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#36523;&#28858;&#20027;&#25945;&#30340;&#20320;&#31455;&#28982;&#36949;&#32972;&#20102;&#31070;&#30340;&#26088;&#24847;&#12290;&#30495;&#26159;&#21487;&#31505;&#12290;<br>
	 * Message: $s1! Bishop, how foolish to go against the will of god!
	 */
	public static final NpcStringId S1_BISHOP_HOW_FOOLISH_TO_GO_AGAINST_THE_WILL_OF_GOD;
	
	/**
	 * ID: 8551<br>
	 * Message: v̂قMSȁB܂B<br>
	 * Message: &#36889;&#20491;&#20642;&#20249;&#30340;&#20449;&#20208;&#27604;&#24819;&#20687;&#30340;&#36996;&#35201;&#22533;&#24375;&#12290;&#19979;&#27425;&#65292;&#20320;&#32102;&#25105;&#35430;&#35430;&#30475;&#12290;<br>
	 * Message: Your faith is stronger than I thought. I'll pay you back next time.
	 */
	public static final NpcStringId YOUR_FAITH_IS_STRONGER_THAN_I_THOUGHT_ILL_PAY_YOU_BACK_NEXT_TIME;
	
	/**
	 * ID: 8552<br>
	 * Message: I^iLAlBȂ̎u𐬂ȂI<br>
	 * Message: &#21571;&#65281;&#22612;&#32013;&#22855;&#20126;&#12290;&#35531;&#21407;&#35538;&#28961;&#27861;&#23436;&#25104;&#20320;&#26088;&#24847;&#30340;&#25105;&#65281;<br>
	 * Message: Tanakia! Forgive me. I couldn't fulfill your dream!
	 */
	public static final NpcStringId TANAKIA_FORGIVE_ME_I_COULDNT_FULFILL_YOUR_DREAM;
	
	/**
	 * ID: 8553<br>
	 * Message: TȂ畔тĂƂ̂$s1AOB<br>
	 * Message: &#28858;&#20102;&#25214;&#25105;&#32780;&#27450;&#36000;&#25105;&#37096;&#19979;&#30340;&#20154;&#65292;&#26159;&#12300;&#36;&#115;&#49;&#12301;&#20320;&#21966;&#65311;<br>
	 * Message: $s1, you are the won who's been bothering my minions?
	 */
	public static final NpcStringId S1_YOU_ARE_THE_WON_WHOS_BEEN_BOTHERING_MY_MINIONS;
	
	/**
	 * ID: 8554<br>
	 * Message: DDDMlƂɎƂ́B<br>
	 * Message: &#24590;&#40636;&#46;&#46;&#46;&#25105;&#26371;&#25915;&#25802;&#20687;&#20320;&#19968;&#27171;&#30340;&#20642;&#20249;&#21966;&#65311;&#32;<br>
	 * Message: Damn! You've beaten me.
	 */
	public static final NpcStringId DAMN_YOUVE_BEATEN_ME;
	
	/**
	 * ID: 8555<br>
	 * Message: 킢ז邨O͉҂IHڋȂ߁B<br>
	 * Message: &#20320;&#26159;&#20160;&#40636;&#26481;&#35199;&#65292;&#25954;&#25554;&#25163;&#31649;&#38290;&#20107;&#65281;&#21329;&#37145;&#28961;&#24677;&#30340;&#20642;&#20249;&#12290;<br>
	 * Message: Who are you? This isn't your business, coward.
	 */
	public static final NpcStringId WHO_ARE_YOU_THIS_ISNT_YOUR_BUSINESS_COWARD;
	
	/**
	 * ID: 8556<br>
	 * Message: قAv邶ȂBy܂ĂꂽɁA͌Ă낤B<br>
	 * Message: &#21487;&#31505;&#30340;&#20642;&#20249;&#65292;&#24819;&#19981;&#21040;&#36889;&#40636;&#26377;&#38860;&#24615;&#12290;&#20320;&#20196;&#25105;&#24863;&#21040;&#33288;&#22894;&#20102;&#65292;&#36889;&#27425;&#23601;&#21407;&#35538;&#20320;&#21543;&#12290;&#32;<br>
	 * Message: How weak. I'll forgive you this time because you made me laugh.
	 */
	public static final NpcStringId HOW_WEAK_ILL_FORGIVE_YOU_THIS_TIME_BECAUSE_YOU_MADE_ME_LAUGH;
	
	/**
	 * ID: 8557<br>
	 * Message: v苭łˁBAキ͂ȂłB<br>
	 * Message: &#24819;&#19981;&#21040;&#65292;&#20320;&#36889;&#40636;&#24375;&#12290;&#20294;&#26159;&#25105;&#20063;&#19981;&#24046;&#12290;&#32;<br>
	 * Message: You are stronger than I thought, but I'm no weakling!
	 */
	public static final NpcStringId YOU_ARE_STRONGER_THAN_I_THOUGHT_BUT_IM_NO_WEAKLING;
	
	/**
	 * ID: 8558<br>
	 * Message: 育킢łˁB$s1IƗ͂킹Ă̎҂|܂傤B<br>
	 * Message: &#26524;&#28982;&#19981;&#26159;&#20491;&#31777;&#21934;&#30340;&#23565;&#25163;&#12290;&#12300;&#36;&#115;&#49;&#12301;&#65281;&#21644;&#25105;&#19968;&#36215;&#21512;&#21147;&#38500;&#25481;&#37027;&#20491;&#20642;&#20249;&#21543;&#12290;<br>
	 * Message: He's got a tough shell. $s1! Let's fight together and crack his skull!
	 */
	public static final NpcStringId HES_GOT_A_TOUGH_SHELL_S1_LETS_FIGHT_TOGETHER_AND_CRACK_HIS_SKULL;
	
	/**
	 * ID: 8560<br>
	 * Message: $s1I{̗͂𔭊ȂƂ|܂II<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#19981;&#30332;&#25582;&#21407;&#20358;&#30340;&#23526;&#21147;&#65292;&#23601;&#28961;&#27861;&#25802;&#22446;&#37027;&#20491;&#20642;&#20249;&#12290;&#36245;&#24555;&#65281;<br>
	 * Message: $s1! We won't beat him unless we give it our all. Come on!
	 */
	public static final NpcStringId S1_WE_WONT_BEAT_HIM_UNLESS_WE_GIVE_IT_OUR_ALL_COME_ON;
	
	/**
	 * ID: 8561<br>
	 * Message: ł́A͂̎҂ɂčs܂B<br>
	 * Message: &#37027;&#40636;&#65292;&#25105;&#21435;&#36861;&#25802;&#37027;&#20491;&#20642;&#20249;&#12290;<br>
	 * Message: I'll follow him.
	 */
	public static final NpcStringId ILL_FOLLOW_HIM;
	
	/**
	 * ID: 8562<br>
	 * Message: ܂Bǂ̂͑ςB<br>
	 * Message: &#22833;&#21435;&#36889;&#27425;&#27231;&#26371;&#30340;&#35441;&#65292;&#35201;&#20877;&#36861;&#25429;&#20182;&#23601;&#38627;&#19978;&#21152;&#38627;&#12290;&#32;<br>
	 * Message: I missed again! He's hard to follow.
	 */
	public static final NpcStringId I_MISSED_AGAIN_HES_HARD_TO_FOLLOW;
	
	/**
	 * ID: 8563<br>
	 * Message: ł́A̎pɊ҂Ă܂B<br>
	 * Message: &#37027;&#40636;&#65292;&#26399;&#24453;&#26410;&#20358;&#30340;&#24773;&#26223;&#12290;<br>
	 * Message: We'll see what the future brings.
	 */
	public static final NpcStringId WELL_SEE_WHAT_THE_FUTURE_BRINGS;
	
	/**
	 * ID: 8564<br>
	 * Message: V[l̂߂ɁI<br>
	 * Message: &#28858;&#20102;&#24109;&#29747;&#65281;<br>
	 * Message: For Shilen!
	 */
	public static final NpcStringId FOR_SHILEN;
	
	/**
	 * ID: 8565<br>
	 * Message: ͖߂ĂB̎ɂ͊o傷邪B<br>
	 * Message: &#35201;&#20877;&#22238;&#20358;&#12290;&#21040;&#37027;&#20491;&#26178;&#20505;&#35201;&#35258;&#24735;&#12290;<br>
	 * Message: I'll be back. I'll deal with you then.
	 */
	public static final NpcStringId ILL_BE_BACK_ILL_DEAL_WITH_YOU_THEN;
	
	/**
	 * ID: 8566<br>
	 * Message: $s1I̎ɋt炤̂I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#22909;&#22823;&#30340;&#33213;&#23376;&#65292;&#31455;&#25954;&#21453;&#25239;&#25105;&#65281;<br>
	 * Message: $s1! Are you going to fight me?
	 */
	public static final NpcStringId S1_ARE_YOU_GOING_TO_FIGHT_ME;
	
	/**
	 * ID: 8567<br>
	 * Message: $s1IoĂBMl̂Ƃ͐ΖYȂB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#31561;&#33879;&#30631;&#65281;&#25105;&#32085;&#23565;&#19981;&#26371;&#24536;&#35352;&#20320;&#30340;&#12290;<br>
	 * Message: $s1! I'll pay you back. I won't forget you.
	 */
	public static final NpcStringId S1_ILL_PAY_YOU_BACK_I_WONT_FORGET_YOU;
	
	/**
	 * ID: 8650<br>
	 * Message: $s1IvtBbg_̌SɔwƂ́BB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#36523;&#28858;&#20808;&#30693;&#30340;&#20320;&#31455;&#28982;&#36949;&#32972;&#20102;&#31070;&#30340;&#26088;&#24847;&#12290;&#30495;&#26159;&#21487;&#31505;&#12290;<br>
	 * Message: $s1! Prophet, how foolish to go against the will of god!
	 */
	public static final NpcStringId S1_PROPHET_HOW_FOOLISH_TO_GO_AGAINST_THE_WILL_OF_GOD;
	
	/**
	 * ID: 8651<br>
	 * Message: v̂قMSȁB܂B<br>
	 * Message: &#36889;&#20491;&#20642;&#20249;&#30340;&#20449;&#20208;&#27604;&#24819;&#20687;&#30340;&#36996;&#35201;&#22533;&#24375;&#12290;&#19979;&#27425;&#65292;&#20320;&#32102;&#25105;&#35430;&#35430;&#30475;&#12290;<br>
	 * Message: Your faith is stronger than I thought. I'll deal with you next time.
	 */
	public static final NpcStringId YOUR_FAITH_IS_STRONGER_THAN_I_THOUGHT_ILL_DEAL_WITH_YOU_NEXT_TIME;
	
	/**
	 * ID: 8653<br>
	 * Message: TȂ畔тĂƂ̂$s1AOB<br>
	 * Message: &#28858;&#20102;&#25214;&#25105;&#32780;&#27450;&#36000;&#25105;&#37096;&#19979;&#30340;&#20154;&#65292;&#26159;&#12300;&#36;&#115;&#49;&#12301;&#20320;&#21966;&#65311;<br>
	 * Message: Are you the one who's been bothering my minions, $s1?
	 */
	public static final NpcStringId ARE_YOU_THE_ONE_WHOS_BEEN_BOTHERING_MY_MINIONS_S1;
	
	/**
	 * ID: 8654<br>
	 * Message: DDDMlƂɎƂ́B<br>
	 * Message: &#24590;&#40636;&#46;&#46;&#46;&#25105;&#26371;&#25915;&#25802;&#20687;&#20320;&#19968;&#27171;&#30340;&#20642;&#20249;&#21966;&#65311;&#32;<br>
	 * Message: Damn! I can't believe I've been beaten by you!
	 */
	public static final NpcStringId DAMN_I_CANT_BELIEVE_IVE_BEEN_BEATEN_BY_YOU;
	
	/**
	 * ID: 8655<br>
	 * Message: 킢ז邨O͉҂IHڋȂ߁B<br>
	 * Message: &#20320;&#26159;&#20160;&#40636;&#26481;&#35199;&#65292;&#25954;&#25554;&#25163;&#31649;&#38290;&#20107;&#65281;&#21329;&#37145;&#28961;&#24677;&#30340;&#20642;&#20249;&#12290;<br>
	 * Message: Who are you? This is none of your business, coward.
	 */
	public static final NpcStringId WHO_ARE_YOU_THIS_IS_NONE_OF_YOUR_BUSINESS_COWARD;
	
	/**
	 * ID: 8657<br>
	 * Message: ̗͂ŁAɂ͂тłނ邾낤B<br>
	 * Message: &#29992;&#20809;&#30340;&#21147;&#37327;&#20358;&#25475;&#38500;&#31840;&#32617;&#22312;&#25972;&#20491;&#19990;&#30028;&#30340;&#40657;&#26263;&#12290;<br>
	 * Message: I'll destroy the darkness surrounding the world with the power of light!
	 */
	public static final NpcStringId ILL_DESTROY_THE_DARKNESS_SURROUNDING_THE_WORLD_WITH_THE_POWER_OF_LIGHT;
	
	/**
	 * ID: 8658<br>
	 * Message: $s1Iƈꏏɂ̑҂|āA^Ȃ̗͂Ă܂傤B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#21644;&#25105;&#19968;&#36215;&#38500;&#25481;&#37027;&#20491;&#22702;&#33853;&#32773;&#65292;&#35731;&#20182;&#30631;&#30631;&#30495;&#23526;&#20043;&#20809;&#30340;&#23041;&#21147;&#21543;&#12290;<br>
	 * Message: $s1! Fight the Fallen Angel with me. Show the true power of light!
	 */
	public static final NpcStringId S1_FIGHT_THE_FALLEN_ANGEL_WITH_ME_SHOW_THE_TRUE_POWER_OF_LIGHT;
	
	/**
	 * ID: 8659<br>
	 * Message: $s1IĂB̐킢͂ŏI点ȂĂ͂Ȃ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#21029;&#20572;&#12290;&#36889;&#22580;&#25136;&#39717;&#35201;&#22312;&#36889;&#35041;&#32080;&#26463;&#12290;<br>
	 * Message: $s1! Go! We must stop fighting here.
	 */
	public static final NpcStringId S1_GO_WE_MUST_STOP_FIGHTING_HERE;
	
	/**
	 * ID: 8660<br>
	 * Message: $s1I͐ΕȂ̂łBH΂Đ키̂łB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#25105;&#20497;&#32085;&#23565;&#19981;&#33021;&#22833;&#25943;&#12290;&#21676;&#32202;&#29273;&#26681;&#65292;&#20877;&#21152;&#25226;&#21185;&#12290;<br>
	 * Message: We mustn't lose, $s1! Pull yourself together!
	 */
	public static final NpcStringId WE_MUSTNT_LOSE_S1_PULL_YOURSELF_TOGETHER;
	
	/**
	 * ID: 8661<br>
	 * Message: ł́A΂܂܂傤B<br>
	 * Message: &#37027;&#40636;&#65292;&#26377;&#32227;&#30340;&#35441;&#65292;&#32317;&#26377;&#19968;&#22825;&#26371;&#20877;&#35211;&#38754;&#30340;&#12290;<br>
	 * Message: We'll meet again if fate wills it.
	 */
	public static final NpcStringId WELL_MEET_AGAIN_IF_FATE_WILLS_IT;
	
	/**
	 * ID: 8662<br>
	 * Message: ڋȈ̌ǂ܂B<br>
	 * Message: &#35201;&#21435;&#36861;&#25802;&#37027;&#20301;&#36305;&#25481;&#30340;&#21329;&#37145;&#24801;&#39764;&#12290;<br>
	 * Message: I'll follow the cowardly devil.
	 */
	public static final NpcStringId ILL_FOLLOW_THE_COWARDLY_DEVIL;
	
	/**
	 * ID: 8750<br>
	 * Message: $s1IG_[_̌SɔwƂ́BB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#36523;&#28858;&#38263;&#32769;&#30340;&#20320;&#31455;&#28982;&#36949;&#32972;&#20102;&#31070;&#30340;&#26088;&#24847;&#12290;&#30495;&#26159;&#21487;&#31505;&#12290;<br>
	 * Message: $s1! Elder, it's foolish of you to go against the will of the gods.
	 */
	public static final NpcStringId S1_ELDER_ITS_FOOLISH_OF_YOU_TO_GO_AGAINST_THE_WILL_OF_THE_GODS;
	
	/**
	 * ID: 8757<br>
	 * Message: v苭łˁBAキ͂ȂłB<br>
	 * Message: &#24819;&#19981;&#21040;&#65292;&#20320;&#36889;&#40636;&#24375;&#12290;&#20294;&#26159;&#25105;&#20063;&#19981;&#24046;&#12290;&#32;<br>
	 * Message: You're stronger than I thought, but I'm no weakling either!
	 */
	public static final NpcStringId YOURE_STRONGER_THAN_I_THOUGHT_BUT_IM_NO_WEAKLING_EITHER;
	
	/**
	 * ID: 8760<br>
	 * Message: $s1I{̗͂𔭊ȂƂ|܂II<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#19981;&#30332;&#25582;&#21407;&#20358;&#30340;&#23526;&#21147;&#65292;&#23601;&#28961;&#27861;&#25802;&#22446;&#37027;&#20491;&#20642;&#20249;&#12290;&#36245;&#24555;&#65281;<br>
	 * Message: $s1! We'll never win unless we give it our all. Come on!
	 */
	public static final NpcStringId S1_WELL_NEVER_WIN_UNLESS_WE_GIVE_IT_OUR_ALL_COME_ON;
	
	/**
	 * ID: 8850<br>
	 * Message: Ml$s1HtbA΂͎Ă邼I<br>
	 * Message: &#20320;&#23601;&#26159;&#12300;&#36;&#115;&#49;&#12301;&#65311;&#21756;&#65292;&#20132;&#24863;&#30707;&#22312;&#25105;&#30340;&#25163;&#19978;&#65281;<br>
	 * Message: Are you $s1? Oh! I have the Resonance Amulet!
	 */
	public static final NpcStringId ARE_YOU_S1_OH_I_HAVE_THE_RESONANCE_AMULET;
	
	/**
	 * ID: 8851<br>
	 * Message: Av肵ԂƂȁB͂̕ӂŌĂ낤B<br>
	 * Message: &#22038;&#12290;&#27794;&#24819;&#21040;&#65292;&#36889;&#40636;&#26377;&#38860;&#24615;&#12290;&#36889;&#27425;&#65292;&#23601;&#21040;&#27492;&#28858;&#27490;&#21543;&#12290;<br>
	 * Message: You're feistier than I thought! I'll quit here for today.
	 */
	public static final NpcStringId YOURE_FEISTIER_THAN_I_THOUGHT_ILL_QUIT_HERE_FOR_TODAY;
	
	/**
	 * ID: 8852<br>
	 * Message: DDD̎Ƃ́DDD<br>
	 * Message: &#21917;&#21834;&#46;&#46;&#46;&#25105;&#25915;&#25802;&#46;&#46;&#46;<br>
	 * Message: Aaargh! I can't believe I lost...
	 */
	public static final NpcStringId AAARGH_I_CANT_BELIEVE_I_LOST;
	
	/**
	 * ID: 8854<br>
	 * Message: ADDD<br>
	 * Message: &#24456;&#21426;&#23475;&#46;&#46;&#46;&#21621;&#21621;<br>
	 * Message: Yikes! You're tough!
	 */
	public static final NpcStringId YIKES_YOURE_TOUGH;
	
	/**
	 * ID: 8855<br>
	 * Message: Ȃ킢̎ז̂DDD<br>
	 * Message: &#20320;&#28858;&#20309;&#35201;&#24178;&#28041;&#21029;&#20154;&#30340;&#25171;&#39717;&#46;&#46;&#46;<br>
	 * Message: Why do you interfere in other people's business...
	 */
	public static final NpcStringId WHY_DO_YOU_INTERFERE_IN_OTHER_PEOPLES_BUSINESS;
	
	/**
	 * ID: 8856<br>
	 * Message: ͂̕ӂňƂ悤B<br>
	 * Message: &#36889;&#27425;&#23601;&#21040;&#27492;&#28858;&#27492;&#21543;&#65292;&#25764;&#36864;&#21543;&#12290;<br>
	 * Message: I'll stop here for today.
	 */
	public static final NpcStringId ILL_STOP_HERE_FOR_TODAY;
	
	/**
	 * ID: 8857<br>
	 * Message: xȂI<br>
	 * Message: &#36889;&#27425;&#21029;&#20877;&#37679;&#36942;&#20102;&#65281;<br>
	 * Message: I won't miss you this time!
	 */
	public static final NpcStringId I_WONT_MISS_YOU_THIS_TIME;
	
	/**
	 * ID: 8858<br>
	 * Message: DDD͂1lł͖DDD$s1I`ĂI<br>
	 * Message: &#31967;&#31957;&#65292;&#25105;&#19968;&#20491;&#20154;&#26524;&#28982;&#36996;&#26159;&#24456;&#21507;&#21147;&#46;&#46;&#46;&#12300;&#36;&#115;&#49;&#12301;&#65281;&#35531;&#24171;&#24171;&#25105;&#21543;&#65281;<br>
	 * Message: Dammit! This is too hard by myself... $s1! Give me a hand!
	 */
	public static final NpcStringId DAMMIT_THIS_IS_TOO_HARD_BY_MYSELF_S1_GIVE_ME_A_HAND;
	
	/**
	 * ID: 8859<br>
	 * Message: $s1I}Â܂܂ᓦĂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#36245;&#24555;&#12290;&#20877;&#36889;&#27171;&#19979;&#21435;&#30340;&#35441;&#65292;&#23601;&#26371;&#35731;&#20182;&#36305;&#20102;&#12290;<br>
	 * Message: $s1! Hurry up, we'll miss him.
	 */
	public static final NpcStringId S1_HURRY_UP_WELL_MISS_HIM;
	
	/**
	 * ID: 8860<br>
	 * Message: $s1I}łB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#36245;&#24555;&#12290;<br>
	 * Message: $s1! Come on. Hurry up!
	 */
	public static final NpcStringId S1_COME_ON_HURRY_UP;
	
	/**
	 * ID: 8861<br>
	 * Message: ɂĎB͂ǂ˂΂ȂʁB<br>
	 * Message: &#21040;&#27492;&#28858;&#27490;&#12290;&#25105;&#35201;&#32380;&#32396;&#36861;&#25802;&#37027;&#20491;&#20642;&#20249;&#12290;<br>
	 * Message: I gotta' go follow him.
	 */
	public static final NpcStringId I_GOTTA_GO_FOLLOW_HIM;
	
	/**
	 * ID: 8862<br>
	 * Message: A悤Ă̂B҂āI<br>
	 * Message: &#22038;&#12290;&#24819;&#35201;&#36867;&#36305;&#21966;&#65311;&#31449;&#20303;&#65281;<br>
	 * Message: Hey, quit running! Stop!
	 */
	public static final NpcStringId HEY_QUIT_RUNNING_STOP;
	
	/**
	 * ID: 8863<br>
	 * Message: ꂶA܂ˁ`<br>
	 * Message: &#37027;&#40636;&#19979;&#27425;&#20877;&#35211;&#12290;<br>
	 * Message: See you next time~
	 */
	public static final NpcStringId SEE_YOU_NEXT_TIME;
	
	/**
	 * ID: 8864<br>
	 * Message: HMlƂhƎv̂B<br>
	 * Message: &#20160;&#40636;&#65292;&#20687;&#20320;&#36889;&#27171;&#30340;&#35282;&#33394;&#65292;&#33021;&#25803;&#20303;&#25105;&#21966;&#65311;<br>
	 * Message: What? Think you can get in my way?
	 */
	public static final NpcStringId WHAT_THINK_YOU_CAN_GET_IN_MY_WAY;
	
	/**
	 * ID: 8865<br>
	 * Message: ӂAȁBႠȁDDD<br>
	 * Message: &#21710;&#21568;&#65292;&#21147;&#37327;&#35722;&#24369;&#20102;&#12290;&#37027;&#40636;&#25105;&#23601;&#46;&#46;&#46;&#32;<br>
	 * Message: You are so weak. I gotta' go now!
	 */
	public static final NpcStringId YOU_ARE_SO_WEAK_I_GOTTA_GO_NOW;
	
	/**
	 * ID: 8866<br>
	 * Message: ށHMl$s1IxAꏏɎnĂB<br>
	 * Message: &#21670;&#65311;&#12300;&#36;&#115;&#49;&#12301;&#20320;&#36889;&#20491;&#20642;&#20249;&#65281;&#20358;&#24471;&#27491;&#22909;&#65292;&#19968;&#36215;&#25915;&#25802;&#21543;&#12290;<br>
	 * Message: $s1! Good. I'll help you.
	 */
	public static final NpcStringId S1_GOOD_ILL_HELP_YOU;
	
	/**
	 * ID: 8867<br>
	 * Message: $s1AƌȁBv苭ȁB܂B<br>
	 * Message: &#20320;&#21483;&#12300;&#36;&#115;&#49;&#12301;&#26159;&#21966;&#65311;&#27794;&#24819;&#21040;&#20320;&#36889;&#40636;&#24375;&#24717;&#12290;&#24460;&#26371;&#26377;&#26399;&#12290;<br>
	 * Message: $s1, you're stronger than I thought. See you next time.
	 */
	public static final NpcStringId S1_YOURE_STRONGER_THAN_I_THOUGHT_SEE_YOU_NEXT_TIME;
	
	/**
	 * ID: 8951<br>
	 * Message: Av肵ԂƂȁB͂̕ӂŌĂ낤B<br>
	 * Message: &#22038;&#12290;&#27794;&#24819;&#21040;&#65292;&#36889;&#40636;&#26377;&#38860;&#24615;&#12290;&#36889;&#27425;&#65292;&#23601;&#21040;&#27492;&#28858;&#27490;&#21543;&#12290;<br>
	 * Message: You're feistier than I thought! I'll stop here today.
	 */
	public static final NpcStringId YOURE_FEISTIER_THAN_I_THOUGHT_ILL_STOP_HERE_TODAY;
	
	/**
	 * ID: 8952<br>
	 * Message: DDD̎Ƃ́DDD<br>
	 * Message: &#21917;&#21834;&#46;&#46;&#46;&#25105;&#25915;&#25802;&#46;&#46;&#46;<br>
	 * Message: Aargh! I can't believe I lost...
	 */
	public static final NpcStringId AARGH_I_CANT_BELIEVE_I_LOST;
	
	/**
	 * ID: 8956<br>
	 * Message: ͂̕ӂňƂ悤B<br>
	 * Message: &#36889;&#27425;&#23601;&#21040;&#27492;&#28858;&#27492;&#21543;&#65292;&#25764;&#36864;&#21543;&#12290;<br>
	 * Message: I'll stop here today.
	 */
	public static final NpcStringId ILL_STOP_HERE_TODAY;
	
	/**
	 * ID: 8958<br>
	 * Message: DDD͂1lł͖DDD$s1I`ĂI<br>
	 * Message: &#22038;&#65292;&#25105;&#19968;&#20491;&#20154;&#26524;&#28982;&#36996;&#26159;&#24456;&#21507;&#21147;&#46;&#46;&#46;&#12300;&#36;&#115;&#49;&#12301;&#65281;&#24171;&#24171;&#25105;&#21543;&#65281;<br>
	 * Message: Damn! It's too much by myself...$s1! Give me a hand!
	 */
	public static final NpcStringId DAMN_ITS_TOO_MUCH_BY_MYSELFS1_GIVE_ME_A_HAND;
	
	/**
	 * ID: 8959<br>
	 * Message: $s1I}Â܂܂ᓦĂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#36245;&#24555;&#12290;&#20877;&#36889;&#27171;&#19979;&#21435;&#30340;&#35441;&#65292;&#23601;&#26371;&#35731;&#20182;&#36305;&#20102;&#12290;<br>
	 * Message: $s1! Hurry, we'll miss him.
	 */
	public static final NpcStringId S1_HURRY_WELL_MISS_HIM;
	
	/**
	 * ID: 8960<br>
	 * Message: $s1I}łB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#36245;&#24555;&#12290;<br>
	 * Message: $s1! Hurry, please!
	 */
	public static final NpcStringId S1_HURRY_PLEASE;
	
	/**
	 * ID: 8961<br>
	 * Message: ɂĎB͂ǂ˂΂ȂʁB<br>
	 * Message: &#21040;&#27492;&#28858;&#27490;&#12290;&#25105;&#35201;&#32380;&#32396;&#36861;&#25802;&#37027;&#20491;&#20642;&#20249;&#12290;<br>
	 * Message: I gotta' go follow him now.
	 */
	public static final NpcStringId I_GOTTA_GO_FOLLOW_HIM_NOW;
	
	/**
	 * ID: 8962<br>
	 * Message: A悤Ă̂B҂āI<br>
	 * Message: &#22038;&#12290;&#24819;&#36867;&#36305;&#21834;&#12290;&#31449;&#20303;&#65281;<br>
	 * Message: Are you running away? Stop!
	 */
	public static final NpcStringId ARE_YOU_RUNNING_AWAY_STOP;
	
	/**
	 * ID: 8964<br>
	 * Message: HMlƂhƎv̂B<br>
	 * Message: &#20160;&#40636;&#65292;&#20687;&#20320;&#36889;&#27171;&#30340;&#35282;&#33394;&#65292;&#33021;&#25803;&#20303;&#25105;&#21966;&#65311;<br>
	 * Message: Do you think you can stop me?
	 */
	public static final NpcStringId DO_YOU_THINK_YOU_CAN_STOP_ME;
	
	/**
	 * ID: 8965<br>
	 * Message: ӂAȁBႠȁDDD<br>
	 * Message: &#21710;&#21568;&#65292;&#21147;&#37327;&#35722;&#24369;&#20102;&#12290;&#37027;&#40636;&#25105;&#23601;&#46;&#46;&#46;&#32;<br>
	 * Message: You're so weak. I gotta' go now...
	 */
	public static final NpcStringId YOURE_SO_WEAK_I_GOTTA_GO_NOW;
	
	/**
	 * ID: 8966<br>
	 * Message: ށHMl$s1IxAꏏɎnĂB<br>
	 * Message: &#21670;&#65311;&#12300;&#36;&#115;&#49;&#12301;&#20320;&#36889;&#20491;&#20642;&#20249;&#65281;&#20358;&#24471;&#27491;&#22909;&#65292;&#19968;&#36215;&#25915;&#25802;&#21543;&#12290;<br>
	 * Message: You're $s1! Good. I'll help you.
	 */
	public static final NpcStringId YOURE_S1_GOOD_ILL_HELP_YOU;
	
	/**
	 * ID: 9050<br>
	 * Message: Ml$s1HtbA΂͎Ă邼I<br>
	 * Message: &#20320;&#23601;&#26159;&#12300;&#36;&#115;&#49;&#12301;&#65311;&#21756;&#65292;&#20132;&#24863;&#30707;&#22312;&#25105;&#30340;&#25163;&#19978;&#65281;<br>
	 * Message: Are you $s1? Oh! I have a Resonance Amulet!
	 */
	public static final NpcStringId ARE_YOU_S1_OH_I_HAVE_A_RESONANCE_AMULET;
	
	/**
	 * ID: 9051<br>
	 * Message: Av肵ԂƂȁB͂̕ӂŌĂ낤B<br>
	 * Message: &#22038;&#12290;&#27794;&#24819;&#21040;&#65292;&#36889;&#40636;&#26377;&#38860;&#24615;&#12290;&#36889;&#27425;&#65292;&#23601;&#21040;&#27492;&#28858;&#27490;&#21543;&#12290;<br>
	 * Message: Hey, you're more tenacious than I thought! I'll stop here today.
	 */
	public static final NpcStringId HEY_YOURE_MORE_TENACIOUS_THAN_I_THOUGHT_ILL_STOP_HERE_TODAY;
	
	/**
	 * ID: 9058<br>
	 * Message: DDD͂1lł͖DDD$s1I`ĂI<br>
	 * Message: &#31967;&#31957;&#65292;&#25105;&#19968;&#20491;&#20154;&#26524;&#28982;&#36996;&#26159;&#24456;&#21507;&#21147;&#46;&#46;&#46;&#12300;&#36;&#115;&#49;&#12301;&#65281;&#35531;&#24171;&#24171;&#25105;&#21543;&#65281;<br>
	 * Message: Dammit! I can't do this alone, $s1! Give me a hand!
	 */
	public static final NpcStringId DAMMIT_I_CANT_DO_THIS_ALONE_S1_GIVE_ME_A_HAND;
	
	/**
	 * ID: 9059<br>
	 * Message: $s1I}Â܂܂ᓦĂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#36245;&#24555;&#12290;&#20877;&#36889;&#27171;&#19979;&#21435;&#30340;&#35441;&#65292;&#23601;&#26371;&#35731;&#20182;&#36305;&#20102;&#12290;<br>
	 * Message: $s1! Hurry or we'll miss him.
	 */
	public static final NpcStringId S1_HURRY_OR_WELL_MISS_HIM;
	
	/**
	 * ID: 9060<br>
	 * Message: $s1I}łB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#36245;&#24555;&#12290;<br>
	 * Message: $s1! Hurry up!
	 */
	public static final NpcStringId S1_HURRY_UP;
	
	/**
	 * ID: 9061<br>
	 * Message: ɂĎB͂ǂ˂΂ȂʁB<br>
	 * Message: &#21040;&#27492;&#28858;&#27490;&#12290;&#25105;&#35201;&#32380;&#32396;&#36861;&#25802;&#37027;&#20491;&#20642;&#20249;&#12290;<br>
	 * Message: I gotta' follow him now.
	 */
	public static final NpcStringId I_GOTTA_FOLLOW_HIM_NOW;
	
	/**
	 * ID: 9062<br>
	 * Message: A悤Ă̂B҂āI<br>
	 * Message: &#22038;&#12290;&#24819;&#35201;&#36867;&#36305;&#21966;&#65311;&#31449;&#20303;&#65281;<br>
	 * Message: Hey, are you running? Stop!
	 */
	public static final NpcStringId HEY_ARE_YOU_RUNNING_STOP;
	
	/**
	 * ID: 9066<br>
	 * Message: ށHMl$s1IxAꏏɎnĂB<br>
	 * Message: &#21670;&#65311;&#12300;&#36;&#115;&#49;&#12301;&#20320;&#36889;&#20491;&#20642;&#20249;&#65281;&#20358;&#24471;&#27491;&#22909;&#65292;&#19968;&#36215;&#25915;&#25802;&#21543;&#12290;<br>
	 * Message: Oh! You're $s1! Good. I'll help you.
	 */
	public static final NpcStringId OH_YOURE_S1_GOOD_ILL_HELP_YOU;
	
	/**
	 * ID: 9150<br>
	 * Message: NŶ悤ȐǂƌҁA$s1IOɐȂmbɂ鎑i͂ȂI<br>
	 * Message: &#33287;&#31895;&#37326;&#30340;&#31934;&#38728;&#20132;&#27969;&#30340;&#20154;&#65292;&#12300;&#36;&#115;&#49;&#12301;&#65281;&#20320;&#27794;&#26377;&#36039;&#26684;&#24471;&#21040;&#31070;&#32854;&#30340;&#26234;&#24935;&#65281;<br>
	 * Message: You carouse with evil spirits, $s1! You're not worthy of the holy wisdom!
	 */
	public static final NpcStringId YOU_CAROUSE_WITH_EVIL_SPIRITS_S1_YOURE_NOT_WORTHY_OF_THE_HOLY_WISDOM;
	
	/**
	 * ID: 9151<br>
	 * Message: Ӓn̂ĂIȏ㎕ĂʂI<br>
	 * Message: &#21029;&#20877;&#22266;&#22519;&#20102;&#65281;&#20877;&#24590;&#40636;&#25269;&#25239;&#37117;&#26159;&#27794;&#26377;&#29992;&#30340;&#65281;<br>
	 * Message: You're so stubborn! I can't boss you around any more, can I?
	 */
	public static final NpcStringId YOURE_SO_STUBBORN_I_CANT_BOSS_YOU_AROUND_ANY_MORE_CAN_I;
	
	/**
	 * ID: 9152<br>
	 * Message: ܁A܂Iq[}ƂɂƂ́IH<br>
	 * Message: &#31449;&#20303;&#65292;&#38627;&#36947;&#46;&#46;&#46;&#65281;&#36973;&#21463;&#20687;&#20154;&#39006;&#36889;&#27171;&#30340;&#20642;&#20249;&#46;&#46;&#46;&#65311;<br>
	 * Message: How could it happen? Defeated by a Human!
	 */
	public static final NpcStringId HOW_COULD_IT_HAPPEN_DEFEATED_BY_A_HUMAN;
	
	/**
	 * ID: 9157<br>
	 * Message: ll̋ɏ]ĂɂILbg̖_qāAȂ܂ɂI<br>
	 * Message: &#20027;&#20154;&#27966;&#25105;&#20358;&#30340;&#65281;&#25105;&#20197;&#35987;&#26063;&#30340;&#21517;&#35709;&#20358;&#24171;&#21161;&#20320;&#65281;<br>
	 * Message: My master sent me here! I'll give you a hand.
	 */
	public static final NpcStringId MY_MASTER_SENT_ME_HERE_ILL_GIVE_YOU_A_HAND;
	
	/**
	 * ID: 9158<br>
	 * Message: ɂႠI$s1`AĂI<br>
	 * Message: &#21941;&#126;&#65281;&#12300;&#36;&#115;&#49;&#12301;&#65292;&#35531;&#24171;&#24171;&#24537;&#65281;<br>
	 * Message: Meow~! Master $s1, help me!
	 */
	public static final NpcStringId MEOW_MASTER_S1_HELP_ME;
	
	/**
	 * ID: 9159<br>
	 * Message: $s1Ix_߂Ȃ悤ɒ炵߂ɂI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#35531;&#25945;&#35347;&#36889;&#20491;&#20642;&#20249;&#65292;&#35731;&#20182;&#19981;&#35201;&#20877;&#25214;&#34003;&#29747;&#36948;&#30340;&#40635;&#29033;&#65281;<br>
	 * Message: Master $s1. Punish him so he can't bother Belinda!
	 */
	public static final NpcStringId MASTER_S1_PUNISH_HIM_SO_HE_CANT_BOTHER_BELINDA;
	
	/**
	 * ID: 9160<br>
	 * Message: $s1Î܂܂ᓦꂿႤɂI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#20877;&#36889;&#27171;&#19979;&#21435;&#30340;&#35441;&#65292;&#23601;&#26371;&#35731;&#20182;&#36305;&#20102;&#21941;&#65281;<br>
	 * Message: Master $s1, We'll miss him!
	 */
	public static final NpcStringId MASTER_S1_WELL_MISS_HIM;
	
	/**
	 * ID: 9161<br>
	 * Message: ɂႠ`IllĂłɂIoCoCI<br>
	 * Message: &#21941;&#65281;&#20027;&#20154;&#21483;&#25105;&#21966;&#65281;&#21040;&#27492;&#28858;&#27490;&#126;&#65281;<br>
	 * Message: Meow~! My master is calling. Meow! I gotta' go now~!
	 */
	public static final NpcStringId MEOW_MY_MASTER_IS_CALLING_MEOW_I_GOTTA_GO_NOW;
	
	/**
	 * ID: 9162<br>
	 * Message: ɂႤIĂ܂ɂI<br>
	 * Message: &#21941;&#65281;&#37679;&#36942;&#20102;&#65281;<br>
	 * Message: Meow~! I missed him. Meow!
	 */
	public static final NpcStringId MEOW_I_MISSED_HIM_MEOW;
	
	/**
	 * ID: 9163<br>
	 * Message: K^F܂ɂIꂶ܂I<br>
	 * Message: &#25105;&#36996;&#31048;&#27714;&#24118;&#20358;&#22909;&#36939;&#126;&#65281;&#21040;&#27492;&#28858;&#27490;&#126;&#65281;<br>
	 * Message: Good luck! Meow~! I gotta' go now.
	 */
	public static final NpcStringId GOOD_LUCK_MEOW_I_GOTTA_GO_NOW;
	
	/**
	 * ID: 9164<br>
	 * Message: O͂낢m肷Blł炨I<br>
	 * Message: &#22909;&#22855;&#24515;&#26371;&#27578;&#27515;&#19968;&#38587;&#35987;&#65311;&#40664;&#40664;&#22320;&#27515;&#21435;&#21543;&#65281;<br>
	 * Message: Curiosity killed the cat? I'll show you!
	 */
	public static final NpcStringId CURIOSITY_KILLED_THE_CAT_ILL_SHOW_YOU;
	
	/**
	 * ID: 9165<br>
	 * Message: {͂܂ŁI<br>
	 * Message: &#20170;&#22825;&#30340;&#26371;&#38754;&#23601;&#21040;&#27492;&#28858;&#27490;&#46;&#46;&#46;&#65281;<br>
	 * Message: That's all for today...!
	 */
	public static final NpcStringId THATS_ALL_FOR_TODAY;
	
	/**
	 * ID: 9166<br>
	 * Message: x_DƂĂ̂͋MlA$s1H˂I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#26159;&#20320;&#35201;&#22890;&#36208;&#34003;&#29747;&#36948;&#30340;&#21966;&#65311;&#21435;&#27515;&#21543;&#65281;<br>
	 * Message: Are you trying to take Belinda from me, $s1? I'll show you!
	 */
	public static final NpcStringId ARE_YOU_TRYING_TO_TAKE_BELINDA_FROM_ME_S1_ILL_SHOW_YOU;
	
	/**
	 * ID: 9167<br>
	 * Message: xAx_INĂIOtbI<br>
	 * Message: &#35997;&#12289;&#34003;&#29747;&#36948;&#65281;&#24859;&#20320;&#46;&#46;&#46;&#65281;&#21571;&#65281;<br>
	 * Message: Belinda! I love you! Yikes!!!
	 */
	public static final NpcStringId BELINDA_I_LOVE_YOU_YIKES;
	
	/**
	 * ID: 9251<br>
	 * Message: Ӓn̂ĂIȏ㎕ĂʂI<br>
	 * Message: &#21029;&#20877;&#22266;&#22519;&#20102;&#65281;&#20877;&#24590;&#40636;&#23565;&#25239;&#37117;&#26159;&#27794;&#26377;&#29992;&#30340;&#65281;<br>
	 * Message: You're stubborn as a mule! Guess I can't boss you around any more!
	 */
	public static final NpcStringId YOURE_STUBBORN_AS_A_MULE_GUESS_I_CANT_BOSS_YOU_AROUND_ANY_MORE;
	
	/**
	 * ID: 9252<br>
	 * Message: ܁A܂IGtƂɂƂ́IH<br>
	 * Message: &#31449;&#20303;&#65292;&#38627;&#36947;&#46;&#46;&#46;&#65281;&#36973;&#21463;&#21040;&#20687;&#20154;&#39006;&#36889;&#27171;&#30340;&#20642;&#20249;&#46;&#46;&#46;&#65311;<br>
	 * Message: How could it be?...Defeated by an Elf!
	 */
	public static final NpcStringId HOW_COULD_IT_BEDEFEATED_BY_AN_ELF;
	
	/**
	 * ID: 9257<br>
	 * Message: fBXl Ō vOɂ Ȃ ` ܂B<br>
	 * Message: &#22857;&#65295;&#25289;&#24093;&#26031;&#65295;&#26368;&#24460;&#30340;&#24847;&#26088;&#65295;&#20358;&#21332;&#21161;&#20320;&#65295;<br>
	 * Message: I came to help you. It's the will of Radyss.
	 */
	public static final NpcStringId I_CAME_TO_HELP_YOU_ITS_THE_WILL_OF_RADYSS;
	
	/**
	 * ID: 9258<br>
	 * Message: $s1 Ȃ ͂ ݂ B<br>
	 * Message: &#47;&#12300;&#36;&#115;&#49;&#12301;&#21834;&#47;&#35531;&#47;&#36060;&#32102;&#25105;&#47;&#24744;&#30340;&#47;&#21147;&#37327;&#47;<br>
	 * Message: $s1! Fight with me!
	 */
	public static final NpcStringId S1_FIGHT_WITH_ME;
	
	/**
	 * ID: 9259<br>
	 * Message: $s1  K |ȂĂ Ȃ܂B<br>
	 * Message: &#47;&#12300;&#36;&#115;&#49;&#12301;&#21834;&#47;&#19968;&#23450;&#47;&#35201;&#38500;&#25481;&#47;&#37027;&#20491;&#47;&#20642;&#20249;&#47;<br>
	 * Message: $s1! We must defeat him!
	 */
	public static final NpcStringId S1_WE_MUST_DEFEAT_HIM;
	
	/**
	 * ID: 9260<br>
	 * Message: $s1 Ԃ ܂   |ȂẮB<br>
	 * Message: &#47;&#12300;&#36;&#115;&#49;&#12301;&#21834;&#47;&#27794;&#47;&#26178;&#38291;&#20102;&#47;&#36245;&#24555;&#47;&#35201;&#38500;&#25481;&#47;&#37027;&#20491;&#47;&#20642;&#20249;&#47;<br>
	 * Message: $s1. There's no time. We must defeat him!
	 */
	public static final NpcStringId S1_THERES_NO_TIME_WE_MUST_DEFEAT_HIM;
	
	/**
	 * ID: 9261<br>
	 * Message: fBXl  Ăł܂  sȂẮB<br>
	 * Message: &#65295;&#25289;&#24093;&#26031;&#21628;&#21914;&#65295;&#25105;&#65295;&#25105;&#65295;&#23601;&#65295;&#20808;&#36864;&#19979;&#65295;<br>
	 * Message: Radyss is calling me. I gotta' go now.
	 */
	public static final NpcStringId RADYSS_IS_CALLING_ME_I_GOTTA_GO_NOW;
	
	/**
	 * ID: 9262<br>
	 * Message:  w  Ƃ łȂB<br>
	 * Message: &#65295;&#21371;&#27794;&#26377;&#65295;&#24171;&#65295;&#21516;&#26063;&#65295;&#22577;&#20167;&#65295;<br>
	 * Message: I was unable to avenge my brother.
	 */
	public static final NpcStringId I_WAS_UNABLE_TO_AVENGE_MY_BROTHER;
	
	/**
	 * ID: 9263<br>
	 * Message:  ΂ j 񂱂ƂB<br>
	 * Message: &#65295;&#39000;&#65295;&#28246;&#27700;&#30340;&#31069;&#31119;&#65295;&#38477;&#33256;&#65295;&#21040;&#65295;&#20320;&#30340;&#36523;&#19978;&#12290;<br>
	 * Message: May you be blessed.
	 */
	public static final NpcStringId MAY_YOU_BE_BLESSED;
	
	/**
	 * ID: 9264<br>
	 * Message: 遖Ȏ҂A߂IȎ҂A邪IߐlAIāI<br>
	 * Message: &#39509;&#20658;&#30340;&#20154;&#65292;&#24724;&#25913;&#21543;&#65281;&#24858;&#34850;&#30340;&#20154;&#65292;&#35258;&#24735;&#21543;&#65281;&#32618;&#20154;&#21834;&#65292;&#30452;&#21040;&#27515;&#20043;&#21069;&#65292;&#36118;&#32618;&#21543;&#65281;&#65281;&#65281;<br>
	 * Message: The proud, repent! The foolish, awaken! Sinners, die!
	 */
	public static final NpcStringId THE_PROUD_REPENT_THE_FOOLISH_AWAKEN_SINNERS_DIE;
	
	/**
	 * ID: 9265<br>
	 * Message: ̐̎傪ĂтDDD܍߂͂܂xɂ悤DDD<br>
	 * Message: &#22320;&#29508;&#30340;&#20027;&#20154;&#20808;&#21484;&#21914;&#46;&#46;&#46;&#28982;&#24460;&#25165;&#33021;&#36118;&#32618;&#46;&#46;&#46;&#65281;<br>
	 * Message: Hell's master is calling. Atonement will have to wait!
	 */
	public static final NpcStringId HELLS_MASTER_IS_CALLING_ATONEMENT_WILL_HAVE_TO_WAIT;
	
	/**
	 * ID: 9266<br>
	 * Message: $s1AO̖Oًk̃XgɍڂĂĂI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#25105;&#26371;&#25226;&#20320;&#36889;&#20642;&#20249;&#30340;&#21517;&#23383;&#20063;&#21015;&#20837;&#30064;&#25945;&#24466;&#30340;&#21517;&#21934;&#20043;&#20839;&#65281;<br>
	 * Message: $s1, I'll remember your name, heathen.
	 */
	public static final NpcStringId S1_ILL_REMEMBER_YOUR_NAME_HEATHEN;
	
	/**
	 * ID: 9267<br>
	 * Message: ȂRɉʎҁA$s1I̖AYʂI<br>
	 * Message: &#25298;&#32085;&#25509;&#21463;&#31070;&#32854;&#23529;&#21028;&#30340;&#20154;&#65292;&#12300;&#36;&#115;&#49;&#12301;&#65281;&#25105;&#19981;&#26371;&#24536;&#35352;&#37027;&#20491;&#21517;&#23383;&#46;&#46;&#46;&#65281;<br>
	 * Message: I won't forget the name of one who doesn't obey holy judgment, $s1!
	 */
	public static final NpcStringId I_WONT_FORGET_THE_NAME_OF_ONE_WHO_DOESNT_OBEY_HOLY_JUDGMENT_S1;
	
	/**
	 * ID: 9351<br>
	 * Message: Ӓn̂ĂIȏ㎕ĂʂI<br>
	 * Message: &#21029;&#20877;&#22266;&#22519;&#20102;&#65281;&#20877;&#24590;&#40636;&#23565;&#25239;&#37117;&#26159;&#27794;&#26377;&#29992;&#30340;&#65281;<br>
	 * Message: You're stubborn as a mule! I guess I can't boss you around any more!
	 */
	public static final NpcStringId YOURE_STUBBORN_AS_A_MULE_I_GUESS_I_CANT_BOSS_YOU_AROUND_ANY_MORE;
	
	/**
	 * ID: 9352<br>
	 * Message: ܁A܂I_[N GtƂɂƂ́IH<br>
	 * Message: &#31449;&#20303;&#65292;&#38627;&#36947;&#46;&#46;&#46;&#65281;&#36973;&#21463;&#20687;&#40657;&#26263;&#31934;&#38728;&#36889;&#27171;&#30340;&#20154;&#27450;&#36000;&#65294;&#65294;&#65311;<br>
	 * Message: Could it be...? Defeated by a Dark Elf!
	 */
	public static final NpcStringId COULD_IT_BE_DEFEATED_BY_A_DARK_ELF;
	
	/**
	 * ID: 9357<br>
	 * Message: ȅtAɗB<br>
	 * Message: &#24433;&#20043;&#20803;&#32032;&#20351;&#23559;&#26371;&#20358;&#21332;&#21161;&#20320;&#30340;&#12290;<br>
	 * Message: Shadow Summoner, I came here to help you.
	 */
	public static final NpcStringId SHADOW_SUMMONER_I_CAME_HERE_TO_HELP_YOU;
	
	/**
	 * ID: 9358<br>
	 * Message: ȅtA$s1IȂ̗݂͂ĂB<br>
	 * Message: &#24433;&#20043;&#20803;&#32032;&#20351;&#65292;&#12300;&#36;&#115;&#49;&#12301;&#21834;&#65281;&#35531;&#36060;&#32102;&#25105;&#24744;&#30340;&#21147;&#37327;&#65281;<br>
	 * Message: Shadow Summoner, $s1! Fight with me!
	 */
	public static final NpcStringId SHADOW_SUMMONER_S1_FIGHT_WITH_ME;
	
	/**
	 * ID: 9359<br>
	 * Message: $s1A|Ȃ΂ȂI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#21834;&#65292;&#22914;&#26524;&#19981;&#36245;&#24555;&#38500;&#25481;&#37027;&#20491;&#20642;&#20249;&#30340;&#35441;&#65292;&#20320;&#23601;&#26371;&#21463;&#21040;&#20663;&#23475;&#65281;<br>
	 * Message: $s1, You'll die if you don't kill him!
	 */
	public static final NpcStringId S1_YOULL_DIE_IF_YOU_DONT_KILL_HIM;
	
	/**
	 * ID: 9360<br>
	 * Message: }̂A$s1I𓦂Ă͂Ȃ܂I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#21834;&#65281;&#36245;&#24555;&#65281;&#19981;&#33021;&#25918;&#36942;&#37027;&#20491;&#20642;&#20249;&#65281;<br>
	 * Message: Hurry, $s1! Don't miss him!
	 */
	public static final NpcStringId HURRY_S1_DONT_MISS_HIM;
	
	/**
	 * ID: 9361<br>
	 * Message: ȏ̂ۂƂ͖łDDD<br>
	 * Message: &#20877;&#20063;&#27794;&#36774;&#27861;&#32380;&#32396;&#32173;&#25345;&#23526;&#39636;&#20102;&#46;&#46;&#46;<br>
	 * Message: I can't hold on any longer...
	 */
	public static final NpcStringId I_CANT_HOLD_ON_ANY_LONGER;
	
	/**
	 * ID: 9362<br>
	 * Message: ǁDDDĂ܂DDD<br>
	 * Message: &#32080;&#26524;&#46;&#46;&#46;&#37679;&#36942;&#20102;&#46;&#46;&#46;<br>
	 * Message: After all that...I missed him...
	 */
	public static final NpcStringId AFTER_ALL_THATI_MISSED_HIM;
	
	/**
	 * ID: 9363<br>
	 * Message: ȅtIɐ[̏ĵ񂱂ƂI<br>
	 * Message: &#24433;&#20043;&#20803;&#32032;&#20351;&#65281;&#39000;&#28145;&#28023;&#30340;&#31069;&#31119;&#38477;&#33256;&#22312;&#20320;&#36523;&#19978;&#65281;<br>
	 * Message: Shadow summoner! May you be blessed!
	 */
	public static final NpcStringId SHADOW_SUMMONER_MAY_YOU_BE_BLESSED;
	
	/**
	 * ID: 9364<br>
	 * Message: ll̖ɂAȂɎ^ɗI<br>
	 * Message: &#22857;&#20027;&#20154;&#20043;&#21517;&#65292;&#21069;&#20358;&#36060;&#20320;&#27515;&#20129;&#65281;&#32;<br>
	 * Message: My master sent me here to kill you!
	 */
	public static final NpcStringId MY_MASTER_SENT_ME_HERE_TO_KILL_YOU;
	
	/**
	 * ID: 9365<br>
	 * Message: eĂłDDD<br>
	 * Message: &#24433;&#23376;&#21484;&#21914;&#33879;&#25105;&#46;&#46;&#46;<br>
	 * Message: The shadow is calling me...
	 */
	public static final NpcStringId THE_SHADOW_IS_CALLING_ME;
	
	/**
	 * ID: 9366<br>
	 * Message: $s1AɂȂ̂I]݂Ƃ΂łɑĂ낤I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#25105;&#20358;&#32034;&#20320;&#30340;&#21629;&#20102;&#65281;&#39340;&#19978;&#36865;&#20320;&#21435;&#22320;&#29508;&#65281;<br>
	 * Message: $s1, you want to die early? I'll send you to the darkness!
	 */
	public static final NpcStringId S1_YOU_WANT_TO_DIE_EARLY_ILL_SEND_YOU_TO_THE_DARKNESS;
	
	/**
	 * ID: 9367<br>
	 * Message: e𑀂ҁA$s1IȂ̖O͊oĂI<br>
	 * Message: &#34399;&#20196;&#38512;&#24433;&#32773;&#65292;&#12300;&#36;&#115;&#49;&#12301;&#21834;&#65281;&#25105;&#26371;&#35352;&#20303;&#20320;&#30340;&#21517;&#23383;&#65281;<br>
	 * Message: You deal in darkness, $s1! I'll pay you back.
	 */
	public static final NpcStringId YOU_DEAL_IN_DARKNESS_S1_ILL_PAY_YOU_BACK;
	
	/**
	 * ID: 9450<br>
	 * Message: MĺDDD$s1Hqf~bg̓̕ɂ͂Ȃ񂼁I<br>
	 * Message: &#20320;&#36889;&#20491;&#20642;&#20249;&#26159;&#46;&#46;&#46;&#12300;&#36;&#115;&#49;&#12301;&#65311;&#33287;&#38899;&#24503;&#31859;&#26031;&#37027;&#26178;&#30340;&#24773;&#27841;&#26159;&#19981;&#21516;&#30340;&#65281;<br>
	 * Message: You're $s1? I won't be like Hindemith!
	 */
	public static final NpcStringId YOURE_S1_I_WONT_BE_LIKE_HINDEMITH;
	
	/**
	 * ID: 9451<br>
	 * Message: Av肵ԂƂȁB͂̕ӂŌĂ낤B<br>
	 * Message: &#22038;&#12290;&#27794;&#24819;&#21040;&#65292;&#36889;&#40636;&#26377;&#38860;&#24615;&#12290;&#36889;&#27425;&#65292;&#23601;&#21040;&#27492;&#28858;&#27490;&#21543;&#12290;<br>
	 * Message: You're feistier than I thought! I'll stop here for today.
	 */
	public static final NpcStringId YOURE_FEISTIER_THAN_I_THOUGHT_ILL_STOP_HERE_FOR_TODAY;
	
	/**
	 * ID: 9453<br>
	 * Message: $s1Aߍ̕тĂ̂͂OB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#26368;&#36817;&#22312;&#27450;&#36000;&#25105;&#37096;&#19979;&#30340;&#20642;&#20249;&#65292;&#23601;&#26159;&#20320;&#21966;&#65311;<br>
	 * Message: Are you the one who is bothering my minions, $s1?
	 */
	public static final NpcStringId ARE_YOU_THE_ONE_WHO_IS_BOTHERING_MY_MINIONS_S1;
	
	/**
	 * ID: 9457<br>
	 * Message: Oɔ`̃^ubgƂ̌͂ʁI΂nI<br>
	 * Message: &#19981;&#35731;&#20320;&#21644;&#31061;&#20659;&#30340;&#30707;&#26495;&#20132;&#24863;&#65281;&#35531;&#20132;&#20986;&#20132;&#24863;&#30707;&#65281;<br>
	 * Message: I can't let you commune with Tablet of Vision! Give me the Resonance Amulet!
	 */
	public static final NpcStringId I_CANT_LET_YOU_COMMUNE_WITH_TABLET_OF_VISION_GIVE_ME_THE_RESONANCE_AMULET;
	
	/**
	 * ID: 9460<br>
	 * Message: $s1I}łB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#36245;&#24555;&#12290;<br>
	 * Message: $s1! Please hurry!
	 */
	public static final NpcStringId S1_PLEASE_HURRY;
	
	/**
	 * ID: 9461<br>
	 * Message: ɂĎB͂ǂ˂΂ȂʁB<br>
	 * Message: &#21040;&#27492;&#28858;&#27490;&#12290;&#25105;&#35201;&#32380;&#32396;&#36861;&#25802;&#37027;&#20491;&#20642;&#20249;&#12290;<br>
	 * Message: I must follow him now.
	 */
	public static final NpcStringId I_MUST_FOLLOW_HIM_NOW;
	
	/**
	 * ID: 9462<br>
	 * Message: A悤Ă̂B҂āI<br>
	 * Message: &#22038;&#12290;&#24819;&#36867;&#36305;&#21834;&#12290;&#31449;&#20303;&#65281;<br>
	 * Message: Are you running? Stop!
	 */
	public static final NpcStringId ARE_YOU_RUNNING_STOP;
	
	/**
	 * ID: 9464<br>
	 * Message: H؂̂BƎvDDD`FbÂƂ͂őނƂ邩B<br>
	 * Message: &#20160;&#40636;&#65292;&#26159;&#32972;&#21467;&#21966;&#65311;&#19981;&#31649;&#24590;&#40636;&#27171;&#65292;&#26377;&#40670;&#22855;&#24618;&#46;&#46;&#46;&#22038;&#65292;&#36889;&#27425;&#24471;&#20808;&#25764;&#36864;&#20102;&#12290;<br>
	 * Message: Are you betraying me? I thought something was wrong...I'll stop here.
	 */
	public static final NpcStringId ARE_YOU_BETRAYING_ME_I_THOUGHT_SOMETHING_WAS_WRONGILL_STOP_HERE;
	
	/**
	 * ID: 9466<br>
	 * Message: MĺDDD$s1H2lɂȂƂĎ~߂邱ƂłƎv̂B<br>
	 * Message: &#20320;&#36889;&#20642;&#20249;&#26159;&#46;&#46;&#46;&#12300;&#36;&#115;&#49;&#12301;&#65311;&#20320;&#20497;&#20197;&#28858;&#22810;&#20102;&#19968;&#20491;&#20154;&#23601;&#21487;&#20197;&#25803;&#20303;&#25105;&#30340;&#21435;&#36335;&#21966;&#65311;<br>
	 * Message: You're $s1? Even two of you can't stop me!
	 */
	public static final NpcStringId YOURE_S1_EVEN_TWO_OF_YOU_CANT_STOP_ME;
	
	/**
	 * ID: 9467<br>
	 * Message: IȞ΂DDD$s1AoĂB<br>
	 * Message: &#31967;&#31957;&#65281;&#25105;&#30340;&#20132;&#24863;&#30707;&#46;&#46;&#46;&#12300;&#36;&#115;&#49;&#12301;&#65292;&#25105;&#26371;&#35352;&#20303;&#30340;&#12290;<br>
	 * Message: Dammit! My Resonance Amulet...$s1, I'll never forget to pay you back.
	 */
	public static final NpcStringId DAMMIT_MY_RESONANCE_AMULETS1_ILL_NEVER_FORGET_TO_PAY_YOU_BACK;
	
	/**
	 * ID: 9550<br>
	 * Message: MĺDDD$s1HogV^C̓̕ɂ͂Ȃ񂼁I<br>
	 * Message: &#20320;&#36889;&#20491;&#20642;&#20249;&#26159;&#46;&#46;&#46;&#12300;&#36;&#115;&#49;&#12301;&#65311;&#33287;&#24052;&#29246;&#25552;&#26031;&#27712;&#37027;&#26178;&#30340;&#24773;&#27841;&#26159;&#19981;&#21516;&#30340;&#65281;<br>
	 * Message: Are you... $s1? I won't be like Waldstein!
	 */
	public static final NpcStringId ARE_YOU_S1_I_WONT_BE_LIKE_WALDSTEIN;
	
	/**
	 * ID: 9552<br>
	 * Message: DDD̎Ƃ́DDD<br>
	 * Message: &#21917;&#21834;&#46;&#46;&#46;&#25105;&#25915;&#25802;&#46;&#46;&#46;<br>
	 * Message: Yikes! I can't believe I lost...
	 */
	public static final NpcStringId YIKES_I_CANT_BELIEVE_I_LOST;
	
	/**
	 * ID: 9553<br>
	 * Message: $s1Aߍ̕тĂ̂͂OB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#26368;&#36817;&#22312;&#27450;&#36000;&#25105;&#37096;&#19979;&#30340;&#20642;&#20249;&#65292;&#23601;&#26159;&#20320;&#21966;&#65311;<br>
	 * Message: Are you the one bothering my minions, $s1?
	 */
	public static final NpcStringId ARE_YOU_THE_ONE_BOTHERING_MY_MINIONS_S1;
	
	/**
	 * ID: 9557<br>
	 * Message: Oɔ`̃^ubgƂ̌͂ʁI΂nI<br>
	 * Message: &#19981;&#35731;&#20320;&#21644;&#31061;&#20659;&#30340;&#30707;&#26495;&#20132;&#24863;&#65281;&#35531;&#20132;&#20986;&#20132;&#24863;&#30707;&#65281;<br>
	 * Message: You can't commune with the Tablet of Vision! Give me the Resonance Amulet!
	 */
	public static final NpcStringId YOU_CANT_COMMUNE_WITH_THE_TABLET_OF_VISION_GIVE_ME_THE_RESONANCE_AMULET;
	
	/**
	 * ID: 9567<br>
	 * Message: IȞ΂DDD$s1AoĂB<br>
	 * Message: &#31967;&#31957;&#65281;&#25105;&#30340;&#20132;&#24863;&#30707;&#46;&#46;&#46;&#12300;&#36;&#115;&#49;&#12301;&#65292;&#25105;&#26371;&#35352;&#20303;&#30340;&#12290;<br>
	 * Message: Dammit! My Resonance Amulet...$s1, I'll never forget this.
	 */
	public static final NpcStringId DAMMIT_MY_RESONANCE_AMULETS1_ILL_NEVER_FORGET_THIS;
	
	/**
	 * ID: 9650<br>
	 * Message: $s1IMlHngl̍sזłȂ悤̍~߂ĂB<br>
	 * Message: &#20320;&#23601;&#26159;&#12300;&#36;&#115;&#49;&#12301;&#65311;&#19981;&#33021;&#35731;&#20320;&#38459;&#31001;&#21704;&#21202;&#29305;&#30340;&#21435;&#36335;&#65292;&#25105;&#35201;&#27578;&#20102;&#20320;&#12290;<br>
	 * Message: You're $s1? I'll kill you for Hallate!
	 */
	public static final NpcStringId YOURE_S1_ILL_KILL_YOU_FOR_HALLATE;
	
	/**
	 * ID: 9651<br>
	 * Message: v肵ԂƂȁBMl͎̑肶ȂB<br>
	 * Message: &#27794;&#24819;&#21040;&#65292;&#20320;&#33021;&#25744;&#36889;&#40636;&#20037;&#12290;&#20294;&#20320;&#20173;&#19981;&#26159;&#25105;&#30340;&#23565;&#25163;&#65281;<br>
	 * Message: You're tougher than I thought, but you still can't rival me!
	 */
	public static final NpcStringId YOURE_TOUGHER_THAN_I_THOUGHT_BUT_YOU_STILL_CANT_RIVAL_ME;
	
	/**
	 * ID: 9652<br>
	 * Message: nglI͂ȎI<br>
	 * Message: &#21704;&#21202;&#29305;&#65281;&#35531;&#21407;&#35538;&#25105;&#27794;&#24171;&#19978;&#24537;&#65281;<br>
	 * Message: Hallate! Forgive me! I can't help you.
	 */
	public static final NpcStringId HALLATE_FORGIVE_ME_I_CANT_HELP_YOU;
	
	/**
	 * ID: 9654<br>
	 * Message: DDDMlƂɎƂ́B<br>
	 * Message: &#24590;&#40636;&#46;&#46;&#46;&#25105;&#26371;&#25915;&#25802;&#20687;&#20320;&#19968;&#27171;&#30340;&#20642;&#20249;&#21966;&#65311;&#32;<br>
	 * Message: Dammit! I can't believe you beat me!
	 */
	public static final NpcStringId DAMMIT_I_CANT_BELIEVE_YOU_BEAT_ME;
	
	/**
	 * ID: 9655<br>
	 * Message: 킢ז邨O͉҂IHڋȂ߁B<br>
	 * Message: &#20320;&#26159;&#20160;&#40636;&#26481;&#35199;&#65292;&#25954;&#25554;&#25163;&#31649;&#38290;&#20107;&#65281;&#21329;&#37145;&#28961;&#24677;&#30340;&#20642;&#20249;&#12290;<br>
	 * Message: Who are you? Mind your own business, coward.
	 */
	public static final NpcStringId WHO_ARE_YOU_MIND_YOUR_OWN_BUSINESS_COWARD;
	
	/**
	 * ID: 9657<br>
	 * Message: ̌NIȂB<br>
	 * Message: &#21029;&#25918;&#36942;&#29001;&#29508;&#30340;&#21531;&#29579;&#12290;&#32;<br>
	 * Message: Purgatory Lord, I won't fail this time.
	 */
	public static final NpcStringId PURGATORY_LORD_I_WONT_FAIL_THIS_TIME;
	
	/**
	 * ID: 9658<br>
	 * Message: $s1I܂ł̐ʂ`XIO̗͂ĂB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#22810;&#24180;&#20358;&#25105;&#25152;&#32047;&#31309;&#30340;&#23526;&#21147;&#65292;&#32066;&#26044;&#26377;&#27231;&#26371;&#34920;&#29694;&#20102;&#12290;&#23637;&#29694;&#20986;&#20320;&#30340;&#23526;&#21147;&#21543;&#12290;<br>
	 * Message: $s1! Now's the time to put your training to the test!
	 */
	public static final NpcStringId S1_NOWS_THE_TIME_TO_PUT_YOUR_TRAINING_TO_THE_TEST;
	
	/**
	 * ID: 9659<br>
	 * Message: $s1IO̎͂͂Ȃ񂶂Ȃ낤B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#20320;&#30340;&#21133;&#34899;&#23526;&#21147;&#19981;&#21487;&#33021;&#21482;&#26377;&#36889;&#27171;&#21543;&#12290;<br>
	 * Message: $s1! Your sword skills can't be that bad.
	 */
	public static final NpcStringId S1_YOUR_SWORD_SKILLS_CANT_BE_THAT_BAD;
	
	/**
	 * ID: 9660<br>
	 * Message: $s1IO̖{̗͂ĂI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#23637;&#29694;&#20986;&#20320;&#30340;&#23526;&#21147;&#21543;&#65281;<br>
	 * Message: $s1! Show your strength!
	 */
	public static final NpcStringId S1_SHOW_YOUR_STRENGTH;
	
	/**
	 * ID: 9661<br>
	 * Message: ꂶA̗͑p̂ŁDDD<br>
	 * Message: &#37027;&#40636;&#65292;&#25105;&#36996;&#26377;&#21029;&#30340;&#20107;&#35201;&#36774;&#46;&#46;&#46;<br>
	 * Message: I have some pressing business. I have to go.
	 */
	public static final NpcStringId I_HAVE_SOME_PRESSING_BUSINESS_I_HAVE_TO_GO;
	
	/**
	 * ID: 9662<br>
	 * Message: ̂AB<br>
	 * Message: &#21448;&#22833;&#21435;&#36889;&#27425;&#27231;&#26371;&#20102;&#21966;&#12290;&#28151;&#34507;&#12290;<br>
	 * Message: I missed him! Dammit.
	 */
	public static final NpcStringId I_MISSED_HIM_DAMMIT;
	
	/**
	 * ID: 9663<br>
	 * Message: ܂VтɗƂB<br>
	 * Message: &#37027;&#40636;&#65292;&#19979;&#27425;&#20877;&#20358;&#29609;&#12290;<br>
	 * Message: Try again sometime.
	 */
	public static final NpcStringId TRY_AGAIN_SOMETIME;
	
	/**
	 * ID: 9664<br>
	 * Message: ̓ǂҁIďI<br>
	 * Message: &#25803;&#20303;&#25105;&#21435;&#36335;&#30340;&#20154;&#23601;&#24471;&#27515;&#65281;<br>
	 * Message: I'll kill anyone who gets in my way!
	 */
	public static final NpcStringId ILL_KILL_ANYONE_WHO_GETS_IN_MY_WAY;
	
	/**
	 * ID: 9665<br>
	 * Message: ΂킹ȁB܂ȉ߂B<br>
	 * Message: &#30495;&#26159;&#20491;&#21487;&#31505;&#30340;&#20642;&#20249;&#65292;&#22826;&#23567;&#23478;&#23376;&#27683;&#20102;&#65292;&#30495;&#27794;&#24847;&#24605;&#12290;&#32;<br>
	 * Message: This is pathetic! You make me laugh.
	 */
	public static final NpcStringId THIS_IS_PATHETIC_YOU_MAKE_ME_LAUGH;
	
	/**
	 * ID: 9666<br>
	 * Message: $s1IMlƂ̑Oɗ͂낤Ƃ́I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#20320;&#36889;&#20491;&#20642;&#20249;&#33213;&#25954;&#25803;&#20303;&#25105;&#30340;&#21435;&#36335;&#65281;<br>
	 * Message: $s1! Are you trying to get in my way?
	 */
	public static final NpcStringId S1_ARE_YOU_TRYING_TO_GET_IN_MY_WAY;
	
	/**
	 * ID: 9667<br>
	 * Message: $s1I߂ĂO̖ɂȂ邾낤B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#31561;&#25105;&#22238;&#20358;&#30340;&#26178;&#20505;&#65292;&#23601;&#35201;&#32013;&#20320;&#30340;&#21629;&#12290;<br>
	 * Message: $s1! When I come back, I'll kill you.
	 */
	public static final NpcStringId S1_WHEN_I_COME_BACK_ILL_KILL_YOU;
	
	/**
	 * ID: 9750<br>
	 * Message: $s1H M l        B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65311;&#25105;&#65294;&#35201;&#65294;&#22312;&#65294;&#36889;&#65294;&#35041;&#65294;&#38500;&#65294;&#25481;&#65294;&#20320;&#12290;<br>
	 * Message: $s1? Wake up! Time to die!
	 */
	public static final NpcStringId S1_WAKE_UP_TIME_TO_DIE;
	
	/**
	 * ID: 9751<br>
	 * Message: v          o  B<br>
	 * Message: &#20320;&#65294;&#27604;&#65294;&#24819;&#65294;&#20687;&#65294;&#20013;&#65294;&#30340;&#65294;&#36996;&#65294;&#35201;&#65294;&#21426;&#65294;&#23475;&#12290;&#25105;&#65294;&#26371;&#65294;&#20877;&#65294;&#22238;&#65294;&#20358;&#65294;&#25214;&#65294;&#20320;&#12290;<br>
	 * Message: You're tougher than I thought! I'll be back!
	 */
	public static final NpcStringId YOURE_TOUGHER_THAN_I_THOUGHT_ILL_BE_BACK;
	
	/**
	 * ID: 9752<br>
	 * Message:        āB<br>
	 * Message: &#25105;&#65294;&#25915;&#65294;&#25802;&#65294;&#30340;&#65294;<br>
	 * Message: I lost? It can't be!
	 */
	public static final NpcStringId I_LOST_IT_CANT_BE;
	
	/**
	 * ID: 9757<br>
	 * Message: ΂IxȂB<br>
	 * Message: &#20320;&#36889;&#20491;&#20642;&#20249;&#65281;&#36889;&#27425;&#19981;&#26371;&#25918;&#36942;&#20320;&#65281;<br>
	 * Message: You're a cunning fiend. I won't fail again.
	 */
	public static final NpcStringId YOURE_A_CUNNING_FIEND_I_WONT_FAIL_AGAIN;
	
	/**
	 * ID: 9758<br>
	 * Message: $s1I̖YOɂł邼Iځ[ƂĂȂŐ킦I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#36889;&#20491;&#22750;&#34507;&#30447;&#19978;&#20320;&#20102;&#65292;&#21029;&#20809;&#21574;&#33879;&#65292;&#20986;&#25802;&#21543;&#65281;<br>
	 * Message: $s1! It's after you! Fight!
	 */
	public static final NpcStringId S1_ITS_AFTER_YOU_FIGHT;
	
	/**
	 * ID: 9759<br>
	 * Message: $s1IȂɁHx݂āHˁI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#22914;&#26524;&#20320;&#37027;&#40636;&#24819;&#20241;&#24687;&#30340;&#35441;&#65292;&#20094;&#33030;&#27515;&#20102;&#31639;&#20102;&#65281;&#22909;&#22909;&#32102;&#25105;&#25136;&#39717;&#12290;<br>
	 * Message: $s1! You have to fight better than that if you expect to survive!
	 */
	public static final NpcStringId S1_YOU_HAVE_TO_FIGHT_BETTER_THAN_THAT_IF_YOU_EXPECT_TO_SURVIVE;
	
	/**
	 * ID: 9760<br>
	 * Message: $s1ICĐ키񂾁I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#25391;&#20316;&#31934;&#31070;&#25136;&#39717;&#21543;&#65281;<br>
	 * Message: $s1! Pull yourself together. Fight!
	 */
	public static final NpcStringId S1_PULL_YOURSELF_TOGETHER_FIGHT;
	
	/**
	 * ID: 9761<br>
	 * Message: ꂶA͂ǂB<br>
	 * Message: &#37027;&#40636;&#25105;&#35201;&#20877;&#21435;&#25235;&#37027;&#20491;&#40736;&#36649;&#12290;&#32;<br>
	 * Message: I'll catch the cunning fiend.
	 */
	public static final NpcStringId ILL_CATCH_THE_CUNNING_FIEND;
	
	/**
	 * ID: 9762<br>
	 * Message: A܂B΂߁I<br>
	 * Message: &#22038;&#65292;&#21448;&#37679;&#36942;&#20102;&#12290;&#36889;&#20491;&#40736;&#36649;&#65281;<br>
	 * Message: I missed him again! He's clever!
	 */
	public static final NpcStringId I_MISSED_HIM_AGAIN_HES_CLEVER;
	
	/**
	 * ID: 9763<br>
	 * Message: ͔lO甲oĂ񂾂ȁI<br>
	 * Message: &#19979;&#23376;&#32085;&#23565;&#35201;&#21085;&#25481;&#37027;&#23567;&#23376;&#30340;&#30382;&#65281;<br>
	 * Message: Don't cower like a puppy next time!
	 */
	public static final NpcStringId DONT_COWER_LIKE_A_PUPPY_NEXT_TIME;
	
	/**
	 * ID: 9764<br>
	 * Message: ̖ڕW͂1IזǂB<br>
	 * Message: &#25105;&#30340;&#30446;&#27161;&#21482;&#26377;&#19968;&#20491;&#65281;&#28414;&#38283;&#65292;&#21029;&#25199;&#25105;&#24460;&#33151;&#12290;&#32;<br>
	 * Message: I have only one goal. Get out of my way.
	 */
	public static final NpcStringId I_HAVE_ONLY_ONE_GOAL_GET_OUT_OF_MY_WAY;
	
	/**
	 * ID: 9765<br>
	 * Message: OɓV܂ő҂Ă񂾂ȁB<br>
	 * Message: &#25105;&#22312;&#31561;&#20320;&#36973;&#21040;&#22825;&#35700;&#12290;&#32;<br>
	 * Message: Just wait. You'll get yours!
	 */
	public static final NpcStringId JUST_WAIT_YOULL_GET_YOURS;
	
	/**
	 * ID: 9766<br>
	 * Message: $s1I̔ڋ҂߁I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#20320;&#36889;&#20491;&#21329;&#37145;&#28961;&#24677;&#30340;&#20642;&#20249;&#65281;<br>
	 * Message: $s1! You're a coward, aren't you!
	 */
	public static final NpcStringId S1_YOURE_A_COWARD_ARENT_YOU;
	
	/**
	 * ID: 9767<br>
	 * Message: $s1IOK|ĂB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#19979;&#27425;&#19968;&#23450;&#35201;&#38500;&#25481;&#20320;&#12290;<br>
	 * Message: $s1! I'll kill you next time.
	 */
	public static final NpcStringId S1_ILL_KILL_YOU_NEXT_TIME;
	
	/**
	 * ID: 9850<br>
	 * Message: $s1IO_̌Sɋt炤Ƃ́BB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#20320;&#31455;&#28982;&#26371;&#36949;&#32972;&#20102;&#31070;&#30340;&#26088;&#24847;&#12290;&#30495;&#26159;&#21487;&#31505;&#12290;<br>
	 * Message: $s1! How foolish to act against the will of god.
	 */
	public static final NpcStringId S1_HOW_FOOLISH_TO_ACT_AGAINST_THE_WILL_OF_GOD;
	
	/**
	 * ID: 9851<br>
	 * Message: v̂قMSȁB܂B<br>
	 * Message: &#36889;&#20491;&#20642;&#20249;&#30340;&#20449;&#20208;&#27604;&#24819;&#20687;&#30340;&#36996;&#35201;&#22533;&#24375;&#12290;&#19979;&#27425;&#65292;&#20320;&#32102;&#25105;&#35430;&#35430;&#30475;&#12290;<br>
	 * Message: Your faith is stronger than I thought. I'll get you next time.
	 */
	public static final NpcStringId YOUR_FAITH_IS_STRONGER_THAN_I_THOUGHT_ILL_GET_YOU_NEXT_TIME;
	
	/**
	 * ID: 9855<br>
	 * Message: 킢ז邨O͉҂IHڋȂ߁B<br>
	 * Message: &#20320;&#26159;&#20160;&#40636;&#26481;&#35199;&#65292;&#25954;&#25554;&#25163;&#31649;&#38290;&#20107;&#65281;&#21329;&#37145;&#28961;&#24677;&#30340;&#20642;&#20249;&#12290;<br>
	 * Message: Who are you? Mind your own business, you coward!
	 */
	public static final NpcStringId WHO_ARE_YOU_MIND_YOUR_OWN_BUSINESS_YOU_COWARD;
	
	/**
	 * ID: 9857<br>
	 * Message: ^iLAAȂ̉R͂oĂłB<br>
	 * Message: &#22612;&#32013;&#22855;&#20126;&#20320;&#30340;&#35594;&#35328;&#24050;&#32147;&#34987;&#25581;&#31359;&#20102;&#12290;&#32;<br>
	 * Message: Tanakia, your lie has already been exposed!
	 */
	public static final NpcStringId TANAKIA_YOUR_LIE_HAS_ALREADY_BEEN_EXPOSED;
	
	/**
	 * ID: 9858<br>
	 * Message: $s1IƂƂɂ̎z܂傤B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#21644;&#25105;&#19968;&#36215;&#20811;&#26381;&#36889;&#20491;&#32771;&#39511;&#21543;&#12290;<br>
	 * Message: $s1! Help me overcome this.
	 */
	public static final NpcStringId S1_HELP_ME_OVERCOME_THIS;
	
	/**
	 * ID: 9859<br>
	 * Message: $s1I̒x^iLA͓|܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#20197;&#36889;&#31278;&#19977;&#33139;&#35987;&#21151;&#22827;&#65292;&#26159;&#28961;&#27861;&#38500;&#25481;&#22612;&#32013;&#22855;&#20126;&#30340;&#12290;<br>
	 * Message: $s1! We can't defeat Tanakia this way.
	 */
	public static final NpcStringId S1_WE_CANT_DEFEAT_TANAKIA_THIS_WAY;
	
	/**
	 * ID: 9860<br>
	 * Message: $s1I`X͍ȂłII<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#29694;&#22312;&#19981;&#20570;&#30340;&#35441;&#65292;&#23601;&#27794;&#27231;&#26371;&#20102;&#12290;&#36245;&#24555;&#65281;<br>
	 * Message: $s1! Here's our chance. Don't squander the opportunity!
	 */
	public static final NpcStringId S1_HERES_OUR_CHANCE_DONT_SQUANDER_THE_OPPORTUNITY;
	
	/**
	 * ID: 9861<br>
	 * Message: ܂΂łł傤B悤ȂDDD<br>
	 * Message: &#37027;&#40636;&#20320;&#25105;&#28961;&#32227;&#65292;&#20358;&#26085;&#20877;&#30456;&#26371;&#12290;&#20877;&#35211;&#46;&#46;&#46;<br>
	 * Message: Goodbye. We'll meet again if fate allows.
	 */
	public static final NpcStringId GOODBYE_WELL_MEET_AGAIN_IF_FATE_ALLOWS;
	
	/**
	 * ID: 9862<br>
	 * Message: ߂̉^𐳂߂ɁA^iLAǂ܂B<br>
	 * Message: &#28858;&#20102;&#25913;&#35722;&#25105;&#30340;&#26979;&#36939;&#65292;&#19968;&#23450;&#35201;&#21435;&#36861;&#25802;&#22612;&#32013;&#22855;&#20126;&#12290;&#32;<br>
	 * Message: I'll follow Tanakia to correct this falsehood.
	 */
	public static final NpcStringId ILL_FOLLOW_TANAKIA_TO_CORRECT_THIS_FALSEHOOD;
	
	/**
	 * ID: 9863<br>
	 * Message: Ȃ̉^̗ƌ鎞A܂ł傤B<br>
	 * Message: &#20320;&#21644;&#25105;&#30340;&#21629;&#36939;&#20132;&#26371;&#30340;&#26178;&#20505;&#65292;&#25105;&#26371;&#20877;&#20358;&#25214;&#20320;&#30340;&#12290;&#32;<br>
	 * Message: I'll be back if fate allows.
	 */
	public static final NpcStringId ILL_BE_BACK_IF_FATE_ALLOWS;
	
	/**
	 * ID: 9865<br>
	 * Message: ͖߂ĂB̎ɂ͊o傷邪B<br>
	 * Message: &#35201;&#20877;&#22238;&#20358;&#12290;&#21040;&#37027;&#20491;&#26178;&#20505;&#35201;&#35258;&#24735;&#12290;<br>
	 * Message: I'll be back. You'll pay.
	 */
	public static final NpcStringId ILL_BE_BACK_YOULL_PAY;
	
	/**
	 * ID: 9866<br>
	 * Message: $s1Ǐv󂷂肩I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#33213;&#25954;&#30772;&#22750;&#25105;&#30340;&#35336;&#30059;&#65311;<br>
	 * Message: $s1! Are you trying to spoil my plan?
	 */
	public static final NpcStringId S1_ARE_YOU_TRYING_TO_SPOIL_MY_PLAN;
	
	/**
	 * ID: 9867<br>
	 * Message: $s1IoĂBMl̂Ƃ͐ΖYȂB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#31561;&#33879;&#30631;&#65281;&#25105;&#32085;&#23565;&#19981;&#26371;&#24536;&#35352;&#20320;&#30340;&#12290;<br>
	 * Message: $s1! I won't forget you. You'll pay.
	 */
	public static final NpcStringId S1_I_WONT_FORGET_YOU_YOULL_PAY;
	
	/**
	 * ID: 9950<br>
	 * Message: O$s1BsȒmÂ҂Ao傷邪DDD<br>
	 * Message: &#20320;&#23601;&#26159;&#12300;&#36;&#115;&#49;&#12301;&#21966;&#65311;&#36010;&#22294;&#19981;&#30070;&#30693;&#35672;&#30340;&#20998;&#23376;&#65292;&#28310;&#20633;&#21435;&#27515;&#21543;&#46;&#46;&#46;<br>
	 * Message: $s1, You have an affinity for dangerous ideas. Are you ready to die?
	 */
	public static final NpcStringId S1_YOU_HAVE_AN_AFFINITY_FOR_DANGEROUS_IDEAS_ARE_YOU_READY_TO_DIE;
	
	/**
	 * ID: 9951<br>
	 * Message: ɗ^ꂽԂ͎gʂDDD<br>
	 * Message: &#25105;&#30340;&#26178;&#38291;&#37117;&#32791;&#30433;&#20102;&#46;&#46;&#46;<br>
	 * Message: My time is up...
	 */
	public static final NpcStringId MY_TIME_IS_UP;
	
	/**
	 * ID: 9952<br>
	 * Message: lԂƂɂЂ܂Ƃ́I蓾ȂƂI<br>
	 * Message: &#21521;&#24494;&#19981;&#36275;&#36947;&#30340;&#20154;&#39006;&#27714;&#39250;&#65281;&#36889;&#26159;&#19981;&#21487;&#33021;&#30340;&#20107;&#65281;<br>
	 * Message: I can't believe I must kneel to a Human!
	 */
	public static final NpcStringId I_CANT_BELIEVE_I_MUST_KNEEL_TO_A_HUMAN;
	
	/**
	 * ID: 9957<br>
	 * Message: ~lBAI悤I<br>
	 * Message: &#31859;&#20839;&#32173;&#20126;&#65281;&#20170;&#22825;&#25105;&#20497;&#19968;&#27770;&#21213;&#36000;&#21543;&#65281;<br>
	 * Message: Minervia! What's the matter?
	 */
	public static final NpcStringId MINERVIA_WHATS_THE_MATTER;
	
	/**
	 * ID: 9958<br>
	 * Message: [IIs`Ȃ̂ɁA܂˂ČĂ̂I<br>
	 * Message: &#22079;&#22079;&#46;&#46;&#46;&#21890;&#126;&#23567;&#22992;&#38519;&#20837;&#21361;&#38570;&#20102;&#65292;&#20320;&#38627;&#36947;&#22352;&#35222;&#19981;&#31649;&#21966;&#65311;<br>
	 * Message: The princess is in danger. Why are you staring?
	 */
	public static final NpcStringId THE_PRINCESS_IS_IN_DANGER_WHY_ARE_YOU_STARING;
	
	/**
	 * ID: 9959<br>
	 * Message: ΂ĂI$s1AI<br>
	 * Message: &#22810;&#29992;&#40670;&#21147;&#126;&#65281;&#12300;&#36;&#115;&#49;&#12301;&#65292;&#36245;&#24555;&#65281;<br>
	 * Message: Master $s1! Come on, Hurry up!
	 */
	public static final NpcStringId MASTER_S1_COME_ON_HURRY_UP;
	
	/**
	 * ID: 9960<br>
	 * Message: _I$s1A΂āI<br>
	 * Message: &#32085;&#23565;&#19981;&#33021;&#25918;&#36942;&#65281;&#12300;&#36;&#115;&#49;&#12301;&#65292;&#21152;&#27833;&#65281;<br>
	 * Message: We can't fail! Master $s1, Pull yourself together!
	 */
	public static final NpcStringId WE_CANT_FAIL_MASTER_S1_PULL_YOURSELF_TOGETHER;
	
	/**
	 * ID: 9961<br>
	 * Message: ĂꍇȂDDDꂶICłˁI<br>
	 * Message: &#36889;&#20491;&#26178;&#20505;&#19981;&#35442;&#24453;&#22312;&#36889;&#35041;&#46;&#46;&#46;&#21435;&#30475;&#30475;&#65281;&#23567;&#24515;&#23433;&#20840;&#65281;<br>
	 * Message: What am I doing... I gotta' go! Goodbye.
	 */
	public static final NpcStringId WHAT_AM_I_DOING_I_GOTTA_GO_GOODBYE;
	
	/**
	 * ID: 9962<br>
	 * Message: IDDD<br>
	 * Message: &#31561;&#31561;&#65281;&#37679;&#36942;&#20102;&#46;&#46;&#46;<br>
	 * Message: Dammit! I missed...!
	 */
	public static final NpcStringId DAMMIT_I_MISSED;
	
	/**
	 * ID: 9963<br>
	 * Message: cOǂ܂ʂłˁDDDK^FI<br>
	 * Message: &#38614;&#28982;&#26377;&#40670;&#25448;&#19981;&#24471;&#65292;&#20294;&#26159;&#21448;&#24471;&#20998;&#38626;&#20102;&#46;&#46;&#46;&#31069;&#20320;&#22909;&#36939;&#65281;<br>
	 * Message: Sorry, but I must say goodbye again... Good luck to you!
	 */
	public static final NpcStringId SORRY_BUT_I_MUST_SAY_GOODBYE_AGAIN_GOOD_LUCK_TO_YOU;
	
	/**
	 * ID: 9964<br>
	 * Message: ă^ubg̔閧邱Ƃ͂łȂI<br>
	 * Message: &#38364;&#26044;&#30707;&#26495;&#30340;&#31061;&#23494;&#65292;&#32085;&#19981;&#33021;&#35731;&#27493;&#65281;<br>
	 * Message: I can't yield the secret of the tablet!
	 */
	public static final NpcStringId I_CANT_YIELD_THE_SECRET_OF_THE_TABLET;
	
	/**
	 * ID: 9965<br>
	 * Message: ̂炢ɂĂقȁDDD<br>
	 * Message: &#21040;&#27492;&#65292;&#26368;&#22909;&#28414;&#38283;&#21543;&#46;&#46;&#46;<br>
	 * Message: I'll stop here for now...
	 */
	public static final NpcStringId ILL_STOP_HERE_FOR_NOW;
	
	/**
	 * ID: 9966<br>
	 * Message: $s1ÅɏƂ́IˁI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#31455;&#25954;&#22312;&#25105;&#30340;&#33225;&#19978;&#30041;&#19979;&#30116;&#30165;&#65281;&#21435;&#27515;&#21543;&#65281;&#65281;&#65281;<br>
	 * Message: $s1, you dared to leave scar on my face! I'll kill you!!!
	 */
	public static final NpcStringId S1_YOU_DARED_TO_LEAVE_SCAR_ON_MY_FACE_ILL_KILL_YOU;
	
	/**
	 * ID: 9967<br>
	 * Message: $s1A̖OAoĂDDDނI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#25105;&#26371;&#35352;&#20303;&#37027;&#20491;&#21517;&#23383;&#46;&#46;&#46;&#21571;&#65281;<br>
	 * Message: $s1, I won't forget your name...Ha!
	 */
	public static final NpcStringId S1_I_WONT_FORGET_YOUR_NAMEHA;
	
	/**
	 * ID: 10050<br>
	 * Message: O$s1BsȒmÂ҂Ao傷邪DDD<br>
	 * Message: &#20320;&#23601;&#26159;&#12300;&#36;&#115;&#49;&#12301;&#21966;&#65311;&#36010;&#22294;&#19981;&#30070;&#30693;&#35672;&#30340;&#20998;&#23376;&#65292;&#28310;&#20633;&#21435;&#27515;&#21543;&#46;&#46;&#46;<br>
	 * Message: $s1? You have an affinity for bad ideas. Are you ready to die?
	 */
	public static final NpcStringId S1_YOU_HAVE_AN_AFFINITY_FOR_BAD_IDEAS_ARE_YOU_READY_TO_DIE;
	
	/**
	 * ID: 10052<br>
	 * Message: lԂƂɂЂ܂Ƃ́I蓾ȂƂI<br>
	 * Message: &#21521;&#24494;&#19981;&#36275;&#36947;&#30340;&#20154;&#39006;&#27714;&#39250;&#65281;&#36889;&#26159;&#19981;&#21487;&#33021;&#30340;&#20107;&#65281;<br>
	 * Message: I can't believe I must kneel before a Human!
	 */
	public static final NpcStringId I_CANT_BELIEVE_I_MUST_KNEEL_BEFORE_A_HUMAN;
	
	/**
	 * ID: 10057<br>
	 * Message: Ä}IA΂nI<br>
	 * Message: &#21670;&#46;&#46;&#46;&#22730;&#34507;&#65281;&#20132;&#65292;&#20132;&#24863;&#30707;&#46;&#46;&#46;&#65281;&#32;<br>
	 * Message: You thief! Give me the Resonance Amulet!
	 */
	public static final NpcStringId YOU_THIEF_GIVE_ME_THE_RESONANCE_AMULET;
	
	/**
	 * ID: 10058<br>
	 * Message: I$s1AĂI<br>
	 * Message: &#21571;&#21571;&#65281;&#12300;&#36;&#115;&#49;&#12301;&#65292;&#35531;&#24171;&#24171;&#25105;&#21543;&#65281;<br>
	 * Message: Ugh! $s1, Help me!
	 */
	public static final NpcStringId UGH_S1_HELP_ME;
	
	/**
	 * ID: 10059<br>
	 * Message: $s1AށI͂킹ΏĂI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#25308;&#35351;&#20320;&#20102;&#65281;&#21516;&#24515;&#21332;&#21147;&#30340;&#35441;&#65292;&#23601;&#21487;&#20197;&#38500;&#25481;&#20182;&#20102;&#65281;<br>
	 * Message: $s1. Please, help me! Together we can beat him.
	 */
	public static final NpcStringId S1_PLEASE_HELP_ME_TOGETHER_WE_CAN_BEAT_HIM;
	
	/**
	 * ID: 10060<br>
	 * Message: $s1IԂĂ̂Ă肩I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#19968;&#27171;&#26159;&#20844;&#26371;&#30340;&#26371;&#21729;&#65292;&#38627;&#36947;&#35201;&#22352;&#35222;&#19981;&#31649;&#21966;&#65311;&#65281;&#65281;<br>
	 * Message: $s1! Are you going to let a guild member die?
	 */
	public static final NpcStringId S1_ARE_YOU_GOING_TO_LET_A_GUILD_MEMBER_DIE;
	
	/**
	 * ID: 10061<br>
	 * Message: ߂Aς肾߂IɍsI<br>
	 * Message: &#23565;&#19981;&#36215;&#65292;&#36996;&#26159;&#19981;&#34892;&#65281;&#20808;&#36208;&#20102;&#65281;<br>
	 * Message: I'm sorry, but I gotta' go first!
	 */
	public static final NpcStringId IM_SORRY_BUT_I_GOTTA_GO_FIRST;
	
	/**
	 * ID: 10062<br>
	 * Message: DDD΂ɓ炸DDD<br>
	 * Message: &#22079;&#8230;&#65281;&#32080;&#26524;&#27794;&#24471;&#21040;&#20132;&#24863;&#30707;&#46;&#46;&#46;<br>
	 * Message: Aaaah! I couldn't get the Resonance Amulet.
	 */
	public static final NpcStringId AAAAH_I_COULDNT_GET_THE_RESONANCE_AMULET;
	
	/**
	 * ID: 10063<br>
	 * Message: ꂶAI͂̕ӂŁ`<br>
	 * Message: &#37027;&#40636;&#36763;&#33510;&#20102;&#65281;&#27492;&#21051;&#65292;&#25105;&#35442;&#36864;&#22580;&#20102;&#126;&#65281;<br>
	 * Message: Take care! I gotta' go now~!
	 */
	public static final NpcStringId TAKE_CARE_I_GOTTA_GO_NOW;
	
	/**
	 * ID: 10064<br>
	 * Message: cOAd̂DDDł炨I<br>
	 * Message: &#24863;&#21040;&#38750;&#24120;&#36986;&#25022;&#65292;&#36889;&#20063;&#26159;&#25105;&#30340;&#20219;&#21209;&#46;&#46;&#46;&#38500;&#25481;&#65281;<br>
	 * Message: I'm sorry, but it's my job to kill you now!
	 */
	public static final NpcStringId IM_SORRY_BUT_ITS_MY_JOB_TO_KILL_YOU_NOW;
	
	/**
	 * ID: 10065<br>
	 * Message: ӂAԂ̖ʂȁI<br>
	 * Message: &#21628;&#65292;&#21482;&#26159;&#28010;&#36027;&#26178;&#38291;&#46;&#46;&#46;&#65281;<br>
	 * Message: What a waste of time!
	 */
	public static final NpcStringId WHAT_A_WASTE_OF_TIME;
	
	/**
	 * ID: 10066<br>
	 * Message: $s1IMlHӋCȂ߁I̍~߂ĂI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#20320;&#36889;&#20491;&#20642;&#20249;&#22909;&#22823;&#30340;&#33213;&#23376;&#65311;&#65281;&#25105;&#23601;&#36865;&#20320;&#19978;&#40643;&#27849;&#36335;&#21543;&#65281;<br>
	 * Message: $s1! How could you do this? I'll kill you!
	 */
	public static final NpcStringId S1_HOW_COULD_YOU_DO_THIS_ILL_KILL_YOU;
	
	/**
	 * ID: 10067<br>
	 * Message: $s1I̎؂͕KԂI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#25105;&#19968;&#23450;&#35201;&#22577;&#36889;&#20491;&#20167;&#65281;<br>
	 * Message: $s1! I'll pay you back!
	 */
	public static final NpcStringId S1_ILL_PAY_YOU_BACK;
	
	/**
	 * ID: 10068<br>
	 * Message: 肢玀łI<br>
	 * Message: &#27714;&#27714;&#20320;&#65292;&#21487;&#20197;&#20808;&#27515;&#19968;&#19979;&#22043;&#126;&#65311;<br>
	 * Message: Why don't you just die?!
	 */
	public static final NpcStringId WHY_DONT_YOU_JUST_DIE;
	
	/**
	 * ID: 10069<br>
	 * Message: X|C5iȂ߂ȂI<br>
	 * Message: &#35731;&#20320;&#30631;&#30631;&#33258;&#39636;&#35722;&#21270;&#38542;&#27573;&#53;&#30340;&#21426;&#23475;&#65281;<br>
	 * Message: Taste the sting of Level 5 Spoil!
	 */
	public static final NpcStringId TASTE_THE_STING_OF_LEVEL_5_SPOIL;
	
	/**
	 * ID: 10070<br>
	 * Message: 񎝂ĂȂ`<br>
	 * Message: &#20320;&#36523;&#19978;&#26377;&#25105;&#35201;&#30340;&#26481;&#35199;&#21734;&#126;<br>
	 * Message: The item is already inside you...
	 */
	public static final NpcStringId THE_ITEM_IS_ALREADY_INSIDE_YOU;
	
	/**
	 * ID: 10071<br>
	 * Message: Mdȃ|[Vނ͂߂ɂȂȂāI<br>
	 * Message: &#31455;&#25954;&#36924;&#25105;&#20351;&#29992;&#29645;&#34255;&#30340;&#34277;&#27700;&#65281;<br>
	 * Message: This potion you're making me drink is worth its weight in gold!
	 */
	public static final NpcStringId THIS_POTION_YOURE_MAKING_ME_DRINK_IS_WORTH_ITS_WEIGHT_IN_GOLD;
	
	/**
	 * ID: 10072<br>
	 * Message: OY[̊̂ō|[VIo債I<br>
	 * Message: &#36889;&#26159;&#29992;&#28784;&#29066;&#30340;&#33213;&#30740;&#30952;&#32780;&#25104;&#30340;&#34277;&#27700;&#12290;&#31561;&#33879;&#30631;&#21543;&#65281;<br>
	 * Message: This potion is prepared from the ground gall of a bear. Be careful - it packs quite a punch!
	 */
	public static final NpcStringId THIS_POTION_IS_PREPARED_FROM_THE_GROUND_GALL_OF_A_BEAR_BE_CAREFUL_IT_PACKS_QUITE_A_PUNCH;
	
	/**
	 * ID: 10073<br>
	 * Message: ЂɃ|[VgƂɂȂȂāI<br>
	 * Message: &#31455;&#28982;&#22240;&#28858;&#36889;&#20083;&#33261;&#26410;&#20094;&#30340;&#23567;&#23376;&#32780;&#20351;&#29992;&#34277;&#27700;&#126;<br>
	 * Message: How can you use a potion on a newbie...
	 */
	public static final NpcStringId HOW_CAN_YOU_USE_A_POTION_ON_A_NEWBIE;
	
	/**
	 * ID: 10074<br>
	 * Message: $s1Aꂽ҈ȊȌ͕ւĂI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#38500;&#20102;&#34987;&#20801;&#35377;&#30340;&#20154;&#20197;&#22806;&#65292;&#20219;&#20309;&#20154;&#37117;&#19981;&#20934;&#25884;&#24118;&#27494;&#22120;&#65281;<br>
	 * Message: Listen to me, $s1! Unless you have prior authorization, you can't carry a weapon here!
	 */
	public static final NpcStringId LISTEN_TO_ME_S1_UNLESS_YOU_HAVE_PRIOR_AUTHORIZATION_YOU_CANT_CARRY_A_WEAPON_HERE;
	
	/**
	 * ID: 10075<br>
	 * Message: $s1AACnU[hl̏ĵ񂱂ƂI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#39000;&#27575;&#28023;&#34217;&#30340;&#31069;&#31119;&#33287;&#24744;&#21516;&#22312;&#46;&#46;<br>
	 * Message: Dear $s1, may the blessings of Einhasad be with you always.
	 */
	public static final NpcStringId DEAR_S1_MAY_THE_BLESSINGS_OF_EINHASAD_BE_WITH_YOU_ALWAYS;
	
	/**
	 * ID: 10076<br>
	 * Message: $s1A̓ɕތZDDD<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#19968;&#21516;&#36367;&#19978;&#20809;&#26126;&#20043;&#36947;&#30340;&#20804;&#24351;&#21834;&#46;&#46;<br>
	 * Message: Dear brother $s1, follow the path of light with me...
	 */
	public static final NpcStringId DEAR_BROTHER_S1_FOLLOW_THE_PATH_OF_LIGHT_WITH_ME;
	
	/**
	 * ID: 10077<br>
	 * Message: $s1Ał̓IԂƂ́I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#31455;&#28982;&#36984;&#25799;&#20102;&#40657;&#26263;&#20043;&#36947;&#65281;<br>
	 * Message: $s1, why would you choose the path of darkness?!
	 */
	public static final NpcStringId S1_WHY_WOULD_YOU_CHOOSE_THE_PATH_OF_DARKNESS;
	
	/**
	 * ID: 10078<br>
	 * Message: $s1AACnU[hľSɔwƂ́I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#31455;&#25954;&#36949;&#32972;&#27575;&#28023;&#34217;&#30340;&#26088;&#24847;&#65281;<br>
	 * Message: $s1! How dare you defy the will of Einhasad!
	 */
	public static final NpcStringId S1_HOW_DARE_YOU_DEFY_THE_WILL_OF_EINHASAD;
	
	/**
	 * ID: 10079<br>
	 * Message: Ւd3K̔J܂B<br>
	 * Message: &#31085;&#22727;&#51;&#27155;&#30340;&#38272;&#24050;&#38283;&#21855;<br>
	 * Message: The door to the 3rd floor of the altar is now open.
	 */
	public static final NpcStringId THE_DOOR_TO_THE_3RD_FLOOR_OF_THE_ALTAR_IS_NOW_OPEN;
	
	/**
	 * ID: 11101<br>
	 * Message: GNbL[ n^[̏<br>
	 * Message: &#32822;&#29246;&#21487;&#32645;&#29557;&#20154;&#30340;&#35657;&#25818;<br>
	 * Message: Elrokian Hunters
	 */
	public static final NpcStringId ELROKIAN_HUNTERS;
	
	/**
	 * ID: 11450<br>
	 * Message: EFfBP$s1AˁI<br>
	 * Message: &#25915;&#25802;&#28331;&#33922;&#30340;&#12300;&#36;&#115;&#49;&#12301;&#65292;&#21463;&#27515;&#21543;&#65281;<br>
	 * Message: You, $s1, you attacked Wendy. Prepare to die!
	 */
	public static final NpcStringId YOU_S1_YOU_ATTACKED_WENDY_PREPARE_TO_DIE;
	
	/**
	 * ID: 11451<br>
	 * Message: G$s1ǂԂ܂BԂđҋ@܂B<br>
	 * Message: &#25802;&#36864;&#20102;&#25973;&#20154;&#12300;&#36;&#115;&#49;&#12301;&#65292;&#25105;&#20808;&#36864;&#19979;&#24453;&#21629;&#12290;<br>
	 * Message: $s1, your enemy was driven out. I will now withdraw and await your next command.
	 */
	public static final NpcStringId S1_YOUR_ENEMY_WAS_DRIVEN_OUT_I_WILL_NOW_WITHDRAW_AND_AWAIT_YOUR_NEXT_COMMAND;
	
	/**
	 * ID: 11452<br>
	 * Message: zȏɓGB퓬s\BގUB<br>
	 * Message: &#25973;&#20154;&#27604;&#24819;&#20687;&#20013;&#26356;&#21152;&#24375;&#24717;&#65292;&#28961;&#27861;&#25136;&#39717;&#65292;&#36996;&#26159;&#20808;&#36864;&#19979;&#20102;&#12290;<br>
	 * Message: This enemy is far too powerful for me to fight. I must withdraw.
	 */
	public static final NpcStringId THIS_ENEMY_IS_FAR_TOO_POWERFUL_FOR_ME_TO_FIGHT_I_MUST_WITHDRAW;
	
	/**
	 * ID: 11453<br>
	 * Message: dgTm킪ĂB#߂Ŗڂɂ̂́AȐ΂̎RB<br>
	 * Message: &#38651;&#27874;&#27298;&#28204;&#22120;&#30332;&#29983;&#21453;&#25033;&#12290;&#35;&#21608;&#22285;&#27604;&#36611;&#29305;&#21029;&#30340;&#65292;&#21482;&#26377;&#21487;&#30097;&#30340;&#30707;&#22534;&#32780;&#24050;&#12290;<br>
	 * Message: The radio signal detector is responding. # A suspicious pile of stones catches your eye.
	 */
	public static final NpcStringId THE_RADIO_SIGNAL_DETECTOR_IS_RESPONDING_A_SUSPICIOUS_PILE_OF_STONES_CATCHES_YOUR_EYE;
	
	/**
	 * ID: 11550<br>
	 * Message: ւ̂͂Ȃ񂾂ǁDDD<br>
	 * Message: &#22909;&#20687;&#23601;&#26159;&#36889;&#20818;&#46;&#46;&#46;<br>
	 * Message: This looks like the right place...
	 */
	public static final NpcStringId THIS_LOOKS_LIKE_THE_RIGHT_PLACE;
	
	/**
	 * ID: 11551<br>
	 * Message: NB^Ȃ̂DDD<br>
	 * Message: &#26377;&#20154;&#22312;&#27492;&#65292;&#38627;&#36947;&#36889;&#20063;&#26159;&#35387;&#23450;&#30340;&#21966;&#65311;<br>
	 * Message: I see someone. Is this fate?
	 */
	public static final NpcStringId I_SEE_SOMEONE_IS_THIS_FATE;
	
	/**
	 * ID: 11552<br>
	 * Message: Ȃɂł܂Ƃ́B<br>
	 * Message: &#31455;&#33021;&#33287;&#20320;&#22312;&#36889;&#20818;&#20877;&#27425;&#30456;&#36898;&#12290;<br>
	 * Message: We meet again.
	 */
	public static final NpcStringId WE_MEET_AGAIN;
	
	/**
	 * ID: 11553<br>
	 * Message: ̂Ƃ͂BȂ͂Ȃ̉^ɏ]ȂB<br>
	 * Message: &#26377;&#38364;&#26044;&#25105;&#30340;&#20107;&#24773;&#20320;&#19981;&#24517;&#30693;&#36947;&#12290;&#20320;&#21482;&#35201;&#38918;&#24478;&#20320;&#30340;&#21629;&#36939;&#23601;&#23565;&#20102;&#12290;<br>
	 * Message: Don't bother trying to find out more about me. Follow your own destiny.
	 */
	public static final NpcStringId DONT_BOTHER_TRYING_TO_FIND_OUT_MORE_ABOUT_ME_FOLLOW_YOUR_OWN_DESTINY;
	
	/**
	 * ID: 14204<br>
	 * Message: t@[ GWFFI<br>
	 * Message: &#22684;&#33853;&#30340;&#22825;&#20351;&#45;&#36984;&#25799;<br>
	 * Message: Fallen Angel - Select
	 */
	public static final NpcStringId FALLEN_ANGEL_SELECT;
	
	/**
	 * ID: 15804<br>
	 * Message: ӋCɂɒނƂ́I<br>
	 * Message: &#46;&#46;&#46;&#31455;&#25954;&#21521;&#25105;&#25361;&#25136;&#65281;<br>
	 * Message: ... How dare you challenge me!
	 */
	public static final NpcStringId _HOW_DARE_YOU_CHALLENGE_ME;
	
	/**
	 * ID: 15805<br>
	 * Message: ׃XľVɁDDD<br>
	 * Message: &#23559;&#24052;&#21015;&#26031;&#30340;&#27402;&#21218;&#65292;&#36941;&#20296;&#26044;&#22825;&#19979;&#46;&#46;&#46;&#65281;<br>
	 * Message: The power of Lord Beleth rules the whole world...!
	 */
	public static final NpcStringId THE_POWER_OF_LORD_BELETH_RULES_THE_WHOLE_WORLD;
	
	/**
	 * ID: 16404<br>
	 * Message: Ȃ̔M𖡂킹Ă炨I<br>
	 * Message: &#25105;&#35201;&#21852;&#39154;&#20320;&#30340;&#29105;&#34880;&#65281;<br>
	 * Message: I will taste your blood!
	 */
	public static final NpcStringId I_WILL_TASTE_YOUR_BLOOD;
	
	/**
	 * ID: 16405<br>
	 * Message: N~XƂ̌_񂪏IDDD<br>
	 * Message: &#21644;&#20811;&#37324;&#31859;&#26031;&#30340;&#22865;&#32004;&#24050;&#23653;&#34892;&#23436;&#30050;&#46;&#46;&#46;<br>
	 * Message: I have fulfilled my contract with Trader Creamees.
	 */
	public static final NpcStringId I_HAVE_FULFILLED_MY_CONTRACT_WITH_TRADER_CREAMEES;
	
	/**
	 * ID: 17004<br>
	 * Message: ߂邱Ƃ̂ȂɊׂĂI<br>
	 * Message: &#35731;&#20320;&#27704;&#36960;&#37117;&#20570;&#24801;&#22818;&#28961;&#27861;&#29990;&#37266;&#65281;<br>
	 * Message: I'll cast you into an eternal nightmare!
	 */
	public static final NpcStringId ILL_CAST_YOU_INTO_AN_ETERNAL_NIGHTMARE;
	
	/**
	 * ID: 17005<br>
	 * Message: ̍̓CJXl̂ƂցDDD<br>
	 * Message: &#25105;&#30340;&#38728;&#39746;&#23660;&#26044;&#20234;&#20811;&#39791;&#26031;&#38307;&#19979;&#46;&#46;&#46;<br>
	 * Message: Send my soul to Lich King Icarus...
	 */
	public static final NpcStringId SEND_MY_SOUL_TO_LICH_KING_ICARUS;
	
	/**
	 * ID: 17151<br>
	 * Message: ͂ꂭ炢ɂĈグ悤DDD<br>
	 * Message: &#36889;&#27425;&#23601;&#21040;&#27492;&#28858;&#27490;&#21543;&#46;&#46;&#46;<br>
	 * Message: You should consider going back...
	 */
	public static final NpcStringId YOU_SHOULD_CONSIDER_GOING_BACK;
	
	/**
	 * ID: 17951<br>
	 * Message: x[ɕ܂ꂽnDDD<br>
	 * Message: &#34987;&#25513;&#33995;&#30340;&#21109;&#36896;&#20027;&#46;&#46;&#46;<br>
	 * Message: The Veiled Creator...
	 */
	public static final NpcStringId THE_VEILED_CREATOR;
	
	/**
	 * ID: 17952<br>
	 * Message: 󂳂Ȃ΂ȂȂ푰<br>
	 * Message: &#25033;&#23553;&#21360;&#36215;&#20358;&#30340;&#31278;&#26063;<br>
	 * Message: The Conspiracy of the Ancient Race
	 */
	public static final NpcStringId THE_CONSPIRACY_OF_THE_ANCIENT_RACE;
	
	/**
	 * ID: 17953<br>
	 * Message: ׂ̖DDD<br>
	 * Message: &#28222;&#27788;&#30340;&#26410;&#20358;&#46;&#46;&#46;<br>
	 * Message: Chaos and Time...
	 */
	public static final NpcStringId CHAOS_AND_TIME;
	
	/**
	 * ID: 18451<br>
	 * Message: NҔIRh߁A2ɋL^uj󂵂܂B<br>
	 * Message: &#30332;&#29694;&#20837;&#20405;&#32773;&#65292;&#28858;&#36991;&#20813;&#24773;&#22577;&#27945;&#28431;&#65292;&#23559;&#22312;&#50;&#20998;&#37912;&#24460;&#36914;&#34892;&#32000;&#37636;&#35037;&#32622;&#30340;&#29190;&#30772;&#12290;<br>
	 * Message: Intruder Alert! The alarm will self-destruct in 2 minutes.
	 */
	public static final NpcStringId INTRUDER_ALERT_THE_ALARM_WILL_SELF_DESTRUCT_IN_2_MINUTES;
	
	/**
	 * ID: 18452<br>
	 * Message: L^u̔j60bOłBj~߂ɂ̓pX[h͂ĂB<br>
	 * Message: &#36317;&#38626;&#32000;&#37636;&#35037;&#32622;&#29190;&#30772;&#26178;&#38291;&#36996;&#21097;&#19979;&#54;&#48;&#31186;&#65292;&#33509;&#35201;&#20013;&#26039;&#35531;&#36664;&#20837;&#23494;&#30908;&#12290;<br>
	 * Message: The alarm will self-destruct in 60 seconds. Enter passcode to override.
	 */
	public static final NpcStringId THE_ALARM_WILL_SELF_DESTRUCT_IN_60_SECONDS_ENTER_PASSCODE_TO_OVERRIDE;
	
	/**
	 * ID: 18453<br>
	 * Message: L^u̔j30bOłBj~߂ɂ̓pX[h͂ĂB<br>
	 * Message: &#36317;&#38626;&#32000;&#37636;&#35037;&#32622;&#29190;&#30772;&#26178;&#38291;&#36996;&#21097;&#19979;&#51;&#48;&#31186;&#65292;&#33509;&#35201;&#20013;&#26039;&#35531;&#36664;&#20837;&#23494;&#30908;&#12290;<br>
	 * Message: The alarm will self-destruct in 30 seconds. Enter passcode to override.
	 */
	public static final NpcStringId THE_ALARM_WILL_SELF_DESTRUCT_IN_30_SECONDS_ENTER_PASSCODE_TO_OVERRIDE;
	
	/**
	 * ID: 18454<br>
	 * Message: L^u̔j10bOłBj~߂ɂ̓pX[h͂ĂB<br>
	 * Message: &#36317;&#38626;&#32000;&#37636;&#35037;&#32622;&#29190;&#30772;&#26178;&#38291;&#36996;&#21097;&#19979;&#49;&#48;&#31186;&#65292;&#33509;&#35201;&#20013;&#26039;&#35531;&#36664;&#20837;&#23494;&#30908;&#12290;<br>
	 * Message: The alarm will self-destruct in 10 seconds. Enter passcode to override.
	 */
	public static final NpcStringId THE_ALARM_WILL_SELF_DESTRUCT_IN_10_SECONDS_ENTER_PASSCODE_TO_OVERRIDE;
	
	/**
	 * ID: 18455<br>
	 * Message: L^uj󂳂܂B<br>
	 * Message: &#32000;&#37636;&#35037;&#32622;&#24050;&#34987;&#25703;&#27584;&#12290;<br>
	 * Message: Recorder crushed.
	 */
	public static final NpcStringId RECORDER_CRUSHED;
	
	/**
	 * ID: 18552<br>
	 * Message: L^uj60bOłBSȏꏊɔĂB<br>
	 * Message: &#38626;&#32000;&#37636;&#35037;&#32622;&#29190;&#30772;&#26178;&#38291;&#36996;&#21097;&#19979;&#54;&#48;&#31186;&#65292;&#35531;&#30433;&#36895;&#25764;&#38626;&#21040;&#23433;&#20840;&#30340;&#22320;&#26041;&#12290;<br>
	 * Message: The alarm will self-destruct in 60 seconds. Please evacuate immediately!
	 */
	public static final NpcStringId THE_ALARM_WILL_SELF_DESTRUCT_IN_60_SECONDS_PLEASE_EVACUATE_IMMEDIATELY;
	
	/**
	 * ID: 18553<br>
	 * Message: L^uj30bOłBSȏꏊɔĂB<br>
	 * Message: &#38626;&#32000;&#37636;&#35037;&#32622;&#29190;&#30772;&#26178;&#38291;&#36996;&#21097;&#19979;&#51;&#48;&#31186;&#65292;&#35531;&#30433;&#36895;&#25764;&#38626;&#21040;&#23433;&#20840;&#30340;&#22320;&#26041;&#12290;<br>
	 * Message: The alarm will self-destruct in 30 seconds. Please evacuate immediately!
	 */
	public static final NpcStringId THE_ALARM_WILL_SELF_DESTRUCT_IN_30_SECONDS_PLEASE_EVACUATE_IMMEDIATELY;
	
	/**
	 * ID: 18554<br>
	 * Message: L^uj10bOłBSȏꏊɔĂB<br>
	 * Message: &#38626;&#32000;&#37636;&#35037;&#32622;&#29190;&#30772;&#26178;&#38291;&#36996;&#21097;&#19979;&#49;&#48;&#31186;&#65292;&#35531;&#30433;&#36895;&#25764;&#38626;&#21040;&#23433;&#20840;&#30340;&#22320;&#26041;&#12290;<br>
	 * Message: The alarm will self-destruct in 10 seconds. Please evacuate immediately!
	 */
	public static final NpcStringId THE_ALARM_WILL_SELF_DESTRUCT_IN_10_SECONDS_PLEASE_EVACUATE_IMMEDIATELY;
	
	/**
	 * ID: 19304<br>
	 * Message: $s1I̕i̎͂܂ł͂ȂI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#21834;&#65281;&#37027;&#20491;&#29289;&#21697;&#30340;&#20027;&#20154;&#19981;&#26159;&#20320;&#20497;&#12290;<br>
	 * Message: $s1! You are not the owner of that item.
	 */
	public static final NpcStringId S1_YOU_ARE_NOT_THE_OWNER_OF_THAT_ITEM;
	
	/**
	 * ID: 19305<br>
	 * Message: CI͐ċA˂I<br>
	 * Message: &#23567;&#24515;&#65281;&#19979;&#27425;&#23601;&#19981;&#33021;&#27963;&#33879;&#22238;&#21435;&#20102;&#12290;<br>
	 * Message: Next time, you will not escape!
	 */
	public static final NpcStringId NEXT_TIME_YOU_WILL_NOT_ESCAPE;
	
	/**
	 * ID: 19306<br>
	 * Message: $s1ÎƂ͈邪A͂O߂܂ĂI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#29694;&#22312;&#25105;&#23601;&#35731;&#20320;&#19968;&#27493;&#46;&#46;&#19981;&#36942;&#65292;&#25105;&#19968;&#23450;&#26371;&#25235;&#21040;&#20320;&#30340;&#12290;<br>
	 * Message: $s1! You may have won this time... But next time, I will surely capture you!
	 */
	public static final NpcStringId S1_YOU_MAY_HAVE_WON_THIS_TIME_BUT_NEXT_TIME_I_WILL_SURELY_CAPTURE_YOU;
	
	/**
	 * ID: 19504<br>
	 * Message: N҂It̎iՒcI<br>
	 * Message: &#26377;&#20837;&#20405;&#32773;&#65281;&#23432;&#35703;&#40654;&#26126;&#30340;&#31085;&#21496;&#22296;&#65281;<br>
	 * Message: Intruder! Protect the Priests of Dawn!
	 */
	public static final NpcStringId INTRUDER_PROTECT_THE_PRIESTS_OF_DAWN;
	
	/**
	 * ID: 19505<br>
	 * Message: O͒NHƂȂ炾ȁB܂͂ɂ͋ߊȂB<br>
	 * Message: &#20320;&#26159;&#35504;&#65281;&#65281;&#65281;&#38476;&#29983;&#38754;&#23380;&#28961;&#27861;&#25509;&#36817;&#27492;&#22320;&#65281;<br>
	 * Message: Who are you?! A new face like you can't approach this place!
	 */
	public static final NpcStringId WHO_ARE_YOU_A_NEW_FACE_LIKE_YOU_CANT_APPROACH_THIS_PLACE;
	
	/**
	 * ID: 19506<br>
	 * Message: Ȏq܂̕ϐgpłɔEэނƂ́IočsI<br>
	 * Message: &#31455;&#25954;&#20197;&#37027;&#31278;&#21312;&#21312;&#30340;&#35722;&#36523;&#34899;&#20837;&#20405;&#27492;&#22320;&#65281;&#32102;&#25105;&#28414;&#65281;<br>
	 * Message: How dare you intrude with that transformation! Get lost!
	 */
	public static final NpcStringId HOW_DARE_YOU_INTRUDE_WITH_THAT_TRANSFORMATION_GET_LOST;
	
	/**
	 * ID: 19604<br>
	 * Message: NI}̏lĂяốI<br>
	 * Message: &#35504;&#46;&#46;&#46;&#26159;&#35504;&#21484;&#21914;&#25105;&#36001;&#23500;&#30340;&#21830;&#20154;&#21834;&#46;&#46;&#46;<br>
	 * Message: Who dares summon the Merchant of Mammon?!
	 */
	public static final NpcStringId WHO_DARES_SUMMON_THE_MERCHANT_OF_MAMMON;
	
	/**
	 * ID: 19605<br>
	 * Message: cƂ̌Â񑩂DDD<br>
	 * Message: &#33287;&#30343;&#24093;&#20043;&#38291;&#30340;&#38263;&#20037;&#32004;&#23450;&#32066;&#26044;&#36948;&#25104;&#20102;&#46;&#46;&#46;<br>
	 * Message: The ancient promise to the Emperor has been fulfilled.
	 */
	public static final NpcStringId THE_ANCIENT_PROMISE_TO_THE_EMPEROR_HAS_BEEN_FULFILLED;
	
	/**
	 * ID: 19606<br>
	 * Message: ACnU[hAiȂI<br>
	 * Message: &#28858;&#20102;&#27575;&#28023;&#34217;&#30340;&#27704;&#24646;&#65281;&#65281;&#65281;<br>
	 * Message: For the eternity of Einhasad!!!
	 */
	public static final NpcStringId FOR_THE_ETERNITY_OF_EINHASAD;
	
	/**
	 * ID: 19607<br>
	 * Message: V[̎qIFO͉X̑ł͂ȂI<br>
	 * Message: &#24109;&#29747;&#30340;&#23401;&#23376;&#20497;&#21834;&#65281;&#20320;&#20497;&#28961;&#27861;&#25104;&#28858;&#25105;&#20497;&#30340;&#23565;&#25163;&#65281;<br>
	 * Message: Dear Shillien's offsprings! You are not capable of confronting us!
	 */
	public static final NpcStringId DEAR_SHILLIENS_OFFSPRINGS_YOU_ARE_NOT_CAPABLE_OF_CONFRONTING_US;
	
	/**
	 * ID: 19608<br>
	 * Message: ACnU[hl̐^̗͂Ă낤I<br>
	 * Message: &#25105;&#35731;&#20320;&#20497;&#30631;&#30631;&#27575;&#28023;&#34217;&#30495;&#27491;&#30340;&#21147;&#37327;&#65281;<br>
	 * Message: I'll show you the real power of Einhasad!
	 */
	public static final NpcStringId ILL_SHOW_YOU_THE_REAL_POWER_OF_EINHASAD;
	
	/**
	 * ID: 19609<br>
	 * Message: ̌RIV[̎q|I<br>
	 * Message: &#20809;&#26126;&#36557;&#21218;&#21834;&#65281;&#25802;&#25943;&#24109;&#29747;&#30340;&#23401;&#23376;&#20497;&#21543;&#65281;&#65281;&#65281;<br>
	 * Message: Dear Military Force of Light! Go destroy the offsprings of Shillien!!!
	 */
	public static final NpcStringId DEAR_MILITARY_FORCE_OF_LIGHT_GO_DESTROY_THE_OFFSPRINGS_OF_SHILLIEN;
	
	/**
	 * ID: 19610<br>
	 * Message: ׂ$s1l̂łB肪Ƃ܂B<br>
	 * Message: &#36889;&#20840;&#37117;&#26159;&#35351;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#31119;&#65292;&#35613;&#35613;&#65281;<br>
	 * Message: Everything is owing to $s1. Thank you.
	 */
	public static final NpcStringId EVERYTHING_IS_OWING_TO_S1_THANK_YOU;
	
	/**
	 * ID: 19611<br>
	 * Message: ̗͂͂܂B󑕒u쓮ĂI<br>
	 * Message: &#25105;&#30340;&#21147;&#37327;&#22312;&#35722;&#24369;&#65292;&#35531;&#36245;&#24555;&#21855;&#21205;&#23553;&#21360;&#35037;&#32622;&#21543;&#65281;&#65281;&#65281;<br>
	 * Message: My power's weakening.. Hurry and turn on the sealing device!!!
	 */
	public static final NpcStringId MY_POWERS_WEAKENING_HURRY_AND_TURN_ON_THE_SEALING_DEVICE;
	
	/**
	 * ID: 19612<br>
	 * Message: 󑕒u4ׂč쓮Ȃ΂Ȃ܂I<br>
	 * Message: &#52;&#20491;&#23553;&#21360;&#35037;&#32622;&#24517;&#38920;&#35201;&#20840;&#37096;&#21855;&#21205;&#65281;&#65281;&#65281;<br>
	 * Message: All 4 sealing devices must be turned on!!!
	 */
	public static final NpcStringId ALL_4_SEALING_DEVICES_MUST_BE_TURNED_ON;
	
	/**
	 * ID: 19613<br>
	 * Message: X̍UȂ܂B쓮ĂI<br>
	 * Message: &#33673;&#33673;&#32114;&#30340;&#25915;&#25802;&#35722;&#24471;&#26356;&#21152;&#20807;&#29467;&#20102;&#65281;&#35531;&#36245;&#24555;&#21855;&#21205;&#65281;<br>
	 * Message: Lilith's attack is getting stronger! Go ahead and turn it on!
	 */
	public static final NpcStringId LILITHS_ATTACK_IS_GETTING_STRONGER_GO_AHEAD_AND_TURN_IT_ON;
	
	/**
	 * ID: 19614<br>
	 * Message: $s1I΂ĂB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#21834;&#65292;&#35531;&#24744;&#20877;&#46;&#46;&#21152;&#40670;&#21147;&#12290;<br>
	 * Message: Dear $s1, give me more strength.
	 */
	public static final NpcStringId DEAR_S1_GIVE_ME_MORE_STRENGTH;
	
	/**
	 * ID: 19615<br>
	 * Message: ̋҂߂I̐푈̐^̏҂̓V[lI<br>
	 * Message: &#24858;&#34850;&#30340;&#26481;&#35199;&#65281;&#36889;&#22580;&#25136;&#29229;&#30340;&#21213;&#21033;&#26159;&#27512;&#24109;&#29747;&#30340;&#65281;&#65281;&#65281;<br>
	 * Message: You, such a fool! The victory over this war belongs to Shilien!!!
	 */
	public static final NpcStringId YOU_SUCH_A_FOOL_THE_VICTORY_OVER_THIS_WAR_BELONGS_TO_SHILIEN;
	
	/**
	 * ID: 19616<br>
	 * Message: ӋCɂƐ킢ƁHΎ~疜I<br>
	 * Message: &#31455;&#25954;&#24819;&#35201;&#21644;&#25105;&#27604;&#27494;&#65311;&#30495;&#26159;&#21487;&#31505;&#12290;<br>
	 * Message: How dare you try to contend against me in strength? Ridiculous.
	 */
	public static final NpcStringId HOW_DARE_YOU_TRY_TO_CONTEND_AGAINST_ME_IN_STRENGTH_RIDICULOUS;
	
	/**
	 * ID: 19617<br>
	 * Message: AiLȊȂV[ľ䖼̂Ƃɑ̍~߂ĂI<br>
	 * Message: &#20126;&#32013;&#65281;&#20197;&#20553;&#22823;&#30340;&#24109;&#29747;&#20043;&#21517;&#65292;&#25105;&#23559;&#20102;&#26039;&#20320;&#30340;&#29983;&#21629;&#65281;<br>
	 * Message: Anakim! In the name of Great Shilien, I will cut your throat!
	 */
	public static final NpcStringId ANAKIM_IN_THE_NAME_OF_GREAT_SHILIEN_I_WILL_CUT_YOUR_THROAT;
	
	/**
	 * ID: 19618<br>
	 * Message: FȎ͎ł͂ȂÎł킩点Ă낤I<br>
	 * Message: &#20320;&#28961;&#27861;&#25104;&#28858;&#25105;&#45;&#45;&#33673;&#33673;&#32114;&#30340;&#23565;&#25163;&#65292;&#35731;&#20320;&#30631;&#30631;&#25105;&#30340;&#21426;&#23475;&#65281;<br>
	 * Message: You cannot be the match of Lilith. I'll teach you a lesson!
	 */
	public static final NpcStringId YOU_CANNOT_BE_THE_MATCH_OF_LILITH_ILL_TEACH_YOU_A_LESSON;
	
	/**
	 * ID: 19619<br>
	 * Message: ȎpŃV[l̉ɖ߂˂΂ȂȂƂ́DDD₵DDD<br>
	 * Message: &#31455;&#28982;&#23601;&#36889;&#27171;&#22238;&#21040;&#24109;&#29747;&#30340;&#25079;&#25265;&#46;&#46;&#30495;&#26159;&#27683;&#24996;&#46;&#46;<br>
	 * Message: I must go back to Shilien just like this. Outrageous.
	 */
	public static final NpcStringId I_MUST_GO_BACK_TO_SHILIEN_JUST_LIKE_THIS_OUTRAGEOUS;
	
	/**
	 * ID: 19804<br>
	 * Message: ťNɐn҂ɎI<br>
	 * Message: &#23559;&#25361;&#25136;&#40654;&#26126;&#30340;&#21531;&#20027;&#30340;&#20154;&#34389;&#27515;&#21543;&#65281;&#65281;&#65281;<br>
	 * Message: Death to the enemies of the Lords of Dawn!!!
	 */
	public static final NpcStringId DEATH_TO_THE_ENEMIES_OF_THE_LORDS_OF_DAWN;
	
	/**
	 * ID: 19805<br>
	 * Message: O̖ɂ́AɉXtB񑩂悤I<br>
	 * Message: &#25105;&#21521;&#20320;&#25215;&#35582;&#65292;&#22312;&#20320;&#30340;&#26410;&#20358;&#65292;&#25105;&#20497;&#40654;&#26126;&#23559;&#27704;&#36960;&#20276;&#33879;&#20320;&#65281;&#65281;&#65281;&#65281;<br>
	 * Message: We will be with you always...
	 */
	public static final NpcStringId WE_WILL_BE_WITH_YOU_ALWAYS;
	
	/**
	 * ID: 19806<br>
	 * Message: ̕i̎͂܂ł͂ȂI<br>
	 * Message: &#37027;&#20491;&#29289;&#21697;&#30340;&#20027;&#20154;&#19981;&#26159;&#20320;&#20497;&#46;&#46;&#46;<br>
	 * Message: You are not the owner of that item.
	 */
	public static final NpcStringId YOU_ARE_NOT_THE_OWNER_OF_THAT_ITEM;
	
	/**
	 * ID: 19807<br>
	 * Message: GuIDDD<br>
	 * Message: &#32986;&#32974;&#46;&#46;&#46;<br>
	 * Message: Embryo...
	 */
	public static final NpcStringId EMBRYO;
	
	/**
	 * ID: 20901<br>
	 * Message: J}G `[gA<br>
	 * Message: &#38343;&#22825;&#20351;&#25351;&#21335;<br>
	 * Message: Kamael Tutorial
	 */
	public static final NpcStringId KAMAEL_TUTORIAL;
	
	/**
	 * ID: 22051<br>
	 * Message: JJC̎艺I<br>
	 * Message: &#21345;&#21345;&#20234;&#30340;&#29226;&#29273;&#33;<br>
	 * Message: Is it a lackey of Kakai?!
	 */
	public static final NpcStringId IS_IT_A_LACKEY_OF_KAKAI;
	
	/**
	 * ID: 22052<br>
	 * Message: xI<br>
	 * Message: &#22826;&#26202;&#20102;&#33;<br>
	 * Message: Too late!
	 */
	public static final NpcStringId TOO_LATE;
	
	/**
	 * ID: 22055<br>
	 * Message: AG߂I<br>
	 * Message: &#20900;&#26505;&#21834;&#33;&#26159;&#35492;&#26371;&#21834;&#33;<br>
	 * Message: How regretful! Unjust dishonor!
	 */
	public static final NpcStringId HOW_REGRETFUL_UNJUST_DISHONOR;
	
	/**
	 * ID: 22056<br>
	 * Message: KQĂI<br>
	 * Message: &#32317;&#26377;&#19968;&#22825;&#25105;&#26371;&#22577;&#20167;&#30340;&#33;&#33;<br>
	 * Message: I'll get revenge someday!!
	 */
	public static final NpcStringId ILL_GET_REVENGE_SOMEDAY;
	
	/**
	 * ID: 22057<br>
	 * Message: sȎI<br>
	 * Message: &#21756;&#33;&#19981;&#26381;&#27683;&#33;&#27515;&#30340;&#22826;&#20900;&#26505;&#20102;&#33;&#33;<br>
	 * Message: Indignant and unfair death!
	 */
	public static final NpcStringId INDIGNANT_AND_UNFAIR_DEATH;
	
	/**
	 * ID: 22719<br>
	 * Message: Bꂽ^͂邾낤DDD<br>
	 * Message: &#24050;&#28153;&#27794;&#30340;&#30495;&#23526;&#65292;&#32317;&#26377;&#19968;&#22825;&#26371;&#30495;&#30456;&#22823;&#30333;&#46;&#46;&#46;&#33;<br>
	 * Message: The concealed truth will always be revealed...!
	 */
	public static final NpcStringId THE_CONCEALED_TRUTH_WILL_ALWAYS_BE_REVEALED;
	
	/**
	 * ID: 22720<br>
	 * Message: ߁I<br>
	 * Message: &#21329;&#37145;&#30340;&#20642;&#20249;&#33;<br>
	 * Message: Cowardly guy!
	 */
	public static final NpcStringId COWARDLY_GUY;
	
	/**
	 * ID: 22819<br>
	 * Message: ̖͋؁DDD߂ׂƂmĂDDD؁DDD<br>
	 * Message: &#25105;&#26159;&#34395;&#28961;&#20043;&#27193;&#46;&#46;&#46;&#30693;&#36947;&#21435;&#34389;&#46;&#46;&#46;&#20043;&#27193;&#46;&#46;&#46;<br>
	 * Message: I am a tree of nothing... a tree... that knows where to return...
	 */
	public static final NpcStringId I_AM_A_TREE_OF_NOTHING_A_TREE_THAT_KNOWS_WHERE_TO_RETURN;
	
	/**
	 * ID: 22820<br>
	 * Message: ͋̉[̐^鑶݁DDD<br>
	 * Message: &#25105;&#26159;&#21487;&#20197;&#22312;&#20839;&#24515;&#28145;&#34389;&#28014;&#29694;&#30495;&#23526;&#38754;&#30340;&#23384;&#22312;&#46;&#46;&#46;<br>
	 * Message: I am a creature that shows the truth of the place deep in my heart...
	 */
	public static final NpcStringId I_AM_A_CREATURE_THAT_SHOWS_THE_TRUTH_OF_THE_PLACE_DEEP_IN_MY_HEART;
	
	/**
	 * ID: 22821<br>
	 * Message: ͈ł̋DDDł̋DDD<br>
	 * Message: &#25105;&#26159;&#26263;&#40657;&#20043;&#37857;&#46;&#46;&#46;&#26263;&#40657;&#20043;&#34395;&#24819;&#46;&#46;&#46;<br>
	 * Message: I am a mirror of darkness... a virtual image of darkness...
	 */
	public static final NpcStringId I_AM_A_MIRROR_OF_DARKNESS_A_VIRTUAL_IMAGE_OF_DARKNESS;
	
	/**
	 * ID: 22933<br>
	 * Message: ΂ɓn񂼁I͎̋Mdȍ󂾁I<br>
	 * Message: &#32085;&#23565;&#19981;&#33021;&#32102;&#20320;&#33;&#36889;&#26159;&#25105;&#26368;&#29645;&#36020;&#30340;&#23542;&#29289;&#33;<br>
	 * Message: I absolutely cannot give it to you! It is my precious jewel!
	 */
	public static final NpcStringId I_ABSOLUTELY_CANNOT_GIVE_IT_TO_YOU_IT_IS_MY_PRECIOUS_JEWEL;
	
	/**
	 * ID: 22934<br>
	 * Message: O̖D̂́A܂łaI<br>
	 * Message: &#19979;&#27425;&#20877;&#21462;&#20320;&#20497;&#30340;&#20154;&#38957;&#65281;<br>
	 * Message: I'll take your lives later!
	 */
	public static final NpcStringId ILL_TAKE_YOUR_LIVES_LATER;
	
	/**
	 * ID: 22935<br>
	 * Message: ̌͂܂DDD<br>
	 * Message: &#37027;&#21133;&#35442;&#19981;&#26371;&#26159;&#46;&#46;&#46;&#33;<br>
	 * Message: That sword is really...!
	 */
	public static final NpcStringId THAT_SWORD_IS_REALLY;
	
	/**
	 * ID: 22936<br>
	 * Message: ߂łI܂jƎEC̎gʂĂ܂I<br>
	 * Message: &#19981;&#34892;&#33;&#33;&#33;&#36996;&#27794;&#23436;&#25104;&#30772;&#22750;&#33287;&#27578;&#25134;&#30340;&#21629;&#20196;&#33;&#33;&#33;<br>
	 * Message: No! I haven't completely finished the command for destruction and slaughter yet!!!
	 */
	public static final NpcStringId NO_I_HAVENT_COMPLETELY_FINISHED_THE_COMMAND_FOR_DESTRUCTION_AND_SLAUGHTER_YET;
	
	/**
	 * ID: 22937<br>
	 * Message: ̖WƂ́IʂI<br>
	 * Message: &#31455;&#25954;&#21557;&#37266;&#25105;&#65281;&#21435;&#27515;&#21543;&#65281;<br>
	 * Message: How dare you wake me! Now you shall die!
	 */
	public static final NpcStringId HOW_DARE_YOU_WAKE_ME_NOW_YOU_SHALL_DIE;
	
	/**
	 * ID: 23060<br>
	 * Message: P b g E  n W  } XDDD<br>
	 * Message: &#25136;&#46;&#39717;&#46;&#38283;&#46;&#22987;<br>
	 * Message: START DUEL
	 */
	public static final NpcStringId START_DUEL;
	
	/**
	 * ID: 23061<br>
	 * Message: n  \ N f XDDD<br>
	 * Message: &#29359;&#46;&#35215;<br>
	 * Message: RULE VIOLATION
	 */
	public static final NpcStringId RULE_VIOLATION;
	
	/**
	 * ID: 23062<br>
	 * Message:  ^ V m } P f XDDD<br>
	 * Message: &#25105;&#46;&#34987;&#46;&#25171;&#46;&#25943;&#46;&#20102;<br>
	 * Message: I LOSE
	 */
	public static final NpcStringId I_LOSE;
	
	/**
	 * ID: 23063<br>
	 * Message: ɂɂ`I<br>
	 * Message: &#21941;&#126;&#126;&#126;&#33;<br>
	 * Message: Whhiisshh!
	 */
	public static final NpcStringId WHHIISSHH;
	
	/**
	 * ID: 23065<br>
	 * Message: llA߂ɂ`I<br>
	 * Message: &#20027;&#20154;&#23565;&#19981;&#36215;&#33;<br>
	 * Message: I'm sorry, Lord!
	 */
	public static final NpcStringId IM_SORRY_LORD;
	
	/**
	 * ID: 23066<br>
	 * Message: ɂIтI<br>
	 * Message: &#20358;&#21543;&#33;&#19978;&#21543;&#33;<br>
	 * Message: Whish! Fight!
	 */
	public static final NpcStringId WHISH_FIGHT;
	
	/**
	 * ID: 23068<br>
	 * Message: ɂIllĂɂI<br>
	 * Message: &#36664;&#20102;&#33;&#20027;&#20154;&#23565;&#19981;&#36215;&#33;<br>
	 * Message: Lost! Sorry, Lord!
	 */
	public static final NpcStringId LOST_SORRY_LORD;
	
	/**
	 * ID: 23072<br>
	 * Message: ꂶAn߂Ƃ邩I<br>
	 * Message: &#37027;&#25105;&#20497;&#38283;&#22987;&#21543;&#33;<br>
	 * Message: So shall we start?!
	 */
	public static final NpcStringId SO_SHALL_WE_START;
	
	/**
	 * ID: 23074<br>
	 * Message: IƂ́I<br>
	 * Message: &#21487;&#24801;&#33;&#25105;&#31455;&#28982;&#36664;&#20102;&#46;&#46;&#46;&#33;<br>
	 * Message: Ugh! I lost...!
	 */
	public static final NpcStringId UGH_I_LOST;
	
	/**
	 * ID: 23075<br>
	 * Message: XɓÂĂI<br>
	 * Message: &#25105;&#26371;&#24930;&#24930;&#22577;&#20167;&#30340;&#33;<br>
	 * Message: I'll walk all over you!
	 */
	public static final NpcStringId ILL_WALK_ALL_OVER_YOU;
	
	/**
	 * ID: 23077<br>
	 * Message: IȔnȁI<br>
	 * Message: &#21487;&#24801;&#33;&#24590;&#40636;&#26371;&#36889;&#27171;&#33;<br>
	 * Message: Ugh! Can this be happening?!
	 */
	public static final NpcStringId UGH_CAN_THIS_BE_HAPPENING;
	
	/**
	 * ID: 23078<br>
	 * Message: ŘʂI<br>
	 * Message: &#36889;&#26159;&#30070;&#28982;&#30340;&#32080;&#26524;&#33;<br>
	 * Message: It's the natural result!
	 */
	public static final NpcStringId ITS_THE_NATURAL_RESULT;
	
	/**
	 * ID: 23079<br>
	 * Message: قف`ȈI<br>
	 * Message: &#32822;&#33;&#25105;&#36111;&#20102;&#33;<br>
	 * Message: Ho, ho! I win!
	 */
	public static final NpcStringId HO_HO_I_WIN;
	
	/**
	 * ID: 23080<br>
	 * Message:  ^ V m V  E  f XDDD<br>
	 * Message: &#25105;&#46;&#21213;&#46;&#21033;&#46;&#20102;<br>
	 * Message: I WIN
	 */
	public static final NpcStringId I_WIN;
	
	/**
	 * ID: 23081<br>
	 * Message: ɂIɂI<br>
	 * Message: &#32822;&#33;&#36111;&#20102;&#33;<br>
	 * Message: Whish! I won!
	 */
	public static final NpcStringId WHISH_I_WON;
	
	/**
	 * ID: 23434<br>
	 * Message: N̍MȏȂɗ~Ă̂I<br>
	 * Message: &#26159;&#35504;&#22312;&#36010;&#22294;&#25105;&#39640;&#36020;&#30340;&#32020;&#34880;&#65281;<br>
	 * Message: Who dares to try and steal my noble blood?
	 */
	public static final NpcStringId WHO_DARES_TO_TRY_AND_STEAL_MY_NOBLE_BLOOD;
	
	/**
	 * ID: 23651<br>
	 * Message: $s1IƉȁI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#32066;&#26044;&#35211;&#21040;&#21862;&#12290;<br>
	 * Message: $s1! Finally, we meet!
	 */
	public static final NpcStringId S1_FINALLY_WE_MEET;
	
	/**
	 * ID: 23652<br>
	 * Message: ӂށA͂ǂs񂾁H<br>
	 * Message: &#21756;&#65292;&#36889;&#26379;&#21451;&#36305;&#21040;&#21738;&#20818;&#21435;&#21862;&#65311;<br>
	 * Message: Hmm, where did my friend go?
	 */
	public static final NpcStringId HMM_WHERE_DID_MY_FRIEND_GO;
	
	/**
	 * ID: 23653<br>
	 * Message: ͂藊񂾂DDD<br>
	 * Message: &#21097;&#19979;&#30340;&#23601;&#20132;&#32102;&#20320;&#20102;&#46;&#46;&#46;<br>
	 * Message: Best of luck with your future endeavours.
	 */
	public static final NpcStringId BEST_OF_LUCK_WITH_YOUR_FUTURE_ENDEAVOURS;
	
	/**
	 * ID: 23661<br>
	 * Message: $s1IȂ҂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#31561;&#24456;&#20037;&#20102;&#21966;&#65311;<br>
	 * Message: $s1! Did you wait for long?
	 */
	public static final NpcStringId S1_DID_YOU_WAIT_FOR_LONG;
	
	/**
	 * ID: 23671<br>
	 * Message: Ɍꂽ͎ėB $s1<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#26377;&#24118;&#22238;&#25105;&#35201;&#27714;&#30340;&#26481;&#35199;&#21966;&#65311;<br>
	 * Message: Did you bring what I asked, $s1?
	 */
	public static final NpcStringId DID_YOU_BRING_WHAT_I_ASKED_S1;
	
	/**
	 * ID: 23681<br>
	 * Message: H߂ɒN̂B<br>
	 * Message: &#21999;&#65311;&#26377;&#20154;&#20358;&#21040;&#38468;&#36817;&#20102;&#21966;&#65311;<br>
	 * Message: Hmm? Is someone approaching?
	 */
	public static final NpcStringId HMM_IS_SOMEONE_APPROACHING;
	
	/**
	 * ID: 23682<br>
	 * Message: ȂƁAG̍UI<br>
	 * Message: &#31967;&#31957;&#65292;&#25973;&#20154;&#20837;&#20405;&#20102;&#65281;<br>
	 * Message: Graaah, we're being attacked!
	 */
	public static final NpcStringId GRAAAH_WERE_BEING_ATTACKED;
	
	/**
	 * ID: 23683<br>
	 * Message: 悵Bł͂藊񂾂B<br>
	 * Message: &#24456;&#22909;&#65292;&#37027;&#23601;&#25308;&#35351;&#20320;&#20102;&#12290;<br>
	 * Message: In that case, I wish you good luck.
	 */
	public static final NpcStringId IN_THAT_CASE_I_WISH_YOU_GOOD_LUCK;
	
	/**
	 * ID: 23685<br>
	 * Message: $s1ASTėB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#37117;&#25214;&#22238;&#20358;&#20102;&#21966;&#65311;<br>
	 * Message: $s1, has everything been found?
	 */
	public static final NpcStringId S1_HAS_EVERYTHING_BEEN_FOUND;
	
	/**
	 * ID: 23687<br>
	 * Message: ł́A܂I<br>
	 * Message: &#37027;&#40636;&#65292;&#24460;&#26371;&#26377;&#26399;&#21862;&#65281;<br>
	 * Message: Safe travels!
	 */
	public static final NpcStringId SAFE_TRAVELS;
	
	/**
	 * ID: 25901<br>
	 * Message: q̈˗<br>
	 * Message: &#29287;&#22580;&#20027;&#20154;&#30340;&#22996;&#35351;<br>
	 * Message: Request from the Farm Owner
	 */
	public static final NpcStringId REQUEST_FROM_THE_FARM_OWNER;
	
	/**
	 * ID: 31603<br>
	 * Message: ȂXeDDD<br>
	 * Message: &#28858;&#20160;&#40636;&#35201;&#37806;&#22739;&#25105;&#20497;&#46;&#46;&#46;&#65311;<br>
	 * Message: Why do you oppress us so?
	 */
	public static final NpcStringId WHY_DO_YOU_OPPRESS_US_SO;
	
	/**
	 * ID: 33409<br>
	 * Message: xƎ̋x̎זȁB<br>
	 * Message: &#21029;&#20877;&#22952;&#31001;&#25105;&#20241;&#24687;&#12290;<br>
	 * Message: Don't interrupt my rest again
	 */
	public static final NpcStringId DONT_INTERRUPT_MY_REST_AGAIN;
	
	/**
	 * ID: 33410<br>
	 * Message: ꂩ͂OO[g f[ LODDD<br>
	 * Message: &#24478;&#29694;&#22312;&#36215;&#20320;&#23601;&#26159;&#22823;&#39764;&#29579;&#46;&#46;&#46;<br>
	 * Message: You're a great devil now...
	 */
	public static final NpcStringId YOURE_A_GREAT_DEVIL_NOW;
	
	/**
	 * ID: 33411<br>
	 * Message: ͂莄̓Gł͂ȂAEnnnnI<br>
	 * Message: &#26524;&#28982;&#19981;&#26159;&#25105;&#30340;&#25973;&#25163;&#65292;&#21704;&#21704;&#21704;&#21704;&#65281;<br>
	 * Message: Oh, it's not an opponent of mine. Ha, ha, ha!
	 */
	public static final NpcStringId OH_ITS_NOT_AN_OPPONENT_OF_MINE_HA_HA_HA;
	
	/**
	 * ID: 33412<br>
	 * Message: OAO[g f[ LOlDDD<br>
	 * Message: &#22823;&#12289;&#22823;&#39764;&#29579;&#46;&#46;&#46;<br>
	 * Message: Oh... Great Demon King...
	 */
	public static final NpcStringId OH_GREAT_DEMON_KING;
	
	/**
	 * ID: 33413<br>
	 * Message: Q͖E̐ΎҁAZoEXlI<br>
	 * Message: &#39764;&#30028;&#30340;&#32085;&#23565;&#32773;&#26391;&#29791;&#24052;&#37324;&#22887;&#26031;&#23559;&#26371;&#22577;&#20167;&#65281;<br>
	 * Message: Revenge is Overlord Ramsebalius of the evil world!
	 */
	public static final NpcStringId REVENGE_IS_OVERLORD_RAMSEBALIUS_OF_THE_EVIL_WORLD;
	
	/**
	 * ID: 33414<br>
	 * Message: ̉qA{ipeEXlO𒦂炵߂邾낤I<br>
	 * Message: &#29001;&#29508;&#20043;&#29579;&#28196;&#32013;&#24052;&#29305;&#21214;&#26031;&#23559;&#25074;&#25106;&#20320;<br>
	 * Message: Bonaparterius, Abyss King, will punish you
	 */
	public static final NpcStringId BONAPARTERIUS_ABYSS_KING_WILL_PUNISH_YOU;
	
	/**
	 * ID: 33415<br>
	 * Message: FA؂ɋFȂI<br>
	 * Message: &#20358;&#65292;&#22823;&#23478;&#36843;&#20999;&#30340;&#31048;&#31153;&#21543;&#65281;<br>
	 * Message: OK, everybody pray fervently!
	 */
	public static final NpcStringId OK_EVERYBODY_PRAY_FERVENTLY;
	
	/**
	 * ID: 33416<br>
	 * Message: VɁIԂ̂łI<br>
	 * Message: &#26397;&#33879;&#22825;&#31354;&#65292;&#33289;&#36215;&#38617;&#25163;&#65281;&#22823;&#23478;&#19968;&#36215;&#22823;&#32882;&#21584;&#21898;&#21543;&#65281;<br>
	 * Message: Both hands to heaven! Everybody yell together!
	 */
	public static final NpcStringId BOTH_HANDS_TO_HEAVEN_EVERYBODY_YELL_TOGETHER;
	
	/**
	 * ID: 33417<br>
	 * Message: I肢抐I<br>
	 * Message: &#19968;&#33;&#20108;&#33;&#39000;&#26395;&#21834;&#65374;&#23526;&#29694;&#21543;&#65281;<br>
	 * Message: One! Two! May your dreams come true!
	 */
	public static final NpcStringId ONE_TWO_MAY_YOUR_DREAMS_COME_TRUE;
	
	/**
	 * ID: 33418<br>
	 * Message: ̃̕f[ LOÊ͒NH<br>
	 * Message: &#26159;&#35504;&#25171;&#27515;&#20102;&#25105;&#30340;&#19979;&#23660;&#39764;&#29579;&#65311;<br>
	 * Message: Who killed my underling devil?
	 */
	public static final NpcStringId WHO_KILLED_MY_UNDERLING_DEVIL;
	
	/**
	 * ID: 33420<br>
	 * Message: Ȃ̗Ă܂傤``<br>
	 * Message: &#35731;&#20320;&#25088;&#24859;&#25104;&#21151;&#126;&#24859;&#24859;&#24859;&#24773;&#126;<br>
	 * Message: I will make your love come true~ love, love, love~
	 */
	public static final NpcStringId I_WILL_MAKE_YOUR_LOVE_COME_TRUE_LOVE_LOVE_LOVE;
	
	/**
	 * ID: 33421<br>
	 * Message: ̒ɒmbl܂Ă܂BȎ͒mb̔`<br>
	 * Message: &#25105;&#25793;&#26377;&#26234;&#24935;&#12290;&#25105;&#26159;&#26234;&#24935;&#20043;&#30418;&#65281;<br>
	 * Message: I have wisdom in me. I am the box of wisdom!
	 */
	public static final NpcStringId I_HAVE_WISDOM_IN_ME_I_AM_THE_BOX_OF_WISDOM;
	
	/**
	 * ID: 33422<br>
	 * Message: NIIIII<br>
	 * Message: &#21703;&#21704;&#21704;&#21704;&#65281;<br>
	 * Message: Oh, oh, oh!
	 */
	public static final NpcStringId OH_OH_OH;
	
	/**
	 * ID: 33423<br>
	 * Message: Ă܂傤BEtB<br>
	 * Message: &#30495;&#30340;&#26371;&#24859;&#25105;&#20497;&#21966;&#65311;&#21621;&#21621;&#12290;<br>
	 * Message: Do you want us to love you? Oh.
	 */
	public static final NpcStringId DO_YOU_WANT_US_TO_LOVE_YOU_OH;
	
	/**
	 * ID: 33424<br>
	 * Message: Í̌NĂԎ҂͒NI<br>
	 * Message: &#35504;&#33213;&#25954;&#21628;&#21914;&#40657;&#26263;&#20043;&#29579;&#65281;<br>
	 * Message: Who is calling the Lord of Darkness!
	 */
	public static final NpcStringId WHO_IS_CALLING_THE_LORD_OF_DARKNESS;
	
	/**
	 * ID: 33425<br>
	 * Message: ͈̑ȂcqA{ipeEXI<br>
	 * Message: &#25105;&#26159;&#20553;&#22823;&#30340;&#29001;&#29508;&#20043;&#29579;&#65292;&#28196;&#32013;&#24052;&#29305;&#21214;&#26031;&#65281;<br>
	 * Message: I am a great empire, Bonaparterius!
	 */
	public static final NpcStringId I_AM_A_GREAT_EMPIRE_BONAPARTERIUS;
	
	/**
	 * ID: 33426<br>
	 * Message: ̐Ύ҂̑OɕI<br>
	 * Message: &#22312;&#32085;&#23565;&#32773;&#38754;&#21069;&#20302;&#38957;&#21543;&#65281;<br>
	 * Message: Let your head down before the Lord!
	 */
	public static final NpcStringId LET_YOUR_HEAD_DOWN_BEFORE_THE_LORD;
	
	/**
	 * ID: 33501<br>
	 * Message: n^[̉<br>
	 * Message: &#29557;&#20154;&#20043;&#27468;<br>
	 * Message: The Song of the Hunter
	 */
	public static final NpcStringId THE_SONG_OF_THE_HUNTER;
	
	/**
	 * ID: 33511<br>
	 * Message: ̂̒鍑̈Y͉XčsI<br>
	 * Message: &#25105;&#20497;&#23559;&#26371;&#25226;&#21476;&#20195;&#24093;&#22283;&#30340;&#36986;&#29986;&#24118;&#36208;&#65281;<br>
	 * Message: We'll take the property of the ancient empire!
	 */
	public static final NpcStringId WELL_TAKE_THE_PROPERTY_OF_THE_ANCIENT_EMPIRE;
	
	/**
	 * ID: 33512<br>
	 * Message: YȌ镨oIS̕I<br>
	 * Message: &#23559;&#28418;&#20142;&#30340;&#38275;&#32768;&#29664;&#23542;&#25343;&#20986;&#20358;&#65281;&#37117;&#26159;&#25105;&#30340;&#65281;<br>
	 * Message: Show me the pretty sparkling things! They're all mine!
	 */
	public static final NpcStringId SHOW_ME_THE_PRETTY_SPARKLING_THINGS_THEYRE_ALL_MINE;
	
	/**
	 * ID: 33513<br>
	 * Message: I<br>
	 * Message: &#21571;&#65281;<br>
	 * Message: Pretty good!
	 */
	public static final NpcStringId PRETTY_GOOD;
	
	/**
	 * ID: 34830<br>
	 * Message: tttDDDʔBJM͎̂܂Ȃ{Ă݂邱ƂB<br>
	 * Message: &#21628;&#21628;&#46;&#46;&#46;&#30495;&#22909;&#29609;&#12290;&#33267;&#26044;&#38000;&#21273;&#65292;&#23601;&#32763;&#30475;&#23629;&#39636;&#21543;&#65281;<br>
	 * Message: Ha, that was fun! If you wish to find the key, search the corpse.
	 */
	public static final NpcStringId HA_THAT_WAS_FUN_IF_YOU_WISH_TO_FIND_THE_KEY_SEARCH_THE_CORPSE;
	
	/**
	 * ID: 34831<br>
	 * Message: JM͎ĂBقȂA͐sŒDI<br>
	 * Message: &#38000;&#21273;&#22312;&#25105;&#36889;&#35041;&#65292;&#24819;&#20197;&#21147;&#37327;&#25654;&#22890;&#23427;&#21966;&#65311;<br>
	 * Message: I have the key. Why don't you come and take it?
	 */
	public static final NpcStringId I_HAVE_THE_KEY_WHY_DONT_YOU_COME_AND_TAKE_IT;
	
	/**
	 * ID: 34832<br>
	 * Message: ȁDDD_A̎҂DDD<br>
	 * Message: &#30495;&#24858;&#37389;&#46;&#46;&#46;&#31070;&#21834;&#65292;&#23559;&#20182;&#20497;&#46;&#46;&#46;<br>
	 * Message: You fools will get what's coming to you!
	 */
	public static final NpcStringId YOU_FOOLS_WILL_GET_WHATS_COMING_TO_YOU;
	
	/**
	 * ID: 34833<br>
	 * Message: cOAO̖DȂ΂ȂB<br>
	 * Message: &#46;&#46;&#46;&#25105;&#20063;&#35258;&#24471;&#24456;&#36986;&#25022;&#65292;&#20294;&#26159;&#25105;&#24471;&#21462;&#19979;&#20320;&#20497;&#30340;&#24615;&#21629;&#12290;<br>
	 * Message: Sorry about this, but I must kill you now.
	 */
	public static final NpcStringId SORRY_ABOUT_THIS_BUT_I_MUST_KILL_YOU_NOW;
	
	/**
	 * ID: 34835<br>
	 * Message: O͒mȂDDD7́̕DDDOzbI<br>
	 * Message: &#20320;&#20497;&#19981;&#30693;&#36947;&#46;&#46;&#46;&#19971;&#20491;&#23553;&#21360;&#26159;&#46;&#46;&#46;&#21683;&#65281;<br>
	 * Message: You guys wouldn't know... the seven seals are... Arrrgh!
	 */
	public static final NpcStringId YOU_GUYS_WOULDNT_KNOW_THE_SEVEN_SEALS_ARE_ARRRGH;
	
	/**
	 * ID: 34836<br>
	 * Message: ̎RǑŕsĂ낤I<br>
	 * Message: &#25105;&#23559;&#20197;&#20320;&#20497;&#30340;&#34880;&#20358;&#35206;&#33995;&#36889;&#24231;&#23665;&#65281;<br>
	 * Message: I shall drench this mountain with your blood!
	 */
	public static final NpcStringId I_SHALL_DRENCH_THIS_MOUNTAIN_WITH_YOUR_BLOOD;
	
	/**
	 * ID: 34837<br>
	 * Message: Ȃɂłił͂ȂB悢B<br>
	 * Message: &#36889;&#19981;&#26159;&#23660;&#26044;&#20320;&#20497;&#30340;&#26481;&#35199;&#12290;&#25226;&#25163;&#25343;&#38283;&#12290;<br>
	 * Message: That doesn't belong to you. Don't touch it!
	 */
	public static final NpcStringId THAT_DOESNT_BELONG_TO_YOU_DONT_TOUCH_IT;
	
	/**
	 * ID: 34838<br>
	 * Message: sM҂߁I邪悢I<br>
	 * Message: &#19981;&#20449;&#32773;&#65281;&#28414;&#38283;&#65281;<br>
	 * Message: Get out of my sight, you infidels!
	 */
	public static final NpcStringId GET_OUT_OF_MY_SIGHT_YOU_INFIDELS;
	
	/**
	 * ID: 34839<br>
	 * Message: Nɂ͂ȏp͂ȂDDD̂ɂ錮͒TĂ݂B<br>
	 * Message: &#38614;&#28982;&#24050;&#27794;&#20160;&#40636;&#20107;&#35201;&#25214;&#20320;&#20102;&#8230;&#20294;&#26159;&#26377;&#25214;&#36942;&#23629;&#39636;&#19978;&#30340;&#38000;&#21273;&#21966;&#65311;<br>
	 * Message: We don't have any further business to discuss... Have you searched the corpse for the key?
	 */
	public static final NpcStringId WE_DONT_HAVE_ANY_FURTHER_BUSINESS_TO_DISCUSS_HAVE_YOU_SEARCHED_THE_CORPSE_FOR_THE_KEY;
	
	/**
	 * ID: 35051<br>
	 * Message: $s1AXebv $s2̃u[ \E Xg[ɓ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#29554;&#24471;&#20102;&#38542;&#27573;&#12300;&#36;&#115;&#50;&#12301;&#30340;&#34253;&#33394;&#25628;&#39746;&#30707;&#12290;<br>
	 * Message: $s1 has earned a stage $s2 Blue Soul Crystal.
	 */
	public static final NpcStringId S1_HAS_EARNED_A_STAGE_S2_BLUE_SOUL_CRYSTAL;
	
	/**
	 * ID: 35052<br>
	 * Message: $s1AXebv $s2̃bh \E Xg[ɓ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#29554;&#24471;&#20102;&#38542;&#27573;&#12300;&#36;&#115;&#50;&#12301;&#30340;&#32005;&#33394;&#25628;&#39746;&#30707;&#12290;<br>
	 * Message: $s1 has earned a stage $s2 Red Soul Crystal.
	 */
	public static final NpcStringId S1_HAS_EARNED_A_STAGE_S2_RED_SOUL_CRYSTAL;
	
	/**
	 * ID: 35053<br>
	 * Message: $s1AXebv $s2̃O[ \E Xg[ɓ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#29554;&#24471;&#20102;&#38542;&#27573;&#12300;&#36;&#115;&#50;&#12301;&#30340;&#32160;&#33394;&#25628;&#39746;&#30707;&#12290;<br>
	 * Message: $s1 has earned a stage $s2 Green Soul Crystal.
	 */
	public static final NpcStringId S1_HAS_EARNED_A_STAGE_S2_GREEN_SOUL_CRYSTAL;
	
	/**
	 * ID: 35054<br>
	 * Message: $s1AXebv $s2̎ꂽu[ \E Xg[ɓ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#24471;&#21040;&#20102;&#31532;&#12300;&#36;&#115;&#50;&#12301;&#38542;&#27573;&#30340;&#21463;&#35419;&#21650;&#30340;&#34253;&#33394;&#25628;&#39746;&#30707;&#12290;<br>
	 * Message: $s1 has earned a Stage $s2 Blue Cursed Soul Crystal.
	 */
	public static final NpcStringId S1_HAS_EARNED_A_STAGE_S2_BLUE_CURSED_SOUL_CRYSTAL;
	
	/**
	 * ID: 35055<br>
	 * Message: $s1AXebv $s2̎ꂽbh \E Xg[ɓ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#24471;&#21040;&#20102;&#31532;&#12300;&#36;&#115;&#50;&#12301;&#38542;&#27573;&#30340;&#21463;&#35419;&#21650;&#30340;&#32005;&#33394;&#25628;&#39746;&#30707;&#12290;<br>
	 * Message: $s1 has earned a Stage $s2 Red Cursed Soul Crystal.
	 */
	public static final NpcStringId S1_HAS_EARNED_A_STAGE_S2_RED_CURSED_SOUL_CRYSTAL;
	
	/**
	 * ID: 35056<br>
	 * Message: $s1AXebv $s2̎ꂽO[ \E Xg[ɓ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#24471;&#21040;&#20102;&#31532;&#12300;&#36;&#115;&#50;&#12301;&#38542;&#27573;&#30340;&#21463;&#35419;&#21650;&#30340;&#32160;&#33394;&#25628;&#39746;&#30707;&#12290;<br>
	 * Message: $s1 has earned a Stage $s2 Green Cursed Soul Crystal.
	 */
	public static final NpcStringId S1_HAS_EARNED_A_STAGE_S2_GREEN_CURSED_SOUL_CRYSTAL;
	
	/**
	 * ID: 37101<br>
	 * Message: 썰̋<br>
	 * Message: &#39746;&#38728;&#20497;&#30340;&#21741;&#32882;<br>
	 * Message: Shrieks of Ghosts
	 */
	public static final NpcStringId SHRIEKS_OF_GHOSTS;
	
	/**
	 * ID: 38451<br>
	 * Message: $s1Ԗڂ̊ԁF$s2I<br>
	 * Message: &#31532;&#12300;&#36;&#115;&#49;&#12301;&#26684;&#65306;&#12300;&#36;&#115;&#50;&#12301;<br>
	 * Message: Slot $s1: $s2
	 */
	public static final NpcStringId SLOT_S1_S3;
	
	/**
	 * ID: 40306<br>
	 * Message: ̐˂A߂܂邾āH<br>
	 * Message: &#20083;&#33261;&#26410;&#20094;&#30340;&#23567;&#23376;&#65292;&#24977;&#20320;&#20063;&#24819;&#25235;&#25105;&#65311;<br>
	 * Message: You childish fool, do you think you can catch me?
	 */
	public static final NpcStringId YOU_CHILDISH_FOOL_DO_YOU_THINK_YOU_CAN_CATCH_ME;
	
	/**
	 * ID: 40307<br>
	 * Message: ̋J͕KDDD<br>
	 * Message: &#25105;&#19968;&#23450;&#26371;&#27927;&#21047;&#36889;&#20491;&#24677;&#36785;&#46;&#46;&#46;<br>
	 * Message: I must do something about this shameful incident...
	 */
	public static final NpcStringId I_MUST_DO_SOMETHING_ABOUT_THIS_SHAMEFUL_INCIDENT;
	
	/**
	 * ID: 40308<br>
	 * Message: A킷Ƃł̂IH<br>
	 * Message: &#20160;&#40636;&#65311;&#20320;&#31455;&#25954;&#21521;&#25105;&#25361;&#25136;&#33;<br>
	 * Message: What, do you dare to challenge me!
	 */
	public static final NpcStringId WHAT_DO_YOU_DARE_TO_CHALLENGE_ME;
	
	/**
	 * ID: 40309<br>
	 * Message: bhACRc̕Q҂ĂI<br>
	 * Message: &#36196;&#30524;&#23665;&#36042;&#22296;&#24517;&#26371;&#24489;&#20167;&#30340;&#33;<br>
	 * Message: The red-eyed thieves will revenge!
	 */
	public static final NpcStringId THE_RED_EYED_THIEVES_WILL_REVENGE;
	
	/**
	 * ID: 40310<br>
	 * Message: ėA̐ˁI<br>
	 * Message: &#20760;&#31649;&#20358;&#21543;&#65292;&#20083;&#33261;&#26410;&#20094;&#30340;&#23567;&#23376;&#33;<br>
	 * Message: Go ahead, you child!
	 */
	public static final NpcStringId GO_AHEAD_YOU_CHILD;
	
	/**
	 * ID: 40311<br>
	 * Message: ̒ԂKQDDD<br>
	 * Message: &#25105;&#30340;&#20249;&#20276;&#23450;&#26371;&#24171;&#25105;&#22577;&#20167;&#46;&#46;&#46;<br>
	 * Message: My friends are sure to revenge!
	 */
	public static final NpcStringId MY_FRIENDS_ARE_SURE_TO_REVENGE;
	
	/**
	 * ID: 40312<br>
	 * Message: ̕|̒m炸߁AɂڂɑI<br>
	 * Message: &#20320;&#36889;&#24858;&#26151;&#30340;&#23567;&#23376;&#65292;&#35731;&#25105;&#21578;&#35380;&#20320;&#20160;&#40636;&#25165;&#26159;&#30495;&#27491;&#30340;&#25136;&#39717;&#33;<br>
	 * Message: You ruthless fool, I will show you what real fighting is all about!
	 */
	public static final NpcStringId YOU_RUTHLESS_FOOL_I_WILL_SHOW_YOU_WHAT_REAL_FIGHTING_IS_ALL_ABOUT;
	
	/**
	 * ID: 40313<br>
	 * Message: AȌ`ŏIƂ́DDDOI<br>
	 * Message: &#21978;&#65292;&#23621;&#28982;&#23601;&#36889;&#40636;&#27515;&#20102;&#46;&#46;&#46;&#30495;&#19981;&#20844;&#24179;&#21834;&#33;<br>
	 * Message: Ahh, how can it end like this... it is not fair!
	 */
	public static final NpcStringId AHH_HOW_CAN_IT_END_LIKE_THIS_IT_IS_NOT_FAIR;
	
	/**
	 * ID: 40909<br>
	 * Message: ͉̂̂I<br>
	 * Message: &#32854;&#28779;&#26159;&#25105;&#20497;&#30340;&#33;&#33;<br>
	 * Message: The sacred flame is ours!
	 */
	public static final NpcStringId THE_SACRED_FLAME_IS_OURS;
	
	/**
	 * ID: 40910<br>
	 * Message: NbA߂邵ȂDDD<br>
	 * Message: &#21834;&#46;&#46;&#46;&#25105;&#20497;&#19981;&#26371;&#46;&#46;&#46;&#25918;&#26820;&#46;&#46;&#46;<br>
	 * Message: Arrghh...we shall never.. surrender...
	 */
	public static final NpcStringId ARRGHHWE_SHALL_NEVER_SURRENDER;
	
	/**
	 * ID: 40913<br>
	 * Message: ߂ɏ]܂AllI<br>
	 * Message: &#20027;&#20154;&#65292;&#22914;&#24744;&#25152;&#39000;&#33;<br>
	 * Message: As you wish, master!
	 */
	public static final NpcStringId AS_YOU_WISH_MASTER;
	
	/**
	 * ID: 41651<br>
	 * Message: ɗEA$s1́I<br>
	 * Message: &#46;&#46;&#46;&#46;&#46;&#46;&#46;&#65281;&#20808;&#36208;&#19968;&#27493;&#30340;&#21516;&#32990;&#21834;&#65292;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#46;&#46;&#46;&#46;&#46;&#46;&#65281;<br>
	 * Message: My dear friend of $s1, who has gone on ahead of me!
	 */
	public static final NpcStringId MY_DEAR_FRIEND_OF_S1_WHO_HAS_GONE_ON_AHEAD_OF_ME;
	
	/**
	 * ID: 41652<br>
	 * Message: I҂IfWJ KWIpT[̍$s1ĂłI<br>
	 * Message: &#20670;&#32893;&#21543;&#65292;&#24180;&#36629;&#30340;&#20800;&#32645;&#21345;&#21834;&#65281;&#37941;&#36040;&#21345;&#21202;&#32;&#29976;&#22320;&#65281;&#20498;&#19979;&#30340;&#35961;&#20043;&#39746;&#38728;&#27491;&#21628;&#21914;&#33879;&#12300;&#36;&#115;&#49;&#12301;&#20320;&#21602;&#65281;<br>
	 * Message: Listen to Tejakar Gandi, young Oroka! The spirit of the slain leopard is calling you, $s1!
	 */
	public static final NpcStringId LISTEN_TO_TEJAKAR_GANDI_YOUNG_OROKA_THE_SPIRIT_OF_THE_SLAIN_LEOPARD_IS_CALLING_YOU_S1;
	
	/**
	 * ID: 42046<br>
	 * Message: NEbI݂Ȃŗ̂I<br>
	 * Message: &#21710;&#21568;&#65281;&#22823;&#23478;&#37117;&#22533;&#23432;&#33879;&#34507;&#65281;<br>
	 * Message: Hey! Everybody watch the eggs!
	 */
	public static final NpcStringId HEY_EVERYBODY_WATCH_THE_EGGS;
	
	/**
	 * ID: 42047<br>
	 * Message: ňׂłƎvDDDNNbI<br>
	 * Message: &#25105;&#20197;&#28858;&#35201;&#30332;&#22823;&#36001;&#20102;&#21602;&#8230;&#22079;&#32;&#63;&#65281;<br>
	 * Message: I thought I'd caught one share... Whew!
	 */
	public static final NpcStringId I_THOUGHT_ID_CAUGHT_ONE_SHARE_WHEW;
	
	/**
	 * ID: 42048<br>
	 * Message: ΂DDDd΂DDDӂāDDD<br>
	 * Message: &#30707;&#46;&#46;&#46;&#22934;&#31934;&#30707;&#46;&#46;&#46;&#30772;&#30862;&#20102;&#46;&#46;&#46;<br>
	 * Message: The stone... the Elven stone... broke...
	 */
	public static final NpcStringId THE_STONE_THE_ELVEN_STONE_BROKE;
	
	/**
	 * ID: 42049<br>
	 * Message: DꂽAX͎ʉ^I <br>
	 * Message: &#34507;&#33509;&#34987;&#22890;&#36208;&#65292;&#25105;&#20497;&#23601;&#27515;&#23450;&#20102;&#65281;<br>
	 * Message: If the eggs get taken, we're dead!
	 */
	public static final NpcStringId IF_THE_EGGS_GET_TAKEN_WERE_DEAD;
	
	/**
	 * ID: 42111<br>
	 * Message: d̗tI<br>
	 * Message: &#32102;&#25105;&#22934;&#31934;&#30340;&#33865;&#23376;&#46;&#46;&#46;&#65281;<br>
	 * Message: Give me a Fairy Leaf...!
	 */
	public static final NpcStringId GIVE_ME_A_FAIRY_LEAF;
	
	/**
	 * ID: 42112<br>
	 * Message: Ȃ܂ɂ܂Ƃ񂾁H<br>
	 * Message: &#24185;&#22043;&#21448;&#29033;&#25105;&#65311;<br>
	 * Message: Why do you bother me again?
	 */
	public static final NpcStringId WHY_DO_YOU_BOTHER_ME_AGAIN;
	
	/**
	 * ID: 42113<br>
	 * Message: ڂAO͂̐񂾁B<br>
	 * Message: &#23567;&#39740;&#21834;&#46;&#46;&#46;&#20320;&#24050;&#32147;&#21917;&#20102;&#39080;&#20043;&#31934;&#27700;&#12290;<br>
	 * Message: Hey, you've already drunk the essence of wind!
	 */
	public static final NpcStringId HEY_YOUVE_ALREADY_DRUNK_THE_ESSENCE_OF_WIND;
	
	/**
	 * ID: 42114<br>
	 * Message: sB҂̍|߂ɑ킳OɁDDD<br>
	 * Message: &#24555;&#36208;&#21543;&#65281;&#36225;&#36996;&#27794;&#26377;&#34987;&#23432;&#35703;&#32773;&#39746;&#38728;&#32629;&#20043;&#21069;&#46;&#46;&#46;<br>
	 * Message: Leave now, before you incur the wrath of the guardian ghost...
	 */
	public static final NpcStringId LEAVE_NOW_BEFORE_YOU_INCUR_THE_WRATH_OF_THE_GUARDIAN_GHOST;
	
	/**
	 * ID: 42115<br>
	 * Message: ڂAO͂̐񂾁B<br>
	 * Message: &#23567;&#39740;&#21834;&#46;&#46;&#46;&#20320;&#24050;&#32147;&#21917;&#20102;&#26143;&#20043;&#31934;&#27700;&#12290;<br>
	 * Message: Hey, you've already drunk the essence of a star!
	 */
	public static final NpcStringId HEY_YOUVE_ALREADY_DRUNK_THE_ESSENCE_OF_A_STAR;
	
	/**
	 * ID: 42116<br>
	 * Message: ڂAO͂̐񂾁B<br>
	 * Message: &#23567;&#39740;&#21834;&#46;&#46;&#46;&#20320;&#24050;&#32147;&#21917;&#20102;&#40643;&#26127;&#20043;&#31934;&#27700;&#12290;<br>
	 * Message: Hey, you've already drunk the essence of dusk!
	 */
	public static final NpcStringId HEY_YOUVE_ALREADY_DRUNK_THE_ESSENCE_OF_DUSK;
	
	/**
	 * ID: 42117<br>
	 * Message: ڂAO͂ArX̐񂾁B<br>
	 * Message: &#23567;&#39740;&#21834;&#46;&#46;&#46;&#20320;&#24050;&#32147;&#21917;&#20102;&#28145;&#28149;&#20043;&#31934;&#27700;&#12290;<br>
	 * Message: Hey, you've already drunk the essence of the abyss!
	 */
	public static final NpcStringId HEY_YOUVE_ALREADY_DRUNK_THE_ESSENCE_OF_THE_ABYSS;
	
	/**
	 * ID: 42118<br>
	 * Message: X͗d؂˂΂ȂȂB<br>
	 * Message: &#25105;&#20497;&#24517;&#38920;&#23432;&#20303;&#22934;&#31934;&#26408;&#12290;<br>
	 * Message: We must protect the fairy tree!
	 */
	public static final NpcStringId WE_MUST_PROTECT_THE_FAIRY_TREE;
	
	/**
	 * ID: 42119<br>
	 * Message: sȎ҂AȂ؂痣B<br>
	 * Message: &#19981;&#36556;&#20043;&#24466;&#65292;&#38626;&#31070;&#32854;&#30340;&#27193;&#36960;&#19968;&#40670;&#12290;<br>
	 * Message: Get out of the sacred tree, you scoundrels!
	 */
	public static final NpcStringId GET_OUT_OF_THE_SACRED_TREE_YOU_SCOUNDRELS;
	
	/**
	 * ID: 42120<br>
	 * Message: E̐𓐂Ƃ铐𐬔sĂDDD<br>
	 * Message: &#27578;&#27515;&#24819;&#20599;&#21462;&#19990;&#30028;&#31934;&#27700;&#30340;&#30428;&#36042;&#20497;&#46;&#46;&#46;<br>
	 * Message: Death to the thieves of the pure water of the world!
	 */
	public static final NpcStringId DEATH_TO_THE_THIEVES_OF_THE_PURE_WATER_OF_THE_WORLD;
	
	/**
	 * ID: 42231<br>
	 * Message: AZȈKvȂ悤ȁH<br>
	 * Message: &#21890;&#65281;&#20804;&#24351;&#65281;&#30475;&#20358;&#38656;&#35201;&#25105;&#30340;&#24171;&#21161;&#21908;&#65311;<br>
	 * Message: Hey, it seems like you need my help, doesn't it?
	 */
	public static final NpcStringId HEY_IT_SEEMS_LIKE_YOU_NEED_MY_HELP_DOESNT_IT;
	
	/**
	 * ID: 42232<br>
	 * Message: ǂւłtčsIɂĂN\bA̎ƂȁI<br>
	 * Message: &#36889;&#40636;&#19968;&#25289;&#126;&#23601;&#26371;&#36942;&#20358;&#65281;&#21487;&#24801;&#65281;&#21487;&#24801;&#30340;&#25163;&#37548;&#65281;<br>
	 * Message: Almost got it... Ouch! Stop! Damn these bloody manacles!
	 */
	public static final NpcStringId ALMOST_GOT_IT_OUCH_STOP_DAMN_THESE_BLOODY_MANACLES;
	
	/**
	 * ID: 42233<br>
	 * Message: ɂIɉ߂邼I͂Ђǂɂ񂾁I<br>
	 * Message: &#24456;&#30140;&#65281;&#24456;&#30140;&#65281;&#20804;&#24351;&#65292;&#25105;&#30140;&#24471;&#35201;&#21629;&#126;&#65281;<br>
	 * Message: Oh, that smarts!
	 */
	public static final NpcStringId OH_THAT_SMARTS;
	
	/**
	 * ID: 42234<br>
	 * Message: A}X^[IĂ񂶂˂I񂾂I<br>
	 * Message: &#21890;&#65281;&#20027;&#20154;&#65281;&#27880;&#24847;&#19968;&#19979;&#65281;&#37027;&#20491;&#20642;&#20249;&#25171;&#25105;&#27448;&#65281;<br>
	 * Message: Hey, master! Pay attention! I'm dying over here!
	 */
	public static final NpcStringId HEY_MASTER_PAY_ATTENTION_IM_DYING_OVER_HERE;
	
	/**
	 * ID: 42235<br>
	 * Message: ̉Ƃ񂾁I<br>
	 * Message: &#20320;&#24185;&#22043;&#25171;&#25105;&#65281;&#25105;&#21738;&#35023;&#37679;&#20102;&#65281;<br>
	 * Message: What have I done to deserve this?
	 */
	public static final NpcStringId WHAT_HAVE_I_DONE_TO_DESERVE_THIS;
	
	/**
	 * ID: 42236<br>
	 * Message: ͂͂A債񂾁A˂IŁAǂ񂾂H<br>
	 * Message: &#20570;&#24471;&#22909;&#65281;&#20570;&#24471;&#30495;&#126;&#22909;&#65281;&#29694;&#22312;&#35442;&#24590;&#40636;&#36774;&#126;&#65311;<br>
	 * Message: Oh, this is just great! What are you going to do now?
	 */
	public static final NpcStringId OH_THIS_IS_JUST_GREAT_WHAT_ARE_YOU_GOING_TO_DO_NOW;
	
	/**
	 * ID: 42237<br>
	 * Message: oJIO̓}kPBl̖ʓ|ƌȂ̂H<br>
	 * Message: &#31528;&#34507;&#65281;&#30333;&#30305;&#65281;&#36899;&#25105;&#19968;&#20491;&#20154;&#37117;&#20445;&#35703;&#19981;&#22909;&#21966;&#65311;&#65281;<br>
	 * Message: You inconsiderate moron! Can't you even take care of little old me?!
	 */
	public static final NpcStringId YOU_INCONSIDERATE_MORON_CANT_YOU_EVEN_TAKE_CARE_OF_LITTLE_OLD_ME;
	
	/**
	 * ID: 42238<br>
	 * Message: PbIV C[^[SI܍߂ɂ͂܂܂ȁI<br>
	 * Message: &#21756;&#65281;&#22124;&#32618;&#32773;&#27515;&#20129;&#65281;&#38626;&#36118;&#32618;&#36996;&#26089;&#30340;&#24456;&#21602;&#126;&#65281;<br>
	 * Message: Oh no! The man who eats one's sins has died! Penitence is further away~!
	 */
	public static final NpcStringId OH_NO_THE_MAN_WHO_EATS_ONES_SINS_HAS_DIED_PENITENCE_IS_FURTHER_AWAY;
	
	/**
	 * ID: 42239<br>
	 * Message: XLHȏłނ݂ɎgÅCɂȂ邺I<br>
	 * Message: &#29305;&#27530;&#25216;&#24039;&#65311;&#22312;&#36889;&#31278;&#22320;&#26041;&#20098;&#29992;&#65292;&#26371;&#35722;&#25104;&#34880;&#28023;&#21737;&#126;&#65281;<br>
	 * Message: Using a special skill here could trigger a bloodbath!
	 */
	public static final NpcStringId USING_A_SPECIAL_SKILL_HERE_COULD_TRIGGER_A_BLOODBATH;
	
	/**
	 * ID: 42240<br>
	 * Message: AZIɈ̉҂Ă񂾁H<br>
	 * Message: &#21890;&#65281;&#20804;&#24351;&#65281;&#20320;&#21040;&#24213;&#23565;&#25105;&#26399;&#24453;&#20123;&#20160;&#40636;&#65311;<br>
	 * Message: Hey, what do you expect of me?
	 */
	public static final NpcStringId HEY_WHAT_DO_YOU_EXPECT_OF_ME;
	
	/**
	 * ID: 42241<br>
	 * Message: ႠIIIAočsȂI<br>
	 * Message: &#21628;&#21703;&#21834;&#65281;&#21628;&#21862;&#65281;&#21628;&#21862;&#65281;&#27794;&#21453;&#25033;&#21834;&#65311;<br>
	 * Message: Ugggggh! Push! It's not coming out!
	 */
	public static final NpcStringId UGGGGGH_PUSH_ITS_NOT_COMING_OUT;
	
	/**
	 * ID: 42242<br>
	 * Message: AOꂿ܂I<br>
	 * Message: &#21834;&#65292;&#27794;&#26377;&#25802;&#20013;&#126;&#65281;<br>
	 * Message: Ah, I missed the mark!
	 */
	public static final NpcStringId AH_I_MISSED_THE_MARK;
	
	/**
	 * ID: 42243<br>
	 * Message: IDDDދBǂsI<br>
	 * Message: &#21834;&#21834;&#126;&#21834;&#65281;&#28961;&#32842;&#27515;&#20102;&#65292;&#21435;&#21029;&#30340;&#22320;&#26041;&#21543;&#65281;<br>
	 * Message: Yawwwwn! It's so boring here. We should go and find some action!
	 */
	public static final NpcStringId YAWWWWN_ITS_SO_BORING_HERE_WE_SHOULD_GO_AND_FIND_SOME_ACTION;
	
	/**
	 * ID: 42244<br>
	 * Message: AZIȂƂĂA܂łĂ܍߂IȂB<br>
	 * Message: &#21890;&#65281;&#20804;&#24351;&#65281;&#20320;&#36889;&#27171;&#35201;&#21040;&#20160;&#40636;&#26178;&#20505;&#25165;&#33021;&#23436;&#25104;&#36118;&#32618;&#21602;&#65311;<br>
	 * Message: Hey, if you continue to waste time you will never finish your penance!
	 */
	public static final NpcStringId HEY_IF_YOU_CONTINUE_TO_WASTE_TIME_YOU_WILL_NEVER_FINISH_YOUR_PENANCE;
	
	/**
	 * ID: 42245<br>
	 * Message: O͉Ȃ񂾂H悤ɉÔƂȂ񂾂I<br>
	 * Message: &#25105;&#30693;&#36947;&#20320;&#35342;&#21421;&#25105;&#21862;&#65281;&#21487;&#25105;&#20063;&#35342;&#21421;&#20320;&#32822;&#65281;<br>
	 * Message: I know you don't like me. The feeling is mutual!
	 */
	public static final NpcStringId I_KNOW_YOU_DONT_LIKE_ME_THE_FEELING_IS_MUTUAL;
	
	/**
	 * ID: 42246<br>
	 * Message: GNgvY L[ŁAt肽Ƃ낾B<br>
	 * Message: &#30495;&#24819;&#21917;&#26479;&#24456;&#28872;&#30340;&#27580;&#37202;&#12290;<br>
	 * Message: I need a drink.
	 */
	public static final NpcStringId I_NEED_A_DRINK;
	
	/**
	 * ID: 42247<br>
	 * Message: ADDDȂƂł́AVׂ̕ĉOɁAƂɋAł͂ȂB<br>
	 * Message: &#30495;&#24930;&#32822;&#46;&#46;&#46;&#36889;&#27171;&#30340;&#35441;&#65292;&#22312;&#35299;&#38500;&#19971;&#20491;&#23553;&#21360;&#20043;&#21069;&#26159;&#19981;&#33021;&#22238;&#23478;&#30340;&#21862;&#65281;<br>
	 * Message: Oh, this is dragging on too long... At this rate I won't make it home before the seven seals are broken.
	 */
	public static final NpcStringId OH_THIS_IS_DRAGGING_ON_TOO_LONG_AT_THIS_RATE_I_WONT_MAKE_IT_HOME_BEFORE_THE_SEVEN_SEALS_ARE_BROKEN;
	
	/**
	 * ID: 45650<br>
	 * Message: $s1͂ɂȂACe$s2󂯎܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24478;&#20998;&#38626;&#30340;&#38728;&#39746;&#24471;&#21040;&#20102;&#12300;&#36;&#115;&#50;&#12301;&#36947;&#20855;&#20316;&#28858;&#29518;&#21237;&#12290;<br>
	 * Message: $s1 received a $s2 item as a reward from the separated soul.
	 */
	public static final NpcStringId S1_RECEIVED_A_S2_ITEM_AS_A_REWARD_FROM_THE_SEPARATED_SOUL;
	
	/**
	 * ID: 45651<br>
	 * Message: 󂳂ꂽo[yX w<br>
	 * Message: &#23553;&#21360;&#30340;&#21338;&#20329;&#26031;&#38957;&#30420;<br>
	 * Message: Sealed Vorpal Helmet
	 */
	public static final NpcStringId SEALED_VORPAL_HELMET;
	
	/**
	 * ID: 45652<br>
	 * Message: 󂳂ꂽo[yX U[ w<br>
	 * Message: &#23553;&#21360;&#30340;&#21338;&#20329;&#26031;&#30382;&#38957;&#30420;<br>
	 * Message: Sealed Vorpal Leather Helmet
	 */
	public static final NpcStringId SEALED_VORPAL_LEATHER_HELMET;
	
	/**
	 * ID: 45653<br>
	 * Message: 󂳂ꂽo[yX T[Nbg<br>
	 * Message: &#23553;&#21360;&#30340;&#21338;&#20329;&#26031;&#38957;&#31629;<br>
	 * Message: Sealed Vorpal Circlet
	 */
	public static final NpcStringId SEALED_VORPAL_CIRCLET;
	
	/**
	 * ID: 45654<br>
	 * Message: 󂳂ꂽo[yX uXg v[g<br>
	 * Message: &#23553;&#21360;&#30340;&#21338;&#20329;&#26031;&#33016;&#30002;<br>
	 * Message: Sealed Vorpal Breastplate
	 */
	public static final NpcStringId SEALED_VORPAL_BREASTPLATE;
	
	/**
	 * ID: 45655<br>
	 * Message: 󂳂ꂽo[yX U[ v[g<br>
	 * Message: &#23553;&#21360;&#30340;&#21338;&#20329;&#26031;&#30382;&#33016;&#30002;<br>
	 * Message: Sealed Vorpal Leather Breastplate
	 */
	public static final NpcStringId SEALED_VORPAL_LEATHER_BREASTPLATE;
	
	/**
	 * ID: 45656<br>
	 * Message: 󂳂ꂽo[yX `[jbN<br>
	 * Message: &#23553;&#21360;&#30340;&#21338;&#20329;&#26031;&#22806;&#34915;<br>
	 * Message: Sealed Vorpal Tunic
	 */
	public static final NpcStringId SEALED_VORPAL_TUNIC;
	
	/**
	 * ID: 45657<br>
	 * Message: 󂳂ꂽo[yX Q[g<br>
	 * Message: &#23553;&#21360;&#30340;&#21338;&#20329;&#26031;&#33051;&#30002;<br>
	 * Message: Sealed Vorpal Gaiters
	 */
	public static final NpcStringId SEALED_VORPAL_GAITERS;
	
	/**
	 * ID: 45658<br>
	 * Message: 󂳂ꂽo[yX U[ MX<br>
	 * Message: &#23553;&#21360;&#30340;&#21338;&#20329;&#26031;&#30382;&#33051;&#30002;<br>
	 * Message: Sealed Vorpal Leather Legging
	 */
	public static final NpcStringId SEALED_VORPAL_LEATHER_LEGGING;
	
	/**
	 * ID: 45659<br>
	 * Message: 󂳂ꂽo[yX z[X<br>
	 * Message: &#23553;&#21360;&#30340;&#21338;&#20329;&#26031;&#38263;&#35178;<br>
	 * Message: Sealed Vorpal Stocking
	 */
	public static final NpcStringId SEALED_VORPAL_STOCKING;
	
	/**
	 * ID: 45660<br>
	 * Message: 󂳂ꂽo[yX Kgbg<br>
	 * Message: &#23553;&#21360;&#30340;&#21338;&#20329;&#26031;&#35703;&#25163;<br>
	 * Message: Sealed Vorpal Gauntlet
	 */
	public static final NpcStringId SEALED_VORPAL_GAUNTLET;
	
	/**
	 * ID: 45661<br>
	 * Message: 󂳂ꂽo[yX U[ O[u<br>
	 * Message: &#23553;&#21360;&#30340;&#21338;&#20329;&#26031;&#30382;&#25163;&#22871;<br>
	 * Message: Sealed Vorpal Leather Gloves
	 */
	public static final NpcStringId SEALED_VORPAL_LEATHER_GLOVES;
	
	/**
	 * ID: 45662<br>
	 * Message: 󂳂ꂽo[yX O[u<br>
	 * Message: &#23553;&#21360;&#30340;&#21338;&#20329;&#26031;&#25163;&#22871;<br>
	 * Message: Sealed Vorpal Gloves
	 */
	public static final NpcStringId SEALED_VORPAL_GLOVES;
	
	/**
	 * ID: 45663<br>
	 * Message: 󂳂ꂽo[yX u[c<br>
	 * Message: &#23553;&#21360;&#30340;&#21338;&#20329;&#26031;&#38772;<br>
	 * Message: Sealed Vorpal Boots
	 */
	public static final NpcStringId SEALED_VORPAL_BOOTS;
	
	/**
	 * ID: 45664<br>
	 * Message: 󂳂ꂽo[yX U[ u[c<br>
	 * Message: &#23553;&#21360;&#30340;&#21338;&#20329;&#26031;&#30382;&#38772;<br>
	 * Message: Sealed Vorpal Leather Boots
	 */
	public static final NpcStringId SEALED_VORPAL_LEATHER_BOOTS;
	
	/**
	 * ID: 45665<br>
	 * Message: 󂳂ꂽo[yX V[Y<br>
	 * Message: &#23553;&#21360;&#30340;&#21338;&#20329;&#26031;&#38795;<br>
	 * Message: Sealed Vorpal Shoes
	 */
	public static final NpcStringId SEALED_VORPAL_SHOES;
	
	/**
	 * ID: 45666<br>
	 * Message: 󂳂ꂽo[yX V[h<br>
	 * Message: &#23553;&#21360;&#30340;&#21338;&#20329;&#26031;&#30462;<br>
	 * Message: Sealed Vorpal Shield
	 */
	public static final NpcStringId SEALED_VORPAL_SHIELD;
	
	/**
	 * ID: 45667<br>
	 * Message: 󂳂ꂽo[yX VM<br>
	 * Message: &#23553;&#21360;&#30340;&#21338;&#20329;&#26031;&#31526;&#21360;<br>
	 * Message: Sealed Vorpal Sigil
	 */
	public static final NpcStringId SEALED_VORPAL_SIGIL;
	
	/**
	 * ID: 45668<br>
	 * Message: 󂳂ꂽo[yX O<br>
	 * Message: &#23553;&#21360;&#30340;&#21338;&#20329;&#26031;&#25106;&#25351;<br>
	 * Message: Sealed Vorpal Ring
	 */
	public static final NpcStringId SEALED_VORPAL_RING;
	
	/**
	 * ID: 45669<br>
	 * Message: 󂳂ꂽo[yX CAO<br>
	 * Message: &#23553;&#21360;&#30340;&#21338;&#20329;&#26031;&#32819;&#29872;<br>
	 * Message: Sealed Vorpal Earring
	 */
	public static final NpcStringId SEALED_VORPAL_EARRING;
	
	/**
	 * ID: 45670<br>
	 * Message: 󂳂ꂽo[yX lbNX<br>
	 * Message: &#23553;&#21360;&#30340;&#21338;&#20329;&#26031;&#38917;&#37706;<br>
	 * Message: Sealed Vorpal Necklace
	 */
	public static final NpcStringId SEALED_VORPAL_NECKLACE;
	
	/**
	 * ID: 45671<br>
	 * Message: yG \[h<br>
	 * Message: &#20329;&#21033;&#29246;&#20043;&#21133;<br>
	 * Message: Periel Sword
	 */
	public static final NpcStringId PERIEL_SWORD;
	
	/**
	 * ID: 45672<br>
	 * Message: XJ GbW<br>
	 * Message: &#28357;&#39592;&#20043;&#37586;<br>
	 * Message: Skull Edge
	 */
	public static final NpcStringId SKULL_EDGE;
	
	/**
	 * ID: 45673<br>
	 * Message: BOBbN AbNX<br>
	 * Message: &#27604;&#26684;&#32173;&#20811;&#25136;&#26023;<br>
	 * Message: Vigwik Axe
	 */
	public static final NpcStringId VIGWIK_AXE;
	
	/**
	 * ID: 45674<br>
	 * Message: C[ fCeB }E<br>
	 * Message: &#37034;&#38728;&#34909;&#37786;<br>
	 * Message: Devilish Maul
	 */
	public static final NpcStringId DEVILISH_MAUL;
	
	/**
	 * ID: 45675<br>
	 * Message: tFU[AC u[h<br>
	 * Message: &#32701;&#32764;&#21133;&#20995;<br>
	 * Message: Feather Eye Blade
	 */
	public static final NpcStringId FEATHER_EYE_BLADE;
	
	/**
	 * ID: 45676<br>
	 * Message: INg N[<br>
	 * Message: &#20843;&#32764;&#25915;&#29226;<br>
	 * Message: Octo Claw
	 */
	public static final NpcStringId OCTO_CLAW;
	
	/**
	 * ID: 45677<br>
	 * Message: _ugp XsA[<br>
	 * Message: &#38617;&#30772;&#25136;&#25119;<br>
	 * Message: Doubletop Spear
	 */
	public static final NpcStringId DOUBLETOP_SPEAR;
	
	/**
	 * ID: 45678<br>
	 * Message: L[eBN<br>
	 * Message: &#24235;&#25552;&#20811;&#39764;&#26454;<br>
	 * Message: Rising Star
	 */
	public static final NpcStringId RISING_STAR;
	
	/**
	 * ID: 45679<br>
	 * Message: ubN BT[W<br>
	 * Message: &#38343;&#40657;&#27054;&#32768;<br>
	 * Message: Black Visage
	 */
	public static final NpcStringId BLACK_VISAGE;
	
	/**
	 * ID: 45680<br>
	 * Message: xjvg \[h<br>
	 * Message: &#31070;&#33256;&#20043;&#21133;<br>
	 * Message: Veniplant Sword
	 */
	public static final NpcStringId VENIPLANT_SWORD;
	
	/**
	 * ID: 45681<br>
	 * Message: XJ JjE {E<br>
	 * Message: &#39025;&#39592;&#20043;&#24339;<br>
	 * Message: Skull Carnium Bow
	 */
	public static final NpcStringId SKULL_CARNIUM_BOW;
	
	/**
	 * ID: 45682<br>
	 * Message: WFeC CsA<br>
	 * Message: &#32768;&#33426;&#32048;&#21133;<br>
	 * Message: Gemtail Rapier
	 */
	public static final NpcStringId GEMTAIL_RAPIER;
	
	/**
	 * ID: 45683<br>
	 * Message: tB CBVu u[h<br>
	 * Message: &#28961;&#25943;&#32854;&#20995;<br>
	 * Message: Finale Blade
	 */
	public static final NpcStringId FINALE_BLADE;
	
	/**
	 * ID: 45684<br>
	 * Message: [h Jb^[ NX{E<br>
	 * Message: &#26039;&#32618;&#21313;&#23383;&#24339;<br>
	 * Message: Dominion Crossbow
	 */
	public static final NpcStringId DOMINION_CROSSBOW;
	
	/**
	 * ID: 45685<br>
	 * Message: jꂽ틭XN[FSO[h<br>
	 * Message: &#31069;&#31119;&#30340;&#27494;&#22120;&#24375;&#21270;&#21367;&#36600;&#45;&#83;&#32026;<br>
	 * Message: Blessed Weapon Enchant Scroll - S Grade
	 */
	public static final NpcStringId BLESSED_WEAPON_ENCHANT_SCROLL_S_GRADE;
	
	/**
	 * ID: 45686<br>
	 * Message: jꂽhXN[FSO[h<br>
	 * Message: &#31069;&#31119;&#30340;&#38450;&#20855;&#24375;&#21270;&#21367;&#36600;&#45;&#83;&#32026;<br>
	 * Message: Blessed Armor Enchant Scroll - S Grade
	 */
	public static final NpcStringId BLESSED_ARMOR_ENCHANT_SCROLL_S_GRADE;
	
	/**
	 * ID: 45687<br>
	 * Message: ΂̐<br>
	 * Message: &#28779;&#20043;&#27700;&#26230;<br>
	 * Message: Fire Crystal
	 */
	public static final NpcStringId FIRE_CRYSTAL;
	
	/**
	 * ID: 45688<br>
	 * Message: ̐<br>
	 * Message: &#27700;&#20043;&#27700;&#26230;<br>
	 * Message: Water Crystal
	 */
	public static final NpcStringId WATER_CRYSTAL;
	
	/**
	 * ID: 45689<br>
	 * Message: n̐<br>
	 * Message: &#22303;&#20043;&#27700;&#26230;<br>
	 * Message: Earth Crystal
	 */
	public static final NpcStringId EARTH_CRYSTAL;
	
	/**
	 * ID: 45690<br>
	 * Message: ̐<br>
	 * Message: &#39080;&#20043;&#27700;&#26230;<br>
	 * Message: Wind Crystal
	 */
	public static final NpcStringId WIND_CRYSTAL;
	
	/**
	 * ID: 45691<br>
	 * Message: ̐<br>
	 * Message: &#32854;&#20043;&#27700;&#26230;<br>
	 * Message: Holy Crystal
	 */
	public static final NpcStringId HOLY_CRYSTAL;
	
	/**
	 * ID: 45692<br>
	 * Message: ł̐<br>
	 * Message: &#26263;&#20043;&#27700;&#26230;<br>
	 * Message: Dark Crystal
	 */
	public static final NpcStringId DARK_CRYSTAL;
	
	/**
	 * ID: 45693<br>
	 * Message: 틭XN[FSO[h<br>
	 * Message: &#27494;&#22120;&#24375;&#21270;&#21367;&#36600;&#45;&#83;&#32026;<br>
	 * Message: Weapon Enchant Scroll - S Grade
	 */
	public static final NpcStringId WEAPON_ENCHANT_SCROLL_S_GRADE;
	
	/**
	 * ID: 46350<br>
	 * Message: AUDDD$s1AAODDD$s2<br>
	 * Message: &#25915;&#46;&#46;&#25915;&#25802;&#46;&#46;&#12300;&#36;&#115;&#49;&#12301;&#46;&#46;&#35352;&#46;&#46;&#35352;&#46;&#46;&#37636;&#46;&#46;&#35352;&#37636;&#46;&#46;&#12300;&#36;&#115;&#50;&#12301;&#46;&#46;<br>
	 * Message: Att... attack... $s1.. Ro... rogue... $s2..
	 */
	public static final NpcStringId ATT_ATTACK_S1_RO_ROGUE_S2;
	
	/**
	 * ID: 50110<br>
	 * Message: ##########rSI##########<br>
	 * Message: &#35;&#35;&#35;&#35;&#35;&#35;&#35;&#35;&#35;&#35;&#66;&#73;&#78;&#71;&#79;&#33;&#35;&#35;&#35;&#35;&#35;&#35;&#35;&#35;&#35;&#35;<br>
	 * Message: ##########Bingo!##########
	 */
	public static final NpcStringId BINGO;
	
	/**
	 * ID: 50338<br>
	 * Message: Ɩ_I<br>
	 * Message: &#34880;&#33287;&#21517;&#35709;&#65281;<br>
	 * Message: Blood and honor!
	 */
	public static final NpcStringId BLOOD_AND_HONOR;
	
	/**
	 * ID: 50339<br>
	 * Message: 鍑̈Y҂ɐ_̍قI<br>
	 * Message: &#23559;&#20398;&#36785;&#24093;&#22283;&#36986;&#29986;&#30340;&#20154;&#36070;&#20104;&#31070;&#30340;&#35419;&#21650;&#65281;<br>
	 * Message: Curse of the gods on the one that defiles the property of the empire!
	 */
	public static final NpcStringId CURSE_OF_THE_GODS_ON_THE_ONE_THAT_DEFILES_THE_PROPERTY_OF_THE_EMPIRE;
	
	/**
	 * ID: 50340<br>
	 * Message: 푈ƎI<br>
	 * Message: &#25136;&#29229;&#33287;&#27515;&#20129;&#65281;<br>
	 * Message: War and death!
	 */
	public static final NpcStringId WAR_AND_DEATH;
	
	/**
	 * ID: 50341<br>
	 * Message: ]ƌI<br>
	 * Message: &#37326;&#24515;&#33287;&#27402;&#21218;&#65281;<br>
	 * Message: Ambition and power!
	 */
	public static final NpcStringId AMBITION_AND_POWER;
	
	/**
	 * ID: 50503<br>
	 * Message: $s1$s2̍ՓT$s3_L^܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#22312;&#26410;&#28415;&#12300;&#36;&#115;&#50;&#12301;&#30340;&#31085;&#20856;&#19978;&#30331;&#35352;&#20102;&#12300;&#36;&#115;&#51;&#12301;&#20998;&#12290;<br>
	 * Message: $s1 has won the main event for players under level $s2, and earned $s3 points!
	 */
	public static final NpcStringId S1_HAS_WON_THE_MAIN_EVENT_FOR_PLAYERS_UNDER_LEVEL_S2_AND_EARNED_S3_POINTS;
	
	/**
	 * ID: 50504<br>
	 * Message: $s1NX̍ՓT$s2_L^܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#22312;&#28961;&#31561;&#32026;&#38480;&#21046;&#30340;&#31085;&#20856;&#19978;&#30331;&#35352;&#20102;&#12300;&#36;&#115;&#50;&#12301;&#20998;&#12290;<br>
	 * Message: $s1 has earned $s2 points in the main event for unlimited levels.
	 */
	public static final NpcStringId S1_HAS_EARNED_S2_POINTS_IN_THE_MAIN_EVENT_FOR_UNLIMITED_LEVELS;
	
	/**
	 * ID: 50701<br>
	 * Message: ׂ̒<br>
	 * Message: &#36914;&#20837;&#28222;&#27788;<br>
	 * Message: Into the Chaos
	 */
	public static final NpcStringId INTO_THE_CHAOS;
	
	/**
	 * ID: 50851<br>
	 * Message: NGXg𖳎NÂŁA$s1̌ll܂B<br>
	 * Message: &#38918;&#21033;&#23436;&#25104;&#20219;&#21209;&#65292;&#22240;&#27492;&#29554;&#24471;&#34880;&#30431;&#32882;&#26395;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: You have successfully completed a clan quest. $s1 points have been added to your clan's reputation score.
	 */
	public static final NpcStringId YOU_HAVE_SUCCESSFULLY_COMPLETED_A_CLAN_QUEST_S1_POINTS_HAVE_BEEN_ADDED_TO_YOUR_CLANS_REPUTATION_SCORE;
	
	/**
	 * ID: 60000<br>
	 * Message: Ă݂AΔɉ΂B<br>
	 * Message: &#28779;&#29200;&#23559;&#26371;&#40670;&#33879;&#65292;&#20180;&#32048;&#30475;&#22909;&#21908;&#12290;<br>
	 * Message: The furnace will go out. Watch and see.
	 */
	public static final NpcStringId THE_FURNACE_WILL_GO_OUT_WATCH_AND_SEE;
	
	/**
	 * ID: 60001<br>
	 * Message: c1I<br>
	 * Message: &#21097;&#19979;&#49;&#20998;&#37912;&#24038;&#21491;&#65281;<br>
	 * Message: There's about 1 minute left!
	 */
	public static final NpcStringId THERES_ABOUT_1_MINUTE_LEFT;
	
	/**
	 * ID: 60002<br>
	 * Message: c10bȂI<br>
	 * Message: &#21482;&#21097;&#19979;&#49;&#48;&#31186;&#65281;<br>
	 * Message: There's just 10 seconds left!
	 */
	public static final NpcStringId THERES_JUST_10_SECONDS_LEFT;
	
	/**
	 * ID: 60003<br>
	 * Message: قAΔɉ΂Ă݂B<br>
	 * Message: &#20358;&#65292;&#29694;&#22312;&#22312;&#28779;&#29200;&#19978;&#40670;&#28779;&#30475;&#30475;&#12290;<br>
	 * Message: Now, light the furnace's fire.
	 */
	public static final NpcStringId NOW_LIGHT_THE_FURNACES_FIRE;
	
	/**
	 * ID: 60004<br>
	 * Message: ^CI[o[ŎsB񒧂ނ͓̂B<br>
	 * Message: &#26178;&#38291;&#24050;&#21040;&#65292;&#22833;&#25943;&#20102;&#12290;&#25033;&#35442;&#19981;&#33021;&#20877;&#22039;&#35430;&#20102;&#12290;<br>
	 * Message: Time is up and you have failed. Any more will be difficult.
	 */
	public static final NpcStringId TIME_IS_UP_AND_YOU_HAVE_FAILED_ANY_MORE_WILL_BE_DIFFICULT;
	
	/**
	 * ID: 60005<br>
	 * Message: ͂BI<br>
	 * Message: &#21908;&#65292;&#20102;&#19981;&#36215;&#21908;&#65292;&#31455;&#28982;&#26371;&#25104;&#21151;&#32822;&#12290;<br>
	 * Message: Oh, you've succeeded.
	 */
	public static final NpcStringId OH_YOUVE_SUCCEEDED;
	
	/**
	 * ID: 60006<br>
	 * Message: AsIłA܂܂蒼I<br>
	 * Message: &#21834;&#65292;&#22833;&#25943;&#20102;&#21966;&#65311;&#19981;&#36942;&#65292;&#22909;&#20687;&#36996;&#21487;&#20197;&#32380;&#32396;&#35430;&#35430;&#21908;&#12290;<br>
	 * Message: Ah, is this failure? But it looks like I can keep going.
	 */
	public static final NpcStringId AH_IS_THIS_FAILURE_BUT_IT_LOOKS_LIKE_I_CAN_KEEP_GOING;
	
	/**
	 * ID: 60007<br>
	 * Message: sB񒧂ނ͓̂B<br>
	 * Message: &#21834;&#65292;&#22833;&#25943;&#20102;&#12290;&#25033;&#35442;&#19981;&#33021;&#20877;&#22039;&#35430;&#20102;&#12290;<br>
	 * Message: Ah, I've failed. Going further will be difficult.
	 */
	public static final NpcStringId AH_IVE_FAILED_GOING_FURTHER_WILL_BE_DIFFICULT;
	
	/**
	 * ID: 60008<br>
	 * Message: oX̉Δ<br>
	 * Message: &#22343;&#34913;&#30340;&#28779;&#29200;<br>
	 * Message: Furnace of Balance
	 */
	public static final NpcStringId FURNACE_OF_BALANCE;
	
	/**
	 * ID: 60009<br>
	 * Message: ̉Δ<br>
	 * Message: &#23432;&#35703;&#30340;&#28779;&#29200;<br>
	 * Message: Furnace of Protection
	 */
	public static final NpcStringId FURNACE_OF_PROTECTION;
	
	/**
	 * ID: 60010<br>
	 * Message: ủΔ<br>
	 * Message: &#39717;&#24535;&#30340;&#28779;&#29200;<br>
	 * Message: Furnace of Will
	 */
	public static final NpcStringId FURNACE_OF_WILL;
	
	/**
	 * ID: 60011<br>
	 * Message: ͂̉Δ<br>
	 * Message: &#39764;&#21147;&#30340;&#28779;&#29200;<br>
	 * Message: Furnace of Magic
	 */
	public static final NpcStringId FURNACE_OF_MAGIC;
	
	/**
	 * ID: 60012<br>
	 * Message: ȂCY܂B<br>
	 * Message: &#32854;&#20043;&#27683;&#24687;&#38283;&#22987;&#20957;&#32858;&#20102;&#36215;&#20358;&#12290;<br>
	 * Message: Divine energy is beginning to encircle.
	 */
	public static final NpcStringId DIVINE_ENERGY_IS_BEGINNING_TO_ENCIRCLE;
	
	/**
	 * ID: 60013<br>
	 * Message: \i̖_̂߂ɁI<br>
	 * Message: &#28858;&#20102;&#32034;&#40654;&#37027;&#30340;&#27054;&#32768;&#65281;<br>
	 * Message: For the glory of Solina!
	 */
	public static final NpcStringId FOR_THE_GLORY_OF_SOLINA;
	
	/**
	 * ID: 60014<br>
	 * Message: ̒nɑ𓥂ݓꂽׂĂ̎҂f߂I<br>
	 * Message: &#23559;&#36367;&#20837;&#27492;&#22320;&#30340;&#25152;&#26377;&#20154;&#21028;&#28858;&#26377;&#32618;&#12290;<br>
	 * Message: Punish all those who tread footsteps in this place.
	 */
	public static final NpcStringId PUNISH_ALL_THOSE_WHO_TREAD_FOOTSTEPS_IN_THIS_PLACE;
	
	/**
	 * ID: 60015<br>
	 * Message: X͐^̌łA\ǐłB<br>
	 * Message: &#25105;&#20497;&#26159;&#30495;&#29702;&#20043;&#21133;&#65292;&#20063;&#26159;&#32034;&#40654;&#37027;&#20043;&#21133;&#12290;<br>
	 * Message: We are the sword of truth, the sword of Solina.
	 */
	public static final NpcStringId WE_ARE_THE_SWORD_OF_TRUTH_THE_SWORD_OF_SOLINA;
	
	/**
	 * ID: 60016<br>
	 * Message: \i̖_̂߂Ɍ낤B<br>
	 * Message: &#28858;&#20102;&#32034;&#40654;&#37027;&#30340;&#27054;&#32768;&#65292;&#39640;&#33289;&#20992;&#21133;&#65281;<br>
	 * Message: We raise our blades for the glory of Solina.
	 */
	public static final NpcStringId WE_RAISE_OUR_BLADES_FOR_THE_GLORY_OF_SOLINA;
	
	/**
	 * ID: 60018<br>
	 * Message: ȂɑsȂŁB<br>
	 * Message: &#21834;&#21834;&#65292;&#21029;&#36208;&#24471;&#22826;&#24555;&#21834;&#12290;<br>
	 * Message: Hey, don't go so fast.
	 */
	public static final NpcStringId HEY_DONT_GO_SO_FAST;
	
	/**
	 * ID: 60019<br>
	 * Message: Ă܂B<br>
	 * Message: &#24456;&#38627;&#36861;&#24471;&#19978;&#21862;&#12290;<br>
	 * Message: It's hard to follow.
	 */
	public static final NpcStringId ITS_HARD_TO_FOLLOW;
	
	/**
	 * ID: 60020<br>
	 * Message: nAnAAĂĂ܂B<br>
	 * Message: &#21683;&#21683;&#65292;&#22826;&#24555;&#20102;&#65292;&#27794;&#36774;&#27861;&#20877;&#36861;&#36245;&#19978;&#21435;&#20102;&#12290;<br>
	 * Message: Huff huff. You're too fast. I can't follow anymore.
	 */
	public static final NpcStringId HUFF_HUFF_YOURE_TOO_FAST_I_CANT_FOLLOW_ANYMORE;
	
	/**
	 * ID: 60021<br>
	 * Message: A͌o邼B<br>
	 * Message: &#21834;&#46;&#46;&#36889;&#35041;&#22909;&#20687;&#26377;&#21360;&#35937;&#21908;&#65311;&#65281;<br>
	 * Message: Ah... I think I remember this place.
	 */
	public static final NpcStringId AH_I_THINK_I_REMEMBER_THIS_PLACE;
	
	/**
	 * ID: 60022<br>
	 * Message: ACI<br>
	 * Message: &#21834;&#65281;&#22909;&#28165;&#26032;&#30340;&#31354;&#27683;&#65281;<br>
	 * Message: Ah! Fresh air!
	 */
	public static final NpcStringId AH_FRESH_AIR;
	
	/**
	 * ID: 60023<br>
	 * Message: ŉĂłB<br>
	 * Message: &#20882;&#38570;&#23478;&#24744;&#22312;&#36889;&#35041;&#20570;&#20160;&#40636;&#21602;&#65311;<br>
	 * Message: What were you doing here?
	 */
	public static final NpcStringId WHAT_WERE_YOU_DOING_HERE;
	
	/**
	 * ID: 60024<br>
	 * Message: ܂A낵BĎƓ󕨂H<br>
	 * Message: &#20882;&#38570;&#23478;&#24744;&#30495;&#26159;&#23432;&#21475;&#22914;&#29942;&#21834;&#12290;&#38627;&#36947;&#24744;&#20063;&#26159;&#20687;&#25105;&#19968;&#27171;&#22312;&#23563;&#23542;&#65311;<br>
	 * Message: I guess you're the silent type. Then are you looking for treasure like me?
	 */
	public static final NpcStringId I_GUESS_YOURE_THE_SILENT_TYPE_THEN_ARE_YOU_LOOKING_FOR_TREASURE_LIKE_ME;
	
	/**
	 * ID: 60403<br>
	 * Message: ĂԂ̂͒NH<br>
	 * Message: &#26159;&#35504;&#22312;&#21628;&#21914;&#25105;&#65311;<br>
	 * Message: Who is calling me?
	 */
	public static final NpcStringId WHO_IS_CALLING_ME;
	
	/**
	 * ID: 60404<br>
	 * Message: łƌ͕\̂Ȃ񂾁B<br>
	 * Message: &#27794;&#26377;&#40657;&#26263;&#65292;&#20809;&#26126;&#26371;&#23384;&#22312;&#21966;&#65311;<br>
	 * Message: Can light exist without darkness?
	 */
	public static final NpcStringId CAN_LIGHT_EXIST_WITHOUT_DARKNESS;
	
	/**
	 * ID: 60903<br>
	 * Message: E_l͔̊ȂI<br>
	 * Message: &#28961;&#27861;&#36530;&#36991;&#28879;&#20025;&#30340;&#30524;&#30555;&#65281;<br>
	 * Message: You can't avoid the eyes of Udan!
	 */
	public static final NpcStringId YOU_CANT_AVOID_THE_EYES_OF_UDAN;
	
	/**
	 * ID: 60904<br>
	 * Message: E_l͂łɂO̊ɂȂI<br>
	 * Message: &#28879;&#20025;&#24050;&#32147;&#30475;&#21040;&#20102;&#20320;&#30340;&#33225;&#65281;<br>
	 * Message: Udan has already seen your face!
	 */
	public static final NpcStringId UDAN_HAS_ALREADY_SEEN_YOUR_FACE;
	
	/**
	 * ID: 61050<br>
	 * Message: ̖́IꑦƒÔǵ̗It炦Ύ̂݁I<br>
	 * Message: &#27700;&#20043;&#39764;&#21147;&#23601;&#26159;&#26292;&#39080;&#33287;&#28023;&#22063;&#30340;&#21147;&#37327;&#65281;&#33287;&#25105;&#23565;&#25239;&#21482;&#26377;&#27515;&#36335;&#19968;&#26781;&#65281;<br>
	 * Message: The magical power of water comes from the power of storm and hail! If you dare to confront it, only death will await you!
	 */
	public static final NpcStringId THE_MAGICAL_POWER_OF_WATER_COMES_FROM_THE_POWER_OF_STORM_AND_HAIL_IF_YOU_DARE_TO_CONFRONT_IT_ONLY_DEATH_WILL_AWAIT_YOU;
	
	/**
	 * ID: 61051<br>
	 * Message: ̗͂܂ĂBMl̋V͎sI<br>
	 * Message: &#26463;&#32283;&#30340;&#21147;&#37327;&#27491;&#36880;&#28472;&#34928;&#24369;&#12290;&#20320;&#20497;&#30340;&#20736;&#24335;&#22833;&#25943;&#20102;&#65281;<br>
	 * Message: The power of constraint is getting weaker. Your ritual has failed!
	 */
	public static final NpcStringId THE_POWER_OF_CONSTRAINT_IS_GETTING_WEAKER_YOUR_RITUAL_HAS_FAILED;
	
	/**
	 * ID: 61503<br>
	 * Message: AZt@l͔̊ȂI<br>
	 * Message: &#28961;&#27861;&#36530;&#36991;&#20126;&#29791;&#27861;&#30340;&#30524;&#30555;&#65281;<br>
	 * Message: You can't avoid the eyes of Asefa!
	 */
	public static final NpcStringId YOU_CANT_AVOID_THE_EYES_OF_ASEFA;
	
	/**
	 * ID: 61504<br>
	 * Message: AZt@l͂łɂO̊ɂȂI<br>
	 * Message: &#20126;&#29791;&#27861;&#24050;&#32147;&#30475;&#21040;&#20102;&#20320;&#30340;&#33225;&#65281;<br>
	 * Message: Asefa has already seen your face!
	 */
	public static final NpcStringId ASEFA_HAS_ALREADY_SEEN_YOUR_FACE;
	
	/**
	 * ID: 61650<br>
	 * Message: ΂̖͂́AȂ킿ΉƗń̗It炦Ύ̂݁I<br>
	 * Message: &#28814;&#20043;&#39764;&#21147;&#23601;&#26159;&#28779;&#28976;&#33287;&#29076;&#23721;&#30340;&#21147;&#37327;&#65281;&#33287;&#25105;&#23565;&#25239;&#21482;&#26377;&#27515;&#36335;&#19968;&#26781;&#65281;<br>
	 * Message: The magical power of fire is also the power of flames and lava! If you dare to confront it, only death will await you!
	 */
	public static final NpcStringId THE_MAGICAL_POWER_OF_FIRE_IS_ALSO_THE_POWER_OF_FLAMES_AND_LAVA_IF_YOU_DARE_TO_CONFRONT_IT_ONLY_DEATH_WILL_AWAIT_YOU;
	
	/**
	 * ID: 62503<br>
	 * Message: ȓDDD<br>
	 * Message: &#22909;&#39321;&#30340;&#21619;&#36947;&#21834;&#46;&#46;&#46;<br>
	 * Message: I smell something delicious...
	 */
	public static final NpcStringId I_SMELL_SOMETHING_DELICIOUS;
	
	/**
	 * ID: 62504<br>
	 * Message: I<br>
	 * Message: &#21978;&#21703;&#21703;&#65281;<br>
	 * Message: Oooh!
	 */
	public static final NpcStringId OOOH;
	
	/**
	 * ID: 66001<br>
	 * Message: t[~<br>
	 * Message: &#24171;&#21161;&#33433;&#32645;&#34349;&#26449;&#33674;&#21543;<br>
	 * Message: Aiding the Floran Village.
	 */
	public static final NpcStringId AIDING_THE_FLORAN_VILLAGE;
	
	/**
	 * ID: 66300<br>
	 * Message: J[hȂ<br>
	 * Message: &#27794;&#26377;&#21345;&#29255;<br>
	 * Message: No such card
	 */
	public static final NpcStringId NO_SUCH_CARD;
	
	/**
	 * ID: 68801<br>
	 * Message: GNbL[PނI<br>
	 * Message: &#25802;&#36864;&#32822;&#29246;&#21487;&#32645;&#35186;&#25802;&#38538;&#21543;&#65281;<br>
	 * Message: Defeat the Elrokian Raiders!
	 */
	public static final NpcStringId DEFEAT_THE_ELROKIAN_RAIDERS;
	
	/**
	 * ID: 70851<br>
	 * Message: lA͂낵ł傤B<br>
	 * Message: &#22478;&#20027;&#22823;&#20154;&#65292;&#19968;&#20999;&#37117;&#20633;&#40778;&#20102;&#21966;&#65311;<br>
	 * Message: Have you completed your preparations to become a lord?
	 */
	public static final NpcStringId HAVE_YOU_COMPLETED_YOUR_PREPARATIONS_TO_BECOME_A_LORD;
	
	/**
	 * ID: 70852<br>
	 * Message: $s1AoI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#29694;&#22312;&#23601;&#20986;&#30332;&#21543;&#65281;<br>
	 * Message: $s1. Now, depart!
	 */
	public static final NpcStringId S1_NOW_DEPART;
	
	/**
	 * ID: 70853<br>
	 * Message: TCAXK˂ĂB<br>
	 * Message: &#35531;&#21069;&#21435;&#25308;&#35370;&#36093;&#20126;&#26031;&#65281;<br>
	 * Message: Go find Saius!
	 */
	public static final NpcStringId GO_FIND_SAIUS;
	
	/**
	 * ID: 70854<br>
	 * Message: F̏OA悭I܂Ȃ̎lɂȂɂȂlfn|ꂽIFASĕ炷悢I<br>
	 * Message: &#26449;&#33674;&#25152;&#26377;&#20154;&#35531;&#27880;&#24847;&#65281;&#21363;&#23559;&#25104;&#28858;&#38936;&#20027;&#30340;&#22478;&#20027;&#22823;&#20154;&#25802;&#20498;&#20102;&#28961;&#38957;&#39438;&#22763;&#126;&#32;&#26085;&#24460;&#20320;&#20497;&#21487;&#20197;&#23433;&#24515;&#30340;&#29983;&#27963;&#20102;&#12290;<br>
	 * Message: Listen, you villagers. Our liege, who will soon become a lord, has defeated the Headless Knight. You can now rest easy!
	 */
	public static final NpcStringId LISTEN_YOU_VILLAGERS_OUR_LIEGE_WHO_WILL_SOON_BECOME_A_LORD_HAS_DEFEATED_THE_HEADLESS_KNIGHT_YOU_CAN_NOW_REST_EASY;
	
	/**
	 * ID: 70855<br>
	 * Message: $s1IĂ߂A悭̕ɎoĂꂽȁI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#31455;&#25954;&#25307;&#24825;&#25105;&#30340;&#37096;&#19979;&#65311;<br>
	 * Message: $s1! Do you dare defy my subordinates?
	 */
	public static final NpcStringId S1_DO_YOU_DARE_DEFY_MY_SUBORDINATES;
	
	/**
	 * ID: 70856<br>
	 * Message: ⋋WQC͂IȂ̂B<br>
	 * Message: &#25105;&#38459;&#25803;&#35036;&#32102;&#30340;&#20219;&#21209;&#65292;&#38627;&#36947;&#23601;&#21040;&#27492;&#28858;&#27490;&#20102;&#21966;&#65311;<br>
	 * Message: Does my mission to block the supplies end here?
	 */
	public static final NpcStringId DOES_MY_MISSION_TO_BLOCK_THE_SUPPLIES_END_HERE;
	
	/**
	 * ID: 70859<br>
	 * Message: $s1l̓O[fBI̗̎ɂȂɂȂ܂BO[fBI̒nɉhI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#25104;&#28858;&#21476;&#39791;&#19969;&#22478;&#37806;&#30340;&#38936;&#20027;&#65292;&#20182;&#23559;&#24118;&#32102;&#21476;&#39791;&#19969;&#38936;&#22320;&#28961;&#38480;&#27054;&#32768;&#65281;<br>
	 * Message: $s1 has become lord of the Town of Gludio. Long may he reign!
	 */
	public static final NpcStringId S1_HAS_BECOME_LORD_OF_THE_TOWN_OF_GLUDIO_LONG_MAY_HE_REIGN;
	
	/**
	 * ID: 70957<br>
	 * Message: oĂI͐΋˂ȁI<br>
	 * Message: &#36208;&#33879;&#30631;&#65281;&#19979;&#27425;&#32085;&#19981;&#26371;&#39250;&#20102;&#20320;&#20497;&#65281;<br>
	 * Message: You'll see! I won't forgive you next time!
	 */
	public static final NpcStringId YOULL_SEE_I_WONT_FORGIVE_YOU_NEXT_TIME;
	
	/**
	 * ID: 70959<br>
	 * Message: $s1l̓O[fBI̗̎ɂȂɂȂ܂BO[fBI̒nɉhI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#25104;&#28858;&#21476;&#39791;&#19969;&#22478;&#37806;&#30340;&#38936;&#20027;&#65292;&#20182;&#23559;&#24118;&#32102;&#21476;&#39791;&#19969;&#38936;&#22320;&#28961;&#38480;&#27054;&#32768;&#65281;<br>
	 * Message: $s1 has become lord of the Town of Dion. Long may he reign!
	 */
	public static final NpcStringId S1_HAS_BECOME_LORD_OF_THE_TOWN_OF_DION_LONG_MAY_HE_REIGN;
	
	/**
	 * ID: 71052<br>
	 * Message: GPI1lc炸I<br>
	 * Message: &#26377;&#25973;&#20154;&#65281;&#25226;&#36996;&#27963;&#33879;&#30340;&#37117;&#27578;&#20809;&#65281;<br>
	 * Message: It's the enemy! No mercy!
	 */
	public static final NpcStringId ITS_THE_ENEMY_NO_MERCY;
	
	/**
	 * ID: 71053<br>
	 * Message: 񂾁I܂̕DȂI<br>
	 * Message: &#22312;&#20570;&#20160;&#40636;&#65311;&#25105;&#20497;&#36996;&#22312;&#20778;&#21218;&#24773;&#27841;&#21602;&#65281;<br>
	 * Message: What are you doing? We are still superior!
	 */
	public static final NpcStringId WHAT_ARE_YOU_DOING_WE_ARE_STILL_SUPERIOR;
	
	/**
	 * ID: 71054<br>
	 * Message: I̋w͕KDDD<br>
	 * Message: &#19981;&#29976;&#24515;&#21834;&#65281;&#36889;&#20491;&#20167;&#46;&#46;&#46;<br>
	 * Message: How infuriating! This enemy...
	 */
	public static final NpcStringId HOW_INFURIATING_THIS_ENEMY;
	
	/**
	 * ID: 71059<br>
	 * Message: $s1l̓M̗̑̎ɂȂɂȂ܂BM̒nɉhI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#25104;&#28858;&#22855;&#23721;&#22478;&#37806;&#30340;&#38936;&#20027;&#65292;&#20182;&#23559;&#24118;&#32102;&#22855;&#23721;&#38936;&#22320;&#28961;&#38480;&#27054;&#32768;&#65281;<br>
	 * Message: $s1 has become the lord of the Town of Giran. May there be glory in the territory of Giran!
	 */
	public static final NpcStringId S1_HAS_BECOME_THE_LORD_OF_THE_TOWN_OF_GIRAN_MAY_THERE_BE_GLORY_IN_THE_TERRITORY_OF_GIRAN;
	
	/**
	 * ID: 71151<br>
	 * Message: lAǂɂႢ܂B<br>
	 * Message: &#22478;&#20027;&#22823;&#20154;&#65281;&#24744;&#22312;&#21738;&#35041;&#21834;&#65311;<br>
	 * Message: My liege! Where are you?
	 */
	public static final NpcStringId MY_LIEGE_WHERE_ARE_YOU;
	
	/**
	 * ID: 71159<br>
	 * Message: $s1l̓Cih̗̑̎ɂȂɂȂ܂BI[̒nɉhI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#25104;&#28858;&#22240;&#32013;&#24471;&#31435;&#22478;&#37806;&#30340;&#38936;&#20027;&#65292;&#20182;&#23559;&#24118;&#32102;&#22240;&#32013;&#24471;&#31435;&#38936;&#22320;&#28961;&#38480;&#27054;&#32768;&#65281;<br>
	 * Message: $s1 has become the lord of the Town of Innadril. May there be glory in the territory of Innadril!
	 */
	public static final NpcStringId S1_HAS_BECOME_THE_LORD_OF_THE_TOWN_OF_INNADRIL_MAY_THERE_BE_GLORY_IN_THE_TERRITORY_OF_INNADRIL;
	
	/**
	 * ID: 71252<br>
	 * Message: lrCg I[uׂČ܂B<br>
	 * Message: &#25214;&#21040;&#25152;&#26377;&#30340;&#38549;&#30707;&#29699;&#29664;&#20102;&#65281;<br>
	 * Message: You have found all the Nebulite Orbs!
	 */
	public static final NpcStringId YOU_HAVE_FOUND_ALL_THE_NEBULITE_ORBS;
	
	/**
	 * ID: 71259<br>
	 * Message: $s1l̓I[̗̑̎ɂȂɂȂ܂BI[̒nɉhI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#25104;&#28858;&#27472;&#29790;&#22478;&#37806;&#30340;&#38936;&#20027;&#65292;&#20182;&#23559;&#24118;&#32102;&#27472;&#29790;&#38936;&#22320;&#28961;&#38480;&#27054;&#32768;&#65281;<br>
	 * Message: $s1 has become the lord of the Town of Oren. May there be glory in the territory of Oren!
	 */
	public static final NpcStringId S1_HAS_BECOME_THE_LORD_OF_THE_TOWN_OF_OREN_MAY_THERE_BE_GLORY_IN_THE_TERRITORY_OF_OREN;
	
	/**
	 * ID: 71351<br>
	 * Message: $s1l̓Af̗̑̎ɂȂɂȂ܂BAf̒nɉhI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#25104;&#28858;&#20126;&#19969;&#22478;&#37806;&#30340;&#38936;&#20027;&#65292;&#20182;&#23559;&#24118;&#32102;&#20126;&#19969;&#38936;&#22320;&#28961;&#38480;&#27054;&#32768;&#65281;<br>
	 * Message: $s1 has become the lord of the Town of Aden. May there be glory in the territory of Aden!
	 */
	public static final NpcStringId S1_HAS_BECOME_THE_LORD_OF_THE_TOWN_OF_ADEN_MAY_THERE_BE_GLORY_IN_THE_TERRITORY_OF_ADEN;
	
	/**
	 * ID: 71459<br>
	 * Message: $s1l̓V`bcKg̗̑̎ɂȂɂȂ܂BV`bcKg̒nɉhI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#25104;&#28858;&#20462;&#21152;&#29305;&#22478;&#37806;&#30340;&#38936;&#20027;&#65292;&#20182;&#23559;&#24118;&#32102;&#20462;&#21152;&#29305;&#38936;&#22320;&#28961;&#38480;&#27054;&#32768;&#65281;<br>
	 * Message: $s1 has become the lord of the Town of Schuttgart. May there be glory in the territory of Schuttgart!
	 */
	public static final NpcStringId S1_HAS_BECOME_THE_LORD_OF_THE_TOWN_OF_SCHUTTGART_MAY_THERE_BE_GLORY_IN_THE_TERRITORY_OF_SCHUTTGART;
	
	/**
	 * ID: 71551<br>
	 * Message: $s1AÔƂ͖YȂ낤B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#25105;&#26371;&#35352;&#20303;&#20320;&#36889;&#20491;&#20642;&#20249;&#30340;&#12290;<br>
	 * Message: $s1, I will remember you.
	 */
	public static final NpcStringId S1_I_WILL_REMEMBER_YOU;
	
	/**
	 * ID: 71653<br>
	 * Message: tfbNlɂڂɂ肽Ɛ\Ă܂B<br>
	 * Message: &#20315;&#38647;&#24503;&#21033;&#20811;&#27491;&#22312;&#23563;&#25214;&#22478;&#20027;&#22823;&#20154;&#12290;<br>
	 * Message: Frederick is looking for you, my liege.
	 */
	public static final NpcStringId FREDERICK_IS_LOOKING_FOR_YOU_MY_LIEGE;
	
	/**
	 * ID: 71654<br>
	 * Message: ӂӂӂBXƎɊƂłvI<br>
	 * Message: &#21628;&#21628;&#65292;&#20320;&#35469;&#28858;&#19981;&#21644;&#25105;&#20497;&#20132;&#26131;&#20063;&#33021;&#22816;&#25744;&#24471;&#19979;&#21435;&#21966;&#65311;<br>
	 * Message: Ho ho! Did you think you could really stop trading with us?
	 */
	public static final NpcStringId HO_HO_DID_YOU_THINK_YOU_COULD_REALLY_STOP_TRADING_WITH_US;
	
	/**
	 * ID: 71655<br>
	 * Message: _aɍUߓ܂B<br>
	 * Message: &#25915;&#36914;&#20102;&#31070;&#27583;&#12290;<br>
	 * Message: You have charged into the temple.
	 */
	public static final NpcStringId YOU_HAVE_CHARGED_INTO_THE_TEMPLE;
	
	/**
	 * ID: 71656<br>
	 * Message: ׋̐_a̎׋k|ĂŒłB<br>
	 * Message: &#27491;&#22312;&#25910;&#26381;&#37034;&#25945;&#24466;&#31070;&#27583;&#30340;&#37034;&#25945;&#24466;&#12290;<br>
	 * Message: You are in the midst of dealing with the heretic of Heretic Temple.
	 */
	public static final NpcStringId YOU_ARE_IN_THE_MIDST_OF_DEALING_WITH_THE_HERETIC_OF_HERETIC_TEMPLE;
	
	/**
	 * ID: 71657<br>
	 * Message: ׋̐_aɊׂ܂B<br>
	 * Message: &#37034;&#25945;&#24466;&#31070;&#27583;&#24050;&#38283;&#22987;&#38519;&#20837;&#28151;&#20098;&#20043;&#20013;&#12290;<br>
	 * Message: The Heretic Temple is descending into chaos.
	 */
	public static final NpcStringId THE_HERETIC_TEMPLE_IS_DESCENDING_INTO_CHAOS;
	
	/**
	 * ID: 71659<br>
	 * Message: $s1l̓Ȇ̗̎ɂȂɂȂ܂BE̒nɉhI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#25104;&#28858;&#39791;&#22240;&#22478;&#37806;&#30340;&#38936;&#20027;&#65292;&#20182;&#23559;&#24118;&#32102;&#39791;&#22240;&#38936;&#22320;&#28961;&#38480;&#27054;&#32768;&#65281;<br>
	 * Message: $s1 has become the lord of the Town of Rune. May there be glory in the territory of Rune!
	 */
	public static final NpcStringId S1_HAS_BECOME_THE_LORD_OF_THE_TOWN_OF_RUNE_MAY_THERE_BE_GLORY_IN_THE_TERRITORY_OF_RUNE;
	
	/**
	 * ID: 71751<br>
	 * Message: $s1! ̒n̂߂ɕI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#28858;&#20102;&#38936;&#22320;&#65292;&#33289;&#36215;&#27494;&#22120;&#65281;<br>
	 * Message: $s1! Raise your weapons for the sake of the territory!
	 */
	public static final NpcStringId S1_RAISE_YOUR_WEAPONS_FOR_THE_SAKE_OF_THE_TERRITORY;
	
	/**
	 * ID: 71752<br>
	 * Message: $s1! 푈͏IBÂ߂Ɍ߂I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#25136;&#29229;&#24050;&#32080;&#26463;&#12290;&#28858;&#20102;&#23559;&#20358;&#20316;&#25171;&#31639;&#65292;&#20808;&#25918;&#19979;&#20320;&#30340;&#21133;&#21543;&#12290;<br>
	 * Message: $s1! The war is over. Lower your sword for the sake of the future.
	 */
	public static final NpcStringId S1_THE_WAR_IS_OVER_LOWER_YOUR_SWORD_FOR_THE_SAKE_OF_THE_FUTURE;
	
	/**
	 * ID: 71755<br>
	 * Message: ̒ñobW90All450_A$s1AfiB<br>
	 * Message: &#57;&#48;&#20491;&#38936;&#22320;&#24509;&#31456;&#12289;&#20491;&#20154;&#32882;&#26395;&#52;&#53;&#48;&#40670;&#21644;&#12300;&#36;&#115;&#49;&#12301;&#37329;&#24163;&#12290;<br>
	 * Message: 90 Territory Badges, 450 scores in Individual Fame and $s2 Adenas
	 */
	public static final NpcStringId N91_TERRITORY_BADGES_450_SCORES_IN_INDIVIDUAL_FAME_AND_S2_ADENAS;
	
	/**
	 * ID: 72903<br>
	 * Message: bNGXg̔ԍ$s1Amemostate1$s2Amemostate2$s3łB<br>
	 * Message: &#20653;&#20853;&#20219;&#21209;&#30340;&#34399;&#30908;&#28858;&#12300;&#36;&#115;&#49;&#12301;&#65292;&#109;&#101;&#109;&#111;&#115;&#116;&#97;&#116;&#101;&#49;&#28858;&#12300;&#36;&#115;&#50;&#12301;&#65292;&#109;&#101;&#109;&#111;&#115;&#116;&#97;&#116;&#101;&#50;&#28858;&#12300;&#36;&#115;&#51;&#12301;&#12290;<br>
	 * Message: The mercenary quest number is $s1; memostate1 is $s2; and memostate2 is $s3.
	 */
	public static final NpcStringId THE_MERCENARY_QUEST_NUMBER_IS_S1_MEMOSTATE1_IS_S2_AND_MEMOSTATE2_IS_S3;
	
	/**
	 * ID: 72904<br>
	 * Message: user_connected  CxgASiege Id $s1A728memo2̒l$s2A729/memo2$s3A255/memo1 $s4łB<br>
	 * Message: &#117;&#115;&#101;&#114;&#95;&#99;&#111;&#110;&#110;&#101;&#99;&#116;&#101;&#100;&#27963;&#21205;&#33289;&#36774;&#25104;&#21151;&#65292;&#83;&#105;&#101;&#103;&#101;&#32;&#73;&#100;&#12300;&#36;&#115;&#49;&#12301;&#65292;&#55;&#50;&#56;&#34399;&#109;&#101;&#109;&#111;&#50;&#20540;&#12300;&#36;&#115;&#50;&#12301;&#65292;&#55;&#50;&#57;&#47;&#109;&#101;&#109;&#111;&#50;&#12300;&#36;&#115;&#51;&#12301;&#12289;&#50;&#53;&#53;&#47;&#109;&#101;&#109;&#111;&#49;&#12300;&#36;&#115;&#52;&#12301;&#12290;<br>
	 * Message: user_connected event occurrence success. Siege Id is $s1, Number 728 memo2 is $s2. 729/memo2 is $s3, and 255/memo1 is $s4.
	 */
	public static final NpcStringId USER_CONNECTED_EVENT_OCCURRENCE_SUCCESS_SIEGE_ID_IS_S1_NUMBER_728_MEMO2_IS_S2_729_MEMO2_IS_S3_AND_255_MEMO1_IS_S4;
	
	/**
	 * ID: 72905<br>
	 * Message: ̒n΋@AdyingCxg΋@̗̒nID$s1Ap[eB $s2<br>
	 * Message: &#38936;&#22320;&#25237;&#30707;&#27231;&#100;&#121;&#105;&#110;&#103;&#27963;&#21205;&#32;&#25237;&#30707;&#27231;&#30340;&#38936;&#22320;&#73;&#68;&#12300;&#36;&#115;&#49;&#12301;&#65292;&#38538;&#20237;&#29376;&#24907;&#12300;&#36;&#115;&#50;&#12301;<br>
	 * Message: Territory Catapult dying event catapult's territory ID $s1, party status $s2.
	 */
	public static final NpcStringId TERRITORY_CATAPULT_DYING_EVENT_CATAPULTS_TERRITORY_ID_S1_PARTY_STATUS_S2;
	
	/**
	 * ID: 72951<br>
	 * Message: O[fBI̗̒n΋@I<br>
	 * Message: &#38450;&#34907;&#21476;&#39791;&#19969;&#30340;&#38936;&#22320;&#25237;&#30707;&#27231;&#65281;<br>
	 * Message: Protect the catapult of Gludio!
	 */
	public static final NpcStringId PROTECT_THE_CATAPULT_OF_GLUDIO;
	
	/**
	 * ID: 72952<br>
	 * Message: fBI̗̒n΋@I<br>
	 * Message: &#38450;&#34907;&#29380;&#24681;&#30340;&#38936;&#22320;&#25237;&#30707;&#27231;&#65281;<br>
	 * Message: Protect the catapult of Dion!
	 */
	public static final NpcStringId PROTECT_THE_CATAPULT_OF_DION;
	
	/**
	 * ID: 72953<br>
	 * Message: M̗̒n΋@I<br>
	 * Message: &#38450;&#34907;&#22855;&#23721;&#30340;&#38936;&#22320;&#25237;&#30707;&#27231;&#65281;<br>
	 * Message: Protect the catapult of Giran!
	 */
	public static final NpcStringId PROTECT_THE_CATAPULT_OF_GIRAN;
	
	/**
	 * ID: 72954<br>
	 * Message: I[̗̒n΋@I<br>
	 * Message: &#38450;&#34907;&#27472;&#29790;&#30340;&#38936;&#22320;&#25237;&#30707;&#27231;&#65281;<br>
	 * Message: Protect the catapult of Oren!
	 */
	public static final NpcStringId PROTECT_THE_CATAPULT_OF_OREN;
	
	/**
	 * ID: 72955<br>
	 * Message: Af̗̒n΋@I<br>
	 * Message: &#38450;&#34907;&#20126;&#19969;&#30340;&#38936;&#22320;&#25237;&#30707;&#27231;&#65281;<br>
	 * Message: Protect the catapult of Aden!
	 */
	public static final NpcStringId PROTECT_THE_CATAPULT_OF_ADEN;
	
	/**
	 * ID: 72956<br>
	 * Message: Cih̗̒n΋@I<br>
	 * Message: &#38450;&#34907;&#22240;&#32013;&#24471;&#31435;&#30340;&#38936;&#22320;&#25237;&#30707;&#27231;&#65281;<br>
	 * Message: Protect the catapult of Innadril!
	 */
	public static final NpcStringId PROTECT_THE_CATAPULT_OF_INNADRIL;
	
	/**
	 * ID: 72957<br>
	 * Message: S_[h̗̒n΋@I<br>
	 * Message: &#38450;&#34907;&#39640;&#36948;&#29305;&#30340;&#38936;&#22320;&#25237;&#30707;&#27231;&#65281;<br>
	 * Message: Protect the catapult of Goddard!
	 */
	public static final NpcStringId PROTECT_THE_CATAPULT_OF_GODDARD;
	
	/**
	 * ID: 72958<br>
	 * Message: E̗̒n΋@I<br>
	 * Message: &#38450;&#34907;&#39791;&#22240;&#30340;&#38936;&#22320;&#25237;&#30707;&#27231;&#65281;<br>
	 * Message: Protect the catapult of Rune!
	 */
	public static final NpcStringId PROTECT_THE_CATAPULT_OF_RUNE;
	
	/**
	 * ID: 72959<br>
	 * Message: V`bcKg̗̒n΋@I<br>
	 * Message: &#38450;&#34907;&#20462;&#21152;&#29305;&#30340;&#38936;&#22320;&#25237;&#30707;&#27231;&#65281;<br>
	 * Message: Protect the catapult of Schuttgart!
	 */
	public static final NpcStringId PROTECT_THE_CATAPULT_OF_SCHUTTGART;
	
	/**
	 * ID: 72961<br>
	 * Message: O[fBI̗̒n΋@j󂳂ꂽI<br>
	 * Message: &#21476;&#39791;&#19969;&#30340;&#38936;&#22320;&#25237;&#30707;&#27231;&#24050;&#34987;&#25613;&#22750;&#65281;<br>
	 * Message: The catapult of Gludio has been destroyed!
	 */
	public static final NpcStringId THE_CATAPULT_OF_GLUDIO_HAS_BEEN_DESTROYED;
	
	/**
	 * ID: 72962<br>
	 * Message: fBI̗̒n΋@j󂳂ꂽI<br>
	 * Message: &#29380;&#24681;&#30340;&#38936;&#22320;&#25237;&#30707;&#27231;&#24050;&#34987;&#25613;&#22750;&#65281;<br>
	 * Message: The catapult of Dion has been destroyed!
	 */
	public static final NpcStringId THE_CATAPULT_OF_DION_HAS_BEEN_DESTROYED;
	
	/**
	 * ID: 72963<br>
	 * Message: M̗̒n΋@j󂳂ꂽI<br>
	 * Message: &#22855;&#23721;&#30340;&#38936;&#22320;&#25237;&#30707;&#27231;&#24050;&#34987;&#25613;&#22750;&#65281;<br>
	 * Message: The catapult of Giran has been destroyed!
	 */
	public static final NpcStringId THE_CATAPULT_OF_GIRAN_HAS_BEEN_DESTROYED;
	
	/**
	 * ID: 72964<br>
	 * Message: I[̗̒n΋@j󂳂ꂽI<br>
	 * Message: &#27472;&#29790;&#30340;&#38936;&#22320;&#25237;&#30707;&#27231;&#24050;&#34987;&#25613;&#22750;&#65281;<br>
	 * Message: The catapult of Oren has been destroyed!
	 */
	public static final NpcStringId THE_CATAPULT_OF_OREN_HAS_BEEN_DESTROYED;
	
	/**
	 * ID: 72965<br>
	 * Message: Af̗̒n΋@j󂳂ꂽI<br>
	 * Message: &#20126;&#19969;&#30340;&#38936;&#22320;&#25237;&#30707;&#27231;&#24050;&#34987;&#25613;&#22750;&#65281;<br>
	 * Message: The catapult of Aden has been destroyed!
	 */
	public static final NpcStringId THE_CATAPULT_OF_ADEN_HAS_BEEN_DESTROYED;
	
	/**
	 * ID: 72966<br>
	 * Message: Cih̗̒n΋@j󂳂ꂽI<br>
	 * Message: &#22240;&#32013;&#24471;&#31435;&#30340;&#38936;&#22320;&#25237;&#30707;&#27231;&#24050;&#34987;&#25613;&#22750;&#65281;<br>
	 * Message: The catapult of Innadril has been destroyed!
	 */
	public static final NpcStringId THE_CATAPULT_OF_INNADRIL_HAS_BEEN_DESTROYED;
	
	/**
	 * ID: 72967<br>
	 * Message: S_[h̗̒n΋@j󂳂ꂽI<br>
	 * Message: &#39640;&#36948;&#29305;&#30340;&#38936;&#22320;&#25237;&#30707;&#27231;&#24050;&#34987;&#25613;&#22750;&#65281;<br>
	 * Message: The catapult of Goddard has been destroyed!
	 */
	public static final NpcStringId THE_CATAPULT_OF_GODDARD_HAS_BEEN_DESTROYED;
	
	/**
	 * ID: 72968<br>
	 * Message: E̗̒n΋@j󂳂ꂽI<br>
	 * Message: &#39791;&#22240;&#30340;&#38936;&#22320;&#25237;&#30707;&#27231;&#24050;&#34987;&#25613;&#22750;&#65281;<br>
	 * Message: The catapult of Rune has been destroyed!
	 */
	public static final NpcStringId THE_CATAPULT_OF_RUNE_HAS_BEEN_DESTROYED;
	
	/**
	 * ID: 72969<br>
	 * Message: V`bcKg̗̒n΋@j󂳂ꂽI<br>
	 * Message: &#20462;&#21152;&#29305;&#30340;&#38936;&#22320;&#25237;&#30707;&#27231;&#24050;&#34987;&#25613;&#22750;&#65281;<br>
	 * Message: The catapult of Schuttgart has been destroyed!
	 */
	public static final NpcStringId THE_CATAPULT_OF_SCHUTTGART_HAS_BEEN_DESTROYED;
	
	/**
	 * ID: 72981<br>
	 * Message: O[fBI<br>
	 * Message: &#21476;&#39791;&#19969;<br>
	 * Message: Gludio
	 */
	public static final NpcStringId GLUDIO;
	
	/**
	 * ID: 72982<br>
	 * Message: fBI<br>
	 * Message: &#29380;&#24681;<br>
	 * Message: Dion
	 */
	public static final NpcStringId DION;
	
	/**
	 * ID: 72983<br>
	 * Message: M<br>
	 * Message: &#22855;&#23721;<br>
	 * Message: Giran
	 */
	public static final NpcStringId GIRAN;
	
	/**
	 * ID: 72984<br>
	 * Message: I[<br>
	 * Message: &#27472;&#29790;<br>
	 * Message: Oren
	 */
	public static final NpcStringId OREN;
	
	/**
	 * ID: 72985<br>
	 * Message: Af<br>
	 * Message: &#20126;&#19969;<br>
	 * Message: Aden
	 */
	public static final NpcStringId ADEN;
	
	/**
	 * ID: 72986<br>
	 * Message: Cih<br>
	 * Message: &#22240;&#32013;&#24471;&#31435;<br>
	 * Message: Innadril
	 */
	public static final NpcStringId INNADRIL;
	
	/**
	 * ID: 72987<br>
	 * Message: S_[h<br>
	 * Message: &#39640;&#36948;&#29305;<br>
	 * Message: Goddard
	 */
	public static final NpcStringId GODDARD;
	
	/**
	 * ID: 72988<br>
	 * Message: E<br>
	 * Message: &#39791;&#22240;<br>
	 * Message: Rune
	 */
	public static final NpcStringId RUNE;
	
	/**
	 * ID: 72989<br>
	 * Message: V`bcKg<br>
	 * Message: &#20462;&#21152;&#29305;<br>
	 * Message: Schuttgart
	 */
	public static final NpcStringId SCHUTTGART;
	
	/**
	 * ID: 73051<br>
	 * Message: O[fBI̕⋋iۊǔI<br>
	 * Message: &#23432;&#35703;&#21476;&#39791;&#19969;&#30340;&#35036;&#32102;&#21697;&#20445;&#31649;&#31665;&#65281;<br>
	 * Message: Protect the supplies safe of Gludio!
	 */
	public static final NpcStringId PROTECT_THE_SUPPLIES_SAFE_OF_GLUDIO;
	
	/**
	 * ID: 73052<br>
	 * Message: fBI̕⋋iۊǔI<br>
	 * Message: &#23432;&#35703;&#29380;&#24681;&#30340;&#35036;&#32102;&#21697;&#20445;&#31649;&#31665;&#65281;<br>
	 * Message: Protect the supplies safe of Dion!
	 */
	public static final NpcStringId PROTECT_THE_SUPPLIES_SAFE_OF_DION;
	
	/**
	 * ID: 73053<br>
	 * Message: M̕⋋iۊǔI<br>
	 * Message: &#23432;&#35703;&#22855;&#23721;&#30340;&#35036;&#32102;&#21697;&#20445;&#31649;&#31665;&#65281;<br>
	 * Message: Protect the supplies safe of Giran!
	 */
	public static final NpcStringId PROTECT_THE_SUPPLIES_SAFE_OF_GIRAN;
	
	/**
	 * ID: 73054<br>
	 * Message: I[̕⋋iۊǔI<br>
	 * Message: &#23432;&#35703;&#27472;&#29790;&#30340;&#35036;&#32102;&#21697;&#20445;&#31649;&#31665;&#65281;<br>
	 * Message: Protect the supplies safe of Oren!
	 */
	public static final NpcStringId PROTECT_THE_SUPPLIES_SAFE_OF_OREN;
	
	/**
	 * ID: 73055<br>
	 * Message: Af̕⋋iۊǔI<br>
	 * Message: &#23432;&#35703;&#20126;&#19969;&#30340;&#35036;&#32102;&#21697;&#20445;&#31649;&#31665;&#65281;<br>
	 * Message: Protect the supplies safe of Aden!
	 */
	public static final NpcStringId PROTECT_THE_SUPPLIES_SAFE_OF_ADEN;
	
	/**
	 * ID: 73056<br>
	 * Message: Cih̕⋋iۊǔI<br>
	 * Message: &#23432;&#35703;&#22240;&#32013;&#24471;&#31435;&#30340;&#35036;&#32102;&#21697;&#20445;&#31649;&#31665;&#65281;<br>
	 * Message: Protect the supplies safe of Innadril!
	 */
	public static final NpcStringId PROTECT_THE_SUPPLIES_SAFE_OF_INNADRIL;
	
	/**
	 * ID: 73057<br>
	 * Message: S_[h̕⋋iۊǔI<br>
	 * Message: &#23432;&#35703;&#39640;&#36948;&#29305;&#30340;&#35036;&#32102;&#21697;&#20445;&#31649;&#31665;&#65281;<br>
	 * Message: Protect the supplies safe of Goddard!
	 */
	public static final NpcStringId PROTECT_THE_SUPPLIES_SAFE_OF_GODDARD;
	
	/**
	 * ID: 73058<br>
	 * Message: E̕⋋iۊǔI<br>
	 * Message: &#23432;&#35703;&#39791;&#22240;&#30340;&#35036;&#32102;&#21697;&#20445;&#31649;&#31665;&#65281;<br>
	 * Message: Protect the supplies safe of Rune!
	 */
	public static final NpcStringId PROTECT_THE_SUPPLIES_SAFE_OF_RUNE;
	
	/**
	 * ID: 73059<br>
	 * Message: V`bcKg̕⋋iۊǔI<br>
	 * Message: &#23432;&#35703;&#20462;&#21152;&#29305;&#30340;&#35036;&#32102;&#21697;&#20445;&#31649;&#31665;&#65281;<br>
	 * Message: Protect the supplies safe of Schuttgart!
	 */
	public static final NpcStringId PROTECT_THE_SUPPLIES_SAFE_OF_SCHUTTGART;
	
	/**
	 * ID: 73061<br>
	 * Message: O[fBI̕⋋iۊǔj󂳂ꂽI<br>
	 * Message: &#24050;&#25915;&#30772;&#21476;&#39791;&#19969;&#30340;&#35036;&#32102;&#21697;&#20445;&#31649;&#31665;&#65281;<br>
	 * Message: The supplies safe of Gludio has been destroyed!
	 */
	public static final NpcStringId THE_SUPPLIES_SAFE_OF_GLUDIO_HAS_BEEN_DESTROYED;
	
	/**
	 * ID: 73062<br>
	 * Message: fBI̕⋋iۊǔj󂳂ꂽI<br>
	 * Message: &#24050;&#25915;&#30772;&#29380;&#24681;&#30340;&#35036;&#32102;&#21697;&#20445;&#31649;&#31665;&#65281;<br>
	 * Message: The supplies safe of Dion has been destroyed!
	 */
	public static final NpcStringId THE_SUPPLIES_SAFE_OF_DION_HAS_BEEN_DESTROYED;
	
	/**
	 * ID: 73063<br>
	 * Message: M̕⋋iۊǔj󂳂ꂽI<br>
	 * Message: &#24050;&#25915;&#30772;&#22855;&#23721;&#30340;&#35036;&#32102;&#21697;&#20445;&#31649;&#31665;&#65281;<br>
	 * Message: The supplies safe of Giran has been destroyed!
	 */
	public static final NpcStringId THE_SUPPLIES_SAFE_OF_GIRAN_HAS_BEEN_DESTROYED;
	
	/**
	 * ID: 73064<br>
	 * Message: I[̕⋋iۊǔj󂳂ꂽI<br>
	 * Message: &#24050;&#25915;&#30772;&#27472;&#29790;&#30340;&#35036;&#32102;&#21697;&#20445;&#31649;&#31665;&#65281;<br>
	 * Message: The supplies safe of Oren has been destroyed!
	 */
	public static final NpcStringId THE_SUPPLIES_SAFE_OF_OREN_HAS_BEEN_DESTROYED;
	
	/**
	 * ID: 73065<br>
	 * Message: Af̕⋋iۊǔj󂳂ꂽI<br>
	 * Message: &#24050;&#25915;&#30772;&#20126;&#19969;&#30340;&#35036;&#32102;&#21697;&#20445;&#31649;&#31665;&#65281;<br>
	 * Message: The supplies safe of Aden has been destroyed!
	 */
	public static final NpcStringId THE_SUPPLIES_SAFE_OF_ADEN_HAS_BEEN_DESTROYED;
	
	/**
	 * ID: 73066<br>
	 * Message: Cih̕⋋iۊǔj󂳂ꂽI<br>
	 * Message: &#24050;&#25915;&#30772;&#22240;&#32013;&#24471;&#31435;&#30340;&#35036;&#32102;&#21697;&#20445;&#31649;&#31665;&#65281;<br>
	 * Message: The supplies safe of Innadril has been destroyed!
	 */
	public static final NpcStringId THE_SUPPLIES_SAFE_OF_INNADRIL_HAS_BEEN_DESTROYED;
	
	/**
	 * ID: 73067<br>
	 * Message: S_[h̕⋋iۊǔj󂳂ꂽI<br>
	 * Message: &#24050;&#25915;&#30772;&#39640;&#36948;&#29305;&#30340;&#35036;&#32102;&#21697;&#20445;&#31649;&#31665;&#65281;<br>
	 * Message: The supplies safe of Goddard has been destroyed!
	 */
	public static final NpcStringId THE_SUPPLIES_SAFE_OF_GODDARD_HAS_BEEN_DESTROYED;
	
	/**
	 * ID: 73068<br>
	 * Message: E̕⋋iۊǔj󂳂ꂽI<br>
	 * Message: &#24050;&#25915;&#30772;&#39791;&#22240;&#30340;&#35036;&#32102;&#21697;&#20445;&#31649;&#31665;&#65281;<br>
	 * Message: The supplies safe of Rune has been destroyed!
	 */
	public static final NpcStringId THE_SUPPLIES_SAFE_OF_RUNE_HAS_BEEN_DESTROYED;
	
	/**
	 * ID: 73069<br>
	 * Message: V`bcKg̕⋋iۊǔj󂳂ꂽI<br>
	 * Message: &#24050;&#25915;&#30772;&#20462;&#21152;&#29305;&#30340;&#35036;&#32102;&#21697;&#20445;&#31649;&#31665;&#65281;<br>
	 * Message: The supplies safe of Schuttgart has been destroyed!
	 */
	public static final NpcStringId THE_SUPPLIES_SAFE_OF_SCHUTTGART_HAS_BEEN_DESTROYED;
	
	/**
	 * ID: 73151<br>
	 * Message: O[fBIRAI<br>
	 * Message: &#20445;&#35703;&#21476;&#39791;&#19969;&#30340;&#36557;&#20107;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Military Association Leader of Gludio!
	 */
	public static final NpcStringId PROTECT_THE_MILITARY_ASSOCIATION_LEADER_OF_GLUDIO;
	
	/**
	 * ID: 73152<br>
	 * Message: fBIRAI<br>
	 * Message: &#20445;&#35703;&#29380;&#24681;&#30340;&#36557;&#20107;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Military Association Leader of Dion!
	 */
	public static final NpcStringId PROTECT_THE_MILITARY_ASSOCIATION_LEADER_OF_DION;
	
	/**
	 * ID: 73153<br>
	 * Message: MRAI<br>
	 * Message: &#20445;&#35703;&#22855;&#23721;&#30340;&#36557;&#20107;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Military Association Leader of Giran!
	 */
	public static final NpcStringId PROTECT_THE_MILITARY_ASSOCIATION_LEADER_OF_GIRAN;
	
	/**
	 * ID: 73154<br>
	 * Message: I[RAI<br>
	 * Message: &#20445;&#35703;&#27472;&#29790;&#30340;&#36557;&#20107;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Military Association Leader of Oren!
	 */
	public static final NpcStringId PROTECT_THE_MILITARY_ASSOCIATION_LEADER_OF_OREN;
	
	/**
	 * ID: 73155<br>
	 * Message: AfRAI<br>
	 * Message: &#20445;&#35703;&#20126;&#19969;&#30340;&#36557;&#20107;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Military Association Leader of Aden!
	 */
	public static final NpcStringId PROTECT_THE_MILITARY_ASSOCIATION_LEADER_OF_ADEN;
	
	/**
	 * ID: 73156<br>
	 * Message: CihRAI<br>
	 * Message: &#20445;&#35703;&#22240;&#32013;&#24471;&#31435;&#30340;&#36557;&#20107;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Military Association Leader of Innadril!
	 */
	public static final NpcStringId PROTECT_THE_MILITARY_ASSOCIATION_LEADER_OF_INNADRIL;
	
	/**
	 * ID: 73157<br>
	 * Message: S_[hRAI<br>
	 * Message: &#20445;&#35703;&#39640;&#36948;&#29305;&#30340;&#36557;&#20107;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Military Association Leader of Goddard!
	 */
	public static final NpcStringId PROTECT_THE_MILITARY_ASSOCIATION_LEADER_OF_GODDARD;
	
	/**
	 * ID: 73158<br>
	 * Message: ERAI<br>
	 * Message: &#20445;&#35703;&#39791;&#22240;&#30340;&#36557;&#20107;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Military Association Leader of Rune!
	 */
	public static final NpcStringId PROTECT_THE_MILITARY_ASSOCIATION_LEADER_OF_RUNE;
	
	/**
	 * ID: 73159<br>
	 * Message: V`bcKgRAI<br>
	 * Message: &#20445;&#35703;&#20462;&#21152;&#29305;&#30340;&#36557;&#20107;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Military Association Leader of Schuttgart!
	 */
	public static final NpcStringId PROTECT_THE_MILITARY_ASSOCIATION_LEADER_OF_SCHUTTGART;
	
	/**
	 * ID: 73161<br>
	 * Message: O[fBIRA񂾁I<br>
	 * Message: &#21476;&#39791;&#19969;&#30340;&#36557;&#20107;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Military Association Leader of Gludio is dead!
	 */
	public static final NpcStringId THE_MILITARY_ASSOCIATION_LEADER_OF_GLUDIO_IS_DEAD;
	
	/**
	 * ID: 73162<br>
	 * Message: fBIRA񂾁I<br>
	 * Message: &#29380;&#24681;&#30340;&#36557;&#20107;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Military Association Leader of Dion is dead!
	 */
	public static final NpcStringId THE_MILITARY_ASSOCIATION_LEADER_OF_DION_IS_DEAD;
	
	/**
	 * ID: 73163<br>
	 * Message: MRA񂾁I<br>
	 * Message: &#22855;&#23721;&#30340;&#36557;&#20107;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Military Association Leader of Giran is dead!
	 */
	public static final NpcStringId THE_MILITARY_ASSOCIATION_LEADER_OF_GIRAN_IS_DEAD;
	
	/**
	 * ID: 73164<br>
	 * Message: I[RA񂾁I<br>
	 * Message: &#27472;&#29790;&#30340;&#36557;&#20107;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Military Association Leader of Oren is dead!
	 */
	public static final NpcStringId THE_MILITARY_ASSOCIATION_LEADER_OF_OREN_IS_DEAD;
	
	/**
	 * ID: 73165<br>
	 * Message: AfRA񂾁I<br>
	 * Message: &#20126;&#19969;&#30340;&#36557;&#20107;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Military Association Leader of Aden is dead!
	 */
	public static final NpcStringId THE_MILITARY_ASSOCIATION_LEADER_OF_ADEN_IS_DEAD;
	
	/**
	 * ID: 73166<br>
	 * Message: CihRA񂾁I<br>
	 * Message: &#22240;&#32013;&#24471;&#31435;&#30340;&#36557;&#20107;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Military Association Leader of Innadril is dead!
	 */
	public static final NpcStringId THE_MILITARY_ASSOCIATION_LEADER_OF_INNADRIL_IS_DEAD;
	
	/**
	 * ID: 73167<br>
	 * Message: S_[hRA񂾁I<br>
	 * Message: &#39640;&#36948;&#29305;&#30340;&#36557;&#20107;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Military Association Leader of Goddard is dead!
	 */
	public static final NpcStringId THE_MILITARY_ASSOCIATION_LEADER_OF_GODDARD_IS_DEAD;
	
	/**
	 * ID: 73168<br>
	 * Message: ERA񂾁I<br>
	 * Message: &#39791;&#22240;&#30340;&#36557;&#20107;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Military Association Leader of Rune is dead!
	 */
	public static final NpcStringId THE_MILITARY_ASSOCIATION_LEADER_OF_RUNE_IS_DEAD;
	
	/**
	 * ID: 73169<br>
	 * Message: V`bcKgRA񂾁I<br>
	 * Message: &#20462;&#21152;&#29305;&#30340;&#36557;&#20107;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Military Association Leader of Schuttgart is dead!
	 */
	public static final NpcStringId THE_MILITARY_ASSOCIATION_LEADER_OF_SCHUTTGART_IS_DEAD;
	
	/**
	 * ID: 73251<br>
	 * Message: O[fBI@AI<br>
	 * Message: &#20445;&#35703;&#21476;&#39791;&#19969;&#30340;&#23447;&#25945;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Religious Association Leader of Gludio!
	 */
	public static final NpcStringId PROTECT_THE_RELIGIOUS_ASSOCIATION_LEADER_OF_GLUDIO;
	
	/**
	 * ID: 73252<br>
	 * Message: fBI@AI<br>
	 * Message: &#20445;&#35703;&#29380;&#24681;&#30340;&#23447;&#25945;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Religious Association Leader of Dion!
	 */
	public static final NpcStringId PROTECT_THE_RELIGIOUS_ASSOCIATION_LEADER_OF_DION;
	
	/**
	 * ID: 73253<br>
	 * Message: M@AI<br>
	 * Message: &#20445;&#35703;&#22855;&#23721;&#30340;&#23447;&#25945;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Religious Association Leader of Giran!
	 */
	public static final NpcStringId PROTECT_THE_RELIGIOUS_ASSOCIATION_LEADER_OF_GIRAN;
	
	/**
	 * ID: 73254<br>
	 * Message: I[@AI<br>
	 * Message: &#20445;&#35703;&#27472;&#29790;&#30340;&#23447;&#25945;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Religious Association Leader of Oren!
	 */
	public static final NpcStringId PROTECT_THE_RELIGIOUS_ASSOCIATION_LEADER_OF_OREN;
	
	/**
	 * ID: 73255<br>
	 * Message: Af@AI<br>
	 * Message: &#20445;&#35703;&#20126;&#19969;&#30340;&#23447;&#25945;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Religious Association Leader of Aden!
	 */
	public static final NpcStringId PROTECT_THE_RELIGIOUS_ASSOCIATION_LEADER_OF_ADEN;
	
	/**
	 * ID: 73256<br>
	 * Message: Cih@AI<br>
	 * Message: &#20445;&#35703;&#22240;&#32013;&#24471;&#31435;&#30340;&#23447;&#25945;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Religious Association Leader of Innadril!
	 */
	public static final NpcStringId PROTECT_THE_RELIGIOUS_ASSOCIATION_LEADER_OF_INNADRIL;
	
	/**
	 * ID: 73257<br>
	 * Message: S_[h@AI<br>
	 * Message: &#20445;&#35703;&#39640;&#36948;&#29305;&#30340;&#23447;&#25945;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Religious Association Leader of Goddard!
	 */
	public static final NpcStringId PROTECT_THE_RELIGIOUS_ASSOCIATION_LEADER_OF_GODDARD;
	
	/**
	 * ID: 73258<br>
	 * Message: E@AI<br>
	 * Message: &#20445;&#35703;&#39791;&#22240;&#30340;&#23447;&#25945;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Religious Association Leader of Rune!
	 */
	public static final NpcStringId PROTECT_THE_RELIGIOUS_ASSOCIATION_LEADER_OF_RUNE;
	
	/**
	 * ID: 73259<br>
	 * Message: V`bcKg@AI<br>
	 * Message: &#20445;&#35703;&#20462;&#21152;&#29305;&#30340;&#23447;&#25945;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Religious Association Leader of Schuttgart!
	 */
	public static final NpcStringId PROTECT_THE_RELIGIOUS_ASSOCIATION_LEADER_OF_SCHUTTGART;
	
	/**
	 * ID: 73261<br>
	 * Message: O[fBI@A񂾁I<br>
	 * Message: &#21476;&#39791;&#19969;&#30340;&#23447;&#25945;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Religious Association Leader of Gludio is dead!
	 */
	public static final NpcStringId THE_RELIGIOUS_ASSOCIATION_LEADER_OF_GLUDIO_IS_DEAD;
	
	/**
	 * ID: 73262<br>
	 * Message: fBI@A񂾁I<br>
	 * Message: &#29380;&#24681;&#30340;&#23447;&#25945;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Religious Association Leader of Dion is dead!
	 */
	public static final NpcStringId THE_RELIGIOUS_ASSOCIATION_LEADER_OF_DION_IS_DEAD;
	
	/**
	 * ID: 73263<br>
	 * Message: M@A񂾁I<br>
	 * Message: &#22855;&#23721;&#30340;&#23447;&#25945;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Religious Association Leader of Giran is dead!
	 */
	public static final NpcStringId THE_RELIGIOUS_ASSOCIATION_LEADER_OF_GIRAN_IS_DEAD;
	
	/**
	 * ID: 73264<br>
	 * Message: I[@A񂾁I<br>
	 * Message: &#27472;&#29790;&#30340;&#23447;&#25945;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Religious Association Leader of Oren is dead!
	 */
	public static final NpcStringId THE_RELIGIOUS_ASSOCIATION_LEADER_OF_OREN_IS_DEAD;
	
	/**
	 * ID: 73265<br>
	 * Message: Af@A񂾁I<br>
	 * Message: &#20126;&#19969;&#30340;&#23447;&#25945;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Religious Association Leader of Aden is dead!
	 */
	public static final NpcStringId THE_RELIGIOUS_ASSOCIATION_LEADER_OF_ADEN_IS_DEAD;
	
	/**
	 * ID: 73266<br>
	 * Message: Cih@A񂾁I<br>
	 * Message: &#22240;&#32013;&#24471;&#31435;&#30340;&#23447;&#25945;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Religious Association Leader of Innadril is dead!
	 */
	public static final NpcStringId THE_RELIGIOUS_ASSOCIATION_LEADER_OF_INNADRIL_IS_DEAD;
	
	/**
	 * ID: 73267<br>
	 * Message: S_[h@A񂾁I<br>
	 * Message: &#39640;&#36948;&#29305;&#30340;&#23447;&#25945;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Religious Association Leader of Goddard is dead!
	 */
	public static final NpcStringId THE_RELIGIOUS_ASSOCIATION_LEADER_OF_GODDARD_IS_DEAD;
	
	/**
	 * ID: 73268<br>
	 * Message: E@A񂾁I<br>
	 * Message: &#39791;&#22240;&#30340;&#23447;&#25945;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Religious Association Leader of Rune is dead!
	 */
	public static final NpcStringId THE_RELIGIOUS_ASSOCIATION_LEADER_OF_RUNE_IS_DEAD;
	
	/**
	 * ID: 73269<br>
	 * Message: V`bcKg@A񂾁I<br>
	 * Message: &#20462;&#21152;&#29305;&#30340;&#23447;&#25945;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Religious Association Leader of Schuttgart is dead!
	 */
	public static final NpcStringId THE_RELIGIOUS_ASSOCIATION_LEADER_OF_SCHUTTGART_IS_DEAD;
	
	/**
	 * ID: 73351<br>
	 * Message: O[fBIoϘAI<br>
	 * Message: &#20445;&#35703;&#21476;&#39791;&#19969;&#30340;&#32147;&#28639;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Economic Association Leader of Gludio!
	 */
	public static final NpcStringId PROTECT_THE_ECONOMIC_ASSOCIATION_LEADER_OF_GLUDIO;
	
	/**
	 * ID: 73352<br>
	 * Message: fBIoϘAI<br>
	 * Message: &#20445;&#35703;&#29380;&#24681;&#30340;&#32147;&#28639;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Economic Association Leader of Dion!
	 */
	public static final NpcStringId PROTECT_THE_ECONOMIC_ASSOCIATION_LEADER_OF_DION;
	
	/**
	 * ID: 73353<br>
	 * Message: MoϘAI<br>
	 * Message: &#20445;&#35703;&#22855;&#23721;&#30340;&#32147;&#28639;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Economic Association Leader of Giran!
	 */
	public static final NpcStringId PROTECT_THE_ECONOMIC_ASSOCIATION_LEADER_OF_GIRAN;
	
	/**
	 * ID: 73354<br>
	 * Message: I[oϘAI<br>
	 * Message: &#20445;&#35703;&#27472;&#29790;&#30340;&#32147;&#28639;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Economic Association Leader of Oren!
	 */
	public static final NpcStringId PROTECT_THE_ECONOMIC_ASSOCIATION_LEADER_OF_OREN;
	
	/**
	 * ID: 73355<br>
	 * Message: AfoϘAI<br>
	 * Message: &#20445;&#35703;&#20126;&#19969;&#30340;&#32147;&#28639;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Economic Association Leader of Aden!
	 */
	public static final NpcStringId PROTECT_THE_ECONOMIC_ASSOCIATION_LEADER_OF_ADEN;
	
	/**
	 * ID: 73356<br>
	 * Message: CihoϘAI<br>
	 * Message: &#20445;&#35703;&#22240;&#32013;&#24471;&#31435;&#30340;&#32147;&#28639;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Economic Association Leader of Innadril!
	 */
	public static final NpcStringId PROTECT_THE_ECONOMIC_ASSOCIATION_LEADER_OF_INNADRIL;
	
	/**
	 * ID: 73357<br>
	 * Message: S_[hoϘAI<br>
	 * Message: &#20445;&#35703;&#39640;&#36948;&#29305;&#30340;&#32147;&#28639;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Economic Association Leader of Goddard!
	 */
	public static final NpcStringId PROTECT_THE_ECONOMIC_ASSOCIATION_LEADER_OF_GODDARD;
	
	/**
	 * ID: 73358<br>
	 * Message: EoϘAI<br>
	 * Message: &#20445;&#35703;&#39791;&#22240;&#30340;&#32147;&#28639;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Economic Association Leader of Rune!
	 */
	public static final NpcStringId PROTECT_THE_ECONOMIC_ASSOCIATION_LEADER_OF_RUNE;
	
	/**
	 * ID: 73359<br>
	 * Message: V`bcKgoϘAI<br>
	 * Message: &#20445;&#35703;&#20462;&#21152;&#29305;&#30340;&#32147;&#28639;&#32879;&#21512;&#38263;&#65281;<br>
	 * Message: Protect the Economic Association Leader of Schuttgart!
	 */
	public static final NpcStringId PROTECT_THE_ECONOMIC_ASSOCIATION_LEADER_OF_SCHUTTGART;
	
	/**
	 * ID: 73361<br>
	 * Message: O[fBIoϘA񂾁I<br>
	 * Message: &#21476;&#39791;&#19969;&#30340;&#32147;&#28639;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Economic Association Leader of Gludio is dead!
	 */
	public static final NpcStringId THE_ECONOMIC_ASSOCIATION_LEADER_OF_GLUDIO_IS_DEAD;
	
	/**
	 * ID: 73362<br>
	 * Message: fBIoϘA񂾁I<br>
	 * Message: &#29380;&#24681;&#30340;&#32147;&#28639;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Economic Association Leader of Dion is dead!
	 */
	public static final NpcStringId THE_ECONOMIC_ASSOCIATION_LEADER_OF_DION_IS_DEAD;
	
	/**
	 * ID: 73363<br>
	 * Message: MoϘA񂾁I<br>
	 * Message: &#22855;&#23721;&#30340;&#32147;&#28639;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Economic Association Leader of Giran is dead!
	 */
	public static final NpcStringId THE_ECONOMIC_ASSOCIATION_LEADER_OF_GIRAN_IS_DEAD;
	
	/**
	 * ID: 73364<br>
	 * Message: I[oϘA񂾁I<br>
	 * Message: &#27472;&#29790;&#30340;&#32147;&#28639;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Economic Association Leader of Oren is dead!
	 */
	public static final NpcStringId THE_ECONOMIC_ASSOCIATION_LEADER_OF_OREN_IS_DEAD;
	
	/**
	 * ID: 73365<br>
	 * Message: AfoϘA񂾁I<br>
	 * Message: &#20126;&#19969;&#30340;&#32147;&#28639;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Economic Association Leader of Aden is dead!
	 */
	public static final NpcStringId THE_ECONOMIC_ASSOCIATION_LEADER_OF_ADEN_IS_DEAD;
	
	/**
	 * ID: 73366<br>
	 * Message: CihoϘA񂾁I<br>
	 * Message: &#22240;&#32013;&#24471;&#31435;&#30340;&#32147;&#28639;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Economic Association Leader of Innadril is dead!
	 */
	public static final NpcStringId THE_ECONOMIC_ASSOCIATION_LEADER_OF_INNADRIL_IS_DEAD;
	
	/**
	 * ID: 73367<br>
	 * Message: S_[hoϘA񂾁I<br>
	 * Message: &#39640;&#36948;&#29305;&#30340;&#32147;&#28639;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Economic Association Leader of Goddard is dead!
	 */
	public static final NpcStringId THE_ECONOMIC_ASSOCIATION_LEADER_OF_GODDARD_IS_DEAD;
	
	/**
	 * ID: 73368<br>
	 * Message: EoϘA񂾁I<br>
	 * Message: &#39791;&#22240;&#30340;&#32147;&#28639;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Economic Association Leader of Rune is dead!
	 */
	public static final NpcStringId THE_ECONOMIC_ASSOCIATION_LEADER_OF_RUNE_IS_DEAD;
	
	/**
	 * ID: 73369<br>
	 * Message: V`bcKgoϘA񂾁I<br>
	 * Message: &#20462;&#21152;&#29305;&#30340;&#32147;&#28639;&#32879;&#21512;&#38263;&#24050;&#27515;&#20129;&#65281;<br>
	 * Message: The Economic Association Leader of Schuttgart is dead!
	 */
	public static final NpcStringId THE_ECONOMIC_ASSOCIATION_LEADER_OF_SCHUTTGART_IS_DEAD;
	
	/**
	 * ID: 73451<br>
	 * Message: ̏łGR̃iCg$s1l|I<br>
	 * Message: &#25802;&#20498;&#12300;&#36;&#115;&#49;&#12301;&#27425;&#25136;&#22580;&#20043;&#30462;&#45;&#45;&#25973;&#36557;&#30340;&#39438;&#22763;&#65281;<br>
	 * Message: Defeat $s1 enemy knights!
	 */
	public static final NpcStringId DEFEAT_S1_ENEMY_KNIGHTS;
	
	/**
	 * ID: 73461<br>
	 * Message: GR̃iCg$s1l$s2l|B<br>
	 * Message: &#22312;&#12300;&#36;&#115;&#49;&#12301;&#21517;&#20013;&#25802;&#20498;&#20102;&#12300;&#36;&#115;&#50;&#12301;&#21517;&#39438;&#22763;&#12290;<br>
	 * Message: You have defeated $s2 of $s1 knights.
	 */
	public static final NpcStringId YOU_HAVE_DEFEATED_S2_OF_S1_KNIGHTS;
	
	/**
	 * ID: 73462<br>
	 * Message: G̃V[hтI<br>
	 * Message: &#31361;&#30772;&#20102;&#25973;&#20154;&#20043;&#30462;&#65281;<br>
	 * Message: You weakened the enemy's defense!
	 */
	public static final NpcStringId YOU_WEAKENED_THE_ENEMYS_DEFENSE;
	
	/**
	 * ID: 73551<br>
	 * Message: GR̃EH[A[ƃ[O$s1l|I<br>
	 * Message: &#22312;&#25136;&#22763;&#21644;&#30428;&#36042;&#31995;&#20013;&#65292;&#25802;&#20498;&#25973;&#36557;&#12300;&#36;&#115;&#49;&#12301;&#21517;&#65281;<br>
	 * Message: Defeat $s1 warriors and rogues!
	 */
	public static final NpcStringId DEFEAT_S1_WARRIORS_AND_ROGUES;
	
	/**
	 * ID: 73561<br>
	 * Message: $s1l$s2l̍U͂点B<br>
	 * Message: &#22312;&#12300;&#36;&#115;&#49;&#12301;&#21517;&#20013;&#24369;&#21270;&#20102;&#12300;&#36;&#115;&#50;&#12301;&#21517;&#25973;&#36557;&#30340;&#29289;&#29702;&#25915;&#25802;&#21147;&#12290;<br>
	 * Message: You have defeated $s2 of $s1 warriors and rogues.
	 */
	public static final NpcStringId YOU_HAVE_DEFEATED_S2_OF_S1_WARRIORS_AND_ROGUES;
	
	/**
	 * ID: 73562<br>
	 * Message: G̍U͂点B<br>
	 * Message: &#24369;&#21270;&#20102;&#25973;&#20154;&#30340;&#29289;&#29702;&#25915;&#25802;&#21147;&#12290;<br>
	 * Message: You weakened the enemy's attack!
	 */
	public static final NpcStringId YOU_WEAKENED_THE_ENEMYS_ATTACK;
	
	/**
	 * ID: 73651<br>
	 * Message: GR̃EBU[hƏn$s1l|I<br>
	 * Message: &#22312;&#24043;&#24107;&#21644;&#21484;&#21914;&#22763;&#31995;&#20013;&#65292;&#25802;&#20498;&#25973;&#36557;&#12300;&#36;&#115;&#49;&#12301;&#21517;&#65281;<br>
	 * Message: Defeat $s1 wizards and summoners!
	 */
	public static final NpcStringId DEFEAT_S1_WIZARDS_AND_SUMMONERS;
	
	/**
	 * ID: 73661<br>
	 * Message: $s1l$s2l̖͂点B<br>
	 * Message: &#22312;&#12300;&#36;&#115;&#49;&#12301;&#21517;&#20013;&#24369;&#21270;&#20102;&#12300;&#36;&#115;&#50;&#12301;&#21517;&#25973;&#36557;&#30340;&#39764;&#27861;&#25915;&#25802;&#21147;&#12290;<br>
	 * Message: You have defeated $s2 of $s1 enemies.
	 */
	public static final NpcStringId YOU_HAVE_DEFEATED_S2_OF_S1_ENEMIES;
	
	/**
	 * ID: 73662<br>
	 * Message: G̖͂点B<br>
	 * Message: &#24369;&#21270;&#20102;&#25973;&#20154;&#30340;&#39764;&#27861;&#25915;&#25802;&#21147;&#12290;<br>
	 * Message: You weakened the enemy's magic!
	 */
	public static final NpcStringId YOU_WEAKENED_THE_ENEMYS_MAGIC;
	
	/**
	 * ID: 73751<br>
	 * Message: GR̎mC߂j҂ǂ$s1l|I<br>
	 * Message: &#25802;&#20498;&#36000;&#36012;&#40723;&#33310;&#25973;&#36557;&#22763;&#27683;&#30340;&#31069;&#31119;&#32773;&#12300;&#36;&#115;&#49;&#12301;&#21517;&#65281;<br>
	 * Message: Defeat $s1 healers and buffers.
	 */
	public static final NpcStringId DEFEAT_S1_HEALERS_AND_BUFFERS;
	
	/**
	 * ID: 73761<br>
	 * Message: $s1l$s2l̏jj~B<br>
	 * Message: &#22312;&#12300;&#36;&#115;&#49;&#12301;&#21517;&#20013;&#22952;&#31001;&#20102;&#12300;&#36;&#115;&#50;&#12301;&#21517;&#25973;&#36557;&#36060;&#20104;&#31069;&#31119;&#12290;<br>
	 * Message: You have defeated $s2 of $s1 healers and buffers.
	 */
	public static final NpcStringId YOU_HAVE_DEFEATED_S2_OF_S1_HEALERS_AND_BUFFERS;
	
	/**
	 * ID: 73762<br>
	 * Message: G̎mCI<br>
	 * Message: &#38477;&#20302;&#20102;&#25973;&#20154;&#30340;&#22763;&#27683;&#65281;<br>
	 * Message: You have weakened the enemy's support!
	 */
	public static final NpcStringId YOU_HAVE_WEAKENED_THE_ENEMYS_SUPPORT;
	
	/**
	 * ID: 73851<br>
	 * Message: ̃JMłGR̃EH[X~XƃI[o[[h$s1l|I<br>
	 * Message: &#25802;&#20498;&#12300;&#36;&#115;&#49;&#12301;&#27425;&#21213;&#21033;&#20043;&#38000;&#45;&#45;&#25973;&#36557;&#30340;&#25136;&#29229;&#24037;&#21280;&#21644;&#38712;&#20027;&#65281;<br>
	 * Message: Defeat $s1 warsmiths and overlords.
	 */
	public static final NpcStringId DEFEAT_S1_WARSMITHS_AND_OVERLORDS;
	
	/**
	 * ID: 73861<br>
	 * Message: $s1l$s2l̃JMЕtB<br>
	 * Message: &#22312;&#12300;&#36;&#115;&#49;&#12301;&#21517;&#20013;&#25802;&#20498;&#20102;&#12300;&#36;&#115;&#50;&#12301;&#21517;&#25973;&#36557;&#20043;&#38000;&#12290;<br>
	 * Message: You have defeated $s2 of $s1 warsmiths and overlords.
	 */
	public static final NpcStringId YOU_HAVE_DEFEATED_S2_OF_S1_WARSMITHS_AND_OVERLORDS;
	
	/**
	 * ID: 73862<br>
	 * Message: G̃JM󂵂I<br>
	 * Message: &#25915;&#30772;&#20102;&#25973;&#36557;&#20043;&#38000;&#65281;<br>
	 * Message: You destroyed the enemy's professionals!
	 */
	public static final NpcStringId YOU_DESTROYED_THE_ENEMYS_PROFESSIONALS;
	
	/**
	 * ID: 99601<br>
	 * Message: `䂩ȗ̓`͉Tɏo悤`<br>
	 * Message: &#21862;&#21862;&#21862;&#126;&#20170;&#22825;&#21448;&#26159;&#20491;&#24841;&#24555;&#30340;&#26053;&#36884;&#126;&#36889;&#27425;&#21435;&#25214;&#20160;&#40636;&#26481;&#35199;&#22909;&#21602;&#126;<br>
	 * Message: Tra la la... Today, I'm going to make another fun-filled trip. I wonder what I should look for this time...
	 */
	public static final NpcStringId TRA_LA_LA_TODAY_IM_GOING_TO_MAKE_ANOTHER_FUN_FILLED_TRIP_I_WONDER_WHAT_I_SHOULD_LOOK_FOR_THIS_TIME;
	
	/**
	 * ID: 99700<br>
	 * Message: A^V̂ƌĂ񂾁H<br>
	 * Message: &#21670;&#65311;&#36889;&#26159;&#20160;&#40636;&#65311;&#24590;&#40636;&#22238;&#20107;&#65311;&#26159;&#35504;&#21483;&#25105;&#65311;<br>
	 * Message: What's this? Why am I being disturbed?
	 */
	public static final NpcStringId WHATS_THIS_WHY_AM_I_BEING_DISTURBED;
	
	/**
	 * ID: 99701<br>
	 * Message: ɂ́AA^VA|iI낵肢܁`I<br>
	 * Message: &#22079;&#21691;&#126;&#23567;&#33899;&#34310;&#22823;&#29242;&#30331;&#22580;&#20102;&#65281;<br>
	 * Message: Ta-da! Here I am!
	 */
	public static final NpcStringId TA_DA_HERE_I_AM;
	
	/**
	 * ID: 99702<br>
	 * Message: ӂӂAA^V̂ƌĂ񂾁H<br>
	 * Message: &#22075;&#22075;&#46;&#46;&#46;&#20320;&#25214;&#25105;&#21966;&#46;&#46;&#46;&#65311;&#32;<br>
	 * Message: What are you looking at?
	 */
	public static final NpcStringId WHAT_ARE_YOU_LOOKING_AT;
	
	/**
	 * ID: 99703<br>
	 * Message: ݂Ȃ҂܂I|iAIꂩǂǂႤ񂾂I<br>
	 * Message: &#23567;&#33899;&#34310;&#30331;&#22580;&#20102;&#65281;&#29694;&#22312;&#38283;&#22987;&#26371;&#36880;&#28472;&#25104;&#38263;&#30340;&#65281;<br>
	 * Message: If you give me nectar, this little squash will grow up quickly!
	 */
	public static final NpcStringId IF_YOU_GIVE_ME_NECTAR_THIS_LITTLE_SQUASH_WILL_GROW_UP_QUICKLY;
	
	/**
	 * ID: 99704<br>
	 * Message: HAi^ɉ̂͏߂ĂHA^VA|iI낵ˁI<br>
	 * Message: &#21769;&#21938;&#65292;&#36889;&#26159;&#22810;&#20037;&#27794;&#35211;&#38754;&#30340;&#20154;&#21834;&#65311;<br>
	 * Message: Are you my mommy?
	 */
	public static final NpcStringId ARE_YOU_MY_MOMMY;
	
	/**
	 * ID: 99705<br>
	 * Message: A^VAAi^̂Ƃ悤ɂ΂邩AςĂˁI<br>
	 * Message: &#24685;&#21916;&#30332;&#36001;&#65281;&#32;<br>
	 * Message: Fancy meeting you here!
	 */
	public static final NpcStringId FANCY_MEETING_YOU_HERE;
	
	/**
	 * ID: 99706<br>
	 * Message: pHGbIȃA^VɈẮH<br>
	 * Message: &#25214;&#25105;&#21966;&#65311;&#25214;&#25105;&#24185;&#20160;&#40636;&#65311;&#20197;&#28858;&#26371;&#20986;&#29694;&#20160;&#40636;&#21966;&#65311;<br>
	 * Message: Are you afraid of the big-bad squash?
	 */
	public static final NpcStringId ARE_YOU_AFRAID_OF_THE_BIG_BAD_SQUASH;
	
	/**
	 * ID: 99707<br>
	 * Message: ӁBA^V̎pAȂɌ`H<br>
	 * Message: &#36454;&#36454;&#36339;&#36339;&#65281;&#24819;&#30475;&#25105;&#30340;&#32654;&#35980;&#21966;&#65311;<br>
	 * Message: Impressive, aren't I?
	 */
	public static final NpcStringId IMPRESSIVE_ARENT_I;
	
	/**
	 * ID: 99708<br>
	 * Message: Ai^ɌĂ΂Ăɗ̂I傤`I<br>
	 * Message: &#21571;&#21549;&#65281;&#20986;&#20358;&#20102;&#65281;&#37027;&#23601;&#22909;&#22909;&#20282;&#20505;&#25105;&#30475;&#30475;&#21543;&#65281;<br>
	 * Message: Obey me!!
	 */
	public static final NpcStringId OBEY_ME;
	
	/**
	 * ID: 99709<br>
	 * Message: ɂ́AA^VA|iIɗ̂͏߂ĂȁH낵ˁI<br>
	 * Message: &#39178;&#24471;&#22909;&#65292;&#24685;&#21916;&#30332;&#36001;&#126;&#39178;&#19981;&#22909;&#65292;&#35722;&#25104;&#20062;&#19984;&#126;<br>
	 * Message: Raise me well and you'll be rewarded. Neglect me and suffer the consequences!
	 */
	public static final NpcStringId RAISE_ME_WELL_AND_YOULL_BE_REWARDED_NEGLECT_ME_AND_SUFFER_THE_CONSEQUENCES;
	
	/**
	 * ID: 99710<br>
	 * Message: ҂Ił́Aϐg̎ԂI<br>
	 * Message: &#22079;&#21691;&#126;&#35722;&#126;&#36523;&#126;&#65281;<br>
	 * Message: Transform!
	 */
	public static final NpcStringId TRANSFORM;
	
	/**
	 * ID: 99711<br>
	 * Message: ǂHA^VALCɂȂHHLCɂȂČāI<br>
	 * Message: &#20320;&#29468;&#25105;&#26159;&#20778;&#33391;&#36996;&#26159;&#19981;&#33391;&#30340;&#21602;&#65311;<br>
	 * Message: I feel different?
	 */
	public static final NpcStringId I_FEEL_DIFFERENT;
	
	/**
	 * ID: 99712<br>
	 * Message: nIAǂł[I<br>
	 * Message: &#21568;&#21628;&#65292;&#38263;&#22823;&#20102;&#65281;&#25918;&#39340;&#36942;&#20358;&#65281;<br>
	 * Message: I'm bigger now! Bring it on!
	 */
	public static final NpcStringId IM_BIGGER_NOW_BRING_IT_ON;
	
	/**
	 * ID: 99713<br>
	 * Message: DDDM̂Sg삯́I<br>
	 * Message: &#36454;&#36454;&#36339;&#36339;&#65281;&#38263;&#22823;&#21543;&#35722;&#24375;&#21543;&#65281;<br>
	 * Message: I'm not a kid anymore!
	 */
	public static final NpcStringId IM_NOT_A_KID_ANYMORE;
	
	/**
	 * ID: 99714<br>
	 * Message: A^V̂ƁA؂ɂĂȂ̂ˁDDDnYႦI<br>
	 * Message: &#35722;&#25104;&#31406;&#20809;&#34507;&#65281;&#46;&#46;&#21487;&#26159;&#24050;&#32147;&#38263;&#22823;&#20102;&#65311;<br>
	 * Message: Big time!
	 */
	public static final NpcStringId BIG_TIME;
	
	/**
	 * ID: 99716<br>
	 * Message: тHCHƂAAE^EVHւցAxĂ݂񂾁B<br>
	 * Message: &#37117;&#38263;&#22823;&#20102;&#65281;&#37027;&#23601;&#20358;&#36208;&#20154;&#22217;&#126;<br>
	 * Message: I'm all grown up now!
	 */
	public static final NpcStringId IM_ALL_GROWN_UP_NOW;
	
	/**
	 * ID: 99717<br>
	 * Message: 1疜Afi邩狖ĂIĂÂH<br>
	 * Message: &#33509;&#25918;&#36942;&#25105;&#23601;&#32102;&#20320;&#19968;&#21315;&#33836;&#37329;&#24163;&#65281;&#8230;&#23416;&#24471;&#20687;&#21966;&#65311;<br>
	 * Message: If you let me go, I'll be your best friend.
	 */
	public static final NpcStringId IF_YOU_LET_ME_GO_ILL_BE_YOUR_BEST_FRIEND;
	
	/**
	 * ID: 99718<br>
	 * Message: A^V̒ɔ߂ꂽ̌Ă݂H<br>
	 * Message: &#20358;&#65281;&#20320;&#35258;&#24471;&#25105;&#35041;&#38754;&#35037;&#33879;&#20160;&#40636;&#65311;&#32;<br>
	 * Message: I'm chuck full of goodness!
	 */
	public static final NpcStringId IM_CHUCK_FULL_OF_GOODNESS;
	
	/**
	 * ID: 99719<br>
	 * Message: A^V̍~̂킩H킩ĂłHA̈~́I<br>
	 * Message: &#24456;&#22909;&#24456;&#22909;&#65292;&#20570;&#30340;&#24456;&#126;&#32;&#22909;&#12290;&#37027;&#29694;&#22312;&#30693;&#36947;&#35442;&#20570;&#20160;&#40636;&#20102;&#21543;&#65311;<br>
	 * Message: Good job! Now what are you going to do?
	 */
	public static final NpcStringId GOOD_JOB_NOW_WHAT_ARE_YOU_GOING_TO_DO;
	
	/**
	 * ID: 99720<br>
	 * Message: ˂AlN^[ĂIA^Vւ̈ĂȂ̂ȂłH<br>
	 * Message: &#21890;&#65281;&#29992;&#40670;&#24515;&#20570;&#65281;&#37117;&#27969;&#20986;&#20358;&#20102;&#22043;&#65281;<br>
	 * Message: Keep it coming!
	 */
	public static final NpcStringId KEEP_IT_COMING;
	
	/**
	 * ID: 99721<br>
	 * Message: ACCBC悢I傤I<br>
	 * Message: &#21834;&#126;&#30495;&#33298;&#26381;&#65281;&#20877;&#28550;&#28550;&#30475;&#65281;<br>
	 * Message: That's what I'm talking about!
	 */
	public static final NpcStringId THATS_WHAT_IM_TALKING_ABOUT;
	
	/**
	 * ID: 99722<br>
	 * Message: Ai^̈Ŗ銴DDDƗ~́I<br>
	 * Message: &#21653;&#22165;&#21653;&#22165;&#126;&#24456;&#22909;&#65281;&#36996;&#26377;&#27794;&#26377;&#21834;&#65311;<br>
	 * Message: May I have some more?
	 */
	public static final NpcStringId MAY_I_HAVE_SOME_MORE;
	
	/**
	 * ID: 99723<br>
	 * Message: I܂ƂɂłȂ́HڂĂ邶ȂIvv<br>
	 * Message: &#30596;&#28310;&#37117;&#19981;&#26371;&#21966;&#65311;&#27969;&#30340;&#28415;&#22320;&#37117;&#26159;&#126;<br>
	 * Message: That hit the spot!
	 */
	public static final NpcStringId THAT_HIT_THE_SPOT;
	
	/**
	 * ID: 99724<br>
	 * Message: ``ςIAA^Vւ̈ĂȂ̂I<br>
	 * Message: &#36889;&#26159;&#19981;&#26159;&#28151;&#20102;&#27700;&#21834;&#65311;&#21619;&#36947;&#24590;&#26371;&#36889;&#27171;&#21602;&#65311;<br>
	 * Message: I feel special!
	 */
	public static final NpcStringId I_FEEL_SPECIAL;
	
	/**
	 * ID: 99725<br>
	 * Message: ADDDƂ傤I<br>
	 * Message: &#21938;&#126;&#24456;&#22909;&#24456;&#22909;&#12290;&#20877;&#32380;&#32396;&#65292;&#24930;&#24930;&#30340;&#22909;&#36215;&#20358;&#20102;&#12290;<br>
	 * Message: I think it's working!
	 */
	public static final NpcStringId I_THINK_ITS_WORKING;
	
	/**
	 * ID: 99726<br>
	 * Message: CbIȂ́Iw^N\IAɂȂႤI<br>
	 * Message: &#21890;&#65281;&#19981;&#26159;&#37027;&#20818;&#65281;&#26159;&#36889;&#35041;&#21862;&#65292;&#36889;&#35041;&#65281;&#26159;&#30475;&#25105;&#23567;&#65292;&#25152;&#20197;&#38568;&#20415;&#28550;&#28550;&#26159;&#21966;&#65311;<br>
	 * Message: You DO understand!
	 */
	public static final NpcStringId YOU_DO_UNDERSTAND;
	
	/**
	 * ID: 99727<br>
	 * Message: E@[ÎȂ`DDD˂A̖{ɃlN^[́H<br>
	 * Message: &#21978;&#22036;&#21624;&#21624;&#65281;&#20320;&#36889;&#26159;&#20160;&#40636;&#65281;&#26159;&#31070;&#37202;&#21966;&#65311;<br>
	 * Message: Yuck! What is this? Ha Ha just kidding!
	 */
	public static final NpcStringId YUCK_WHAT_IS_THIS_HA_HA_JUST_KIDDING;
	
	/**
	 * ID: 99728<br>
	 * Message: ˂A肵ĂILCɈĂȂAlN^[LCɂ̂؂I<br>
	 * Message: &#22909;&#22909;&#20570;&#65281;&#21482;&#35201;&#39221;&#20116;&#29942;&#23601;&#26371;&#35722;&#25104;&#22823;&#33899;&#34310;&#30340;&#65281;<br>
	 * Message: A total of five and I'll be twice as alive!
	 */
	public static final NpcStringId A_TOTAL_OF_FIVE_AND_ILL_BE_TWICE_AS_ALIVE;
	
	/**
	 * ID: 99729<br>
	 * Message: ɖlN^[~́I<br>
	 * Message: &#31070;&#37202;&#20013;&#26368;&#22909;&#30340;&#26524;&#28982;&#26159;&#33899;&#34310;&#31070;&#37202;&#65281;&#21704;&#21704;&#21704;&#21704;&#65281;<br>
	 * Message: Nectar is sublime!
	 */
	public static final NpcStringId NECTAR_IS_SUBLIME;
	
	/**
	 * ID: 99730<br>
	 * Message: AbIA^VA@ꂽ`͖Ȃ̂I肢炾͂߂āI<br>
	 * Message: &#21769;&#21568;&#65311;&#25171;&#25105;&#65311;&#25171;&#25105;&#26159;&#21966;&#65311;<br>
	 * Message: You call that a hit?
	 */
	public static final NpcStringId YOU_CALL_THAT_A_HIT;
	
	/**
	 * ID: 99731<br>
	 * Message: A^V߂ȂŁ`߂ĂI@ȂłIA^V́AAi^̈~́`<br>
	 * Message: &#21769;&#21938;&#65281;&#31455;&#28982;&#29694;&#22312;&#32102;&#25105;&#20098;&#25171;&#65311;&#19981;&#26159;&#35201;&#20320;&#28550;&#31070;&#37202;&#21966;&#65311;<br>
	 * Message: Why are you hitting me? Ouch, stop it! Give me nectar!
	 */
	public static final NpcStringId WHY_ARE_YOU_HITTING_ME_OUCH_STOP_IT_GIVE_ME_NECTAR;
	
	/**
	 * ID: 99732<br>
	 * Message: Ai^̈Ȃ́IꂶAA^VނႤI<br>
	 * Message: &#21890;&#21890;&#65292;&#22816;&#20102;&#21543;&#65311;&#36889;&#27171;&#26371;&#26543;&#21734;&#65311;<br>
	 * Message: Stop or I'll wilt!
	 */
	public static final NpcStringId STOP_OR_ILL_WILT;
	
	/**
	 * ID: 99733<br>
	 * Message: A^VƂ̈ĂC͂Ȃ́HA^V́AAi^̈̂lN^[~́I<br>
	 * Message: &#19981;&#39178;&#25105;&#21453;&#32780;&#24819;&#21507;&#25481;&#25105;&#26159;&#21966;&#65311;&#22909;&#65292;&#38568;&#20320;&#20415;&#126;&#19981;&#32102;&#31070;&#37202;&#23601;&#27515;&#32102;&#20320;&#30475;&#65281;<br>
	 * Message: I'm not fully grown yet! Oh well, do what you will. I'll fade away without nectar anyway!
	 */
	public static final NpcStringId IM_NOT_FULLY_GROWN_YET_OH_WELL_DO_WHAT_YOU_WILL_ILL_FADE_AWAY_WITHOUT_NECTAR_ANYWAY;
	
	/**
	 * ID: 99734<br>
	 * Message: ܂́Iɂ̂͂Ȃ́IlN^[~́I<br>
	 * Message: &#20877;&#25171;&#21568;&#65281;&#20877;&#25171;&#21568;&#65281;&#32;<br>
	 * Message: Go ahead and hit me again. It won't do you any good!
	 */
	public static final NpcStringId GO_AHEAD_AND_HIT_ME_AGAIN_IT_WONT_DO_YOU_ANY_GOOD;
	
	/**
	 * ID: 99735<br>
	 * Message: ̂܂܂ႵꂿႤ́IA^VǂȂĂ悢ẮH<br>
	 * Message: &#36889;&#27171;&#26371;&#26543;&#30340;&#126;&#25105;&#19981;&#31649;&#22217;&#126;<br>
	 * Message: Woe is me! I'm wilting!
	 */
	public static final NpcStringId WOE_IS_ME_IM_WILTING;
	
	/**
	 * ID: 99736<br>
	 * Message: A^VꂽAȂɂcȂHȂɃA^V̂ƌȂ́HƂAi^̈͏IĂ܂́H<br>
	 * Message: &#21890;&#65292;&#25105;&#36889;&#27171;&#27515;&#20102;&#65292;&#20160;&#40636;&#23542;&#29289;&#37117;&#27794;&#26377;&#20102;&#21734;&#65311;&#31070;&#37202;&#26377;&#37027;&#40636;&#29645;&#36020;&#21966;&#65311;<br>
	 * Message: I'm not fully grown yet! How about some nectar to ease my pain?
	 */
	public static final NpcStringId IM_NOT_FULLY_GROWN_YET_HOW_ABOUT_SOME_NECTAR_TO_EASE_MY_PAIN;
	
	/**
	 * ID: 99737<br>
	 * Message: Aʂ̂ƍlĂłHȂ񂶂AAi^̈̓A^Vɓ`ĂȂ́IƈāI<br>
	 * Message: &#20320;&#23601;&#22909;&#22909;&#126;&#30340;&#30333;&#36027;&#24037;&#22827;&#21543;&#65281;<br>
	 * Message: The end is near!
	 */
	public static final NpcStringId THE_END_IS_NEAR;
	
	/**
	 * ID: 99738<br>
	 * Message: lFAA^VĂ`lN^[x߂ɂȂāAm炸Ďʂ̂ƈꏏI<br>
	 * Message: &#20027;&#20154;&#25937;&#25937;&#25105;&#21543;&#126;&#36899;&#19968;&#28404;&#31070;&#37202;&#37117;&#27794;&#22160;&#36942;&#23601;&#35201;&#27515;&#21862;&#126;<br>
	 * Message: Pretty please... with sugar on top, give me some nectar!
	 */
	public static final NpcStringId PRETTY_PLEASE_WITH_SUGAR_ON_TOP_GIVE_ME_SOME_NECTAR;
	
	/**
	 * ID: 99739<br>
	 * Message: ̂܂܂ƃA^VA܂ĂӖȂA邵Ȃ̂ˁB߂DDD<br>
	 * Message: &#36889;&#27171;&#27515;&#20102;&#23601;&#35722;&#25104;&#20062;&#19984;&#21862;&#126;<br>
	 * Message: If I die without nectar, you'll get nothing.
	 */
	public static final NpcStringId IF_I_DIE_WITHOUT_NECTAR_YOULL_GET_NOTHING;
	
	/**
	 * ID: 99740<br>
	 * Message: 炵߂Ȃ́I񂾂OẮI30bȓɂȂȂAAႤI<br>
	 * Message: &#21147;&#37327;&#28472;&#28472;&#19978;&#21319;&#21734;&#65281;&#20877;&#31561;&#51;&#48;&#31186;&#23601;&#21487;&#20197;&#38283;&#28316;&#20102;&#65281;<br>
	 * Message: I'm feeling better! Another thirty seconds and I'll be out of here!
	 */
	public static final NpcStringId IM_FEELING_BETTER_ANOTHER_THIRTY_SECONDS_AND_ILL_BE_OUT_OF_HERE;
	
	/**
	 * ID: 99741<br>
	 * Message: 20bIA^Vւ̈ĂȂ񂾂́H<br>
	 * Message: &#50;&#48;&#31186;&#24460;&#23601;&#33287;&#20320;&#20497;&#35498;&#20877;&#35211;&#20102;&#65281;<br>
	 * Message: Twenty seconds and it's ciao, baby!
	 */
	public static final NpcStringId TWENTY_SECONDS_AND_ITS_CIAO_BABY;
	
	/**
	 * ID: 99742<br>
	 * Message: Ac10bI9DDD8DDD7DDD<br>
	 * Message: &#22909;&#32822;&#65292;&#21482;&#21097;&#49;&#48;&#31186;&#20102;&#65281;&#32;&#57;&#46;&#46;&#46;&#32;&#56;&#46;&#46;&#46;&#32;&#55;&#46;&#46;&#46;&#33;<br>
	 * Message: Woohoo, just ten seconds left! nine... eight... seven!
	 */
	public static final NpcStringId WOOHOO_JUST_TEN_SECONDS_LEFT_NINE_EIGHT_SEVEN;
	
	/**
	 * ID: 99743<br>
	 * Message: lN^[ȂȂA2ɋAႤI<br>
	 * Message: &#35201;&#26159;&#19981;&#32102;&#31070;&#37202;&#30340;&#35441;&#65292;&#50;&#20998;&#37912;&#24460;&#23601;&#26371;&#36305;&#25481;&#22217;&#126;<br>
	 * Message: Give me nectar or I'll be gone in two minutes!
	 */
	public static final NpcStringId GIVE_ME_NECTAR_OR_ILL_BE_GONE_IN_TWO_MINUTES;
	
	/**
	 * ID: 99744<br>
	 * Message: lN^[ȂȂA1ɃTiȂ񂾂I<br>
	 * Message: &#35201;&#26159;&#19981;&#32102;&#31070;&#37202;&#30340;&#35441;&#65292;&#49;&#20998;&#37912;&#24460;&#23601;&#35498;&#25308;&#25308;&#22217;&#126;<br>
	 * Message: Give me nectar or I'll be gone in one minute!
	 */
	public static final NpcStringId GIVE_ME_NECTAR_OR_ILL_BE_GONE_IN_ONE_MINUTE;
	
	/**
	 * ID: 99745<br>
	 * Message: A^VˁAAi^̖̂ƂzẮBˁÃA^V̓Ai^ɂςẮB܂܂ŌCłĂ˂IƂI<br>
	 * Message: &#22909;&#32822;&#65281;&#36867;&#36305;&#25104;&#21151;&#65281;&#36889;&#20123;&#31528;&#34507;&#65292;&#22909;&#33258;&#28858;&#20043;&#21543;&#65281;<br>
	 * Message: So long suckers!
	 */
	public static final NpcStringId SO_LONG_SUCKERS;
	
	/**
	 * ID: 99746<br>
	 * Message: ĉȂ̂킩HAi^ɂꂪłAxƎv́B܂܂傤ˁI<br>
	 * Message: &#21508;&#20301;&#20877;&#35211;&#126;&#24456;&#21487;&#24796;&#65292;&#22823;&#33899;&#34310;&#25105;&#35201;&#28040;&#22833;&#21862;&#65281;<br>
	 * Message: I'm out of here!
	 */
	public static final NpcStringId IM_OUT_OF_HERE;
	
	/**
	 * ID: 99747<br>
	 * Message: ܂ȂIA^VAAIȂ񂶂Ã|iɂ񂾂IȂȂ`I<br>
	 * Message: &#28858;&#26178;&#24050;&#26202;&#126;&#25105;&#35201;&#36208;&#20154;&#20102;&#126;&#22909;&#22909;&#29609;&#20818;&#21543;&#126;<br>
	 * Message: I must be going! Have fun everybody!
	 */
	public static final NpcStringId I_MUST_BE_GOING_HAVE_FUN_EVERYBODY;
	
	/**
	 * ID: 99748<br>
	 * Message: Aʂ̎ԂȂ́BɈ܂łɁAA^Vւ̈łĂˁI<br>
	 * Message: &#22137;&#22137;&#22137;&#22137;&#126;&#32080;&#26463;&#20102;&#12290;&#25910;&#36215;&#25152;&#26377;&#27494;&#22120;&#65292;&#25361;&#25136;&#19979;&#20491;&#27231;&#26371;&#21543;&#126;<br>
	 * Message: Time is up! Put your weapons down!
	 */
	public static final NpcStringId TIME_IS_UP_PUT_YOUR_WEAPONS_DOWN;
	
	/**
	 * ID: 99749<br>
	 * Message: IȈāA΂ĂĂDDDAă_Ǝv́B܂łĂꂽ񂾂ǁAsˁB{ɃSˁB<br>
	 * Message: &#30495;&#21487;&#24796;&#32822;&#126;&#37117;&#39178;&#22823;&#20102;&#36996;&#35731;&#23427;&#32102;&#36305;&#20102;&#65281;&#35201;&#26159;&#25105;&#65292;&#26089;&#23601;&#21435;&#25758;&#29254;&#21862;&#65281;&#21703;&#21704;&#21704;&#21704;&#65281;<br>
	 * Message: Good for me, bad for you!
	 */
	public static final NpcStringId GOOD_FOR_ME_BAD_FOR_YOU;
	
	/**
	 * ID: 99750<br>
	 * Message: AFˁI<br>
	 * Message: &#21734;&#65292;&#32882;&#38899;&#19981;&#37679;&#21908;&#65311;<br>
	 * Message: Soundtastic!
	 */
	public static final NpcStringId SOUNDTASTIC;
	
	/**
	 * ID: 99751<br>
	 * Message: ˂A˂Aȉ̂ĂH<br>
	 * Message: &#27138;&#22120;&#19981;&#37679;&#65292;&#20294;&#27794;&#26377;&#27468;&#26354;&#32822;&#12290;&#35201;&#25105;&#20358;&#21809;&#19968;&#39318;&#21966;&#65311;<br>
	 * Message: I can sing along if you like?
	 */
	public static final NpcStringId I_CAN_SING_ALONG_IF_YOU_LIKE;
	
	/**
	 * ID: 99752<br>
	 * Message: Ă΂炵́IFł`̂Ȃ̂˂I<br>
	 * Message: &#30495;&#26834;&#30340;&#38899;&#27138;&#65281;<br>
	 * Message: I think you need some backup!
	 */
	public static final NpcStringId I_THINK_YOU_NEED_SOME_BACKUP;
	
	/**
	 * ID: 99753<br>
	 * Message: CɂȂĂ`ĂI<br>
	 * Message: &#24863;&#35258;&#30495;&#22909;&#126;&#20877;&#24392;&#24392;&#30475;&#65281;<br>
	 * Message: Keep up that rhythm and you'll be a star!
	 */
	public static final NpcStringId KEEP_UP_THAT_RHYTHM_AND_YOULL_BE_A_STAR;
	
	/**
	 * ID: 99754<br>
	 * Message: A^V̂߂ɒeẮHꂵI<br>
	 * Message: &#20811;&#39791;&#35582;&#30340;&#26059;&#24459;&#30495;&#20196;&#20154;&#20670;&#24515;&#65281;<br>
	 * Message: My heart yearns for more music.
	 */
	public static final NpcStringId MY_HEART_YEARNS_FOR_MORE_MUSIC;
	
	/**
	 * ID: 99755<br>
	 * Message: ƁIςȂHA^Vւ̈ĂȂ̂Ȃ́H<br>
	 * Message: &#22909;&#22909;&#30340;&#37197;&#37197;&#38899;&#65281;&#37027;&#37002;&#37679;&#20102;&#65281;<br>
	 * Message: You're out of tune again!
	 */
	public static final NpcStringId YOURE_OUT_OF_TUNE_AGAIN;
	
	/**
	 * ID: 99756<br>
	 * Message: |IXSꂵI<br>
	 * Message: &#30495;&#26159;&#24859;&#25171;&#28151;&#21834;&#65281;&#38750;&#24120;&#22909;&#65281;<br>
	 * Message: This is awful!
	 */
	public static final NpcStringId THIS_IS_AWFUL;
	
	/**
	 * ID: 99757<br>
	 * Message: ``AĝYYĂIȂ𕷂ƒĂǁAA^V̏ꍇ|HȊˁH<br>
	 * Message: &#21834;&#21834;&#126;&#126;&#36523;&#23376;&#23601;&#35201;&#25950;&#38283;&#20102;&#65281;<br>
	 * Message: I think I broke something!
	 */
	public static final NpcStringId I_THINK_I_BROKE_SOMETHING;
	
	/**
	 * ID: 99758<br>
	 * Message: A̘aIōIƕĂȂ́I<br>
	 * Message: &#21734;&#65292;&#36889;&#21512;&#38899;&#65281;&#30495;&#26159;&#32654;&#21574;&#20102;&#65281;&#20877;&#24392;&#24392;&#30475;&#65281;<br>
	 * Message: What a lovely melody! Play it again!
	 */
	public static final NpcStringId WHAT_A_LOVELY_MELODY_PLAY_IT_AGAIN;
	
	/**
	 * ID: 99759<br>
	 * Message: AĨTEh́IAi^A~[WVɂȂI<br>
	 * Message: &#23601;&#26159;&#36889;&#20491;&#65281;&#36889;&#23601;&#26159;&#25105;&#35201;&#30340;&#26059;&#24459;&#65281;&#20320;&#65292;&#24819;&#19981;&#24819;&#30070;&#27468;&#26143;&#21834;&#65311;<br>
	 * Message: Music to my, uh... ears!
	 */
	public static final NpcStringId MUSIC_TO_MY_UH_EARS;
	
	/**
	 * ID: 99760<br>
	 * Message: Ȃ񂶂_I@Ă͈炽ȂI<br>
	 * Message: &#20877;&#24590;&#40636;&#25970;&#36889;&#29609;&#24847;&#20818;&#65292;&#20063;&#24471;&#19981;&#21040;&#22909;&#26481;&#35199;&#30340;&#21862;&#65281;<br>
	 * Message: You need music lessons!
	 */
	public static final NpcStringId YOU_NEED_MUSIC_LESSONS;
	
	/**
	 * ID: 99761<br>
	 * Message: ɂ̂IA^V͉ýI܂߂ɂĂI<br>
	 * Message: &#24456;&#30171;&#32822;&#65281;&#21482;&#33021;&#29992;&#27138;&#22120;&#25970;&#21862;&#65281;<br>
	 * Message: I can't hear you!
	 */
	public static final NpcStringId I_CANT_HEAR_YOU;
	
	/**
	 * ID: 99762<br>
	 * Message: TEhȂAA^V̐SƐĝɂ͋Ȃ́I<br>
	 * Message: &#21482;&#26377;&#22909;&#38899;&#27138;&#25165;&#33021;&#25950;&#38283;&#25105;&#30340;&#36523;&#23376;&#65281;<br>
	 * Message: You can't hurt me like that!
	 */
	public static final NpcStringId YOU_CANT_HURT_ME_LIKE_THAT;
	
	/**
	 * ID: 99763<br>
	 * Message: ꂶȂ́IAINm̊yIł́I<br>
	 * Message: &#36889;&#20491;&#19981;&#23565;&#65292;&#19981;&#26159;&#26377;&#37027;&#20491;&#21966;&#65311;&#23601;&#26159;&#25343;&#20358;&#30070;&#27599;&#19968;&#31456;&#32000;&#24565;&#21697;&#30340;&#65292;&#23601;&#29992;&#37027;&#20491;&#25970;&#21543;&#65281;<br>
	 * Message: I'm stronger than you are!
	 */
	public static final NpcStringId IM_STRONGER_THAN_YOU_ARE;
	
	/**
	 * ID: 99764<br>
	 * Message: ŉyȂ́HA^VAAĂHDDD́H{ɋAႤH<br>
	 * Message: &#28858;&#20309;&#27794;&#26377;&#38899;&#27138;&#65311;&#25105;&#35201;&#36208;&#22217;&#65311;&#30495;&#30340;&#35201;&#36208;&#20102;&#21908;&#65311;<br>
	 * Message: No music? I'm out of here!
	 */
	public static final NpcStringId NO_MUSIC_IM_OUT_OF_HERE;
	
	/**
	 * ID: 99765<br>
	 * Message: ̂́AȈo镨łĂI<br>
	 * Message: &#19981;&#26159;&#36889;&#31278;&#21050;&#32819;&#30340;&#22122;&#38899;&#65281;&#29992;&#32654;&#22937;&#30340;&#26059;&#24459;&#21862;&#65281;<br>
	 * Message: That racket is getting on my nerves! Tone it down a bit!
	 */
	public static final NpcStringId THAT_RACKET_IS_GETTING_ON_MY_NERVES_TONE_IT_DOWN_A_BIT;
	
	/**
	 * ID: 99766<br>
	 * Message: A^V́AyȂ_Ȃ̂`Œ@ӖȂ́I<br>
	 * Message: &#36889;&#22823;&#33899;&#34310;&#21482;&#26377;&#29992;&#38899;&#27138;&#25165;&#33021;&#25171;&#24471;&#38283;&#126;&#29992;&#27494;&#22120;&#26159;&#19981;&#34892;&#30340;&#65281;<br>
	 * Message: You can only hurt me through music!
	 */
	public static final NpcStringId YOU_CAN_ONLY_HURT_ME_THROUGH_MUSIC;
	
	/**
	 * ID: 99767<br>
	 * Message: yłĂIȕCIył́I<br>
	 * Message: &#29992;&#27138;&#22120;&#25970;&#21862;&#65281;&#23601;&#36319;&#20320;&#35498;&#19981;&#26159;&#36889;&#20491;&#65292;&#29992;&#27138;&#22120;&#25970;&#21862;&#65281;<br>
	 * Message: Only musical instruments can hurt me! Nothing else!
	 */
	public static final NpcStringId ONLY_MUSICAL_INSTRUMENTS_CAN_HURT_ME_NOTHING_ELSE;
	
	/**
	 * ID: 99768<br>
	 * Message: Ai^̃A^bNăXSĈˁ`łAʖʂȂ̂`Ȃ܂܂Ȃă_I<br>
	 * Message: &#24456;&#26377;&#23526;&#21147;&#21734;&#65281;&#20294;&#20840;&#37117;&#26159;&#30333;&#36027;&#24037;&#22827;&#21862;&#126;<br>
	 * Message: Your skills are impressive, but sadly, useless...
	 */
	public static final NpcStringId YOUR_SKILLS_ARE_IMPRESSIVE_BUT_SADLY_USELESS;
	
	/**
	 * ID: 99769<br>
	 * Message: nŋĂʂIA^V~͉̂Ȃ́I<br>
	 * Message: &#29992;&#37027;&#37941;&#29255;&#24590;&#40636;&#19981;&#21435;&#22806;&#38957;&#29417;&#29557;&#24618;&#29289;&#21602;&#65311;&#25105;&#35201;&#30340;&#26159;&#20811;&#39791;&#35582;&#65281;<br>
	 * Message: Catch a Chrono for me please.
	 */
	public static final NpcStringId CATCH_A_CHRONO_FOR_ME_PLEASE;
	
	/**
	 * ID: 99770<br>
	 * Message: |iƂāAAi^ɈĂ悩B܂܂ĂĂ|iłȁBAi^ƂxDDD<br>
	 * Message: &#33899;&#34310;&#29190;&#38283;&#21862;&#65281;&#65281;&#65281;<br>
	 * Message: You got me!
	 */
	public static final NpcStringId YOU_GOT_ME;
	
	/**
	 * ID: 99771<br>
	 * Message: ނނFInYႦILnn<br>
	 * Message: &#20320;&#21435;&#32102;&#25105;&#35722;&#25104;&#20062;&#19984;&#21543;&#65281;<br>
	 * Message: Now look at what you've done!
	 */
	public static final NpcStringId NOW_LOOK_AT_WHAT_YOUVE_DONE;
	
	/**
	 * ID: 99772<br>
	 * Message: A^VƂ̎voA؂ɂĂˁ`<br>
	 * Message: &#29190;&#20986;&#20123;&#22934;&#24618;&#21543;&#65281;<br>
	 * Message: You win!
	 */
	public static final NpcStringId YOU_WIN;
	
	/**
	 * ID: 99773<br>
	 * Message: ꂪAi^ƃA^V̈̌I<br>
	 * Message: &#24685;&#21916;&#30332;&#36001;&#65281;&#65281;<br>
	 * Message: Squashed......
	 */
	public static final NpcStringId SQUASHED;
	
	/**
	 * ID: 99774<br>
	 * Message: Ai^̑zA󂯎́BATiˁDDD<br>
	 * Message: &#21029;&#25226;&#25105;&#30340;&#27515;&#35338;&#27969;&#20659;&#26044;&#22806;&#65281;<br>
	 * Message: Don't tell anyone!
	 */
	public static final NpcStringId DONT_TELL_ANYONE;
	
	/**
	 * ID: 99775<br>
	 * Message: ڂŃAi^̊炪Ȃ́DDDłˁAAi^͖̎YȂB܂ˁH<br>
	 * Message: &#21834;&#65292;&#33144;&#23376;&#27969;&#20986;&#20358;&#20102;&#65281;<br>
	 * Message: Gross! My guts are coming out!
	 */
	public static final NpcStringId GROSS_MY_GUTS_ARE_COMING_OUT;
	
	/**
	 * ID: 99776<br>
	 * Message: `A悩́IȂ́`Ał܂]邱Ƃł邩ȁHƂĂꂠˁB<br>
	 * Message: &#25343;&#33879;&#36889;&#20491;&#32102;&#25105;&#28414;&#34507;&#126;<br>
	 * Message: Take it and go.
	 */
	public static final NpcStringId TAKE_IT_AND_GO;
	
	/**
	 * ID: 99777<br>
	 * Message: Ai^̈Aς󂯂Ƃ́BłAʂꂾˁBAi^̂ƁAYȂI܂ˁI<br>
	 * Message: &#21888;&#21834;&#21834;&#65281;&#22909;&#28779;&#22823;&#65281;&#26412;&#20358;&#33021;&#36867;&#25481;&#30340;&#8230;&#65281;<br>
	 * Message: I should've left when I could!
	 */
	public static final NpcStringId I_SHOULDVE_LEFT_WHEN_I_COULD;
	
	/**
	 * ID: 99778<br>
	 * Message: |iAꂿ́Ȉo`HoȂƂĂAx˂ˁI<br>
	 * Message: &#21508;&#20301;&#65292;&#36889;&#35041;&#30340;&#33899;&#34310;&#29190;&#38283;&#21862;&#65281;&#26377;&#23542;&#29289;&#25481;&#19979;&#20358;&#21734;&#65281;&#21703;&#21704;&#21704;&#21704;<br>
	 * Message: Now look what you have done!
	 */
	public static final NpcStringId NOW_LOOK_WHAT_YOU_HAVE_DONE;
	
	/**
	 * ID: 99779<br>
	 * Message: IꂿIA^V̒̈````<br>
	 * Message: &#21710;&#21938;&#65281;&#29190;&#38283;&#21862;&#65281;&#35041;&#38754;&#30340;&#26481;&#35199;&#22057;&#21862;&#22057;&#21862;&#126;<br>
	 * Message: I feel dirty!
	 */
	public static final NpcStringId I_FEEL_DIRTY;
	
	/**
	 * ID: 99780<br>
	 * Message: ߂ĂȂ́IDĂˁI<br>
	 * Message: &#21703;&#21704;&#21704;&#21704;&#65292;&#22909;&#22909;&#30340;&#25171;&#25171;&#30475;&#65281;<br>
	 * Message: Better luck next time!
	 */
	public static final NpcStringId BETTER_LUCK_NEXT_TIME;
	
	/**
	 * ID: 99781<br>
	 * Message: AꂢȁH<br>
	 * Message: &#21769;&#21568;&#65311;&#36996;&#30495;&#26377;&#20841;&#25226;&#21047;&#23376;&#21734;&#65311;<br>
	 * Message: Nice shot!
	 */
	public static final NpcStringId NICE_SHOT;
	
	/**
	 * ID: 99782<br>
	 * Message: ƁIƈ~́I<br>
	 * Message: &#20877;&#25171;&#21568;&#65281;&#20877;&#25171;&#65281;<br>
	 * Message: I'm not afraid of you!
	 */
	public static final NpcStringId IM_NOT_AFRAID_OF_YOU;
	
	/**
	 * ID: 99783<br>
	 * Message: A^V̓Ai^̈ň̂I<br>
	 * Message: &#25105;&#22240;&#20320;&#30340;&#25171;&#25802;&#32780;&#25104;&#38263;&#65281;<br>
	 * Message: If I knew this was going to happen, I would have stayed home!
	 */
	public static final NpcStringId IF_I_KNEW_THIS_WAS_GOING_TO_HAPPEN_I_WOULD_HAVE_STAYED_HOME;
	
	/**
	 * ID: 99784<br>
	 * Message: ł߂ς̈Ȃ́HȂ񂶂A^V߂Ȃ́I<br>
	 * Message: &#20877;&#20351;&#40670;&#21185;&#20818;&#126;&#36889;&#27171;&#25105;&#26371;&#36208;&#20154;&#30340;&#21908;&#126;<br>
	 * Message: Try harder or I'm out of here!
	 */
	public static final NpcStringId TRY_HARDER_OR_IM_OUT_OF_HERE;
	
	/**
	 * ID: 99785<br>
	 * Message: ̒xŖƂłvẮH<br>
	 * Message: &#25165;&#36889;&#40636;&#40670;&#21147;&#23601;&#20197;&#28858;&#25105;&#26371;&#29190;&#38283;&#21966;&#65311;&#32;<br>
	 * Message: I'm tougher than I look!
	 */
	public static final NpcStringId IM_TOUGHER_THAN_I_LOOK;
	
	/**
	 * ID: 99786<br>
	 * Message: ˁBA^VA̍DB<br>
	 * Message: &#19981;&#37679;&#30340;&#25915;&#25802;&#65292;&#36996;&#31639;&#33021;&#25171;&#27515;&#38587;&#33980;&#34821;&#12290;<br>
	 * Message: Good strike!
	 */
	public static final NpcStringId GOOD_STRIKE;
	
	/**
	 * ID: 99787<br>
	 * Message: AI[AEI͂ӂ<br>
	 * Message: &#37027;&#35041;&#37027;&#35041;&#65281;&#21491;&#37002;&#19968;&#40670;&#65281;&#21834;&#126;&#22909;&#33298;&#26381;&#12290;<br>
	 * Message: Oh my gourd!
	 */
	public static final NpcStringId OH_MY_GOURD;
	
	/**
	 * ID: 99788<br>
	 * Message: ƂAAi^̈Ă̒x̂̂Ȃ́H<br>
	 * Message: &#37027;&#20063;&#33021;&#31639;&#26159;&#25915;&#25802;&#21966;&#65311;&#25214;&#20491;&#26377;&#23526;&#21147;&#40670;&#30340;&#20358;&#21543;&#65281;<br>
	 * Message: That's all you've got?
	 */
	public static final NpcStringId THATS_ALL_YOUVE_GOT;
	
	/**
	 * ID: 99789<br>
	 * Message: A^V̂ƂlāÎƂlȂă_Ȃ́Iƒ@āI<br>
	 * Message: &#19981;&#29992;&#21435;&#24819;&#65281;&#21482;&#31649;&#25171;&#65281;&#25171;&#21543;&#65281;<br>
	 * Message: Why me?
	 */
	public static final NpcStringId WHY_ME;
	
	/**
	 * ID: 99790<br>
	 * Message: lN^[~́IǂĂlN^[~́I<br>
	 * Message: &#25226;&#31070;&#37202;&#25343;&#20358;&#65281;&#33899;&#34310;&#31070;&#37202;&#65281;<br>
	 * Message: Bring me nectar!
	 */
	public static final NpcStringId BRING_ME_NECTAR;
	
	/**
	 * ID: 99791<br>
	 * Message: A^VˁAlN^[Ƒ傫Ȃ̂I<br>
	 * Message: &#21482;&#26377;&#21917;&#31070;&#37202;&#65292;&#25105;&#25165;&#33021;&#38263;&#22823;&#21734;&#126;<br>
	 * Message: I must have nectar to grow!
	 */
	public static final NpcStringId I_MUST_HAVE_NECTAR_TO_GROW;
	
	/**
	 * ID: 99792<br>
	 * Message: AAi^̈ςՁI肭΃A^VALCɈI<br>
	 * Message: &#20358;&#65292;&#24555;&#39178;&#39178;&#30475;&#21543;&#65281;&#39178;&#24471;&#22909;&#24685;&#21916;&#30332;&#36001;&#65292;&#39178;&#19981;&#22909;&#35722;&#25104;&#20062;&#19984;&#65281;<br>
	 * Message: Give me some nectar quickly or you'll get nothing!
	 */
	public static final NpcStringId GIVE_ME_SOME_NECTAR_QUICKLY_OR_YOULL_GET_NOTHING;
	
	/**
	 * ID: 99793<br>
	 * Message: ˂ÂlN^[傤IA^V̐SƂ͂yRyRI<br>
	 * Message: &#32102;&#25105;&#19968;&#40670;&#31070;&#37202;&#21543;&#126;&#32922;&#23376;&#22909;&#39187;&#126;<br>
	 * Message: Please give me some nectar! I'm hungry!
	 */
	public static final NpcStringId PLEASE_GIVE_ME_SOME_NECTAR_IM_HUNGRY;
	
	/**
	 * ID: 99794<br>
	 * Message: AlN^[ςāI<br>
	 * Message: &#20358;&#65292;&#24555;&#21435;&#25343;&#31070;&#37202;&#20358;&#21543;&#12290;<br>
	 * Message: Nectar please!
	 */
	public static final NpcStringId NECTAR_PLEASE;
	
	/**
	 * ID: 99795<br>
	 * Message: lN^[DDDăA^Vւ̈̕\Ȃ́BA^V͂đ傫Ȃ́I<br>
	 * Message: &#33509;&#25343;&#31070;&#37202;&#20358;&#65292;&#21917;&#20102;&#20043;&#24460;&#25105;&#23601;&#28858;&#20320;&#24555;&#36895;&#30340;&#25104;&#38263;&#65281;<br>
	 * Message: Nectar will make me grow quickly!
	 */
	public static final NpcStringId NECTAR_WILL_MAKE_ME_GROW_QUICKLY;
	
	/**
	 * ID: 99796<br>
	 * Message: ȖnȂɒẮHĆB傫ȂĂA^VI<br>
	 * Message: &#36889;&#27171;&#30340;&#23567;&#33899;&#34310;&#20063;&#35201;&#21507;&#65311;&#25343;&#31070;&#37202;&#20358;&#30475;&#30475;&#65292;&#25105;&#23601;&#20877;&#38263;&#22823;&#32102;&#20320;&#30475;&#65281;<br>
	 * Message: Don't you want a bigger squash? Give me some nectar and I'll grow much larger!
	 */
	public static final NpcStringId DONT_YOU_WANT_A_BIGGER_SQUASH_GIVE_ME_SOME_NECTAR_AND_ILL_GROW_MUCH_LARGER;
	
	/**
	 * ID: 99797<br>
	 * Message: Ai^ɑ̂ĺBāIAi^ɈĂ悩`A^V̈󂯎~߂Ă邩`A^V_ɂȂĂ`Ō܂ňꏏɈĂ悤DDDǂH_ȁH<br>
	 * Message: &#21703;&#21704;&#21704;&#21704;&#65292;&#39178;&#22909;&#26377;&#22909;&#26481;&#35199;&#126;&#37027;&#39178;&#19981;&#22909;&#21602;&#65311;&#25105;&#20063;&#19981;&#30693;&#36947;&#126;<br>
	 * Message: If you raise me well, you'll get prizes! Or not...
	 */
	public static final NpcStringId IF_YOU_RAISE_ME_WELL_YOULL_GET_PRIZES_OR_NOT;
	
	/**
	 * ID: 99798<br>
	 * Message: ƃAi^ɂƂƎvIA^V́AǂȂƂĂAi^̈΂񂺂񕽋C`MĂ邩ˁI<br>
	 * Message: &#24819;&#35201;&#30332;&#22823;&#36001;&#21966;&#65311;&#20294;&#25105;&#21916;&#27489;&#23567;&#20062;&#19984;&#32822;&#126;<br>
	 * Message: You are here for the stuff, eh? Well it's mine, all mine!
	 */
	public static final NpcStringId YOU_ARE_HERE_FOR_THE_STUFF_EH_WELL_ITS_MINE_ALL_MINE;
	
	/**
	 * ID: 99799<br>
	 * Message: ˂AA^VMălN^[ĂIA^Vn炫ƂKI<br>
	 * Message: &#20358;&#65292;&#30456;&#20449;&#25105;&#65292;&#20760;&#31649;&#23559;&#31070;&#37202;&#28550;&#19978;&#65281;&#65281;&#25105;&#26371;&#35731;&#20320;&#30332;&#22823;&#36001;&#21862;&#65281;&#65281;&#65281;<br>
	 * Message: Trust me... give me nectar and I'll become a giant squash!
	 */
	public static final NpcStringId TRUST_ME_GIVE_ME_NECTAR_AND_ILL_BECOME_A_GIANT_SQUASH;
	
	/**
	 * ID: 528551<br>
	 * Message: Ȃق炵Ƃ̂͂ǂ̌IĂ₵ȂB<br>
	 * Message: &#23526;&#22312;&#26159;&#32893;&#19981;&#19979;&#21435;&#20102;&#65292;&#25105;&#28961;&#27861;&#20877;&#32893;&#20320;&#24375;&#35422;&#22890;&#29702;&#20102;&#65281;<br>
	 * Message: There's nothing you can't say. I can't listen to you anymore!
	 */
	public static final NpcStringId THERES_NOTHING_YOU_CANT_SAY_I_CANT_LISTEN_TO_YOU_ANYMORE;
	
	/**
	 * ID: 528651<br>
	 * Message: ȂɓXƏoĂ̂ɁAAĂƂ͂̃U}HzzzB<br>
	 * Message: &#30475;&#20320;&#19968;&#33225;&#29702;&#30452;&#27683;&#22767;&#30340;&#65292;&#32080;&#26524;&#21371;&#19981;&#36942;&#22914;&#27492;&#21834;&#12290;&#21628;&#21628;&#21628;&#12290;<br>
	 * Message: You advanced bravely but got such a tiny result. Hohoho.
	 */
	public static final NpcStringId YOU_ADVANCED_BRAVELY_BUT_GOT_SUCH_A_TINY_RESULT_HOHOHO;
	
	/**
	 * ID: 1000001<br>
	 * Message: N҂𔭌܂B<br>
	 * Message: &#30332;&#29694;&#26410;&#32147;&#35377;&#21487;&#30340;&#30446;&#27161;&#12290;<br>
	 * Message: A non-permitted target has been discovered.
	 */
	public static final NpcStringId A_NON_PERMITTED_TARGET_HAS_BEEN_DISCOVERED;
	
	/**
	 * ID: 1000002<br>
	 * Message: NҏVXeN܂B<br>
	 * Message: &#21855;&#21205;&#20405;&#20837;&#32773;&#28040;&#28357;&#31995;&#32113;&#12290;<br>
	 * Message: Intruder removal system initiated.
	 */
	public static final NpcStringId INTRUDER_REMOVAL_SYSTEM_INITIATED;
	
	/**
	 * ID: 1000003<br>
	 * Message: NҏDDD<br>
	 * Message: &#28040;&#28357;&#20405;&#20837;&#32773;&#20013;&#12290;<br>
	 * Message: Removing intruders.
	 */
	public static final NpcStringId REMOVING_INTRUDERS;
	
	/**
	 * ID: 1000004<br>
	 * Message: vIȃG[܂B<br>
	 * Message: &#30332;&#29983;&#33268;&#21629;&#37679;&#35492;&#12290;<br>
	 * Message: A fatal error has occurred.
	 */
	public static final NpcStringId A_FATAL_ERROR_HAS_OCCURRED;
	
	/**
	 * ID: 1000005<br>
	 * Message: VXeI܂DDD<br>
	 * Message: &#31995;&#32113;&#38364;&#38281;&#20013;&#46;&#46;&#46;<br>
	 * Message: System is being shut down...
	 */
	public static final NpcStringId SYSTEM_IS_BEING_SHUT_DOWN;
	
	/**
	 * ID: 1000006<br>
	 * Message: DDDDDD<br>
	 * Message: &#46;&#46;&#46;&#46;&#46;&#46;&#32;<br>
	 * Message: ......
	 */
	public static final NpcStringId DOT_DOT_DOT_DOT_DOT_DOT;
	
	/**
	 * ID: 1000007<br>
	 * Message: oĂI<br>
	 * Message: &#32102;&#25105;&#36208;&#33879;&#30631;&#33;<br>
	 * Message: We shall see about that!
	 */
	public static final NpcStringId WE_SHALL_SEE_ABOUT_THAT;
	
	/**
	 * ID: 1000008<br>
	 * Message: ̋JAYʂI<br>
	 * Message: &#20170;&#22825;&#21463;&#21040;&#24677;&#36785;&#65292;&#32;&#19979;&#27425;&#19968;&#23450;&#22857;&#36996;&#32102;&#20320;&#33;<br>
	 * Message: I will definitely repay this humiliation!
	 */
	public static final NpcStringId I_WILL_DEFINITELY_REPAY_THIS_HUMILIATION;
	
	/**
	 * ID: 1000009<br>
	 * Message: PށI<br>
	 * Message: &#25764;&#36864;&#33;<br>
	 * Message: Retreat!
	 */
	public static final NpcStringId RETREAT;
	
	/**
	 * ID: 1000010<br>
	 * Message: 헪IɌނI<br>
	 * Message: &#20808;&#36864;&#20877;&#35498;&#33;<br>
	 * Message: Tactical retreat!
	 */
	public static final NpcStringId TACTICAL_RETREAT;
	
	/**
	 * ID: 1000011<br>
	 * Message: I<br>
	 * Message: &#20808;&#36867;&#20877;&#35498;&#33;&#33;<br>
	 * Message: Mass fleeing!
	 */
	public static final NpcStringId MASS_FLEEING;
	
	/**
	 * ID: 1000012<br>
	 * Message: v苭I<br>
	 * Message: &#27604;&#25105;&#24819;&#20687;&#20013;&#36996;&#21426;&#23475;&#33;<br>
	 * Message: It's stronger than expected!
	 */
	public static final NpcStringId ITS_STRONGER_THAN_EXPECTED;
	
	/**
	 * ID: 1000013<br>
	 * Message: oĂI<br>
	 * Message: &#19979;&#19968;&#27425;&#35201;&#35731;&#20320;&#19979;&#22320;&#29508;&#33;<br>
	 * Message: I'll kill you next time!
	 */
	public static final NpcStringId ILL_KILL_YOU_NEXT_TIME;
	
	/**
	 * ID: 1000014<br>
	 * Message: ́AĂI<br>
	 * Message: &#19979;&#27425;&#19968;&#23450;&#35731;&#20320;&#19979;&#22320;&#29508;&#33;<br>
	 * Message: I'll definitely kill you next time!
	 */
	public static final NpcStringId ILL_DEFINITELY_KILL_YOU_NEXT_TIME;
	
	/**
	 * ID: 1000015<br>
	 * Message: I苭I<br>
	 * Message: &#21756;&#33;&#32;&#21426;&#23475;&#33;<br>
	 * Message: Oh! How strong!
	 */
	public static final NpcStringId OH_HOW_STRONG;
	
	/**
	 * ID: 1000016<br>
	 * Message: N҂I<br>
	 * Message: &#26377;&#20837;&#20405;&#32773;&#33;<br>
	 * Message: Invader!
	 */
	public static final NpcStringId INVADER;
	
	/**
	 * ID: 1000017<br>
	 * Message: EĂɂȂȂDDDNNNB<br>
	 * Message: &#23601;&#31639;&#27578;&#20102;&#25105;&#65292;&#20320;&#20063;&#24471;&#19981;&#21040;&#20160;&#40636;&#65281;<br>
	 * Message: There is no reason for you to kill me! I have nothing you need!
	 */
	public static final NpcStringId THERE_IS_NO_REASON_FOR_YOU_TO_KILL_ME_I_HAVE_NOTHING_YOU_NEED;
	
	/**
	 * ID: 1000018<br>
	 * Message: ͕KDDD<br>
	 * Message: &#19979;&#27425;&#46;&#46;&#46;&#25105;&#19968;&#23450;&#26371;&#21507;&#25481;&#20320;&#30340;&#33;<br>
	 * Message: Someday you will pay!
	 */
	public static final NpcStringId SOMEDAY_YOU_WILL_PAY;
	
	/**
	 * ID: 1000019<br>
	 * Message: Ȃ΂艣񂾁I<br>
	 * Message: &#24185;&#22043;&#21482;&#25549;&#25105;&#21862;&#126;<br>
	 * Message: I won't just stand still while you hit me.
	 */
	public static final NpcStringId I_WONT_JUST_STAND_STILL_WHILE_YOU_HIT_ME;
	
	/**
	 * ID: 1000020<br>
	 * Message: قĂI<br>
	 * Message: &#19981;&#35201;&#20877;&#25171;&#20102;&#33;<br>
	 * Message: Stop hitting!
	 */
	public static final NpcStringId STOP_HITTING;
	
	/**
	 * ID: 1000021<br>
	 * Message: ̐c܂Ⴢ邺I<br>
	 * Message: &#30140;&#21040;&#39592;&#23376;&#35041;&#20102;&#33;<br>
	 * Message: It hurts to the bone!
	 */
	public static final NpcStringId IT_HURTS_TO_THE_BONE;
	
	/**
	 * ID: 1000022<br>
	 * Message: ͉I<br>
	 * Message: &#25105;&#19981;&#26159;&#20986;&#27683;&#31570;&#21862;&#33;<br>
	 * Message: Am I the neighborhood drum for beating!
	 */
	public static final NpcStringId AM_I_THE_NEIGHBORHOOD_DRUM_FOR_BEATING;
	
	/**
	 * ID: 1000023<br>
	 * Message: ėȂAėȁI<br>
	 * Message: &#26377;&#31278;&#23601;&#36319;&#25105;&#20358;&#33;<br>
	 * Message: Follow me if you want!
	 */
	public static final NpcStringId FOLLOW_ME_IF_YOU_WANT;
	
	/**
	 * ID: 1000024<br>
	 * Message: ~I<br>
	 * Message: &#25237;&#38477;&#33;<br>
	 * Message: Surrender!
	 */
	public static final NpcStringId SURRENDER;
	
	/**
	 * ID: 1000025<br>
	 * Message: A܂I<br>
	 * Message: &#21710;&#21815;&#46;&#46;&#46;&#25105;&#24555;&#27515;&#20102;&#21862;&#33;<br>
	 * Message: Oh, I'm dead!
	 */
	public static final NpcStringId OH_IM_DEAD;
	
	/**
	 * ID: 1000026<br>
	 * Message: N\Iđ҂ƂI<br>
	 * Message: &#73;&#39;&#108;&#108;&#32;&#98;&#101;&#32;&#98;&#97;&#99;&#107;&#33;<br>
	 * Message: I'll be back!
	 */
	public static final NpcStringId ILL_BE_BACK;
	
	/**
	 * ID: 1000027<br>
	 * Message: AĂȂA1疜Afi邼I<br>
	 * Message: &#25937;&#25105;&#23601;&#36865;&#20320;&#49;&#48;&#48;&#48;&#33836;&#37329;&#24163;&#32;&#33;<br>
	 * Message: I'll give you ten million arena if you let me live!
	 */
	public static final NpcStringId ILL_GIVE_YOU_TEN_MILLION_ARENA_IF_YOU_LET_ME_LIVE;
	
	/**
	 * ID: 1000028<br>
	 * Message: $s1B̖̂͂vmI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#38936;&#24735;&#19968;&#19979;&#33258;&#24049;&#26377;&#22810;&#28961;&#33021;&#21543;&#65281;<br>
	 * Message: $s1. Stop kidding yourself about your own powerlessness!
	 */
	public static final NpcStringId S1_STOP_KIDDING_YOURSELF_ABOUT_YOUR_OWN_POWERLESSNESS;
	
	/**
	 * ID: 1000029<br>
	 * Message: $s1I^̋|Ƃ͉Ă낤I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#25105;&#26371;&#35731;&#20320;&#39636;&#39511;&#20309;&#35586;&#30495;&#27491;&#30340;&#24656;&#24598;&#65281;<br>
	 * Message: $s1. I'll make you feel what true fear is!
	 */
	public static final NpcStringId S1_ILL_MAKE_YOU_FEEL_WHAT_TRUE_FEAR_IS;
	
	/**
	 * ID: 1000030<br>
	 * Message: ɂɂĂƂĂ낤B$s1Io債I<br>
	 * Message: &#31455;&#25954;&#21521;&#25105;&#25361;&#25136;&#12290;&#12300;&#36;&#115;&#49;&#12301;&#65281;&#31561;&#33879;&#30631;&#65281;<br>
	 * Message: You're really stupid to have challenged me. $s1! Get ready!
	 */
	public static final NpcStringId YOURE_REALLY_STUPID_TO_HAVE_CHALLENGED_ME_S1_GET_READY;
	
	/**
	 * ID: 1000031<br>
	 * Message: $s1BȎ肪ʂƂłv̂I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#19981;&#35201;&#20877;&#20351;&#29992;&#21516;&#27171;&#30340;&#25307;&#25976;&#20102;&#65281;<br>
	 * Message: $s1. Do you think that's going to work?!
	 */
	public static final NpcStringId S1_DO_YOU_THINK_THATS_GOING_TO_WORK;
	
	/**
	 * ID: 1000032<br>
	 * Message: ꂽ̖_AK҉񂵂Ă݂I<br>
	 * Message: &#25105;&#19968;&#23450;&#26371;&#35342;&#22238;&#34987;&#20398;&#36785;&#30340;&#21517;&#35709;&#65281;<br>
	 * Message: I will definitely reclaim my honor which has been tarnished!
	 */
	public static final NpcStringId I_WILL_DEFINITELY_RECLAIM_MY_HONOR_WHICH_HAS_BEEN_TARNISHED;
	
	/**
	 * ID: 1000033<br>
	 * Message: ȋRm݂̑󂯂Ă݂I<br>
	 * Message: &#35731;&#20320;&#30475;&#30475;&#21517;&#35709;&#34987;&#25703;&#27544;&#30340;&#39438;&#22763;&#20043;&#24680;&#65281;<br>
	 * Message: Show me the wrath of the knight whose honor has been downtrodden!
	 */
	public static final NpcStringId SHOW_ME_THE_WRATH_OF_THE_KNIGHT_WHOSE_HONOR_HAS_BEEN_DOWNTRODDEN;
	
	/**
	 * ID: 1000034<br>
	 * Message: ȋUP҂ɎI<br>
	 * Message: &#23559;&#20605;&#21892;&#32773;&#34389;&#27515;&#21543;&#65281;<br>
	 * Message: Death to the hypocrite!
	 */
	public static final NpcStringId DEATH_TO_THE_HYPOCRITE;
	
	/**
	 * ID: 1000035<br>
	 * Message: G߂𐰂炷܂ŌĖɕtƂȂAłʂI<br>
	 * Message: &#22312;&#27927;&#28165;&#25105;&#30340;&#20900;&#23624;&#20043;&#21069;&#65292;&#25105;&#26159;&#19981;&#26371;&#27515;&#30340;&#65281;<br>
	 * Message: I'll never sleep until I've shed my dishonor!
	 */
	public static final NpcStringId ILL_NEVER_SLEEP_UNTIL_IVE_SHED_MY_DISHONOR;
	
	/**
	 * ID: 1000036<br>
	 * Message: ̒􂤎҂ǂA͂I<br>
	 * Message: &#24996;&#24680;&#19990;&#20439;&#30340;&#20154;&#20497;&#65292;&#25105;&#20358;&#20102;&#65281;<br>
	 * Message: I'm here for the ones that are cursing the world!
	 */
	public static final NpcStringId IM_HERE_FOR_THE_ONES_THAT_ARE_CURSING_THE_WORLD;
	
	/**
	 * ID: 1000037<br>
	 * Message: O܂悦鍰ɂĂ낤I<br>
	 * Message: &#35731;&#20320;&#20063;&#35722;&#25104;&#20900;&#39746;&#21543;&#65281;<br>
	 * Message: I'll turn you into a malignant spirit!
	 */
	public static final NpcStringId ILL_TURN_YOU_INTO_A_MALIGNANT_SPIRIT;
	
	/**
	 * ID: 1000038<br>
	 * Message: Ƒ̗͂łOĂI<br>
	 * Message: &#20197;&#25265;&#24616;&#21644;&#24974;&#24680;&#65292;&#35419;&#21650;&#20320;&#65281;<br>
	 * Message: I'll curse you with the power of revenge and hate!
	 */
	public static final NpcStringId ILL_CURSE_YOU_WITH_THE_POWER_OF_REVENGE_AND_HATE;
	
	/**
	 * ID: 1000039<br>
	 * Message: OVẢĥ߂ɁI<br>
	 * Message: &#28858;&#20102;&#26684;&#21202;&#35199;&#20126;&#30340;&#27054;&#32768;&#65281;<br>
	 * Message: For the glory of Gracia!
	 */
	public static final NpcStringId FOR_THE_GLORY_OF_GRACIA;
	
	/**
	 * ID: 1000040<br>
	 * Message: ӋCɂƗׂ͔ƁH<br>
	 * Message: &#20320;&#31455;&#25954;&#33287;&#25105;&#28858;&#25973;&#65311;<br>
	 * Message: Do you dare pit your power against me?
	 */
	public static final NpcStringId DO_YOU_DARE_PIT_YOUR_POWER_AGAINST_ME;
	
	/**
	 * ID: 1000041<br>
	 * Message: A̎skƂ́I<br>
	 * Message: &#25105;&#65292;&#25105;&#31455;&#28982;&#34987;&#25171;&#25943;&#20102;&#65281;&#65281;&#65281;<br>
	 * Message: I... I am defeated!!!
	 */
	public static final NpcStringId I_I_AM_DEFEATED;
	
	/**
	 * ID: 1000042<br>
	 * Message: ̓kJl̈ӎv`҂I זAǂI<br>
	 * Message: &#25105;&#26159;&#20659;&#36948;&#22900;&#29246;&#21345;&#26088;&#24847;&#30340;&#20351;&#32773;&#65281;&#20840;&#37117;&#32102;&#25105;&#35731;&#38283;&#65281;<br>
	 * Message: I am conveying the will of Nurka! Everybody get out of my way!
	 */
	public static final NpcStringId I_AM_CONVEYING_THE_WILL_OF_NURKA_EVERYBODY_GET_OUT_OF_MY_WAY;
	
	/**
	 * ID: 1000043<br>
	 * Message: ̑OՂ҂́ANł낤ł͂񂼁I<br>
	 * Message: &#38459;&#25803;&#25105;&#30340;&#20154;&#65281;&#35504;&#20063;&#19981;&#33021;&#27963;&#33879;&#38626;&#38283;&#65281;<br>
	 * Message: Those who stand against me shall die horribly!
	 */
	public static final NpcStringId THOSE_WHO_STAND_AGAINST_ME_SHALL_DIE_HORRIBLY;
	
	/**
	 * ID: 1000044<br>
	 * Message: ȂɁI̎ז̂I<br>
	 * Message: &#35504;&#25954;&#38459;&#25803;&#25105;&#65281;<br>
	 * Message: Do you dare to block my way?!
	 */
	public static final NpcStringId DO_YOU_DARE_TO_BLOCK_MY_WAY;
	
	/**
	 * ID: 1000045<br>
	 * Message: ̒ԂQĂ邾낤I<br>
	 * Message: &#25105;&#30340;&#38538;&#21451;&#24517;&#23559;&#24489;&#20167;&#65281;<br>
	 * Message: My comrades will get revenge!
	 */
	public static final NpcStringId MY_COMRADES_WILL_GET_REVENGE;
	
	/**
	 * ID: 1000046<br>
	 * Message: X̐_ȑnɐ߂҂͋񂼁I<br>
	 * Message: &#32085;&#19981;&#33021;&#39250;&#20102;&#20197;&#34880;&#27745;&#26579;&#25105;&#20497;&#31070;&#32854;&#20043;&#22320;&#30340;&#20154;&#65281;<br>
	 * Message: You heathen blasphemers of this holy place will be punished!
	 */
	public static final NpcStringId YOU_HEATHEN_BLASPHEMERS_OF_THIS_HOLY_PLACE_WILL_BE_PUNISHED;
	
	/**
	 * ID: 1000047<br>
	 * Message: ̌Ђɒ킷Ȏ҂ǂAOɏoI<br>
	 * Message: &#21521;&#25105;&#30340;&#27402;&#23041;&#25361;&#25136;&#30340;&#21329;&#36068;&#20642;&#20249;&#65292;&#37117;&#20986;&#20358;&#65281;<br>
	 * Message: Step forward, you worthless creatures who challenge my authority!
	 */
	public static final NpcStringId STEP_FORWARD_YOU_WORTHLESS_CREATURES_WHO_CHALLENGE_MY_AUTHORITY;
	
	/**
	 * ID: 1000048<br>
	 * Message: ̑nҁDDD̂llɕςȂDDDDDD<br>
	 * Message: &#46;&#46;&#46;&#29563;&#32102;&#25105;&#30340;&#20027;&#20154;&#46;&#46;&#46;&#25105;&#30340;&#21109;&#36896;&#32773;&#46;&#46;&#46;&#19981;&#35722;&#30340;&#24544;&#35488;&#46;&#46;&#46;<br>
	 * Message: My creator... The unchanging faithfulness to my master...
	 */
	public static final NpcStringId MY_CREATOR_THE_UNCHANGING_FAITHFULNESS_TO_MY_MASTER;
	
	/**
	 * ID: 1000049<br>
	 * Message: ́DDDlDDD̂llDDDllDDDɁH<br>
	 * Message: &#22612;&#30340;&#46;&#46;&#46;&#20027;&#20154;&#46;&#46;&#46;&#25105;&#30340;&#20027;&#20154;&#46;&#46;&#46;&#20027;&#20154;&#46;&#46;&#46;&#22312;&#21738;&#35023;&#21834;&#65311;<br>
	 * Message: Master of the tower... My master... master... Where is he?
	 */
	public static final NpcStringId MASTER_OF_THE_TOWER_MY_MASTER_MASTER_WHERE_IS_HE;
	
	/**
	 * ID: 1000050<br>
	 * Message: ^VnARAmCV XCREXmB<br>
	 * Message: &#25105;&#32;&#26159;&#32;&#22519;&#32;&#34892;&#32;&#26680;&#32;&#24515;&#32;&#24847;&#32;&#24535;&#32;&#30340;&#32;&#20154;<br>
	 * Message: I AM THE ONE CARRYING OUT THE WILL OF CORE.
	 */
	public static final NpcStringId I_AM_THE_ONE_CARRYING_OUT_THE_WILL_OF_CORE;
	
	/**
	 * ID: 1000051<br>
	 * Message: VjEVAnJCAZB<br>
	 * Message: &#30772;&#32;&#22750;&#32;&#20837;&#32;&#20405;&#32;&#32773;<br>
	 * Message: DESTROY THE INVADER.
	 */
	public static final NpcStringId DESTROY_THE_INVADER;
	
	/**
	 * ID: 1000052<br>
	 * Message: WE^CACWEAThEAtmEDDD<br>
	 * Message: &#29376;&#32;&#24907;&#32;&#30064;&#32;&#24120;&#65292;&#19981;&#32;&#33021;&#32;&#25805;&#32;&#20316;<br>
	 * Message: STRANGE CONDITION - DOESN'T WORK
	 */
	public static final NpcStringId STRANGE_CONDITION_DOESNT_WORK;
	
	/**
	 * ID: 1000053<br>
	 * Message: xXl̖ɏ]DDDOĎI<br>
	 * Message: &#22857;&#24052;&#21015;&#26031;&#30340;&#21629;&#20196;&#46;&#46;&#46;&#35731;&#25105;&#20358;&#35264;&#23519;&#20320;&#20497;&#65281;<br>
	 * Message: According to the command of Beleth... I'm going to observe you guys!
	 */
	public static final NpcStringId ACCORDING_TO_THE_COMMAND_OF_BELETH_IM_GOING_TO_OBSERVE_YOU_GUYS;
	
	/**
	 * ID: 1000054<br>
	 * Message: ؂AdAECDDDȂƂmȂȔyǂDDDOĂƁAn^ςԂ肻B<br>
	 * Message: &#21482;&#30693;&#36947;&#32972;&#21467;&#12289;&#38512;&#35584;&#12289;&#23648;&#27578;&#30340;&#24858;&#31528;&#20642;&#20249;&#46;&#46;&#46;&#30475;&#33879;&#20320;&#20497;&#65292;&#30495;&#35731;&#20154;&#29033;&#24758;&#12290;<br>
	 * Message: You people make me sick! No sense of loyalty whatsoever!
	 */
	public static final NpcStringId YOU_PEOPLE_MAKE_ME_SICK_NO_SENSE_OF_LOYALTY_WHATSOEVER;
	
	/**
	 * ID: 1000055<br>
	 * Message: ւ̒A͂Ȃ킿xXlɑ΂钧łB<br>
	 * Message: &#21521;&#25105;&#25361;&#25136;&#23601;&#26159;&#21521;&#24052;&#21015;&#26031;&#25361;&#25136;&#46;&#46;&#46;<br>
	 * Message: A challenge against me is the same as a challenge against Beleth...
	 */
	public static final NpcStringId A_CHALLENGE_AGAINST_ME_IS_THE_SAME_AS_A_CHALLENGE_AGAINST_BELETH;
	
	/**
	 * ID: 1000056<br>
	 * Message: xXĺAɂOĂ̂I<br>
	 * Message: &#24052;&#21015;&#26031;&#32317;&#26159;&#20463;&#35222;&#33879;&#20320;&#20497;&#65281;<br>
	 * Message: Beleth is always watching over you guys!
	 */
	public static final NpcStringId BELETH_IS_ALWAYS_WATCHING_OVER_YOU_GUYS;
	
	/**
	 * ID: 1000057<br>
	 * Message: E̔jłĂI A^Xlڂo܂ꂽI <br>
	 * Message: &#26411;&#26085;&#23559;&#33267;&#65281;&#23433;&#22612;&#29790;&#26031;&#30556;&#38283;&#20102;&#38617;&#30524;&#65281;&#32;<br>
	 * Message: That was really close! Antharas opened its eyes!
	 */
	public static final NpcStringId THAT_WAS_REALLY_CLOSE_ANTHARAS_OPENED_ITS_EYES;
	
	/**
	 * ID: 1000058<br>
	 * Message: A^Xl̈ӎuɋt炤҂IʂI<br>
	 * Message: &#36949;&#25239;&#23433;&#22612;&#29790;&#26031;&#24847;&#24535;&#30340;&#20154;&#65281;&#21435;&#27515;&#21543;&#65281;<br>
	 * Message: You who disobey the will of Antharas! Die!
	 */
	public static final NpcStringId YOU_WHO_DISOBEY_THE_WILL_OF_ANTHARAS_DIE;
	
	/**
	 * ID: 1000059<br>
	 * Message: A^XlAɎ^I<br>
	 * Message: &#23433;&#22612;&#29790;&#26031;&#65292;&#35531;&#25910;&#22238;&#25105;&#30340;&#29983;&#21629;&#21543;&#65281;<br>
	 * Message: Antharas has taken my life!
	 */
	public static final NpcStringId ANTHARAS_HAS_TAKEN_MY_LIFE;
	
	/**
	 * ID: 1000060<br>
	 * Message: ߂߂ɁAn̒ꂩ畑߂I<br>
	 * Message: &#28858;&#20102;&#25214;&#22238;&#23542;&#29289;&#65292;&#28193;&#36942;&#27515;&#20129;&#27836;&#28580;&#65292;&#32780;&#22238;&#21040;&#27492;&#22320;&#65281;<br>
	 * Message: I crossed back over the marshlands of death to reclaim the treasure!
	 */
	public static final NpcStringId I_CROSSED_BACK_OVER_THE_MARSHLANDS_OF_DEATH_TO_RECLAIM_THE_TREASURE;
	
	/**
	 * ID: 1000061<br>
	 * Message: BĂɕI<br>
	 * Message: &#23559;&#23542;&#36020;&#30340;&#37329;&#37504;&#29664;&#23542;&#29563;&#32102;&#25105;&#65281;<br>
	 * Message: Bring over and surrender your precious gold treasure to me!
	 */
	public static final NpcStringId BRING_OVER_AND_SURRENDER_YOUR_PRECIOUS_GOLD_TREASURE_TO_ME;
	
	/**
	 * ID: 1000062<br>
	 * Message: NnnnIOȂ񂼃C`RI<br>
	 * Message: &#25105;&#23559;&#19968;&#25802;&#27578;&#20102;&#20320;&#65281;<br>
	 * Message: I'll kill you in an instant!
	 */
	public static final NpcStringId ILL_KILL_YOU_IN_AN_INSTANT;
	
	/**
	 * ID: 1000063<br>
	 * Message: _I܂󂪁DDD<br>
	 * Message: &#19981;&#65281;&#23542;&#29289;&#36996;&#46;&#46;&#46;&#65281;<br>
	 * Message: No! The treasure is still..!
	 */
	public static final NpcStringId NO_THE_TREASURE_IS_STILL;
	
	/**
	 * ID: 1000064<br>
	 * Message: hSo[Ƃ҂ǂAĐĂ͋A񂼁I<br>
	 * Message: &#20405;&#29359;&#40845;&#20043;&#35895;&#30340;&#20154;&#65292;&#32085;&#19981;&#33021;&#35731;&#20182;&#27963;&#33879;&#20986;&#21435;&#65281;<br>
	 * Message: Invaders of Dragon Valley will never live to return!
	 */
	public static final NpcStringId INVADERS_OF_DRAGON_VALLEY_WILL_NEVER_LIVE_TO_RETURN;
	
	/**
	 * ID: 1000065<br>
	 * Message: ̓A^Xl̖ł̒n҂I<br>
	 * Message: &#25105;&#26159;&#22857;&#23433;&#22612;&#29790;&#26031;&#20043;&#21629;&#23432;&#34907;&#36889;&#35041;&#30340;&#23432;&#35703;&#32773;&#65281;<br>
	 * Message: I am the guardian that honors the command of Antharas to watch over this place!
	 */
	public static final NpcStringId I_AM_THE_GUARDIAN_THAT_HONORS_THE_COMMAND_OF_ANTHARAS_TO_WATCH_OVER_THIS_PLACE;
	
	/**
	 * ID: 1000066<br>
	 * Message: ȂhSo[ɑ𓥂ݓƂ́Ič߂I<br>
	 * Message: &#26410;&#32147;&#35377;&#21487;&#65292;&#33213;&#25954;&#27493;&#20837;&#40845;&#20043;&#35895;&#65281;&#20197;&#27515;&#35613;&#32618;&#21543;&#65281;<br>
	 * Message: You've set foot in Dragon Valley without permission! The penalty is death!
	 */
	public static final NpcStringId YOUVE_SET_FOOT_IN_DRAGON_VALLEY_WITHOUT_PERMISSION_THE_PENALTY_IS_DEATH;
	
	/**
	 * ID: 1000068<br>
	 * Message: EC̊сID̉INNNAdĂ낤˂B<br>
	 * Message: &#27578;&#25134;&#30340;&#21916;&#24709;&#65281;&#25504;&#22890;&#30340;&#24555;&#24863;&#65281;&#20170;&#22825;&#22823;&#20249;&#20877;&#24185;&#19968;&#31080;&#21543;&#65281;<br>
	 * Message: The joy of killing! The ecstasy of looting! Hey guys, let's have a go at it again!
	 */
	public static final NpcStringId THE_JOY_OF_KILLING_THE_ECSTASY_OF_LOOTING_HEY_GUYS_LETS_HAVE_A_GO_AT_IT_AGAIN;
	
	/**
	 * ID: 1000069<br>
	 * Message: ̒́AȂĕ|̒m炸Ȃ΂Ȃ񂾁I炵߂Ă񂺁I<br>
	 * Message: &#19990;&#19978;&#19981;&#30693;&#33213;&#24623;&#30340;&#20642;&#20249;&#20173;&#28982;&#24456;&#22810;&#65281;&#35731;&#20320;&#20497;&#30631;&#30631;&#25105;&#20497;&#30340;&#21426;&#23475;&#65281;<br>
	 * Message: There really are still lots of folks in the world without fear! I'll teach you a lesson!
	 */
	public static final NpcStringId THERE_REALLY_ARE_STILL_LOTS_OF_FOLKS_IN_THE_WORLD_WITHOUT_FEAR_ILL_TEACH_YOU_A_LESSON;
	
	/**
	 * ID: 1000070<br>
	 * Message: ׂĂ̕nƂȂA͏ĂĂI<br>
	 * Message: &#23559;&#25152;&#26377;&#26481;&#35199;&#20132;&#20986;&#20358;&#23601;&#39250;&#20102;&#20320;&#65281;<br>
	 * Message: If you hand over everything you've got, I'll at least spare your life!
	 */
	public static final NpcStringId IF_YOU_HAND_OVER_EVERYTHING_YOUVE_GOT_ILL_AT_LEAST_SPARE_YOUR_LIFE;
	
	/**
	 * ID: 1000071<br>
	 * Message: ̒x̂ɋƂ͂ȁI<br>
	 * Message: &#27794;&#24819;&#21040;&#25105;&#26371;&#23565;&#20320;&#36889;&#20642;&#20249;&#19979;&#36330;&#65281;<br>
	 * Message: Kneel down before one such as this!
	 */
	public static final NpcStringId KNEEL_DOWN_BEFORE_ONE_SUCH_AS_THIS;
	
	/**
	 * ID: 1000072<br>
	 * Message: ll̖ɏ]AׂĂ̐N҂𒦂炵߂̂I<br>
	 * Message: &#26381;&#24478;&#20027;&#20154;&#20043;&#24847;&#65292;&#25074;&#25106;&#25152;&#26377;&#20837;&#20405;&#32773;&#65281;<br>
	 * Message: Honor the master's wishes and punish all the invaders!
	 */
	public static final NpcStringId HONOR_THE_MASTERS_WISHES_AND_PUNISH_ALL_THE_INVADERS;
	
	/**
	 * ID: 1000073<br>
	 * Message: ll̖ɏ]AN҂Ɏ̓SƂI<br>
	 * Message: &#26381;&#24478;&#20027;&#20154;&#20043;&#24847;&#65292;&#25105;&#23559;&#25802;&#20498;&#20837;&#20405;&#32773;&#65281;<br>
	 * Message: Follow the master's wishes and punish the invaders!
	 */
	public static final NpcStringId FOLLOW_THE_MASTERS_WISHES_AND_PUNISH_THE_INVADERS;
	
	/**
	 * ID: 1000074<br>
	 * Message: ́A΂̋xɉ߂B<br>
	 * Message: &#27515;&#20129;&#26159;&#30701;&#26283;&#30340;&#23433;&#24687;&#32631;&#20102;&#46;&#46;&#46;<br>
	 * Message: Death is nothing more than a momentary rest...
	 */
	public static final NpcStringId DEATH_IS_NOTHING_MORE_THAN_A_MOMENTARY_REST;
	
	/**
	 * ID: 1000075<br>
	 * Message: 悭IO̎͂I肾IA^Xlڊo߂̂I<br>
	 * Message: &#27880;&#24847;&#32838;&#32893;&#65281;&#20154;&#39006;&#30340;&#26178;&#20195;&#24050;&#32147;&#32080;&#26463;&#20102;&#65281;&#23433;&#22612;&#29790;&#26031;&#29990;&#37266;&#20102;&#65281;&#32;<br>
	 * Message: Listen! This is the end of the human era! Antharas has awoken!
	 */
	public static final NpcStringId LISTEN_THIS_IS_THE_END_OF_THE_HUMAN_ERA_ANTHARAS_HAS_AWOKEN;
	
	/**
	 * ID: 1000076<br>
	 * Message: O̓A^XlɌサĂ낤I<br>
	 * Message: &#25105;&#23559;&#20320;&#30340;&#29983;&#21629;&#29563;&#32102;&#23433;&#22612;&#29790;&#26031;&#65281;<br>
	 * Message: Present the lives of four people to Antharas!
	 */
	public static final NpcStringId PRESENT_THE_LIVES_OF_FOUR_PEOPLE_TO_ANTHARAS;
	
	/**
	 * ID: 1000077<br>
	 * Message: A̎AJȎ푰ɕƂ́I<br>
	 * Message: &#25105;&#65281;&#31455;&#34987;&#26410;&#38283;&#21270;&#30340;&#31278;&#26063;&#25171;&#25943;&#20102;&#65281;<br>
	 * Message: This is unbelievable! How could I have lost to one so inferior to myself?
	 */
	public static final NpcStringId THIS_IS_UNBELIEVABLE_HOW_COULD_I_HAVE_LOST_TO_ONE_SO_INFERIOR_TO_MYSELF;
	
	/**
	 * ID: 1000078<br>
	 * Message: ł̎xzwɐ[߂I<br>
	 * Message: &#32972;&#36000;&#40657;&#26263;&#27402;&#21218;&#65292;&#24478;&#28145;&#28149;&#19990;&#30028;&#22238;&#20358;&#20102;&#12290;<br>
	 * Message: I carry the power of darkness and have returned from the abyss.
	 */
	public static final NpcStringId I_CARRY_THE_POWER_OF_DARKNESS_AND_HAVE_RETURNED_FROM_THE_ABYSS;
	
	/**
	 * ID: 1000079<br>
	 * Message: ȂƂ炵B<br>
	 * Message: &#21487;&#24801;&#26997;&#20102;&#12290;<br>
	 * Message: It's detestable.
	 */
	public static final NpcStringId ITS_DETESTABLE;
	
	/**
	 * ID: 1000080<br>
	 * Message: Ɉ̎}B<br>
	 * Message: &#32066;&#26044;&#36814;&#25509;&#23433;&#24687;&#46;&#46;&#46;<br>
	 * Message: I finally find rest...
	 */
	public static final NpcStringId I_FINALLY_FIND_REST;
	
	/**
	 * ID: 1000081<br>
	 * Message: ItFlɉhI<br>
	 * Message: &#20197;&#22887;&#29246;&#33452;&#20043;&#20809;&#27054;&#65281;<br>
	 * Message: Glory to Orfen!
	 */
	public static final NpcStringId GLORY_TO_ORFEN;
	
	/**
	 * ID: 1000082<br>
	 * Message: ItFl̖Ă̒nƂƂ߁I<br>
	 * Message: &#20197;&#22887;&#29246;&#33452;&#20043;&#21517;&#65292;&#32085;&#19981;&#23481;&#20320;&#20497;&#20405;&#29359;&#27492;&#22320;&#65281;<br>
	 * Message: In the name of Orfen, I can never forgive you who are invading this place!
	 */
	public static final NpcStringId IN_THE_NAME_OF_ORFEN_I_CAN_NEVER_FORGIVE_YOU_WHO_ARE_INVADING_THIS_PLACE;
	
	/**
	 * ID: 1000083<br>
	 * Message: ItFl̒nɓyœݍ񂾔󂯂̂I<br>
	 * Message: &#33213;&#25954;&#20405;&#29359;&#22887;&#29246;&#33452;&#30340;&#38936;&#22495;&#65292;&#23601;&#35201;&#20320;&#20497;&#20184;&#20986;&#20195;&#20729;&#65281;<br>
	 * Message: I'll make you pay the price for fearlessly entering Orfen's land!
	 */
	public static final NpcStringId ILL_MAKE_YOU_PAY_THE_PRICE_FOR_FEARLESSLY_ENTERING_ORFENS_LAND;
	
	/**
	 * ID: 1000084<br>
	 * Message: ɂ̂悤ɋƂĂAO͎􂢂ɂĈꐶꂵ߂邾낤DDDNNNB<br>
	 * Message: &#38614;&#28982;&#46;&#46;&#46;&#25105;&#36889;&#27171;&#34395;&#28961;&#22320;&#28040;&#22833;&#8230;&#20294;&#20320;&#20497;&#23559;&#19968;&#36649;&#23376;&#21463;&#22256;&#26044;&#25105;&#30340;&#35419;&#21650;&#46;&#46;&#46;<br>
	 * Message: Even if you disappear into nothingness, you will still face the life-long suffering of the curse that I have given you.
	 */
	public static final NpcStringId EVEN_IF_YOU_DISAPPEAR_INTO_NOTHINGNESS_YOU_WILL_STILL_FACE_THE_LIFE_LONG_SUFFERING_OF_THE_CURSE_THAT_I_HAVE_GIVEN_YOU;
	
	/**
	 * ID: 1000085<br>
	 * Message: _ȗd̏Z݂r炷҂A̎ɂȂĂ낤I<br>
	 * Message: &#22916;&#24819;&#22890;&#21462;&#31070;&#32854;&#22934;&#31934;&#27138;&#22290;&#30340;&#20154;&#21834;&#65292;&#25105;&#23559;&#35242;&#33258;&#23565;&#20184;&#20320;&#20497;&#65281;<br>
	 * Message: I'll stand against anyone that makes light of the sacred place of the Elves!
	 */
	public static final NpcStringId ILL_STAND_AGAINST_ANYONE_THAT_MAKES_LIGHT_OF_THE_SACRED_PLACE_OF_THE_ELVES;
	
	/**
	 * ID: 1000086<br>
	 * Message: X̏Z݂҂A̎őĂ낤I<br>
	 * Message: &#27745;&#36785;&#25105;&#20497;&#27138;&#22290;&#30340;&#20154;&#65292;&#25105;&#23559;&#35242;&#25163;&#25802;&#20498;&#20320;&#65281;<br>
	 * Message: I will kill with my own hands anyone that defiles our home!
	 */
	public static final NpcStringId I_WILL_KILL_WITH_MY_OWN_HANDS_ANYONE_THAT_DEFILES_OUR_HOME;
	
	/**
	 * ID: 1000087<br>
	 * Message: Ƃ̎艺̒Jǂo܂ŁǍZ킽͌ċxނƂ͂Ȃ낤I <br>
	 * Message: &#30452;&#21040;&#23559;&#20320;&#21644;&#20320;&#30340;&#21516;&#20276;&#36245;&#20986;&#36889;&#24231;&#35895;&#20043;&#21069;&#65292;&#25105;&#30340;&#20804;&#24351;&#22992;&#22969;&#23559;&#27704;&#19981;&#20572;&#24687;&#65281;<br>
	 * Message: My brothers will never rest until we push you and your gang out of this valley!
	 */
	public static final NpcStringId MY_BROTHERS_WILL_NEVER_REST_UNTIL_WE_PUSH_YOU_AND_YOUR_GANG_OUT_OF_THIS_VALLEY;
	
	/**
	 * ID: 1000088<br>
	 * Message: wXgDCŖŜ̓܂ŁI<br>
	 * Message: &#30452;&#21040;&#40657;&#26031;&#21520;&#20234;&#28357;&#20129;&#28858;&#27490;&#65281;<br>
	 * Message: Until the day of destruction of Hestui!
	 */
	public static final NpcStringId UNTIL_THE_DAY_OF_DESTRUCTION_OF_HESTUI;
	
	/**
	 * ID: 1000089<br>
	 * Message: EȂI[N͂܂cĂ邩IŌ̈ꕺ܂Ő킦I<br>
	 * Message: &#33509;&#36996;&#26377;&#20854;&#20182;&#29983;&#23384;&#30340;&#21191;&#29467;&#21322;&#29560;&#20154;&#65292;&#37117;&#25918;&#39340;&#36942;&#20358;&#21543;&#65281;<br>
	 * Message: If any intrepid Orcs remain, attack them!
	 */
	public static final NpcStringId IF_ANY_INTREPID_ORCS_REMAIN_ATTACK_THEM;
	
	/**
	 * ID: 1000090<br>
	 * Message: ̍~߂ĂI<br>
	 * Message: &#35731;&#25105;&#20358;&#27578;&#20102;&#20320;&#65281;<br>
	 * Message: I'll break your windpipe!
	 */
	public static final NpcStringId ILL_BREAK_YOUR_WINDPIPE;
	
	/**
	 * ID: 1000091<br>
	 * Message: ǁAQ͎s DDD<br>
	 * Message: &#38627;&#36947;&#24489;&#20167;&#23559;&#20197;&#22833;&#25943;&#25910;&#22580;&#21966;&#32;&#46;&#32;&#46;&#32;&#65281;<br>
	 * Message: Is revenge a failure?!
	 */
	public static final NpcStringId IS_REVENGE_A_FAILURE;
	
	/**
	 * ID: 1000092<br>
	 * Message: h[t̃sJsJP~XAꂢȕ΁IׂĎɂ̂I<br>
	 * Message: &#23567;&#30702;&#20154;&#30340;&#38275;&#32768;&#31859;&#32034;&#33673;&#23542;&#30707;&#21834;&#65281;&#25105;&#35201;&#20840;&#37096;&#25343;&#36208;&#65281;<br>
	 * Message: The sparkling mithril of the dwarves and their pretty treasures! I'll get them all!
	 */
	public static final NpcStringId THE_SPARKLING_MITHRIL_OF_THE_DWARVES_AND_THEIR_PRETTY_TREASURES_ILL_GET_THEM_ALL;
	
	/**
	 * ID: 1000093<br>
	 * Message: aȃ`rAP΂́AǂɂDDD<br>
	 * Message: &#33213;&#24623;&#30340;&#23567;&#30702;&#20154;&#21644;&#38275;&#32768;&#30340;&#30707;&#23376;&#37117;&#22312;&#21738;&#35023;&#21602;&#65374;<br>
	 * Message: Where are all the dreadful dwarves and their sparkling things?
	 */
	public static final NpcStringId WHERE_ARE_ALL_THE_DREADFUL_DWARVES_AND_THEIR_SPARKLING_THINGS;
	
	/**
	 * ID: 1000094<br>
	 * Message: ׂďoIꂢȕ΁I<br>
	 * Message: &#20132;&#20986;&#20358;&#65281;&#33;&#28418;&#20142;&#30340;&#23542;&#30707;&#65281;<br>
	 * Message: Hand over your pretty treasures!
	 */
	public static final NpcStringId HAND_OVER_YOUR_PRETTY_TREASURES;
	
	/**
	 * ID: 1000095<br>
	 * Message: NbI̎Ă΁DDD<br>
	 * Message: &#21756;&#65281;&#26089;&#30693;&#36947;&#23601;&#36867;&#36208;&#20102;&#65281;<br>
	 * Message: Hey! You should have run away!
	 */
	public static final NpcStringId HEY_YOU_SHOULD_HAVE_RUN_AWAY;
	
	/**
	 * ID: 1000096<br>
	 * Message: jAŁAECAŖSIjAŁAECAŖSI<br>
	 * Message: &#30772;&#22750;&#12289;&#25475;&#34153;&#12289;&#27578;&#25134;&#12289;&#28357;&#20129;&#65281;&#30772;&#22750;&#12289;&#25475;&#34153;&#12289;&#27578;&#25134;&#12289;&#28357;&#20129;&#65281;<br>
	 * Message: DESTRUCTION - EXTINCTION - SLAUGHTER - COLLAPSE! DESTRUCTION - EXTINCTION - SLAUGHTER - COLLAPSE!
	 */
	public static final NpcStringId DESTRUCTION_EXTINCTION_SLAUGHTER_COLLAPSE_DESTRUCTION_EXTINCTION_SLAUGHTER_COLLAPSE;
	
	/**
	 * ID: 1000097<br>
	 * Message: jIjIjIjI<br>
	 * Message: &#30772;&#22750;&#65281;&#30772;&#22750;&#65281;&#30772;&#22750;&#65281;&#30772;&#22750;&#65281;<br>
	 * Message: Destruction! Destruction! Destruction! Destruction!
	 */
	public static final NpcStringId DESTRUCTION_DESTRUCTION_DESTRUCTION_DESTRUCTION;
	
	/**
	 * ID: 1000098<br>
	 * Message: jIjIjDDD<br>
	 * Message: &#30772;&#22750;&#65281;&#30772;&#22750;&#65281;&#30772;&#46;&#32;&#46;&#32;&#46;<br>
	 * Message: Destruction! Destruction! Destruction. . .
	 */
	public static final NpcStringId DESTRUCTION_DESTRUCTION_DESTRUCTION;
	
	/**
	 * ID: 1000099<br>
	 * Message: WW[IAėEUJI<br>
	 * Message: &#20320;&#30475;&#65281;&#27512;&#20358;&#30340;&#28879;&#23665;&#21345;&#65281;<br>
	 * Message: Ta-da! Uthanka has returned!
	 */
	public static final NpcStringId TA_DA_UTHANKA_HAS_RETURNED;
	
	/**
	 * ID: 1000100<br>
	 * Message: nnnI͍̓tŃEUJl̂I<br>
	 * Message: &#21704;&#21704;&#21704;&#21704;&#65281;&#24478;&#20170;&#22825;&#36215;&#65292;&#36889;&#24231;&#23798;&#23601;&#23660;&#26044;&#28879;&#23665;&#21345;&#30340;&#21862;&#65281;<br>
	 * Message: Wah, ha, ha, ha! Uthanka has taken over this island today!
	 */
	public static final NpcStringId WAH_HA_HA_HA_UTHANKA_HAS_TAKEN_OVER_THIS_ISLAND_TODAY;
	
	/**
	 * ID: 1000101<br>
	 * Message: [ƁIʂAȂȂ<br>
	 * Message: &#21756;&#65281;&#30495;&#26377;&#20841;&#19979;&#23376;&#65281;<br>
	 * Message: Whew! He's quite a guy!
	 */
	public static final NpcStringId WHEW_HES_QUITE_A_GUY;
	
	/**
	 * ID: 1000102<br>
	 * Message: ADDDƕƂ́DDD<br>
	 * Message: &#30495;&#26159;&#26082;&#24724;&#24680;&#21448;&#28961;&#22856;&#21834;&#46;&#46;&#46;&#31455;&#28982;&#23601;&#36889;&#40636;&#36629;&#26131;&#30340;&#34987;&#25171;&#25943;&#20102;&#46;&#46;&#46;<br>
	 * Message: How exasperating and unfair to have things happen in such a meaningless way like this...
	 */
	public static final NpcStringId HOW_EXASPERATING_AND_UNFAIR_TO_HAVE_THINGS_HAPPEN_IN_SUCH_A_MEANINGLESS_WAY_LIKE_THIS;
	
	/**
	 * ID: 1000103<br>
	 * Message: ̐̒͋|Ɣ߂݂ŖׂDDD<br>
	 * Message: &#19990;&#30028;&#25033;&#35442;&#20805;&#28415;&#24656;&#24598;&#33287;&#24754;&#21696;&#46;&#46;&#46;<br>
	 * Message: This world should be filled with fear and sadness...
	 */
	public static final NpcStringId THIS_WORLD_SHOULD_BE_FILLED_WITH_FEAR_AND_SADNESS;
	
	/**
	 * ID: 1000104<br>
	 * Message: Ɏ􂢂̐̒DDDċ񂼁I<br>
	 * Message: &#25105;&#32085;&#19981;&#21407;&#35538;&#35419;&#21650;&#25105;&#30340;&#19990;&#30028;&#65281;<br>
	 * Message: I won't forgive the world that cursed me!
	 */
	public static final NpcStringId I_WONT_FORGIVE_THE_WORLD_THAT_CURSED_ME;
	
	/**
	 * ID: 1000105<br>
	 * Message: FɎƓɂ𖡂킹ĂI<br>
	 * Message: &#25105;&#26371;&#35731;&#20320;&#20497;&#20840;&#37096;&#37117;&#25215;&#21463;&#36319;&#25105;&#19968;&#27171;&#30340;&#30171;&#33510;&#65281;<br>
	 * Message: I'll make everyone feel the same suffering as me!
	 */
	public static final NpcStringId ILL_MAKE_EVERYONE_FEEL_THE_SAME_SUFFERING_AS_ME;
	
	/**
	 * ID: 1000106<br>
	 * Message: Oɂiɉ邱Ƃ̂Ȃ􂢂Ă낤I<br>
	 * Message: &#25105;&#26371;&#35731;&#20320;&#25215;&#21463;&#27704;&#36960;&#28961;&#27861;&#35299;&#38500;&#30340;&#35419;&#21650;&#65281;<br>
	 * Message: I'll give you a curse that you'll never be able to remove forever!
	 */
	public static final NpcStringId ILL_GIVE_YOU_A_CURSE_THAT_YOULL_NEVER_BE_ABLE_TO_REMOVE_FOREVER;
	
	/**
	 * ID: 1000107<br>
	 * Message: EEɕQI<br>
	 * Message: &#25105;&#26371;&#23565;&#23648;&#27578;&#21516;&#32990;&#30340;&#20320;&#20497;&#22577;&#20167;&#65281;<br>
	 * Message: I'll get revenge on you who slaughtered my compatriots!
	 */
	public static final NpcStringId ILL_GET_REVENGE_ON_YOU_WHO_SLAUGHTERED_MY_COMPATRIOTS;
	
	/**
	 * ID: 1000108<br>
	 * Message: aȂ͏IEȂ͂ėI<br>
	 * Message: &#33213;&#24623;&#30340;&#20642;&#20249;&#28414;&#20986;&#21435;&#65292;&#21191;&#25954;&#30340;&#20642;&#20249;&#34909;&#36942;&#20358;&#21543;&#65281;<br>
	 * Message: Those who are afraid should get away and those who are brave should fight!
	 */
	public static final NpcStringId THOSE_WHO_ARE_AFRAID_SHOULD_GET_AWAY_AND_THOSE_WHO_ARE_BRAVE_SHOULD_FIGHT;
	
	/**
	 * ID: 1000109<br>
	 * Message: xXl͂^ꂽȒPɂƂłvĂ̂I<br>
	 * Message: &#25105;&#26159;&#29554;&#24471;&#24052;&#21015;&#26031;&#21147;&#37327;&#30340;&#20154;&#65292;&#24590;&#40636;&#21487;&#33021;&#36889;&#40636;&#23481;&#26131;&#23601;&#34987;&#20320;&#25802;&#25943;&#65281;<br>
	 * Message: I've got power from Beleth so do you think I'll be easily defeated?!
	 */
	public static final NpcStringId IVE_GOT_POWER_FROM_BELETH_SO_DO_YOU_THINK_ILL_BE_EASILY_DEFEATED;
	
	/**
	 * ID: 1000110<br>
	 * Message: ͂ďĂDDDl̎O|ɗł낤I<br>
	 * Message: &#38614;&#28982;&#25105;&#36889;&#27171;&#28040;&#22833;&#65292;&#20294;&#21478;&#19968;&#20491;&#25105;&#19968;&#23450;&#26371;&#20358;&#25074;&#25106;&#20320;&#20497;&#65281;<br>
	 * Message: I am leaving now, but soon someone will come who will teach you all a lesson!
	 */
	public static final NpcStringId I_AM_LEAVING_NOW_BUT_SOON_SOMEONE_WILL_COME_WHO_WILL_TEACH_YOU_ALL_A_LESSON;
	
	/**
	 * ID: 1000111<br>
	 * Message: OAl̓꒣肵ėI<br>
	 * Message: &#21890;&#65292;&#25105;&#20497;&#21435;&#24033;&#35222;&#19968;&#19979;&#25105;&#20497;&#30340;&#21312;&#22495;&#21543;&#65281;<br>
	 * Message: Hey guys, let's make a round of our territory!
	 */
	public static final NpcStringId HEY_GUYS_LETS_MAKE_A_ROUND_OF_OUR_TERRITORY;
	
	/**
	 * ID: 1000112<br>
	 * Message: ߍAl̓꒣ōDȂƂĂ邻DDD<br>
	 * Message: &#32893;&#35498;&#26368;&#36817;&#22312;&#25105;&#30340;&#22320;&#30436;&#35041;&#26377;&#20491;&#20642;&#20249;&#24456;&#29462;&#29378;&#46;&#46;&#46;<br>
	 * Message: The rumor is that there are wild, uncivilized ruffians who have recently arrived in my territory.
	 */
	public static final NpcStringId THE_RUMOR_IS_THAT_THERE_ARE_WILD_UNCIVILIZED_RUFFIANS_WHO_HAVE_RECENTLY_ARRIVED_IN_MY_TERRITORY;
	
	/**
	 * ID: 1000113<br>
	 * Message: lN킩邩I܂VbRlIOA܂I<br>
	 * Message: &#20320;&#30693;&#19981;&#30693;&#36947;&#25105;&#26159;&#35504;&#65281;&#25105;&#23601;&#26159;&#35199;&#27931;&#21487;&#65281;&#36914;&#25915;&#65281;<br>
	 * Message: Do you know who I am?! I am Sirocco! Everyone, attack!
	 */
	public static final NpcStringId DO_YOU_KNOW_WHO_I_AM_I_AM_SIROCCO_EVERYONE_ATTACK;
	
	/**
	 * ID: 1000114<br>
	 * Message: Ȃ͂ł́DDDss̃VbROƂɕƂ́I<br>
	 * Message: &#22825;&#21834;&#65281;&#24478;&#26410;&#25136;&#25943;&#30340;&#35199;&#27931;&#21487;&#31455;&#28982;&#34987;&#20320;&#25802;&#25943;&#65281;<br>
	 * Message: What's just happened?! The invincible Sirocco was defeated by someone like you?!
	 */
	public static final NpcStringId WHATS_JUST_HAPPENED_THE_INVINCIBLE_SIROCCO_WAS_DEFEATED_BY_SOMEONE_LIKE_YOU;
	
	/**
	 * ID: 1000115<br>
	 * Message: ւ[AL`<br>
	 * Message: &#39187;&#26997;&#20102;&#65292;&#21653;&#22165;&#65374;<br>
	 * Message: Oh, I'm really hungry...
	 */
	public static final NpcStringId OH_IM_REALLY_HUNGRY;
	
	/**
	 * ID: 1000116<br>
	 * Message: ȁL邼AL`<br>
	 * Message: &#26377;&#39135;&#29289;&#30340;&#21619;&#36947;&#65292;&#21653;&#22165;&#65374;<br>
	 * Message: I smell food. Ooh...
	 */
	public static final NpcStringId I_SMELL_FOOD_OOH;
	
	/**
	 * ID: 1000117<br>
	 * Message: L`<br>
	 * Message: &#21653;&#22165;&#65374;<br>
	 * Message: Ooh...
	 */
	public static final NpcStringId OOH;
	
	/**
	 * ID: 1000118<br>
	 * Message: ̖I͂ǂȖȁH<br>
	 * Message: &#36889;&#35041;&#30340;&#34562;&#34588;&#26159;&#20160;&#40636;&#21475;&#21619;&#21602;&#65281;<br>
	 * Message: What does honey of this place taste like?!
	 */
	public static final NpcStringId WHAT_DOES_HONEY_OF_THIS_PLACE_TASTE_LIKE;
	
	/**
	 * ID: 1000119<br>
	 * Message: Ƃ肷قǊÂƌĂA̖IoI<br>
	 * Message: &#23559;&#21448;&#29980;&#21448;&#21487;&#21475;&#30340;&#40643;&#37329;&#33394;&#34562;&#34588;&#25343;&#20986;&#20358;&#65281;<br>
	 * Message: Give me some sweet, delicious golden honey!
	 */
	public static final NpcStringId GIVE_ME_SOME_SWEET_DELICIOUS_GOLDEN_HONEY;
	
	/**
	 * ID: 1000120<br>
	 * Message: Io΁A͏ĂI<br>
	 * Message: &#33509;&#23559;&#34562;&#34588;&#25343;&#20986;&#20358;&#65292;&#23601;&#39250;&#20102;&#20320;&#46;&#46;&#46;<br>
	 * Message: If you give me some honey, I'll at least spare your life...
	 */
	public static final NpcStringId IF_YOU_GIVE_ME_SOME_HONEY_ILL_AT_LEAST_SPARE_YOUR_LIFE;
	
	/**
	 * ID: 1000121<br>
	 * Message: IĂ΁DDD.OȂ񂩂ɕȂ͂B<br>
	 * Message: &#35201;&#26159;&#25214;&#21040;&#20102;&#34562;&#34588;&#46;&#46;&#46;&#25105;&#23601;&#19981;&#26371;&#34987;&#20320;&#25802;&#25943;&#30340;&#46;&#46;&#46;<br>
	 * Message: Only for lack of honey did I lose to the likes of you.
	 */
	public static final NpcStringId ONLY_FOR_LACK_OF_HONEY_DID_I_LOSE_TO_THE_LIKES_OF_YOU;
	
	/**
	 * ID: 1000122<br>
	 * Message: ؂҂̃N{X͂ǂI<br>
	 * Message: &#32972;&#21467;&#32773;&#24235;&#21202;&#20445;&#27931;&#26031;&#22312;&#21738;&#35041;&#65281;<br>
	 * Message: Where is the traitor Kuroboros!?
	 */
	public static final NpcStringId WHERE_IS_THE_TRAITOR_KUROBOROS;
	
	/**
	 * ID: 1000123<br>
	 * Message: ܂ȂTI<br>
	 * Message: &#20840;&#37117;&#32102;&#25105;&#25628;&#26597;&#19968;&#36941;&#65281;<br>
	 * Message: Look in every nook and cranny around here!
	 */
	public static final NpcStringId LOOK_IN_EVERY_NOOK_AND_CRANNY_AROUND_HERE;
	
	/**
	 * ID: 1000124<br>
	 * Message: N{X̎艺B꓁fɂĂI<br>
	 * Message: &#20320;&#26159;&#24235;&#21202;&#20445;&#26031;&#30340;&#25163;&#19979;&#21966;&#65311;&#25105;&#23559;&#19968;&#25802;&#27578;&#20102;&#20320;&#65281;<br>
	 * Message: Are you Lackey of Kuroboros?! I'll knock you out in one shot!
	 */
	public static final NpcStringId ARE_YOU_LACKEY_OF_KUROBOROS_ILL_KNOCK_YOU_OUT_IN_ONE_SHOT;
	
	/**
	 * ID: 1000125<br>
	 * Message: ؂҂|ʂ܂܎ʂƂ́DDD₵I<br>
	 * Message: &#31455;&#28982;&#22312;&#36996;&#27794;&#34389;&#27770;&#32972;&#21467;&#32773;&#20043;&#21069;&#23601;&#35201;&#27515;&#21435;&#46;&#46;&#46;&#30495;&#19981;&#29976;&#24515;&#65281;<br>
	 * Message: He just closed his eyes without disposing of the traitor... How unfair!
	 */
	public static final NpcStringId HE_JUST_CLOSED_HIS_EYES_WITHOUT_DISPOSING_OF_THE_TRAITOR_HOW_UNFAIR;
	
	/**
	 * ID: 1000126<br>
	 * Message: N{XlMʎ҂͒nɗ邪I<br>
	 * Message: &#24235;&#21202;&#20445;&#26031;&#65292;&#19981;&#20449;&#32773;&#30340;&#22320;&#29508;&#65281;<br>
	 * Message: Hell for unbelievers in Kuroboros!
	 */
	public static final NpcStringId HELL_FOR_UNBELIEVERS_IN_KUROBOROS;
	
	/**
	 * ID: 1000127<br>
	 * Message: ̃N{XMȂҁB̐Ȃ킿nȂ̂I<br>
	 * Message: &#19981;&#20449;&#24235;&#21202;&#20445;&#27931;&#26031;&#30340;&#20154;&#65292;&#20320;&#30340;&#20154;&#29983;&#23601;&#26371;&#26159;&#22320;&#29508;&#65281;<br>
	 * Message: The person that does not believe in kuroboros, his life will soon become hell!
	 */
	public static final NpcStringId THE_PERSON_THAT_DOES_NOT_BELIEVE_IN_KUROBOROS_HIS_LIFE_WILL_SOON_BECOME_HELL;
	
	/**
	 * ID: 1000128<br>
	 * Message: U̐_Ɏd鈫̎艺߁I̎ŐsĂ낤I<br>
	 * Message: &#20379;&#22857;&#20551;&#31070;&#30340;&#24801;&#39764;&#25163;&#19979;&#65281;&#25105;&#23559;&#35242;&#33258;&#25802;&#20498;&#20320;&#65281;<br>
	 * Message: The lackey of that demented devil, the servant of a false god! I'll send that fool straight to hell!
	 */
	public static final NpcStringId THE_LACKEY_OF_THAT_DEMENTED_DEVIL_THE_SERVANT_OF_A_FALSE_GOD_ILL_SEND_THAT_FOOL_STRAIGHT_TO_HELL;
	
	/**
	 * ID: 1000129<br>
	 * Message: DDDAʂɂ炸B΂̂݁DDDĂѕI<br>
	 * Message: &#21834;&#46;&#46;&#46;&#25105;&#19981;&#26159;&#27515;&#21435;&#65292;&#32780;&#26159;&#26283;&#26178;&#28040;&#22833;&#32631;&#20102;&#46;&#46;&#46;&#25105;&#23559;&#26371;&#37325;&#26032;&#24489;&#27963;&#65281;<br>
	 * Message: Uh... I'm not dying; I'm just disappearing for a moment... I'll resurrect again!
	 */
	public static final NpcStringId UH_IM_NOT_DYING_IM_JUST_DISAPPEARING_FOR_A_MOMENT_ILL_RESURRECT_AGAIN;
	
	/**
	 * ID: 1000130<br>
	 * Message: N{XlA΁I<br>
	 * Message: &#24235;&#21202;&#20445;&#27931;&#26031;&#25945;&#20027;&#33836;&#27506;&#65281;<br>
	 * Message: Hail to Kuroboros, the founder of our religion!
	 */
	public static final NpcStringId HAIL_TO_KUROBOROS_THE_FOUNDER_OF_OUR_RELIGION;
	
	/**
	 * ID: 1000131<br>
	 * Message: N{XlM҂~̂I<br>
	 * Message: &#21482;&#26377;&#20449;&#22857;&#24235;&#21202;&#20445;&#27931;&#26031;&#65292;&#25165;&#33021;&#24471;&#21040;&#25937;&#36118;&#65281;<br>
	 * Message: Only those who believe in Patriarch Kuroboros shall receive salvation!
	 */
	public static final NpcStringId ONLY_THOSE_WHO_BELIEVE_IN_PATRIARCH_KUROBOROS_SHALL_RECEIVE_SALVATION;
	
	/**
	 * ID: 1000132<br>
	 * Message: VN̂ȁION{XlMċ~邪悢I<br>
	 * Message: &#20320;&#20497;&#26159;&#34987;&#22799;&#39791;&#20811;&#24939;&#24703;&#30340;&#20642;&#20249;&#22043;&#65281;&#20320;&#20497;&#20063;&#20358;&#20379;&#22857;&#24235;&#21202;&#20445;&#27931;&#26031;&#65292;&#19968;&#36215;&#29554;&#24471;&#25937;&#36118;&#21543;&#65281;<br>
	 * Message: Are you the ones that Sharuk has incited?! You also should trust in Kuroboros and be saved!
	 */
	public static final NpcStringId ARE_YOU_THE_ONES_THAT_SHARUK_HAS_INCITED_YOU_ALSO_SHOULD_TRUST_IN_KUROBOROS_AND_BE_SAVED;
	
	/**
	 * ID: 1000133<br>
	 * Message: N{XlO𒦂炵߂邾낤B<br>
	 * Message: &#24235;&#21202;&#20445;&#27931;&#26031;&#23559;&#25074;&#25106;&#20320;&#20497;&#12290;<br>
	 * Message: Kuroboros will punish you.
	 */
	public static final NpcStringId KUROBOROS_WILL_PUNISH_YOU;
	
	/**
	 * ID: 1000134<br>
	 * Message: 񂾋P썰҂I͋AėI<br>
	 * Message: &#24118;&#26377;&#29618;&#29903;&#38275;&#32768;&#30340;&#32654;&#40599;&#38728;&#39746;&#20043;&#20154;&#21834;&#65281;&#25105;&#22238;&#20358;&#20102;&#65281;<br>
	 * Message: You who have beautiful spirits that shine brightly! I have returned!
	 */
	public static final NpcStringId YOU_WHO_HAVE_BEAUTIFUL_SPIRITS_THAT_SHINE_BRIGHTLY_I_HAVE_RETURNED;
	
	/**
	 * ID: 1000135<br>
	 * Message: Jނ҂DDD썰ɎȂB<br>
	 * Message: &#21214;&#32047;&#30130;&#20518;&#30340;&#20154;&#21834;&#46;&#46;&#46;&#23559;&#38728;&#39746;&#20132;&#20184;&#32102;&#25105;&#21543;&#46;&#46;&#46;<br>
	 * Message: You that are weary and exhausted... Entrust your souls to me.
	 */
	public static final NpcStringId YOU_THAT_ARE_WEARY_AND_EXHAUSTED_ENTRUST_YOUR_SOULS_TO_ME;
	
	/**
	 * ID: 1000136<br>
	 * Message: O̗썰̐F͂Ƃ肷قǔB<br>
	 * Message: &#20320;&#37027;&#38728;&#39746;&#30340;&#20809;&#24425;&#30495;&#26159;&#20196;&#20154;&#21916;&#24859;&#12290;<br>
	 * Message: The color of your soul is very attractive.
	 */
	public static final NpcStringId THE_COLOR_OF_YOUR_SOUL_IS_VERY_ATTRACTIVE;
	
	/**
	 * ID: 1000137<br>
	 * Message: Ƃ҂IO̗썰ǂȂɔmĂ邩I<br>
	 * Message: &#27963;&#33879;&#30340;&#20154;&#21834;&#65281;&#20320;&#20497;&#30693;&#19981;&#30693;&#36947;&#20320;&#20497;&#30340;&#38728;&#39746;&#26377;&#22810;&#28418;&#20142;&#65281;<br>
	 * Message: Those of you who live! Do you know how beautiful your souls are?!
	 */
	public static final NpcStringId THOSE_OF_YOU_WHO_LIVE_DO_YOU_KNOW_HOW_BEAUTIFUL_YOUR_SOULS_ARE;
	
	/**
	 * ID: 1000138<br>
	 * Message: ݁AFEɂĂDDD<br>
	 * Message: &#25105;&#26371;&#46;&#46;&#46;&#23559;&#46;&#46;&#46;&#20840;&#37096;&#46;&#46;&#46;&#25171;&#27515;&#46;&#46;&#46;&#46;<br>
	 * Message: It... will... kill... everyone...
	 */
	public static final NpcStringId IT_WILL_KILL_EVERYONE;
	
	/**
	 * ID: 1000139<br>
	 * Message: AǓƂDDD<br>
	 * Message: &#23396;&#46;&#46;&#46;&#23396;&#21934;&#46;&#46;&#46;&#23396;&#21934;&#46;&#46;&#46;<br>
	 * Message: I'm... so... lonely...
	 */
	public static final NpcStringId IM_SO_LONELY;
	
	/**
	 * ID: 1000140<br>
	 * Message: ÂDDD<br>
	 * Message: &#25105;&#46;&#46;&#46;&#25105;&#30340;&#46;&#46;&#46;&#20167;&#46;&#46;&#46;&#20167;&#20154;&#46;&#46;&#46;&#65281;<br>
	 * Message: My... enemy...!
	 */
	public static final NpcStringId MY_ENEMY;
	
	/**
	 * ID: 1000141<br>
	 * Message: AǓƂł͂ȂI<br>
	 * Message: &#46;&#46;&#46;&#29694;&#22312;&#46;&#46;&#46;&#19981;&#26371;&#20877;&#46;&#23396;&#21934;&#65281;<br>
	 * Message: ... Now... I'm not so lonely!
	 */
	public static final NpcStringId _NOW_IM_NOT_SO_LONELY;
	
	/**
	 * ID: 1000142<br>
	 * Message: XDDDłڂƂDDDsNV[~JIċ܂I<br>
	 * Message: &#35201;&#23559;&#25105;&#20497;&#8230;&#36245;&#30433;&#27578;&#32085;&#30340;&#46;&#46;&#46;&#23567;&#31934;&#38728;&#33707;&#22958;&#21345;&#65281;&#25105;&#32085;&#19981;&#21407;&#35538;&#65281;<br>
	 * Message: I will never forgive the Pixy Murika... that is trying to... kill us!
	 */
	public static final NpcStringId I_WILL_NEVER_FORGIVE_THE_PIXY_MURIKA_THAT_IS_TRYING_TO_KILL_US;
	
	/**
	 * ID: 1000143<br>
	 * Message: ~J̗Dꂽ艺AĂI<br>
	 * Message: &#33707;&#22958;&#21345;&#30340;&#21329;&#36068;&#25163;&#19979;&#65292;&#37117;&#34909;&#36942;&#20358;&#21543;&#65281;<br>
	 * Message: Attack all the dull and stupid followers of Murika!
	 */
	public static final NpcStringId ATTACK_ALL_THE_DULL_AND_STUPID_FOLLOWERS_OF_MURIKA;
	
	/**
	 * ID: 1000144<br>
	 * Message: ̒x̔eCł͑łłȂI<br>
	 * Message: &#20197;&#20320;&#30340;&#24847;&#24535;&#26159;&#32085;&#23565;&#19981;&#21487;&#33021;&#30340;&#65281;<br>
	 * Message: I didn't have any idea about such ambitions!
	 */
	public static final NpcStringId I_DIDNT_HAVE_ANY_IDEA_ABOUT_SUCH_AMBITIONS;
	
	/**
	 * ID: 1000145<br>
	 * Message: ͏Ił͂ȂDDDn܂ɉ߂ȂB<br>
	 * Message: &#36889;&#19981;&#26159;&#32080;&#26463;&#46;&#46;&#46;&#32780;&#26159;&#38283;&#22987;&#32780;&#24050;&#12290;<br>
	 * Message: This is not the end... It's just the beginning.
	 */
	public static final NpcStringId THIS_IS_NOT_THE_END_ITS_JUST_THE_BEGINNING;
	
	/**
	 * ID: 1000146<br>
	 * Message: ӂDDDvԂ̊OoByƂ͂ȂȁDDD<br>
	 * Message: &#21621;&#46;&#46;&#46;&#22909;&#20037;&#27794;&#26377;&#20986;&#20358;&#29609;&#20102;&#65292;&#25105;&#20497;&#20358;&#29609;&#36938;&#25138;&#21543;&#46;&#46;&#46;<br>
	 * Message: Hey... Shall we have some fun for the first time in a long while?...
	 */
	public static final NpcStringId HEY_SHALL_WE_HAVE_SOME_FUN_FOR_THE_FIRST_TIME_IN_A_LONG_WHILE;
	
	/**
	 * ID: 1000147<br>
	 * Message: ̕ӂ̂΂Ăy炵DDD<br>
	 * Message: &#32893;&#35498;&#36817;&#20358;&#26377;&#20491;&#29378;&#22916;&#30340;&#20642;&#20249;&#46;&#46;&#46;<br>
	 * Message: There've been some things going around like crazy here recently...
	 */
	public static final NpcStringId THEREVE_BEEN_SOME_THINGS_GOING_AROUND_LIKE_CRAZY_HERE_RECENTLY;
	
	/**
	 * ID: 1000148<br>
	 * Message: ANƎvĂĨ}bNXIF̎ҁAI<br>
	 * Message: &#36889;&#20642;&#20249;&#65292;&#20320;&#30693;&#19981;&#30693;&#36947;&#25105;&#26159;&#35504;&#65281;&#25105;&#23601;&#26159;&#29802;&#38647;&#26031;&#65281;&#22823;&#23478;&#36914;&#25915;&#65281;<br>
	 * Message: Hey! Do you know who I am? I am Malex, Herald of Dagoniel! Attack!
	 */
	public static final NpcStringId HEY_DO_YOU_KNOW_WHO_I_AM_I_AM_MALEX_HERALD_OF_DAGONIEL_ATTACK;
	
	/**
	 * ID: 1000149<br>
	 * Message: Ȃ͂ł́DDD̕ss̃}bNXOȂ񂼂ɕƂ́DDD<br>
	 * Message: &#22825;&#21834;&#65281;&#24478;&#26410;&#25136;&#25943;&#30340;&#29802;&#38647;&#26031;&#31455;&#34987;&#20320;&#25802;&#25943;&#46;&#46;&#46;<br>
	 * Message: What's just happened?! The invincible Malex just lost to the likes of you?!
	 */
	public static final NpcStringId WHATS_JUST_HAPPENED_THE_INVINCIBLE_MALEX_JUST_LOST_TO_THE_LIKES_OF_YOU;
	
	/**
	 * ID: 1000150<br>
	 * Message: JԂDDD<br>
	 * Message: &#19981;&#26039;&#36650;&#36852;&#21453;&#35206;&#30340;&#33618;&#35628;&#20154;&#29983;&#46;&#46;&#46;<br>
	 * Message: It's something repeated in a vain life...
	 */
	public static final NpcStringId ITS_SOMETHING_REPEATED_IN_A_VAIN_LIFE;
	
	/**
	 * ID: 1000151<br>
	 * Message: ҂݂͂ȋ|ɜɂI<br>
	 * Message: &#27963;&#33879;&#30340;&#25152;&#26377;&#29983;&#29289;&#37117;&#38519;&#20837;&#24656;&#25084;&#21543;&#65281;<br>
	 * Message: Shake in fear, all you who value your lives!
	 */
	public static final NpcStringId SHAKE_IN_FEAR_ALL_YOU_WHO_VALUE_YOUR_LIVES;
	
	/**
	 * ID: 1000152<br>
	 * Message: 邱Ƃ̂ȂɓZ悤ȋꂵ݂𖡂킹ĂI<br>
	 * Message: &#25105;&#23559;&#35731;&#20320;&#20497;&#25215;&#21463;&#27704;&#19981;&#29060;&#28357;&#20043;&#28779;&#33324;&#30340;&#30171;&#33510;&#65281;<br>
	 * Message: I'll make you feel suffering like a flame that is never extinguished!
	 */
	public static final NpcStringId ILL_MAKE_YOU_FEEL_SUFFERING_LIKE_A_FLAME_THAT_IS_NEVER_EXTINGUISHED;
	
	/**
	 * ID: 1000153<br>
	 * Message: Ăѓy̒ɁDDD<br>
	 * Message: &#22238;&#27512;&#22303;&#20013;&#46;&#46;&#46;<br>
	 * Message: Back to the dirt...
	 */
	public static final NpcStringId BACK_TO_THE_DIRT;
	
	/**
	 * ID: 1000154<br>
	 * Message: @JlI΁I<br>
	 * Message: &#29926;&#29790;&#21345;&#65281;&#33836;&#27506;&#65374;<br>
	 * Message: Hail Varika!!
	 */
	public static final NpcStringId HAIL_VARIKA;
	
	/**
	 * ID: 1000155<br>
	 * Message: NX~߂邱Ƃ͂łȂI<br>
	 * Message: &#35504;&#37117;&#28961;&#27861;&#38459;&#25803;&#25105;&#20497;&#65281;<br>
	 * Message: Nobody can stop us!
	 */
	public static final NpcStringId NOBODY_CAN_STOP_US;
	
	/**
	 * ID: 1000156<br>
	 * Message: ݂I<br>
	 * Message: &#21205;&#20316;&#22826;&#24930;&#20102;&#65281;<br>
	 * Message: You move slowly!
	 */
	public static final NpcStringId YOU_MOVE_SLOWLY;
	
	/**
	 * ID: 1000157<br>
	 * Message: @JlIɐ܂I<br>
	 * Message: &#29926;&#29790;&#21345;&#65281;&#25105;&#20808;&#36208;&#20102;&#65281;<br>
	 * Message: Varika! Go first!
	 */
	public static final NpcStringId VARIKA_GO_FIRST;
	
	/**
	 * ID: 1000158<br>
	 * Message: ͂ǂH͒NH<br>
	 * Message: &#36889;&#26159;&#21738;&#35023;&#65311;&#25105;&#26159;&#35504;&#65311;<br>
	 * Message: Where am I? Who am I?
	 */
	public static final NpcStringId WHERE_AM_I_WHO_AM_I;
	
	/**
	 * ID: 1000159<br>
	 * Message: DDD悤ɒɂI͒NȂ񂾁H<br>
	 * Message: &#21834;&#46;&#46;&#46;&#38957;&#30140;&#24471;&#24456;&#65281;&#25105;&#26159;&#35504;&#65311;<br>
	 * Message: Uh... My head hurts like it's going to burst! Who am I?
	 */
	public static final NpcStringId UH_MY_HEAD_HURTS_LIKE_ITS_GOING_TO_BURST_WHO_AM_I;
	
	/**
	 * ID: 1000160<br>
	 * Message: MlBMl̈ȁIȖڂɍ킹ȁI<br>
	 * Message: &#36889;&#20491;&#20642;&#20249;&#12290;&#21407;&#20358;&#20320;&#23601;&#26159;&#24801;&#39764;&#65281;&#35731;&#25105;&#35722;&#25104;&#36889;&#20491;&#27169;&#27171;&#30340;&#24801;&#39764;&#65281;<br>
	 * Message: You jerk. You're a devil! You're a devil to have made me like this!
	 */
	public static final NpcStringId YOU_JERK_YOURE_A_DEVIL_YOURE_A_DEVIL_TO_HAVE_MADE_ME_LIKE_THIS;
	
	/**
	 * ID: 1000161<br>
	 * Message: DDDƐCɂȂDDD肪ƂBƂx߂B<br>
	 * Message: &#21834;&#46;&#46;&#46;&#32066;&#26044;&#28165;&#37266;&#20102;&#46;&#46;&#46;&#35613;&#35613;&#46;&#46;&#46;&#29694;&#22312;&#25105;&#32066;&#26044;&#21487;&#20197;&#20241;&#24687;&#20102;&#46;&#46;&#46;<br>
	 * Message: Where am I? What happened? Thank you!
	 */
	public static final NpcStringId WHERE_AM_I_WHAT_HAPPENED_THANK_YOU;
	
	/**
	 * ID: 1000162<br>
	 * Message: EN}X^I<br>
	 * Message: &#28879;&#21487;&#21202;&#39340;&#34311;&#22612;&#65281;<br>
	 * Message: Ukru Master!
	 */
	public static final NpcStringId UKRU_MASTER;
	
	/**
	 * ID: 1000163<br>
	 * Message: }gDiH<br>
	 * Message: &#29802;&#21520;&#32013;&#65311;<br>
	 * Message: Are you Matu?
	 */
	public static final NpcStringId ARE_YOU_MATU;
	
	/**
	 * ID: 1000164<br>
	 * Message: }bOIgDoITo`I<br>
	 * Message: &#29802;&#25289;&#20811;&#65281;&#21520;&#24052;&#26519;&#65281;&#27801;&#24052;&#25289;&#26597;&#65281;<br>
	 * Message: Marak! Tubarin! Sabaracha!
	 */
	public static final NpcStringId MARAK_TUBARIN_SABARACHA;
	
	/**
	 * ID: 1000165<br>
	 * Message: pOI^}I<br>
	 * Message: &#24085;&#26684;&#31435;&#27472;&#22612;&#29802;&#65281;<br>
	 * Message: Pa'agrio Tama!
	 */
	public static final NpcStringId PAAGRIO_TAMA;
	
	/**
	 * ID: 1000166<br>
	 * Message: CJẌӎuA󂯌pׂI<br>
	 * Message: &#20197;&#20234;&#20811;&#39791;&#26031;&#30340;&#24847;&#24535;&#46;&#46;&#46;&#25509;&#25307;&#21543;&#65281;<br>
	 * Message: Accept the will of Icarus!
	 */
	public static final NpcStringId ACCEPT_THE_WILL_OF_ICARUS;
	
	/**
	 * ID: 1000167<br>
	 * Message: זĂ҂͋񂼁I<br>
	 * Message: &#38459;&#25803;&#25105;&#30340;&#20154;&#65281;&#32085;&#19981;&#33021;&#21407;&#35538;&#65281;<br>
	 * Message: The people who are blocking my way will not be forgiven...
	 */
	public static final NpcStringId THE_PEOPLE_WHO_ARE_BLOCKING_MY_WAY_WILL_NOT_BE_FORGIVEN;
	
	/**
	 * ID: 1000168<br>
	 * Message: ͂Ȃ낤ǂDDD<br>
	 * Message: &#33178;&#28154;&#30340;&#20642;&#20249;&#20497;&#46;&#46;&#46;<br>
	 * Message: You are scum.
	 */
	public static final NpcStringId YOU_ARE_SCUM;
	
	/**
	 * ID: 1000169<br>
	 * Message: ͂܂ȂȂȂ܂B<br>
	 * Message: &#21205;&#21147;&#24555;&#35201;&#19981;&#22816;&#20102;&#12290;<br>
	 * Message: You lack power.
	 */
	public static final NpcStringId YOU_LACK_POWER;
	
	/**
	 * ID: 1000170<br>
	 * Message: ߂<br>
	 * Message: &#36820;&#22238;<br>
	 * Message: Return
	 */
	public static final NpcStringId RETURN;
	
	/**
	 * ID: 1000171<br>
	 * Message: AfiJz܂B<br>
	 * Message: &#22825;&#24163;&#32080;&#36681;&#21040;&#19979;&#20491;&#26376;&#20102;&#12290;<br>
	 * Message: Adena has been transferred.
	 */
	public static final NpcStringId ADENA_HAS_BEEN_TRANSFERRED;
	
	/**
	 * ID: 1000172<br>
	 * Message: F<br>
	 * Message: &#22238;&#21512;<br>
	 * Message: Event Number
	 */
	public static final NpcStringId EVENT_NUMBER;
	
	/**
	 * ID: 1000173<br>
	 * Message: 1<br>
	 * Message: &#38957;&#29518;<br>
	 * Message: First Prize
	 */
	public static final NpcStringId FIRST_PRIZE;
	
	/**
	 * ID: 1000174<br>
	 * Message: 2<br>
	 * Message: &#20108;&#29518;<br>
	 * Message: Second Prize
	 */
	public static final NpcStringId SECOND_PRIZE;
	
	/**
	 * ID: 1000175<br>
	 * Message: 3<br>
	 * Message: &#19977;&#29518;<br>
	 * Message: Third Prize
	 */
	public static final NpcStringId THIRD_PRIZE;
	
	/**
	 * ID: 1000176<br>
	 * Message: 4<br>
	 * Message: &#22235;&#29518;<br>
	 * Message: Fourth Prize
	 */
	public static final NpcStringId FOURTH_PRIZE;
	
	/**
	 * ID: 1000177<br>
	 * Message: I󂭂܂B<br>
	 * Message: &#27794;&#26377;&#20013;&#29518;&#30340;&#24425;&#21048;&#12290;<br>
	 * Message: There has been no winning lottery ticket.
	 */
	public static final NpcStringId THERE_HAS_BEEN_NO_WINNING_LOTTERY_TICKET;
	
	/**
	 * ID: 1000178<br>
	 * Message: ̓IԍF<br>
	 * Message: &#36889;&#27425;&#20013;&#29518;&#34399;&#30908;&#65306;<br>
	 * Message: The most recent winning lottery numbers
	 */
	public static final NpcStringId THE_MOST_RECENT_WINNING_LOTTERY_NUMBERS;
	
	/**
	 * ID: 1000179<br>
	 * Message: ̔ԍőI<br>
	 * Message: &#36984;&#25799;&#19978;&#38754;&#30340;&#34399;&#30908;<br>
	 * Message: Your lucky numbers have been selected above.
	 */
	public static final NpcStringId YOUR_LUCKY_NUMBERS_HAVE_BEEN_SELECTED_ABOVE;
	
	/**
	 * ID: 1000180<br>
	 * Message: ɋ߂ÂƂ҂͒NI<br>
	 * Message: &#26159;&#35504;&#22312;&#38752;&#36817;&#36889;&#35041;&#21568;&#65281;<br>
	 * Message: I wonder who it is that is lurking about..
	 */
	public static final NpcStringId I_WONDER_WHO_IT_IS_THAT_IS_LURKING_ABOUT;
	
	/**
	 * ID: 1000181<br>
	 * Message: ͐_Ȗ@鏊łB<br>
	 * Message: &#36889;&#35041;&#26159;&#30740;&#31350;&#31070;&#32854;&#39764;&#27861;&#30340;&#22320;&#26041;&#12290;<br>
	 * Message: Sacred magical research is conducted here.
	 */
	public static final NpcStringId SACRED_MAGICAL_RESEARCH_IS_CONDUCTED_HERE;
	
	/**
	 * ID: 1000182<br>
	 * Message: ̑Ȗ@̗͂Ă낤I<br>
	 * Message: &#35731;&#20320;&#30631;&#30631;&#20553;&#22823;&#30340;&#39764;&#27861;&#20043;&#21147;&#65281;<br>
	 * Message: Behold the awesome power of magic!
	 */
	public static final NpcStringId BEHOLD_THE_AWESOME_POWER_OF_MAGIC;
	
	/**
	 * ID: 1000183<br>
	 * Message: ȂȂ債̂ȁBAʃCWɂ͎oȂق낤B<br>
	 * Message: &#20320;&#30340;&#21147;&#37327;&#20063;&#24456;&#24375;&#22823;&#12290;&#20294;&#26159;&#26368;&#22909;&#36996;&#26159;&#19981;&#35201;&#25307;&#24825;&#39640;&#38542;&#39764;&#27861;&#24107;&#12290;<br>
	 * Message: Your powers are impressive but you must not annoy our high level sorcerer.
	 */
	public static final NpcStringId YOUR_POWERS_ARE_IMPRESSIVE_BUT_YOU_MUST_NOT_ANNOY_OUR_HIGH_LEVEL_SORCERER;
	
	/**
	 * ID: 1000184<br>
	 * Message: Ԃ̎l̃o_lBEnnnI<br>
	 * Message: &#25105;&#26159;&#23665;&#23528;&#30340;&#20027;&#20154;&#24052;&#27931;&#36948;&#12290;&#21704;&#21704;&#21704;&#65281;&#65281;&#65281;<br>
	 * Message: I am Barda, master of the Bandit Stronghold!
	 */
	public static final NpcStringId I_AM_BARDA_MASTER_OF_THE_BANDIT_STRONGHOLD;
	
	/**
	 * ID: 1000185<br>
	 * Message: ̍Ԃ͌X̃o_l̂̂Ȃ̂B<br>
	 * Message: &#37027;&#20491;&#23665;&#23528;&#26412;&#20358;&#23601;&#26159;&#25105;&#24052;&#27931;&#36948;&#30340;&#12290;<br>
	 * Message: I, Master Barda, once owned that stronghold,
	 */
	public static final NpcStringId I_MASTER_BARDA_ONCE_OWNED_THAT_STRONGHOLD;
	
	/**
	 * ID: 1000186<br>
	 * Message: ւA낻ȁB<br>
	 * Message: &#21734;&#65281;&#24456;&#26377;&#36259;&#12290;<br>
	 * Message: Ah, very interesting!
	 */
	public static final NpcStringId AH_VERY_INTERESTING;
	
	/**
	 * ID: 1000187<br>
	 * Message: v肻ȁB͈Uق悳B<br>
	 * Message: &#27604;&#24819;&#20687;&#20013;&#36996;&#21426;&#23475;&#65292;&#25105;&#26371;&#20877;&#22238;&#20358;&#30340;&#126;<br>
	 * Message: You are more powerful than you appear. We'll meet again!
	 */
	public static final NpcStringId YOU_ARE_MORE_POWERFUL_THAN_YOU_APPEAR_WELL_MEET_AGAIN;
	
	/**
	 * ID: 1000188<br>
	 * Message: oJȃCWǂ߁I<br>
	 * Message: &#21487;&#24801;&#30340;&#39764;&#27861;&#24107;&#20497;&#12290;<br>
	 * Message: You filthy sorcerers disgust me!
	 */
	public static final NpcStringId YOU_FILTHY_SORCERERS_DISGUST_ME;
	
	/**
	 * ID: 1000189<br>
	 * Message: ӋCɂ̒nɐNƂ͂ȁIł͂ȂI<br>
	 * Message: &#31455;&#25954;&#20405;&#29359;&#25105;&#20497;&#30340;&#22303;&#22320;&#33;&#32085;&#19981;&#26371;&#39250;&#20102;&#20320;&#20497;&#33;<br>
	 * Message: Why would you build a tower in our territory?
	 */
	public static final NpcStringId WHY_WOULD_YOU_BUILD_A_TOWER_IN_OUR_TERRITORY;
	
	/**
	 * ID: 1000190<br>
	 * Message: O׈ȃCWƃOȂ̂B<br>
	 * Message: &#20320;&#20497;&#20063;&#21644;&#37027;&#20123;&#37034;&#24801;&#39764;&#27861;&#24107;&#21516;&#19968;&#36335;&#30340;&#21966;&#65311;<br>
	 * Message: Are you part of that evil gang of sorcerers?
	 */
	public static final NpcStringId ARE_YOU_PART_OF_THAT_EVIL_GANG_OF_SORCERERS;
	
	/**
	 * ID: 1000191<br>
	 * Message: ꂾ烁CW̎qȂ񂩂Ɛ킢Ȃ񂾁B<br>
	 * Message: &#23601;&#22240;&#28858;&#36889;&#27171;&#65292;&#25152;&#20197;&#25105;&#25165;&#19981;&#24819;&#21644;&#39764;&#27861;&#24107;&#30340;&#25163;&#19979;&#25136;&#39717;&#12290;<br>
	 * Message: That is why I don't bother with anyone below the level of sorcerer.
	 */
	public static final NpcStringId THAT_IS_WHY_I_DONT_BOTHER_WITH_ANYONE_BELOW_THE_LEVEL_OF_SORCERER;
	
	/**
	 * ID: 1000192<br>
	 * Message: yn܂ȁDDD<br>
	 * Message: &#20170;&#22825;&#20063;&#26159;&#24841;&#24555;&#30340;&#19968;&#22825;&#21834;&#46;&#46;&#46;<br>
	 * Message: Ah, another beautiful day!
	 */
	public static final NpcStringId AH_ANOTHER_BEAUTIFUL_DAY;
	
	/**
	 * ID: 1000193<br>
	 * Message: ΂ƗD͉B̐傳B<br>
	 * Message: &#25918;&#28779;&#21644;&#25504;&#22890;&#26159;&#25105;&#20497;&#30340;&#23560;&#38263;&#12290;<br>
	 * Message: Our specialties are arson and looting.
	 */
	public static final NpcStringId OUR_SPECIALTIES_ARE_ARSON_AND_LOOTING;
	
	/**
	 * ID: 1000194<br>
	 * Message: O̗Lc炸Ă낤I<br>
	 * Message: &#35731;&#25105;&#20358;&#20599;&#20809;&#20320;&#22218;&#20013;&#30340;&#26481;&#35199;&#65281;<br>
	 * Message: You will leave empty-handed!
	 */
	public static final NpcStringId YOU_WILL_LEAVE_EMPTY_HANDED;
	
	/**
	 * ID: 1000195<br>
	 * Message: W߂󕨂Ȃɗ~̂BATĂ݂邱ƂInnnI<br>
	 * Message: &#20320;&#22402;&#28046;&#25105;&#25152;&#25910;&#34255;&#30340;&#23542;&#29289;&#21966;&#65311;&#37027;&#23601;&#25214;&#25214;&#30475;&#21543;&#65281;&#21704;&#21704;&#21704;&#65281;<br>
	 * Message: Ah, so you admire my treasure, do you? Try finding it! Ha!
	 */
	public static final NpcStringId AH_SO_YOU_ADMIRE_MY_TREASURE_DO_YOU_TRY_FINDING_IT_HA;
	
	/**
	 * ID: 1000196<br>
	 * Message: F̎ҁAĂ̂BVIl̂߂肾BF̎ҁArhqDDD<br>
	 * Message: &#22823;&#23478;&#32893;&#22909;&#65281;&#35199;&#29790;&#24681;&#22238;&#20358;&#20102;&#12290;&#20840;&#37117;&#33180;&#25308;&#21543;&#8230;<br>
	 * Message: Is everybody listening? Sirion has come back. Everyone chant and bow...
	 */
	public static final NpcStringId IS_EVERYBODY_LISTENING_SIRION_HAS_COME_BACK_EVERYONE_CHANT_AND_BOW;
	
	/**
	 * ID: 1000197<br>
	 * Message: ɑ҂ǂIIT낤I<br>
	 * Message: &#21329;&#36068;&#30340;&#20154;&#39006;&#46;&#46;&#46;&#20840;&#37117;&#20302;&#38957;&#21543;&#65281;<br>
	 * Message: Bow down, you worthless humans!
	 */
	public static final NpcStringId BOW_DOWN_YOU_WORTHLESS_HUMANS;
	
	/**
	 * ID: 1000198<br>
	 * Message: ɑ܂ҁDDD<br>
	 * Message: &#24046;&#24471;&#36960;&#21602;&#46;&#46;&#46;<br>
	 * Message: Very tacky!
	 */
	public static final NpcStringId VERY_TACKY;
	
	/**
	 * ID: 1000199<br>
	 * Message: bNDDDł|ƈ̂͂܂DDD<br>
	 * Message: &#20320;&#20497;&#46;&#46;&#46;&#23601;&#31639;&#25171;&#25943;&#20102;&#25105;&#65292;&#20063;&#19981;&#35201;&#23433;&#24515;&#46;&#46;&#46;<br>
	 * Message: Don't think that you are invincible just because you defeated me!
	 */
	public static final NpcStringId DONT_THINK_THAT_YOU_ARE_INVINCIBLE_JUST_BECAUSE_YOU_DEFEATED_ME;
	
	/**
	 * ID: 1000200<br>
	 * Message: ̖𗧂DDD҂̗~]DDD<br>
	 * Message: &#34395;&#28961;&#30340;&#26159;&#46;&#46;&#46;&#27963;&#20154;&#30340;&#27442;&#26395;&#46;&#46;&#46;<br>
	 * Message: The material desires of mortals are ultimately meaningless.
	 */
	public static final NpcStringId THE_MATERIAL_DESIRES_OF_MORTALS_ARE_ULTIMATELY_MEANINGLESS;
	
	/**
	 * ID: 1000201<br>
	 * Message: ̓󂵂Pl邱ƂDDD<br>
	 * Message: &#35352;&#20303;&#20658;&#24930;&#20043;&#22612;&#23849;&#28528;&#30340;&#21407;&#22240;&#46;&#46;&#46;<br>
	 * Message: Do not forget the reason the Tower of Insolence collapsed.
	 */
	public static final NpcStringId DO_NOT_FORGET_THE_REASON_THE_TOWER_OF_INSOLENCE_COLLAPSED;
	
	/**
	 * ID: 1000202<br>
	 * Message: ~[҂ǂB~[MǂDDD<br>
	 * Message: &#22826;&#36010;&#23146;&#30340;&#20154;&#39006;&#12290;&#22826;&#36010;&#23146;&#30340;&#36020;&#26063;&#20497;&#12290;<br>
	 * Message: You humans are all alike, full of greed and avarice!
	 */
	public static final NpcStringId YOU_HUMANS_ARE_ALL_ALIKE_FULL_OF_GREED_AND_AVARICE;
	
	/**
	 * ID: 1000203<br>
	 * Message: BׂĂ̂Ƃ̂DDD<br>
	 * Message: &#22826;&#34395;&#28961;&#12290;&#19968;&#20999;&#37117;&#22826;&#34395;&#28961;&#46;&#46;&#46;<br>
	 * Message: All for nothing,
	 */
	public static final NpcStringId ALL_FOR_NOTHING;
	
	/**
	 * ID: 1000204<br>
	 * Message: ȂAȂɂȂɐl̂H<br>
	 * Message: &#21710;&#21568;&#65292;&#24590;&#40636;&#36889;&#40636;&#22810;&#30340;&#20154;&#21602;&#65311;<br>
	 * Message: What are all these people doing here?
	 */
	public static final NpcStringId WHAT_ARE_ALL_THESE_PEOPLE_DOING_HERE;
	
	/**
	 * ID: 1000205<br>
	 * Message: ǂɉi̖̔閧͂BIVgǂ߁I<br>
	 * Message: &#27704;&#29983;&#30340;&#31061;&#23494;&#25033;&#35442;&#22312;&#26576;&#20491;&#22320;&#26041;&#12290;&#21487;&#24801;&#30340;&#27515;&#22825;&#20351;&#20497;&#12290;<br>
	 * Message: I must find the secret of eternal life, here among these rotten angels!
	 */
	public static final NpcStringId I_MUST_FIND_THE_SECRET_OF_ETERNAL_LIFE_HERE_AMONG_THESE_ROTTEN_ANGELS;
	
	/**
	 * ID: 1000206<br>
	 * Message: Oi̖̔閧TĂ̂B<br>
	 * Message: &#20320;&#20497;&#20063;&#22312;&#25214;&#27704;&#29983;&#30340;&#31061;&#23494;&#21966;&#65311;<br>
	 * Message: Do you also seek the secret of immortality?
	 */
	public static final NpcStringId DO_YOU_ALSO_SEEK_THE_SECRET_OF_IMMORTALITY;
	
	/**
	 * ID: 1000207<br>
	 * Message: mĂƂĂĘbĂB<br>
	 * Message: &#25105;&#32085;&#23565;&#19981;&#26371;&#21578;&#35380;&#20320;&#25105;&#25152;&#30693;&#36947;&#30340;&#26481;&#35199;&#12290;<br>
	 * Message: I shall never reveal my secrets!
	 */
	public static final NpcStringId I_SHALL_NEVER_REVEAL_MY_SECRETS;
	
	/**
	 * ID: 1000208<br>
	 * Message: ӋCɂNɓėƂ̂B<br>
	 * Message: &#26159;&#35504;&#25954;&#36914;&#20358;&#36889;&#35041;&#65311;&#65281;<br>
	 * Message: Who dares enter this place?
	 */
	public static final NpcStringId WHO_DARES_ENTER_THIS_PLACE;
	
	/**
	 * ID: 1000209<br>
	 * Message: ͂Ô悤ȂƂł͂ȂBočsI<br>
	 * Message: &#36889;&#35041;&#19981;&#26159;&#20154;&#39006;&#21487;&#20197;&#36914;&#20358;&#30340;&#22320;&#26041;&#12290;&#36245;&#24555;&#32102;&#25105;&#20986;&#21435;&#65281;<br>
	 * Message: This is no place for humans! You must leave immediately.
	 */
	public static final NpcStringId THIS_IS_NO_PLACE_FOR_HUMANS_YOU_MUST_LEAVE_IMMEDIATELY;
	
	/**
	 * ID: 1000210<br>
	 * Message: Ȃ҂ǂBŐ݂킩ʂ̂B<br>
	 * Message: &#20154;&#39006;&#21834;&#65281;&#38627;&#36947;&#20320;&#20497;&#19981;&#30693;&#36947;&#33258;&#24049;&#30340;&#24858;&#37389;&#65281;<br>
	 * Message: You poor creatures! Too stupid to realize your own ignorance!
	 */
	public static final NpcStringId YOU_POOR_CREATURES_TOO_STUPID_TO_REALIZE_YOUR_OWN_IGNORANCE;
	
	/**
	 * ID: 1000211<br>
	 * Message: 悹B̏ɍsĂ͂ȂʁB<br>
	 * Message: &#19981;&#34892;&#12290;&#19981;&#33021;&#21040;&#19978;&#38754;&#21435;&#12290;<br>
	 * Message: You mustn't go there!
	 */
	public static final NpcStringId YOU_MUSTNT_GO_THERE;
	
	/**
	 * ID: 1000212<br>
	 * Message: ̏҂͒NB<br>
	 * Message: &#21738;&#20491;&#20642;&#20249;&#24324;&#20098;&#36889;&#27836;&#28580;&#65311;<br>
	 * Message: Who dares disturb this marsh?
	 */
	public static final NpcStringId WHO_DARES_DISTURB_THIS_MARSH;
	
	/**
	 * ID: 1000213<br>
	 * Message: ҂ǂ̗~]ŁAn܂rꂳ킯ɂ͂B<br>
	 * Message: &#27770;&#19981;&#33021;&#20877;&#27425;&#22240;&#28858;&#20154;&#39006;&#30340;&#36010;&#24958;&#32780;&#25226;&#27836;&#28580;&#33618;&#24290;&#25481;&#12290;<br>
	 * Message: The humans must not be allowed to destroy the marshland for their greedy purposes.
	 */
	public static final NpcStringId THE_HUMANS_MUST_NOT_BE_ALLOWED_TO_DESTROY_THE_MARSHLAND_FOR_THEIR_GREEDY_PURPOSES;
	
	/**
	 * ID: 1000214<br>
	 * Message: EȂȁDDD<br>
	 * Message: &#26159;&#20491;&#21191;&#25954;&#30340;&#20642;&#20249;&#21602;&#46;&#46;&#46;<br>
	 * Message: You are a brave man...
	 */
	public static final NpcStringId YOU_ARE_A_BRAVE_MAN;
	
	/**
	 * ID: 1000215<br>
	 * Message: ҂ǂDDDO͂B<br>
	 * Message: &#24858;&#31528;&#30340;&#20642;&#20249;&#21834;&#46;&#46;&#46;&#32317;&#26377;&#19968;&#22825;&#20320;&#20497;&#20063;&#26371;&#28040;&#22833;&#30340;&#12290;<br>
	 * Message: You idiots! Some day you shall also be gone!
	 */
	public static final NpcStringId YOU_IDIOTS_SOME_DAY_YOU_SHALL_ALSO_BE_GONE;
	
	/**
	 * ID: 1000216<br>
	 * Message: NXɓėDDD<br>
	 * Message: &#26377;&#20154;&#36914;&#20837;&#36889;&#26862;&#26519;&#35023;&#20102;&#46;&#46;&#46;<br>
	 * Message: Someone has entered the forest...
	 */
	public static final NpcStringId SOMEONE_HAS_ENTERED_THE_FOREST;
	
	/**
	 * ID: 1000217<br>
	 * Message: ̐X͂ƂĂÂŕaȏꏊB<br>
	 * Message: &#36889;&#26862;&#26519;&#26159;&#20491;&#26082;&#23433;&#38748;&#21448;&#24179;&#21644;&#30340;&#22320;&#26041;&#12290;<br>
	 * Message: The forest is very quiet and peaceful.
	 */
	public static final NpcStringId THE_FOREST_IS_VERY_QUIET_AND_PEACEFUL;
	
	/**
	 * ID: 1000218<br>
	 * Message: ͂B̐X͂ƂĂƂ낾B<br>
	 * Message: &#20320;&#30041;&#22312;&#36889;&#35041;&#21543;&#65281;&#36889;&#26862;&#26519;&#26159;&#38750;&#24120;&#22909;&#30340;&#22320;&#26041;&#12290;<br>
	 * Message: Stay here in this wonderful forest!
	 */
	public static final NpcStringId STAY_HERE_IN_THIS_WONDERFUL_FOREST;
	
	/**
	 * ID: 1000219<br>
	 * Message: DDD̍DDD<br>
	 * Message: &#25105;&#46;&#46;&#46;&#25105;&#30340;&#38728;&#39746;&#46;&#46;&#46;<br>
	 * Message: My... my souls...
	 */
	public static final NpcStringId MY_MY_SOULS;
	
	/**
	 * ID: 1000220<br>
	 * Message: ̐X͊댯B<br>
	 * Message: &#36889;&#26862;&#26519;&#24456;&#21361;&#38570;&#12290;<br>
	 * Message: This forest is a dangerous place.
	 */
	public static final NpcStringId THIS_FOREST_IS_A_DANGEROUS_PLACE;
	
	/**
	 * ID: 1000221<br>
	 * Message: ̐XočsIȂ΁A傫ȍЂ~肩邾낤B<br>
	 * Message: &#33509;&#19981;&#31435;&#21051;&#38626;&#38283;&#36889;&#35041;&#65292;&#26371;&#30332;&#29983;&#24456;&#22823;&#30340;&#28797;&#31117;&#12290;<br>
	 * Message: Unless you leave this forest immediately you are bound to run into serious trouble.
	 */
	public static final NpcStringId UNLESS_YOU_LEAVE_THIS_FOREST_IMMEDIATELY_YOU_ARE_BOUND_TO_RUN_INTO_SERIOUS_TROUBLE;
	
	/**
	 * ID: 1000222<br>
	 * Message: očsI<br>
	 * Message: &#36245;&#24555;&#38626;&#38283;&#36889;&#35041;&#65281;<br>
	 * Message: Leave now!
	 */
	public static final NpcStringId LEAVE_NOW;
	
	/**
	 * ID: 1000223<br>
	 * Message: ǂāǍx𖳎̂H<br>
	 * Message: &#28858;&#20160;&#40636;&#28448;&#35222;&#25105;&#30340;&#35686;&#21578;&#21602;&#65311;<br>
	 * Message: Why do you ignore my warning?
	 */
	public static final NpcStringId WHY_DO_YOU_IGNORE_MY_WARNING;
	
	/**
	 * ID: 1000224<br>
	 * Message: ׂ̐̂ẴncDDDO炩ɂĂ낤DDD<br>
	 * Message: &#19990;&#19978;&#25152;&#26377;&#30340;&#21704;&#37324;&#29305;&#21834;&#46;&#46;&#46;&#25105;&#36060;&#20104;&#20320;&#20497;&#24179;&#23433;&#46;&#46;&#46;<br>
	 * Message: Harits of the world... I bring you peace!
	 */
	public static final NpcStringId HARITS_OF_THE_WORLD_I_BRING_YOU_PEACE;
	
	/**
	 * ID: 1000225<br>
	 * Message: ׂẴncIECoI<br>
	 * Message: &#25152;&#26377;&#21704;&#37324;&#29305;&#21834;&#65281;&#40723;&#36215;&#21191;&#27683;&#21543;&#65281;<br>
	 * Message: Harits! Be courageous!
	 */
	public static final NpcStringId HARITS_BE_COURAGEOUS;
	
	/**
	 * ID: 1000226<br>
	 * Message: O̐ԂSĂI<br>
	 * Message: &#35731;&#25105;&#20358;&#21507;&#25481;&#20320;&#34880;&#32005;&#30340;&#24515;&#33247;&#65281;<br>
	 * Message: I shall eat your still-beating heart!.
	 */
	public static final NpcStringId I_SHALL_EAT_YOUR_STILL_BEATING_HEART;
	
	/**
	 * ID: 1000227<br>
	 * Message: ̃ncDDDĂі߂ė܂ŁDDD]̂āDDDȁDDD<br>
	 * Message: &#25105;&#30340;&#21704;&#37324;&#29305;&#21834;&#46;&#46;&#46;&#30452;&#21040;&#25105;&#20877;&#27425;&#22238;&#20358;&#20043;&#21069;&#46;&#46;&#46;&#21029;&#25918;&#26820;&#46;&#46;&#46;&#24076;&#26395;&#46;&#46;&#46;<br>
	 * Message: Harits! Keep faith until the day I return... Never lose hope!
	 */
	public static final NpcStringId HARITS_KEEP_FAITH_UNTIL_THE_DAY_I_RETURN_NEVER_LOSE_HOPE;
	
	/**
	 * ID: 1000228<br>
	 * Message: l̐EÎ͂ȂI<br>
	 * Message: &#24040;&#20154;&#28040;&#22833;&#30340;&#19990;&#30028;&#65281;&#27794;&#20160;&#40636;&#21487;&#24597;&#30340;&#65281;<br>
	 * Message: Even the giants are gone! There's nothing left to be afraid of now!
	 */
	public static final NpcStringId EVEN_THE_GIANTS_ARE_GONE_THERES_NOTHING_LEFT_TO_BE_AFRAID_OF_NOW;
	
	/**
	 * ID: 1000229<br>
	 * Message: lɂĒmĂȁH̖ŖS͓R߂錋ʂȂ̂I<br>
	 * Message: &#20320;&#30693;&#36947;&#26377;&#38364;&#24040;&#20154;&#30340;&#20107;&#21966;&#65311;&#20182;&#20497;&#30340;&#28357;&#20129;&#26159;&#29702;&#25152;&#30070;&#28982;&#30340;&#32080;&#26524;&#65281;<br>
	 * Message: Have you heard of the giants? Their downfall was inevitable!
	 */
	public static final NpcStringId HAVE_YOU_HEARD_OF_THE_GIANTS_THEIR_DOWNFALL_WAS_INEVITABLE;
	
	/**
	 * ID: 1000230<br>
	 * Message: IƐ키̂I<br>
	 * Message: &#22823;&#33213;&#65281;&#20320;&#31455;&#25954;&#21521;&#25105;&#25361;&#25136;&#65281;<br>
	 * Message: What nerve! Do you dare to challenge me?
	 */
	public static final NpcStringId WHAT_NERVE_DO_YOU_DARE_TO_CHALLENGE_ME;
	
	/**
	 * ID: 1000231<br>
	 * Message: O܂lƓ׈ȂDDDȁDDD<br>
	 * Message: &#20320;&#20063;&#26159;&#36319;&#24040;&#20154;&#24046;&#19981;&#22810;&#65292;&#26159;&#20491;&#37034;&#24801;&#30340;&#46;&#46;&#46;&#20642;&#20249;&#46;&#46;&#46;<br>
	 * Message: You are as evil as the giants...
	 */
	public static final NpcStringId YOU_ARE_AS_EVIL_AS_THE_GIANTS;
	
	/**
	 * ID: 1000232<br>
	 * Message: ̃_W͂܂݂B<br>
	 * Message: &#36889;&#27934;&#31391;&#21040;&#29694;&#22312;&#36996;&#22312;&#21834;&#65281;<br>
	 * Message: This dungeon is still in good condition!
	 */
	public static final NpcStringId THIS_DUNGEON_IS_STILL_IN_GOOD_CONDITION;
	
	/**
	 * ID: 1000233<br>
	 * Message: ɗYsȁB<br>
	 * Message: &#36889;&#21487;&#31639;&#22816;&#38596;&#20553;&#20102;&#21543;&#65281;<br>
	 * Message: This place is spectacular, wouldn't you say?
	 */
	public static final NpcStringId THIS_PLACE_IS_SPECTACULAR_WOULDNT_YOU_SAY;
	
	/**
	 * ID: 1000234<br>
	 * Message: O͗EȐmI<br>
	 * Message: &#20320;&#20497;&#26159;&#24456;&#21191;&#25954;&#30340;&#25136;&#22763;&#12290;<br>
	 * Message: You are very brave warriors!
	 */
	public static final NpcStringId YOU_ARE_VERY_BRAVE_WARRIORS;
	
	/**
	 * ID: 1000235<br>
	 * Message: ͂l̎͗Ȃ̂B<br>
	 * Message: &#24040;&#20154;&#30340;&#26178;&#20195;&#26524;&#30495;&#19981;&#26371;&#20877;&#20358;&#20102;&#21966;&#65311;&#65281;<br>
	 * Message: Are the giants truly gone for good?
	 */
	public static final NpcStringId ARE_THE_GIANTS_TRULY_GONE_FOR_GOOD;
	
	/**
	 * ID: 1000236<br>
	 * Message: 悾B<br>
	 * Message: &#36889;&#20123;&#22707;&#22675;&#24456;&#19981;&#37679;&#12290;<br>
	 * Message: These graves are good.
	 */
	public static final NpcStringId THESE_GRAVES_ARE_GOOD;
	
	/**
	 * ID: 1000237<br>
	 * Message: S҂ɋȂǕKv͂ȂB<br>
	 * Message: &#23565;&#20129;&#32773;&#32780;&#35328;&#37329;&#37504;&#36001;&#23542;&#21448;&#26377;&#20309;&#29992;&#12290;<br>
	 * Message: Gold and silver are meaningless to a dead man!
	 */
	public static final NpcStringId GOLD_AND_SILVER_ARE_MEANINGLESS_TO_A_DEAD_MAN;
	
	/**
	 * ID: 1000238<br>
	 * Message: ԔȋMǂ߁IȂĝ̂𖄂߂̂B<br>
	 * Message: &#21533;&#21959;&#30340;&#36020;&#26063;&#20642;&#20249;&#12290;&#24185;&#22043;&#23559;&#36889;&#20123;&#26377;&#29992;&#30340;&#26481;&#35199;&#22475;&#36215;&#20358;&#21602;&#65281;<br>
	 * Message: Why would those corrupt aristocrats bury such useful things?
	 */
	public static final NpcStringId WHY_WOULD_THOSE_CORRUPT_ARISTOCRATS_BURY_SUCH_USEFUL_THINGS;
	
	/**
	 * ID: 1000239<br>
	 * Message: B炵邾ȂāB<br>
	 * Message: &#21533;&#21959;&#30340;&#20642;&#20249;&#12290;&#20320;&#22909;&#22909;&#30340;&#27963;&#21543;&#20320;&#12290;<br>
	 * Message: You filthy pig! Eat and be merry now that you have shirked your responsibilities!
	 */
	public static final NpcStringId YOU_FILTHY_PIG_EAT_AND_BE_MERRY_NOW_THAT_YOU_HAVE_SHIRKED_YOUR_RESPONSIBILITIES;
	
	/**
	 * ID: 1000240<br>
	 * Message: Y^Y^ɐ؂􂢂āAVV򂢎U炷ł͋C܂̂IAf̂߁A񂼁I<br>
	 * Message: &#23601;&#31639;&#25226;&#36889;&#20123;&#20126;&#19969;&#20154;&#25749;&#29211;&#22204;&#30862;&#20358;&#21507;&#20063;&#19981;&#22816;&#30171;&#24555;&#65281;&#65281;<br>
	 * Message: Those thugs! It would be too merciful to rip them apart and chew them up one at a time!
	 */
	public static final NpcStringId THOSE_THUGS_IT_WOULD_BE_TOO_MERCIFUL_TO_RIP_THEM_APART_AND_CHEW_THEM_UP_ONE_AT_A_TIME;
	
	/**
	 * ID: 1000241<br>
	 * Message: AAf̂߁I<br>
	 * Message: &#35442;&#21463;&#35419;&#21650;&#30340;&#20126;&#19969;&#20154;&#20497;&#65281;<br>
	 * Message: You accursed scoundrels!
	 */
	public static final NpcStringId YOU_ACCURSED_SCOUNDRELS;
	
	/**
	 * ID: 1000242<br>
	 * Message: tbDDDAf̃AzǂÎE҂B<br>
	 * Message: &#21621;&#46;&#46;&#46;&#26159;&#20126;&#19969;&#30340;&#34850;&#34507;&#27966;&#20358;&#30340;&#26263;&#27578;&#32773;&#21966;&#65311;<br>
	 * Message: Hmm, could this be the assassin sent by those idiots from Aden?
	 */
	public static final NpcStringId HMM_COULD_THIS_BE_THE_ASSASSIN_SENT_BY_THOSE_IDIOTS_FROM_ADEN;
	
	/**
	 * ID: 1000243<br>
	 * Message: ̑ȂDDDiɂOĂ낤I<br>
	 * Message: &#25105;&#30340;&#24616;&#24680;&#35299;&#38500;&#19981;&#20102;&#30340;&#35441;&#46;&#46;&#25105;&#23559;&#27704;&#36960;&#35419;&#21650;&#20320;&#20497;&#65281;<br>
	 * Message: I shall curse your name with my last breath!
	 */
	public static final NpcStringId I_SHALL_CURSE_YOUR_NAME_WITH_MY_LAST_BREATH;
	
	/**
	 * ID: 1000244<br>
	 * Message: hV[lDDD<br>
	 * Message: &#25105;&#35242;&#24859;&#30340;&#24109;&#29747;&#22899;&#31070;&#46;&#46;&#46;<br>
	 * Message: My beloved Lord Shilen.
	 */
	public static final NpcStringId MY_BELOVED_LORD_SHILEN;
	
	/**
	 * ID: 1000245<br>
	 * Message: V[l̕𑁂čグȂ΂ȂȂ̂ɁDDD<br>
	 * Message: &#25105;&#25033;&#35442;&#36245;&#24555;&#24171;&#24109;&#29747;&#22899;&#31070;&#35299;&#38283;&#22905;&#30340;&#23553;&#21360;&#46;&#46;&#46;<br>
	 * Message: I must break the seal and release Lord Shilen as soon as possible...
	 */
	public static final NpcStringId I_MUST_BREAK_THE_SEAL_AND_RELEASE_LORD_SHILEN_AS_SOON_AS_POSSIBLE;
	
	/**
	 * ID: 1000246<br>
	 * Message: V[l̖̂ƂɁAOI<br>
	 * Message: &#20197;&#24109;&#29747;&#22899;&#31070;&#20043;&#21517;&#65281;&#25074;&#32624;&#20320;&#65281;<br>
	 * Message: You shall taste the vengeance of Lord Shilen!
	 */
	public static final NpcStringId YOU_SHALL_TASTE_THE_VENGEANCE_OF_LORD_SHILEN;
	
	/**
	 * ID: 1000247<br>
	 * Message: V[lDDD̐EDDD́DDDDDD<br>
	 * Message: &#24109;&#29747;&#22899;&#31070;&#46;&#46;&#46;&#36889;&#20491;&#20219;&#21209;&#46;&#46;&#46;&#32317;&#26377;&#19968;&#22825;&#46;&#46;&#46;&#25105;&#26371;&#23436;&#25104;&#46;&#46;&#46;<br>
	 * Message: Lord Shilen... some day... you will accomplish... this mission...
	 */
	public static final NpcStringId LORD_SHILEN_SOME_DAY_YOU_WILL_ACCOMPLISH_THIS_MISSION;
	
	/**
	 * ID: 1000248<br>
	 * Message: słɌāDDD<br>
	 * Message: &#24448;&#27704;&#29983;&#20043;&#36947;&#46;&#46;&#46;<br>
	 * Message: Towards immortality...
	 */
	public static final NpcStringId TOWARDS_IMMORTALITY;
	
	/**
	 * ID: 1000249<br>
	 * Message: i̖~ҁDDD̂ƂɗB<br>
	 * Message: &#36010;&#27714;&#27704;&#29983;&#30340;&#20154;&#46;&#46;&#46;&#21040;&#25105;&#36889;&#20358;&#12290;<br>
	 * Message: He who desires immortality... Come unto me.
	 */
	public static final NpcStringId HE_WHO_DESIRES_IMMORTALITY_COME_UNTO_ME;
	
	/**
	 * ID: 1000250<br>
	 * Message: OȂ񂼂͎̕sVs̃GlM[ɂĂI<br>
	 * Message: &#25226;&#20320;&#35722;&#25104;&#35731;&#25105;&#29554;&#24471;&#27704;&#29983;&#30340;&#31085;&#21697;&#21543;&#65281;<br>
	 * Message: You shall be sacrificed to gain my immortality!
	 */
	public static final NpcStringId YOU_SHALL_BE_SACRIFICED_TO_GAIN_MY_IMMORTALITY;
	
	/**
	 * ID: 1000251<br>
	 * Message: ŉi̖ɓƂ낾̂ɁDDDȂӂəRʂȂāDDD<br>
	 * Message: &#24555;&#35201;&#29554;&#24471;&#27704;&#29983;&#30340;&#25105;&#8230;&#31455;&#28982;&#36889;&#27171;&#34395;&#28961;&#30340;&#34987;&#25171;&#25943;&#46;&#46;&#46;<br>
	 * Message: Eternal life in front of my eyes... I have collapsed in such a worthless way like this...
	 */
	public static final NpcStringId ETERNAL_LIFE_IN_FRONT_OF_MY_EYES_I_HAVE_COLLAPSED_IN_SUCH_A_WORTHLESS_WAY_LIKE_THIS;
	
	/**
	 * ID: 1000252<br>
	 * Message: UPAȂĔڋȂI<br>
	 * Message: &#26413;&#32943;&#65292;&#20320;&#36889;&#21329;&#37145;&#20642;&#20249;&#65281;<br>
	 * Message: Zaken, you are a cowardly cur!
	 */
	public static final NpcStringId ZAKEN_YOU_ARE_A_COWARDLY_CUR;
	
	/**
	 * ID: 1000253<br>
	 * Message: UPAO͉i̖ɂĂȂ̂I<br>
	 * Message: &#26413;&#32943;&#65292;&#20320;&#19981;&#26159;&#24050;&#24471;&#21040;&#27704;&#29983;&#21966;&#65311;&#65281;<br>
	 * Message: You are immortal, aren't you, Zaken?
	 */
	public static final NpcStringId YOU_ARE_IMMORTAL_ARENT_YOU_ZAKEN;
	
	/**
	 * ID: 1000254<br>
	 * Message: ́DDD̐ĝԂĂDDD<br>
	 * Message: &#25308;&#35351;&#46;&#46;&#46;&#25226;&#25105;&#30340;&#36523;&#23376;&#36996;&#32102;&#25105;&#12290;<br>
	 * Message: Please return my body to me.
	 */
	public static final NpcStringId PLEASE_RETURN_MY_BODY_TO_ME;
	
	/**
	 * ID: 1000255<br>
	 * Message: AłDDD炩ɖƂƂȂ̂DDD<br>
	 * Message: &#29694;&#22312;&#46;&#46;&#46;&#25105;&#32066;&#26044;&#21487;&#20197;&#20241;&#24687;&#20102;&#21543;&#46;&#46;&#46;<br>
	 * Message: Finally... will I be able to rest?
	 */
	public static final NpcStringId FINALLY_WILL_I_BE_ABLE_TO_REST;
	
	/**
	 * ID: 1000256<br>
	 * Message: ȂȂɑX̂łB<br>
	 * Message: &#24590;&#40636;&#36889;&#40636;&#21557;&#21602;&#65311;<br>
	 * Message: What is all that racket?
	 */
	public static final NpcStringId WHAT_IS_ALL_THAT_RACKET;
	
	/**
	 * ID: 1000257<br>
	 * Message: Lhl͑ƂłB<br>
	 * Message: &#21513;&#29246;&#26421;&#19981;&#21916;&#27489;&#21927;&#22057;&#12290;<br>
	 * Message: Master Gildor does not like to be disturbed.
	 */
	public static final NpcStringId MASTER_GILDOR_DOES_NOT_LIKE_TO_BE_DISTURBED;
	
	/**
	 * ID: 1000258<br>
	 * Message: ÂɂĂ炢̂łDDD<br>
	 * Message: &#20320;&#20497;&#31245;&#24494;&#23433;&#38748;&#19968;&#19979;&#23601;&#22909;&#20102;&#46;&#46;&#46;<br>
	 * Message: Please, just hold it down...
	 */
	public static final NpcStringId PLEASE_JUST_HOLD_IT_DOWN;
	
	/**
	 * ID: 1000259<br>
	 * Message: Lhl{ɂȂĂ͂m܂B<br>
	 * Message: &#22914;&#26524;&#21513;&#29246;&#26421;&#29983;&#27683;&#20102;&#65292;&#25105;&#21487;&#19981;&#31649;&#22217;&#12290;<br>
	 * Message: If you disturb Master Gildor I won't be able to help you.
	 */
	public static final NpcStringId IF_YOU_DISTURB_MASTER_GILDOR_I_WONT_BE_ABLE_TO_HELP_YOU;
	
	/**
	 * ID: 1000260<br>
	 * Message: ǂ̂ǂƂ񂾁H<br>
	 * Message: &#21040;&#24213;&#26159;&#21738;&#20491;&#20642;&#20249;&#22312;&#38468;&#36817;&#65311;<br>
	 * Message: Who dares approach?
	 */
	public static final NpcStringId WHO_DARES_APPROACH;
	
	/**
	 * ID: 1000261<br>
	 * Message: ͎̗̑̒nDDD<br>
	 * Message: &#36889;&#34310;&#33894;&#33609;&#22320;&#26159;&#25105;&#30340;&#38936;&#22320;&#46;&#46;&#46;<br>
	 * Message: These reeds are my territory...
	 */
	public static final NpcStringId THESE_REEDS_ARE_MY_TERRITORY;
	
	/**
	 * ID: 1000262<br>
	 * Message: ҂߁IڂɕĂI<br>
	 * Message: &#24858;&#31528;&#30340;&#20642;&#20249;&#65281;&#35731;&#20320;&#20497;&#30631;&#30631;&#25105;&#30340;&#21426;&#23475;&#65281;<br>
	 * Message: You fools! Today you shall learn a lesson!
	 */
	public static final NpcStringId YOU_FOOLS_TODAY_YOU_SHALL_LEARN_A_LESSON;
	
	/**
	 * ID: 1000263<br>
	 * Message: Â悫͋āDDDVオĴDDD<br>
	 * Message: &#36942;&#21435;&#30340;&#26178;&#20195;&#24050;&#27969;&#36893;&#8230;&#26032;&#30340;&#26178;&#20195;&#35201;&#20358;&#33256;&#20102;&#21966;&#8230;<br>
	 * Message: The past goes by... Is a new era beginning?...
	 */
	public static final NpcStringId THE_PAST_GOES_BY_IS_A_NEW_ERA_BEGINNING;
	
	/**
	 * ID: 1000264<br>
	 * Message: ̓G@l̒뉀łB<br>
	 * Message: &#36889;&#35041;&#26159;&#20234;&#23043;&#22899;&#31070;&#30340;&#24237;&#38498;&#12290;<br>
	 * Message: This is the garden of Eva.
	 */
	public static final NpcStringId THIS_IS_THE_GARDEN_OF_EVA;
	
	/**
	 * ID: 1000265<br>
	 * Message: G@l̒뉀͐ȂꏊłB<br>
	 * Message: &#20234;&#23043;&#22899;&#31070;&#30340;&#24237;&#38498;&#26159;&#24456;&#31070;&#32854;&#30340;&#22320;&#26041;&#12290;<br>
	 * Message: The garden of Eva is a sacred place.
	 */
	public static final NpcStringId THE_GARDEN_OF_EVA_IS_A_SACRED_PLACE;
	
	/**
	 * ID: 1000266<br>
	 * Message: G@l`̂łB<br>
	 * Message: &#20320;&#26159;&#22312;&#20398;&#36785;&#20234;&#23043;&#22899;&#31070;&#21966;&#65311;<br>
	 * Message: Do you mean to insult Eva?
	 */
	public static final NpcStringId DO_YOU_MEAN_TO_INSULT_EVA;
	
	/**
	 * ID: 1000267<br>
	 * Message: ȖȂȂłDDDG@l͈ŕłł傤DDD<br>
	 * Message: &#23601;&#36899;&#20320;&#36889;&#27171;&#28961;&#31150;&#30340;&#20154;&#46;&#46;&#46;&#20234;&#23043;&#22899;&#31070;&#37117;&#26371;&#20197;&#24859;&#46;&#46;&#46;&#34962;&#35703;&#30340;&#12290;<br>
	 * Message: How rude! Eva's love is available to all, even to an ill-mannered lout like yourself!
	 */
	public static final NpcStringId HOW_RUDE_EVAS_LOVE_IS_AVAILABLE_TO_ALL_EVEN_TO_AN_ILL_MANNERED_LOUT_LIKE_YOURSELF;
	
	/**
	 * ID: 1000268<br>
	 * Message: ͌XV[l̂̂B<br>
	 * Message: &#36889;&#35041;&#26412;&#20358;&#26159;&#23660;&#26044;&#24109;&#29747;&#22899;&#31070;&#30340;&#12290;<br>
	 * Message: This place once belonged to Lord Shilen.
	 */
	public static final NpcStringId THIS_PLACE_ONCE_BELONGED_TO_LORD_SHILEN;
	
	/**
	 * ID: 1000269<br>
	 * Message: {an̂BG@̐삽B<br>
	 * Message: &#25226;&#23470;&#27583;&#20132;&#20986;&#20358;&#65281;&#20234;&#23043;&#30340;&#31934;&#38728;&#21834;&#65281;<br>
	 * Message: Leave this palace to us, spirits of Eva.
	 */
	public static final NpcStringId LEAVE_THIS_PALACE_TO_US_SPIRITS_OF_EVA;
	
	/**
	 * ID: 1000270<br>
	 * Message: ȂX̎ז̂B<br>
	 * Message: &#28858;&#20160;&#40636;&#22952;&#31001;&#25105;&#20497;&#21602;&#65311;<br>
	 * Message: Why are you getting in our way?
	 */
	public static final NpcStringId WHY_ARE_YOU_GETTING_IN_OUR_WAY;
	
	/**
	 * ID: 1000271<br>
	 * Message: V[lDDDV[ĺDDD<br>
	 * Message: &#24109;&#29747;&#22899;&#31070;&#46;&#46;&#46;&#24109;&#29747;&#22899;&#31070;&#30340;&#46;&#46;&#46;<br>
	 * Message: Shilen... our Shilen!
	 */
	public static final NpcStringId SHILEN_OUR_SHILEN;
	
	/**
	 * ID: 1000272<br>
	 * Message: pvIlҁDDDočŝI<br>
	 * Message: &#25084;&#24597;&#27861;&#21033;&#26114;&#30340;&#20154;&#46;&#46;&#46;&#37117;&#38626;&#38283;&#36889;&#35041;&#65281;<br>
	 * Message: All who fear of Fafurion... Leave this place at once!
	 */
	public static final NpcStringId ALL_WHO_FEAR_OF_FAFURION_LEAVE_THIS_PLACE_AT_ONCE;
	
	/**
	 * ID: 1000273<br>
	 * Message: pvIl̖̂ƂɁAOYI<br>
	 * Message: &#20197;&#27861;&#21033;&#26114;&#20043;&#21517;&#65292;&#25074;&#32624;&#20320;&#20497;&#65281;<br>
	 * Message: You are being punished in the name of Fafurion!
	 */
	public static final NpcStringId YOU_ARE_BEING_PUNISHED_IN_THE_NAME_OF_FAFURION;
	
	/**
	 * ID: 1000274<br>
	 * Message: llDDD݂Ȃ킽DDD<br>
	 * Message: &#25105;&#30340;&#20027;&#20154;&#46;&#46;&#46;&#35531;&#24744;&#21407;&#35538;&#27794;&#20986;&#24687;&#30340;&#25105;&#46;&#46;&#46;<br>
	 * Message: Oh, master... please forgive your humble servant...
	 */
	public static final NpcStringId OH_MASTER_PLEASE_FORGIVE_YOUR_HUMBLE_SERVANT;
	
	/**
	 * ID: 1000275<br>
	 * Message: o債Aٍ̐N҂ǂI̗vǂ̎xz҂łAOX^tl̑Ă낤I<br>
	 * Message: &#35258;&#24735;&#21543;&#65281;&#20320;&#20497;&#36889;&#20123;&#30064;&#22283;&#30340;&#20405;&#30053;&#32773;&#65281;&#36889;&#20491;&#35201;&#22622;&#27704;&#36960;&#30340;&#32113;&#27835;&#32773;&#65292;&#25105;&#21476;&#26031;&#22612;&#22827;&#24050;&#33289;&#36215;&#21133;&#20358;&#65281;<br>
	 * Message: Prepare to die, foreign invaders! I am Gustav, the eternal ruler of this fortress and I have taken up my sword to repel thee!
	 */
	public static final NpcStringId PREPARE_TO_DIE_FOREIGN_INVADERS_I_AM_GUSTAV_THE_ETERNAL_RULER_OF_THIS_FORTRESS_AND_I_HAVE_TAKEN_UP_MY_SWORD_TO_REPEL_THEE;
	
	/**
	 * ID: 1000276<br>
	 * Message: ҂̉AAfɉhIšNAOX^tlɉhI<br>
	 * Message: &#36060;&#20104;&#29509;&#23376;&#29579;&#22283;&#20126;&#19969;&#20809;&#27054;&#65281;&#36060;&#20104;&#19981;&#27515;&#20043;&#21531;&#20027;&#21476;&#26031;&#36948;&#22827;&#20809;&#27054;&#65281;<br>
	 * Message: Glory to Aden, the Kingdom of the Lion! Glory to Sir Gustav, our immortal lord!
	 */
	public static final NpcStringId GLORY_TO_ADEN_THE_KINGDOM_OF_THE_LION_GLORY_TO_SIR_GUSTAV_OUR_IMMORTAL_LORD;
	
	/**
	 * ID: 1000277<br>
	 * Message: OX^t̐mA킦IN҂ɎI<br>
	 * Message: &#21476;&#26031;&#36948;&#22827;&#30340;&#25136;&#22763;&#20497;&#65292;&#25136;&#39717;&#21543;&#65281;&#35731;&#20405;&#30053;&#32773;&#20497;&#27515;&#20129;&#21543;&#65281;<br>
	 * Message: Soldiers of Gustav, go forth and destroy the invaders!
	 */
	public static final NpcStringId SOLDIERS_OF_GUSTAV_GO_FORTH_AND_DESTROY_THE_INVADERS;
	
	/**
	 * ID: 1000278<br>
	 * Message: Ȃ͂́DDDꂪAskƂ̂Ȃ̂BAK߂IO̎炢ɂȁI<br>
	 * Message: &#22825;&#21834;&#46;&#46;&#46;&#31455;&#28982;&#34987;&#25171;&#25943;&#20102;&#21966;&#65311;&#20294;&#25105;&#19968;&#23450;&#26371;&#20877;&#22238;&#20358;&#65281;&#22238;&#20358;&#25343;&#19979;&#20320;&#20497;&#30340;&#38957;&#39025;&#65281;<br>
	 * Message: This is unbelievable! Have I really been defeated? I shall return and take your head!
	 */
	public static final NpcStringId THIS_IS_UNBELIEVABLE_HAVE_I_REALLY_BEEN_DEFEATED_I_SHALL_RETURN_AND_TAKE_YOUR_HEAD;
	
	/**
	 * ID: 1000279<br>
	 * Message: ꂪ̌EȂ̂DDDAOX^tl̋ȂĂ͎˂̂I<br>
	 * Message: &#38627;&#36947;&#36889;&#23601;&#26159;&#25105;&#30340;&#30028;&#38480;&#21966;&#46;&#46;&#46;&#20294;&#26159;&#27794;&#26377;&#21476;&#26031;&#36948;&#22827;&#30340;&#35377;&#21487;&#65292;&#25105;&#27770;&#19981;&#33021;&#20498;&#19979;&#65281;<br>
	 * Message: Could it be that I have reached my end? I cannot die without honor, without the permission of Sir Gustav!
	 */
	public static final NpcStringId COULD_IT_BE_THAT_I_HAVE_REACHED_MY_END_I_CANNOT_DIE_WITHOUT_HONOR_WITHOUT_THE_PERMISSION_OF_SIR_GUSTAV;
	
	/**
	 * ID: 1000280<br>
	 * Message: ܂Ăєsk̐J߂𖡂키̂DDDAߌ͂ł͏IDDD<br>
	 * Message: &#38627;&#36947;&#35201;&#20877;&#27425;&#22160;&#21040;&#22833;&#25943;&#30340;&#24677;&#36785;&#21966;&#46;&#46;&#46;&#20294;&#24754;&#21127;&#36996;&#27794;&#32080;&#26463;&#46;&#46;&#46;<br>
	 * Message: Ah, the bitter taste of defeat... I fear my torments are not over...
	 */
	public static final NpcStringId AH_THE_BITTER_TASTE_OF_DEFEAT_I_FEAR_MY_TORMENTS_ARE_NOT_OVER;
	
	/**
	 * ID: 1000281<br>
	 * Message: ̓pvIl̈ӎuɏ]ҁI<br>
	 * Message: &#25105;&#26159;&#22519;&#34892;&#27861;&#21033;&#26114;&#24847;&#24535;&#30340;&#20154;&#65281;<br>
	 * Message: I follow the will of Fafurion.
	 */
	public static final NpcStringId I_FOLLOW_THE_WILL_OF_FAFURION;
	
	/**
	 * ID: 1000282<br>
	 * Message: K^̕󂭂̔̔s܂I<br>
	 * Message: &#38283;&#22987;&#36009;&#36067;&#24184;&#36939;&#24425;&#31080;&#33;&#33;&#33;<br>
	 * Message: Tickets for the Lucky Lottery are now on sale!
	 */
	public static final NpcStringId TICKETS_FOR_THE_LUCKY_LOTTERY_ARE_NOW_ON_SALE;
	
	/**
	 * ID: 1000283<br>
	 * Message: K^̕󂭂̒Is܂I<br>
	 * Message: &#38283;&#22987;&#38283;&#29518;&#24184;&#36939;&#24425;&#31080;&#33;&#33;&#33;<br>
	 * Message: The Lucky Lottery drawing is about to begin!
	 */
	public static final NpcStringId THE_LUCKY_LOTTERY_DRAWING_IS_ABOUT_TO_BEGIN;
	
	/**
	 * ID: 1000284<br>
	 * Message: ߂łƂ܂I$s1̓Iԍ$s2łB<br>
	 * Message: &#36889;&#27425;&#31532;&#12300;&#36;&#115;&#49;&#12301;&#22238;&#20013;&#29518;&#34399;&#30908;&#26159;&#12300;&#36;&#115;&#50;&#12301;&#12290;&#24685;&#21916;&#20013;&#29518;&#65281;<br>
	 * Message: The winning numbers for Lucky Lottery $s1 are $s2. Congratulations to the winners!
	 */
	public static final NpcStringId THE_WINNING_NUMBERS_FOR_LUCKY_LOTTERY_S1_ARE_S2_CONGRATULATIONS_TO_THE_WINNERS;
	
	/**
	 * ID: 1000285<br>
	 * Message: Nɂĕ󂭂𔃂Ƃł܂B<br>
	 * Message: &#22240;&#38480;&#21046;&#24180;&#40801;&#32;&#28961;&#27861;&#36092;&#36023;&#24425;&#31080;&#12290;<br>
	 * Message: You're too young to play Lucky Lottery!
	 */
	public static final NpcStringId YOURE_TOO_YOUNG_TO_PLAY_LUCKY_LOTTERY;
	
	/**
	 * ID: 1000286<br>
	 * Message: $s1IwɋC񂾂ȁI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#23567;&#24515;&#32972;&#24460;&#65281;&#65281;&#65281;<br>
	 * Message: $s1! Watch your back!!!
	 */
	public static final NpcStringId S1_WATCH_YOUR_BACK;
	
	/**
	 * ID: 1000287<br>
	 * Message: $s1IݔqƂI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#20358;&#65292;&#36319;&#25105;&#21934;&#25361;&#65281;<br>
	 * Message: $s1! Come on, I'll take you on!
	 */
	public static final NpcStringId S1_COME_ON_ILL_TAKE_YOU_ON;
	
	/**
	 * ID: 1000288<br>
	 * Message: $s1IזƂ͂IA݂ĂI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#31455;&#25954;&#22952;&#31001;&#25105;&#20497;&#27604;&#27494;&#65281;&#22823;&#23478;&#24171;&#24171;&#25105;&#65281;<br>
	 * Message: $s1! How dare you interrupt our fight! Hey guys, help!
	 */
	public static final NpcStringId S1_HOW_DARE_YOU_INTERRUPT_OUR_FIGHT_HEY_GUYS_HELP;
	
	/**
	 * ID: 1000289<br>
	 * Message: ݂͂Iڋ҂͋I<br>
	 * Message: &#25105;&#20358;&#24171;&#20320;&#65281;&#25105;&#20497;&#26368;&#35342;&#21421;&#21329;&#37145;&#20102;&#65281;&#65281;&#65281;<br>
	 * Message: I'll help you! I'm no coward!
	 */
	public static final NpcStringId ILL_HELP_YOU_IM_NO_COWARD;
	
	/**
	 * ID: 1000290<br>
	 * Message: ɂ̗͂I<br>
	 * Message: &#31350;&#26997;&#21147;&#37327;&#21834;&#65281;&#65281;&#65281;&#65281;<br>
	 * Message: Dear ultimate power!!!
	 */
	public static final NpcStringId DEAR_ULTIMATE_POWER;
	
	/**
	 * ID: 1000291<br>
	 * Message: S $s1 ɏWUI<br>
	 * Message: &#25152;&#26377;&#20154;&#23565;&#12300;&#36;&#115;&#49;&#12301;&#38598;&#20013;&#25915;&#25802;&#65281;<br>
	 * Message: Everybody! Attack $s1!
	 */
	public static final NpcStringId EVERYBODY_ATTACK_S1;
	
	/**
	 * ID: 1000292<br>
	 * Message: ߂ɏ]܂B<br>
	 * Message: &#36981;&#21629;&#12290;<br>
	 * Message: I will follow your order.
	 */
	public static final NpcStringId I_WILL_FOLLOW_YOUR_ORDER;
	
	/**
	 * ID: 1000293<br>
	 * Message: ͒mȂ낤I<br>
	 * Message: &#36889;&#20491;&#20320;&#23601;&#19981;&#30693;&#36947;&#20102;&#21543;&#65281;<br>
	 * Message: Bet you didn't expect this!
	 */
	public static final NpcStringId BET_YOU_DIDNT_EXPECT_THIS;
	
	/**
	 * ID: 1000294<br>
	 * Message: ołIł̎҂ǂI<br>
	 * Message: &#20986;&#20358;&#65281;&#40657;&#26263;&#30340;&#23401;&#23376;&#20497;&#65281;<br>
	 * Message: Come out, you children of darkness!
	 */
	public static final NpcStringId COME_OUT_YOU_CHILDREN_OF_DARKNESS;
	
	/**
	 * ID: 1000295<br>
	 * Message: p[eB o[I<br>
	 * Message: &#21484;&#21914;&#25105;&#30340;&#25136;&#21451;&#20497;&#21834;&#65281;<br>
	 * Message: Summon party members!
	 */
	public static final NpcStringId SUMMON_PARTY_MEMBERS;
	
	/**
	 * ID: 1000296<br>
	 * Message: llIĂтł傤B<br>
	 * Message: &#20027;&#20154;&#65281;&#24744;&#25214;&#25105;&#21966;&#65311;<br>
	 * Message: Master! Did you call me?
	 */
	public static final NpcStringId MASTER_DID_YOU_CALL_ME;
	
	/**
	 * ID: 1000297<br>
	 * Message: ҂߁I<br>
	 * Message: &#24858;&#31528;&#30340;&#20642;&#20249;&#65281;<br>
	 * Message: You idiot!
	 */
	public static final NpcStringId YOU_IDIOT;
	
	/**
	 * ID: 1000298<br>
	 * Message: ͂ǂI<br>
	 * Message: &#36889;&#25307;&#22914;&#20309;&#65281;<br>
	 * Message: What about this?
	 */
	public static final NpcStringId WHAT_ABOUT_THIS;
	
	/**
	 * ID: 1000299<br>
	 * Message:  $s1IōŌゾI<br>
	 * Message: &#22909;&#21426;&#23475;&#65292;&#12300;&#36;&#115;&#49;&#12301;&#65281;&#36889;&#26159;&#26368;&#24460;&#19968;&#27425;&#65281;<br>
	 * Message: Very impressive $s1! This is the last!
	 */
	public static final NpcStringId VERY_IMPRESSIVE_S1_THIS_IS_THE_LAST;
	
	/**
	 * ID: 1000300<br>
	 * Message: t<br>
	 * Message: &#40654;&#26126;<br>
	 * Message: Dawn
	 */
	public static final NpcStringId DAWN;
	
	/**
	 * ID: 1000301<br>
	 * Message: <br>
	 * Message: &#40643;&#26127;<br>
	 * Message: Dusk
	 */
	public static final NpcStringId DUSK;
	
	/**
	 * ID: 1000302<br>
	 * Message: Ȃ<br>
	 * Message: &#28961;<br>
	 * Message: Nothingness
	 */
	public static final NpcStringId NOTHINGNESS;
	
	/**
	 * ID: 1000303<br>
	 * Message: ܂Ȃ͖̐łтł낤I<br>
	 * Message: &#36889;&#20491;&#19990;&#30028;&#21363;&#23559;&#28357;&#20129;&#65281;<br>
	 * Message: This world will soon be annihilated!
	 */
	public static final NpcStringId THIS_WORLD_WILL_SOON_BE_ANNIHILATED;
	
	/**
	 * ID: 1000304<br>
	 * Message: ȂɎ􂢂Ă낤I<br>
	 * Message: &#35419;&#21650;&#20320;&#65281;<br>
	 * Message: A curse upon you!
	 */
	public static final NpcStringId A_CURSE_UPON_YOU;
	
	/**
	 * ID: 1000305<br>
	 * Message: ق̓߂ÂĂI<br>
	 * Message: &#23529;&#21028;&#30340;&#26085;&#23376;&#21363;&#23559;&#20358;&#33256;&#65281;<br>
	 * Message: The day of judgment is near!
	 */
	public static final NpcStringId THE_DAY_OF_JUDGMENT_IS_NEAR;
	
	/**
	 * ID: 1000306<br>
	 * Message: ȂɏjI<br>
	 * Message: &#31069;&#31119;&#20320;&#65281;<br>
	 * Message: I bestow upon you a blessing!
	 */
	public static final NpcStringId I_BESTOW_UPON_YOU_A_BLESSING;
	
	/**
	 * ID: 1000307<br>
	 * Message: アɓ|̂PJ̖@I<br>
	 * Message: &#20808;&#27578;&#24369;&#32773;&#65292;&#36889;&#23601;&#26159;&#25136;&#39717;&#20043;&#36947;&#65281;<br>
	 * Message: The first rule of fighting is to start by killing the weak ones!
	 */
	public static final NpcStringId THE_FIRST_RULE_OF_FIGHTING_IS_TO_START_BY_KILLING_THE_WEAK_ONES;
	
	/**
	 * ID: 1000308<br>
	 * Message: Afi<br>
	 * Message: &#37329;&#24163;<br>
	 * Message: Adena
	 */
	public static final NpcStringId ADENA;
	
	/**
	 * ID: 1000309<br>
	 * Message: Ñ̃Afi<br>
	 * Message: &#21476;&#20195;&#30340;&#37329;&#24163;<br>
	 * Message: Ancient Adena
	 */
	public static final NpcStringId ANCIENT_ADENA;
	
	/**
	 * ID: 1000312<br>
	 * Message: x32<br>
	 * Message: &#26410;&#28415;&#51;&#50;&#32026;<br>
	 * Message: Level 31 or lower
	 */
	public static final NpcStringId LEVEL_31_OR_LOWER;
	
	/**
	 * ID: 1000313<br>
	 * Message: x43<br>
	 * Message: &#26410;&#28415;&#52;&#51;&#32026;<br>
	 * Message: Level 42 or lower
	 */
	public static final NpcStringId LEVEL_42_OR_LOWER;
	
	/**
	 * ID: 1000314<br>
	 * Message: x54<br>
	 * Message: &#26410;&#28415;&#53;&#52;&#32026;<br>
	 * Message: Level 53 or lower
	 */
	public static final NpcStringId LEVEL_53_OR_LOWER;
	
	/**
	 * ID: 1000315<br>
	 * Message: x65<br>
	 * Message: &#26410;&#28415;&#54;&#53;&#32026;<br>
	 * Message: Level 64 or lower
	 */
	public static final NpcStringId LEVEL_64_OR_LOWER;
	
	/**
	 * ID: 1000316<br>
	 * Message: <br>
	 * Message: &#28961;&#38480;&#21046;<br>
	 * Message: No Level Limit
	 */
	public static final NpcStringId NO_LEVEL_LIMIT;
	
	/**
	 * ID: 1000317<br>
	 * Message: 2Ɉł̍ՓTn܂܂BtsĂB<br>
	 * Message: &#50;&#20998;&#37912;&#24460;&#38283;&#22987;&#33289;&#34892;&#40657;&#26263;&#30340;&#31085;&#20856;&#12290;&#35531;&#36404;&#36493;&#21443;&#21152;&#12290;<br>
	 * Message: The main event will start in 2 minutes. Please register now.
	 */
	public static final NpcStringId THE_MAIN_EVENT_WILL_START_IN_2_MINUTES_PLEASE_REGISTER_NOW;
	
	/**
	 * ID: 1000318<br>
	 * Message: ł̍ՓTn߂܂B<br>
	 * Message: &#40657;&#26263;&#30340;&#31085;&#20856;&#27491;&#24335;&#38283;&#22987;&#12290;<br>
	 * Message: The main event is now starting.
	 */
	public static final NpcStringId THE_MAIN_EVENT_IS_NOW_STARTING;
	
	/**
	 * ID: 1000319<br>
	 * Message: 5Ɉł̍ՓTI܂B<br>
	 * Message: &#53;&#20998;&#37912;&#24460;&#40657;&#26263;&#30340;&#31085;&#20856;&#23559;&#35201;&#32080;&#26463;&#12290;<br>
	 * Message: The main event will close in 5 minutes.
	 */
	public static final NpcStringId THE_MAIN_EVENT_WILL_CLOSE_IN_5_MINUTES;
	
	/**
	 * ID: 1000320<br>
	 * Message: 2Ɉł̍ՓTI܂B̃Q[̏ĂB<br>
	 * Message: &#50;&#20998;&#37912;&#24460;&#40657;&#26263;&#30340;&#31085;&#20856;&#23559;&#35201;&#32080;&#26463;&#12290;&#35531;&#28310;&#20633;&#19979;&#22238;&#21512;&#30340;&#25361;&#25136;&#12290;<br>
	 * Message: The main event will finish in 2 minutes. Please prepare for the next game.
	 */
	public static final NpcStringId THE_MAIN_EVENT_WILL_FINISH_IN_2_MINUTES_PLEASE_PREPARE_FOR_THE_NEXT_GAME;
	
	/**
	 * ID: 1000321<br>
	 * Message: SSQ vx $s1 オ܂B<br>
	 * Message: &#19971;&#23553;&#21360;&#36002;&#29563;&#24230;&#25552;&#21319;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: The amount of SSQ contribution has increased by $s1.
	 */
	public static final NpcStringId THE_AMOUNT_OF_SSQ_CONTRIBUTION_HAS_INCREASED_BY_S1;
	
	/**
	 * ID: 1000322<br>
	 * Message: L^Ȃ<br>
	 * Message: &#27794;&#26377;&#35352;&#37636;<br>
	 * Message: No record exists
	 */
	public static final NpcStringId NO_RECORD_EXISTS;
	
	/**
	 * ID: 1000380<br>
	 * Message: \ȂтIOɑĂ낤B<br>
	 * Message: &#31085;&#29289;&#24456;&#20805;&#36275;&#65281;&#65281;&#25105;&#23559;&#31435;&#21051;&#25226;&#20320;&#31227;&#21205;&#21040;&#22806;&#38754;&#65281;<br>
	 * Message: That will do! I'll move you to the outside soon.
	 */
	public static final NpcStringId THAT_WILL_DO_ILL_MOVE_YOU_TO_THE_OUTSIDE_SOON;
	
	/**
	 * ID: 1000382<br>
	 * Message: 낪XL炯ȁI<br>
	 * Message: &#24460;&#38754;&#30772;&#32187;&#22826;&#22810;&#33;<br>
	 * Message: Your rear is practically unguarded!
	 */
	public static final NpcStringId YOUR_REAR_IS_PRACTICALLY_UNGUARDED;
	
	/**
	 * ID: 1000383<br>
	 * Message: wƂ́IĂ̂I<br>
	 * Message: &#31455;&#25954;&#36899;&#29702;&#37117;&#19981;&#29702;&#33;&#30631;&#19981;&#36215;&#26159;&#21966;&#65311;<br>
	 * Message: How dare you turn your back on me!
	 */
	public static final NpcStringId HOW_DARE_YOU_TURN_YOUR_BACK_ON_ME;
	
	/**
	 * ID: 1000384<br>
	 * Message: $s1IΈŏI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#20358;&#21934;&#25361;&#21834;&#65281;<br>
	 * Message: $s1! I'll deal with you myself!
	 */
	public static final NpcStringId S1_ILL_DEAL_WITH_YOU_MYSELF;
	
	/**
	 * ID: 1000385<br>
	 * Message: $s1IΌI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#20358;&#27604;&#27494;&#21543;&#65281;<br>
	 * Message: $s1! This is personal!
	 */
	public static final NpcStringId S1_THIS_IS_PERSONAL;
	
	/**
	 * ID: 1000386<br>
	 * Message: $s1IINזȁI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#27770;&#39717;&#21543;&#65281;&#35504;&#20063;&#19981;&#20934;&#20358;&#22952;&#31001;&#65281;<br>
	 * Message: $s1! Leave us alone! This is between us!
	 */
	public static final NpcStringId S1_LEAVE_US_ALONE_THIS_IS_BETWEEN_US;
	
	/**
	 * ID: 1000387<br>
	 * Message: $s1IO̖͎炤I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#20320;&#30340;&#21629;&#25105;&#25910;&#19979;&#21862;&#65281;<br>
	 * Message: $s1! Killing you will be a pleasure!
	 */
	public static final NpcStringId S1_KILLING_YOU_WILL_BE_A_PLEASURE;
	
	/**
	 * ID: 1000388<br>
	 * Message: $s1I悭ΌWQĂꂽȁI҂߁I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#31455;&#25954;&#22952;&#31001;&#25105;&#20497;&#27604;&#27494;&#65281;&#21508;&#20301;&#65281;<br>
	 * Message: $s1! Hey! We're having a duel here!
	 */
	public static final NpcStringId S1_HEY_WERE_HAVING_A_DUEL_HERE;
	
	/**
	 * ID: 1000389<br>
	 * Message: Έ̑Ό͏I肾IF̎ҁAĂ܂I<br>
	 * Message: &#27604;&#27494;&#32080;&#26463;&#20102;&#33;&#22823;&#23478;&#36914;&#25915;&#33;<br>
	 * Message: The duel is over! Attack!
	 */
	public static final NpcStringId THE_DUEL_IS_OVER_ATTACK;
	
	/**
	 * ID: 1000390<br>
	 * Message: IF̎ҁAڋ҂nI<br>
	 * Message: &#29359;&#35215;&#33;&#22823;&#23478;&#24555;&#32102;&#25105;&#34389;&#27770;&#21329;&#21155;&#32773;&#33;<br>
	 * Message: Foul! Kill the coward!
	 */
	public static final NpcStringId FOUL_KILL_THE_COWARD;
	
	/**
	 * ID: 1000391<br>
	 * Message: _ȌWQƂ́Ił͂ȂI<br>
	 * Message: &#31455;&#25954;&#22952;&#31001;&#31070;&#32854;&#30340;&#27770;&#39717;&#33;&#32085;&#23565;&#39250;&#19981;&#20102;&#20320;&#20497;&#33;<br>
	 * Message: How dare you interrupt a sacred duel! You must be taught a lesson!
	 */
	public static final NpcStringId HOW_DARE_YOU_INTERRUPT_A_SACRED_DUEL_YOU_MUST_BE_TAUGHT_A_LESSON;
	
	/**
	 * ID: 1000392<br>
	 * Message: ڋҁII<br>
	 * Message: &#21329;&#21155;&#32773;&#33;&#21435;&#27515;&#21543;&#33;<br>
	 * Message: Die, you coward!
	 */
	public static final NpcStringId DIE_YOU_COWARD;
	
	/**
	 * ID: 1000394<br>
	 * Message: ڋ҂ɎI<br>
	 * Message: &#23559;&#21329;&#21155;&#32773;&#34389;&#27515;&#21543;&#33;<br>
	 * Message: Kill the coward!
	 */
	public static final NpcStringId KILL_THE_COWARD;
	
	/**
	 * ID: 1000395<br>
	 * Message: ˂𑊎ɂ̃XLgƂ́I<br>
	 * Message: &#27794;&#24819;&#21040;&#31455;&#26371;&#23565;&#20083;&#33261;&#26410;&#20094;&#30340;&#23567;&#23376;&#20351;&#29992;&#36889;&#25307;&#33;<br>
	 * Message: I never thought I'd use this against a novice!
	 */
	public static final NpcStringId I_NEVER_THOUGHT_ID_USE_THIS_AGAINST_A_NOVICE;
	
	/**
	 * ID: 1000396<br>
	 * Message: ܂܂ɂ͏Ă񂼁I<br>
	 * Message: &#24819;&#36111;&#25105;&#65292;&#36996;&#26089;&#30340;&#24456;&#21602;&#33;<br>
	 * Message: You won't take me down easily.
	 */
	public static final NpcStringId YOU_WONT_TAKE_ME_DOWN_EASILY;
	
	/**
	 * ID: 1000397<br>
	 * Message: ꂩ炪{̐킢I<br>
	 * Message: &#29694;&#22312;&#38283;&#22987;&#25165;&#26159;&#30495;&#27491;&#30340;&#27770;&#39717;&#33;<br>
	 * Message: The battle has just begun!
	 */
	public static final NpcStringId THE_BATTLE_HAS_JUST_BEGUN;
	
	/**
	 * ID: 1000398<br>
	 * Message: $s1|I<br>
	 * Message: &#20808;&#23559;&#12300;&#36;&#115;&#49;&#12301;&#25802;&#20498;&#65281;<br>
	 * Message: Kill $s1 first!
	 */
	public static final NpcStringId KILL_S1_FIRST;
	
	/**
	 * ID: 1000399<br>
	 * Message: WUIڕW$s1I<br>
	 * Message: &#38598;&#20013;&#25915;&#25802;&#65281;&#30446;&#27161;&#26159;&#12300;&#36;&#115;&#49;&#12301;&#65281;<br>
	 * Message: Attack $s1!
	 */
	public static final NpcStringId ATTACK_S1;
	
	/**
	 * ID: 1000400<br>
	 * Message: UIUI<br>
	 * Message: &#25915;&#25802;&#33;&#25915;&#25802;&#33;<br>
	 * Message: Attack! Attack!
	 */
	public static final NpcStringId ATTACK_ATTACK;
	
	/**
	 * ID: 1000401<br>
	 * Message: WUJnI<br>
	 * Message: &#38283;&#22987;&#38598;&#20013;&#25915;&#25802;&#33;<br>
	 * Message: Over here!
	 */
	public static final NpcStringId OVER_HERE;
	
	/**
	 * ID: 1000402<br>
	 * Message: W[I<br>
	 * Message: &#25910;&#21040;&#33;&#33;&#33;&#33;<br>
	 * Message: Roger!
	 */
	public static final NpcStringId ROGER;
	
	/**
	 * ID: 1000403<br>
	 * Message: F̎ҁIoėI<br>
	 * Message: &#21508;&#20301;&#33;&#20986;&#20358;&#21543;&#33;<br>
	 * Message: Show yourselves!
	 */
	public static final NpcStringId SHOW_YOURSELVES;
	
	/**
	 * ID: 1000404<br>
	 * Message: ł̌RAɑI<br>
	 * Message: &#40657;&#26263;&#30340;&#36557;&#21218;&#21834;&#65292;&#36319;&#38568;&#25105;&#21543;&#33;<br>
	 * Message: Forces of darkness! Follow me!
	 */
	public static final NpcStringId FORCES_OF_DARKNESS_FOLLOW_ME;
	
	/**
	 * ID: 1000405<br>
	 * Message: Z킽AGrłI<br>
	 * Message: &#20804;&#24351;&#20497;&#21834;&#65292;&#28040;&#28357;&#25973;&#20154;&#21543;&#33;<br>
	 * Message: Destroy the enemy, my brothers!
	 */
	public static final NpcStringId DESTROY_THE_ENEMY_MY_BROTHERS;
	
	/**
	 * ID: 1000406<br>
	 * Message: ꂩ炪{ԂI<br>
	 * Message: &#29694;&#22312;&#25165;&#26159;&#30495;&#27491;&#30340;&#38283;&#22987;&#33;<br>
	 * Message: Now the fun starts!
	 */
	public static final NpcStringId NOW_THE_FUN_STARTS;
	
	/**
	 * ID: 1000407<br>
	 * Message: Â̂ԈႢI{CőĂ낤I<br>
	 * Message: &#25105;&#22826;&#23567;&#30475;&#20320;&#20497;&#20102;&#33;&#37027;&#40636;&#23601;&#35469;&#30495;&#22320;&#23565;&#20184;&#20320;&#20497;&#21543;&#33;<br>
	 * Message: Enough fooling around. Get ready to die!
	 */
	public static final NpcStringId ENOUGH_FOOLING_AROUND_GET_READY_TO_DIE;
	
	/**
	 * ID: 1000408<br>
	 * Message: ҂߂I܂Ŏ𔲂ĂI<br>
	 * Message: &#24858;&#34850;&#30340;&#20642;&#20249;&#33;&#21040;&#29694;&#22312;&#21482;&#19981;&#36942;&#26159;&#32244;&#32722;&#32780;&#24050;&#33;<br>
	 * Message: You idiot! I've just been toying with you!
	 */
	public static final NpcStringId YOU_IDIOT_IVE_JUST_BEEN_TOYING_WITH_YOU;
	
	/**
	 * ID: 1000409<br>
	 * Message: ̖{̗͂Ă낤I<br>
	 * Message: &#35731;&#20320;&#30631;&#30631;&#25105;&#30495;&#27491;&#30340;&#21147;&#37327;&#33;<br>
	 * Message: Witness my true power!
	 */
	public static final NpcStringId WITNESS_MY_TRUE_POWER;
	
	/**
	 * ID: 1000410<br>
	 * Message: {̐킢͂ꂩ炾I<br>
	 * Message: &#30495;&#27491;&#30340;&#27770;&#39717;&#29694;&#22312;&#25165;&#38283;&#22987;&#21602;&#33;<br>
	 * Message: Now the battle begins!
	 */
	public static final NpcStringId NOW_THE_BATTLE_BEGINS;
	
	/**
	 * ID: 1000411<br>
	 * Message: vԂɌ̑肾ȁI<br>
	 * Message: &#30495;&#26159;&#22909;&#20037;&#27794;&#26377;&#30896;&#21040;&#35731;&#25105;&#29105;&#34880;&#27832;&#39472;&#30340;&#23565;&#25163;&#33;<br>
	 * Message: I must admit, no one makes my blood boil quite like you do!
	 */
	public static final NpcStringId I_MUST_ADMIT_NO_ONE_MAKES_MY_BLOOD_BOIL_QUITE_LIKE_YOU_DO;
	
	/**
	 * ID: 1000412<br>
	 * Message: ͋I܂ŒǂނƂ́I<br>
	 * Message: &#30495;&#24847;&#22806;&#33;&#31455;&#33021;&#25226;&#25105;&#36924;&#21040;&#36889;&#22320;&#27493;&#33;<br>
	 * Message: You have more skill than I thought!
	 */
	public static final NpcStringId YOU_HAVE_MORE_SKILL_THAN_I_THOUGHT;
	
	/**
	 * ID: 1000413<br>
	 * Message: 200̐퓬͂ő肵Ă낤I<br>
	 * Message: &#35731;&#25105;&#29992;&#30334;&#20998;&#20043;&#20841;&#30334;&#30340;&#25136;&#39717;&#21147;&#20358;&#23565;&#20184;&#20320;&#33;<br>
	 * Message: I'll double my strength!
	 */
	public static final NpcStringId ILL_DOUBLE_MY_STRENGTH;
	
	/**
	 * ID: 1000414<br>
	 * Message: ꂪŌゾIIɂĂ邼I<br>
	 * Message: &#32066;&#26044;&#21040;&#20102;&#26368;&#24460;&#33;&#36865;&#20320;&#36212;&#40643;&#27849;&#21543;&#33;<br>
	 * Message: Prepare to die!
	 */
	public static final NpcStringId PREPARE_TO_DIE;
	
	/**
	 * ID: 1000415<br>
	 * Message: F̎ҁA߂݂ɕ邪悢IԂȂ̏_~Ղ̂I<br>
	 * Message: &#22823;&#23478;&#31561;&#33879;&#32085;&#26395;&#21543;&#33;&#27515;&#20129;&#22899;&#31070;&#21363;&#23559;&#35201;&#38477;&#33256;&#20102;&#33;<br>
	 * Message: All is lost! Prepare to meet the goddess of death!
	 */
	public static final NpcStringId ALL_IS_LOST_PREPARE_TO_MEET_THE_GODDESS_OF_DEATH;
	
	/**
	 * ID: 1000416<br>
	 * Message: F̎ҁA߂݂ɕ邪悢IԂȂŖS̗\ł낤I<br>
	 * Message: &#22823;&#23478;&#31561;&#33879;&#32085;&#26395;&#21543;&#33;&#28357;&#20129;&#30340;&#38928;&#35328;&#21363;&#23559;&#23601;&#35201;&#23526;&#29694;&#20102;&#33;<br>
	 * Message: All is lost! The prophecy of destruction has been fulfilled!
	 */
	public static final NpcStringId ALL_IS_LOST_THE_PROPHECY_OF_DESTRUCTION_HAS_BEEN_FULFILLED;
	
	/**
	 * ID: 1000417<br>
	 * Message: ŖS̗\ɎXIԂȂI̎オn܂̂I<br>
	 * Message: &#32838;&#32893;&#28357;&#20129;&#30340;&#38928;&#35328;&#21543;&#33;&#26411;&#26085;&#26178;&#20195;&#21363;&#23559;&#35201;&#20358;&#33256;&#20102;&#33;<br>
	 * Message: The end of time has come! The prophecy of destruction has been fulfilled!
	 */
	public static final NpcStringId THE_END_OF_TIME_HAS_COME_THE_PROPHECY_OF_DESTRUCTION_HAS_BEEN_FULFILLED;
	
	/**
	 * ID: 1000418<br>
	 * Message: $s1IȂɖŖS̒I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#24478;&#20320;&#36523;&#19978;&#21487;&#20197;&#30475;&#21040;&#28357;&#20129;&#30340;&#24501;&#20806;&#65281;<br>
	 * Message: $s1! You bring an ill wind!
	 */
	public static final NpcStringId S1_YOU_BRING_AN_ILL_WIND;
	
	/**
	 * ID: 1000419<br>
	 * Message: $s1IȂɐ]Ă낤I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#35731;&#20320;&#22160;&#22160;&#32085;&#26395;&#30340;&#24863;&#35258;&#65281;<br>
	 * Message: $s1! You might as well give up!
	 */
	public static final NpcStringId S1_YOU_MIGHT_AS_WELL_GIVE_UP;
	
	/**
	 * ID: 1000420<br>
	 * Message: I̎𐶂҂A]̕ɗI<br>
	 * Message: &#27963;&#22312;&#26411;&#26085;&#26178;&#20195;&#30340;&#20154;&#21834;&#65292;&#32085;&#26395;&#21543;&#33;<br>
	 * Message: You don't have any hope! Your end has come!
	 */
	public static final NpcStringId YOU_DONT_HAVE_ANY_HOPE_YOUR_END_HAS_COME;
	
	/**
	 * ID: 1000421<br>
	 * Message: ł̌[ɎXIł肩o߂̂I<br>
	 * Message: &#32838;&#32893;&#40657;&#26263;&#30340;&#21855;&#31034;&#21543;&#33;&#27785;&#30561;&#20013;&#30340;&#40657;&#26263;&#29990;&#37266;&#20102;&#33;<br>
	 * Message: The prophecy of darkness has been fulfilled!
	 */
	public static final NpcStringId THE_PROPHECY_OF_DARKNESS_HAS_BEEN_FULFILLED;
	
	/**
	 * ID: 1000422<br>
	 * Message: ł̌[ɎXIׂ̎オn܂̂I<br>
	 * Message: &#32838;&#32893;&#40657;&#26263;&#30340;&#21855;&#31034;&#21543;&#33;&#28222;&#27788;&#30340;&#26178;&#20195;&#24050;&#32147;&#38283;&#22987;&#20102;&#33;<br>
	 * Message: As foretold in the prophecy of darkness, the era of chaos has begun!
	 */
	public static final NpcStringId AS_FORETOLD_IN_THE_PROPHECY_OF_DARKNESS_THE_ERA_OF_CHAOS_HAS_BEGUN;
	
	/**
	 * ID: 1000423<br>
	 * Message: ł̌[ɎXIԂȂ̊yƂȂ邾낤I<br>
	 * Message: &#32838;&#32893;&#40657;&#26263;&#30340;&#21855;&#31034;&#21543;&#33;&#27515;&#20129;&#30340;&#27138;&#22290;&#21363;&#23559;&#20358;&#33256;&#20102;&#33;<br>
	 * Message: The prophecy of darkness has come to pass!
	 */
	public static final NpcStringId THE_PROPHECY_OF_DARKNESS_HAS_COME_TO_PASS;
	
	/**
	 * ID: 1000424<br>
	 * Message: $s1IȂɌ[̏j^悤I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#36060;&#32102;&#20320;&#21855;&#31034;&#30340;&#31069;&#31119;&#65281;<br>
	 * Message: $s1! I give you the blessing of prophecy!
	 */
	public static final NpcStringId S1_I_GIVE_YOU_THE_BLESSING_OF_PROPHECY;
	
	/**
	 * ID: 1000425<br>
	 * Message: $s1IȂɐ[̌\^悤I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#36060;&#32102;&#20320;&#28145;&#28149;&#30340;&#27402;&#33021;&#65281;<br>
	 * Message: $s1! I bestow upon you the authority of the abyss!
	 */
	public static final NpcStringId S1_I_BESTOW_UPON_YOU_THE_AUTHORITY_OF_THE_ABYSS;
	
	/**
	 * ID: 1000426<br>
	 * Message: VJ҂Aڂo܂I<br>
	 * Message: &#38283;&#21855;&#26032;&#26178;&#20195;&#30340;&#20154;&#21834;&#65292;&#29990;&#37266;&#21543;&#33;<br>
	 * Message: Herald of the new era, open your eyes!
	 */
	public static final NpcStringId HERALD_OF_THE_NEW_ERA_OPEN_YOUR_EYES;
	
	/**
	 * ID: 1000427<br>
	 * Message: ア҂|̂킢̖@I<br>
	 * Message: &#20808;&#27578;&#24369;&#32773;&#26159;&#25136;&#39717;&#30340;&#27861;&#21063;&#33;<br>
	 * Message: Remember, kill the weaklings first!
	 */
	public static final NpcStringId REMEMBER_KILL_THE_WEAKLINGS_FIRST;
	
	/**
	 * ID: 1000428<br>
	 * Message: ЎセȂOEĂI<br>
	 * Message: &#34395;&#24369;&#30340;&#20642;&#20249;&#33;&#20808;&#35731;&#20320;&#19979;&#22320;&#29508;&#33;<br>
	 * Message: Prepare to die, maggot!
	 */
	public static final NpcStringId PREPARE_TO_DIE_MAGGOT;
	
	/**
	 * ID: 1000429<br>
	 * Message: т͂̂炢ŏ[IOɏoĂ邩珀I<br>
	 * Message: &#36889;&#20123;&#31085;&#29289;&#23601;&#22816;&#20102;&#33;&#39340;&#19978;&#23601;&#36865;&#20320;&#20986;&#21435;&#65292;&#28310;&#20633;&#21543;&#33;<br>
	 * Message: That will do. Prepare to be released!
	 */
	public static final NpcStringId THAT_WILL_DO_PREPARE_TO_BE_RELEASED;
	
	/**
	 * ID: 1000430<br>
	 * Message: <br>
	 * Message: &#24179;&#25163;<br>
	 * Message: Draw
	 */
	public static final NpcStringId DRAW;
	
	/**
	 * ID: 1000431<br>
	 * Message: ̎xz҂̊FlIiɎQ܂I<br>
	 * Message: &#23553;&#21360;&#30340;&#32113;&#27835;&#32773;&#20497;&#33;&#28858;&#20102;&#23637;&#31034;&#29645;&#36020;&#30340;&#31934;&#21697;&#65292;&#25105;&#20358;&#25214;&#21508;&#20301;&#21862;&#33;<br>
	 * Message: Rulers of the seal! I bring you wondrous gifts!
	 */
	public static final NpcStringId RULERS_OF_THE_SEAL_I_BRING_YOU_WONDROUS_GIFTS;
	
	/**
	 * ID: 1000432<br>
	 * Message: ̎xz҂̊FlIō̕ɎQ܂I<br>
	 * Message: &#23553;&#21360;&#30340;&#32113;&#27835;&#32773;&#20497;&#33;&#28858;&#20102;&#23637;&#31034;&#26368;&#39640;&#32026;&#30340;&#27494;&#20855;&#65292;&#25105;&#20358;&#25214;&#21508;&#20301;&#21862;&#33;<br>
	 * Message: Rulers of the seal! I have some excellent weapons to show you!
	 */
	public static final NpcStringId RULERS_OF_THE_SEAL_I_HAVE_SOME_EXCELLENT_WEAPONS_TO_SHOW_YOU;
	
	/**
	 * ID: 1000433<br>
	 * Message: sȂȂA[ZAZI<br>
	 * Message: &#26481;&#22868;&#35199;&#36305;&#30340;&#21040;&#34389;&#20986;&#24046;&#65292;&#24537;&#30340;&#19981;&#24471;&#20102;&#33;<br>
	 * Message: I've been so busy lately, in addition to planning my trip!
	 */
	public static final NpcStringId IVE_BEEN_SO_BUSY_LATELY_IN_ADDITION_TO_PLANNING_MY_TRIP;
	
	/**
	 * ID: 1000434<br>
	 * Message: ア҂߂Ƃ́I񂼁I<br>
	 * Message: &#31455;&#25954;&#27450;&#36000;&#24369;&#32773;&#33;&#32085;&#23565;&#28961;&#27861;&#39250;&#24661;&#33;<br>
	 * Message: Your treatment of weaklings is unforgivable!
	 */
	public static final NpcStringId YOUR_TREATMENT_OF_WEAKLINGS_IS_UNFORGIVABLE;
	
	/**
	 * ID: 1000435<br>
	 * Message: ɗII<br>
	 * Message: &#20358;&#24171;&#20320;&#20102;&#33;&#21917;&#21834;&#33;<br>
	 * Message: I'm here to help you! Hi yah!
	 */
	public static final NpcStringId IM_HERE_TO_HELP_YOU_HI_YAH;
	
	/**
	 * ID: 1000436<br>
	 * Message: `̖̂ƂɁI<br>
	 * Message: &#20197;&#27491;&#32681;&#20043;&#21517;&#33;<br>
	 * Message: Justice will be served!
	 */
	public static final NpcStringId JUSTICE_WILL_BE_SERVED;
	
	/**
	 * ID: 1000437<br>
	 * Message: ̂ƂɁIĥ̖ƂɁI<br>
	 * Message: &#20197;&#20809;&#36637;&#33;&#20197;&#27054;&#35709;&#33;<br>
	 * Message: On to immortal glory!
	 */
	public static final NpcStringId ON_TO_IMMORTAL_GLORY;
	
	/**
	 * ID: 1000438<br>
	 * Message: `͎ア҂̖I<br>
	 * Message: &#27491;&#32681;&#28858;&#24369;&#32773;&#32780;&#23384;&#22312;&#33;<br>
	 * Message: Justice always avenges the powerless!
	 */
	public static final NpcStringId JUSTICE_ALWAYS_AVENGES_THE_POWERLESS;
	
	/**
	 * ID: 1000439<br>
	 * Message: ܂킦邩B񒣂I<br>
	 * Message: &#36996;&#25744;&#24471;&#20303;&#21966;&#33;&#65311;&#20877;&#24525;&#32784;&#19968;&#26371;&#20818;&#21543;&#33;<br>
	 * Message: Are you hurt? Hang in there, we've almost got them!
	 */
	public static final NpcStringId ARE_YOU_HURT_HANG_IN_THERE_WEVE_ALMOST_GOT_THEM;
	
	/**
	 * ID: 1000440<br>
	 * Message: ̖BOɋ閼ȂǂȂI<br>
	 * Message: &#25105;&#30340;&#21517;&#23383;&#65311;&#20320;&#20497;&#19981;&#37197;&#23559;&#25105;&#30340;&#21517;&#23383;&#25499;&#22312;&#22068;&#19978;&#33;<br>
	 * Message: Why should I tell you my name, you creep!?
	 */
	public static final NpcStringId WHY_SHOULD_I_TELL_YOU_MY_NAME_YOU_CREEP;
	
	/**
	 * ID: 1000441<br>
	 * Message: t\<br>
	 * Message: &#21487;&#20197;&#30003;&#35531;<br>
	 * Message: 0 minute
	 */
	public static final NpcStringId N1_MINUTE;
	
	/**
	 * ID: 1000443<br>
	 * Message: $s1̎o[sɃe|[g܂B<br>
	 * Message: &#23559;&#12300;&#36;&#115;&#49;&#12301;&#22478;&#30340;&#23432;&#22478;&#20154;&#21729;&#20659;&#36865;&#33267;&#20839;&#22478;&#12290;<br>
	 * Message: The defenders of $s1 castle will be teleported to the inner castle.
	 */
	public static final NpcStringId THE_DEFENDERS_OF_S1_CASTLE_WILL_BE_TELEPORTED_TO_THE_INNER_CASTLE;
	
	/**
	 * ID: 1000444<br>
	 * Message: j<br>
	 * Message: &#26143;&#26399;&#26085;<br>
	 * Message: Sunday
	 */
	public static final NpcStringId SUNDAY;
	
	/**
	 * ID: 1000445<br>
	 * Message: j<br>
	 * Message: &#26143;&#26399;&#19968;<br>
	 * Message: Monday
	 */
	public static final NpcStringId MONDAY;
	
	/**
	 * ID: 1000446<br>
	 * Message: Ηj<br>
	 * Message: &#26143;&#26399;&#20108;<br>
	 * Message: Tuesday
	 */
	public static final NpcStringId TUESDAY;
	
	/**
	 * ID: 1000447<br>
	 * Message: j<br>
	 * Message: &#26143;&#26399;&#19977;<br>
	 * Message: Wednesday
	 */
	public static final NpcStringId WEDNESDAY;
	
	/**
	 * ID: 1000448<br>
	 * Message: ؗj<br>
	 * Message: &#26143;&#26399;&#22235;<br>
	 * Message: Thursday
	 */
	public static final NpcStringId THURSDAY;
	
	/**
	 * ID: 1000449<br>
	 * Message: j<br>
	 * Message: &#26143;&#26399;&#20116;<br>
	 * Message: Friday
	 */
	public static final NpcStringId FRIDAY;
	
	/**
	 * ID: 1000450<br>
	 * Message: yj<br>
	 * Message: &#26143;&#26399;&#20845;<br>
	 * Message: Saturday
	 */
	public static final NpcStringId SATURDAY;
	
	/**
	 * ID: 1000451<br>
	 * Message: <br>
	 * Message: &#40670;<br>
	 * Message: Hour
	 */
	public static final NpcStringId HOUR;
	
	/**
	 * ID: 1000452<br>
	 * Message: Ō̎􂢂DDDƂɒn֍sI<br>
	 * Message: &#23559;&#26368;&#24460;&#30340;&#35419;&#21650;&#46;&#46;&#46;&#65281;&#19968;&#36215;&#19979;&#22320;&#29508;&#21543;&#65281;<br>
	 * Message: It's a good day to die! Welcome to hell, maggot!
	 */
	public static final NpcStringId ITS_A_GOOD_DAY_TO_DIE_WELCOME_TO_HELL_MAGGOT;
	
	/**
	 * ID: 1000453<br>
	 * Message: 2Ɉł̍ՓTI܂B<br>
	 * Message: &#50;&#20998;&#37912;&#24460;&#40657;&#26263;&#30340;&#31085;&#20856;&#23559;&#35201;&#32080;&#26463;<br>
	 * Message: The Festival of Darkness will end in two minutes.
	 */
	public static final NpcStringId THE_FESTIVAL_OF_DARKNESS_WILL_END_IN_TWO_MINUTES;
	
	/**
	 * ID: 1000454<br>
	 * Message: m[uX Q[g pX<br>
	 * Message: &#36020;&#26063;&#36890;&#34892;&#35657;<br>
	 * Message: Noblesse Gate Pass
	 */
	public static final NpcStringId NOBLESSE_GATE_PASS;
	
	/**
	 * ID: 1000456<br>
	 * Message: o߂܂<br>
	 * Message: &#20998;&#37912;&#12290;<br>
	 * Message: minute(s) have passed.
	 */
	public static final NpcStringId MINUTES_HAVE_PASSED;
	
	/**
	 * ID: 1000457<br>
	 * Message: Q[I܂BԂȂe|[g܂B<br>
	 * Message: &#25361;&#25136;&#24050;&#32080;&#26463;&#12290;&#31245;&#24460;&#23559;&#33258;&#21205;&#36914;&#34892;&#20659;&#36865;<br>
	 * Message: Game over. The teleport will appear momentarily.
	 */
	public static final NpcStringId GAME_OVER_THE_TELEPORT_WILL_APPEAR_MOMENTARILY;
	
	/**
	 * ID: 1000458<br>
	 * Message: n𔇂ǂAS̃f[̎ߐ[ƈ̑傳͌vmʂ̂InnnI<br>
	 * Message: &#20687;&#22312;&#22320;&#19978;&#29228;&#34892;&#30340;&#34802;&#23376;&#30340;&#20154;&#21834;&#65292;&#30334;&#30524;&#24801;&#39764;&#30340;&#24904;&#24754;&#33287;&#20553;&#22823;&#26159;&#28961;&#38480;&#30340;&#65281;&#21704;&#21704;&#21704;&#65281;<br>
	 * Message: You, who are like the slugs crawling on the ground. The generosity and greatness of me, Daimon the White-Eyed is endless! Ha Ha Ha!
	 */
	public static final NpcStringId YOU_WHO_ARE_LIKE_THE_SLUGS_CRAWLING_ON_THE_GROUND_THE_GENEROSITY_AND_GREATNESS_OF_ME_DAIMON_THE_WHITE_EYED_IS_ENDLESS_HA_HA_HA;
	
	/**
	 * ID: 1000459<br>
	 * Message: ̕S̃f[Gɉ񂷂Ȃ{炢łĂȂƂȂH<br>
	 * Message: &#24819;&#35201;&#33287;&#25105;&#30334;&#30524;&#30340;&#24801;&#39764;&#25973;&#23565;&#20043;&#20154;&#65292;&#23601;&#35201;&#20855;&#20633;&#19968;&#23450;&#30340;&#23526;&#21147;&#25165;&#34892;&#126;&#65281;<br>
	 * Message: If you want to be the opponent of me, Daimon the White-Eyed, you should at least have the basic skills~!
	 */
	public static final NpcStringId IF_YOU_WANT_TO_BE_THE_OPPONENT_OF_ME_DAIMON_THE_WHITE_EYED_YOU_SHOULD_AT_LEAST_HAVE_THE_BASIC_SKILLS;
	
	/**
	 * ID: 1000460<br>
	 * Message: nɔꂽȎ҂ǂAd̂ŋ킵Ă悤ȁB̃f[̋ɂa炰Ă낤B<br>
	 * Message: &#34987;&#23553;&#21360;&#22312;&#22823;&#22320;&#30340;&#24858;&#34850;&#20642;&#20249;&#20497;&#21834;&#65292;&#22240;&#28858;&#37027;&#27785;&#37325;&#30340;&#36523;&#39636;&#21463;&#33510;&#21862;&#12290;&#35731;&#26412;&#24801;&#39764;&#20358;&#28187;&#36629;&#37027;&#33510;&#30171;&#21543;&#12290;<br>
	 * Message: You stupid creatures that are bound to the earth. You are suffering too much while dragging your fat, heavy bodies. I, Daimon, will lighten your burden.
	 */
	public static final NpcStringId YOU_STUPID_CREATURES_THAT_ARE_BOUND_TO_THE_EARTH_YOU_ARE_SUFFERING_TOO_MUCH_WHILE_DRAGGING_YOUR_FAT_HEAVY_BODIES_I_DAIMON_WILL_LIGHTEN_YOUR_BURDEN;
	
	/**
	 * ID: 1000461<br>
	 * Message: Ml̂悤ȓŋȎ푰ɓG͂ȂIEnnnI<br>
	 * Message: &#20687;&#20320;&#20497;&#36889;&#27171;&#33030;&#24369;&#21448;&#24858;&#31528;&#30340;&#31278;&#26063;&#65292;&#26159;&#28961;&#27861;&#33287;&#25105;&#28858;&#25973;&#30340;&#65281;&#21704;&#21704;&#21704;&#21704;&#65281;&#32;<br>
	 * Message: A weak and stupid tribe like yours doesn't deserve to be my enemy! Bwa ha ha ha!
	 */
	public static final NpcStringId A_WEAK_AND_STUPID_TRIBE_LIKE_YOURS_DOESNT_DESERVE_TO_BE_MY_ENEMY_BWA_HA_HA_HA;
	
	/**
	 * ID: 1000462<br>
	 * Message: ̕S̃f[̗̒n҂Ȃ㏞𕥂I<br>
	 * Message: &#20405;&#29359;&#30334;&#30524;&#30340;&#24801;&#39764;&#38936;&#22320;&#30340;&#24858;&#32773;&#21834;&#65292;&#20184;&#20986;&#20195;&#20729;&#21543;&#65281;<br>
	 * Message: You dare to invade the territory of Daimon, the White-Eyed! Now, you will pay the price for your action!
	 */
	public static final NpcStringId YOU_DARE_TO_INVADE_THE_TERRITORY_OF_DAIMON_THE_WHITE_EYED_NOW_YOU_WILL_PAY_THE_PRICE_FOR_YOUR_ACTION;
	
	/**
	 * ID: 1000463<br>
	 * Message: ꂱt[eBO AC̈̑ȂNAS̃f[̉bInnnI<br>
	 * Message: &#36889;&#23601;&#26159;&#20553;&#22823;&#30340;&#30524;&#24618;&#20043;&#20027;&#45;&#30334;&#30524;&#24801;&#39764;&#30340;&#24681;&#20856;&#65281;&#21704;&#21704;&#21704;&#65281;<br>
	 * Message: This is the grace of Daimon the White-Eyed, the great Monster Eye Lord! Ha Ha Ha!
	 */
	public static final NpcStringId THIS_IS_THE_GRACE_OF_DAIMON_THE_WHITE_EYED_THE_GREAT_MONSTER_EYE_LORD_HA_HA_HA;
	
	/**
	 * ID: 1000464<br>
	 * Message: $s1lfGXg̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#27770;&#39717;&#32773;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Duelists. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_DUELISTS_CONGRATULATIONS;
	
	/**
	 * ID: 1000465<br>
	 * Message: $s1lhbhm[g̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#29467;&#23559;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Dreadnoughts. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_DREADNOUGHTS_CONGRATULATIONS;
	
	/**
	 * ID: 1000466<br>
	 * Message: $s1ltFjbNX iCg̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#32854;&#20976;&#39438;&#22763;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Phoenix Knights. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_PHOENIX_KNIGHTS_CONGRATULATIONS;
	
	/**
	 * ID: 1000467<br>
	 * Message: $s1lw iCg̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#29001;&#29508;&#39438;&#22763;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Hell Knights. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_HELL_KNIGHTS_CONGRATULATIONS;
	
	/**
	 * ID: 1000468<br>
	 * Message: $s1lTW^EX̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#20154;&#39340;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1 You have become a Sagittarius Hero. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_SAGITTARIUS_HERO_CONGRATULATIONS;
	
	/**
	 * ID: 1000469<br>
	 * Message: $s1lAhx`[̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#20882;&#38570;&#33521;&#35946;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Adventurers. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_ADVENTURERS_CONGRATULATIONS;
	
	/**
	 * ID: 1000470<br>
	 * Message: $s1lA[NCW̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#22823;&#39764;&#23566;&#22763;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Archmages. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_ARCHMAGES_CONGRATULATIONS;
	
	/**
	 * ID: 1000471<br>
	 * Message: $s1l\E eCJ[̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#39746;&#29417;&#34899;&#22763;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Soultakers. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_SOULTAKERS_CONGRATULATIONS;
	
	/**
	 * ID: 1000472<br>
	 * Message: $s1lAJi [h̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#31061;&#20736;&#21484;&#20027;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Arcana Lords. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_ARCANA_LORDS_CONGRATULATIONS;
	
	/**
	 * ID: 1000473<br>
	 * Message: $s1lJ[fBỉpYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#27166;&#27231;&#20027;&#25945;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Cardinals. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_CARDINALS_CONGRATULATIONS;
	
	/**
	 * ID: 1000474<br>
	 * Message: $s1lnCGt@g̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#26157;&#32854;&#32773;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Hierophants. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_HIEROPHANTS_CONGRATULATIONS;
	
	/**
	 * ID: 1000475<br>
	 * Message: $s1lG@X ev[̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#20234;&#23043;&#31070;&#27583;&#39438;&#22763;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Eva's Templars. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_EVAS_TEMPLARS_CONGRATULATIONS;
	
	/**
	 * ID: 1000476<br>
	 * Message: $s1l\[h ~[ỶpYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#20234;&#23043;&#21535;&#36938;&#35433;&#20154;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Sword Muses. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_SWORD_MUSES_CONGRATULATIONS;
	
	/**
	 * ID: 1000477<br>
	 * Message: $s1lEBh C_[̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#30142;&#39080;&#28010;&#20154;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Wind Riders. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_WIND_RIDERS_CONGRATULATIONS;
	
	/**
	 * ID: 1000478<br>
	 * Message: $s1l[Cg ZeBl̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#26376;&#20809;&#31661;&#38728;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Moonlight Sentinels. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_MOONLIGHT_SENTINELS_CONGRATULATIONS;
	
	/**
	 * ID: 1000479<br>
	 * Message: $s1l~XeBbN ~[ỶpYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#20234;&#23043;&#31061;&#34899;&#35433;&#20154;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Mystic Muses. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_MYSTIC_MUSES_CONGRATULATIONS;
	
	/**
	 * ID: 1000480<br>
	 * Message: $s1lG^ }X^[̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#20803;&#32032;&#25903;&#37197;&#32773;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Elemental Masters. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_ELEMENTAL_MASTERS_CONGRATULATIONS;
	
	/**
	 * ID: 1000481<br>
	 * Message: $s1lG@X ZCg̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#20234;&#23043;&#32854;&#32773;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Eva's Saints. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_EVAS_SAINTS_CONGRATULATIONS;
	
	/**
	 * ID: 1000482<br>
	 * Message: $s1lVG ev[̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#24109;&#29747;&#20901;&#27583;&#39438;&#22763;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of the Shillien Templars. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_THE_SHILLIEN_TEMPLARS_CONGRATULATIONS;
	
	/**
	 * ID: 1000483<br>
	 * Message: $s1lXyNg _T[̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#24189;&#20901;&#33310;&#32773;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Spectral Dancers. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_SPECTRAL_DANCERS_CONGRATULATIONS;
	
	/**
	 * ID: 1000484<br>
	 * Message: $s1lS[Xg n^[̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#39749;&#24433;&#29557;&#32773;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Ghost Hunters. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_GHOST_HUNTERS_CONGRATULATIONS;
	
	/**
	 * ID: 1000485<br>
	 * Message: $s1lS[Xg ZeBl̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#24189;&#20901;&#31661;&#38728;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Ghost Sentinels. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_GHOST_SENTINELS_CONGRATULATIONS;
	
	/**
	 * ID: 1000486<br>
	 * Message: $s1lXg[ XN[}[̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#26292;&#39080;&#29378;&#22063;&#32773;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Storm Screamers. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_STORM_SCREAMERS_CONGRATULATIONS;
	
	/**
	 * ID: 1000487<br>
	 * Message: $s1lXyNg }X^[̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#38343;&#24433;&#25903;&#37197;&#32773;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Spectral Masters. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_SPECTRAL_MASTERS_CONGRATULATIONS;
	
	/**
	 * ID: 1000488<br>
	 * Message: $s1lVG ZCg̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#24109;&#29747;&#32854;&#32773;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of the Shillien Saints. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_THE_SHILLIEN_SAINTS_CONGRATULATIONS;
	
	/**
	 * ID: 1000489<br>
	 * Message: $s1l^C^̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#27888;&#22374;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Titans. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_TITANS_CONGRATULATIONS;
	
	/**
	 * ID: 1000490<br>
	 * Message: $s1lOh Jo^̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#21345;&#24052;&#22612;&#37324;&#23447;&#24107;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Grand Khavataris. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_GRAND_KHAVATARIS_CONGRATULATIONS;
	
	/**
	 * ID: 1000491<br>
	 * Message: $s1lh~l[^[̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#21531;&#20027;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Dominators. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_DOMINATORS_CONGRATULATIONS;
	
	/**
	 * ID: 1000492<br>
	 * Message: $s1lhD[ NC[̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#26411;&#26085;&#25136;&#29378;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Doomcryers. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_DOOMCRYERS_CONGRATULATIONS;
	
	/**
	 * ID: 1000493<br>
	 * Message: $s1ltH[` V[J[̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#36001;&#23500;&#29557;&#20154;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Fortune Seekers. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_FORTUNE_SEEKERS_CONGRATULATIONS;
	
	/**
	 * ID: 1000494<br>
	 * Message: $s1l}GXg̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#24040;&#21280;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Maestros. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_MAESTROS_CONGRATULATIONS;
	
	/**
	 * ID: 1000495<br>
	 * Message: o^<br>
	 * Message: &#42;&#42;&#26410;&#30331;&#35352;&#42;&#42;<br>
	 * Message: **unregistered**
	 */
	public static final NpcStringId UNREGISTERED;
	
	/**
	 * ID: 1000496<br>
	 * Message: $s1lhD[ uK[̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#26411;&#26085;&#20351;&#32773;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Doombringers. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_DOOMBRINGERS_CONGRATULATIONS;
	
	/**
	 * ID: 1000497<br>
	 * Message: $s1l\E nEh̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#36861;&#39746;&#20351;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Soul Hounds. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_SOUL_HOUNDS_CONGRATULATIONS;
	
	/**
	 * ID: 1000499<br>
	 * Message: $s1lgbNX^[̉pYɂȂ܂B߂łƂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#27054;&#30331;&#39764;&#24392;&#23556;&#25163;&#20043;&#20013;&#65292;&#30331;&#23792;&#36896;&#26997;&#30340;&#33521;&#38596;&#65281;&#24685;&#21916;&#24744;&#65281;<br>
	 * Message: $s1! You have become a Hero of Tricksters. Congratulations!
	 */
	public static final NpcStringId S1_YOU_HAVE_BECOME_A_HERO_OF_TRICKSTERS_CONGRATULATIONS;
	
	/**
	 * ID: 1000500<br>
	 * Message: _֓邱Ƃł܂B<br>
	 * Message: &#24478;&#29694;&#22312;&#36215;&#21487;&#20197;&#36914;&#20837;&#38517;&#22675;&#20839;&#12290;<br>
	 * Message: You may now enter the Sepulcher.
	 */
	public static final NpcStringId YOU_MAY_NOW_ENTER_THE_SEPULCHER;
	
	/**
	 * ID: 1000501<br>
	 * Message: _ɓɂ́Al_̐ΑɎ悹܂B<br>
	 * Message: &#33509;&#23559;&#25163;&#25918;&#22312;&#22235;&#22823;&#38517;&#22675;&#30340;&#30707;&#20687;&#19978;&#65292;&#23601;&#21487;&#20197;&#36914;&#20837;&#38517;&#22675;&#20839;&#12290;<br>
	 * Message: If you place your hand on the stone statue in front of each sepulcher, you will be able to enter.
	 */
	public static final NpcStringId IF_YOU_PLACE_YOUR_HAND_ON_THE_STONE_STATUE_IN_FRONT_OF_EACH_SEPULCHER_YOU_WILL_BE_ABLE_TO_ENTER;
	
	/**
	 * ID: 1000502<br>
	 * Message: CȏOɖWQX^[o܂B<br>
	 * Message: &#28858;&#31478;&#29229;&#32773;&#21109;&#36896;&#20102;&#22952;&#31001;&#30340;&#24618;&#29289;&#12290;<br>
	 * Message: The monsters have spawned!
	 */
	public static final NpcStringId THE_MONSTERS_HAVE_SPAWNED;
	
	/**
	 * ID: 1000503<br>
	 * Message: ĂĂ肪Ƃ܂B<br>
	 * Message: &#24863;&#35613;&#24744;&#24171;&#25105;&#25214;&#20358;&#12290;<br>
	 * Message: Thank you for saving me.
	 */
	public static final NpcStringId THANK_YOU_FOR_SAVING_ME;
	
	/**
	 * ID: 1000504<br>
	 * Message: $s1l<br>
	 * Message: &#26410;&#28415;&#12300;&#36;&#115;&#49;&#12301;&#21517;&#32;<br>
	 * Message: Fewer than $s1
	 */
	public static final NpcStringId FEWER_THAN_S2;
	
	/**
	 * ID: 1000505<br>
	 * Message: $s1lȏ<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#21517;&#20197;&#19978;<br>
	 * Message: More than $s1
	 */
	public static final NpcStringId MORE_THAN_S2;
	
	/**
	 * ID: 1000506<br>
	 * Message: |Cg<br>
	 * Message: &#40670;&#25976;<br>
	 * Message: Point
	 */
	public static final NpcStringId POINT;
	
	/**
	 * ID: 1000507<br>
	 * Message: <br>
	 * Message: &#31478;&#29229;<br>
	 * Message: Competition
	 */
	public static final NpcStringId COMPETITION;
	
	/**
	 * ID: 1000508<br>
	 * Message: L<br>
	 * Message: &#26377;&#25928;&#23553;&#21360;<br>
	 * Message: Seal Validation
	 */
	public static final NpcStringId SEAL_VALIDATION;
	
	/**
	 * ID: 1000509<br>
	 * Message: <br>
	 * Message: &#28310;&#20633;<br>
	 * Message: Preparation
	 */
	public static final NpcStringId PREPARATION;
	
	/**
	 * ID: 1000512<br>
	 * Message: L<br>
	 * Message: &#28961;&#25793;&#26377;<br>
	 * Message: No Owner
	 */
	public static final NpcStringId NO_OWNER;
	
	/**
	 * ID: 1000513<br>
	 * Message: $s1lɂ͊댯łB߂肭B<br>
	 * Message: &#27492;&#22320;&#23565;&#12300;&#36;&#115;&#49;&#12301;&#20358;&#35498;&#26159;&#20491;&#21361;&#38570;&#20043;&#22320;&#65292;&#35531;&#22238;&#21543;&#12290;<br>
	 * Message: This place is dangerous, $s1. Please turn back.
	 */
	public static final NpcStringId THIS_PLACE_IS_DANGEROUS_S1_PLEASE_TURN_BACK;
	
	/**
	 * ID: 1000514<br>
	 * Message: Ȃ閰Ŵ͒NB<br>
	 * Message: &#26159;&#35504;&#22312;&#20405;&#25854;&#36889;&#31070;&#32854;&#30340;&#27785;&#30496;<br>
	 * Message: Who disturbs my sacred sleep?
	 */
	public static final NpcStringId WHO_DISTURBS_MY_SACRED_SLEEP;
	
	/**
	 * ID: 1000515<br>
	 * Message: @A邪B͉Ẍ̒nB<br>
	 * Message: &#30428;&#22675;&#32773;&#21834;&#65292;&#32102;&#25105;&#36864;&#19979;&#65281;&#36889;&#35041;&#26159;&#25105;&#20497;&#30340;&#23433;&#24687;&#20043;&#22320;&#65281;<br>
	 * Message: Begone, thief! Let our bones rest in peace.
	 */
	public static final NpcStringId BEGONE_THIEF_LET_OUR_BONES_REST_IN_PEACE;
	
	/**
	 * ID: 1000516<br>
	 * Message: wXgDCAXɍ\ȂłB<br>
	 * Message: &#40657;&#26031;&#21520;&#20234;&#19968;&#26063;&#21834;&#65292;&#19981;&#35201;&#20877;&#20358;&#29033;&#25105;&#20497;&#65281;<br>
	 * Message: Leave us be, Hestui scum!
	 */
	public static final NpcStringId _LEAVE_US_BE_HESTUI_SCUM;
	
	/**
	 * ID: 1000517<br>
	 * Message: JJCAyɂ͖Ȃ낤B<br>
	 * Message: &#21345;&#21345;&#20234;&#21834;&#65292;&#20320;&#23559;&#27704;&#28961;&#23527;&#26085;&#12290;<br>
	 * Message: Thieving Kakai, may bloodbugs gnaw you in your sleep!
	 */
	public static final NpcStringId THIEVING_KAKAI_MAY_BLOODBUGS_GNAW_YOU_IN_YOUR_SLEEP;
	
	/**
	 * ID: 1000518<br>
	 * Message: gx[Y g[N<br>
	 * Message: &#35211;&#32722;&#26053;&#32773;&#30340;&#27161;&#31456;<br>
	 * Message: Newbie Travel Token
	 */
	public static final NpcStringId NEWBIE_TRAVEL_TOKEN;
	
	/**
	 * ID: 1000519<br>
	 * Message: ̎xz҂ł邱̎ɂĒނƂ̂B $s1I<br>
	 * Message: &#31455;&#25954;&#21521;&#25105;&#36889;&#28779;&#28976;&#30340;&#25903;&#37197;&#32773;&#25361;&#25136;&#65311;&#12300;&#36;&#115;&#49;&#12301;&#65281;&#65281;&#65281;&#65281;<br>
	 * Message: Arrogant fool! You dare to challenge me, the Ruler of Flames? Here is your reward!
	 */
	public static final NpcStringId ARROGANT_FOOL_YOU_DARE_TO_CHALLENGE_ME_THE_RULER_OF_FLAMES_HERE_IS_YOUR_REWARD;
	
	/**
	 * ID: 1000520<br>
	 * Message: $s1I̒x̗͂Ŏ|ƂłvI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65281;&#65281;&#65281;&#65281;&#20197;&#20320;&#37027;&#24494;&#24369;&#30340;&#21147;&#37327;&#65292;&#31455;&#28982;&#22916;&#24819;&#33021;&#25802;&#25943;&#25105;&#65311;<br>
	 * Message: $s1!!!! You cannot hope to defeat me with your meager strength.
	 */
	public static final NpcStringId S1_YOU_CANNOT_HOPE_TO_DEFEAT_ME_WITH_YOUR_MEAGER_STRENGTH;
	
	/**
	 * ID: 1000521<br>
	 * Message: _Ȃ$s1OƂ̂I΂킹ȁI<br>
	 * Message: &#36899;&#31070;&#37117;&#22856;&#20309;&#19981;&#20102;&#25105;&#65292;&#32780;&#12300;&#36;&#115;&#49;&#12301;&#20320;&#31455;&#25954;&#21521;&#25105;&#25361;&#25136;&#65311;&#30495;&#26159;&#21487;&#31505;&#65281;<br>
	 * Message: Not even the gods themselves could touch me. But you, $s1, you dare challenge me?! Ignorant mortal!
	 */
	public static final NpcStringId NOT_EVEN_THE_GODS_THEMSELVES_COULD_TOUCH_ME_BUT_YOU_S1_YOU_DARE_CHALLENGE_ME_IGNORANT_MORTAL;
	
	/**
	 * ID: 1000522<br>
	 * Message: ̃NCG<br>
	 * Message: &#24974;&#24680;&#30340;&#37806;&#39746;&#26354;<br>
	 * Message: Requiem of Hatred
	 */
	public static final NpcStringId REQUIEM_OF_HATRED;
	
	/**
	 * ID: 1000523<br>
	 * Message: ̃t[K<br>
	 * Message: &#29378;&#21916;&#30340;&#36070;&#26684;&#26354;<br>
	 * Message: Fugue of Jubilation
	 */
	public static final NpcStringId FUGUE_OF_JUBILATION;
	
	/**
	 * ID: 1000524<br>
	 * Message: ̃gbJ[^<br>
	 * Message: &#30142;&#36208;&#30340;&#25176;&#21345;&#22612;&#26354;<br>
	 * Message: Frenetic Toccata
	 */
	public static final NpcStringId FRENETIC_TOCCATA;
	
	/**
	 * ID: 1000525<br>
	 * Message: f̃}YJ<br>
	 * Message: &#39749;&#24785;&#30340;&#39340;&#21405;&#21345;&#33310;&#26354;<br>
	 * Message: Hypnotic Mazurka
	 */
	public static final NpcStringId HYPNOTIC_MAZURKA;
	
	/**
	 * ID: 1000526<br>
	 * Message: ߒQ̃R[<br>
	 * Message: &#24754;&#21696;&#30340;&#35738;&#32654;&#35433;<br>
	 * Message: Mournful Chorale Prelude
	 */
	public static final NpcStringId MOURNFUL_CHORALE_PRELUDE;
	
	/**
	 * ID: 1000527<br>
	 * Message: ǓƂ̃h<br>
	 * Message: &#23396;&#29544;&#30340;&#36852;&#26059;&#26354;<br>
	 * Message: Rondo of Solitude
	 */
	public static final NpcStringId RONDO_OF_SOLITUDE;
	
	/**
	 * ID: 1000528<br>
	 * Message: IsA[h g[N<br>
	 * Message: &#22887;&#26519;&#21305;&#20126;&#27161;&#31456;<br>
	 * Message: Olympiad Token
	 */
	public static final NpcStringId OLYMPIAD_TOKEN;
	
	/**
	 * ID: 1001000<br>
	 * Message: Af<br>
	 * Message: &#20126;&#19969;&#29579;&#22283;<br>
	 * Message: The Kingdom of Aden
	 */
	public static final NpcStringId THE_KINGDOM_OF_ADEN;
	
	/**
	 * ID: 1001100<br>
	 * Message: GA<br>
	 * Message: &#33406;&#29246;&#25705;&#29579;&#22283;<br>
	 * Message: The Kingdom of Elmore
	 */
	public static final NpcStringId THE_KINGDOM_OF_ELMORE;
	
	/**
	 * ID: 1010001<br>
	 * Message: b铇̑<br>
	 * Message: &#35498;&#35441;&#20043;&#23798;&#26449;&#33674;<br>
	 * Message: Talking Island Village
	 */
	public static final NpcStringId TALKING_ISLAND_VILLAGE;
	
	/**
	 * ID: 1010002<br>
	 * Message: Gt<br>
	 * Message: &#31934;&#38728;&#26449;&#33674;<br>
	 * Message: The Elven Village
	 */
	public static final NpcStringId THE_ELVEN_VILLAGE;
	
	/**
	 * ID: 1010003<br>
	 * Message: _[NGt<br>
	 * Message: &#40657;&#26263;&#31934;&#38728;&#26449;&#33674;<br>
	 * Message: The Dark Elf Village
	 */
	public static final NpcStringId THE_DARK_ELF_VILLAGE;
	
	/**
	 * ID: 1010004<br>
	 * Message: O[fB<br>
	 * Message: &#21476;&#39791;&#19969;&#26449;&#33674;<br>
	 * Message: The Village of Gludin
	 */
	public static final NpcStringId THE_VILLAGE_OF_GLUDIN;
	
	/**
	 * ID: 1010005<br>
	 * Message: O[fBȊ<br>
	 * Message: &#21476;&#39791;&#19969;&#22478;&#37806;<br>
	 * Message: The Town of Gludio
	 */
	public static final NpcStringId THE_TOWN_OF_GLUDIO;
	
	/**
	 * ID: 1010006<br>
	 * Message: fBȊ<br>
	 * Message: &#29380;&#24681;&#22478;&#37806;<br>
	 * Message: The Town of Dion
	 */
	public static final NpcStringId THE_TOWN_OF_DION;
	
	/**
	 * ID: 1010007<br>
	 * Message: M̑<br>
	 * Message: &#22855;&#23721;&#22478;&#37806;<br>
	 * Message: The Town of Giran
	 */
	public static final NpcStringId THE_TOWN_OF_GIRAN;
	
	/**
	 * ID: 1010008<br>
	 * Message: I[N<br>
	 * Message: &#21322;&#29560;&#20154;&#26449;&#33674;<br>
	 * Message: Orc Village
	 */
	public static final NpcStringId ORC_VILLAGE;
	
	/**
	 * ID: 1010009<br>
	 * Message: h[t<br>
	 * Message: &#30702;&#20154;&#26449;&#33674;<br>
	 * Message: Dwarven Village
	 */
	public static final NpcStringId DWARVEN_VILLAGE;
	
	/**
	 * ID: 1010010<br>
	 * Message: _[NGt̐X̓암<br>
	 * Message: &#40657;&#26263;&#31934;&#38728;&#26862;&#26519;&#21335;&#37096;<br>
	 * Message: The Southern Part of the Dark Forest
	 */
	public static final NpcStringId THE_SOUTHERN_PART_OF_THE_DARK_FOREST;
	
	/**
	 * ID: 1010011<br>
	 * Message: kC<br>
	 * Message: &#26481;&#21271;&#28023;&#23736;<br>
	 * Message: The Northeast Coast
	 */
	public static final NpcStringId THE_NORTHEAST_COAST;
	
	/**
	 * ID: 1010012<br>
	 * Message: rn̓쑤<br>
	 * Message: &#33618;&#22320;&#21335;&#26041;&#20837;&#21475;<br>
	 * Message: The Southern Entrance to the Wastelandss
	 */
	public static final NpcStringId THE_SOUTHERN_ENTRANCE_TO_THE_WASTELANDSS;
	
	/**
	 * ID: 1010013<br>
	 * Message: I[̑<br>
	 * Message: &#27472;&#29790;&#22478;&#37806;<br>
	 * Message: Town of Oren
	 */
	public static final NpcStringId TOWN_OF_OREN;
	
	/**
	 * ID: 1010014<br>
	 * Message: ۉ̓<br>
	 * Message: &#35937;&#29273;&#22612;<br>
	 * Message: Ivory Tower
	 */
	public static final NpcStringId IVORY_TOWER;
	
	/**
	 * ID: 1010015<br>
	 * Message: 1Kr[<br>
	 * Message: &#49;&#27155;&#22823;&#24307;<br>
	 * Message: 1st Floor Lobby
	 */
	public static final NpcStringId N1ST_FLOOR_LOBBY;
	
	/**
	 * ID: 1010016<br>
	 * Message: n1KXX<br>
	 * Message: &#22320;&#19979;&#49;&#27155;&#32;&#22320;&#19979;&#21830;&#22478;<br>
	 * Message: Underground Shopping Area
	 */
	public static final NpcStringId UNDERGROUND_SHOPPING_AREA;
	
	/**
	 * ID: 1010017<br>
	 * Message: 2Kq[} EBU[h Mh<br>
	 * Message: &#50;&#27155;&#20154;&#39006;&#24043;&#24107;&#20844;&#26371;<br>
	 * Message: 2nd Floor Human Wizard Guild
	 */
	public static final NpcStringId N2ND_FLOOR_HUMAN_WIZARD_GUILD;
	
	/**
	 * ID: 1010018<br>
	 * Message: 3KG EBU[h Mh<br>
	 * Message: &#51;&#27155;&#31934;&#38728;&#24043;&#24107;&#20844;&#26371;<br>
	 * Message: 3rd Floor Elven Wizard Guild
	 */
	public static final NpcStringId N3RD_FLOOR_ELVEN_WIZARD_GUILD;
	
	/**
	 * ID: 1010019<br>
	 * Message: 4K_[N EBU[h Mh<br>
	 * Message: &#52;&#27155;&#40657;&#26263;&#24043;&#24107;&#20844;&#26371;<br>
	 * Message: 4th Floor Dark Wizard Guild
	 */
	public static final NpcStringId N4TH_FLOOR_DARK_WIZARD_GUILD;
	
	/**
	 * ID: 1010020<br>
	 * Message: t̑<br>
	 * Message: &#29557;&#20154;&#26449;&#33674;<br>
	 * Message: Hunters Village
	 */
	public static final NpcStringId HUNTERS_VILLAGE;
	
	/**
	 * ID: 1010021<br>
	 * Message: M`<br>
	 * Message: &#22855;&#23721;&#28207;&#21475;<br>
	 * Message: Giran Harbor
	 */
	public static final NpcStringId GIRAN_HARBOR;
	
	/**
	 * ID: 1010022<br>
	 * Message: n[fB̎m<br>
	 * Message: &#21704;&#27712;&#23416;&#38498;<br>
	 * Message: Hardin's Private Academy
	 */
	public static final NpcStringId HARDINS_PRIVATE_ACADEMY;
	
	/**
	 * ID: 1010023<br>
	 * Message: Af̑<br>
	 * Message: &#20126;&#19969;&#22478;&#37806;<br>
	 * Message: Town of Aden
	 */
	public static final NpcStringId TOWN_OF_ADEN;
	
	/**
	 * ID: 1010024<br>
	 * Message: ̍L<br>
	 * Message: &#22478;&#22561;&#24291;&#22580;<br>
	 * Message: Village Square
	 */
	public static final NpcStringId VILLAGE_SQUARE;
	
	/**
	 * ID: 1010025<br>
	 * Message: k<br>
	 * Message: &#21271;&#38272;&#20837;&#21475;<br>
	 * Message: North Gate Entrance
	 */
	public static final NpcStringId NORTH_GATE_ENTRANCE;
	
	/**
	 * ID: 1010026<br>
	 * Message: <br>
	 * Message: &#26481;&#38272;&#20837;&#21475;<br>
	 * Message: East Gate Entrance
	 */
	public static final NpcStringId EAST_GATE_ENTRANCE;
	
	/**
	 * ID: 1010027<br>
	 * Message: <br>
	 * Message: &#35199;&#38272;&#20837;&#21475;<br>
	 * Message: West Gate Entrance
	 */
	public static final NpcStringId WEST_GATE_ENTRANCE;
	
	/**
	 * ID: 1010028<br>
	 * Message: <br>
	 * Message: &#21335;&#38272;&#20837;&#21475;<br>
	 * Message: South Gate Entrance
	 */
	public static final NpcStringId SOUTH_GATE_ENTRANCE;
	
	/**
	 * ID: 1010029<br>
	 * Message: gDbN I[N̖cn̓<br>
	 * Message: &#22303;&#29790;&#20811;&#21322;&#29560;&#20154;&#20853;&#29151;&#20837;&#21475;<br>
	 * Message: Entrance to Turek Orc Camp
	 */
	public static final NpcStringId ENTRANCE_TO_TUREK_ORC_CAMP;
	
	/**
	 * ID: 1010030<br>
	 * Message: Yꂽ_a̓<br>
	 * Message: &#34987;&#36986;&#24536;&#30340;&#31070;&#27583;&#20837;&#21475;<br>
	 * Message: Entrance to Forgotten Temple
	 */
	public static final NpcStringId ENTRANCE_TO_FORGOTTEN_TEMPLE;
	
	/**
	 * ID: 1010031<br>
	 * Message: rn̓<br>
	 * Message: &#24290;&#22687;&#20837;&#21475;<br>
	 * Message: Entrance to the Wastelands
	 */
	public static final NpcStringId ENTRANCE_TO_THE_WASTELANDS;
	
	/**
	 * ID: 1010032<br>
	 * Message: ĂꂽIcn̓<br>
	 * Message: &#33618;&#24290;&#30340;&#29151;&#21312;&#20837;&#21475;<br>
	 * Message: Entrance to Abandoned Camp
	 */
	public static final NpcStringId ENTRANCE_TO_ABANDONED_CAMP;
	
	/**
	 * ID: 1010033<br>
	 * Message: N}n̓<br>
	 * Message: &#20811;&#39791;&#29802;&#27836;&#28580;&#20837;&#21475;<br>
	 * Message: Entrance to Cruma Marshlands
	 */
	public static final NpcStringId ENTRANCE_TO_CRUMA_MARSHLANDS;
	
	/**
	 * ID: 1010034<br>
	 * Message: Y̓<br>
	 * Message: &#21009;&#22580;&#20837;&#21475;<br>
	 * Message: Entrance to Execution Grounds
	 */
	public static final NpcStringId ENTRANCE_TO_EXECUTION_GROUNDS;
	
	/**
	 * ID: 1010035<br>
	 * Message: p`ŨAWgւ̓<br>
	 * Message: &#25269;&#25239;&#36557;&#30340;&#38577;&#34255;&#22320;&#20837;&#21475;<br>
	 * Message: Entrance to the Fortress of Resistance
	 */
	public static final NpcStringId ENTRANCE_TO_THE_FORTRESS_OF_RESISTANCE;
	
	/**
	 * ID: 1010036<br>
	 * Message: t[<br>
	 * Message: &#33433;&#32645;&#34349;&#26449;&#33674;<br>
	 * Message: Entrance to Floran Village
	 */
	public static final NpcStringId ENTRANCE_TO_FLORAN_VILLAGE;
	
	/**
	 * ID: 1010037<br>
	 * Message: n<br>
	 * Message: &#20013;&#31435;&#22320;&#24118;<br>
	 * Message: Neutral Zone
	 */
	public static final NpcStringId NEUTRAL_ZONE;
	
	/**
	 * ID: 1010038<br>
	 * Message: M̓<br>
	 * Message: &#22855;&#23721;&#35199;&#37002;&#36947;&#36335;<br>
	 * Message: Western Road of Giran
	 */
	public static final NpcStringId WESTERN_ROAD_OF_GIRAN;
	
	/**
	 * ID: 1010039<br>
	 * Message: O[fB̓<br>
	 * Message: &#21476;&#39791;&#19969;&#22478;&#26481;&#37002;&#36947;&#36335;<br>
	 * Message: Eastern Road of Gludin Village
	 */
	public static final NpcStringId EASTERN_ROAD_OF_GLUDIN_VILLAGE;
	
	/**
	 * ID: 1010041<br>
	 * Message: N}̓̓<br>
	 * Message: &#20811;&#39791;&#29802;&#39640;&#22612;&#20837;&#21475;<br>
	 * Message: Entrance to Cruma Tower
	 */
	public static final NpcStringId ENTRANCE_TO_CRUMA_TOWER;
	
	/**
	 * ID: 1010042<br>
	 * Message: ̉L<br>
	 * Message: &#27515;&#20129;&#36852;&#24266;<br>
	 * Message: Death Pass
	 */
	public static final NpcStringId DEATH_PASS;
	
	/**
	 * ID: 1010043<br>
	 * Message: nіk<br>
	 * Message: &#27836;&#28580;&#22320;&#24118;&#21271;&#37096;<br>
	 * Message: Northern part of the Marshlands
	 */
	public static final NpcStringId NORTHERN_PART_OF_THE_MARSHLANDS;
	
	/**
	 * ID: 1010044<br>
	 * Message: nіk<br>
	 * Message: &#20013;&#31435;&#22320;&#24118;&#35199;&#21271;&#37096;<br>
	 * Message: Northeast of the Neutral Zone
	 */
	public static final NpcStringId NORTHEAST_OF_THE_NEUTRAL_ZONE;
	
	/**
	 * ID: 1010045<br>
	 * Message: sł̍<br>
	 * Message: &#19981;&#28357;&#39640;&#21407;&#20013;&#37096;<br>
	 * Message: Immortal Plateau, Central Region
	 */
	public static final NpcStringId IMMORTAL_PLATEAU_CENTRAL_REGION;
	
	/**
	 * ID: 1010046<br>
	 * Message: sł̍암<br>
	 * Message: &#19981;&#28357;&#39640;&#21407;&#21335;&#37096;<br>
	 * Message: Immortal Plateau, Southern Region
	 */
	public static final NpcStringId IMMORTAL_PLATEAU_SOUTHERN_REGION;
	
	/**
	 * ID: 1010047<br>
	 * Message: sł̍쓌<br>
	 * Message: &#19981;&#28357;&#39640;&#21407;&#26481;&#21335;&#37096;<br>
	 * Message: Immortal Plateau, Southeast Region
	 */
	public static final NpcStringId IMMORTAL_PLATEAU_SOUTHEAST_REGION;
	
	/**
	 * ID: 1010048<br>
	 * Message: <br>
	 * Message: &#20912;&#20941;&#28689;&#24067;<br>
	 * Message: Frozen Waterfall
	 */
	public static final NpcStringId FROZEN_WATERFALL;
	
	/**
	 * ID: 1010049<br>
	 * Message: ssnClX<br>
	 * Message: &#27700;&#19978;&#37117;&#24066;&#28023;&#38899;&#26031;<br>
	 * Message: Heine
	 */
	public static final NpcStringId HEINE;
	
	/**
	 * ID: 1010050<br>
	 * Message: ̓F1K<br>
	 * Message: &#20658;&#24930;&#20043;&#22612;&#45;&#31532;&#49;&#23652;<br>
	 * Message: Tower of Insolence - 1st Floor
	 */
	public static final NpcStringId TOWER_OF_INSOLENCE_1ST_FLOOR;
	
	/**
	 * ID: 1010051<br>
	 * Message: ̓F5K<br>
	 * Message: &#20658;&#24930;&#20043;&#22612;&#45;&#31532;&#53;&#23652;<br>
	 * Message: Tower of Insolence - 5th Floor
	 */
	public static final NpcStringId TOWER_OF_INSOLENCE_5TH_FLOOR;
	
	/**
	 * ID: 1010052<br>
	 * Message: ̓F10K<br>
	 * Message: &#20658;&#24930;&#20043;&#22612;&#45;&#31532;&#49;&#48;&#23652;<br>
	 * Message: Tower of Insolence - 10th Floor
	 */
	public static final NpcStringId TOWER_OF_INSOLENCE_10TH_FLOOR;
	
	/**
	 * ID: 1010053<br>
	 * Message: RVA<br>
	 * Message: &#22823;&#22291;&#24418;&#31478;&#25216;&#22580;<br>
	 * Message: Coliseum
	 */
	public static final NpcStringId COLISEUM;
	
	/**
	 * ID: 1010054<br>
	 * Message: X^[ [X<br>
	 * Message: &#24618;&#29289;&#31478;&#36093;&#22580;<br>
	 * Message: Monster Derby
	 */
	public static final NpcStringId MONSTER_DERBY;
	
	/**
	 * ID: 1010055<br>
	 * Message: t<br>
	 * Message: &#22283;&#22659;&#23432;&#20633;&#38538;&#38468;&#36817;<br>
	 * Message: Near the frontier post
	 */
	public static final NpcStringId NEAR_THE_FRONTIER_POST;
	
	/**
	 * ID: 1010056<br>
	 * Message: Eq̊C̓<br>
	 * Message: &#23394;&#23376;&#20043;&#28023;&#20837;&#21475;<br>
	 * Message: Entrance to the Sea of Spores
	 */
	public static final NpcStringId ENTRANCE_TO_THE_SEA_OF_SPORES;
	
	/**
	 * ID: 1010057<br>
	 * Message: ߋ̐<br>
	 * Message: &#21476;&#25136;&#22580;<br>
	 * Message: An old battlefield
	 */
	public static final NpcStringId AN_OLD_BATTLEFIELD;
	
	/**
	 * ID: 1010058<br>
	 * Message: tFA[̒J̓<br>
	 * Message: &#22934;&#31934;&#35895;&#20837;&#21475;<br>
	 * Message: Entrance to Enchanted Valley
	 */
	public static final NpcStringId ENTRANCE_TO_ENCHANTED_VALLEY;
	
	/**
	 * ID: 1010059<br>
	 * Message: ̓̓<br>
	 * Message: &#20658;&#24930;&#20043;&#22612;&#20837;&#21475;<br>
	 * Message: Entrance to the Tower of Insolence
	 */
	public static final NpcStringId ENTRANCE_TO_THE_TOWER_OF_INSOLENCE;
	
	/**
	 * ID: 1010060<br>
	 * Message: Ή̏<br>
	 * Message: &#29123;&#29138;&#30340;&#27836;&#28580;<br>
	 * Message: Blazing Swamp
	 */
	public static final NpcStringId BLAZING_SWAMP;
	
	/**
	 * ID: 1010061<br>
	 * Message: n̓<br>
	 * Message: &#22283;&#31435;&#22675;&#22320;&#20837;&#21475;<br>
	 * Message: Entrance to the Cemetery
	 */
	public static final NpcStringId ENTRANCE_TO_THE_CEMETERY;
	
	/**
	 * ID: 1010062<br>
	 * Message: l̓A<br>
	 * Message: &#24040;&#20154;&#27934;&#31348;&#20837;&#21475;<br>
	 * Message: Entrance to The Giant's Cave
	 */
	public static final NpcStringId ENTRANCE_TO_THE_GIANTS_CAVE;
	
	/**
	 * ID: 1010063<br>
	 * Message: ̐X̓<br>
	 * Message: &#37857;&#20043;&#26862;&#26519;&#20837;&#21475;<br>
	 * Message: Entrance to the Forest of Mirrors
	 */
	public static final NpcStringId ENTRANCE_TO_THE_FOREST_OF_MIRRORS;
	
	/**
	 * ID: 1010064<br>
	 * Message: V[̓̕<br>
	 * Message: &#24109;&#29747;&#23553;&#21360;&#20837;&#21475;<br>
	 * Message: The Forbidden Gateway
	 */
	public static final NpcStringId THE_FORBIDDEN_GATEWAY;
	
	/**
	 * ID: 1010066<br>
	 * Message: ^m[ VmX̖cn<br>
	 * Message: &#36093;&#21202;&#35582;&#26031;&#20853;&#29151;<br>
	 * Message: Entrance to the Tanor Silenos Barracks
	 */
	public static final NpcStringId ENTRANCE_TO_THE_TANOR_SILENOS_BARRACKS;
	
	/**
	 * ID: 1010067<br>
	 * Message: hSo[<br>
	 * Message: &#40845;&#20043;&#35895;<br>
	 * Message: Dragon Valley
	 */
	public static final NpcStringId DRAGON_VALLEY;
	
	/**
	 * ID: 1010068<br>
	 * Message: t̐_<br>
	 * Message: &#40654;&#26126;&#30340;&#31070;&#35565;&#34389;<br>
	 * Message: Oracle of Dawn
	 */
	public static final NpcStringId ORACLE_OF_DAWN;
	
	/**
	 * ID: 1010069<br>
	 * Message: ̐_<br>
	 * Message: &#40643;&#26127;&#30340;&#31070;&#35565;&#34389;<br>
	 * Message: Oracle of Dusk
	 */
	public static final NpcStringId ORACLE_OF_DUSK;
	
	/**
	 * ID: 1010070<br>
	 * Message: т̃lN|X<br>
	 * Message: &#31085;&#29289;&#30340;&#21476;&#20195;&#20844;&#22675;<br>
	 * Message: Necropolis of Sacrifice
	 */
	public static final NpcStringId NECROPOLIS_OF_SACRIFICE;
	
	/**
	 * ID: 1010071<br>
	 * Message: ҂̃lN|X<br>
	 * Message: &#24033;&#31150;&#32773;&#30340;&#21476;&#20195;&#20844;&#22675;<br>
	 * Message: The Pilgrim's Necropolis
	 */
	public static final NpcStringId THE_PILGRIMS_NECROPOLIS;
	
	/**
	 * ID: 1010072<br>
	 * Message: Qq҂̃lN|X<br>
	 * Message: &#21443;&#25308;&#32773;&#30340;&#21476;&#20195;&#20844;&#22675;<br>
	 * Message: Necropolis of Worship
	 */
	public static final NpcStringId NECROPOLIS_OF_WORSHIP;
	
	/**
	 * ID: 1010073<br>
	 * Message: m̃lN|X<br>
	 * Message: &#28872;&#22763;&#30340;&#21476;&#20195;&#20844;&#22675;<br>
	 * Message: The Patriot's Necropolis
	 */
	public static final NpcStringId THE_PATRIOTS_NECROPOLIS;
	
	/**
	 * ID: 1010074<br>
	 * Message: s҂̃lN|X<br>
	 * Message: &#33510;&#34892;&#32773;&#30340;&#21476;&#20195;&#20844;&#22675;<br>
	 * Message: Necropolis of Devotion
	 */
	public static final NpcStringId NECROPOLIS_OF_DEVOTION;
	
	/**
	 * ID: 1010075<br>
	 * Message: }҂̃lN|X<br>
	 * Message: &#27529;&#25945;&#32773;&#30340;&#21476;&#20195;&#20844;&#22675;<br>
	 * Message: Necropolis of Martyrdom
	 */
	public static final NpcStringId NECROPOLIS_OF_MARTYRDOM;
	
	/**
	 * ID: 1010076<br>
	 * Message: gk̃lN|X<br>
	 * Message: &#20351;&#24466;&#30340;&#21476;&#20195;&#20844;&#22675;<br>
	 * Message: The Disciple's Necropolis
	 */
	public static final NpcStringId THE_DISCIPLES_NECROPOLIS;
	
	/**
	 * ID: 1010077<br>
	 * Message: ҂̃lN|X<br>
	 * Message: &#32854;&#32773;&#30340;&#21476;&#20195;&#20844;&#22675;<br>
	 * Message: The Saint's Necropolis
	 */
	public static final NpcStringId THE_SAINTS_NECROPOLIS;
	
	/**
	 * ID: 1010078<br>
	 * Message: ْ[҂̃J^R<br>
	 * Message: &#30064;&#31471;&#32773;&#30340;&#22320;&#19979;&#22675;&#31348;<br>
	 * Message: The Catacomb of the Heretic
	 */
	public static final NpcStringId THE_CATACOMB_OF_THE_HERETIC;
	
	/**
	 * ID: 1010079<br>
	 * Message: ̃J^R<br>
	 * Message: &#28889;&#21360;&#30340;&#22320;&#19979;&#22675;&#31348;<br>
	 * Message: Catacomb of the Branded
	 */
	public static final NpcStringId CATACOMB_OF_THE_BRANDED;
	
	/**
	 * ID: 1010080<br>
	 * Message: ًk̃J^R<br>
	 * Message: &#30064;&#25945;&#24466;&#30340;&#22320;&#19979;&#22675;&#31348;<br>
	 * Message: Catacomb of the Apostate
	 */
	public static final NpcStringId CATACOMB_OF_THE_APOSTATE;
	
	/**
	 * ID: 1010081<br>
	 * Message: ̃J^R<br>
	 * Message: &#39764;&#36947;&#30340;&#22320;&#19979;&#22675;&#31348;<br>
	 * Message: Catacomb of the Witch
	 */
	public static final NpcStringId CATACOMB_OF_THE_WITCH;
	
	/**
	 * ID: 1010082<br>
	 * Message: ̃J^R<br>
	 * Message: &#20982;&#29022;&#30340;&#22320;&#19979;&#22675;&#31348;<br>
	 * Message: Catacomb of Dark Omens
	 */
	public static final NpcStringId CATACOMB_OF_DARK_OMENS;
	
	/**
	 * ID: 1010083<br>
	 * Message: ẼJ^R<br>
	 * Message: &#23494;&#35584;&#32773;&#30340;&#22320;&#19979;&#22675;&#31348;<br>
	 * Message: Catacomb of the Forbidden Path
	 */
	public static final NpcStringId CATACOMB_OF_THE_FORBIDDEN_PATH;
	
	/**
	 * ID: 1010084<br>
	 * Message: ߒQ̔pГ<br>
	 * Message: &#24754;&#21696;&#24290;&#22687;&#20837;&#21475;<br>
	 * Message: Entrance to the Ruins of Agony
	 */
	public static final NpcStringId ENTRANCE_TO_THE_RUINS_OF_AGONY;
	
	/**
	 * ID: 1010085<br>
	 * Message: ]̔pГ<br>
	 * Message: &#32085;&#26395;&#24290;&#22687;&#20837;&#21475;<br>
	 * Message: Entrance to the Ruins of Despair
	 */
	public static final NpcStringId ENTRANCE_TO_THE_RUINS_OF_DESPAIR;
	
	/**
	 * ID: 1010086<br>
	 * Message: Ȃ<br>
	 * Message: &#34718;&#34811;&#27934;&#31391;&#20837;&#21475;<br>
	 * Message: Entrance to the Ant Nest
	 */
	public static final NpcStringId ENTRANCE_TO_THE_ANT_NEST;
	
	/**
	 * ID: 1010087<br>
	 * Message: fBI암<br>
	 * Message: &#29380;&#24681;&#21335;&#37096;<br>
	 * Message: Southern Dion
	 */
	public static final NpcStringId SOUTHERN_DION;
	
	/**
	 * ID: 1010088<br>
	 * Message: hSo[<br>
	 * Message: &#40845;&#20043;&#35895;&#20837;&#21475;<br>
	 * Message: Entrance to Dragon Valley
	 */
	public static final NpcStringId ENTRANCE_TO_DRAGON_VALLEY;
	
	/**
	 * ID: 1010089<br>
	 * Message: Î̑<br>
	 * Message: &#23527;&#38748;&#24179;&#21407;<br>
	 * Message: Field of Silence
	 */
	public static final NpcStringId FIELD_OF_SILENCE;
	
	/**
	 * ID: 1010090<br>
	 * Message: ̑<br>
	 * Message: &#32048;&#35486;&#24179;&#21407;<br>
	 * Message: Field of Whispers
	 */
	public static final NpcStringId FIELD_OF_WHISPERS;
	
	/**
	 * ID: 1010091<br>
	 * Message: NR_C ACh<br>
	 * Message: &#40055;&#39770;&#23798;&#20837;&#21475;<br>
	 * Message: Entrance to Alligator Island
	 */
	public static final NpcStringId ENTRANCE_TO_ALLIGATOR_ISLAND;
	
	/**
	 * ID: 1010092<br>
	 * Message: I[암<br>
	 * Message: &#27472;&#29790;&#21335;&#37096;&#33609;&#21407;<br>
	 * Message: Southern Plain of Oren
	 */
	public static final NpcStringId SOUTHERN_PLAIN_OF_OREN;
	
	/**
	 * ID: 1010093<br>
	 * Message: ȒA<br>
	 * Message: &#23665;&#36042;&#22478;&#23528;&#20837;&#21475;<br>
	 * Message: Entrance to the Bandit Stronghold
	 */
	public static final NpcStringId ENTRANCE_TO_THE_BANDIT_STRONGHOLD;
	
	/**
	 * ID: 1010094<br>
	 * Message: ̋u<br>
	 * Message: &#39080;&#20043;&#19992;&#38517;<br>
	 * Message: Windy Hill
	 */
	public static final NpcStringId WINDY_HILL;
	
	/**
	 * ID: 1010095<br>
	 * Message: gDbN I[N̖cn<br>
	 * Message: &#22303;&#29790;&#20811;&#29560;&#20154;&#20853;&#29151;<br>
	 * Message: Orc Barracks
	 */
	public static final NpcStringId ORC_BARRACKS;
	
	/**
	 * ID: 1010096<br>
	 * Message: tF̏W<br>
	 * Message: &#24085;&#31859;&#29246;&#25505;&#38598;&#22580;<br>
	 * Message: Fellmere Harvesting Grounds
	 */
	public static final NpcStringId FELLMERE_HARVESTING_GROUNDS;
	
	/**
	 * ID: 1010097<br>
	 * Message: ߒQ̔p<br>
	 * Message: &#24754;&#21696;&#24290;&#22687;<br>
	 * Message: Ruins of Agony
	 */
	public static final NpcStringId RUINS_OF_AGONY;
	
	/**
	 * ID: 1010098<br>
	 * Message: ĂꂽIcn<br>
	 * Message: &#33618;&#24290;&#30340;&#29151;&#21312;<br>
	 * Message: Abandoned Camp
	 */
	public static final NpcStringId ABANDONED_CAMP;
	
	/**
	 * ID: 1010099<br>
	 * Message: Ԃ̔<br>
	 * Message: &#36196;&#23721;&#31260;&#32218;<br>
	 * Message: Red Rock Ridge
	 */
	public static final NpcStringId RED_ROCK_RIDGE;
	
	/**
	 * ID: 1010100<br>
	 * Message: N U[h}n<br>
	 * Message: &#26391;&#20811;&#34597;&#34612;&#20154;&#20853;&#29151;<br>
	 * Message: Langk Lizardman Dwellings
	 */
	public static final NpcStringId LANGK_LIZARDMAN_DWELLINGS;
	
	/**
	 * ID: 1010101<br>
	 * Message: ]̔p<br>
	 * Message: &#32085;&#26395;&#24290;&#22687;<br>
	 * Message: Ruins of Despair
	 */
	public static final NpcStringId RUINS_OF_DESPAIR;
	
	/**
	 * ID: 1010102<br>
	 * Message: EB_ Ebh̑<br>
	 * Message: &#28331;&#36948;&#20237;&#24503;&#33674;&#22290;<br>
	 * Message: Windawood Manor
	 */
	public static final NpcStringId WINDAWOOD_MANOR;
	
	/**
	 * ID: 1010103<br>
	 * Message: rn̖k<br>
	 * Message: &#33618;&#21407;&#21271;&#26041;&#20837;&#21475;<br>
	 * Message: Northern Pathway to the Wastelands
	 */
	public static final NpcStringId NORTHERN_PATHWAY_TO_THE_WASTELANDS;
	
	/**
	 * ID: 1010104<br>
	 * Message: rn̐<br>
	 * Message: &#33618;&#21407;&#35199;&#26041;&#20837;&#21475;<br>
	 * Message: Western Pathway to the Wastelands
	 */
	public static final NpcStringId WESTERN_PATHWAY_TO_THE_WASTELANDS;
	
	/**
	 * ID: 1010105<br>
	 * Message: rn̓쑤<br>
	 * Message: &#33618;&#21407;&#21335;&#26041;&#20837;&#21475;<br>
	 * Message: Southern Pathway to the Wastelands
	 */
	public static final NpcStringId SOUTHERN_PATHWAY_TO_THE_WASTELANDS;
	
	/**
	 * ID: 1010106<br>
	 * Message: Yꂽ_a<br>
	 * Message: &#36986;&#24536;&#31070;&#27583;<br>
	 * Message: Forgotten Temple
	 */
	public static final NpcStringId FORGOTTEN_TEMPLE;
	
	/**
	 * ID: 1010107<br>
	 * Message: Ȃ̓쑤<br>
	 * Message: &#34718;&#34811;&#27934;&#31391;&#21335;&#26041;&#20837;&#21475;<br>
	 * Message: South Entrance of Ant Nest
	 */
	public static final NpcStringId SOUTH_ENTRANCE_OF_ANT_NEST;
	
	/**
	 * ID: 1010108<br>
	 * Message: Ȃ̓<br>
	 * Message: &#34718;&#34811;&#27934;&#31391;&#26481;&#26041;&#20837;&#21475;<br>
	 * Message: East Entrance of Ant Nest
	 */
	public static final NpcStringId EAST_ENTRANCE_OF_ANT_NEST;
	
	/**
	 * ID: 1010109<br>
	 * Message: Ȃ̐<br>
	 * Message: &#34718;&#34811;&#27934;&#31391;&#35199;&#26041;&#20837;&#21475;<br>
	 * Message: West Entrance of Ant Nest
	 */
	public static final NpcStringId WEST_ENTRANCE_OF_ANT_NEST;
	
	/**
	 * ID: 1010110<br>
	 * Message: N}n<br>
	 * Message: &#20811;&#39791;&#29802;&#27836;&#28580;&#22320;<br>
	 * Message: Cruma Marshland
	 */
	public static final NpcStringId CRUMA_MARSHLAND;
	
	/**
	 * ID: 1010111<br>
	 * Message: fBIqn<br>
	 * Message: &#29380;&#24681;&#29287;&#33609;&#22320;<br>
	 * Message: Plains of Dion
	 */
	public static final NpcStringId PLAINS_OF_DION;
	
	/**
	 * ID: 1010112<br>
	 * Message: r[nC<br>
	 * Message: &#21704;&#22294;&#34588;&#34562;&#34562;&#31401;<br>
	 * Message: Bee Hive
	 */
	public static final NpcStringId BEE_HIVE;
	
	/**
	 * ID: 1010113<br>
	 * Message: p`ŨAWg<br>
	 * Message: &#21453;&#25239;&#36557;&#26681;&#25818;&#22320;<br>
	 * Message: Fortress of Resistance
	 */
	public static final NpcStringId FORTRESS_OF_RESISTANCE;
	
	/**
	 * ID: 1010114<br>
	 * Message: Y<br>
	 * Message: &#21009;&#22580;<br>
	 * Message: Execution Grounds
	 */
	public static final NpcStringId EXECUTION_GROUNDS;
	
	/**
	 * ID: 1010115<br>
	 * Message: ^m[J<br>
	 * Message: &#22612;&#35582;&#23805;&#35895;<br>
	 * Message: Tanor Canyon
	 */
	public static final NpcStringId TANOR_CANYON;
	
	/**
	 * ID: 1010116<br>
	 * Message: N}̓<br>
	 * Message: &#20811;&#39791;&#29802;&#39640;&#22612;<br>
	 * Message: Cruma Tower
	 */
	public static final NpcStringId CRUMA_TOWER;
	
	/**
	 * ID: 1010117<br>
	 * Message: hSo[̎OH<br>
	 * Message: &#40845;&#20043;&#35895;&#19977;&#21449;&#36335;<br>
	 * Message: Three-way crossroads at Dragon Valley
	 */
	public static final NpcStringId THREE_WAY_CROSSROADS_AT_DRAGON_VALLEY;
	
	/**
	 * ID: 1010118<br>
	 * Message: uJ̑A<br>
	 * Message: &#24067;&#36084;&#21345;&#30340;&#24034;&#31348;<br>
	 * Message: Breka's Stronghold
	 */
	public static final NpcStringId BREKAS_STRONGHOLD;
	
	/**
	 * ID: 1010119<br>
	 * Message: SR̉ԉ<br>
	 * Message: &#21733;&#32943;&#30340;&#33457;&#22290;<br>
	 * Message: Gorgon Flower Garden
	 */
	public static final NpcStringId GORGON_FLOWER_GARDEN;
	
	/**
	 * ID: 1010120<br>
	 * Message: hSo[̃_W<br>
	 * Message: &#23433;&#22612;&#29790;&#26031;&#27934;&#31391;<br>
	 * Message: Antharas's Lair
	 */
	public static final NpcStringId ANTHARASS_LAIR;
	
	/**
	 * ID: 1010121<br>
	 * Message: Eq̊C<br>
	 * Message: &#23394;&#23376;&#20043;&#28023;<br>
	 * Message: Sea of Spores
	 */
	public static final NpcStringId SEA_OF_SPORES;
	
	/**
	 * ID: 1010122<br>
	 * Message: @҂̐X<br>
	 * Message: &#28961;&#27861;&#32773;&#30340;&#26862;&#26519;<br>
	 * Message: Outlaw Forest
	 */
	public static final NpcStringId OUTLAW_FOREST;
	
	/**
	 * ID: 1010123<br>
	 * Message: ̐XƏۉ̓<br>
	 * Message: &#39764;&#36947;&#30340;&#26862;&#26519;&#21644;&#35937;&#29273;&#22612;<br>
	 * Message: Forest of Evil and the Ivory Tower
	 */
	public static final NpcStringId FOREST_OF_EVIL_AND_THE_IVORY_TOWER;
	
	/**
	 * ID: 1010124<br>
	 * Message: eB}bN AEg|Xg<br>
	 * Message: &#25552;&#29802;&#20811;&#21069;&#21736;&#22522;&#22320;<br>
	 * Message: Timak Outpost
	 */
	public static final NpcStringId TIMAK_OUTPOST;
	
	/**
	 * ID: 1010125<br>
	 * Message: I[啽<br>
	 * Message: &#27472;&#29790;&#22823;&#24179;&#21407;<br>
	 * Message: Great Plains of Oren
	 */
	public static final NpcStringId GREAT_PLAINS_OF_OREN;
	
	/**
	 * ID: 1010126<br>
	 * Message: Bpt̏<br>
	 * Message: &#37706;&#37329;&#34899;&#22763;&#30340;&#23567;&#26408;&#23627;<br>
	 * Message: Alchemist's Hut
	 */
	public static final NpcStringId ALCHEMISTS_HUT;
	
	/**
	 * ID: 1010127<br>
	 * Message: ߋ̐<br>
	 * Message: &#21476;&#25136;&#22580;<br>
	 * Message: Ancient Battleground
	 */
	public static final NpcStringId ANCIENT_BATTLEGROUND;
	
	/**
	 * ID: 1010128<br>
	 * Message: tFA[̒J̖k<br>
	 * Message: &#22934;&#31934;&#35895;&#21271;&#26041;&#20837;&#21475;<br>
	 * Message: Northern Pathway of the Enchanted Valley
	 */
	public static final NpcStringId NORTHERN_PATHWAY_OF_THE_ENCHANTED_VALLEY;
	
	/**
	 * ID: 1010129<br>
	 * Message: tFA[̒J̓쑤<br>
	 * Message: &#22934;&#31934;&#35895;&#21335;&#26041;&#20837;&#21475;<br>
	 * Message: Southern Pathway of the Enchanted Valley
	 */
	public static final NpcStringId SOUTHERN_PATHWAY_OF_THE_ENCHANTED_VALLEY;
	
	/**
	 * ID: 1010130<br>
	 * Message: ťkJ<br>
	 * Message: &#29557;&#20154;&#20043;&#35895;<br>
	 * Message: Hunters Valley
	 */
	public static final NpcStringId HUNTERS_VALLEY;
	
	/**
	 * ID: 1010131<br>
	 * Message: Ή̏̐<br>
	 * Message: &#29123;&#29138;&#30340;&#27836;&#28580;&#35199;&#26041;&#20837;&#21475;<br>
	 * Message: Western Entrance of Blazing Swamp
	 */
	public static final NpcStringId WESTERN_ENTRANCE_OF_BLAZING_SWAMP;
	
	/**
	 * ID: 1010132<br>
	 * Message: Ή̏̓<br>
	 * Message: &#29123;&#29138;&#30340;&#27836;&#28580;&#26481;&#26041;&#20837;&#21475;<br>
	 * Message: Eastern Entrance of Blazing Swamp
	 */
	public static final NpcStringId EASTERN_ENTRANCE_OF_BLAZING_SWAMP;
	
	/**
	 * ID: 1010133<br>
	 * Message: h̕<br>
	 * Message: &#27054;&#32768;&#30340;&#24179;&#21407;<br>
	 * Message: Plains of Glory
	 */
	public static final NpcStringId PLAINS_OF_GLORY;
	
	/**
	 * ID: 1010134<br>
	 * Message: ̕<br>
	 * Message: &#28608;&#25136;&#30340;&#24179;&#21407;<br>
	 * Message: War-Torn Plains
	 */
	public static final NpcStringId WAR_TORN_PLAINS;
	
	/**
	 * ID: 1010135<br>
	 * Message: ̐X̖k<br>
	 * Message: &#37857;&#20043;&#26862;&#26519;&#35199;&#21271;&#26041;&#20837;&#21475;<br>
	 * Message: Northwestern Passage to the Forest of Mirrors
	 */
	public static final NpcStringId NORTHWESTERN_PASSAGE_TO_THE_FOREST_OF_MIRRORS;
	
	/**
	 * ID: 1010136<br>
	 * Message: Aw̑O<br>
	 * Message: &#26114;&#36203;&#28689;&#24067;&#21069;&#26041;<br>
	 * Message: The Front of Anghel Waterfall
	 */
	public static final NpcStringId THE_FRONT_OF_ANGHEL_WATERFALL;
	
	/**
	 * ID: 1010137<br>
	 * Message: j󂳂ꂽԂ̓쑤<br>
	 * Message: &#27584;&#22750;&#30340;&#22478;&#22561;&#21335;&#26041;&#20837;&#21475;<br>
	 * Message: South Entrance of Devastated Castle
	 */
	public static final NpcStringId SOUTH_ENTRANCE_OF_DEVASTATED_CASTLE;
	
	/**
	 * ID: 1010138<br>
	 * Message: j󂳂ꂽԂ̖k<br>
	 * Message: &#27584;&#22750;&#30340;&#22478;&#22561;&#21271;&#26041;<br>
	 * Message: North Entrance of Devastated Castle
	 */
	public static final NpcStringId NORTH_ENTRANCE_OF_DEVASTATED_CASTLE;
	
	/**
	 * ID: 1010139<br>
	 * Message: n̖k<br>
	 * Message: &#22283;&#31435;&#22675;&#22320;&#21271;&#26041;&#20837;&#21475;<br>
	 * Message: North Entrance of the Cemetery
	 */
	public static final NpcStringId NORTH_ENTRANCE_OF_THE_CEMETERY;
	
	/**
	 * ID: 1010140<br>
	 * Message: n̓쑤<br>
	 * Message: &#22283;&#31435;&#22675;&#22320;&#21335;&#26041;&#20837;&#21475;<br>
	 * Message: South Entrance of the Cemetery
	 */
	public static final NpcStringId SOUTH_ENTRANCE_OF_THE_CEMETERY;
	
	/**
	 * ID: 1010141<br>
	 * Message: n̐<br>
	 * Message: &#22283;&#31435;&#22675;&#22320;&#35199;&#26041;&#20837;&#21475;<br>
	 * Message: West Entrance of the Cemetery
	 */
	public static final NpcStringId WEST_ENTRANCE_OF_THE_CEMETERY;
	
	/**
	 * ID: 1010142<br>
	 * Message: V[̓̕<br>
	 * Message: &#24109;&#29747;&#23553;&#21360;&#20837;&#21475;<br>
	 * Message: Entrance of the Forbidden Gateway
	 */
	public static final NpcStringId ENTRANCE_OF_THE_FORBIDDEN_GATEWAY;
	
	/**
	 * ID: 1010143<br>
	 * Message: Yp̕<br>
	 * Message: &#24536;&#21371;&#24179;&#21407;<br>
	 * Message: Forsaken Plains
	 */
	public static final NpcStringId FORSAKEN_PLAINS;
	
	/**
	 * ID: 1010144<br>
	 * Message: ̓<br>
	 * Message: &#20658;&#24930;&#20043;&#22612;<br>
	 * Message: Tower of Insolence
	 */
	public static final NpcStringId TOWER_OF_INSOLENCE;
	
	/**
	 * ID: 1010145<br>
	 * Message: l̓A<br>
	 * Message: &#24040;&#20154;&#27934;&#31348;<br>
	 * Message: The Giant's Cave
	 */
	public static final NpcStringId THE_GIANTS_CAVE;
	
	/**
	 * ID: 1010146<br>
	 * Message: Î̖̑kn<br>
	 * Message: &#23527;&#38748;&#24179;&#21407;&#21271;&#37002;&#22320;&#24118;<br>
	 * Message: Northern Part of the Field of Silence
	 */
	public static final NpcStringId NORTHERN_PART_OF_THE_FIELD_OF_SILENCE;
	
	/**
	 * ID: 1010147<br>
	 * Message: Î̑̐n<br>
	 * Message: &#23527;&#38748;&#24179;&#21407;&#35199;&#37002;&#22320;&#24118;<br>
	 * Message: Western Part of the Field of Silence
	 */
	public static final NpcStringId WESTERN_PART_OF_THE_FIELD_OF_SILENCE;
	
	/**
	 * ID: 1010148<br>
	 * Message: ̑̓n<br>
	 * Message: &#32048;&#35486;&#24179;&#21407;&#26481;&#37002;&#22320;&#24118;<br>
	 * Message: Eastern Part of the Field of Silence
	 */
	public static final NpcStringId EASTERN_PART_OF_THE_FIELD_OF_SILENCE;
	
	/**
	 * ID: 1010149<br>
	 * Message: ̑̐n<br>
	 * Message: &#32048;&#35486;&#24179;&#21407;&#35199;&#37002;&#22320;&#24118;<br>
	 * Message: Western Part of the Field of Whispers
	 */
	public static final NpcStringId WESTERN_PART_OF_THE_FIELD_OF_WHISPERS;
	
	/**
	 * ID: 1010150<br>
	 * Message: NR_C ACh<br>
	 * Message: &#40055;&#39770;&#23798;<br>
	 * Message: Alligator Island
	 */
	public static final NpcStringId ALLIGATOR_ISLAND;
	
	/**
	 * ID: 1010151<br>
	 * Message: NR_C̔l<br>
	 * Message: &#40055;&#39770;&#30340;&#30333;&#27801;&#28760;<br>
	 * Message: Alligator Beach
	 */
	public static final NpcStringId ALLIGATOR_BEACH;
	
	/**
	 * ID: 1010152<br>
	 * Message: ̓<br>
	 * Message: &#24801;&#39764;&#23798;<br>
	 * Message: Devil's Isle
	 */
	public static final NpcStringId DEVILS_ISLE;
	
	/**
	 * ID: 1010153<br>
	 * Message: G@̐뉀<br>
	 * Message: &#20234;&#23043;&#30340;&#27700;&#20013;&#24237;&#22290;<br>
	 * Message: Garden of Eva
	 */
	public static final NpcStringId GARDEN_OF_EVA;
	
	/**
	 * ID: 1010154<br>
	 * Message: b铇<br>
	 * Message: &#35498;&#35441;&#20043;&#23798;<br>
	 * Message: Talking Island
	 */
	public static final NpcStringId TALKING_ISLAND;
	
	/**
	 * ID: 1010155<br>
	 * Message: Gt<br>
	 * Message: &#31934;&#38728;&#26449;&#33674;<br>
	 * Message: Elven Village
	 */
	public static final NpcStringId ELVEN_VILLAGE;
	
	/**
	 * ID: 1010156<br>
	 * Message: _[NGt<br>
	 * Message: &#40657;&#26263;&#31934;&#38728;&#26449;&#33674;<br>
	 * Message: Dark Elf Village
	 */
	public static final NpcStringId DARK_ELF_VILLAGE;
	
	/**
	 * ID: 1010159<br>
	 * Message: ACXΓW]<br>
	 * Message: &#24859;&#40599;&#32114;&#28246;&#30637;&#26395;&#21488;<br>
	 * Message: Scenic Deck of Iris Lake
	 */
	public static final NpcStringId SCENIC_DECK_OF_IRIS_LAKE;
	
	/**
	 * ID: 1010160<br>
	 * Message: l̍Ւd<br>
	 * Message: &#40657;&#26263;&#31934;&#38728;&#25104;&#20154;&#31085;&#22727;<br>
	 * Message: Altar of Rites
	 */
	public static final NpcStringId ALTAR_OF_RITES;
	
	/**
	 * ID: 1010161<br>
	 * Message: _[NGt̐XA<br>
	 * Message: &#40657;&#26263;&#31934;&#38728;&#26862;&#26519;&#12289;&#28689;&#24067;<br>
	 * Message: Dark Forest, Waterfall
	 */
	public static final NpcStringId DARK_FOREST_WATERFALL;
	
	/**
	 * ID: 1010162<br>
	 * Message: nт̎OH<br>
	 * Message: &#20013;&#31435;&#22320;&#24118;&#19977;&#21449;&#36335;<br>
	 * Message: Three-way Crossroads of the Neutral Zone
	 */
	public static final NpcStringId THREE_WAY_CROSSROADS_OF_THE_NEUTRAL_ZONE;
	
	/**
	 * ID: 1010163<br>
	 * Message: _[NGt̐X<br>
	 * Message: &#40657;&#26263;&#31934;&#38728;&#26862;&#26519;<br>
	 * Message: Dark Forest
	 */
	public static final NpcStringId DARK_FOREST;
	
	/**
	 * ID: 1010164<br>
	 * Message: n<br>
	 * Message: &#27836;&#28580;&#22320;&#24118;<br>
	 * Message: Swampland
	 */
	public static final NpcStringId SWAMPLAND;
	
	/**
	 * ID: 1010165<br>
	 * Message: ̋u<br>
	 * Message: &#40657;&#30707;&#23665;&#22369;<br>
	 * Message: Black Rock Hill
	 */
	public static final NpcStringId BLACK_ROCK_HILL;
	
	/**
	 * ID: 1010166<br>
	 * Message: N̑<br>
	 * Message: &#34584;&#34523;&#24034;&#31348;<br>
	 * Message: Spider Nest
	 */
	public static final NpcStringId SPIDER_NEST;
	
	/**
	 * ID: 1010167<br>
	 * Message: Gt̐X<br>
	 * Message: &#31934;&#38728;&#26862;&#26519;<br>
	 * Message: Elven Forest
	 */
	public static final NpcStringId ELVEN_FOREST;
	
	/**
	 * ID: 1010168<br>
	 * Message: 폟LO<br>
	 * Message: &#25136;&#21213;&#32000;&#24565;&#22612;<br>
	 * Message: Obelisk of Victory
	 */
	public static final NpcStringId OBELISK_OF_VICTORY;
	
	/**
	 * ID: 1010169<br>
	 * Message: b铇̖k<br>
	 * Message: &#35498;&#35441;&#20043;&#23798;&#21271;&#37002;<br>
	 * Message: Northern Territory of Talking Island
	 */
	public static final NpcStringId NORTHERN_TERRITORY_OF_TALKING_ISLAND;
	
	/**
	 * ID: 1010170<br>
	 * Message: b铇̓쑤<br>
	 * Message: &#35498;&#35441;&#20043;&#23798;&#21335;&#37002;<br>
	 * Message: Southern Territory of Talking Island
	 */
	public static final NpcStringId SOUTHERN_TERRITORY_OF_TALKING_ISLAND;
	
	/**
	 * ID: 1010171<br>
	 * Message: ̗Dn<br>
	 * Message: &#39764;&#29289;&#30340;&#25504;&#22890;&#22320;<br>
	 * Message: Evil Hunting Grounds
	 */
	public static final NpcStringId EVIL_HUNTING_GROUNDS;
	
	/**
	 * ID: 1010172<br>
	 * Message:  U[h}Ԓn<br>
	 * Message: &#38596;&#24615;&#34597;&#34612;&#20154;&#20853;&#29151;<br>
	 * Message: Maille Lizardmen Barracks
	 */
	public static final NpcStringId MAILLE_LIZARDMEN_BARRACKS;
	
	/**
	 * ID: 1010173<br>
	 * Message: ߒQ̔pЂɌ<br>
	 * Message: &#24754;&#21696;&#24290;&#22687;&#20837;&#21475;<br>
	 * Message: Ruins of Agony Bend
	 */
	public static final NpcStringId RUINS_OF_AGONY_BEND;
	
	/**
	 * ID: 1010174<br>
	 * Message: ]̔pЂɌ<br>
	 * Message: &#32085;&#26395;&#24290;&#22687;&#20837;&#21475;<br>
	 * Message: The Entrance to the Ruins of Despair
	 */
	public static final NpcStringId THE_ENTRANCE_TO_THE_RUINS_OF_DESPAIR;
	
	/**
	 * ID: 1010175<br>
	 * Message: Ԃ̋u<br>
	 * Message: &#39080;&#36554;&#30340;&#23665;&#22369;<br>
	 * Message: Windmill Hill
	 */
	public static final NpcStringId WINDMILL_HILL;
	
	/**
	 * ID: 1010177<br>
	 * Message: t[Jn<br>
	 * Message: &#33433;&#34367;&#34349;&#38283;&#22718;&#22320;<br>
	 * Message: Floran Agricultural Area
	 */
	public static final NpcStringId FLORAN_AGRICULTURAL_AREA;
	
	/**
	 * ID: 1010178<br>
	 * Message: ^m[J̐<br>
	 * Message: &#22612;&#35582;&#23805;&#35895;&#35199;&#37002;<br>
	 * Message: Western Tanor Canyon
	 */
	public static final NpcStringId WESTERN_TANOR_CANYON;
	
	/**
	 * ID: 1010179<br>
	 * Message: U[h vC<br>
	 * Message: &#34597;&#34612;&#33609;&#21407;<br>
	 * Message: Plains of the Lizardmen
	 */
	public static final NpcStringId PLAINS_OF_THE_LIZARDMEN;
	
	/**
	 * ID: 1010180<br>
	 * Message: ̐X<br>
	 * Message: &#39764;&#36947;&#30340;&#26862;&#26519;<br>
	 * Message: Forest of Evil
	 */
	public static final NpcStringId FOREST_OF_EVIL;
	
	/**
	 * ID: 1010181<br>
	 * Message: sȆn<br>
	 * Message: &#27578;&#25134;&#30340;&#22823;&#22320;<br>
	 * Message: Fields of Massacre
	 */
	public static final NpcStringId FIELDS_OF_MASSACRE;
	
	/**
	 * ID: 1010182<br>
	 * Message: TCg o[<br>
	 * Message: &#23490;&#38748;&#20043;&#35895;<br>
	 * Message: Silent Valley
	 */
	public static final NpcStringId SILENT_VALLEY;
	
	/**
	 * ID: 1010183<br>
	 * Message: sł̍k̖k<br>
	 * Message: &#19981;&#28357;&#39640;&#21407;&#21271;&#37096;&#21271;&#37002;<br>
	 * Message: Northern Area of the Immortal Plateau, Northern Region
	 */
	public static final NpcStringId NORTHERN_AREA_OF_THE_IMMORTAL_PLATEAU_NORTHERN_REGION;
	
	/**
	 * ID: 1010184<br>
	 * Message: sł̍k̓쑤<br>
	 * Message: &#19981;&#28357;&#39640;&#21407;&#21271;&#37096;&#21335;&#37002;<br>
	 * Message: Southern Area of the Immortal Plateau, Northern Region
	 */
	public static final NpcStringId SOUTHERN_AREA_OF_THE_IMMORTAL_PLATEAU_NORTHERN_REGION;
	
	/**
	 * ID: 1010185<br>
	 * Message: sł̍암̖k<br>
	 * Message: &#19981;&#28357;&#39640;&#21407;&#21335;&#37096;&#21271;&#37002;<br>
	 * Message: Northern Area of the Immortal Plateau, Southern Region
	 */
	public static final NpcStringId NORTHERN_AREA_OF_THE_IMMORTAL_PLATEAU_SOUTHERN_REGION;
	
	/**
	 * ID: 1010186<br>
	 * Message: sł̍암̓쑤<br>
	 * Message: &#19981;&#28357;&#39640;&#21407;&#21335;&#37096;&#21335;&#37002;<br>
	 * Message: Southern Area of the Immortal Plateau, Southern Region
	 */
	public static final NpcStringId SOUTHERN_AREA_OF_THE_IMMORTAL_PLATEAU_SOUTHERN_REGION;
	
	/**
	 * ID: 1010187<br>
	 * Message: zRnѐ<br>
	 * Message: &#23665;&#33032;&#31014;&#21312;&#35199;&#37096;<br>
	 * Message: Western Mining Zone
	 */
	public static final NpcStringId WESTERN_MINING_ZONE;
	
	/**
	 * ID: 1010190<br>
	 * Message: ̂ĂꂽYz<br>
	 * Message: &#24290;&#26820;&#30340;&#31014;&#22353;&#20837;&#21475;<br>
	 * Message: Entrance to the Abandoned Coal Mines
	 */
	public static final NpcStringId ENTRANCE_TO_THE_ABANDONED_COAL_MINES;
	
	/**
	 * ID: 1010191<br>
	 * Message: ~XzR<br>
	 * Message: &#31859;&#32034;&#33673;&#31014;&#23665;&#20837;&#21475;<br>
	 * Message: Entrance to the Mithril Mines
	 */
	public static final NpcStringId ENTRANCE_TO_THE_MITHRIL_MINES;
	
	/**
	 * ID: 1010192<br>
	 * Message: j󂳂ꂽԂ̐<br>
	 * Message: &#27584;&#22750;&#30340;&#22478;&#22561;&#35199;&#37002;<br>
	 * Message: West Area of the Devastated Castle
	 */
	public static final NpcStringId WEST_AREA_OF_THE_DEVASTATED_CASTLE;
	
	/**
	 * ID: 1010193<br>
	 * Message: ̓3K<br>
	 * Message: &#20658;&#24930;&#20043;&#22612;&#65306;&#31532;&#51;&#23652;<br>
	 * Message: Tower of Insolence, 3rd Floor
	 */
	public static final NpcStringId TOWER_OF_INSOLENCE_3RD_FLOOR;
	
	/**
	 * ID: 1010195<br>
	 * Message: ̓7K<br>
	 * Message: &#20658;&#24930;&#20043;&#22612;&#65306;&#31532;&#55;&#23652;<br>
	 * Message: Tower of Insolence, 7th Floor
	 */
	public static final NpcStringId TOWER_OF_INSOLENCE_7TH_FLOOR;
	
	/**
	 * ID: 1010197<br>
	 * Message: ̓13K<br>
	 * Message: &#20658;&#24930;&#20043;&#22612;&#65306;&#31532;&#49;&#51;&#23652;<br>
	 * Message: Tower of Insolence, 13th Floor
	 */
	public static final NpcStringId TOWER_OF_INSOLENCE_13TH_FLOOR;
	
	/**
	 * ID: 1010199<br>
	 * Message: S_[h̑<br>
	 * Message: &#39640;&#36948;&#29305;&#22478;&#37806;<br>
	 * Message: Town of Goddard
	 */
	public static final NpcStringId TOWN_OF_GODDARD;
	
	/**
	 * ID: 1010200<br>
	 * Message: Ȇ<br>
	 * Message: &#39791;&#22240;&#22478;&#37806;<br>
	 * Message: Rune Township
	 */
	public static final NpcStringId RUNE_TOWNSHIP;
	
	/**
	 * ID: 1010201<br>
	 * Message: N^[ɂ͂łˁH͂A܂܂`<br>
	 * Message: &#36939;&#36865;&#32102;&#38647;&#20811;&#29305;&#65311;&#22909;&#22909;&#65292;&#30693;&#36947;&#20102;&#126;<br>
	 * Message: A delivery for Mr. Lector? Very good!
	 */
	public static final NpcStringId A_DELIVERY_FOR_MR_LECTOR_VERY_GOOD;
	
	/**
	 * ID: 1010202<br>
	 * Message: ӂAƋxƁ`<br>
	 * Message: &#21710;&#21568;&#65281;&#35201;&#31245;&#24494;&#20241;&#24687;&#19968;&#19979;&#126;<br>
	 * Message: I need a break!
	 */
	public static final NpcStringId I_NEED_A_BREAK;
	
	/**
	 * ID: 1010203<br>
	 * Message: ɂ́AN^[IWN\Ă܂I<br>
	 * Message: &#20320;&#22909;&#65281;&#38647;&#20811;&#29305;&#65281;&#20625;&#20811;&#26862;&#20063;&#22909;&#20037;&#19981;&#35211;&#65281;<br>
	 * Message: Hello, Mr. Lector! Long time no see, Mr. Jackson!
	 */
	public static final NpcStringId HELLO_MR_LECTOR_LONG_TIME_NO_SEE_MR_JACKSON;
	
	/**
	 * ID: 1010204<br>
	 * Message: `<br>
	 * Message: &#21862;&#21862;&#21862;&#21862;&#126;<br>
	 * Message: Lulu!
	 */
	public static final NpcStringId LULU;
	
	/**
	 * ID: 1010205<br>
	 * Message: ̂ǂɍs񂾂낤H<br>
	 * Message: &#21040;&#24213;&#21435;&#21738;&#35041;&#21602;&#65311;<br>
	 * Message: Where has he gone?
	 */
	public static final NpcStringId WHERE_HAS_HE_GONE;
	
	/**
	 * ID: 1010206<br>
	 * Message: ́AEB_Ebhl܂łB<br>
	 * Message: &#20320;&#26377;&#30475;&#21040;&#28331;&#36948;&#20237;&#24503;&#21966;&#65311;<br>
	 * Message: Have you seen Windawood?
	 */
	public static final NpcStringId HAVE_YOU_SEEN_WINDAWOOD;
	
	/**
	 * ID: 1010207<br>
	 * Message: ̂ǂɂ񂾂낤H<br>
	 * Message: &#20182;&#21040;&#24213;&#22312;&#21738;&#35041;&#21602;&#65311;<br>
	 * Message: Where did he go?
	 */
	public static final NpcStringId WHERE_DID_HE_GO;
	
	/**
	 * ID: 1010208<br>
	 * Message: E񂾂͂ĂDDD<br>
	 * Message: &#19990;&#30028;&#27193;&#22312;&#36880;&#28472;&#20939;&#38646;&#26543;&#33806;&#46;&#46;&#46;<br>
	 * Message: The Mother Tree is slowly dying.
	 */
	public static final NpcStringId THE_MOTHER_TREE_IS_SLOWLY_DYING;
	
	/**
	 * ID: 1010209<br>
	 * Message: ECɂ@͂ȂȁH<br>
	 * Message: &#28858;&#20102;&#25937;&#27963;&#19990;&#30028;&#27193;&#35442;&#24590;&#40637;&#20570;&#65311;<br>
	 * Message: How can we save the Mother Tree?
	 */
	public static final NpcStringId HOW_CAN_WE_SAVE_THE_MOTHER_TREE;
	
	/**
	 * ID: 1010210<br>
	 * Message: ĂE͔DDD<br>
	 * Message: &#28961;&#35542;&#20309;&#26178;&#20957;&#35222;&#19990;&#30028;&#27193;&#37117;&#26159;&#22914;&#27492;&#32654;&#40599;&#46;&#46;<br>
	 * Message: The Mother Tree is always so gorgeous!
	 */
	public static final NpcStringId THE_MOTHER_TREE_IS_ALWAYS_SO_GORGEOUS;
	
	/**
	 * ID: 1010211<br>
	 * Message: ~eBGlIɌΔȂ̕â񂱂ƂI<br>
	 * Message: &#31859;&#24093;&#29246;&#65292;&#28246;&#27700;&#30340;&#21644;&#24179;&#33287;&#20320;&#21516;&#22312;&#46;&#46;<br>
	 * Message: Lady Mirabel, may the peace of the lake be with you!
	 */
	public static final NpcStringId LADY_MIRABEL_MAY_THE_PEACE_OF_THE_LAKE_BE_WITH_YOU;
	
	/**
	 * ID: 1010212<br>
	 * Message: lłAClI<br>
	 * Message: &#24744;&#24456;&#36763;&#33510;&#12290;&#33802;&#20234;&#29246;&#25289;&#65281;<br>
	 * Message: You're a hard worker, Rayla!
	 */
	public static final NpcStringId YOURE_A_HARD_WORKER_RAYLA;
	
	/**
	 * ID: 1010213<br>
	 * Message: lłI<br>
	 * Message: &#22810;&#21214;&#24744;&#36763;&#33510;&#20102;&#65281;<br>
	 * Message: You're a hard worker!
	 */
	public static final NpcStringId YOURE_A_HARD_WORKER;
	
	/**
	 * ID: 1010214<br>
	 * Message: ɂ͈ł̗qn܂܂Bx̎ɂ߂ȂłˁI<br>
	 * Message: &#24190;&#22825;&#24460;&#23559;&#38283;&#22987;&#40657;&#26263;&#20736;&#24335;&#65292;&#38656;&#35201;&#26356;&#27880;&#37325;&#35686;&#20633;&#24037;&#20316;&#65281;<br>
	 * Message: The mass of darkness will start in a couple of days. Pay more attention to the guard!
	 */
	public static final NpcStringId THE_MASS_OF_DARKNESS_WILL_START_IN_A_COUPLE_OF_DAYS_PAY_MORE_ATTENTION_TO_THE_GUARD;
	
	/**
	 * ID: 1010215<br>
	 * Message: AgbR܂łB<br>
	 * Message: &#20170;&#22825;&#20320;&#27794;&#30475;&#21040;&#21520;&#39791;&#20811;&#21966;&#65311;<br>
	 * Message: Have you seen Torocco today?
	 */
	public static final NpcStringId HAVE_YOU_SEEN_TOROCCO_TODAY;
	
	/**
	 * ID: 1010216<br>
	 * Message: āAgbR܂łB<br>
	 * Message: &#20320;&#27794;&#30475;&#21040;&#21520;&#39791;&#20811;&#21966;&#65311;<br>
	 * Message: Have you seen Torocco?
	 */
	public static final NpcStringId HAVE_YOU_SEEN_TOROCCO;
	
	/**
	 * ID: 1010217<br>
	 * Message: ΂߁IǂɉBꂽ񂾁H<br>
	 * Message: &#37027;&#20491;&#40736;&#36649;&#65281;&#32;&#21040;&#24213;&#36530;&#22312;&#21738;&#20818;&#65311;<br>
	 * Message: Where is that fool hiding?
	 */
	public static final NpcStringId WHERE_IS_THAT_FOOL_HIDING;
	
	/**
	 * ID: 1010218<br>
	 * Message: AꂶႠЂƉ肵Ă݂悤B<br>
	 * Message: &#22909;&#65281;&#37027;&#40637;&#23601;&#38283;&#22987;&#36681;&#19968;&#36681;&#65311;<br>
	 * Message: Care to go a round?
	 */
	public static final NpcStringId CARE_TO_GO_A_ROUND;
	
	/**
	 * ID: 1010219<br>
	 * Message: K^I~II悢I<br>
	 * Message: &#21345;&#40654;&#22612;&#65281;&#32;&#31859;&#24681;&#65281;&#32;&#24456;&#24841;&#24555;&#30340;&#19968;&#22825;&#65281;<br>
	 * Message: Have a nice day, Mr. Garita and Mion!
	 */
	public static final NpcStringId HAVE_A_NICE_DAY_MR_GARITA_AND_MION;
	
	/**
	 * ID: 1010220<br>
	 * Message: [hI}[tIGA[ICłB<br>
	 * Message: &#37324;&#24503;&#65281;&#32;&#25705;&#26222;&#29747;&#65281;&#32;&#33406;&#20818;&#40654;&#65281;&#32;&#20320;&#20497;&#22823;&#23478;&#37117;&#22909;&#21966;&#65311;<br>
	 * Message: Mr. Lid, Murdoc, and Airy! How are you doing?
	 */
	public static final NpcStringId MR_LID_MURDOC_AND_AIRY_HOW_ARE_YOU_DOING;
	
	/**
	 * ID: 1010221<br>
	 * Message: DDDttttDDD̂ڂo܂ꂽƂ킩邩B<br>
	 * Message: &#22312;&#40657;&#26376;&#20043;&#19979;&#46;&#46;&#21628;&#21628;&#46;&#46;&#21628;&#21628;&#21628;&#46;&#46;&#37027;&#20301;&#28165;&#37266;&#20102;&#65292;&#20320;&#25026;&#20102;&#21966;&#65311;<br>
	 * Message: A black moon... Now do you understand that he has opened his eyes?
	 */
	public static final NpcStringId A_BLACK_MOON_NOW_DO_YOU_UNDERSTAND_THAT_HE_HAS_OPENED_HIS_EYES;
	
	/**
	 * ID: 1010222<br>
	 * Message: ̉_񂹂ĂĂ邻ȁDDDtttDDDɂ͉J~邾낤DDD̉JȁDDD<br>
	 * Message: &#26263;&#32005;&#30340;&#38642;&#38695;&#27491;&#22312;&#20405;&#35186;&#46;&#46;&#21628;&#21628;&#21628;&#46;&#46;&#24555;&#35201;&#19979;&#38632;&#20102;&#46;&#46;&#34880;&#38632;&#24555;&#35201;&#24478;&#22825;&#32780;&#38477;&#20102;&#46;&#46;<br>
	 * Message: Clouds of blood are gathering. Soon, it will start to rain. The rain of crimson blood...
	 */
	public static final NpcStringId CLOUDS_OF_BLOOD_ARE_GATHERING_SOON_IT_WILL_START_TO_RAIN_THE_RAIN_OF_CRIMSON_BLOOD;
	
	/**
	 * ID: 1010223<br>
	 * Message: ȌɂĂ鍠Ałڂo܂Ƃ͂ȁDDDtttDDD<br>
	 * Message: &#35504;&#30693;&#36947;&#36225;&#24858;&#34850;&#30340;&#20809;&#33426;&#22312;&#27785;&#30561;&#30340;&#26178;&#20505;&#65292;&#40657;&#26263;&#31455;&#28982;&#26371;&#20808;&#28165;&#37266;&#36942;&#20358;&#46;&#46;&#21628;&#21628;&#21628;&#46;&#46;<br>
	 * Message: While the foolish light was asleep, the darkness will awaken first. Uh huh huh...
	 */
	public static final NpcStringId WHILE_THE_FOOLISH_LIGHT_WAS_ASLEEP_THE_DARKNESS_WILL_AWAKEN_FIRST_UH_HUH_HUH;
	
	/**
	 * ID: 1010224<br>
	 * Message: ł[̈łƁHȂ̂炱̐͏I肾ȁDDDtttDDD<br>
	 * Message: &#37027;&#26159;&#26368;&#28145;&#28149;&#30340;&#40657;&#26263;&#46;&#46;&#26082;&#28982;&#26159;&#36889;&#31278;&#26481;&#35199;&#35201;&#35186;&#25802;&#36942;&#20358;&#65292;&#37027;&#36889;&#20491;&#19990;&#30028;&#20063;&#25033;&#35442;&#39340;&#19978;&#23601;&#26371;&#28357;&#20129;&#20102;&#21543;&#46;&#46;&#21628;&#21628;&#46;&#46;<br>
	 * Message: It is the deepest darkness. With its arrival, the world will soon die.
	 */
	public static final NpcStringId IT_IS_THE_DEEPEST_DARKNESS_WITH_ITS_ARRIVAL_THE_WORLD_WILL_SOON_DIE;
	
	/**
	 * ID: 1010225<br>
	 * Message: ͂܂VȎn܂wBtttDDDȁB<br>
	 * Message: &#27515;&#20129;&#24847;&#35586;&#33879;&#26032;&#30340;&#38283;&#22987;&#46;&#46;&#21628;&#21628;&#46;&#46;&#19981;&#24517;&#37027;&#40636;&#24863;&#21040;&#24656;&#25084;&#46;&#46;<br>
	 * Message: Death is just a new beginning. Huhu... Fear not.
	 */
	public static final NpcStringId DEATH_IS_JUST_A_NEW_BEGINNING_HUHU_FEAR_NOT;
	
	/**
	 * ID: 1010226<br>
	 * Message: Ȁ_Ỉꂫ̒łŕs܂I<br>
	 * Message: &#21834;&#21834;&#65281;&#32654;&#40599;&#30340;&#27515;&#20129;&#22899;&#31070;&#21834;&#65281;&#35531;&#29992;&#40657;&#26263;&#20358;&#35206;&#33995;&#36889;&#20491;&#39599;&#39634;&#30340;&#19990;&#30028;&#21543;&#65281;<br>
	 * Message: Ahh! Beautiful goddess of death! Cover over the filth of this world with your darkness!
	 */
	public static final NpcStringId AHH_BEAUTIFUL_GODDESS_OF_DEATH_COVER_OVER_THE_FILTH_OF_THIS_WORLD_WITH_YOUR_DARKNESS;
	
	/**
	 * ID: 1010227<br>
	 * Message: łɏ_̕n܂ĂBtttDDDUR̂܂炪ƂŖʂI<br>
	 * Message: &#22899;&#31070;&#24050;&#38283;&#22987;&#24489;&#27963;&#46;&#46;&#21628;&#21628;&#46;&#46;&#20320;&#20497;&#36889;&#20123;&#24494;&#19981;&#36275;&#36947;&#30340;&#26481;&#35199;&#65292;&#23601;&#31639;&#20320;&#20497;&#20986;&#38754;&#20063;&#24050;&#32147;&#20358;&#19981;&#21450;&#20102;&#65281;<br>
	 * Message: The goddess's resurrection has already begun. Huhu... Insignificant creatures like you can do nothing!
	 */
	public static final NpcStringId THE_GODDESSS_RESURRECTION_HAS_ALREADY_BEGUN_HUHU_INSIGNIFICANT_CREATURES_LIKE_YOU_CAN_DO_NOTHING;
	
	/**
	 * ID: 1010400<br>
	 * Message: PPbIȂƂ$s1ȂāIH<br>
	 * Message: &#22035;&#65281;&#22035;&#65281;&#22312;&#27492;&#22320;&#24590;&#40636;&#26371;&#26377;&#20687;&#12300;&#36;&#115;&#49;&#12301;&#36889;&#27171;&#30340;&#39135;&#29289;&#65311;&#65281;<br>
	 * Message: Croak, Croak! Food like $s1 in this place?!
	 */
	public static final NpcStringId CROAK_CROAK_FOOD_LIKE_S1_IN_THIS_PLACE;
	
	/**
	 * ID: 1010401<br>
	 * Message: $s1AˁI<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#24590;&#40636;&#26371;&#26377;&#36889;&#31278;&#26481;&#35199;&#65281;<br>
	 * Message: $s1, How lucky I am!
	 */
	public static final NpcStringId S1_HOW_LUCKY_I_AM;
	
	/**
	 * ID: 1010402<br>
	 * Message: ނԈႦČA$s1I<br>
	 * Message: &#22914;&#26524;&#26159;&#37347;&#37679;&#20102;&#23565;&#35937;&#65292;&#37027;&#23601;&#36245;&#24555;&#27714;&#39250;&#21543;&#12290;&#12300;&#36;&#115;&#49;&#12301;&#65281;<br>
	 * Message: Pray that you caught a wrong fish $s1!
	 */
	public static final NpcStringId PRAY_THAT_YOU_CAUGHT_A_WRONG_FISH_S1;
	
	/**
	 * ID: 1010403<br>
	 * Message: JGÂႢB<br>
	 * Message: &#20320;&#30693;&#36947;&#38738;&#34521;&#30340;&#28363;&#21619;&#21966;&#65311;<br>
	 * Message: Do you know what a frog tastes like?
	 */
	public static final NpcStringId DO_YOU_KNOW_WHAT_A_FROG_TASTES_LIKE;
	
	/**
	 * ID: 1010404<br>
	 * Message: JG̗͂Ă낤I<br>
	 * Message: &#35731;&#20320;&#30475;&#30475;&#38738;&#34521;&#30340;&#21147;&#37327;&#21543;&#33;<br>
	 * Message: I will show you the power of a frog!
	 */
	public static final NpcStringId I_WILL_SHOW_YOU_THE_POWER_OF_A_FROG;
	
	/**
	 * ID: 1010405<br>
	 * Message: ňݍłI<br>
	 * Message: &#19968;&#21475;&#21507;&#19979;&#21435;&#21543;&#33;<br>
	 * Message: I will swallow at a mouthful!
	 */
	public static final NpcStringId I_WILL_SWALLOW_AT_A_MOUTHFUL;
	
	/**
	 * ID: 1010406<br>
	 * Message: StbDDD̃IlʂȂāI<br>
	 * Message: &#21834;&#21704;&#46;&#46;&#46;&#30495;&#27794;&#24819;&#21040;&#36889;&#20301;&#32769;&#20808;&#29983;&#23601;&#36889;&#27171;&#27515;&#20102;&#33;<br>
	 * Message: Ugh, no chance. How could this elder pass away like this!
	 */
	public static final NpcStringId UGH_NO_CHANCE_HOW_COULD_THIS_ELDER_PASS_AWAY_LIKE_THIS;
	
	/**
	 * ID: 1010407<br>
	 * Message: QRQRIJGEI<br>
	 * Message: &#21617;&#21617;&#33;&#35201;&#38738;&#34521;&#30340;&#21629;&#21834;&#33;<br>
	 * Message: Croak! Croak! A frog is dying!
	 */
	public static final NpcStringId CROAK_CROAK_A_FROG_IS_DYING;
	
	/**
	 * ID: 1010408<br>
	 * Message: JG͔ȂłIB<br>
	 * Message: &#38738;&#34521;&#32905;&#19981;&#22909;&#21507;&#21862;&#33;&#21769;&#21568;&#33;<br>
	 * Message: A frog tastes bad! Yuck!
	 */
	public static final NpcStringId A_FROG_TASTES_BAD_YUCK;
	
	/**
	 * ID: 1010409<br>
	 * Message: ႠI$s1ÂH<br>
	 * Message: &#21703;&#21834;&#65281;&#12300;&#36;&#115;&#49;&#12301;&#65292;&#20320;&#22312;&#25630;&#20160;&#40636;&#39740;&#21834;&#65311;<br>
	 * Message: Kaak! $s1, What are you doing now?
	 */
	public static final NpcStringId KAAK_S1_WHAT_ARE_YOU_DOING_NOW;
	
	/**
	 * ID: 1010410<br>
	 * Message: ӂӂA$s1̑̂ɏȂāBo͂łĂł傤ˁH<br>
	 * Message: &#21756;&#21756;&#65292;&#31455;&#25954;&#29992;&#37341;&#21050;&#12300;&#36;&#115;&#49;&#12301;&#31934;&#38728;&#30340;&#36523;&#39636;&#65292;&#24744;&#25033;&#35442;&#26377;&#20570;&#22909;&#24515;&#29702;&#28310;&#20633;&#21543;&#65311;<br>
	 * Message: Huh, $s1 You pierced into the body of the Spirit with a needle. Are you ready?
	 */
	public static final NpcStringId HUH_S1_YOU_PIERCED_INTO_THE_BODY_OF_THE_SPIRIT_WITH_A_NEEDLE_ARE_YOU_READY;
	
	/**
	 * ID: 1010411<br>
	 * Message: A$s1 Ȃ̂ˁBłˁAȍrۂ҂ɊԏȂĂȂH<br>
	 * Message: &#21710;&#21938;&#65292;&#21407;&#20358;&#26159;&#12300;&#36;&#115;&#49;&#12301;&#24744;&#21834;&#12290;&#25105;&#35498;&#27794;&#26377;&#19968;&#20491;&#22899;&#20154;&#26371;&#21916;&#27489;&#36889;&#40636;&#28961;&#31150;&#30340;&#36992;&#35531;&#30340;&#65281;<br>
	 * Message: Ooh $s1 That's you. But, no lady is pleased with this savage invitation!
	 */
	public static final NpcStringId OOH_S1_THATS_YOU_BUT_NO_LADY_IS_PLEASED_WITH_THIS_SAVAGE_INVITATION;
	
	/**
	 * ID: 1010412<br>
	 * Message: {点ˁI<br>
	 * Message: &#27683;&#27515;&#25105;&#20102;&#33;<br>
	 * Message: You made me angry!
	 */
	public static final NpcStringId YOU_MADE_ME_ANGRY;
	
	/**
	 * ID: 1010413<br>
	 * Message: ̏AǂĂ̂IH<br>
	 * Message: &#30382;&#33178;&#19978;&#30340;&#37341;&#23380;&#65292;&#28858;&#20102;&#25105;&#20320;&#35201;&#24590;&#40636;&#36000;&#36012;&#33;&#63;<br>
	 * Message: It is but a scratch! Is that all you can do?!
	 */
	public static final NpcStringId IT_IS_BUT_A_SCRATCH_IS_THAT_ALL_YOU_CAN_DO;
	
	/**
	 * ID: 1010414<br>
	 * Message: 񂽂ڂɂ킹ĂII<br>
	 * Message: &#20320;&#20063;&#35201;&#22039;&#22039;&#30475;&#30171;&#33510;&#30340;&#28363;&#21619;&#33;&#21710;&#21568;&#33;<br>
	 * Message: Feel my pain!
	 */
	public static final NpcStringId FEEL_MY_PAIN;
	
	/**
	 * ID: 1010415<br>
	 * Message: ႠIˁAoĂႢI<br>
	 * Message: &#21703;&#21834;&#33;&#37027;&#40636;&#65292;&#23601;&#36208;&#33879;&#30631;&#21543;&#33;<br>
	 * Message: I'll get you for this!
	 */
	public static final NpcStringId ILL_GET_YOU_FOR_THIS;
	
	/**
	 * ID: 1010416<br>
	 * Message: Ȃ̃GT͐HׂȂāA̋Ɍӂ炵ĂI<br>
	 * Message: &#25105;&#35201;&#21435;&#35686;&#21578;&#39770;&#20818;&#20497;&#65292;&#21483;&#20182;&#20497;&#19981;&#35201;&#21676;&#39770;&#39180;&#33;<br>
	 * Message: I will tell fish not to take your bait!
	 */
	public static final NpcStringId I_WILL_TELL_FISH_NOT_TO_TAKE_YOUR_BAIT;
	
	/**
	 * ID: 1010417<br>
	 * Message: ݂Ȃア߂ȂāDDDB<br>
	 * Message: &#31455;&#25954;&#25240;&#30952;&#25105;&#36889;&#27171;&#23308;&#36020;&#30340;&#31934;&#38728;&#46;&#46;&#46;&#21621;&#21621;&#46;&#46;&#46;<br>
	 * Message: You bothered such a weak spirit...Huh, Huh
	 */
	public static final NpcStringId YOU_BOTHERED_SUCH_A_WEAK_SPIRITHUH_HUH;
	
	/**
	 * ID: 1010418<br>
	 * Message: PPPDDD$s1DDDHׂ邼DDDPPbDDD<br>
	 * Message: &#21888;&#21888;&#46;&#46;&#46;&#21507;&#25481;&#46;&#46;&#46;&#12300;&#36;&#115;&#49;&#12301;&#46;&#46;&#46;&#21888;&#21888;&#46;&#46;&#46;<br>
	 * Message: Ke, ke, ke..$s1...I'm eating..Ke..
	 */
	public static final NpcStringId KE_KE_KES1IM_EATINGKE;
	
	/**
	 * ID: 1010419<br>
	 * Message: ODDDDDD$s1DDD߂DDDǂDDD<br>
	 * Message: &#21653;&#22165;&#46;&#46;&#46;&#22165;&#46;&#46;&#46;&#12300;&#36;&#115;&#49;&#12301;&#46;&#46;&#24819;&#35201;&#30340;&#46;&#46;&#46;&#39770;&#46;&#46;&#46;<br>
	 * Message: Kuh..Ooh..$s1..Enmity...Fish....
	 */
	public static final NpcStringId KUHOOHS1ENMITYFISH;
	
	/**
	 * ID: 1010420<br>
	 * Message: $s1HPzbDDDODDDObDDD<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#46;&#46;&#46;&#65311;&#21888;&#21888;&#46;&#46;&#46;&#21653;&#22165;&#46;&#46;&#46;&#21653;&#22165;&#46;&#46;&#46;<br>
	 * Message: $s1...? Huh... Huh..huh...
	 */
	public static final NpcStringId S1_HUH_HUHHUH;
	
	/**
	 * ID: 1010421<br>
	 * Message: NPPPPINIXsIA^AAAAAbNI<br>
	 * Message: &#21888;&#21888;&#21888;&#21888;&#46;&#46;&#46;&#21862;&#21653;&#33;&#22070;&#21866;&#33;&#21908;&#32822;&#32822;&#32822;&#33;<br>
	 * Message: Ke, ke, ke, Rakul! Spin! Eh, eh, eh!
	 */
	public static final NpcStringId KE_KE_KE_RAKUL_SPIN_EH_EH_EH;
	
	/**
	 * ID: 1010422<br>
	 * Message: IpvIIII<br>
	 * Message: &#21695;&#21568;&#33;&#27861;&#21033;&#26114;&#33;&#21695;&#21568;&#33;&#21834;&#21568;&#33;<br>
	 * Message: Ah! Fafurion! Ah! Ah!
	 */
	public static final NpcStringId AH_FAFURION_AH_AH;
	
	/**
	 * ID: 1010423<br>
	 * Message: NINI@@NDDDDI<br>
	 * Message: &#21862;&#21653;&#33;&#25289;&#21653;&#33;&#21862;&#21653;&#21653;&#22165;&#33;&#32;<br>
	 * Message: Rakul! Rakul! Ra-kul!
	 */
	public static final NpcStringId RAKUL_RAKUL_RA_KUL;
	
	/**
	 * ID: 1010424<br>
	 * Message: NGFDDD݁DDDDDD<br>
	 * Message: &#21888;&#21888;&#46;&#46;&#46;&#24819;&#35201;&#46;&#46;&#46;&#39770;&#46;&#46;&#46;<br>
	 * Message: Eh..Enmity...Fish...
	 */
	public static final NpcStringId EHENMITYFISH;
	
	/**
	 * ID: 1010425<br>
	 * Message: HꂽȂDDDOA@<br>
	 * Message: &#25105;&#19981;&#35201;&#34987;&#21507;&#25481;&#8230;&#21571;&#21568;&#21568;&#21568;&#33;<br>
	 * Message: I won't be eaten up...Kah, ah, ah
	 */
	public static final NpcStringId I_WONT_BE_EATEN_UPKAH_AH_AH;
	
	/**
	 * ID: 1010426<br>
	 * Message: OnbINIPzbPzbIOGFDDD<br>
	 * Message: &#21653;&#21862;&#33;&#21862;&#21653;&#33;&#21653;&#21862;&#21653;&#21862;&#33;&#21888;&#21571;&#46;&#46;&#46;<br>
	 * Message: Cough! Rakul! Cough, Cough! Keh...
	 */
	public static final NpcStringId COUGH_RAKUL_COUGH_COUGH_KEH;
	
	/**
	 * ID: 1010427<br>
	 * Message: pvIɉhI$s1ɂ͎I<br>
	 * Message: &#36060;&#20104;&#27861;&#21033;&#26114;&#27054;&#32768;&#65281;&#36060;&#20104;&#12300;&#36;&#115;&#49;&#12301;&#27515;&#20129;&#65281;<br>
	 * Message: Glory to Fafurion! Death to $s1!
	 */
	public static final NpcStringId GLORY_TO_FAFURION_DEATH_TO_S1;
	
	/**
	 * ID: 1010428<br>
	 * Message: $s1AOỈ߂Ă̂́I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#26159;&#20320;&#46;&#46;&#46;&#65311;&#33213;&#25954;&#27450;&#36000;&#25105;&#20497;&#36889;&#20123;&#21487;&#24976;&#30340;&#39770;&#65281;<br>
	 * Message: $s1! You are the one who bothered my poor fish!
	 */
	public static final NpcStringId S1_YOU_ARE_THE_ONE_WHO_BOTHERED_MY_POOR_FISH;
	
	/**
	 * ID: 1010429<br>
	 * Message: lI$s1Ɏ􂢂I<br>
	 * Message: &#27700;&#40845;&#21834;&#65281;&#35419;&#21650;&#12300;&#36;&#115;&#49;&#12301;&#21543;&#65281;<br>
	 * Message: Fafurion! A curse upon $s1!
	 */
	public static final NpcStringId FAFURION_A_CURSE_UPON_S1;
	
	/**
	 * ID: 1010430<br>
	 * Message: WCAg XyV A^bNI<br>
	 * Message: &#24040;&#20154;&#29305;&#25915;&#33;<br>
	 * Message: Giant Special Attack!
	 */
	public static final NpcStringId GIANT_SPECIAL_ATTACK;
	
	/**
	 * ID: 1010431<br>
	 * Message: ݂̍vmI<br>
	 * Message: &#35731;&#20320;&#30631;&#19968;&#30631;&#39770;&#32676;&#30340;&#24996;&#24594;&#33;<br>
	 * Message: Know the enmity of fish!
	 */
	public static final NpcStringId KNOW_THE_ENMITY_OF_FISH;
	
	/**
	 * ID: 1010432<br>
	 * Message: ̑HĂ݂I<br>
	 * Message: &#35731;&#20320;&#30693;&#36947;&#25105;&#27085;&#25216;&#26377;&#22810;&#40636;&#21426;&#23475;&#33;<br>
	 * Message: I will show you the power of a spear!
	 */
	public static final NpcStringId I_WILL_SHOW_YOU_THE_POWER_OF_A_SPEAR;
	
	/**
	 * ID: 1010433<br>
	 * Message: pvIlɉhI<br>
	 * Message: &#23559;&#27054;&#32768;&#27512;&#26044;&#27861;&#21033;&#26114;&#33;<br>
	 * Message: Glory to Fafurion!
	 */
	public static final NpcStringId GLORY_TO_FAFURION;
	
	/**
	 * ID: 1010434<br>
	 * Message: ͂I<br>
	 * Message: &#21888;&#21621;&#21621;&#33;<br>
	 * Message: Yipes!
	 */
	public static final NpcStringId YIPES;
	
	/**
	 * ID: 1010435<br>
	 * Message: V͎ȂDDD̂݁DDD<br>
	 * Message: &#32769;&#23559;&#19981;&#27515;&#8230;&#33;&#21482;&#26159;&#20939;&#38646;&#8230;&#33;<br>
	 * Message: An old soldier does not die..! but just disappear...!
	 */
	public static final NpcStringId AN_OLD_SOLDIER_DOES_NOT_DIE_BUT_JUST_DISAPPEAR;
	
	/**
	 * ID: 1010436<br>
	 * Message: $s1A̐̋Rm̒󂯂I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#25509;&#21463;&#25105;&#36889;&#20491;&#27700;&#20013;&#39438;&#22763;&#30340;&#25361;&#25136;&#21543;&#65281;<br>
	 * Message: $s1, Take my challenge, the knight of water!
	 */
	public static final NpcStringId S1_TAKE_MY_CHALLENGE_THE_KNIGHT_OF_WATER;
	
	/**
	 * ID: 1010437<br>
	 * Message: ̕񍐂ɂ$s1I<br>
	 * Message: &#30332;&#29694;&#39770;&#32676;&#22577;&#21578;&#20013;&#25152;&#35352;&#36617;&#30340;&#12300;&#36;&#115;&#49;&#12301;&#65281;<br>
	 * Message: Discover $s1 in the treasure chest of fish!
	 */
	public static final NpcStringId DISCOVER_S1_IN_THE_TREASURE_CHEST_OF_FISH;
	
	/**
	 * ID: 1010438<br>
	 * Message: $s1A킦̂͂񂽂̃GT̂I<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#21407;&#20358;&#25105;&#26159;&#19978;&#20102;&#20320;&#30340;&#19978;&#37476;&#21834;&#65281;<br>
	 * Message: $s1, I took your bait!
	 */
	public static final NpcStringId S1_I_TOOK_YOUR_BAIT;
	
	/**
	 * ID: 1010439<br>
	 * Message: {d݂̑pI<br>
	 * Message: &#30631;&#30631;&#40845;&#23470;&#27085;&#27861;&#30340;&#21426;&#23475;&#33;<br>
	 * Message: I will show you spearmanship used in Dragon King's Palace!
	 */
	public static final NpcStringId I_WILL_SHOW_YOU_SPEARMANSHIP_USED_IN_DRAGON_KINGS_PALACE;
	
	/**
	 * ID: 1010440<br>
	 * Message: 񂽂ɑŊ̃v[gI<br>
	 * Message: &#36889;&#26159;&#25105;&#32102;&#20320;&#30340;&#26368;&#24460;&#19968;&#20491;&#31150;&#29289;&#33;<br>
	 * Message: This is the last gift I give you!
	 */
	public static final NpcStringId THIS_IS_THE_LAST_GIFT_I_GIVE_YOU;
	
	/**
	 * ID: 1010441<br>
	 * Message: 񂽂̃GT͎|IႠȁI<br>
	 * Message: &#20320;&#30340;&#39770;&#39180;&#30495;&#22909;&#21507;&#33;&#37027;&#40636;&#23601;&#21435;&#27515;&#21543;&#33;<br>
	 * Message: Your bait was too delicious! Now, I will kill you!
	 */
	public static final NpcStringId YOUR_BAIT_WAS_TOO_DELICIOUS_NOW_I_WILL_KILL_YOU;
	
	/**
	 * ID: 1010442<br>
	 * Message: I䂪E݂̍I<br>
	 * Message: &#30495;&#19981;&#29976;&#24515;&#21834;&#33;&#25105;&#21516;&#32990;&#20497;&#30340;&#24616;&#24680;&#8230;&#33;<br>
	 * Message: What a regret! The enmity of my brethren!
	 */
	public static final NpcStringId WHAT_A_REGRET_THE_ENMITY_OF_MY_BRETHREN;
	
	/**
	 * ID: 1010443<br>
	 * Message: oĂI̋w͂ƒNDDD<br>
	 * Message: &#20320;&#32102;&#25105;&#35352;&#20303;&#33;&#25105;&#30340;&#20167;&#26371;&#26377;&#20154;&#46;&#46;&#46;<br>
	 * Message: I'll pay you back! Somebody will have my revenge!
	 */
	public static final NpcStringId ILL_PAY_YOU_BACK_SOMEBODY_WILL_HAVE_MY_REVENGE;
	
	/**
	 * ID: 1010444<br>
	 * Message: OtbDDDOɂ͕߂܂ȂI<br>
	 * Message: &#21888;&#21888;&#46;&#46;&#46;&#35201;&#19981;&#28982;&#20063;&#19981;&#26371;&#34987;&#20320;&#25235;&#20303;&#8230;&#33;<br>
	 * Message: Cough... But, I won't be eaten up by you...!
	 */
	public static final NpcStringId COUGH_BUT_I_WONT_BE_EATEN_UP_BY_YOU;
	
	/**
	 * ID: 1010445<br>
	 * Message: $s1ADDD<br>
	 * Message: &#46;&#46;&#46;&#65311;&#35584;&#27578;&#46;&#46;&#46;&#12300;&#36;&#115;&#49;&#12301;&#46;&#46;&#46;<br>
	 * Message: ....? $s1... I will kill you...
	 */
	public static final NpcStringId _S1_I_WILL_KILL_YOU;
	
	/**
	 * ID: 1010446<br>
	 * Message: $s1A[Cɂ鉴ނグȂāDDD<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#46;&#46;&#46;&#31455;&#28982;&#33021;&#37347;&#21040;&#22312;&#28145;&#28023;&#20013;&#30340;&#25105;&#46;&#46;&#46;<br>
	 * Message: $s1... How could you catch me from the deep sea...
	 */
	public static final NpcStringId S1_HOW_COULD_YOU_CATCH_ME_FROM_THE_DEEP_SEA;
	
	/**
	 * ID: 1010447<br>
	 * Message: $s1AɌ邩B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#46;&#46;&#46;&#25105;&#30475;&#36215;&#20358;&#20687;&#26781;&#39770;&#21966;&#65311;<br>
	 * Message: $s1... Do you think I am a fish?
	 */
	public static final NpcStringId S1_DO_YOU_THINK_I_AM_A_FISH;
	
	/**
	 * ID: 1010448<br>
	 * Message: ͂قЂ`<br>
	 * Message: &#21487;&#24801;&#30340;&#20642;&#20249;&#126;<br>
	 * Message: Ebibibi~
	 */
	public static final NpcStringId EBIBIBI;
	
	/**
	 * ID: 1010449<br>
	 * Message: NNNbAǂA񂪂ĂĂ낤B<br>
	 * Message: &#22079;&#22079;&#65292;&#37027;&#40636;&#65292;&#35201;&#19981;&#35201;&#25226;&#20320;&#29105;&#29105;&#22320;&#28900;&#29087;&#63;<br>
	 * Message: He, he, he. Do you want me to roast you well?
	 */
	public static final NpcStringId HE_HE_HE_DO_YOU_WANT_ME_TO_ROAST_YOU_WELL;
	
	/**
	 * ID: 1010450<br>
	 * Message: oĖfĂ񂾂H<br>
	 * Message: &#24478;&#27700;&#20013;&#20986;&#20358;&#30340;&#65292;&#20320;&#23601;&#19981;&#24597;&#20102;&#65311;<br>
	 * Message: You didn't keep your eyes on me because I come from the sea?
	 */
	public static final NpcStringId YOU_DIDNT_KEEP_YOUR_EYES_ON_ME_BECAUSE_I_COME_FROM_THE_SEA;
	
	/**
	 * ID: 1010451<br>
	 * Message: ЂDDDɂDDDĂĂĂĂI<br>
	 * Message: &#21888;&#22079;&#46;&#46;&#46;&#32;&#22909;&#30171;&#46;&#46;&#46;&#22909;&#30171;&#46;&#46;&#46;&#21834;&#21834;&#33;<br>
	 * Message: Eeek... I feel sick...yow...!
	 */
	public static final NpcStringId EEEK_I_FEEL_SICKYOW;
	
	/**
	 * ID: 1010452<br>
	 * Message: `FbAsDDD̂ɁB<br>
	 * Message: &#21834;&#65292;&#26159;&#22833;&#25943;&#21966;&#65311;&#25105;&#36996;&#30332;&#29694;&#20102;<br>
	 * Message: I have failed...
	 */
	public static final NpcStringId I_HAVE_FAILED;
	
	/**
	 * ID: 1010453<br>
	 * Message: DDD~DDDWWbDDD<br>
	 * Message: &#29983;&#21629;&#27963;&#21205;&#46;&#46;&#46;&#38748;&#27490;&#46;&#46;&#46;&#21571;&#21571;&#21571;&#46;&#46;&#46;<br>
	 * Message: Activity of life... Is stopped... Chizifc...
	 */
	public static final NpcStringId ACTIVITY_OF_LIFE_IS_STOPPED_CHIZIFC;
	
	/**
	 * ID: 1010454<br>
	 * Message: NbI$s1`Nb|[B<br>
	 * Message: &#21653;&#22165;&#22165;&#65281;&#12300;&#36;&#115;&#49;&#12301;&#126;&#32;&#21653;&#22165;&#21653;&#22165;&#65281;<br>
	 * Message: Growling! $s1~ Growling!
	 */
	public static final NpcStringId GROWLING_S1_GROWLING;
	
	/**
	 * ID: 1010455<br>
	 * Message: $s1̓邼I<br>
	 * Message: &#32862;&#21040;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#21619;&#36947;&#46;&#46;&#46;&#65281;<br>
	 * Message: I can smell $s1..!
	 */
	public static final NpcStringId I_CAN_SMELL_S1;
	
	/**
	 * ID: 1010456<br>
	 * Message: ȁA$s1I<br>
	 * Message: &#30475;&#36215;&#20358;&#22909;&#22909;&#21507;&#21908;&#65292;&#12300;&#36;&#115;&#49;&#12301;&#65281;<br>
	 * Message: Looks delicious, $s1!
	 */
	public static final NpcStringId LOOKS_DELICIOUS_S1;
	
	/**
	 * ID: 1010457<br>
	 * Message: HĂ邼I<br>
	 * Message: &#35201;&#25235;&#20358;&#21507;&#33;<br>
	 * Message: I will catch you!
	 */
	public static final NpcStringId I_WILL_CATCH_YOU;
	
	/**
	 * ID: 1010458<br>
	 * Message: ււցAvԂɂGTȁI<br>
	 * Message: &#21908;&#22079;&#22079;&#22079;&#65292;&#22909;&#20037;&#27794;&#21507;&#21040;&#36889;&#31278;&#26481;&#35199;&#20102;&#33;<br>
	 * Message: Uah, ah, ah, I couldn't eat anything for a long time!
	 */
	public static final NpcStringId UAH_AH_AH_I_COULDNT_EAT_ANYTHING_FOR_A_LONG_TIME;
	
	/**
	 * ID: 1010459<br>
	 * Message: OȂ񂩈I<br>
	 * Message: &#20687;&#20320;&#36889;&#27171;&#30340;&#26481;&#35199;&#25105;&#19968;&#21475;&#23601;&#21487;&#20197;&#21507;&#25481;&#33;<br>
	 * Message: I can swallow you at a mouthful!
	 */
	public static final NpcStringId I_CAN_SWALLOW_YOU_AT_A_MOUTHFUL;
	
	/**
	 * ID: 1010460<br>
	 * Message: DDDGTɂȂāI<br>
	 * Message: &#21888;&#8230;&#24819;&#21507;&#23601;&#21507;&#65292;&#21482;&#26159;&#27794;&#24819;&#21040;&#26371;&#19978;&#30070;&#33;<br>
	 * Message: What?! I am defeated by the prey!
	 */
	public static final NpcStringId WHAT_I_AM_DEFEATED_BY_THE_PREY;
	
	/**
	 * ID: 1010461<br>
	 * Message: Õ͉GTȂ񂾂I߂ĐHĂI<br>
	 * Message: &#20320;&#26159;&#25105;&#30340;&#31975;&#39135;&#33;&#35201;&#25235;&#20358;&#21507;&#46;&#46;&#46;&#33;<br>
	 * Message: You are my food! I have to kill you!
	 */
	public static final NpcStringId YOU_ARE_MY_FOOD_I_HAVE_TO_KILL_YOU;
	
	/**
	 * ID: 1010462<br>
	 * Message: GTɐHȂāDDDNbDDD<br>
	 * Message: &#36996;&#34987;&#39135;&#29289;&#21507;&#25481;&#20102;&#46;&#46;&#46;&#21834;&#21571;&#46;&#46;&#46;<br>
	 * Message: I can't believe I am eaten up by my prey... Gah!
	 */
	public static final NpcStringId I_CANT_BELIEVE_I_AM_EATEN_UP_BY_MY_PREY_GAH;
	
	/**
	 * ID: 1010463<br>
	 * Message: ނ̂$s1H<br>
	 * Message: &#46;&#46;&#46;&#12300;&#36;&#115;&#49;&#12301;&#26159;&#20320;&#37347;&#21040;&#25105;&#30340;&#46;&#46;&#46;&#65311;<br>
	 * Message: ....You caught me, $s1...?
	 */
	public static final NpcStringId YOU_CAUGHT_ME_S1;
	
	/**
	 * ID: 1010464<br>
	 * Message: ɉƂhɎvA$s1B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#20320;&#35201;&#24863;&#21040;&#27054;&#24184;&#21834;&#65292;&#23621;&#28982;&#33021;&#35211;&#21040;&#25105;&#12290;<br>
	 * Message: You're lucky to have even seen me, $s1.
	 */
	public static final NpcStringId YOURE_LUCKY_TO_HAVE_EVEN_SEEN_ME_S1;
	
	/**
	 * ID: 1010465<br>
	 * Message: $s1AċAȂĂۂvȂقB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#20320;&#26368;&#22909;&#25918;&#26820;&#24819;&#35201;&#36867;&#33067;&#30340;&#24565;&#38957;&#12290;<br>
	 * Message: $s1, you can't leave here alive. Give up.
	 */
	public static final NpcStringId S1_YOU_CANT_LEAVE_HERE_ALIVE_GIVE_UP;
	
	/**
	 * ID: 1010466<br>
	 * Message: [̗͂ƂƌDDD<br>
	 * Message: &#35731;&#20320;&#30631;&#30631;&#28145;&#28023;&#21147;&#37327;&#30340;&#21426;&#23475;&#46;&#46;&#46;&#33;<br>
	 * Message: I will show you the power of the deep sea!
	 */
	public static final NpcStringId I_WILL_SHOW_YOU_THE_POWER_OF_THE_DEEP_SEA;
	
	/**
	 * ID: 1010467<br>
	 * Message: ̒ނƂւ܂ĂDDD<br>
	 * Message: &#31881;&#30862;&#37347;&#31487;&#21543;&#46;&#46;&#46;&#33;<br>
	 * Message: I will break the fishing pole!
	 */
	public static final NpcStringId I_WILL_BREAK_THE_FISHING_POLE;
	
	/**
	 * ID: 1010468<br>
	 * Message: Ml̎ŕẢDDD<br>
	 * Message: &#20320;&#30340;&#23629;&#39636;&#25105;&#26371;&#22909;&#22909;&#22320;&#20139;&#29992;&#30340;&#46;&#46;&#46;<br>
	 * Message: Your corpse will be good food for me!
	 */
	public static final NpcStringId YOUR_CORPSE_WILL_BE_GOOD_FOOD_FOR_ME;
	
	/**
	 * ID: 1010469<br>
	 * Message: ̒ނtȂ̂DDD<br>
	 * Message: &#21407;&#20358;&#19981;&#26159;&#26222;&#36890;&#30340;&#22402;&#37347;&#32773;&#46;&#46;&#46;<br>
	 * Message: You are a good fisherman.
	 */
	public static final NpcStringId YOU_ARE_A_GOOD_FISHERMAN;
	
	/**
	 * ID: 1010470<br>
	 * Message: pvI|Ȃ̂DDD<br>
	 * Message: &#38627;&#36947;&#20320;&#19981;&#23475;&#24597;&#27861;&#21033;&#26114;&#46;&#46;&#46;&#33;<br>
	 * Message: Aren't you afraid of Fafurion?!
	 */
	public static final NpcStringId ARENT_YOU_AFRAID_OF_FAFURION;
	
	/**
	 * ID: 1010471<br>
	 * Message: f炵AJ߂Ă邼DDD<br>
	 * Message: &#35498;&#25105;&#22909;&#21426;&#23475;&#20358;&#35738;&#32654;&#25105;&#19968;&#19979;&#21543;&#46;&#46;&#46;<br>
	 * Message: You are excellent....
	 */
	public static final NpcStringId YOU_ARE_EXCELLENT;
	
	/**
	 * ID: 1010472<br>
	 * Message: őu쓮܂B<br>
	 * Message: &#24050;&#38283;&#21855;&#27602;&#27683;&#27231;&#38364;&#12290;<br>
	 * Message: The Poison device has been activated.
	 */
	public static final NpcStringId THE_POISON_DEVICE_HAS_BEEN_ACTIVATED;
	
	/**
	 * ID: 1010473<br>
	 * Message: 1AU͒ቺu쓮܂B<br>
	 * Message: &#49;&#20998;&#37912;&#24460;&#65292;&#23559;&#38283;&#21855;&#25915;&#25802;&#21147;&#24369;&#21270;&#27231;&#38364;&#12290;<br>
	 * Message: The P. Atk. reduction device will be activated in 1 minute.
	 */
	public static final NpcStringId THE_P_ATK_REDUCTION_DEVICE_WILL_BE_ACTIVATED_IN_1_MINUTE;
	
	/**
	 * ID: 1010474<br>
	 * Message: 2Ah͒ቺu쓮܂B<br>
	 * Message: &#50;&#20998;&#37912;&#24460;&#65292;&#23559;&#38283;&#21855;&#38450;&#31142;&#21147;&#24369;&#21270;&#27231;&#38364;&#12290;<br>
	 * Message: The Defense reduction device will be activated in 2 minutes.
	 */
	public static final NpcStringId THE_DEFENSE_REDUCTION_DEVICE_WILL_BE_ACTIVATED_IN_2_MINUTES;
	
	/**
	 * ID: 1010475<br>
	 * Message: 3AHP񕜌u쓮܂B<br>
	 * Message: &#51;&#20998;&#37912;&#24460;&#65292;&#23559;&#38283;&#21855;&#72;&#80;&#24674;&#24489;&#24369;&#21270;&#27231;&#38364;&#12290;<br>
	 * Message: The HP regeneration reduction device will be activated in 3 minutes.
	 */
	public static final NpcStringId THE_HP_REGENERATION_REDUCTION_DEVICE_WILL_BE_ACTIVATED_IN_3_MINUTES;
	
	/**
	 * ID: 1010476<br>
	 * Message: U͒ቺu쓮܂B<br>
	 * Message: &#24050;&#38283;&#21855;&#25915;&#25802;&#21147;&#24369;&#21270;&#27231;&#38364;&#12290;<br>
	 * Message: The P. Atk. reduction device has been activated.
	 */
	public static final NpcStringId THE_P_ATK_REDUCTION_DEVICE_HAS_BEEN_ACTIVATED;
	
	/**
	 * ID: 1010477<br>
	 * Message: h͒ቺu쓮܂B<br>
	 * Message: &#24050;&#38283;&#21855;&#38450;&#31142;&#21147;&#24369;&#21270;&#27231;&#38364;&#12290;<br>
	 * Message: The Defense reduction device has been activated.
	 */
	public static final NpcStringId THE_DEFENSE_REDUCTION_DEVICE_HAS_BEEN_ACTIVATED;
	
	/**
	 * ID: 1010478<br>
	 * Message: HP񕜌u쓮܂B<br>
	 * Message: &#24050;&#38283;&#21855;&#72;&#80;&#24674;&#24489;&#24369;&#21270;&#27231;&#38364;&#12290;<br>
	 * Message: The HP regeneration reduction device has been activated.
	 */
	public static final NpcStringId THE_HP_REGENERATION_REDUCTION_DEVICE_HAS_BEEN_ACTIVATED;
	
	/**
	 * ID: 1010479<br>
	 * Message: őuj󂳂܂B<br>
	 * Message: &#27602;&#27683;&#27231;&#38364;&#24050;&#36973;&#21463;&#30772;&#22750;&#12290;<br>
	 * Message: The poison device has now been destroyed.
	 */
	public static final NpcStringId THE_POISON_DEVICE_HAS_NOW_BEEN_DESTROYED;
	
	/**
	 * ID: 1010480<br>
	 * Message: U͒ቺuj󂳂܂B<br>
	 * Message: &#25915;&#25802;&#21147;&#24369;&#21270;&#27231;&#38364;&#24050;&#36973;&#21463;&#30772;&#22750;&#12290;<br>
	 * Message: The P. Atk. reduction device has now been destroyed.
	 */
	public static final NpcStringId THE_P_ATK_REDUCTION_DEVICE_HAS_NOW_BEEN_DESTROYED;
	
	/**
	 * ID: 1010481<br>
	 * Message: h͒ቺuj󂳂܂B<br>
	 * Message: &#38450;&#31142;&#21147;&#24369;&#21270;&#27231;&#38364;&#24050;&#36973;&#21463;&#30772;&#22750;&#12290;<br>
	 * Message: The Defense reduction device has been destroyed.
	 */
	public static final NpcStringId THE_DEFENSE_REDUCTION_DEVICE_HAS_BEEN_DESTROYED;
	
	/**
	 * ID: 1010485<br>
	 * Message: ̓A<br>
	 * Message: &#35430;&#32244;&#27934;&#31391;&#20837;&#21475;<br>
	 * Message: Entrance to the Cave of Trials
	 */
	public static final NpcStringId ENTRANCE_TO_THE_CAVE_OF_TRIALS;
	
	/**
	 * ID: 1010486<br>
	 * Message: GẗՓ<br>
	 * Message: &#31934;&#38728;&#24290;&#22687;&#20839;&#37096;<br>
	 * Message: Inside the Elven Ruins
	 */
	public static final NpcStringId INSIDE_THE_ELVEN_RUINS;
	
	/**
	 * ID: 1010487<br>
	 * Message: GẗՓ<br>
	 * Message: &#31934;&#38728;&#24290;&#22687;&#20837;&#21475;<br>
	 * Message: Entrance to the Elven Ruins
	 */
	public static final NpcStringId ENTRANCE_TO_THE_ELVEN_RUINS;
	
	/**
	 * ID: 1010488<br>
	 * Message: @<br>
	 * Message: &#40657;&#39764;&#27861;&#23416;&#38498;&#20837;&#21475;<br>
	 * Message: Entrance to the School of Dark Arts
	 */
	public static final NpcStringId ENTRANCE_TO_THE_SCHOOL_OF_DARK_ARTS;
	
	/**
	 * ID: 1010489<br>
	 * Message: @<br>
	 * Message: &#40657;&#39764;&#27861;&#23416;&#38498;&#20013;&#24515;<br>
	 * Message: Center of the School of Dark Arts
	 */
	public static final NpcStringId CENTER_OF_THE_SCHOOL_OF_DARK_ARTS;
	
	/**
	 * ID: 1010490<br>
	 * Message: Gt̒nvǓ<br>
	 * Message: &#31934;&#38728;&#30340;&#22320;&#24213;&#35201;&#22622;&#20837;&#21475;<br>
	 * Message: Entrance to the Elven Fortress
	 */
	public static final NpcStringId ENTRANCE_TO_THE_ELVEN_FORTRESS;
	
	/**
	 * ID: 1010491<br>
	 * Message: oJVmXԒn<br>
	 * Message: &#24052;&#29790;&#21345;&#36093;&#21202;&#35582;&#26031;&#20853;&#29151;<br>
	 * Message: Varka Silenos Stronghold
	 */
	public static final NpcStringId VARKA_SILENOS_STRONGHOLD;
	
	/**
	 * ID: 1010492<br>
	 * Message: Pg[ I[N AEg|Xg<br>
	 * Message: &#32943;&#29305;&#25289;&#29560;&#20154;&#21069;&#21736;&#22522;&#22320;<br>
	 * Message: Ketra Orc Outpost
	 */
	public static final NpcStringId KETRA_ORC_OUTPOST;
	
	/**
	 * ID: 1010493<br>
	 * Message: Ȇ̃Mh<br>
	 * Message: &#39791;&#22240;&#22478;&#37806;&#20844;&#26371;<br>
	 * Message: Rune Township Guild
	 */
	public static final NpcStringId RUNE_TOWNSHIP_GUILD;
	
	/**
	 * ID: 1010494<br>
	 * Message: Ȇ̐_a<br>
	 * Message: &#39791;&#22240;&#22478;&#37806;&#31070;&#27583;<br>
	 * Message: Rune Township Temple
	 */
	public static final NpcStringId RUNE_TOWNSHIP_TEMPLE;
	
	/**
	 * ID: 1010495<br>
	 * Message: Ȇ̏X<br>
	 * Message: &#39791;&#22240;&#22478;&#37806;&#21830;&#24215;<br>
	 * Message: Rune Township Store
	 */
	public static final NpcStringId RUNE_TOWNSHIP_STORE;
	
	/**
	 * ID: 1010496<br>
	 * Message: S҂̐X<br>
	 * Message: &#20129;&#32773;&#30340;&#26862;&#26519;&#20837;&#21475;<br>
	 * Message: Entrance to the Forest of the Dead
	 */
	public static final NpcStringId ENTRANCE_TO_THE_FOREST_OF_THE_DEAD;
	
	/**
	 * ID: 1010497<br>
	 * Message: ߖ̏̓<br>
	 * Message: &#24754;&#40180;&#30340;&#27836;&#28580;&#35199;&#26041;&#20837;&#21475;<br>
	 * Message: Western Entrance to the Swamp of Screams
	 */
	public static final NpcStringId WESTERN_ENTRANCE_TO_THE_SWAMP_OF_SCREAMS;
	
	/**
	 * ID: 1010498<br>
	 * Message: Yꂽ_a̓<br>
	 * Message: &#36986;&#24536;&#31070;&#27583;&#20837;&#21475;<br>
	 * Message: Entrance to the Forgotten Temple
	 */
	public static final NpcStringId ENTRANCE_TO_THE_FORGOTTEN_TEMPLE;
	
	/**
	 * ID: 1010499<br>
	 * Message: Yꂽ_a<br>
	 * Message: &#36986;&#24536;&#31070;&#27583;&#20013;&#22830;<br>
	 * Message: Center of the Forgotten Temple
	 */
	public static final NpcStringId CENTER_OF_THE_FORGOTTEN_TEMPLE;
	
	/**
	 * ID: 1010500<br>
	 * Message: N}̓<br>
	 * Message: &#20811;&#39791;&#29802;&#20837;&#21475;<br>
	 * Message: Entrance to the Cruma Tower
	 */
	public static final NpcStringId ENTRANCE_TO_THE_CRUMA_TOWER;
	
	/**
	 * ID: 1010501<br>
	 * Message: N}̓1K<br>
	 * Message: &#20811;&#39791;&#29802;&#49;&#27155;<br>
	 * Message: Cruma Tower - First Floor
	 */
	public static final NpcStringId CRUMA_TOWER_FIRST_FLOOR;
	
	/**
	 * ID: 1010502<br>
	 * Message: N}̓2K<br>
	 * Message: &#20811;&#39791;&#29802;&#50;&#27155;<br>
	 * Message: Cruma Tower - Second Floor
	 */
	public static final NpcStringId CRUMA_TOWER_SECOND_FLOOR;
	
	/**
	 * ID: 1010503<br>
	 * Message: N}̓3K<br>
	 * Message: &#20811;&#39791;&#29802;&#51;&#27155;<br>
	 * Message: Cruma Tower - Third Floor
	 */
	public static final NpcStringId CRUMA_TOWER_THIRD_FLOOR;
	
	/**
	 * ID: 1010504<br>
	 * Message: ̓<br>
	 * Message: &#24801;&#39764;&#23798;&#20837;&#21475;<br>
	 * Message: Entrance to Devil's Isle
	 */
	public static final NpcStringId ENTRANCE_TO_DEVILS_ISLE;
	
	/**
	 * ID: 1010506<br>
	 * Message: O[fB<br>
	 * Message: &#21476;&#39791;&#19969;&#31478;&#25216;&#22580;<br>
	 * Message: Gludin Arena
	 */
	public static final NpcStringId GLUDIN_ARENA;
	
	/**
	 * ID: 1010507<br>
	 * Message: M<br>
	 * Message: &#22855;&#23721;&#31478;&#25216;&#22580;<br>
	 * Message: Giran Arena
	 */
	public static final NpcStringId GIRAN_ARENA;
	
	/**
	 * ID: 1010508<br>
	 * Message: hSo[̃_W<br>
	 * Message: &#23433;&#22612;&#29790;&#26031;&#27934;&#31391;&#20837;&#21475;<br>
	 * Message: Entrance to Antharas's Lair
	 */
	public static final NpcStringId ENTRANCE_TO_ANTHARASS_LAIR;
	
	/**
	 * ID: 1010509<br>
	 * Message: hSo[̃_W 1K<br>
	 * Message: &#23433;&#22612;&#29790;&#26031;&#27934;&#31391;&#49;&#27155;<br>
	 * Message: Antharas's Lair - 1st Level
	 */
	public static final NpcStringId ANTHARASS_LAIR_1ST_LEVEL;
	
	/**
	 * ID: 1010510<br>
	 * Message: hSo[̃_W 2K<br>
	 * Message: &#23433;&#22612;&#29790;&#26031;&#27934;&#31391;&#50;&#27155;<br>
	 * Message: Antharas's Lair - 2nd Level
	 */
	public static final NpcStringId ANTHARASS_LAIR_2ND_LEVEL;
	
	/**
	 * ID: 1010511<br>
	 * Message: hSo[̃_WE̋<br>
	 * Message: &#23433;&#22612;&#29790;&#26031;&#27934;&#31391;&#32080;&#30028;&#20043;&#27211;<br>
	 * Message: Antharas's Lair - Magic Force Field Bridge
	 */
	public static final NpcStringId ANTHARASS_LAIR_MAGIC_FORCE_FIELD_BRIDGE;
	
	/**
	 * ID: 1010512<br>
	 * Message: hSo[̃_WS<br>
	 * Message: &#23433;&#22612;&#29790;&#26031;&#27934;&#31391;&#30340;&#24515;&#33247;<br>
	 * Message: The Heart of Antharas's Lair
	 */
	public static final NpcStringId THE_HEART_OF_ANTHARASS_LAIR;
	
	/**
	 * ID: 1010513<br>
	 * Message: Î̑ <br>
	 * Message: &#23527;&#38748;&#24179;&#21407;&#26481;&#26041;<br>
	 * Message: East of the Field of Silence
	 */
	public static final NpcStringId EAST_OF_THE_FIELD_OF_SILENCE;
	
	/**
	 * ID: 1010514<br>
	 * Message: Î̑ <br>
	 * Message: &#23527;&#38748;&#24179;&#21407;&#35199;&#26041;<br>
	 * Message: West of the Field of Silence
	 */
	public static final NpcStringId WEST_OF_THE_FIELD_OF_SILENCE;
	
	/**
	 * ID: 1010515<br>
	 * Message: ̑ <br>
	 * Message: &#32048;&#35486;&#24179;&#21407;&#26481;&#26041;<br>
	 * Message: East of the Field of Whispers
	 */
	public static final NpcStringId EAST_OF_THE_FIELD_OF_WHISPERS;
	
	/**
	 * ID: 1010516<br>
	 * Message: ̑ <br>
	 * Message: &#32048;&#35486;&#24179;&#21407;&#35199;&#26041;<br>
	 * Message: West of the Field of Whispers
	 */
	public static final NpcStringId WEST_OF_THE_FIELD_OF_WHISPERS;
	
	/**
	 * ID: 1010517<br>
	 * Message: G@̐뉀<br>
	 * Message: &#20234;&#23043;&#30340;&#27700;&#20013;&#24237;&#22290;&#20837;&#21475;<br>
	 * Message: Entrance to the Garden of Eva
	 */
	public static final NpcStringId ENTRANCE_TO_THE_GARDEN_OF_EVA;
	
	/**
	 * ID: 1010520<br>
	 * Message: NR_C AChk<br>
	 * Message: &#40055;&#39770;&#23798;&#21271;&#26041;<br>
	 * Message: Northern part of Alligator Island
	 */
	public static final NpcStringId NORTHERN_PART_OF_ALLIGATOR_ISLAND;
	
	/**
	 * ID: 1010521<br>
	 * Message: NR_C ACh<br>
	 * Message: &#40055;&#39770;&#23798;&#20013;&#22830;<br>
	 * Message: Central part of Alligator Island
	 */
	public static final NpcStringId CENTRAL_PART_OF_ALLIGATOR_ISLAND;
	
	/**
	 * ID: 1010522<br>
	 * Message: G@̐뉀2K<br>
	 * Message: &#20234;&#23043;&#30340;&#27700;&#20013;&#24237;&#22290;&#50;&#27155;<br>
	 * Message: Garden of Eva - 2nd Level
	 */
	public static final NpcStringId GARDEN_OF_EVA_2ND_LEVEL;
	
	/**
	 * ID: 1010523<br>
	 * Message: G@̐뉀3K<br>
	 * Message: &#20234;&#23043;&#30340;&#27700;&#20013;&#24237;&#22290;&#51;&#27155;<br>
	 * Message: Garden of Eva - 3rd Level
	 */
	public static final NpcStringId GARDEN_OF_EVA_3RD_LEVEL;
	
	/**
	 * ID: 1010524<br>
	 * Message: G@̐뉀4K<br>
	 * Message: &#20234;&#23043;&#30340;&#27700;&#20013;&#24237;&#22290;&#52;&#27155;<br>
	 * Message: Garden of Eva - 4th Level
	 */
	public static final NpcStringId GARDEN_OF_EVA_4TH_LEVEL;
	
	/**
	 * ID: 1010525<br>
	 * Message: G@̐뉀5K<br>
	 * Message: &#20234;&#23043;&#30340;&#27700;&#20013;&#24237;&#22290;&#53;&#27155;<br>
	 * Message: Garden of Eva - 5th Level
	 */
	public static final NpcStringId GARDEN_OF_EVA_5TH_LEVEL;
	
	/**
	 * ID: 1010526<br>
	 * Message: G@̐뉀<br>
	 * Message: &#20234;&#23043;&#30340;&#27700;&#20013;&#24237;&#22290;&#20839;&#37096;<br>
	 * Message: Inside the Garden of Eva
	 */
	public static final NpcStringId INSIDE_THE_GARDEN_OF_EVA;
	
	/**
	 * ID: 1010527<br>
	 * Message: l_<br>
	 * Message: &#22235;&#22823;&#38517;&#22675;<br>
	 * Message: Four Sepulchers
	 */
	public static final NpcStringId FOUR_SEPULCHERS;
	
	/**
	 * ID: 1010528<br>
	 * Message: 鍑̕n<br>
	 * Message: &#24093;&#22283;&#20043;&#22675;<br>
	 * Message: Imperial Tomb
	 */
	public static final NpcStringId IMPERIAL_TOMB;
	
	/**
	 * ID: 1010529<br>
	 * Message: ̎Qqn<br>
	 * Message: &#35576;&#20399;&#30340;&#32854;&#22727;<br>
	 * Message: Shrine of Loyalty
	 */
	public static final NpcStringId SHRINE_OF_LOYALTY;
	
	/**
	 * ID: 1010530<br>
	 * Message: _X̉Δ<br>
	 * Message: &#35576;&#31070;&#30340;&#29076;&#29200;&#20837;&#21475;<br>
	 * Message: Entrance to the Forge of the Gods
	 */
	public static final NpcStringId ENTRANCE_TO_THE_FORGE_OF_THE_GODS;
	
	/**
	 * ID: 1010531<br>
	 * Message: _X̉Δw<br>
	 * Message: &#35576;&#31070;&#30340;&#29076;&#29200;&#19978;&#23652;<br>
	 * Message: Forge of the Gods - Top Level
	 */
	public static final NpcStringId FORGE_OF_THE_GODS_TOP_LEVEL;
	
	/**
	 * ID: 1010532<br>
	 * Message: _X̉Δw<br>
	 * Message: &#35576;&#31070;&#30340;&#29076;&#29200;&#19979;&#23652;<br>
	 * Message: Forge of the Gods - Lower Level
	 */
	public static final NpcStringId FORGE_OF_THE_GODS_LOWER_LEVEL;
	
	/**
	 * ID: 1010533<br>
	 * Message: ASX̕Ǔ<br>
	 * Message: &#20126;&#29246;&#21476;&#26031;&#20043;&#22721;&#20837;&#21475;<br>
	 * Message: Entrance to the Wall of Argos
	 */
	public static final NpcStringId ENTRANCE_TO_THE_WALL_OF_ARGOS;
	
	/**
	 * ID: 1010534<br>
	 * Message: oJ VmX BbW<br>
	 * Message: &#24052;&#29790;&#21345;&#36093;&#21202;&#35582;&#26031;&#37096;&#33853;<br>
	 * Message: Varka Silenos Village
	 */
	public static final NpcStringId VARKA_SILENOS_VILLAGE;
	
	/**
	 * ID: 1010535<br>
	 * Message: Pg[ I[N BbW<br>
	 * Message: &#32943;&#29305;&#25289;&#29560;&#20154;&#37096;&#33853;<br>
	 * Message: Ketra Orc Village
	 */
	public static final NpcStringId KETRA_ORC_VILLAGE;
	
	/**
	 * ID: 1010536<br>
	 * Message: nѓ<br>
	 * Message: &#28331;&#27849;&#22320;&#24118;&#20837;&#21475;<br>
	 * Message: Entrance to the Hot Springs Region
	 */
	public static final NpcStringId ENTRANCE_TO_THE_HOT_SPRINGS_REGION;
	
	/**
	 * ID: 1010537<br>
	 * Message: ҏb̕qn<br>
	 * Message: &#29467;&#29560;&#25918;&#29287;&#22580;<br>
	 * Message: Wild Beast Pastures
	 */
	public static final NpcStringId WILD_BEAST_PASTURES;
	
	/**
	 * ID: 1010538<br>
	 * Message: ҂̌kJ<br>
	 * Message: &#32854;&#32773;&#20043;&#35895;&#20837;&#21475;<br>
	 * Message: Entrance to the Valley of Saints
	 */
	public static final NpcStringId ENTRANCE_TO_THE_VALLEY_OF_SAINTS;
	
	/**
	 * ID: 1010539<br>
	 * Message: ꂽ<br>
	 * Message: &#21463;&#35419;&#21650;&#30340;&#26449;&#33674;<br>
	 * Message: Cursed Village
	 */
	public static final NpcStringId CURSED_VILLAGE;
	
	/**
	 * ID: 1010540<br>
	 * Message: ҏb̕qn̓<br>
	 * Message: &#29467;&#29560;&#25918;&#29287;&#22580;&#21335;&#26041;&#20837;&#21475;<br>
	 * Message: Southern Entrance of the Wild Beast Pastures
	 */
	public static final NpcStringId SOUTHERN_ENTRANCE_OF_THE_WILD_BEAST_PASTURES;
	
	/**
	 * ID: 1010541<br>
	 * Message: ҏb̕qn<br>
	 * Message: &#29467;&#29560;&#25918;&#29287;&#22580;&#26481;&#26041;<br>
	 * Message: Eastern Part of the Wild Beast Pastures
	 */
	public static final NpcStringId EASTERN_PART_OF_THE_WILD_BEAST_PASTURES;
	
	/**
	 * ID: 1010542<br>
	 * Message: ҏb̕qn<br>
	 * Message: &#29467;&#29560;&#25918;&#29287;&#22580;&#35199;&#26041;<br>
	 * Message: Western Part of the Wild Beast Pastures
	 */
	public static final NpcStringId WESTERN_PART_OF_THE_WILD_BEAST_PASTURES;
	
	/**
	 * ID: 1010543<br>
	 * Message: ߖ̏<br>
	 * Message: &#24754;&#40180;&#30340;&#27836;&#28580;&#26481;&#26041;<br>
	 * Message: Eastern Part of the Swamp of Screams
	 */
	public static final NpcStringId EASTERN_PART_OF_THE_SWAMP_OF_SCREAMS;
	
	/**
	 * ID: 1010544<br>
	 * Message: ߖ̏<br>
	 * Message: &#24754;&#40180;&#30340;&#27836;&#28580;&#35199;&#26041;<br>
	 * Message: Western Part of the Swamp of Screams
	 */
	public static final NpcStringId WESTERN_PART_OF_THE_SWAMP_OF_SCREAMS;
	
	/**
	 * ID: 1010545<br>
	 * Message: ߖ̏<br>
	 * Message: &#24754;&#40180;&#30340;&#27836;&#28580;&#20013;&#22830;<br>
	 * Message: Center of the Swamp of Screams
	 */
	public static final NpcStringId CENTER_OF_THE_SWAMP_OF_SCREAMS;
	
	/**
	 * ID: 1010547<br>
	 * Message: Afʍ֖<br>
	 * Message: &#20126;&#19969;&#26041;&#21521;&#30340;&#22283;&#22659;&#38364;&#21475;<br>
	 * Message: Aden Frontier Gateway
	 */
	public static final NpcStringId ADEN_FRONTIER_GATEWAY;
	
	/**
	 * ID: 1010548<br>
	 * Message: I[ʍ֖<br>
	 * Message: &#27472;&#29790;&#26041;&#21521;&#30340;&#22283;&#22659;&#38364;&#21475;<br>
	 * Message: Oren Frontier Gateway
	 */
	public static final NpcStringId OREN_FRONTIER_GATEWAY;
	
	/**
	 * ID: 1010549<br>
	 * Message: b̒뉀<br>
	 * Message: &#37326;&#29560;&#30340;&#24237;&#22290;<br>
	 * Message: Garden of Wild Beasts
	 */
	public static final NpcStringId GARDEN_OF_WILD_BEASTS;
	
	/**
	 * ID: 1010550<br>
	 * Message: ֖̊<br>
	 * Message: &#27515;&#38728;&#30340;&#38364;&#21475;<br>
	 * Message: Devil's Pass
	 */
	public static final NpcStringId DEVILS_PASS;
	
	/**
	 * ID: 1010551<br>
	 * Message: e`[WĂŒłB<br>
	 * Message: &#35037;&#22635;&#24392;&#34277;&#20013;&#12290;<br>
	 * Message: The bullets are being loaded.
	 */
	public static final NpcStringId THE_BULLETS_ARE_BEING_LOADED;
	
	/**
	 * ID: 1010552<br>
	 * Message: 荏X^[gł܂B<br>
	 * Message: &#25972;&#40670;&#26178;&#21363;&#21487;&#38283;&#22987;&#12290;<br>
	 * Message: You can start at the scheduled time.
	 */
	public static final NpcStringId YOU_CAN_START_AT_THE_SCHEDULED_TIME;
	
	/**
	 * ID: 1010554<br>
	 * Message: l̓Aw<br>
	 * Message: &#24040;&#20154;&#27934;&#31348;&#19978;&#23652;<br>
	 * Message: Upper Level of The Giant's Cave
	 */
	public static final NpcStringId UPPER_LEVEL_OF_THE_GIANTS_CAVE;
	
	/**
	 * ID: 1010555<br>
	 * Message: l̓Aw<br>
	 * Message: &#24040;&#20154;&#27934;&#31348;&#19979;&#23652;<br>
	 * Message: Lower Level of The Giant's Cave
	 */
	public static final NpcStringId LOWER_LEVEL_OF_THE_GIANTS_CAVE;
	
	/**
	 * ID: 1010556<br>
	 * Message: sł̍k<br>
	 * Message: &#19981;&#28357;&#39640;&#21407;&#21271;&#37096;<br>
	 * Message: Immortal Plateau, Northern Region
	 */
	public static final NpcStringId IMMORTAL_PLATEAU_NORTHERN_REGION;
	
	/**
	 * ID: 1010557<br>
	 * Message: Gẗ<br>
	 * Message: &#31934;&#38728;&#24290;&#22687;<br>
	 * Message: Elven Ruins
	 */
	public static final NpcStringId ELVEN_RUINS;
	
	/**
	 * ID: 1010558<br>
	 * Message: ̂<br>
	 * Message: &#27468;&#21809;&#30340;&#28689;&#24067;<br>
	 * Message: Singing Waterfall
	 */
	public static final NpcStringId SINGING_WATERFALL;
	
	/**
	 * ID: 1010559<br>
	 * Message: b铇̐(k)<br>
	 * Message: &#35498;&#35441;&#20043;&#23798;&#35199;&#37096;&#40;&#21271;&#37002;&#41;<br>
	 * Message: Talking Island, Northern Territory
	 */
	public static final NpcStringId TALKING_ISLAND_NORTHERN_TERRITORY;
	
	/**
	 * ID: 1010560<br>
	 * Message: Gt̒nv<br>
	 * Message: &#31934;&#38728;&#30340;&#22320;&#24213;&#35201;&#22622;<br>
	 * Message: Elven Fortress
	 */
	public static final NpcStringId ELVEN_FORTRESS;
	
	/**
	 * ID: 1010561<br>
	 * Message: ҂̎@<br>
	 * Message: &#24033;&#31150;&#32773;&#23546;&#38498;<br>
	 * Message: Pilgrim's Temple
	 */
	public static final NpcStringId PILGRIMS_TEMPLE;
	
	/**
	 * ID: 1010562<br>
	 * Message: O[fB`<br>
	 * Message: &#21476;&#39791;&#19969;&#28207;&#21475;<br>
	 * Message: Gludin Harbor
	 */
	public static final NpcStringId GLUDIN_HARBOR;
	
	/**
	 * ID: 1010563<br>
	 * Message: V[̒뉀<br>
	 * Message: &#24109;&#29747;&#30340;&#24237;&#22290;<br>
	 * Message: Shilen's Garden
	 */
	public static final NpcStringId SHILENS_GARDEN;
	
	/**
	 * ID: 1010564<br>
	 * Message: @<br>
	 * Message: &#40657;&#39764;&#27861;&#23416;&#38498;<br>
	 * Message: School of Dark Arts
	 */
	public static final NpcStringId SCHOOL_OF_DARK_ARTS;
	
	/**
	 * ID: 1010565<br>
	 * Message: ߖ̏<br>
	 * Message: &#24754;&#40180;&#30340;&#27836;&#28580;<br>
	 * Message: Swamp of Screams
	 */
	public static final NpcStringId SWAMP_OF_SCREAMS;
	
	/**
	 * ID: 1010566<br>
	 * Message: Ȃ<br>
	 * Message: &#34718;&#34811;&#27934;&#31391;<br>
	 * Message: The Ant Nest
	 */
	public static final NpcStringId THE_ANT_NEST;
	
	/**
	 * ID: 1010568<br>
	 * Message: ASX̕<br>
	 * Message: &#20126;&#29246;&#21476;&#26031;&#20043;&#22721;<br>
	 * Message: Wall of Argos
	 */
	public static final NpcStringId WALL_OF_ARGOS;
	
	/**
	 * ID: 1010569<br>
	 * Message: ̐<br>
	 * Message: &#24801;&#38728;&#24034;&#31348;<br>
	 * Message: Den of Evil
	 */
	public static final NpcStringId DEN_OF_EVIL;
	
	/**
	 * ID: 1010570<br>
	 * Message: X̏<br>
	 * Message: &#20912;&#38634;&#21830;&#38538;&#39376;&#32046;&#22320;<br>
	 * Message: Iceman's Hut
	 */
	public static final NpcStringId ICEMANS_HUT;
	
	/**
	 * ID: 1010571<br>
	 * Message: pJ̖n<br>
	 * Message: &#24677;&#36785;&#22675;&#22320;<br>
	 * Message: Crypts of Disgrace
	 */
	public static final NpcStringId CRYPTS_OF_DISGRACE;
	
	/**
	 * ID: 1010572<br>
	 * Message: D̍r<br>
	 * Message: &#25504;&#22890;&#30340;&#33618;&#37326;<br>
	 * Message: Plunderous Plains
	 */
	public static final NpcStringId PLUNDEROUS_PLAINS;
	
	/**
	 * ID: 1010573<br>
	 * Message: pF̈<br>
	 * Message: &#24085;&#27604;&#29246;&#36986;&#36321;<br>
	 * Message: Pavel Ruins
	 */
	public static final NpcStringId PAVEL_RUINS;
	
	/**
	 * ID: 1010574<br>
	 * Message: V`bcKg̑<br>
	 * Message: &#20462;&#21152;&#29305;&#22478;&#37806;<br>
	 * Message: Town of Schuttgart
	 */
	public static final NpcStringId TOWN_OF_SCHUTTGART;
	
	/**
	 * ID: 1010575<br>
	 * Message: ق̏C@<br>
	 * Message: &#27785;&#40664;&#20462;&#36947;&#38498;<br>
	 * Message: Monastery of Silence
	 */
	public static final NpcStringId MONASTERY_OF_SILENCE;
	
	/**
	 * ID: 1010576<br>
	 * Message: ق̏C@<br>
	 * Message: &#27785;&#40664;&#20462;&#36947;&#38498;&#24460;&#38272;<br>
	 * Message: Monastery of Silence: Rear Gate
	 */
	public static final NpcStringId MONASTERY_OF_SILENCE_REAR_GATE;
	
	/**
	 * ID: 1010577<br>
	 * Message: X^bJ[g̑<br>
	 * Message: &#21496;&#22612;&#21345;&#25299;&#24034;&#31348;<br>
	 * Message: Stakato Nest
	 */
	public static final NpcStringId STAKATO_NEST;
	
	/**
	 * ID: 1010578<br>
	 * Message: 䂪̈ɑ𓥂ݓƂ͂xI<br>
	 * Message: &#20320;&#36889;&#20642;&#20249;&#36996;&#30495;&#22823;&#33213;&#65292;&#31455;&#25954;&#20405;&#29359;&#25105;&#30340;&#38936;&#22303;&#65281;<br>
	 * Message: How dare you trespass into my territory! Have you no fear?
	 */
	public static final NpcStringId HOW_DARE_YOU_TRESPASS_INTO_MY_TERRITORY_HAVE_YOU_NO_FEAR;
	
	/**
	 * ID: 1010579<br>
	 * Message: ȁI܂Ă̂Iɂڂɂ悤ȁI<br>
	 * Message: &#24858;&#34850;&#30340;&#20642;&#20249;&#65281;&#31455;&#28982;&#36996;&#27794;&#36867;&#36305;&#65311;&#65281;&#23601;&#35731;&#20320;&#20497;&#30631;&#30631;&#25105;&#30340;&#21426;&#23475;&#65281;<br>
	 * Message: Fools! Why haven't you fled yet? Prepare to learn a lesson!
	 */
	public static final NpcStringId FOOLS_WHY_HAVENT_YOU_FLED_YET_PREPARE_TO_LEARN_A_LESSON;
	
	/**
	 * ID: 1010580<br>
	 * Message: ӂ͂́AĂIEg X[p[KEI閧oI<br>
	 * Message: &#21628;&#21628;&#65292;&#30631;&#33879;&#21543;&#65281;&#26368;&#32066;&#26368;&#24460;&#26368;&#24375;&#26368;&#24801;&#30340;&#126;&#126;&#31061;&#23494;&#27494;&#22120;&#23559;&#20986;&#25802;&#21862;&#65281;<br>
	 * Message: Bwah-ha-ha! Your doom is at hand! Behold the Ultra Secret Super Weapon!
	 */
	public static final NpcStringId BWAH_HA_HA_YOUR_DOOM_IS_AT_HAND_BEHOLD_THE_ULTRA_SECRET_SUPER_WEAPON;
	
	/**
	 * ID: 1010581<br>
	 * Message: Ύ~IɒނƂ́I<br>
	 * Message: &#19981;&#30693;&#22825;&#39640;&#22320;&#21402;&#30340;&#20642;&#20249;&#65281;&#33213;&#25954;&#21521;&#25105;&#25361;&#25136;&#65281;<br>
	 * Message: Foolish, insignificant creatures! How dare you challenge me!
	 */
	public static final NpcStringId FOOLISH_INSIGNIFICANT_CREATURES_HOW_DARE_YOU_CHALLENGE_ME;
	
	/**
	 * ID: 1010582<br>
	 * Message: ǂH܂B<br>
	 * Message: &#30475;&#20358;&#27794;&#20154;&#25954;&#20877;&#25361;&#25136;&#20102;&#12290;<br>
	 * Message: I see that none will challenge me now!
	 */
	public static final NpcStringId I_SEE_THAT_NONE_WILL_CHALLENGE_ME_NOW;
	
	/**
	 * ID: 1010583<br>
	 * Message: AMlDDDoĂDDD<br>
	 * Message: &#21571;&#65292;&#20320;&#20497;&#36889;&#20123;&#20642;&#20249;&#46;&#46;&#46;&#36208;&#33879;&#30631;&#46;&#46;&#46;<br>
	 * Message: Urggh! You will pay dearly for this insult.
	 */
	public static final NpcStringId URGGH_YOU_WILL_PAY_DEARLY_FOR_THIS_INSULT;
	
	/**
	 * ID: 1010584<br>
	 * Message: Ȃ񂾁AꕶB`FbB<br>
	 * Message: &#20160;&#40636;&#22043;&#65292;&#26159;&#20491;&#31406;&#20809;&#34507;&#21834;&#65292;&#21756;&#33;<br>
	 * Message: What? You haven't even two pennies to rub together? Harumph!
	 */
	public static final NpcStringId WHAT_YOU_HAVENT_EVEN_TWO_PENNIES_TO_RUB_TOGETHER_HARUMPH;
	
	/**
	 * ID: 1010585<br>
	 * Message: ̐X<br>
	 * Message: &#37857;&#20043;&#26862;&#26519;<br>
	 * Message: Forest of Mirrors
	 */
	public static final NpcStringId FOREST_OF_MIRRORS;
	
	/**
	 * ID: 1010586<br>
	 * Message: ̐X̒S<br>
	 * Message: &#37857;&#20043;&#26862;&#26519;&#20013;&#24515;<br>
	 * Message: The Center of the Forest of Mirrors
	 */
	public static final NpcStringId THE_CENTER_OF_THE_FOREST_OF_MIRRORS;
	
	/**
	 * ID: 1010588<br>
	 * Message: 󒆗Ԃ̈<br>
	 * Message: &#31354;&#20013;&#21015;&#36554;&#36986;&#36321;<br>
	 * Message: Sky Wagon Relic
	 */
	public static final NpcStringId SKY_WAGON_RELIC;
	
	/**
	 * ID: 1010590<br>
	 * Message: _[NGt̐X̒S<br>
	 * Message: &#40657;&#26263;&#31934;&#38728;&#26862;&#26519;&#20013;&#24515;<br>
	 * Message: The Center of the Dark Forest
	 */
	public static final NpcStringId THE_CENTER_OF_THE_DARK_FOREST;
	
	/**
	 * ID: 1010591<br>
	 * Message: @̐<br>
	 * Message: &#30428;&#22675;&#32773;&#24034;&#31348;<br>
	 * Message: Grave Robber Hideout
	 */
	public static final NpcStringId GRAVE_ROBBER_HIDEOUT;
	
	/**
	 * ID: 1010592<br>
	 * Message: S҂̐X<br>
	 * Message: &#20129;&#32773;&#30340;&#26862;&#26519;<br>
	 * Message: Forest of the Dead
	 */
	public static final NpcStringId FOREST_OF_THE_DEAD;
	
	/**
	 * ID: 1010593<br>
	 * Message: S҂̐X̒S<br>
	 * Message: &#20129;&#32773;&#30340;&#26862;&#26519;&#20013;&#24515;<br>
	 * Message: The Center of the Forest of the Dead
	 */
	public static final NpcStringId THE_CENTER_OF_THE_FOREST_OF_THE_DEAD;
	
	/**
	 * ID: 1010594<br>
	 * Message: ~XzR<br>
	 * Message: &#31859;&#32034;&#33673;&#31014;&#23665;<br>
	 * Message: Mithril Mines
	 */
	public static final NpcStringId MITHRIL_MINES;
	
	/**
	 * ID: 1010595<br>
	 * Message: ~XzR̒S<br>
	 * Message: &#31859;&#32034;&#33673;&#31014;&#23665;&#20013;&#24515;<br>
	 * Message: The Center of the Mithril Mines
	 */
	public static final NpcStringId THE_CENTER_OF_THE_MITHRIL_MINES;
	
	/**
	 * ID: 1010596<br>
	 * Message: ̂ĂꂽYz<br>
	 * Message: &#24290;&#26820;&#30340;&#31014;&#22353;<br>
	 * Message: Abandoned Coal Mines
	 */
	public static final NpcStringId ABANDONED_COAL_MINES;
	
	/**
	 * ID: 1010597<br>
	 * Message: ̂ĂꂽYz̒S<br>
	 * Message: &#24290;&#26820;&#30340;&#31014;&#22353;&#20013;&#24515;<br>
	 * Message: The Center of the Abandoned Coal Mines
	 */
	public static final NpcStringId THE_CENTER_OF_THE_ABANDONED_COAL_MINES;
	
	/**
	 * ID: 1010598<br>
	 * Message: sł̍<br>
	 * Message: &#19981;&#28357;&#39640;&#21407;&#35199;&#37096;<br>
	 * Message: Immortal Plateau, Western Region
	 */
	public static final NpcStringId IMMORTAL_PLATEAU_WESTERN_REGION;
	
	/**
	 * ID: 1010600<br>
	 * Message: ҂̌kJ<br>
	 * Message: &#32854;&#32773;&#20043;&#35895;<br>
	 * Message: Valley of Saints
	 */
	public static final NpcStringId VALLEY_OF_SAINTS;
	
	/**
	 * ID: 1010601<br>
	 * Message: ҂̌kJ̒S<br>
	 * Message: &#32854;&#32773;&#20043;&#35895;&#20013;&#24515;<br>
	 * Message: The Center of the Valley of Saints
	 */
	public static final NpcStringId THE_CENTER_OF_THE_VALLEY_OF_SAINTS;
	
	/**
	 * ID: 1010603<br>
	 * Message: ̓A<br>
	 * Message: &#35430;&#32244;&#27934;&#31391;<br>
	 * Message: Cave of Trials
	 */
	public static final NpcStringId CAVE_OF_TRIALS;
	
	/**
	 * ID: 1010604<br>
	 * Message: V[̕<br>
	 * Message: &#24109;&#29747;&#23553;&#21360;<br>
	 * Message: Seal of Shilen
	 */
	public static final NpcStringId SEAL_OF_SHILEN;
	
	/**
	 * ID: 1010605<br>
	 * Message: ASX̕ǂ̒S<br>
	 * Message: &#20126;&#29246;&#21476;&#26031;&#20043;&#22721;&#20013;&#24515;<br>
	 * Message: The Center of the Wall of Argos
	 */
	public static final NpcStringId THE_CENTER_OF_THE_WALL_OF_ARGOS;
	
	/**
	 * ID: 1010606<br>
	 * Message: NR_C ACh̒S<br>
	 * Message: &#40055;&#39770;&#23798;&#20013;&#24515;<br>
	 * Message: The Center of Alligator Island
	 */
	public static final NpcStringId THE_CENTER_OF_ALLIGATOR_ISLAND;
	
	/**
	 * ID: 1010607<br>
	 * Message: Aw<br>
	 * Message: &#26114;&#36203;&#28689;&#24067;<br>
	 * Message: Anghel Waterfall
	 */
	public static final NpcStringId ANGHEL_WATERFALL;
	
	/**
	 * ID: 1010608<br>
	 * Message: GẗՂ̒S<br>
	 * Message: &#31934;&#38728;&#24290;&#22687;&#20013;&#24515;<br>
	 * Message: Center of the Elven Ruins
	 */
	public static final NpcStringId CENTER_OF_THE_ELVEN_RUINS;
	
	/**
	 * ID: 1010609<br>
	 * Message: n<br>
	 * Message: &#28331;&#27849;&#22320;&#24118;<br>
	 * Message: Hot Springs
	 */
	public static final NpcStringId HOT_SPRINGS;
	
	/**
	 * ID: 1010610<br>
	 * Message: nђ<br>
	 * Message: &#28331;&#27849;&#22320;&#24118;&#20013;&#24515;<br>
	 * Message: The Center of the Hot Springs
	 */
	public static final NpcStringId THE_CENTER_OF_THE_HOT_SPRINGS;
	
	/**
	 * ID: 1010611<br>
	 * Message: hSo[<br>
	 * Message: &#40845;&#20043;&#35895;&#20013;&#24515;<br>
	 * Message: The Center of Dragon Valley
	 */
	public static final NpcStringId THE_CENTER_OF_DRAGON_VALLEY;
	
	/**
	 * ID: 1010613<br>
	 * Message: nђ<br>
	 * Message: &#20013;&#31435;&#22320;&#24118;&#20013;&#24515;<br>
	 * Message: The Center of the Neutral Zone
	 */
	public static final NpcStringId THE_CENTER_OF_THE_NEUTRAL_ZONE;
	
	/**
	 * ID: 1010614<br>
	 * Message: N}n<br>
	 * Message: &#20811;&#39791;&#29802;&#27836;&#28580;<br>
	 * Message: Cruma Marshlands
	 */
	public static final NpcStringId CRUMA_MARSHLANDS;
	
	/**
	 * ID: 1010615<br>
	 * Message: N}n<br>
	 * Message: &#20811;&#39791;&#29802;&#27836;&#28580;&#20013;&#24515;<br>
	 * Message: The Center of the Cruma Marshlands
	 */
	public static final NpcStringId THE_CENTER_OF_THE_CRUMA_MARSHLANDS;
	
	/**
	 * ID: 1010617<br>
	 * Message: tFA[̒J<br>
	 * Message: &#22934;&#31934;&#35895;&#20013;&#24515;<br>
	 * Message: The Center of the Enchanted Valley
	 */
	public static final NpcStringId THE_CENTER_OF_THE_ENCHANTED_VALLEY;
	
	/**
	 * ID: 1010618<br>
	 * Message: tFA[̒J(쑤)<br>
	 * Message: &#22934;&#31934;&#35895;&#65288;&#21335;&#26041;&#65289;<br>
	 * Message: Enchanted Valley, Southern Region
	 */
	public static final NpcStringId ENCHANTED_VALLEY_SOUTHERN_REGION;
	
	/**
	 * ID: 1010619<br>
	 * Message: tFA[̒J(k)<br>
	 * Message: &#22934;&#31934;&#35895;&#65288;&#21271;&#26041;&#65289;<br>
	 * Message: Enchanted Valley, Northern Region
	 */
	public static final NpcStringId ENCHANTED_VALLEY_NORTHERN_REGION;
	
	/**
	 * ID: 1010620<br>
	 * Message: tXg<br>
	 * Message: &#23506;&#38684;&#20043;&#28246;<br>
	 * Message: Frost Lake
	 */
	public static final NpcStringId FROST_LAKE;
	
	/**
	 * ID: 1010621<br>
	 * Message: rn<br>
	 * Message: &#33618;&#21407;<br>
	 * Message: Wastelands
	 */
	public static final NpcStringId WASTELANDS;
	
	/**
	 * ID: 1010622<br>
	 * Message: rn()<br>
	 * Message: &#33618;&#21407;&#65288;&#35199;&#26041;&#65289;<br>
	 * Message: Wastelands, Western Region
	 */
	public static final NpcStringId WASTELANDS_WESTERN_REGION;
	
	/**
	 * ID: 1010623<br>
	 * Message: 䂪̋ʍ_͉̂zHɗ˂΁AMľĂ̑㏞𕥂Ă炨I<br>
	 * Message: &#26159;&#35504;&#33213;&#25954;&#35244;&#35238;&#22478;&#20027;&#20043;&#20301;&#65281;&#33509;&#19981;&#39340;&#19978;&#36864;&#19979;&#65292;&#23559;&#35201;&#20320;&#20197;&#34880;&#20767;&#21629;&#65281;<br>
	 * Message: Who dares to covet the throne of our castle! Leave immediately or you will pay the price of your audacity with your very own blood!
	 */
	public static final NpcStringId WHO_DARES_TO_COVET_THE_THRONE_OF_OUR_CASTLE_LEAVE_IMMEDIATELY_OR_YOU_WILL_PAY_THE_PRICE_OF_YOUR_AUDACITY_WITH_YOUR_VERY_OWN_BLOOD;
	
	/**
	 * ID: 1010624<br>
	 * Message: قAłȂ҂Ȁ_ĂƁHNNNbDDDS҂̍݁A̗͂𕎂ȁI<br>
	 * Message: &#21756;&#65292;&#38750;&#25105;&#34880;&#26063;&#20043;&#20154;&#31455;&#34909;&#33879;&#36889;&#22478;&#22561;&#32780;&#20358;&#65311;&#21621;&#21621;&#46;&#46;&#46;&#20129;&#32773;&#20497;&#30340;&#24616;&#24680;&#65292;&#21487;&#21029;&#23567;&#30475;&#36889;&#21147;&#37327;&#21734;&#65281;<br>
	 * Message: Hmm, those who are not of the bloodline are coming this way to take over the castle?! Humph! The bitter grudges of the dead. You must not make light of their power!
	 */
	public static final NpcStringId HMM_THOSE_WHO_ARE_NOT_OF_THE_BLOODLINE_ARE_COMING_THIS_WAY_TO_TAKE_OVER_THE_CASTLE_HUMPH_THE_BITTER_GRUDGES_OF_THE_DEAD_YOU_MUST_NOT_MAKE_LIGHT_OF_THEIR_POWER;
	
	/**
	 * ID: 1010625<br>
	 * Message: OIbDDD|΁DDĎEI<br>
	 * Message: &#21571;&#46;&#46;&#46;&#65281;&#33509;&#25105;&#20498;&#19979;&#30340;&#35441;&#65292;&#34880;&#20043;&#32080;&#30028;&#23559;&#46;&#46;&#46;&#65281;<br>
	 * Message: Aargh...! If I die, then the magic force field of blood will...!
	 */
	public static final NpcStringId AARGH_IF_I_DIE_THEN_THE_MAGIC_FORCE_FIELD_OF_BLOOD_WILL;
	
	/**
	 * ID: 1010626<br>
	 * Message: ܂DDDI肶ȂDDDŏI点́DDDȂDDD<br>
	 * Message: &#36996;&#27794;&#32080;&#26463;&#46;&#46;&#46;&#19981;&#26371;&#46;&#46;&#46;&#23601;&#27492;&#46;&#46;&#46;&#32080;&#26463;&#30340;&#46;&#46;&#46;<br>
	 * Message: It's not over yet... It won't be... over... like this... Never...
	 */
	public static final NpcStringId ITS_NOT_OVER_YET_IT_WONT_BE_OVER_LIKE_THIS_NEVER;
	
	/**
	 * ID: 1010627<br>
	 * Message: DDDNAQĂ̂ɓɃlN^[₪́I<br>
	 * Message: &#21978;&#21834;&#46;&#46;&#46;&#30561;&#24471;&#22909;&#22909;&#30340;&#65292;&#26159;&#35504;&#23559;&#31070;&#37202;&#28550;&#22312;&#25105;&#38957;&#19978;&#21834;&#65311;<br>
	 * Message: Oooh! Who poured nectar on my head while I was sleeping?
	 */
	public static final NpcStringId OOOH_WHO_POURED_NECTAR_ON_MY_HEAD_WHILE_I_WAS_SLEEPING;
	
	/**
	 * ID: 1010628<br>
	 * Message: X҂B<br>
	 * Message: &#35531;&#31245;&#20505;&#12290;<br>
	 * Message: Please wait a moment.
	 */
	public static final NpcStringId PLEASE_WAIT_A_MOMENT;
	
	/**
	 * ID: 1010629<br>
	 * Message: Ax$s1ƂP𓖂ĂĂB<br>
	 * Message: &#20358;&#65292;&#36889;&#27425;&#35201;&#29468;&#30340;&#21934;&#23383;&#26159;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: The word you need this time is $s1.
	 */
	public static final NpcStringId THE_WORD_YOU_NEED_THIS_TIME_IS_S1;
	
	/**
	 * ID: 1010630<br>
	 * Message: N҂Ix񑕒u쓮B<br>
	 * Message: &#26377;&#20837;&#20405;&#32773;&#65292;&#21855;&#21205;&#35686;&#22577;&#35037;&#32622;&#12290;<br>
	 * Message: Intruders! Sound the alarm!
	 */
	public static final NpcStringId INTRUDERS_SOUND_THE_ALARM;
	
	/**
	 * ID: 1010631<br>
	 * Message: x<br>
	 * Message: &#35299;&#38500;&#35686;&#22577;&#35037;&#32622;<br>
	 * Message: De-activate the alarm.
	 */
	public static final NpcStringId DE_ACTIVATE_THE_ALARM;
	
	/**
	 * ID: 1010632<br>
	 * Message: ܂DDDh@\Ƃ́DDD̒͊댯IFOցI<br>
	 * Message: &#31967;&#31957;&#46;&#46;&#46;&#38450;&#31142;&#27231;&#33021;&#31455;&#28982;&#28040;&#22833;&#20102;&#46;&#46;&#46;&#22478;&#20839;&#24456;&#21361;&#38570;&#65292;&#20840;&#37096;&#36867;&#21040;&#22478;&#22806;&#21435;&#21543;&#65281;<br>
	 * Message: Oh no! The defenses have failed. It is too dangerous to remain inside the castle. Flee! Every man for himself!
	 */
	public static final NpcStringId OH_NO_THE_DEFENSES_HAVE_FAILED_IT_IS_TOO_DANGEROUS_TO_REMAIN_INSIDE_THE_CASTLE_FLEE_EVERY_MAN_FOR_HIMSELF;
	
	/**
	 * ID: 1010633<br>
	 * Message: Q[X^[gIQꂽ́A\グP[ēĂĂˁB<br>
	 * Message: &#36938;&#25138;&#38283;&#22987;&#65281;&#21508;&#20301;&#21443;&#36093;&#32773;&#35531;&#20180;&#32048;&#30475;&#25105;&#25152;&#35498;&#30340;&#21934;&#23383;&#24460;&#32068;&#21512;&#25343;&#20358;&#21543;&#12290;<br>
	 * Message: The game has begun. Participants, prepare to learn an important word.
	 */
	public static final NpcStringId THE_GAME_HAS_BEGUN_PARTICIPANTS_PREPARE_TO_LEARN_AN_IMPORTANT_WORD;
	
	/**
	 * ID: 1010634<br>
	 * Message: $s1`[ |i̎cHP$s2p[ZgłB<br>
	 * Message: &#30446;&#21069;&#12300;&#36;&#115;&#49;&#12301;&#38538;&#22823;&#33899;&#34310;&#30340;&#21097;&#39192;&#72;&#80;&#28858;&#30334;&#20998;&#20043;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $s1 team's jackpot has $s2 percent of its HP remaining.
	 */
	public static final NpcStringId S1_TEAMS_JACKPOT_HAS_S2_PERCENT_OF_ITS_HP_REMAINING;
	
	/**
	 * ID: 1010635<br>
	 * Message: <br>
	 * Message: &#26410;&#23450;<br>
	 * Message: Undecided
	 */
	public static final NpcStringId UNDECIDED;
	
	/**
	 * ID: 1010636<br>
	 * Message: NNbDDDn܂邼Ǐɐ݂w}Ƃ̎􂢂𖡂킦I<br>
	 * Message: &#21621;&#21621;&#46;&#46;&#46;&#23476;&#26371;&#38283;&#22987;&#20102;&#65281;&#36941;&#20296;&#36889;&#22823;&#22320;&#30340;&#21704;&#26364;&#23478;&#26063;&#20043;&#35419;&#21650;&#65281;&#35258;&#24735;&#21543;&#65281;<br>
	 * Message: Heh Heh... I see that the feast has begun! Be wary! The curse of the Hellmann family has poisoned this land!
	 */
	public static final NpcStringId HEH_HEH_I_SEE_THAT_THE_FEAST_HAS_BEGUN_BE_WARY_THE_CURSE_OF_THE_HELLMANN_FAMILY_HAS_POISONED_THIS_LAND;
	
	/**
	 * ID: 1010637<br>
	 * Message: 肩o߂A䂪ƐbB󂯌p҂A䂪ĂłB̉̎n܂肾I<br>
	 * Message: &#36215;&#20358;&#21543;&#65292;&#23478;&#33251;&#20497;&#21834;&#65292;&#32380;&#25215;&#34880;&#32113;&#30340;&#20154;&#20497;&#21834;&#65292;&#26159;&#25105;&#22899;&#20818;&#30340;&#21484;&#21914;&#12290;&#34880;&#20043;&#39255;&#23476;&#21363;&#23559;&#23637;&#38283;&#65281;<br>
	 * Message: Arise, my faithful servants! You, my people who have inherited the blood. It is the calling of my daughter. The feast of blood will now begin!
	 */
	public static final NpcStringId ARISE_MY_FAITHFUL_SERVANTS_YOU_MY_PEOPLE_WHO_HAVE_INHERITED_THE_BLOOD_IT_IS_THE_CALLING_OF_MY_DAUGHTER_THE_FEAST_OF_BLOOD_WILL_NOW_BEGIN;
	
	/**
	 * ID: 1010639<br>
	 * Message: Ղ`A2xAX^WA̐|s܂BvȂACeĂ͒nʂɎ̂ĂĂB<br>
	 * Message: &#27874;&#25552;&#126;&#29694;&#22312;&#38283;&#22987;&#23559;&#21033;&#29992;&#50;&#20998;&#37912;&#20358;&#28165;&#25475;&#31478;&#25216;&#22580;&#12290;&#33509;&#36523;&#19978;&#26377;&#27794;&#29992;&#30340;&#36947;&#20855;&#65292;&#35531;&#19999;&#22312;&#22320;&#19978;&#12290;<br>
	 * Message: Grarr! For the next 2 minutes or so, the game arena are will be cleaned. Throw any items you don't need to the floor now.
	 */
	public static final NpcStringId GRARR_FOR_THE_NEXT_2_MINUTES_OR_SO_THE_GAME_ARENA_ARE_WILL_BE_CLEANED_THROW_ANY_ITEMS_YOU_DONT_NEED_TO_THE_FLOOR_NOW;
	
	/**
	 * ID: 1010640<br>
	 * Message: Ղ`I$s1`[`[̃GAɉ򗰉gp܂B<br>
	 * Message: &#27874;&#25552;&#126;&#65281;&#12300;&#36;&#115;&#49;&#12301;&#38538;&#25171;&#31639;&#23565;&#20854;&#20182;&#38538;&#20237;&#20351;&#29992;&#28331;&#27849;&#30827;&#30970;&#12290;<br>
	 * Message: Grarr! $s1 team is using the hot springs sulfur on the opponent's camp.
	 */
	public static final NpcStringId GRARR_S1_TEAM_IS_USING_THE_HOT_SPRINGS_SULFUR_ON_THE_OPPONENTS_CAMP;
	
	/**
	 * ID: 1010641<br>
	 * Message: Ղ`I$s1`[|i̓ւ݂܂B<br>
	 * Message: &#27874;&#25552;&#126;&#65281;&#12300;&#36;&#115;&#49;&#12301;&#38538;&#35430;&#22294;&#20599;&#25563;&#22823;&#33899;&#34310;&#21734;&#12290;<br>
	 * Message: Grarr! $s1 team is attempting to steal the jackpot.
	 */
	public static final NpcStringId GRARR_S1_TEAM_IS_ATTEMPTING_TO_STEAL_THE_JACKPOT;
	
	/**
	 * ID: 1010642<br>
	 * Message: ****<br>
	 * Message: &#42;&#42;&#31354;&#20301;&#42;&#42;<br>
	 * Message: ** Vacant Seat **
	 */
	public static final NpcStringId _VACANT_SEAT;
	
	/**
	 * ID: 1010643<br>
	 * Message: c$s1łB<br>
	 * Message: &#21097;&#19979;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#12290;<br>
	 * Message: $s1 minute(s) are remaining.
	 */
	public static final NpcStringId S1_MINUTES_REMAINING;
	
	/**
	 * ID: 1010644<br>
	 * Message: ̒c̃Xe[WԂ󂷂Ƃ́DDDʁI<br>
	 * Message: &#31455;&#25954;&#30776;&#22750;&#40657;&#20043;&#32854;&#27468;&#22296;&#30340;&#33310;&#21488;&#46;&#46;&#25105;&#19981;&#26371;&#25918;&#36942;&#20320;&#30340;&#65281;<br>
	 * Message: How dare you ruin the performance of the Dark Choir... Unforgivable!
	 */
	public static final NpcStringId HOW_DARE_YOU_RUIN_THE_PERFORMANCE_OF_THE_DARK_CHOIR_UNFORGIVABLE;
	
	/**
	 * ID: 1010645<br>
	 * Message: ̒c̉tWז҂I<br>
	 * Message: &#28040;&#28357;&#22952;&#31001;&#40657;&#20043;&#32854;&#27468;&#22296;&#28436;&#22863;&#30340;&#20837;&#20405;&#32773;&#21543;&#65281;<br>
	 * Message: Get rid of the invaders who interrupt the performance of the Dark Choir!
	 */
	public static final NpcStringId GET_RID_OF_THE_INVADERS_WHO_INTERRUPT_THE_PERFORMANCE_OF_THE_DARK_CHOIR;
	
	/**
	 * ID: 1010646<br>
	 * Message: ̉tȂ̂I̒c̋낵ĂI<br>
	 * Message: &#32893;&#35211;&#27515;&#20129;&#30340;&#28436;&#22863;&#20102;&#21966;&#46;&#46;&#35731;&#20182;&#30631;&#30631;&#40657;&#20043;&#32854;&#27468;&#22296;&#30340;&#21426;&#23475;&#21543;&#65281;<br>
	 * Message: Don't you hear the music of death? Reveal the horror of the Dark Choir!
	 */
	public static final NpcStringId DONT_YOU_HEAR_THE_MUSIC_OF_DEATH_REVEAL_THE_HORROR_OF_THE_DARK_CHOIR;
	
	/**
	 * ID: 1010647<br>
	 * Message: sł̍<br>
	 * Message: &#19981;&#28357;&#39640;&#21407;<br>
	 * Message: The Immortal Plateau
	 */
	public static final NpcStringId THE_IMMORTAL_PLATEAU;
	
	/**
	 * ID: 1010648<br>
	 * Message: J}G<br>
	 * Message: &#38343;&#22825;&#20351;&#26449;&#33674;<br>
	 * Message: Kamael Village
	 */
	public static final NpcStringId KAMAEL_VILLAGE;
	
	/**
	 * ID: 1010649<br>
	 * Message: ̓_<br>
	 * Message: &#33521;&#39746;&#20043;&#23798;&#32;&#25818;&#40670;<br>
	 * Message: Isle of Souls Base
	 */
	public static final NpcStringId ISLE_OF_SOULS_BASE;
	
	/**
	 * ID: 1010650<br>
	 * Message: ̋u_<br>
	 * Message: &#40643;&#37329;&#19992;&#38517;&#32;&#25818;&#40670;<br>
	 * Message: Golden Hills Base
	 */
	public static final NpcStringId GOLDEN_HILLS_BASE;
	
	/**
	 * ID: 1010651<br>
	 * Message: ~~̐X_<br>
	 * Message: &#31859;&#23494;&#29246;&#26862;&#26519;&#32;&#25818;&#40670;<br>
	 * Message: Mimir's Forest Base
	 */
	public static final NpcStringId MIMIRS_FOREST_BASE;
	
	/**
	 * ID: 1010652<br>
	 * Message: ̓̍`<br>
	 * Message: &#33521;&#39746;&#20043;&#23798;&#32;&#28207;&#21475;<br>
	 * Message: Isle of Souls Harbor
	 */
	public static final NpcStringId ISLE_OF_SOULS_HARBOR;
	
	/**
	 * ID: 1010653<br>
	 * Message: 1_<br>
	 * Message: &#31532;&#49;&#25818;&#40670;<br>
	 * Message: Stronghold I
	 */
	public static final NpcStringId STRONGHOLD_I;
	
	/**
	 * ID: 1010654<br>
	 * Message: 2_<br>
	 * Message: &#31532;&#50;&#25818;&#40670;<br>
	 * Message: Stronghold II
	 */
	public static final NpcStringId STRONGHOLD_II;
	
	/**
	 * ID: 1010655<br>
	 * Message: 3_<br>
	 * Message: &#31532;&#51;&#25818;&#40670;<br>
	 * Message: Stronghold III
	 */
	public static final NpcStringId STRONGHOLD_III;
	
	/**
	 * ID: 1010656<br>
	 * Message: vǐ<br>
	 * Message: &#35201;&#22622;&#35199;&#38272;<br>
	 * Message: Fortress West Gate
	 */
	public static final NpcStringId FORTRESS_WEST_GATE;
	
	/**
	 * ID: 1010657<br>
	 * Message: vǓ<br>
	 * Message: &#35201;&#22622;&#26481;&#38272;<br>
	 * Message: Fortress East Gate
	 */
	public static final NpcStringId FORTRESS_EAST_GATE;
	
	/**
	 * ID: 1010658<br>
	 * Message: vǖk<br>
	 * Message: &#35201;&#22622;&#21271;&#38272;<br>
	 * Message: Fortress North Gate
	 */
	public static final NpcStringId FORTRESS_NORTH_GATE;
	
	/**
	 * ID: 1010659<br>
	 * Message: vǓ<br>
	 * Message: &#35201;&#22622;&#21335;&#38272;<br>
	 * Message: Fortress South Gate
	 */
	public static final NpcStringId FORTRESS_SOUTH_GATE;
	
	/**
	 * ID: 1010660<br>
	 * Message: kJvǑO<br>
	 * Message: &#23805;&#35895;&#35201;&#22622;&#21069;<br>
	 * Message: Front of the Valley Fortress
	 */
	public static final NpcStringId FRONT_OF_THE_VALLEY_FORTRESS;
	
	/**
	 * ID: 1010661<br>
	 * Message: S_[h̑L<br>
	 * Message: &#39640;&#36948;&#29305;&#22478;&#37806;&#24291;&#22580;<br>
	 * Message: Goddard Town Square
	 */
	public static final NpcStringId GODDARD_TOWN_SQUARE;
	
	/**
	 * ID: 1010662<br>
	 * Message: S_[hO<br>
	 * Message: &#39640;&#36948;&#29305;&#22478;&#38272;&#21069;<br>
	 * Message: Front of the Goddard Castle Gate
	 */
	public static final NpcStringId FRONT_OF_THE_GODDARD_CASTLE_GATE;
	
	/**
	 * ID: 1010663<br>
	 * Message: O[fBȊL<br>
	 * Message: &#21476;&#39791;&#19969;&#22478;&#37806;&#24291;&#22580;<br>
	 * Message: Gludio Town Square
	 */
	public static final NpcStringId GLUDIO_TOWN_SQUARE;
	
	/**
	 * ID: 1010664<br>
	 * Message: O[fBIO<br>
	 * Message: &#21476;&#39791;&#19969;&#22478;&#37806;&#22478;&#38272;&#21069;<br>
	 * Message: Front of the Gludio Castle Gate
	 */
	public static final NpcStringId FRONT_OF_THE_GLUDIO_CASTLE_GATE;
	
	/**
	 * ID: 1010665<br>
	 * Message: M̑L<br>
	 * Message: &#22855;&#23721;&#22478;&#37806;&#24291;&#22580;<br>
	 * Message: Giran Town Square
	 */
	public static final NpcStringId GIRAN_TOWN_SQUARE;
	
	/**
	 * ID: 1010666<br>
	 * Message: MO<br>
	 * Message: &#22855;&#23721;&#22478;&#37806;&#22478;&#38272;&#21069;<br>
	 * Message: Front of the Giran Castle Gate
	 */
	public static final NpcStringId FRONT_OF_THE_GIRAN_CASTLE_GATE;
	
	/**
	 * ID: 1010667<br>
	 * Message: 암vǑO<br>
	 * Message: &#21335;&#37096;&#35201;&#22622;&#21069;<br>
	 * Message: Front of the Southern Fortress
	 */
	public static final NpcStringId FRONT_OF_THE_SOUTHERN_FORTRESS;
	
	/**
	 * ID: 1010668<br>
	 * Message: nїvǑO<br>
	 * Message: &#27836;&#28580;&#35201;&#22622;&#21069;<br>
	 * Message: Front of the Swamp Fortress
	 */
	public static final NpcStringId FRONT_OF_THE_SWAMP_FORTRESS;
	
	/**
	 * ID: 1010669<br>
	 * Message: fBȊL<br>
	 * Message: &#29380;&#24681;&#22478;&#37806;&#24291;&#22580;<br>
	 * Message: Dion Town Square
	 */
	public static final NpcStringId DION_TOWN_SQUARE;
	
	/**
	 * ID: 1010670<br>
	 * Message: fBIO<br>
	 * Message: &#29380;&#24681;&#22478;&#37806;&#22478;&#38272;&#21069;<br>
	 * Message: Front of the Dion Castle Gate
	 */
	public static final NpcStringId FRONT_OF_THE_DION_CASTLE_GATE;
	
	/**
	 * ID: 1010671<br>
	 * Message: ȆL<br>
	 * Message: &#39791;&#22240;&#22478;&#37806;&#24291;&#22580;<br>
	 * Message: Rune Town Square
	 */
	public static final NpcStringId RUNE_TOWN_SQUARE;
	
	/**
	 * ID: 1010672<br>
	 * Message: EO<br>
	 * Message: &#39791;&#22240;&#22478;&#37806;&#22478;&#38272;&#21069;<br>
	 * Message: Front of the Rune Castle Gate
	 */
	public static final NpcStringId FRONT_OF_THE_RUNE_CASTLE_GATE;
	
	/**
	 * ID: 1010673<br>
	 * Message: lvǑO<br>
	 * Message: &#30333;&#27801;&#28760;&#35201;&#22622;&#21069;<br>
	 * Message: Front of the White Sand Fortress
	 */
	public static final NpcStringId FRONT_OF_THE_WHITE_SAND_FORTRESS;
	
	/**
	 * ID: 1010674<br>
	 * Message: ~nvǑO<br>
	 * Message: &#30406;&#22320;&#35201;&#22622;&#21069;<br>
	 * Message: Front of the Basin Fortress
	 */
	public static final NpcStringId FRONT_OF_THE_BASIN_FORTRESS;
	
	/**
	 * ID: 1010675<br>
	 * Message: ۉ̓vǑO<br>
	 * Message: &#35937;&#29273;&#22612;&#35201;&#22622;&#21069;<br>
	 * Message: Front of the Ivory Fortress
	 */
	public static final NpcStringId FRONT_OF_THE_IVORY_FORTRESS;
	
	/**
	 * ID: 1010676<br>
	 * Message: V`bcKg̑L<br>
	 * Message: &#20462;&#21152;&#29305;&#22478;&#37806;&#24291;&#22580;<br>
	 * Message: Schuttgart Town Square
	 */
	public static final NpcStringId SCHUTTGART_TOWN_SQUARE;
	
	/**
	 * ID: 1010677<br>
	 * Message: V`bcKgO<br>
	 * Message: &#20462;&#21152;&#29305;&#22478;&#37806;&#22478;&#38272;&#21069;<br>
	 * Message: Front of the Schuttgart Castle Gate
	 */
	public static final NpcStringId FRONT_OF_THE_SCHUTTGART_CASTLE_GATE;
	
	/**
	 * ID: 1010678<br>
	 * Message: Af̑L<br>
	 * Message: &#20126;&#19969;&#22478;&#37806;&#24291;&#22580;<br>
	 * Message: Aden Town Square
	 */
	public static final NpcStringId ADEN_TOWN_SQUARE;
	
	/**
	 * ID: 1010679<br>
	 * Message: AfO<br>
	 * Message: &#20126;&#19969;&#22478;&#37806;&#22478;&#38272;&#21069;<br>
	 * Message: Front of the Aden Castle Gate
	 */
	public static final NpcStringId FRONT_OF_THE_ADEN_CASTLE_GATE;
	
	/**
	 * ID: 1010680<br>
	 * Message: IcnvǑO<br>
	 * Message: &#37326;&#29151;&#35201;&#22622;&#21069;<br>
	 * Message: Front of the Shanty Fortress
	 */
	public static final NpcStringId FRONT_OF_THE_SHANTY_FORTRESS;
	
	/**
	 * ID: 1010681<br>
	 * Message: I[̑L<br>
	 * Message: &#27472;&#29790;&#22478;&#37806;&#24291;&#22580;<br>
	 * Message: Oren Town Square
	 */
	public static final NpcStringId OREN_TOWN_SQUARE;
	
	/**
	 * ID: 1010682<br>
	 * Message: I[O<br>
	 * Message: &#27472;&#29790;&#22478;&#37806;&#22478;&#38272;&#21069;<br>
	 * Message: Front of the Oren Castle Gate
	 */
	public static final NpcStringId FRONT_OF_THE_OREN_CASTLE_GATE;
	
	/**
	 * ID: 1010683<br>
	 * Message: ՗vǑO<br>
	 * Message: &#36986;&#36447;&#35201;&#22622;&#21069;<br>
	 * Message: Front of the Archaic Fortress
	 */
	public static final NpcStringId FRONT_OF_THE_ARCHAIC_FORTRESS;
	
	/**
	 * ID: 1010684<br>
	 * Message: CihO<br>
	 * Message: &#22240;&#32013;&#24471;&#31435;&#22478;&#38272;&#21069;<br>
	 * Message: Front of the Innadril Castle Gate
	 */
	public static final NpcStringId FRONT_OF_THE_INNADRIL_CASTLE_GATE;
	
	/**
	 * ID: 1010685<br>
	 * Message: AEg|XgvǑO<br>
	 * Message: &#21069;&#21736;&#22522;&#22320;&#35201;&#22622;&#21069;<br>
	 * Message: Front of the Border Fortress
	 */
	public static final NpcStringId FRONT_OF_THE_BORDER_FORTRESS;
	
	/**
	 * ID: 1010686<br>
	 * Message: ssnClXL<br>
	 * Message: &#28023;&#38899;&#26031;&#26449;&#33674;&#24291;&#22580;<br>
	 * Message: Heine Town Square
	 */
	public static final NpcStringId HEINE_TOWN_SQUARE;
	
	/**
	 * ID: 1010687<br>
	 * Message: nCvǑO<br>
	 * Message: &#34562;&#31401;&#35201;&#22622;&#21069;<br>
	 * Message: Front of the Hive Fortress
	 */
	public static final NpcStringId FRONT_OF_THE_HIVE_FORTRESS;
	
	/**
	 * ID: 1010688<br>
	 * Message: ΂̗vǑO<br>
	 * Message: &#28246;&#27850;&#35201;&#22622;&#21069;<br>
	 * Message: Front of the Narsell Fortress
	 */
	public static final NpcStringId FRONT_OF_THE_NARSELL_FORTRESS;
	
	/**
	 * ID: 1010689<br>
	 * Message: O[fBȊO<br>
	 * Message: &#21476;&#39791;&#19969;&#22478;&#21069;<br>
	 * Message: Front of the Gludio Castle
	 */
	public static final NpcStringId FRONT_OF_THE_GLUDIO_CASTLE;
	
	/**
	 * ID: 1010690<br>
	 * Message: fBȊO<br>
	 * Message: &#29380;&#24681;&#22478;&#21069;<br>
	 * Message: Front of the Dion Castle
	 */
	public static final NpcStringId FRONT_OF_THE_DION_CASTLE;
	
	/**
	 * ID: 1010691<br>
	 * Message: M̑O<br>
	 * Message: &#22855;&#23721;&#22478;&#21069;<br>
	 * Message: Front of the Giran Castle
	 */
	public static final NpcStringId FRONT_OF_THE_GIRAN_CASTLE;
	
	/**
	 * ID: 1010692<br>
	 * Message: I[̑O<br>
	 * Message: &#27472;&#29790;&#22478;&#21069;<br>
	 * Message: Front of the Oren Castle
	 */
	public static final NpcStringId FRONT_OF_THE_OREN_CASTLE;
	
	/**
	 * ID: 1010693<br>
	 * Message: Af̑O<br>
	 * Message: &#20126;&#19969;&#22478;&#21069;<br>
	 * Message: Front of the Aden Castle
	 */
	public static final NpcStringId FRONT_OF_THE_ADEN_CASTLE;
	
	/**
	 * ID: 1010694<br>
	 * Message: Cih̑O<br>
	 * Message: &#22240;&#32013;&#24471;&#31435;&#22478;&#21069;<br>
	 * Message: Front of the Innadril Castle
	 */
	public static final NpcStringId FRONT_OF_THE_INNADRIL_CASTLE;
	
	/**
	 * ID: 1010695<br>
	 * Message: S_[h̑O<br>
	 * Message: &#39640;&#36948;&#29305;&#22478;&#21069;<br>
	 * Message: Front of the Goddard Castle
	 */
	public static final NpcStringId FRONT_OF_THE_GODDARD_CASTLE;
	
	/**
	 * ID: 1010696<br>
	 * Message: ȆO<br>
	 * Message: &#39791;&#22240;&#22478;&#21069;<br>
	 * Message: Front of the Rune Castle
	 */
	public static final NpcStringId FRONT_OF_THE_RUNE_CASTLE;
	
	/**
	 * ID: 1010697<br>
	 * Message: V`bcKg̑O<br>
	 * Message: &#20462;&#21152;&#29305;&#22478;&#21069;<br>
	 * Message: Front of the Schuttgart Castle
	 */
	public static final NpcStringId FRONT_OF_THE_SCHUTTGART_CASTLE;
	
	/**
	 * ID: 1010698<br>
	 * Message: Â̓D<br>
	 * Message: &#21407;&#22987;&#20043;&#23798;&#30908;&#38957;<br>
	 * Message: Primeval Isle Wharf
	 */
	public static final NpcStringId PRIMEVAL_ISLE_WHARF;
	
	/**
	 * ID: 1010699<br>
	 * Message: _̓<br>
	 * Message: &#31070;&#35565;&#20043;&#23798;<br>
	 * Message: Isle of Prayer
	 */
	public static final NpcStringId ISLE_OF_PRAYER;
	
	/**
	 * ID: 1010700<br>
	 * Message: ~XzR̐<br>
	 * Message: &#31859;&#32034;&#33673;&#31014;&#23665;&#35199;&#37002;&#20837;&#21475;<br>
	 * Message: Mithril Mines Western Entrance
	 */
	public static final NpcStringId MITHRIL_MINES_WESTERN_ENTRANCE;
	
	/**
	 * ID: 1010701<br>
	 * Message: ~XzR̖k<br>
	 * Message: &#31859;&#32034;&#33673;&#31014;&#23665;&#21271;&#37002;&#20837;&#21475;<br>
	 * Message: Mithril Mines Eastern Entrance
	 */
	public static final NpcStringId MITHRIL_MINES_EASTERN_ENTRANCE;
	
	/**
	 * ID: 1010702<br>
	 * Message: l̓Aw<br>
	 * Message: &#24040;&#20154;&#27934;&#31348;&#19978;&#23652;<br>
	 * Message: The Giant's Cave Upper Layer
	 */
	public static final NpcStringId THE_GIANTS_CAVE_UPPER_LAYER;
	
	/**
	 * ID: 1010703<br>
	 * Message: l̓Aw<br>
	 * Message: &#24040;&#20154;&#27934;&#31348;&#19979;&#23652;<br>
	 * Message: The Giant's Cave Lower Layer
	 */
	public static final NpcStringId THE_GIANTS_CAVE_LOWER_LAYER;
	
	/**
	 * ID: 1010704<br>
	 * Message: Î̑̒S<br>
	 * Message: &#23527;&#38748;&#24179;&#21407;&#30340;&#20013;&#24515;<br>
	 * Message: Field of Silence Center
	 */
	public static final NpcStringId FIELD_OF_SILENCE_CENTER;
	
	/**
	 * ID: 1010705<br>
	 * Message: ̑̒S<br>
	 * Message: &#32048;&#35486;&#24179;&#21407;&#30340;&#20013;&#24515;<br>
	 * Message: Field of Whispers Center
	 */
	public static final NpcStringId FIELD_OF_WHISPERS_CENTER;
	
	/**
	 * ID: 1010706<br>
	 * Message: VCh̐ݏ<br>
	 * Message: &#22799;&#20234;&#24503;&#23621;&#25152;<br>
	 * Message: Shyeed's Cavern
	 */
	public static final NpcStringId SHYEEDS_CAVERN;
	
	/**
	 * ID: 1010709<br>
	 * Message: sł̎D<br>
	 * Message: &#19981;&#28357;&#20043;&#31278;&#30908;&#38957;<br>
	 * Message: Seed of Infinity Dock
	 */
	public static final NpcStringId SEED_OF_INFINITY_DOCK;
	
	/**
	 * ID: 1010710<br>
	 * Message: jł̎D<br>
	 * Message: &#30772;&#28357;&#20043;&#31278;&#30908;&#38957;<br>
	 * Message: Seed of Destruction Dock
	 */
	public static final NpcStringId SEED_OF_DESTRUCTION_DOCK;
	
	/**
	 * ID: 1010711<br>
	 * Message: ł̎D<br>
	 * Message: &#27524;&#28357;&#20043;&#31278;&#30908;&#38957;<br>
	 * Message: Seed of Annihilation Dock
	 */
	public static final NpcStringId SEED_OF_ANNIHILATION_DOCK;
	
	/**
	 * ID: 1010712<br>
	 * Message: Af̑̃ACnU[h_aɂ_Ebh<br>
	 * Message: &#20126;&#19969;&#22478;&#37806;&#27575;&#28023;&#34217;&#31070;&#27583;&#30340;&#31070;&#23448;&#32;&#24043;&#24503;<br>
	 * Message: Town of Aden Einhasad Temple Priest Wood
	 */
	public static final NpcStringId TOWN_OF_ADEN_EINHASAD_TEMPLE_PRIEST_WOOD;
	
	/**
	 * ID: 1010713<br>
	 * Message: t̑ɂ邿ɂȂ̑O<br>
	 * Message: &#29557;&#20154;&#26449;&#33674;&#20998;&#38626;&#30340;&#38728;&#39746;&#30340;&#21069;&#26041;<br>
	 * Message: Hunter's Village Separated Soul Front
	 */
	public static final NpcStringId HUNTERS_VILLAGE_SEPARATED_SOUL_FRONT;
	
	/**
	 * ID: 1029350<br>
	 * Message: ̍܂ŉẮHl҂ɂI<br>
	 * Message: &#20320;&#24590;&#40636;&#29694;&#22312;&#25165;&#20358;&#21834;&#65311;&#25105;&#31561;&#20102;&#22909;&#20037;&#21602;&#12290;<br>
	 * Message: What took so long? I waited for ever.
	 */
	public static final NpcStringId WHAT_TOOK_SO_LONG_I_WAITED_FOR_EVER;
	
	/**
	 * ID: 1029351<br>
	 * Message: {̂Ƃ͐}ْ\tBAɕāB<br>
	 * Message: &#24517;&#38920;&#21521;&#22294;&#26360;&#39208;&#38263;&#32;&#32034;&#27604;&#20126;&#35426;&#21839;&#26377;&#38364;&#26360;&#26412;&#30340;&#20107;&#24773;&#25165;&#34892;&#12290;<br>
	 * Message: I must ask Librarian Sophia about the book.
	 */
	public static final NpcStringId I_MUST_ASK_LIBRARIAN_SOPHIA_ABOUT_THE_BOOK;
	
	/**
	 * ID: 1029352<br>
	 * Message: ̐}فAfJŖɗ{͂܂ȂˁB<br>
	 * Message: &#36889;&#20491;&#22294;&#26360;&#39208;&#46;&#46;&#46;&#38614;&#28982;&#40848;&#22823;&#65292;&#20294;&#27794;&#30332;&#29694;&#20160;&#40636;&#26377;&#29992;&#30340;&#26360;&#21602;&#65311;&#65281;<br>
	 * Message: This library... It's huge but there aren't many useful books, right?
	 */
	public static final NpcStringId THIS_LIBRARY_ITS_HUGE_BUT_THERE_ARENT_MANY_USEFUL_BOOKS_RIGHT;
	
	/**
	 * ID: 1029353<br>
	 * Message: n}ق˂DDDWWĂăNTƂ͂Ȃ񂾂ˁB<br>
	 * Message: &#22320;&#19979;&#22294;&#26360;&#39208;&#21834;&#46;&#46;&#46;&#25105;&#24456;&#35342;&#21421;&#28629;&#27683;&#37325;&#19988;&#26377;&#21619;&#36947;&#30340;&#22320;&#26041;&#32822;&#46;&#46;&#46;<br>
	 * Message: An underground library... I hate damp and smelly places...
	 */
	public static final NpcStringId AN_UNDERGROUND_LIBRARY_I_HATE_DAMP_AND_SMELLY_PLACES;
	
	/**
	 * ID: 1029354<br>
	 * Message: ̒TĂ{́AƂɂ͂BĂ݂܂傤B<br>
	 * Message: &#36889;&#35041;&#19968;&#23450;&#26371;&#26377;&#25105;&#20497;&#27491;&#22312;&#23563;&#25214;&#30340;&#26360;&#26412;&#12290;&#22909;&#22909;&#25214;&#25214;&#30475;&#21543;&#12290;<br>
	 * Message: The book that we seek is certainly here. Search inch by inch.
	 */
	public static final NpcStringId THE_BOOK_THAT_WE_SEEK_IS_CERTAINLY_HERE_SEARCH_INCH_BY_INCH;
	
	/**
	 * ID: 1029450<br>
	 * Message: kꂼ̕ŁA̖{uꂽǏTāB<br>
	 * Message: &#22312;&#20301;&#26044;&#26481;&#35199;&#21335;&#21271;&#30340;&#21508;&#20491;&#25151;&#38291;&#65292;&#24517;&#38920;&#35201;&#25214;&#20986;&#25918;&#32622;&#33879;&#25105;&#20497;&#27491;&#22312;&#23563;&#25214;&#30340;&#26360;&#26412;&#30340;&#38321;&#35261;&#21488;&#12290;<br>
	 * Message: We must search high and low in every room for the reading desk that contains the book we seek.
	 */
	public static final NpcStringId WE_MUST_SEARCH_HIGH_AND_LOW_IN_EVERY_ROOM_FOR_THE_READING_DESK_THAT_CONTAINS_THE_BOOK_WE_SEEK;
	
	/**
	 * ID: 1029451<br>
	 * Message: {̓e͊oĂāBďoȂB<br>
	 * Message: &#24517;&#38920;&#35201;&#35352;&#20303;&#25214;&#21040;&#30340;&#26360;&#26412;&#20839;&#23481;&#65292;&#22240;&#28858;&#26360;&#26412;&#26159;&#24118;&#19981;&#20986;&#21435;&#30340;&#12290;<br>
	 * Message: Remember the content of the books that you found. You can't take them out with you.
	 */
	public static final NpcStringId REMEMBER_THE_CONTENT_OF_THE_BOOKS_THAT_YOU_FOUND_YOU_CANT_TAKE_THEM_OUT_WITH_YOU;
	
	/**
	 * ID: 1029452<br>
	 * Message: x{ɂ͂Ȃ悤ˁB<br>
	 * Message: &#24050;&#32147;&#25214;&#21040;&#26360;&#26412;&#30340;&#30435;&#35222;&#32773;&#20043;&#25151;&#65292;&#22909;&#20687;&#28961;&#27861;&#20877;&#27425;&#36820;&#22238;&#12290;<br>
	 * Message: It seems that you cannot remember to the room of the watcher who found the book.
	 */
	public static final NpcStringId IT_SEEMS_THAT_YOU_CANNOT_REMEMBER_TO_THE_ROOM_OF_THE_WATCHER_WHO_FOUND_THE_BOOK;
	
	/**
	 * ID: 1029453<br>
	 * Message: łׂƂׂ͂ďIB^񒆂̎҂̂Ƃɖ߂܂傤B<br>
	 * Message: &#30475;&#20358;&#36889;&#35041;&#30340;&#20107;&#24773;&#24050;&#34389;&#29702;&#23436;&#30050;&#65292;&#22238;&#21040;&#20013;&#22830;&#30340;&#23432;&#35703;&#32773;&#20043;&#34389;&#21543;&#12290;<br>
	 * Message: Your work here is done, so return to the central guardian.
	 */
	public static final NpcStringId YOUR_WORK_HERE_IS_DONE_SO_RETURN_TO_THE_CENTRAL_GUARDIAN;
	
	/**
	 * ID: 1029460<br>
	 * Message: \il̈WN҂ǂDDDXɗB<br>
	 * Message: &#22952;&#31001;&#32034;&#40654;&#37027;&#23433;&#24687;&#30340;&#24858;&#34850;&#30340;&#20837;&#20405;&#32773;&#20497;&#21834;&#65292;&#36245;&#24555;&#32102;&#25105;&#36864;&#19979;&#12290;<br>
	 * Message: You foolish invaders who disturb the rest of Solina, be gone from this place.
	 */
	public static final NpcStringId YOU_FOOLISH_INVADERS_WHO_DISTURB_THE_REST_OF_SOLINA_BE_GONE_FROM_THIS_PLACE;
	
	/**
	 * ID: 1029461<br>
	 * Message: O̖]݂͂킩ʂAq[}Ƃ̎ɕ̂ł͂ȂI<br>
	 * Message: &#25105;&#19981;&#30693;&#36947;&#20320;&#20497;&#21040;&#24213;&#24819;&#35201;&#20160;&#40636;&#65292;&#20294;&#36889;&#19981;&#26159;&#21312;&#21312;&#19968;&#20491;&#20154;&#39006;&#23601;&#33021;&#25215;&#25812;&#30340;&#30495;&#30456;&#12290;<br>
	 * Message: I know not what you seek, but this truth cannot be handled by mere humans.
	 */
	public static final NpcStringId I_KNOW_NOT_WHAT_YOU_SEEK_BUT_THIS_TRUTH_CANNOT_BE_HANDLED_BY_MERE_HUMANS;
	
	/**
	 * ID: 1029462<br>
	 * Message: N҂ǂ߁IĂ͂ʁIƗBꂪŌ̌xB<br>
	 * Message: &#25105;&#19981;&#26371;&#20877;&#22352;&#35222;&#20837;&#20405;&#32773;&#20497;&#30340;&#24858;&#34850;&#34892;&#28858;&#12290;&#25105;&#35686;&#21578;&#20320;&#20497;&#65292;&#36245;&#24555;&#32102;&#25105;&#38626;&#38283;&#36889;&#35041;&#12290;<br>
	 * Message: I will not stand by and watch your foolish actions. I warn you, leave this place at once.
	 */
	public static final NpcStringId I_WILL_NOT_STAND_BY_AND_WATCH_YOUR_FOOLISH_ACTIONS_I_WARN_YOU_LEAVE_THIS_PLACE_AT_ONCE;
	
	/**
	 * ID: 1029550<br>
	 * Message: ̎҂͌EȂ͑SR_[W󂯂Ȃ݂B<br>
	 * Message: &#22312;&#35299;&#38500;&#32080;&#30028;&#20043;&#21069;&#65292;&#23553;&#21360;&#23432;&#35703;&#32773;&#22909;&#20687;&#19981;&#26371;&#21463;&#21040;&#20219;&#20309;&#20663;&#23475;&#12290;<br>
	 * Message: The guardian of the seal doesn't seem to get injured at all until the barrier is destroyed.
	 */
	public static final NpcStringId THE_GUARDIAN_OF_THE_SEAL_DOESNT_SEEM_TO_GET_INJURED_AT_ALL_UNTIL_THE_BARRIER_IS_DESTROYED;
	
	/**
	 * ID: 1029551<br>
	 * Message: ̎҂̑Ȏ̕úAƎ҂̗͂i錋EB<br>
	 * Message: &#25918;&#32622;&#22312;&#23553;&#21360;&#23432;&#35703;&#32773;&#21069;&#26041;&#30340;&#25151;&#38291;&#35037;&#32622;&#65292;&#19968;&#23450;&#23601;&#26159;&#25484;&#31649;&#23432;&#35703;&#32773;&#21147;&#37327;&#30340;&#32080;&#30028;&#12290;<br>
	 * Message: The device located in the room in front of the guardian of the seal is definitely the barrier that controls the guardian's power.
	 */
	public static final NpcStringId THE_DEVICE_LOCATED_IN_THE_ROOM_IN_FRONT_OF_THE_GUARDIAN_OF_THE_SEAL_IS_DEFINITELY_THE_BARRIER_THAT_CONTROLS_THE_GUARDIANS_POWER;
	
	/**
	 * ID: 1029552<br>
	 * Message: Eɂ́AɍTđu𓮂̂B<br>
	 * Message: &#22914;&#26524;&#35201;&#35299;&#38500;&#32080;&#30028;&#30340;&#35441;&#65292;&#38656;&#35201;&#25214;&#20986;&#31526;&#21512;&#32080;&#30028;&#30340;&#32854;&#29289;&#65292;&#37027;&#40636;&#23601;&#33021;&#21855;&#21205;&#35037;&#32622;&#20102;&#12290;<br>
	 * Message: To remove the barrier, you must find the relics that fit the barrier and activate the device.
	 */
	public static final NpcStringId TO_REMOVE_THE_BARRIER_YOU_MUST_FIND_THE_RELICS_THAT_FIT_THE_BARRIER_AND_ACTIVATE_THE_DEVICE;
	
	/**
	 * ID: 1029553<br>
	 * Message: ҂͑S|B͂B^񒆂̃e|[gňړ܂傤B<br>
	 * Message: &#26082;&#28982;&#25802;&#20498;&#20102;&#25152;&#26377;&#30340;&#23432;&#35703;&#32773;&#65292;&#37027;&#40636;&#23553;&#21360;&#20063;&#25033;&#35442;&#34987;&#35299;&#38500;&#20102;&#12290;&#31227;&#21205;&#21040;&#20013;&#22830;&#30340;&#20659;&#36865;&#35037;&#32622;&#21543;&#12290;<br>
	 * Message: All the guardians were defeated, and the seal was removed. Teleport to the center.
	 */
	public static final NpcStringId ALL_THE_GUARDIANS_WERE_DEFEATED_AND_THE_SEAL_WAS_REMOVED_TELEPORT_TO_THE_CENTER;
	
	/**
	 * ID: 1110071<br>
	 * Message: NĂƂłB<br>
	 * Message: &#27491;&#22312;&#31449;&#31435;&#12290;<br>
	 * Message: ... is the process of standing up.
	 */
	public static final NpcStringId _IS_THE_PROCESS_OF_STANDING_UP;
	
	/**
	 * ID: 1110072<br>
	 * Message: ĂƂłB<br>
	 * Message: &#27491;&#22312;&#22352;&#19979;&#12290;<br>
	 * Message: ... is the process of sitting down.
	 */
	public static final NpcStringId _IS_THE_PROCESS_OF_SITTING_DOWN;
	
	/**
	 * ID: 1110073<br>
	 * Message: ĂԂŃXLgpł܂B<br>
	 * Message: &#22352;&#33879;&#26178;&#20063;&#21487;&#20197;&#20351;&#29992;&#25216;&#33021;&#12290;<br>
	 * Message: It is possible to use a skill while sitting down.
	 */
	public static final NpcStringId IT_IS_POSSIBLE_TO_USE_A_SKILL_WHILE_SITTING_DOWN;
	
	/**
	 * ID: 1110074<br>
	 * Message: ˒OĂ܂B<br>
	 * Message: &#33067;&#38626;&#23556;&#31243;&#36317;&#38626;&#12290;<br>
	 * Message: ...is out of range.
	 */
	public static final NpcStringId IS_OUT_OF_RANGE;
	
	/**
	 * ID: 1120300<br>
	 * Message: ߂ĂDDDCς񂾂H<br>
	 * Message: &#22816;&#20102;&#21543;&#46;&#46;&#46;&#20320;&#21507;&#30340;&#46;&#46;&#46;&#19981;&#26159;&#22816;&#22810;&#20102;&#21966;&#65311;<br>
	 * Message: Thank you... My book... Child...
	 */
	public static final NpcStringId THANK_YOU_MY_BOOK_CHILD;
	
	/**
	 * ID: 1120301<br>
	 * Message: $s1ɓ|ꂽ<br>
	 * Message: &#34987;&#12300;&#36;&#115;&#49;&#12301;&#34389;&#27515;&#30340;<br>
	 * Message: Killed by $s1
	 */
	public static final NpcStringId KILLED_BY_S2;
	
	/**
	 * ID: 1121000<br>
	 * Message: FƑ҂ĂB<br>
	 * Message: &#22519;&#20107;&#65306;&#35531;&#31245;&#20505;&#12290;<br>
	 * Message: Steward: Please wait a moment.
	 */
	public static final NpcStringId STEWARD_PLEASE_WAIT_A_MOMENT;
	
	/**
	 * ID: 1121001<br>
	 * Message: Flǂ̎pɁDDD<br>
	 * Message: &#22519;&#20107;&#65306;&#35531;&#35731;&#22899;&#29579;&#24674;&#24489;&#21407;&#35980;&#46;&#46;&#46;<br>
	 * Message: Steward: Please restore the Queen's former appearance!
	 */
	public static final NpcStringId STEWARD_PLEASE_RESTORE_THE_QUEENS_FORMER_APPEARANCE;
	
	/**
	 * ID: 1121002<br>
	 * Message: FԂ܂B}łB<br>
	 * Message: &#22519;&#20107;&#65306;&#26178;&#38291;&#19981;&#22810;&#20102;&#65292;&#35531;&#24744;&#30433;&#24555;&#12290;<br>
	 * Message: Steward: Waste no time! Please hurry!
	 */
	public static final NpcStringId STEWARD_WASTE_NO_TIME_PLEASE_HURRY;
	
	/**
	 * ID: 1121003<br>
	 * Message: F͂薳̂DDD<br>
	 * Message: &#22519;&#20107;&#65306;&#38627;&#36947;&#36996;&#26159;&#19981;&#34892;&#22043;&#46;&#46;&#46;<br>
	 * Message: Steward: Was it indeed too much to ask...
	 */
	public static final NpcStringId STEWARD_WAS_IT_INDEED_TOO_MUCH_TO_ASK;
	
	/**
	 * ID: 1121004<br>
	 * Message: tF͂ǂH̓DDD<br>
	 * Message: &#33433;&#34174;&#38597;&#65306;&#36889;&#35041;&#26159;&#21738;&#35041;&#46;&#46;&#37027;&#22825;&#20197;&#24460;&#46;&#46;<br>
	 * Message: Freya: Heathens! Feel my chill!
	 */
	public static final NpcStringId FREYA_HEATHENS_FEEL_MY_CHILL;
	
	/**
	 * ID: 1121005<br>
	 * Message: JԂ͏I܂BɂX͑₩ɊO֏oĂB<br>
	 * Message: &#38283;&#25918;&#26178;&#38291;&#24050;&#32080;&#26463;&#12290;&#22312;&#22899;&#29579;&#22478;&#22561;&#20839;&#36887;&#30041;&#30340;&#35370;&#23458;&#35531;&#21040;&#22806;&#38754;&#20358;&#12290;<br>
	 * Message: Attention please! The gates will be closing shortly. All visitors to the Queen's Castle should leave immediately.
	 */
	public static final NpcStringId ATTENTION_PLEASE_THE_GATES_WILL_BE_CLOSING_SHORTLY_ALL_VISITORS_TO_THE_QUEENS_CASTLE_SHOULD_LEAVE_IMMEDIATELY;
	
	/**
	 * ID: 1121006<br>
	 * Message: ꂽ҈ȊȌ͕ւĂI<br>
	 * Message: &#38500;&#20102;&#34987;&#20801;&#35377;&#30340;&#20154;&#20043;&#22806;&#65292;&#19968;&#24459;&#19981;&#21487;&#25884;&#24118;&#27494;&#22120;&#65281;<br>
	 * Message: You cannot carry a weapon without authorization!
	 */
	public static final NpcStringId YOU_CANNOT_CARRY_A_WEAPON_WITHOUT_AUTHORIZATION;
	
	/**
	 * ID: 1121007<br>
	 * Message: xłˁBȂ܂B<br>
	 * Message: &#24744;&#24819;&#27450;&#39449;&#25105;&#65311;&#30495;&#26159;&#20196;&#20154;&#22833;&#26395;&#12290;<br>
	 * Message: Are you trying to deceive me? I'm disappointed.
	 */
	public static final NpcStringId ARE_YOU_TRYING_TO_DECEIVE_ME_IM_DISAPPOINTED;
	
	/**
	 * ID: 1121008<br>
	 * Message: c30łB<br>
	 * Message: &#21097;&#19979;&#51;&#48;&#20998;&#37912;&#12290;<br>
	 * Message: 30 minutes remain.
	 */
	public static final NpcStringId N30_MINUTES_REMAIN;
	
	/**
	 * ID: 1121009<br>
	 * Message: c20łB<br>
	 * Message: &#21097;&#19979;&#50;&#48;&#20998;&#37912;&#12290;<br>
	 * Message: 20 minutes remain.
	 */
	public static final NpcStringId N20_MINUTES_REMAIN;
	
	/**
	 * ID: 1200001<br>
	 * Message: ` R[_<br>
	 * Message: &#20919;&#27683;&#26607;&#22612;<br>
	 * Message: Chilly Coda
	 */
	public static final NpcStringId CHILLY_CODA;
	
	/**
	 * ID: 1200002<br>
	 * Message: o[jO R[_<br>
	 * Message: &#29123;&#29138;&#26607;&#22612;<br>
	 * Message: Burning Coda
	 */
	public static final NpcStringId BURNING_CODA;
	
	/**
	 * ID: 1200003<br>
	 * Message: u[ R[_<br>
	 * Message: &#34253;&#33394;&#26607;&#22612;<br>
	 * Message: Blue Coda
	 */
	public static final NpcStringId BLUE_CODA;
	
	/**
	 * ID: 1200004<br>
	 * Message: bh R[_<br>
	 * Message: &#32005;&#33394;&#26607;&#22612;<br>
	 * Message: Red Coda
	 */
	public static final NpcStringId RED_CODA;
	
	/**
	 * ID: 1200005<br>
	 * Message: S[f R[_<br>
	 * Message: &#37329;&#33394;&#26607;&#22612;<br>
	 * Message: Golden Coda
	 */
	public static final NpcStringId GOLDEN_CODA;
	
	/**
	 * ID: 1200006<br>
	 * Message: fU[g R[_<br>
	 * Message: &#27801;&#28448;&#26607;&#22612;<br>
	 * Message: Desert Coda
	 */
	public static final NpcStringId DESERT_CODA;
	
	/**
	 * ID: 1200007<br>
	 * Message: [g R[_<br>
	 * Message: &#39791;&#29305;&#26607;&#22612;<br>
	 * Message: Lute Coda
	 */
	public static final NpcStringId LUTE_CODA;
	
	/**
	 * ID: 1200008<br>
	 * Message: cC R[_<br>
	 * Message: &#38617;&#29983;&#26607;&#22612;<br>
	 * Message: Twin Coda
	 */
	public static final NpcStringId TWIN_CODA;
	
	/**
	 * ID: 1200009<br>
	 * Message: _[N R[_<br>
	 * Message: &#40657;&#26263;&#26607;&#22612;<br>
	 * Message: Dark Coda
	 */
	public static final NpcStringId DARK_CODA;
	
	/**
	 * ID: 1200010<br>
	 * Message: VCjO R[_<br>
	 * Message: &#38275;&#32768;&#26607;&#22612;<br>
	 * Message: Shining Coda
	 */
	public static final NpcStringId SHINING_CODA;
	
	/**
	 * ID: 1200011<br>
	 * Message: ` R{<br>
	 * Message: &#20919;&#27683;&#26607;&#26575;<br>
	 * Message: Chilly Cobol
	 */
	public static final NpcStringId CHILLY_COBOL;
	
	/**
	 * ID: 1200012<br>
	 * Message: o[jO R{<br>
	 * Message: &#29123;&#29138;&#26607;&#26575;<br>
	 * Message: Burning Cobol
	 */
	public static final NpcStringId BURNING_COBOL;
	
	/**
	 * ID: 1200013<br>
	 * Message: u[ R{<br>
	 * Message: &#34253;&#33394;&#26607;&#26575;<br>
	 * Message: Blue Cobol
	 */
	public static final NpcStringId BLUE_COBOL;
	
	/**
	 * ID: 1200014<br>
	 * Message: bh R{<br>
	 * Message: &#32005;&#33394;&#26607;&#26575;<br>
	 * Message: Red Cobol
	 */
	public static final NpcStringId RED_COBOL;
	
	/**
	 * ID: 1200015<br>
	 * Message: S[f R{<br>
	 * Message: &#37329;&#33394;&#26607;&#26575;<br>
	 * Message: Golden Cobol
	 */
	public static final NpcStringId GOLDEN_COBOL;
	
	/**
	 * ID: 1200016<br>
	 * Message: fU[g R{<br>
	 * Message: &#27801;&#28448;&#26607;&#26575;<br>
	 * Message: Desert Cobol
	 */
	public static final NpcStringId DESERT_COBOL;
	
	/**
	 * ID: 1200017<br>
	 * Message: V[ R{<br>
	 * Message: &#28023;&#27915;&#26607;&#26575;<br>
	 * Message: Sea Cobol
	 */
	public static final NpcStringId SEA_COBOL;
	
	/**
	 * ID: 1200018<br>
	 * Message: o[ R{<br>
	 * Message: &#33426;&#21050;&#26607;&#26575;<br>
	 * Message: Thorn Cobol
	 */
	public static final NpcStringId THORN_COBOL;
	
	/**
	 * ID: 1200019<br>
	 * Message: _bv R{<br>
	 * Message: &#26001;&#40670;&#26607;&#26575;<br>
	 * Message: Dapple Cobol
	 */
	public static final NpcStringId DAPPLE_COBOL;
	
	/**
	 * ID: 1200020<br>
	 * Message: O[g R{<br>
	 * Message: &#24040;&#22823;&#26607;&#26575;<br>
	 * Message: Great Cobol
	 */
	public static final NpcStringId GREAT_COBOL;
	
	/**
	 * ID: 1200021<br>
	 * Message: ` Rh<br>
	 * Message: &#20919;&#27683;&#26607;&#24503;&#26391;<br>
	 * Message: Chilly Codran
	 */
	public static final NpcStringId CHILLY_CODRAN;
	
	/**
	 * ID: 1200022<br>
	 * Message: o[jO Rh<br>
	 * Message: &#29123;&#29138;&#26607;&#24503;&#26391;<br>
	 * Message: Burning Codran
	 */
	public static final NpcStringId BURNING_CODRAN;
	
	/**
	 * ID: 1200023<br>
	 * Message: u[ Rh<br>
	 * Message: &#34253;&#33394;&#26607;&#24503;&#26391;<br>
	 * Message: Blue Codran
	 */
	public static final NpcStringId BLUE_CODRAN;
	
	/**
	 * ID: 1200024<br>
	 * Message: bh Rh<br>
	 * Message: &#32005;&#33394;&#26607;&#24503;&#26391;<br>
	 * Message: Red Codran
	 */
	public static final NpcStringId RED_CODRAN;
	
	/**
	 * ID: 1200025<br>
	 * Message: _bv Rh<br>
	 * Message: &#26001;&#40670;&#26607;&#24503;&#26391;<br>
	 * Message: Dapple Codran
	 */
	public static final NpcStringId DAPPLE_CODRAN;
	
	/**
	 * ID: 1200026<br>
	 * Message: fU[g Rh<br>
	 * Message: &#27801;&#28448;&#26607;&#24503;&#26391;<br>
	 * Message: Desert Codran
	 */
	public static final NpcStringId DESERT_CODRAN;
	
	/**
	 * ID: 1200027<br>
	 * Message: V[ Rh<br>
	 * Message: &#28023;&#27915;&#26607;&#24503;&#26391;<br>
	 * Message: Sea Codran
	 */
	public static final NpcStringId SEA_CODRAN;
	
	/**
	 * ID: 1200028<br>
	 * Message: cC Rh<br>
	 * Message: &#38617;&#29983;&#26607;&#24503;&#26391;<br>
	 * Message: Twin Codran
	 */
	public static final NpcStringId TWIN_CODRAN;
	
	/**
	 * ID: 1200029<br>
	 * Message: o[ Rh<br>
	 * Message: &#33426;&#21050;&#26607;&#24503;&#26391;<br>
	 * Message: Thorn Codran
	 */
	public static final NpcStringId THORN_CODRAN;
	
	/**
	 * ID: 1200030<br>
	 * Message: O[g Rh<br>
	 * Message: &#24040;&#22823;&#26607;&#24503;&#26391;<br>
	 * Message: Great Codran
	 */
	public static final NpcStringId GREAT_CODRAN;
	
	/**
	 * ID: 1200031<br>
	 * Message: ǃ_[N R[_<br>
	 * Message: &#25913;&#33391;&#40657;&#26263;&#26607;&#22612;<br>
	 * Message: Alternative Dark Coda
	 */
	public static final NpcStringId ALTERNATIVE_DARK_CODA;
	
	/**
	 * ID: 1200032<br>
	 * Message: ǃbh R[_<br>
	 * Message: &#25913;&#33391;&#32005;&#33394;&#26607;&#22612;<br>
	 * Message: Alternative Red Coda
	 */
	public static final NpcStringId ALTERNATIVE_RED_CODA;
	
	/**
	 * ID: 1200033<br>
	 * Message: ǃ` R[_<br>
	 * Message: &#25913;&#33391;&#20919;&#27683;&#26607;&#22612;<br>
	 * Message: Alternative Chilly Coda
	 */
	public static final NpcStringId ALTERNATIVE_CHILLY_CODA;
	
	/**
	 * ID: 1200034<br>
	 * Message: ǃu[ R[_<br>
	 * Message: &#25913;&#33391;&#34253;&#33394;&#26607;&#22612;<br>
	 * Message: Alternative Blue Coda
	 */
	public static final NpcStringId ALTERNATIVE_BLUE_CODA;
	
	/**
	 * ID: 1200035<br>
	 * Message: ǃS[f R[_<br>
	 * Message: &#25913;&#33391;&#37329;&#33394;&#26607;&#22612;<br>
	 * Message: Alternative Golden Coda
	 */
	public static final NpcStringId ALTERNATIVE_GOLDEN_CODA;
	
	/**
	 * ID: 1200036<br>
	 * Message: ǃ[g R[_<br>
	 * Message: &#25913;&#33391;&#39791;&#29305;&#26607;&#22612;<br>
	 * Message: Alternative Lute Coda
	 */
	public static final NpcStringId ALTERNATIVE_LUTE_CODA;
	
	/**
	 * ID: 1200037<br>
	 * Message: ǃfU[g R[_<br>
	 * Message: &#25913;&#33391;&#27801;&#28448;&#26607;&#22612;<br>
	 * Message: Alternative Desert Coda
	 */
	public static final NpcStringId ALTERNATIVE_DESERT_CODA;
	
	/**
	 * ID: 1200038<br>
	 * Message: ǃbh R{<br>
	 * Message: &#25913;&#33391;&#32005;&#33394;&#26607;&#26575;<br>
	 * Message: Alternative Red Cobol
	 */
	public static final NpcStringId ALTERNATIVE_RED_COBOL;
	
	/**
	 * ID: 1200039<br>
	 * Message: ǃ` R{<br>
	 * Message: &#25913;&#33391;&#20919;&#27683;&#26607;&#26575;<br>
	 * Message: Alternative Chilly Cobol
	 */
	public static final NpcStringId ALTERNATIVE_CHILLY_COBOL;
	
	/**
	 * ID: 1200040<br>
	 * Message: ǃu[ R{<br>
	 * Message: &#25913;&#33391;&#34253;&#33394;&#26607;&#26575;<br>
	 * Message: Alternative Blue Cobol
	 */
	public static final NpcStringId ALTERNATIVE_BLUE_COBOL;
	
	/**
	 * ID: 1200041<br>
	 * Message: ǃo[ R{<br>
	 * Message: &#25913;&#33391;&#33426;&#21050;&#26607;&#26575;<br>
	 * Message: Alternative Thorn Cobol
	 */
	public static final NpcStringId ALTERNATIVE_THORN_COBOL;
	
	/**
	 * ID: 1200042<br>
	 * Message: ǃS[f R{<br>
	 * Message: &#25913;&#33391;&#37329;&#33394;&#26607;&#26575;<br>
	 * Message: Alternative Golden Cobol
	 */
	public static final NpcStringId ALTERNATIVE_GOLDEN_COBOL;
	
	/**
	 * ID: 1200043<br>
	 * Message: ǃO[g R{<br>
	 * Message: &#25913;&#33391;&#24040;&#22823;&#26607;&#26575;<br>
	 * Message: Alternative Great Cobol
	 */
	public static final NpcStringId ALTERNATIVE_GREAT_COBOL;
	
	/**
	 * ID: 1200044<br>
	 * Message: ǃbh Rh<br>
	 * Message: &#25913;&#33391;&#32005;&#33394;&#26607;&#24503;&#26391;<br>
	 * Message: Alternative Red Codran
	 */
	public static final NpcStringId ALTERNATIVE_RED_CODRAN;
	
	/**
	 * ID: 1200045<br>
	 * Message: ǃV[ Rh<br>
	 * Message: &#25913;&#33391;&#28023;&#27915;&#26607;&#24503;&#26391;<br>
	 * Message: Alternative Sea Codran
	 */
	public static final NpcStringId ALTERNATIVE_SEA_CODRAN;
	
	/**
	 * ID: 1200046<br>
	 * Message: ǃ` Rh<br>
	 * Message: &#25913;&#33391;&#20919;&#27683;&#26607;&#24503;&#26391;<br>
	 * Message: Alternative Chilly Codran
	 */
	public static final NpcStringId ALTERNATIVE_CHILLY_CODRAN;
	
	/**
	 * ID: 1200047<br>
	 * Message: ǃu[ Rh<br>
	 * Message: &#25913;&#33391;&#34253;&#33394;&#26607;&#24503;&#26391;<br>
	 * Message: Alternative Blue Codran
	 */
	public static final NpcStringId ALTERNATIVE_BLUE_CODRAN;
	
	/**
	 * ID: 1200048<br>
	 * Message: ǃcC Rh<br>
	 * Message: &#25913;&#33391;&#38617;&#29983;&#26607;&#24503;&#26391;<br>
	 * Message: Alternative Twin Codran
	 */
	public static final NpcStringId ALTERNATIVE_TWIN_CODRAN;
	
	/**
	 * ID: 1200049<br>
	 * Message: ǃO[g Rh<br>
	 * Message: &#25913;&#33391;&#24040;&#22823;&#26607;&#24503;&#26391;<br>
	 * Message: Alternative Great Codran
	 */
	public static final NpcStringId ALTERNATIVE_GREAT_CODRAN;
	
	/**
	 * ID: 1200050<br>
	 * Message: ǃfU[g Rh<br>
	 * Message: &#25913;&#33391;&#27801;&#28448;&#26607;&#24503;&#26391;<br>
	 * Message: Alternative Desert Codran
	 */
	public static final NpcStringId ALTERNATIVE_DESERT_CODRAN;
	
	/**
	 * ID: 1300001<br>
	 * Message: 󂳂ꂽBɂׂĉ󂵁AGR̎wߖ{܂ňړI<br>
	 * Message: &#38272;&#24050;&#30772;&#22750;&#65292;&#25802;&#30772;&#25152;&#26377;&#24149;&#33293;&#24460;&#31227;&#21205;&#33267;&#25973;&#36557;&#30340;&#25351;&#25582;&#26412;&#37096;&#65281;<br>
	 * Message: We have broken through the gate! Destroy the encampment and move to the Command Post!
	 */
	public static final NpcStringId WE_HAVE_BROKEN_THROUGH_THE_GATE_DESTROY_THE_ENCAMPMENT_AND_MOVE_TO_THE_COMMAND_POST;
	
	/**
	 * ID: 1300002<br>
	 * Message: Ɏwߖɂ̔JꂽB}Ŋɓꏟ̂߂ɍf̂I<br>
	 * Message: &#25351;&#25582;&#24149;&#33293;&#20043;&#38272;&#32066;&#26044;&#38283;&#21855;&#20102;&#12290;&#36245;&#32202;&#22890;&#21462;&#26071;&#24159;&#65292;&#28858;&#21213;&#21033;&#39640;&#33289;&#36215;&#20358;&#21543;&#65281;<br>
	 * Message: The command gate has opened! Capture the flag quickly and raise it high to proclaim our victory!
	 */
	public static final NpcStringId THE_COMMAND_GATE_HAS_OPENED_CAPTURE_THE_FLAG_QUICKLY_AND_RAISE_IT_HIGH_TO_PROCLAIM_OUR_VICTORY;
	
	/**
	 * ID: 1300003<br>
	 * Message: DDDDDD<br>
	 * Message: &#30495;&#19981;&#29976;&#24515;&#46;&#46;&#46;&#36867;&#21834;&#46;&#46;&#46;<br>
	 * Message: The gods have forsaken us... Retreat!!
	 */
	public static final NpcStringId THE_GODS_HAVE_FORSAKEN_US_RETREAT;
	
	/**
	 * ID: 1300004<br>
	 * Message: O̖܂낤ƂAX̎uƂ͂łȂ̂DDD|AނI<br>
	 * Message: &#20320;&#20497;&#38614;&#33021;&#25240;&#26039;&#25105;&#30340;&#31661;&#30690;&#65292;&#20294;&#32085;&#23565;&#19981;&#33021;&#25240;&#26039;&#25105;&#20497;&#30340;&#24847;&#24535;&#46;&#46;&#46;&#24339;&#20853;&#38538;&#24460;&#36864;&#12290;<br>
	 * Message: You may have broken our arrows, but you will never break our will! Archers, retreat!
	 */
	public static final NpcStringId YOU_MAY_HAVE_BROKEN_OUR_ARROWS_BUT_YOU_WILL_NEVER_BREAK_OUR_WILL_ARCHERS_RETREAT;
	
	/**
	 * ID: 1300005<br>
	 * Message: DDDvǂĂ@w̗͂キȂĂBxSނ̂łB<br>
	 * Message: &#21834;&#46;&#46;&#46;&#20445;&#35703;&#35201;&#22622;&#30340;&#39764;&#27861;&#38499;&#21147;&#37327;&#28472;&#28472;&#34928;&#24369;&#65292;&#25903;&#25588;&#38538;&#21729;&#65292;&#20840;&#21729;&#36864;&#19979;&#65281;<br>
	 * Message: At last! The Magic Field that protects the fortress has weakened! Volunteers, stand back!
	 */
	public static final NpcStringId AT_LAST_THE_MAGIC_FIELD_THAT_PROTECTS_THE_FORTRESS_HAS_WEAKENED_VOLUNTEERS_STAND_BACK;
	
	/**
	 * ID: 1300006<br>
	 * Message: DDD{DDDDDD肤DDD<br>
	 * Message: &#21834;&#46;&#46;&#46;&#26412;&#37096;&#46;&#46;&#46;&#36889;&#35041;&#26159;&#23432;&#20633;&#38538;&#46;&#46;&#46;&#32;&#35531;&#36895;&#27966;&#20853;&#25903;&#25588;&#46;&#46;&#46;&#32;&#21834;&#65281;<br>
	 * Message: Aiieeee! Command Center! This is guard unit! We need backup right away!
	 */
	public static final NpcStringId AIIEEEE_COMMAND_CENTER_THIS_IS_GUARD_UNIT_WE_NEED_BACKUP_RIGHT_AWAY;
	
	/**
	 * ID: 1300007<br>
	 * Message: vǐ͂̋Ւf܂B<br>
	 * Message: &#35201;&#22622;&#30340;&#38651;&#21147;&#20379;&#32102;&#24050;&#32147;&#20572;&#27490;&#20102;&#12290;<br>
	 * Message: Fortress power disabled.
	 */
	public static final NpcStringId FORTRESS_POWER_DISABLED;
	
	/**
	 * ID: 1300008<br>
	 * Message: ̖Ǝw܂Ƃ́DDD<br>
	 * Message: &#20687;&#25105;&#36889;&#33324;&#20197;&#21517;&#35709;&#33879;&#31281;&#30340;&#25351;&#25582;&#23448;&#65292;&#31455;&#28982;&#26371;&#23601;&#27492;&#34987;&#25171;&#25943;&#46;&#46;&#46;<br>
	 * Message: Oh my, what has become of me??? My fame.. my friends.. lost.. all lost...
	 */
	public static final NpcStringId OH_MY_WHAT_HAS_BECOME_OF_ME_MY_FAME_MY_FRIENDS_LOST_ALL_LOST;
	
	/**
	 * ID: 1300009<br>
	 * Message: No.1 Machine Power Off!<br>
	 * Message: &#78;&#111;&#46;&#49;&#32;&#77;&#97;&#99;&#104;&#105;&#110;&#101;&#32;&#80;&#111;&#119;&#101;&#114;&#32;&#79;&#102;&#102;&#65281;<br>
	 * Message: Machine No. 1 - Power Off!
	 */
	public static final NpcStringId MACHINE_NO_1_POWER_OFF;
	
	/**
	 * ID: 1300010<br>
	 * Message: No.2 Machine Power Off!<br>
	 * Message: &#78;&#111;&#46;&#50;&#32;&#77;&#97;&#99;&#104;&#105;&#110;&#101;&#32;&#80;&#111;&#119;&#101;&#114;&#32;&#79;&#102;&#102;&#65281;<br>
	 * Message: Machine No. 2 - Power Off!
	 */
	public static final NpcStringId MACHINE_NO_2_POWER_OFF;
	
	/**
	 * ID: 1300011<br>
	 * Message: No.3 Machine Power Off!<br>
	 * Message: &#78;&#111;&#46;&#51;&#32;&#77;&#97;&#99;&#104;&#105;&#110;&#101;&#32;&#80;&#111;&#119;&#101;&#114;&#32;&#79;&#102;&#102;&#65281;<br>
	 * Message: Machine No. 3 - Power Off!
	 */
	public static final NpcStringId MACHINE_NO_3_POWER_OFF;
	
	/**
	 * ID: 1300012<br>
	 * Message: SɍI$s1WUIGɌPʂĂ̂I<br>
	 * Message: &#20840;&#38538;&#21729;&#38598;&#20013;&#25915;&#25802;&#12300;&#36;&#115;&#49;&#12301;&#65281;&#35731;&#25973;&#20154;&#22160;&#22160;&#20320;&#20497;&#37723;&#37706;&#30340;&#25104;&#26524;&#21543;&#65281;<br>
	 * Message: Everyone, concentrate your attacks on $s1! Show the enemy your resolve!
	 */
	public static final NpcStringId EVERYONE_CONCENTRATE_YOUR_ATTACKS_ON_S1_SHOW_THE_ENEMY_YOUR_RESOLVE;
	
	/**
	 * ID: 1300013<br>
	 * Message: GR̎x܂Û퓬̊{BI<br>
	 * Message: &#20808;&#25915;&#25973;&#20154;&#30340;&#25903;&#25588;&#37096;&#38538;&#65292;&#26159;&#25136;&#39717;&#30340;&#22522;&#30990;&#65292;&#27578;&#21834;&#65281;<br>
	 * Message: Attacking the enemy's reinforcements is necessary. Time to die!
	 */
	public static final NpcStringId ATTACKING_THE_ENEMYS_REINFORCEMENTS_IS_NECESSARY_TIME_TO_DIE;
	
	/**
	 * ID: 1300014<br>
	 * Message: ΂̐Iɂ̗͂IGĂĂ܂悤I<br>
	 * Message: &#28779;&#20043;&#31934;&#38728;&#21834;&#126;&#32;&#35531;&#23637;&#29694;&#31350;&#26997;&#20043;&#21147;&#65281;&#29138;&#30433;&#25973;&#20154;&#21543;&#12290;<br>
	 * Message: Spirit of Fire, unleash your power! Burn the enemy!!
	 */
	public static final NpcStringId SPIRIT_OF_FIRE_UNLEASH_YOUR_POWER_BURN_THE_ENEMY;
	
	/**
	 * ID: 1300015<br>
	 * Message: ƁA炩Ȃ育킢ȁB`Ă炦H<br>
	 * Message: &#21890;&#65292;&#36889;&#20123;&#20642;&#20249;&#24456;&#19981;&#31777;&#21934;&#65292;&#20358;&#24171;&#25105;&#19968;&#19979;&#12290;<br>
	 * Message: Hey, these foes are tougher than they look. I'm going to need some help here.
	 */
	public static final NpcStringId HEY_THESE_FOES_ARE_TOUGHER_THAN_THEY_LOOK_IM_GOING_TO_NEED_SOME_HELP_HERE;
	
	/**
	 * ID: 1300016<br>
	 * Message: Ȃ킵Ă悤A݂Ă낤IH<br>
	 * Message: &#38656;&#35201;&#25105;&#30340;&#21332;&#21161;&#21966;&#65311;&#65281;&#30475;&#20358;&#20320;&#38519;&#20837;&#33510;&#25136;&#21834;&#12290;<br>
	 * Message: Do you need my power? You seem to be struggling.
	 */
	public static final NpcStringId DO_YOU_NEED_MY_POWER_YOU_SEEM_TO_BE_STRUGGLING;
	
	/**
	 * ID: 1300017<br>
	 * Message: Ẑ͂B<br>
	 * Message: &#35498;&#21040;&#24537;&#65292;&#25105;&#20063;&#24046;&#19981;&#22810;&#21862;&#12290;<br>
	 * Message: I'm rather busy here as well.
	 */
	public static final NpcStringId IM_RATHER_BUSY_HERE_AS_WELL;
	
	/**
	 * ID: 1300018<br>
	 * Message: ̂܂܂ŏIƎvȂBO̖]ɕ邾낤B<br>
	 * Message: &#19981;&#35201;&#20197;&#28858;&#25105;&#26371;&#23601;&#27492;&#32631;&#20241;&#65292;&#20320;&#20497;&#30340;&#37326;&#24515;&#20063;&#25744;&#19981;&#20102;&#22810;&#20037;&#20102;&#12290;<br>
	 * Message: Don't think that it's gonna end like this. Your ambition will soon be destroyed as well.
	 */
	public static final NpcStringId DONT_THINK_THAT_ITS_GONNA_END_LIKE_THIS_YOUR_AMBITION_WILL_SOON_BE_DESTROYED_AS_WELL;
	
	/**
	 * ID: 1300019<br>
	 * Message: ʊo͂łĂ邾낤ȁI<br>
	 * Message: &#20320;&#26377;&#28310;&#20633;&#22909;&#36865;&#27515;&#21543;&#65311;&#65281;<br>
	 * Message: You must have been prepared to die!
	 */
	public static final NpcStringId YOU_MUST_HAVE_BEEN_PREPARED_TO_DIE;
	
	/**
	 * ID: 1300020<br>
	 * Message: DDD̐gЂƂłvʂɂłȂƂ́AȂB̍ɗ܂Kv͂Ȃ낤B<br>
	 * Message: &#21628;&#21628;&#46;&#46;&#46;&#30495;&#26159;&#21487;&#24754;&#21487;&#27470;&#21834;&#65292;&#25105;&#31455;&#28982;&#36899;&#25105;&#33258;&#24049;&#37117;&#29031;&#39015;&#19981;&#20102;&#65292;&#37027;&#25105;&#20063;&#27794;&#29702;&#30001;&#32380;&#32396;&#24453;&#22312;&#36889;&#35041;&#20102;&#12290;<br>
	 * Message: I feel so much grief that I can't even take care of myself. There isn't any reason for me to stay here any longer.
	 */
	public static final NpcStringId I_FEEL_SO_MUCH_GRIEF_THAT_I_CANT_EVEN_TAKE_CARE_OF_MYSELF_THERE_ISNT_ANY_REASON_FOR_ME_TO_STAY_HERE_ANY_LONGER;
	
	/**
	 * ID: 1300101<br>
	 * Message: Icnv<br>
	 * Message: &#37326;&#29151;&#35201;&#22622;<br>
	 * Message: Shanty Fortress
	 */
	public static final NpcStringId SHANTY_FORTRESS;
	
	/**
	 * ID: 1300102<br>
	 * Message: O[fBI암v<br>
	 * Message: &#21476;&#39791;&#19969;&#21335;&#37096;&#35201;&#22622;<br>
	 * Message: Southern Fortress
	 */
	public static final NpcStringId SOUTHERN_FORTRESS;
	
	/**
	 * ID: 1300103<br>
	 * Message: nCv<br>
	 * Message: &#34562;&#31401;&#35201;&#22622;<br>
	 * Message: Hive Fortress
	 */
	public static final NpcStringId HIVE_FORTRESS;
	
	/**
	 * ID: 1300104<br>
	 * Message: kJv<br>
	 * Message: &#23805;&#35895;&#35201;&#22622;<br>
	 * Message: Valley Fortress
	 */
	public static final NpcStringId VALLEY_FORTRESS;
	
	/**
	 * ID: 1300105<br>
	 * Message: ۉ̓v<br>
	 * Message: &#35937;&#29273;&#22612;&#35201;&#22622;<br>
	 * Message: Ivory Fortress
	 */
	public static final NpcStringId IVORY_FORTRESS;
	
	/**
	 * ID: 1300106<br>
	 * Message: ΂̗v<br>
	 * Message: &#28246;&#27850;&#35201;&#22622;<br>
	 * Message: Narsell Fortress
	 */
	public static final NpcStringId NARSELL_FORTRESS;
	
	/**
	 * ID: 1300107<br>
	 * Message: ~nv<br>
	 * Message: &#30406;&#22320;&#35201;&#22622;<br>
	 * Message: Basin Fortress
	 */
	public static final NpcStringId BASIN_FORTRESS;
	
	/**
	 * ID: 1300108<br>
	 * Message: lv<br>
	 * Message: &#30333;&#27801;&#28760;&#35201;&#22622;<br>
	 * Message: White Sands Fortress
	 */
	public static final NpcStringId WHITE_SANDS_FORTRESS;
	
	/**
	 * ID: 1300109<br>
	 * Message: AEg|Xgv<br>
	 * Message: &#21069;&#21736;&#22522;&#22320;&#35201;&#22622;<br>
	 * Message: Borderland Fortress
	 */
	public static final NpcStringId BORDERLAND_FORTRESS;
	
	/**
	 * ID: 1300110<br>
	 * Message: nїv<br>
	 * Message: &#27836;&#28580;&#35201;&#22622;<br>
	 * Message: Swamp Fortress
	 */
	public static final NpcStringId SWAMP_FORTRESS;
	
	/**
	 * ID: 1300111<br>
	 * Message: ՗v<br>
	 * Message: &#36986;&#36321;&#35201;&#22622;<br>
	 * Message: Archaic Fortress
	 */
	public static final NpcStringId ARCHAIC_FORTRESS;
	
	/**
	 * ID: 1300112<br>
	 * Message: t[Ev<br>
	 * Message: &#33433;&#32645;&#34349;&#37002;&#22659;&#35201;&#22622;<br>
	 * Message: Floran Fortress
	 */
	public static final NpcStringId FLORAN_FORTRESS;
	
	/**
	 * ID: 1300113<br>
	 * Message: ̎REv<br>
	 * Message: &#34180;&#38695;&#23665;&#33032;&#37002;&#22659;&#35201;&#22622;<br>
	 * Message: Cloud Mountain Fortress
	 */
	public static final NpcStringId CLOUD_MOUNTAIN_FORTRESS;
	
	/**
	 * ID: 1300114<br>
	 * Message: ^m[Ev<br>
	 * Message: &#22612;&#35582;&#37002;&#22659;&#35201;&#22622;<br>
	 * Message: Tanor Fortress
	 */
	public static final NpcStringId TANOR_FORTRESS;
	
	/**
	 * ID: 1300115<br>
	 * Message: hS XpCEv<br>
	 * Message: &#40845;&#22763;&#20271;&#21535;&#37002;&#22659;&#35201;&#22622;<br>
	 * Message: Dragonspine Fortress
	 */
	public static final NpcStringId DRAGONSPINE_FORTRESS;
	
	/**
	 * ID: 1300116<br>
	 * Message: n̋Ev<br>
	 * Message: &#22320;&#40845;&#20043;&#37002;&#22659;&#35201;&#22622;<br>
	 * Message: Antharas's Fortress
	 */
	public static final NpcStringId ANTHARASS_FORTRESS;
	
	/**
	 * ID: 1300117<br>
	 * Message:  v<br>
	 * Message: &#35199;&#37096;&#22283;&#22659;&#37002;&#22659;&#35201;&#22622;<br>
	 * Message: Western Fortress
	 */
	public static final NpcStringId WESTERN_FORTRESS;
	
	/**
	 * ID: 1300118<br>
	 * Message: t̋Ev<br>
	 * Message: &#29557;&#20154;&#30340;&#37002;&#22659;&#35201;&#22622;<br>
	 * Message: Hunter's Fortress
	 */
	public static final NpcStringId HUNTERS_FORTRESS;
	
	/**
	 * ID: 1300119<br>
	 * Message: ̋Ev<br>
	 * Message: &#24179;&#21407;&#37002;&#22659;&#35201;&#22622;<br>
	 * Message: Aaru Fortress
	 */
	public static final NpcStringId AARU_FORTRESS;
	
	/**
	 * ID: 1300120<br>
	 * Message: ̋Ev<br>
	 * Message: &#27515;&#38728;&#30340;&#37002;&#22659;&#35201;&#22622;<br>
	 * Message: Demon Fortress
	 */
	public static final NpcStringId DEMON_FORTRESS;
	
	/**
	 * ID: 1300121<br>
	 * Message: ҂̋Ev<br>
	 * Message: &#32854;&#32773;&#37002;&#22659;&#35201;&#22622;<br>
	 * Message: Monastic Fortress
	 */
	public static final NpcStringId MONASTIC_FORTRESS;
	
	/**
	 * ID: 1300122<br>
	 * Message: Ɨ<br>
	 * Message: &#29544;&#31435;&#29376;&#24907;<br>
	 * Message: Independent State
	 */
	public static final NpcStringId INDEPENDENT_STATE;
	
	/**
	 * ID: 1300123<br>
	 * Message: ֌W<br>
	 * Message: &#28961;&#38364;&#20418;<br>
	 * Message: Nonpartisan
	 */
	public static final NpcStringId NONPARTISAN;
	
	/**
	 * ID: 1300124<br>
	 * Message: _<br>
	 * Message: &#22865;&#32004;&#29376;&#24907;<br>
	 * Message: Contract State
	 */
	public static final NpcStringId CONTRACT_STATE;
	
	/**
	 * ID: 1300125<br>
	 * Message: 1Ԗڂ̃pX[h͂܂B<br>
	 * Message: &#27491;&#30906;&#36664;&#20837;&#20102;&#31532;&#19968;&#20491;&#23494;&#30908;&#12290;<br>
	 * Message: First password has been entered.
	 */
	public static final NpcStringId FIRST_PASSWORD_HAS_BEEN_ENTERED;
	
	/**
	 * ID: 1300126<br>
	 * Message: 2Ԗڂ̃pX[h͂܂B<br>
	 * Message: &#27491;&#30906;&#36664;&#20837;&#20102;&#31532;&#20108;&#20491;&#23494;&#30908;&#12290;<br>
	 * Message: Second password has been entered.
	 */
	public static final NpcStringId SECOND_PASSWORD_HAS_BEEN_ENTERED;
	
	/**
	 * ID: 1300127<br>
	 * Message: pX[h͂܂łB<br>
	 * Message: &#27794;&#26377;&#36664;&#20837;&#27491;&#30906;&#23494;&#30908;&#12290;<br>
	 * Message: Password has not been entered.
	 */
	public static final NpcStringId PASSWORD_HAS_NOT_BEEN_ENTERED;
	
	/**
	 * ID: 1300128<br>
	 * Message:  $s1 / 3ڂsĂ܂B<br>
	 * Message: &#30446;&#21069;&#27491;&#22312;&#22039;&#35430;&#12300;&#36;&#115;&#49;&#12301;&#47;&#32;&#31532;&#51;&#32;&#27425;&#12290;<br>
	 * Message: Attempt $s1 / 3 is in progress. => This is the third attempt on $s1.
	 */
	public static final NpcStringId ATTEMPT_S1_3_IS_IN_PROGRESS_THIS_IS_THE_THIRD_ATTEMPT_ON_S1;
	
	/**
	 * ID: 1300129<br>
	 * Message: 1Ԃ̋L킹܂B<br>
	 * Message: &#29468;&#23565;&#20102;&#49;&#34399;&#31526;&#34399;&#12290;<br>
	 * Message: The 1st Mark is correct.
	 */
	public static final NpcStringId THE_1ST_MARK_IS_CORRECT;
	
	/**
	 * ID: 1300130<br>
	 * Message: 2Ԃ̋L킹܂B<br>
	 * Message: &#29468;&#23565;&#20102;&#50;&#34399;&#31526;&#34399;&#12290;<br>
	 * Message: The 2nd Mark is correct.
	 */
	public static final NpcStringId THE_2ND_MARK_IS_CORRECT;
	
	/**
	 * ID: 1300131<br>
	 * Message: L̑gݍ킹Ɏs܂B<br>
	 * Message: &#31526;&#34399;&#32068;&#21512;&#19981;&#31526;&#12290;<br>
	 * Message: The Marks have not been assembled.
	 */
	public static final NpcStringId THE_MARKS_HAVE_NOT_BEEN_ASSEMBLED;
	
	/**
	 * ID: 1300132<br>
	 * Message: ܂Ȃ$s1X^WAŁAIsA[hNX`[Zn܂܂B<br>
	 * Message: &#31245;&#24460;&#23559;&#22312;&#31532;&#12300;&#36;&#115;&#49;&#12301;&#31478;&#25216;&#22580;&#33289;&#34892;&#22887;&#26519;&#21305;&#20126;&#19981;&#38480;&#32887;&#26989;&#39006;&#21029;&#38538;&#20237;&#27604;&#36093;&#12290;<br>
	 * Message: Olympiad class-free team match is going to begin in Arena $s1 in a moment.
	 */
	public static final NpcStringId OLYMPIAD_CLASS_FREE_TEAM_MATCH_IS_GOING_TO_BEGIN_IN_ARENA_S1_IN_A_MOMENT;
	
	/**
	 * ID: 1300133<br>
	 * Message: ̒nv<br>
	 * Message: &#38936;&#22320;&#35201;&#22622;<br>
	 * Message: Domain Fortress
	 */
	public static final NpcStringId DOMAIN_FORTRESS;
	
	/**
	 * ID: 1300134<br>
	 * Message: Ev<br>
	 * Message: &#37002;&#22659;&#35201;&#22622;<br>
	 * Message: Boundary Fortress
	 */
	public static final NpcStringId BOUNDARY_FORTRESS;
	
	/**
	 * ID: 1300135<br>
	 * Message: $s1 $s2<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#26178;&#12300;&#36;&#115;&#50;&#12301;&#20998;<br>
	 * Message: $s1hour $s2minute
	 */
	public static final NpcStringId S1HOUR_S2MINUTE;
	
	/**
	 * ID: 1300136<br>
	 * Message: wł܂B<br>
	 * Message: &#28961;&#27861;&#25351;&#23450;<br>
	 * Message: Not designated
	 */
	public static final NpcStringId NOT_DESIGNATED;
	
	/**
	 * ID: 1300137<br>
	 * Message: EmA̐g̉X~ɗĂꂽłˁB<br>
	 * Message: &#21191;&#22763;&#20497;&#21834;&#65292;&#20320;&#20497;&#32066;&#26044;&#20358;&#25327;&#25937;&#22256;&#26044;&#27492;&#22320;&#30340;&#25105;&#20497;&#21862;&#12290;<br>
	 * Message: Warriors, have you come to help those who are imprisoned here?
	 */
	public static final NpcStringId WARRIORS_HAVE_YOU_COME_TO_HELP_THOSE_WHO_ARE_IMPRISONED_HERE;
	
	/**
	 * ID: 1300138<br>
	 * Message: 炦IYI<br>
	 * Message: &#25509;&#25307;&#21543;&#65281;&#20320;&#36889;&#36575;&#24369;&#30340;&#20642;&#20249;&#65281;<br>
	 * Message: Take that, you weakling!
	 */
	public static final NpcStringId TAKE_THAT_YOU_WEAKLING;
	
	/**
	 * ID: 1300139<br>
	 * Message: ͋񂾁I<br>
	 * Message: &#25105;&#24456;&#24375;&#24717;&#65281;<br>
	 * Message: Behold my might!
	 */
	public static final NpcStringId BEHOLD_MY_MIGHT;
	
	/**
	 * ID: 1300140<br>
	 * Message: CȂ肻B<br>
	 * Message: &#31934;&#31070;&#23559;&#26371;&#35722;&#24471;&#26377;&#40670;&#24653;&#24794;&#12290;<br>
	 * Message: Your mind is going blank...
	 */
	public static final NpcStringId YOUR_MIND_IS_GOING_BLANK;
	
	/**
	 * ID: 1300141<br>
	 * Message: ɂ݂̐܂ł݂킽邺DDD<br>
	 * Message: &#30171;&#21040;&#39592;&#23376;&#35041;&#21862;&#46;&#46;&#46;<br>
	 * Message: Ugh, it hurts down to the bones...
	 */
	public static final NpcStringId UGH_IT_HURTS_DOWN_TO_THE_BONES;
	
	/**
	 * ID: 1300142<br>
	 * Message: EȁBDDD<br>
	 * Message: &#19981;&#33021;&#20877;&#25744;&#19979;&#21435;&#20102;&#12290;&#21571;&#21834;&#46;&#46;&#46;<br>
	 * Message: I can't stand it anymore. Aah...
	 */
	public static final NpcStringId I_CANT_STAND_IT_ANYMORE_AAH;
	
	/**
	 * ID: 1300143<br>
	 * Message: `I<br>
	 * Message: &#21769;&#21568;&#21568;<br>
	 * Message: Kyaaak!
	 */
	public static final NpcStringId KYAAAK;
	
	/**
	 * ID: 1300144<br>
	 * Message: AȂĂI<br>
	 * Message: &#21571;&#46;&#46;&#46;&#35912;&#26377;&#27492;&#29702;&#46;&#46;&#46;<br>
	 * Message: Gasp! How can this be?
	 */
	public static final NpcStringId GASP_HOW_CAN_THIS_BE;
	
	/**
	 * ID: 1300145<br>
	 * Message: Ă߂IƓ΂΂ɂĂ̂I<br>
	 * Message: &#36889;&#20123;&#20642;&#20249;&#65292;&#25105;&#35201;&#20320;&#20497;&#30862;&#23629;&#33836;&#27573;&#65281;<br>
	 * Message: I'll rip the flesh from your bones!
	 */
	public static final NpcStringId ILL_RIP_THE_FLESH_FROM_YOUR_BONES;
	
	/**
	 * ID: 1300146<br>
	 * Message: ꐶAϑz̏Œn̐ӂߋ𖡂킹ĂI<br>
	 * Message: &#25105;&#35201;&#20320;&#20497;&#36889;&#19968;&#29983;&#27704;&#36960;&#37117;&#22312;&#22916;&#24819;&#20013;&#25497;&#25166;&#65281;<br>
	 * Message: You'll flounder in delusion for the rest of your life!
	 */
	public static final NpcStringId YOULL_FLOUNDER_IN_DELUSION_FOR_THE_REST_OF_YOUR_LIFE;
	
	/**
	 * ID: 1300147<br>
	 * Message: 甲o@͂ȂI<br>
	 * Message: &#24050;&#32147;&#27794;&#26377;&#36774;&#27861;&#36867;&#38626;&#27492;&#22320;&#20102;&#65281;<br>
	 * Message: There is no escape from this place!
	 */
	public static final NpcStringId THERE_IS_NO_ESCAPE_FROM_THIS_PLACE;
	
	/**
	 * ID: 1300148<br>
	 * Message: Ă߂ANƎvĂ񂾁I<br>
	 * Message: &#20320;&#20497;&#36889;&#20123;&#20642;&#20249;&#31455;&#25954;&#46;&#46;&#46;<br>
	 * Message: How dare you!
	 */
	public static final NpcStringId HOW_DARE_YOU;
	
	/**
	 * ID: 1300149<br>
	 * Message: |ĂI<br>
	 * Message: &#25105;&#24517;&#23559;&#25802;&#20498;&#20320;&#20497;&#12290;<br>
	 * Message: I shall defeat you.
	 */
	public static final NpcStringId I_SHALL_DEFEAT_YOU;
	
	/**
	 * ID: 1300150<br>
	 * Message: 1iKX^[gI<br>
	 * Message: &#31532;&#49;&#38542;&#27573;&#38283;&#22987;&#65281;<br>
	 * Message: Begin stage 1!
	 */
	public static final NpcStringId BEGIN_STAGE_1;
	
	/**
	 * ID: 1300151<br>
	 * Message: 2iKX^[gI<br>
	 * Message: &#31532;&#50;&#38542;&#27573;&#38283;&#22987;&#65281;<br>
	 * Message: Begin stage 2!
	 */
	public static final NpcStringId BEGIN_STAGE_2;
	
	/**
	 * ID: 1300152<br>
	 * Message: 3iKX^[gI<br>
	 * Message: &#31532;&#51;&#38542;&#27573;&#38283;&#22987;&#65281;<br>
	 * Message: Begin stage 3!
	 */
	public static final NpcStringId BEGIN_STAGE_3;
	
	/**
	 * ID: 1300153<br>
	 * Message: 萋łˁI͗EҗlMĂ܂BƂ͂ł܂񂪁AS΂̂pӂ܂BXԂ܂ł傤B<br>
	 * Message: &#24744;&#20570;&#21040;&#21862;&#65281;&#25105;&#20497;&#19968;&#30452;&#37117;&#23565;&#21191;&#22763;&#24744;&#25265;&#26377;&#20449;&#24515;&#12290;&#25105;&#20497;&#24819;&#35201;&#34920;&#36948;&#25105;&#20497;&#30340;&#23567;&#23567;&#24515;&#24847;&#65292;&#35531;&#24744;&#25277;&#40670;&#26178;&#38291;&#22909;&#21966;&#65311;<br>
	 * Message: You've done it! We believed in you, warrior. We want to show our sincerity, though it is small. Please give me some of your time.
	 */
	public static final NpcStringId YOUVE_DONE_IT_WE_BELIEVED_IN_YOU_WARRIOR_WE_WANT_TO_SHOW_OUR_SINCERITY_THOUGH_IT_IS_SMALL_PLEASE_GIVE_ME_SOME_OF_YOUR_TIME;
	
	/**
	 * ID: 1300154<br>
	 * Message: _̋Ïk@ғ܂B<br>
	 * Message: &#20013;&#22830;&#25818;&#40670;&#30340;&#20957;&#32080;&#22120;&#21363;&#23559;&#21855;&#21205;&#12290;<br>
	 * Message: The Central Stronghold's compressor is working.
	 */
	public static final NpcStringId THE_CENTRAL_STRONGHOLDS_COMPRESSOR_IS_WORKING;
	
	/**
	 * ID: 1300155<br>
	 * Message: 1_̋Ïk@ғ܂B<br>
	 * Message: &#31532;&#49;&#25818;&#40670;&#30340;&#20957;&#32080;&#22120;&#21363;&#23559;&#21855;&#21205;&#12290;<br>
	 * Message: Stronghold I's compressor is working.
	 */
	public static final NpcStringId STRONGHOLD_IS_COMPRESSOR_IS_WORKING;
	
	/**
	 * ID: 1300156<br>
	 * Message: 2_̋Ïk@ғ܂B<br>
	 * Message: &#31532;&#50;&#25818;&#40670;&#30340;&#20957;&#32080;&#22120;&#21363;&#23559;&#21855;&#21205;&#12290;<br>
	 * Message: Stronghold II's compressor is working.
	 */
	public static final NpcStringId STRONGHOLD_IIS_COMPRESSOR_IS_WORKING;
	
	/**
	 * ID: 1300157<br>
	 * Message: 3_̋Ïk@ғ܂B<br>
	 * Message: &#31532;&#51;&#25818;&#40670;&#30340;&#20957;&#32080;&#22120;&#21363;&#23559;&#21855;&#21205;&#12290;<br>
	 * Message: Stronghold III's compressor is working.
	 */
	public static final NpcStringId STRONGHOLD_IIIS_COMPRESSOR_IS_WORKING;
	
	/**
	 * ID: 1300158<br>
	 * Message: _̋Ïk@j󂳂܂B<br>
	 * Message: &#24050;&#25915;&#30772;&#20013;&#22830;&#25818;&#40670;&#30340;&#20957;&#32080;&#22120;&#12290;<br>
	 * Message: The Central Stronghold's compressor has been destroyed.
	 */
	public static final NpcStringId THE_CENTRAL_STRONGHOLDS_COMPRESSOR_HAS_BEEN_DESTROYED;
	
	/**
	 * ID: 1300159<br>
	 * Message: 1_̋Ïk@j󂳂܂B<br>
	 * Message: &#24050;&#25915;&#30772;&#31532;&#49;&#25818;&#40670;&#30340;&#20957;&#32080;&#22120;&#12290;<br>
	 * Message: Stronghold I's compressor has been destroyed.
	 */
	public static final NpcStringId STRONGHOLD_IS_COMPRESSOR_HAS_BEEN_DESTROYED;
	
	/**
	 * ID: 1300160<br>
	 * Message: 2_̋Ïk@j󂳂܂B<br>
	 * Message: &#24050;&#25915;&#30772;&#31532;&#50;&#25818;&#40670;&#30340;&#20957;&#32080;&#22120;&#12290;<br>
	 * Message: Stronghold II's compressor has been destroyed.
	 */
	public static final NpcStringId STRONGHOLD_IIS_COMPRESSOR_HAS_BEEN_DESTROYED;
	
	/**
	 * ID: 1300161<br>
	 * Message: 3_̋Ïk@j󂳂܂B<br>
	 * Message: &#24050;&#25915;&#30772;&#31532;&#51;&#25818;&#40670;&#30340;&#20957;&#32080;&#22120;&#12290;<br>
	 * Message: Stronghold III's compressor has been destroyed.
	 */
	public static final NpcStringId STRONGHOLD_IIIS_COMPRESSOR_HAS_BEEN_DESTROYED;
	
	/**
	 * ID: 1300162<br>
	 * Message: ȂĂICĂƂĂɂȂB<br>
	 * Message: &#30495;&#26159;&#29436;&#29437;&#19981;&#22570;&#21834;&#46;&#46;&#46;&#21147;&#27683;&#22823;&#65292;&#26524;&#28982;&#19981;&#22909;&#25511;&#21046;&#12290;<br>
	 * Message: What a predicament... my attempts were unsuccessful.
	 */
	public static final NpcStringId WHAT_A_PREDICAMENT_MY_ATTEMPTS_WERE_UNSUCCESSFUL;
	
	/**
	 * ID: 1300163<br>
	 * Message: ECIeCICI̒nŐ퓬JLbǏɏW܂BxƖ_҂ĂB<br>
	 * Message: &#21191;&#27683;&#65281;&#39748;&#21147;&#65281;&#34880;&#27683;&#65281;&#35201;&#22312;&#38936;&#22320;&#25136;&#23526;&#29694;&#25136;&#39717;&#22818;&#24819;&#30340;&#20653;&#20853;&#20497;&#21834;&#65292;&#20358;&#21040;&#25105;&#30340;&#36319;&#21069;&#65281;&#36001;&#23500;&#21644;&#21517;&#35709;&#27491;&#31561;&#33879;&#20320;&#20497;&#21602;&#65281;<br>
	 * Message: Courage! Ambition! Passion! Mercenaries who want to realize their dream of fighting in the territory war, come to me! Fortune and glory are waiting for you!
	 */
	public static final NpcStringId COURAGE_AMBITION_PASSION_MERCENARIES_WHO_WANT_TO_REALIZE_THEIR_DREAM_OF_FIGHTING_IN_THE_TERRITORY_WAR_COME_TO_ME_FORTUNE_AND_GLORY_ARE_WAITING_FOR_YOU;
	
	/**
	 * ID: 1300164<br>
	 * Message: 킢̂B|āHB悤Ă͂ȂBȂ΁AXb݂͂I<br>
	 * Message: &#24819;&#35201;&#25136;&#39717;&#21966;&#65311;&#26371;&#24863;&#21040;&#23475;&#24597;&#65311;&#65281;&#20877;&#24590;&#40636;&#36530;&#20063;&#28961;&#34389;&#21487;&#36867;&#20102;&#12290;&#33509;&#24819;&#35201;&#23565;&#25136;&#65292;&#25105;&#20497;&#20653;&#20853;&#38538;&#23559;&#26371;&#35242;&#33258;&#20986;&#39340;&#20358;&#25300;&#20992;&#30456;&#21161;&#65281;<br>
	 * Message: Do you wish to fight? Are you afraid? No matter how hard you try, you have nowhere to run. But if you face it head on, our mercenary troop will help you out!
	 */
	public static final NpcStringId DO_YOU_WISH_TO_FIGHT_ARE_YOU_AFRAID_NO_MATTER_HOW_HARD_YOU_TRY_YOU_HAVE_NOWHERE_TO_RUN_BUT_IF_YOU_FACE_IT_HEAD_ON_OUR_MERCENARY_TROOP_WILL_HELP_YOU_OUT;
	
	/**
	 * ID: 1300165<br>
	 * Message: ˌIˌIˌI<br>
	 * Message: &#31361;&#25802;&#65281;&#31361;&#25802;&#65281;&#31361;&#25802;&#65281;<br>
	 * Message: Charge! Charge! Charge!
	 */
	public static final NpcStringId CHARGE_CHARGE_CHARGE;
	
	/**
	 * ID: 1300166<br>
	 * Message: ܂Ȃ$s1X^WAŁAIsA[hNXlZn܂܂B<br>
	 * Message: &#31245;&#24460;&#23559;&#22312;&#31532;&#12300;&#36;&#115;&#49;&#12301;&#31478;&#25216;&#22580;&#33289;&#34892;&#22887;&#26519;&#21305;&#20126;&#19981;&#38480;&#32887;&#26989;&#39006;&#21029;&#20491;&#20154;&#27604;&#36093;&#12290;<br>
	 * Message: Olympiad class-free individual match is going to begin in Arena $s1 in a moment.
	 */
	public static final NpcStringId OLYMPIAD_CLASS_FREE_INDIVIDUAL_MATCH_IS_GOING_TO_BEGIN_IN_ARENA_S1_IN_A_MOMENT;
	
	/**
	 * ID: 1300167<br>
	 * Message: ܂Ȃ$s1X^WAŁAIsA[hNXʌlZn܂܂B<br>
	 * Message: &#31245;&#24460;&#23559;&#22312;&#31532;&#12300;&#36;&#115;&#49;&#12301;&#31478;&#25216;&#22580;&#33289;&#34892;&#22887;&#26519;&#21305;&#32887;&#26989;&#39006;&#21029;&#20491;&#20154;&#27604;&#36093;&#12290;<br>
	 * Message: Olympiad class individual match is going to begin in Arena $s1 in a moment.
	 */
	public static final NpcStringId OLYMPIAD_CLASS_INDIVIDUAL_MATCH_IS_GOING_TO_BEGIN_IN_ARENA_S1_IN_A_MOMENT;
	
	/**
	 * ID: 1600001<br>
	 * Message: ̃LN^[ɕ⏕@rłB΂炭ĂēxB<br>
	 * Message: &#27491;&#23565;&#20854;&#20182;&#29609;&#23478;&#26045;&#23637;&#36628;&#21161;&#39764;&#27861;&#20013;&#65292;&#35531;&#31245;&#24460;&#20877;&#35430;&#12290;<br>
	 * Message: Another player is currently being buffed. Please try again in a moment.
	 */
	public static final NpcStringId ANOTHER_PLAYER_IS_CURRENTLY_BEING_BUFFED_PLEASE_TRY_AGAIN_IN_A_MOMENT;
	
	/**
	 * ID: 1600002<br>
	 * Message: ϐgɂ͓ł܂B<br>
	 * Message: &#34389;&#26044;&#35722;&#36523;&#29376;&#24907;&#26178;&#28961;&#27861;&#39438;&#20056;&#12290;<br>
	 * Message: You cannot mount while you are polymorphed.
	 */
	public static final NpcStringId YOU_CANNOT_MOUNT_WHILE_YOU_ARE_POLYMORPHED;
	
	/**
	 * ID: 1600003<br>
	 * Message: 퓬ԂAXgC_[ɓ悵Ԃł̓Co[ɏ܂B<br>
	 * Message: &#34389;&#26044;&#25136;&#39717;&#29376;&#24907;&#25110;&#39438;&#20056;&#24231;&#40845;&#26178;&#65292;&#28961;&#27861;&#39438;&#20056;&#39131;&#40845;&#12290;<br>
	 * Message: You cannot mount a Wyvern while in battle mode or while mounted on a Strider.
	 */
	public static final NpcStringId YOU_CANNOT_MOUNT_A_WYVERN_WHILE_IN_BATTLE_MODE_OR_WHILE_MOUNTED_ON_A_STRIDER;
	
	/**
	 * ID: 1600004<br>
	 * Message: DDDDDD<br>
	 * Message: &#21756;&#46;&#46;&#35342;&#21421;&#46;&#46;<br>
	 * Message: Boo-hoo... I hate...
	 */
	public static final NpcStringId BOO_HOO_I_HATE;
	
	/**
	 * ID: 1600005<br>
	 * Message: ܂ˁ`I<br>
	 * Message: &#19979;&#27425;&#20877;&#35211;&#22217;&#126;<br>
	 * Message: See you later.
	 */
	public static final NpcStringId SEE_YOU_LATER;
	
	/**
	 * ID: 1600006<br>
	 * Message: 悭Ił܂I<br>
	 * Message: &#30495;&#26159;&#21331;&#36234;&#30340;&#36984;&#25799;&#12290;<br>
	 * Message: You've made a great choice.
	 */
	public static final NpcStringId YOUVE_MADE_A_GREAT_CHOICE;
	
	/**
	 * ID: 1600007<br>
	 * Message: ̒̃ucEYĂ那B<br>
	 * Message: &#23436;&#25104;&#21697;&#22312;&#25105;&#30340;&#32922;&#23376;&#35041;&#34850;&#34850;&#27442;&#21205;&#21602;&#126;<br>
	 * Message: Thanks! I feel more relaxed
	 */
	public static final NpcStringId THANKS_I_FEEL_MORE_RELAXED;
	
	/**
	 * ID: 1600008<br>
	 * Message: IŁÎ̓NYI<br>
	 * Message: &#24744;&#27794;&#30475;&#21040;&#37027;&#29190;&#30332;&#30340;&#29017;&#28779;&#21966;&#65311;&#65281;<br>
	 * Message: Did you see that Firecracker explode?
	 */
	public static final NpcStringId DID_YOU_SEE_THAT_FIRECRACKER_EXPLODE;
	
	/**
	 * ID: 1600009<br>
	 * Message: ₢IɂȂŁI<br>
	 * Message: &#25105;&#27794;&#20160;&#40636;&#29305;&#21029;&#30340;&#12290;<br>
	 * Message: I am nothing.
	 */
	public static final NpcStringId I_AM_NOTHING;
	
	/**
	 * ID: 1600010<br>
	 * Message: Aڂ肷łI<br>
	 * Message: &#25105;&#25165;&#26159;&#36008;&#30495;&#20729;&#23526;&#30340;&#21862;&#12290;<br>
	 * Message: I am telling the truth.
	 */
	public static final NpcStringId I_AM_TELLING_THE_TRUTH;
	
	/**
	 * ID: 1600012<br>
	 * Message: oւ̃e|[g̓^_łłႤB<br>
	 * Message: &#20659;&#36865;&#33267;&#30070;&#21021;&#25152;&#20986;&#30332;&#30340;&#26449;&#33674;&#26159;&#20813;&#36027;&#26381;&#21209;&#30340;&#12290;<br>
	 * Message: It's free to go back to the village you teleported from.
	 */
	public static final NpcStringId ITS_FREE_TO_GO_BACK_TO_THE_VILLAGE_YOU_TELEPORTED_FROM;
	
	/**
	 * ID: 1600013<br>
	 * Message: 󕨂̑܂̐؂[50W߂ĂꂽA{N񂪕󕨂̑܂ɑւĂ邩ˁB<br>
	 * Message: &#25910;&#38598;&#23542;&#34955;&#30862;&#29255;&#53;&#48;&#20491;&#22238;&#20358;&#23601;&#26371;&#20132;&#25563;&#23542;&#34955;&#32102;&#24744;&#12290;<br>
	 * Message: If you collect 50 individual Treasure Sack Pieces, you can exchange them for a Treasure Sack.
	 */
	public static final NpcStringId IF_YOU_COLLECT_50_INDIVIDUAL_TREASURE_SACK_PIECES_YOU_CAN_EXCHANGE_THEM_FOR_A_TREASURE_SACK;
	
	/**
	 * ID: 1600014<br>
	 * Message: ETMɕϐgȂƔȂB<br>
	 * Message: &#35722;&#36523;&#28858;&#20820;&#23376;&#24460;&#25165;&#33021;&#23563;&#25214;&#31665;&#23376;&#12290;<br>
	 * Message: You must be transformed into a Treasure Hunter to find a chest.
	 */
	public static final NpcStringId YOU_MUST_BE_TRANSFORMED_INTO_A_TREASURE_HUNTER_TO_FIND_A_CHEST;
	
	/**
	 * ID: 1600015<br>
	 * Message: ETM̕ϐg͂Ⴄ񂾁BADȏꏊɈڂĂXN[gB<br>
	 * Message: &#20820;&#23376;&#35722;&#36523;&#25928;&#26524;&#26997;&#30701;&#65292;&#22240;&#27492;&#24314;&#35696;&#21069;&#24448;&#24819;&#35201;&#35722;&#36523;&#30340;&#22320;&#26041;&#20043;&#24460;&#20877;&#20351;&#29992;&#21367;&#36600;&#12290;<br>
	 * Message: You'd better use the Transformation spell at the right moment since it doesn't last long.
	 */
	public static final NpcStringId YOUD_BETTER_USE_THE_TRANSFORMATION_SPELL_AT_THE_RIGHT_MOMENT_SINCE_IT_DOESNT_LAST_LONG;
	
	/**
	 * ID: 1600016<br>
	 * Message: z̓͂ǂłs[X][ˁB<br>
	 * Message: &#22818;&#24187;&#23798;&#20839;&#30340;&#25152;&#26377;&#21312;&#22495;&#37117;&#26159;&#23433;&#20840;&#21312;&#22495;&#12290;<br>
	 * Message: All of Fantasy Isle is a Peace Zone.
	 */
	public static final NpcStringId ALL_OF_FANTASY_ISLE_IS_A_PEACE_ZONE;
	
	/**
	 * ID: 1600017<br>
	 * Message: z̓܂Ń{N񂪃^_őĂႤB<br>
	 * Message: &#20813;&#36027;&#25552;&#20379;&#20659;&#36865;&#21040;&#22818;&#24187;&#23798;&#30340;&#26381;&#21209;&#21908;&#126;<br>
	 * Message: If you need to go to Fantasy Isle, come see me.
	 */
	public static final NpcStringId IF_YOU_NEED_TO_GO_TO_FANTASY_ISLE_COME_SEE_ME;
	
	/**
	 * ID: 1600018<br>
	 * Message: ETMϐgXN[̔̔12ԂƂˁB<br>
	 * Message: &#20820;&#23376;&#35722;&#36523;&#21367;&#36600;&#22312;&#27599;&#49;&#50;&#23567;&#26178;&#21482;&#33021;&#36092;&#36023;&#19968;&#27425;&#12290;<br>
	 * Message: You can only purchase a Treasure Hunter Transformation Scroll once every 12 hours.
	 */
	public static final NpcStringId YOU_CAN_ONLY_PURCHASE_A_TREASURE_HUNTER_TRANSFORMATION_SCROLL_ONCE_EVERY_12_HOURS;
	
	/**
	 * ID: 1600019<br>
	 * Message: H܂ňႤ@ŗ́HꂶA߂̃Ȇ֑ĂˁB<br>
	 * Message: &#24744;&#26159;&#21033;&#29992;&#20854;&#20182;&#26041;&#27861;&#20358;&#30340;&#21834;&#12290;&#37027;&#25105;&#23559;&#24744;&#20659;&#36865;&#21040;&#26368;&#37168;&#36817;&#30340;&#26449;&#33674;&#45;&#39791;&#22240;&#22478;&#37806;&#21543;&#12290;<br>
	 * Message: If your means of arrival was a bit unconventional, then I'll be sending you back to Rune Township, which is the nearest town.
	 */
	public static final NpcStringId IF_YOUR_MEANS_OF_ARRIVAL_WAS_A_BIT_UNCONVENTIONAL_THEN_ILL_BE_SENDING_YOU_BACK_TO_RUNE_TOWNSHIP_WHICH_IS_THE_NEAREST_TOWN;
	
	/**
	 * ID: 1600020<br>
	 * Message: hhbB<br>
	 * Message: &#30031;&#32302;<br>
	 * Message: *Rattle*
	 */
	public static final NpcStringId RATTLE;
	
	/**
	 * ID: 1600021<br>
	 * Message: K^SgbB<br>
	 * Message: &#20985;&#20984;&#19981;&#24179;<br>
	 * Message: *Bump*
	 */
	public static final NpcStringId BUMP;
	
	/**
	 * ID: 1600022<br>
	 * Message: ܂B<br>
	 * Message: &#24744;&#19968;&#23450;&#26371;&#24460;&#24724;&#30340;&#12290;<br>
	 * Message: You will regret this.
	 */
	public static final NpcStringId YOU_WILL_REGRET_THIS;
	
	/**
	 * ID: 1600023<br>
	 * Message: ӂӂӁDDDǂAECȂ^Ă݂ȂB<br>
	 * Message: &#21621;&#21621;&#21621;&#46;&#46;&#46;&#20320;&#26377;&#21191;&#27683;&#24819;&#35201;&#35430;&#35430;&#33258;&#24049;&#30340;&#36939;&#27683;&#21966;&#65311;<br>
	 * Message: Care to challenge fate and test your luck?
	 */
	public static final NpcStringId CARE_TO_CHALLENGE_FATE_AND_TEST_YOUR_LUCK;
	
	/**
	 * ID: 1600024<br>
	 * Message: S80͗~ȂB<br>
	 * Message: &#20320;&#126;&#32;&#19981;&#24819;&#25343;&#21040;&#83;&#56;&#48;&#27494;&#22120;&#21966;&#65311;<br>
	 * Message: Don't pass up the chance to win an S80 weapon.
	 */
	public static final NpcStringId DONT_PASS_UP_THE_CHANCE_TO_WIN_AN_S80_WEAPON;
	
	/**
	 * ID: 1800009<br>
	 * Message: hbv ACez # $s1A`lɂ܂B<br>
	 * Message: &#25481;&#33853;&#36947;&#20855;&#30340;&#29289;&#21697;&#20998;&#37197;&#27402;&#38480;&#65292;&#22312;&#35;&#12300;&#36;&#115;&#49;&#12301;&#25152;&#23660;&#30340;&#25351;&#25582;&#38971;&#36947;&#12290;<br>
	 * Message: # $s1's Command Channel has looting rights.
	 */
	public static final NpcStringId _S1S_COMMAND_CHANNEL_HAS_LOOTING_RIGHTS;
	
	/**
	 * ID: 1800010<br>
	 * Message: hbv ACez܂B<br>
	 * Message: &#35299;&#38500;&#25481;&#33853;&#36947;&#20855;&#30340;&#29289;&#21697;&#20998;&#37197;&#27402;&#38480;&#12290;<br>
	 * Message: Looting rules are no longer active.
	 */
	public static final NpcStringId LOOTING_RULES_ARE_NO_LONGER_ACTIVE;
	
	/**
	 * ID: 1800011<br>
	 * Message: `Ill̂߂肾BKdԂĂ͂IOƂŎ̂B<br>
	 * Message: &#22030;&#21834;&#21834;&#126;&#25105;&#20497;&#30340;&#20027;&#20154;&#39340;&#19978;&#23601;&#26371;&#20358;&#22577;&#20167;&#21862;&#12290;&#36942;&#19981;&#20037;&#20320;&#20497;&#20063;&#23559;&#26371;&#35722;&#25104;&#23629;&#39636;&#46;&#46;&#46;<br>
	 * Message: Our master now comes to claim our vengeance. Soon you will all be nothing more than dirt...
	 */
	public static final NpcStringId OUR_MASTER_NOW_COMES_TO_CLAIM_OUR_VENGEANCE_SOON_YOU_WILL_ALL_BE_NOTHING_MORE_THAN_DIRT;
	
	/**
	 * ID: 1800012<br>
	 * Message: ťNɒގ҂Ɏ<br>
	 * Message: &#23559;&#25361;&#25136;&#40654;&#26126;&#30340;&#21531;&#20027;&#32773;&#34389;&#27515;&#21543;&#65281;<br>
	 * Message: Death to those who challenge the Lords of Dawn!
	 */
	public static final NpcStringId DEATH_TO_THOSE_WHO_CHALLENGE_THE_LORDS_OF_DAWN;
	
	/**
	 * ID: 1800013<br>
	 * Message: ɒގ҂Ɏ<br>
	 * Message: &#23559;&#25361;&#25136;&#32854;&#24231;&#20043;&#20154;&#36060;&#27515;&#21543;&#65281;<br>
	 * Message: Death to those who challenge the Lord!
	 */
	public static final NpcStringId DEATH_TO_THOSE_WHO_CHALLENGE_THE_LORD;
	
	/**
	 * ID: 1800014<br>
	 * Message: uquqIu^΂łłIA^X畉̒ sbO X^I<br>
	 * Message: &#21756;&#21756;&#65281;&#35948;&#20063;&#33021;&#20570;&#21040;&#65281;&#36229;&#36234;&#23433;&#22612;&#29790;&#26031;&#30340;&#36229;&#24375;&#21147;&#32982;&#35948;&#34909;&#25802;&#65281;<br>
	 * Message: Oink oink! Pigs can do it too! Antharas-Surpassing Super Powered Pig Stun! How do like them apples?
	 */
	public static final NpcStringId OINK_OINK_PIGS_CAN_DO_IT_TOO_ANTHARAS_SURPASSING_SUPER_POWERED_PIG_STUN_HOW_DO_LIKE_THEM_APPLES;
	
	/**
	 * ID: 1800015<br>
	 * Message: uquqIH炦I@JXłrrEg sbO tBA[I<br>
	 * Message: &#21756;&#21756;&#65281;&#25509;&#25307;&#21543;&#65281;&#36899;&#23433;&#22612;&#29790;&#26031;&#20063;&#23475;&#24597;&#30340;&#32982;&#35948;&#32066;&#26997;&#24656;&#25084;&#65281;<br>
	 * Message: Oink oink! Take that! Valakas-Terrorizing Ultra Pig Fear! Ha ha!
	 */
	public static final NpcStringId OINK_OINK_TAKE_THAT_VALAKAS_TERRORIZING_ULTRA_PIG_FEAR_HA_HA;
	
	/**
	 * ID: 1800016<br>
	 * Message: uquqIA^Az`}ȂIɂI<br>
	 * Message: &#21756;&#21756;&#65281;&#36208;&#38283;&#65281;&#21029;&#20877;&#29033;&#25105;&#21862;&#65281;<br>
	 * Message: Oink oink! Go away! Stop bothering me!
	 */
	public static final NpcStringId OINK_OINK_GO_AWAY_STOP_BOTHERING_ME;
	
	/**
	 * ID: 1800017<br>
	 * Message: uquqI݂ȂWAWII̗͂낤ȂI<br>
	 * Message: &#21756;&#21756;&#65281;&#20804;&#24351;&#20497;&#65292;&#24555;&#20358;&#21834;&#65281;&#35731;&#20182;&#30631;&#30631;&#25105;&#20497;&#30340;&#21426;&#23475;&#65281;<br>
	 * Message: Oink oink! Pigs of the world unite! Let's show them our strength!
	 */
	public static final NpcStringId OINK_OINK_PIGS_OF_THE_WORLD_UNITE_LETS_SHOW_THEM_OUR_STRENGTH;
	
	/**
	 * ID: 1800018<br>
	 * Message: ÂĂ͂HɁIuquqI<br>
	 * Message: &#24744;&#27835;&#22909;&#25105;&#21862;&#12290;&#30495;&#35613;&#35613;&#24744;&#126;&#32822;&#32822;&#65281;<br>
	 * Message: You healed me. Thanks a lot! Oink oink!
	 */
	public static final NpcStringId YOU_HEALED_ME_THANKS_A_LOT_OINK_OINK;
	
	/**
	 * ID: 1800019<br>
	 * Message: uquqIȂAA^Iz}ɎÂĂ񂩂ȁH߂ɂ񂯁I<br>
	 * Message: &#21756;&#21756;&#65281;&#38614;&#28982;&#26159;&#27835;&#30274;&#65292;&#20294;&#26159;&#24456;&#30171;&#32822;&#65281;<br>
	 * Message: Oink oink! This treatment hurts too much! Are you sure that you're trying to heal me?
	 */
	public static final NpcStringId OINK_OINK_THIS_TREATMENT_HURTS_TOO_MUCH_ARE_YOU_SURE_THAT_YOURE_TRYING_TO_HEAL_ME;
	
	/**
	 * ID: 1800020<br>
	 * Message: uquqIEaƔɉĥ߂ɁÃvY Xg[gĕϐgI<br>
	 * Message: &#21756;&#21756;&#65281;&#21033;&#29992;&#26376;&#20809;&#27700;&#26230;&#26865;&#37857;&#30340;&#21147;&#37327;&#35722;&#36523;&#65281;<br>
	 * Message: Oink oink! Transform with Moon Crystal Prism Power!
	 */
	public static final NpcStringId OINK_OINK_TRANSFORM_WITH_MOON_CRYSTAL_PRISM_POWER;
	
	/**
	 * ID: 1800021<br>
	 * Message: uquqI`AIɖ߂肽Ȃ``<br>
	 * Message: &#21756;&#21756;&#65281;&#21834;&#65281;&#25105;&#19981;&#24819;&#24674;&#24489;&#21407;&#29376;&#32822;&#126;&#126;<br>
	 * Message: Oink oink! Nooo! I don't want to go back to normal!
	 */
	public static final NpcStringId OINK_OINK_NOOO_I_DONT_WANT_TO_GO_BACK_TO_NORMAL;
	
	/**
	 * ID: 1800022<br>
	 * Message: uqIe͂₳AʂɃT[rXĂ炢܂IقȁAȂBuquqI<br>
	 * Message: &#21756;&#21756;&#65281;&#22240;&#28858;&#25105;&#24456;&#26377;&#37666;&#65292;&#25152;&#20197;&#32102;&#24744;&#29305;&#21029;&#22810;&#21908;&#12290;&#35613;&#35613;&#24744;&#12290;<br>
	 * Message: Oink oink! I'm rich, so I've got plenty to share! Thanks!
	 */
	public static final NpcStringId OINK_OINK_IM_RICH_SO_IVE_GOT_PLENTY_TO_SHARE_THANKS;
	
	/**
	 * ID: 1800023<br>
	 * Message: sgȋCzɕ܂ꂽłˁB댯܂񂩂l̂ĂĂ܂IՂ`I<br>
	 * Message: &#26377;&#32929;&#19981;&#31077;&#20043;&#27683;&#30340;&#27494;&#22120;&#22043;&#12290;&#35498;&#19981;&#23450;&#26371;&#26377;&#21361;&#38570;&#65292;&#25105;&#24171;&#24744;&#25226;&#23427;&#19999;&#25481;&#21543;&#12290;&#27874;&#25552;&#126;&#65281;<br>
	 * Message: It's a weapon surrounded by an ominous aura. I'll discard it because it may be dangerous. Miss...!
	 */
	public static final NpcStringId ITS_A_WEAPON_SURROUNDED_BY_AN_OMINOUS_AURA_ILL_DISCARD_IT_BECAUSE_IT_MAY_BE_DANGEROUS_MISS;
	
	/**
	 * ID: 1800024<br>
	 * Message: ~ĂƂӂ܂B<br>
	 * Message: &#24863;&#35613;&#24744;&#23559;&#25105;&#24478;&#37034;&#24801;&#20013;&#25937;&#20986;&#20358;<br>
	 * Message: Thank you for saving me from the clutches of evil!
	 */
	public static final NpcStringId THANK_YOU_FOR_SAVING_ME_FROM_THE_CLUTCHES_OF_EVIL;
	
	/**
	 * ID: 1800025<br>
	 * Message: ͂̂炢ɂĂĂ낤BSދpI<br>
	 * Message: &#20170;&#22825;&#23601;&#21040;&#27492;&#28858;&#27490;&#65292;&#20808;&#35731;&#20320;&#19968;&#27493;&#65292;&#20840;&#21729;&#36864;&#19979;&#65281;<br>
	 * Message: That is it for today...let's retreat. Everyone pull back!
	 */
	public static final NpcStringId THAT_IS_IT_FOR_TODAYLETS_RETREAT_EVERYONE_PULL_BACK;
	
	/**
	 * ID: 1800026<br>
	 * Message: ĂĂ肪Ƃ܂B͂₩ȃv[głB<br>
	 * Message: &#35613;&#35613;&#24744;&#30340;&#30456;&#21161;&#65292;&#36889;&#26159;&#23567;&#23567;&#30340;&#24515;&#24847;&#12290;<br>
	 * Message: Thank you for the rescue. It's a small gift.
	 */
	public static final NpcStringId THANK_YOU_FOR_THE_RESCUE_ITS_A_SMALL_GIFT;
	
	/**
	 * ID: 1800027<br>
	 * Message: $s1AԂNX^܂DDD<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#46;&#46;&#24744;&#27794;&#26377;&#36196;&#32005;&#27700;&#26230;&#46;&#46;&#46;<br>
	 * Message: $s1.. You don't have a Red Crystal...
	 */
	public static final NpcStringId S1_YOU_DONT_HAVE_A_RED_CRYSTAL;
	
	/**
	 * ID: 1800028<br>
	 * Message: $s1ANX^܂DDD<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#46;&#46;&#24744;&#27794;&#26377;&#28251;&#34253;&#27700;&#26230;&#46;&#46;&#46;<br>
	 * Message: $s1.. You don't have a Blue Crystal...
	 */
	public static final NpcStringId S1_YOU_DONT_HAVE_A_BLUE_CRYSTAL;
	
	/**
	 * ID: 1800029<br>
	 * Message: $s1AȃNX^܂DDD<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#46;&#46;&#24744;&#27794;&#26377;&#36879;&#26126;&#27700;&#26230;&#46;&#46;&#46;&#32;<br>
	 * Message: $s1.. You don't have a Clear Crystal...
	 */
	public static final NpcStringId S1_YOU_DONT_HAVE_A_CLEAR_CRYSTAL;
	
	/**
	 * ID: 1800030<br>
	 * Message: $s1A痣߂AȂ𑗂܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#46;&#46;&#22914;&#26524;&#20320;&#20497;&#38626;&#25105;&#22826;&#36960;&#46;&#46;&#23601;&#28961;&#27861;&#20659;&#36865;&#20320;&#20497;&#46;&#46;&#46;&#32;<br>
	 * Message: $s1.. If you are too far away from me...I can't let you go...
	 */
	public static final NpcStringId S1_IF_YOU_ARE_TOO_FAR_AWAY_FROM_MEI_CANT_LET_YOU_GO;
	
	/**
	 * ID: 1800031<br>
	 * Message: x񑕒u쓮INҔINҌރvO𔭓܂I<br>
	 * Message: &#35686;&#22577;&#35037;&#32622;&#20986;&#29694;&#20102;&#126;&#65281;&#33509;&#19981;&#36245;&#24555;&#35299;&#38500;&#65292;&#22823;&#23478;&#23601;&#26371;&#34389;&#26044;&#21361;&#38570;&#126;&#65281;&#65281;<br>
	 * Message: An alarm has been set off! Everybody will be in danger if they are not taken care of immediately!
	 */
	public static final NpcStringId AN_ALARM_HAS_BEEN_SET_OFF_EVERYBODY_WILL_BE_IN_DANGER_IF_THEY_ARE_NOT_TAKEN_CARE_OF_IMMEDIATELY;
	
	/**
	 * ID: 1800032<br>
	 * Message: ȒPɂ͂ȂI<br>
	 * Message: &#20320;&#28961;&#27861;&#37027;&#40636;&#36629;&#26131;&#23601;&#35299;&#27770;&#25105;&#30340;&#126;&#65281;<br>
	 * Message: It will not be that easy to kill me!
	 */
	public static final NpcStringId IT_WILL_NOT_BE_THAT_EASY_TO_KILL_ME;
	
	/**
	 * ID: 1800033<br>
	 * Message: AȁDDD̔閧m̂ȂāDDD<br>
	 * Message: &#21710;&#21568;&#46;&#46;&#31455;&#28982;&#20597;&#30772;&#25105;&#30340;&#24369;&#40670;&#46;&#46;&#46;&#46;<br>
	 * Message: No...You knew my weakness...
	 */
	public static final NpcStringId NOYOU_KNEW_MY_WEAKNESS;
	
	/**
	 * ID: 1800034<br>
	 * Message: `AN܂񂩂H<br>
	 * Message: &#21890;&#21890;&#126;&#32;&#26377;&#20154;&#22312;&#21966;&#65311;<br>
	 * Message: Hello? Is anyone there?
	 */
	public static final NpcStringId HELLO_IS_ANYONE_THERE;
	
	/**
	 * ID: 1800035<br>
	 * Message: NȂ̂`ǂ̂炢BĂ񂾂낤BHׂĂȂA󂢂ĎɂI<br>
	 * Message: &#27794;&#20154;&#32822;&#126;&#32;&#25105;&#21040;&#24213;&#36530;&#20102;&#22810;&#20037;&#21834;&#65311;&#19981;&#30693;&#39187;&#20102;&#24190;&#22825;&#65292;&#39187;&#24471;&#37117;&#24555;&#21463;&#19981;&#20102;&#21862;&#126;&#65281;<br>
	 * Message: Is no one there? How long have I been hiding? I have been starving for days and cannot hold out anymore!
	 */
	public static final NpcStringId IS_NO_ONE_THERE_HOW_LONG_HAVE_I_BEEN_HIDING_I_HAVE_BEEN_STARVING_FOR_DAYS_AND_CANNOT_HOLD_OUT_ANYMORE;
	
	/**
	 * ID: 1800036<br>
	 * Message: N`NX^̔jЂꂽA̗₽eBA[ỶBƂĂǂȁ`ނɂނɂB<br>
	 * Message: &#22914;&#26524;&#26377;&#20154;&#20998;&#19968;&#40670;&#32654;&#21619;&#30340;&#27700;&#26230;&#30862;&#29255;&#65292;&#37027;&#25105;&#23601;&#26371;&#25552;&#20379;&#20919;&#28129;&#19988;&#38512;&#26862;&#30340;&#25552;&#29246;&#26031;&#34255;&#36523;&#20043;&#34389;&#126;&#32;&#22909;&#21507;&#22909;&#21507;&#12290;<br>
	 * Message: If someone would give me some of those tasty Crystal Fragments, I would gladly tell them where Tears is hiding! Yummy, yummy!
	 */
	public static final NpcStringId IF_SOMEONE_WOULD_GIVE_ME_SOME_OF_THOSE_TASTY_CRYSTAL_FRAGMENTS_I_WOULD_GLADLY_TELL_THEM_WHERE_TEARS_IS_HIDING_YUMMY_YUMMY;
	
	/**
	 * ID: 1800037<br>
	 * Message: `Anォ痈l`NX^̔jЂĂȂA傤`B<br>
	 * Message: &#21890;&#126;&#32;&#24478;&#22320;&#19978;&#20358;&#30340;&#20642;&#20249;&#20497;&#126;&#32;&#33509;&#26377;&#27700;&#26230;&#30862;&#29255;&#23601;&#20998;&#19968;&#40670;&#32102;&#25105;&#21507;&#21543;&#126;&#32;<br>
	 * Message: Hey! You from above the ground! Let's share some Crystal Fragments, if you have any.
	 */
	public static final NpcStringId HEY_YOU_FROM_ABOVE_THE_GROUND_LETS_SHARE_SOME_CRYSTAL_FRAGMENTS_IF_YOU_HAVE_ANY;
	
	/**
	 * ID: 1800038<br>
	 * Message: TNTNăqĊ`ւց`̖I<br>
	 * Message: &#21448;&#33030;&#21448;&#20912;&#30340;&#24863;&#35258;&#126;&#32;&#22075;&#22075;&#22075;&#126;&#32;&#23601;&#26159;&#36889;&#20491;&#21619;&#36947;&#126;&#65281;<br>
	 * Message: Crispy and cold feeling! Teehee! Delicious!!
	 */
	public static final NpcStringId CRISPY_AND_COLD_FEELING_TEEHEE_DELICIOUS;
	
	/**
	 * ID: 1800039<br>
	 * Message: VVA`<br>
	 * Message: &#22909;&#21507;&#22909;&#21507;&#65292;&#22826;&#22909;&#21507;&#20102;&#126;&#32;<br>
	 * Message: Yummy! This is so tasty.
	 */
	public static final NpcStringId YUMMY_THIS_IS_SO_TASTY;
	
	/**
	 * ID: 1800040<br>
	 * Message: NNANX^̔jЂƂ`<br>
	 * Message: &#21683;&#21683;&#65292;&#32;&#20877;&#32102;&#25105;&#19968;&#40670;&#27700;&#26230;&#30862;&#29255;&#21543;&#126;<br>
	 * Message: Sniff, sniff! Give me more Crystal Fragments!
	 */
	public static final NpcStringId SNIFF_SNIFF_GIVE_ME_MORE_CRYSTAL_FRAGMENTS;
	
	/**
	 * ID: 1800041<br>
	 * Message: ȂȁIĂȂIƂ񂭂ȂH<br>
	 * Message: &#23567;&#27683;&#39740;&#65292;&#21482;&#20998;&#19968;&#20491;&#32102;&#25105;&#65281;&#30495;&#26159;&#32085;&#24773;&#32822;&#126;&#32;&#19981;&#33021;&#20877;&#22810;&#32102;&#19968;&#40670;&#21966;&#65311;<br>
	 * Message: How insensitive! It's not nice to give me just a piece! Can't you give me more?
	 */
	public static final NpcStringId HOW_INSENSITIVE_ITS_NOT_NICE_TO_GIVE_ME_JUST_A_PIECE_CANT_YOU_GIVE_ME_MORE;
	
	/**
	 * ID: 1800042<br>
	 * Message: `󂢂`<br>
	 * Message: &#21834;&#126;&#32;&#22909;&#39187;&#126;<br>
	 * Message: Ah - I'm hungry!
	 */
	public static final NpcStringId AH_IM_HUNGRY;
	
	/**
	 * ID: 1800043<br>
	 * Message: {`<br>
	 * Message: &#25105;&#25165;&#26159;&#30495;&#30340;&#21862;&#126;<br>
	 * Message: I'm the real one!
	 */
	public static final NpcStringId IM_THE_REAL_ONE;
	
	/**
	 * ID: 1800044<br>
	 * Message: Ił`<br>
	 * Message: &#36984;&#25105;&#21543;&#126;<br>
	 * Message: Pick me!
	 */
	public static final NpcStringId PICK_ME;
	
	/**
	 * ID: 1800045<br>
	 * Message: MĂ`<br>
	 * Message: &#23601;&#30456;&#20449;&#25105;&#19968;&#27425;&#21543;&#126;<br>
	 * Message: Trust me!
	 */
	public static final NpcStringId TRUST_ME;
	
	/**
	 * ID: 1800046<br>
	 * Message: ACcȂĎ{I<br>
	 * Message: &#19981;&#26159;&#20182;&#65292;&#25105;&#25165;&#26159;&#30495;&#30340;&#21862;&#126;&#65281;<br>
	 * Message: Not that dude, I'm the real one!
	 */
	public static final NpcStringId NOT_THAT_DUDE_IM_THE_REAL_ONE;
	
	/**
	 * ID: 1800047<br>
	 * Message: __A܂ꂿI{ˁI<br>
	 * Message: &#21029;&#21463;&#39449;&#65292;&#21029;&#21463;&#39449;&#65292;&#25105;&#25165;&#26159;&#30495;&#30340;&#126;&#65281;<br>
	 * Message: Don't be fooled! Don't be fooled! I'm the real one!!
	 */
	public static final NpcStringId DONT_BE_FOOLED_DONT_BE_FOOLED_IM_THE_REAL_ONE;
	
	/**
	 * ID: 1800048<br>
	 * Message: {̂ӂ肷΂ĂƂˁIƂI<br>
	 * Message: &#21482;&#35201;&#20551;&#35037;&#26159;&#30495;&#30340;&#23601;&#34892;&#21862;&#126;&#65281;&#27513;&#21218;&#65281;<br>
	 * Message: Just act like the real one! Oops!
	 */
	public static final NpcStringId JUST_ACT_LIKE_THE_REAL_ONE_OOPS;
	
	/**
	 * ID: 1800049<br>
	 * Message: cOł`<br>
	 * Message: &#34987;&#39449;&#20102;&#21543;&#126;<br>
	 * Message: You've been fooled!
	 */
	public static final NpcStringId YOUVE_BEEN_FOOLED;
	
	/**
	 * ID: 1800050<br>
	 * Message: \ȂǁDDD̓jZm`<br>
	 * Message: &#23565;&#19981;&#36215;&#46;&#46;&#32;&#25105;&#26159;&#20551;&#30340;&#21862;&#126;<br>
	 * Message: Sorry, but...I'm the fake one.
	 */
	public static final NpcStringId SORRY_BUT_IM_THE_FAKE_ONE;
	
	/**
	 * ID: 1800051<br>
	 * Message: {`CG`CI<br>
	 * Message: &#25105;&#25165;&#26159;&#30495;&#30340;&#21862;&#126;&#32;&#21769;&#21938;&#126;&#126;&#65281;&#65281;<br>
	 * Message: I'm the real one! Phew!!
	 */
	public static final NpcStringId IM_THE_REAL_ONE_PHEW;
	
	/**
	 * ID: 1800052<br>
	 * Message: ꂭ炢Ȃ́H<br>
	 * Message: &#36899;&#37027;&#20491;&#37117;&#25214;&#19981;&#20986;&#20358;&#21834;&#126;&#65311;&#26524;&#30495;&#26159;&#20491;&#20154;&#26448;&#46;&#46;&#46;<br>
	 * Message: Can't you even find out?
	 */
	public static final NpcStringId CANT_YOU_EVEN_FIND_OUT;
	
	/**
	 * ID: 1800053<br>
	 * Message: ̂Ƃɗā`<br>
	 * Message: &#25214;&#25214;&#25105;&#21543;&#126;<br>
	 * Message: Find me!
	 */
	public static final NpcStringId FIND_ME;
	
	/**
	 * ID: 1800054<br>
	 * Message: IĂǂĂ킩́H<br>
	 * Message: &#21703;&#22622;&#126;&#65281;&#24590;&#40636;&#26371;&#30693;&#36947;&#26159;&#25105;&#21834;&#65311;<br>
	 * Message: Huh?! How did you know it was me?
	 */
	public static final NpcStringId HUH_HOW_DID_YOU_KNOW_IT_WAS_ME;
	
	/**
	 * ID: 1800055<br>
	 * Message: Iˁ``<br>
	 * Message: &#32085;&#20339;&#30340;&#36984;&#25799;&#126;&#22075;&#22075;&#126;<br>
	 * Message: Excellent choice! Teehee!
	 */
	public static final NpcStringId EXCELLENT_CHOICE_TEEHEE;
	
	/**
	 * ID: 1800056<br>
	 * Message: `ł܂`<br>
	 * Message: &#20570;&#24471;&#30495;&#22909;&#126;<br>
	 * Message: You've done well!
	 */
	public static final NpcStringId YOUVE_DONE_WELL;
	
	/**
	 * ID: 1800057<br>
	 * Message: `ZX񂶂ȂH<br>
	 * Message: &#22114;&#21628;&#126;&#32;&#30495;&#26377;&#30524;&#20809;&#32822;&#65281;<br>
	 * Message: Oh... very sensible?
	 */
	public static final NpcStringId OH_VERY_SENSIBLE;
	
	/**
	 * ID: 1800058<br>
	 * Message: EIIHHHI 䂪̓o[[I vm邪悢A䂪͂I<br>
	 * Message: &#21834;&#126;&#126;&#126;&#65281;&#25105;&#26159;&#24052;&#29246;&#21202;&#46;&#46;&#46;&#46;&#23601;&#35731;&#20320;&#20497;&#30631;&#30631;&#25105;&#30340;&#21147;&#37327;&#21543;&#126;&#126;&#126;<br>
	 * Message: Behold the mighty power of Baylor, foolish mortal!
	 */
	public static final NpcStringId BEHOLD_THE_MIGHTY_POWER_OF_BAYLOR_FOOLISH_MORTAL;
	
	/**
	 * ID: 1800059<br>
	 * Message: NlƂĐĂ͋A񂼁I<br>
	 * Message: &#20320;&#20497;&#27794;&#26377;&#19968;&#20491;&#21487;&#20197;&#27963;&#33879;&#22238;&#21435;&#30340;&#46;&#46;&#46;&#46;&#46;&#46;&#46;&#65281;<br>
	 * Message: No one is going to survive!
	 */
	public static final NpcStringId NO_ONE_IS_GOING_TO_SURVIVE;
	
	/**
	 * ID: 1800060<br>
	 * Message: nƂ͂Ƃ낾I<br>
	 * Message: &#35731;&#20320;&#20497;&#22160;&#22160;&#22320;&#29508;&#30340;&#28363;&#21619;&#21543;&#46;&#46;&#46;&#46;&#46;&#46;<br>
	 * Message: You'll see what hell is like...
	 */
	public static final NpcStringId YOULL_SEE_WHAT_HELL_IS_LIKE;
	
	/**
	 * ID: 1800061<br>
	 * Message: ̒PǂI nɑĂI<br>
	 * Message: &#20320;&#35442;&#27493;&#20837;&#40643;&#27849;&#20102;&#126;&#126;&#65281;<br>
	 * Message: You will be put in jail!
	 */
	public static final NpcStringId YOU_WILL_BE_PUT_IN_JAIL;
	
	/**
	 * ID: 1800062<br>
	 * Message: ̒xB΂킹ȁIn֏I<br>
	 * Message: &#30495;&#26159;&#21487;&#31505;&#30340;&#20642;&#20249;&#46;&#46;&#46;&#20320;&#23601;&#19979;&#22320;&#29508;&#21543;&#126;&#65281;<br>
	 * Message: Worthless creature... Go to hell!
	 */
	public static final NpcStringId WORTHLESS_CREATURE_GO_TO_HELL;
	
	/**
	 * ID: 1800063<br>
	 * Message: 䂪|̗͂łO̐_xzĂ낤I<br>
	 * Message: &#25105;&#23601;&#32102;&#20320;&#36889;&#20642;&#20249;&#30041;&#19979;&#28961;&#27861;&#24536;&#25079;&#30340;&#35352;&#25014;&#21543;&#126;&#126;<br>
	 * Message: I'll give you something that you'll never forget!
	 */
	public static final NpcStringId ILL_GIVE_YOU_SOMETHING_THAT_YOULL_NEVER_FORGET;
	
	/**
	 * ID: 1800064<br>
	 * Message: MĎI񂾂̂DDDEtttB<br>
	 * Message: &#20320;&#24977;&#20160;&#40636;&#36984;&#25799;&#20102;&#25105;&#46;&#46;&#46;&#46;&#46;&#46;&#21571;&#21621;&#21621;&#21621;<br>
	 * Message: Why did you trust to choose me? Hahahaha....
	 */
	public static final NpcStringId WHY_DID_YOU_TRUST_TO_CHOOSE_ME_HAHAHAHA;
	
	/**
	 * ID: 1800065<br>
	 * Message: I񂾂ƂĂ낤DDD<br>
	 * Message: &#25105;&#26371;&#35731;&#20320;&#24460;&#24724;&#36984;&#25799;&#20102;&#25105;&#46;&#46;&#46;<br>
	 * Message: I'll make you regret that you ever chose me...
	 */
	public static final NpcStringId ILL_MAKE_YOU_REGRET_THAT_YOU_EVER_CHOSE_ME;
	
	/**
	 * ID: 1800066<br>
	 * Message: ċAƂłvĂ̂DDD<br>
	 * Message: &#20320;&#20197;&#28858;&#20320;&#33021;&#27963;&#33879;&#22238;&#21435;&#21966;&#46;&#46;&#65311;&#65281;<br>
	 * Message: Don't expect to get out alive..
	 */
	public static final NpcStringId DONT_EXPECT_TO_GET_OUT_ALIVE;
	
	/**
	 * ID: 1800067<br>
	 * Message: xXBɗ͂^܂I<br>
	 * Message: &#39764;&#29579;&#65292;&#24052;&#21015;&#26031;&#65292;&#35531;&#36060;&#20104;&#25105;&#21147;&#37327;&#126;&#126;&#126;&#21571;&#21834;&#21834;&#126;&#126;&#65281;&#65281;<br>
	 * Message: Demon King Beleth, give me the power! Aaahh!!!
	 */
	public static final NpcStringId DEMON_KING_BELETH_GIVE_ME_THE_POWER_AAAHH;
	
	/**
	 * ID: 1800068<br>
	 * Message: ȂƁDDDpvI̗͂DDD<br>
	 * Message: &#31967;&#31957;&#46;&#46;&#46;&#46;&#46;&#46;&#46;&#24863;&#35258;&#21040;&#20102;&#27861;&#21033;&#26114;&#30340;&#21147;&#37327;&#46;&#46;&#46;&#46;&#46;&#46;&#46;<br>
	 * Message: No....... I feel the power of Fafurion.......
	 */
	public static final NpcStringId NO_I_FEEL_THE_POWER_OF_FAFURION;
	
	/**
	 * ID: 1800069<br>
	 * Message: pvI`̈țޏɂ͂I<br>
	 * Message: &#27861;&#21033;&#26114;&#21834;&#126;&#32;&#35531;&#36060;&#20104;&#24494;&#24369;&#30340;&#24043;&#22899;&#21147;&#37327;&#21543;&#126;&#126;&#65281;&#65281;<br>
	 * Message: Fafurion! Please give power to this helpless witch!!
	 */
	public static final NpcStringId FAFURION_PLEASE_GIVE_POWER_TO_THIS_HELPLESS_WITCH;
	
	/**
	 * ID: 1800070<br>
	 * Message: ͂̏ꏊɕ߂̐gBo[[̗͂܂点邭炢͓Ył܂DDD<br>
	 * Message: &#36523;&#22312;&#27492;&#34389;&#65292;&#25105;&#33021;&#24171;&#24744;&#30340;&#20063;&#21482;&#19981;&#36942;&#26159;&#31245;&#24494;&#24369;&#21270;&#24052;&#29246;&#21202;&#30340;&#21147;&#37327;&#32631;&#20102;&#46;&#46;&#46;<br>
	 * Message: I can't help you much, but I can weaken the power of Baylor since I'm locked up here.
	 */
	public static final NpcStringId I_CANT_HELP_YOU_MUCH_BUT_I_CAN_WEAKEN_THE_POWER_OF_BAYLOR_SINCE_IM_LOCKED_UP_HERE;
	
	/**
	 * ID: 1800071<br>
	 * Message: Ȃ̎͂ȁB̂炢Ȃ玄𒴂r݂ƂƂF߂Ă낤BJMĂ𔭂ȂB<br>
	 * Message: &#30495;&#26377;&#23526;&#21147;&#12290;&#21040;&#20102;&#36889;&#20491;&#31243;&#24230;&#65292;&#37027;&#25105;&#20063;&#23601;&#35469;&#21516;&#20320;&#36948;&#21040;&#20102;&#21487;&#20197;&#36890;&#36942;&#25105;&#30340;&#27700;&#28310;&#12290;&#25343;&#33879;&#38000;&#21273;&#38626;&#38283;&#27492;&#22320;&#21543;&#12290;<br>
	 * Message: Your skill is impressive. I'll admit that you are good enough to pass. Take the key and leave this place.
	 */
	public static final NpcStringId YOUR_SKILL_IS_IMPRESSIVE_ILL_ADMIT_THAT_YOU_ARE_GOOD_ENOUGH_TO_PASS_TAKE_THE_KEY_AND_LEAVE_THIS_PLACE;
	
	/**
	 * ID: 1800072<br>
	 * Message: Ă̑SoIΖ͌Ă邼I<br>
	 * Message: &#25226;&#20320;&#36523;&#19978;&#25152;&#26377;&#30340;&#26481;&#35199;&#36890;&#36890;&#37117;&#20132;&#20986;&#20358;&#65281;&#25105;&#23601;&#39250;&#20320;&#19968;&#21629;&#65281;&#65281;<br>
	 * Message: Give me all you have! It's the only way I'll let you live!!
	 */
	public static final NpcStringId GIVE_ME_ALL_YOU_HAVE_ITS_THE_ONLY_WAY_ILL_LET_YOU_LIVE;
	
	/**
	 * ID: 1800073<br>
	 * Message: DDDB<br>
	 * Message: &#32922;&#46;&#46;&#32922;&#23376;&#22909;&#39187;&#12290;<br>
	 * Message: Hun.. hungry
	 */
	public static final NpcStringId HUN_HUNGRY;
	
	/**
	 * ID: 1800074<br>
	 * Message: T{Ă񂶂ȂI̒ǂ߁I<br>
	 * Message: &#19981;&#35201;&#32102;&#25105;&#20599;&#25078;&#65281;&#20320;&#20497;&#36889;&#20123;&#25078;&#34802;&#65281;<br>
	 * Message: Don't be lazy! You bastards!
	 */
	public static final NpcStringId DONT_BE_LAZY_YOU_BASTARDS;
	
	/**
	 * ID: 1800075<br>
	 * Message: |S̏̉񂵎҂Ȃ̂DDDт肳ȂłDDD<br>
	 * Message: &#21407;&#20358;&#19981;&#26159;&#24478;&#37628;&#37941;&#20043;&#22478;&#20358;&#30340;&#25163;&#19979;&#21834;&#46;&#46;&#46;&#23475;&#25105;&#36530;&#20102;&#36215;&#20358;&#46;&#46;&#46;<br>
	 * Message: They are just henchmen of the Iron Castle... Why did we hide?
	 */
	public static final NpcStringId THEY_ARE_JUST_HENCHMEN_OF_THE_IRON_CASTLE_WHY_DID_WE_HIDE;
	
	/**
	 * ID: 1800076<br>
	 * Message: YǂIɉ̗͂tĂI<br>
	 * Message: &#20804;&#24351;&#20497;&#65292;&#35731;&#36889;&#20123;&#20642;&#20249;&#30631;&#30631;&#25105;&#20497;&#30340;&#21426;&#23475;&#21543;&#65281;&#65281;&#65281;&#65281;<br>
	 * Message: Guys, show them our power!!!!
	 */
	public static final NpcStringId GUYS_SHOW_THEM_OUR_POWER;
	
	/**
	 * ID: 1800077<br>
	 * Message: 悭܂łǂ蒅ȁDDD閧̔J͂ʂI<br>
	 * Message: &#36996;&#30495;&#30340;&#25214;&#21040;&#36889;&#35041;&#20358;&#21834;&#46;&#46;&#46;&#19981;&#36942;&#20320;&#26159;&#32085;&#23565;&#25214;&#19981;&#21040;&#31061;&#23494;&#25151;&#38291;&#30340;&#126;&#65281;<br>
	 * Message: You have finally come here. But you will not be able to find the secret room!
	 */
	public static final NpcStringId YOU_HAVE_FINALLY_COME_HERE_BUT_YOU_WILL_NOT_BE_ABLE_TO_FIND_THE_SECRET_ROOM;
	
	/**
	 * ID: 1800078<br>
	 * Message: 悭܂ŗȁIJM͂ȒPɂ͓n񂼁I<br>
	 * Message: &#22909;&#19981;&#23481;&#26131;&#25214;&#21040;&#20102;&#25105;&#65292;&#20294;&#25105;&#21487;&#19981;&#26371;&#36629;&#26131;&#30340;&#20132;&#20986;&#38000;&#21273;&#65281;<br>
	 * Message: You have done well in finding me, but I cannot just hand you the key!
	 */
	public static final NpcStringId YOU_HAVE_DONE_WELL_IN_FINDING_ME_BUT_I_CANNOT_JUST_HAND_YOU_THE_KEY;
	
	/**
	 * ID: 1800079<br>
	 * Message: c$s1łB<br>
	 * Message: &#21097;&#19979;&#12300;&#36;&#115;&#49;&#12301;&#31186;&#12290;<br>
	 * Message: $s1 second(s) remaining.
	 */
	public static final NpcStringId S1_SECONDS_REMAINING;
	
	/**
	 * ID: 1800081<br>
	 * Message: ǗlƗꂷĂ邽߁AZIɃLZ܂B<br>
	 * Message: &#33287;&#20837;&#22580;&#31649;&#29702;&#21729;&#30340;&#36317;&#38626;&#30456;&#36960;&#65292;&#22240;&#27492;&#24050;&#33258;&#21205;&#21462;&#28040;&#31478;&#36093;&#12290;<br>
	 * Message: The match is automatically canceled because you are too far from the admission manager.
	 */
	public static final NpcStringId THE_MATCH_IS_AUTOMATICALLY_CANCELED_BECAUSE_YOU_ARE_TOO_FAR_FROM_THE_ADMISSION_MANAGER;
	
	/**
	 * ID: 1800082<br>
	 * Message: AْDDDoԂȂ̂ɂǂ悤DDDB<br>
	 * Message: &#21834;&#65292;&#30495;&#20196;&#20154;&#19981;&#32784;&#30340;&#32202;&#24373;&#24863;&#46;&#46;&#46;&#34920;&#28436;&#39340;&#19978;&#23601;&#35201;&#38283;&#22987;&#20102;&#46;&#46;&#46;&#21756;<br>
	 * Message: Ugh, I have butterflies in my stomach.. The show starts soon...
	 */
	public static final NpcStringId UGH_I_HAVE_BUTTERFLIES_IN_MY_STOMACH_THE_SHOW_STARTS_SOON;
	
	/**
	 * ID: 1800083<br>
	 * Message: {͓ʃCxgɂW܂肢A܂Ƃɂ肪Ƃ܂B<br>
	 * Message: &#20170;&#22825;&#38750;&#24120;&#24863;&#35613;&#21508;&#20301;&#20358;&#21040;&#27492;&#22320;&#12290;<br>
	 * Message: Thank you all for coming here tonight.
	 */
	public static final NpcStringId THANK_YOU_ALL_FOR_COMING_HERE_TONIGHT;
	
	/**
	 * ID: 1800084<br>
	 * Message: ̂悤ȃCxgJÂłƂv܂B<br>
	 * Message: &#20170;&#22825;&#33021;&#29305;&#21029;&#28858;&#21508;&#20301;&#24118;&#20358;&#34920;&#28436;&#65292;&#30495;&#26159;&#24863;&#21040;&#33836;&#20998;&#30340;&#27054;&#24184;&#12290;<br>
	 * Message: It is an honor to have the special show today.
	 */
	public static final NpcStringId IT_IS_AN_HONOR_TO_HAVE_THE_SPECIAL_SHOW_TODAY;
	
	/**
	 * ID: 1800085<br>
	 * Message: ̌z̓ł́AFlɂy݂悤Aɐ^SsĂ܂B<br>
	 * Message: &#25105;&#20497;&#22818;&#24187;&#23798;&#28858;&#20102;&#24118;&#32102;&#22823;&#23478;&#27489;&#27138;&#65292;&#19968;&#30452;&#37117;&#26159;&#20840;&#21147;&#20197;&#36212;&#12290;<br>
	 * Message: Fantasy Isle is fully committed to your happiness.
	 */
	public static final NpcStringId FANTASY_ISLE_IS_FULLY_COMMITTED_TO_YOUR_HAPPINESS;
	
	/**
	 * ID: 1800086<br>
	 * Message: ł́ÃCxgɉ؂YAf񂾍ō̔l̎AC~Љ܂I<br>
	 * Message: &#20358;&#65292;&#37027;&#40636;&#25105;&#20358;&#20171;&#32057;&#19968;&#19979;&#65292;&#25105;&#20497;&#28858;&#20102;&#20351;&#34920;&#28436;&#26356;&#20986;&#33394;&#32780;&#32763;&#36941;&#25972;&#20491;&#20126;&#19969;&#25165;&#25214;&#20358;&#65292;&#26368;&#26834;&#30340;&#32654;&#22899;&#27468;&#25163;&#45;&#33802;&#20234;&#25289;&#32654;&#32645;&#23567;&#22992;&#65281;<br>
	 * Message: Now I'd like to introduce the most beautiful singer in Aden. Please welcome...Leyla Mira!
	 */
	public static final NpcStringId NOW_ID_LIKE_TO_INTRODUCE_THE_MOST_BEAUTIFUL_SINGER_IN_ADEN_PLEASE_WELCOMELEYLA_MIRA;
	
	/**
	 * ID: 1800087<br>
	 * Message: ǂ`<br>
	 * Message: &#25484;&#32;&#32882;&#32;&#27489;&#32;&#36814;&#126;<br>
	 * Message: Here she comes!
	 */
	public static final NpcStringId HERE_SHE_COMES;
	
	/**
	 * ID: 1800088<br>
	 * Message: C~A肪Ƃ܂B́DDD<br>
	 * Message: &#38750;&#24120;&#24863;&#35613;&#33802;&#20234;&#25289;&#32654;&#32645;&#23567;&#22992;&#24118;&#20358;&#30340;&#27468;&#26354;&#12290;&#37027;&#40636;&#25509;&#19979;&#20358;&#26159;<br>
	 * Message: Thank you very much, Leyla!
	 */
	public static final NpcStringId THANK_YOU_VERY_MUCH_LEYLA;
	
	/**
	 * ID: 1800089<br>
	 * Message: ͂B̓Afւ閼l|y݂܂傤B<br>
	 * Message: &#21999;&#46;&#46;&#46;&#25509;&#19979;&#20358;&#65292;&#25105;&#20497;&#20358;&#20171;&#32057;&#20126;&#19969;&#21508;&#22320;&#21312;&#30340;&#21517;&#20154;&#12290;<br>
	 * Message: Now we're in for a real treat.
	 */
	public static final NpcStringId NOW_WERE_IN_FOR_A_REAL_TREAT;
	
	/**
	 * ID: 1800090<br>
	 * Message: ܂A[h cA[IȀɋ삯tĂz̓̋Ȍ|c̊FłI<br>
	 * Message: &#39318;&#20808;&#20171;&#32057;&#30340;&#26159;&#65292;&#29305;&#21029;&#36992;&#35531;&#32780;&#20358;&#12289;&#21083;&#32080;&#26463;&#19990;&#30028;&#24033;&#36852;&#34920;&#28436;&#30340;&#22818;&#24187;&#23798;&#25216;&#34269;&#22296;&#65281;<br>
	 * Message: Just back from their world tour put your hands together for the Fantasy Isle Circus!
	 */
	public static final NpcStringId JUST_BACK_FROM_THEIR_WORLD_TOUR_PUT_YOUR_HANDS_TOGETHER_FOR_THE_FANTASY_ISLE_CIRCUS;
	
	/**
	 * ID: 1800091<br>
	 * Message: Ȍ|c̊F`A͂肫ĂǂI<br>
	 * Message: &#21508;&#20301;&#65292;&#35531;&#126;&#20986;&#22580;&#12290;<br>
	 * Message: Come on ~ everyone
	 */
	public static final NpcStringId COME_ON_EVERYONE;
	
	/**
	 * ID: 1800092<br>
	 * Message: łBf炵łˁB<br>
	 * Message: &#26377;&#22909;&#22909;&#27427;&#36062;&#21966;&#65311;&#30495;&#26159;&#26082;&#21487;&#24859;&#21448;&#20986;&#33394;&#30340;&#34920;&#28436;&#12290;<br>
	 * Message: Did you like it? That was so amazing.
	 */
	public static final NpcStringId DID_YOU_LIKE_IT_THAT_WAS_SO_AMAZING;
	
	/**
	 * ID: 1800093<br>
	 * Message: A͊enW܂˔\̕łB<br>
	 * Message: &#25509;&#19979;&#20358;&#25105;&#20497;&#36992;&#35531;&#20102;&#21508;&#22320;&#25793;&#26377;&#38750;&#20961;&#25165;&#33775;&#30340;&#20154;&#22763;&#12290;<br>
	 * Message: Now we also invited individuals with special talents.
	 */
	public static final NpcStringId NOW_WE_ALSO_INVITED_INDIVIDUALS_WITH_SPECIAL_TALENTS;
	
	/**
	 * ID: 1800094<br>
	 * Message: ł́Igbvob^[肢܂I<br>
	 * Message: &#25105;&#20497;&#20358;&#27489;&#36814;&#19968;&#19979;&#21543;&#65292;&#31532;&#19968;&#20301;&#35531;&#20986;&#22580;&#65281;<br>
	 * Message: Let's welcome the first person here!
	 */
	public static final NpcStringId LETS_WELCOME_THE_FIRST_PERSON_HERE;
	
	/**
	 * ID: 1800095<br>
	 * Message: GGGG`B<br>
	 * Message: &#46;&#46;&#46;&#21999;<br>
	 * Message: ;;;;;;Oh
	 */
	public static final NpcStringId OH;
	
	/**
	 * ID: 1800096<br>
	 * Message: ͂Bł͎̕肢܂B<br>
	 * Message: &#22909;&#65292;&#25105;&#20497;&#27489;&#36814;&#19979;&#19968;&#20301;&#21443;&#21152;&#32773;&#65292;&#35531;&#20986;&#22580;&#12290;<br>
	 * Message: Okay, now here comes the next person. Come on up please.
	 */
	public static final NpcStringId OKAY_NOW_HERE_COMES_THE_NEXT_PERSON_COME_ON_UP_PLEASE;
	
	/**
	 * ID: 1800097<br>
	 * Message: AȂ肷ł˂B<br>
	 * Message: &#21734;&#21734;&#65292;&#36889;&#27425;&#22909;&#20687;&#38750;&#24120;&#20102;&#19981;&#36215;&#21908;&#65311;<br>
	 * Message: Oh, it looks like something great is going to happen, right?
	 */
	public static final NpcStringId OH_IT_LOOKS_LIKE_SOMETHING_GREAT_IS_GOING_TO_HAPPEN_RIGHT;
	
	/**
	 * ID: 1800098<br>
	 * Message: nbGGGG<br>
	 * Message: &#21571;&#46;&#46;&#46;<br>
	 * Message: Oh, my ;;;;
	 */
	public static final NpcStringId OH_MY;
	
	/**
	 * ID: 1800099<br>
	 * Message: A΂炵Ił͍Ō̕A肢܂I<br>
	 * Message: &#30495;&#46;&#46;&#30495;&#26159;&#20102;&#19981;&#36215;&#12290;&#37027;&#40636;&#25105;&#20497;&#35531;&#26368;&#24460;&#19968;&#20301;&#21443;&#21152;&#32773;&#20986;&#22580;&#21543;&#12290;<br>
	 * Message: That's g- .. great. Now, here comes the last person.
	 */
	public static final NpcStringId THATS_G_GREAT_NOW_HERE_COMES_THE_LAST_PERSON;
	
	/**
	 * ID: 1800100<br>
	 * Message: ɂĊlElV[JƂĂ܂B<br>
	 * Message: &#23601;&#36889;&#27171;&#65292;&#25105;&#20497;&#30340;&#29305;&#25216;&#34920;&#28436;&#20063;&#21040;&#20102;&#23614;&#32882;&#12290;<br>
	 * Message: Now this is the end of today's show.
	 */
	public static final NpcStringId NOW_THIS_IS_THE_END_OF_TODAYS_SHOW;
	
	/**
	 * ID: 1800101<br>
	 * Message: FǂłHył܂B<br>
	 * Message: &#21508;&#20301;&#35258;&#24471;&#22914;&#20309;&#65311;&#19981;&#30693;&#22823;&#23478;&#26159;&#21542;&#26377;&#22909;&#22909;&#27427;&#36062;&#12290;<br>
	 * Message: How was it? I hope you all enjoyed it.
	 */
	public static final NpcStringId HOW_WAS_IT_I_HOPE_YOU_ALL_ENJOYED_IT;
	
	/**
	 * ID: 1800102<br>
	 * Message: ǂz̓ł́AFlɊł悤ɗlXȃCxgpӂĂ܂Bǂ҂B<br>
	 * Message: &#24448;&#24460;&#25105;&#20497;&#22818;&#24187;&#23798;&#20063;&#26371;&#32380;&#32396;&#28858;&#21508;&#20301;&#28310;&#20633;&#20986;&#33394;&#30340;&#34920;&#28436;&#31680;&#30446;&#65292;&#25964;&#35531;&#26399;&#24453;&#12290;<br>
	 * Message: Please remember that Fantasy Isle is always planning a lot of great shows for you.
	 */
	public static final NpcStringId PLEASE_REMEMBER_THAT_FANTASY_ISLE_IS_ALWAYS_PLANNING_A_LOT_OF_GREAT_SHOWS_FOR_YOU;
	
	/**
	 * ID: 1800103<br>
	 * Message: cɂłAɂĕƂĂ܂B<br>
	 * Message: &#30495;&#36986;&#25022;&#65292;&#19981;&#36942;&#20170;&#22825;&#23601;&#21040;&#27492;&#28858;&#27490;&#20102;&#12290;&#35613;&#35613;&#12290;<br>
	 * Message: Well, I wish I could continue all night long, but this is it for today. Thank you.
	 */
	public static final NpcStringId WELL_I_WISH_I_COULD_CONTINUE_ALL_NIGHT_LONG_BUT_THIS_IS_IT_FOR_TODAY_THANK_YOU;
	
	/**
	 * ID: 1800104<br>
	 * Message: ł͊Fl悤B<br>
	 * Message: &#25105;&#24859;&#20320;&#20497;&#21908;&#12290;<br>
	 * Message: We love you.
	 */
	public static final NpcStringId WE_LOVE_YOU;
	
	/**
	 * ID: 1800105<br>
	 * Message: ȂŒNW܂ĂȂ́DDDCxgn܂̂ɁDDDB<br>
	 * Message: &#24590;&#40636;&#27794;&#20154;&#21671;&#46;&#46;&#46;&#34920;&#28436;&#39340;&#19978;&#23601;&#35201;&#38283;&#22987;&#20102;&#46;&#46;&#46;&#21756;<br>
	 * Message: How come people are not here... We are about to start the show.. Hmm
	 */
	public static final NpcStringId HOW_COME_PEOPLE_ARE_NOT_HERE_WE_ARE_ABOUT_TO_START_THE_SHOW_HMM;
	
	/**
	 * ID: 1800106<br>
	 * Message: `[ZLZ܂B<br>
	 * Message: &#23565;&#26041;&#38538;&#20237;&#21462;&#28040;&#20102;&#31478;&#36093;&#12290;<br>
	 * Message: The opponent team canceled the match.
	 */
	public static final NpcStringId THE_OPPONENT_TEAM_CANCELED_THE_MATCH;
	
	/**
	 * ID: 1800107<br>
	 * Message: ȒPɂ͎ɓȂ낤B<br>
	 * Message: &#27794;&#26377;&#37027;&#40636;&#23481;&#26131;&#23601;&#21487;&#20197;&#24471;&#21040;&#12290;<br>
	 * Message: It's not easy to obtain.
	 */
	public static final NpcStringId ITS_NOT_EASY_TO_OBTAIN;
	
	/**
	 * ID: 1800108<br>
	 * Message: CłɓĂƂ͂ȁDDD<br>
	 * Message: &#23621;&#28982;&#20197;&#27491;&#24120;&#30340;&#31934;&#31070;&#29376;&#24907;&#36914;&#21040;&#36889;&#35041;&#20358;&#46;&#46;&#46;<br>
	 * Message: You're out of your mind coming here...
	 */
	public static final NpcStringId YOURE_OUT_OF_YOUR_MIND_COMING_HERE;
	
	/**
	 * ID: 1800109<br>
	 * Message: GNI}ōHɂƂ肩I<br>
	 * Message: &#26377;&#25973;&#36557;&#20837;&#20405;&#65281;&#36245;&#24555;&#32080;&#26463;&#24037;&#31243;&#21543;&#65281;<br>
	 * Message: Enemy invasion! Hurry up!
	 */
	public static final NpcStringId ENEMY_INVASION_HURRY_UP;
	
	/**
	 * ID: 1800110<br>
	 * Message: ̂ŁDDDHDDDxẮDDDȂʁDDD<br>
	 * Message: &#19981;&#24471;&#46;&#46;&#46;&#22240;&#25105;&#46;&#46;&#46;&#32780;&#24608;&#24930;&#46;&#46;&#46;&#24037;&#31243;&#46;&#46;&#46;<br>
	 * Message: Process... shouldn't... be delayed... because of me...
	 */
	public static final NpcStringId PROCESS_SHOULDNT_BE_DELAYED_BECAUSE_OF_ME;
	
	/**
	 * ID: 1800111<br>
	 * Message: 낤BI_X͂Ô̂I<br>
	 * Message: &#22909;&#65292;&#29694;&#22312;&#38647;&#27472;&#36948;&#26031;&#23601;&#20132;&#32102;&#20320;&#20102;&#65281;<br>
	 * Message: Alright, now Leodas is yours!
	 */
	public static final NpcStringId ALRIGHT_NOW_LEODAS_IS_YOURS;
	
	/**
	 * ID: 1800112<br>
	 * Message: VȓzꂪKvȂ悤ȁDDDɖ߂邩҂ĂI<br>
	 * Message: &#35442;&#38656;&#35201;&#26032;&#30340;&#22900;&#38584;&#20102;&#46;&#46;&#46;&#25105;&#26371;&#24555;&#21435;&#24555;&#22238;&#65292;&#31245;&#24453;&#65281;<br>
	 * Message: We might need new slaves... I'll be back soon, so wait!
	 */
	public static final NpcStringId WE_MIGHT_NEED_NEW_SLAVES_ILL_BE_BACK_SOON_SO_WAIT;
	
	/**
	 * ID: 1800113<br>
	 * Message: ^C [vűNI<br>
	 * Message: &#26178;&#38291;&#36339;&#36493;&#35037;&#32622;&#21855;&#21205;&#25104;&#21151;&#65281;<br>
	 * Message: Time rift device activation successful!
	 */
	public static final NpcStringId TIME_RIFT_DEVICE_ACTIVATION_SUCCESSFUL;
	
	/**
	 * ID: 1800114<br>
	 * Message: ɎRIȂΎI<br>
	 * Message: &#19981;&#33258;&#30001;&#65292;&#27595;&#23527;&#27515;&#65281;&#65281;&#65281;<br>
	 * Message: Freedom or death!!!
	 */
	public static final NpcStringId FREEDOM_OR_DEATH;
	
	/**
	 * ID: 1800115<br>
	 * Message: ꂪ^̐m̈ӎuI<br>
	 * Message: &#36889;&#23601;&#26159;&#30495;&#27491;&#25136;&#22763;&#30340;&#24847;&#24535;&#65281;&#65281;&#65281;<br>
	 * Message: This is the will of true warriors!!!
	 */
	public static final NpcStringId THIS_IS_THE_WILL_OF_TRUE_WARRIORS;
	
	/**
	 * ID: 1800116<br>
	 * Message: ӂ̔т͒nŐH񂾂ȁI<br>
	 * Message: &#20320;&#30340;&#26202;&#39184;&#23601;&#22312;&#22320;&#29508;&#20139;&#29992;&#21543;&#65281;&#65281;&#65281;<br>
	 * Message: We'll have dinner in hell!!!
	 */
	public static final NpcStringId WELL_HAVE_DINNER_IN_HELL;
	
	/**
	 * ID: 1800117<br>
	 * Message: NȕFԐݒ $s1<br>
	 * Message: &#36215;&#29190;&#35037;&#32622;&#21021;&#22987;&#21270;&#32;&#45;&#23559;&#26178;&#38291;&#35373;&#23450;&#28858;&#24478;&#29694;&#22312;&#31639;&#36215;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#24460;&#45;&#32;<br>
	 * Message: Detonator initialization- time set for $s1 minute(s) from now-
	 */
	public static final NpcStringId DETONATOR_INITIALIZATION_TIME_S1_MINUTES_FROM_NOW;
	
	/**
	 * ID: 1800118<br>
	 * Message: WWWbF̊ɂsFOi۔F<br>
	 * Message: &#28363;&#46;&#46;&#46;&#46;&#46;&#46;&#45;&#26178;&#38291;&#27425;&#20803;&#24178;&#28041;&#37679;&#35492;&#45;&#30332;&#29983;&#21069;&#36914;&#29694;&#35937;&#45;<br>
	 * Message: Zzzz- city interference error - forward effect created-
	 */
	public static final NpcStringId ZZZZ_CITY_INTERFERENCE_ERROR_FORWARD_EFFECT_CREATED;
	
	/**
	 * ID: 1800119<br>
	 * Message: WWWbF̊ɂsFA۔F<br>
	 * Message: &#28363;&#46;&#46;&#46;&#46;&#46;&#46;&#45;&#26178;&#38291;&#27425;&#20803;&#24178;&#28041;&#37679;&#35492;&#45;&#30332;&#29983;&#22238;&#27512;&#29694;&#35937;&#45;<br>
	 * Message: Zzzz- city interference error - recurrence effect created-
	 */
	public static final NpcStringId ZZZZ_CITY_INTERFERENCE_ERROR_RECURRENCE_EFFECT_CREATED;
	
	/**
	 * ID: 1800120<br>
	 * Message: Ďė܂IĂI<br>
	 * Message: &#30435;&#35222;&#20853;&#23601;&#35201;&#25915;&#36914;&#20358;&#20102;&#65292;&#35531;&#36245;&#24555;&#25764;&#38626;&#21543;&#65281;<br>
	 * Message: Guards are coming, run!
	 */
	public static final NpcStringId GUARDS_ARE_COMING_RUN;
	
	/**
	 * ID: 1800121<br>
	 * Message: lłEoł܂I<br>
	 * Message: &#29694;&#22312;&#25105;&#19968;&#20491;&#20154;&#20063;&#33021;&#36867;&#33067;&#20102;&#65281;<br>
	 * Message: Now I can escape on my own!
	 */
	public static final NpcStringId NOW_I_CAN_ESCAPE_ON_MY_OWN;
	
	/**
	 * ID: 1800122<br>
	 * Message: ĂĂ肪Ƃ܂I<br>
	 * Message: &#38750;&#24120;&#24863;&#35613;&#24744;&#30340;&#30456;&#21161;&#65281;<br>
	 * Message: Thanks for your help!
	 */
	public static final NpcStringId THANKS_FOR_YOUR_HELP;
	
	/**
	 * ID: 1800123<br>
	 * Message: `[X^WAւ̓𖞂Ă炸ZLZ܂B<br>
	 * Message: &#23565;&#26041;&#38538;&#20237;&#19981;&#31526;&#21512;&#36914;&#20837;&#31478;&#25216;&#22580;&#30340;&#26781;&#20214;&#65292;&#22240;&#27492;&#21462;&#28040;&#20102;&#31478;&#36093;&#12290;<br>
	 * Message: Match cancelled. Opponent did not meet the stadium admission requirements.
	 */
	public static final NpcStringId MATCH_CANCELLED_OPPONENT_DID_NOT_MEET_THE_STADIUM_ADMISSION_REQUIREMENTS;
	
	/**
	 * ID: 1800124<br>
	 * Message: ͂͂́`Bɂɂ̂܂Ȃ玀ł䂭I<br>
	 * Message: &#21888;&#21704;&#21704;&#21704;&#126;&#24456;&#22909;&#65292;&#20320;&#23601;&#22312;&#30171;&#33510;&#20013;&#25497;&#25166;&#24930;&#24930;&#27515;&#21435;&#21543;&#65281;<br>
	 * Message: Ha-ha yes, die slowly writhing in pain and agony!
	 */
	public static final NpcStringId HA_HA_YES_DIE_SLOWLY_WRITHING_IN_PAIN_AND_AGONY;
	
	/**
	 * ID: 1800125<br>
	 * Message: ƂDDDƋȋɂDDDKvȂ̂DDD<br>
	 * Message: &#38656;&#35201;&#46;&#46;&#46;&#26356;&#46;&#46;&#46;&#26356;&#24375;&#28872;&#30340;&#30171;&#33510;&#46;&#46;&#46;<br>
	 * Message: More... need more... severe pain...
	 */
	public static final NpcStringId MORE_NEED_MORE_SEVERE_PAIN;
	
	/**
	 * ID: 1800126<br>
	 * Message: Iz那I<br>
	 * Message: &#21834;&#65281;&#29983;&#21629;&#34987;&#22890;&#36208;&#20102;&#65281;<br>
	 * Message: Ahh! My life is being drained out!
	 */
	public static final NpcStringId AHH_MY_LIFE_IS_BEING_DRAINED_OUT;
	
	/**
	 * ID: 1800127<br>
	 * Message: M̂̑̂NオĂ邼I<br>
	 * Message: &#28825;&#29105;&#30340;&#26481;&#35199;&#22312;&#39636;&#20839;&#32763;&#39472;&#21834;&#65281;<br>
	 * Message: Something is burning inside my body!
	 */
	public static final NpcStringId SOMETHING_IS_BURNING_INSIDE_MY_BODY;
	
	/**
	 * ID: 1800128<br>
	 * Message: $s1AX^WÃxɍĂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#24744;&#19981;&#31526;&#21512;&#31478;&#25216;&#22580;&#30340;&#31561;&#32026;&#12290;<br>
	 * Message: $s1. Not adequate for the stadium level.
	 */
	public static final NpcStringId S1_NOT_ADEQUATE_FOR_THE_STADIUM_LEVEL;
	
	/**
	 * ID: 1800129<br>
	 * Message: $s1AO̖DDD肪󂯎낤DDD<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#20320;&#30340;&#29983;&#21629;&#46;&#46;&#46;&#25105;&#26371;&#27427;&#28982;&#25509;&#21463;&#46;&#46;&#46;<br>
	 * Message: $s1, thank you... for giving me your life...
	 */
	public static final NpcStringId S1_THANK_YOU_FOR_GIVING_ME_YOUR_LIFE;
	
	/**
	 * ID: 1800130<br>
	 * Message: _AsI_IlAI<br>
	 * Message: &#25105;&#22833;&#25943;&#20102;&#46;&#46;&#46;&#65281;&#36948;&#37324;&#26114;&#65292;&#35531;&#24744;&#21407;&#35538;&#25105;&#21543;&#46;&#46;&#46;&#65281;<br>
	 * Message: I failed... Please forgive me, Darion...
	 */
	public static final NpcStringId I_FAILED_PLEASE_FORGIVE_ME_DARION;
	
	/**
	 * ID: 1800131<br>
	 * Message: $s1AK߂Ă邼DDDŜ͂܂DDD<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#25105;&#26371;&#20877;&#22238;&#20358;&#30340;&#46;&#46;&#46;&#21487;&#19981;&#35201;&#22826;&#23433;&#24515;&#46;&#46;&#46;&#65281;<br>
	 * Message: $s1, I'll be back... don't get comfortable...
	 */
	public static final NpcStringId S1_ILL_BE_BACK_DONT_GET_COMFORTABLE;
	
	/**
	 * ID: 1800132<br>
	 * Message: ̎̂܂܂ƎvDDDԈႢI<br>
	 * Message: &#20320;&#20197;&#28858;&#25105;&#26371;&#23601;&#36889;&#27171;&#34987;&#25802;&#20498;&#46;&#46;&#46;&#37027;&#23601;&#26159;&#20320;&#30340;&#22833;&#31639;&#65281;&#65281;<br>
	 * Message: If you think I'm giving up like this.. You're wrong!!
	 */
	public static final NpcStringId IF_YOU_THINK_IM_GIVING_UP_LIKE_THIS_YOURE_WRONG;
	
	/**
	 * ID: 1800133<br>
	 * Message: ςȂŖقĂ邩I<br>
	 * Message: &#20320;&#35201;&#36889;&#27171;&#30524;&#30556;&#30556;&#22320;&#30475;&#33879;&#25105;&#21463;&#38627;&#21966;&#65311;&#65281;<br>
	 * Message: So you're just going to watch me suffer?!
	 */
	public static final NpcStringId SO_YOURE_JUST_GOING_TO_WATCH_ME_SUFFER;
	
	/**
	 * ID: 1800134<br>
	 * Message: ܂܂I<br>
	 * Message: &#19968;&#20999;&#36996;&#27794;&#26377;&#32080;&#26463;&#65281;&#65281;<br>
	 * Message: It's not over yet!!
	 */
	public static final NpcStringId ITS_NOT_OVER_YET;
	
	/**
	 * ID: 1800135<br>
	 * Message: ͂͂Iʂ̂Ȃɕ|DDDǂDDDԓɎTo΁DDDJ邩DDDmʂDDD<br>
	 * Message: &#21704;&#21704;&#46;&#46;&#46;&#65281;&#31455;&#28982;&#36889;&#40636;&#24597;&#27515;&#46;&#46;&#46;&#35731;&#25105;&#30475;&#30475;&#46;&#46;&#46;&#21482;&#35201;&#22312;&#38480;&#23450;&#26178;&#38291;&#20839;&#25214;&#21040;&#25105;&#30340;&#35441;&#46;&#46;&#46;&#25110;&#35377;&#36996;&#26371;&#26377;&#46;&#46;&#46;&#36774;&#27861;&#46;&#46;&#46;<br>
	 * Message: HA-HA! You were so afraid of death... let me see... If you find me in time... maybe you can... find a way ...
	 */
	public static final NpcStringId HA_HA_YOU_WERE_SO_AFRAID_OF_DEATH_LET_ME_SEE_IF_YOU_FIND_ME_IN_TIME_MAYBE_YOU_CAN_FIND_A_WAY;
	
	/**
	 * ID: 1800136<br>
	 * Message: ĂDDD̎킶ƍi߂ĂDDD<br>
	 * Message: &#27714;&#27714;&#20320;&#65292;&#25937;&#25937;&#25105;&#21543;&#46;&#46;&#26576;&#20491;&#26481;&#35199;&#19968;&#30452;&#22312;&#25488;&#33879;&#25105;&#30340;&#33046;&#23376;&#46;&#46;&#46;<br>
	 * Message: Don't kill me please.. Something's strangling me...
	 */
	public static final NpcStringId DONT_KILL_ME_PLEASE_SOMETHINGS_STRANGLING_ME;
	
	/**
	 * ID: 1800137<br>
	 * Message: ̃bL[ȓz͒NȁH͂́Iy݂ȁI<br>
	 * Message: &#35504;&#26371;&#25104;&#28858;&#20170;&#26202;&#30340;&#24184;&#36939;&#20818;&#21602;&#65311;&#21704;&#21704;&#65281;&#30495;&#26159;&#22909;&#22855;&#65292;&#30495;&#26159;&#22909;&#22855;&#65281;<br>
	 * Message: Who will be the lucky one tonight? Ha-ha! Curious, very curious!
	 */
	public static final NpcStringId WHO_WILL_BE_THE_LUCKY_ONE_TONIGHT_HA_HA_CURIOUS_VERY_CURIOUS;
	
	/**
	 * ID: 1800138<br>
	 * Message: `bI`bIsbOgĂX^苭͂I<br>
	 * Message: &#21553;&#21553;&#65281;&#36889;&#27425;&#25033;&#35442;&#26371;&#27604;&#20197;&#21069;&#32982;&#35948;&#25152;&#20351;&#29992;&#30340;&#34909;&#25802;&#36996;&#35201;&#21426;&#23475;&#21908;&#65281;<br>
	 * Message: Squeak! This will be stronger than the stun the pig used last time!
	 */
	public static final NpcStringId SQUEAK_THIS_WILL_BE_STRONGER_THAN_THE_STUN_THE_PIG_USED_LAST_TIME;
	
	/**
	 * ID: 1800139<br>
	 * Message: `bI`bI@JXKēEg tBA[I󂯂Ă݂₪I<br>
	 * Message: &#21553;&#21553;&#65281;&#25509;&#25307;&#21543;&#65281;&#36899;&#23433;&#22612;&#29790;&#26031;&#20063;&#23475;&#24597;&#30340;&#32066;&#26997;&#24656;&#25084;&#65281;<br>
	 * Message: Squeak! Here it goes! Extremely scary, even to Valakas!
	 */
	public static final NpcStringId SQUEAK_HERE_IT_GOES_EXTREMELY_SCARY_EVEN_TO_VALAKAS;
	
	/**
	 * ID: 1800140<br>
	 * Message: `bI`bIǂsIقƂĂI<br>
	 * Message: &#21553;&#21553;&#65281;&#36208;&#38283;&#65281;&#21029;&#20877;&#29033;&#25105;&#21862;&#65281;<br>
	 * Message: Squeak! Go away! Leave us alone!
	 */
	public static final NpcStringId SQUEAK_GO_AWAY_LEAVE_US_ALONE;
	
	/**
	 * ID: 1800141<br>
	 * Message: `bI`bI݂ȁAW܂ꂥI̗͂ĂI<br>
	 * Message: &#21553;&#21553;&#65281;&#20804;&#24351;&#20497;&#65292;&#24555;&#20358;&#21834;&#65281;&#35731;&#20182;&#30631;&#30631;&#25105;&#20497;&#30340;&#21426;&#23475;&#65281;<br>
	 * Message: Squeak! Guys, gather up! Let's show our power!
	 */
	public static final NpcStringId SQUEAK_GUYS_GATHER_UP_LETS_SHOW_OUR_POWER;
	
	/**
	 * ID: 1800142<br>
	 * Message: ܂Aʂɂ肪炠킯Ȃ񂾂``FbI<br>
	 * Message: &#20063;&#19981;&#23436;&#20840;&#26159;&#28858;&#20102;&#24863;&#24681;&#65292;&#25152;&#20197;&#25165;&#26371;&#32102;&#20320;&#30340;&#21908;&#126;&#21553;&#21553;&#65281;<br>
	 * Message: It's not like I'm giving this because I'm grateful~ Squeak!
	 */
	public static final NpcStringId ITS_NOT_LIKE_IM_GIVING_THIS_BECAUSE_IM_GRATEFUL_SQUEAK;
	
	/**
	 * ID: 1800143<br>
	 * Message: `bI`bI肪ɂ񂾂ǁDDD{ɎÂẮIH<br>
	 * Message: &#21553;&#21553;&#65281;&#38614;&#28982;&#35498;&#26159;&#28858;&#20102;&#27835;&#30274;&#65292;&#20294;&#25105;&#30340;&#23617;&#32929;&#24456;&#30171;&#32822;&#65281;<br>
	 * Message: Squeak! Even if it is treatment, my bottom hurts so much!
	 */
	public static final NpcStringId SQUEAK_EVEN_IF_IT_IS_TREATMENT_MY_BOTTOM_HURTS_SO_MUCH;
	
	/**
	 * ID: 1800144<br>
	 * Message: `bI`bIvY Xg[ŕϐgI<br>
	 * Message: &#21553;&#21553;&#65281;&#21033;&#29992;&#26376;&#20809;&#27700;&#26230;&#26865;&#37857;&#30340;&#21147;&#37327;&#35722;&#36523;&#65281;<br>
	 * Message: Squeak! Transform to Moon Crystal Prism Power!
	 */
	public static final NpcStringId SQUEAK_TRANSFORM_TO_MOON_CRYSTAL_PRISM_POWER;
	
	/**
	 * ID: 1800145<br>
	 * Message: `bI`bII̎pɖ߂̌悧``<br>
	 * Message: &#21553;&#21553;&#65281;&#21834;&#65281;&#25105;&#19981;&#24819;&#24674;&#24489;&#21407;&#29376;&#32822;&#126;&#126;<br>
	 * Message: Squeak! Oh, no! I don't want to turn back again...
	 */
	public static final NpcStringId SQUEAK_OH_NO_I_DONT_WANT_TO_TURN_BACK_AGAIN;
	
	/**
	 * ID: 1800146<br>
	 * Message: `bI`bIAς񂾂B肪ƂˁB<br>
	 * Message: &#21553;&#21553;&#65281;&#22240;&#28858;&#25105;&#24456;&#26377;&#37666;&#65292;&#25152;&#20197;&#32102;&#24744;&#29305;&#21029;&#22810;&#21908;&#12290;&#35613;&#35613;&#24744;&#12290;<br>
	 * Message: Squeak! I'm specially giving you a lot since I'm rich. Thank you
	 */
	public static final NpcStringId SQUEAK_IM_SPECIALLY_GIVING_YOU_A_LOT_SINCE_IM_RICH_THANK_YOU;
	
	/**
	 * ID: 1800147<br>
	 * Message: uqIuqI{肪_܂ŒBłIp[IȂp[I<br>
	 * Message: &#21756;&#21756;&#65281;&#30495;&#26159;&#35731;&#20154;&#28779;&#20882;&#19977;&#19976;&#21834;&#65281;&#21147;&#126;&#37327;&#65281;&#28961;&#38480;&#21147;&#126;&#37327;&#65281;<br>
	 * Message: Oink-oink! Rage is boiling up inside of me! Power! Infinite power!!
	 */
	public static final NpcStringId OINK_OINK_RAGE_IS_BOILING_UP_INSIDE_OF_ME_POWER_INFINITE_POWER;
	
	/**
	 * ID: 1800148<br>
	 * Message: uqIuqIނނII<br>
	 * Message: &#21756;&#21756;&#65281;&#25105;&#29694;&#22312;&#24594;&#39662;&#34909;&#20896;&#21862;&#65281;<br>
	 * Message: Oink-oink! I'm really furious right now!
	 */
	public static final NpcStringId OINK_OINK_IM_REALLY_FURIOUS_RIGHT_NOW;
	
	/**
	 * ID: 1800149<br>
	 * Message: `bI`bI{肪_܂ŒBIp[IȂp[I<br>
	 * Message: &#21553;&#21553;&#65281;&#30495;&#26159;&#35731;&#20154;&#28779;&#20882;&#19977;&#19976;&#21834;&#65281;&#21147;&#126;&#37327;&#65281;&#28961;&#38480;&#21147;&#126;&#37327;&#65281;<br>
	 * Message: Squeak! Rage is boiling up inside of me! Power! Infinite power!!
	 */
	public static final NpcStringId SQUEAK_RAGE_IS_BOILING_UP_INSIDE_OF_ME_POWER_INFINITE_POWER;
	
	/**
	 * ID: 1800150<br>
	 * Message: `bI`bIȂLĂ邺I<br>
	 * Message: &#21553;&#21553;&#65281;&#25105;&#29694;&#22312;&#24594;&#39662;&#34909;&#20896;&#21862;&#65281;<br>
	 * Message: Squeak! I'm really furious right now!!
	 */
	public static final NpcStringId SQUEAK_IM_REALLY_FURIOUS_RIGHT_NOW;
	
	/**
	 * ID: 1800162<br>
	 * Message: GO[h<br>
	 * Message: &#71;&#31561;&#32026;<br>
	 * Message: G Rank
	 */
	public static final NpcStringId G_RANK;
	
	/**
	 * ID: 1800163<br>
	 * Message: قDDDłԂׂ݂قǂ̗͂Ă悤Ƃ͒N\zȂ낤B<br>
	 * Message: &#21834;&#46;&#46;&#46;&#30772;&#28357;&#30340;&#23384;&#22312;&#31455;&#28982;&#26371;&#25793;&#26377;&#36889;&#33324;&#30340;&#21147;&#37327;&#65292;&#25033;&#35442;&#27794;&#26377;&#20154;&#26371;&#29468;&#24819;&#21040;&#30340;&#46;&#46;&#46;<br>
	 * Message: Huh... No one would have guessed that a doomed creature would be so powerful...
	 */
	public static final NpcStringId HUH_NO_ONE_WOULD_HAVE_GUESSED_THAT_A_DOOMED_CREATURE_WOULD_BE_SO_POWERFUL;
	
	/**
	 * ID: 1800164<br>
	 * Message: SO[h<br>
	 * Message: &#83;&#31561;&#32026;<br>
	 * Message: S-Grade
	 */
	public static final NpcStringId S_GRADE;
	
	/**
	 * ID: 1800165<br>
	 * Message: AO[h<br>
	 * Message: &#65;&#31561;&#32026;<br>
	 * Message: A-Grade
	 */
	public static final NpcStringId A_GRADE;
	
	/**
	 * ID: 1800166<br>
	 * Message: BO[h<br>
	 * Message: &#66;&#31561;&#32026;<br>
	 * Message: B-Grade
	 */
	public static final NpcStringId B_GRADE;
	
	/**
	 * ID: 1800167<br>
	 * Message: CO[h<br>
	 * Message: &#67;&#31561;&#32026;<br>
	 * Message: C-Grade
	 */
	public static final NpcStringId C_GRADE;
	
	/**
	 * ID: 1800168<br>
	 * Message: DO[h<br>
	 * Message: &#68;&#31561;&#32026;<br>
	 * Message: D-Grade
	 */
	public static final NpcStringId D_GRADE;
	
	/**
	 * ID: 1800169<br>
	 * Message: FO[h<br>
	 * Message: &#70;&#31561;&#32026;<br>
	 * Message: F-Grade
	 */
	public static final NpcStringId F_GRADE;
	
	/**
	 * ID: 1800170<br>
	 * Message: ́DDD`̐^̉pYłȂ΂łȂقǂ̈̑ȋƐтI<br>
	 * Message: &#36889;&#46;&#46;&#46;&#36889;&#21487;&#26159;&#21482;&#26377;&#20659;&#35498;&#20013;&#30340;&#33521;&#38596;&#25165;&#20570;&#24471;&#21040;&#30340;&#20553;&#22823;&#25104;&#23601;&#21834;&#65281;<br>
	 * Message: This is... This is a great achievement that is worthy of the true heroes of legend!
	 */
	public static final NpcStringId THIS_IS_THIS_IS_A_GREAT_ACHIEVEMENT_THAT_IS_WORTHY_OF_THE_TRUE_HEROES_OF_LEGEND;
	
	/**
	 * ID: 1800171<br>
	 * Message: ɂقڂƂBJ}JʂĂĂN̖̎x点ׂ􂾁B<br>
	 * Message: &#30495;&#26159;&#20329;&#26381;&#65292;&#20320;&#30340;&#34920;&#29694;&#22823;&#22823;&#28187;&#32233;&#20102;&#32147;&#30001;&#27442;&#30028;&#32780;&#36914;&#34892;&#30340;&#20405;&#30053;&#36895;&#24230;&#12290;<br>
	 * Message: Admirable. You greatly decreased the speed of invasion through Kamaloka.
	 */
	public static final NpcStringId ADMIRABLE_YOU_GREATLY_DECREASED_THE_SPEED_OF_INVASION_THROUGH_KAMALOKA;
	
	/**
	 * ID: 1800172<br>
	 * Message: ɗhB̖`Ƃ̂{ɂقǂ̎͂B<br>
	 * Message: &#30495;&#26159;&#20102;&#19981;&#36215;&#65292;&#20320;&#37027;&#20625;&#20986;&#30340;&#23526;&#21147;&#36275;&#20197;&#25104;&#28858;&#20854;&#20182;&#20882;&#38570;&#23478;&#30340;&#27036;&#27171;&#12290;<br>
	 * Message: Very good. Your skill makes you a model for other adventurers to follow.
	 */
	public static final NpcStringId VERY_GOOD_YOUR_SKILL_MAKES_YOU_A_MODEL_FOR_OTHER_ADVENTURERS_TO_FOLLOW;
	
	/**
	 * ID: 1800173<br>
	 * Message: 悭B̖`ƂOقǂ̐ʂグꂽAXɊ]̌Ă邾낤B<br>
	 * Message: &#20570;&#24471;&#22909;&#65292;&#22914;&#26524;&#25152;&#26377;&#30340;&#20882;&#38570;&#23478;&#37117;&#33021;&#36948;&#25104;&#20687;&#20320;&#19968;&#27171;&#30340;&#25104;&#26524;&#65292;&#37027;&#40636;&#20284;&#20046;&#21487;&#20197;&#40670;&#29123;&#19968;&#32218;&#24076;&#26395;&#20102;&#12290;<br>
	 * Message: Good work. If all adventurers produce results like you, we will slowly start to see the glimmer of hope.
	 */
	public static final NpcStringId GOOD_WORK_IF_ALL_ADVENTURERS_PRODUCE_RESULTS_LIKE_YOU_WE_WILL_SLOWLY_START_TO_SEE_THE_GLIMMER_OF_HOPE;
	
	/**
	 * ID: 1800174<br>
	 * Message: cOA J}J͒NłCyɋ߂Â鑶݂ł͂Ȃ悤B<br>
	 * Message: &#30495;&#36986;&#25022;&#65292;&#30475;&#20358;&#20006;&#19981;&#26159;&#20219;&#20309;&#20154;&#37117;&#21487;&#20197;&#38568;&#24847;&#20405;&#20837;&#27442;&#30028;&#37002;&#32227;&#21834;&#12290;<br>
	 * Message: Unfortunately, it seems that Rim Kamaloka cannot be easily approached by everyone.
	 */
	public static final NpcStringId UNFORTUNATELY_IT_SEEMS_THAT_RIM_KAMALOKA_CANNOT_BE_EASILY_APPROACHED_BY_EVERYONE;
	
	/**
	 * ID: 1800175<br>
	 * Message: ]BO J}ĴƂɑ̂͊ԈႢ悤B<br>
	 * Message: &#30495;&#20196;&#20154;&#22833;&#26395;&#65292;&#30475;&#27171;&#23376;&#65292;&#23559;&#20320;&#36865;&#21040;&#27442;&#30028;&#37002;&#32227;&#26159;&#25105;&#30340;&#22833;&#31639;&#12290;<br>
	 * Message: How disappointing. It looks like I made a mistake in sending you inside Rim Kamaloka.
	 */
	public static final NpcStringId HOW_DISAPPOINTING_IT_LOOKS_LIKE_I_MADE_A_MISTAKE_IN_SENDING_YOU_INSIDE_RIM_KAMALOKA;
	
	/**
	 * ID: 1800176<br>
	 * Message: AɂイAAAɂイAAB<br>
	 * Message: &#26377;&#8231;&#20837;&#8231;&#20405;&#8231;&#32773;&#8231;&#26377;&#8231;&#20837;&#8231;&#20405;&#8231;&#32773;&#12290;<br>
	 * Message: Intruder alert. Intruder alert.
	 */
	public static final NpcStringId INTRUDER_ALERT_INTRUDER_ALERT;
	
	/**
	 * ID: 1800177<br>
	 * Message: Ă񂾁IƎI<br>
	 * Message: &#20320;&#22312;&#24185;&#20160;&#40636;&#65281;&#36996;&#19981;&#36245;&#24555;&#20358;&#24171;&#25105;&#65281;<br>
	 * Message: What are you doing? Hurry up and help me!
	 */
	public static final NpcStringId WHAT_ARE_YOU_DOING_HURRY_UP_AND_HELP_ME;
	
	/**
	 * ID: 1800178<br>
	 * Message: ܂Ŏ{点Ƃ͂ȁDDDႨȂI<br>
	 * Message: &#31455;&#25954;&#25226;&#25105;&#24825;&#27611;&#20102;&#46;&#46;&#46;&#25105;&#19981;&#26371;&#21892;&#32631;&#29976;&#20241;&#65281;<br>
	 * Message: I've had it up to here with you! I'll take care of you!
	 */
	public static final NpcStringId IVE_HAD_IT_UP_TO_HERE_WITH_YOU_ILL_TAKE_CARE_OF_YOU;
	
	/**
	 * ID: 1800179<br>
	 * Message: `SĂI<br>
	 * Message: &#21834;&#21834;&#46;&#46;&#46;&#31934;&#31070;&#35201;&#23849;&#28528;&#20102;&#12290;<br>
	 * Message: Ah... My mind is a wreck.
	 */
	public static final NpcStringId AH_MY_MIND_IS_A_WRECK;
	
	/**
	 * ID: 1800180<br>
	 * Message: ̎艺̐ȂǂmĂƎvĂȂԈႢI<br>
	 * Message: &#20197;&#28858;&#25105;&#30340;&#25163;&#19979;&#23601;&#21482;&#26377;&#36889;&#20123;&#65292;&#37027;&#21487;&#30495;&#26159;&#22823;&#37679;&#29305;&#37679;&#21862;&#65281;<br>
	 * Message: If you thought that my subordinates would be so few, you are mistaken!
	 */
	public static final NpcStringId IF_YOU_THOUGHT_THAT_MY_SUBORDINATES_WOULD_BE_SO_FEW_YOU_ARE_MISTAKEN;
	
	/**
	 * ID: 1800181<br>
	 * Message: ܂肨ɂ͗Ȃł傤A܂B<br>
	 * Message: &#38614;&#28982;&#25105;&#30340;&#23526;&#21147;&#24494;&#34180;&#65292;&#20294;&#25105;&#19968;&#23450;&#26371;&#21161;&#24744;&#19968;&#33218;&#20043;&#21147;&#30340;&#12290;<br>
	 * Message: There's not much I can do, but I want to help you.
	 */
	public static final NpcStringId THERES_NOT_MUCH_I_CAN_DO_BUT_I_WANT_TO_HELP_YOU;
	
	/**
	 * ID: 1800182<br>
	 * Message: AĂ߂I$s1Iɂڂɂ킵ĂȁI<br>
	 * Message: &#22823;&#22821;&#20497;&#65292;&#21435;&#25915;&#25802;&#12300;&#36;&#115;&#49;&#12301;&#37027;&#20491;&#20642;&#20249;&#21543;&#65281;<br>
	 * Message: You $s1! Attack them!
	 */
	public static final NpcStringId YOU_S1_ATTACK_THEM;
	
	/**
	 * ID: 1800183<br>
	 * Message: ołA䂪艺ǂI̖茸炵ĂOĂ񂾂̂B̂ĂołЕtI<br>
	 * Message: &#20986;&#20358;&#21543;&#65281;&#25105;&#30340;&#25163;&#19979;&#65281;&#26082;&#28982;&#25105;&#20197;&#19968;&#37096;&#20221;&#30340;&#29983;&#21629;&#21484;&#21914;&#20102;&#20320;&#65292;&#20320;&#23601;&#20840;&#21147;&#36245;&#36208;&#37027;&#20123;&#20642;&#20249;&#21543;&#12290;<br>
	 * Message: Come out! My subordinate! I summon you to drive them out!
	 */
	public static final NpcStringId COME_OUT_MY_SUBORDINATE_I_SUMMON_YOU_TO_DRIVE_THEM_OUT;
	
	/**
	 * ID: 1800184<br>
	 * Message: 債Ƃ͂ł܂񂪁A̖Ăł͂ɂȂ܂B<br>
	 * Message: &#21329;&#24494;&#30340;&#25105;&#46;&#46;&#46;&#23601;&#31639;&#19999;&#19979;&#24615;&#21629;&#65292;&#20063;&#26371;&#25104;&#28858;&#24744;&#24375;&#22823;&#30340;&#21147;&#37327;&#65281;<br>
	 * Message: There's not much I can do, but I will risk my life to help you!
	 */
	public static final NpcStringId THERES_NOT_MUCH_I_CAN_DO_BUT_I_WILL_RISK_MY_LIFE_TO_HELP_YOU;
	
	/**
	 * ID: 1800185<br>
	 * Message: I͒ɂI<br>
	 * Message: &#21683;&#46;&#46;&#46;&#36889;&#27425;&#30495;&#30171;&#46;&#46;&#46;<br>
	 * Message: Arg! The pain is more than I can stand!
	 */
	public static final NpcStringId ARG_THE_PAIN_IS_MORE_THAN_I_CAN_STAND;
	
	/**
	 * ID: 1800186<br>
	 * Message: I̋}ǂāDDD<br>
	 * Message: &#21834;&#65281;&#24590;&#40636;&#26371;&#30475;&#20986;&#25105;&#30340;&#24369;&#40670;&#21602;&#65311;<br>
	 * Message: Ahh! How did he find my weakness?
	 */
	public static final NpcStringId AHH_HOW_DID_HE_FIND_MY_WEAKNESS;
	
	/**
	 * ID: 1800187<br>
	 * Message: O|JirIĂǂJ}J̃GbZXW߂̂ɐBAꂾB<br>
	 * Message: &#22810;&#34407;&#20320;&#25152;&#25802;&#20498;&#30340;&#37027;&#20123;&#21345;&#32013;&#27604;&#26114;&#65292;&#20063;&#33021;&#25104;&#21151;&#22320;&#25910;&#38598;&#21040;&#27442;&#30028;&#30340;&#31934;&#33775;&#20102;&#65292;&#22312;&#36889;&#35041;&#12290;<br>
	 * Message: We were able to successfully collect the Essence of Kamaloka from the Kanabions that you defeated. Here they are.
	 */
	public static final NpcStringId WE_WERE_ABLE_TO_SUCCESSFULLY_COLLECT_THE_ESSENCE_OF_KAMALOKA_FROM_THE_KANABIONS_THAT_YOU_DEFEATED_HERE_THEY_ARE;
	
	/**
	 * ID: 1800188<br>
	 * Message: AO|JirIǂJ}J̃GbZXȂɏW߂邱ƂłBAꂾB<br>
	 * Message: &#19981;&#36942;&#65292;&#25105;&#36996;&#26159;&#26377;&#24478;&#37027;&#20123;&#21345;&#32013;&#27604;&#26114;&#25910;&#38598;&#21040;&#27442;&#30028;&#30340;&#31934;&#33775;&#65292;&#22312;&#36889;&#35041;&#12290;<br>
	 * Message: But we were able to collect somehow the Essence of Kamaloka from the Kanabions that you defeated. Here they are.
	 */
	public static final NpcStringId BUT_WE_WERE_ABLE_TO_COLLECT_SOMEHOW_THE_ESSENCE_OF_KAMALOKA_FROM_THE_KANABIONS_THAT_YOU_DEFEATED_HERE_THEY_ARE;
	
	/**
	 * ID: 1800189<br>
	 * Message: O|JirIǂɏhĂł̃I[͔łBJ}J̃GbZXW߂̂Ɏs悤B<br>
	 * Message: &#24456;&#25265;&#27465;&#65292;&#20320;&#25152;&#25802;&#20498;&#30340;&#21345;&#32013;&#27604;&#26114;&#65292;&#20854;&#34314;&#21547;&#30340;&#40657;&#26263;&#20043;&#27683;&#22826;&#24369;&#65292;&#22240;&#27492;&#28961;&#27861;&#25104;&#21151;&#22320;&#25910;&#38598;&#21040;&#27442;&#30028;&#30340;&#31934;&#33775;&#12290;<br>
	 * Message: I'm sorry, but we were unable to collect the Essence of Kamaloka from the Kanabions that you defeated because their dark energy was too weak.
	 */
	public static final NpcStringId IM_SORRY_BUT_WE_WERE_UNABLE_TO_COLLECT_THE_ESSENCE_OF_KAMALOKA_FROM_THE_KANABIONS_THAT_YOU_DEFEATED_BECAUSE_THEIR_DARK_ENERGY_WAS_TOO_WEAK;
	
	/**
	 * ID: 1800190<br>
	 * Message: PɓG|ł͂ȂAX]ł̂O͏[킩Ă悤ȁB<br>
	 * Message: &#30475;&#20358;&#20320;&#30340;&#29992;&#24515;&#19981;&#20677;&#22312;&#26044;&#25802;&#20498;&#25973;&#32676;&#65292;&#20063;&#38750;&#24120;&#20102;&#35299;&#25105;&#20497;&#30340;&#38656;&#27714;&#12290;<br>
	 * Message: Rather than simply defeating the enemies, you seem to understand our goal and purpose as well.
	 */
	public static final NpcStringId RATHER_THAN_SIMPLY_DEFEATING_THE_ENEMIES_YOU_SEEM_TO_UNDERSTAND_OUR_GOAL_AND_PURPOSE_AS_WELL;
	
	/**
	 * ID: 1800191<br>
	 * Message: hbv[{Ch̓JirÏł̃I[wꂽ`BJ}J̍UH~߂邽߂ɂ́A|ƂɈw͂˂΂ȂȂB<br>
	 * Message: &#37117;&#21340;&#21202;&#25110;&#26159;&#21338;&#20234;&#24503;&#65292;&#37117;&#26159;&#21345;&#32013;&#27604;&#26114;&#30340;&#40657;&#26263;&#20043;&#27683;&#26356;&#21152;&#24375;&#21270;&#30340;&#22411;&#24907;&#65292;&#28858;&#20102;&#38459;&#25803;&#27442;&#30028;&#30340;&#20405;&#35186;&#65292;&#38656;&#35201;&#26356;&#23560;&#27880;&#26044;&#25802;&#20498;&#20182;&#20497;&#12290;<br>
	 * Message: Dopplers and Voids possess an enhanced amount of the Kanabions' dark energy, so it is important to concentrate on defeating them when blocking the Kamalokians attack.
	 */
	public static final NpcStringId DOPPLERS_AND_VOIDS_POSSESS_AN_ENHANCED_AMOUNT_OF_THE_KANABIONS_DARK_ENERGY_SO_IT_IS_IMPORTANT_TO_CONCENTRATE_ON_DEFEATING_THEM_WHEN_BLOCKING_THE_KAMALOKIANS_ATTACK;
	
	/**
	 * ID: 1800192<br>
	 * Message: JirIVȃJirIĂ̂Ƃ邩BÛƂ|ƂɁAő̃_[W^ƁAȏʂɏo킷ƂB<br>
	 * Message: &#26377;&#30475;&#36942;&#21345;&#32013;&#27604;&#26114;&#20598;&#29246;&#35069;&#36896;&#20986;&#26032;&#21345;&#32013;&#27604;&#26114;&#30340;&#29694;&#35937;&#21966;&#65311;&#32893;&#35498;&#22312;&#36914;&#34892;&#25915;&#25802;&#25110;&#25802;&#20498;&#20182;&#20497;&#26178;&#65292;&#33509;&#32102;&#20104;&#26997;&#22823;&#20663;&#23475;&#30340;&#35441;&#65292;&#23601;&#26371;&#26377;&#27231;&#26371;&#30446;&#30585;&#37027;&#20491;&#29694;&#35937;&#12290;<br>
	 * Message: Have you seen Kanabions being remade as new Kanabions sometimes? You can see it occur more often by inflicting great damage during an attack or at the moment you defeat them.
	 */
	public static final NpcStringId HAVE_YOU_SEEN_KANABIONS_BEING_REMADE_AS_NEW_KANABIONS_SOMETIMES_YOU_CAN_SEE_IT_OCCUR_MORE_OFTEN_BY_INFLICTING_GREAT_DAMAGE_DURING_AN_ATTACK_OR_AT_THE_MOMENT_YOU_DEFEAT_THEM;
	
	/**
	 * ID: 1800193<br>
	 * Message: ǂȐ퓬ɂĂł悤ɁA J}Jł͂莩邱ƂŗDȂ̂BYłȂBX͖dȃ`WȂǖ]ł͂Ȃ̂B<br>
	 * Message: &#23601;&#22914;&#21516;&#25152;&#26377;&#30340;&#25136;&#39717;&#33324;&#65292;&#22312;&#37002;&#32227;&#27442;&#30028;&#20839;&#37096;&#65292;&#35352;&#24471;&#32173;&#35703;&#33258;&#36523;&#23433;&#20840;&#25165;&#26159;&#26368;&#37325;&#35201;&#30340;&#12290;&#25105;&#20497;&#35201;&#27714;&#30340;&#20006;&#19981;&#26159;&#30450;&#30446;&#30340;&#25361;&#25136;&#12290;<br>
	 * Message: As in any other battle, it is critical to protect yourself while you are inside Rim Kamaloka. We do not want to attack recklessly.
	 */
	public static final NpcStringId AS_IN_ANY_OTHER_BATTLE_IT_IS_CRITICAL_TO_PROTECT_YOURSELF_WHILE_YOU_ARE_INSIDE_RIM_KAMALOKA_WE_DO_NOT_WANT_TO_ATTACK_RECKLESSLY;
	
	/**
	 * ID: 1800194<br>
	 * Message: X͈x̏ASȂl̐mĂ邱ƂɉluĂ̂B񑼐lɗĂ܂ȂA͎̗͂Ń`WĂ݂̂͂ǂH<br>
	 * Message: &#25105;&#20497;&#37325;&#35222;&#33853;&#23526;&#26044;&#20581;&#20840;&#25136;&#21147;&#30340;&#22521;&#39178;&#65292;&#32780;&#38750;&#21934;&#19968;&#30340;&#21213;&#21033;&#12290;&#22914;&#26524;&#36889;&#27425;&#24471;&#21040;&#20102;&#20182;&#20154;&#30340;&#21332;&#21161;&#65292;&#37027;&#40636;&#19979;&#27425;&#23601;&#22039;&#35430;&#20197;&#33258;&#24049;&#30340;&#21147;&#37327;&#25361;&#25136;&#65292;&#22914;&#20309;&#65311;<br>
	 * Message: We value developing an individual's overall power rather than a one-time victory. If you relied on another person's support this time, why don't you try to rely on your own strength next time?
	 */
	public static final NpcStringId WE_VALUE_DEVELOPING_AN_INDIVIDUALS_OVERALL_POWER_RATHER_THAN_A_ONE_TIME_VICTORY_IF_YOU_RELIED_ON_ANOTHER_PERSONS_SUPPORT_THIS_TIME_WHY_DONT_YOU_TRY_TO_RELY_ON_YOUR_OWN_STRENGTH_NEXT_TIME;
	
	/**
	 * ID: 1800195<br>
	 * Message: قǂ̐퓬̃xɍĂƎvĂ̂BVтŃx̒ႢJirIɑɂ̂́A̖͂ʂɌ邪ȁB<br>
	 * Message: &#20320;&#35469;&#28858;&#21083;&#25165;&#30340;&#25136;&#39717;&#26377;&#36948;&#21040;&#20196;&#33258;&#24049;&#28415;&#24847;&#30340;&#27700;&#28310;&#21966;&#65311;&#20294;&#25105;&#20497;&#30475;&#20358;&#65292;&#21482;&#26159;&#38568;&#33288;&#23565;&#20184;&#19979;&#31561;&#30340;&#21345;&#32013;&#27604;&#26114;&#32631;&#20102;&#65292;&#36889;&#26681;&#26412;&#23601;&#26159;&#22312;&#28010;&#36027;&#25136;&#21147;&#12290;<br>
	 * Message: Are you sure that the battle just now was at the appropriate level? Bothering lower Kanabions, as if for mere entertainment, is considered to be a wasted battle for us.
	 */
	public static final NpcStringId ARE_YOU_SURE_THAT_THE_BATTLE_JUST_NOW_WAS_AT_THE_APPROPRIATE_LEVEL_BOTHERING_LOWER_KANABIONS_AS_IF_FOR_MERE_ENTERTAINMENT_IS_CONSIDERED_TO_BE_A_WASTED_BATTLE_FOR_US;
	
	/**
	 * ID: 1800196<br>
	 * Message: ō̏Ƃ͗^ꂽi𑍓āAɃ`X^Ał邾I点邱ƂBvȂB<br>
	 * Message: &#20540;&#24471;&#35738;&#32654;&#30340;&#21213;&#21033;&#65292;&#23601;&#26159;&#22312;&#26044;&#21205;&#21729;&#25152;&#26377;&#30340;&#25136;&#21147;&#12289;&#26039;&#32085;&#25152;&#26377;&#25973;&#26041;&#30340;&#27231;&#26371;&#12289;&#22312;&#26368;&#30701;&#26178;&#38291;&#20839;&#19968;&#33289;&#27570;&#28357;&#25973;&#20154;&#12290;&#20320;&#19981;&#36889;&#40636;&#35469;&#28858;&#21966;&#65311;<br>
	 * Message: The greatest victory involves using all available resources, eliminating all of the enemy's opportunities, and bringing it to the fastest possible end. Don't you think so?
	 */
	public static final NpcStringId THE_GREATEST_VICTORY_INVOLVES_USING_ALL_AVAILABLE_RESOURCES_ELIMINATING_ALL_OF_THE_ENEMYS_OPPORTUNITIES_AND_BRINGING_IT_TO_THE_FASTEST_POSSIBLE_END_DONT_YOU_THINK_SO;
	
	/**
	 * ID: 1800197<br>
	 * Message: 펖ԔIOǑϋvx}ɗĂI<br>
	 * Message: &#32202;&#24613;&#65281;&#32202;&#24613;&#65281;&#22806;&#22478;&#29254;&#32784;&#20037;&#24230;&#27491;&#22312;&#24613;&#36895;&#19979;&#38477;&#65281;<br>
	 * Message: Emergency! Emergency! The outer wall is weakening rapidly!
	 */
	public static final NpcStringId EMERGENCY_EMERGENCY_THE_OUTER_WALL_IS_WEAKENING_RAPIDLY;
	
	/**
	 * ID: 1800198<br>
	 * Message: OǑϋvxc$s1I<br>
	 * Message: &#22806;&#22478;&#29254;&#32784;&#20037;&#24230;&#21097;&#39192;&#12300;&#36;&#115;&#49;&#12301;&#65281;<br>
	 * Message: The remaining strength of the outer wall is $s1!
	 */
	public static final NpcStringId THE_REMAINING_STRENGTH_OF_THE_OUTER_WALL_IS_S1;
	
	/**
	 * ID: 1800199<br>
	 * Message: pXt@C_[̋~<br>
	 * Message: &#38283;&#25299;&#32773;&#30340;&#25937;&#36118;&#32773;<br>
	 * Message: Pathfinder Savior
	 */
	public static final NpcStringId PATHFINDER_SAVIOR;
	
	/**
	 * ID: 1800200<br>
	 * Message: pXt@C_[͎̋<br>
	 * Message: &#38283;&#25299;&#32773;&#30340;&#21332;&#21161;&#32773;<br>
	 * Message: Pathfinder Supporter
	 */
	public static final NpcStringId PATHFINDER_SUPPORTER;
	
	/**
	 * ID: 1800201<br>
	 * Message: ܂V̂ɊꂫĂȂꕔ̃JirÍAg̍\ɂ낭Ȃ邱ƂB̂Ƃ_čU΁AɌʂグ񂾁B<br>
	 * Message: &#26377;&#19968;&#37096;&#20998;&#23578;&#26410;&#23436;&#20840;&#36969;&#25033;&#26032;&#22411;&#24907;&#32905;&#39636;&#30340;&#21345;&#32013;&#27604;&#26114;&#65292;&#26377;&#26178;&#26371;&#20986;&#29694;&#36523;&#39636;&#27083;&#36896;&#35722;&#24471;&#38750;&#24120;&#33030;&#24369;&#30340;&#29376;&#24907;&#12290;&#33509;&#22312;&#27492;&#26178;&#25915;&#25802;&#20182;&#20497;&#65292;&#21487;&#20197;&#24471;&#21040;&#30456;&#30070;&#39023;&#33879;&#30340;&#25928;&#26524;&#12290;<br>
	 * Message: Some Kanabions who haven't fully adjusted yet to their new physical form are known to exhibit symptoms of an extremely weakened body structure sometimes. If you attack them at that moment, you will have great results.
	 */
	public static final NpcStringId SOME_KANABIONS_WHO_HAVENT_FULLY_ADJUSTED_YET_TO_THEIR_NEW_PHYSICAL_FORM_ARE_KNOWN_TO_EXHIBIT_SYMPTOMS_OF_AN_EXTREMELY_WEAKENED_BODY_STRUCTURE_SOMETIMES_IF_YOU_ATTACK_THEM_AT_THAT_MOMENT_YOU_WILL_HAVE_GREAT_RESULTS;
	
	/**
	 * ID: 1800202<br>
	 * Message: $s1̂Ƃ͕Ƃ邩B܂ɐ^$s2I<br>
	 * Message: &#32893;&#35498;&#36942;&#26377;&#38364;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#20107;&#24773;&#21966;&#65311;&#37027;&#26159;&#30495;&#27491;&#30340;&#12300;&#36;&#115;&#50;&#12301;&#65281;<br>
	 * Message: Have you ever heard of $s1? They say it's a genuine $s2!
	 */
	public static final NpcStringId HAVE_YOU_EVER_HEARD_OF_S1_THEY_SAY_ITS_A_GENUINE_S2;
	
	/**
	 * ID: 1800203<br>
	 * Message: NẽL[űZ̐\ݏI܂ł5łB<br>
	 * Message: &#26607;&#38647;&#22612;&#30340;&#26230;&#39636;&#27604;&#36093;&#30331;&#35352;&#30003;&#35531;&#26178;&#38291;&#65292;&#23578;&#39192;&#53;&#20998;&#37912;&#12290;<br>
	 * Message: There are 5 minutes remaining to register for Kratei's cube match.
	 */
	public static final NpcStringId THERE_ARE_5_MINUTES_REMAINING_TO_REGISTER_FOR_KRATEIS_CUBE_MATCH;
	
	/**
	 * ID: 1800204<br>
	 * Message: NẽL[űZ̐\ݏI܂ł3łB<br>
	 * Message: &#26607;&#38647;&#22612;&#30340;&#26230;&#39636;&#27604;&#36093;&#30331;&#35352;&#30003;&#35531;&#26178;&#38291;&#65292;&#23578;&#39192;&#51;&#20998;&#37912;&#12290;<br>
	 * Message: There are 3 minutes remaining to register for Kratei's cube match.
	 */
	public static final NpcStringId THERE_ARE_3_MINUTES_REMAINING_TO_REGISTER_FOR_KRATEIS_CUBE_MATCH;
	
	/**
	 * ID: 1800205<br>
	 * Message: NẽL[űZ̐\ݏI܂ł1łB<br>
	 * Message: &#26607;&#38647;&#22612;&#30340;&#26230;&#39636;&#27604;&#36093;&#30331;&#35352;&#30003;&#35531;&#26178;&#38291;&#65292;&#23578;&#39192;&#49;&#20998;&#37912;&#12290;<br>
	 * Message: There are 1 minutes remaining to register for Kratei's cube match.
	 */
	public static final NpcStringId THERE_ARE_1_MINUTES_REMAINING_TO_REGISTER_FOR_KRATEIS_CUBE_MATCH;
	
	/**
	 * ID: 1800207<br>
	 * Message: ܂ȂZn܂܂B<br>
	 * Message: &#31245;&#24460;&#27604;&#36093;&#23559;&#26371;&#38283;&#22987;&#12290;<br>
	 * Message: The match will begin shortly.
	 */
	public static final NpcStringId THE_MATCH_WILL_BEGIN_SHORTLY;
	
	/**
	 * ID: 1800209<br>
	 * Message: SIIIIHDDD<br>
	 * Message: &#38283;&#46;&#46;&#46;&#38283;&#46;&#46;&#46;&#22987;&#46;&#46;&#46;<br>
	 * Message: Ohh...oh...oh...
	 */
	public static final NpcStringId OHHOHOH;
	
	/**
	 * ID: 1800210<br>
	 * Message: <br>
	 * Message: &#28779;<br>
	 * Message: Fire
	 */
	public static final NpcStringId FIRE;
	
	/**
	 * ID: 1800211<br>
	 * Message: <br>
	 * Message: &#27700;<br>
	 * Message: Water
	 */
	public static final NpcStringId WATER;
	
	/**
	 * ID: 1800212<br>
	 * Message: <br>
	 * Message: &#39080;<br>
	 * Message: Wind
	 */
	public static final NpcStringId WIND;
	
	/**
	 * ID: 1800213<br>
	 * Message: n<br>
	 * Message: &#22320;<br>
	 * Message: Earth
	 */
	public static final NpcStringId EARTH;
	
	/**
	 * ID: 1800214<br>
	 * Message: $s1DDD<br>
	 * Message: &#46;&#46;&#46;&#26159;&#12300;&#36;&#115;&#49;&#12301;&#46;&#46;&#46;<br>
	 * Message: ...It's $s1...
	 */
	public static final NpcStringId ITS_S1;
	
	/**
	 * ID: 1800215<br>
	 * Message: $s1ɋDDD<br>
	 * Message: &#46;&#46;&#46;&#23565;&#12300;&#36;&#115;&#49;&#12301;&#25239;&#24615;&#24375;&#46;&#46;&#46;<br>
	 * Message: ...$s1 is strong...
	 */
	public static final NpcStringId S1_IS_STRONG;
	
	/**
	 * ID: 1800216<br>
	 * Message: $s1mȂ̂DDD<br>
	 * Message: &#46;&#46;&#46;&#22909;&#20687;&#21482;&#30693;&#36947;&#12300;&#36;&#115;&#49;&#12301;&#32822;&#46;&#46;&#46;<br>
	 * Message: ...It's always $s1...
	 */
	public static final NpcStringId ITS_ALWAYS_S1;
	
	/**
	 * ID: 1800217<br>
	 * Message: $s1͂߂DDD<br>
	 * Message: &#46;&#46;&#46;&#25105;&#30475;&#12300;&#36;&#115;&#49;&#12301;&#26159;&#19981;&#34892;&#20102;&#46;&#46;&#46;<br>
	 * Message: ...$s1 won't do...
	 */
	public static final NpcStringId S1_WONT_DO;
	
	/**
	 * ID: 1800218<br>
	 * Message: 󕨂ɎoƂ҂ɂ͎􂢂邾낤I<br>
	 * Message: &#35244;&#35238;&#23542;&#29289;&#32773;&#65292;&#24517;&#26371;&#21463;&#21040;&#35419;&#21650;&#65281;<br>
	 * Message: You will be cursed for seeking the treasure!
	 */
	public static final NpcStringId YOU_WILL_BE_CURSED_FOR_SEEKING_THE_TREASURE;
	
	/**
	 * ID: 1800219<br>
	 * Message: sD܂B5ɎIɏo܂B<br>
	 * Message: &#24050;&#21484;&#21914;&#21040;&#39131;&#31354;&#33351;&#12290;&#53;&#20998;&#37912;&#24460;&#65292;&#23559;&#26371;&#33258;&#21205;&#20986;&#30332;&#12290;<br>
	 * Message: The airship has been summoned. It will automatically depart in 5 minutes.
	 */
	public static final NpcStringId THE_AIRSHIP_HAS_BEEN_SUMMONED_IT_WILL_AUTOMATICALLY_DEPART_IN_5_MINUTES;
	
	/**
	 * ID: 1800220<br>
	 * Message: ֔sD܂B1ɃAfɌďo܂B<br>
	 * Message: &#23450;&#26399;&#39131;&#31354;&#33351;&#24050;&#32147;&#25269;&#36948;&#12290;&#49;&#20998;&#37912;&#24460;&#65292;&#23559;&#26371;&#38283;&#24448;&#20126;&#19969;&#22823;&#38520;&#12290;<br>
	 * Message: The regularly scheduled airship has arrived. It will depart for the Aden continent in 1 minute.
	 */
	public static final NpcStringId THE_REGULARLY_SCHEDULED_AIRSHIP_HAS_ARRIVED_IT_WILL_DEPART_FOR_THE_ADEN_CONTINENT_IN_1_MINUTE;
	
	/**
	 * ID: 1800221<br>
	 * Message: AfɌsDo܂B<br>
	 * Message: &#38283;&#24448;&#20126;&#19969;&#22823;&#38520;&#30340;&#23450;&#26399;&#39131;&#31354;&#33351;&#24050;&#20986;&#30332;&#12290;<br>
	 * Message: The regularly scheduled airship that flies to the Aden continent has departed.
	 */
	public static final NpcStringId THE_REGULARLY_SCHEDULED_AIRSHIP_THAT_FLIES_TO_THE_ADEN_CONTINENT_HAS_DEPARTED;
	
	/**
	 * ID: 1800222<br>
	 * Message: ֔sD܂B1ɃOVAɌďo܂B<br>
	 * Message: &#23450;&#26399;&#39131;&#31354;&#33351;&#24050;&#32147;&#25269;&#36948;&#12290;&#49;&#20998;&#37912;&#24460;&#65292;&#23559;&#26371;&#38283;&#24448;&#26684;&#21202;&#35199;&#20126;&#22823;&#38520;&#12290;<br>
	 * Message: The regularly scheduled airship has arrived. It will depart for the Gracia continent in 1 minute.
	 */
	public static final NpcStringId THE_REGULARLY_SCHEDULED_AIRSHIP_HAS_ARRIVED_IT_WILL_DEPART_FOR_THE_GRACIA_CONTINENT_IN_1_MINUTE;
	
	/**
	 * ID: 1800223<br>
	 * Message: OVAɌ֔sDo܂B<br>
	 * Message: &#38283;&#24448;&#26684;&#21202;&#35199;&#20126;&#22823;&#38520;&#30340;&#23450;&#26399;&#39131;&#31354;&#33351;&#24050;&#20986;&#30332;&#12290;<br>
	 * Message: The regularly scheduled airship that flies to the Gracia continent has departed.
	 */
	public static final NpcStringId THE_REGULARLY_SCHEDULED_AIRSHIP_THAT_FLIES_TO_THE_GRACIA_CONTINENT_HAS_DEPARTED;
	
	/**
	 * ID: 1800224<br>
	 * Message: ɂ͑̔sDĂ܂B܂قǂpB<br>
	 * Message: &#30908;&#38957;&#19978;&#24050;&#26377;&#21484;&#21914;&#20854;&#20182;&#30340;&#39131;&#31354;&#33351;&#65292;&#35531;&#31245;&#24460;&#20877;&#21033;&#29992;&#12290;<br>
	 * Message: Another airship has been summoned to the wharf. Please try again later.
	 */
	public static final NpcStringId ANOTHER_AIRSHIP_HAS_BEEN_SUMMONED_TO_THE_WHARF_PLEASE_TRY_AGAIN_LATER;
	
	/**
	 * ID: 1800225<br>
	 * Message: H󂪕ςȁDDDIÁI<br>
	 * Message: &#21670;&#65311;&#22825;&#31354;&#26377;&#40670;&#24618;&#24618;&#30340;&#21908;&#65311;&#37027;&#26159;&#20160;&#40636;&#21671;&#65311;<br>
	 * Message: Huh? The sky looks funny. What's that?
	 */
	public static final NpcStringId HUH_THE_SKY_LOOKS_FUNNY_WHATS_THAT;
	
	/**
	 * ID: 1800226<br>
	 * Message: oA I[uɕׂ肷ĂB̔͂炭DDD<br>
	 * Message: &#22312;&#23631;&#38556;&#29699;&#29664;&#19978;&#36000;&#36617;&#33879;&#24375;&#21147;&#38651;&#27969;&#65281;&#36889;&#21453;&#25033;&#35442;&#19981;&#26371;&#26159;&#46;&#46;&#46;&#65281;<br>
	 * Message: A powerful subordinate is being held by the Barrier Orb! This reaction means...!
	 */
	public static final NpcStringId A_POWERFUL_SUBORDINATE_IS_BEING_HELD_BY_THE_BARRIER_ORB_THIS_REACTION_MEANS;
	
	/**
	 * ID: 1800227<br>
	 * Message: CI邼I<br>
	 * Message: &#23567;&#24515;&#46;&#46;&#46;&#65281;&#26377;&#20491;&#26481;&#35199;&#22312;&#38752;&#36817;&#46;&#46;&#46;&#65281;<br>
	 * Message: Be careful...! Something's coming...!
	 */
	public static final NpcStringId BE_CAREFUL_SOMETHINGS_COMING;
	
	/**
	 * ID: 1800228<br>
	 * Message: ܂͌n݂邩AɉȂ΂Ȃ܂B<br>
	 * Message: &#38656;&#35201;&#20808;&#21109;&#31435;&#34880;&#30431;&#25110;&#38584;&#23660;&#26044;&#26576;&#34880;&#30431;&#20043;&#19979;&#12290;<br>
	 * Message: You must first found a clan or belong to one.
	 */
	public static final NpcStringId YOU_MUST_FIRST_FOUND_A_CLAN_OR_BELONG_TO_ONE;
	
	/**
	 * ID: 1800229<br>
	 * Message: GLXɒ풆̃p[eB͂܂B$s1bȓɓȂ΁Asł̐Sւ̍U͎sƂȂ܂B<br>
	 * Message: &#30446;&#21069;&#23578;&#28961;&#25361;&#25136;&#20234;&#21345;&#22982;&#22763;&#30340;&#38538;&#20237;&#12290;&#22312;&#12300;&#36;&#115;&#49;&#12301;&#31186;&#20839;&#33509;&#19981;&#36914;&#20837;&#20839;&#37096;&#30340;&#35441;&#65292;&#23601;&#28961;&#27861;&#25915;&#25802;&#19981;&#28357;&#30340;&#24515;&#33247;&#37096;&#46;&#46;&#46;<br>
	 * Message: There is no party currently challenging Ekimus. \\n If no party enters within $s1 seconds, the attack on the Heart of Immortality will fail...
	 */
	public static final NpcStringId THERE_IS_NO_PARTY_CURRENTLY_CHALLENGING_EKIMUS_N_IF_NO_PARTY_ENTERS_WITHIN_S1_SECONDS_THE_ATTACK_ON_THE_HEART_OF_IMMORTALITY_WILL_FAIL;
	
	/**
	 * ID: 1800230<br>
	 * Message: ᇑ̂ƂȂGLX͂ɋ͂ȗ͂𓾂܂B<br>
	 * Message: &#33287;&#33131;&#30244;&#39636;&#36899;&#32080;&#30340;&#20234;&#21345;&#22982;&#22763;&#65292;&#24471;&#21040;&#20102;&#26356;&#24375;&#22823;&#30340;&#21147;&#37327;&#46;&#46;&#46;<br>
	 * Message: Ekimus has gained strength from a tumor...
	 */
	public static final NpcStringId EKIMUS_HAS_GAINED_STRENGTH_FROM_A_TUMOR;
	
	/**
	 * ID: 1800231<br>
	 * Message: ᇑ̂Ƃ̂Ȃ肪؂ꂽGLX͂܂B<br>
	 * Message: &#33287;&#33131;&#30244;&#39636;&#32080;&#26463;&#36899;&#32080;&#30340;&#20234;&#21345;&#22982;&#22763;&#22833;&#21435;&#20102;&#21147;&#37327;&#65281;<br>
	 * Message: Ekimus has been weakened by losing strength from a tumor!
	 */
	public static final NpcStringId EKIMUS_HAS_BEEN_WEAKENED_BY_LOSING_STRENGTH_FROM_A_TUMOR;
	
	/**
	 * ID: 1800233<br>
	 * Message: [IoĂÃlY~YIĂ߂̈sA̖ڂłƌĂI<br>
	 * Message: &#21917;&#65281;&#32102;&#25105;&#20986;&#20358;&#65292;&#20320;&#36889;&#20491;&#20687;&#33261;&#32769;&#40736;&#30340;&#20642;&#20249;&#65281;&#36889;&#20123;&#35442;&#27515;&#30340;&#33261;&#23567;&#23376;&#65292;&#25105;&#20498;&#26159;&#35201;&#30475;&#30475;&#20320;&#20497;&#33021;&#32781;&#20160;&#40636;&#33457;&#27171;&#65281;<br>
	 * Message: C'mon, c'mon! Show your face, you little rats! Let me see what the doomed weaklings are scheming!
	 */
	public static final NpcStringId CMON_CMON_SHOW_YOUR_FACE_YOU_LITTLE_RATS_LET_ME_SEE_WHAT_THE_DOOMED_WEAKLINGS_ARE_SCHEMING;
	
	/**
	 * ID: 1800234<br>
	 * Message: ȂȂ̂񂾂ȁAtttDDDƁAȂBMȂ߂ȁBAWFNeAJI<br>
	 * Message: &#36996;&#30495;&#19981;&#36084;&#46;&#46;&#46;&#21621;&#21621;&#21621;&#65292;&#22826;&#26377;&#24847;&#24605;&#20102;&#12290;&#20294;&#26159;&#38656;&#35201;&#38477;&#38477;&#28779;&#27683;&#65292;&#38463;&#29246;&#21513;&#24247;&#24503;&#65292;&#38283;&#36335;&#21543;&#12290;<br>
	 * Message: Impressive.... Hahaha it's so much fun, but I need to chill a little while. Argekunte, clear the way!
	 */
	public static final NpcStringId IMPRESSIVE_HAHAHA_ITS_SO_MUCH_FUN_BUT_I_NEED_TO_CHILL_A_LITTLE_WHILE_ARGEKUNTE_CLEAR_THE_WAY;
	
	/**
	 * ID: 1800235<br>
	 * Message: ͂͂͂͂Iᇑ̂ԂA͂Ă߂̑Kv͂ȂȁB<br>
	 * Message: &#21704;&#21704;&#21704;&#21704;&#65292;&#26082;&#28982;&#33131;&#30244;&#39636;&#37117;&#24050;&#32147;&#24489;&#27963;&#65292;&#37027;&#25105;&#30475;&#20063;&#27794;&#24517;&#35201;&#20877;&#38506;&#20320;&#20497;&#29609;&#20102;&#65281;<br>
	 * Message: Kyahaha! Since the tumor has been resurrected, I no longer need to waste my time on you!
	 */
	public static final NpcStringId KYAHAHA_SINCE_THE_TUMOR_HAS_BEEN_RESURRECTED_I_NO_LONGER_NEED_TO_WASTE_MY_TIME_ON_YOU;
	
	/**
	 * ID: 1800236<br>
	 * Message: I͂ꂮ炢ɂƂĂ邪AŏI肾ƎvȂIsł͕̎ʂiɕsłI<br>
	 * Message: &#21683;&#21571;&#46;&#46;&#46;&#29694;&#22312;&#25105;&#22993;&#19988;&#36864;&#19979;&#46;&#46;&#46;&#20294;&#21029;&#20197;&#28858;&#36889;&#23601;&#34920;&#31034;&#32080;&#26463;&#46;&#46;&#46;&#19981;&#28357;&#20043;&#31278;&#26159;&#27704;&#19981;&#28357;&#20129;&#30340;&#46;&#46;&#46;<br>
	 * Message: Keu... I will leave for now... But don't think this is over... The Seed of Infinity can never die...
	 */
	public static final NpcStringId KEU_I_WILL_LEAVE_FOR_NOW_BUT_DONT_THINK_THIS_IS_OVER_THE_SEED_OF_INFINITY_CAN_NEVER_DIE;
	
	/**
	 * ID: 1800237<br>
	 * Message: ͂͂͂͂I͊OłۂB̋ȂΎʂƂłȂBA`̖@AfXX K[fBAI<br>
	 * Message: &#21704;&#21704;&#21704;&#21704;&#65292;&#37027;&#20642;&#20249;&#21482;&#19981;&#36942;&#26159;&#20491;&#31354;&#27580;&#65281;&#27794;&#26377;&#25105;&#30340;&#20801;&#35377;&#26159;&#27515;&#19981;&#20102;&#30340;&#65281;&#20358;&#65292;&#30475;&#22909;&#20102;&#65281;&#32066;&#26997;&#31061;&#20659;&#39764;&#27861;&#65281;&#19981;&#28357;&#23432;&#35703;&#32773;&#65281;<br>
	 * Message: Kahahaha! That guy's nothing! He can't even kill without my permission! See here! Ultimate forgotten magic! Deathless Guardian!
	 */
	public static final NpcStringId KAHAHAHA_THAT_GUYS_NOTHING_HE_CANT_EVEN_KILL_WITHOUT_MY_PERMISSION_SEE_HERE_ULTIMATE_FORGOTTEN_MAGIC_DEATHLESS_GUARDIAN;
	
	/**
	 * ID: 1800238<br>
	 * Message: ĂO̓zɐ艺̓̋J͉iɖYȂBRwlXIĂ߂̑̍~܂uԂ̖ڂŌ͂ĂI<br>
	 * Message: &#28858;&#20102;&#36867;&#36991;&#27515;&#20129;&#65292;&#25105;&#23621;&#28982;&#36984;&#25799;&#20570;&#20320;&#30340;&#22900;&#38584;&#65292;&#25105;&#26371;&#27704;&#36960;&#35419;&#21650;&#36889;&#19968;&#22825;&#30340;&#12290;&#20811;&#28023;&#26757;&#32013;&#26031;&#65281;&#25105;&#19968;&#23450;&#35201;&#35242;&#30524;&#30446;&#30585;&#20320;&#30340;&#27515;&#20129;&#65281;<br>
	 * Message: I curse the day that I became your slave in order to escape death, Cohemenes! I swear that I shall see you die with my own eyes!
	 */
	public static final NpcStringId I_CURSE_THE_DAY_THAT_I_BECAME_YOUR_SLAVE_IN_ORDER_TO_ESCAPE_DEATH_COHEMENES_I_SWEAR_THAT_I_SHALL_SEE_YOU_DIE_WITH_MY_OWN_EYES;
	
	/**
	 * ID: 1800239<br>
	 * Message: ̂ɂI킭킭邺IAcAcI<br>
	 * Message: &#25105;&#30340;&#20167;&#20154;&#27491;&#22312;&#28693;&#27515;&#20043;&#38555;&#65292;&#20294;&#25105;&#21371;&#29105;&#34880;&#27832;&#39472;&#65281;&#36889;&#26159;&#22810;&#40636;&#24920;&#24525;&#30340;&#35419;&#21650;&#21834;&#65281;<br>
	 * Message: My enemy is dying, and my blood is boiling! What cruel curse is this!
	 */
	public static final NpcStringId MY_ENEMY_IS_DYING_AND_MY_BLOOD_IS_BOILING_WHAT_CRUEL_CURSE_IS_THIS;
	
	/**
	 * ID: 1800240<br>
	 * Message: ɂ̊<br>
	 * Message: &#33510;&#30171;&#26874;&#23460;<br>
	 * Message: Hall of Suffering
	 */
	public static final NpcStringId HALL_OF_SUFFERING;
	
	/**
	 * ID: 1800241<br>
	 * Message: NH̊<br>
	 * Message: &#20405;&#34645;&#26874;&#23460;<br>
	 * Message: Hall of Erosion
	 */
	public static final NpcStringId HALL_OF_EROSION;
	
	/**
	 * ID: 1800242<br>
	 * Message: sł̐S<br>
	 * Message: &#19981;&#28357;&#30340;&#24515;&#33247;&#37096;<br>
	 * Message: Heart of Immortality
	 */
	public static final NpcStringId HEART_OF_IMMORTALITY;
	
	/**
	 * ID: 1800243<br>
	 * Message: U<br>
	 * Message: &#25915;&#25802;<br>
	 * Message: Attack
	 */
	public static final NpcStringId ATTACK;
	
	/**
	 * ID: 1800244<br>
	 * Message: h<br>
	 * Message: &#38450;&#34907;<br>
	 * Message: Defend
	 */
	public static final NpcStringId DEFEND;
	
	/**
	 * ID: 1800245<br>
	 * Message: ߂łƂ܂I$s1 $s2ɐ܂I܂ȂCX^g ][ł܂B<br>
	 * Message: &#24685;&#21916;&#24744;&#65281;&#12300;&#36;&#115;&#49;&#36;&#115;&#50;&#12301;&#25104;&#21151;&#65281;&#31245;&#24460;&#21363;&#26178;&#22320;&#21312;&#23559;&#26371;&#28040;&#22833;&#12290;<br>
	 * Message: Congratulations! You have succeeded at $s1 $s2! The instance will shortly expire.
	 */
	public static final NpcStringId CONGRATULATIONS_YOU_HAVE_SUCCEEDED_AT_S1_S2_THE_INSTANCE_WILL_SHORTLY_EXPIRE;
	
	/**
	 * ID: 1800246<br>
	 * Message: $s1 $s2Ɏs܂DDD܂ȂCX^g ][ł܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#36;&#115;&#50;&#12301;&#22833;&#25943;&#46;&#46;&#46;&#31245;&#24460;&#21363;&#26178;&#22320;&#21312;&#23559;&#26371;&#28040;&#22833;&#12290;<br>
	 * Message: You have failed at $s1 $s2... The instance will shortly expire.
	 */
	public static final NpcStringId YOU_HAVE_FAILED_AT_S1_S2_THE_INSTANCE_WILL_SHORTLY_EXPIRE;
	
	/**
	 * ID: 1800247<br>
	 * Message: $s1̃p[eB͎ᇑ̂̂܂蔲āÂƂɈړ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#38538;&#20237;&#36879;&#36942;&#33131;&#30244;&#39636;&#35010;&#32299;&#24050;&#31227;&#21205;&#21040;&#20854;&#20182;&#22320;&#26041;&#65281;<br>
	 * Message: $s1's party has moved to a different location through the crack in the tumor!
	 */
	public static final NpcStringId S1S_PARTY_HAS_MOVED_TO_A_DIFFERENT_LOCATION_THROUGH_THE_CRACK_IN_THE_TUMOR;
	
	/**
	 * ID: 1800248<br>
	 * Message: $s1̃p[eB͎ᇑ̂̂܂蔲āAGLX̕ɓ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#38538;&#20237;&#36879;&#36942;&#33131;&#30244;&#39636;&#35010;&#32299;&#24050;&#36914;&#20837;&#20234;&#21345;&#22982;&#22763;&#30340;&#25151;&#38291;&#65281;<br>
	 * Message: $s1's party has entered the Chamber of Ekimus through the crack in the tumor!
	 */
	public static final NpcStringId S1S_PARTY_HAS_ENTERED_THE_CHAMBER_OF_EKIMUS_THROUGH_THE_CRACK_IN_THE_TUMOR;
	
	/**
	 * ID: 1800249<br>
	 * Message: GLXُsm܂B풆̃p[eB͋Ǖ܂B<br>
	 * Message: &#20234;&#21345;&#22982;&#22763;&#24863;&#25033;&#21040;&#20102;&#30064;&#24120;&#34892;&#28858;&#65292;&#23559;&#26371;&#24375;&#21046;&#39493;&#36880;&#25361;&#25136;&#20013;&#30340;&#38538;&#20237;&#65281;<br>
	 * Message: Ekimus has sensed abnormal activity. \\nThe advancing party is forcefully expelled!
	 */
	public static final NpcStringId EKIMUS_HAS_SENSED_ABNORMAL_ACTIVITY_NTHE_ADVANCING_PARTY_IS_FORCEFULLY_EXPELLED;
	
	/**
	 * ID: 1800250<br>
	 * Message: ACesĂ܂BsD̏ɂ̓GlM[ X^[Xg[5KvłB<br>
	 * Message: &#36947;&#20855;&#19981;&#36275;&#12290;&#22914;&#26524;&#24819;&#35201;&#21484;&#21914;&#39131;&#31354;&#33351;&#65292;&#38656;&#35201;&#29992;&#21040;&#33021;&#37327;&#26143;&#30707;&#53;&#20491;&#12290;<br>
	 * Message: There aren't enough items. In order to summon the airship, you need 5 Energy Star Stones.
	 */
	public static final NpcStringId THERE_ARENT_ENOUGH_ITEMS_IN_ORDER_TO_SUMMON_THE_AIRSHIP_YOU_NEED_5_ENERGY_STAR_STONES;
	
	/**
	 * ID: 1800251<br>
	 * Message: Ō܂ŐcĐ̎Hs񂪂߂ɁAHӒn̒̕ߐH҂ڊo߂܂DDD<br>
	 * Message: &#37027;&#20123;&#20687;&#39187;&#27515;&#39740;&#33324;&#30340;&#38728;&#39746;&#25504;&#39135;&#32773;&#65292;&#28858;&#20102;&#21534;&#39135;&#22909;&#19981;&#23481;&#26131;&#29983;&#23384;&#19979;&#20358;&#30340;&#19968;&#20123;&#20877;&#29983;&#31278;&#23376;&#32780;&#24050;&#32147;&#21914;&#37266;&#46;&#46;&#46;&#65281;<br>
	 * Message: The Soul Devourers who are greedy to eat the Seeds of Life that remain alive until the end have awakened...!
	 */
	public static final NpcStringId THE_SOUL_DEVOURERS_WHO_ARE_GREEDY_TO_EAT_THE_SEEDS_OF_LIFE_THAT_REMAIN_ALIVE_UNTIL_THE_END_HAVE_AWAKENED;
	
	/**
	 * ID: 1800252<br>
	 * Message: 1Cڂ̖E̖ڊo߂܂DDD<br>
	 * Message: &#31532;&#19968;&#38587;&#20901;&#30028;&#30340;&#39764;&#29356;&#24050;&#32147;&#29990;&#37266;&#46;&#46;&#46;&#65281;<br>
	 * Message: The first Feral Hound of the Netherworld has awakened!
	 */
	public static final NpcStringId THE_FIRST_FERAL_HOUND_OF_THE_NETHERWORLD_HAS_AWAKENED;
	
	/**
	 * ID: 1800253<br>
	 * Message: 2Cڂ̖E̖ڊo߂܂DDD<br>
	 * Message: &#31532;&#20108;&#38587;&#20901;&#30028;&#30340;&#39764;&#29356;&#24050;&#32147;&#29990;&#37266;&#46;&#46;&#46;&#65281;<br>
	 * Message: The second Feral Hound of the Netherworld has awakened!
	 */
	public static final NpcStringId THE_SECOND_FERAL_HOUND_OF_THE_NETHERWORLD_HAS_AWAKENED;
	
	/**
	 * ID: 1800254<br>
	 * Message: tĂĂʂI`̖@AuCh ^[炦I<br>
	 * Message: &#36861;&#19978;&#20358;&#20063;&#27794;&#29992;&#65281;&#32066;&#26997;&#31061;&#20659;&#39764;&#27861;&#65281;&#20992;&#20995;&#36864;&#36820;&#65281;<br>
	 * Message: Clinging on won't help you! Ultimate forgotten magic, Blade Turn!
	 */
	public static final NpcStringId CLINGING_ON_WONT_HELP_YOU_ULTIMATE_FORGOTTEN_MAGIC_BLADE_TURN;
	
	/**
	 * ID: 1800255<br>
	 * Message: ȂƂł炠ĂʂȂI`̖@AtH[X V[h炦I<br>
	 * Message: &#22312;&#36960;&#34389;&#32781;&#23567;&#33457;&#27171;&#20063;&#26159;&#27794;&#29992;&#30340;&#65281;&#32066;&#26997;&#31061;&#20659;&#39764;&#27861;&#65281;&#21147;&#37327;&#30462;&#65281;<br>
	 * Message: Even special sauce can't help you! Ultimate forgotten magic, Force Shield!
	 */
	public static final NpcStringId EVEN_SPECIAL_SAUCE_CANT_HELP_YOU_ULTIMATE_FORGOTTEN_MAGIC_FORCE_SHIELD;
	
	/**
	 * ID: 1800256<br>
	 * Message: ̒ǂ߁IɂȂĂĂƂŁAsł̗͂͋Ȃ΂肾I<br>
	 * Message: &#26377;&#22914;&#35442;&#27515;&#30340;&#33261;&#34802;&#19968;&#33324;&#65281;&#20320;&#20497;&#20877;&#24590;&#40636;&#34909;&#36942;&#20358;&#65292;&#20063;&#21482;&#26371;&#35731;&#19981;&#28357;&#30340;&#21147;&#37327;&#35722;&#24471;&#26356;&#21152;&#24375;&#22823;&#65281;<br>
	 * Message: You little doomed maggots! Even if you keep swarming, the power of Immortality will only grow stronger!
	 */
	public static final NpcStringId YOU_LITTLE_DOOMED_MAGGOTS_EVEN_IF_YOU_KEEP_SWARMING_THE_POWER_OF_IMMORTALITY_WILL_ONLY_GROW_STRONGER;
	
	/**
	 * ID: 1800257<br>
	 * Message: sD̏͂ł܂BM͍AsD̏ł悤ɂȂ܂B<br>
	 * Message: &#39131;&#31354;&#33351;&#21484;&#21914;&#35377;&#21487;&#35657;&#36664;&#20837;&#23436;&#30050;&#12290;&#23601;&#27492;&#24744;&#30340;&#34880;&#30431;&#21487;&#20197;&#21484;&#21914;&#39131;&#31354;&#33351;&#12290;<br>
	 * Message: The Airship Summon License has been awarded. Your clan can now summon an airship.
	 */
	public static final NpcStringId THE_AIRSHIP_SUMMON_LICENSE_HAS_BEEN_AWARDED_YOUR_CLAN_CAN_NOW_SUMMON_AN_AIRSHIP;
	
	/**
	 * ID: 1800258<br>
	 * Message: OVA󔠂܂B<br>
	 * Message: &#26684;&#21202;&#35199;&#20126;&#23542;&#31665;&#20986;&#29694;&#20102;&#65281;<br>
	 * Message: The Gracia treasure box has appeared!
	 */
	public static final NpcStringId THE_GRACIA_TREASURE_BOX_HAS_APPEARED;
	
	/**
	 * ID: 1800259<br>
	 * Message: OVA󔠂܂Ȃł܂B<br>
	 * Message: &#26684;&#21202;&#35199;&#20126;&#23542;&#31665;&#21363;&#23559;&#28040;&#22833;&#65281;<br>
	 * Message: The Gracia treasure box will soon disappear!
	 */
	public static final NpcStringId THE_GRACIA_TREASURE_BOX_WILL_SOON_DISAPPEAR;
	
	/**
	 * ID: 1800260<br>
	 * Message: ᇑ̂􂢂ɂ$s1̃_[W܂B<br>
	 * Message: &#21463;&#21040;&#33131;&#30244;&#39636;&#30340;&#35419;&#21650;&#65292;&#22240;&#27492;&#36973;&#21463;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#20663;&#23475;&#12290;<br>
	 * Message: You have been cursed by the tumor and have incurred $s1 damage.
	 */
	public static final NpcStringId YOU_HAVE_BEEN_CURSED_BY_THE_TUMOR_AND_HAVE_INCURRED_S1_DAMAGE;
	
	/**
	 * ID: 1800261<br>
	 * Message: Ă߂̒A󂯂ėI$s1Isł̉ɕĐȁI<br>
	 * Message: &#25105;&#25509;&#21463;&#20320;&#30340;&#25361;&#25136;&#65292;&#12300;&#36;&#115;&#49;&#12301;&#65281;&#20320;&#23601;&#27515;&#22312;&#19981;&#28357;&#30340;&#25079;&#25265;&#21543;&#65281;<br>
	 * Message: I shall accept your challenge, $s1! Come and die in the arms of immortality!
	 */
	public static final NpcStringId I_SHALL_ACCEPT_YOUR_CHALLENGE_S1_COME_AND_DIE_IN_THE_ARMS_OF_IMMORTALITY;
	
	/**
	 * ID: 1800262<br>
	 * Message: ܂Ȃ$s1 $s2ɎQ܂BS̏肢܂B<br>
	 * Message: &#31245;&#24460;&#23559;&#26371;&#21443;&#33287;&#12300;&#36;&#115;&#49;&#36;&#115;&#50;&#12301;&#65292;&#35531;&#24744;&#20570;&#22909;&#33836;&#20840;&#30340;&#28310;&#20633;&#12290;<br>
	 * Message: You will participate in $s1 $s2 shortly. Be prepared for anything.
	 */
	public static final NpcStringId YOU_WILL_PARTICIPATE_IN_S1_S2_SHORTLY_BE_PREPARED_FOR_ANYTHING;
	
	/**
	 * ID: 1800263<br>
	 * Message: GLX̃AfbhĂ鑫܂B$s1 $s2Bn܂܂B<br>
	 * Message: &#20659;&#20358;&#19968;&#38499;&#20234;&#21345;&#22982;&#22763;&#30340;&#19981;&#27515;&#29983;&#29289;&#20497;&#34909;&#36942;&#20358;&#30340;&#32882;&#38899;&#12290;&#12300;&#36;&#115;&#49;&#36;&#115;&#50;&#12301;&#65292;&#29694;&#22312;&#38283;&#22987;&#20102;&#65281;<br>
	 * Message: You can hear the undead of Ekimus rushing toward you. $s1 $s2, it has now begun!
	 */
	public static final NpcStringId YOU_CAN_HEAR_THE_UNDEAD_OF_EKIMUS_RUSHING_TOWARD_YOU_S1_S2_IT_HAS_NOW_BEGUN;
	
	/**
	 * ID: 1800264<br>
	 * Message: ᇑ̂Ɏ̃GlM[邱Ƃ܂B<br>
	 * Message: &#24863;&#35258;&#21040;&#33131;&#30244;&#39636;&#20839;&#20805;&#26021;&#33879;&#27515;&#20129;&#30340;&#33021;&#37327;&#12290;<br>
	 * Message: You can feel the surging energy of death from the tumor.
	 */
	public static final NpcStringId YOU_CAN_FEEL_THE_SURGING_ENERGY_OF_DEATH_FROM_THE_TUMOR;
	
	/**
	 * ID: 1800265<br>
	 * Message: ᇑ̂̂܂ɕsgȋCӂĂ܂B<br>
	 * Message: &#22312;&#33131;&#30244;&#39636;&#21608;&#22285;&#20805;&#28415;&#33879;&#19981;&#21513;&#30340;&#27683;&#24687;&#12290;<br>
	 * Message: The area near the tumor is full of ominous energy.
	 */
	public static final NpcStringId THE_AREA_NEAR_THE_TUMOR_IS_FULL_OF_OMINOUS_ENERGY;
	
	/**
	 * ID: 1800266<br>
	 * Message: X܂Ƃ́Aǂ܂ł߁I<br>
	 * Message: &#23621;&#28982;&#24819;&#35201;&#25286;&#25955;&#25105;&#20497;&#65292;&#30495;&#26159;&#24858;&#34850;&#21040;&#26997;&#40670;&#65281;<br>
	 * Message: You tried to drop us. How stupid!
	 */
	public static final NpcStringId YOU_TRIED_TO_DROP_US_HOW_STUPID;
	
	/**
	 * ID: 1800267<br>
	 * Message: X͌𕪂Z킾BuĐɐ킯ɂ͂ȂB<br>
	 * Message: &#25105;&#20497;&#26159;&#27969;&#33879;&#30456;&#21516;&#34880;&#33032;&#30340;&#20804;&#24351;&#12290;&#26377;&#24351;&#24351;&#22312;&#65292;&#25105;&#24590;&#33021;&#23601;&#36889;&#40636;&#36629;&#26131;&#22320;&#20498;&#19979;&#12290;<br>
	 * Message: We are blood brethren. I can't fall so easily here and leave my brother behind.
	 */
	public static final NpcStringId WE_ARE_BLOOD_BRETHREN_I_CANT_FALL_SO_EASILY_HERE_AND_LEAVE_MY_BROTHER_BEHIND;
	
	/**
	 * ID: 1800268<br>
	 * Message: q̍ZɓĂB̌ZuĐɐ킯ɂ͂ȂB<br>
	 * Message: &#24478;&#23567;&#25105;&#21733;&#19968;&#30452;&#37117;&#26159;&#25105;&#23815;&#25308;&#30340;&#23565;&#35937;&#12290;&#26377;&#20491;&#36889;&#27171;&#30340;&#20804;&#38263;&#65292;&#25105;&#21487;&#33021;&#23601;&#36889;&#40636;&#36629;&#26131;&#22320;&#34987;&#25802;&#20498;&#21966;&#65311;<br>
	 * Message: You were always what I aspired to be. Do you think I would fall so easily here when I have a brother like that?
	 */
	public static final NpcStringId YOU_WERE_ALWAYS_WHAT_I_ASPIRED_TO_BE_DO_YOU_THINK_I_WOULD_FALL_SO_EASILY_HERE_WHEN_I_HAVE_A_BROTHER_LIKE_THAT;
	
	/**
	 * ID: 1800269<br>
	 * Message: ᇑ̂Ƃ̂Ȃ肪؂ꂽGLX̖ɑ΂铝͂܂B<br>
	 * Message: &#33287;&#33131;&#30244;&#39636;&#32080;&#26463;&#25152;&#26377;&#36899;&#32080;&#30340;&#20234;&#21345;&#22982;&#22763;&#65292;&#21930;&#22833;&#20102;&#25511;&#21046;&#39764;&#29356;&#30340;&#21147;&#37327;&#65281;<br>
	 * Message: With all connections to the tumor severed, Ekimus has lost its power to control the Feral Hound!
	 */
	public static final NpcStringId WITH_ALL_CONNECTIONS_TO_THE_TUMOR_SEVERED_EKIMUS_HAS_LOST_ITS_POWER_TO_CONTROL_THE_FERAL_HOUND;
	
	/**
	 * ID: 1800270<br>
	 * Message: ᇑ̂ƍĂтȂė͂߂GLXɑ΂铝͂߂܂B<br>
	 * Message: &#33287;&#33131;&#30244;&#39636;&#20877;&#24230;&#36899;&#32080;&#24460;&#24674;&#24489;&#21147;&#37327;&#30340;&#20234;&#21345;&#22982;&#22763;&#65292;&#20063;&#25214;&#22238;&#20102;&#25511;&#21046;&#39764;&#29356;&#30340;&#21147;&#37327;&#46;&#46;&#46;<br>
	 * Message: With the connection to the tumor restored, Ekimus has regained control over the Feral Hound...
	 */
	public static final NpcStringId WITH_THE_CONNECTION_TO_THE_TUMOR_RESTORED_EKIMUS_HAS_REGAINED_CONTROL_OVER_THE_FERAL_HOUND;
	
	/**
	 * ID: 1800271<br>
	 * Message: I<br>
	 * Message: &#21978;&#21978;&#21978;&#21978;&#21978;&#65281;<br>
	 * Message: Woooong!
	 */
	public static final NpcStringId WOOOONG;
	
	/**
	 * ID: 1800272<br>
	 * Message:   <br>
	 * Message: &#21978;&#21978;&#32;&#21978;&#21978;&#21978;&#32;&#21978;&#21978;&#21978;&#46;&#46;&#46;<br>
	 * Message: Woong... Woong... Woo...
	 */
	public static final NpcStringId WOONG_WOONG_WOO;
	
	/**
	 * ID: 1800273<br>
	 * Message: GRPI퓬̐ɂI͂I<br>
	 * Message: &#26377;&#25973;&#32676;&#30340;&#25915;&#25802;&#65292;&#20840;&#37096;&#20986;&#20358;&#23565;&#25239;&#65281;&#65281;&#65281;&#65281;&#46;&#46;&#46;&#21683;&#21571;&#126;&#65281;<br>
	 * Message: The enemies have attacked. Everyone come out and fight!!!! ... Urgh~!
	 */
	public static final NpcStringId THE_ENEMIES_HAVE_ATTACKED_EVERYONE_COME_OUT_AND_FIGHT_URGH;
	
	/**
	 * ID: 1800274<br>
	 * Message: $s1̎ᇑ̂j󂳂܂IڋȃRwlXo߂ɂׂ͂Ă̎ᇑ̂j󂵂Ȃ΂Ȃ܂B<br>
	 * Message: &#22312;&#12300;&#36;&#115;&#49;&#12301;&#20839;&#30340;&#33131;&#30244;&#39636;&#24050;&#36973;&#30772;&#22750;&#65281;&#28858;&#20102;&#24341;&#35480;&#21329;&#37145;&#30340;&#20811;&#28023;&#26757;&#32013;&#26031;&#20986;&#20358;&#65292;&#24517;&#38920;&#35201;&#30772;&#22750;&#25152;&#26377;&#30340;&#33131;&#30244;&#39636;&#65281;<br>
	 * Message: The tumor inside $s1 has been destroyed! \\nIn order to draw out the cowardly Cohemenes, you must destroy all the tumors!
	 */
	public static final NpcStringId THE_TUMOR_INSIDE_S1_HAS_BEEN_DESTROYED_NIN_ORDER_TO_DRAW_OUT_THE_COWARDLY_COHEMENES_YOU_MUST_DESTROY_ALL_THE_TUMORS;
	
	/**
	 * ID: 1800275<br>
	 * Message: $s1̎ᇑ̂Sɕ܂B͂߂RwlX͎̉[ɓĂ܂B<br>
	 * Message: &#22312;&#12300;&#36;&#115;&#49;&#12301;&#20839;&#30340;&#33131;&#30244;&#39636;&#24050;&#23436;&#20840;&#24489;&#27963;&#12290;&#24674;&#24489;&#21147;&#37327;&#30340;&#20811;&#28023;&#26757;&#32013;&#26031;&#23559;&#26371;&#36867;&#38626;&#21040;&#31278;&#23376;&#20839;&#26356;&#28145;&#30340;&#22320;&#26041;&#46;&#46;&#46;<br>
	 * Message: The tumor inside $s1 has completely revived. \\nThe restrengthened Cohemenes has fled deeper inside the seed...
	 */
	public static final NpcStringId THE_TUMOR_INSIDE_S1_HAS_COMPLETELY_REVIVED_NTHE_RESTRENGTHENED_COHEMENES_HAS_FLED_DEEPER_INSIDE_THE_SEED;
	
	/**
	 * ID: 1800276<br>
	 * Message: sDłɊlĂ܂B<br>
	 * Message: &#24050;&#26377;&#38936;&#21462;&#39131;&#31354;&#33351;&#21484;&#21914;&#35377;&#21487;&#35657;&#12290;<br>
	 * Message: The awarded Airship Summon License has been received.
	 */
	public static final NpcStringId THE_AWARDED_AIRSHIP_SUMMON_LICENSE_HAS_BEEN_RECEIVED;
	
	/**
	 * ID: 1800277<br>
	 * Message: sD܂B̓R甭Ă炦܂B<br>
	 * Message: &#27794;&#26377;&#39131;&#31354;&#33351;&#21484;&#21914;&#35377;&#21487;&#35657;&#12290;&#39131;&#31354;&#33351;&#21484;&#21914;&#35377;&#21487;&#35657;&#21487;&#21521;&#24037;&#31243;&#24107;&#38647;&#22372;&#30003;&#35531;&#30332;&#34892;&#12290;<br>
	 * Message: You do not currently have an Airship Summon License. You can earn your Airship Summon License through Engineer Lekon.
	 */
	public static final NpcStringId YOU_DO_NOT_CURRENTLY_HAVE_AN_AIRSHIP_SUMMON_LICENSE_YOU_CAN_EARN_YOUR_AIRSHIP_SUMMON_LICENSE_THROUGH_ENGINEER_LEKON;
	
	/**
	 * ID: 1800278<br>
	 * Message: sD͂łɓ͂Ă܂B<br>
	 * Message: &#24050;&#26377;&#36664;&#20837;&#39131;&#31354;&#33351;&#21484;&#21914;&#35377;&#21487;&#35657;&#12290;<br>
	 * Message: The Airship Summon License has already been awarded.
	 */
	public static final NpcStringId THE_AIRSHIP_SUMMON_LICENSE_HAS_ALREADY_BEEN_AWARDED;
	
	/**
	 * ID: 1800279<br>
	 * Message: łACe`<br>
	 * Message: &#22914;&#26524;&#26377;&#36947;&#20855;&#30340;&#35441;&#65292;&#38568;&#20415;&#32102;&#25105;&#19968;&#20491;&#21543;&#12290;<br>
	 * Message: If you have items, please give them to me.
	 */
	public static final NpcStringId IF_YOU_HAVE_ITEMS_PLEASE_GIVE_THEM_TO_ME;
	
	/**
	 * ID: 1800280<br>
	 * Message: Ă񂾂I<br>
	 * Message: &#32922;&#23376;&#31354;&#31354;&#30340;&#12290;<br>
	 * Message: My stomach is empty.
	 */
	public static final NpcStringId MY_STOMACH_IS_EMPTY;
	
	/**
	 * ID: 1800281<br>
	 * Message: IVH킹I<br>
	 * Message: &#22909;&#39187;&#65292;&#22909;&#39187;&#65281;<br>
	 * Message: I'm hungry, I'm hungry!
	 */
	public static final NpcStringId IM_HUNGRY_IM_HUNGRY;
	
	/**
	 * ID: 1800282<br>
	 * Message: ȂȂB<br>
	 * Message: &#22909;&#20687;&#32570;&#20102;&#40670;&#20160;&#40636;&#20284;&#30340;&#46;&#46;<br>
	 * Message: I'm still not full...
	 */
	public static final NpcStringId IM_STILL_NOT_FULL;
	
	/**
	 * ID: 1800283<br>
	 * Message: ܂Ă邼I<br>
	 * Message: &#25105;&#36996;&#39187;&#21602;&#126;<br>
	 * Message: I'm still hungry~
	 */
	public static final NpcStringId IM_STILL_HUNGRY;
	
	/**
	 * ID: 1800284<br>
	 * Message: Ƃ͕c񂾂ǂȂDDD<br>
	 * Message: &#36889;&#25165;&#20687;&#26159;&#21507;&#20102;&#40670;&#26481;&#35199;&#46;&#46;&#46;<br>
	 * Message: I feel a little woozy...
	 */
	public static final NpcStringId I_FEEL_A_LITTLE_WOOZY;
	
	/**
	 * ID: 1800285<br>
	 * Message: ĤI<br>
	 * Message: &#32102;&#25105;&#40670;&#26481;&#35199;&#21507;&#21543;&#12290;<br>
	 * Message: Give me something to eat.
	 */
	public static final NpcStringId GIVE_ME_SOMETHING_TO_EAT;
	
	/**
	 * ID: 1800286<br>
	 * Message: ĂƁA{iIɐHƂ邩B<br>
	 * Message: &#25105;&#21487;&#35201;&#22823;&#21475;&#22823;&#21475;&#21507;&#20102;&#126;<br>
	 * Message: Now it's time to eat~
	 */
	public static final NpcStringId NOW_ITS_TIME_TO_EAT;
	
	/**
	 * ID: 1800287<br>
	 * Message: fU[gYȂȁB<br>
	 * Message: &#29980;&#40670;&#20063;&#25343;&#36942;&#20358;&#12290;<br>
	 * Message: I also need a dessert.
	 */
	public static final NpcStringId I_ALSO_NEED_A_DESSERT;
	
	/**
	 * ID: 1800289<br>
	 * Message: ȂςB<br>
	 * Message: &#25105;&#24456;&#39165;&#65292;&#19981;&#21507;&#20102;&#12290;<br>
	 * Message: I'm full now, I don't want to eat anymore.
	 */
	public static final NpcStringId IM_FULL_NOW_I_DONT_WANT_TO_EAT_ANYMORE;
	
	/**
	 * ID: 1800290<br>
	 * Message: H˂A͂o˂I<br>
	 * Message: &#20063;&#27794;&#21507;&#21040;&#20160;&#40636;&#65292;&#21769;&#65292;&#30495;&#27794;&#21147;&#27683;&#126;<br>
	 * Message: I haven't eaten anything, I'm so weak~
	 */
	public static final NpcStringId I_HAVENT_EATEN_ANYTHING_IM_SO_WEAK;
	
	/**
	 * ID: 1800291<br>
	 * Message: ނނ<br>
	 * Message: &#22909;&#21507;&#22909;&#21507;&#12290;<br>
	 * Message: Yum-yum, yum-yum
	 */
	public static final NpcStringId YUM_YUM_YUM_YUM;
	
	/**
	 * ID: 1800292<br>
	 * Message: V[h̐Ȃ͂ɐGꂽᇑ̂̊O炪$s1̃_[W܂B<br>
	 * Message: &#33131;&#30244;&#39636;&#19968;&#30896;&#21040;&#30462;&#29260;&#19978;&#31070;&#32854;&#30340;&#21360;&#31456;&#20043;&#24460;&#65292;&#22806;&#30382;&#38283;&#22987;&#28342;&#21270;&#65292;&#20006;&#36973;&#21463;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#20663;&#23475;&#65281;<br>
	 * Message: You've sustained $s1 damage as Tumor's shell started melting after touching the sacred seal on the shield!
	 */
	public static final NpcStringId YOUVE_SUSTAINED_S1_DAMAGE_AS_TUMORS_SHELL_STARTED_MELTING_AFTER_TOUCHING_THE_SACRED_SEAL_ON_THE_SHIELD;
	
	/**
	 * ID: 1800293<br>
	 * Message: V[h̐Ȃ͂ɐGꂽ̊ǂ̊O炪$s1̃_[W܂B<br>
	 * Message: &#38728;&#39746;&#31649;&#19968;&#30896;&#21040;&#30462;&#29260;&#19978;&#31070;&#32854;&#30340;&#21360;&#31456;&#20043;&#24460;&#65292;&#22806;&#30382;&#38283;&#22987;&#28342;&#21270;&#65292;&#20006;&#36973;&#21463;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#20663;&#23475;&#65281;<br>
	 * Message: You've sustained $s1 damage as Soul Coffin's shell started melting after touching the sacred seal on the shield!
	 */
	public static final NpcStringId YOUVE_SUSTAINED_S1_DAMAGE_AS_SOUL_COFFINS_SHELL_STARTED_MELTING_AFTER_TOUCHING_THE_SACRED_SEAL_ON_THE_SHIELD;
	
	/**
	 * ID: 1800295<br>
	 * Message: IxXN󂵂B͂Ĝ΂̂ĂȂI<br>
	 * Message: &#26041;&#23574;&#22612;&#24050;&#20498;&#22604;&#65292;&#19981;&#35201;&#20877;&#35731;&#25973;&#32676;&#22210;&#24373;&#20102;&#65281;&#65281;&#65281;&#65281;<br>
	 * Message: Obelisk has collapsed. Don't let the enemies jump around wildly anymore!!!!
	 */
	public static final NpcStringId OBELISK_HAS_COLLAPSED_DONT_LET_THE_ENEMIES_JUMP_AROUND_WILDLY_ANYMORE;
	
	/**
	 * ID: 1800296<br>
	 * Message: GvǂUߗƂƂĂB͂sĖhI<br>
	 * Message: &#25973;&#32676;&#27491;&#22312;&#35430;&#22294;&#25915;&#30772;&#35201;&#22622;&#65292;&#30433;&#20840;&#21147;&#20358;&#25803;&#19979;&#65281;&#65281;&#65281;&#65281;<br>
	 * Message: Enemies are trying to destroy the fortress. Everyone defend the fortress!!!!
	 */
	public static final NpcStringId ENEMIES_ARE_TRYING_TO_DESTROY_THE_FORTRESS_EVERYONE_DEFEND_THE_FORTRESS;
	
	/**
	 * ID: 1800297<br>
	 * Message: ołAmIjł̎B<br>
	 * Message: &#20986;&#20358;&#21543;&#65292;&#25136;&#22763;&#20497;&#65292;&#23432;&#20303;&#30772;&#28357;&#20043;&#31278;&#12290;<br>
	 * Message: Come out, warriors. Protect Seed of Destruction.
	 */
	public static final NpcStringId COME_OUT_WARRIORS_PROTECT_SEED_OF_DESTRUCTION;
	
	/**
	 * ID: 1800298<br>
	 * Message: Đ̎킪GLX̃AfbhUĂ܂BĐ̎킪łj󂳂ꂽANH̖̊h䂪s܂B<br>
	 * Message: &#20877;&#29983;&#31278;&#23376;&#27491;&#22312;&#36973;&#21463;&#20234;&#21345;&#22982;&#22763;&#30340;&#19981;&#27515;&#29983;&#29289;&#30340;&#25915;&#25802;&#12290;&#21482;&#35201;&#26377;&#20219;&#20309;&#19968;&#20491;&#20877;&#29983;&#31278;&#23376;&#34987;&#30772;&#22750;&#65292;&#37027;&#40636;&#20405;&#34645;&#26874;&#23460;&#30340;&#38450;&#34907;&#23601;&#31639;&#26159;&#22833;&#25943;&#46;&#46;&#46;<br>
	 * Message: The undead of Ekimus is attacking Seed of Life. Defending Hall of Erosion will fail even if one Seed of Life is destroyed...
	 */
	public static final NpcStringId THE_UNDEAD_OF_EKIMUS_IS_ATTACKING_SEED_OF_LIFE_DEFENDING_HALL_OF_EROSION_WILL_FAIL_EVEN_IF_ONE_SEED_OF_LIFE_IS_DESTROYED;
	
	/**
	 * ID: 1800299<br>
	 * Message: $s1̎ᇑ̂j󂳂܂InɒǂꂽRwlXׂ̒nɌ܂B<br>
	 * Message: &#22312;&#12300;&#36;&#115;&#49;&#12301;&#20839;&#30340;&#33131;&#30244;&#39636;&#24050;&#20840;&#36973;&#30772;&#22750;&#65281;&#38519;&#20837;&#22256;&#22659;&#30340;&#20811;&#28023;&#26757;&#32013;&#26031;&#23559;&#26371;&#22312;&#38468;&#36817;&#22320;&#21312;&#29694;&#36523;&#65281;<br>
	 * Message: All the tumors inside $s1 have been destroyed! Driven into a corner, Cohemenes appears close by!
	 */
	public static final NpcStringId ALL_THE_TUMORS_INSIDE_S1_HAVE_BEEN_DESTROYED_DRIVEN_INTO_A_CORNER_COHEMENES_APPEARS_CLOSE_BY;
	
	/**
	 * ID: 1800300<br>
	 * Message: $s1̎ᇑ̂j󂳂܂Iׂ̍Đ̎UĂAfbh͂ēĂ܂B<br>
	 * Message: &#22312;&#12300;&#36;&#115;&#49;&#12301;&#20839;&#30340;&#33131;&#30244;&#39636;&#24050;&#36973;&#30772;&#22750;&#65281;&#22312;&#38468;&#36817;&#25915;&#25802;&#20877;&#29983;&#31278;&#23376;&#30340;&#19981;&#27515;&#29983;&#29289;&#20497;&#23559;&#26371;&#21930;&#22833;&#21147;&#37327;&#24460;&#36867;&#38626;&#65281;<br>
	 * Message: The tumor inside $s1 has been destroyed! \\nThe nearby Undead that were attacking Seed of Life start losing their energy and run away!
	 */
	public static final NpcStringId THE_TUMOR_INSIDE_S1_HAS_BEEN_DESTROYED_NTHE_NEARBY_UNDEAD_THAT_WERE_ATTACKING_SEED_OF_LIFE_START_LOSING_THEIR_ENERGY_AND_RUN_AWAY;
	
	/**
	 * ID: 1800301<br>
	 * Message: $s1̎ᇑ̂Sɕ܂B͂߂Afbhׂ̍Đ̎ɉ񂹂܂B<br>
	 * Message: &#22312;&#12300;&#36;&#115;&#49;&#12301;&#20839;&#30340;&#33131;&#30244;&#39636;&#24050;&#23436;&#20840;&#24489;&#27963;&#12290;&#24674;&#24489;&#21147;&#37327;&#30340;&#19981;&#27515;&#29983;&#29289;&#20497;&#23559;&#26371;&#25778;&#21521;&#38468;&#36817;&#30340;&#20877;&#29983;&#31278;&#23376;&#46;&#46;&#46;<br>
	 * Message: The tumor inside $s1 has completely revived. \\nRecovered nearby Undead are swarming toward Seed of Life...
	 */
	public static final NpcStringId THE_TUMOR_INSIDE_S1_HAS_COMPLETELY_REVIVED_NRECOVERED_NEARBY_UNDEAD_ARE_SWARMING_TOWARD_SEED_OF_LIFE;
	
	/**
	 * ID: 1800302<br>
	 * Message: GLXɗ͂Ă$s1̎ᇑ̂j󂳂܂I<br>
	 * Message: &#22312;&#12300;&#36;&#115;&#49;&#12301;&#20839;&#21521;&#20234;&#21345;&#22982;&#22763;&#25552;&#20379;&#21147;&#37327;&#30340;&#33131;&#30244;&#39636;&#24050;&#36973;&#30772;&#22750;&#65281;<br>
	 * Message: The tumor inside $s1 that has provided energy \\n to Ekimus is destroyed!
	 */
	public static final NpcStringId THE_TUMOR_INSIDE_S1_THAT_HAS_PROVIDED_ENERGY_N_TO_EKIMUS_IS_DESTROYED;
	
	/**
	 * ID: 1800303<br>
	 * Message: $s1̎ᇑ̂SɕāAGLXɗ͂n߂܂B<br>
	 * Message: &#22312;&#12300;&#36;&#115;&#49;&#12301;&#20839;&#30340;&#33131;&#30244;&#39636;&#24050;&#23436;&#20840;&#24489;&#27963;&#65292;&#23559;&#26371;&#20877;&#24230;&#21521;&#20234;&#21345;&#22982;&#22763;&#25552;&#20379;&#21147;&#37327;&#46;&#46;&#46;<br>
	 * Message: The tumor inside $s1 has been completely resurrected \\n and started to energize Ekimus again...
	 */
	public static final NpcStringId THE_TUMOR_INSIDE_S1_HAS_BEEN_COMPLETELY_RESURRECTED_N_AND_STARTED_TO_ENERGIZE_EKIMUS_AGAIN;
	
	/**
	 * ID: 1800304<br>
	 * Message: $s1̎ᇑ̂j󂳂܂IGLXaт񂹂Xs[hxȂ܂B<br>
	 * Message: &#22312;&#12300;&#36;&#115;&#49;&#12301;&#20839;&#30340;&#33131;&#30244;&#39636;&#24050;&#36973;&#30772;&#22750;&#65281;&#20234;&#21345;&#22982;&#22763;&#35201;&#27714;&#39135;&#29289;&#30340;&#36895;&#24230;&#23559;&#26371;&#28187;&#24930;&#65281;<br>
	 * Message: The tumor inside $s1 has been destroyed! \\nThe speed that Ekimus calls out his prey has slowed down!
	 */
	public static final NpcStringId THE_TUMOR_INSIDE_S1_HAS_BEEN_DESTROYED_NTHE_SPEED_THAT_EKIMUS_CALLS_OUT_HIS_PREY_HAS_SLOWED_DOWN;
	
	/**
	 * ID: 1800305<br>
	 * Message: $s1̎ᇑ̂Sɕ܂B͂߂GLXɋ}ŉaT܂B<br>
	 * Message: &#22312;&#12300;&#36;&#115;&#49;&#12301;&#20839;&#30340;&#33131;&#30244;&#39636;&#24050;&#23436;&#20840;&#24489;&#27963;&#12290;&#38283;&#22987;&#24674;&#24489;&#21147;&#37327;&#30340;&#20234;&#21345;&#22982;&#22763;&#26356;&#32202;&#24613;&#30340;&#22312;&#23563;&#27714;&#39135;&#29289;&#46;&#46;&#46;<br>
	 * Message: The tumor inside $s1 has completely revived. \\nEkimus started to regain his energy and is desperately looking for his prey...
	 */
	public static final NpcStringId THE_TUMOR_INSIDE_S1_HAS_COMPLETELY_REVIVED_NEKIMUS_STARTED_TO_REGAIN_HIS_ENERGY_AND_IS_DESPERATELY_LOOKING_FOR_HIS_PREY;
	
	/**
	 * ID: 1800306<br>
	 * Message: AƍI<br>
	 * Message: &#20877;&#20358;&#65292;&#20877;&#32102;&#25105;&#26356;&#22810;&#30340;&#38728;&#39746;&#46;&#46;&#46;&#65281;<br>
	 * Message: Bring more, more souls...!
	 */
	public static final NpcStringId BRING_MORE_MORE_SOULS;
	
	/**
	 * ID: 1800307<br>
	 * Message: ΂₭ᇑ̂UȂ΁ANH̊̍UɎs܂B<br>
	 * Message: &#22914;&#26524;&#28961;&#27861;&#36805;&#36895;&#25915;&#25802;&#33131;&#30244;&#39636;&#65292;&#37027;&#40636;&#20405;&#34645;&#26874;&#23460;&#30340;&#25915;&#25802;&#31639;&#26159;&#22833;&#25943;&#65281;<br>
	 * Message: The Hall of Erosion attack will fail unless you make a quick attack against the tumor!
	 */
	public static final NpcStringId THE_HALL_OF_EROSION_ATTACK_WILL_FAIL_UNLESS_YOU_MAKE_A_QUICK_ATTACK_AGAINST_THE_TUMOR;
	
	/**
	 * ID: 1800308<br>
	 * Message: ᇑ̂Ȃ̂ŁARwlX͎̉[ɓĂ܂B<br>
	 * Message: &#30070;&#33131;&#30244;&#39636;&#19981;&#20877;&#21463;&#21040;&#23041;&#33029;&#26178;&#65292;&#20811;&#28023;&#26757;&#32013;&#26031;&#23601;&#24050;&#36867;&#38626;&#21040;&#31278;&#23376;&#20839;&#26356;&#28145;&#30340;&#22320;&#26041;&#46;&#46;&#46;<br>
	 * Message: As the tumor was not threatened, Cohemenes completely ran away to deep inside the Seed...
	 */
	public static final NpcStringId AS_THE_TUMOR_WAS_NOT_THREATENED_COHEMENES_COMPLETELY_RAN_AWAY_TO_DEEP_INSIDE_THE_SEED;
	
	/**
	 * ID: 1800309<br>
	 * Message: ڕWWQꂽA󂯂肷B<br>
	 * Message: &#31435;&#19979;&#30340;&#30446;&#27161;&#23559;&#21463;&#21040;&#38459;&#31001;&#65292;&#25110;&#21463;&#21040;&#29694;&#23526;&#19978;&#30340;&#38480;&#21046;&#12290;<br>
	 * Message: Your goal will be obstructed or be under a restraint.
	 */
	public static final NpcStringId YOUR_GOAL_WILL_BE_OBSTRUCTED_OR_BE_UNDER_A_RESTRAINT;
	
	/**
	 * ID: 1800310<br>
	 * Message: ڕWɌĐiމߒŗ\zO̖肪邩ȂB<br>
	 * Message: &#26397;&#30446;&#27161;&#36993;&#36914;&#30340;&#36942;&#31243;&#30070;&#20013;&#65292;&#25110;&#35377;&#26371;&#30332;&#29983;&#24847;&#24819;&#19981;&#21040;&#30340;&#21839;&#38988;&#12290;<br>
	 * Message: You may face an unforeseen problem on your course toward the goal.
	 */
	public static final NpcStringId YOU_MAY_FACE_AN_UNFORESEEN_PROBLEM_ON_YOUR_COURSE_TOWARD_THE_GOAL;
	
	/**
	 * ID: 1800311<br>
	 * Message: 󋵂sɂȂāAsŏőɎ邱ƂɂȂB<br>
	 * Message: &#20107;&#24773;&#36914;&#23637;&#19981;&#38918;&#21033;&#65292;&#26371;&#36896;&#25104;&#29033;&#36481;&#21644;&#19981;&#23433;&#12290;<br>
	 * Message: You may feel nervous and anxious because of unfavorable situations.
	 */
	public static final NpcStringId YOU_MAY_FEEL_NERVOUS_AND_ANXIOUS_BECAUSE_OF_UNFAVORABLE_SITUATIONS;
	
	/**
	 * ID: 1800312<br>
	 * Message: ꂪ낤Ȃ΁Af݂͂ėɂȂʂƂBCB<br>
	 * Message: &#36523;&#38519;&#22256;&#22659;&#65292;&#22240;&#32780;&#21028;&#26039;&#33021;&#21147;&#35722;&#24471;&#27169;&#31946;&#65292;&#20570;&#20986;&#19981;&#21512;&#24120;&#29702;&#30340;&#20107;&#65292;&#38920;&#35641;&#24910;&#12290;<br>
	 * Message: Be warned when the situation is difficult because you may lose your judgment and make an irrational mistake.
	 */
	public static final NpcStringId BE_WARNED_WHEN_THE_SITUATION_IS_DIFFICULT_BECAUSE_YOU_MAY_LOSE_YOUR_JUDGMENT_AND_MAKE_AN_IRRATIONAL_MISTAKE;
	
	/**
	 * ID: 1800313<br>
	 * Message: MłlɉāA`XށB<br>
	 * Message: &#36935;&#35211;&#20540;&#24471;&#20449;&#36084;&#30340;&#20154;&#65292;&#25110;&#24471;&#21040;&#22909;&#27231;&#26371;&#12290;<br>
	 * Message: You may meet a trustworthy person or a good opportunity.
	 */
	public static final NpcStringId YOU_MAY_MEET_A_TRUSTWORTHY_PERSON_OR_A_GOOD_OPPORTUNITY;
	
	/**
	 * ID: 1800314<br>
	 * Message: pbƂȂ炵B<br>
	 * Message: &#38519;&#20837;&#20302;&#28526;&#30340;&#29983;&#27963;&#65292;&#23559;&#26371;&#36880;&#28472;&#22909;&#36681;&#12290;<br>
	 * Message: Your downward life starts taking an upturn.
	 */
	public static final NpcStringId YOUR_DOWNWARD_LIFE_STARTS_TAKING_AN_UPTURN;
	
	/**
	 * ID: 1800315<br>
	 * Message: lCĎ͂̎gɏW߂B<br>
	 * Message: &#20154;&#27683;&#27798;&#22825;&#65292;&#26371;&#21463;&#21040;&#21608;&#22285;&#30340;&#27880;&#30446;&#12290;<br>
	 * Message: You will attract attention from people with your popularity.
	 */
	public static final NpcStringId YOU_WILL_ATTRACT_ATTENTION_FROM_PEOPLE_WITH_YOUR_POPULARITY;
	
	/**
	 * ID: 1800316<br>
	 * Message: d|ĂaɋHB<br>
	 * Message: &#39770;&#20818;&#19978;&#37390;&#20043;&#36939;&#12290;<br>
	 * Message: Your star of fortune says there'll be fish snapping at your bait.
	 */
	public static final NpcStringId YOUR_STAR_OF_FORTUNE_SAYS_THERELL_BE_FISH_SNAPPING_AT_YOUR_BAIT;
	
	/**
	 * ID: 1800317<br>
	 * Message: ƒfŎi߂΁AꂫB<br>
	 * Message: &#25797;&#33258;&#34389;&#29702;&#20107;&#24773;&#65292;&#23559;&#26371;&#25307;&#20358;&#31998;&#32027;&#12290;<br>
	 * Message: There may be a conflict born of your dogmatic procedures.
	 */
	public static final NpcStringId THERE_MAY_BE_A_CONFLICT_BORN_OF_YOUR_DOGMATIC_PROCEDURES;
	
	/**
	 * ID: 1800318<br>
	 * Message: mbƑn͂ŖڕWBB<br>
	 * Message: &#20860;&#20855;&#26234;&#24935;&#21644;&#21109;&#24847;&#65292;&#23559;&#26371;&#29554;&#24471;&#26399;&#30460;&#30340;&#25104;&#26524;&#12290;<br>
	 * Message: Your wisdom and creativity may lead you to success with your goal.
	 */
	public static final NpcStringId YOUR_WISDOM_AND_CREATIVITY_MAY_LEAD_YOU_TO_SUCCESS_WITH_YOUR_GOAL;
	
	/**
	 * ID: 1800319<br>
	 * Message: 킫ڂӂ炸ɎdɐS΁AڕWBłB<br>
	 * Message: &#22809;&#22812;&#21290;&#25032;&#30340;&#20419;&#36914;&#24037;&#20316;&#65292;&#20415;&#33021;&#36948;&#21040;&#30446;&#27161;&#12290;<br>
	 * Message: You may accomplish your goals if you diligently pursue them without giving up.
	 */
	public static final NpcStringId YOU_MAY_ACCOMPLISH_YOUR_GOALS_IF_YOU_DILIGENTLY_PURSUE_THEM_WITHOUT_GIVING_UP;
	
	/**
	 * ID: 1800320<br>
	 * Message: mb𓭂ʂU߂Η͂𓾂B<br>
	 * Message: &#19981;&#25237;&#27231;&#21462;&#24039;&#25110;&#32781;&#25163;&#27573;&#32780;&#27491;&#30070;&#34892;&#20107;&#65292;&#20415;&#26371;&#24471;&#21040;&#24171;&#21161;&#12290;<br>
	 * Message: You may get help if you go through the front door without seeking tricks or maneuvers.
	 */
	public static final NpcStringId YOU_MAY_GET_HELP_IF_YOU_GO_THROUGH_THE_FRONT_DOOR_WITHOUT_SEEKING_TRICKS_OR_MANEUVERS;
	
	/**
	 * ID: 1800321<br>
	 * Message: ڕW߂ėECčs΁AʂB<br>
	 * Message: &#31435;&#19979;&#30446;&#27161;&#65292;&#21191;&#26044;&#20184;&#35576;&#34892;&#21205;&#65292;&#20415;&#26371;&#26377;&#22909;&#32080;&#26524;&#12290;<br>
	 * Message: A good result is on the way if you set a goal and bravely proceed toward it.
	 */
	public static final NpcStringId A_GOOD_RESULT_IS_ON_THE_WAY_IF_YOU_SET_A_GOAL_AND_BRAVELY_PROCEED_TOWARD_IT;
	
	/**
	 * ID: 1800322<br>
	 * Message: Ȃ鍢낤ƂA肭B<br>
	 * Message: &#19981;&#31649;&#38754;&#33256;&#22810;&#40636;&#22256;&#38627;&#30340;&#20107;&#24773;&#65292;&#33836;&#20107;&#30342;&#36814;&#20995;&#32780;&#35299;&#12290;<br>
	 * Message: Everything will be smoothly managed no matter how difficult.
	 */
	public static final NpcStringId EVERYTHING_WILL_BE_SMOOTHLY_MANAGED_NO_MATTER_HOW_DIFFICULT;
	
	/**
	 * ID: 1800323<br>
	 * Message: ʂATdɌĎuāB<br>
	 * Message: &#25110;&#35377;&#26371;&#36935;&#21040;&#22256;&#38627;&#65292;&#23452;&#24910;&#37325;&#32771;&#24942;&#20006;&#22533;&#23450;&#24847;&#24535;&#12290;<br>
	 * Message: Be firm and carefully scrutinize circumstances even when things are difficult.
	 */
	public static final NpcStringId BE_FIRM_AND_CAREFULLY_SCRUTINIZE_CIRCUMSTANCES_EVEN_WHEN_THINGS_ARE_DIFFICULT;
	
	/**
	 * ID: 1800324<br>
	 * Message: uĂ肪ȂAɍlB<br>
	 * Message: &#38568;&#26178;&#30041;&#24847;&#26159;&#21542;&#23578;&#26377;&#26410;&#32147;&#34389;&#29702;&#32780;&#32622;&#20043;&#19981;&#29702;&#30340;&#21839;&#38988;&#12290;<br>
	 * Message: Always think over to find neglected problems you haven't taken care of yet.
	 */
	public static final NpcStringId ALWAYS_THINK_OVER_TO_FIND_NEGLECTED_PROBLEMS_YOU_HAVENT_TAKEN_CARE_OF_YET;
	
	/**
	 * ID: 1800325<br>
	 * Message: ɋ󂪓]荞łB<br>
	 * Message: &#31384;&#22256;&#30340;&#29983;&#27963;&#20013;&#65292;&#23559;&#26371;&#24118;&#20358;&#28414;&#28414;&#36001;&#28304;&#12290;<br>
	 * Message: Financial fortune will greet your poor life.
	 */
	public static final NpcStringId FINANCIAL_FORTUNE_WILL_GREET_YOUR_POOR_LIFE;
	
	/**
	 * ID: 1800326<br>
	 * Message: sK̐̉ɐ܂ꂽȂB^C㏸ĕxƖ_ɂB<br>
	 * Message: &#19981;&#24184;&#30340;&#29872;&#22659;&#20013;&#31840;&#32617;&#24184;&#36939;&#65292;&#23559;&#24471;&#21040;&#36001;&#23500;&#33287;&#21517;&#35709;&#12290;<br>
	 * Message: You may acquire wealth and fame after unlucky circumstances.
	 */
	public static final NpcStringId YOU_MAY_ACQUIRE_WEALTH_AND_FAME_AFTER_UNLUCKY_CIRCUMSTANCES;
	
	/**
	 * ID: 1800327<br>
	 * Message: Ă\zȌ𓾂Č悤ɂȂB<br>
	 * Message: &#36935;&#21040;&#22256;&#22659;&#26178;&#65292;&#24471;&#21040;&#31361;&#22914;&#20854;&#20358;&#30340;&#24171;&#21161;&#65292;&#23559;&#37325;&#23563;&#24076;&#26395;&#12290;<br>
	 * Message: The difficult situations will turn to hope with unforeseen help.
	 */
	public static final NpcStringId THE_DIFFICULT_SITUATIONS_WILL_TURN_TO_HOPE_WITH_UNFORESEEN_HELP;
	
	/**
	 * ID: 1800328<br>
	 * Message: 傫ȎdB<br>
	 * Message: &#38754;&#23565;&#37325;&#35201;&#30340;&#22823;&#20107;&#65292;&#21487;&#20197;&#29554;&#24471;&#25104;&#21151;&#12290;<br>
	 * Message: A great task will result in success.
	 */
	public static final NpcStringId A_GREAT_TASK_WILL_RESULT_IN_SUCCESS;
	
	/**
	 * ID: 1800329<br>
	 * Message: ɔ߂Ă₵Ɗ𐁂΂ĂMlɉB<br>
	 * Message: &#31361;&#36935;&#36020;&#20154;&#65292;&#21487;&#28858;&#20320;&#27927;&#21435;&#24515;&#20013;&#30340;&#23490;&#23518;&#21644;&#30683;&#30462;&#12290;<br>
	 * Message: You may encounter a precious person who will lift your loneliness and discord.
	 */
	public static final NpcStringId YOU_MAY_ENCOUNTER_A_PRECIOUS_PERSON_WHO_WILL_LIFT_YOUR_LONELINESS_AND_DISCORD;
	
	/**
	 * ID: 1800330<br>
	 * Message: ͂̐lX̌ɗ͂𓾂B<br>
	 * Message: &#22312;&#21608;&#22285;&#30340;&#40723;&#21237;&#20043;&#19979;&#65292;&#33836;&#20107;&#30342;&#26371;&#24471;&#21040;&#21147;&#37327;&#12290;<br>
	 * Message: People around you will encourage your every task in the future.
	 */
	public static final NpcStringId PEOPLE_AROUND_YOU_WILL_ENCOURAGE_YOUR_EVERY_TASK_IN_THE_FUTURE;
	
	/**
	 * ID: 1800331<br>
	 * Message: ~ɐiށB<br>
	 * Message: &#33836;&#20107;&#30342;&#26371;&#36814;&#20995;&#32780;&#35299;&#12290;<br>
	 * Message: Everything will be smoothly managed.
	 */
	public static final NpcStringId EVERYTHING_WILL_BE_SMOOTHLY_MANAGED;
	
	/**
	 * ID: 1800332<br>
	 * Message: ~ȐlԊ֌Wێ΁AȂ̉l߂ĂlB<br>
	 * Message: &#20445;&#25345;&#22291;&#28415;&#30340;&#20154;&#38555;&#38364;&#20418;&#65292;&#20415;&#26371;&#36935;&#19978;&#33021;&#35731;&#20320;&#25552;&#39640;&#36523;&#20729;&#30340;&#20154;&#12290;<br>
	 * Message: You will meet a person who can cherish your values if you maintain good ties with people.
	 */
	public static final NpcStringId YOU_WILL_MEET_A_PERSON_WHO_CAN_CHERISH_YOUR_VALUES_IF_YOU_MAINTAIN_GOOD_TIES_WITH_PEOPLE;
	
	/**
	 * ID: 1800333<br>
	 * Message: ̎LׂNBɋ͂SYꂸɁB<br>
	 * Message: &#23559;&#36935;&#35211;&#23565;&#20320;&#26377;&#24171;&#21161;&#30340;&#20154;&#65292;&#38568;&#26178;&#25265;&#20197;&#21512;&#20316;&#30340;&#24907;&#24230;&#12290;<br>
	 * Message: Maintain cooperative attitude since you will meet someone to be of help.
	 */
	public static final NpcStringId MAINTAIN_COOPERATIVE_ATTITUDE_SINCE_YOU_WILL_MEET_SOMEONE_TO_BE_OF_HELP;
	
	/**
	 * ID: 1800334<br>
	 * Message: ܂^񂾂Ƃĕߐɗ߁B<br>
	 * Message: &#21247;&#20197;&#20107;&#20107;&#38918;&#24515;&#32780;&#21916;&#20986;&#26395;&#22806;&#65292;&#20445;&#25345;&#31680;&#21046;&#30340;&#29983;&#27963;&#12290;<br>
	 * Message: Keep your moderation and ego in check even in successful phases of your life.
	 */
	public static final NpcStringId KEEP_YOUR_MODERATION_AND_EGO_IN_CHECK_EVEN_IN_SUCCESSFUL_PHASES_OF_YOUR_LIFE;
	
	/**
	 * ID: 1800335<br>
	 * Message: dAAlԊ֌WׂĂɂĉʂԂ΂ƂNB<br>
	 * Message: &#23565;&#20107;&#24773;&#12289;&#29983;&#27963;&#21644;&#20154;&#38555;&#38364;&#20418;&#23452;&#25505;&#21462;&#24120;&#35215;&#32780;&#38750;&#27402;&#23452;&#20043;&#35336;&#65292;&#37027;&#40636;&#33258;&#28982;&#26371;&#26377;&#22909;&#20107;&#30332;&#29983;&#12290;<br>
	 * Message: When it comes to work, lifestyle and relationships you'll be better off to go by the text rather than tricks.
	 */
	public static final NpcStringId WHEN_IT_COMES_TO_WORK_LIFESTYLE_AND_RELATIONSHIPS_YOULL_BE_BETTER_OFF_TO_GO_BY_THE_TEXT_RATHER_THAN_TRICKS;
	
	/**
	 * ID: 1800336<br>
	 * Message: Ďdɒe͂tB<br>
	 * Message: &#21608;&#37002;&#29872;&#22659;&#30340;&#26178;&#27231;&#24050;&#25104;&#65292;&#36914;&#34892;&#30340;&#20107;&#23559;&#26371;&#35722;&#24471;&#26356;&#38728;&#27963;&#12290;<br>
	 * Message: Your task will receive substantial support since the surroundings will fully develop.
	 */
	public static final NpcStringId YOUR_TASK_WILL_RECEIVE_SUBSTANTIAL_SUPPORT_SINCE_THE_SURROUNDINGS_WILL_FULLY_DEVELOP;
	
	/**
	 * ID: 1800337<br>
	 * Message: _IɂIɂ𓾂ĐB<br>
	 * Message: &#24471;&#21040;&#31934;&#31070;&#19978;&#21644;&#29289;&#36074;&#19978;&#30340;&#24171;&#21161;&#65292;&#39340;&#21040;&#25104;&#21151;&#20043;&#36939;&#12290;<br>
	 * Message: Your star of fortune indicate a success with mental and material assistance.
	 */
	public static final NpcStringId YOUR_STAR_OF_FORTUNE_INDICATE_A_SUCCESS_WITH_MENTAL_AND_MATERIAL_ASSISTANCE;
	
	/**
	 * ID: 1800338<br>
	 * Message: ńA˔\AĈӂ܂ŊFDB<br>
	 * Message: &#20855;&#26377;&#21109;&#24847;&#30340;&#25165;&#26234;&#65292;&#23559;&#24471;&#21040;&#20154;&#20154;&#30340;&#21916;&#24859;&#12290;<br>
	 * Message: You will enjoy popularity with your creative talents and clever acts.
	 */
	public static final NpcStringId YOU_WILL_ENJOY_POPULARITY_WITH_YOUR_CREATIVE_TALENTS_AND_CLEVER_ACTS;
	
	/**
	 * ID: 1800339<br>
	 * Message: FȂ悤ƂB<br>
	 * Message: &#20154;&#20154;&#23559;&#26371;&#29229;&#20808;&#24656;&#24460;&#30340;&#21069;&#20358;&#30456;&#21161;&#12290;<br>
	 * Message: People will line up to be of assistance to you.
	 */
	public static final NpcStringId PEOPLE_WILL_LINE_UP_TO_BE_OF_ASSISTANCE_TO_YOU;
	
	/**
	 * ID: 1800340<br>
	 * Message: HɂFB<br>
	 * Message: &#23559;&#26371;&#36935;&#19978;&#19968;&#21516;&#20986;&#36938;&#30340;&#20154;&#12290;<br>
	 * Message: You may meet someone to share your journey.
	 */
	public static final NpcStringId YOU_MAY_MEET_SOMEONE_TO_SHARE_YOUR_JOURNEY;
	
	/**
	 * ID: 1800341<br>
	 * Message: lXȐlɏoėǉɂ߂荇B<br>
	 * Message: &#21487;&#36935;&#35211;&#21508;&#26041;&#38754;&#23652;&#27425;&#19981;&#21516;&#30340;&#20154;&#20358;&#24314;&#31435;&#32227;&#20998;&#12290;<br>
	 * Message: You may achieve connections in many fields.
	 */
	public static final NpcStringId YOU_MAY_ACHIEVE_CONNECTIONS_IN_MANY_FIELDS;
	
	/**
	 * ID: 1800342<br>
	 * Message: wсAǂ߂p̐SBɂĐ^ȑԓxŗՂ߁B<br>
	 * Message: &#38656;&#35201;&#19981;&#26039;&#38321;&#35712;&#21644;&#25506;&#35342;&#65292;&#33836;&#20107;&#23452;&#25265;&#20197;&#35469;&#30495;&#30340;&#24907;&#24230;&#12290;<br>
	 * Message: An attitude that continually studies and explores is needed, and always be sincere.
	 */
	public static final NpcStringId AN_ATTITUDE_THAT_CONTINUALLY_STUDIES_AND_EXPLORES_IS_NEEDED_AND_ALWAYS_BE_SINCERE;
	
	/**
	 * ID: 1800343<br>
	 * Message: t̒gȋCɏĂĂԂɂƂ܂B<br>
	 * Message: &#26149;&#20809;&#27915;&#28322;&#65292;&#34676;&#34678;&#22352;&#33853;&#26044;&#33457;&#26421;&#20043;&#30456;&#12290;<br>
	 * Message: It's an image of a butterfly on a flower in warm spring air.
	 */
	public static final NpcStringId ITS_AN_IMAGE_OF_A_BUTTERFLY_ON_A_FLOWER_IN_WARM_SPRING_AIR;
	
	/**
	 * ID: 1800344<br>
	 * Message: ǂ肵ɁAu~AB<br>
	 * Message: &#21644;&#30566;&#23433;&#23450;&#30340;&#29983;&#27963;&#20013;&#65292;&#26399;&#30460;&#30340;&#20107;&#24773;&#23559;&#26371;&#22291;&#28415;&#22914;&#24847;&#12290;<br>
	 * Message: Your goals will move smoothly with peace and happiness in your life.
	 */
	public static final NpcStringId YOUR_GOALS_WILL_MOVE_SMOOTHLY_WITH_PEACE_AND_HAPPINESS_IN_YOUR_LIFE;
	
	/**
	 * ID: 1800345<br>
	 * Message: ͂̐lXɒgڂΈ萶B<br>
	 * Message: &#20197;&#28331;&#26262;&#23565;&#24453;&#21608;&#22285;&#65292;&#24859;&#24773;&#20415;&#26371;&#33804;&#33469;&#32780;&#20986;&#12290;<br>
	 * Message: Love may sprout its leaves when you treat those around you with care.
	 */
	public static final NpcStringId LOVE_MAY_SPROUT_ITS_LEAVES_WHEN_YOU_TREAT_THOSE_AROUND_YOU_WITH_CARE;
	
	/**
	 * ID: 1800346<br>
	 * Message: ^ꂽd𒅎ɐi߂΁AM𓾂ĂɍXe[Wɐi߂B<br>
	 * Message: &#35469;&#30495;&#23436;&#25104;&#33258;&#24049;&#20221;&#20839;&#30340;&#20107;&#65292;&#20415;&#33021;&#36111;&#24471;&#20449;&#36084;&#65292;&#19988;&#33021;&#26356;&#19978;&#19968;&#23652;&#27155;&#12290;<br>
	 * Message: You may climb into a higher position with others' trust if you faithfully carry out your duties.
	 */
	public static final NpcStringId YOU_MAY_CLIMB_INTO_A_HIGHER_POSITION_WITH_OTHERS_TRUST_IF_YOU_FAITHFULLY_CARRY_OUT_YOUR_DUTIES;
	
	/**
	 * ID: 1800347<br>
	 * Message: ^C㏸B~𒣂ΖAɋAB<br>
	 * Message: &#33509;&#35244;&#35238;&#24184;&#36939;&#21644;&#20709;&#20502;&#65292;&#19988;&#36942;&#20998;&#36010;&#23146;&#65292;&#33836;&#20107;&#30342;&#26371;&#36764;&#36000;&#26399;&#24453;&#12290;<br>
	 * Message: Everything can fall apart if you greedily aim by pure luck.
	 */
	public static final NpcStringId EVERYTHING_CAN_FALL_APART_IF_YOU_GREEDILY_AIM_BY_PURE_LUCK;
	
	/**
	 * ID: 1800348<br>
	 * Message: lƂ̕t܂߂ɁB<br>
	 * Message: &#21247;&#24608;&#24930;&#26044;&#32080;&#35672;&#26032;&#20154;&#12290;<br>
	 * Message: Do not underestimate the importance of meeting people.
	 */
	public static final NpcStringId DO_NOT_UNDERESTIMATE_THE_IMPORTANCE_OF_MEETING_PEOPLE;
	
	/**
	 * ID: 1800349<br>
	 * Message: 𓾂B<br>
	 * Message: &#31661;&#24471;&#24339;&#65292;&#22914;&#39770;&#24471;&#27700;&#20043;&#25976;&#12290;<br>
	 * Message: An arrow will coalesce into the bow.
	 */
	public static final NpcStringId AN_ARROW_WILL_COALESCE_INTO_THE_BOW;
	
	/**
	 * ID: 1800350<br>
	 * Message: ͂ꂩ̖؂ɎȂB<br>
	 * Message: &#20939;&#38646;&#30340;&#27193;&#26525;&#19978;&#38283;&#33457;&#32080;&#26524;&#20043;&#25976;&#12290;<br>
	 * Message: A bony limb of a tree may bear its fruit.
	 */
	public static final NpcStringId A_BONY_LIMB_OF_A_TREE_MAY_BEAR_ITS_FRUIT;
	
	/**
	 * ID: 1800351<br>
	 * Message: w͂ēʂŕ܂𓾂B<br>
	 * Message: &#23565;&#26044;&#33258;&#24049;&#21162;&#21147;&#30340;&#32080;&#26524;&#65292;&#23559;&#26371;&#24471;&#21040;&#22577;&#37228;&#12290;<br>
	 * Message: You will be rewarded for your efforts and accomplishments.
	 */
	public static final NpcStringId YOU_WILL_BE_REWARDED_FOR_YOUR_EFFORTS_AND_ACCOMPLISHMENTS;
	
	/**
	 * ID: 1800352<br>
	 * Message: AMOĐi߂Α傫ȐʂB<br>
	 * Message: &#33836;&#20107;&#21482;&#35201;&#20855;&#20633;&#22533;&#24375;&#30340;&#20449;&#24565;&#65292;&#20415;&#26371;&#24471;&#21040;&#26997;&#22823;&#30340;&#25104;&#26524;&#12290;<br>
	 * Message: No matter where it lies, your faithful drive leads you to success.
	 */
	public static final NpcStringId NO_MATTER_WHERE_IT_LIES_YOUR_FAITHFUL_DRIVE_LEADS_YOU_TO_SUCCESS;
	
	/**
	 * ID: 1800353<br>
	 * Message: Ȃ̖͂͂ǂȂƂłꏊȂƂB<br>
	 * Message: &#20320;&#30340;&#24544;&#35488;&#24907;&#24230;&#65292;&#20351;&#21608;&#22285;&#23565;&#20320;&#24863;&#21040;&#39749;&#21147;&#21313;&#36275;&#12290;<br>
	 * Message: People will be attracted to your loyalties.
	 */
	public static final NpcStringId PEOPLE_WILL_BE_ATTRACTED_TO_YOUR_LOYALTIES;
	
	/**
	 * ID: 1800354<br>
	 * Message: ľƂɐU񂳂ׂ炸BMB<br>
	 * Message: &#30433;&#37327;&#19981;&#35201;&#30456;&#20449;&#20182;&#20154;&#30340;&#35441;&#65292;&#30456;&#20449;&#33258;&#24049;&#25165;&#26159;&#37325;&#35201;&#30340;&#12290;<br>
	 * Message: You may trust yourself rather than others' talks.
	 */
	public static final NpcStringId YOU_MAY_TRUST_YOURSELF_RATHER_THAN_OTHERS_TALKS;
	
	/**
	 * ID: 1800355<br>
	 * Message: ̂̌ςđnIȍlāB<br>
	 * Message: &#25913;&#35722;&#35264;&#30475;&#20107;&#29289;&#30340;&#35264;&#40670;&#65292;&#24819;&#20986;&#26377;&#21109;&#24847;&#30340;&#40670;&#23376;&#65292;&#25165;&#33021;&#24471;&#21040;&#24171;&#21161;&#12290;<br>
	 * Message: Creative thinking away from the old viewpoint may help you.
	 */
	public static final NpcStringId CREATIVE_THINKING_AWAY_FROM_THE_OLD_VIEWPOINT_MAY_HELP_YOU;
	
	/**
	 * ID: 1800356<br>
	 * Message: 炸]TČʂ҂Ă΂ʂB<br>
	 * Message: &#19981;&#35201;&#24613;&#26044;&#24471;&#21040;&#32080;&#26524;&#65292;&#25918;&#39686;&#24515;&#24773;&#20415;&#26371;&#26377;&#22909;&#32080;&#26524;&#12290;<br>
	 * Message: Patience without being impetuous of the results will only bear a positive outcome.
	 */
	public static final NpcStringId PATIENCE_WITHOUT_BEING_IMPETUOUS_OF_THE_RESULTS_WILL_ONLY_BEAR_A_POSITIVE_OUTCOME;
	
	/**
	 * ID: 1800357<br>
	 * Message: lԂB<br>
	 * Message: &#27515;&#32773;&#23559;&#26371;&#36215;&#27515;&#22238;&#29983;&#12290;<br>
	 * Message: The dead will come alive.
	 */
	public static final NpcStringId THE_DEAD_WILL_COME_ALIVE;
	
	/**
	 * ID: 1800358<br>
	 * Message: ̏oȂ҂󂯂B<br>
	 * Message: &#23559;&#26371;&#30332;&#29983;&#20196;&#20154;&#39514;&#35357;&#30340;&#20107;&#24773;&#12290;<br>
	 * Message: There will be a shocking incident.
	 */
	public static final NpcStringId THERE_WILL_BE_A_SHOCKING_INCIDENT;
	
	/**
	 * ID: 1800359<br>
	 * Message: Ȃڂő听߂B<br>
	 * Message: &#31361;&#22914;&#20854;&#20358;&#30340;&#24184;&#36939;&#23637;&#29694;&#30524;&#21069;&#65292;&#26377;&#26395;&#36993;&#21521;&#25104;&#21151;&#20043;&#36335;&#12290;<br>
	 * Message: You will enjoy a huge success after unforeseen luck comes before you.
	 */
	public static final NpcStringId YOU_WILL_ENJOY_A_HUGE_SUCCESS_AFTER_UNFORESEEN_LUCK_COMES_BEFORE_YOU;
	
	/**
	 * ID: 1800360<br>
	 * Message: ߂ĂƂɊՂNBŌ܂ł߂ȁB<br>
	 * Message: &#24190;&#20046;&#25918;&#26820;&#30340;&#20107;&#24773;&#23559;&#36935;&#19978;&#22855;&#36447;&#65292;&#19981;&#23452;&#25918;&#26820;&#65292;&#22533;&#25345;&#21040;&#24213;&#12290;<br>
	 * Message: Do not give up since there may be a miraculous rescue from the course of despair.
	 */
	public static final NpcStringId DO_NOT_GIVE_UP_SINCE_THERE_MAY_BE_A_MIRACULOUS_RESCUE_FROM_THE_COURSE_OF_DESPAIR;
	
	/**
	 * ID: 1800361<br>
	 * Message: ڕWBɍőPspKvB<br>
	 * Message: &#23565;&#26044;&#33258;&#24049;&#31435;&#19979;&#30340;&#30446;&#27161;&#65292;&#38920;&#22533;&#25345;&#21040;&#24213;&#20006;&#20840;&#21147;&#20197;&#36212;&#12290;<br>
	 * Message: An attitude to try one's best to pursue the goal is needed.
	 */
	public static final NpcStringId AN_ATTITUDE_TO_TRY_ONES_BEST_TO_PURSUE_THE_GOAL_IS_NEEDED;
	
	/**
	 * ID: 1800362<br>
	 * Message: RlɏoāÅ͂𓾂B<br>
	 * Message: &#20598;&#28982;&#30456;&#36935;&#36020;&#20154;&#65292;&#23559;&#26371;&#24471;&#21040;&#29983;&#27963;&#19978;&#30340;&#27963;&#21147;&#12290;<br>
	 * Message: You may get a shot in the arm in your life after meeting a good person.
	 */
	public static final NpcStringId YOU_MAY_GET_A_SHOT_IN_THE_ARM_IN_YOUR_LIFE_AFTER_MEETING_A_GOOD_PERSON;
	
	/**
	 * ID: 1800363<br>
	 * Message: 炵ɑ傫ȏ𓾂B<br>
	 * Message: &#22312;&#20154;&#29983;&#36335;&#36884;&#19978;&#65292;&#23559;&#26371;&#24471;&#21040;&#33707;&#22823;&#30340;&#24171;&#21161;&#12290;<br>
	 * Message: You may get a big help in the course of your life.
	 */
	public static final NpcStringId YOU_MAY_GET_A_BIG_HELP_IN_THE_COURSE_OF_YOUR_LIFE;
	
	/**
	 * ID: 1800364<br>
	 * Message: WւƂȂ`XށB<br>
	 * Message: &#21487;&#20197;&#20598;&#28982;&#24471;&#21040;&#39131;&#40643;&#39472;&#36948;&#30340;&#27231;&#26371;&#12290;<br>
	 * Message: A rare opportunity will come to you so you may prosper.
	 */
	public static final NpcStringId A_RARE_OPPORTUNITY_WILL_COME_TO_YOU_SO_YOU_MAY_PROSPER;
	
	/**
	 * ID: 1800365<br>
	 * Message: 邪llB<br>
	 * Message: &#39138;&#39187;&#30340;&#32769;&#40441;&#24471;&#21040;&#32905;&#39135;&#20043;&#25976;&#12290;<br>
	 * Message: A hungry falcon will have meat.
	 */
	public static final NpcStringId A_HUNGRY_FALCON_WILL_HAVE_MEAT;
	
	/**
	 * ID: 1800366<br>
	 * Message: ɍƐH]荞łB<br>
	 * Message: &#31384;&#22256;&#30340;&#29983;&#27963;&#20013;&#65292;&#23559;&#24471;&#21040;&#37666;&#36001;&#21644;&#39135;&#29289;&#12290;<br>
	 * Message: A household in need will acquire a fortune and meat.
	 */
	public static final NpcStringId A_HOUSEHOLD_IN_NEED_WILL_ACQUIRE_A_FORTUNE_AND_MEAT;
	
	/**
	 * ID: 1800367<br>
	 * Message: l畨IA_Iȏ𓾂ċꋫEB<br>
	 * Message: &#24478;&#20182;&#20154;&#24471;&#21040;&#29289;&#36074;&#19978;&#21644;&#31934;&#31070;&#19978;&#30340;&#24171;&#21161;&#65292;&#24478;&#32780;&#21487;&#20197;&#33067;&#38626;&#22256;&#22659;&#12290;<br>
	 * Message: A hard situation will come to its end with materialistic and mental help from others.
	 */
	public static final NpcStringId A_HARD_SITUATION_WILL_COME_TO_ITS_END_WITH_MATERIALISTIC_AND_MENTAL_HELP_FROM_OTHERS;
	
	/**
	 * ID: 1800368<br>
	 * Message: ߂ڕW͂Ƃ΁AƏ̎肪LׂB<br>
	 * Message: &#19981;&#25918;&#26820;&#22818;&#24819;&#19988;&#30906;&#31435;&#30446;&#27161;&#65292;&#26576;&#20154;&#23601;&#26371;&#20280;&#20986;&#25937;&#25588;&#33287;&#24859;&#24773;&#20043;&#25163;&#12290;<br>
	 * Message: If you set a firm goal without surrender, there will be a person who can offer help and care.
	 */
	public static final NpcStringId IF_YOU_SET_A_FIRM_GOAL_WITHOUT_SURRENDER_THERE_WILL_BE_A_PERSON_WHO_CAN_OFFER_HELP_AND_CARE;
	
	/**
	 * ID: 1800369<br>
	 * Message: ^ŐȑԓxۂĂ΁A̐lXMB<br>
	 * Message: &#20445;&#25345;&#35469;&#30495;&#21644;&#35488;&#23526;&#30340;&#24907;&#24230;&#65292;&#20415;&#21487;&#24471;&#21040;&#21608;&#22285;&#30340;&#20449;&#20219;&#12290;<br>
	 * Message: You'll gain others' trust when you maintain a sincere and honest attitude.
	 */
	public static final NpcStringId YOULL_GAIN_OTHERS_TRUST_WHEN_YOU_MAINTAIN_A_SINCERE_AND_HONEST_ATTITUDE;
	
	/**
	 * ID: 1800370<br>
	 * Message: Nɂ炸ɕ点B<br>
	 * Message: &#25345;&#32396;&#29544;&#31435;&#29983;&#27963;&#30340;&#24907;&#24230;&#12290;<br>
	 * Message: Be independent at all times.
	 */
	public static final NpcStringId BE_INDEPENDENT_AT_ALL_TIMES;
	
	/**
	 * ID: 1800371<br>
	 * Message: Ԃ̎ԗւȂB<br>
	 * Message: &#36554;&#36635;&#20841;&#26049;&#27794;&#26377;&#36554;&#36650;&#12290;<br>
	 * Message: It's a wagon with no wheels.
	 */
	public static final NpcStringId ITS_A_WAGON_WITH_NO_WHEELS;
	
	/**
	 * ID: 1800372<br>
	 * Message: uĂA̎WB<br>
	 * Message: &#24050;&#30906;&#31435;&#30446;&#27161;&#65292;&#20294;&#21463;&#21040;&#29694;&#23526;&#30340;&#38480;&#21046;&#65292;&#22240;&#32780;&#36935;&#19978;&#29942;&#38968;&#12290;<br>
	 * Message: You've set a goal but there may be obstacles in reality.
	 */
	public static final NpcStringId YOUVE_SET_A_GOAL_BUT_THERE_MAY_BE_OBSTACLES_IN_REALITY;
	
	/**
	 * ID: 1800373<br>
	 * Message: ڕWɌ簐i邪Avقǂ̐ʂ͓ȂB<br>
	 * Message: &#38614;&#26377;&#26397;&#30446;&#27161;&#22868;&#39347;&#65292;&#20294;&#25104;&#26524;&#20006;&#22826;&#19981;&#29702;&#24819;&#12290;<br>
	 * Message: You're running toward the goal but there won't be as many outcomes as you thought.
	 */
	public static final NpcStringId YOURE_RUNNING_TOWARD_THE_GOAL_BUT_THERE_WONT_BE_AS_MANY_OUTCOMES_AS_YOU_THOUGHT;
	
	/**
	 * ID: 1800374<br>
	 * Message: זĔY܂B<br>
	 * Message: &#21608;&#22285;&#30340;&#38556;&#31001;&#29289;&#22826;&#22810;&#65292;&#38656;&#32771;&#24942;&#30340;&#20107;&#38917;&#22686;&#22810;&#12290;<br>
	 * Message: There are many things to consider after encountering hindrances.
	 */
	public static final NpcStringId THERE_ARE_MANY_THINGS_TO_CONSIDER_AFTER_ENCOUNTERING_HINDRANCES;
	
	/**
	 * ID: 1800375<br>
	 * Message: ̏lɋsΎsB<br>
	 * Message: &#19981;&#39015;&#21069;&#24460;&#20358;&#20419;&#36914;&#20107;&#24773;&#65292;&#23559;&#26371;&#36973;&#36935;&#22833;&#25943;&#12290;<br>
	 * Message: A reckless move may bring a failure.
	 */
	public static final NpcStringId A_RECKLESS_MOVE_MAY_BRING_A_FAILURE;
	
	/**
	 * ID: 1800376<br>
	 * Message: ATdɂBȂΎ̐lX̐MB<br>
	 * Message: &#33836;&#20107;&#33509;&#19981;&#24910;&#37325;&#65292;&#20415;&#26371;&#22833;&#21435;&#21608;&#22285;&#30340;&#20449;&#20219;&#12290;<br>
	 * Message: You may lose people's trust if you lack prudence at all times.
	 */
	public static final NpcStringId YOU_MAY_LOSE_PEOPLES_TRUST_IF_YOU_LACK_PRUDENCE_AT_ALL_TIMES;
	
	/**
	 * ID: 1800377<br>
	 * Message: Ȃ݂D@҂āB<br>
	 * Message: &#24910;&#37325;&#22320;&#22238;&#39015;&#33258;&#25105;&#65292;&#31561;&#24453;&#27231;&#26371;&#20358;&#33256;&#12290;<br>
	 * Message: You may need to reflect on yourself with deliberation and wait for an opportunity.
	 */
	public static final NpcStringId YOU_MAY_NEED_TO_REFLECT_ON_YOURSELF_WITH_DELIBERATION_AND_WAIT_FOR_AN_OPPORTUNITY;
	
	/**
	 * ID: 1800378<br>
	 * Message: nmA\𓾂BȂڂ̗\B<br>
	 * Message: &#36007;&#31406;&#30340;&#26360;&#29983;&#24471;&#21040;&#20472;&#31103;&#12290;<br>
	 * Message: A poor scholar receives a stipend.
	 */
	public static final NpcStringId A_POOR_SCHOLAR_RECEIVES_A_STIPEND;
	
	/**
	 * ID: 1800379<br>
	 * Message: ɃpXĕxƖ_𓾂B<br>
	 * Message: &#26360;&#29983;&#37329;&#27036;&#38988;&#21517;&#65292;&#23559;&#24471;&#21040;&#36001;&#23500;&#33287;&#21517;&#35709;&#12290;<br>
	 * Message: A scholar gets a pass toward fame and fortune.
	 */
	public static final NpcStringId A_SCHOLAR_GETS_A_PASS_TOWARD_FAME_AND_FORTUNE;
	
	/**
	 * ID: 1800380<br>
	 * Message: ƖB<br>
	 * Message: &#23526;&#29694;&#33258;&#24049;&#30340;&#25265;&#36000;&#21644;&#22818;&#24819;&#20043;&#25976;&#12290;<br>
	 * Message: Your ambition and dream will come true.
	 */
	public static final NpcStringId YOUR_AMBITION_AND_DREAM_WILL_COME_TRUE;
	
	/**
	 * ID: 1800381<br>
	 * Message: GȖ͏B<br>
	 * Message: &#21608;&#22285;&#31998;&#32399;&#35079;&#38620;&#30340;&#21839;&#38988;&#23559;&#36880;&#19968;&#35299;&#38283;&#12290;<br>
	 * Message: Complicated problems around you may start being solved one after another.
	 */
	public static final NpcStringId COMPLICATED_PROBLEMS_AROUND_YOU_MAY_START_BEING_SOLVED_ONE_AFTER_ANOTHER;
	
	/**
	 * ID: 1800382<br>
	 * Message: ߂ƂŔY܂AڕWĂĎɓw͂΂ʂB<br>
	 * Message: &#19981;&#20877;&#28858;&#24448;&#20107;&#29033;&#24817;&#65292;&#26397;&#19968;&#20491;&#30446;&#27161;&#21521;&#21069;&#36993;&#36914;&#65292;&#20415;&#33021;&#24471;&#21040;&#22909;&#32080;&#26524;&#12290;<br>
	 * Message: You will have a good result if you diligently pursue one goal without being dragged from your past.
	 */
	public static final NpcStringId YOU_WILL_HAVE_A_GOOD_RESULT_IF_YOU_DILIGENTLY_PURSUE_ONE_GOAL_WITHOUT_BEING_DRAGGED_FROM_YOUR_PAST;
	
	/**
	 * ID: 1800383<br>
	 * Message: K͑ŔjׂB<br>
	 * Message: &#32769;&#33290;&#30340;&#32722;&#24931;&#26368;&#22909;&#22823;&#26041;&#22320;&#25291;&#26820;&#12290;<br>
	 * Message: You may need to rid yourself of old and worn habits.
	 */
	public static final NpcStringId YOU_MAY_NEED_TO_RID_YOURSELF_OF_OLD_AND_WORN_HABITS;
	
	/**
	 * ID: 1800384<br>
	 * Message: Cꂽd͐ӔCĂʂBA͂̏ϋɓIɋ߂B<br>
	 * Message: &#25265;&#20197;&#36012;&#20219;&#24515;&#20358;&#34389;&#29702;&#20221;&#20839;&#30340;&#20107;&#22266;&#28982;&#37325;&#35201;&#65292;&#20294;&#20063;&#38656;&#35201;&#31309;&#26997;&#22320;&#21521;&#22821;&#20276;&#20280;&#20986;&#25588;&#25163;&#12290;<br>
	 * Message: Be responsible with your tasks but do not hesitate to ask for colleagues' help.
	 */
	public static final NpcStringId BE_RESPONSIBLE_WITH_YOUR_TASKS_BUT_DO_NOT_HESITATE_TO_ASK_FOR_COLLEAGUES_HELP;
	
	/**
	 * ID: 1800385<br>
	 * Message: ΂YށB<br>
	 * Message: &#39881;&#39770;&#36493;&#40845;&#38272;&#12290;<br>
	 * Message: Fish transforms into a dragon.
	 */
	public static final NpcStringId FISH_TRANSFORMS_INTO_A_DRAGON;
	
	/**
	 * ID: 1800386<br>
	 * Message: ]݂Ė_ƍ𓾂B<br>
	 * Message: &#33258;&#24049;&#26399;&#30460;&#30340;&#20107;&#24773;&#23559;&#26371;&#22291;&#28415;&#25104;&#21151;&#65292;&#20006;&#24471;&#21040;&#21517;&#35709;&#33287;&#36001;&#23500;&#12290;<br>
	 * Message: Your dream may come true, and fame and fortune will come to you.
	 */
	public static final NpcStringId YOUR_DREAM_MAY_COME_TRUE_AND_FAME_AND_FORTUNE_WILL_COME_TO_YOU;
	
	/**
	 * ID: 1800387<br>
	 * Message: v悪vʂɐiށB<br>
	 * Message: &#20107;&#24773;&#23559;&#26371;&#25353;&#29031;&#35336;&#30059;&#30340;&#26041;&#21521;&#36914;&#34892;&#12290;<br>
	 * Message: What you've planed will be accomplished.
	 */
	public static final NpcStringId WHAT_YOUVE_PLANED_WILL_BE_ACCOMPLISHED;
	
	/**
	 * ID: 1800388<br>
	 * Message: vʂƂ납K`X]荞ށB<br>
	 * Message: &#22312;&#24847;&#24819;&#19981;&#21040;&#30340;&#22320;&#26041;&#65292;&#23559;&#26371;&#24471;&#21040;&#37329;&#37666;&#25110;&#26032;&#30340;&#27231;&#26371;&#12290;<br>
	 * Message: You may acquire money or a new opportunity from a place you wouldn't have thought of.
	 */
	public static final NpcStringId YOU_MAY_ACQUIRE_MONEY_OR_A_NEW_OPPORTUNITY_FROM_A_PLACE_YOU_WOULDNT_HAVE_THOUGHT_OF;
	
	/**
	 * ID: 1800389<br>
	 * Message: Ă͑ATdɍlB<br>
	 * Message: &#23559;&#26371;&#24471;&#21040;&#24456;&#22810;&#30340;&#24314;&#35696;&#65292;&#20294;&#23452;&#24910;&#37325;&#32771;&#24942;&#12290;<br>
	 * Message: There will be many offers to you, you may think them over carefully.
	 */
	public static final NpcStringId THERE_WILL_BE_MANY_OFFERS_TO_YOU_YOU_MAY_THINK_THEM_OVER_CAREFULLY;
	
	/**
	 * ID: 1800390<br>
	 * Message: lɎނȁB<br>
	 * Message: &#30433;&#37327;&#19981;&#35201;&#22909;&#31649;&#38290;&#20107;&#12290;<br>
	 * Message: It may be a good idea not to become involved in others' business.
	 */
	public static final NpcStringId IT_MAY_BE_A_GOOD_IDEA_NOT_TO_BECOME_INVOLVED_IN_OTHERS_BUSINESS;
	
	/**
	 * ID: 1800391<br>
	 * Message: ɍsBfӂ񂾂肷̂͋֕B<br>
	 * Message: &#33836;&#20107;&#23559;&#36814;&#20995;&#32780;&#35299;&#65292;&#20294;&#21247;&#25265;&#20197;&#23433;&#24515;&#25110;&#20302;&#28526;&#30340;&#24907;&#24230;&#12290;<br>
	 * Message: Everything will go smoothly but be aware of danger from being careless and remiss.
	 */
	public static final NpcStringId EVERYTHING_WILL_GO_SMOOTHLY_BUT_BE_AWARE_OF_DANGER_FROM_BEING_CARELESS_AND_REMISS;
	
	/**
	 * ID: 1800392<br>
	 * Message: lɂ͐ɂ݂Ȃ𒍂B傫ȕ܂B<br>
	 * Message: &#23565;&#24515;&#20736;&#30340;&#20154;&#20184;&#20986;&#28961;&#30433;&#30340;&#24859;&#65292;&#20415;&#26371;&#24471;&#21040;&#28961;&#30433;&#30340;&#22577;&#31572;&#12290;<br>
	 * Message: If you sincerely care for someone you love, a big reward will return to you.
	 */
	public static final NpcStringId IF_YOU_SINCERELY_CARE_FOR_SOMEONE_YOU_LOVE_A_BIG_REWARD_WILL_RETURN_TO_YOU;
	
	/**
	 * ID: 1800393<br>
	 * Message: daɗǖ𓾂B<br>
	 * Message: &#30149;&#28797;&#24471;&#21040;&#38728;&#34277;&#12290;<br>
	 * Message: A remedy is on its way for a serious illness.
	 */
	public static final NpcStringId A_REMEDY_IS_ON_ITS_WAY_FOR_A_SERIOUS_ILLNESS;
	
	/**
	 * ID: 1800394<br>
	 * Message: aŋꂵނAǖ𓾂Ċ͂߂B<br>
	 * Message: &#30149;&#20837;&#33167;&#32915;&#65292;&#20294;&#27714;&#24471;&#38728;&#34277;&#20043;&#24460;&#65292;&#24517;&#33021;&#36681;&#21361;&#32780;&#23433;&#12290;<br>
	 * Message: You may acquire a precious medicine to recover after suffering a disease of a serious nature.
	 */
	public static final NpcStringId YOU_MAY_ACQUIRE_A_PRECIOUS_MEDICINE_TO_RECOVER_AFTER_SUFFERING_A_DISEASE_OF_A_SERIOUS_NATURE;
	
	/**
	 * ID: 1800395<br>
	 * Message: ꋫŋMlɏo]݂B<br>
	 * Message: &#22312;&#33393;&#38627;&#30340;&#24773;&#27841;&#19979;&#31361;&#36935;&#36020;&#20154;&#65292;&#23559;&#26371;&#36948;&#21040;&#39000;&#26395;&#12290;<br>
	 * Message: You may realize your dream by meeting a man of distinction at a difficult time.
	 */
	public static final NpcStringId YOU_MAY_REALIZE_YOUR_DREAM_BY_MEETING_A_MAN_OF_DISTINCTION_AT_A_DIFFICULT_TIME;
	
	/**
	 * ID: 1800396<br>
	 * Message: Hɂ͓́B<br>
	 * Message: &#22312;&#26053;&#36884;&#19978;&#65292;&#23559;&#26371;&#36935;&#21040;&#19968;&#20841;&#27425;&#30340;&#38627;&#38364;&#12290;<br>
	 * Message: You may suffer one or two hardships on your journey.
	 */
	public static final NpcStringId YOU_MAY_SUFFER_ONE_OR_TWO_HARDSHIPS_ON_YOUR_JOURNEY;
	
	/**
	 * ID: 1800397<br>
	 * Message: ΂Yꂸ܂Ȃ΁A̐lXMƏ𓾂B<br>
	 * Message: &#19981;&#25084;&#25387;&#25240;&#19988;&#38754;&#24118;&#24494;&#31505;&#65292;&#20415;&#26371;&#24471;&#21040;&#21608;&#22285;&#30340;&#20449;&#20219;&#21644;&#24171;&#21161;&#12290;<br>
	 * Message: If you keep smiling without despair, people will come to trust you and offer help.
	 */
	public static final NpcStringId IF_YOU_KEEP_SMILING_WITHOUT_DESPAIR_PEOPLE_WILL_COME_TO_TRUST_YOU_AND_OFFER_HELP;
	
	/**
	 * ID: 1800398<br>
	 * Message: ω͈B<br>
	 * Message: &#33287;&#20854;&#32102;&#20104;&#35722;&#21270;&#65292;&#19981;&#22914;&#23433;&#20139;&#29983;&#27963;&#12290;<br>
	 * Message: Seek stability rather than dynamics in your life.
	 */
	public static final NpcStringId SEEK_STABILITY_RATHER_THAN_DYNAMICS_IN_YOUR_LIFE;
	
	/**
	 * ID: 1800399<br>
	 * Message: ATdmɐi߂ׂB<br>
	 * Message: &#38656;&#20197;&#24910;&#37325;&#12289;&#28310;&#30906;&#12289;&#23433;&#20840;&#28858;&#21407;&#21063;&#20358;&#20419;&#36914;&#34892;&#20107;&#12290;<br>
	 * Message: It's a good idea to be careful and secure at all times.
	 */
	public static final NpcStringId ITS_A_GOOD_IDEA_TO_BE_CAREFUL_AND_SECURE_AT_ALL_TIMES;
	
	/**
	 * ID: 1800400<br>
	 * Message: 葫킸di߂ȂB<br>
	 * Message: &#22914;&#21516;&#32570;&#20047;&#25163;&#33218;&#65292;&#28961;&#27861;&#20419;&#36914;&#34892;&#20107;&#12290;<br>
	 * Message: You can't perform the job with bound hands.
	 */
	public static final NpcStringId YOU_CANT_PERFORM_THE_JOB_WITH_BOUND_HANDS;
	
	/**
	 * ID: 1800401<br>
	 * Message: i͂܂悤B<br>
	 * Message: &#22833;&#21435;&#21205;&#21147;&#65292;&#24492;&#24488;&#20043;&#25976;&#12290;<br>
	 * Message: You may lose your drive and feel lost.
	 */
	public static final NpcStringId YOU_MAY_LOSE_YOUR_DRIVE_AND_FEEL_LOST;
	
	/**
	 * ID: 1800402<br>
	 * Message: pAdɏWłȂB<br>
	 * Message: &#21040;&#34389;&#30332;&#29983;&#21839;&#38988;&#65292;&#38627;&#20197;&#23560;&#27880;&#26044;&#33258;&#24049;&#30340;&#20107;&#24773;&#19978;&#12290;<br>
	 * Message: You may be unable to concentrate with so many problems occurring.
	 */
	public static final NpcStringId YOU_MAY_BE_UNABLE_TO_CONCENTRATE_WITH_SO_MANY_PROBLEMS_OCCURRING;
	
	/**
	 * ID: 1800403<br>
	 * Message: 蕿lɉ肳B<br>
	 * Message: &#33258;&#24049;&#30340;&#21151;&#21214;&#23559;&#26371;&#36681;&#35731;&#32102;&#21029;&#20154;&#12290;<br>
	 * Message: Your achievement unfairly may go somewhere else.
	 */
	public static final NpcStringId YOUR_ACHIEVEMENT_UNFAIRLY_MAY_GO_SOMEWHERE_ELSE;
	
	/**
	 * ID: 1800404<br>
	 * Message: młȂΎȁB<br>
	 * Message: &#19981;&#30906;&#23450;&#30340;&#20107;&#24773;&#65292;&#26368;&#22909;&#19981;&#35201;&#38283;&#22987;&#36914;&#34892;&#12290;<br>
	 * Message: Do not start a task that's not clear to you.
	 */
	public static final NpcStringId DO_NOT_START_A_TASK_THATS_NOT_CLEAR_TO_YOU;
	
	/**
	 * ID: 1800405<br>
	 * Message: ɔB<br>
	 * Message: &#28858;&#20102;&#33836;&#19968;&#65292;&#38568;&#26178;&#37117;&#35201;&#20570;&#22909;&#38450;&#31684;&#30340;&#28310;&#20633;&#12290;<br>
	 * Message: You will need to be prepared for all events.
	 */
	public static final NpcStringId YOU_WILL_NEED_TO_BE_PREPARED_FOR_ALL_EVENTS;
	
	/**
	 * ID: 1800406<br>
	 * Message: @ɕmĂ߂ɂ܂ʓw͂BF߂ĂlB<br>
	 * Message: &#36935;&#19978;&#22256;&#38627;&#20063;&#19981;&#35201;&#25918;&#26820;&#65292;&#21162;&#21147;&#22533;&#25345;&#21040;&#24213;&#65292;&#20415;&#26371;&#24471;&#21040;&#32943;&#23450;&#12290;<br>
	 * Message: Someone will acknowledge you if you relentlessly keep trying and do not give up when facing hardships.
	 */
	public static final NpcStringId SOMEONE_WILL_ACKNOWLEDGE_YOU_IF_YOU_RELENTLESSLY_KEEP_TRYING_AND_DO_NOT_GIVE_UP_WHEN_FACING_HARDSHIPS;
	
	/**
	 * ID: 1800407<br>
	 * Message: ̐^̎pB<br>
	 * Message: &#22914;&#40845;&#24471;&#35282;&#65292;&#37670;&#19978;&#28155;&#33457;&#65292;&#23559;&#26371;&#20855;&#20633;&#23436;&#21892;&#30340;&#33258;&#25105;&#12290;<br>
	 * Message: You may perfect yourself like a dragon's horn decorates the dragon.
	 */
	public static final NpcStringId YOU_MAY_PERFECT_YOURSELF_LIKE_A_DRAGONS_HORN_DECORATES_THE_DRAGON;
	
	/**
	 * ID: 1800408<br>
	 * Message: Xɐ^𔭊B<br>
	 * Message: &#28872;&#28779;&#35211;&#30495;&#37329;&#65292;&#23559;&#36880;&#28472;&#30332;&#25582;&#33258;&#24049;&#30340;&#20729;&#20540;&#12290;<br>
	 * Message: Your true value starts to shine.
	 */
	public static final NpcStringId YOUR_TRUE_VALUE_STARTS_TO_SHINE;
	
	/**
	 * ID: 1800409<br>
	 * Message: ʂłBVƂǂ߂BȂ̉lオB<br>
	 * Message: &#27604;&#20182;&#20154;&#21462;&#24471;&#26356;&#22810;&#30340;&#24773;&#22577;&#65292;&#38568;&#26178;&#28310;&#20633;&#25506;&#35342;&#26032;&#20107;&#29289;&#65292;&#20415;&#26371;&#25552;&#39640;&#33258;&#24049;&#30340;&#20729;&#20540;&#12290;<br>
	 * Message: Your steady pursuit of new information and staying ahead of others will raise your value.
	 */
	public static final NpcStringId YOUR_STEADY_PURSUIT_OF_NEW_INFORMATION_AND_STAYING_AHEAD_OF_OTHERS_WILL_RAISE_YOUR_VALUE;
	
	/**
	 * ID: 1800410<br>
	 * Message: dlԊ֌W悭BʂB<br>
	 * Message: &#27683;&#21218;&#30917;&#31009;&#22320;&#20419;&#36914;&#20107;&#24773;&#25110;&#24314;&#31435;&#20154;&#38555;&#38364;&#20418;&#65292;&#20415;&#26371;&#24471;&#21040;&#22909;&#32080;&#26524;&#12290;<br>
	 * Message: Maintaining confidence with work or relationships may bring good results.
	 */
	public static final NpcStringId MAINTAINING_CONFIDENCE_WITH_WORK_OR_RELATIONSHIPS_MAY_BRING_GOOD_RESULTS;
	
	/**
	 * ID: 1800411<br>
	 * Message: ߐM͍Ђ̂ƁBԂƋ͂B<br>
	 * Message: &#36942;&#20449;&#33258;&#24049;&#65292;&#23559;&#26371;&#24341;&#20358;&#31117;&#23475;&#65292;&#38920;&#33287;&#22821;&#20276;&#22521;&#39178;&#40778;&#24515;&#21332;&#21147;&#30340;&#24907;&#24230;&#12290;<br>
	 * Message: Learn to work with others since overconfidence will bear wrath.
	 */
	public static final NpcStringId LEARN_TO_WORK_WITH_OTHERS_SINCE_OVERCONFIDENCE_WILL_BEAR_WRATH;
	
	/**
	 * ID: 1800412<br>
	 * Message: Sɋ_B<br>
	 * Message: &#40845;&#21547;&#22914;&#24847;&#29664;&#12290;<br>
	 * Message: The dragon now acquires an eagle's wings.
	 */
	public static final NpcStringId THE_DRAGON_NOW_ACQUIRES_AN_EAGLES_WINGS;
	
	/**
	 * ID: 1800413<br>
	 * Message: Sɋ_BƖڕWB<br>
	 * Message: &#40845;&#21547;&#22914;&#24847;&#29664;&#21319;&#22825;&#65292;&#23559;&#26371;&#23526;&#29694;&#33258;&#24049;&#30340;&#22818;&#24819;&#21644;&#30446;&#27161;&#12290;<br>
	 * Message: As the dragon flies high in the sky, your goals and dreams may come true.
	 */
	public static final NpcStringId AS_THE_DRAGON_FLIES_HIGH_IN_THE_SKY_YOUR_GOALS_AND_DREAMS_MAY_COME_TRUE;
	
	/**
	 * ID: 1800414<br>
	 * Message: dAAƑAlB^C㏸B<br>
	 * Message: &#19981;&#35542;&#20107;&#24773;&#12289;&#33288;&#36259;&#12289;&#32887;&#26989;&#12289;&#23478;&#20154;&#21644;&#25088;&#20154;&#26041;&#38754;&#65292;&#30342;&#26371;&#20805;&#28415;&#24184;&#36939;&#12290;<br>
	 * Message: Luck enters into your work, hobby, family and love.
	 */
	public static final NpcStringId LUCK_ENTERS_INTO_YOUR_WORK_HOBBY_FAMILY_AND_LOVE;
	
	/**
	 * ID: 1800415<br>
	 * Message: ƂGȂB<br>
	 * Message: &#33836;&#20107;&#30342;&#26371;&#20056;&#39080;&#30772;&#28010;&#12290;<br>
	 * Message: Whatever you do, it will accompany winning.
	 */
	public static final NpcStringId WHATEVER_YOU_DO_IT_WILL_ACCOMPANY_WINNING;
	
	/**
	 * ID: 1800416<br>
	 * Message: vʂƂ납K`X]荞ށB<br>
	 * Message: &#24847;&#24819;&#19981;&#21040;&#30340;&#36001;&#28304;&#23559;&#26371;&#28414;&#28414;&#32780;&#36914;&#65292;&#19978;&#19978;&#20043;&#25976;&#12290;<br>
	 * Message: It's as good as it gets with unforeseen fortune rolling your way.
	 */
	public static final NpcStringId ITS_AS_GOOD_AS_IT_GETS_WITH_UNFORESEEN_FORTUNE_ROLLING_YOUR_WAY;
	
	/**
	 * ID: 1800417<br>
	 * Message: ~Čli߂ΉB<br>
	 * Message: &#19981;&#39015;&#19968;&#20999;&#36010;&#24515;&#22320;&#24373;&#32645;&#20107;&#24773;&#65292;&#23559;&#26371;&#24471;&#21040;&#24847;&#22806;&#30340;&#32080;&#26524;&#12290;<br>
	 * Message: A greedy act with no prudence will bring a surprise at the end.
	 */
	public static final NpcStringId A_GREEDY_ACT_WITH_NO_PRUDENCE_WILL_BRING_A_SURPRISE_AT_THE_END;
	
	/**
	 * ID: 1800418<br>
	 * Message: ÂɍlāATdɍsB<br>
	 * Message: &#20961;&#20107;&#38920;&#19977;&#24605;&#32780;&#24460;&#34892;&#12290;<br>
	 * Message: Think carefully and act with caution at all times.
	 */
	public static final NpcStringId THINK_CAREFULLY_AND_ACT_WITH_CAUTION_AT_ALL_TIMES;
	
	/**
	 * ID: 1800419<br>
	 * Message: ǂƏF͍BB<br>
	 * Message: &#27193;&#20043;&#28961;&#26681;&#20063;&#65292;&#25104;&#26524;&#19981;&#32046;&#23526;&#12290;<br>
	 * Message: If a tree doesn't have its roots, there will be no fruit.
	 */
	public static final NpcStringId IF_A_TREE_DOESNT_HAVE_ITS_ROOTS_THERE_WILL_BE_NO_FRUIT;
	
	/**
	 * ID: 1800420<br>
	 * Message: ܂葹̂тׂB<br>
	 * Message: &#21482;&#26377;&#21162;&#21147;&#27794;&#26377;&#32080;&#26524;&#12290;<br>
	 * Message: Hard work doesn't bear fruit.
	 */
	public static final NpcStringId HARD_WORK_DOESNT_BEAR_FRUIT;
	
	/**
	 * ID: 1800421<br>
	 * Message: ċꋫɗB<br>
	 * Message: &#29983;&#27963;&#35722;&#24471;&#31384;&#22256;&#65292;&#23559;&#26371;&#36935;&#19978;&#29942;&#38968;&#12290;<br>
	 * Message: Financial difficulties may bring an ordeal.
	 */
	public static final NpcStringId FINANCIAL_DIFFICULTIES_MAY_BRING_AN_ORDEAL;
	
	/**
	 * ID: 1800422<br>
	 * Message: ɐiłƂɋ}u[LB<br>
	 * Message: &#24179;&#24120;&#38918;&#21033;&#30340;&#20107;&#65292;&#32147;&#24120;&#20063;&#26371;&#26377;&#19981;&#22914;&#24847;&#30340;&#26178;&#20505;&#12290;<br>
	 * Message: What used to be well managed may stumble one after another.
	 */
	public static final NpcStringId WHAT_USED_TO_BE_WELL_MANAGED_MAY_STUMBLE_ONE_AFTER_ANOTHER;
	
	/**
	 * ID: 1800423<br>
	 * Message: vقǂ̐ʂ͓ꂸǂB<br>
	 * Message: &#25104;&#26524;&#27794;&#26377;&#38928;&#26009;&#20013;&#30340;&#22909;&#65292;&#23566;&#33268;&#24758;&#24758;&#19981;&#27138;&#12290;<br>
	 * Message: A feeling of frustration may follow disappointment.
	 */
	public static final NpcStringId A_FEELING_OF_FRUSTRATION_MAY_FOLLOW_DISAPPOINTMENT;
	
	/**
	 * ID: 1800424<br>
	 * Message: ̐lXɓU点ΐlԊ֌WɂЂтB<br>
	 * Message: &#22240;&#30130;&#24970;&#32780;&#23565;&#21608;&#22285;&#24773;&#32210;&#21270;&#65292;&#23559;&#23566;&#33268;&#20154;&#38555;&#38364;&#20418;&#27770;&#35010;&#12290;<br>
	 * Message: Be cautioned as unharnessed behavior at difficult times can ruin relationships.
	 */
	public static final NpcStringId BE_CAUTIONED_AS_UNHARNESSED_BEHAVIOR_AT_DIFFICULT_TIMES_CAN_RUIN_RELATIONSHIPS;
	
	/**
	 * ID: 1800425<br>
	 * Message: ~𒣂炸AmB<br>
	 * Message: &#19981;&#23452;&#36942;&#24230;&#36010;&#23146;&#65292;&#23452;&#28858;&#23567;&#20107;&#30693;&#36275;&#65292;&#22521;&#39178;&#27192;&#32032;&#35264;&#24565;&#12290;<br>
	 * Message: Curtail greed and be grateful for small returns as modesty is needed.
	 */
	public static final NpcStringId CURTAIL_GREED_AND_BE_GRATEFUL_FOR_SMALL_RETURNS_AS_MODESTY_IS_NEEDED;
	
	/**
	 * ID: 1800426<br>
	 * Message: lB<br>
	 * Message: &#24471;&#21040;&#20154;&#24515;&#65292;&#21371;&#21448;&#22833;&#21435;&#20154;&#24515;&#12290;<br>
	 * Message: The person that came under your wings will leave.
	 */
	public static final NpcStringId THE_PERSON_THAT_CAME_UNDER_YOUR_WINGS_WILL_LEAVE;
	
	/**
	 * ID: 1800427<br>
	 * Message: lԊ֌WɋCgΊFǂȂAB<br>
	 * Message: &#24453;&#20154;&#24544;&#21402;&#65292;&#19981;&#35542;&#23565;&#21516;&#20107;&#25110;&#33836;&#20107;&#65292;&#30342;&#22823;&#27489;&#21916;&#20043;&#25976;&#12290;<br>
	 * Message: Your work and relationship with colleagues will be well managed if you maintain your devotion.
	 */
	public static final NpcStringId YOUR_WORK_AND_RELATIONSHIP_WITH_COLLEAGUES_WILL_BE_WELL_MANAGED_IF_YOU_MAINTAIN_YOUR_DEVOTION;
	
	/**
	 * ID: 1800428<br>
	 * Message: ltŗQ֌W΂lėVȂ΁AA@ĐM͒nɗB<br>
	 * Message: &#33509;&#24453;&#20154;&#36942;&#24230;&#35336;&#36611;&#21033;&#23475;&#38364;&#20418;&#19988;&#27794;&#39080;&#24230;&#65292;&#20415;&#26371;&#36973;&#21475;&#33292;&#20043;&#28797;&#65292;&#20006;&#25153;&#20302;&#33258;&#24049;&#30340;&#20729;&#20540;&#12290;<br>
	 * Message: Calculating your profit in relationships without displaying any courteous manners will bring malicious gossip and ruin your value.
	 */
	public static final NpcStringId CALCULATING_YOUR_PROFIT_IN_RELATIONSHIPS_WITHOUT_DISPLAYING_ANY_COURTEOUS_MANNERS_WILL_BRING_MALICIOUS_GOSSIP_AND_RUIN_YOUR_VALUE;
	
	/**
	 * ID: 1800429<br>
	 * Message: ɑ̗ɗčlāA^SŐڂB<br>
	 * Message: &#34389;&#34389;&#26367;&#20182;&#20154;&#33879;&#24819;&#65292;&#20197;&#30495;&#24515;&#23565;&#24453;&#12290;<br>
	 * Message: Consider other's situations and treat them sincerely at all times.
	 */
	public static final NpcStringId CONSIDER_OTHERS_SITUATIONS_AND_TREAT_THEM_SINCERELY_AT_ALL_TIMES;
	
	/**
	 * ID: 1800430<br>
	 * Message: ْȁB<br>
	 * Message: &#19981;&#24471;&#25918;&#39686;&#12290;<br>
	 * Message: Do not loosen up with your precautions.
	 */
	public static final NpcStringId DO_NOT_LOOSEN_UP_WITH_YOUR_PRECAUTIONS;
	
	/**
	 * ID: 1800431<br>
	 * Message: ƒfŎi߂ΎsB̌ƂɎXB<br>
	 * Message: &#25797;&#33258;&#34389;&#29702;&#20107;&#24773;&#23559;&#26371;&#25307;&#20358;&#22833;&#25943;&#65292;&#31309;&#26997;&#25910;&#25986;&#21608;&#22285;&#30340;&#24847;&#35211;&#12290;<br>
	 * Message: Reflect other's opinions as a mistake always lies ahead of an arbitrary decision.
	 */
	public static final NpcStringId REFLECT_OTHERS_OPINIONS_AS_A_MISTAKE_ALWAYS_LIES_AHEAD_OF_AN_ARBITRARY_DECISION;
	
	/**
	 * ID: 1800432<br>
	 * Message: 炭ǰʂB<br>
	 * Message: &#30475;&#19981;&#35211;&#21069;&#26041;&#30340;&#30450;&#20154;&#65292;&#23559;&#30452;&#25509;&#36914;&#38272;&#12290;<br>
	 * Message: A blind man goes right through the door.
	 */
	public static final NpcStringId A_BLIND_MAN_GOES_RIGHT_THROUGH_THE_DOOR;
	
	/**
	 * ID: 1800433<br>
	 * Message: d̃S[ǂB<br>
	 * Message: &#20107;&#24773;&#33579;&#28982;&#28961;&#30693;&#65292;&#23559;&#26371;&#24758;&#24758;&#19981;&#27138;&#12290;<br>
	 * Message: A heart falls into hopelessness as things are in disarray.
	 */
	public static final NpcStringId A_HEART_FALLS_INTO_HOPELESSNESS_AS_THINGS_ARE_IN_DISARRAY;
	
	/**
	 * ID: 1800434<br>
	 * Message: {肵ĂǂB<br>
	 * Message: &#36914;&#34892;&#20013;&#30340;&#20107;&#24773;&#38519;&#20837;&#35598;&#24213;&#65292;&#23559;&#26371;&#24863;&#21040;&#39729;&#24758;&#12290;<br>
	 * Message: Hopelessness may fill your heart as your work falls into a maze.
	 */
	public static final NpcStringId HOPELESSNESS_MAY_FILL_YOUR_HEART_AS_YOUR_WORK_FALLS_INTO_A_MAZE;
	
	/**
	 * ID: 1800435<br>
	 * Message: ꏊŎɂĂ̂ɖɂԂB<br>
	 * Message: &#38614;&#28982;&#20840;&#21147;&#20197;&#36212;&#65292;&#20294;&#21371;&#22240;&#24847;&#24819;&#19981;&#21040;&#30340;&#21839;&#38988;&#32780;&#36935;&#19978;&#29942;&#38968;&#12290;<br>
	 * Message: Difficulties lie ahead of an unforeseen problem even with your hard work.
	 */
	public static final NpcStringId DIFFICULTIES_LIE_AHEAD_OF_AN_UNFORESEEN_PROBLEM_EVEN_WITH_YOUR_HARD_WORK;
	
	/**
	 * ID: 1800436<br>
	 * Message: ɎMAl𗊂ɂȂB<br>
	 * Message: &#33836;&#20107;&#22833;&#21435;&#33258;&#20449;&#65292;&#21521;&#20182;&#20154;&#27714;&#21161;&#30340;&#20107;&#24773;&#20063;&#26371;&#38568;&#20043;&#22686;&#21152;&#12290;<br>
	 * Message: There may be more occasions you will want to ask favors from others as you lose confidence in you.
	 */
	public static final NpcStringId THERE_MAY_BE_MORE_OCCASIONS_YOU_WILL_WANT_TO_ASK_FAVORS_FROM_OTHERS_AS_YOU_LOSE_CONFIDENCE_IN_YOU;
	
	/**
	 * ID: 1800437<br>
	 * Message: ɓI߂Ă͔W͖]߂ȂBMɏ]B<br>
	 * Message: &#28040;&#26997;&#34892;&#20107;&#65292;&#21063;&#28961;&#27861;&#33258;&#25105;&#30332;&#23637;&#65292;&#38920;&#20197;&#20449;&#24565;&#34892;&#20107;&#12290;<br>
	 * Message: Be brave and ambitious as no bird can fly into the sky by staying in their nest.
	 */
	public static final NpcStringId BE_BRAVE_AND_AMBITIOUS_AS_NO_BIRD_CAN_FLY_INTO_THE_SKY_BY_STAYING_IN_THEIR_NEST;
	
	/**
	 * ID: 1800438<br>
	 * Message: sȂƂɂ͎ȁBM̒ulTB<br>
	 * Message: &#19981;&#26126;&#30906;&#30340;&#20107;&#24773;&#30433;&#37327;&#21029;&#20570;&#65292;&#20197;&#23563;&#25214;&#20540;&#24471;&#20449;&#36084;&#30340;&#20154;&#28858;&#37325;&#12290;<br>
	 * Message: It's a good idea not to start an unclear task and always look for someone you can trust and rely upon.
	 */
	public static final NpcStringId ITS_A_GOOD_IDEA_NOT_TO_START_AN_UNCLEAR_TASK_AND_ALWAYS_LOOK_FOR_SOMEONE_YOU_CAN_TRUST_AND_RELY_UPON;
	
	/**
	 * ID: 1800439<br>
	 * Message: ɏオ͓̂悤B<br>
	 * Message: &#32769;&#40441;&#28961;&#21033;&#29226;&#65292;&#29417;&#29557;&#19981;&#38918;&#21033;&#12290;<br>
	 * Message: Hunting won't be successful as the falcon lacks its claws.
	 */
	public static final NpcStringId HUNTING_WONT_BE_SUCCESSFUL_AS_THE_FALCON_LACKS_ITS_CLAWS;
	
	/**
	 * ID: 1800440<br>
	 * Message: 邱ƂȂƂ܂ȂB<br>
	 * Message: &#26399;&#30460;&#30340;&#20107;&#24773;&#19981;&#22826;&#38918;&#21033;&#20043;&#25976;&#12290;<br>
	 * Message: A prepared plan won't move smoothly.
	 */
	public static final NpcStringId A_PREPARED_PLAN_WONT_MOVE_SMOOTHLY;
	
	/**
	 * ID: 1800441<br>
	 * Message: ߐMė~΁A܂͂̂ƂsB<br>
	 * Message: &#22240;&#36942;&#24230;&#33258;&#20449;&#32780;&#36010;&#26044;&#24037;&#20316;&#65292;&#21453;&#32780;&#24324;&#24039;&#25104;&#25305;&#65292;&#38920;&#35641;&#24910;&#12290;<br>
	 * Message: An easy task may fail if one is consumed by greed and overconfidence.
	 */
	public static final NpcStringId AN_EASY_TASK_MAY_FAIL_IF_ONE_IS_CONSUMED_BY_GREED_AND_OVERCONFIDENCE;
	
	/**
	 * ID: 1800442<br>
	 * Message: sȏ󋵂ŏőɎB<br>
	 * Message: &#21608;&#22285;&#30340;&#29376;&#27841;&#23565;&#33258;&#24049;&#19981;&#21033;&#65292;&#22240;&#32780;&#26371;&#25805;&#20043;&#36942;&#24613;&#12290;<br>
	 * Message: Impatience may lie ahead as the situation is unfavorable.
	 */
	public static final NpcStringId IMPATIENCE_MAY_LIE_AHEAD_AS_THE_SITUATION_IS_UNFAVORABLE;
	
	/**
	 * ID: 1800443<br>
	 * Message: ڂɑȂ悤ɐʂڂāB<br>
	 * Message: &#26368;&#22909;&#20855;&#20633;&#19968;&#19979;&#33021;&#22816;&#38928;&#38450;&#22750;&#20107;&#30332;&#29983;&#30340;&#33021;&#21147;&#12290;<br>
	 * Message: Thoughtful foresight is needed before a disaster may fall upon you.
	 */
	public static final NpcStringId THOUGHTFUL_FORESIGHT_IS_NEEDED_BEFORE_A_DISASTER_MAY_FALL_UPON_YOU;
	
	/**
	 * ID: 1800444<br>
	 * Message: ƒfIȍsT߁BF̐S߂B<br>
	 * Message: &#35641;&#24910;&#25105;&#34892;&#25105;&#32032;&#30340;&#34892;&#28858;&#65292;&#38920;&#20197;&#28331;&#26262;&#23433;&#25771;&#21608;&#22285;&#30340;&#24515;&#12290;<br>
	 * Message: Refrain from dictatorial acts as caring for others around you with dignity is much needed.
	 */
	public static final NpcStringId REFRAIN_FROM_DICTATORIAL_ACTS_AS_CARING_FOR_OTHERS_AROUND_YOU_WITH_DIGNITY_IS_MUCH_NEEDED;
	
	/**
	 * ID: 1800445<br>
	 * Message: 炭炷B<br>
	 * Message: &#36942;&#26044;&#35079;&#38620;&#32780;&#24456;&#22909;&#12290;<br>
	 * Message: Things are messy with no good sign.
	 */
	public static final NpcStringId THINGS_ARE_MESSY_WITH_NO_GOOD_SIGN;
	
	/**
	 * ID: 1800446<br>
	 * Message: 悩ʂƂNāAꋫɗB<br>
	 * Message: &#19981;&#22909;&#30340;&#20107;&#24773;&#23559;&#26371;&#30332;&#29983;&#65292;&#34389;&#26044;&#22256;&#22659;&#20043;&#25976;&#12290;<br>
	 * Message: You may fall into a vexing situation as bad circumstances will arise.
	 */
	public static final NpcStringId YOU_MAY_FALL_INTO_A_VEXING_SITUATION_AS_BAD_CIRCUMSTANCES_WILL_ARISE;
	
	/**
	 * ID: 1800447<br>
	 * Message: lԊ֌WɂЂтB<br>
	 * Message: &#23559;&#30332;&#29983;&#20154;&#38555;&#38364;&#20418;&#33067;&#31680;&#30340;&#29376;&#27841;&#12290;<br>
	 * Message: Relationships with people may be contrary to your expectations.
	 */
	public static final NpcStringId RELATIONSHIPS_WITH_PEOPLE_MAY_BE_CONTRARY_TO_YOUR_EXPECTATIONS;
	
	/**
	 * ID: 1800448<br>
	 * Message: 菈͏ł͂ȂA{̌B<br>
	 * Message: &#23601;&#31639;&#36914;&#34892;&#30340;&#20107;&#24773;&#30332;&#29983;&#21839;&#38988;&#65292;&#20134;&#21247;&#25505;&#29992;&#27402;&#23452;&#20043;&#35336;&#65292;&#38920;&#24478;&#21839;&#38988;&#30340;&#26681;&#26412;&#24930;&#24930;&#29702;&#28165;&#12290;<br>
	 * Message: Do not seek a quick fix as the problem needs a fundamental resolution.
	 */
	public static final NpcStringId DO_NOT_SEEK_A_QUICK_FIX_AS_THE_PROBLEM_NEEDS_A_FUNDAMENTAL_RESOLUTION;
	
	/**
	 * ID: 1800449<br>
	 * Message: }ĐS𕽉ɕۂāB<br>
	 * Message: &#20811;&#21046;&#24773;&#32210;&#34920;&#36948;&#65292;&#38920;&#25265;&#20197;&#24179;&#24120;&#24515;&#12290;<br>
	 * Message: Seek peace in your heart as vulgar display of your emotions may harm you.
	 */
	public static final NpcStringId SEEK_PEACE_IN_YOUR_HEART_AS_VULGAR_DISPLAY_OF_YOUR_EMOTIONS_MAY_HARM_YOU;
	
	/**
	 * ID: 1800450<br>
	 * Message: Θb͐ւ̋ߓB<br>
	 * Message: &#33287;&#21608;&#37002;&#20154;&#22810;&#22810;&#20132;&#35527;&#65292;&#20415;&#33021;&#24471;&#21040;&#25104;&#21151;&#30340;&#24773;&#22577;&#12290;<br>
	 * Message: Information for success may come from the conversations with people around you.
	 */
	public static final NpcStringId INFORMATION_FOR_SUCCESS_MAY_COME_FROM_THE_CONVERSATIONS_WITH_PEOPLE_AROUND_YOU;
	
	/**
	 * ID: 1800451<br>
	 * Message: AMāB<br>
	 * Message: &#33836;&#20107;&#25265;&#20197;&#20449;&#24515;&#65292;&#20877;&#20184;&#35576;&#26044;&#34892;&#21205;&#12290;<br>
	 * Message: Be confident and act reliantly at all times.
	 */
	public static final NpcStringId BE_CONFIDENT_AND_ACT_RELIANTLY_AT_ALL_TIMES;
	
	/**
	 * ID: 1800452<br>
	 * Message: Iڂ݁B<br>
	 * Message: &#23567;&#23401;&#24471;&#21040;&#23542;&#35997;&#12290;<br>
	 * Message: A child gets a treasure.
	 */
	public static final NpcStringId A_CHILD_GETS_A_TREASURE;
	
	/**
	 * ID: 1800453<br>
	 * Message: ȂڂɋKƃ`XB<br>
	 * Message: &#22914;&#21516;&#23567;&#23567;&#24180;&#32000;&#29554;&#24471;&#22823;&#36001;&#23500;&#65292;&#22312;&#24847;&#24819;&#19981;&#21040;&#30340;&#22320;&#26041;&#23559;&#29554;&#24471;&#37666;&#36001;&#21644;&#22909;&#27231;&#26371;&#20043;&#25976;&#12290;<br>
	 * Message: Good fortune and opportunity may lie ahead as if one's born in a golden spoon.
	 */
	public static final NpcStringId GOOD_FORTUNE_AND_OPPORTUNITY_MAY_LIE_AHEAD_AS_IF_ONES_BORN_IN_A_GOLDEN_SPOON;
	
	/**
	 * ID: 1800454<br>
	 * Message: ͏B\ʋKƐʂɂB<br>
	 * Message: &#26085;&#24120;&#29983;&#27963;&#38918;&#21033;&#65292;&#32780;&#19988;&#26371;&#24471;&#21040;&#24847;&#22806;&#20043;&#36001;&#21644;&#25104;&#26524;&#12290;<br>
	 * Message: Your life flows as if it's on a silk surface and unexpected fortune and success may come to you.
	 */
	public static final NpcStringId YOUR_LIFE_FLOWS_AS_IF_ITS_ON_A_SILK_SURFACE_AND_UNEXPECTED_FORTUNE_AND_SUCCESS_MAY_COME_TO_YOU;
	
	/**
	 * ID: 1800455<br>
	 * Message: GɈB΂炭̊Ԃ͉^Ɍb܂B<br>
	 * Message: &#19981;&#32147;&#21162;&#21147;&#20063;&#21487;&#24471;&#21040;&#26283;&#26178;&#24615;&#30340;&#24184;&#36939;&#12290;<br>
	 * Message: Temporary luck may come to you with no effort.
	 */
	public static final NpcStringId TEMPORARY_LUCK_MAY_COME_TO_YOU_WITH_NO_EFFORT;
	
	/**
	 * ID: 1800456<br>
	 * Message: v͒ɁAs͂΂₭B<br>
	 * Message: &#35469;&#30495;&#24314;&#31435;&#35336;&#30059;&#65292;&#20294;&#30433;&#36895;&#20184;&#35576;&#26044;&#34892;&#21205;&#12290;<br>
	 * Message: Plan ahead with patience but execute with swiftness.
	 */
	public static final NpcStringId PLAN_AHEAD_WITH_PATIENCE_BUT_EXECUTE_WITH_SWIFTNESS;
	
	/**
	 * ID: 1800457<br>
	 * Message: ȌׂĒBʂ͂Ȃ̉l߂B<br>
	 * Message: &#23559;&#26371;&#25913;&#21892;&#23567;&#23567;&#30340;&#32570;&#38519;&#65292;&#20006;&#29992;&#35264;&#28204;&#21644;&#20998;&#26512;&#26410;&#20358;&#30340;&#33021;&#21147;&#25552;&#39640;&#33258;&#24049;&#30340;&#20729;&#20540;&#12290;<br>
	 * Message: The abilities to amend, foresee and analyze may raise your value.
	 */
	public static final NpcStringId THE_ABILITIES_TO_AMEND_FORESEE_AND_ANALYZE_MAY_RAISE_YOUR_VALUE;
	
	/**
	 * ID: 1800458<br>
	 * Message: ߂Ȃ݂Ȃ΁AɕȂقǂ̑厸sB<br>
	 * Message: &#33509;&#23559;&#33258;&#24049;&#30340;&#36942;&#22833;&#21512;&#29702;&#21270;&#65292;&#20415;&#26371;&#29359;&#19979;&#28961;&#21487;&#25405;&#22238;&#30340;&#26356;&#22823;&#30340;&#37679;&#35492;&#12290;<br>
	 * Message: Bigger mistakes will be on the road if you fail to correct a small mistake.
	 */
	public static final NpcStringId BIGGER_MISTAKES_WILL_BE_ON_THE_ROAD_IF_YOU_FAIL_TO_CORRECT_A_SMALL_MISTAKE;
	
	/**
	 * ID: 1800459<br>
	 * Message: \O̔o͔Ɏ󂯓B<br>
	 * Message: &#19981;&#35201;&#36852;&#36991;&#24847;&#22806;&#30340;&#30332;&#29694;&#25110;&#26032;&#30340;&#32147;&#39511;&#65292;&#20760;&#31649;&#25509;&#21463;&#21543;&#12290;<br>
	 * Message: Don't be evasive to accept new findings or experiences.
	 */
	public static final NpcStringId DONT_BE_EVASIVE_TO_ACCEPT_NEW_FINDINGS_OR_EXPERIENCES;
	
	/**
	 * ID: 1800460<br>
	 * Message: vƂɂȂȂĂAȁB<br>
	 * Message: &#21363;&#20351;&#20107;&#24773;&#19981;&#22914;&#35336;&#30059;&#65292;&#20063;&#19981;&#35201;&#33879;&#24613;&#12290;<br>
	 * Message: Don't be irritated as the situations don't move as planned.
	 */
	public static final NpcStringId DONT_BE_IRRITATED_AS_THE_SITUATIONS_DONT_MOVE_AS_PLANNED;
	
	/**
	 * ID: 1800461<br>
	 * Message: mɈӎuƁBȂ΁AɗB<br>
	 * Message: &#22914;&#26524;&#19981;&#26126;&#30906;&#30340;&#34920;&#36948;&#24847;&#24605;&#65292;&#20415;&#26371;&#23481;&#26131;&#34987;&#21608;&#22285;&#20107;&#29289;&#25152;&#29309;&#36899;&#65292;&#38920;&#35641;&#24910;&#12290;<br>
	 * Message: Be warned as you may be overwhelmed by surroundings if you lack a clear opinion.
	 */
	public static final NpcStringId BE_WARNED_AS_YOU_MAY_BE_OVERWHELMED_BY_SURROUNDINGS_IF_YOU_LACK_A_CLEAR_OPINION;
	
	/**
	 * ID: 1800462<br>
	 * Message: ڂ͒ĂĂS͋сB<br>
	 * Message: &#23601;&#31639;&#19968;&#28961;&#25152;&#26377;&#65292;&#20063;&#21487;&#35920;&#34915;&#36275;&#39135;&#22320;&#36942;&#27963;&#12290;<br>
	 * Message: You may live an affluent life even without possessions.
	 */
	public static final NpcStringId YOU_MAY_LIVE_AN_AFFLUENT_LIFE_EVEN_WITHOUT_POSSESSIONS;
	
	/**
	 * ID: 1800463<br>
	 * Message: ̖ɎɂŐlBl]B<br>
	 * Message: &#29992;&#36763;&#33510;&#36090;&#20358;&#30340;&#37666;&#24171;&#21161;&#20182;&#20154;&#65292;&#22240;&#27492;&#21487;&#20197;&#24471;&#21040;&#20154;&#20154;&#30340;&#24859;&#25140;&#12290;<br>
	 * Message: You will gain popularity as you help people with money you earnestly earned.
	 */
	public static final NpcStringId YOU_WILL_GAIN_POPULARITY_AS_YOU_HELP_PEOPLE_WITH_MONEY_YOU_EARNESTLY_EARNED;
	
	/**
	 * ID: 1800464<br>
	 * Message: ŜyXB<br>
	 * Message: &#36523;&#24515;&#29554;&#24471;&#24179;&#23433;&#12290;<br>
	 * Message: Your heart and body may be in health.
	 */
	public static final NpcStringId YOUR_HEART_AND_BODY_MAY_BE_IN_HEALTH;
	
	/**
	 * ID: 1800465<br>
	 * Message: ځ[ƂĂ邤ɖ]܂ʕɐiށB<br>
	 * Message: &#20809;&#26159;&#30332;&#21574;&#65292;&#21482;&#26371;&#24341;&#21521;&#33258;&#24049;&#19981;&#39000;&#24847;&#38754;&#23565;&#30340;&#29376;&#27841;&#12290;<br>
	 * Message: Be warned as you may be dragged to an unwanted direction if not cautious.
	 */
	public static final NpcStringId BE_WARNED_AS_YOU_MAY_BE_DRAGGED_TO_AN_UNWANTED_DIRECTION_IF_NOT_CAUTIOUS;
	
	/**
	 * ID: 1800466<br>
	 * Message: VɐlɉĂAlɂ͂ȂȂ߂荇ȂB<br>
	 * Message: &#33021;&#22816;&#36935;&#35211;&#24456;&#22810;&#26032;&#20154;&#65292;&#20294;&#19981;&#26131;&#25214;&#21040;&#21512;&#20320;&#24515;&#24847;&#30340;&#20154;&#12290;<br>
	 * Message: You may meet many new people but it will be difficult to find a perfect person who wins your heart.
	 */
	public static final NpcStringId YOU_MAY_MEET_MANY_NEW_PEOPLE_BUT_IT_WILL_BE_DIFFICULT_TO_FIND_A_PERFECT_PERSON_WHO_WINS_YOUR_HEART;
	
	/**
	 * ID: 1800467<br>
	 * Message: 肩Ȃ߂B<br>
	 * Message: &#23559;&#30332;&#29983;&#19968;&#20123;&#21521;&#21608;&#22285;&#24471;&#21040;&#23433;&#24944;&#30340;&#20107;&#24773;&#12290;<br>
	 * Message: There may be an occasion where you are consoled by people.
	 */
	public static final NpcStringId THERE_MAY_BE_AN_OCCASION_WHERE_YOU_ARE_CONSOLED_BY_PEOPLE;
	
	/**
	 * ID: 1800468<br>
	 * Message: 邢B͕ω̎łȂB<br>
	 * Message: &#21363;&#20351;&#26085;&#24120;&#29983;&#27963;&#24863;&#21040;&#21421;&#29033;&#65292;&#20294;&#29694;&#22312;&#19981;&#36969;&#21512;&#31361;&#22914;&#20854;&#20358;&#30340;&#35722;&#21270;&#12290;<br>
	 * Message: It may not be a good time for a change even if there's tedium in daily life.
	 */
	public static final NpcStringId IT_MAY_NOT_BE_A_GOOD_TIME_FOR_A_CHANGE_EVEN_IF_THERES_TEDIUM_IN_DAILY_LIFE;
	
	/**
	 * ID: 1800469<br>
	 * Message: gƂ͖̂߂̓B<br>
	 * Message: &#28858;&#33258;&#24049;&#25152;&#33457;&#30340;&#37666;&#65292;&#23559;&#26371;&#35722;&#25104;&#21478;&#19968;&#31278;&#25237;&#36039;&#20877;&#22238;&#21040;&#33258;&#24049;&#30340;&#25163;&#20013;&#12290;<br>
	 * Message: The money you spend for yourself may act as an investment and bring you a return.
	 */
	public static final NpcStringId THE_MONEY_YOU_SPEND_FOR_YOURSELF_MAY_ACT_AS_AN_INVESTMENT_AND_BRING_YOU_A_RETURN;
	
	/**
	 * ID: 1800470<br>
	 * Message: l̂߂ɂgĂǂԂɎ̂Ă̂ƓBlɒӂB<br>
	 * Message: &#28858;&#20182;&#20154;&#25152;&#33457;&#30340;&#37666;&#21482;&#26371;&#28040;&#22833;&#32780;&#39131;&#65292;&#23567;&#24515;&#21247;&#28651;&#29992;&#22312;&#20182;&#20154;&#36523;&#19978;&#12290;<br>
	 * Message: The money you spend for others will be wasted so be cautious.
	 */
	public static final NpcStringId THE_MONEY_YOU_SPEND_FOR_OTHERS_WILL_BE_WASTED_SO_BE_CAUTIOUS;
	
	/**
	 * ID: 1800471<br>
	 * Message: QɒӁB<br>
	 * Message: &#23559;&#26371;&#26377;&#19981;&#24517;&#35201;&#30340;&#25903;&#20986;&#65292;&#38920;&#35641;&#24910;&#12290;<br>
	 * Message: Be warned so as not to have unnecessary expenses.
	 */
	public static final NpcStringId BE_WARNED_SO_AS_NOT_TO_HAVE_UNNECESSARY_EXPENSES;
	
	/**
	 * ID: 1800472<br>
	 * Message: iiv[gCxgɎQB哖̗\B<br>
	 * Message: &#26377;&#27243;&#36001;&#36939;&#65292;&#21443;&#21152;&#30475;&#30475;&#36104;&#29518;&#20043;&#39006;&#30340;&#27963;&#21205;&#12290;<br>
	 * Message: Your star indicated such good luck, participate in bonus giveaways or events.
	 */
	public static final NpcStringId YOUR_STAR_INDICATED_SUCH_GOOD_LUCK_PARTICIPATE_IN_BONUS_GIVEAWAYS_OR_EVENTS;
	
	/**
	 * ID: 1800473<br>
	 * Message: RK^ށB<br>
	 * Message: &#22312;&#20598;&#28982;&#30340;&#27231;&#26371;&#19979;&#21487;&#20197;&#29554;&#24471;&#22909;&#36939;&#12290;<br>
	 * Message: You may grab unexpected luck.
	 */
	public static final NpcStringId YOU_MAY_GRAB_UNEXPECTED_LUCK;
	
	/**
	 * ID: 1800474<br>
	 * Message: ҂lB<br>
	 * Message: &#24515;&#20736;&#30340;&#20154;&#65292;&#33258;&#28982;&#26371;&#20027;&#21205;&#22320;&#20358;&#25509;&#36817;&#20320;&#12290;<br>
	 * Message: The person in your heart may naturally come to you.
	 */
	public static final NpcStringId THE_PERSON_IN_YOUR_HEART_MAY_NATURALLY_COME_TO_YOU;
	
	/**
	 * ID: 1800475<br>
	 * Message: l̕]ȂǋCɂɃ}Cy[Xێ΂ʂB<br>
	 * Message: &#21029;&#22312;&#24847;&#20182;&#20154;&#30340;&#35413;&#20729;&#65292;&#32173;&#25345;&#33258;&#24049;&#30340;&#34892;&#28858;&#27169;&#24335;&#65292;&#20415;&#26371;&#24471;&#21040;&#22909;&#32080;&#26524;&#12290;<br>
	 * Message: There will be a good result if you keep your own pace regardless of others' judgment.
	 */
	public static final NpcStringId THERE_WILL_BE_A_GOOD_RESULT_IF_YOU_KEEP_YOUR_OWN_PACE_REGARDLESS_OF_OTHERS_JUDGMENT;
	
	/**
	 * ID: 1800476<br>
	 * Message: \zO̍K^łAЂŐAɋABӂB<br>
	 * Message: &#31361;&#22914;&#20854;&#20358;&#30340;&#24184;&#36939;&#65292;&#26371;&#22240;&#28858;&#22833;&#35328;&#32780;&#36960;&#36208;&#39640;&#39131;&#65292;&#38920;&#35641;&#24910;&#12290;<br>
	 * Message: Be warned as unexpected luck may be wasted with your reckless comments.
	 */
	public static final NpcStringId BE_WARNED_AS_UNEXPECTED_LUCK_MAY_BE_WASTED_WITH_YOUR_RECKLESS_COMMENTS;
	
	/**
	 * ID: 1800477<br>
	 * Message: ŉ΂ɓĂ̒BߐM͋֕B<br>
	 * Message: &#36942;&#20998;&#33258;&#20449;&#32780;&#22909;&#39640;&#40361;&#36960;&#65292;&#23559;&#26371;&#36973;&#21040;&#29436;&#29437;&#19981;&#22570;&#30340;&#19979;&#22580;&#12290;<br>
	 * Message: Overconfidence will convince you to carry a task above your reach and there will be consequences.
	 */
	public static final NpcStringId OVERCONFIDENCE_WILL_CONVINCE_YOU_TO_CARRY_A_TASK_ABOVE_YOUR_REACH_AND_THERE_WILL_BE_CONSEQUENCES;
	
	/**
	 * ID: 1800478<br>
	 * Message: dvȔf͌ɂB<br>
	 * Message: &#33509;&#38656;&#23450;&#19979;&#37325;&#35201;&#30340;&#27770;&#31574;&#65292;&#36996;&#26159;&#31245;&#24494;&#24310;&#24460;&#19968;&#19979;&#28858;&#22937;&#12290;<br>
	 * Message: Momentarily delay an important decision.
	 */
	public static final NpcStringId MOMENTARILY_DELAY_AN_IMPORTANT_DECISION;
	
	/**
	 * ID: 1800479<br>
	 * Message: ڏ̐l⒇Ԃ̌tŃguB<br>
	 * Message: &#23559;&#26371;&#33287;&#38263;&#36649;&#25110;&#29087;&#20154;&#30332;&#29983;&#21475;&#35282;&#12290;<br>
	 * Message: Trouble spots lie ahead when talking to superiors or people close to you.
	 */
	public static final NpcStringId TROUBLE_SPOTS_LIE_AHEAD_WHEN_TALKING_TO_SUPERIORS_OR_PEOPLE_CLOSE_TO_YOU;
	
	/**
	 * ID: 1800480<br>
	 * Message: tő菝ꂽ肷B<br>
	 * Message: &#26371;&#29992;&#35328;&#35486;&#20358;&#20663;&#20154;&#25110;&#20663;&#21040;&#33258;&#24049;&#65292;&#38920;&#35641;&#24910;&#12290;<br>
	 * Message: Be warned as your words can hurt others or others' words can hurt you.
	 */
	public static final NpcStringId BE_WARNED_AS_YOUR_WORDS_CAN_HURT_OTHERS_OR_OTHERS_WORDS_CAN_HURT_YOU;
	
	/**
	 * ID: 1800481<br>
	 * Message: rbO}EX͘Q̂ƁB<br>
	 * Message: &#25918;&#22823;&#35441;&#20043;&#24460;&#65292;&#21487;&#33021;&#38656;&#35201;&#28858;&#35299;&#27770;&#27492;&#20107;&#32780;&#25487;&#33136;&#21253;&#65292;&#38920;&#35641;&#24910;&#12290;<br>
	 * Message: Make a loud boast and you may have to pay to cover unnecessary expenses.
	 */
	public static final NpcStringId MAKE_A_LOUD_BOAST_AND_YOU_MAY_HAVE_TO_PAY_TO_COVER_UNNECESSARY_EXPENSES;
	
	/**
	 * ID: 1800482<br>
	 * Message: 邪A܂킹BȂΑ化܂ɂȂB<br>
	 * Message: &#33509;&#19981;&#27231;&#20278;&#22320;&#36852;&#36991;&#25214;&#40635;&#29033;&#30340;&#20154;&#65292;&#23559;&#26371;&#23566;&#33268;&#22823;&#21557;&#26550;&#65292;&#38656;&#35201;&#29305;&#21029;&#35641;&#24910;&#12290;<br>
	 * Message: Skillful evasion is needed when dealing with people who pick fights as a disaster may arise from it.
	 */
	public static final NpcStringId SKILLFUL_EVASION_IS_NEEDED_WHEN_DEALING_WITH_PEOPLE_WHO_PICK_FIGHTS_AS_A_DISASTER_MAY_ARISE_FROM_IT;
	
	/**
	 * ID: 1800483<br>
	 * Message: Ȏ咣̂Ŕ𔃂B<br>
	 * Message: &#36942;&#24375;&#30340;&#20027;&#24373;&#26371;&#35731;&#20182;&#20154;&#24341;&#36215;&#21453;&#24863;&#65292;&#38920;&#25918;&#20302;&#32882;&#38899;&#12290;<br>
	 * Message: Keep a low profile as too strong an opinion will attract adverse reactions.
	 */
	public static final NpcStringId KEEP_A_LOW_PROFILE_AS_TOO_STRONG_AN_OPINION_WILL_ATTRACT_ADVERSE_REACTIONS;
	
	/**
	 * ID: 1800484<br>
	 * Message: Aʂ悤A𔃂sT߁B<br>
	 * Message: &#23559;&#26371;&#36973;&#21475;&#33292;&#20043;&#28797;&#65292;&#33509;&#19981;&#26159;&#38750;&#20570;&#19981;&#21487;&#65292;&#20999;&#21247;&#20570;&#20123;&#24341;&#36215;&#20182;&#20154;&#35492;&#26371;&#30340;&#20107;&#12290;<br>
	 * Message: Do not unnecessarily provoke misunderstanding as you may be involved in malicious gossip.
	 */
	public static final NpcStringId DO_NOT_UNNECESSARILY_PROVOKE_MISUNDERSTANDING_AS_YOU_MAY_BE_INVOLVED_IN_MALICIOUS_GOSSIP;
	
	/**
	 * ID: 1800485<br>
	 * Message: ɒӁB<br>
	 * Message: &#25110;&#35377;&#26371;&#36986;&#22833;&#26576;&#20123;&#26481;&#35199;&#65292;&#23567;&#24515;&#20445;&#31649;&#20197;&#20813;&#36986;&#22833;&#12290;<br>
	 * Message: Check your belongings as you may lose what you possess.
	 */
	public static final NpcStringId CHECK_YOUR_BELONGINGS_AS_YOU_MAY_LOSE_WHAT_YOU_POSSESS;
	
	/**
	 * ID: 1800486<br>
	 * Message: ɘbɂ͂ÂāB<br>
	 * Message: &#35201;&#25026;&#24471;&#38568;&#32882;&#38468;&#21644;&#23565;&#26041;&#12290;<br>
	 * Message: Be flexible enough to play up to others.
	 */
	public static final NpcStringId BE_FLEXIBLE_ENOUGH_TO_PLAY_UP_TO_OTHERS;
	
	/**
	 * ID: 1800487<br>
	 * Message: lԊ֌WBT߁B<br>
	 * Message: &#20154;&#38555;&#38364;&#20418;&#21487;&#33021;&#26371;&#36935;&#19978;&#29942;&#38968;&#65292;&#38920;&#29305;&#21029;&#30041;&#24847;&#33287;&#20182;&#20154;&#20043;&#38291;&#30340;&#30456;&#26371;&#25110;&#20132;&#35527;&#12290;<br>
	 * Message: Pay special attention when meeting or talking to people as relationships may go amiss.
	 */
	public static final NpcStringId PAY_SPECIAL_ATTENTION_WHEN_MEETING_OR_TALKING_TO_PEOPLE_AS_RELATIONSHIPS_MAY_GO_AMISS;
	
	/**
	 * ID: 1800488<br>
	 * Message: dvȌ̏uԁBlڂCɂAvʂɐi߂BACǂ߁B<br>
	 * Message: &#33509;&#38754;&#33256;&#38656;&#35201;&#23450;&#19979;&#37325;&#35201;&#27770;&#31574;&#30340;&#26178;&#20505;&#65292;&#21029;&#22312;&#24847;&#20182;&#20154;&#30340;&#30475;&#27861;&#65292;&#23452;&#27491;&#30906;&#25484;&#25569;&#33258;&#24049;&#30340;&#24847;&#39000;&#20358;&#20570;&#27770;&#23450;&#12290;<br>
	 * Message: When the important moment arrives, decide upon what you truly want without measuring others' judgment.
	 */
	public static final NpcStringId WHEN_THE_IMPORTANT_MOMENT_ARRIVES_DECIDE_UPON_WHAT_YOU_TRULY_WANT_WITHOUT_MEASURING_OTHERS_JUDGMENT;
	
	/**
	 * ID: 1800489<br>
	 * Message: ėɏoB<br>
	 * Message: &#39165;&#35712;&#26360;&#39321;&#24460;&#20986;&#38272;&#26053;&#36938;&#65292;&#24184;&#36939;&#23559;&#38568;&#20043;&#32780;&#20358;&#12290;<br>
	 * Message: Luck will always follow you if you travel and read many books.
	 */
	public static final NpcStringId LUCK_WILL_ALWAYS_FOLLOW_YOU_IF_YOU_TRAVEL_AND_READ_MANY_BOOKS;
	
	/**
	 * ID: 1800490<br>
	 * Message: ACfBAԁBȂ̃AhoCXKvƂĂƂɍsB<br>
	 * Message: &#24819;&#27861;&#21644;&#26032;&#40670;&#23376;&#19981;&#26039;&#28263;&#29694;&#65292;&#30433;&#36895;&#21069;&#24448;&#21521;&#20320;&#35531;&#27714;&#24314;&#35696;&#30340;&#22320;&#26041;&#12290;<br>
	 * Message: Head to a place that needs your advice as good ideas and wisdom will flourish.
	 */
	public static final NpcStringId HEAD_TO_A_PLACE_THAT_NEEDS_YOUR_ADVICE_AS_GOOD_IDEAS_AND_WISDOM_WILL_FLOURISH;
	
	/**
	 * ID: 1800491<br>
	 * Message: Ȃ̃AhoCX̐lςB<br>
	 * Message: &#26681;&#25818;&#20320;&#30340;&#24314;&#35696;&#65292;&#25110;&#35377;&#26371;&#36681;&#25240;&#23565;&#26041;&#30340;&#20154;&#29983;&#12290;<br>
	 * Message: Someone's life may change upon your advice.
	 */
	public static final NpcStringId SOMEONES_LIFE_MAY_CHANGE_UPON_YOUR_ADVICE;
	
	/**
	 * ID: 1800492<br>
	 * Message: ߎɊׂ邱ƂȂAOɒuB<br>
	 * Message: &#19981;&#20677;&#26159;&#23565;&#26044;&#36817;&#26085;&#30340;&#26410;&#20358;&#65292;&#29694;&#22312;&#20063;&#24456;&#36969;&#21512;&#28858;&#36953;&#36960;&#30340;&#26410;&#20358;&#20570;&#25171;&#31639;&#12290;<br>
	 * Message: It's a proper time to plan for the future rather than a short term plan.
	 */
	public static final NpcStringId ITS_A_PROPER_TIME_TO_PLAN_FOR_THE_FUTURE_RATHER_THAN_A_SHORT_TERM_PLAN;
	
	/**
	 * ID: 1800493<br>
	 * Message: 悭Yłv𗧂ĂB<br>
	 * Message: &#32147;&#36942;&#19968;&#30058;&#33510;&#24605;&#32780;&#24314;&#31435;&#30340;&#35336;&#30059;&#65292;&#23565;&#26085;&#24460;&#23559;&#26371;&#26377;&#33707;&#22823;&#30340;&#24171;&#21161;&#12290;<br>
	 * Message: Many thoughtful plans at present time will be of great help in the future.
	 */
	public static final NpcStringId MANY_THOUGHTFUL_PLANS_AT_PRESENT_TIME_WILL_BE_OF_GREAT_HELP_IN_THE_FUTURE;
	
	/**
	 * ID: 1800494<br>
	 * Message: ߂lƂ̌܂ɒӁB䖝̂݁B<br>
	 * Message: &#25110;&#35377;&#26371;&#33287;&#29087;&#20154;&#30332;&#29983;&#21475;&#35282;&#65292;&#38920;&#20808;&#24525;&#32784;&#20006;&#38748;&#35264;&#20854;&#35722;&#12290;<br>
	 * Message: Patience may be needed as a big quarrel arises between you and a person close to you.
	 */
	public static final NpcStringId PATIENCE_MAY_BE_NEEDED_AS_A_BIG_QUARREL_ARISES_BETWEEN_YOU_AND_A_PERSON_CLOSE_TO_YOU;
	
	/**
	 * ID: 1800495<br>
	 * Message: KvłS͂ȁBvCh邾B<br>
	 * Message: &#23601;&#31639;&#38656;&#35201;&#37329;&#37666;&#65292;&#20134;&#21247;&#27714;&#21161;&#26044;&#20182;&#20154;&#65292;&#19981;&#20677;&#20663;&#21040;&#33258;&#23562;&#24515;&#65292;&#20134;&#19981;&#33021;&#23559;&#37666;&#36001;&#21040;&#25163;&#12290;<br>
	 * Message: Do not ask for financial help when the time is difficult. Your pride will be hurt without gaining any money.
	 */
	public static final NpcStringId DO_NOT_ASK_FOR_FINANCIAL_HELP_WHEN_THE_TIME_IS_DIFFICULT_YOUR_PRIDE_WILL_BE_HURT_WITHOUT_GAINING_ANY_MONEY;
	
	/**
	 * ID: 1800496<br>
	 * Message: ȋRǉɂȂB<br>
	 * Message: &#23567;&#23567;&#30340;&#20598;&#28982;&#23559;&#26371;&#24310;&#32396;&#28858;&#32227;&#20998;&#12290;<br>
	 * Message: Connection with a special person starts with a mere incident.
	 */
	public static final NpcStringId CONNECTION_WITH_A_SPECIAL_PERSON_STARTS_WITH_A_MERE_INCIDENT;
	
	/**
	 * ID: 1800497<br>
	 * Message: łɂȂΊ@B<br>
	 * Message: &#19981;&#31649;&#38754;&#23565;&#21738;&#19968;&#20214;&#20107;&#65292;&#22266;&#22519;&#23559;&#26371;&#24341;&#20358;&#39080;&#38570;&#12290;<br>
	 * Message: Stubbornness regardless of the matter will only bear danger.
	 */
	public static final NpcStringId STUBBORNNESS_REGARDLESS_OF_THE_MATTER_WILL_ONLY_BEAR_DANGER;
	
	/**
	 * ID: 1800498<br>
	 * Message: Ƃgu̎킠B݁A}i[ɂCB<br>
	 * Message: &#36629;&#28014;&#23559;&#25307;&#20358;&#31117;&#23475;&#65292;&#23569;&#35498;&#35441;&#19988;&#34892;&#28858;&#33289;&#27490;&#35201;&#26377;&#39080;&#24230;&#12290;<br>
	 * Message: Keep good manners and value taciturnity as light-heartedness may bring misfortune.
	 */
	public static final NpcStringId KEEP_GOOD_MANNERS_AND_VALUE_TACITURNITY_AS_LIGHT_HEARTEDNESS_MAY_BRING_MISFORTUNE;
	
	/**
	 * ID: 1800499<br>
	 * Message: ςِɏoB<br>
	 * Message: &#26377;&#26997;&#39640;&#30340;&#27231;&#29575;&#36935;&#19978;&#19981;&#21516;&#39006;&#22411;&#30340;&#30064;&#24615;&#12290;<br>
	 * Message: You may meet the opposite sex.
	 */
	public static final NpcStringId YOU_MAY_MEET_THE_OPPOSITE_SEX;
	
	/**
	 * ID: 1800500<br>
	 * Message: ~肷čЂB<br>
	 * Message: &#23565;&#37666;&#36001;&#30340;&#36010;&#24515;&#20351;&#24471;&#20320;&#24819;&#35201;&#22823;&#25736;&#19968;&#31558;&#65292;&#20294;&#21371;&#26371;&#25307;&#20358;&#31117;&#23475;&#12290;<br>
	 * Message: Greed by wanting to take wealth may bring unfortunate disaster.
	 */
	public static final NpcStringId GREED_BY_WANTING_TO_TAKE_WEALTH_MAY_BRING_UNFORTUNATE_DISASTER;
	
	/**
	 * ID: 1800501<br>
	 * Message: ^Bxo}B<br>
	 * Message: &#20805;&#28415;&#25613;&#22833;&#36939;&#65292;&#25237;&#36039;&#39080;&#38570;&#22823;&#65292;&#29645;&#24796;&#25163;&#20013;&#20043;&#36001;&#12290;<br>
	 * Message: Loss is ahead, refrain from investing. Try to save the money in your pockets.
	 */
	public static final NpcStringId LOSS_IS_AHEAD_REFRAIN_FROM_INVESTING_TRY_TO_SAVE_THE_MONEY_IN_YOUR_POCKETS;
	
	/**
	 * ID: 1800502<br>
	 * Message: ^悩炸B̖S͑ɂȁB<br>
	 * Message: &#36001;&#36939;&#19981;&#20339;&#65292;&#21363;&#20351;&#20182;&#20154;&#21521;&#20320;&#20280;&#25163;&#27714;&#21161;&#65292;&#20063;&#35201;&#25026;&#24471;&#36852;&#36991;&#12290;<br>
	 * Message: Your wealth luck is dim, avoid any offers.
	 */
	public static final NpcStringId YOUR_WEALTH_LUCK_IS_DIM_AVOID_ANY_OFFERS;
	
	/**
	 * ID: 1800503<br>
	 * Message: ׂƂ𖾓悤Ƃ΋ꋫɗB<br>
	 * Message: &#20170;&#26085;&#20107;&#33509;&#19981;&#20170;&#26085;&#30050;&#65292;&#23559;&#26371;&#25307;&#20358;&#26356;&#22823;&#30340;&#22256;&#38627;&#12290;<br>
	 * Message: A bigger challenge may be when delaying today's work.
	 */
	public static final NpcStringId A_BIGGER_CHALLENGE_MAY_BE_WHEN_DELAYING_TODAYS_WORK;
	
	/**
	 * ID: 1800504<br>
	 * Message: ɏPĂӔCĖ]߂΂ʂ𓾂B<br>
	 * Message: &#23559;&#26371;&#36935;&#21040;&#22256;&#38627;&#65292;&#20294;&#25265;&#20197;&#36012;&#20219;&#24863;&#34892;&#20107;&#65292;&#20415;&#26371;&#24471;&#21040;&#22909;&#32080;&#26524;&#12290;<br>
	 * Message: There will be difficulty, but a good result may be ahead when facing it responsibly.
	 */
	public static final NpcStringId THERE_WILL_BE_DIFFICULTY_BUT_A_GOOD_RESULT_MAY_BE_AHEAD_WHEN_FACING_IT_RESPONSIBLY;
	
	/**
	 * ID: 1800505<br>
	 * Message: ǂĂƐӔĈdBKB<br>
	 * Message: &#38614;&#28982;&#28145;&#24863;&#36000;&#25812;&#65292;&#20294;&#38656;&#21152;&#37325;&#36012;&#20219;&#65292;&#26085;&#24460;&#20415;&#26371;&#24471;&#21040;&#21033;&#30410;&#12290;<br>
	 * Message: Even with some difficulties, expand the range of your scope where you are in charge. It will return to you as help.
	 */
	public static final NpcStringId EVEN_WITH_SOME_DIFFICULTIES_EXPAND_THE_RANGE_OF_YOUR_SCOPE_WHERE_YOU_ARE_IN_CHARGE_IT_WILL_RETURN_TO_YOU_AS_HELP;
	
	/**
	 * ID: 1800506<br>
	 * Message: gӐ˂΁AWłȂB<br>
	 * Message: &#33509;&#19981;&#34389;&#29702;&#22909;&#21608;&#37002;&#29872;&#22659;&#65292;&#20415;&#26371;&#36896;&#25104;&#31934;&#31070;&#29376;&#24907;&#19981;&#20339;&#65292;&#23566;&#33268;&#25613;&#22833;&#24920;&#37325;&#65292;&#38920;&#35641;&#24910;&#12290;<br>
	 * Message: Focus on maintaining organized surroundings to help reduce your losses.
	 */
	public static final NpcStringId FOCUS_ON_MAINTAINING_ORGANIZED_SURROUNDINGS_TO_HELP_REDUCE_YOUR_LOSSES;
	
	/**
	 * ID: 1800507<br>
	 * Message: l͒ǂ҂gB<br>
	 * Message: &#33287;&#20854;&#36861;&#36245;&#20182;&#20154;&#65292;&#19981;&#22914;&#31561;&#24453;&#20182;&#20154;&#65292;&#37027;&#40636;&#24184;&#31119;&#20415;&#26371;&#22312;&#20320;&#36523;&#37002;&#12290;<br>
	 * Message: Luck lies ahead when waiting for people rather than following them.
	 */
	public static final NpcStringId LUCK_LIES_AHEAD_WHEN_WAITING_FOR_PEOPLE_RATHER_THAN_FOLLOWING_THEM;
	
	/**
	 * ID: 1800508<br>
	 * Message: ً}łĂ炩Lׂׂ炸Bpč܂jڂɁB<br>
	 * Message: &#19981;&#31649;&#20877;&#24590;&#40636;&#24908;&#24373;&#65292;&#20063;&#19981;&#35201;&#20808;&#20280;&#25163;&#27714;&#21161;&#65292;&#21453;&#32780;&#26371;&#36896;&#25104;&#38364;&#20418;&#30095;&#36960;&#12290;<br>
	 * Message: Do not offer your hand first even when things are hasty. The relationship may fall apart.
	 */
	public static final NpcStringId DO_NOT_OFFER_YOUR_HAND_FIRST_EVEN_WHEN_THINGS_ARE_HASTY_THE_RELATIONSHIP_MAY_FALL_APART;
	
	/**
	 * ID: 1800509<br>
	 * Message: ^㏸B<br>
	 * Message: &#36001;&#36939;&#19978;&#21319;&#65292;&#22810;&#23569;&#26371;&#26377;&#40670;&#25104;&#26524;&#12290;<br>
	 * Message: Your wealth luck is rising, there will be some good result.
	 */
	public static final NpcStringId YOUR_WEALTH_LUCK_IS_RISING_THERE_WILL_BE_SOME_GOOD_RESULT;
	
	/**
	 * ID: 1800510<br>
	 * Message: vŎi߂΁A@ɕmB<br>
	 * Message: &#20381;&#29031;&#30070;&#26178;&#30340;&#24515;&#24773;&#38568;&#33288;&#34892;&#21205;&#65292;&#20415;&#26371;&#34389;&#26044;&#21361;&#38570;&#12290;<br>
	 * Message: You may fall in danger each time when acting upon improvisation.
	 */
	public static final NpcStringId YOU_MAY_FALL_IN_DANGER_EACH_TIME_WHEN_ACTING_UPON_IMPROVISATION;
	
	/**
	 * ID: 1800511<br>
	 * Message: ڏ̐l̑Oł͍Α̐U镑B<br>
	 * Message: &#33287;&#38263;&#36649;&#30456;&#34389;&#26178;&#65292;&#33509;&#20570;&#20986;&#31245;&#20559;&#24188;&#31258;&#30340;&#34892;&#28858;&#65292;&#21487;&#33021;&#26371;&#31967;&#36427;&#19968;&#20999;&#12290;<br>
	 * Message: Be warned as a childishly act before elders may ruin everything.
	 */
	public static final NpcStringId BE_WARNED_AS_A_CHILDISHLY_ACT_BEFORE_ELDERS_MAY_RUIN_EVERYTHING;
	
	/**
	 * ID: 1800512<br>
	 * Message: VɂȂΉ^B<br>
	 * Message: &#20107;&#24773;&#36880;&#28472;&#22909;&#36681;&#65292;&#20294;&#19981;&#24471;&#22240;&#27492;&#22210;&#24373;&#65292;&#21542;&#21063;&#22909;&#36939;&#23559;&#38626;&#20320;&#32780;&#21435;&#12290;<br>
	 * Message: Things will move effortlessly but luck will vanish with your audacity.
	 */
	public static final NpcStringId THINGS_WILL_MOVE_EFFORTLESSLY_BUT_LUCK_WILL_VANISH_WITH_YOUR_AUDACITY;
	
	/**
	 * ID: 1800513<br>
	 * Message: ^𒷎B<br>
	 * Message: &#20107;&#24773;&#22909;&#36681;&#26178;&#65292;&#38920;&#25265;&#20197;&#35609;&#34395;&#30340;&#24907;&#24230;&#65292;&#24184;&#36939;&#25165;&#26371;&#25345;&#20037;&#12290;<br>
	 * Message: Luck may be continued only when humility is maintained after success.
	 */
	public static final NpcStringId LUCK_MAY_BE_CONTINUED_ONLY_WHEN_HUMILITY_IS_MAINTAINED_AFTER_SUCCESS;
	
	/**
	 * ID: 1800514<br>
	 * Message: O҂̏oɂOp֌WɂpSB<br>
	 * Message: &#26032;&#20154;&#30340;&#30331;&#22580;&#65292;&#36896;&#25104;&#19977;&#35282;&#38364;&#20418;&#30340;&#23616;&#38754;&#12290;<br>
	 * Message: A new person may appear to create a love triangle.
	 */
	public static final NpcStringId A_NEW_PERSON_MAY_APPEAR_TO_CREATE_A_LOVE_TRIANGLE;
	
	/**
	 * ID: 1800515<br>
	 * Message: ƓX^C̐lTB<br>
	 * Message: &#23563;&#25214;&#33287;&#33258;&#24049;&#30456;&#21516;&#39006;&#22411;&#30340;&#20154;&#65292;&#20415;&#26371;&#26377;&#22909;&#20107;&#30332;&#29983;&#12290;<br>
	 * Message: Look for someone with a similar style. It will open up for the good.
	 */
	public static final NpcStringId LOOK_FOR_SOMEONE_WITH_A_SIMILAR_STYLE_IT_WILL_OPEN_UP_FOR_THE_GOOD;
	
	/**
	 * ID: 1800516<br>
	 * Message: It@[͒fB͎ł͂ȂB<br>
	 * Message: &#23559;&#26371;&#25509;&#21463;&#21512;&#22821;&#30340;&#24314;&#35696;&#65292;&#20294;&#24773;&#27841;&#19981;&#20339;&#65292;&#26368;&#22909;&#25512;&#36781;&#12290;<br>
	 * Message: An offer may soon be made to collaborate a task but delaying it will be a good idea.
	 */
	public static final NpcStringId AN_OFFER_MAY_SOON_BE_MADE_TO_COLLABORATE_A_TASK_BUT_DELAYING_IT_WILL_BE_A_GOOD_IDEA;
	
	/**
	 * ID: 1800517<br>
	 * Message: }悤ȃIt@[͒fB<br>
	 * Message: &#21512;&#22821;&#36939;&#19981;&#20339;&#65292;&#33509;&#26377;&#20154;&#20652;&#20419;&#65292;&#26368;&#22909;&#19981;&#35201;&#21512;&#20316;&#12290;<br>
	 * Message: Partnership is out of luck, avoid someone who rushes you to start a collaboration.
	 */
	public static final NpcStringId PARTNERSHIP_IS_OUT_OF_LUCK_AVOID_SOMEONE_WHO_RUSHES_YOU_TO_START_A_COLLABORATION;
	
	/**
	 * ID: 1800518<br>
	 * Message: uɂlX̃lbg[NBɑ傫d邱ƂɂȂB<br>
	 * Message: &#33287;&#24535;&#27683;&#30456;&#25237;&#30340;&#20154;&#21162;&#21147;&#24314;&#31435;&#20154;&#38555;&#38364;&#20418;&#65292;&#26085;&#24460;&#20415;&#26371;&#24471;&#21040;&#33707;&#22823;&#30340;&#24171;&#21161;&#12290;<br>
	 * Message: Focus on networking with like-minded people. They may join you for a big mission in the future.
	 */
	public static final NpcStringId FOCUS_ON_NETWORKING_WITH_LIKE_MINDED_PEOPLE_THEY_MAY_JOIN_YOU_FOR_A_BIG_MISSION_IN_THE_FUTURE;
	
	/**
	 * ID: 1800519<br>
	 * Message: Ȃ͏^ȐlƌċߊĂ҂ɋCB<br>
	 * Message: &#26377;&#20154;&#26371;&#35498;&#20320;&#21934;&#32020;&#65292;&#20294;&#36889;&#19981;&#20195;&#34920;&#22909;&#24847;&#65292;&#38920;&#35641;&#24910;&#38450;&#20633;&#12290;<br>
	 * Message: Be warned when someone says you are innocent as that's not a compliment.
	 */
	public static final NpcStringId BE_WARNED_WHEN_SOMEONE_SAYS_YOU_ARE_INNOCENT_AS_THATS_NOT_A_COMPLIMENT;
	
	/**
	 * ID: 1800520<br>
	 * Message: \̋ꂠBȂ߂ꂽ呹B<br>
	 * Message: &#34987;&#39449;&#30340;&#27231;&#29575;&#22823;&#12290;&#33509;&#34987;&#20182;&#20154;&#30475;&#25153;&#26371;&#36896;&#25104;&#25613;&#22833;&#24920;&#37325;&#65292;&#38920;&#25552;&#36215;&#31934;&#31070;&#12290;<br>
	 * Message: You may be scammed. Be cautious as there may be a big loss by underestimating others.
	 */
	public static final NpcStringId YOU_MAY_BE_SCAMMED_BE_CAUTIOUS_AS_THERE_MAY_BE_A_BIG_LOSS_BY_UNDERESTIMATING_OTHERS;
	
	/**
	 * ID: 1800521<br>
	 * Message: ͌̎ł͂ȂB̍l펯ɉfB<br>
	 * Message: &#27770;&#23450;&#36939;&#19981;&#20339;&#65292;&#21247;&#20197;&#20027;&#35264;&#21028;&#26039;&#20107;&#29289;&#65292;&#38920;&#21443;&#32771;&#26222;&#36941;&#22949;&#30070;&#30340;&#24120;&#35672;&#20358;&#20570;&#21028;&#26039;&#12290;<br>
	 * Message: Luck at decision-making is dim, avoid subjective conclusions and rely on universal common-sense.
	 */
	public static final NpcStringId LUCK_AT_DECISION_MAKING_IS_DIM_AVOID_SUBJECTIVE_CONCLUSIONS_AND_RELY_ON_UNIVERSAL_COMMON_SENSE;
	
	/**
	 * ID: 1800522<br>
	 * Message: S̎コŏdׂwށBȎ咣͂͂ƁB<br>
	 * Message: &#22240;&#24515;&#36575;&#21487;&#33021;&#26371;&#38519;&#20837;&#22256;&#22659;&#65292;&#38656;&#35201;&#22266;&#22519;&#24050;&#35211;&#30340;&#26178;&#20505;&#65292;&#23452;&#25505;&#21462;&#22533;&#25345;&#24907;&#24230;&#12290;<br>
	 * Message: Your weakness may invite hardships, cautiously take a strong position as needed.
	 */
	public static final NpcStringId YOUR_WEAKNESS_MAY_INVITE_HARDSHIPS_CAUTIOUSLY_TAKE_A_STRONG_POSITION_AS_NEEDED;
	
	/**
	 * ID: 1800523<br>
	 * Message: ׂ̗VѐlɗpSBgűꂠB<br>
	 * Message: &#38920;&#25552;&#38450;&#35441;&#22810;&#19988;&#22909;&#29609;&#30340;&#20154;&#65292;&#21542;&#21063;&#26371;&#22240;&#27492;&#25307;&#20358;&#31117;&#23475;&#12290;<br>
	 * Message: Be wary of someone who talks and entertains too much. The person may bring you misfortune.
	 */
	public static final NpcStringId BE_WARY_OF_SOMEONE_WHO_TALKS_AND_ENTERTAINS_TOO_MUCH_THE_PERSON_MAY_BRING_YOU_MISFORTUNE;
	
	/**
	 * ID: 1800524<br>
	 * Message: rMi[YbN̗\B<br>
	 * Message: &#22914;&#21516;&#27794;&#29609;&#36942;&#36077;&#21338;&#30340;&#20154;&#20709;&#20502;&#36111;&#37666;&#33324;&#65292;&#23601;&#22240;&#28858;&#20320;&#26159;&#26032;&#25163;&#65292;&#22240;&#27492;&#26371;&#24471;&#21040;&#24184;&#36939;&#12290;<br>
	 * Message: You may enjoy a beginner's luck.
	 */
	public static final NpcStringId YOU_MAY_ENJOY_A_BEGINNERS_LUCK;
	
	/**
	 * ID: 1800525<br>
	 * Message: ^͂AmׂB<br>
	 * Message: &#36001;&#36939;&#20339;&#65292;&#20294;&#38656;&#35201;&#30693;&#36275;&#24460;&#36864;&#12290;<br>
	 * Message: Your wealth luck is strong but you should know when to withdraw.
	 */
	public static final NpcStringId YOUR_WEALTH_LUCK_IS_STRONG_BUT_YOU_SHOULD_KNOW_WHEN_TO_WITHDRAW;
	
	/**
	 * ID: 1800526<br>
	 * Message: ~肷ĖׂB<br>
	 * Message: &#36942;&#24230;&#36010;&#24515;&#65292;&#23566;&#33268;&#36899;&#28414;&#36914;&#30340;&#37666;&#36001;&#20063;&#26371;&#22833;&#21435;&#12290;<br>
	 * Message: Already acquired wealth can be lost by greed.
	 */
	public static final NpcStringId ALREADY_ACQUIRED_WEALTH_CAN_BE_LOST_BY_GREED;
	
	/**
	 * ID: 1800527<br>
	 * Message: lłł邱ƂłNƂƂB<br>
	 * Message: &#21363;&#20351;&#19968;&#20154;&#33021;&#34389;&#29702;&#30340;&#20107;&#65292;&#20063;&#26368;&#22909;&#33287;&#20182;&#20154;&#19968;&#21516;&#34389;&#29702;&#12290;<br>
	 * Message: Even if you can complete it by yourself, it's a good idea to have someone help you.
	 */
	public static final NpcStringId EVEN_IF_YOU_CAN_COMPLETE_IT_BY_YOURSELF_ITS_A_GOOD_IDEA_TO_HAVE_SOMEONE_HELP_YOU;
	
	/**
	 * ID: 1800528<br>
	 * Message: ł̐SȂƂ͘aB킪܂܂΋ꋫɗB<br>
	 * Message: &#33287;&#20182;&#20154;&#30340;&#21644;&#35559;&#23452;&#25490;&#21015;&#20778;&#20808;&#65292;&#22266;&#22519;&#26371;&#35731;&#20320;&#38519;&#20837;&#22256;&#22659;&#12290;<br>
	 * Message: Make harmony with people the priority. Stubbornness may bring hardships.
	 */
	public static final NpcStringId MAKE_HARMONY_WITH_PEOPLE_THE_PRIORITY_STUBBORNNESS_MAY_BRING_HARDSHIPS;
	
	/**
	 * ID: 1800529<br>
	 * Message: ߂l̒mȂƂ킩B<br>
	 * Message: &#26371;&#30475;&#21040;&#29087;&#20154;&#26032;&#30340;&#19968;&#38754;&#12290;<br>
	 * Message: There may be a chance when you can see a new aspect of a close friend.
	 */
	public static final NpcStringId THERE_MAY_BE_A_CHANCE_WHEN_YOU_CAN_SEE_A_NEW_ASPECT_OF_A_CLOSE_FRIEND;
	
	/**
	 * ID: 1800530<br>
	 * Message: ς̂ĂBƂ͈Ⴄ^Cv̐lƂB<br>
	 * Message: &#20808;&#25291;&#38283;&#25104;&#35211;&#65292;&#22039;&#35430;&#25509;&#35320;&#33287;&#33258;&#24049;&#31245;&#24494;&#19981;&#21516;&#39006;&#22411;&#30340;&#20154;&#12290;<br>
	 * Message: Try to be close to someone different from you without any stereotypical judgment.
	 */
	public static final NpcStringId TRY_TO_BE_CLOSE_TO_SOMEONE_DIFFERENT_FROM_YOU_WITHOUT_ANY_STEREOTYPICAL_JUDGMENT;
	
	/**
	 * ID: 1800531<br>
	 * Message: [_[ɂȂ\Bl̏ɗA炢B<br>
	 * Message: &#20855;&#26377;&#38936;&#34966;&#29305;&#36074;&#65292;&#23559;&#24471;&#21040;&#24456;&#22810;&#23660;&#19979;&#65292;&#20294;&#26371;&#26377;&#40670;&#21507;&#21147;&#12290;<br>
	 * Message: Good luck in becoming a leader with many followers. However, it'll only be after hard work.
	 */
	public static final NpcStringId GOOD_LUCK_IN_BECOMING_A_LEADER_WITH_MANY_FOLLOWERS_HOWEVER_ITLL_ONLY_BE_AFTER_HARD_WORK;
	
	/**
	 * ID: 1800532<br>
	 * Message: ^㏸BēB<br>
	 * Message: &#36001;&#36939;&#19978;&#21319;&#65292;&#38614;&#28982;&#26371;&#26377;&#19968;&#40670;&#25903;&#20986;&#65292;&#20294;&#23526;&#38555;&#36914;&#24115;&#30340;&#37666;&#26371;&#22686;&#22810;&#65292;&#22240;&#27492;&#36000;&#25812;&#23559;&#19981;&#27785;&#37325;&#12290;<br>
	 * Message: Your wealth luck is rising, expenditures will be followed by substantial income as you are able to sustain.
	 */
	public static final NpcStringId YOUR_WEALTH_LUCK_IS_RISING_EXPENDITURES_WILL_BE_FOLLOWED_BY_SUBSTANTIAL_INCOME_AS_YOU_ARE_ABLE_TO_SUSTAIN;
	
	/**
	 * ID: 1800533<br>
	 * Message: ^͍ŗǂň̂ǂ炩B<br>
	 * Message: &#36001;&#36939;&#26997;&#20339;&#25110;&#26997;&#20982;&#65292;&#38920;&#35641;&#24910;&#12290;<br>
	 * Message: Be cautious as your wealth luck can be either very good or very bad.
	 */
	public static final NpcStringId BE_CAUTIOUS_AS_YOUR_WEALTH_LUCK_CAN_BE_EITHER_VERY_GOOD_OR_VERY_BAD;
	
	/**
	 * ID: 1800534<br>
	 * Message: ׂȑŋ߂lƂ̒ȂB<br>
	 * Message: &#33437;&#40635;&#23567;&#20107;&#20063;&#26371;&#25289;&#38283;&#33287;&#29087;&#20154;&#30340;&#36317;&#38626;&#65292;&#38920;&#35641;&#24910;&#12290;<br>
	 * Message: Be warned as a small argument can distance you from a close friend.
	 */
	public static final NpcStringId BE_WARNED_AS_A_SMALL_ARGUMENT_CAN_DISTANCE_YOU_FROM_A_CLOSE_FRIEND;
	
	/**
	 * ID: 1800535<br>
	 * Message: ^㏸B<br>
	 * Message: &#33287;&#26032;&#20154;&#20043;&#38291;&#26377;&#24859;&#24773;&#36939;&#12290;<br>
	 * Message: There is luck in love with a new person.
	 */
	public static final NpcStringId THERE_IS_LUCK_IN_LOVE_WITH_A_NEW_PERSON;
	
	/**
	 * ID: 1800536<br>
	 * Message: ͐l̂߂Ȃ炸B<br>
	 * Message: &#24171;&#21161;&#20182;&#20154;&#20415;&#33021;&#24471;&#21040;&#26356;&#22823;&#30340;&#24184;&#36939;&#12290;<br>
	 * Message: A bigger fortune will be followed by your good deed.
	 */
	public static final NpcStringId A_BIGGER_FORTUNE_WILL_BE_FOLLOWED_BY_YOUR_GOOD_DEED;
	
	/**
	 * ID: 1800537<br>
	 * Message: 𔃂Ύ̋ꂠB<br>
	 * Message: &#26371;&#26377;&#22833;&#25088;&#30340;&#21487;&#33021;&#24615;&#65292;&#38920;&#30433;&#24515;&#30433;&#21147;&#65292;&#21247;&#24341;&#30332;&#35492;&#26371;&#12290;<br>
	 * Message: There may be a relationship breaking, try to eliminate misunderstandings.
	 */
	public static final NpcStringId THERE_MAY_BE_A_RELATIONSHIP_BREAKING_TRY_TO_ELIMINATE_MISUNDERSTANDINGS;
	
	/**
	 * ID: 1800538<br>
	 * Message: 󂯂ĂȒPɐMĂ͂ȂȂB<br>
	 * Message: &#23601;&#31639;&#35731;&#20320;&#21313;&#20998;&#24863;&#21205;&#65292;&#20063;&#19981;&#24471;&#39340;&#19978;&#20449;&#20219;&#12290;<br>
	 * Message: Be cautious not to be emotionally moved even if it's convincing.
	 */
	public static final NpcStringId BE_CAUTIOUS_NOT_TO_BE_EMOTIONALLY_MOVED_EVEN_IF_ITS_CONVINCING;
	
	/**
	 * ID: 1800539<br>
	 * Message: ΂ɂ͕B<br>
	 * Message: &#31505;&#23481;&#25307;&#20358;&#31119;&#27683;&#12290;<br>
	 * Message: Smiling will bring good luck.
	 */
	public static final NpcStringId SMILING_WILL_BRING_GOOD_LUCK;
	
	/**
	 * ID: 1800540<br>
	 * Message: ȑł܂ł悭悷ȁB<br>
	 * Message: &#23567;&#23567;&#30340;&#25613;&#22833;&#65292;&#26368;&#22909;&#31435;&#21051;&#24536;&#35352;&#12290;<br>
	 * Message: It's a good idea to let go of a small loss.
	 */
	public static final NpcStringId ITS_A_GOOD_IDEA_TO_LET_GO_OF_A_SMALL_LOSS;
	
	/**
	 * ID: 1800541<br>
	 * Message: R~jP[V܂AB<br>
	 * Message: &#28961;&#27861;&#26126;&#30906;&#34920;&#36948;&#33258;&#24049;&#30340;&#24847;&#24605;&#65292;&#22240;&#27492;&#24456;&#23481;&#26131;&#29986;&#29983;&#35492;&#26371;&#12290;<br>
	 * Message: Conveying your own truth may be difficult and easy misunderstandings will follow.
	 */
	public static final NpcStringId CONVEYING_YOUR_OWN_TRUTH_MAY_BE_DIFFICULT_AND_EASY_MISUNDERSTANDINGS_WILL_FOLLOW;
	
	/**
	 * ID: 1800542<br>
	 * Message: l̏W܂Ƃ납K^ĂB<br>
	 * Message: &#20154;&#23665;&#20154;&#28023;&#20043;&#34389;&#65292;&#23559;&#26371;&#26377;&#24184;&#36939;&#20358;&#33256;&#12290;<br>
	 * Message: There is good luck in a place with many people.
	 */
	public static final NpcStringId THERE_IS_GOOD_LUCK_IN_A_PLACE_WITH_MANY_PEOPLE;
	
	/**
	 * ID: 1800543<br>
	 * Message: ܂̂͋pĂ悭ȂB<br>
	 * Message: &#26368;&#22909;&#36991;&#20813;&#38283;&#38272;&#35211;&#23665;&#30340;&#26041;&#24335;&#12290;<br>
	 * Message: Try to avoid directness if you can.
	 */
	public static final NpcStringId TRY_TO_AVOID_DIRECTNESS_IF_YOU_CAN;
	
	/**
	 * ID: 1800544<br>
	 * Message: ڂ蒆g̐SB<br>
	 * Message: &#33287;&#20854;&#34395;&#27054;&#65292;&#19981;&#22914;&#23526;&#22312;&#65292;&#38920;&#25918;&#38283;&#36960;&#22823;&#30340;&#30524;&#20809;&#20358;&#35336;&#30059;&#34892;&#20107;&#12290;<br>
	 * Message: Value substance opposed to the sake honor and look beyond what's in front of you.
	 */
	public static final NpcStringId VALUE_SUBSTANCE_OPPOSED_TO_THE_SAKE_HONOR_AND_LOOK_BEYOND_WHATS_IN_FRONT_OF_YOU;
	
	/**
	 * ID: 1800545<br>
	 * Message: lԊ֌W͂ƌ܂炢B<br>
	 * Message: &#33225;&#30382;&#21402;&#19968;&#40670;&#65292;&#23559;&#26377;&#21161;&#26044;&#24314;&#31435;&#20154;&#38555;&#38364;&#20418;&#12290;<br>
	 * Message: Expanding a relationship with humor may be a good idea.
	 */
	public static final NpcStringId EXPANDING_A_RELATIONSHIP_WITH_HUMOR_MAY_BE_A_GOOD_IDEA;
	
	/**
	 * ID: 1800546<br>
	 * Message: ƂqŖׂB<br>
	 * Message: &#25509;&#21463;&#31777;&#21934;&#30340;&#25171;&#36077;&#65292;&#20415;&#26371;&#30332;&#29983;&#24841;&#24555;&#30340;&#20107;&#24773;&#12290;<br>
	 * Message: An enjoyable event may be ahead if you accept a simple bet.
	 */
	public static final NpcStringId AN_ENJOYABLE_EVENT_MAY_BE_AHEAD_IF_YOU_ACCEPT_A_SIMPLE_BET;
	
	/**
	 * ID: 1800547<br>
	 * Message: lԊ֌W̓EFbgɂȂ肷Ȃ悤ɁBÂɍl邱ƂKvB<br>
	 * Message: &#21482;&#35201;&#26159;&#26377;&#38364;&#20154;&#38555;&#38364;&#20418;&#30340;&#20107;&#24773;&#65292;&#20999;&#21247;&#34987;&#24773;&#24863;&#31998;&#32399;&#65292;&#38920;&#20919;&#38748;&#23565;&#24453;&#12290;<br>
	 * Message: Being level-headed not focusing on emotions may help with relationships.
	 */
	public static final NpcStringId BEING_LEVEL_HEADED_NOT_FOCUSING_ON_EMOTIONS_MAY_HELP_WITH_RELATIONSHIPS;
	
	/**
	 * ID: 1800548<br>
	 * Message: d͌yd킸ǂi߂ׂB<br>
	 * Message: &#34389;&#29702;&#20107;&#24773;&#26178;&#19981;&#31649;&#36629;&#37325;&#65292;&#38920;&#25353;&#29031;&#38918;&#24207;&#20358;&#34389;&#29702;&#12290;<br>
	 * Message: It's a good idea to take care of matters in sequential order without measuring their importance.
	 */
	public static final NpcStringId ITS_A_GOOD_IDEA_TO_TAKE_CARE_OF_MATTERS_IN_SEQUENTIAL_ORDER_WITHOUT_MEASURING_THEIR_IMPORTANCE;
	
	/**
	 * ID: 1800549<br>
	 * Message: 蒲ׂĎMčs΁AFɕB<br>
	 * Message: &#20570;&#22909;&#20107;&#21069;&#30340;&#35519;&#26597;&#65292;&#20381;&#29031;&#20449;&#24565;&#34892;&#20107;&#65292;&#20154;&#20154;&#20415;&#26371;&#36319;&#38568;&#20320;&#12290;<br>
	 * Message: A determined act after prepared research will attract people.
	 */
	public static final NpcStringId A_DETERMINED_ACT_AFTER_PREPARED_RESEARCH_WILL_ATTRACT_PEOPLE;
	
	/**
	 * ID: 1800550<br>
	 * Message: ΂ĎW߂B<br>
	 * Message: &#22810;&#34407;&#20123;&#35377;&#30340;&#24189;&#40664;&#65292;&#21487;&#20197;&#24471;&#21040;&#21608;&#22285;&#30340;&#27880;&#30446;&#12290;<br>
	 * Message: A little humor may bring complete attention to you.
	 */
	public static final NpcStringId A_LITTLE_HUMOR_MAY_BRING_COMPLETE_ATTENTION_TO_YOU;
	
	/**
	 * ID: 1800551<br>
	 * Message: dvȌ͉BK͔̎B<br>
	 * Message: &#27492;&#26178;&#27231;&#19981;&#36969;&#21512;&#23450;&#19979;&#37325;&#35201;&#27770;&#31574;&#65292;&#23567;&#24515;&#34987;&#36855;&#24785;&#65292;&#36852;&#36991;&#37329;&#37666;&#20132;&#26131;&#12290;<br>
	 * Message: It may not be a good time for an important decision, be wary of temptations and avoid monetary dealings.
	 */
	public static final NpcStringId IT_MAY_NOT_BE_A_GOOD_TIME_FOR_AN_IMPORTANT_DECISION_BE_WARY_OF_TEMPTATIONS_AND_AVOID_MONETARY_DEALINGS;
	
	/**
	 * ID: 1800552<br>
	 * Message: ߂l̏Sɍ߁B<br>
	 * Message: &#25509;&#32013;&#29087;&#20154;&#30340;&#24314;&#35696;&#20006;&#29282;&#35352;&#22312;&#24515;&#12290;<br>
	 * Message: Pay special attention to advice from a close friend.
	 */
	public static final NpcStringId PAY_SPECIAL_ATTENTION_TO_ADVICE_FROM_A_CLOSE_FRIEND;
	
	/**
	 * ID: 1800553<br>
	 * Message: ȂO҂̗ꂩlB~ȉ􂪌B<br>
	 * Message: &#19981;&#31649;&#26159;&#20160;&#40636;&#21839;&#38988;&#65292;&#21482;&#35201;&#31449;&#22312;&#31532;&#19977;&#32773;&#30340;&#31435;&#22580;&#20358;&#35264;&#23519;&#65292;&#20415;&#33021;&#24471;&#21040;&#22291;&#28415;&#30340;&#32080;&#23616;&#12290;<br>
	 * Message: There may be moderate solutions to every problem when they're viewed from a 3rd party's point of view.
	 */
	public static final NpcStringId THERE_MAY_BE_MODERATE_SOLUTIONS_TO_EVERY_PROBLEM_WHEN_THEYRE_VIEWED_FROM_A_3RD_PARTYS_POINT_OF_VIEW;
	
	/**
	 * ID: 1800554<br>
	 * Message: ߂lƂ̎͒fB̒ɂƂB<br>
	 * Message: &#33287;&#29087;&#20154;&#30340;&#20132;&#26131;&#65292;&#19981;&#20677;&#35731;&#20320;&#19981;&#22909;&#38283;&#21475;&#65292;&#36996;&#26371;&#36896;&#25104;&#38957;&#30171;&#22240;&#32032;&#65292;&#37165;&#37325;&#22320;&#25512;&#36781;&#65292;&#20006;&#25509;&#21463;&#20854;&#20182;&#30340;&#27231;&#26371;&#12290;<br>
	 * Message: Dealings with close friends only bring frustration and headache, politely decline and mention another chance.
	 */
	public static final NpcStringId DEALINGS_WITH_CLOSE_FRIENDS_ONLY_BRING_FRUSTRATION_AND_HEADACHE_POLITELY_DECLINE_AND_MENTION_ANOTHER_CHANCE;
	
	/**
	 * ID: 1800555<br>
	 * Message: baɂΎdグɖ肪B<br>
	 * Message: &#22914;&#26524;&#27794;&#26377;&#32771;&#24942;&#21040;&#22522;&#30990;&#65292;&#19981;&#31649;&#36942;&#31243;&#36914;&#23637;&#22914;&#20309;&#65292;&#32080;&#23616;&#37117;&#26371;&#30332;&#29983;&#21839;&#38988;&#65292;&#38920;&#35641;&#24910;&#12290;<br>
	 * Message: There may be a problem at completion if the basic matters are not considered from the beginning.
	 */
	public static final NpcStringId THERE_MAY_BE_A_PROBLEM_AT_COMPLETION_IF_THE_BASIC_MATTERS_ARE_NOT_CONSIDERED_FROM_THE_BEGINNING;
	
	/**
	 * ID: 1800556<br>
	 * Message: ̋ʂ͂ƁB<br>
	 * Message: &#38920;&#20844;&#31169;&#20998;&#26126;&#65292;&#25165;&#19981;&#26371;&#24324;&#24039;&#25104;&#25305;&#12290;<br>
	 * Message: Distinguishing business from a private matter is needed to succeed.
	 */
	public static final NpcStringId DISTINGUISHING_BUSINESS_FROM_A_PRIVATE_MATTER_IS_NEEDED_TO_SUCCEED;
	
	/**
	 * ID: 1800557<br>
	 * Message: d肭ȂȂ牡Ă݂̂̎B<br>
	 * Message: &#22914;&#26524;&#20107;&#24773;&#19968;&#30452;&#19981;&#38918;&#65292;&#25505;&#21462;&#19981;&#21512;&#35215;&#21063;&#30340;&#26041;&#27861;&#20063;&#28961;&#22952;&#12290;<br>
	 * Message: A change in rules may be helpful when problems are persistent.
	 */
	public static final NpcStringId A_CHANGE_IN_RULES_MAY_BE_HELPFUL_WHEN_PROBLEMS_ARE_PERSISTENT;
	
	/**
	 * ID: 1800558<br>
	 * Message: ȂƂƔ΂΁A\zȌ󋵂ɋꂵ߂B<br>
	 * Message: &#33509;&#24573;&#30053;&#23567;&#20107;&#65292;&#20415;&#38627;&#20197;&#38928;&#38450;&#28961;&#24847;&#20013;&#30332;&#29983;&#30340;&#24773;&#27841;&#12290;<br>
	 * Message: Preparing for an unforeseen situation will be difficult when small matters are ignored.
	 */
	public static final NpcStringId PREPARING_FOR_AN_UNFORESEEN_SITUATION_WILL_BE_DIFFICULT_WHEN_SMALL_MATTERS_ARE_IGNORED;
	
	/**
	 * ID: 1800559<br>
	 * Message: lɂ͕Kvȏ˂ނȁB<br>
	 * Message: &#25265;&#20197;&#24736;&#38290;&#30340;&#24515;&#24773;&#65292;&#26368;&#22909;&#19981;&#35201;&#24178;&#28041;&#19981;&#24517;&#35201;&#30340;&#20182;&#20154;&#21839;&#38988;&#12290;<br>
	 * Message: Refrain from getting involved in others' business, try to be loose as a goose.
	 */
	public static final NpcStringId REFRAIN_FROM_GETTING_INVOLVED_IN_OTHERS_BUSINESS_TRY_TO_BE_LOOSE_AS_A_GOOSE;
	
	/**
	 * ID: 1800560<br>
	 * Message: f؂AmȈӎv\ɂ͕KvB<br>
	 * Message: &#20445;&#25345;&#20013;&#31435;&#20063;&#19981;&#28858;&#36942;&#65292;&#20294;&#33287;&#20854;&#21547;&#31946;&#19981;&#28165;&#65292;&#19981;&#22914;&#30906;&#23526;&#34920;&#36948;&#24847;&#24605;&#65292;&#26371;&#26356;&#26377;&#24171;&#21161;&#12290;<br>
	 * Message: Being neutral is a good way to go, but clarity may be helpful contrary to your hesitance.
	 */
	public static final NpcStringId BEING_NEUTRAL_IS_A_GOOD_WAY_TO_GO_BUT_CLARITY_MAY_BE_HELPFUL_CONTRARY_TO_YOUR_HESITANCE;
	
	/**
	 * ID: 1800561<br>
	 * Message: ߋ̂ƂŌBsɒӂB<br>
	 * Message: &#33287;&#36942;&#21435;&#30456;&#38364;&#30340;&#20107;&#24773;&#65292;&#26371;&#26377;&#21487;&#33021;&#24341;&#36215;&#35492;&#26371;&#65292;&#35641;&#24910;&#34892;&#20107;&#12290;<br>
	 * Message: Be cautious of your own actions, the past may bring misunderstandings.
	 */
	public static final NpcStringId BE_CAUTIOUS_OF_YOUR_OWN_ACTIONS_THE_PAST_MAY_BRING_MISUNDERSTANDINGS;
	
	/**
	 * ID: 1800562<br>
	 * Message: ɗĎԂ𖳑ʂɂBԊǗɋCB<br>
	 * Message: &#22240;&#24773;&#24863;&#31998;&#32399;&#21487;&#33021;&#26371;&#28010;&#36027;&#26178;&#38291;&#65292;&#38920;&#30041;&#24847;&#26178;&#38291;&#19978;&#30340;&#31649;&#29702;&#12290;<br>
	 * Message: Pay attention to time management, emotions may waste your time.
	 */
	public static final NpcStringId PAY_ATTENTION_TO_TIME_MANAGEMENT_EMOTIONS_MAY_WASTE_YOUR_TIME;
	
	/**
	 * ID: 1800563<br>
	 * Message: ĝȂ`S͈ӖȂB<br>
	 * Message: &#34892;&#20448;&#20183;&#32681;&#22266;&#28982;&#26159;&#22909;&#65292;&#20294;&#20999;&#21247;&#22240;&#27492;&#24859;&#20986;&#39080;&#38957;&#25110;&#39015;&#38754;&#23376;&#12290;<br>
	 * Message: Heroism will be rewarded, but be careful not to display arrogance or lack of sincerity.
	 */
	public static final NpcStringId HEROISM_WILL_BE_REWARDED_BUT_BE_CAREFUL_NOT_TO_DISPLAY_ARROGANCE_OR_LACK_OF_SINCERITY;
	
	/**
	 * ID: 1800564<br>
	 * Message: ꂽlƒ肹B֌W񕜂B<br>
	 * Message: &#20808;&#25552;&#20986;&#21644;&#35299;&#65292;&#25165;&#33021;&#33287;&#30332;&#29983;&#35492;&#26371;&#30340;&#20154;&#20445;&#25345;&#33391;&#22909;&#38364;&#20418;&#12290;<br>
	 * Message: If you want to maintain relationship connections, offer reconciliation to those who had misunderstandings with you.
	 */
	public static final NpcStringId IF_YOU_WANT_TO_MAINTAIN_RELATIONSHIP_CONNECTIONS_OFFER_RECONCILIATION_TO_THOSE_WHO_HAD_MISUNDERSTANDINGS_WITH_YOU;
	
	/**
	 * ID: 1800565<br>
	 * Message: ɍsɂǂAɏoB<br>
	 * Message: &#30332;&#29694;&#23565;&#26041;&#30340;&#34892;&#28858;&#35731;&#20154;&#32013;&#24758;&#26178;&#65292;&#20134;&#21487;&#35242;&#33258;&#20986;&#39340;&#20195;&#26367;&#35299;&#27770;&#12290;<br>
	 * Message: Step forward to solve others' problems when they are unable.
	 */
	public static final NpcStringId STEP_FORWARD_TO_SOLVE_OTHERS_PROBLEMS_WHEN_THEY_ARE_UNABLE;
	
	/**
	 * ID: 1800566<br>
	 * Message: ኱̑ւ̓B<br>
	 * Message: &#25110;&#35377;&#26371;&#30332;&#29983;&#19968;&#20123;&#25613;&#22833;&#65292;&#20294;&#21487;&#30070;&#20316;&#26159;&#23565;&#33258;&#24049;&#30340;&#25237;&#36039;&#12290;<br>
	 * Message: There may be a little loss, but think of it as an investment for yourself.
	 */
	public static final NpcStringId THERE_MAY_BE_A_LITTLE_LOSS_BUT_THINK_OF_IT_AS_AN_INVESTMENT_FOR_YOURSELF;
	
	/**
	 * ID: 1800567<br>
	 * Message: ~~ĂԁBmׂB<br>
	 * Message: &#36010;&#23146;&#26371;&#25307;&#20358;&#26356;&#22823;&#30340;&#36010;&#24565;&#65292;&#38920;&#36969;&#21487;&#32780;&#27490;&#65292;&#30693;&#36275;&#24120;&#27138;&#12290;<br>
	 * Message: Avarice bears a bigger greed, being satisfied with moderation is needed.
	 */
	public static final NpcStringId AVARICE_BEARS_A_BIGGER_GREED_BEING_SATISFIED_WITH_MODERATION_IS_NEEDED;
	
	/**
	 * ID: 1800568<br>
	 * Message: li߂΃guɊ܂B󋵂悭ǂ߁B<br>
	 * Message: &#30450;&#30446;&#34389;&#29702;&#20107;&#24773;&#65292;&#21487;&#33021;&#26371;&#25307;&#20358;&#21475;&#35282;&#65292;&#22240;&#27492;&#38920;&#35264;&#23519;&#21608;&#22285;&#30340;&#29376;&#27841;&#22909;&#22909;&#22320;&#36914;&#34892;&#35215;&#21123;&#12290;<br>
	 * Message: A rational analysis is needed as unplanned actions may bring criticism.
	 */
	public static final NpcStringId A_RATIONAL_ANALYSIS_IS_NEEDED_AS_UNPLANNED_ACTIONS_MAY_BRING_CRITICISM;
	
	/**
	 * ID: 1800569<br>
	 * Message: lӂ߂莩Ȃ݂B<br>
	 * Message: &#22312;&#25351;&#36012;&#20182;&#20154;&#20043;&#21069;&#65292;&#38920;&#20808;&#22238;&#39015;&#33258;&#24049;&#30340;&#21839;&#38988;&#12290;<br>
	 * Message: Reflect upon your shortcomings before criticizing others.
	 */
	public static final NpcStringId REFLECT_UPON_YOUR_SHORTCOMINGS_BEFORE_CRITICIZING_OTHERS;
	
	/**
	 * ID: 1800570<br>
	 * Message: Ƃ̍sŊ@𓦂B㏈ƁB<br>
	 * Message: &#33509;&#26159;&#28858;&#20102;&#33067;&#38626;&#21361;&#38570;&#32780;&#20351;&#20986;&#30340;&#33256;&#27231;&#25033;&#35722;&#65292;&#37027;&#40636;&#38920;&#33457;&#36027;&#26356;&#22823;&#30340;&#24515;&#24605;&#20358;&#34389;&#29702;&#21892;&#24460;&#12290;<br>
	 * Message: Follow-up care is always needed after an emergency evasion.
	 */
	public static final NpcStringId FOLLOW_UP_CARE_IS_ALWAYS_NEEDED_AFTER_AN_EMERGENCY_EVASION;
	
	/**
	 * ID: 1800571<br>
	 * Message: VȒւ̗~킭BLׂB<br>
	 * Message: &#23565;&#26044;&#26032;&#25361;&#25136;&#30340;&#24958;&#26395;&#39640;&#65292;&#20294;&#38920;&#32771;&#24942;&#22823;&#31684;&#22285;&#30340;&#21839;&#38988;&#12290;<br>
	 * Message: You may look for a new challenge but vast knowledge is required.
	 */
	public static final NpcStringId YOU_MAY_LOOK_FOR_A_NEW_CHALLENGE_BUT_VAST_KNOWLEDGE_IS_REQUIRED;
	
	/**
	 * ID: 1800572<br>
	 * Message: vCĥĂΌB<br>
	 * Message: &#25291;&#19979;&#33258;&#23562;&#24515;&#65292;&#20415;&#33021;&#23481;&#26131;&#35299;&#27770;&#35492;&#26371;&#12290;<br>
	 * Message: When one puts aside their ego any misunderstanding will be solved.
	 */
	public static final NpcStringId WHEN_ONE_PUTS_ASIDE_THEIR_EGO_ANY_MISUNDERSTANDING_WILL_BE_SOLVED;
	
	/**
	 * ID: 1800573<br>
	 * Message: VɂȂ炸̏ɎXB<br>
	 * Message: &#20999;&#21247;&#39509;&#20658;&#65292;&#20197;&#35609;&#34395;&#30340;&#24907;&#24230;&#20670;&#32893;&#21608;&#22285;&#30340;&#21240;&#21578;&#12290;<br>
	 * Message: Listen to the advice that's given to you with a humble attitude.
	 */
	public static final NpcStringId LISTEN_TO_THE_ADVICE_THATS_GIVEN_TO_YOU_WITH_A_HUMBLE_ATTITUDE;
	
	/**
	 * ID: 1800574<br>
	 * Message: ɂ鎞ɔB<br>
	 * Message: &#22312;&#20154;&#29983;&#20013;&#30340;&#19978;&#22369;&#33021;&#22816;&#39015;&#24942;&#21040;&#36208;&#19979;&#22369;&#30340;&#24773;&#27841;&#65292;&#20415;&#33021;&#24471;&#21040;&#24179;&#23433;&#12290;<br>
	 * Message: Equilibrium is achieved when one understands a downshift is evident after the rise.
	 */
	public static final NpcStringId EQUILIBRIUM_IS_ACHIEVED_WHEN_ONE_UNDERSTANDS_A_DOWNSHIFT_IS_EVIDENT_AFTER_THE_RISE;
	
	/**
	 * ID: 1800575<br>
	 * Message: ܂nBvʂɐɐi߂B<br>
	 * Message: &#25773;&#19979;&#22810;&#23569;&#30340;&#31278;&#65292;&#20415;&#26371;&#25910;&#31339;&#22810;&#23569;&#65292;&#38920;&#25353;&#29031;&#35336;&#30059;&#35469;&#30495;&#34892;&#20107;&#12290;<br>
	 * Message: What you sow is what you reap, faithfully follow the plan.
	 */
	public static final NpcStringId WHAT_YOU_SOW_IS_WHAT_YOU_REAP_FAITHFULLY_FOLLOW_THE_PLAN;
	
	/**
	 * ID: 1800576<br>
	 * Message: vŎi߂ΐ_IAKIɑ呹Bpӂ͂ƁB<br>
	 * Message: &#38568;&#33288;&#27770;&#23450;&#30340;&#20107;&#24773;&#65292;&#21482;&#26371;&#36896;&#25104;&#31934;&#31070;&#19978;&#21644;&#37329;&#37666;&#19978;&#30340;&#25613;&#22833;&#65292;&#38656;&#35201;&#26377;&#24505;&#24213;&#30340;&#28310;&#20633;&#12290;<br>
	 * Message: Meticulous preparation is needed as spontaneous actions only bear mental and monetary losses.
	 */
	public static final NpcStringId METICULOUS_PREPARATION_IS_NEEDED_AS_SPONTANEOUS_ACTIONS_ONLY_BEAR_MENTAL_AND_MONETARY_LOSSES;
	
	/**
	 * ID: 1800577<br>
	 * Message: l̖ڂɋCĂȂȂIȂB<br>
	 * Message: &#36234;&#26159;&#22312;&#20046;&#20182;&#20154;&#30340;&#24819;&#27861;&#65292;&#36234;&#26371;&#24310;&#36978;&#32080;&#26524;&#12290;<br>
	 * Message: The right time to bear fruit is delayed while the farmer ponders opinions.
	 */
	public static final NpcStringId THE_RIGHT_TIME_TO_BEAR_FRUIT_IS_DELAYED_WHILE_THE_FARMER_PONDERS_OPINIONS;
	
	/**
	 * ID: 1800578<br>
	 * Message: ǂmŏB<br>
	 * Message: &#29087;&#20154;&#20043;&#38291;&#38656;&#35201;&#30456;&#36628;&#30456;&#21161;&#12290;<br>
	 * Message: Help each other among close friends.
	 */
	public static final NpcStringId HELP_EACH_OTHER_AMONG_CLOSE_FRIENDS;
	
	/**
	 * ID: 1800579<br>
	 * Message: ڐׂ̍ȗvɕ߂ȁBlƂ̊֌WB<br>
	 * Message: &#22914;&#26524;&#30041;&#25088;&#30524;&#21069;&#30340;&#23567;&#23567;&#21033;&#30410;&#65292;&#20415;&#26371;&#23481;&#26131;&#36896;&#25104;&#19981;&#33258;&#22312;&#30340;&#38364;&#20418;&#12290;<br>
	 * Message: Obsessing over a small profit will place people apart.
	 */
	public static final NpcStringId OBSESSING_OVER_A_SMALL_PROFIT_WILL_PLACE_PEOPLE_APART;
	
	/**
	 * ID: 1800580<br>
	 * Message: qɕĂ悭悷ȁB<br>
	 * Message: &#33509;&#26377;&#25171;&#36077;&#65292;&#20415;&#19981;&#23452;&#22826;&#36942;&#22312;&#24847;&#20854;&#32080;&#26524;&#12290;<br>
	 * Message: Don't cling to the result of a gamble.
	 */
	public static final NpcStringId DONT_CLING_TO_THE_RESULT_OF_A_GAMBLE;
	
	/**
	 * ID: 1800581<br>
	 * Message: Ȏ̂gűꂠB]TāB<br>
	 * Message: &#23481;&#26131;&#30332;&#29983;&#23567;&#23567;&#30340;&#24847;&#22806;&#21644;&#21475;&#35282;&#65292;&#38920;&#25265;&#20197;&#23532;&#23481;&#30340;&#24515;&#12290;<br>
	 * Message: Small troubles and arguments are ahead, face them with a mature attitude.
	 */
	public static final NpcStringId SMALL_TROUBLES_AND_ARGUMENTS_ARE_AHEAD_FACE_THEM_WITH_A_MATURE_ATTITUDE;
	
	/**
	 * ID: 1800582<br>
	 * Message: 񑩂j΋ꋫɗB<br>
	 * Message: &#33509;&#19981;&#36981;&#23432;&#25215;&#35582;&#65292;&#20415;&#26371;&#38519;&#20837;&#22256;&#22659;&#12290;<br>
	 * Message: Neglecting a promise may put you in distress.
	 */
	public static final NpcStringId NEGLECTING_A_PROMISE_MAY_PUT_YOU_IN_DISTRESS;
	
	/**
	 * ID: 1800583<br>
	 * Message: ̋ꂠB͕ۗB<br>
	 * Message: &#23481;&#26131;&#24536;&#26481;&#24536;&#35199;&#65292;&#26368;&#22909;&#20445;&#30041;&#20132;&#26131;&#12290;<br>
	 * Message: Delay any dealings as you may easily omit addressing what's important to you.
	 */
	public static final NpcStringId DELAY_ANY_DEALINGS_AS_YOU_MAY_EASILY_OMIT_ADDRESSING_WHATS_IMPORTANT_TO_YOU;
	
	/**
	 * ID: 1800584<br>
	 * Message: lƂ̔rɂȂB<br>
	 * Message: &#33287;&#20182;&#20154;&#30456;&#20114;&#27604;&#36611;&#65292;&#20415;&#33021;&#24471;&#21040;&#24171;&#21161;&#12290;<br>
	 * Message: A comparison to others may be helpful.
	 */
	public static final NpcStringId A_COMPARISON_TO_OTHERS_MAY_BE_HELPFUL;
	
	/**
	 * ID: 1800585<br>
	 * Message: ɂ͒ɂ݂tBJbオB<br>
	 * Message: &#22833;&#25943;&#28858;&#25104;&#21151;&#20043;&#27597;&#65292;&#23559;&#26371;&#38754;&#33256;&#33510;&#30433;&#29976;&#20358;&#30340;&#26085;&#23376;&#12290;<br>
	 * Message: What you've endured will return as a benefit.
	 */
	public static final NpcStringId WHAT_YOUVE_ENDURED_WILL_RETURN_AS_A_BENEFIT;
	
	/**
	 * ID: 1800586<br>
	 * Message: VĐsB<br>
	 * Message: &#38754;&#23565;&#30064;&#24615;&#38920;&#20445;&#25345;&#39080;&#24230;&#65292;&#20006;&#36367;&#19978;&#27491;&#36947;&#12290;<br>
	 * Message: Try to be courteous to the opposite sex and follow a virtuous path.
	 */
	public static final NpcStringId TRY_TO_BE_COURTEOUS_TO_THE_OPPOSITE_SEX_AND_FOLLOW_A_VIRTUOUS_PATH;
	
	/**
	 * ID: 1800587<br>
	 * Message: ȂƂő傫ȏ΂B<br>
	 * Message: &#24478;&#33437;&#40635;&#23567;&#20107;&#20063;&#21487;&#23563;&#25214;&#24555;&#27138;&#12290;<br>
	 * Message: Joy may come from small things.
	 */
	public static final NpcStringId JOY_MAY_COME_FROM_SMALL_THINGS;
	
	/**
	 * ID: 1800588<br>
	 * Message: ʂ悵BMčsB<br>
	 * Message: &#32080;&#26524;&#23559;&#26371;&#22291;&#28415;&#22914;&#24847;&#65292;&#38920;&#25265;&#20197;&#33258;&#20449;&#34892;&#20107;&#12290;<br>
	 * Message: Be confident in your actions as good luck shadows the result.
	 */
	public static final NpcStringId BE_CONFIDENT_IN_YOUR_ACTIONS_AS_GOOD_LUCK_SHADOWS_THE_RESULT;
	
	/**
	 * ID: 1800589<br>
	 * Message: ܂Ƃ낪ȂȂ瓰XƌB<br>
	 * Message: &#20449;&#29992;&#26041;&#38754;&#65292;&#22914;&#26524;&#33258;&#35469;&#19981;&#24871;&#26044;&#19990;&#65292;&#20415;&#21487;&#22530;&#22530;&#27491;&#27491;&#30340;&#38754;&#23565;&#12290;<br>
	 * Message: Be confident without hesitation when your honesty is above reproach in dealings.
	 */
	public static final NpcStringId BE_CONFIDENT_WITHOUT_HESITATION_WHEN_YOUR_HONESTY_IS_ABOVE_REPROACH_IN_DEALINGS;
	
	/**
	 * ID: 1800590<br>
	 * Message: eɂVBȂΌǗ̋B<br>
	 * Message: &#33287;&#29087;&#20154;&#30456;&#38364;&#30340;&#20107;&#24773;&#65292;&#25110;&#35377;&#26371;&#35731;&#33258;&#24049;&#23396;&#31435;&#65292;&#22240;&#27492;&#35442;&#36981;&#23432;&#30340;&#36996;&#26159;&#24471;&#36981;&#23432;&#12290;<br>
	 * Message: A matter related to a close friend can isolate you, keep staying on the right path.
	 */
	public static final NpcStringId A_MATTER_RELATED_TO_A_CLOSE_FRIEND_CAN_ISOLATE_YOU_KEEP_STAYING_ON_THE_RIGHT_PATH;
	
	/**
	 * ID: 1800591<br>
	 * Message: ʂ̂Ƃł܂ł悭悷ȁB悩ʂƂNB<br>
	 * Message: &#33509;&#36942;&#26044;&#22312;&#20046;&#32080;&#26524;&#65292;&#20415;&#26371;&#36899;&#32396;&#30332;&#29983;&#19981;&#22909;&#30340;&#20107;&#24773;&#12290;<br>
	 * Message: Too much focus on the result may bring continuous misfortune.
	 */
	public static final NpcStringId TOO_MUCH_FOCUS_ON_THE_RESULT_MAY_BRING_CONTINUOUS_MISFORTUNE;
	
	/**
	 * ID: 1800592<br>
	 * Message: rœoΌXƂɂȂBCāB<br>
	 * Message: &#20013;&#36884;&#25918;&#26820;&#65292;&#20415;&#26371;&#23566;&#33268;&#38627;&#20197;&#22949;&#21892;&#34389;&#29702;&#21892;&#24460;&#65292;&#38920;&#22533;&#25345;&#21040;&#24213;&#12290;<br>
	 * Message: Be tenacious until the finish as halfway abandonment causes a troubled ending.
	 */
	public static final NpcStringId BE_TENACIOUS_UNTIL_THE_FINISH_AS_HALFWAY_ABANDONMENT_CAUSES_A_TROUBLED_ENDING;
	
	/**
	 * ID: 1800593<br>
	 * Message: c̍sł͓ȂB<br>
	 * Message: &#22312;&#22296;&#39636;&#20839;&#34892;&#21205;&#65292;&#38627;&#20197;&#24471;&#21040;&#21033;&#30410;&#12290;<br>
	 * Message: There will be no advantage in a group deal.
	 */
	public static final NpcStringId THERE_WILL_BE_NO_ADVANTAGE_IN_A_GROUP_DEAL;
	
	/**
	 * ID: 1800594<br>
	 * Message: ł΂炸B󋵂ɂ͔\IɑΏB<br>
	 * Message: &#33287;&#20854;&#20986;&#38957;&#36894;&#24375;&#65292;&#19981;&#22914;&#36864;&#24460;&#19968;&#27493;&#20358;&#31309;&#26997;&#22320;&#34389;&#29702;&#29376;&#27841;&#12290;<br>
	 * Message: Refrain from stepping-up but take a moment to ponder to be flexible with situations.
	 */
	public static final NpcStringId REFRAIN_FROM_STEPPING_UP_BUT_TAKE_A_MOMENT_TO_PONDER_TO_BE_FLEXIBLE_WITH_SITUATIONS;
	
	/**
	 * ID: 1800595<br>
	 * Message: őpďȍK^߁B<br>
	 * Message: &#21892;&#29992;&#24773;&#22577;&#65292;&#23601;&#26377;&#27231;&#26371;&#25235;&#20303;&#23567;&#23567;&#30340;&#24184;&#36939;&#12290;<br>
	 * Message: There will be a small opportunity when information is best utilized.
	 */
	public static final NpcStringId THERE_WILL_BE_A_SMALL_OPPORTUNITY_WHEN_INFORMATION_IS_BEST_UTILIZED;
	
	/**
	 * ID: 1800596<br>
	 * Message: ̋ꂠB厖Ȃ̂Ȃ炿ƕۊǂB<br>
	 * Message: &#23481;&#26131;&#36986;&#22833;&#29289;&#21697;&#65292;&#33509;&#26159;&#29645;&#24796;&#30340;&#29289;&#21697;&#65292;&#21209;&#24517;&#35201;&#24910;&#37325;&#20445;&#31649;&#12290;<br>
	 * Message: Belongings are at loose ends, keep track of the things you value.
	 */
	public static final NpcStringId BELONGINGS_ARE_AT_LOOSE_ENDS_KEEP_TRACK_OF_THE_THINGS_YOU_VALUE;
	
	/**
	 * ID: 1800597<br>
	 * Message: w͕͂B<br>
	 * Message: &#21162;&#21147;&#30340;&#35441;&#65292;&#33258;&#28982;&#26371;&#24471;&#21040;&#30456;&#25033;&#30340;&#20195;&#20729;&#65292;&#38920;&#20840;&#21147;&#20197;&#36212;&#12290;<br>
	 * Message: What you sow is what you reap, try your best.
	 */
	public static final NpcStringId WHAT_YOU_SOW_IS_WHAT_YOU_REAP_TRY_YOUR_BEST;
	
	/**
	 * ID: 1800598<br>
	 * Message: VɃX^[g؂CŗՂ߂΁Asɕ₦B<br>
	 * Message: &#25265;&#20197;&#26032;&#38283;&#22987;&#30340;&#24515;&#24773;&#20358;&#34892;&#20107;&#65292;&#20415;&#33021;&#36805;&#36895;&#24396;&#35036;&#19981;&#36275;&#30340;&#37096;&#20998;&#12290;<br>
	 * Message: With the beginner's attitude, shortcomings can be easily mended.
	 */
	public static final NpcStringId WITH_THE_BEGINNERS_ATTITUDE_SHORTCOMINGS_CAN_BE_EASILY_MENDED;
	
	/**
	 * ID: 1800599<br>
	 * Message: 肪ΕSɕςB<br>
	 * Message: &#33509;&#26377;&#22256;&#38627;&#65292;&#23452;&#36681;&#21521;&#20840;&#26032;&#30340;&#26041;&#21521;&#25720;&#32034;&#12290;<br>
	 * Message: When facing difficulties, seek a totally different direction.
	 */
	public static final NpcStringId WHEN_FACING_DIFFICULTIES_SEEK_A_TOTALLY_DIFFERENT_DIRECTION;
	
	/**
	 * ID: 1800600<br>
	 * Message: ~̒肷Őςݏd˂ĂƂxɕB<br>
	 * Message: &#36942;&#24230;&#30340;&#36010;&#23146;&#65292;&#26371;&#23559;&#33267;&#20170;&#25152;&#32047;&#31309;&#30340;&#19968;&#25475;&#32780;&#31354;&#12290;<br>
	 * Message: Lifetime savings can disappear with one-time greed.
	 */
	public static final NpcStringId LIFETIME_SAVINGS_CAN_DISAPPEAR_WITH_ONE_TIME_GREED;
	
	/**
	 * ID: 1800601<br>
	 * Message: ɘ_͎ΐS₩B<br>
	 * Message: &#25511;&#21046;&#26997;&#31471;&#30340;&#24819;&#27861;&#65292;&#20415;&#33021;&#20445;&#25345;&#26368;&#20339;&#24515;&#24773;&#12290;<br>
	 * Message: With your heart avoid extremes and peace will stay.
	 */
	public static final NpcStringId WITH_YOUR_HEART_AVOID_EXTREMES_AND_PEACE_WILL_STAY;
	
	/**
	 * ID: 1800602<br>
	 * Message: u̖fŉAjڂɁB<br>
	 * Message: &#31245;&#19968;&#22833;&#31070;&#65292;&#23601;&#26377;&#21487;&#33021;&#36973;&#21475;&#33292;&#20043;&#28797;&#65292;&#38920;&#35641;&#24910;&#12290;<br>
	 * Message: Be cautious as instant recklessness may bring malicious gossip.
	 */
	public static final NpcStringId BE_CAUTIOUS_AS_INSTANT_RECKLESSNESS_MAY_BRING_MALICIOUS_GOSSIP;
	
	/**
	 * ID: 1800603<br>
	 * Message: ~ӂB߂Ō܂ł΂B<br>
	 * Message: &#22909;&#21213;&#24515;&#21313;&#36275;&#65292;&#25925;&#19981;&#35201;&#25918;&#26820;&#65292;&#38920;&#22533;&#25345;&#21040;&#24213;&#12290;<br>
	 * Message: Be tenacious to the end because a strong luck with winning is ahead.
	 */
	public static final NpcStringId BE_TENACIOUS_TO_THE_END_BECAUSE_A_STRONG_LUCK_WITH_WINNING_IS_AHEAD;
	
	/**
	 * ID: 1800604<br>
	 * Message: ߂lɂ͋Cg₳B͐l̂߂Ȃ炸B<br>
	 * Message: &#38364;&#24515;&#21608;&#22285;&#30340;&#29087;&#20154;&#20006;&#35242;&#20999;&#30456;&#24453;&#65292;&#26085;&#24460;&#20415;&#33021;&#36629;&#26131;&#24471;&#21040;&#24171;&#21161;&#12290;<br>
	 * Message: Be kind to and care for those close to you, they may help in the future.
	 */
	public static final NpcStringId BE_KIND_TO_AND_CARE_FOR_THOSE_CLOSE_TO_YOU_THEY_MAY_HELP_IN_THE_FUTURE;
	
	/**
	 * ID: 1800605<br>
	 * Message: |WeBuVLOʂɂȂB<br>
	 * Message: &#31177;&#25345;&#31309;&#26997;&#30340;&#24819;&#27861;&#65292;&#20415;&#26371;&#24118;&#20358;&#22909;&#32080;&#26524;&#12290;<br>
	 * Message: Positivity may bring good results.
	 */
	public static final NpcStringId POSITIVITY_MAY_BRING_GOOD_RESULTS;
	
	/**
	 * ID: 1800606<br>
	 * Message: ߂l̃~X͂΂ĂB<br>
	 * Message: &#38656;&#35201;&#21253;&#23481;&#29087;&#20154;&#30340;&#36942;&#37679;&#12290;<br>
	 * Message: Be gracious to cover a close friend's fault.
	 */
	public static final NpcStringId BE_GRACIOUS_TO_COVER_A_CLOSE_FRIENDS_FAULT;
	
	/**
	 * ID: 1800607<br>
	 * Message: \zO̎xoB<br>
	 * Message: &#23559;&#26371;&#26377;&#24847;&#24819;&#19981;&#21040;&#30340;&#25903;&#20986;&#65292;&#38920;&#30041;&#24847;&#12290;<br>
	 * Message: Be prepared for an expected cost.
	 */
	public static final NpcStringId BE_PREPARED_FOR_AN_EXPECTED_COST;
	
	/**
	 * ID: 1800608<br>
	 * Message: ĂłȂΌǂB؂ʂvB<br>
	 * Message: &#33509;&#19981;&#38283;&#25079;&#24515;&#33016;&#20358;&#35299;&#27770;&#21839;&#38988;&#65292;&#23559;&#26371;&#29986;&#29983;&#24460;&#36986;&#30151;&#65292;&#33287;&#20854;&#30456;&#20114;&#29229;&#35542;&#65292;&#19981;&#22914;&#38364;&#25079;&#23565;&#26041;&#12290;<br>
	 * Message: Be considerate to others and avoid focusing only on winning or a wound will be left untreated.
	 */
	public static final NpcStringId BE_CONSIDERATE_TO_OTHERS_AND_AVOID_FOCUSING_ONLY_ON_WINNING_OR_A_WOUND_WILL_BE_LEFT_UNTREATED;
	
	/**
	 * ID: 1800609<br>
	 * Message: ANZT[bL[ACeB<br>
	 * Message: &#35037;&#39166;&#21697;&#20043;&#39006;&#30340;&#29289;&#21697;&#23559;&#26371;&#24118;&#20358;&#24184;&#36939;&#12290;<br>
	 * Message: An accessory or decoration may bring a good luck.
	 */
	public static final NpcStringId AN_ACCESSORY_OR_DECORATION_MAY_BRING_A_GOOD_LUCK;
	
	/**
	 * ID: 1800610<br>
	 * Message: dČB͖LB<br>
	 * Message: &#33258;&#24859;&#12289;&#35609;&#34395;&#25165;&#26371;&#24118;&#20358;&#22909;&#32080;&#26524;&#12290;<br>
	 * Message: Only reflection and humility may bring success.
	 */
	public static final NpcStringId ONLY_REFLECTION_AND_HUMILITY_MAY_BRING_SUCCESS;
	
	/**
	 * ID: 1800611<br>
	 * Message: ׂȌɂȂB<br>
	 * Message: &#22240;&#23567;&#23567;&#35492;&#26371;&#65292;&#25110;&#35377;&#26371;&#30332;&#29983;&#24773;&#24863;&#19978;&#30340;&#29229;&#22519;&#12290;<br>
	 * Message: A small misunderstanding may cause quarrels.
	 */
	public static final NpcStringId A_SMALL_MISUNDERSTANDING_MAY_CAUSE_QUARRELS;
	
	/**
	 * ID: 1800612<br>
	 * Message: ]Tĉ~ɐi߂B<br>
	 * Message: &#33287;&#20854;&#21193;&#24375;&#36914;&#34892;&#65292;&#19981;&#22914;&#21033;&#29992;&#20805;&#20998;&#30340;&#26178;&#38291;&#22291;&#28415;&#36914;&#34892;&#12290;<br>
	 * Message: Avoid advancing beyond your ability and focus on the flowing stream.
	 */
	public static final NpcStringId AVOID_ADVANCING_BEYOND_YOUR_ABILITY_AND_FOCUS_ON_THE_FLOWING_STREAM;
	
	/**
	 * ID: 1800613<br>
	 * Message: ~炸v̐SāBSȂĂʂ낤B<br>
	 * Message: &#33287;&#20854;&#28415;&#36275;&#33258;&#24049;&#30340;&#36010;&#24565;&#65292;&#19981;&#22914;&#20808;&#38364;&#25079;&#20182;&#20154;&#65292;&#20415;&#26371;&#24471;&#21040;&#22909;&#32080;&#26524;&#12290;<br>
	 * Message: Considering others with a good heart before self-interest will bring a triumph.
	 */
	public static final NpcStringId CONSIDERING_OTHERS_WITH_A_GOOD_HEART_BEFORE_SELF_INTEREST_WILL_BRING_A_TRIUMPH;
	
	/**
	 * ID: 1800614<br>
	 * Message: sȂƂɍsB<br>
	 * Message: &#21069;&#24448;&#24478;&#26410;&#21435;&#36942;&#30340;&#22320;&#26041;&#65292;&#20415;&#26371;&#24471;&#21040;&#24184;&#36939;&#12290;<br>
	 * Message: Visiting a place you've never been before may bring luck.
	 */
	public static final NpcStringId VISITING_A_PLACE_YOUVE_NEVER_BEEN_BEFORE_MAY_BRING_LUCK;
	
	/**
	 * ID: 1800615<br>
	 * Message: l̏W܂Ƃ납K^ĂB<br>
	 * Message: &#22312;&#20154;&#23569;&#30340;&#22320;&#26041;&#65292;&#23559;&#26371;&#30332;&#29983;&#22909;&#20107;&#24773;&#12290;<br>
	 * Message: A good thing may happen in a place with a few people.
	 */
	public static final NpcStringId A_GOOD_THING_MAY_HAPPEN_IN_A_PLACE_WITH_A_FEW_PEOPLE;
	
	/**
	 * ID: 1800616<br>
	 * Message: Ȃ̂͂yĐMpB[AĂA^ʖڂKvB<br>
	 * Message: &#27963;&#28497;&#22266;&#28982;&#26159;&#22909;&#65292;&#20294;&#19968;&#19981;&#23567;&#24515;&#20415;&#26371;&#35492;&#35299;&#28858;&#26159;&#20491;&#36629;&#28014;&#30340;&#20154;&#32780;&#22833;&#21435;&#20449;&#29992;&#65292;&#22240;&#27492;&#20445;&#25345;&#31337;&#37325;&#21371;&#19981;&#22833;&#24189;&#40664;&#25165;&#26159;&#20491;&#38364;&#37749;&#12290;<br>
	 * Message: Being high-strung can cause loss of trust from others because it can be viewed as light-hearted, act sincerely but yet do not lack humor.
	 */
	public static final NpcStringId BEING_HIGH_STRUNG_CAN_CAUSE_LOSS_OF_TRUST_FROM_OTHERS_BECAUSE_IT_CAN_BE_VIEWED_AS_LIGHT_HEARTED_ACT_SINCERELY_BUT_YET_DO_NOT_LACK_HUMOR;
	
	/**
	 * ID: 1800617<br>
	 * Message: ߒɖ肪ĂA㏈肷΂ʂB<br>
	 * Message: &#20013;&#38291;&#36942;&#31243;&#38614;&#26377;&#40670;&#30095;&#24573;&#65292;&#20294;&#21482;&#35201;&#22949;&#21892;&#34389;&#29702;&#21892;&#24460;&#65292;&#20415;&#26371;&#24471;&#21040;&#22909;&#32080;&#26524;&#12290;<br>
	 * Message: Perfection at the finish can cover faulty work in the process.
	 */
	public static final NpcStringId PERFECTION_AT_THE_FINISH_CAN_COVER_FAULTY_WORK_IN_THE_PROCESS;
	
	/**
	 * ID: 1800618<br>
	 * Message: dΓ̂Bꏊ΂̕܂B<br>
	 * Message: &#24037;&#20316;&#37327;&#22686;&#21152;&#34920;&#31034;&#25910;&#29554;&#20063;&#22810;&#65292;&#21482;&#35201;&#19981;&#24608;&#24930;&#65292;&#20415;&#33021;&#24471;&#21040;&#28415;&#36275;&#30340;&#22577;&#37228;&#12290;<br>
	 * Message: Abstain from laziness, much work brings many gains and satisfactory rewards.
	 */
	public static final NpcStringId ABSTAIN_FROM_LAZINESS_MUCH_WORK_BRINGS_MANY_GAINS_AND_SATISFACTORY_REWARDS;
	
	/**
	 * ID: 1800619<br>
	 * Message: ꃖɗ܂炸ǂǂ񓮂B<br>
	 * Message: &#33287;&#20854;&#38263;&#26399;&#24453;&#22312;&#21516;&#19968;&#22320;&#26041;&#65292;&#19981;&#22914;&#24537;&#30860;&#22320;&#21040;&#34389;&#36208;&#21205;&#65292;&#20415;&#33021;&#24471;&#21040;&#24171;&#21161;&#12290;<br>
	 * Message: Staying busy rather than being stationary will help.
	 */
	public static final NpcStringId STAYING_BUSY_RATHER_THAN_BEING_STATIONARY_WILL_HELP;
	
	/**
	 * ID: 1800620<br>
	 * Message: lŔwŗUfł߂ɂȂB<br>
	 * Message: &#29544;&#33258;&#34389;&#29702;&#20107;&#24773;&#26178;&#65292;&#24456;&#23481;&#26131;&#38519;&#20837;&#35480;&#24785;&#65292;&#38920;&#35641;&#24910;&#12290;<br>
	 * Message: Handling the work by yourself may lead you into temptation.
	 */
	public static final NpcStringId HANDLING_THE_WORK_BY_YOURSELF_MAY_LEAD_YOU_INTO_TEMPTATION;
	
	/**
	 * ID: 1800621<br>
	 * Message: ȂƂłXB<br>
	 * Message: &#23601;&#31639;&#26159;&#21608;&#22285;&#30340;&#23567;&#20107;&#24773;&#20063;&#19981;&#35201;&#36629;&#26131;&#30095;&#24573;&#65292;&#38920;&#27927;&#32819;&#24685;&#32893;&#12290;<br>
	 * Message: Pay attention to any small advice without being indifferent.
	 */
	public static final NpcStringId PAY_ATTENTION_TO_ANY_SMALL_ADVICE_WITHOUT_BEING_INDIFFERENT;
	
	/**
	 * ID: 1800622<br>
	 * Message: 炵ג҂̗\BȂƂ؂ɂB<br>
	 * Message: &#31309;&#23569;&#25104;&#22810;&#65292;&#33437;&#40635;&#23567;&#20107;&#20063;&#24471;&#29645;&#24796;&#12290;<br>
	 * Message: Small things make up big things so even value trivial matters.
	 */
	public static final NpcStringId SMALL_THINGS_MAKE_UP_BIG_THINGS_SO_EVEN_VALUE_TRIVIAL_MATTERS;
	
	/**
	 * ID: 1800623<br>
	 * Message: ̂҂AĂ܂B<br>
	 * Message: &#33287;&#20854;&#31561;&#24453;&#26178;&#27231;&#25104;&#29087;&#65292;&#19981;&#22914;&#20027;&#21205;&#34892;&#20107;&#65292;&#20415;&#26371;&#24471;&#21040;&#26356;&#24555;&#30340;&#32080;&#26524;&#12290;<br>
	 * Message: Action toward the result rather than waiting for the right circumstances may lead you to a fast success.
	 */
	public static final NpcStringId ACTION_TOWARD_THE_RESULT_RATHER_THAN_WAITING_FOR_THE_RIGHT_CIRCUMSTANCES_MAY_LEAD_YOU_TO_A_FAST_SUCCESS;
	
	/**
	 * ID: 1800624<br>
	 * Message: Ƃxȍ͎ɂȂBɂނȁB<br>
	 * Message: &#23567;&#23567;&#30340;&#25903;&#20986;&#65292;&#25110;&#35377;&#26371;&#25104;&#28858;&#19968;&#20491;&#21332;&#21161;&#21608;&#22285;&#30340;&#29872;&#31680;&#65292;&#20999;&#21247;&#21533;&#24796;&#20184;&#20986;&#12290;<br>
	 * Message: Don't try to save small expenditures, it will lead to future returns.
	 */
	public static final NpcStringId DONT_TRY_TO_SAVE_SMALL_EXPENDITURES_IT_WILL_LEAD_TO_FUTURE_RETURNS;
	
	/**
	 * ID: 1800625<br>
	 * Message: Ufɘf킳₷B}B<br>
	 * Message: &#26131;&#26044;&#21463;&#21040;&#35480;&#24785;&#65292;&#38656;&#35201;&#27880;&#24847;&#24863;&#24773;&#19978;&#30340;&#25511;&#21046;&#12290;<br>
	 * Message: Be cautious to control emotions as temptations are nearby.
	 */
	public static final NpcStringId BE_CAUTIOUS_TO_CONTROL_EMOTIONS_AS_TEMPTATIONS_ARE_NEARBY;
	
	/**
	 * ID: 1800626<br>
	 * Message: ȂƂƑaɂāAŋƂɂȂB<br>
	 * Message: &#35469;&#28858;&#23567;&#20107;&#32780;&#30095;&#24573;&#65292;&#20415;&#26371;&#25307;&#20358;&#29436;&#29437;&#19981;&#22570;&#30340;&#32080;&#26524;&#65292;&#38920;&#35641;&#24910;&#12290;<br>
	 * Message: Be warned as neglecting a matter because it's small can cause you trouble.
	 */
	public static final NpcStringId BE_WARNED_AS_NEGLECTING_A_MATTER_BECAUSE_ITS_SMALL_CAN_CAUSE_YOU_TROUBLE;
	
	/**
	 * ID: 1800627<br>
	 * Message: ߖxBgׂƂ͎gB<br>
	 * Message: &#21247;&#36942;&#24230;&#31680;&#30465;&#65292;&#35442;&#33457;&#36027;&#30340;&#26178;&#20505;&#20063;&#38656;&#35201;&#36969;&#30070;&#29992;&#37666;&#12290;<br>
	 * Message: Spend when needed rather than trying to unconditionally save.
	 */
	public static final NpcStringId SPEND_WHEN_NEEDED_RATHER_THAN_TRYING_TO_UNCONDITIONALLY_SAVE;
	
	/**
	 * ID: 1800628<br>
	 * Message: ΌɂƂ΁A𓾂ĂB<br>
	 * Message: &#20559;&#35211;&#22312;&#20808;&#65292;&#24471;&#23567;&#21371;&#22833;&#22823;&#12290;<br>
	 * Message: Prejudice will take you to a small gain with a big loss.
	 */
	public static final NpcStringId PREJUDICE_WILL_TAKE_YOU_TO_A_SMALL_GAIN_WITH_A_BIG_LOSS;
	
	/**
	 * ID: 1800629<br>
	 * Message: bL[ACe̓XC[cB<br>
	 * Message: &#39321;&#29980;&#21475;&#21619;&#30340;&#39154;&#39135;&#23559;&#26371;&#24118;&#20358;&#24184;&#36939;&#12290;<br>
	 * Message: Sweet food may bring good luck.
	 */
	public static final NpcStringId SWEET_FOOD_MAY_BRING_GOOD_LUCK;
	
	/**
	 * ID: 1800630<br>
	 * Message: ؋͕ԂĂ炦B͕UĂ炦B<br>
	 * Message: &#23559;&#25910;&#22238;&#20511;&#20986;&#30340;&#37666;&#65292;&#25110;&#23565;&#36942;&#21435;&#30340;&#25613;&#22833;&#24471;&#21040;&#35036;&#20767;&#12290;<br>
	 * Message: You may be paid for what you're owed or for your past loss.
	 */
	public static final NpcStringId YOU_MAY_BE_PAID_FOR_WHAT_YOURE_OWED_OR_FOR_YOUR_PAST_LOSS;
	
	/**
	 * ID: 1800631<br>
	 * Message: {̖ŖCNB<br>
	 * Message: &#22240;&#22522;&#26412;&#19978;&#30340;&#21839;&#38988;&#23559;&#26371;&#30332;&#29983;&#19968;&#20123;&#25705;&#25830;&#12290;<br>
	 * Message: There may be conflict in basic matters.
	 */
	public static final NpcStringId THERE_MAY_BE_CONFLICT_IN_BASIC_MATTERS;
	
	/**
	 * ID: 1800632<br>
	 * Message: ߂l̏ȍsɋCgBA͋֕B<br>
	 * Message: &#38364;&#24515;&#29087;&#20154;&#30340;&#19968;&#33289;&#19968;&#21205;&#65292;&#20294;&#20999;&#21247;&#32102;&#20104;&#36942;&#24230;&#30340;&#38364;&#20999;&#12290;<br>
	 * Message: Be observant to close friends' small behaviors while refraining from excessive kindness.
	 */
	public static final NpcStringId BE_OBSERVANT_TO_CLOSE_FRIENDS_SMALL_BEHAVIORS_WHILE_REFRAINING_FROM_EXCESSIVE_KINDNESS;
	
	/**
	 * ID: 1800633<br>
	 * Message: XgX͕\ɏoAΊYȁB<br>
	 * Message: &#20999;&#21247;&#23559;&#22739;&#21147;&#34920;&#29694;&#20986;&#20358;&#65292;&#20134;&#21247;&#22833;&#21435;&#31505;&#23481;&#12290;<br>
	 * Message: Do not show your distress nor lose your smile.
	 */
	public static final NpcStringId DO_NOT_SHOW_YOUR_DISTRESS_NOR_LOSE_YOUR_SMILE;
	
	/**
	 * ID: 1800634<br>
	 * Message: ωΏ𓾂B<br>
	 * Message: &#23637;&#29694;&#35722;&#21270;&#30340;&#38754;&#35980;&#65292;&#20415;&#26371;&#24471;&#21040;&#24171;&#21161;&#12290;<br>
	 * Message: Showing change may be of help.
	 */
	public static final NpcStringId SHOWING_CHANGE_MAY_BE_OF_HELP;
	
	/**
	 * ID: 1800635<br>
	 * Message: ԊǗOꂹB]݂̌ʂB<br>
	 * Message: &#24505;&#24213;&#31649;&#29702;&#26178;&#38291;&#65292;&#20415;&#33021;&#24471;&#21040;&#26399;&#30460;&#30340;&#32080;&#26524;&#12290;<br>
	 * Message: The intended result may be on your way if the time is perfectly managed.
	 */
	public static final NpcStringId THE_INTENDED_RESULT_MAY_BE_ON_YOUR_WAY_IF_THE_TIME_IS_PERFECTLY_MANAGED;
	
	/**
	 * ID: 1800636<br>
	 * Message: ZʂȂȂA炢ƂNB<br>
	 * Message: &#19981;&#33021;&#35722;&#36890;&#65292;&#20415;&#26371;&#38519;&#20837;&#22256;&#22659;&#12290;<br>
	 * Message: Hardships may arise if flexibility is not well played.
	 */
	public static final NpcStringId HARDSHIPS_MAY_ARISE_IF_FLEXIBILITY_IS_NOT_WELL_PLAYED;
	
	/**
	 * ID: 1800637<br>
	 * Message: fbꐶBÂɁB<br>
	 * Message: &#31245;&#19968;&#22833;&#31070;&#25110;&#36942;&#26044;&#23433;&#24515;&#20415;&#26371;&#22833;&#31639;&#65292;&#38920;&#20445;&#25345;&#20919;&#38748;&#30340;&#24907;&#24230;&#12290;<br>
	 * Message: Keep cool headed because carelessness or inattentiveness may cause misfortune.
	 */
	public static final NpcStringId KEEP_COOL_HEADED_BECAUSE_CARELESSNESS_OR_INATTENTIVENESS_MAY_CAUSE_MISFORTUNE;
	
	/**
	 * ID: 1800638<br>
	 * Message: ͉̒B<br>
	 * Message: &#26152;&#22812;&#33509;&#20570;&#20102;&#20491;&#24801;&#22818;&#65292;&#25110;&#35377;&#26371;&#20663;&#21040;&#36523;&#39636;&#65292;&#38920;&#35641;&#24910;&#12290;<br>
	 * Message: Be cautious as you may get hurt after last night's sinister dream.
	 */
	public static final NpcStringId BE_CAUTIOUS_AS_YOU_MAY_GET_HURT_AFTER_LAST_NIGHTS_SINISTER_DREAM;
	
	/**
	 * ID: 1800639<br>
	 * Message: ^BɗΑB<br>
	 * Message: &#36001;&#36939;&#20339;&#65292;&#20294;&#34987;&#20154;&#24773;&#24038;&#21491;&#65292;&#23559;&#26371;&#25307;&#20358;&#25613;&#22833;&#65292;&#38920;&#35641;&#24910;&#12290;<br>
	 * Message: A strong wealth luck is ahead but be careful with emotions that may bring losses.
	 */
	public static final NpcStringId A_STRONG_WEALTH_LUCK_IS_AHEAD_BUT_BE_CAREFUL_WITH_EMOTIONS_THAT_MAY_BRING_LOSSES;
	
	/**
	 * ID: 1800640<br>
	 * Message: DȐl֘A邱ƂȂ]ݓxʂi߂Ă悢B<br>
	 * Message: &#21482;&#35201;&#26159;&#26377;&#38364;&#24515;&#19978;&#20154;&#30340;&#20107;&#65292;&#20415;&#21487;&#38568;&#24515;&#25152;&#27442;&#22320;&#36914;&#34892;&#12290;<br>
	 * Message: Proceed as you wish when it's pertinent to the person you like.
	 */
	public static final NpcStringId PROCEED_AS_YOU_WISH_WHEN_ITS_PERTINENT_TO_THE_PERSON_YOU_LIKE;
	
	/**
	 * ID: 1800641<br>
	 * Message: ِƘbĐSʂB<br>
	 * Message: &#33287;&#30064;&#24615;&#20132;&#35527;&#20043;&#24460;&#65292;&#23559;&#26371;&#24444;&#27492;&#20102;&#35299;&#23565;&#26041;&#12290;<br>
	 * Message: You may deepen the relationship with the opposite sex through conversation.
	 */
	public static final NpcStringId YOU_MAY_DEEPEN_THE_RELATIONSHIP_WITH_THE_OPPOSITE_SEX_THROUGH_CONVERSATION;
	
	/**
	 * ID: 1800642<br>
	 * Message: ɎcƂɓ̂gB<br>
	 * Message: &#25237;&#36039;&#22312;&#21487;&#20197;&#27704;&#23384;&#30340;&#29289;&#21697;&#19978;&#65292;&#20415;&#21487;&#24471;&#21040;&#21033;&#30410;&#12290;<br>
	 * Message: Investment into solid material may bring profit.
	 */
	public static final NpcStringId INVESTMENT_INTO_SOLID_MATERIAL_MAY_BRING_PROFIT;
	
	/**
	 * ID: 1800643<br>
	 * Message: yƂɓΏ𓾂B<br>
	 * Message: &#25237;&#36039;&#22312;&#21487;&#20197;&#20139;&#27138;&#30340;&#20107;&#24773;&#19978;&#65292;&#20415;&#21487;&#24471;&#21040;&#21033;&#30410;&#12290;<br>
	 * Message: Investment into what you enjoy may be of help.
	 */
	public static final NpcStringId INVESTMENT_INTO_WHAT_YOU_ENJOY_MAY_BE_OF_HELP;
	
	/**
	 * ID: 1800644<br>
	 * Message: ZȂBттƍsB<br>
	 * Message: &#24456;&#22810;&#20107;&#24773;&#38656;&#35201;&#34389;&#29702;&#65292;&#26368;&#22909;&#21220;&#24555;&#19968;&#40670;&#12290;<br>
	 * Message: Being busy may help catching up with many changes.
	 */
	public static final NpcStringId BEING_BUSY_MAY_HELP_CATCHING_UP_WITH_MANY_CHANGES;
	
	/**
	 * ID: 1800645<br>
	 * Message: u̖fŉAjڂɁB<br>
	 * Message: &#38754;&#33256;&#36984;&#25799;&#30340;&#26178;&#21051;&#26178;&#65292;&#33287;&#20854;&#36984;&#25799;&#21517;&#35709;&#65292;&#19981;&#22914;&#24448;&#23526;&#24800;&#30340;&#26041;&#21521;&#36993;&#36914;&#12290;<br>
	 * Message: Choose substance over honor.
	 */
	public static final NpcStringId CHOOSE_SUBSTANCE_OVER_HONOR;
	
	/**
	 * ID: 1800646<br>
	 * Message: K̎͋BƂĂB<br>
	 * Message: &#23601;&#31639;&#20570;&#20102;&#21892;&#20107;&#20063;&#32893;&#19981;&#21040;&#22909;&#35441;&#30340;&#23601;&#26159;&#37329;&#37666;&#20132;&#26131;&#65292;&#26368;&#22909;&#36996;&#26159;&#25298;&#32085;&#12290;<br>
	 * Message: Remember to decline any financial dealings because a good deed may return as resentment.
	 */
	public static final NpcStringId REMEMBER_TO_DECLINE_ANY_FINANCIAL_DEALINGS_BECAUSE_A_GOOD_DEED_MAY_RETURN_AS_RESENTMENT;
	
	/**
	 * ID: 1800647<br>
	 * Message: Ζʂł͎ŝȂ悤ɁB<br>
	 * Message: &#34389;&#34389;&#35641;&#24910;&#65292;&#36991;&#20813;&#23565;&#26032;&#20154;&#20570;&#37679;&#20107;&#12290;<br>
	 * Message: Be careful not to make a mistake with a new person.
	 */
	public static final NpcStringId BE_CAREFUL_NOT_TO_MAKE_A_MISTAKE_WITH_A_NEW_PERSON;
	
	/**
	 * ID: 1800648<br>
	 * Message: ȂȂȂƂɎԂĂȂBȁB<br>
	 * Message: &#26371;&#25302;&#24310;&#26178;&#38291;&#30340;&#20107;&#24773;&#65292;&#23601;&#31639;&#20877;&#32102;&#20805;&#20998;&#30340;&#26178;&#38291;&#20063;&#19968;&#27171;&#28961;&#27861;&#35299;&#27770;&#65292;&#25925;&#19981;&#35201;&#22519;&#33879;&#12290;<br>
	 * Message: Do not be obsessive over a dragged out project since it won't get any better with more time.
	 */
	public static final NpcStringId DO_NOT_BE_OBSESSIVE_OVER_A_DRAGGED_OUT_PROJECT_SINCE_IT_WONT_GET_ANY_BETTER_WITH_MORE_TIME;
	
	/**
	 * ID: 1800649<br>
	 * Message: 葹邱Ƃ͂ȁB<br>
	 * Message: &#19981;&#35201;&#21435;&#20570;&#35731;&#27493;&#25110;&#34407;&#25613;&#33258;&#24049;&#30340;&#20107;&#24773;&#12290;<br>
	 * Message: Do not yield what's rightfully yours or tolerate losses.
	 */
	public static final NpcStringId DO_NOT_YIELD_WHATS_RIGHTFULLY_YOURS_OR_TOLERATE_LOSSES;
	
	/**
	 * ID: 1800650<br>
	 * Message: ǉ̒BِɊ֐SāB<br>
	 * Message: &#22240;&#32227;&#33391;&#22909;&#20043;&#25976;&#65292;&#23565;&#30064;&#24615;&#34920;&#31034;&#38364;&#24515;&#20063;&#28961;&#22952;&#12290;<br>
	 * Message: There's luck in relationships so become interested in the opposite sex.
	 */
	public static final NpcStringId THERES_LUCK_IN_RELATIONSHIPS_SO_BECOME_INTERESTED_IN_THE_OPPOSITE_SEX;
	
	/**
	 * ID: 1800651<br>
	 * Message: ̂t͂ΈꋓB<br>
	 * Message: &#33287;&#20854;&#29031;&#33258;&#24049;&#30340;&#27169;&#24335;&#30828;&#26758;&#26758;&#30340;&#34892;&#20107;&#65292;&#19981;&#22914;&#25509;&#21463;&#21608;&#22285;&#30340;&#21332;&#21161;&#65292;&#20415;&#33021;&#21462;&#24471;&#19968;&#33289;&#20841;&#24471;&#30340;&#25928;&#26524;&#12290;<br>
	 * Message: Seeking others' help rather than trying by yourself may result in two birds with one stone.
	 */
	public static final NpcStringId SEEKING_OTHERS_HELP_RATHER_THAN_TRYING_BY_YOURSELF_MAY_RESULT_IN_TWO_BIRDS_WITH_ONE_STONE;
	
	/**
	 * ID: 1800652<br>
	 * Message: ėv𓾂B<br>
	 * Message: &#35498;&#26381;&#23565;&#26041;&#65292;&#20415;&#33021;&#24471;&#21040;&#21033;&#30410;&#12290;<br>
	 * Message: Persuading the other may result in your gain.
	 */
	public static final NpcStringId PERSUADING_THE_OTHER_MAY_RESULT_IN_YOUR_GAIN;
	
	/**
	 * ID: 1800653<br>
	 * Message: ҂ĂΊCH̓aB<br>
	 * Message: &#19981;&#35201;&#21193;&#24375;&#65292;&#25265;&#20197;&#32784;&#24515;&#31561;&#24453;&#65292;&#20415;&#26371;&#24471;&#21040;&#22909;&#27231;&#26371;&#12290;<br>
	 * Message: A good opportunity may come when keeping patience without excessiveness.
	 */
	public static final NpcStringId A_GOOD_OPPORTUNITY_MAY_COME_WHEN_KEEPING_PATIENCE_WITHOUT_EXCESSIVENESS;
	
	/**
	 * ID: 1800654<br>
	 * Message: ِK^炷B<br>
	 * Message: &#23559;&#24478;&#30064;&#24615;&#27714;&#24471;&#24184;&#36939;&#12290;<br>
	 * Message: The opposite sex may bring fortune.
	 */
	public static final NpcStringId THE_OPPOSITE_SEX_MAY_BRING_FORTUNE;
	
	/**
	 * ID: 1800655<br>
	 * Message: l̗݂𕷂΍K^ĂB<br>
	 * Message: &#25509;&#21463;&#20182;&#20154;&#30340;&#22996;&#35351;&#65292;&#26085;&#24460;&#26371;&#26377;&#24184;&#36939;&#36319;&#38568;&#12290;<br>
	 * Message: Doing favor for other people may bring fortune in the future.
	 */
	public static final NpcStringId DOING_FAVOR_FOR_OTHER_PEOPLE_MAY_BRING_FORTUNE_IN_THE_FUTURE;
	
	/**
	 * ID: 1800656<br>
	 * Message: ꂵĂΊYȁBK^͂ɂB<br>
	 * Message: &#22256;&#26044;&#34389;&#22659;&#20063;&#19981;&#24536;&#38754;&#24118;&#31505;&#23481;&#65292;&#24184;&#36939;&#20415;&#26371;&#22312;&#30524;&#21069;&#12290;<br>
	 * Message: Luck may stay near if a smile is kept during difficult times.
	 */
	public static final NpcStringId LUCK_MAY_STAY_NEAR_IF_A_SMILE_IS_KEPT_DURING_DIFFICULT_TIMES;
	
	/**
	 * ID: 1800657<br>
	 * Message: ܂BĂB܂oƂB<br>
	 * Message: &#22914;&#21516;&#37628;&#37941;&#35211;&#28779;&#65292;&#21487;&#20197;&#23637;&#29694;&#33258;&#24049;&#30340;&#23384;&#22312;&#20729;&#20540;&#12290;<br>
	 * Message: You may reveal your true self like iron is molten into an strong sword.
	 */
	public static final NpcStringId YOU_MAY_REVEAL_YOUR_TRUE_SELF_LIKE_IRON_IS_MOLTEN_INTO_AN_STRONG_SWORD;
	
	/**
	 * ID: 1800658<br>
	 * Message: BĂ܂oB̉l܂B<br>
	 * Message: &#30332;&#29694;&#28507;&#33021;&#65292;&#23559;&#26371;&#32187;&#25918;&#33258;&#24049;&#30340;&#20809;&#24425;&#12290;<br>
	 * Message: Your value will shine as your potential is finally realized.
	 */
	public static final NpcStringId YOUR_VALUE_WILL_SHINE_AS_YOUR_POTENTIAL_IS_FINALLY_REALIZED;
	
	/**
	 * ID: 1800659<br>
	 * Message: ǂCC悭ՂŉɎ߁BʂƋɉBꂽ\͂łB<br>
	 * Message: &#22533;&#25345;&#23436;&#25104;&#33393;&#36763;&#30340;&#20219;&#21209;&#21644;&#32771;&#39511;&#65292;&#19981;&#20677;&#26371;&#24118;&#20358;&#22909;&#30340;&#25104;&#26524;&#65292;&#36996;&#33021;&#30332;&#29694;&#33258;&#24049;&#21478;&#22806;&#19968;&#20491;&#33021;&#21147;&#12290;<br>
	 * Message: Tenacious efforts in solving a difficult mission or hardship may bring good results as well as realizing your hidden potential.
	 */
	public static final NpcStringId TENACIOUS_EFFORTS_IN_SOLVING_A_DIFFICULT_MISSION_OR_HARDSHIP_MAY_BRING_GOOD_RESULTS_AS_WELL_AS_REALIZING_YOUR_HIDDEN_POTENTIAL;
	
	/**
	 * ID: 1800660<br>
	 * Message: yVIŃ[AYȂȂ̎ɂ͏Ί炪₦ȂB<br>
	 * Message: &#27138;&#35264;&#30340;&#24907;&#24230;&#21644;&#24189;&#40664;&#24863;&#65292;&#23559;&#26371;&#24118;&#32102;&#21608;&#22285;&#24555;&#27138;&#27683;&#27675;&#12290;<br>
	 * Message: People will appreciate your positivity and joyful entertaining.
	 */
	public static final NpcStringId PEOPLE_WILL_APPRECIATE_YOUR_POSITIVITY_AND_JOYFUL_ENTERTAINING;
	
	/**
	 * ID: 1800661<br>
	 * Message: mbƋZŎd͏B<br>
	 * Message: &#26234;&#35584;&#38617;&#20840;&#65292;&#20107;&#20107;&#38918;&#24515;&#12290;<br>
	 * Message: Things will move smoothly with your full wisdom and abilities.
	 */
	public static final NpcStringId THINGS_WILL_MOVE_SMOOTHLY_WITH_YOUR_FULL_WISDOM_AND_ABILITIES;
	
	/**
	 * ID: 1800662<br>
	 * Message: ւƓ҂B<br>
	 * Message: &#23559;&#26371;&#36935;&#21040;&#36066;&#32773;&#65292;&#25351;&#24341;&#36367;&#19978;&#27491;&#36947;&#12290;<br>
	 * Message: You may meet a sage who can help you find the right path.
	 */
	public static final NpcStringId YOU_MAY_MEET_A_SAGE_WHO_CAN_HELP_YOU_FIND_THE_RIGHT_PATH;
	
	/**
	 * ID: 1800663<br>
	 * Message: 킹̒ϗ͂Ɠ@͂B<br>
	 * Message: &#30452;&#35258;&#21644;&#20808;&#22825;&#20855;&#26377;&#30340;&#35264;&#23519;&#21147;&#65292;&#23559;&#26371;&#32187;&#25918;&#20809;&#33426;&#12290;<br>
	 * Message: Keen instinct and foresight will shine their values.
	 */
	public static final NpcStringId KEEN_INSTINCT_AND_FORESIGHT_WILL_SHINE_THEIR_VALUES;
	
	/**
	 * ID: 1800664<br>
	 * Message: ɍK^炷B<br>
	 * Message: &#23559;&#26371;&#23565;&#21608;&#22285;&#24118;&#20358;&#24184;&#36939;&#12290;<br>
	 * Message: You may bring good luck to those around you.
	 */
	public static final NpcStringId YOU_MAY_BRING_GOOD_LUCK_TO_THOSE_AROUND_YOU;
	
	/**
	 * ID: 1800665<br>
	 * Message: }ĖڕWBB<br>
	 * Message: &#31649;&#29702;&#22909;&#29795;&#30862;&#30340;&#24773;&#24863;&#65292;&#20415;&#33021;&#36948;&#21040;&#30446;&#27161;&#12290;<br>
	 * Message: Your goal may be realized when emotional details are well defined.
	 */
	public static final NpcStringId YOUR_GOAL_MAY_BE_REALIZED_WHEN_EMOTIONAL_DETAILS_ARE_WELL_DEFINED;
	
	/**
	 * ID: 1800666<br>
	 * Message: Ml̓ŕx搉̂B<br>
	 * Message: &#31361;&#36935;&#36020;&#20154;&#65292;&#21487;&#20197;&#20139;&#21463;&#35920;&#34915;&#36275;&#39135;&#30340;&#29983;&#27963;&#12290;<br>
	 * Message: You may enjoy affluence after meeting a precious person.
	 */
	public static final NpcStringId YOU_MAY_ENJOY_AFFLUENCE_AFTER_MEETING_A_PRECIOUS_PERSON;
	
	/**
	 * ID: 1800667<br>
	 * Message: IȖِ͂ɏoB<br>
	 * Message: &#26377;&#24456;&#22823;&#30340;&#27231;&#29575;&#36935;&#35211;&#20855;&#26377;&#29289;&#36074;&#39749;&#21147;&#30340;&#30064;&#24615;&#12290;<br>
	 * Message: You may meet the opposite sex who has materialistic attractions.
	 */
	public static final NpcStringId YOU_MAY_MEET_THE_OPPOSITE_SEX_WHO_HAS_MATERIALISTIC_ATTRACTIONS;
	
	/**
	 * ID: 1800668<br>
	 * Message: ͑S͂Ő킦B<br>
	 * Message: &#21443;&#33287;&#31478;&#29229;&#20006;&#20840;&#21147;&#20197;&#36212;&#65292;&#20415;&#33021;&#24471;&#21040;&#26997;&#22823;&#30340;&#25104;&#26524;&#12290;<br>
	 * Message: A big success will follow all possible efforts in competition.
	 */
	public static final NpcStringId A_BIG_SUCCESS_WILL_FOLLOW_ALL_POSSIBLE_EFFORTS_IN_COMPETITION;
	
	/**
	 * ID: 1800669<br>
	 * Message: ߋ̍šʂoB<br>
	 * Message: &#26681;&#25818;&#36942;&#21435;&#30340;&#25152;&#20316;&#25152;&#28858;&#65292;&#23559;&#26371;&#24471;&#21040;&#32080;&#26524;&#12290;<br>
	 * Message: A consequence from past actions will be on display.
	 */
	public static final NpcStringId A_CONSEQUENCE_FROM_PAST_ACTIONS_WILL_BE_ON_DISPLAY;
	
	/**
	 * ID: 1800670<br>
	 * Message: Ɨꂪ΂ɁB<br>
	 * Message: &#23559;&#26371;&#30332;&#29983;&#33287;&#36942;&#21435;&#30340;&#33258;&#25105;&#21644;&#20182;&#20154;&#30340;&#29376;&#27841;&#27491;&#22909;&#30456;&#21453;&#30340;&#24773;&#27841;&#12290;<br>
	 * Message: Whatever happened to you and the other person will replay, but this time, the opposite will be the result.
	 */
	public static final NpcStringId WHATEVER_HAPPENED_TO_YOU_AND_THE_OTHER_PERSON_WILL_REPLAY_BUT_THIS_TIME_THE_OPPOSITE_WILL_BE_THE_RESULT;
	
	/**
	 * ID: 1800671<br>
	 * Message: ̒Eđ̒B<br>
	 * Message: &#28858;&#20102;&#26356;&#39640;&#30340;&#20729;&#20540;&#65292;&#23559;&#26371;&#30332;&#29983;&#19981;&#24796;&#29351;&#29298;&#30340;&#24773;&#27841;&#12290;<br>
	 * Message: You may need to sacrifice for a higher cause.
	 */
	public static final NpcStringId YOU_MAY_NEED_TO_SACRIFICE_FOR_A_HIGHER_CAUSE;
	
	/**
	 * ID: 1800672<br>
	 * Message: A_𓾂B<br>
	 * Message: &#22833;&#21435;&#29289;&#36074;&#65292;&#21371;&#24471;&#21040;&#31934;&#31070;&#26041;&#38754;&#30340;&#26481;&#35199;&#12290;<br>
	 * Message: You may lose an item but will gain honor.
	 */
	public static final NpcStringId YOU_MAY_LOSE_AN_ITEM_BUT_WILL_GAIN_HONOR;
	
	/**
	 * ID: 1800673<br>
	 * Message: ωւ̗~]ӂBVȂƂɃ`WB<br>
	 * Message: &#35722;&#21270;&#33021;&#21147;&#21313;&#36275;&#65292;&#21487;&#20197;&#22039;&#35430;&#26032;&#30340;&#25361;&#25136;&#25110;&#25509;&#21463;&#26032;&#30340;&#38283;&#22987;&#12290;<br>
	 * Message: A new trial or start may be successful as luck shadows changes.
	 */
	public static final NpcStringId A_NEW_TRIAL_OR_START_MAY_BE_SUCCESSFUL_AS_LUCK_SHADOWS_CHANGES;
	
	/**
	 * ID: 1800674<br>
	 * Message: \ƗUf߂B{͉BB<br>
	 * Message: &#23559;&#26371;&#21463;&#21040;&#27450;&#35408;&#25110;&#29289;&#36074;&#19978;&#30340;&#35480;&#24785;&#65292;&#38920;&#38577;&#34255;&#30495;&#23526;&#30340;&#20839;&#24515;&#65292;&#31934;&#25171;&#32048;&#31639;&#22320;&#34892;&#21205;&#12290;<br>
	 * Message: Be sophisticated without showing your true emotions as tricks and materialistic temptations lie ahead.
	 */
	public static final NpcStringId BE_SOPHISTICATED_WITHOUT_SHOWING_YOUR_TRUE_EMOTIONS_AS_TRICKS_AND_MATERIALISTIC_TEMPTATIONS_LIE_AHEAD;
	
	/**
	 * ID: 1800675<br>
	 * Message: Nq낤ɋߊ炸B<br>
	 * Message: &#19981;&#35201;&#20882;&#33879;&#39080;&#38570;&#39791;&#33725;&#34892;&#20107;&#12290;<br>
	 * Message: Do not attempt a dangerous adventure.
	 */
	public static final NpcStringId DO_NOT_ATTEMPT_A_DANGEROUS_ADVENTURE;
	
	/**
	 * ID: 1800676<br>
	 * Message: ωȁB@̓`XB<br>
	 * Message: &#19981;&#35201;&#23475;&#24597;&#35722;&#21270;&#65292;&#21361;&#27231;&#21453;&#32780;&#26371;&#36681;&#21270;&#28858;&#26178;&#27231;&#12290;<br>
	 * Message: Do not be afraid of change. A risk will be another opportunity.
	 */
	public static final NpcStringId DO_NOT_BE_AFRAID_OF_CHANGE_A_RISK_WILL_BE_ANOTHER_OPPORTUNITY;
	
	/**
	 * ID: 1800677<br>
	 * Message: MƍCōsBsł܂B<br>
	 * Message: &#25265;&#20197;&#33258;&#20449;&#33287;&#27589;&#21147;&#34892;&#20107;&#65292;&#37027;&#40636;&#23601;&#31639;&#22312;&#38754;&#33256;&#19981;&#23433;&#30340;&#24773;&#27841;&#19979;&#65292;&#20063;&#33021;&#20625;&#20986;&#30340;&#25198;&#28436;&#22909;&#33258;&#24049;&#30340;&#35282;&#33394;&#12290;<br>
	 * Message: Be confident and act tenaciously at all times. You may be able to accomplish to perfection during somewhat unstable situations.
	 */
	public static final NpcStringId BE_CONFIDENT_AND_ACT_TENACIOUSLY_AT_ALL_TIMES_YOU_MAY_BE_ABLE_TO_ACCOMPLISH_TO_PERFECTION_DURING_SOMEWHAT_UNSTABLE_SITUATIONS;
	
	/**
	 * ID: 1800678<br>
	 * Message: 邢҂ĂB<br>
	 * Message: &#21487;&#20197;&#26399;&#24453;&#26126;&#26391;&#19988;&#26377;&#24076;&#26395;&#30340;&#26410;&#20358;&#12290;<br>
	 * Message: You may expect a bright and hopeful future.
	 */
	public static final NpcStringId YOU_MAY_EXPECT_A_BRIGHT_AND_HOPEFUL_FUTURE;
	
	/**
	 * ID: 1800679<br>
	 * Message: x͂Ȃ鐬ւ̋ߓB<br>
	 * Message: &#20241;&#24687;&#65292;&#23559;&#26371;&#25215;&#35582;&#26356;&#22823;&#30340;&#25104;&#38263;&#12290;<br>
	 * Message: A rest will promise a bigger development.
	 */
	public static final NpcStringId A_REST_WILL_PROMISE_A_BIGGER_DEVELOPMENT;
	
	/**
	 * ID: 1800680<br>
	 * Message: |WeBuɍlčsB<br>
	 * Message: &#31309;&#26997;&#27963;&#29992;&#32943;&#23450;&#30340;&#20729;&#20540;&#35264;&#12290;<br>
	 * Message: Fully utilize positive views.
	 */
	public static final NpcStringId FULLY_UTILIZE_POSITIVE_VIEWS;
	
	/**
	 * ID: 1800681<br>
	 * Message: |WeBuŊ͂ӂ邠Ȃ͕̒SɗB<br>
	 * Message: &#32943;&#23450;&#30340;&#24605;&#32771;&#33021;&#21147;&#21644;&#27963;&#21147;&#21313;&#36275;&#30340;&#33289;&#21205;&#65292;&#23559;&#26371;&#35731;&#20320;&#35722;&#25104;&#33775;&#40599;&#33310;&#21488;&#19978;&#30340;&#20027;&#35282;&#12290;<br>
	 * Message: Positive thinking and energetic actions will take you to the center of the glorious stage.
	 */
	public static final NpcStringId POSITIVE_THINKING_AND_ENERGETIC_ACTIONS_WILL_TAKE_YOU_TO_THE_CENTER_OF_THE_GLORIOUS_STAGE;
	
	/**
	 * ID: 1800682<br>
	 * Message: Ă̒MčsB<br>
	 * Message: &#36973;&#36935;&#22256;&#38627;&#65292;&#20294;&#22810;&#34407;&#23565;&#26044;&#33258;&#25105;&#30340;&#20449;&#36084;&#21644;&#30452;&#35258;&#65292;&#23559;&#26371;&#35299;&#27770;&#21839;&#38988;&#12290;<br>
	 * Message: Your self confidence and intuition may solve the difficulties.
	 */
	public static final NpcStringId YOUR_SELF_CONFIDENCE_AND_INTUITION_MAY_SOLVE_THE_DIFFICULTIES;
	
	/**
	 * ID: 1800683<br>
	 * Message: yBΊŎ𖾂邭B<br>
	 * Message: &#33836;&#20107;&#30342;&#22823;&#27489;&#21916;&#65292;&#20998;&#20139;&#21916;&#24709;&#65292;&#23601;&#21487;&#24471;&#21040;&#26356;&#22823;&#30340;&#24184;&#36939;&#12290;<br>
	 * Message: Everything is brilliant and joyful, share it with others. A bigger fortune will follow.
	 */
	public static final NpcStringId EVERYTHING_IS_BRILLIANT_AND_JOYFUL_SHARE_IT_WITH_OTHERS_A_BIGGER_FORTUNE_WILL_FOLLOW;
	
	/**
	 * ID: 1800684<br>
	 * Message: ߋ̍sɑ΂鐳ȕ]ƕ܂҂ĂB<br>
	 * Message: &#27491;&#30070;&#30340;&#35413;&#20729;&#21644;&#22577;&#37228;&#65292;&#27491;&#31561;&#24453;&#33879;&#24396;&#35036;&#36942;&#21435;&#30340;&#25152;&#20316;&#25152;&#28858;&#12290;<br>
	 * Message: A fair assessment and reward for past actions lie ahead.
	 */
	public static final NpcStringId A_FAIR_ASSESSMENT_AND_REWARD_FOR_PAST_ACTIONS_LIE_AHEAD;
	
	/**
	 * ID: 1800685<br>
	 * Message: ق炩̎d؋ЕtBVȊт̒B<br>
	 * Message: &#33509;&#26377;&#38515;&#33290;&#30340;&#32681;&#21209;&#25110;&#20661;&#21209;&#65292;&#23452;&#27491;&#30070;&#22320;&#32080;&#31639;&#36996;&#28165;&#65292;&#37027;&#40636;&#20415;&#26371;&#24471;&#21040;&#23940;&#26032;&#30340;&#24555;&#27138;&#12290;<br>
	 * Message: Pay accurately the old liability or debt, if applicable. A new joy lies ahead.
	 */
	public static final NpcStringId PAY_ACCURATELY_THE_OLD_LIABILITY_OR_DEBT_IF_APPLICABLE_A_NEW_JOY_LIES_AHEAD;
	
	/**
	 * ID: 1800686<br>
	 * Message: đB<br>
	 * Message: &#36942;&#24230;&#30340;&#35609;&#34395;&#21453;&#32780;&#26371;&#25307;&#20358;&#28797;&#27523;&#12290;<br>
	 * Message: An excessive humility can harm you back.
	 */
	public static final NpcStringId AN_EXCESSIVE_HUMILITY_CAN_HARM_YOU_BACK;
	
	/**
	 * ID: 1800687<br>
	 * Message: ܂ł̎d̕܂𓾂B<br>
	 * Message: &#23559;&#26371;&#24471;&#21040;&#33267;&#20170;&#25033;&#24471;&#30340;&#22577;&#37228;&#12290;<br>
	 * Message: A reward for the past work will come through.
	 */
	public static final NpcStringId A_REWARD_FOR_THE_PAST_WORK_WILL_COME_THROUGH;
	
	/**
	 * ID: 1800688<br>
	 * Message: тׂ{ׂ̖ɂȂB<br>
	 * Message: &#27794;&#26377;&#25104;&#23601;&#30340;&#21162;&#21147;&#65292;&#23559;&#24478;&#20854;&#20182;&#26041;&#38754;&#21462;&#24471;&#35036;&#20767;&#12290;<br>
	 * Message: Your past fruitless effort will finally be rewarded with something unexpected.
	 */
	public static final NpcStringId YOUR_PAST_FRUITLESS_EFFORT_WILL_FINALLY_BE_REWARDED_WITH_SOMETHING_UNEXPECTED;
	
	/**
	 * ID: 1800689<br>
	 * Message: Đ̗͋BÂ̂ĂĐV𓾂B<br>
	 * Message: &#20877;&#29983;&#33021;&#21147;&#24375;&#65292;&#26368;&#22909;&#26159;&#26820;&#33290;&#36814;&#26032;&#12290;<br>
	 * Message: There's strong luck in a revival, abandon the old and create the new.
	 */
	public static final NpcStringId THERES_STRONG_LUCK_IN_A_REVIVAL_ABANDON_THE_OLD_AND_CREATE_THE_NEW;
	
	/**
	 * ID: 1800690<br>
	 * Message: 肩畨SʂŏB<br>
	 * Message: &#23559;&#26371;&#24478;&#21608;&#22285;&#24471;&#21040;&#29289;&#36074;&#19978;&#25110;&#31934;&#31070;&#19978;&#30340;&#24171;&#21161;&#12290;<br>
	 * Message: You may gain materialistic or mental aid from close friends.
	 */
	public static final NpcStringId YOU_MAY_GAIN_MATERIALISTIC_OR_MENTAL_AID_FROM_CLOSE_FRIENDS;
	
	/**
	 * ID: 1800691<br>
	 * Message: ւ肪҂ĂB<br>
	 * Message: &#22909;&#28040;&#24687;&#27491;&#22312;&#31561;&#20505;&#12290;<br>
	 * Message: A good beginning is awaiting you.
	 */
	public static final NpcStringId A_GOOD_BEGINNING_IS_AWAITING_YOU;
	
	/**
	 * ID: 1800692<br>
	 * Message: lɉB<br>
	 * Message: &#23559;&#36935;&#35211;&#20037;&#21029;&#37325;&#36898;&#30340;&#20154;&#12290;<br>
	 * Message: You may meet the person you've longed to see.
	 */
	public static final NpcStringId YOU_MAY_MEET_THE_PERSON_YOUVE_LONGED_TO_SEE;
	
	/**
	 * ID: 1800693<br>
	 * Message: ҂͑B<br>
	 * Message: &#24515;&#22320;&#21892;&#33391;&#65292;&#25110;&#35377;&#26371;&#36973;&#21040;&#25613;&#22833;&#12290;<br>
	 * Message: You may sustain a loss due to your kindness.
	 */
	public static final NpcStringId YOU_MAY_SUSTAIN_A_LOSS_DUE_TO_YOUR_KINDNESS;
	
	/**
	 * ID: 1800694<br>
	 * Message: MlLׂBʂ肩̐l悭B<br>
	 * Message: &#31361;&#36935;&#36020;&#20154;&#65292;&#23559;&#26371;&#24471;&#21040;&#33707;&#22823;&#30340;&#24171;&#21161;&#65292;&#22240;&#27492;&#21363;&#20351;&#24046;&#32937;&#32780;&#36942;&#30340;&#20154;&#20063;&#24471;&#20877;&#27425;&#38364;&#27880;&#12290;<br>
	 * Message: Closely observe people who pass by since you may meet a precious person who can help you.
	 */
	public static final NpcStringId CLOSELY_OBSERVE_PEOPLE_WHO_PASS_BY_SINCE_YOU_MAY_MEET_A_PRECIOUS_PERSON_WHO_CAN_HELP_YOU;
	
	/**
	 * ID: 1800695<br>
	 * Message: `߁ANZXA̓uɍI݁Ajł̎ɂeBAg̃hRjAƐ키EC`ƂW܂B<br>
	 * Message: &#20659;&#20196;&#65292;&#21578;&#30693;&#26607;&#22622;&#21202;&#26031;&#21516;&#30431;&#32879;&#21512;&#30340;&#22821;&#20276;&#20497;&#65281;&#30446;&#21069;&#25105;&#20497;&#27491;&#22312;&#21215;&#38598;&#21191;&#29467;&#30340;&#20882;&#38570;&#23478;&#20497;&#65292;&#28310;&#20633;&#25915;&#25802;&#38712;&#20308;&#30772;&#28357;&#20043;&#31278;&#30340;&#33922;&#38597;&#29305;&#30340;&#40845;&#39340;&#22296;&#65281;<br>
	 * Message: Messenger, inform the patrons of the Keucereus Alliance Base! We're gathering brave adventurers to attack Tiat's Mounted Troop that's rooted in the Seed of Destruction.
	 */
	public static final NpcStringId MESSENGER_INFORM_THE_PATRONS_OF_THE_KEUCEREUS_ALLIANCE_BASE_WERE_GATHERING_BRAVE_ADVENTURERS_TO_ATTACK_TIATS_MOUNTED_TROOP_THATS_ROOTED_IN_THE_SEED_OF_DESTRUCTION;
	
	/**
	 * ID: 1800696<br>
	 * Message: `߁ANZXA̓uɍI݁Ajł͓̎Å̉ɈSɊmۂĂB<br>
	 * Message: &#20659;&#20196;&#65292;&#21578;&#30693;&#26607;&#22622;&#21202;&#26031;&#21516;&#30431;&#32879;&#21512;&#30340;&#22821;&#20276;&#20497;&#65281;&#30446;&#21069;&#30772;&#28357;&#20043;&#31278;&#22312;&#21516;&#30431;&#32879;&#21512;&#30340;&#26071;&#24159;&#19979;&#32173;&#35703;&#24471;&#24456;&#23433;&#20840;&#65281;<br>
	 * Message: Messenger, inform the patrons of the Keucereus Alliance Base! The Seed of Destruction is currently secured under the flag of the Keucereus Alliance!
	 */
	public static final NpcStringId MESSENGER_INFORM_THE_PATRONS_OF_THE_KEUCEREUS_ALLIANCE_BASE_THE_SEED_OF_DESTRUCTION_IS_CURRENTLY_SECURED_UNDER_THE_FLAG_OF_THE_KEUCEREUS_ALLIANCE;
	
	/**
	 * ID: 1800697<br>
	 * Message: `߁ANZXA̓uɍI݁AeBAg̃hRjA̒D҂łBƂ郊\[Xjł̎ɓB<br>
	 * Message: &#20659;&#20196;&#65292;&#21578;&#30693;&#26607;&#22622;&#21202;&#26031;&#21516;&#30431;&#32879;&#21512;&#30340;&#22821;&#20276;&#20497;&#65281;&#30446;&#21069;&#33922;&#38597;&#29305;&#30340;&#40845;&#39340;&#22296;&#35430;&#22294;&#24819;&#35201;&#22890;&#21462;&#30772;&#28357;&#20043;&#31278;&#65281;&#31435;&#21363;&#25237;&#20837;&#20840;&#37096;&#30340;&#21487;&#29992;&#20853;&#21147;&#21040;&#30772;&#28357;&#20043;&#31278;&#65281;<br>
	 * Message: Messenger, inform the patrons of the Keucereus Alliance Base! Tiat's Mounted Troop is currently trying to retake Seed of Destruction! Commit all the available reinforcements into Seed of Destruction!
	 */
	public static final NpcStringId MESSENGER_INFORM_THE_PATRONS_OF_THE_KEUCEREUS_ALLIANCE_BASE_TIATS_MOUNTED_TROOP_IS_CURRENTLY_TRYING_TO_RETAKE_SEED_OF_DESTRUCTION_COMMIT_ALL_THE_AVAILABLE_REINFORCEMENTS_INTO_SEED_OF_DESTRUCTION;
	
	/**
	 * ID: 1800698<br>
	 * Message: `߁ANZXA̓uɍI݁Asł̎ɒ񂾗EC`Ƃ́A̎アɂ̊ʂĐNH̊ɐNĂI<br>
	 * Message: &#20659;&#20196;&#65292;&#21578;&#30693;&#26607;&#22622;&#21202;&#26031;&#21516;&#30431;&#32879;&#21512;&#30340;&#22821;&#20276;&#20497;&#65281;&#30446;&#21069;&#25361;&#25136;&#19981;&#28357;&#20043;&#31278;&#30340;&#21191;&#29467;&#30340;&#20882;&#38570;&#23478;&#20497;&#65292;&#36879;&#36942;&#38450;&#34907;&#33030;&#24369;&#30340;&#33510;&#30171;&#26874;&#23460;&#27491;&#22312;&#20405;&#20837;&#20405;&#34645;&#26874;&#23460;&#65281;<br>
	 * Message: Messenger, inform the brothers in Kucereus' clan outpost! Brave adventurers who have challenged the Seed of Infinity are currently infiltrating the Hall of Erosion through the defensively weak Hall of Suffering!
	 */
	public static final NpcStringId MESSENGER_INFORM_THE_BROTHERS_IN_KUCEREUS_CLAN_OUTPOST_BRAVE_ADVENTURERS_WHO_HAVE_CHALLENGED_THE_SEED_OF_INFINITY_ARE_CURRENTLY_INFILTRATING_THE_HALL_OF_EROSION_THROUGH_THE_DEFENSIVELY_WEAK_HALL_OF_SUFFERING;
	
	/**
	 * ID: 1800699<br>
	 * Message: `߁ANZXA̓uɍI݁Asł̎͐S܂ő|ĂBGLX̒ڍU铯ɁAɂ̊ɂAfbh̎c}̑|sĂI<br>
	 * Message: &#20659;&#20196;&#65292;&#21578;&#30693;&#26607;&#22622;&#21202;&#26031;&#21516;&#30431;&#32879;&#21512;&#30340;&#22821;&#20276;&#20497;&#65281;&#30446;&#21069;&#24050;&#25475;&#34153;&#19981;&#28357;&#20043;&#31278;&#30340;&#24515;&#33247;&#37096;&#65292;&#27491;&#22312;&#23565;&#20234;&#21345;&#22982;&#22763;&#23637;&#38283;&#30452;&#25509;&#30340;&#25915;&#25802;&#65292;&#21516;&#26178;&#20063;&#22312;&#21111;&#38500;&#30041;&#22312;&#33510;&#30171;&#26874;&#23460;&#30340;&#19981;&#27515;&#29983;&#29289;&#20497;&#65281;<br>
	 * Message: Messenger, inform the brothers in Kucereus' clan outpost! Brave adventurers who have challenged the Seed of Infinity are currently infiltrating the Hall of Erosion through the defensively weak Hall of Suffering!
	 */
	public static final NpcStringId MESSENGER_INFORM_THE_BROTHERS_IN_KUCEREUS_CLAN_OUTPOST_SWEEPING_THE_SEED_OF_INFINITY_IS_CURRENTLY_COMPLETE_TO_THE_HEART_OF_THE_SEED_EKIMUS_IS_BEING_DIRECTLY_ATTACKED_AND_THE_UNDEAD_REMAINING_IN_THE_HALL_OF_SUFFERING_ARE_BEING_ERADICATED;
	
	/**
	 * ID: 1800700<br>
	 * Message: `߁ANZXA̓uɍI݁Asł͓̎Å̉ɈSɊmۂĂB<br>
	 * Message: &#20659;&#20196;&#65292;&#21578;&#30693;&#26607;&#22622;&#21202;&#26031;&#21516;&#30431;&#32879;&#21512;&#30340;&#22821;&#20276;&#20497;&#65281;&#30446;&#21069;&#19981;&#28357;&#20043;&#31278;&#22312;&#21516;&#30431;&#32879;&#21512;&#30340;&#26071;&#24159;&#19979;&#32173;&#35703;&#24471;&#24456;&#23433;&#20840;&#65281;<br>
	 * Message: Messenger, inform the patrons of the Keucereus Alliance Base! The Seed of Infinity is currently secured under the flag of the Keucereus Alliance!
	 */
	public static final NpcStringId MESSENGER_INFORM_THE_PATRONS_OF_THE_KEUCEREUS_ALLIANCE_BASE_THE_SEED_OF_INFINITY_IS_CURRENTLY_SECURED_UNDER_THE_FLAG_OF_THE_KEUCEREUS_ALLIANCE;
	
	/**
	 * ID: 1800701<br>
	 * Message:
	 */
	public static final NpcStringId _;
	
	/**
	 * ID: 1800702<br>
	 * Message: `߁ANZXA̓uɍI݁AԂsł̎̃Afbhɂ̊ƐNH̊ɂӂoĂB<br>
	 * Message: &#20659;&#20196;&#65292;&#21578;&#30693;&#26607;&#22622;&#21202;&#26031;&#21516;&#30431;&#32879;&#21512;&#30340;&#22821;&#20276;&#20497;&#65281;&#24489;&#27963;&#30340;&#19981;&#28357;&#20043;&#31278;&#30340;&#19981;&#27515;&#29983;&#29289;&#20497;&#65292;&#30446;&#21069;&#27491;&#25778;&#21521;&#33510;&#30171;&#26874;&#23460;&#21644;&#20405;&#34645;&#26874;&#23460;&#65281;<br>
	 * Message: Messenger, inform the patrons of the Keucereus Alliance Base! The resurrected Undead in the Seed of Infinity are pouring into the Hall of Suffering and the Hall of Erosion!
	 */
	public static final NpcStringId MESSENGER_INFORM_THE_PATRONS_OF_THE_KEUCEREUS_ALLIANCE_BASE_THE_RESURRECTED_UNDEAD_IN_THE_SEED_OF_INFINITY_ARE_POURING_INTO_THE_HALL_OF_SUFFERING_AND_THE_HALL_OF_EROSION;
	
	/**
	 * ID: 1800703<br>
	 * Message: `߁ANZXA̓uɍI݁AԂsł̎̃Afbhǂ̎ɂăGLXԂ낤ƂĂBS͂SƋɂ̊ɔhI<br>
	 * Message: &#20659;&#20196;&#65292;&#21578;&#30693;&#26607;&#22622;&#21202;&#26031;&#21516;&#30431;&#32879;&#21512;&#30340;&#22821;&#20276;&#20497;&#65281;&#30446;&#21069;&#22240;&#28858;&#19981;&#28357;&#20043;&#31278;&#20839;&#24489;&#27963;&#30340;&#19981;&#27515;&#29983;&#29289;&#20497;&#65292;&#20234;&#21345;&#22982;&#22763;&#34389;&#26044;&#21363;&#23559;&#24489;&#27963;&#30340;&#29376;&#24907;&#12290;&#31435;&#21363;&#27966;&#36963;&#25152;&#26377;&#30340;&#25903;&#25588;&#20853;&#21069;&#24448;&#24515;&#33247;&#37096;&#21644;&#33510;&#30171;&#26874;&#23460;&#65281;<br>
	 * Message: Messenger, inform the brothers in Kucereus' clan outpost! Ekimus is about to be revived by the resurrected Undead in Seed of Infinity. Send all reinforcements to the Heart and the Hall of Suffering!
	 */
	public static final NpcStringId MESSENGER_INFORM_THE_BROTHERS_IN_KUCEREUS_CLAN_OUTPOST_EKIMUS_IS_ABOUT_TO_BE_REVIVED_BY_THE_RESURRECTED_UNDEAD_IN_SEED_OF_INFINITY_SEND_ALL_REINFORCEMENTS_TO_THE_HEART_AND_THE_HALL_OF_SUFFERING;
	
	/**
	 * ID: 1800704<br>
	 * Message: 3hI<br>
	 * Message: &#23526;&#26045;&#51;&#27425;&#21050;&#25802;&#65281;<br>
	 * Message: Stabbing three times!
	 */
	public static final NpcStringId STABBING_THREE_TIMES;
	
	/**
	 * ID: 1800705<br>
	 * Message: 푢ǂBł̗͂ĂB<br>
	 * Message: &#20320;&#20497;&#36889;&#20123;&#21487;&#24976;&#30340;&#21109;&#36896;&#29289;&#65292;&#22160;&#22160;&#40657;&#26263;&#21147;&#37327;&#30340;&#28363;&#21619;&#21543;&#65281;<br>
	 * Message: Poor creatures, feel the power of darkness!
	 */
	public static final NpcStringId POOR_CREATURES_FEEL_THE_POWER_OF_DARKNESS;
	
	/**
	 * ID: 1800706<br>
	 * Message: I<br>
	 * Message: &#21978;&#21908;&#21908;&#21908;&#21908;&#21908;&#21908;&#21908;&#65281;&#65281;&#65281;&#65281;<br>
	 * Message: Whoaaaaaa!!!!
	 */
	public static final NpcStringId WHOAAAAAA;
	
	/**
	 * ID: 1800707<br>
	 * Message: ɒ񂾂ƂĂI<br>
	 * Message: &#25105;&#26371;&#35731;&#20320;&#24460;&#24724;&#21521;&#25105;&#25361;&#25136;&#65281;&#65281;&#65281;&#65281;<br>
	 * Message: You'll regret challenging me!!!!
	 */
	public static final NpcStringId YOULL_REGRET_CHALLENGING_ME;
	
	/**
	 * ID: 1800708<br>
	 * Message: ݁AGɐ̂ĂB䂪R͍Ui߂ĂB<br>
	 * Message: &#30446;&#21069;&#22312;&#25973;&#32676;&#30340;&#20308;&#38936;&#20043;&#19979;&#65292;&#32780;&#19988;&#25105;&#36557;&#27491;&#22312;&#36914;&#34892;&#25915;&#25802;&#12290;<br>
	 * Message: It's currently occupied by the enemy and our troops are attacking.
	 */
	public static final NpcStringId ITS_CURRENTLY_OCCUPIED_BY_THE_ENEMY_AND_OUR_TROOPS_ARE_ATTACKING;
	
	/**
	 * ID: 1800709<br>
	 * Message: ݁AX̂ĂBNZXAsc̑|ɓĂB<br>
	 * Message: &#30446;&#21069;&#22312;&#25105;&#36557;&#30340;&#20308;&#38936;&#20043;&#19979;&#65292;&#32780;&#19988;&#26607;&#22622;&#21202;&#26031;&#21516;&#30431;&#32879;&#21512;&#27491;&#22312;&#34389;&#29702;&#37027;&#20123;&#21097;&#39192;&#30340;&#27544;&#23384;&#32773;&#20497;&#12290;<br>
	 * Message: It's under occupation by our forces, and I heard that Kucereus' clan is organizing the remnants.
	 */
	public static final NpcStringId ITS_UNDER_OCCUPATION_BY_OUR_FORCES_AND_I_HEARD_THAT_KUCEREUS_CLAN_IS_ORGANIZING_THE_REMNANTS;
	
	/**
	 * ID: 1800710<br>
	 * Message: ݁AX̂Ă邪AG̋͂ȍUɉCB<br>
	 * Message: &#30446;&#21069;&#36996;&#22312;&#25105;&#36557;&#30340;&#20308;&#38936;&#20043;&#19979;&#65292;&#20294;&#25973;&#36557;&#27491;&#20197;&#24375;&#22823;&#30340;&#36557;&#21218;&#25915;&#36914;&#12290;<br>
	 * Message: Although we currently have control of it, the enemy is pushing back with a powerful attack.
	 */
	public static final NpcStringId ALTHOUGH_WE_CURRENTLY_HAVE_CONTROL_OF_IT_THE_ENEMY_IS_PUSHING_BACK_WITH_A_POWERFUL_ATTACK;
	
	/**
	 * ID: 1800711<br>
	 * Message: ݁AGɐ̂ĂB`ƂƘAG̋ɂ̊ƐNH̊UĂB<br>
	 * Message: &#30446;&#21069;&#22312;&#25973;&#32676;&#30340;&#20308;&#38936;&#20043;&#19979;&#65292;&#20294;&#20882;&#38570;&#23478;&#21644;&#26607;&#22622;&#21202;&#26031;&#21516;&#30431;&#32879;&#21512;&#30340;&#36557;&#21218;&#27491;&#22312;&#29467;&#25915;&#33510;&#30171;&#26874;&#23460;&#21644;&#20405;&#34645;&#26874;&#23460;&#12290;<br>
	 * Message: It's under the enemy's occupation, and the military forces of adventurers and clan members are unleashing an onslaught upon the Hall of Suffering and the Hall of Erosion.
	 */
	public static final NpcStringId ITS_UNDER_THE_ENEMYS_OCCUPATION_AND_THE_MILITARY_FORCES_OF_ADVENTURERS_AND_CLAN_MEMBERS_ARE_UNLEASHING_AN_ONSLAUGHT_UPON_THE_HALL_OF_SUFFERING_AND_THE_HALL_OF_EROSION;
	
	/**
	 * ID: 1800713<br>
	 * Message: ݁AX̂ĂB̒sĂB<br>
	 * Message: &#30446;&#21069;&#22312;&#25105;&#36557;&#30340;&#20308;&#38936;&#20043;&#19979;&#65292;&#32780;&#19988;&#27491;&#22312;&#35519;&#26597;&#20839;&#37096;&#12290;<br>
	 * Message: Our forces have occupied it and are currently investigating the depths.
	 */
	public static final NpcStringId OUR_FORCES_HAVE_OCCUPIED_IT_AND_ARE_CURRENTLY_INVESTIGATING_THE_DEPTHS;
	
	/**
	 * ID: 1800714<br>
	 * Message: ݁AX̂Ă邪AGԂċɂ̊ƐNH̊ʂĐNUB<br>
	 * Message: &#30446;&#21069;&#36996;&#22312;&#25105;&#36557;&#30340;&#20308;&#38936;&#20043;&#19979;&#65292;&#20294;&#32893;&#35498;&#25973;&#32676;&#24050;&#24489;&#27963;&#65292;&#27491;&#26397;&#33510;&#30171;&#26874;&#23460;&#21644;&#20405;&#34645;&#26874;&#23460;&#36914;&#25915;&#30070;&#20013;&#12290;<br>
	 * Message: It's under occupation by our forces, but the enemy has resurrected and is attacking toward the Hall of Suffering and the Hall of Erosion.
	 */
	public static final NpcStringId ITS_UNDER_OCCUPATION_BY_OUR_FORCES_BUT_THE_ENEMY_HAS_RESURRECTED_AND_IS_ATTACKING_TOWARD_THE_HALL_OF_SUFFERING_AND_THE_HALL_OF_EROSION;
	
	/**
	 * ID: 1800715<br>
	 * Message: ݁AX̂Ă邪ANH̊͂łɓG̎ɗBɐSɉ񂹂Ă킪ȒޘHƂƂĂBGLX̕Ԃ̖肾B<br>
	 * Message: &#30446;&#21069;&#36996;&#22312;&#25105;&#36557;&#30340;&#20308;&#38936;&#20043;&#19979;&#65292;&#20294;&#32893;&#35498;&#25973;&#32676;&#24050;&#20308;&#38936;&#20405;&#34645;&#26874;&#23460;&#65292;&#27491;&#25915;&#21521;&#24515;&#33247;&#37096;&#65292;&#32780;&#19988;&#20063;&#27491;&#22312;&#20999;&#26039;&#22312;&#33510;&#30171;&#26874;&#23460;&#30340;&#25105;&#36557;&#30340;&#36864;&#36335;&#12290;&#30524;&#30475;&#20234;&#21345;&#22982;&#22763;&#21363;&#23559;&#23601;&#35201;&#24489;&#27963;&#20102;&#12290;<br>
	 * Message: It's under occupation by our forces, but the enemy has already overtaken the Hall of Erosion and is driving out our forces from the Hall of Suffering toward the Heart. It seems that Ekimus will revive shortly.
	 */
	public static final NpcStringId ITS_UNDER_OCCUPATION_BY_OUR_FORCES_BUT_THE_ENEMY_HAS_ALREADY_OVERTAKEN_THE_HALL_OF_EROSION_AND_IS_DRIVING_OUT_OUR_FORCES_FROM_THE_HALL_OF_SUFFERING_TOWARD_THE_HEART_IT_SEEMS_THAT_EKIMUS_WILL_REVIVE_SHORTLY;
	
	/**
	 * ID: 1800717<br>
	 * Message: eBAg̎艺jł̎ԂƂĂBނ̏I<br>
	 * Message: &#33922;&#38597;&#29305;&#30340;&#37096;&#19979;&#20497;&#27491;&#35201;&#21069;&#20358;&#22890;&#21462;&#30772;&#28357;&#20043;&#31278;&#65281;&#28310;&#20633;&#25269;&#25803;&#25973;&#32676;&#65281;<br>
	 * Message: Tiat's followers are coming to retake the Seed of Destruction! Get ready to stop the enemies!
	 */
	public static final NpcStringId TIATS_FOLLOWERS_ARE_COMING_TO_RETAKE_THE_SEED_OF_DESTRUCTION_GET_READY_TO_STOP_THE_ENEMIES;
	
	/**
	 * ID: 1800718<br>
	 * Message: AɂDDD̒ɂ݁Aǂ~ނ낤B<br>
	 * Message: &#22909;&#30171;&#46;&#46;&#46;&#22909;&#30171;&#33510;&#46;&#46;&#46;&#25105;&#35201;&#22914;&#20309;&#23433;&#25771;&#36889;&#30140;&#30171;&#21602;&#46;&#46;&#46;<br>
	 * Message: It's hurting... I'm in pain... What can I do for the pain...
	 */
	public static final NpcStringId ITS_HURTING_IM_IN_PAIN_WHAT_CAN_I_DO_FOR_THE_PAIN;
	
	/**
	 * ID: 1800719<br>
	 * Message: ߂ĂDDDꂷȂȂAǂċɂƐ킦Ă񂾁I<br>
	 * Message: &#19981;&#34892;&#46;&#46;&#46;&#22914;&#26524;&#36899;&#37027;&#20491;&#20063;&#28040;&#22833;&#30340;&#35441;&#46;&#46;&#46;&#25105;&#26371;&#35722;&#24471;&#26356;&#30171;&#33510;&#46;&#46;&#46;<br>
	 * Message: No... When I lose that one... I'll be in more pain...
	 */
	public static final NpcStringId NO_WHEN_I_LOSE_THAT_ONE_ILL_BE_IN_MORE_PAIN;
	
	/**
	 * ID: 1800720<br>
	 * Message: ͂͂́INX}X T^͉߂܂IÑv[g͂aI<br>
	 * Message: &#21621;&#21704;&#21704;&#21704;&#65281;&#65281;&#65281;&#32854;&#35477;&#32769;&#20154;&#26159;&#25105;&#25235;&#30340;&#65281;&#65281;&#20170;&#24180;&#19981;&#26371;&#26377;&#20219;&#20309;&#31150;&#29289;&#20102;&#65281;&#65281;&#65281;<br>
	 * Message: Hahahah!!! I captured Santa Claus!! There will be no gifts this year!!!
	 */
	public static final NpcStringId HAHAHAH_I_CAPTURED_SANTA_CLAUS_THERE_WILL_BE_NO_GIFTS_THIS_YEAR;
	
	/**
	 * ID: 1800721<br>
	 * Message: AĂI<br>
	 * Message: &#20358;&#65281;&#20760;&#31649;&#20358;&#25361;&#25136;&#30475;&#30475;&#21543;&#65281;<br>
	 * Message: Now! Why don't you take up the challenge?
	 */
	public static final NpcStringId NOW_WHY_DONT_YOU_TAKE_UP_THE_CHALLENGE;
	
	/**
	 * ID: 1800722<br>
	 * Message: ĂI<br>
	 * Message: &#36225;&#29694;&#22312;&#20840;&#37117;&#20358;&#25361;&#25136;&#21543;&#65281;<br>
	 * Message: Come on, I'll take all of you on!
	 */
	public static final NpcStringId COME_ON_ILL_TAKE_ALL_OF_YOU_ON;
	
	/**
	 * ID: 1800723<br>
	 * Message: ǂȈȁB<br>
	 * Message: &#24590;&#40636;&#27171;&#65311;&#25033;&#35442;&#25105;&#26159;&#36111;&#23478;&#21543;&#65311;<br>
	 * Message: How about it? I think I won?
	 */
	public static final NpcStringId HOW_ABOUT_IT_I_THINK_I_WON;
	
	/**
	 * ID: 1800724<br>
	 * Message: ͏₪I<br>
	 * Message: &#20358;&#65281;&#65281;&#36664;&#30340;&#20642;&#20249;&#20840;&#37117;&#36208;&#38283;&#65281;<br>
	 * Message: Now!! Those of you who lost, go away!
	 */
	public static final NpcStringId NOW_THOSE_OF_YOU_WHO_LOST_GO_AWAY;
	
	/**
	 * ID: 1800725<br>
	 * Message: Ƙr̗͂Ȃ̂I<br>
	 * Message: &#27794;&#20160;&#40636;&#22823;&#19981;&#20102;&#30340;&#20642;&#20249;&#22043;&#65281;<br>
	 * Message: What a bunch of losers.
	 */
	public static final NpcStringId WHAT_A_BUNCH_OF_LOSERS;
	
	/**
	 * ID: 1800726<br>
	 * Message: NX}X T^~ɗ悤ȁBA肪ȁB<br>
	 * Message: &#30475;&#20358;&#20320;&#22909;&#20687;&#26159;&#20358;&#25937;&#32854;&#35477;&#32769;&#20154;&#30340;&#65292;&#20294;&#20320;&#25214;&#37679;&#23565;&#35937;&#20102;&#12290;<br>
	 * Message: I guess you came to rescue Santa. But you picked the wrong person.
	 */
	public static final NpcStringId I_GUESS_YOU_CAME_TO_RESCUE_SANTA_BUT_YOU_PICKED_THE_WRONG_PERSON;
	
	/**
	 * ID: 1800727<br>
	 * Message: A邶˂B<br>
	 * Message: &#25402;&#46;&#46;&#46;&#25402;&#19981;&#37679;&#30340;&#21908;&#65311;<br>
	 * Message: Ah, okay...
	 */
	public static final NpcStringId AH_OKAY;
	
	/**
	 * ID: 1800728<br>
	 * Message: o񂶂ȂI<br>
	 * Message: &#21769;&#65281;&#65281;&#25105;&#19981;&#35442;&#20986;&#37027;&#20491;&#30340;&#65281;<br>
	 * Message: Agh!! I wasn't going to do that!
	 */
	public static final NpcStringId UAGH_I_WASNT_GOING_TO_DO_THAT;
	
	/**
	 * ID: 1800729<br>
	 * Message: ̎􂢂󂯂IAH<br>
	 * Message: &#25509;&#21463;&#25105;&#30340;&#35419;&#21650;&#21543;&#65281;&#65281;&#21670;&#46;&#46;&#21670;&#46;&#46;&#65311;<br>
	 * Message: You're cursed!! Oh.. What?
	 */
	public static final NpcStringId YOURE_CURSED_OH_WHAT;
	
	/**
	 * ID: 1800730<br>
	 * Message: 񂯂΂Ă񂶂˂I<br>
	 * Message: &#21507;&#39165;&#39151;&#65292;&#20320;&#30433;&#29609;&#20123;&#21098;&#20992;&#30707;&#38957;&#24067;&#21862;&#65281;&#65281;<br>
	 * Message: Have you done nothing but rock-paper-scissors??
	 */
	public static final NpcStringId HAVE_YOU_DONE_NOTHING_BUT_ROCK_PAPER_SCISSORS;
	
	/**
	 * ID: 1800731<br>
	 * Message: ߂DDD{͎₵񂾁DDD<br>
	 * Message: &#22909;&#20102;&#65292;&#19981;&#29609;&#20102;&#46;&#46;&#46;&#25105;&#26159;&#22240;&#28858;&#36942;&#26044;&#23490;&#23518;&#65292;&#25152;&#20197;&#25165;&#26371;&#37027;&#40636;&#20570;&#30340;&#46;&#46;&#46;<br>
	 * Message: Stop it, no more... I did it because I was too lonely...
	 */
	public static final NpcStringId STOP_IT_NO_MORE_I_DID_IT_BECAUSE_I_WAS_TOO_LONELY;
	
	/**
	 * ID: 1800732<br>
	 * Message: INX}X T^ĂȂȂ˂Ƃ͂ȁI<br>
	 * Message: &#31455;&#28982;&#35201;&#25918;&#36208;&#32854;&#35477;&#32769;&#20154;&#46;&#46;&#46;&#30495;&#27683;&#20154;&#65281;&#65281;&#65281;<br>
	 * Message: I have to release Santa... How infuriating!!!
	 */
	public static final NpcStringId I_HAVE_TO_RELEASE_SANTA_HOW_INFURIATING;
	
	/**
	 * ID: 1800733<br>
	 * Message: NX}XȂ񂩑[I<br>
	 * Message: &#25105;&#19981;&#35201;&#24555;&#27138;&#30340;&#32854;&#35477;&#31680;&#65281;&#65281;&#65281;&#65281;<br>
	 * Message: I hate happy Merry Christmas!!!
	 */
	public static final NpcStringId I_HATE_HAPPY_MERRY_CHRISTMAS;
	
	/**
	 * ID: 1800734<br>
	 * Message: `肢`<br>
	 * Message: &#21834;&#65292;&#30495;&#28961;&#32842;&#12290;<br>
	 * Message: Oh. I'm bored.
	 */
	public static final NpcStringId OH_IM_BORED;
	
	/**
	 * ID: 1800735<br>
	 * Message: NX}X T^l߂܂Ă邩ɍsBЂЂI<br>
	 * Message: &#25105;&#21435;&#30475;&#30475;&#32854;&#35477;&#32769;&#20154;&#26377;&#27794;&#26377;&#22909;&#22909;&#34987;&#38364;&#22312;&#35041;&#38754;&#65311;&#65281;&#22075;&#22075;&#12290;<br>
	 * Message: Shall I go to take a look if Santa is still there? Hehe
	 */
	public static final NpcStringId SHALL_I_GO_TO_TAKE_A_LOOK_IF_SANTA_IS_STILL_THERE_HEHE;
	
	/**
	 * ID: 1800736<br>
	 * Message: IbzbzDDD[NX}XI<br>
	 * Message: &#21628;&#21628;&#21628;&#46;&#46;&#46;&#32854;&#35477;&#24555;&#27138;&#65281;&#65281;<br>
	 * Message: Oh ho ho.... Merry Christmas!!
	 */
	public static final NpcStringId OH_HO_HO_MERRY_CHRISTMAS;
	
	/**
	 * ID: 1800737<br>
	 * Message: NX}X T^ėĂȂv[g͂ȂB<br>
	 * Message: &#28779;&#38622;&#35201;&#39686;&#32129;&#32854;&#35477;&#32769;&#20154;&#65292;&#25165;&#26371;&#26377;&#22909;&#31150;&#29289;&#21602;&#46;&#46;&#46;<br>
	 * Message: Santa could give nice presents only if he's released from the Turkey...
	 */
	public static final NpcStringId SANTA_COULD_GIVE_NICE_PRESENTS_ONLY_IF_HES_RELEASED_FROM_THE_TURKEY;
	
	/**
	 * ID: 1800738<br>
	 * Message: IbzbzDDDD݂ȂAJlB͕K܂B<br>
	 * Message: &#21628;&#21628;&#21628;&#46;&#46;&#46;&#21628;&#21628;&#21628;&#46;&#46;&#46;&#35613;&#35613;&#65292;&#21508;&#20301;&#65281;&#25105;&#19968;&#23450;&#26371;&#20358;&#22577;&#31572;&#30340;&#12290;<br>
	 * Message: Oh ho ho... Oh ho ho... Thank you. Ladies and gentlemen! I will repay you for sure.
	 */
	public static final NpcStringId OH_HO_HO_OH_HO_HO_THANK_YOU_LADIES_AND_GENTLEMEN_I_WILL_REPAY_YOU_FOR_SURE;
	
	/**
	 * ID: 1800739<br>
	 * Message: [NX}XIJlB<br>
	 * Message: &#32854;&#35477;&#24555;&#27138;&#126;&#32;&#36763;&#33510;&#20102;&#12290;<br>
	 * Message: Merry Christmas~ You're doing a good job.
	 */
	public static final NpcStringId UMERRY_CHRISTMAS_YOURE_DOING_A_GOOD_JOB;
	
	/**
	 * ID: 1800740<br>
	 * Message: [NX}XILve ^[L[~ĂĂ肪ƂB<br>
	 * Message: &#32854;&#35477;&#24555;&#27138;&#126;&#32;&#30495;&#30340;&#38750;&#24120;&#24863;&#35613;&#20320;&#65292;&#24478;&#37027;&#35342;&#21421;&#30340;&#28779;&#38622;&#25937;&#20102;&#25105;&#20986;&#20358;&#12290;<br>
	 * Message: Merry Christmas~ Thank you for rescuing me from that wretched Turkey.
	 */
	public static final NpcStringId MERRY_CHRISTMAS_THANK_YOU_FOR_RESCUING_ME_FROM_THAT_WRETCHED_TURKEY;
	
	/**
	 * ID: 1800741<br>
	 * Message: $s1AN̂߂Ƀv[gpӂB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#65292;&#25105;&#28858;&#20320;&#28310;&#20633;&#20102;&#31150;&#29289;&#12290;<br>
	 * Message: $s1 . I have prepared a gift for you.
	 */
	public static final NpcStringId S1_I_HAVE_PREPARED_A_GIFT_FOR_YOU;
	
	/**
	 * ID: 1800742<br>
	 * Message: $s1Ƀv[gB<br>
	 * Message: &#25105;&#26377;&#31150;&#29289;&#35201;&#32102;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: I have a gift for $s1.
	 */
	public static final NpcStringId I_HAVE_A_GIFT_FOR_S1;
	
	/**
	 * ID: 1800743<br>
	 * Message: CxgĂB̃v[gACɓĂꂽ炠肪񂾂B<br>
	 * Message: &#26597;&#30475;&#19968;&#19979;&#36947;&#20855;&#28165;&#21934;&#65292;&#24076;&#26395;&#20320;&#26371;&#21916;&#27489;&#25105;&#30340;&#31150;&#29289;&#12290;<br>
	 * Message: Take a look at the inventory. I hope you like the gift I gave you.
	 */
	public static final NpcStringId TAKE_A_LOOK_AT_THE_INVENTORY_I_HOPE_YOU_LIKE_THE_GIFT_I_GAVE_YOU;
	
	/**
	 * ID: 1800744<br>
	 * Message: CxgĂBrbOȃv[gĂ邩ȂB<br>
	 * Message: &#26597;&#30475;&#19968;&#19979;&#36947;&#20855;&#28165;&#21934;&#65292;&#25110;&#35377;&#26371;&#26377;&#39640;&#27284;&#31150;&#29289;&#21908;&#126;<br>
	 * Message: Take a look at the inventory. Perhaps there might be a big present~
	 */
	public static final NpcStringId TAKE_A_LOOK_AT_THE_INVENTORY_PERHAPS_THERE_MIGHT_BE_A_BIG_PRESENT;
	
	/**
	 * ID: 1800745<br>
	 * Message: N̑̂͂񂴂肾BsI<br>
	 * Message: &#25105;&#24050;&#32147;&#25078;&#24471;&#29702;&#20320;&#20102;&#65292;&#25105;&#35201;&#36208;&#20102;&#12290;<br>
	 * Message: I'm tired of dealing with you. I'm leaving.
	 */
	public static final NpcStringId IM_TIRED_OF_DEALING_WITH_YOU_IM_LEAVING;
	
	/**
	 * ID: 1800746<br>
	 * Message: ܂ł肾I낻OĂB<br>
	 * Message: &#20320;&#35201;&#29609;&#21040;&#20160;&#40636;&#26178;&#20505;&#65311;&#25105;&#38283;&#22987;&#26377;&#40670;&#21421;&#29033;&#20102;&#12290;<br>
	 * Message: When are you going to stop? I slowly started to be tired of it.
	 */
	public static final NpcStringId WHEN_ARE_YOU_GOING_TO_STOP_I_SLOWLY_STARTED_TO_BE_TIRED_OF_IT;
	
	/**
	 * ID: 1800747<br>
	 * Message: NX}X T^̓`F킵~oĂꂽ$s1ɏj܂悤ɁDDD<br>
	 * Message: &#32854;&#35477;&#32769;&#20154;&#30340;&#30041;&#35328;&#65306;&#39000;&#25327;&#25937;&#25105;&#30340;&#12300;&#36;&#115;&#49;&#12301;&#20805;&#28415;&#31069;&#31119;&#126;<br>
	 * Message: Message from Santa Claus: Many blessings to $s1, who saved me~
	 */
	public static final NpcStringId MESSAGE_FROM_SANTA_CLAUS_MANY_BLESSINGS_TO_S1_WHO_SAVED_ME;
	
	/**
	 * ID: 1800748<br>
	 * Message: xł鎄BxȂ邱Ƃ͂ł܂B<br>
	 * Message: &#28961;&#27861;&#23559;&#24050;&#27515;&#30340;&#25105;&#20877;&#32622;&#26044;&#27515;&#22320;&#20102;&#46;&#46;&#46;<br>
	 * Message: I am already dead. You cannot kill me again...
	 */
	public static final NpcStringId I_AM_ALREADY_DEAD_YOU_CANNOT_KILL_ME_AGAIN;
	
	/**
	 * ID: 1800749<br>
	 * Message: ׂĂ̈ÍőI퓬̐ɂI<br>
	 * Message: &#38343;&#40845;&#30340;&#26063;&#20154;&#21834;&#65292;&#38568;&#25105;&#19968;&#21516;&#25136;&#39717;&#21543;&#65281;<br>
	 * Message: Oh followers of the Dragon of Darkness, fight by my side!
	 */
	public static final NpcStringId OH_FOLLOWERS_OF_THE_DRAGON_OF_DARKNESS_FIGHT_BY_MY_SIDE;
	
	/**
	 * ID: 1800750<br>
	 * Message: hRjAPI퓬ԐɂĂB<br>
	 * Message: &#40845;&#46;&#26063;&#46;&#36914;&#46;&#25915;&#46;&#20102;&#65292;&#35531;&#46;&#20570;&#46;&#22909;&#46;&#20633;&#46;&#25136;&#46;&#24037;&#46;&#20316;&#12290;<br>
	 * Message: The Dragon Race... are invading... Prepare... for battle...
	 */
	public static final NpcStringId THE_DRAGON_RACE_ARE_INVADING_PREPARE_FOR_BATTLE;
	
	/**
	 * ID: 1800751<br>
	 * Message: $s1l$s2̒ñT^N[XLve^[L[~o܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24478;&#28779;&#38622;&#37027;&#35041;&#25937;&#20986;&#20102;&#12300;&#36;&#115;&#50;&#12301;&#38936;&#22320;&#30340;&#32854;&#35477;&#32769;&#20154;&#12290;<br>
	 * Message: $s1 rescued Santa Claus of $s2 territory from the turkey.
	 */
	public static final NpcStringId S1_RESCUED_SANTA_CLAUS_OF_S2_TERRITORY_FROM_THE_TURKEY;
	
	/**
	 * ID: 1800752<br>
	 * Message: T^~oI<br>
	 * Message: &#32854;&#35477;&#32769;&#20154;&#25327;&#25937;&#25104;&#21151;&#65281;<br>
	 * Message: Santa Rescue Success!
	 */
	public static final NpcStringId SANTA_RESCUE_SUCCESS;
	
	/**
	 * ID: 1800753<br>
	 * Message: $s1l͕+$s2 $s3󂯎ɂȂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#29992;&#27494;&#22120;&#20132;&#25563;&#21048;&#38936;&#21462;&#20102;&#12300;&#43;&#36;&#115;&#50;&#36;&#115;&#51;&#12301;&#12290;<br>
	 * Message: $s1 received +$s2 $s3 through the weapon exchange coupon.
	 */
	public static final NpcStringId S1_RECEIVED_S2_S3_THROUGH_THE_WEAPON_EXCHANGE_COUPON;
	
	/**
	 * ID: 1800754<br>
	 * Message: ł܂ȁI<br>
	 * Message: &#19981;&#35201;&#32102;&#25105;&#32781;&#33457;&#27171;&#65281;<br>
	 * Message: Don't go prattling on!
	 */
	public static final NpcStringId DONT_GO_PRATTLING_ON;
	
	/**
	 * ID: 1800755<br>
	 * Message: vChȂ߁I肷鉿lȂI<br>
	 * Message: &#20320;&#20497;&#36889;&#20123;&#20642;&#20249;&#36899;&#26368;&#22522;&#26412;&#30340;&#23562;&#22196;&#37117;&#27794;&#26377;&#65281;&#19981;&#20540;&#24471;&#25105;&#21435;&#29702;&#26371;&#65281;<br>
	 * Message: You lowlifes with not even an ounce of pride! You're not worthy of opposing me!
	 */
	public static final NpcStringId YOU_LOWLIFES_WITH_NOT_EVEN_AN_OUNCE_OF_PRIDE_YOURE_NOT_WORTHY_OF_OPPOSING_ME;
	
	/**
	 * ID: 1800756<br>
	 * Message: AԈႦBuquqI̓u^IuquqI<br>
	 * Message: &#21564;&#21564;&#126;&#65281;&#19981;&#23565;&#126;&#32;&#32;&#40769;&#40769;&#126;&#65281;&#21890;&#126;&#65281;&#25105;&#26159;&#19968;&#38587;&#35948;&#32822;&#65281;&#40769;&#40769;&#126;&#65281;&#65281;<br>
	 * Message: Roar~! No~ Oink oink~! See~! I'm a pig~! Oink oink~!!
	 */
	public static final NpcStringId ROAR_NO_OINK_OINK_SEE_IM_A_PIG_OINK_OINK;
	
	/**
	 * ID: 1800757<br>
	 * Message: ͂ǂH͒NHuquqI<br>
	 * Message: &#25105;&#26159;&#35504;&#126;&#36889;&#35041;&#21448;&#26159;&#21738;&#35041;&#46;&#46;&#46;&#40769;&#40769;&#65281;<br>
	 * Message: Who am I~ Where am I... Oink oink!
	 */
	public static final NpcStringId WHO_AM_I_WHERE_AM_I_OINK_OINK;
	
	/**
	 * ID: 1800758<br>
	 * Message: FBƈꏏɗVтɗBuquqI<br>
	 * Message: &#25105;&#21482;&#19981;&#36942;&#26159;&#36319;&#33879;&#21726;&#21726;&#29275;&#20358;&#29609;&#32631;&#20102;&#126;&#40769;&#40769;&#65281;<br>
	 * Message: I just followed my friend here for fun~ Oink oink!
	 */
	public static final NpcStringId I_JUST_FOLLOWED_MY_FRIEND_HERE_FOR_FUN_OINK_OINK;
	
	/**
	 * ID: 1800759<br>
	 * Message: vn@`ܑZDɐݓnI<br>
	 * Message: &#21726;&#126;&#65281;&#21703;&#126;&#36889;&#21487;&#30495;&#26159;&#38728;&#34277;&#21834;&#126;&#126;&#65281;<br>
	 * Message: Wow! That's what I call a Cure-All!
	 */
	public static final NpcStringId WOW_THATS_WHAT_I_CALL_A_CURE_ALL;
	
	/**
	 * ID: 1800760<br>
	 * Message: H~ǂǂłĂBłHɍsׁB<br>
	 * Message: &#21726;&#126;&#126;&#39135;&#24958;&#24456;&#26106;&#30427;&#32822;&#65292;&#21435;&#21507;&#40670;&#33609;&#22909;&#20102;&#12290;<br>
	 * Message: I'm starving. Should I go chew some grass?
	 */
	public static final NpcStringId IM_STARVING_SHOULD_I_GO_CHEW_SOME_GRASS;
	
	/**
	 * ID: 1800761<br>
	 * Message: 肪ƂI<br>
	 * Message: &#35613;&#35613;&#126;&#19979;&#27425;&#25105;&#20497;&#19968;&#36215;&#21917;&#26479;&#29275;&#22902;&#21543;&#126;&#65281;<br>
	 * Message: Thank you, thank you!
	 */
	public static final NpcStringId THANK_YOU_THANK_YOU;
	
	/**
	 * ID: 1800762<br>
	 * Message: `ICoĂI<br>
	 * Message: &#21726;&#126;&#126;&#28779;&#29105;&#28779;&#29105;&#126;&#65281;&#24863;&#35258;&#21040;&#20803;&#27683;&#22312;&#24674;&#24489;&#20102;&#126;&#65281;<br>
	 * Message: What's this feeling? Oh oh~! Feels like my energy is back~!
	 */
	public static final NpcStringId WHATS_THIS_FEELING_OH_OH_FEELS_LIKE_MY_ENERGY_IS_BACK;
	
	/**
	 * ID: 1800763<br>
	 * Message: AꂱIJ_yȂ邱̊I<br>
	 * Message: &#21726;&#126;&#21703;&#65281;&#23601;&#26159;&#37027;&#35041;&#65281;&#24456;&#27491;&#40670;&#65281;<br>
	 * Message: My body's getting lighter~ This feeling! Feels familiar somehow!
	 */
	public static final NpcStringId MY_BODYS_GETTING_LIGHTER_THIS_FEELING_FEELS_FAMILIAR_SOMEHOW;
	
	/**
	 * ID: 1800764<br>
	 * Message: 킟`ꂪnĂ悤B<br>
	 * Message: &#21703;&#21978;&#126;&#24863;&#35258;&#21040;&#30130;&#21214;&#20840;&#37096;&#126;&#37117;&#39131;&#36208;&#20102;&#94;&#94;&#118;<br>
	 * Message: Wow~ My fatigue is completely gone!
	 */
	public static final NpcStringId WOW_MY_FATIGUE_IS_COMPLETELY_GONE;
	
	/**
	 * ID: 1800765<br>
	 * Message: sgȋCĂĂI<br>
	 * Message: &#21703;&#126;&#30130;&#21214;&#24230;&#22312;&#28187;&#23569;&#32822;&#126;&#65281;&#30130;&#21214;&#36880;&#28472;&#28187;&#36629;&#20102;&#65311;&#65281;<br>
	 * Message: Hey~ The ominous energy is disappeared~!
	 */
	public static final NpcStringId HEY_THE_OMINOUS_ENERGY_IS_DISAPPEARED;
	
	/**
	 * ID: 1800766<br>
	 * Message: J_Ȃ̂悤ɌyȂB<br>
	 * Message: &#21726;&#126;&#126;&#24863;&#35258;&#36523;&#39636;&#36629;&#30340;&#20687;&#32701;&#27611;&#19968;&#33324;&#21908;&#126;<br>
	 * Message: My body feels as light as a feather~
	 */
	public static final NpcStringId MY_BODY_FEELS_AS_LIGHT_AS_A_FEATHER;
	
	/**
	 * ID: 1800767<br>
	 * Message: AHHB<br>
	 * Message: &#36889;&#26159;&#20160;&#40636;&#65311;&#26159;&#21507;&#30340;&#65311;&#40769;&#40769;&#65281;<br>
	 * Message: What's this? Food?
	 */
	public static final NpcStringId WHATS_THIS_FOOD;
	
	/**
	 * ID: 1800768<br>
	 * Message: ݂͂ȂIC񕜍܂Ȃėv˂I<br>
	 * Message: &#21147;&#37327;&#21313;&#36275;&#126;&#65281;&#25105;&#21487;&#19981;&#38656;&#35201;&#20160;&#40636;&#24674;&#24489;&#30130;&#21214;&#21137;&#21602;&#126;&#40769;&#40769;&#65281;<br>
	 * Message: My energy is overflowing!!! I don't need any Fatigue Recovery Potion~
	 */
	public static final NpcStringId MY_ENERGY_IS_OVERFLOWING_I_DONT_NEED_ANY_FATIGUE_RECOVERY_POTION;
	
	/**
	 * ID: 1800769<br>
	 * Message: Ă񂾁IHflI<br>
	 * Message: &#24185;&#22043;&#65311;&#19968;&#40670;&#37117;&#19981;&#23560;&#26989;&#65281;&#20687;&#24674;&#24489;&#30130;&#21214;&#21137;&#36889;&#31278;&#26481;&#35199;&#65292;&#20320;&#36996;&#26159;&#25343;&#21435;&#39221;&#29275;&#21543;&#126;&#40769;&#40769;&#65281;<br>
	 * Message: What's the matter? That's an amateur move!
	 */
	public static final NpcStringId WHATS_THE_MATTER_THATS_AN_AMATEUR_MOVE;
	
	/**
	 * ID: 1800770<br>
	 * Message: _u`XI10bȓɎÂΕ܂2{I<br>
	 * Message: &#24184;&#36939;&#35336;&#26178;&#65306;&#22312;&#49;&#48;&#31186;&#20197;&#20839;&#23436;&#25104;&#30340;&#35441;&#65292;&#23601;&#21487;&#24471;&#21040;&#50;&#20493;&#22577;&#37228;&#65281;<br>
	 * Message: Fortune Timer: Reward increases 2 times if completed within 10 seconds!
	 */
	public static final NpcStringId FORTUNE_TIMER_REWARD_INCREASES_2_TIMES_IF_COMPLETED_WITHIN_10_SECONDS;
	
	/**
	 * ID: 1800771<br>
	 * Message: _u`XI40bȓɎÂΕ܂2{I<br>
	 * Message: &#24184;&#36939;&#35336;&#26178;&#65306;&#22312;&#52;&#48;&#31186;&#20197;&#20839;&#23436;&#25104;&#30340;&#35441;&#65292;&#23601;&#21487;&#24471;&#21040;&#50;&#20493;&#22577;&#37228;&#65281;<br>
	 * Message: Fortune Timer: Reward increases 2 times if completed within 40 seconds!
	 */
	public static final NpcStringId FORTUNE_TIMER_REWARD_INCREASES_2_TIMES_IF_COMPLETED_WITHIN_40_SECONDS;
	
	/**
	 * ID: 1800772<br>
	 * Message: c40błB<br>
	 * Message: &#21097;&#39192;&#52;&#48;&#31186;&#12290;<br>
	 * Message: 40 seconds are remaining.
	 */
	public static final NpcStringId N40_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800773<br>
	 * Message: c39błB<br>
	 * Message: &#21097;&#39192;&#51;&#57;&#31186;&#12290;<br>
	 * Message: 39 seconds are remaining.
	 */
	public static final NpcStringId N39_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800774<br>
	 * Message: c38błB<br>
	 * Message: &#21097;&#39192;&#51;&#56;&#31186;&#12290;<br>
	 * Message: 38 seconds are remaining.
	 */
	public static final NpcStringId N38_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800775<br>
	 * Message: c37błB<br>
	 * Message: &#21097;&#39192;&#51;&#55;&#31186;&#12290;<br>
	 * Message: 37 seconds are remaining.
	 */
	public static final NpcStringId N37_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800776<br>
	 * Message: c36błB<br>
	 * Message: &#21097;&#39192;&#51;&#54;&#31186;&#12290;<br>
	 * Message: 36 seconds are remaining.
	 */
	public static final NpcStringId N36_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800777<br>
	 * Message: c35błB<br>
	 * Message: &#21097;&#39192;&#51;&#53;&#31186;&#12290;<br>
	 * Message: 35 seconds are remaining.
	 */
	public static final NpcStringId N35_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800778<br>
	 * Message: c34błB<br>
	 * Message: &#21097;&#39192;&#51;&#52;&#31186;&#12290;<br>
	 * Message: 34 seconds are remaining.
	 */
	public static final NpcStringId N34_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800779<br>
	 * Message: c33błB<br>
	 * Message: &#21097;&#39192;&#51;&#51;&#31186;&#12290;<br>
	 * Message: 33 seconds are remaining.
	 */
	public static final NpcStringId N33_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800780<br>
	 * Message: c32błB<br>
	 * Message: &#21097;&#39192;&#51;&#50;&#31186;&#12290;<br>
	 * Message: 32 seconds are remaining.
	 */
	public static final NpcStringId N32_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800781<br>
	 * Message: c31błB<br>
	 * Message: &#21097;&#39192;&#51;&#49;&#31186;&#12290;<br>
	 * Message: 31 seconds are remaining.
	 */
	public static final NpcStringId N31_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800782<br>
	 * Message: c30błB<br>
	 * Message: &#21097;&#39192;&#51;&#48;&#31186;&#12290;<br>
	 * Message: 30 seconds are remaining.
	 */
	public static final NpcStringId N30_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800783<br>
	 * Message: c29błB<br>
	 * Message: &#21097;&#39192;&#50;&#57;&#31186;&#12290;<br>
	 * Message: 29 seconds are remaining.
	 */
	public static final NpcStringId N29_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800784<br>
	 * Message: c28błB<br>
	 * Message: &#21097;&#39192;&#50;&#56;&#31186;&#12290;<br>
	 * Message: 28 seconds are remaining.
	 */
	public static final NpcStringId N28_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800785<br>
	 * Message: c27błB<br>
	 * Message: &#21097;&#39192;&#50;&#55;&#31186;&#12290;<br>
	 * Message: 27 seconds are remaining.
	 */
	public static final NpcStringId N27_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800786<br>
	 * Message: c26błB<br>
	 * Message: &#21097;&#39192;&#50;&#54;&#31186;&#12290;<br>
	 * Message: 26 seconds are remaining.
	 */
	public static final NpcStringId N26_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800787<br>
	 * Message: c25błB<br>
	 * Message: &#21097;&#39192;&#50;&#53;&#31186;&#12290;<br>
	 * Message: 25 seconds are remaining.
	 */
	public static final NpcStringId N25_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800788<br>
	 * Message: c24błB<br>
	 * Message: &#21097;&#39192;&#50;&#52;&#31186;&#12290;<br>
	 * Message: 24 seconds are remaining.
	 */
	public static final NpcStringId N24_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800789<br>
	 * Message: c23błB<br>
	 * Message: &#21097;&#39192;&#50;&#51;&#31186;&#12290;<br>
	 * Message: 23 seconds are remaining.
	 */
	public static final NpcStringId N23_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800790<br>
	 * Message: c22błB<br>
	 * Message: &#21097;&#39192;&#50;&#50;&#31186;&#12290;<br>
	 * Message: 22 seconds are remaining.
	 */
	public static final NpcStringId N22_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800791<br>
	 * Message: c21błB<br>
	 * Message: &#21097;&#39192;&#50;&#49;&#31186;&#12290;<br>
	 * Message: 21 seconds are remaining.
	 */
	public static final NpcStringId N21_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800792<br>
	 * Message: c20błB<br>
	 * Message: &#21097;&#39192;&#50;&#48;&#31186;&#12290;<br>
	 * Message: 20 seconds are remaining.
	 */
	public static final NpcStringId N20_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800793<br>
	 * Message: c19błB<br>
	 * Message: &#21097;&#39192;&#49;&#57;&#31186;&#12290;<br>
	 * Message: 19 seconds are remaining.
	 */
	public static final NpcStringId N19_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800794<br>
	 * Message: c18błB<br>
	 * Message: &#21097;&#39192;&#49;&#56;&#31186;&#12290;<br>
	 * Message: 18 seconds are remaining.
	 */
	public static final NpcStringId N18_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800795<br>
	 * Message: c17błB<br>
	 * Message: &#21097;&#39192;&#49;&#55;&#31186;&#12290;<br>
	 * Message: 17 seconds are remaining.
	 */
	public static final NpcStringId N17_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800796<br>
	 * Message: c16błB<br>
	 * Message: &#21097;&#39192;&#49;&#54;&#31186;&#12290;<br>
	 * Message: 16 seconds are remaining.
	 */
	public static final NpcStringId N16_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800797<br>
	 * Message: c15błB<br>
	 * Message: &#21097;&#39192;&#49;&#53;&#31186;&#12290;<br>
	 * Message: 15 seconds are remaining.
	 */
	public static final NpcStringId N15_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800798<br>
	 * Message: c14błB<br>
	 * Message: &#21097;&#39192;&#49;&#52;&#31186;&#12290;<br>
	 * Message: 14 seconds are remaining.
	 */
	public static final NpcStringId N14_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800799<br>
	 * Message: c13błB<br>
	 * Message: &#21097;&#39192;&#49;&#51;&#31186;&#12290;<br>
	 * Message: 13 seconds are remaining.
	 */
	public static final NpcStringId N13_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800800<br>
	 * Message: c12błB<br>
	 * Message: &#21097;&#39192;&#49;&#50;&#31186;&#12290;<br>
	 * Message: 12 seconds are remaining.
	 */
	public static final NpcStringId N12_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800801<br>
	 * Message: c11błB<br>
	 * Message: &#21097;&#39192;&#49;&#49;&#31186;&#12290;<br>
	 * Message: 11 seconds are remaining.
	 */
	public static final NpcStringId N11_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800802<br>
	 * Message: c10błB<br>
	 * Message: &#21097;&#39192;&#49;&#48;&#31186;&#12290;<br>
	 * Message: 10 seconds are remaining.
	 */
	public static final NpcStringId N10_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800803<br>
	 * Message: c9błB<br>
	 * Message: &#21097;&#39192;&#57;&#31186;&#12290;<br>
	 * Message: 9 seconds are remaining.
	 */
	public static final NpcStringId N9_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800804<br>
	 * Message: c8błB<br>
	 * Message: &#21097;&#39192;&#56;&#31186;&#12290;<br>
	 * Message: 8 seconds are remaining.
	 */
	public static final NpcStringId N8_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800805<br>
	 * Message: c7błB<br>
	 * Message: &#21097;&#39192;&#55;&#31186;&#12290;<br>
	 * Message: 7 seconds are remaining.
	 */
	public static final NpcStringId N7_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800806<br>
	 * Message: c6błB<br>
	 * Message: &#21097;&#39192;&#54;&#31186;&#12290;<br>
	 * Message: 6 seconds are remaining.
	 */
	public static final NpcStringId N6_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800807<br>
	 * Message: c5błB<br>
	 * Message: &#21097;&#39192;&#53;&#31186;&#12290;<br>
	 * Message: 5 seconds are remaining.
	 */
	public static final NpcStringId N5_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800808<br>
	 * Message: c4błB<br>
	 * Message: &#21097;&#39192;&#52;&#31186;&#12290;<br>
	 * Message: 4 seconds are remaining.
	 */
	public static final NpcStringId N4_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800809<br>
	 * Message: c3błB<br>
	 * Message: &#21097;&#39192;&#51;&#31186;&#12290;<br>
	 * Message: 3 seconds are remaining.
	 */
	public static final NpcStringId N3_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800810<br>
	 * Message: c2błB<br>
	 * Message: &#21097;&#39192;&#50;&#31186;&#12290;<br>
	 * Message: 2 seconds are remaining.
	 */
	public static final NpcStringId N2_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800811<br>
	 * Message: c1błB<br>
	 * Message: &#21097;&#39192;&#49;&#31186;&#12290;<br>
	 * Message: 1 seconds are remaining.
	 */
	public static final NpcStringId N1_SECONDS_ARE_REMAINING;
	
	/**
	 * ID: 1800812<br>
	 * Message: II<br>
	 * Message: &#26178;&#38291;&#21040;&#65281;<br>
	 * Message: Time up!
	 */
	public static final NpcStringId TIME_UP;
	
	/**
	 * ID: 1800813<br>
	 * Message: ÂɎs܂DDD<br>
	 * Message: &#20219;&#21209;&#22833;&#25943;&#65281;<br>
	 * Message: Mission failed!
	 */
	public static final NpcStringId MISSION_FAILED;
	
	/**
	 * ID: 1800814<br>
	 * Message: Âɐ܂I<br>
	 * Message: &#20219;&#21209;&#25104;&#21151;&#65281;<br>
	 * Message: Mission success!
	 */
	public static final NpcStringId MISSION_SUCCESS;
	
	/**
	 * ID: 1800815<br>
	 * Message: ȂAɂ͉ƒ낪񂾁B<br>
	 * Message: &#21890;&#65292;&#25105;&#21487;&#26159;&#21517;&#33457;&#26377;&#20027;&#30340;&#21908;&#126;<br>
	 * Message: Hey! I already have an owner!
	 */
	public static final NpcStringId HEY_I_ALREADY_HAVE_AN_OWNER;
	
	/**
	 * ID: 1800816<br>
	 * Message: IĂĐHĂ̂IHL[sbȟC񕜍܂gĂB<br>
	 * Message: &#21890;&#126;&#20320;&#25171;&#31639;&#25226;&#25105;&#21507;&#25481;&#21834;&#65311;&#65281;&#28858;&#25105;&#20351;&#29992;&#37041;&#27604;&#29305;&#30340;&#24674;&#24489;&#30130;&#21214;&#21137;&#21543;&#65281;<br>
	 * Message: Hey~. Are you planning on eating me?! Use a Cupid's Fatigue Recovery Potion already!
	 */
	public static final NpcStringId HEY_ARE_YOU_PLANNING_ON_EATING_ME_USE_A_CUPIDS_FATIGUE_RECOVERY_POTION_ALREADY;
	
	/**
	 * ID: 1800817<br>
	 * Message: @͉̌Bfl̃}bT[W͉āAL[sbȟC񕜍܂ɂƂB<br>
	 * Message: &#19981;&#22816;&#23560;&#26989;&#30340;&#32147;&#32097;&#25353;&#25705;&#25105;&#21487;&#19981;&#25509;&#21463;&#12290;&#28858;&#25105;&#20351;&#29992;&#37041;&#27604;&#29305;&#30340;&#24674;&#24489;&#30130;&#21214;&#21137;&#21543;&#65281;<br>
	 * Message: I'll pass on an amateur's meridian massage. Use a Cupid's Fatigue Recovery Potion already!
	 */
	public static final NpcStringId ILL_PASS_ON_AN_AMATEURS_MERIDIAN_MASSAGE_USE_A_CUPIDS_FATIGUE_RECOVERY_POTION_ALREADY;
	
	/**
	 * ID: 1800818<br>
	 * Message: ȂɑꂪȂĂȁB$s1AB<br>
	 * Message: &#21726;&#126;&#32;&#21726;&#65292;&#31455;&#28982;&#33021;&#22816;&#22914;&#27492;&#36805;&#36895;&#22320;&#24674;&#24489;&#30130;&#21214;&#65292;&#12300;&#36;&#115;&#49;&#12301;&#30495;&#26159;&#22826;&#24863;&#35613;&#24744;&#20102;&#126;<br>
	 * Message: I already feel more energetic. Thanks, $s1~
	 */
	public static final NpcStringId I_ALREADY_FEEL_MORE_ENERGETIC_THANKS_S1;
	
	/**
	 * ID: 1800819<br>
	 * Message: XbLI񂽂̓}bT[W̒BlA$s1搶B<br>
	 * Message: &#24674;&#24489;&#30340;&#30495;&#24555;&#65292;&#38627;&#36947;&#24744;&#23601;&#26159;&#25353;&#25705;&#30340;&#36948;&#20154;&#65292;&#20839;&#20663;&#12300;&#36;&#115;&#49;&#12301;&#22823;&#24107;&#65311;&#65281;<br>
	 * Message: How refreshing! You wouldn't happen to be a master masseuse, $s1, would you?
	 */
	public static final NpcStringId HOW_REFRESHING_YOU_WOULDNT_HAPPEN_TO_BE_A_MASTER_MASSEUSE_S1_WOULD_YOU;
	
	/**
	 * ID: 1800820<br>
	 * Message: ȁI$s1A񂽂̓}bT[W̗jhւI<br>
	 * Message: &#30495;&#20102;&#19981;&#36215;&#65292;&#24448;&#24460;&#25353;&#25705;&#30340;&#27511;&#21490;&#23559;&#26371;&#20197;&#12300;&#36;&#115;&#49;&#12301;&#20358;&#21123;&#20998;&#21069;&#24460;&#65281;<br>
	 * Message: Incredible. From now on, I'll compare all massages to this one with $s1!
	 */
	public static final NpcStringId INCREDIBLE_FROM_NOW_ON_ILL_COMPARE_ALL_MASSAGES_TO_THIS_ONE_WITH_S1;
	
	/**
	 * ID: 1800821<br>
	 * Message: ЂƂł̂͂ǂH͒Ԃƃp[eB[głȁB<br>
	 * Message: &#19968;&#20491;&#20154;&#24456;&#36763;&#33510;&#21543;&#65311;&#19979;&#27425;&#23601;&#25214;&#20123;&#22821;&#20276;&#20497;&#32068;&#20491;&#38538;&#65292;&#28982;&#24460;&#20877;&#35430;&#35430;&#21543;&#126;<br>
	 * Message: Isn't it tough doing it all on your own! Next time, try making a party with some comrades~
	 */
	public static final NpcStringId ISNT_IT_TOUG