/*
 * Copyright (C) 2004-2013 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.npc.Teleports.TeleportToFantasy;

import ai.npc.AbstractNpcAI;

import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.quest.State;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.clientpackets.Say2;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.util.Util;

/**
 * Fantasy Island teleport AI.<br>
 * Original python script by Kerberos.
 * @author Plim
 */
public class TeleportToFantasy extends AbstractNpcAI
{
	// NPC
	private static final int PADDIES = 32378;
	// Misc
	//@formatter:off
	private static final int[] TELEPORTERS =
	{
	/*id*/    -1,
	/* 1*/ 30320,	// RICHLIN
	/* 2*/ 30256,	// BELLA
	/* 3*/ 30059,	// TRISHA
	/* 4*/ 30080,	// CLARISSA
	/* 5*/ 30899,	// FLAUEN
	/* 6*/ 30177,	// VALENTIA
	/* 7*/ 30848,	// ELISA
	/* 8*/ 30233,	// ESMERALDA
	/* 9*/ 31320,	// ILYANA
	/*10*/ 31275,	// TATIANA
	/*11*/ 31964,	// BILIA
	};
	// Locations
	private static final Location[] RETURN_LOCS =
	{
	/*id*/ null,
	/* 1*/ new Location(-80826, 149775, -3043),
	/* 2*/ new Location(-12672, 122776, -3116),
	/* 3*/ new Location(15670, 142983, -2705),
	/* 4*/ new Location(83400, 147943, -3404),
	/* 5*/ new Location(111409, 219364, -3545),
	/* 6*/ new Location(82956, 53162, -1495),
	/* 7*/ new Location(146331, 25762, -2018),
	/* 8*/ new Location(116819, 76994, -2714),
	/* 9*/ new Location(43835, -47749, -792),
	/*10*/ new Location(147930, -55281, -2728),
	/*11*/ new Location(87386, -143246, -1293),
	};
	
	private static final Location[] ISLE_LOCS =
	{
		new Location(-58752, -56898, -2032),
		new Location(-59716, -57868, -2032),
		new Location(-60691, -56893, -2032),
		new Location(-59720, -55921, -2032)
	};
	//@formatter:on
	
	@Override
	public String onTalk(L2Npc npc, L2PcInstance player)
	{
		String htmltext = "";
		QuestState st = player.getQuestState(getName());
		
		if (st == null)
		{
			return null;
		}
		
		int teleport_id;
		int return_id;
		if ((teleport_id = Util.indexOf(TELEPORTERS, npc.getNpcId())) > 0)
		{
			player.teleToLocation(ISLE_LOCS[getRandom(ISLE_LOCS.length)], false);
			st.setState(State.STARTED);
			st.set("id", String.valueOf(teleport_id));
		}
		else if (npc.getNpcId() == PADDIES)
		{
			if (st.getState() == State.STARTED && (return_id = st.getInt("id")) > 0 && return_id < RETURN_LOCS.length)
			{
				player.teleToLocation(RETURN_LOCS[return_id], false);
			}
			
			else
			{
				player.sendPacket(new NpcSay(npc.getObjectId(), Say2.NPC_ALL, npc.getNpcId(), NpcStringId.IF_YOUR_MEANS_OF_ARRIVAL_WAS_A_BIT_UNCONVENTIONAL_THEN_ILL_BE_SENDING_YOU_BACK_TO_RUNE_TOWNSHIP_WHICH_IS_THE_NEAREST_TOWN));
				player.teleToLocation(43835, -47749, -792);
			}
			st.unset("id");
			st.exitQuest(true);
		}
		return htmltext;
	}
	
	private TeleportToFantasy(String name, String descr)
	{
		super(name, descr);
		addStartNpc(TELEPORTERS);
		addTalkId(TELEPORTERS);
		
		addStartNpc(PADDIES);
		addTalkId(PADDIES);
	}
	
	public static void main(String[] args)
	{
		new TeleportToFantasy(TeleportToFantasy.class.getSimpleName(), "ai/npc/Teleports");
	}
}
