﻿## Active Perl 5.8.8

use utf8;
use warnings;
use strict;
use Encode;
binmode STDOUT, ':encoding(cp932)'; $|=1;

my $DEBUG = 0;

opendir DIR,'.'  or die $!;
my @files = readdir DIR;
closedir DIR;

foreach my $fileName (@files) {
	next if $fileName =~ m!^\.!;
	next unless $fileName =~ m!\.html?$!;

	open FILE, '<:utf8', $fileName  or die "'$fileName' $!";
	read FILE, my $htm, -s FILE;
	my $mtime = (stat FILE)[9];
	close FILE;

	my $original = $htm;
	$_           = $htm;
#----------------------------------------------------------------------------
# Fortress ～ Gate
s!(?<=[>;])Fortress East Gate(?=["<])!要塞 東門!gi;
s!(?<=[>;])Fortress North Gate(?=["<])!要塞 北門!gi;
s!(?<=[>;])Fortress South Gate(?=["<])!要塞 南門!gi;
s!(?<=[>;])Fortress West Gate(?=["<])!要塞 西門!gi;

s!(?<=[>;])East Gate(?=["<])!東門!gi;
s!(?<=[>;])North Gate(?=["<])!北門!gi;
s!(?<=[>;])South Gate(?=["<])!南門!gi;
s!(?<=[>;])West Gate(?=["<])!西門!gi;

# ～ Town Square
s!(?<=[>;])Aden Town Square(?=[" <])!アデン城の村 広場!gi;
s!(?<=[>;])Dion Town Square(?=[" <])!ディオン城の村 広場!gi;
s!(?<=[>;])Dion Town(?=[" <])!ディオン城の村!gi;
s!(?<=[>;])Giran Town Square(?=[" <])!ギラン城の村 広場!gi;
s!(?<=[>;])Gludio Town Square(?=[" <])!グルーディオ城の村 広場!gi;
s!(?<=[>;])Goddard Town Square(?=[" <])!ゴダード城の村 広場!gi;
s!(?<=[>;])Heine Town Square(?=[" <])!水上都市ハイネス 広場!gi;
s!(?<=[>;])Oren Town Square(?=[" <])!オーレン城の村 広場!gi;
s!(?<=[>;])Oren Town(?=[" <])!オーレン城の村!gi;
s!(?<=[>;])Rune Town Square(?=[" <])!ルウン城の村 広場!gi;
s!(?<=[>;])Schuttgart Town Square(?=[" <])!シュチュッツガルト城の村 広場!gi;

# Front of the ～ Castle Gate
s/\bFront of the Aden Castle Gate\b/アデン城門前/gi;
s/\bFront of the Dion Castle Gate\b/デイォン城門前/gi;
s/\bFront of the Giran Castle Gate\b/ギラン城門前/gi;
s/\bFront of the Gludio Castle Gate\b/グルーディオ城門前/gi;
s/\bFront of the Goddard Castle Gate\b/ゴダード城門前/gi;
s/\bFront of Goddard Castle\b/ゴダード城門前/gi;
s/\bFront of the Innadril Castle Gate\b/インナドリル城門前/gi;
s/\bFront of the Oren Castle Gate\b/オーレン城門前/gi;
s/\bFront of the Rune Castle Gate\b/ルウン城門前/gi;
s/\bFront of the Schuttgart Castle Gate\b/シュチュッツガルト城門前/gi;

s/ ?- ?(\d+) ?Adena/ - $1 Adena/gi;
s/ - 0 Adena/ - 無料/gi;
s/(\d+) Adena/$1 アデナ/gi;
#----------------------------------------------------------------------------
	$htm = $_;

	if ($htm ne $original) {
		print $fileName,"\n";
		my $output = $fileName;
		   $output = "$fileName.text" if $DEBUG;
		open FILE, '>:utf8', $output  or die "'$output' $!";
		$htm = "\x{feff}".$htm unless $htm =~ m/^\x{feff}/;  #BOM
		print FILE $htm;
		close FILE;
		utime $mtime,$mtime,$output;
	}
}
