/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package handlers.admincommandhandlers;

import com.l2jserver.gameserver.handler.IAdminCommandHandler;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.Say2;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

/**
 * @author Zoey76
 */
public class AdminMessages implements IAdminCommandHandler
{
	private static final String[] ADMIN_COMMANDS =
	{
		"admin_npcsay",	//[JOJO]
		"admin_msg"
	};
	
	@Override
	public boolean useAdminCommand(String command, L2PcInstance activeChar)
	{
		if (command.startsWith("admin_npcsay"))
		{
			try
			{
				String[] args = command.split(" +");
				L2Object target = activeChar.getTarget();
				if (!(target instanceof L2Npc))
				{
					activeChar.sendPacket(SystemMessageId.TARGET_IS_INCORRECT);
				}
				else
				{
					L2Npc npc = (L2Npc) target;
					if (npc.getTemplate().isServerSideName() || npc.getNpcId() != npc.getTemplate().getIdTemplate())
						activeChar.sendMessage("WARNING: Custom NPC cannot say npcstring.");
					// throw new UnsupportedOperationException();
					NpcSay cs = new NpcSay(npc.getObjectId(), Say2.ALL, npc.getNpcId(), Integer.parseInt(args[1]));
					for (int i = 2; i < args.length; ++i)
						cs.addString(args[i]);
					activeChar.sendPacket(cs);
				}
				return true;
			}
			catch (ArrayIndexOutOfBoundsException | NumberFormatException e)
			{
				activeChar.sendMessage("Usage: //npcsay <NPC_STRING_ID> [<ARG_1> <ARG_2>...]");
			}
		}
		else if (command.startsWith("admin_msg"))
		{
			try
			{
				String[] args = command.split(" +");
				SystemMessage sm = SystemMessage.getSystemMessage(Integer.parseInt(args[1]));
				for (int i = 2; i < args.length; ++i)
					sm.addString(args[i]);
				activeChar.sendPacket(sm);
				return true;
			}
			catch (ArrayIndexOutOfBoundsException | NumberFormatException e)
			{
				activeChar.sendMessage("Usage: //msg <SYSTEM_MSG_ID> [<ARG_1> <ARG_2>...]");
			}
		}
		return false;
	}
	
	@Override
	public String[] getAdminCommandList()
	{
		return ADMIN_COMMANDS;
	}
}