﻿## Active Perl 5.8.8

use utf8;
use warnings;
use strict;
use Encode;
binmode STDOUT, ':encoding(cp932)'; $|=1;

my $DEBUG = 0;

&start('./');
exit 0;

sub start {
	my ($subDir) = @_;

	opendir DIR,$subDir  or die $!;
	my @files = readdir DIR;
	closedir DIR;

	foreach my $fileName (@files) {
		next if $fileName =~ m/^\./;
		next if $fileName =~ m/ /;
		next unless $fileName =~ m!\.html?$!;

		my $filePath = $subDir.$fileName;
		open FILE, '<:utf8', $filePath  or die "'$filePath' $!";
		read FILE, my $htm, -s FILE;
		my $mtime = (stat FILE)[9];
		close FILE;

		my $original = $htm;
		$_           = $htm;
#----------------------------------------------------------------------------
s{>Open the gate<}{>門を開く<};		#仮
s{>Close the gate<}{>門を閉じる<};	#仮

# ****-no.htm
s{<body>Who goes there\?!<br>\s*Stay back!\s*</body>}
 {<body>怪しい奴だな！<br>
さっさと消えろ！
</body>};

s{<body>Who goes there\?!<br>\s*I order you to leave at once!\s*</body>}
 {<body>怪しい奴だな！<br>
さっさと消えろ！
</body>};

s{<body>You cannot enter if you are not qualified!\s*</body>}
 {<body>資格がない者を入らせるわけにはいかん！
</body>};

s{<body>Ha! Are you kidding\? Get out of here quick or you'll regret it!\s*</body>}
 {<body>ふふ．．．。ふざけるのもいい加減にしてくれ。とっとと失せろ！さもないと命の保証はないぞ！
</body>};

#----------------------------------------------------------------------------
		$htm = $_;

		if ($htm ne $original) {
			print $filePath,"\n";
			my $output = $filePath;
			   $output = $filePath.'.text' if $DEBUG;
			open FILE, '>:utf8', $output  or die "'$output' $!";
			$htm = "\x{feff}".$htm unless $htm =~ m/^\x{feff}/;  #BOM
			print FILE $htm;
			close FILE;
			utime $mtime,$mtime,$output;
		}
	}
}
